/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.modapi;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.dto.modpack.ProveedorMods;
import com.asbestosstar.crashdetector.dto.modpack.tlmods.ProveedorModsTlmods;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.modapi.PanelAPIBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CDModsEstiloTL
extends PanelAPIBase {
    private ConfigColor colorFondo = ConfigColor.de("cdmods.color.fondo", Config.convertirAColor("#232a34"));
    private ConfigColor colorTexto = ConfigColor.de("cdmods.color.texto", Config.convertirAColor("#e6edf3"));
    private ConfigColor colorBoton = ConfigColor.de("cdmods.color.boton", Config.convertirAColor("#2ecc71"));
    private ConfigColor colorCajaTexto = ConfigColor.de("cdmods.color.cajaTexto", Config.convertirAColor("#1b222b"));
    public static String ID = "cdmodsestilotl";

    @Override
    protected void inicializarColores() {
    }

    @Override
    protected ProveedorMods crearProveedorMods() {
        return new ProveedorModsTlmods();
    }

    @Override
    protected Color obtenerColorFondo() {
        return this.colorFondo.obtener();
    }

    @Override
    protected Color obtenerColorTexto() {
        return this.colorTexto.obtener();
    }

    @Override
    protected Color obtenerColorBoton() {
        return this.colorBoton.obtener();
    }

    @Override
    protected Color obtenerColorCajaTexto() {
        return this.colorCajaTexto.obtener();
    }

    @Override
    protected void aplicarEstiloVolver(JButton boton) {
        if (!CrashDetectorGUI.esMac()) {
            boton.setForeground(this.colorTexto.obtener());
            boton.setBackground(this.colorBoton.obtener());
            boton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        }
    }

    @Override
    protected void aplicarEstiloBusqueda(JTextField campo) {
        if (!CrashDetectorGUI.esMac()) {
            campo.setBackground(this.colorCajaTexto.obtener());
            campo.setForeground(this.colorTexto.obtener());
        }
    }

    @Override
    protected void aplicarEstiloTarjetaMod(JPanel tarjeta) {
        tarjeta.setBackground(Color.decode("#2d2d2d"));
    }

    @Override
    protected void aplicarEstiloSidebar(JPanel sidebar) {
        sidebar.setBackground(this.colorFondo.obtener().darker());
    }

    @Override
    protected void aplicarEstiloSidebarItem(JPanel item, JCheckBox checkBox, JLabel etiqueta) {
        item.setBackground(this.colorFondo.obtener().darker());
        checkBox.setBackground(this.colorFondo.obtener().darker());
        checkBox.setForeground(this.colorTexto.obtener());
        etiqueta.setForeground(this.colorTexto.obtener());
    }

    @Override
    protected void aplicarEstiloPrincipal(JPanel panel) {
        panel.setBackground(this.colorFondo.obtener());
    }

    @Override
    public String id() {
        ID = "cdmodsestilotl";
        return "cdmodsestilotl";
    }

    @Override
    public void recargarApariencia() {
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> artics = new ArrayList<ElementoConfig>();
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        artics.add(this.colorBoton);
        artics.add(this.colorFondo);
        artics.add(this.colorTexto);
        artics.add(this.colorCajaTexto);
        return artics;
    }
}

