/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.modapi;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.dto.modpack.InternetMod;
import com.asbestosstar.crashdetector.dto.modpack.PaginaMods;
import com.asbestosstar.crashdetector.dto.modpack.ProveedorMods;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.principal.PrincipalGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class PanelAPIBase
extends JPanel
implements CrashDetectorGUI {
    public static Map<String, Supplier<PanelAPIBase>> GUIS = new HashMap<String, Supplier<PanelAPIBase>>();
    protected JTextField searchBar;
    protected JPanel modListPanel;
    protected JPanel sidebarPanel;
    protected List<String> archivosJAR;
    protected ProveedorMods proveedorActual;

    protected abstract void inicializarColores();

    protected abstract void aplicarEstiloVolver(JButton var1);

    protected abstract void aplicarEstiloBusqueda(JTextField var1);

    protected abstract void aplicarEstiloTarjetaMod(JPanel var1);

    protected abstract void aplicarEstiloSidebar(JPanel var1);

    protected abstract void aplicarEstiloSidebarItem(JPanel var1, JCheckBox var2, JLabel var3);

    protected abstract void aplicarEstiloPrincipal(JPanel var1);

    protected abstract ProveedorMods crearProveedorMods();

    protected abstract Color obtenerColorFondo();

    protected abstract Color obtenerColorTexto();

    protected abstract Color obtenerColorBoton();

    protected abstract Color obtenerColorCajaTexto();

    public PanelAPIBase() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void init() {
        this.inicializarColores();
        this.setBackground(this.obtenerColorFondo());
        JButton botonVolver = new JButton("\u2190 Volver");
        this.aplicarEstiloVolver(botonVolver);
        botonVolver.setFocusPainted(false);
        botonVolver.addActionListener(e -> {
            if (this.getParent() instanceof PrincipalGUI) {
                ((PrincipalGUI)this.getParent()).volver();
            }
        });
        JPanel topPanel = this.crearPanelBusqueda();
        JPanel norte = new JPanel(new BorderLayout());
        norte.setBackground(this.obtenerColorFondo());
        norte.add((Component)botonVolver, "West");
        norte.add((Component)topPanel, "Center");
        this.add((Component)norte, "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.aplicarEstiloPrincipal(mainPanel);
        this.sidebarPanel = this.crearSidebar();
        JScrollPane sidebarScroll = new JScrollPane(this.sidebarPanel, 20, 31);
        sidebarScroll.setBorder(null);
        int sidebarW = 140;
        sidebarScroll.setPreferredSize(new Dimension(sidebarW, 0));
        sidebarScroll.setMinimumSize(new Dimension(sidebarW, 0));
        sidebarScroll.getVerticalScrollBar().setUnitIncrement(14);
        sidebarScroll.getViewport().setOpaque(true);
        sidebarScroll.getViewport().setBackground(this.obtenerColorFondo().darker());
        mainPanel.add((Component)sidebarScroll, "West");
        this.modListPanel = new JPanel();
        this.modListPanel.setLayout(new BoxLayout(this.modListPanel, 1));
        JScrollPane scrollPane = new JScrollPane(this.modListPanel, 20, 31);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        mainPanel.add((Component)scrollPane, "Center");
        this.add((Component)mainPanel, "Center");
        this.cargarArchivosJAR();
        this.proveedorActual = this.crearProveedorMods();
        this.buscarMods("");
    }

    private JPanel crearPanelBusqueda() {
        JPanel panel = new JPanel(new FlowLayout(0, 10, 5));
        panel.setBackground(this.obtenerColorFondo());
        JLabel label = new JLabel("Buscar mods:");
        label.setForeground(this.obtenerColorTexto());
        panel.add(label);
        this.searchBar = new JTextField(20);
        this.aplicarEstiloBusqueda(this.searchBar);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelAPIBase.this.buscarMods(PanelAPIBase.this.searchBar.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelAPIBase.this.buscarMods(PanelAPIBase.this.searchBar.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelAPIBase.this.buscarMods(PanelAPIBase.this.searchBar.getText());
            }
        });
        panel.add(this.searchBar);
        return panel;
    }

    private void buscarMods(String termino) {
        this.modListPanel.removeAll();
        CompletableFuture.runAsync(() -> {
            try {
                PaginaMods pagina = this.proveedorActual.buscarMods(MonitorDePID.idioma.codigo().toUpperCase(), 0, termino);
                HashSet urlsVistas = new HashSet();
                SwingUtilities.invokeLater(() -> {
                    for (InternetMod internetMod : pagina.obtenerListaMods()) {
                        String enlace = internetMod.obtenerEnlaceProyecto();
                        if (enlace == null || enlace.isEmpty() || !enlace.toLowerCase().contains("curseforge.com") || !urlsVistas.add(enlace)) continue;
                        this.modListPanel.add(this.crearTarjetaMod(internetMod));
                    }
                    this.modListPanel.revalidate();
                    this.modListPanel.repaint();
                });
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(() -> {
                    this.modListPanel.add(new JLabel("Error al cargar mods."));
                    this.modListPanel.revalidate();
                });
            }
        });
    }

    protected JPanel crearTarjetaMod(InternetMod mod) {
        int anchoMaximo = 650;
        int altoTarjeta = 96;
        JPanel tarjeta = new JPanel(new BorderLayout(10, 8));
        tarjeta.setMaximumSize(new Dimension(anchoMaximo, altoTarjeta));
        tarjeta.setPreferredSize(new Dimension(anchoMaximo, altoTarjeta));
        tarjeta.setMinimumSize(new Dimension(anchoMaximo, altoTarjeta));
        tarjeta.setAlignmentX(0.5f);
        tarjeta.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        this.aplicarEstiloTarjetaMod(tarjeta);
        JPanel panelIzq = new JPanel();
        panelIzq.setLayout(new BoxLayout(panelIzq, 1));
        panelIzq.setOpaque(false);
        JLabel icono = this.crearIconoMod(mod);
        icono.setAlignmentX(0.5f);
        JButton instalar = new JButton("Instalar");
        instalar.setAlignmentX(0.5f);
        instalar.setMaximumSize(new Dimension(72, 22));
        instalar.setPreferredSize(new Dimension(72, 22));
        instalar.setBackground(this.obtenerColorBoton());
        instalar.setForeground(Color.WHITE);
        instalar.addActionListener(e -> this.instalarMod(mod));
        panelIzq.add(icono);
        panelIzq.add(Box.createRigidArea(new Dimension(0, 6)));
        panelIzq.add(instalar);
        JPanel centro = new JPanel();
        centro.setLayout(new BoxLayout(centro, 1));
        centro.setOpaque(false);
        JLabel nombre = new JLabel(mod.obtenerNombre());
        nombre.setForeground(this.obtenerColorTexto());
        nombre.setFont(nombre.getFont().deriveFont(15.0f));
        String desc = this.limitarTexto(mod.obtenerDescripcionCorta(), 420);
        JLabel descripcion = new JLabel("<html><div style='width:460px;'>" + desc + "</div></html>");
        descripcion.setForeground(Color.LIGHT_GRAY);
        centro.add(nombre);
        centro.add(Box.createRigidArea(new Dimension(0, 4)));
        centro.add(descripcion);
        tarjeta.add((Component)panelIzq, "West");
        tarjeta.add((Component)centro, "Center");
        return tarjeta;
    }

    private JLabel crearIconoMod(InternetMod mod) {
        int size = 48;
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(size, size));
        label.setMinimumSize(new Dimension(size, size));
        label.setMaximumSize(new Dimension(size, size));
        label.setOpaque(true);
        label.setBackground(new Color(60, 60, 60));
        String url = mod.urlIcon();
        if (url == null || url.isEmpty()) {
            label.setIcon(this.iconoPlaceholder(size));
            return label;
        }
        CompletableFuture.runAsync(() -> {
            try {
                URL u = new URL(url);
                BufferedImage img = ImageIO.read(u);
                if (img != null) {
                    Image escalada = img.getScaledInstance(size, size, 4);
                    SwingUtilities.invokeLater(() -> label.setIcon(new ImageIcon(escalada)));
                } else {
                    SwingUtilities.invokeLater(() -> label.setIcon(this.iconoPlaceholder(size)));
                }
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> label.setIcon(this.iconoPlaceholder(size)));
            }
        });
        return label;
    }

    private Icon iconoPlaceholder(int size) {
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(new Color(80, 80, 80));
        g.fillRect(0, 0, size, size);
        g.setColor(new Color(120, 120, 120));
        g.drawRect(0, 0, size - 1, size - 1);
        g.dispose();
        return new ImageIcon(img);
    }

    private String limitarTexto(String texto, int maxCaracteres) {
        if (texto == null) {
            return "";
        }
        if ((texto = texto.replace("\n", " ").trim()).length() <= maxCaracteres) {
            return texto;
        }
        return texto.substring(0, maxCaracteres).trim() + "...";
    }

    private void instalarMod(InternetMod mod) {
        try {
            if (!Desktop.isDesktopSupported()) {
                return;
            }
            Desktop desktop = Desktop.getDesktop();
            String enlace = mod.obtenerEnlaceProyecto();
            if (enlace == null || enlace.isEmpty()) {
                return;
            }
            desktop.browse(new URI(enlace));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JPanel crearSidebar() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(10, 6, 10, 6));
        panel.setAlignmentX(0.0f);
        panel.setOpaque(true);
        this.aplicarEstiloSidebar(panel);
        this.sidebarPanel = panel;
        this.actualizarSidebar();
        return panel;
    }

    private void cargarArchivosJAR() {
        Path modsDir = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("mods");
        this.archivosJAR = new ArrayList<String>();
        if (!Files.exists(modsDir, new LinkOption[0])) {
            return;
        }
        try {
            this.archivosJAR = Files.list(modsDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).filter(f -> f.endsWith(".jar") || f.endsWith(".jar.disabled") || f.endsWith(".nil") || f.endsWith(".nil.jar") || f.endsWith(".disabled") || f.endsWith(".deactivation")).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void actualizarSidebar() {
        if (this.sidebarPanel == null) {
            return;
        }
        this.sidebarPanel.removeAll();
        JLabel titulo = new JLabel("Mods Instalados");
        titulo.setForeground(this.obtenerColorTexto());
        titulo.setFont(new Font("Segoe UI", 1, 14));
        titulo.setAlignmentX(0.0f);
        titulo.setHorizontalAlignment(2);
        this.sidebarPanel.add(titulo);
        this.sidebarPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.cargarArchivosJAR();
        Path modsDir = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("mods");
        boolean usaCurseForge = modsDir.toString().contains("curseforge");
        for (String archivo : this.archivosJAR) {
            String nombreBase = this.obtenerNombreBase(archivo);
            boolean activo = !archivo.endsWith(".disabled") && !archivo.endsWith(".nil") && !archivo.endsWith(".nil.jar") && !archivo.endsWith(".deactivation");
            JPanel fila = new JPanel(new BorderLayout(6, 0));
            fila.setOpaque(false);
            fila.setAlignmentX(0.0f);
            fila.setMaximumSize(new Dimension(Integer.MAX_VALUE, 26));
            fila.setPreferredSize(new Dimension(10, 26));
            JLabel nombre = this.crearEtiquetaDeslizante(nombreBase);
            nombre.setHorizontalAlignment(2);
            nombre.setAlignmentX(0.0f);
            nombre.setPreferredSize(new Dimension(86, 20));
            nombre.setMinimumSize(new Dimension(86, 20));
            SwitchVerde sw = new SwitchVerde();
            sw.setSelected(activo);
            sw.addActionListener(e -> {
                try {
                    Path destino;
                    Path origen = modsDir.resolve(archivo);
                    if (sw.isSelected()) {
                        String nombreReactivado = archivo.replace(".jar.disabled", ".jar").replace(".jar.deactivation", ".jar").replace(".disabled", "").replace(".deactivation", "").replace(".nil.jar", ".jar").replace(".nil", "");
                        destino = modsDir.resolve(nombreReactivado);
                    } else {
                        String ext = usaCurseForge ? ".jar.disabled" : ".deactivation";
                        destino = archivo.endsWith(".jar") ? modsDir.resolve(archivo + ext) : modsDir.resolve(archivo + ".jar" + ext);
                    }
                    Files.move(origen, destino, StandardCopyOption.REPLACE_EXISTING);
                    this.actualizarSidebar();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    sw.setSelected(!sw.isSelected());
                }
            });
            this.aplicarEstiloSidebarItem(fila, sw, nombre);
            fila.add((Component)nombre, "Center");
            fila.add((Component)sw, "East");
            this.sidebarPanel.add(fila);
            this.sidebarPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        }
        this.sidebarPanel.revalidate();
        this.sidebarPanel.repaint();
    }

    private JLabel crearEtiquetaDeslizante(final String texto) {
        int maxChars = 16;
        final String base = this.acortarTexto(texto, 16);
        final JLabel label = new JLabel(base);
        label.setToolTipText(texto);
        final Timer[] timer = new Timer[1];
        final int[] offset = new int[]{0};
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (texto.length() <= 16) {
                    return;
                }
                offset[0] = 0;
                timer[0] = new Timer(110, ev -> {
                    offset2[0] = offset[0] + 1;
                    if (offset[0] >= texto.length()) {
                        offset2[0] = 0;
                    }
                    String desplazado = texto.substring(offset[0]) + "   " + texto.substring(0, offset[0]);
                    label.setText(PanelAPIBase.this.acortarTexto(desplazado, 16));
                });
                timer[0].start();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (timer[0] != null) {
                    timer[0].stop();
                }
                label.setText(base);
            }
        });
        return label;
    }

    private String acortarTexto(String texto, int max) {
        if (texto == null) {
            return "";
        }
        if (texto.length() <= max) {
            return texto;
        }
        return texto.substring(0, Math.max(0, max - 3)) + "...";
    }

    public void recargarSidebar() {
        this.actualizarSidebar();
    }

    private String obtenerNombreBase(String archivo) {
        if (archivo.endsWith(".jar.disabled")) {
            return archivo.substring(0, archivo.length() - ".jar.disabled".length());
        }
        if (archivo.endsWith(".nil.jar")) {
            return archivo.substring(0, archivo.length() - ".nil.jar".length());
        }
        if (archivo.endsWith(".nil")) {
            return archivo.substring(0, archivo.length() - ".nil".length());
        }
        if (archivo.endsWith(".disabled")) {
            return archivo.substring(0, archivo.length() - ".disabled".length());
        }
        if (archivo.endsWith(".deactivation")) {
            return archivo.substring(0, archivo.length() - ".deactivation".length());
        }
        if (archivo.endsWith(".jar")) {
            return archivo.substring(0, archivo.length() - ".jar".length());
        }
        return archivo;
    }

    @Override
    public TipoGUI<?> tipo() {
        return TipoGUI.MOD_API_PANEL;
    }

    public static class SwitchVerde
    extends JCheckBox {
        private static final int W = 34;
        private static final int H = 16;

        public SwitchVerde() {
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setPreferredSize(new Dimension(34, 16));
            this.setMinimumSize(new Dimension(34, 16));
            this.setMaximumSize(new Dimension(34, 16));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int x = 0;
            int y = (this.getHeight() - 16) / 2;
            Color fondo = this.isSelected() ? new Color(110, 210, 80) : new Color(90, 90, 90);
            g2.setColor(fondo);
            g2.fillRect(x, y, 34, 16);
            g2.setColor(new Color(0, 0, 0, 100));
            g2.drawRect(x, y, 33, 15);
            int knobSize = 12;
            int knobX = this.isSelected() ? x + 34 - knobSize - 2 : x + 2;
            g2.setColor(Color.WHITE);
            g2.fillRect(knobX, y + 2, knobSize, knobSize);
            g2.setColor(new Color(0, 0, 0, 80));
            g2.drawRect(knobX, y + 2, knobSize - 1, knobSize - 1);
            g2.dispose();
        }
    }
}

