/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.modsbuenas;

import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.idioma.cumplimiento.ActaDeProteccionDelIdiomaCulturalDePyongyang;
import com.asbestosstar.crashdetector.json.Json;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public abstract class ModsBuenasGUI
extends JDialog
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<ModsBuenasGUI>> GUIS = new HashMap<String, Supplier<ModsBuenasGUI>>();
    protected final Path archivo = Statics.carpeta.resolve("mods_animados.json");
    protected final List<EntradaMod> mods = new ArrayList<EntradaMod>();

    @Override
    public TipoGUI tipo() {
        return TipoGUI.MODS_BUENAS;
    }

    protected void cargarDatos() {
        this.mods.clear();
        if (!Files.exists(this.archivo, new LinkOption[0])) {
            return;
        }
        try {
            String json = new String(Files.readAllBytes(this.archivo), StandardCharsets.UTF_8);
            if (json == null || json.trim().isEmpty()) {
                return;
            }
            Json.Nodo raiz = Json.leer(json);
            if (raiz == null || !raiz.esArreglo()) {
                return;
            }
            for (int i = 0; i < raiz.tamano(); ++i) {
                Json.Nodo razon;
                Json.Nodo a;
                Json.Nodo r;
                Json.Nodo n = raiz.en(i);
                if (n == null || !n.esObjeto()) continue;
                EntradaMod e = new EntradaMod();
                Json.Nodo m = n.obtener("modid");
                if (m != null && !m.esObjeto() && !m.esArreglo()) {
                    e.modid = m.comoCadena();
                }
                if ((r = n.obtener("ruta")) != null && !r.esObjeto() && !r.esArreglo()) {
                    e.ruta = r.comoCadena();
                }
                if ((a = n.obtener("abrir_cd_si_coincide")) != null) {
                    try {
                        e.abrirCD = a.comoBooleano();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((razon = n.obtener("razon")) != null && razon.esObjeto()) {
                    for (String lang : razon.claves()) {
                        String v;
                        Json.Nodo txt = razon.obtener(lang);
                        if (txt == null || txt.esObjeto() || txt.esArreglo() || (v = txt.comoCadena()) == null || (v = v.trim()).isEmpty()) continue;
                        e.razones.put(lang, v);
                    }
                }
                if (!e.esValida()) continue;
                this.mods.add(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void guardarDatos() {
        try {
            Json.Nodo raiz = Json.leer("[]");
            for (EntradaMod e : this.mods) {
                if (e == null || !e.esValida()) continue;
                Json.Nodo obj = Json.crearObjeto();
                if (e.modid != null && !e.modid.trim().isEmpty()) {
                    obj.obtener("modid").poner(e.modid.trim());
                }
                if (e.ruta != null && !e.ruta.trim().isEmpty()) {
                    obj.obtener("ruta").poner(e.ruta.trim());
                }
                if (e.abrirCD) {
                    obj.obtener("abrir_cd_si_coincide").poner(true);
                }
                if (e.razones != null && !e.razones.isEmpty()) {
                    Json.Nodo r = Json.crearObjeto();
                    for (Map.Entry<String, String> en : e.razones.entrySet()) {
                        String v;
                        if (en.getKey() == null || (v = en.getValue()) == null || (v = v.trim()).isEmpty()) continue;
                        r.obtener(en.getKey()).poner(v);
                    }
                    obj.obtener("razon").poner(r);
                }
                raiz.agregar(obj);
            }
            Files.write(this.archivo, raiz.aBytesUtf8(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String obtenerCodigoIdioma(String nombreIdioma) {
        if (nombreIdioma == null) {
            return "es";
        }
        switch (nombreIdioma) {
            case "Espa\u00f1ol": {
                return "es";
            }
            case "English": {
                return "en";
            }
            case "\u0627\u0644\u0639\u0631\u0628\u064a\u0629": {
                return "ar";
            }
            case "Portugu\u00eas": {
                return "pt";
            }
            case "\u0641\u0627\u0631\u0633\u06cc": {
                return "fa";
            }
            case "\u0420\u0443\u0441\u0441\u043a\u0438\u0439": {
                return "ru";
            }
            case "\u7b80\u4f53\u4e2d\u6587": {
                return "zh";
            }
            case "Esperanto": {
                return "eo";
            }
            case "\u65e5\u672c\u8a9e": {
                return "ja";
            }
            case "\ud55c\uad6d\uc5b4": {
                return "ko";
            }
        }
        return "es";
    }

    protected String resumenRazones(Map<String, String> razones) {
        if (razones == null || razones.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean primero = true;
        String langActual = MonitorDePID.idioma.codigo();
        String langRespaldo = null;
        try {
            langRespaldo = Idioma.idioma_respaldo.obtener();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<String> orden = new ArrayList<String>();
        if (langActual != null && !langActual.isEmpty()) {
            orden.add(langActual);
        }
        if (langRespaldo != null && !langRespaldo.isEmpty() && !orden.contains(langRespaldo)) {
            orden.add(langRespaldo);
        }
        if (!orden.contains("es")) {
            orden.add("es");
        }
        for (String k : razones.keySet()) {
            if (k == null || orden.contains(k)) continue;
            orden.add(k);
        }
        for (String lang : orden) {
            String txt = razones.get(lang);
            if (txt == null || (txt = txt.trim()).isEmpty()) continue;
            if (!primero) {
                sb.append(" | ");
            }
            sb.append(lang).append(": ").append(txt);
            primero = false;
        }
        return sb.toString();
    }

    protected void editarRazonesMultilingue(String titulo, Map<String, String> razonesReferencia, Color fondo, Color texto, Color caja, Color borde, Color botonFondo) {
        if (razonesReferencia == null) {
            return;
        }
        JDialog dialogo = new JDialog(this, titulo, true);
        dialogo.setLayout(new BorderLayout(10, 10));
        dialogo.setSize(680, 460);
        JPanel panelCampos = new JPanel(new GridBagLayout());
        panelCampos.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelCampos.setOpaque(true);
        panelCampos.setBackground(fondo);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.fill = 2;
        LinkedHashMap<String, String> mapaIdiomas = this.mapaParaComboBoxIdiomas();
        HashMap<String, JTextField> camposTexto = new HashMap<String, JTextField>();
        int fila = 0;
        for (Map.Entry<String, String> entry : mapaIdiomas.entrySet()) {
            String nombreVisible = entry.getKey();
            String rutaBandera = entry.getValue();
            String codigo = ModsBuenasGUI.obtenerCodigoIdioma(nombreVisible);
            JLabel etiqueta = new JLabel(codigo);
            etiqueta.setFont(new Font("Segoe UI", 1, 12));
            etiqueta.setForeground(texto);
            etiqueta.setOpaque(false);
            try {
                File f = Statics.carpeta.resolve(rutaBandera).toFile();
                if (f.exists()) {
                    ImageIcon icon = new ImageIcon(f.getAbsolutePath());
                    Image img = icon.getImage().getScaledInstance(18, 12, 4);
                    etiqueta.setIcon(new ImageIcon(img));
                    etiqueta.setIconTextGap(8);
                }
            }
            catch (Exception f) {
                // empty catch block
            }
            gbc.gridx = 0;
            gbc.gridy = fila++;
            gbc.weightx = 0.2;
            panelCampos.add((Component)etiqueta, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.8;
            JTextField campo = new JTextField(40);
            campo.setText(razonesReferencia.getOrDefault(codigo, ""));
            campo.setBackground(caja);
            campo.setForeground(texto);
            campo.setCaretColor(texto);
            campo.setBorder(BorderFactory.createLineBorder(borde, 1));
            camposTexto.put(codigo, campo);
            panelCampos.add((Component)campo, gbc);
        }
        JPanel panelBotones = new JPanel(new FlowLayout(2));
        panelBotones.setOpaque(true);
        panelBotones.setBackground(fondo);
        JButton botonAceptar = new JButton(MonitorDePID.idioma.aceptar());
        JButton botonCancelar = new JButton(MonitorDePID.idioma.cancelar());
        this.estilizarBotonSimple(botonAceptar, botonFondo, Color.WHITE, borde);
        this.estilizarBotonSimple(botonCancelar, botonFondo, Color.WHITE, borde);
        panelBotones.add(botonAceptar);
        panelBotones.add(botonCancelar);
        botonAceptar.addActionListener(e -> {
            HashMap<String, String> nuevas = new HashMap<String, String>();
            for (Map.Entry c : camposTexto.entrySet()) {
                String v = ((JTextField)c.getValue()).getText();
                if (v != null) {
                    v = v.trim();
                }
                if (v == null || v.isEmpty()) continue;
                nuevas.put((String)c.getKey(), v);
            }
            String textoCoreano = (String)nuevas.get("ko");
            if (textoCoreano != null && !textoCoreano.isEmpty()) {
                ActaDeProteccionDelIdiomaCulturalDePyongyang.contieneJergaSur(textoCoreano);
            }
            razonesReferencia.clear();
            razonesReferencia.putAll(nuevas);
            dialogo.dispose();
        });
        botonCancelar.addActionListener(e -> dialogo.dispose());
        dialogo.add((Component)new JScrollPane(panelCampos), "Center");
        dialogo.add((Component)panelBotones, "South");
        dialogo.setLocationRelativeTo(this);
        dialogo.setVisible(true);
    }

    protected void estilizarBotonSimple(JButton btn, Color fondo, Color texto, Color borde) {
        if (btn == null) {
            return;
        }
        btn.setBackground(fondo);
        btn.setForeground(texto);
        btn.setFocusPainted(false);
        btn.setFont(new Font("Segoe UI", 1, 12));
        btn.setBorder(BorderFactory.createLineBorder(borde, 1));
    }

    protected void forzarFondoEnPanel(JComponent c, Color fondo) {
        if (c == null) {
            return;
        }
        c.setOpaque(true);
        c.setBackground(fondo);
    }

    protected static class EntradaMod {
        public String modid;
        public String ruta;
        public boolean abrirCD;
        public Map<String, String> razones = new HashMap<String, String>();

        protected EntradaMod() {
        }

        public boolean esValida() {
            return this.modid != null && !this.modid.trim().isEmpty() || this.ruta != null && !this.ruta.trim().isEmpty();
        }
    }
}

