/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.modsmalas;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.modsmalas.GUIModsMalas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class GUIModsMalasRimaEvenstar
extends GUIModsMalas {
    private static final long serialVersionUID = 1L;
    public static final String ID = "rima_evenstar";
    public static File imagen = Statics.carpeta.resolve("imagenes/rima_evenstar.png").toFile();
    private JTable tabla;
    private DefaultTableModel modelo;
    private JButton botonAgregar;
    private JButton botonQuitar;
    private JButton botonEditarRazones;
    private JButton botonGuardar;
    private JButton botonCancelar;
    private ConfigColor colorFondo = ConfigColor.de("tema.rima_evenstar.fondo", new Color(46, 32, 64));
    private ConfigColor colorTexto = ConfigColor.de("tema.rima_evenstar.texto", new Color(240, 230, 255));
    private ConfigColor colorBoton = ConfigColor.de("tema.rima_evenstar.boton", new Color(168, 90, 200));
    private ConfigColor colorTabla = ConfigColor.de("tema.rima_evenstar.tabla", new Color(33, 23, 48));
    private ConfigColor colorBorde = ConfigColor.de("tema.rima_evenstar.borde", new Color(110, 84, 140));

    @Override
    public void init() {
        this.setTitle(MonitorDePID.idioma.modsNoRecomendados());
        this.setSize(900, 650);
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.cargarDatos();
        JPanel panelIzquierdo = new JPanel(new BorderLayout());
        panelIzquierdo.setPreferredSize(new Dimension(220, 0));
        panelIzquierdo.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.forzarFondoEnPanel(panelIzquierdo, this.colorFondo.obtener());
        JLabel imagenLabel = new JLabel();
        imagenLabel.setHorizontalAlignment(0);
        imagenLabel.setVerticalAlignment(1);
        imagenLabel.setOpaque(true);
        imagenLabel.setBackground(this.colorFondo.obtener());
        this.cargarImagenEnLabel(imagenLabel);
        JLabel aviso = new JLabel("<html><div style='width:160px; text-align:center;'>" + MonitorDePID.idioma.modsNoRecomendadosAviso() + "</div></html>");
        aviso.setForeground(this.colorTexto.obtener());
        aviso.setFont(new Font("Segoe UI", 2, 11));
        aviso.setHorizontalAlignment(0);
        panelIzquierdo.add((Component)imagenLabel, "North");
        panelIzquierdo.add((Component)aviso, "South");
        this.add((Component)panelIzquierdo, "West");
        JPanel panelDerecho = new JPanel(new BorderLayout(6, 6));
        panelDerecho.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.forzarFondoEnPanel(panelDerecho, this.colorFondo.obtener());
        JLabel titulo = new JLabel(MonitorDePID.idioma.modsNoRecomendados());
        titulo.setFont(new Font("Segoe UI", 1, 18));
        titulo.setForeground(this.colorTexto.obtener());
        JPanel panelTitulo = new JPanel(new FlowLayout(0, 0, 0));
        this.forzarFondoEnPanel(panelTitulo, this.colorFondo.obtener());
        panelTitulo.add(titulo);
        panelDerecho.add((Component)panelTitulo, "North");
        this.modelo = new DefaultTableModel(new Object[]{MonitorDePID.idioma.modId(), MonitorDePID.idioma.rutaMod(), MonitorDePID.idioma.anularNormal(), MonitorDePID.idioma.razones()}, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        };
        this.tabla = new JTable(this.modelo);
        this.tabla.setRowHeight(24);
        this.tabla.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(this.tabla);
        panelDerecho.add((Component)scroll, "Center");
        JPanel panelBotones = new JPanel(new FlowLayout(2, 6, 0));
        this.forzarFondoEnPanel(panelBotones, this.colorFondo.obtener());
        this.botonAgregar = new JButton(MonitorDePID.idioma.agregarMod());
        this.botonQuitar = new JButton(MonitorDePID.idioma.quitarMod());
        this.botonEditarRazones = new JButton(MonitorDePID.idioma.editarRazones());
        this.botonGuardar = new JButton(MonitorDePID.idioma.guardarCambios());
        this.botonCancelar = new JButton(MonitorDePID.idioma.cancelar());
        panelBotones.add(this.botonAgregar);
        panelBotones.add(this.botonQuitar);
        panelBotones.add(this.botonEditarRazones);
        panelBotones.add(this.botonGuardar);
        panelBotones.add(this.botonCancelar);
        panelDerecho.add((Component)panelBotones, "South");
        this.add((Component)panelDerecho, "Center");
        this.botonAgregar.addActionListener(e -> this.agregarMod());
        this.botonQuitar.addActionListener(e -> this.quitarMod());
        this.botonEditarRazones.addActionListener(e -> this.editarRazonesMultilingueSeleccion());
        this.botonGuardar.addActionListener(e -> {
            this.guardarDatos();
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.cambiosGuardadosExitosamente(), MonitorDePID.idioma.informacion(), 1);
        });
        this.botonCancelar.addActionListener(e -> this.dispose());
        this.recargarTabla();
        this.recargarApariencia();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void cargarImagenEnLabel(JLabel imagenLabel) {
        try {
            if (imagen != null && imagen.exists()) {
                ImageIcon icon = new ImageIcon(imagen.getAbsolutePath());
                Image img = icon.getImage();
                int newWidth = 200;
                int newHeight = (int)((double)img.getHeight(null) / (double)img.getWidth(null) * (double)newWidth);
                img = img.getScaledInstance(newWidth, newHeight, 4);
                imagenLabel.setIcon(new ImageIcon(img));
            } else {
                imagenLabel.setText(MonitorDePID.idioma.imagenNoEncontrada());
                imagenLabel.setForeground(this.colorTexto.obtener());
            }
        }
        catch (Exception e) {
            imagenLabel.setText(MonitorDePID.idioma.errorCargandoImagen());
            imagenLabel.setForeground(this.colorTexto.obtener());
        }
    }

    private void agregarMod() {
        String ruta;
        JTextField campoModid = new JTextField();
        JTextField campoRuta = new JTextField();
        JCheckBox checkOverride = new JCheckBox(MonitorDePID.idioma.anularNormalDescripcion());
        checkOverride.setOpaque(false);
        checkOverride.setFont(new Font("Segoe UI", 0, 12));
        Object[] msg = new Object[]{MonitorDePID.idioma.modId(), campoModid, MonitorDePID.idioma.rutaMod(), campoRuta, " ", checkOverride};
        int res = JOptionPane.showConfirmDialog(this, msg, MonitorDePID.idioma.agregarMod(), 2);
        if (res != 0) {
            return;
        }
        String modid = campoModid.getText() != null ? campoModid.getText().trim() : "";
        String string = ruta = campoRuta.getText() != null ? campoRuta.getText().trim() : "";
        if (modid.isEmpty() && ruta.isEmpty()) {
            JOptionPane.showMessageDialog(this, MonitorDePID.idioma.errorDebeIndicarMod(), MonitorDePID.idioma.error(), 0);
            return;
        }
        GUIModsMalas.EntradaMod e = new GUIModsMalas.EntradaMod();
        e.modid = modid.isEmpty() ? null : modid;
        e.ruta = ruta.isEmpty() ? null : ruta;
        e.abrirCD = checkOverride.isSelected();
        this.mods.add(e);
        this.recargarTabla();
    }

    private void quitarMod() {
        int fila = this.tabla.getSelectedRow();
        if (fila < 0) {
            return;
        }
        this.mods.remove(fila);
        this.recargarTabla();
    }

    private void editarRazonesMultilingueSeleccion() {
        int fila = this.tabla.getSelectedRow();
        if (fila < 0) {
            return;
        }
        GUIModsMalas.EntradaMod e = (GUIModsMalas.EntradaMod)this.mods.get(fila);
        if (e == null) {
            return;
        }
        String ref = e.modid != null && !e.modid.trim().isEmpty() ? e.modid : (e.ruta != null ? e.ruta : "");
        String titulo = MonitorDePID.idioma.editarRazonesPara(ref);
        this.editarRazonesMultilingue(titulo, e.razones, this.colorFondo.obtener(), this.colorTexto.obtener(), this.colorTabla.obtener(), this.colorBorde.obtener(), this.colorBoton.obtener());
        this.recargarTabla();
    }

    private void recargarTabla() {
        boolean hay;
        this.modelo.setRowCount(0);
        for (GUIModsMalas.EntradaMod e : this.mods) {
            String modid = e.modid == null ? "" : e.modid;
            String ruta = e.ruta == null ? "" : e.ruta;
            String overrideTxt = e.abrirCD ? "true" : "false";
            String razonesTxt = this.resumenRazones(e.razones);
            this.modelo.addRow(new Object[]{modid, ruta, overrideTxt, razonesTxt});
        }
        boolean bl = hay = this.modelo.getRowCount() > 0;
        if (this.botonQuitar != null) {
            this.botonQuitar.setEnabled(hay);
        }
        if (this.botonEditarRazones != null) {
            this.botonEditarRazones.setEnabled(hay);
        }
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void recargarApariencia() {
        JButton[] botones;
        this.getContentPane().setBackground(this.colorFondo.obtener());
        if (this.tabla != null) {
            this.tabla.setBackground(this.colorTabla.obtener());
            this.tabla.setForeground(this.colorTexto.obtener());
            this.tabla.setGridColor(this.colorBorde.obtener());
            this.tabla.setSelectionBackground(this.colorBoton.obtener());
            this.tabla.setSelectionForeground(Color.WHITE);
            this.tabla.setFont(new Font("Segoe UI", 0, 12));
        }
        for (JButton b : botones = new JButton[]{this.botonAgregar, this.botonQuitar, this.botonEditarRazones, this.botonGuardar, this.botonCancelar}) {
            this.estilizarBotonSimple(b, this.colorBoton.obtener(), Color.WHITE, this.colorBorde.obtener());
            if (b == null) continue;
            b.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 12));
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> ret = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        ret.add(this.colorFondo);
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        ret.add(this.colorTexto);
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        ret.add(this.colorBoton);
        this.colorTabla.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBordeListas());
        ret.add(this.colorTabla);
        this.colorBorde.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        ret.add(this.colorBorde);
        return ret;
    }
}

