/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.ComboIdiomasConIcono;
import com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador.NoRegistroLanzadorGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

@Deprecated
public class NoRegistroDeLauncherVShojo
extends NoRegistroLanzadorGUI {
    private static final long serialVersionUID = 1L;
    public static String ID = "vshojo";
    private ConfigColor colorFondoVentana = ConfigColor.de("tema.vshojo.no_registro.color.fondo.ventana", Config.convertirAColor(Config.obtenerInstancia().obtenerColorFondo()));
    private ConfigColor colorTexto = ConfigColor.de("tema.vshojo.no_registro.color.texto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorTexto()));
    private ConfigColor colorBoton = ConfigColor.de("tema.vshojo.no_registro.color.boton", Config.convertirAColor(Config.obtenerInstancia().obtenerColorBoton()));
    private ConfigColor colorCajaTexto = ConfigColor.de("tema.vshojo.no_registro.color.caja_texto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorCajaTexto()));
    private ConfigColor colorEnlace = ConfigColor.de("tema.vshojo.no_registro.color.enlace", Config.convertirAColor(Config.obtenerInstancia().obtenerColorEnlace()));

    @Override
    public void init() {
        this.setVisible(true);
    }

    @Override
    public void preparar(JFrame blanco, Instant instant) {
        this.instant = instant;
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle(Config.obtenerInstancia().obtenerNombreCD() + " \u2013 " + MonitorDePID.idioma.noRegistroLauncherTitulo());
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(700, 520));
        this.setLocationRelativeTo(blanco);
        this.getContentPane().setLayout(new BorderLayout(8, 0));
        JPanel raiz = this.construirContenido();
        this.getContentPane().add((Component)raiz, "Center");
        this.pack();
        this.setSize(880, 640);
        this.aplicarApariencia();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (NoRegistroDeLauncherVShojo.this.botonOmitir != null && NoRegistroDeLauncherVShojo.this.botonOmitir.isEnabled()) {
                    NoRegistroDeLauncherVShojo.this.botonOmitir.doClick();
                } else {
                    NoRegistroDeLauncherVShojo.this.dispose();
                }
            }
        });
    }

    public JPanel construirContenido() {
        int filaAltura;
        this.building = true;
        this.raizPanel = new JPanel(new BorderLayout(8, 0));
        this.raizPanel.setBorder(new EmptyBorder(8, 10, 0, 10));
        this.raizPanel.setBackground(this.colorFondoVentana.obtener());
        this.encabezadoPanel = new JPanel(new BorderLayout(6, 6));
        this.encabezadoPanel.setBackground(this.colorFondoVentana.obtener());
        JLabel titulo = new JLabel("CrashDetector \u2013 " + MonitorDePID.idioma.noRegistroLauncherTitulo());
        titulo.setFont(this.negrita(titulo.getFont(), 18.0f));
        titulo.setForeground(this.colorTexto.obtener());
        this.encabezadoPanel.add((Component)titulo, "North");
        this.descripcionHtml = new JEditorPane();
        this.descripcionHtml.setContentType("text/html");
        this.descripcionHtml.setEditable(false);
        this.descripcionHtml.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.descripcionHtml.setText(this.htmlWrap(MonitorDePID.idioma.noRegistroDeLauncher()));
        this.descripcionHtml.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                    }
                    catch (Exception ex) {
                        CrashDetectorLogger.logException(ex);
                    }
                }
            }
        });
        this.descScroll = new JScrollPane(this.descripcionHtml);
        this.descScroll.setPreferredSize(new Dimension(10, 84));
        this.descScroll.getViewport().setBackground(this.colorCajaTexto.obtener());
        this.descScroll.setBorder(BorderFactory.createLineBorder(this.colorBoton.obtener().darker(), 1));
        this.encabezadoPanel.add((Component)this.descScroll, "Center");
        JPanel filaControles = new JPanel(new FlowLayout(0, 8, 0));
        filaControles.setBackground(this.colorFondoVentana.obtener());
        this.selector = new JComboBox<String>(new String[]{"Gen\u00e9rico", "CurseForge", "Prism/MultiMC+++", "HMCL", "F\u00e9nix", "ATLauncher", "GDLauncher", "Battly Launcher", "Nightworld", "Servidor de Minecraft", "Enlace MD"});
        this.estilizarCombo(this.selector);
        this.selector.setPreferredSize(new Dimension(360, 34));
        this.selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NoRegistroDeLauncherVShojo.this.building) {
                    NoRegistroDeLauncherVShojo.this.refrescarInterfaz();
                }
            }
        });
        LinkedHashMap<String, String> banderas = new LinkedHashMap<String, String>();
        banderas.put("Espa\u00f1ol", "imagenes/bandera_mexico.png");
        banderas.put("English", "imagenes/bandera_inglaterra.png");
        banderas.put("\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "imagenes/bandera_arabia.png");
        banderas.put("Portugu\u00eas", "imagenes/bandera_brasil.png");
        banderas.put("\u0641\u0627\u0631\u0633\u06cc", "imagenes/bandera_iran.png");
        banderas.put("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "imagenes/bandera_rusia.png");
        banderas.put("\u7b80\u4f53\u4e2d\u6587", "imagenes/bandera_china.png");
        banderas.put("Esperanto", "imagenes/bandera_esperanto.png");
        banderas.put("\u65e5\u672c\u8a9e", "imagenes/bandera_japon.png");
        banderas.put("\ud55c\uad6d\uc5b4", "imagenes/bandera_corea.png");
        this.comboBoxIdioma = new ComboIdiomasConIcono(banderas);
        this.estilizarCombo(this.comboBoxIdioma);
        String code = MonitorDePID.idioma.codigo();
        if ("es".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("Espa\u00f1ol");
        } else if ("en".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("English");
        } else if ("ar".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("\u0627\u0644\u0639\u0631\u0628\u064a\u0629");
        } else if ("pt".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("Portugu\u00eas");
        } else if ("fa".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("\u0641\u0627\u0631\u0633\u06cc");
        } else if ("ru".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
        } else if ("zh".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("\u7b80\u4f53\u4e2d\u6587");
        } else if ("eo".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("Esperanto");
        } else if ("ja".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("\u65e5\u672c\u8a9e");
        } else if ("ko".equals(code)) {
            this.comboBoxIdioma.setSelectedItem("\ud55c\uad6d\uc5b4");
        } else {
            this.comboBoxIdioma.setSelectedItem("Espa\u00f1ol");
        }
        this.comboBoxIdioma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NoRegistroDeLauncherVShojo.this.building) {
                    return;
                }
                String sel = (String)NoRegistroDeLauncherVShojo.this.comboBoxIdioma.getSelectedItem();
                String codigo = CrashDetectorGUI.obtenerCodigoIdioma(sel);
                if (codigo != null) {
                    try {
                        ConfigMundial.obtenerInstancia().guardarIdioma(codigo);
                    }
                    catch (Exception ex) {
                        CrashDetectorLogger.logException(ex);
                    }
                    MonitorDePID.idioma = Idioma.detectar();
                    NoRegistroDeLauncherVShojo.this.actualizarTextos();
                }
            }
        });
        filaControles.add(this.selector);
        filaControles.add(Box.createHorizontalStrut(10));
        filaControles.add(this.comboBoxIdioma);
        this.encabezadoPanel.add((Component)filaControles, "South");
        this.raizPanel.add((Component)this.encabezadoPanel, "North");
        this.centroPanel = new JPanel(new BorderLayout(6, 6));
        this.centroPanel.setBackground(this.colorFondoVentana.obtener());
        this.panelImagenYBoton = new JPanel(new BorderLayout());
        this.panelImagenYBoton.setBackground(this.colorFondoVentana.obtener());
        this.imagenLbl.setOpaque(true);
        this.imagenLbl.setBackground(this.colorFondoVentana.obtener());
        this.imagenLbl.setBorder(BorderFactory.createLineBorder(this.colorBoton.obtener().darker(), 1));
        this.panelImagenYBoton.add((Component)this.imagenLbl, "Center");
        this.panelBajoImagen = new JPanel(new FlowLayout(0, 0, 6));
        this.panelBajoImagen.setBackground(this.colorFondoVentana.obtener());
        this.estilizarBoton(this.seleccionarCarpetaBtn);
        this.seleccionarCarpetaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NoRegistroDeLauncherVShojo.this.abrirSelectorCarpeta();
            }
        });
        this.panelBajoImagen.add(this.seleccionarCarpetaBtn);
        this.panelImagenYBoton.add((Component)this.panelBajoImagen, "South");
        this.centroPanel.add((Component)this.panelImagenYBoton, "North");
        this.areaTexto = new TextArea("", 24, 100, 0);
        this.areaTexto.setFont(new Font("Monospaced", 0, 13));
        this.areaTexto.setBackground(this.colorCajaTexto.obtener());
        this.areaTexto.setForeground(this.colorEnlace.obtener());
        this.panelAreaTexto = new JPanel(new BorderLayout());
        this.panelAreaTexto.setBackground(this.colorFondoVentana.obtener());
        this.panelAreaTexto.add((Component)this.areaTexto, "Center");
        this.panelAreaTexto.setBorder(this.bordeTitulado(MonitorDePID.idioma.pegaLosRegistrosAqui()));
        this.centroPanel.add((Component)this.panelAreaTexto, "Center");
        this.raizPanel.add((Component)this.centroPanel, "Center");
        this.piePanel = new JPanel(new GridBagLayout());
        this.piePanel.setBackground(this.colorFondoVentana.obtener());
        ImageIcon vshojoIcon = this.cargarIconoEncajado("imagenes/vshojo.png", 140, 90, true);
        int n = filaAltura = vshojoIcon != null ? vshojoIcon.getIconHeight() : 90;
        if (vshojoIcon != null) {
            this.vshojoLbl.setIcon(vshojoIcon);
            this.vshojoLbl.setBorder(null);
            this.vshojoLbl.setPreferredSize(new Dimension(vshojoIcon.getIconWidth(), vshojoIcon.getIconHeight()));
        } else {
            this.vshojoLbl.setText("VShojo");
        }
        this.vshojoLbl.setForeground(this.colorTexto.obtener());
        this.botonesPanel = new JPanel(new FlowLayout(2, 10, 0));
        this.botonesPanel.setBackground(this.colorFondoVentana.obtener());
        this.botonesPanel.setPreferredSize(new Dimension(10, filaAltura));
        this.botonesPanel.setMinimumSize(new Dimension(10, filaAltura));
        this.botonesPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, filaAltura));
        this.botonProxy = new JButton("ProxySysOutSysErr");
        this.botonGuardar = new JButton(MonitorDePID.idioma.guardarYCerrar());
        this.botonOmitir = new JButton(MonitorDePID.idioma.omitirYCerrar());
        this.estilizarBoton(this.botonProxy, 4);
        this.estilizarBoton(this.botonGuardar, 4);
        this.estilizarBoton(this.botonOmitir, 4);
        this.botonProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String msg = MonitorDePID.idioma.habilitarProxySysOutSysErrMensaje();
                int r = JOptionPane.showConfirmDialog(NoRegistroDeLauncherVShojo.this, msg, MonitorDePID.idioma.confirmacionTitulo(), 0, 3);
                if (r == 0) {
                    Config.obtenerInstancia().guardarProxySysOutSysErr(true);
                    JOptionPane.showMessageDialog(NoRegistroDeLauncherVShojo.this, MonitorDePID.idioma.proxyHabilitadoMensaje(), MonitorDePID.idioma.informacionTitulo(), 1);
                }
            }
        });
        this.botonGuardar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoRegistroDeLauncherVShojo.this.guardarRegistros();
            }
        });
        this.botonOmitir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoRegistroDeLauncherVShojo.this.dispose();
            }
        });
        this.botonesPanel.add(this.botonGuardar);
        this.botonesPanel.add(this.botonOmitir);
        this.botonesPanel.add(this.botonProxy);
        GridBagConstraints g0 = new GridBagConstraints();
        g0.gridx = 0;
        g0.gridy = 0;
        g0.anchor = 17;
        g0.insets = new Insets(0, 0, 0, 8);
        this.piePanel.add((Component)this.vshojoLbl, g0);
        GridBagConstraints g1 = new GridBagConstraints();
        g1.gridx = 1;
        g1.gridy = 0;
        g1.weightx = 1.0;
        g1.anchor = 13;
        g1.fill = 2;
        this.piePanel.add((Component)this.botonesPanel, g1);
        this.raizPanel.add((Component)this.piePanel, "South");
        this.selector.setSelectedItem(this.detectarPorDirectorio());
        this.building = false;
        this.refrescarInterfaz();
        return this.raizPanel;
    }

    @Override
    public void aplicarApariencia() {
        this.getContentPane().setBackground(this.colorFondoVentana.obtener());
        if (this.raizPanel != null) {
            this.raizPanel.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.encabezadoPanel != null) {
            this.encabezadoPanel.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.centroPanel != null) {
            this.centroPanel.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.panelImagenYBoton != null) {
            this.panelImagenYBoton.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.piePanel != null) {
            this.piePanel.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.botonesPanel != null) {
            this.botonesPanel.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.descScroll != null) {
            this.descScroll.getViewport().setBackground(this.colorCajaTexto.obtener());
            this.descScroll.setBorder(BorderFactory.createLineBorder(this.colorBoton.obtener().darker(), 1));
        }
        if (this.descripcionHtml != null) {
            this.descripcionHtml.setOpaque(true);
            this.descripcionHtml.setBackground(this.colorCajaTexto.obtener());
        }
        if (this.imagenLbl != null) {
            this.imagenLbl.setBackground(this.colorFondoVentana.obtener());
            this.imagenLbl.setBorder(BorderFactory.createLineBorder(this.colorBoton.obtener().darker(), 1));
        }
        if (this.panelBajoImagen != null) {
            this.panelBajoImagen.setBackground(this.colorFondoVentana.obtener());
        }
        if (this.panelAreaTexto != null) {
            this.panelAreaTexto.setBackground(this.colorFondoVentana.obtener());
            this.panelAreaTexto.setBorder(this.bordeTitulado(MonitorDePID.idioma.pegaLosRegistrosAqui()));
        }
        if (this.areaTexto != null) {
            this.areaTexto.setBackground(this.colorCajaTexto.obtener());
            this.areaTexto.setForeground(this.colorEnlace.obtener());
        }
        if (this.vshojoLbl != null) {
            this.vshojoLbl.setForeground(this.colorTexto.obtener());
        }
        if (this.seleccionarCarpetaBtn != null) {
            this.estilizarBoton(this.seleccionarCarpetaBtn);
        }
        if (this.botonGuardar != null) {
            this.estilizarBoton(this.botonGuardar, 4);
        }
        if (this.botonOmitir != null) {
            this.estilizarBoton(this.botonOmitir, 4);
        }
        if (this.botonProxy != null) {
            this.estilizarBoton(this.botonProxy, 4);
        }
        if (this.comboBoxIdioma != null) {
            this.estilizarCombo(this.comboBoxIdioma);
        }
        if (this.selector != null) {
            this.estilizarCombo(this.selector);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondoVentana.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        this.colorEnlace.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEnlace());
        elementos.add(this.colorFondoVentana);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        elementos.add(this.colorCajaTexto);
        elementos.add(this.colorEnlace);
        return elementos;
    }

    @Override
    public TitledBorder bordeTitulado(String titulo) {
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.colorBoton.obtener().darker(), 1), titulo);
        b.setTitleColor(this.colorTexto.obtener());
        return b;
    }

    public void estilizarBoton(JButton btn) {
        this.estilizarBoton(btn, 10);
    }

    public void estilizarBoton(JButton btn, int paddingV) {
        if (!CrashDetectorGUI.esMac()) {
            btn.setBackground(this.colorBoton.obtener());
            btn.setForeground(this.colorTexto.obtener());
            btn.setFocusPainted(false);
            btn.setBorder(BorderFactory.createEmptyBorder(paddingV, 18, paddingV, 18));
        } else {
            btn.setContentAreaFilled(false);
        }
        btn.setFont(new Font("Segoe UI", 0, 14));
    }

    public void estilizarCombo(JComboBox<?> combo) {
        if (!CrashDetectorGUI.esMac()) {
            combo.setBackground(this.colorBoton.obtener());
            combo.setForeground(this.colorTexto.obtener());
        }
        combo.setFont(new Font("Segoe UI", 0, 13));
        combo.setPreferredSize(new Dimension(220, 32));
    }

    @Override
    public String htmlWrap(String innerHtml) {
        String fg = this.rgb(this.colorTexto.obtener());
        String bg = this.rgb(this.colorCajaTexto.obtener());
        return "<html><body style='margin:6px; font-family: Segoe UI, sans-serif; font-size:13px; color:" + fg + "; background:" + bg + ";'>" + innerHtml + "</body></html>";
    }
}

