/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.EnlanceMD;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.TextArea;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;

@Deprecated
public abstract class NoRegistroLanzadorGUI
extends JDialog
implements CrashDetectorGUI {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<NoRegistroLanzadorGUI>> GUIS = new HashMap<String, Supplier<NoRegistroLanzadorGUI>>();
    public static final String GEN = "Gen\u00e9rico";
    public static final String CURSE = "CurseForge";
    public static final String PRISM = "Prism/MultiMC+++";
    public static final String HMCL = "HMCL";
    public static final String FENIX = "F\u00e9nix";
    public static final String ATL = "ATLauncher";
    public static final String GD = "GDLauncher";
    public static final String BATTLY = "Battly Launcher";
    public static final String NIGHTWORLD = "Nightworld";
    public static final String MCSERVER = "Servidor de Minecraft";
    public static final String ENLACE_MD = "Enlace MD";
    public static final int MAX_ANCHO_IMAGEN = 500;
    public static final int MAX_ALTO_CASI_CUADRADA = 220;
    public static final int MAX_ALTO_PANORAMICA = 120;
    public static final int ALTURA_MINIMA_SIN_IMAGEN = 120;
    public boolean building = false;
    public JComboBox<String> selector;
    public JComboBox<String> comboBoxIdioma;
    public final JLabel imagenLbl = new JLabel("", 0);
    public final JLabel vshojoLbl = new JLabel("", 0);
    public final JButton seleccionarCarpetaBtn = new JButton(MonitorDePID.idioma.seleccionarCarpeta());
    public JEditorPane descripcionHtml;
    public JScrollPane descScroll;
    public TextArea areaTexto;
    public JButton botonGuardar;
    public JButton botonOmitir;
    public JButton botonProxy;
    public JPanel panelAreaTexto;
    public JPanel panelBajoImagen;
    public JPanel raizPanel;
    public JPanel encabezadoPanel;
    public JPanel centroPanel;
    public JPanel panelImagenYBoton;
    public JPanel piePanel;
    public JPanel botonesPanel;
    public static File cd_launcherlog = new File("cd_launcherlog");
    public Instant instant;

    public abstract void preparar(JFrame var1, Instant var2);

    public void refrescarInterfaz() {
        String tipo = (String)this.selector.getSelectedItem();
        String desc = MonitorDePID.idioma.noRegistroDeLauncher();
        ImageIcon icono = null;
        boolean mostrarArea = true;
        boolean mostrarBotonHMCL = false;
        if (HMCL.equals(tipo)) {
            desc = MonitorDePID.idioma.descripcionHMCL();
        } else if (GEN.equals(tipo)) {
            desc = MonitorDePID.idioma.noRegistroDeLauncher();
        }
        if (CURSE.equals(tipo)) {
            desc = MonitorDePID.idioma.descripcionCurseforge();
            icono = this.cargarIconoAyudaFlexible("/imagenes/cfskiplauncher.png");
            mostrarArea = false;
        } else if (PRISM.equals(tipo)) {
            desc = MonitorDePID.idioma.descripcionPrism();
            icono = this.cargarIconoAyudaFlexible("/imagenes/registros_de_launcher_prism.png");
        } else if (HMCL.equals(tipo)) {
            icono = this.cargarIconoAyudaFlexible("/imagenes/hcml.png");
            mostrarArea = false;
            mostrarBotonHMCL = true;
        } else if (FENIX.equals(tipo)) {
            desc = MonitorDePID.idioma.descripcionFenix();
            icono = this.cargarIconoAyudaFlexible("/imagenes/fenix.png");
        } else if (ATL.equals(tipo)) {
            desc = MonitorDePID.idioma.descripcionATLauncher();
            icono = this.cargarIconoAyudaFlexible("/imagenes/atlogs.png");
        } else if (GD.equals(tipo)) {
            desc = MonitorDePID.idioma.descripcionGDLauncher();
            icono = this.cargarIconoAyudaFlexible("/imagenes/gdconsola.png");
        } else if (ENLACE_MD.equals(tipo)) {
            desc = MonitorDePID.idioma.descripcionLinksMarkdown();
            icono = null;
        } else if (BATTLY.equals(tipo)) {
            desc = MonitorDePID.idioma.noRegistroDeBattly();
            icono = this.cargarIconoAyudaFlexible("/imagenes/battly.png");
            mostrarArea = false;
        } else if (NIGHTWORLD.equals(tipo)) {
            desc = MonitorDePID.idioma.noRegistroDeNightWorld();
            icono = this.cargarIconoAyudaFlexible("/imagenes/nightworld.png");
            mostrarArea = true;
        } else if (MCSERVER.equals(tipo)) {
            desc = MonitorDePID.idioma.noRegistroDeMCServidor();
            icono = this.cargarIconoAyudaFlexible("/imagenes/minecraftserver.png");
            mostrarArea = true;
        } else {
            icono = this.cargarIconoAyudaFlexible("/imagenes/registros_de_lanzar.png");
        }
        if (this.descripcionHtml != null) {
            this.descripcionHtml.setText(this.htmlWrap(desc));
        }
        if (this.imagenLbl != null) {
            if (icono != null) {
                this.imagenLbl.setIcon(icono);
                this.imagenLbl.setText("");
                this.imagenLbl.setPreferredSize(new Dimension(icono.getIconWidth(), icono.getIconHeight()));
            } else {
                this.imagenLbl.setIcon(null);
                this.imagenLbl.setText(MonitorDePID.idioma.imagenNoEncontrada());
                this.imagenLbl.setPreferredSize(new Dimension(10, 120));
            }
        }
        if (this.panelBajoImagen != null) {
            this.panelBajoImagen.setVisible(mostrarBotonHMCL);
        }
        if (this.panelAreaTexto != null) {
            boolean estabaVisible = this.panelAreaTexto.isVisible();
            this.panelAreaTexto.setVisible(mostrarArea);
            if (estabaVisible && !mostrarArea) {
                this.pack();
            }
        }
        this.revalidate();
        this.repaint();
    }

    protected abstract String htmlWrap(String var1);

    public String detectarPorDirectorio() {
        String rutaAbs = new File(System.getProperty("user.dir")).getAbsolutePath().toLowerCase();
        if (this.contiene(rutaAbs, "prismlauncher", "multimc", "polymc", "pollymc", "freesm", "fjord", "ultim", "prism")) {
            return PRISM;
        }
        if (this.contiene(rutaAbs, "atlauncher")) {
            return ATL;
        }
        if (this.contiene(rutaAbs, "gdlauncher")) {
            return GD;
        }
        if (this.contiene(rutaAbs, "curseforge", "overwolf")) {
            return CURSE;
        }
        if (this.contiene(rutaAbs, "hmcl")) {
            return HMCL;
        }
        if (this.contiene(rutaAbs, "battly")) {
            return BATTLY;
        }
        if (this.contiene(rutaAbs, "server")) {
            return MCSERVER;
        }
        File f = new File(rutaAbs);
        for (int i = 0; i < 5 && f != null; ++i, f = f.getParentFile()) {
            String nombre = f.getName().toLowerCase();
            if (this.contiene(nombre, "prismlauncher", "multimc", "polymc", "pollymc", "freesm", "fjord", "ultim", "prism")) {
                return PRISM;
            }
            if (nombre.contains("atlauncher")) {
                return ATL;
            }
            if (nombre.contains("gdlauncher")) {
                return GD;
            }
            if (this.contiene(nombre, "curseforge", "overwolf")) {
                return CURSE;
            }
            if (nombre.contains("hmcl")) {
                return HMCL;
            }
            if (nombre.contains("battly")) {
                return BATTLY;
            }
            if (!nombre.contains("server")) continue;
            return MCSERVER;
        }
        return GEN;
    }

    public boolean contiene(String s, String ... tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            if (!s.contains(tokens[i])) continue;
            return true;
        }
        return false;
    }

    public void abrirSelectorCarpeta() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            File dir = fc.getSelectedFile();
            Config.obtenerInstancia().guardarCarpetaHMCL(dir.getAbsolutePath());
        }
    }

    public void guardarRegistros() {
        long timeoutSeconds;
        String tipo = (String)this.selector.getSelectedItem();
        if (HMCL.equals(tipo) || CURSE.equals(tipo) || BATTLY.equals(tipo)) {
            this.dispose();
            return;
        }
        if (ENLACE_MD.equals(tipo)) {
            final String contenido = this.areaTexto != null ? this.areaTexto.getText() : "";
            this.ejecutarConOverlayDescarga(new Runnable(){

                @Override
                public void run() {
                    CrashDetectorLogger.log("EnlaceMD: iniciando guardado");
                    EnlanceMD.guardar(contenido);
                    CrashDetectorLogger.log("EnlaceMD: guardado completo");
                }
            }, this.overlayMensaje());
            return;
        }
        if (this.areaTexto == null) {
            this.dispose();
            return;
        }
        final byte[] data = this.areaTexto.getText().getBytes(StandardCharsets.UTF_8);
        long sizeBytes = data.length;
        if (sizeBytes < 0xA00000L) {
            timeoutSeconds = 5L;
        } else {
            long chunks = (sizeBytes + 0x3200000L - 1L) / 0x3200000L;
            timeoutSeconds = chunks * 20L;
        }
        CrashDetectorLogger.log("Tama\u00f1o de logs = " + sizeBytes / 0x100000L + " MB, timeout = " + timeoutSeconds + "s");
        Thread writerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try (FileOutputStream fos = new FileOutputStream(cd_launcherlog);
                     FileChannel ch = fos.getChannel();){
                    fos.write(data);
                    CrashDetectorLogger.log("Archivo cd_launcherlog guardado");
                    Consola cons = new Consola(cd_launcherlog.toPath());
                    cons.finalizarContenidoInyectado(new String(data, StandardCharsets.UTF_8));
                    MonitorDePID.consolas.add(cons);
                    MonitorDePID.consola_de_launcher_inyectado = true;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(NoRegistroLanzadorGUI.this, "Error: " + ex.getMessage(), "Error", 0);
                }
            }
        });
        writerThread.start();
        try {
            writerThread.join(timeoutSeconds * 1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.dispose();
    }

    public void ejecutarConOverlayDescarga(final Runnable tarea, String mensaje) {
        final JDialog overlay = new JDialog((Dialog)this, true);
        overlay.setUndecorated(true);
        JPanel box = new JPanel(new BorderLayout(10, 10));
        box.setBorder(BorderFactory.createEmptyBorder(16, 20, 16, 20));
        ImageIcon gif = this.cargarGif(this.gifDescargaPath());
        if (gif != null) {
            JLabel gifLbl = new JLabel(gif);
            gifLbl.setOpaque(false);
            box.add((Component)gifLbl, "West");
        } else {
            CrashDetectorLogger.log("GIF de descarga no encontrado, usando barra indeterminada");
            JProgressBar bar = new JProgressBar();
            bar.setIndeterminate(true);
            box.add((Component)bar, "West");
        }
        JLabel msg = new JLabel(mensaje);
        msg.setFont(new Font("Segoe UI", 0, 14));
        box.add((Component)msg, "Center");
        overlay.getContentPane().add(box);
        overlay.pack();
        overlay.setLocationRelativeTo(this);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                try {
                    tarea.run();
                }
                catch (Throwable t) {
                    CrashDetectorLogger.logException(t);
                    JOptionPane.showMessageDialog(NoRegistroLanzadorGUI.this, "Error: " + t.getMessage(), "Error", 0);
                }
                return null;
            }

            @Override
            protected void done() {
                overlay.dispose();
                NoRegistroLanzadorGUI.this.dispose();
            }
        };
        worker.execute();
        overlay.setVisible(true);
    }

    public abstract void aplicarApariencia();

    public String overlayMensaje() {
        return "Descargando y preparando enlaces...";
    }

    public String gifDescargaPath() {
        return "/imagenes/descargando.gif";
    }

    public Font negrita(Font base, float size) {
        return base.deriveFont(1, size);
    }

    public String rgb(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    public ImageIcon cargarGif(String ruta) {
        try {
            URL url = this.getClass().getResource(ruta);
            return url != null ? new ImageIcon(url) : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ImageIcon cargarIconoAyudaFlexible(String ruta) {
        URL url = this.getClass().getResource(ruta);
        if (url == null) {
            CrashDetectorLogger.log("No se encontr\u00f3 la imagen " + ruta);
            return null;
        }
        ImageIcon original = new ImageIcon(url);
        int w = original.getIconWidth();
        int h = original.getIconHeight();
        if (w <= 0 || h <= 0) {
            return original;
        }
        double ratio = (double)w / (double)h;
        boolean casiCuadrada = ratio >= 0.75 && ratio <= 1.33;
        int maxAncho = 500;
        int maxAlto = casiCuadrada ? 220 : 120;
        double escala = Math.min((double)maxAncho / (double)w, (double)maxAlto / (double)h);
        int nuevoW = (int)Math.round((double)w * escala);
        int nuevoH = (int)Math.round((double)h * escala);
        Image img = original.getImage().getScaledInstance(nuevoW, nuevoH, 4);
        return new ImageIcon(img);
    }

    public ImageIcon cargarIconoEncajado(String ruta, int maxAncho, int maxAlto, boolean noAmpliar) {
        File archivo = Statics.carpeta.resolve(ruta).toFile();
        if (archivo == null) {
            CrashDetectorLogger.log("No se encontr\u00f3 la imagen " + ruta);
            return null;
        }
        ImageIcon original = new ImageIcon(archivo.getAbsolutePath());
        int w = original.getIconWidth();
        int h = original.getIconHeight();
        if (w <= 0 || h <= 0) {
            return original;
        }
        double escalaW = (double)maxAncho / (double)w;
        double escalaH = (double)maxAlto / (double)h;
        double escala = Math.min(escalaW, escalaH);
        if (noAmpliar && escala > 1.0) {
            escala = 1.0;
        }
        int nuevoW = (int)Math.round((double)w * escala);
        int nuevoH = (int)Math.round((double)h * escala);
        Image escalada = original.getImage().getScaledInstance(nuevoW, nuevoH, 4);
        return new ImageIcon(escalada);
    }

    public void actualizarTextos() {
        this.setTitle(Config.obtenerInstancia().obtenerNombreCD() + " \u2013 " + MonitorDePID.idioma.noRegistroLauncherTitulo());
        if (this.descripcionHtml != null) {
            this.descripcionHtml.setText(this.htmlWrap(MonitorDePID.idioma.noRegistroDeLauncher()));
        }
        if (this.seleccionarCarpetaBtn != null) {
            this.seleccionarCarpetaBtn.setText(MonitorDePID.idioma.seleccionarCarpeta());
        }
        if (this.botonGuardar != null) {
            this.botonGuardar.setText(MonitorDePID.idioma.guardarYCerrar());
        }
        if (this.botonOmitir != null) {
            this.botonOmitir.setText(MonitorDePID.idioma.omitirYCerrar());
        }
        if (this.panelAreaTexto != null) {
            this.panelAreaTexto.setBorder(this.bordeTitulado(MonitorDePID.idioma.pegaLosRegistrosAqui()));
        }
        this.refrescarInterfaz();
    }

    protected abstract Border bordeTitulado(String var1);

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
    }

    @Override
    public TipoGUI<NoRegistroLanzadorGUI> tipo() {
        return TipoGUI.NO_REGISTRO_LANZER;
    }

    @Override
    public abstract void init();
}

