/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.principal;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.discord.ManagerDiscord;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.arbol.ArbolDeModsGUIHamu;
import com.asbestosstar.crashdetector.gui.tipos.config.ConfigPanel;
import com.asbestosstar.crashdetector.gui.tipos.config.ConfigPanelEstiloTL;
import com.asbestosstar.crashdetector.gui.tipos.corpo.CorpoSAO;
import com.asbestosstar.crashdetector.gui.tipos.grepr.BusquedaGUISaliorMoon;
import com.asbestosstar.crashdetector.gui.tipos.historia.ClioOfficeGUI;
import com.asbestosstar.crashdetector.gui.tipos.lectador.LectadorDeConsolasHoloTalk;
import com.asbestosstar.crashdetector.gui.tipos.mcreator.EscanerMCreatorGUIRosemiLoveLock;
import com.asbestosstar.crashdetector.gui.tipos.modapi.CDModsEstiloTL;
import com.asbestosstar.crashdetector.gui.tipos.modapi.PanelAPIBase;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.PanelQuickFixDemonSlayers;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.TodosQuickFixesGUI;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class PrincipalGUI
extends JFrame
implements CrashDetectorGUI {
    public static Map<String, Supplier<PrincipalGUI>> GUIS = new HashMap<String, Supplier<PrincipalGUI>>();
    public Instant tiempoFallo;
    public ConfigColor colorFondo = ConfigColor.de("gui.principal.color.fondo", Config.convertirAColor(Config.obtenerInstancia().obtenerColorFondo()));
    public ConfigColor colorTexto = ConfigColor.de("gui.principal.color.texto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorTexto()));
    public ConfigColor colorBoton = ConfigColor.de("gui.principal.color.boton", Config.convertirAColor(Config.obtenerInstancia().obtenerColorBoton()));
    public ConfigColor colorCajaTexto = ConfigColor.de("gui.principal.color.cajaTexto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorCajaTexto()));
    public ConfigColor colorEnlace = ConfigColor.de("gui.principal.color.enlace", Config.convertirAColor(Config.obtenerInstancia().obtenerColorEnlace()));
    public CountDownLatch cerrojo;
    public JEditorPane pantalla = new JEditorPane();
    public JScrollPane scrollPane = new JScrollPane(this.pantalla);
    public ConfigPanel<PrincipalGUI> panelConfiguracion = TipoGUI.CONFIG_PANEL.obtenerGUIPredeterminado(ConfigPanelEstiloTL.ID, () -> new ConfigPanelEstiloTL());
    public PanelAPIBase panelCDMods = TipoGUI.MOD_API_PANEL.obtenerGUIPredeterminado(CDModsEstiloTL.ID, () -> new CDModsEstiloTL());
    public JButton botonVolver = new JButton(MonitorDePID.idioma.volver());
    public JButton botonConfiguracion;
    public JPanel contenidoPrincipal = new JPanel(new BorderLayout());
    public static BiMap<TipoGUI<? extends BotonDeBarraLateralDerecha>, String, Supplier<BotonDeBarraLateralDerecha>> botons_de_barra_lateral_derecha = new BiMap();
    public Map<BotonDeBarraLateralDerecha, JButton> botons_de_barra_lateral_derecha_initalizado = new HashMap<BotonDeBarraLateralDerecha, JButton>();

    public void constructir(Instant utc, CountDownLatch latch) {
        this.tiempoFallo = utc;
        this.cerrojo = latch;
        ManagerDiscord.comenzar();
        CrashDetectorLogger.log("en constructir");
        this.inicializarInterfaz();
        this.setVisible(true);
    }

    public static void registrarBotonDeBarraLateralDerecha(TipoGUI<? extends BotonDeBarraLateralDerecha> boton, String predeterminado, Supplier<BotonDeBarraLateralDerecha> gui_predeterminado) {
        botons_de_barra_lateral_derecha.put(boton, predeterminado, gui_predeterminado);
    }

    public abstract void inicializarInterfaz();

    public void volver() {
        this.contenidoPrincipal.removeAll();
        this.contenidoPrincipal.add((Component)this.scrollPane, "Center");
        this.contenidoPrincipal.revalidate();
        this.contenidoPrincipal.repaint();
        this.botonVolver.setEnabled(false);
    }

    @Override
    public String obtenerCodigoIdioma(String nombreIdioma) {
        switch (nombreIdioma) {
            case "Espa\u00f1ol": {
                return "es";
            }
            case "English": {
                return "en";
            }
            case "\u0627\u0644\u0639\u0631\u0628\u064a\u0629": {
                return "ar";
            }
            case "Portugu\u00eas": {
                return "pt";
            }
            case "\u0641\u0627\u0631\u0633\u06cc": {
                return "fa";
            }
            case "\u0420\u0443\u0441\u0441\u043a\u0438\u0439": {
                return "ru";
            }
            case "\u7b80\u4f53\u4e2d\u6587": {
                return "zh";
            }
            case "Esperanto": {
                return "eo";
            }
            case "\u65e5\u672c\u8a9e": {
                return "ja";
            }
            case "\ud55c\uad6d\uc5b4": {
                return "ko";
            }
        }
        return "es";
    }

    public void anadirRegistro() {
        JFileChooser selectorArchivo = new JFileChooser();
        selectorArchivo.setDialogTitle("Seleccione un archivo");
        int resultado = selectorArchivo.showOpenDialog(null);
        if (resultado == 0) {
            File archivoSeleccionado = selectorArchivo.getSelectedFile();
            try {
                Consola cons = new Consola(archivoSeleccionado.toPath());
                cons.finalizarContenido(this.tiempoFallo, true);
                MonitorDePID.consolas.add(cons);
                this.recargar();
            }
            catch (IOException e) {
                CrashDetectorLogger.logException(e);
                JOptionPane.showMessageDialog(null, "Error al abrir el archivo: " + e.getMessage(), "Error", 0);
            }
        }
    }

    public JButton a\u00f1adirBotonEmoji(JPanel panel, String emoji, String tooltip) {
        final JButton boton = new JButton(emoji);
        boton.setToolTipText(tooltip);
        boton.setFont(new Font("Segoe UI Emoji", 0, 20));
        boton.setRolloverEnabled(true);
        boton.setContentAreaFilled(false);
        boton.setBorderPainted(false);
        boton.setFocusPainted(false);
        boton.setPreferredSize(new Dimension(40, 40));
        boton.setMaximumSize(new Dimension(40, 40));
        boton.setMinimumSize(new Dimension(40, 40));
        boton.setForeground(this.colorTexto.obtener());
        boton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                boton.setBackground(PrincipalGUI.this.colorBoton.obtener().brighter());
                boton.setForeground(Color.BLACK);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                boton.setBackground(PrincipalGUI.this.colorFondo.obtener());
                boton.setForeground(PrincipalGUI.this.colorTexto.obtener());
            }
        });
        panel.add(boton);
        return boton;
    }

    public void a\u00f1adirBotonBarraLateral(JPanel panel, String texto) {
        JButton boton = new JButton(texto);
        boton.setBackground(this.colorBoton.obtener().darker());
        boton.setForeground(this.colorTexto.obtener());
        boton.setFont(boton.getFont().deriveFont(1, 14.0f));
        boton.setAlignmentX(0.5f);
        boton.setMargin(new Insets(10, 20, 10, 20));
        boton.setMaximumSize(new Dimension(130, 40));
        boton.setMinimumSize(new Dimension(130, 40));
        boton.setPreferredSize(new Dimension(130, 40));
        boton.setContentAreaFilled(true);
        boton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panel.add(boton);
    }

    public void estilizarBoton(JButton boton) {
        if (!CrashDetectorGUI.esMac()) {
            boton.setAlignmentX(0.5f);
            boton.setBackground(this.colorBoton.obtener());
            boton.setContentAreaFilled(true);
            boton.setForeground(this.colorTexto.obtener());
            boton.setFocusPainted(false);
            boton.setFont(new Font("Segoe UI", 0, 14));
            boton.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        } else {
            boton.setContentAreaFilled(false);
        }
        boton.setMaximumSize(new Dimension(250, 40));
        boton.setMinimumSize(new Dimension(250, 40));
        boton.setPreferredSize(new Dimension(250, 40));
    }

    @Override
    public void recargar() {
        MonitorDePID.recargar(false, null);
        try {
            this.pantalla.setText(new String(Files.readAllBytes(Paths.get(MonitorDePID.local, new String[0]))));
            this.pantalla.setCaretPosition(0);
            for (Map.Entry<BotonDeBarraLateralDerecha, JButton> entry : this.botons_de_barra_lateral_derecha_initalizado.entrySet()) {
                entry.getValue().setText(entry.getKey().tipo().etiquetaDelBoton());
            }
            this.botonVolver.setText(MonitorDePID.idioma.volver());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void abrirDirectorioEnExplorador() {
        File directorio = new File(System.getProperty("user.dir"));
        if (directorio.exists() && directorio.isDirectory()) {
            try {
                Desktop.getDesktop().open(directorio);
            }
            catch (IOException e) {
                CrashDetectorLogger.logException(e);
            }
        }
    }

    public JButton a\u00f1adirBotonImagen(JPanel panel, String imagePath, String tooltip) {
        final JButton boton = new JButton();
        boton.setToolTipText(tooltip);
        ImageIcon originalIcon = new ImageIcon(imagePath);
        Image image = originalIcon.getImage();
        int BUTTON_SIZE = 40;
        Image scaledImage = image.getScaledInstance(BUTTON_SIZE - 10, BUTTON_SIZE - 10, 4);
        ImageIcon icon = new ImageIcon(scaledImage);
        boton.setIcon(icon);
        boton.setText("");
        boton.setPreferredSize(new Dimension(BUTTON_SIZE, BUTTON_SIZE));
        boton.setBackground(this.colorFondo.obtener());
        boton.setBorder(BorderFactory.createLineBorder(this.colorFondo.obtener(), 1));
        boton.setFocusPainted(false);
        boton.setMargin(new Insets(0, 0, 0, 0));
        boton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                boton.setBackground(PrincipalGUI.this.colorBoton.obtener().brighter());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                boton.setBackground(PrincipalGUI.this.colorFondo.obtener());
            }
        });
        panel.add(boton);
        return boton;
    }

    public void mostrarVentanaQuickFix() {
        JDialog dialogo = new JDialog(this, "QuickFix", true);
        dialogo.setDefaultCloseOperation(2);
        dialogo.setSize(600, 400);
        dialogo.setLocationRelativeTo(this);
        JPanel panelQuickFix = new JPanel(new BorderLayout());
        if (!CrashDetectorGUI.esMac()) {
            panelQuickFix.setBackground(this.colorFondo.obtener());
        }
        TodosQuickFixesGUI panelContenido = TipoGUI.TODOS_QUICKFIXES.obtenerGUIPredeterminado(PanelQuickFixDemonSlayers.ID, () -> new PanelQuickFixDemonSlayers());
        for (QuickFix solucion : MonitorDePID.analizador.obtenerSoluciones()) {
            panelContenido.agregarQuickFix(solucion);
        }
        JPanel panelInferior = new JPanel(new FlowLayout(2));
        panelInferior.setBackground(this.colorFondo.obtener());
        JButton botonCerrar = new JButton(MonitorDePID.idioma.volver());
        this.estilizarBoton(botonCerrar);
        botonCerrar.addActionListener(e -> dialogo.dispose());
        panelInferior.add(botonCerrar);
        panelQuickFix.add((Component)panelContenido, "Center");
        panelQuickFix.add((Component)panelInferior, "South");
        dialogo.getContentPane().add(panelQuickFix);
        dialogo.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        MonitorDePID.fin(this.cerrojo);
    }

    @Override
    public TipoGUI<PrincipalGUI> tipo() {
        return TipoGUI.PRINCIPAL;
    }

    @Override
    public abstract void init();

    static {
        CrashDetectorLogger.log("Principal Static");
        PrincipalGUI.registrarBotonDeBarraLateralDerecha(TipoGUI.GREPR, "saliormoon_grep", () -> new BusquedaGUISaliorMoon());
        PrincipalGUI.registrarBotonDeBarraLateralDerecha(TipoGUI.ESCANER_MCREATOR, "rosemi_lovelock", () -> new EscanerMCreatorGUIRosemiLoveLock());
        PrincipalGUI.registrarBotonDeBarraLateralDerecha(TipoGUI.HISTORIA_DE_MODS, ClioOfficeGUI.ID, () -> new ClioOfficeGUI());
        PrincipalGUI.registrarBotonDeBarraLateralDerecha(TipoGUI.ARBOL_DE_MODS, ArbolDeModsGUIHamu.ID, () -> new ArbolDeModsGUIHamu());
        PrincipalGUI.registrarBotonDeBarraLateralDerecha(TipoGUI.LECTADOR_DE_CONSOLAS, LectadorDeConsolasHoloTalk.ID, () -> new LectadorDeConsolasHoloTalk());
        PrincipalGUI.registrarBotonDeBarraLateralDerecha(TipoGUI.CORPO, CorpoSAO.ID, () -> new CorpoSAO());
        PrincipalGUI.registrarBotonDeBarraLateralDerecha(TipoGUI.TODOS_QUICKFIXES, PanelQuickFixDemonSlayers.ID, () -> new PanelQuickFixDemonSlayers());
    }
}

