/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.principal;

import com.asbestosstar.crashdetector.App;
import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Entregar;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.elementos.ComboIdiomasConIcono;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.compartir.DialogoCompartir;
import com.asbestosstar.crashdetector.gui.tipos.compartir.DialogoCompartirLegacy;
import com.asbestosstar.crashdetector.gui.tipos.principal.PrincipalGUI;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PrincipalGUIEstiloLanzer
extends PrincipalGUI {
    public static String ID = "estilo_lanzer";
    public ConfigColor colorFondo = ConfigColor.de("gui.principal.lanzer.color.fondo", Config.convertirAColor(Config.obtenerInstancia().obtenerColorFondo()));
    public ConfigColor colorTexto = ConfigColor.de("gui.principal.lanzer.color.texto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorTexto()));
    public ConfigColor colorBoton = ConfigColor.de("gui.principal.lanzer.color.boton", Config.convertirAColor(Config.obtenerInstancia().obtenerColorBoton()));
    public ConfigColor colorCajaTexto = ConfigColor.de("gui.principal.lanzer.color.cajaTexto", Config.convertirAColor(Config.obtenerInstancia().obtenerColorCajaTexto()));
    public ConfigColor colorEnlace = ConfigColor.de("gui.principal.lanzer.color.enlace", Config.convertirAColor(Config.obtenerInstancia().obtenerColorEnlace()));

    @Override
    public void init() {
        this.setVisible(true);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void inicializarInterfaz() {
        App detectada;
        String codigoActual;
        this.pantalla.setContentType("text/html");
        this.pantalla.setEditable(false);
        this.pantalla.setBackground(this.colorCajaTexto.obtener());
        this.pantalla.setForeground(this.colorEnlace.obtener());
        this.pantalla.setFont(new Font("Consolas", 0, 14));
        try {
            this.pantalla.setText(new String(Files.readAllBytes(Paths.get(MonitorDePID.local, new String[0]))));
            this.pantalla.setCaretPosition(0);
        }
        catch (IOException e2) {
            this.pantalla.setText("<html><body style='color:#ff6b6b'>Problema con el Informe: " + e2.getMessage() + "</body></html>");
        }
        this.pantalla.addHyperlinkListener(e -> this.enlanceEvento(e));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setBackground(this.colorCajaTexto.obtener());
        if (this.scrollPane.getVerticalScrollBar() != null) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
        JPanel panelInferior = new JPanel(new BorderLayout(5, 5));
        panelInferior.setBackground(this.colorFondo.obtener());
        panelInferior.setBorder(new EmptyBorder(10, 20, 10, 20));
        JPanel seccionConfiguracion = new JPanel();
        seccionConfiguracion.setLayout(new BoxLayout(seccionConfiguracion, 1));
        seccionConfiguracion.setBackground(this.colorFondo.obtener());
        JPanel panelHorizontal = new JPanel();
        panelHorizontal.setLayout(new BoxLayout(panelHorizontal, 0));
        panelHorizontal.setBackground(this.colorFondo.obtener());
        JPanel columnaIzquierda = new JPanel();
        columnaIzquierda.setLayout(new BoxLayout(columnaIzquierda, 1));
        columnaIzquierda.setBackground(this.colorFondo.obtener());
        JPanel columnaDerecha = new JPanel();
        columnaDerecha.setLayout(new BoxLayout(columnaDerecha, 1));
        columnaDerecha.setBackground(this.colorFondo.obtener());
        LinkedHashMap<String, String> idiomas = new LinkedHashMap<String, String>();
        idiomas.put("Espa\u00f1ol", "imagenes/bandera_mexico.png");
        idiomas.put("English", "imagenes/bandera_inglaterra.png");
        idiomas.put("\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "imagenes/bandera_arabia.png");
        idiomas.put("Portugu\u00eas", "imagenes/bandera_brasil.png");
        idiomas.put("\u0641\u0627\u0631\u0633\u06cc", "imagenes/bandera_iran.png");
        idiomas.put("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "imagenes/bandera_rusia.png");
        idiomas.put("\u7b80\u4f53\u4e2d\u6587", "imagenes/bandera_china.png");
        idiomas.put("Esperanto", "imagenes/bandera_esperanto.png");
        idiomas.put("\u65e5\u672c\u8a9e", "imagenes/bandera_japon.png");
        idiomas.put("\ud55c\uad6d\uc5b4", "imagenes/bandera_corea.png");
        ComboIdiomasConIcono comboIdioma = new ComboIdiomasConIcono(idiomas);
        comboIdioma.setMaximumSize(new Dimension(200, 30));
        comboIdioma.setPreferredSize(new Dimension(200, 30));
        if (!CrashDetectorGUI.esMac()) {
            comboIdioma.setBackground(this.colorBoton.obtener());
            comboIdioma.setForeground(this.colorTexto.obtener());
        }
        switch (codigoActual = MonitorDePID.idioma.codigo()) {
            case "es": {
                comboIdioma.setSelectedItem("Espa\u00f1ol");
                break;
            }
            case "en": {
                comboIdioma.setSelectedItem("English");
                break;
            }
            case "ar": {
                comboIdioma.setSelectedItem("\u0627\u0644\u0639\u0631\u0628\u064a\u0629");
                break;
            }
            case "pt": {
                comboIdioma.setSelectedItem("Portugu\u00eas");
                break;
            }
            case "fa": {
                comboIdioma.setSelectedItem("\u0641\u0627\u0631\u0633\u06cc");
                break;
            }
            case "ru": {
                comboIdioma.setSelectedItem("\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
                break;
            }
            case "zh": {
                comboIdioma.setSelectedItem("\u7b80\u4f53\u4e2d\u6587");
                break;
            }
            case "eo": {
                comboIdioma.setSelectedItem("Esperanto");
                break;
            }
            case "ja": {
                comboIdioma.setSelectedItem("\u65e5\u672c\u8a9e");
                break;
            }
            case "ko": {
                comboIdioma.setSelectedItem("\ud55c\uad6d\uc5b4");
                break;
            }
            default: {
                comboIdioma.setSelectedItem("Espa\u00f1ol");
            }
        }
        JCheckBox chkIdiomaSistema = new JCheckBox(MonitorDePID.idioma.usarIdiomaDelSistema());
        chkIdiomaSistema.setForeground(this.colorTexto.obtener());
        chkIdiomaSistema.setBackground(this.colorFondo.obtener());
        chkIdiomaSistema.setOpaque(false);
        chkIdiomaSistema.setHorizontalAlignment(2);
        chkIdiomaSistema.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        chkIdiomaSistema.setMaximumSize(new Dimension(200, 30));
        boolean existePreferencia = Files.exists(Idioma.archivo.toPath(), new LinkOption[0]);
        boolean usarSistemaInicial = !existePreferencia;
        chkIdiomaSistema.setSelected(usarSistemaInicial);
        comboIdioma.setEnabled(!usarSistemaInicial);
        comboIdioma.addActionListener(e -> {
            chkIdiomaSistema.setSelected(false);
            comboIdioma.setEnabled(true);
            String seleccion = (String)comboIdioma.getSelectedItem();
            String codigo = this.obtenerCodigoIdioma(seleccion);
            if (codigo != null) {
                try {
                    ConfigMundial.obtenerInstancia().guardarIdioma(codigo);
                }
                catch (Exception ex) {
                    CrashDetectorLogger.logException(ex);
                }
                MonitorDePID.idioma = Idioma.detectar();
                this.recargar();
            }
        });
        chkIdiomaSistema.addActionListener(e -> {
            boolean usarSistema = chkIdiomaSistema.isSelected();
            comboIdioma.setEnabled(!usarSistema);
            if (usarSistema) {
                try {
                    Files.deleteIfExists(Idioma.archivo.toPath());
                    ConfigMundial.obtenerInstancia().borrarIdioma();
                }
                catch (IOException ex) {
                    CrashDetectorLogger.logException(ex);
                }
                MonitorDePID.idioma = Idioma.detectar();
                this.recargar();
            } else {
                String seleccion = (String)comboIdioma.getSelectedItem();
                String codigo = this.obtenerCodigoIdioma(seleccion);
                if (codigo != null) {
                    try {
                        ConfigMundial.obtenerInstancia().guardarIdioma(codigo);
                    }
                    catch (Exception ex) {
                        CrashDetectorLogger.logException(ex);
                    }
                    MonitorDePID.idioma = Idioma.detectar();
                    this.recargar();
                }
            }
        });
        columnaIzquierda.add(comboIdioma);
        columnaIzquierda.add(chkIdiomaSistema);
        LinkedHashMap<String, App> etiquetasAApp = new LinkedHashMap<String, App>();
        LinkedHashMap<String, String> etiquetasAIcono = new LinkedHashMap<String, String>();
        Function<App, String> etiquetaParaApp = a -> {
            if (a == null || a.id() == null || a.id().trim().isEmpty()) {
                return "Minecraft";
            }
            String id = a.id().trim();
            if ("minecraft".equalsIgnoreCase(id)) {
                return "Minecraft";
            }
            if ("dangerzone".equalsIgnoreCase(id)) {
                return "DangerZone";
            }
            if ("live2d_cubism".equalsIgnoreCase(id)) {
                return "Live2D Cubism";
            }
            if ("unciv".equalsIgnoreCase(id)) {
                return "Unciv";
            }
            if ("nxopen".equalsIgnoreCase(id)) {
                return "NX Open";
            }
            if ("teamcenter".equalsIgnoreCase(id)) {
                return "Teamcenter";
            }
            return Character.toUpperCase(id.charAt(0)) + id.substring(1);
        };
        Function<App, Boolean> appConIconoCD = a -> {
            if (a == null || a.id() == null) {
                return false;
            }
            String id = a.id().trim().toLowerCase();
            return id.equals("minecraft") || id.equals("dangerzone") || id.equals("live2d_cubism") || id.equals("unciv") || id.equals("nxopen") || id.equals("teamcenter");
        };
        Function<App, App> normalizarApp = a -> {
            if (a == null) {
                return App.MINECRAFT;
            }
            String id = a.id();
            if (id == null || id.trim().isEmpty()) {
                return App.MINECRAFT;
            }
            return a;
        };
        for (App a2 : App.APPS) {
            App norm = normalizarApp.apply(a2);
            String etiqueta = etiquetaParaApp.apply(norm);
            if (etiquetasAApp.containsKey(etiqueta)) continue;
            etiquetasAApp.put(etiqueta, norm);
            if (appConIconoCD.apply(norm).booleanValue()) {
                etiquetasAIcono.put(etiqueta, "imagenes/cd_chars.png");
                continue;
            }
            etiquetasAIcono.put(etiqueta, null);
        }
        if (etiquetasAApp.isEmpty()) {
            etiquetasAApp.put("Minecraft", App.MINECRAFT);
            etiquetasAIcono.put("Minecraft", "imagenes/cd_chars.png");
        }
        ComboIdiomasConIcono comboAplicacion = new ComboIdiomasConIcono(etiquetasAIcono);
        comboAplicacion.setMaximumSize(new Dimension(200, 30));
        comboAplicacion.setPreferredSize(new Dimension(200, 30));
        if (!CrashDetectorGUI.esMac()) {
            comboAplicacion.setBackground(this.colorBoton.obtener());
            comboAplicacion.setForeground(this.colorTexto.obtener());
        }
        JCheckBox chkDetectarAuto = new JCheckBox("Detectar autom\u00e1ticamente");
        chkDetectarAuto.setForeground(this.colorTexto.obtener());
        chkDetectarAuto.setBackground(this.colorFondo.obtener());
        chkDetectarAuto.setOpaque(false);
        chkDetectarAuto.setHorizontalAlignment(2);
        chkDetectarAuto.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        chkDetectarAuto.setMaximumSize(new Dimension(200, 30));
        chkDetectarAuto.setSelected(true);
        comboAplicacion.setEnabled(false);
        Statics.APP = detectada = normalizarApp.apply(App.obtenerApp());
        String etiquetaDetectada = etiquetaParaApp.apply(detectada);
        comboAplicacion.setSelectedItem(etiquetaDetectada);
        comboAplicacion.addActionListener(e -> {
            if (chkDetectarAuto.isSelected()) {
                return;
            }
            String etiquetaSel = (String)comboAplicacion.getSelectedItem();
            App seleccionada = (App)etiquetasAApp.get(etiquetaSel);
            Statics.APP = seleccionada = (App)normalizarApp.apply(seleccionada);
            comboAplicacion.setSelectedItem(etiquetaParaApp.apply(seleccionada));
            this.recargar();
        });
        chkDetectarAuto.addActionListener(e -> {
            boolean auto = chkDetectarAuto.isSelected();
            comboAplicacion.setEnabled(!auto);
            if (auto) {
                App autodetect;
                Statics.APP = autodetect = (App)normalizarApp.apply(Entregar.app_detecta);
                comboAplicacion.setSelectedItem(etiquetaParaApp.apply(autodetect));
                this.recargar();
            } else {
                String etiquetaSel = (String)comboAplicacion.getSelectedItem();
                App seleccionada = (App)etiquetasAApp.get(etiquetaSel);
                Statics.APP = seleccionada = (App)normalizarApp.apply(seleccionada);
                comboAplicacion.setSelectedItem(etiquetaParaApp.apply(seleccionada));
                this.recargar();
            }
        });
        columnaDerecha.add(comboAplicacion);
        columnaDerecha.add(chkDetectarAuto);
        panelHorizontal.add(columnaIzquierda);
        panelHorizontal.add(Box.createHorizontalStrut(20));
        panelHorizontal.add(columnaDerecha);
        seccionConfiguracion.add(panelHorizontal);
        int ANCHO_CONTROLES = 220;
        int ALTO_CONTROLES = 30;
        comboIdioma.setPreferredSize(new Dimension(220, 30));
        comboIdioma.setMaximumSize(new Dimension(220, 30));
        comboIdioma.setAlignmentX(0.0f);
        chkIdiomaSistema.setPreferredSize(new Dimension(220, 30));
        chkIdiomaSistema.setMaximumSize(new Dimension(220, 30));
        chkIdiomaSistema.setAlignmentX(0.0f);
        chkIdiomaSistema.setBorder(new EmptyBorder(6, 0, 0, 0));
        comboAplicacion.setPreferredSize(new Dimension(220, 30));
        comboAplicacion.setMaximumSize(new Dimension(220, 30));
        comboAplicacion.setAlignmentX(0.0f);
        chkDetectarAuto.setPreferredSize(new Dimension(220, 30));
        chkDetectarAuto.setMaximumSize(new Dimension(220, 30));
        chkDetectarAuto.setAlignmentX(0.0f);
        chkDetectarAuto.setBorder(new EmptyBorder(6, 0, 0, 0));
        columnaIzquierda.setAlignmentX(0.0f);
        columnaDerecha.setAlignmentX(0.0f);
        chkDetectarAuto.setSelected(true);
        JButton botonQuickFix = new JButton("QuickFix");
        botonQuickFix.setEnabled(MonitorDePID.analizador.obtenerSoluciones().size() > 0);
        botonQuickFix.setAlignmentX(0.5f);
        botonQuickFix.setMinimumSize(new Dimension(120, 30));
        botonQuickFix.setMaximumSize(new Dimension(180, 40));
        botonQuickFix.setPreferredSize(new Dimension(150, 30));
        if (CrashDetectorGUI.esMac()) {
            botonQuickFix.setContentAreaFilled(false);
        } else {
            botonQuickFix.setFont(botonQuickFix.getFont().deriveFont(1, 16.0f));
            botonQuickFix.setBackground(this.colorBoton.obtener());
            botonQuickFix.setForeground(this.colorTexto.obtener());
            botonQuickFix.setContentAreaFilled(true);
            botonQuickFix.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        }
        botonQuickFix.addActionListener(e -> this.mostrarVentanaQuickFix());
        JPanel panelBotonesDerecha = new JPanel(new GridLayout(1, 5, 10, 10));
        panelBotonesDerecha.setBackground(this.colorFondo.obtener());
        JButton boton_CDMods = this.a\u00f1adirBotonImagen(panelBotonesDerecha, Statics.carpeta.resolve("imagenes/boton_cdmods.png").toString(), "CD Mods");
        JButton btnAgregar = this.a\u00f1adirBotonImagen(panelBotonesDerecha, Statics.carpeta.resolve("imagenes/boton_agregar.png").toString(), MonitorDePID.idioma.anadirRegistro());
        JButton btnCompartir = this.a\u00f1adirBotonImagen(panelBotonesDerecha, Statics.carpeta.resolve("imagenes/boton_compartir.png").toString(), MonitorDePID.idioma.botonDeCompartirInforme());
        JButton btnActualizar = this.a\u00f1adirBotonImagen(panelBotonesDerecha, Statics.carpeta.resolve("imagenes/boton_actualizar.png").toString(), MonitorDePID.idioma.actualizar());
        JButton btnArchivos = this.a\u00f1adirBotonImagen(panelBotonesDerecha, Statics.carpeta.resolve("imagenes/boton_archivos.png").toString(), MonitorDePID.idioma.abrirCarpeta());
        this.botonConfiguracion = this.a\u00f1adirBotonImagen(panelBotonesDerecha, Statics.carpeta.resolve("imagenes/boton_config.png").toString(), MonitorDePID.idioma.config());
        DialogoCompartir comp = TipoGUI.DIALOGO_COMPARTIR.obtenerGUIPredeterminado(DialogoCompartirLegacy.ID, () -> new DialogoCompartirLegacy());
        btnCompartir.addActionListener(e -> comp.preperar(this.tiempoFallo));
        btnActualizar.addActionListener(e -> this.recargar());
        btnAgregar.addActionListener(e -> this.anadirRegistro());
        btnArchivos.addActionListener(e -> PrincipalGUIEstiloLanzer.abrirDirectorioEnExplorador());
        this.botonConfiguracion.addActionListener(e -> {
            this.contenidoPrincipal.removeAll();
            this.panelConfiguracion.constructir(this);
            this.contenidoPrincipal.add((Component)this.panelConfiguracion, "Center");
            this.contenidoPrincipal.revalidate();
            this.contenidoPrincipal.repaint();
            this.botonVolver.setEnabled(true);
        });
        boton_CDMods.addActionListener(e -> {
            this.contenidoPrincipal.removeAll();
            this.panelCDMods.init();
            this.contenidoPrincipal.add((Component)this.panelCDMods, "Center");
            this.contenidoPrincipal.revalidate();
            this.contenidoPrincipal.repaint();
            this.botonVolver.setEnabled(true);
        });
        panelInferior.add((Component)seccionConfiguracion, "West");
        panelInferior.add((Component)botonQuickFix, "Center");
        panelInferior.add((Component)panelBotonesDerecha, "East");
        JPanel barraLateralDerecha = new JPanel();
        barraLateralDerecha.setLayout(new BoxLayout(barraLateralDerecha, 1));
        barraLateralDerecha.setBackground(this.colorBoton.obtener().darker());
        barraLateralDerecha.setPreferredSize(new Dimension(230, 0));
        JLabel logoLabel = new JLabel();
        logoLabel.setBackground(this.colorBoton.obtener().darker());
        logoLabel.setOpaque(true);
        ImageIcon logoIcon = new ImageIcon(Statics.carpeta.resolve("imagenes/cd_logo.png").toString());
        Image logoImg = logoIcon.getImage();
        Image logoEscalado = logoImg.getScaledInstance(120, -1, 4);
        logoLabel.setIcon(new ImageIcon(logoEscalado));
        logoLabel.setAlignmentX(0.5f);
        logoLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.estilizarBoton(this.botonVolver);
        this.botonVolver.setEnabled(false);
        this.botonVolver.setAlignmentX(0.5f);
        this.botonVolver.addActionListener(e -> this.volver());
        barraLateralDerecha.add(logoLabel);
        barraLateralDerecha.add(this.botonVolver);
        barraLateralDerecha.add(Box.createVerticalStrut(10));
        for (Map.Entry<BiMap.DoubleKey<TipoGUI<? extends BotonDeBarraLateralDerecha>, String>, Supplier<BotonDeBarraLateralDerecha>> sup : PrincipalGUI.botons_de_barra_lateral_derecha.entrySet()) {
            CrashDetectorLogger.log("registrando boton");
            String id_predeterminado = (String)sup.getKey().key1;
            CrashDetectorLogger.log(id_predeterminado + "pre");
            TipoGUI tipo = (TipoGUI)sup.getKey().key0;
            Supplier<BotonDeBarraLateralDerecha> gui_predeterminado = sup.getValue();
            BotonDeBarraLateralDerecha b = tipo.obtenerGUIPredeterminado(id_predeterminado, gui_predeterminado);
            CrashDetectorLogger.log(b.id() + "obtene");
            JButton btn = new JButton(tipo.etiquetaDelBoton());
            if (tipo.icon() != null) {
                btn.setIcon(tipo.icon());
            }
            CrashDetectorLogger.log(b.id() + "icon y txt");
            this.botons_de_barra_lateral_derecha_initalizado.put(b, btn);
            CrashDetectorLogger.log(b.id() + "init boton");
            this.estilizarBoton(btn);
            btn.setAlignmentX(0.5f);
            btn.addActionListener(e -> b.init());
            barraLateralDerecha.add(btn);
            CrashDetectorLogger.log(b.id() + "agrearboton");
        }
        CrashDetectorLogger.log("Completa con botones");
        this.setLayout(new BorderLayout(5, 5));
        this.contenidoPrincipal.add((Component)this.scrollPane, "Center");
        this.add((Component)this.contenidoPrincipal, "Center");
        this.add((Component)panelInferior, "South");
        this.add((Component)barraLateralDerecha, "East");
        this.setTitle(Config.obtenerInstancia().obtenerNombreCD());
        this.setSize(1050, 650);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void recargarApariencia() {
        Component[] subComponents;
        Component barraLateral;
        Component panelInferior;
        Color fondo = this.colorFondo.obtener();
        Color texto = this.colorTexto.obtener();
        Color boton = this.colorBoton.obtener();
        Color cajaTexto = this.colorCajaTexto.obtener();
        Color enlace = this.colorEnlace.obtener();
        this.getContentPane().setBackground(fondo);
        this.contenidoPrincipal.setBackground(fondo);
        this.pantalla.setForeground(texto);
        this.pantalla.setCaretColor(texto);
        this.botonVolver.setForeground(texto);
        this.botonVolver.setBackground(boton);
        this.scrollPane.getViewport().setBackground(cajaTexto);
        this.pantalla.setForeground(enlace);
        Component[] components = this.getContentPane().getComponents();
        if (components.length > 1 && (panelInferior = components[1]) instanceof JPanel) {
            panelInferior.setBackground(fondo);
            for (Component comp : ((JPanel)panelInferior).getComponents()) {
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setBackground(fondo);
                }
                if (!(comp instanceof JPanel)) continue;
                for (Component innerComp : ((JPanel)comp).getComponents()) {
                    if (!(innerComp instanceof JComponent)) continue;
                    ((JComponent)innerComp).setBackground(fondo);
                }
            }
        }
        if (components.length > 2 && (barraLateral = components[2]) instanceof JPanel) {
            barraLateral.setBackground(boton.darker());
        }
        if (components.length > 1 && components[1] instanceof JPanel && (subComponents = ((Container)(panelInferior = (JPanel)components[1])).getComponents()).length > 2 && subComponents[2] instanceof JPanel) {
            JPanel panelBotonesDerecha = (JPanel)subComponents[2];
            for (Component comp : panelBotonesDerecha.getComponents()) {
                if (!(comp instanceof JButton)) continue;
                JButton btn = (JButton)comp;
                btn.setBackground(fondo);
                btn.setForeground(texto);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        this.colorTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        this.colorBoton.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBoton());
        this.colorCajaTexto.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorCajaTexto());
        this.colorEnlace.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorEnlace());
        elementos.add(this.colorFondo);
        elementos.add(this.colorTexto);
        elementos.add(this.colorBoton);
        elementos.add(this.colorCajaTexto);
        elementos.add(this.colorEnlace);
        return elementos;
    }
}

