/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.quickfix;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ElementoQuickFix
extends JPanel {
    private final JCheckBox checkBoxRetener = new JCheckBox();

    public ElementoQuickFix(QuickFix quickFix) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel panelPrincipal = new JPanel();
        panelPrincipal.setLayout(new BoxLayout(panelPrincipal, 1));
        panelPrincipal.setOpaque(false);
        JLabel etiquetaPrincipal = new JLabel(quickFix.etiqueta);
        etiquetaPrincipal.setFont(etiquetaPrincipal.getFont().deriveFont(1, 14.0f));
        etiquetaPrincipal.setAlignmentX(0.0f);
        if (!CrashDetectorGUI.esMac()) {
            etiquetaPrincipal.setForeground(Config.convertirAColor(Config.obtenerInstancia().obtenerColorTitulo()));
            etiquetaPrincipal.setFont(new Font("Segoe UI", 0, 14));
            etiquetaPrincipal.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        }
        panelPrincipal.add(etiquetaPrincipal);
        JPanel panelComponentes = new JPanel();
        panelComponentes.setLayout(new BoxLayout(panelComponentes, 1));
        panelComponentes.setOpaque(false);
        if (quickFix.tieneCheckbox) {
            JPanel panelRetener = new JPanel();
            panelRetener.setLayout(new FlowLayout(0, 5, 0));
            panelRetener.setOpaque(false);
            panelRetener.add(new JLabel("Retener:"));
            panelRetener.add(this.checkBoxRetener);
            panelComponentes.add(panelRetener);
            this.checkBoxRetener.addItemListener(e -> {
                quickFix.tieneMantener = this.checkBoxRetener.isSelected();
            });
        }
        for (QuickFix.ComponenteGUI componente : quickFix.componentes) {
            JComponent comp = componente.crearComponente(() -> quickFix.tieneMantener);
            Dimension prefSize = comp.getPreferredSize();
            comp.setAlignmentX(0.0f);
            if (comp instanceof JButton) {
                JButton button = (JButton)comp;
                button.setHorizontalAlignment(2);
                button.setMaximumSize(new Dimension(Integer.MAX_VALUE, prefSize.height));
            } else {
                comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, prefSize.height));
            }
            panelComponentes.add(comp);
            panelComponentes.add(Box.createVerticalStrut(5));
        }
        panelPrincipal.add(panelComponentes);
        this.add((Component)panelPrincipal, "North");
    }
}

