/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.quickfix;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.QuickFixGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ElementoQuickFixDemonSlayers
extends QuickFixGUI {
    private static final long serialVersionUID = 1L;
    public static final String ID = "demonslayers_elemento";
    public ConfigColor colorFondoDemon = ConfigColor.de("quickfix_demonslayers_fondo", new Color(0));
    public ConfigColor colorTextoDemon = ConfigColor.de("quickfix_demonslayers_texto", new Color(0xFFFFFF));
    public ConfigColor colorBordeDemon = ConfigColor.de("quickfix_demonslayers_borde", new Color(0xFF0000));
    public ConfigColor colorResaltadoDemon = ConfigColor.de("quickfix_demonslayers_resaltado", new Color(0xFFFF00));
    public ConfigColor colorImagenFondo = ConfigColor.de("quickfix_demonslayers_imagen_fondo", new Color(0x1A1A1A));
    private JLabel etiquetaImagenDecorativa;

    public ElementoQuickFixDemonSlayers() {
        this.setTitle("DemonSlayers - QuickFix");
    }

    @Override
    protected Component crearContenido(QuickFix fix) {
        if (fix == null) {
            return this.crearEtiquetaFallback("(QuickFix nulo)");
        }
        int WRAP_WIDTH = 350;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(true);
        panel.setBackground(this.colorFondoDemon.obtener());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
        JLabel titulo = new JLabel(ElementoQuickFixDemonSlayers.wrapHtml(fix.etiqueta, 350));
        titulo.setAlignmentX(0.0f);
        titulo.setForeground(this.colorTextoDemon.obtener());
        titulo.setFont(titulo.getFont().deriveFont(14.0f).deriveFont(1));
        panel.add(titulo);
        JPanel separador = new JPanel();
        separador.setMaximumSize(new Dimension(Integer.MAX_VALUE, 2));
        separador.setOpaque(true);
        separador.setBackground(this.colorBordeDemon.obtener());
        separador.setAlignmentX(0.0f);
        panel.add(separador);
        for (QuickFix.ComponenteGUI comp : fix.componentes) {
            JComponent jcomp = comp.crearComponente(() -> fix.tieneMantener);
            jcomp.setAlignmentX(0.0f);
            if (jcomp instanceof JLabel) {
                JLabel lbl = (JLabel)jcomp;
                lbl.setForeground(this.colorTextoDemon.obtener());
                lbl.setText(ElementoQuickFixDemonSlayers.wrapHtml(lbl.getText(), 350));
            }
            panel.add(jcomp);
        }
        int[] dims = this.dimensionesImagenDecorativa();
        this.etiquetaImagenDecorativa = this.crearEtiquetaImagenEscalada(this.rutaImagenDecorativa(), dims[0], dims[1]);
        if (this.etiquetaImagenDecorativa != null) {
            JPanel panelImagen = new JPanel();
            panelImagen.setLayout(new BoxLayout(panelImagen, 1));
            panelImagen.setOpaque(true);
            panelImagen.setBackground(this.colorImagenFondo.obtener());
            panelImagen.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
            this.etiquetaImagenDecorativa.setAlignmentX(0.5f);
            panelImagen.add(this.etiquetaImagenDecorativa);
            panel.add(panelImagen);
        }
        return panel;
    }

    private static String wrapHtml(String text, int widthPx) {
        if (text == null) {
            return "";
        }
        return "<html><body style='width:" + widthPx + "px'>" + text + "</body></html>";
    }

    private JLabel crearEtiquetaFallback(String texto) {
        JLabel lbl = new JLabel(ElementoQuickFixDemonSlayers.wrapHtml(texto, 350));
        lbl.setForeground(Color.WHITE);
        lbl.setOpaque(true);
        lbl.setBackground(Color.BLACK);
        lbl.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
        return lbl;
    }

    @Override
    protected void aplicarApariencia() {
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void aplicarAparienciaBase() {
        super.aplicarAparienciaBase();
        this.panelContenido.setOpaque(true);
        this.panelContenido.setBackground(this.colorFondoDemon.obtener());
    }

    @Override
    protected String rutaImagenDecorativa() {
        return Statics.carpeta.resolve("imagenes/demonslayers.png").toString();
    }

    @Override
    protected int[] dimensionesImagenDecorativa() {
        return new int[]{128, 128};
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorFondoDemon.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondo());
        elementos.add(this.colorFondoDemon);
        this.colorTextoDemon.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorTexto());
        elementos.add(this.colorTextoDemon);
        this.colorBordeDemon.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorBorde());
        elementos.add(this.colorBordeDemon);
        this.colorResaltadoDemon.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colResultado());
        elementos.add(this.colorResaltadoDemon);
        this.colorImagenFondo.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorFondoVentana());
        elementos.add(this.colorImagenFondo);
        return elementos;
    }
}

