/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.quickfix;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.TodosQuickFixesGUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelQuickFixDemonSlayers
extends TodosQuickFixesGUI {
    private static final long serialVersionUID = 1L;
    public static String ID = "demonslayers";
    ConfigColor colorSeparador = ConfigColor.de("quickfix_demonslayers_separador", Color.LIGHT_GRAY);

    public PanelQuickFixDemonSlayers() {
        this.inicializarUI();
    }

    private void inicializarUI() {
        this.panelContenedor = new JPanel();
        this.panelContenedor.setLayout(new BoxLayout(this.panelContenedor, 1));
        this.panelContenedor.setOpaque(false);
        this.panelContenedor.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getViewport().setOpaque(false);
        this.setOpaque(false);
        this.setViewportView(this.panelContenedor);
        this.getVerticalScrollBar().setUnitIncrement(16);
        this.piePanel = new JPanel();
        this.piePanel.setOpaque(false);
        this.piePanel.setLayout(new BoxLayout(this.piePanel, 1));
        this.piePanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        JLabel imagen = this.crearEtiquetaImagenEscalada(this.rutaImagenPie(), this.anchoImagenPie(), this.altoImagenPie());
        if (imagen != null) {
            imagen.setAlignmentX(0.5f);
            this.piePanel.add(imagen);
        } else {
            JLabel placeholder = new JLabel(this.textoFallbackImagen());
            placeholder.setAlignmentX(0.5f);
            this.piePanel.add(placeholder);
        }
        this.panelContenedor.add(this.piePanel);
        this.aplicarApariencia();
    }

    @Override
    protected String rutaImagenPie() {
        return Statics.carpeta.resolve("imagenes/demonslayers.png").toString();
    }

    @Override
    protected int anchoImagenPie() {
        return 128;
    }

    @Override
    protected int altoImagenPie() {
        return 128;
    }

    @Override
    protected String textoFallbackImagen() {
        return "(No se pudo cargar demonslayers.png)";
    }

    @Override
    protected void aplicarApariencia() {
        this.getViewport().setOpaque(false);
        this.setOpaque(false);
        if (this.panelContenedor != null) {
            this.panelContenedor.setOpaque(false);
        }
        if (this.piePanel != null) {
            this.piePanel.setOpaque(false);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init() {
        this.setVisible(true);
    }

    @Override
    public List<ElementoConfig> obtenerElementosConfigs() {
        ArrayList<ElementoConfig> elementos = new ArrayList<ElementoConfig>();
        this.colorSeparador.establecerNombreParaMostrar(() -> MonitorDePID.idioma.colorSeparador());
        elementos.add(this.colorSeparador);
        return elementos;
    }
}

