/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.quickfix;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class QuickFixGUI
extends JFrame
implements CrashDetectorGUI {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<QuickFixGUI>> GUIS = new HashMap<String, Supplier<QuickFixGUI>>();
    protected QuickFix quickFixActual;
    protected Component contenidoPrincipal;
    public ConfigColor colorFondo = ConfigColor.de("quickfix_fondo", Color.WHITE);
    public ConfigColor colorTexto = ConfigColor.de("quickfix_texto", Color.BLACK);
    public ConfigColor colorBorde = ConfigColor.de("quickfix_borde", Color.GRAY);
    public ConfigColor colorResaltado = ConfigColor.de("quickfix_resaltado", new Color(255, 230, 0));
    protected JPanel panelContenido;

    public QuickFixGUI() {
        this.setDefaultCloseOperation(2);
        this.panelContenido = new JPanel();
        this.add(this.panelContenido);
    }

    public void constructir(QuickFix fix) {
        if (fix == null) {
            CrashDetectorLogger.log("Advertencia: intento de construir QuickFixGUI con fix nulo");
            return;
        }
        this.quickFixActual = fix;
        this.panelContenido.removeAll();
        this.aplicarAparienciaBase();
        this.contenidoPrincipal = this.crearContenido(fix);
        if (this.contenidoPrincipal != null) {
            this.panelContenido.add(this.contenidoPrincipal);
        }
        this.aplicarApariencia();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public QuickFix obtenerQuickFixActual() {
        return this.quickFixActual;
    }

    protected abstract Component crearContenido(QuickFix var1);

    protected abstract void aplicarApariencia();

    protected abstract String rutaImagenDecorativa();

    protected abstract int[] dimensionesImagenDecorativa();

    protected void aplicarAparienciaBase() {
        this.panelContenido.setLayout(new BoxLayout(this.panelContenido, 1));
        this.panelContenido.setOpaque(true);
        this.panelContenido.setBorder(new EmptyBorder(8, 12, 8, 12));
    }

    protected JLabel crearEtiquetaImagenEscalada(String ruta, int ancho, int alto) {
        if (ruta == null || ruta.isEmpty()) {
            return null;
        }
        try {
            File archivo = new File(ruta);
            if (!archivo.exists() || !archivo.isFile()) {
                return null;
            }
            BufferedImage imagenOriginal = ImageIO.read(archivo);
            if (imagenOriginal == null) {
                return null;
            }
            Image imagenEscalada = imagenOriginal.getScaledInstance(ancho, alto, 4);
            JLabel etiqueta = new JLabel(new ImageIcon(imagenEscalada));
            etiqueta.setBorder(new EmptyBorder(4, 0, 4, 0));
            return etiqueta;
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error cargando imagen decorativa: " + ruta);
            return null;
        }
    }

    protected String formatearTexto(String texto) {
        if (texto == null || texto.trim().isEmpty()) {
            return "";
        }
        return texto;
    }

    @Override
    public final void init() {
        CrashDetectorLogger.log("Advertencia: llamada a init() en QuickFixGUI. Usar constructir(QuickFix).");
    }

    @Override
    public void recargarApariencia() {
        if (this.quickFixActual != null) {
            this.constructir(this.quickFixActual);
        } else {
            this.aplicarApariencia();
        }
    }

    @Override
    public TipoGUI<QuickFixGUI> tipo() {
        return TipoGUI.QUICKFIX;
    }

    @Override
    public abstract String id();
}

