/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.gui.tipos.quickfix;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.config.ConfigColor;
import com.asbestosstar.crashdetector.gui.CrashDetectorGUI;
import com.asbestosstar.crashdetector.gui.elementos.BotonDeBarraLateralDerecha;
import com.asbestosstar.crashdetector.gui.tipos.TipoGUI;
import com.asbestosstar.crashdetector.gui.tipos.quickfix.ElementoQuickFix;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public abstract class TodosQuickFixesGUI
extends JScrollPane
implements CrashDetectorGUI,
BotonDeBarraLateralDerecha {
    private static final long serialVersionUID = 1L;
    public static Map<String, Supplier<TodosQuickFixesGUI>> GUIS = new HashMap<String, Supplier<TodosQuickFixesGUI>>();
    protected JPanel panelContenedor;
    protected JPanel piePanel;
    public ConfigColor colorSeparador = ConfigColor.de("quickfix_separador", Color.LIGHT_GRAY);

    public void agregarQuickFix(QuickFix quickFix) {
        int idxPie;
        if (this.panelContenedor == null || this.piePanel == null) {
            CrashDetectorLogger.log("Error: panelContenedor o piePanel no inicializados.");
            return;
        }
        if (this.piePanel.getParent() != this.panelContenedor) {
            this.panelContenedor.add(this.piePanel);
        }
        if ((idxPie = this.panelContenedor.getComponentCount() - 1) > 0) {
            JSeparator separador = new JSeparator();
            separador.setForeground(this.colorSeparador.obtener());
            this.panelContenedor.add((Component)separador, idxPie);
            ++idxPie;
        }
        ElementoQuickFix elemento = new ElementoQuickFix(quickFix);
        this.panelContenedor.add((Component)elemento, idxPie);
        this.panelContenedor.revalidate();
        this.panelContenedor.repaint();
    }

    public void limpiar() {
        if (this.panelContenedor != null && this.piePanel != null) {
            this.panelContenedor.removeAll();
            this.panelContenedor.add(this.piePanel);
            this.panelContenedor.revalidate();
            this.panelContenedor.repaint();
        }
    }

    protected abstract String rutaImagenPie();

    protected int anchoImagenPie() {
        return 128;
    }

    protected int altoImagenPie() {
        return 128;
    }

    protected String textoFallbackImagen() {
        return "(No se pudo cargar la imagen)";
    }

    protected abstract void aplicarApariencia();

    protected JLabel crearEtiquetaImagenEscalada(String ruta, int w, int h) {
        if (ruta == null) {
            return null;
        }
        try {
            BufferedImage img = ImageIO.read(new File(ruta));
            if (img == null) {
                return null;
            }
            Image esc = img.getScaledInstance(w, h, 4);
            return new JLabel(new ImageIcon(esc));
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void recargarApariencia() {
        this.aplicarApariencia();
    }

    @Override
    public TipoGUI<TodosQuickFixesGUI> tipo() {
        return TipoGUI.TODOS_QUICKFIXES;
    }

    @Override
    public abstract String id();

    @Override
    public abstract void init();
}

