/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Arabe
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0645\u062c\u0644\u062f mods \u063a\u064a\u0631 \u0635\u0627\u0644\u062d</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0625\u064a\u062c\u0627\u062f \u0645\u0644\u0641 JAR \u0627\u0644\u062e\u0627\u0635 \u0628\u0640CrashDetector</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u0627\u0644\u0628\u062d\u062b \u0639\u0646 PID: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") \u0627\u0646\u062a\u0647\u0649!</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627 \u064a\u0648\u062c\u062f JVM</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0642\u062f \u064a\u0633\u0627\u0639\u062f\u0643 \u062a\u062d\u062f\u064a\u062b \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 ATI/AMD \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643. \u0627\u0642\u0631\u0623 \u0647\u0630\u0627 \u0627\u0644\u062f\u0644\u064a\u0644 \u0644\u062d\u0644 \u0627\u0644\u0645\u0634\u0643\u0644\u0629: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u062f\u0644\u064a\u0644 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062a\u0639\u0631\u064a\u0641\u0627\u062a</a> https://www.amd.com/es/support/download/drivers.html \u062a\u0646\u0632\u064a\u0644 </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0628\u0639\u0636 \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u062a\u0648\u0627\u062c\u0647 \u0623\u062d\u064a\u0627\u0646\u064b\u0627 \u0645\u0634\u0643\u0644\u0627\u062a \u0645\u0639 \u0648\u0627\u062c\u0647\u0629 \u062a\u062d\u0645\u064a\u0644 Nouveau \u0627\u0644\u0645\u0628\u0643\u0631\u0629.</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0647\u0646\u0627\u0643 \u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u062a\u0639\u0631\u064a\u0641\u0627\u062a \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643. \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 GPU/APU AMD/ATI\u060c \u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062b \u062a\u0639\u0631\u064a\u0641\u0627\u062a AMD. \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 NVIDIA\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0636\u0628\u0637 \u062c\u0645\u064a\u0639 \u062d\u0627\u0644\u0627\u062a javaw.exe \u0648\u0627\u0644\u0644\u0639\u0628\u0629 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629. \u0627\u0642\u0631\u0623 \u0647\u0630\u0627 \u0627\u0644\u062f\u0644\u064a\u0644: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u062f\u0644\u064a\u0644 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062a\u0639\u0631\u064a\u0641\u0627\u062a</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0634\u0644 \u062a\u062d\u0645\u064a\u0644 \u0646\u0627\u0641\u0630\u0629 FML \u0627\u0644\u0645\u0628\u0643\u0631\u0629. \u0644\u0625\u0635\u0644\u0627\u062d \u0647\u0630\u0627\u060c \u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 (.minecraft/config/fml.toml) \u0648\u0642\u0645 \u0628\u062a\u0639\u064a\u064a\u0646 earlyWindowProvider \u0625\u0644\u0649 \"none\". \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 Mac M1\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 Java ARM \u0648\u0644\u064a\u0633 Intel x64. \u0647\u0630\u0647 \u0645\u0634\u0643\u0644\u0629 \u0634\u0627\u0626\u0639\u0629 \u0623\u064a\u0636\u064b\u0627 \u0645\u0639 \u0627\u0644\u062a\u0639\u0631\u064a\u0641\u0627\u062a \u0627\u0644\u0642\u062f\u064a\u0645\u0629. \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 Windows \u0648\u0644\u0645 \u064a\u0641\u0644\u062d \u062a\u0639\u0637\u064a\u0644 \u0647\u0630\u0627 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u060c \u064a\u0631\u062c\u0649 \u0627\u0644\u0631\u062c\u0648\u0639 \u0625\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u062f\u0644\u064a\u0644: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u062f\u0644\u064a\u0644 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062a\u0639\u0631\u064a\u0641\u0627\u062a</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a \u0627\u0644\u0645\u0637\u0644\u0648\u0628\u0629 \u0645\u0641\u0642\u0648\u062f\u0629:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "\u0637\u0644\u0628 \u0628\u0648\u0627\u0633\u0637\u0629").replace("Expected range", "\u0627\u0644\u0646\u0637\u0627\u0642 \u0627\u0644\u0645\u062a\u0648\u0642\u0639") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u062a\u0642\u0631\u064a\u0631 CrashDetector \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0647\u0646\u0627 <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0639\u0631\u0636 \u0627\u0644\u062a\u0642\u0631\u064a\u0631</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u0647\u0630\u0647 \u0647\u064a \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0629 \u0644\u0640CrashDetector. \u0625\u0630\u0627 \u0623\u063a\u0644\u0642\u062a \u0627\u0644\u0644\u0639\u0628\u0629 \u0628\u0634\u0643\u0644 \u0637\u0628\u064a\u0639\u064a\u060c \u064a\u0631\u062c\u0649 \u062a\u062c\u0627\u0647\u0644 \u0647\u0630\u0647 \u0627\u0644\u0648\u0627\u062c\u0647\u0629.</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>\u0639\u0631\u0636 \u0627\u0644\u062a\u0642\u0631\u064a\u0631</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u0639\u0631\u0636 \u0627\u0644\u062a\u0642\u0631\u064a\u0631 \u0627\u0644\u0645\u062d\u0644\u064a \u0641\u064a \u0627\u0644\u0645\u062a\u0635\u0641\u062d.</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "\u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u062a\u0642\u0631\u064a\u0631";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "\u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u062a\u0642\u0631\u064a\u0631. \u0633\u064a\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 \u0633\u062c\u0644\u0627\u062a\u0643 \u0625\u0644\u0649 securelogger.net \u0648\u0627\u0644\u062a\u0642\u0631\u064a\u0631 \u0625\u0644\u0649 \u0645\u0648\u0627\u0642\u0639 \u0623\u062e\u0631\u0649.";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0645\u0644\u0641\u0627\u062a JAR \u0645\u0634\u0643\u0644\u0629 (\u0627\u0644\u0623\u0648\u0644\u0648\u064a\u0629 \u0644\u0644\u0640FATAL \u062b\u0645 \u0639\u0627\u0644\u064a\u0629 \u0648\u0645\u0646\u062e\u0641\u0636\u0629):</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> \u0627\u0644\u0645\u0633\u062a\u0648\u0649:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0625\u0645\u0643\u0627\u0646\u064a\u0629 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0642\u0627\u062a\u0644\u0627\u064b:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 ModID \u0645\u0634\u0643\u0644\u0629 (\u0627\u0644\u0623\u0648\u0644\u0648\u064a\u0629 \u0644\u0644\u0640FATAL \u062b\u0645 \u0639\u0627\u0644\u064a\u0629 \u0648\u0645\u0646\u062e\u0641\u0636\u0629):</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062d\u0632\u0645 \u0645\u0634\u0643\u0644\u0629 (\u0627\u0644\u0623\u0648\u0644\u0648\u064a\u0629 \u0644\u0644\u0640FATAL \u062b\u0645 \u0639\u0627\u0644\u064a\u0629 \u0648\u0645\u0646\u062e\u0641\u0636\u0629):</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0642\u0627\u062a\u0644\u0629 (FATAL)\u060c \u0648\u0647\u064a \u0645\u0634\u0643\u0644\u0629 \u062e\u0637\u064a\u0631\u0629. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u062a\u0634\u0645\u0644 CoreMods \u062a\u0627\u0644\u0641\u0629 \u0623\u0648 \u062a\u0628\u0639\u064a\u0627\u062a \u0642\u0627\u062a\u0644\u0629. \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 QuickFix \u0644\u0644\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0641\u0626\u0627\u062a \u0642\u0627\u062a\u0644\u0629. \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0642\u0627\u062a\u0644\u0629 \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629 \u0627\u0644\u062a\u064a \u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641\u0647\u0627:</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u062d\u062a\u0648\u0649 \u062f\u0627\u062e\u0644 {} (\u0627\u0644\u0623\u0647\u0645 \u0641\u064a \u0627\u0644\u0623\u0639\u0644\u0649\u060c \u064a\u0639\u0631\u0636 \u0623\u0648\u0644 20 \u0641\u0642\u0637):</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0643\u0648\u064a\u0646 SpongeMixin \u0645\u0634\u0643\u0644\u0629: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u062d\u0632\u0645 \u0645\u0643\u0631\u0631\u0629. \u064a\u0645\u0643\u0646\u0643 \u0625\u0635\u0644\u0627\u062d \u0647\u0630\u0627 \u0639\u0646 \u0637\u0631\u064a\u0642 \u062d\u0630\u0641 \u0627\u0644\u062d\u0632\u0645\u0629 (\u0627\u0644\u0645\u062c\u0644\u062f) \u0645\u0646 \u0645\u0644\u0641 \u0627\u0644\u0640 JAR\u060c \u064a\u0645\u0643\u0646\u0643 \u0641\u062a\u062d \u0645\u0644\u0641 \u0627\u0644\u0640 JAR \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0628\u0631\u0646\u0627\u0645\u062c \u0623\u0631\u0634\u064a\u0641 \u0645\u062b\u0644 WinRAR \u0623\u0648 7z\u060c \u0643\u0645\u0627 \u064a\u0645\u0643\u0646\u0643 \u0623\u064a\u0636\u064b\u0627 \u062a\u063a\u064a\u064a\u0631 \u0627\u0645\u062a\u062f\u0627\u062f \u0627\u0644\u0645\u0644\u0641 \u0645\u0646 .jar \u0625\u0644\u0649 zip \u062b\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u062c\u0644\u062f \u0648\u0645\u0646 \u062b\u0645 \u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u062a\u0647 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u0625\u0644\u0649 \u0645\u0644\u0641 .jar.</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 Mods \u0645\u0643\u0631\u0631\u0629</b> " + linea.replace("from mod files", "\u0645\u0646 \u0645\u0644\u0641\u0627\u062a mod");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge \u0627\u0643\u062a\u0634\u0641 mod \u0645\u0634\u0643\u0648\u0643 \u0641\u064a\u0647:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV \u064a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 lithostitched\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u062b\u0628\u064a\u062a\u0647 \u0645\u0646 \u0647\u0646\u0627: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 Iris shaders \u0623\u0648 Oculus\u060c \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0646 SODIUM \u0623\u0648 \u0645\u062d\u0645\u0644 \u0622\u062e\u0631 (Rubidium, Embedium, Bedium)</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u0627\u0645\u062a\u062f\u0627\u062f KubeJS </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0645\u0634\u0643\u0644\u0627\u062a \u0645\u0639 \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 NVIDIA \u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0633\u0627\u0628\u0642\u0629 \u0645\u0646 Windows 11.</span><br/><br/>\u0644\u0636\u0645\u0627\u0646 \u0623\u0646 Minecraft (\u0648\u0627\u0644\u0640 JVM \u0627\u0644\u062d\u0627\u0644\u064a\u0629) \u064a\u0633\u062a\u062e\u062f\u0645\u0627\u0646 \u0648\u062d\u062f\u0629 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a \u0627\u0644\u0645\u062e\u0635\u0635\u0629 NVIDIA\u060c \u0627\u062a\u0628\u0639 \u0627\u0644\u062e\u0637\u0648\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629:<br/><br/>1. <strong>\u062d\u062f\u062f \u0645\u0644\u0641 \u062a\u0646\u0641\u064a\u0630\u064a Java:</strong><br/>   - \u064a\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a \u0627\u0644\u062a\u0627\u0644\u064a \u0644\u0640 Java: " + this.obtenerRutaJava() + "<br/>   - \u0625\u0630\u0627 \u0644\u0645 \u062a\u0631\u064e \u0645\u0633\u0627\u0631\u064b\u0627 \u0645\u062d\u062f\u062f\u064b\u0627\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a \u0644\u0640 Java \u0628\u0627\u0644\u0628\u062d\u062b \u0639\u0646 'java.exe' \u0641\u064a \u0646\u0638\u0627\u0645\u0643.<br/><br/>2. <strong>\u0627\u0641\u062a\u062d \u0644\u0648\u062d\u0629 \u062a\u062d\u0643\u0645 NVIDIA:</strong><br/>   - \u0627\u0646\u0642\u0631 \u0628\u0632\u0631 \u0627\u0644\u0645\u0627\u0648\u0633 \u0627\u0644\u0623\u064a\u0645\u0646 \u0639\u0644\u0649 \u0633\u0637\u062d \u0627\u0644\u0645\u0643\u062a\u0628 \u0648\u062d\u062f\u062f '\u0644\u0648\u062d\u0629 \u062a\u062d\u0643\u0645 NVIDIA'.<br/><br/>3. <strong>\u0642\u0645 \u0628\u062a\u0643\u0648\u064a\u0646 \u0648\u062d\u062f\u0629 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a \u0627\u0644\u0645\u0641\u0636\u0644\u0629:</strong><br/>   - \u0641\u064a \u0644\u0648\u062d\u0629 \u062a\u062d\u0643\u0645 NVIDIA\u060c \u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 '\u0625\u062f\u0627\u0631\u0629 \u0625\u0639\u062f\u0627\u062f\u0627\u062a 3D'.<br/>   - \u062d\u062f\u062f \u062e\u064a\u0627\u0631 '\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0628\u0631\u0646\u0627\u0645\u062c \u0645\u062d\u062f\u062f'.<br/>   - \u0627\u0646\u0642\u0631 \u0639\u0644\u0649 '\u0625\u0636\u0627\u0641\u0629' \u0648\u0627\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a \u0644\u0640 Java \u0627\u0644\u0630\u064a \u062a\u0645 \u062a\u062d\u062f\u064a\u062f\u0647 \u0633\u0627\u0628\u0642\u064b\u0627 (\u0645\u062b\u0644: 'java.exe').<br/>   - \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0647 \u0645\u064f\u0639\u062f \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 '\u0645\u0639\u0627\u0644\u062c \u0639\u0627\u0644\u064a \u0627\u0644\u0623\u062f\u0627\u0621 (NVIDIA)'.<br/><br/>4. <strong>\u0627\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a:</strong><br/>   - \u0637\u0628\u0642 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0648\u0623\u063a\u0644\u0642 \u0644\u0648\u062d\u0629 \u062a\u062d\u0643\u0645 NVIDIA.<br/><br/>5. <strong>\u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 Minecraft:</strong><br/>   - \u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 Minecraft \u0644\u062a\u0635\u0628\u062d \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0646\u0627\u0641\u0630\u0629.<br/><br/>\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 Windows Server 2022 \u0623\u0648 Windows 10\u060c \u0641\u0625\u0646 \u0647\u0630\u0647 \u0627\u0644\u062e\u0637\u0648\u0627\u062a \u0635\u0627\u0644\u062d\u0629 \u0637\u0627\u0644\u0645\u0627 \u0644\u062f\u064a\u0643 \u0623\u062d\u062f\u062b \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 NVIDIA \u0645\u062b\u0628\u062a\u0629.<br/><br/>\u0645\u0644\u0627\u062d\u0638\u0629: \u0625\u0630\u0627 \u0644\u0645 \u062a\u062a\u0645\u0643\u0646 \u0645\u0646 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0644\u0648\u062d\u0629 \u062a\u062d\u0643\u0645 NVIDIA\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 NVIDIA \u0645\u062b\u0628\u062a\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0645\u0634\u0643\u0644\u0627\u062a \u0645\u0639 \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 NVIDIA \u0641\u064a Windows 11/Server 2025 \u0623\u0648 \u0623\u062d\u062f\u062b.</span><br/><br/>\u0644\u0636\u0645\u0627\u0646 \u0623\u0646 Minecraft (\u0648\u0627\u0644\u0640 JVM \u0627\u0644\u062d\u0627\u0644\u064a\u0629) \u064a\u0633\u062a\u062e\u062f\u0645\u0627\u0646 \u0648\u062d\u062f\u0629 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a \u0627\u0644\u0645\u062e\u0635\u0635\u0629 NVIDIA\u060c \u0627\u062a\u0628\u0639 \u0627\u0644\u062e\u0637\u0648\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629:<br/><br/>1. <strong>\u062d\u062f\u062f \u0645\u0644\u0641 \u062a\u0646\u0641\u064a\u0630\u064a Java:</strong><br/>   - \u064a\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a \u0627\u0644\u062a\u0627\u0644\u064a \u0644\u0640 Java: " + this.obtenerRutaJava() + "<br/>   - \u0625\u0630\u0627 \u0644\u0645 \u062a\u0631\u064e \u0645\u0633\u0627\u0631\u064b\u0627 \u0645\u062d\u062f\u062f\u064b\u0627\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a \u0644\u0640 Java \u0628\u0627\u0644\u0628\u062d\u062b \u0639\u0646 'java.exe' \u0641\u064a \u0646\u0638\u0627\u0645\u0643.<br/><br/>2. <strong>\u0627\u0641\u062a\u062d \u062a\u0637\u0628\u064a\u0642 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a:</strong><br/>   - \u0627\u0636\u063a\u0637 \u0639\u0644\u0649 \u0627\u0644\u0645\u0641\u0627\u062a\u064a\u062d <code>Win + I</code> \u0644\u0641\u062a\u062d \u062a\u0637\u0628\u064a\u0642 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a.<br/>   - \u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 <strong>\u0627\u0644\u0646\u0638\u0627\u0645 > \u0627\u0644\u0634\u0627\u0634\u0629 > \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a</strong>.<br/><br/>3. <strong>\u0642\u0645 \u0628\u062a\u0643\u0648\u064a\u0646 \u0648\u062d\u062f\u0629 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a \u0627\u0644\u0645\u0641\u0636\u0644\u0629:</strong><br/>   - \u0641\u064a \u0642\u0633\u0645 '\u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a', \u0627\u0646\u0642\u0631 \u0639\u0644\u0649 '\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629'.<br/>   - \u062d\u062f\u062f '\u062a\u0637\u0628\u064a\u0642\u0627\u062a \u0633\u0637\u062d \u0627\u0644\u0645\u0643\u062a\u0628' \u062b\u0645 \u0627\u0646\u0642\u0631 \u0639\u0644\u0649 '\u0627\u0633\u062a\u0639\u0631\u0627\u0636'.<br/>   - \u0627\u0628\u062d\u062b \u0648\u062d\u062f\u062f \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a \u0644\u0640 Java \u0627\u0644\u0630\u064a \u062a\u0645 \u062a\u062d\u062f\u064a\u062f\u0647 \u0633\u0627\u0628\u0642\u064b\u0627 (\u0645\u062b\u0644: 'java.exe').<br/>   - \u0628\u0645\u062c\u0631\u062f \u0627\u0644\u0625\u0636\u0627\u0641\u0629\u060c \u062d\u062f\u062f \u062a\u0637\u0628\u064a\u0642 Java \u0641\u064a \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0648\u0642\u0645 \u0628\u062a\u0643\u0648\u064a\u0646\u0647 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 '\u0627\u0644\u0623\u062f\u0627\u0621 \u0627\u0644\u0639\u0627\u0644\u064a (NVIDIA)'.<br/><br/>4. <strong>\u0627\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a:</strong><br/>   - \u0637\u0628\u0642 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0648\u0623\u063a\u0644\u0642 \u062a\u0637\u0628\u064a\u0642 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a.<br/><br/>5. <strong>\u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 Minecraft:</strong><br/>   - \u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 Minecraft \u0644\u062a\u0635\u0628\u062d \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0646\u0627\u0641\u0630\u0629.<br/><br/>\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 Windows 11 \u0623\u0648 Windows Server 2025+\u060c \u0641\u0625\u0646 \u0647\u0630\u0647 \u0627\u0644\u062e\u0637\u0648\u0627\u062a \u0635\u0627\u0644\u062d\u0629 \u0637\u0627\u0644\u0645\u0627 \u0644\u062f\u064a\u0643 \u0623\u062d\u062f\u062b \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 NVIDIA \u0645\u062b\u0628\u062a\u0629.<br/><br/>\u0645\u0644\u0627\u062d\u0638\u0629: \u0625\u0630\u0627 \u0644\u0645 \u062a\u062a\u0645\u0643\u0646 \u0645\u0646 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u062e\u064a\u0627\u0631 \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 NVIDIA \u0645\u062b\u0628\u062a\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0627\u062f\u0645\u0643 \u0623\u0648 \u0639\u0627\u0644\u0645\u0643 \u0644\u062f\u064a\u0647 \u062aicks \u062a\u062a\u062c\u0627\u0648\u0632 60 \u062b\u0627\u0646\u064a\u0629. \u0642\u062f \u064a\u0643\u0648\u0646 \u0630\u0644\u0643 \u0628\u0633\u0628\u0628 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0628\u0637\u0626 \u0627\u0644\u062e\u0627\u062f\u0645 \u0623\u0648 \u0623\u0646 \u0627\u0644\u0623\u062c\u0647\u0632\u0629 \u0636\u0639\u064a\u0641\u0629 \u062c\u062f\u064b\u0627.</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627 \u062a\u0645\u0644\u0643 \u0630\u0627\u0643\u0631\u0629 RAM/\u0630\u0627\u0643\u0631\u0629 \u0643\u0627\u0641\u064a\u0629. \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u062a\u062e\u0635\u064a\u0635 \u0627\u0644\u0645\u0632\u064a\u062f.</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u064a\u0648\u0627\u062c\u0647 Theseus \u0623\u064a\u0636\u064b\u0627 \u0645\u0634\u0627\u0643\u0644 \u0623\u062e\u0631\u0649\u060c \u0628\u0645\u0627 \u0641\u064a \u0630\u0644\u0643 \u0641\u0634\u0644\u0647 \u0641\u064a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0639\u0646\u062f \u0645\u062d\u0627\u0648\u0644\u0629 \u0630\u0644\u0643. \u0625\u0630\u0627 \u0643\u0646\u062a \u0628\u062d\u0627\u062c\u0629 \u0625\u0644\u0649 \u062a\u0634\u063a\u064a\u0644 \u0645\u0644\u0641\u0627\u062a mrpack\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0634\u063a\u0644\u0627\u062a \u0623\u062e\u0631\u0649 \u0645\u062b\u0644 Prism Launcher (\u0645\u062e\u0635\u0635 \u0644\u0640 modrinth.com \u0641\u0642\u0637)\u060c ATLauncher (\u0645\u062e\u0635\u0635 \u0644\u0640 modrinth.com \u0641\u0642\u0637)\u060c \u0623\u0648 Hello Minecraft Launcher (\u064a\u062f\u0639\u0645 modrinth.com \u0648 bbsmc.net).</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u062e\u064a\u0627\u0631 \"\u062a\u062e\u0637\u064a \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0645\u0634\u063a\u0651\u0644\" (\u062a\u0637\u0628\u064a\u0642 CurseForge). \u0623\u062d\u064a\u0627\u0646\u064b\u0627 \u064a\u0633\u0628\u0628 \u0647\u0630\u0627 \u0645\u0634\u0627\u0643\u0644 \u064a\u0635\u0639\u0628 \u0627\u0643\u062a\u0634\u0627\u0641\u0647\u0627. \u064a\u0639\u0648\u062f \u0630\u0644\u0643 \u0625\u0644\u0649 \u062e\u064a\u0627\u0631 \"\u062a\u062e\u0637\u064a \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0645\u0634\u063a\u0651\u0644\" \u0641\u064a \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0642\u062f\u064a\u0645\u0629 \u0645\u0646 \u062a\u0637\u0628\u064a\u0642 CurseForge \u0623\u0648 \u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062c\u062f\u064a\u062f. \u0642\u0645 \u0628\u062a\u0639\u0637\u064a\u0644\u0647 \u0648\u0627\u0633\u062a\u062e\u062f\u0645 \u062e\u064a\u0627\u0631 \"Mojang Launcher\" \u0641\u064a \u0625\u0639\u062f\u0627\u062f\u0627\u062a CurseForge. \u064a\u0645\u0643\u0646\u0643 \u0645\u0634\u0627\u0647\u062f\u0629 \u0647\u0630\u0627 \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u0628\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0645\u0646 Claws of Berk (\u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 1:11) <a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>\u0647\u0646\u0627</a>.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u062a\u062d\u0630\u064a\u0631: \u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 (\u062a\u062d\u0630\u064a\u0631). \u0639\u0627\u062f\u0629\u064b \u0644\u064a\u0633\u062a \u062e\u0637\u064a\u0631\u0629\u060c \u0648\u0644\u0643\u0646\u0647\u0627 \u0642\u062f \u062a\u0633\u0628\u0628 \u0645\u0634\u0627\u0643\u0644 \u2014 \u062a\u062e\u062a\u0644\u0641 \u0639\u0646 \u0627\u0644\u0623\u062e\u0637\u0627\u0621 \u0627\u0644\u0642\u0627\u062a\u0644\u0629. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u062a\u0634\u0645\u0644 CoreMods \u062a\u0627\u0644\u0641\u0629 \u0623\u0648 \u062a\u0628\u0639\u064a\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629. \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 QuickFix \u0644\u0644\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0641\u0626\u0627\u062a \u0646\u0627\u0642\u0635\u0629. \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629 \u0627\u0644\u0645\u0643\u062a\u0634\u0641\u0629:</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627 \u0646\u062a\u0627\u0626\u062c</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0645\u0648\u0627\u0642\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0625\u0644\u064a\u0643 \u0646\u062a\u0627\u0626\u062c \u0639\u0645\u0644\u064a\u0627\u062a \u0627\u0644\u062a\u062d\u0642\u0642 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643. \u0627\u0639\u0645\u0644 \u0628\u0628\u0637\u0621\u061b \u0639\u0627\u062f\u0629\u064b\u060c \u0627\u0644\u0633\u0628\u0628 \u0627\u0644\u0635\u062d\u064a\u062d \u064a\u0643\u0648\u0646 \u0641\u064a \u0627\u0644\u0641\u062d\u0635 \u0627\u0644\u0623\u0648\u0644 \u0623\u0648 \u0627\u0644\u062b\u0627\u0646\u064a. \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0628\u0642\u064a\u0629 (\u0627\u0644\u0623\u062e\u0637\u0627\u0621 \u0645\u0646 3 \u0641\u0645\u0627 \u0641\u0648\u0642) \u0644\u0644\u062a\u0623\u0643\u064a\u062f\u060c \u0644\u0643\u0646\u0647\u0627 \u063a\u0627\u0644\u0628\u064b\u0627 \u0623\u062e\u0637\u0627\u0621 \u0645\u062a\u0633\u0644\u0633\u0644\u0629 \u064a\u0645\u0643\u0646 \u062a\u062c\u0627\u0647\u0644\u0647\u0627. \u0627\u0644\u0623\u0639\u0637\u0627\u0644 \u062a\u062d\u062f\u062b \u0628\u0634\u0643\u0644 \u0637\u0628\u0642\u064a\u060c \u0644\u0630\u0627 \u0641\u0625\u0646 \u0625\u0635\u0644\u0627\u062d \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629 \u0633\u064a\u062d\u0644 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0627\u0644\u0645\u062d\u062f\u062f. \u0648\u0645\u0639 \u0630\u0644\u0643\u060c \u0642\u062f \u064a\u0638\u0647\u0631 \u063a\u062f\u064b\u0627 \u062e\u0637\u0623 \u062c\u062f\u064a\u062f \u063a\u064a\u0631 \u0645\u0631\u062a\u0628\u0637 \u0628\u0627\u0644\u062e\u0637\u0623 \u0627\u0644\u062d\u0627\u0644\u064a\u060c \u0644\u0623\u0646 \u062e\u0637\u0623\u064b \u0648\u0627\u062d\u062f\u064b\u0627 \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u064a\u0645\u0646\u0639 \u0638\u0647\u0648\u0631 \u0622\u062e\u0631 \u0641\u064a \u0648\u062d\u062f\u0629 \u0627\u0644\u062a\u062d\u0643\u0645.</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u0631\u062c\u0649 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 Java 17 \u0644\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a 1.17-1.20.4 \u0648Java 21 \u0644\u0623\u064a \u0625\u0635\u062f\u0627\u0631 \u0623\u062d\u062f\u062b. \u0627\u0633\u062a\u062e\u062f\u0645 Java 8 \u0644\u0623\u064a \u0625\u0635\u062f\u0627\u0631 \u0623\u0642\u062f\u0645. [\u062f\u0644\u064a\u0644](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). \u0625\u0630\u0627 \u0643\u0646\u062a \u0644\u0627 \u062a\u0632\u0627\u0644 \u062a\u0648\u0627\u062c\u0647 \u0645\u0634\u0627\u0643\u0644\u060c \u0641\u0642\u062f \u064a\u0643\u0648\u0646 \u0630\u0644\u0643 \u0644\u0623\u0646 \u0628\u0639\u0636 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0644\u0641\u0627\u062a \u0642\u062f\u064a\u0645\u0629 \u062c\u062f\u064b\u0627 \u0623\u0648 \u062c\u062f\u064a\u062f\u0629 \u062c\u062f\u064b\u0627.</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 22 \u0648\u0645\u0627 \u0641\u0648\u0642\u0647 \u0644\u0627 \u064a\u0639\u0645\u0644 \u0639\u0644\u0649 \u0625\u0635\u062f\u0627\u0631\u0627\u062a Minecraft \u0627\u0644\u0623\u0642\u0644 \u0645\u0646 1.20.5 \u0644\u0645\u0639\u0638\u0645 \u0645\u064f\u062d\u0645\u0651\u0644\u0627\u062a \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0628\u0633\u0628\u0628 \u0623\u0646 ASM \u0642\u062f\u064a\u0645.</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java \u0642\u062f\u064a\u0645 </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0648\u062d\u062f\u0629 JPMS " + mod_necesitas + " \u0645\u0646 " + submod + "</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 " + metodo + " \u0644\u0623\u0646 " + objeto + " \u0647\u0648 \u0642\u064a\u0645\u0629 \u062e\u0627\u0644\u064a\u0629</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "\u0627\u0644\u062a\u062d\u0644\u064a\u0644 \u0627\u0644\u0645\u062a\u0642\u062f\u0645";
    }

    @Override
    public String seleccionarCarpeta() {
        return "\u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0645\u062c\u0644\u062f";
    }

    @Override
    public String cadenaBusqueda() {
        return "\u0633\u0644\u0633\u0644\u0629 \u0627\u0644\u0628\u062d\u062b";
    }

    @Override
    public String usarRegex() {
        return "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062a\u0639\u0628\u064a\u0631\u0627\u062a \u0627\u0644\u0646\u0645\u0637\u064a\u0629";
    }

    @Override
    public String ignorarMayusculas() {
        return "\u062a\u062c\u0627\u0647\u0644 \u062d\u0627\u0644\u0629 \u0627\u0644\u0623\u062d\u0631\u0641";
    }

    @Override
    public String buscar() {
        return "\u0628\u062d\u062b";
    }

    @Override
    public String busquedaEnProgreso() {
        return "\u0627\u0644\u0628\u062d\u062b \u0642\u064a\u062f \u0627\u0644\u062a\u0646\u0641\u064a\u0630";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0646\u062a\u0627\u0626\u062c";
    }

    @Override
    public String errorBusqueda() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0628\u062d\u062b";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "!\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0645\u0634\u063a\u0644. \u0642\u062f \u064a\u0624\u062f\u064a \u0647\u0630\u0627 \u0625\u0644\u0649 \u062a\u0639\u0642\u064a\u062f \u0627\u0644\u062a\u062d\u0642\u064a\u0642\n                \n                \u0644\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0635\u062d\u064a\u062d\u0629:\n                - MultiMC/PolyMC/PrismLauncher/: \u0645\u0644\u0627\u062d\u0638\u0629: \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0645\u0643\u062a\u0634\u0641\u0629 \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627 \u0644\u064a\u0633\u062a \u0635\u062d\u064a\u062d\u0629.\n                  1. \u0627\u0641\u062a\u062d \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0645\u062b\u064a\u0644\n                  2. \u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 \u0642\u0633\u0645 \"Minecraft Log\"\n                  3. \u0627\u0646\u0642\u0631 \u0628\u0632\u0631 \u0627\u0644\u0645\u0627\u0648\u0633 \u0627\u0644\u0623\u064a\u0645\u0646 \u0648\u0627\u0646\u0633\u062e \u0627\u0644\u0645\u062d\u062a\u0648\u0649\n                - CurseForgeApp:\n                  1. \u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629 \u062f\u0648\u0646 \u062a\u062e\u0637\u064a \u0627\u0644\u0645\u0634\u063a\u0644\n                  \n";
    }

    @Override
    public String omitirYCerrar() {
        return "\u062a\u062e\u0637\u064a \u0648\u0625\u063a\u0644\u0627\u0642";
    }

    @Override
    public String guardarYCerrar() {
        return "\u062d\u0641\u0638 \u0648\u0625\u063a\u0644\u0627\u0642";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "\u0627\u0644\u0635\u0642 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0647\u0646\u0627";
    }

    @Override
    public String archivo() {
        return "\u0645\u0644\u0641";
    }

    @Override
    public String incluir() {
        return "\u062a\u0636\u0645\u064a\u0646";
    }

    @Override
    public String abrir() {
        return "\u0641\u062a\u062d";
    }

    @Override
    public String endpointDeInforme() {
        return "\u0646\u0642\u0637\u0629 \u0646\u0647\u0627\u064a\u0629 \u0627\u0644\u062a\u0642\u0631\u064a\u0631";
    }

    @Override
    public String sitoDeLogging() {
        return "\u0645\u0648\u0642\u0639 \u062a\u0633\u062c\u064a\u0644:";
    }

    @Override
    public String apiDeLogging() {
        return "\u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u062a\u0637\u0628\u064a\u0642\u0627\u062a \u062a\u0633\u062c\u064a\u0644:";
    }

    @Override
    public String anonimizarRegistros() {
        return "\u0625\u062e\u0641\u0627\u0621 \u0647\u0648\u064a\u0629 \u0627\u0644\u0633\u062c\u0644\u0627\u062a (\u0628\u064a\u062a\u0627)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "\u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u062a\u0642\u0631\u064a\u0631 \u0648\u062c\u0645\u064a\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0645\u062d\u062f\u062f\u0629";
    }

    @Override
    public String arco() {
        return "\u064a\u0633\u0645\u062d \u0644\u0643 \u0647\u0630\u0627 \u0627\u0644\u062d\u0648\u0627\u0631 \u0628\u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u062a\u0637\u0628\u064a\u0642\u0627\u062a SecureLogger \u0639\u0644\u0649 <a href=\"https://securelogger.net\">securelogger.net</a>. \u0639\u0646\u062f \u0627\u0644\u0636\u063a\u0637 \u0639\u0644\u0649 \u0632\u0631 \u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u062a\u0642\u0631\u064a\u0631\u060c \u064a\u064f\u0631\u0633\u064e\u0644 \u062a\u0642\u0631\u064a\u0631\u0643 \u0625\u0644\u0649 \u0646\u0642\u0637\u0629 \u0627\u0644\u0646\u0647\u0627\u064a\u0629 \u0627\u0644\u0645\u062d\u062f\u062f\u0629 (\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u064b\u0627: asbestosstar.egoism.jp) (\u064a\u0645\u0643\u0646 \u062a\u063a\u064a\u064a\u0631\u0647\u0627 \u0641\u064a \u0627\u0644\u0623\u0633\u0641\u0644). \u064a\u0645\u0643\u0646\u0643 \u0645\u0634\u0627\u0631\u0643\u0629 \u062c\u0645\u064a\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0645\u062d\u062f\u062f\u0629 \u0645\u0639 \u0627\u0644\u062a\u0642\u0631\u064a\u0631. \u0625\u0630\u0627 \u0643\u0646\u062a \u0644\u0627 \u062a\u0631\u063a\u0628 \u0641\u064a \u0627\u0644\u0631\u0641\u0639\u060c \u0641\u0644\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0627\u0644\u062d\u0648\u0627\u0631! \u0646\u062d\u0646 \u0644\u0627 \u0646\u0639\u0627\u0644\u062c \u062a\u0642\u0631\u064a\u0631\u0643 \u0639\u0644\u0649 \u0646\u0642\u0637\u0629 \u0627\u0644\u0646\u0647\u0627\u064a\u0629 \u0627\u0644\u0631\u0633\u0645\u064a\u0629 (<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>); \u0646\u0642\u0648\u0645 \u0641\u0642\u0637 \u0628\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u063a\u064a\u0631 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627. \u0627\u0644\u0643\u0648\u062f \u0645\u062a\u0627\u062d \u0647\u0646\u0627: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">\u0627\u0644\u0643\u0648\u062f \u0627\u0644\u0645\u0635\u062f\u0631\u064a</a>. \u064a\u064f\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0641\u0642\u0637 \u0644\u0639\u0631\u0636 \u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0639\u0646 \u0639\u0637\u0644\u0643 \u0648\u0631\u0627\u0628\u0637 \u0627\u0644\u0633\u062c\u0644\u0627\u062a. \u0648\u0645\u0639 \u0630\u0644\u0643\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0646\u0642\u0637\u0629 \u0646\u0647\u0627\u064a\u0629 \u0645\u062e\u0635\u0635\u0629 \u0642\u062f \u0644\u0627 \u062a\u062a\u0628\u0639 \u0646\u0641\u0633 \u0627\u0644\u0623\u0633\u0627\u0644\u064a\u0628. \u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0645\u0648\u0642\u0639 \u0627\u0644\u062a\u0642\u0627\u0631\u064a\u0631 " + Config.obtenerInstancia().obtenerSitoDeInformes() + " \u0648\u0645\u0648\u0642\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + ". \u064a\u0645\u0643\u0646\u0643 \u0623\u064a\u0636\u064b\u0627 \u0645\u0634\u0627\u0631\u0643\u0629 \u0633\u062c\u0644\u0627\u062a \u0641\u0631\u062f\u064a\u0629 \u062f\u0648\u0646 \u062a\u0642\u0631\u064a\u0631 \u0628\u0627\u0644\u0636\u063a\u0637 \u0639\u0644\u0649 \u0623\u0632\u0631\u0627\u0631 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629 \u0628\u062c\u0627\u0646\u0628 \u0623\u0633\u0645\u0627\u0621 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0641\u0631\u062f\u064a\u0629\u061b \u0633\u062a\u064f\u0631\u0633\u064e\u0644 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0625\u0644\u0649 \u0645\u0648\u0642\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0645\u062d\u062f\u062f. \u064a\u062d\u062a\u0648\u064a CrashDetector \u0639\u0644\u0649 \u0625\u062e\u0641\u0627\u0621 \u0647\u0648\u064a\u0629 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0641\u062a\u0631\u0627\u0636\u064a\u064b\u0627\u060c \u0627\u0644\u0630\u064a \u064a\u062d\u0627\u0648\u0644 \u0625\u0632\u0627\u0644\u0629 \u0623\u0633\u0645\u0627\u0621 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646\u060c UUID\u060c \u0631\u0645\u0648\u0632 \u0627\u0644\u0648\u0635\u0648\u0644\u060c \u0645\u0639\u0631\u0651\u0641\u0627\u062a \u0627\u0644\u062c\u0644\u0633\u0629\u060c \u0639\u0646\u0627\u0648\u064a\u0646 IP \u0648\u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0623\u062e\u0631\u0649. \u0644\u0643\u0646\u0647 \u0644\u064a\u0633 \u0645\u062b\u0627\u0644\u064a\u064b\u0627. \u0648\u0645\u0639 \u0630\u0644\u0643\u060c \u064a\u0645\u0643\u0646 \u0644\u0645\u064f\u0646\u0634\u0626 \u062d\u0632\u0645\u0629 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u062a\u0639\u0637\u064a\u0644\u0647. \u064a\u0645\u0643\u0646\u0643 \u062a\u0641\u0639\u064a\u0644\u0647 \u0623\u0648 \u062a\u0639\u0637\u064a\u0644\u0647 \u0639\u0628\u0631 \u062e\u0627\u0646\u0629 \u0627\u0644\u0627\u062e\u062a\u064a\u0627\u0631 \u0641\u064a \u0623\u0633\u0641\u0644 \u0647\u0630\u0647 \u0627\u0644\u0634\u0627\u0634\u0629. \u0623\u0646\u062a \u0645\u062a\u062d\u0643\u0645 \u0641\u064a \u0628\u064a\u0627\u0646\u0627\u062a\u0643\u061b \u0627\u0644\u0642\u0631\u0627\u0631 \u0644\u0643 \u0623\u064a\u0646 \u062a\u0631\u0641\u0639 \u0628\u064a\u0627\u0646\u0627\u062a\u0643. \u0645\u0648\u0627\u0642\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0645\u0645\u0644\u0648\u0643\u0629 \u0644\u0623\u0637\u0631\u0627\u0641 \u062b\u0627\u0644\u062b\u0629 \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u062a\u0643\u0648\u0646 \u0645\u0644\u0643\u064a\u062a\u0647\u0627 \u0645\u062e\u0641\u064a\u0629 \u0644\u0623\u0633\u0628\u0627\u0628 \u062a\u062a\u0639\u0644\u0642 \u0628\u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629. \u0623\u0646\u062a \u062a\u062a\u062d\u0645\u0644 \u0627\u0644\u0645\u0633\u0624\u0648\u0644\u064a\u0629 \u0627\u0644\u0643\u0627\u0645\u0644\u0629 \u0639\u0646 \u0625\u062f\u0627\u0631\u0629 \u0628\u064a\u0627\u0646\u0627\u062a\u0643 \u0648\u0627\u0644\u0645\u062e\u0627\u0637\u0631 \u0627\u0644\u0645\u0631\u062a\u0628\u0637\u0629 \u0628\u0647\u0627. \u062d\u0648\u0627\u0631 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629 \u0641\u064a CrashDetector \u0647\u0648 \u0645\u062c\u0631\u062f \u0648\u0627\u062c\u0647\u0629 \u062a\u062a\u064a\u062d \u0644\u0643 \u0625\u062f\u0627\u0631\u0629 \u0630\u0644\u0643. \u0645\u0646 \u0627\u0644\u0645\u0647\u0645 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0639\u0644\u0649 \u062f\u0631\u0627\u064a\u0629 \u0628\u0640 GDPR \u0648 ARCO. \u0625\u0630\u0627 \u0643\u0646\u062a \u0641\u064a \u0623\u0648\u0631\u0648\u0628\u0627\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 <a href=\"https://securelogger.top\">securelogger.top</a> \u0627\u0644\u0645\u0633\u062a\u0636\u0627\u0641 \u0641\u064a \u0623\u0644\u0645\u0627\u0646\u064a\u0627 \u0628\u0648\u0627\u0633\u0637\u0629 Hetzner. \u0644\u0645\u0632\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0642\u0627\u0646\u0648\u0646\u064a\u0629\u060c \u0631\u0627\u062c\u0639 \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u062a\u0627\u0644\u064a\u0629: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>, <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>, <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">\u0627\u0644\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629 \u0644\u062d\u0645\u0627\u064a\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0641\u064a \u0627\u0644\u064a\u0627\u0628\u0627\u0646</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "\u0631\u0627\u0628\u0637 \u0627\u0644\u062a\u0642\u0631\u064a\u0631:";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "\u062d\u0641\u0638 \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "\u0627\u0644\u0633\u062c\u0644 \u0643\u0628\u064a\u0631 \u062c\u062f\u064b\u0627 \u0644\u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u0642\u0639. \u064a\u0631\u062c\u0649 \u0627\u062e\u062a\u064a\u0627\u0631 \u0645\u0648\u0642\u0639 \u0622\u062e\u0631 \u0648\u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "\u062e\u0637\u0623 \u0641\u064a \u0646\u0634\u0631 \u0627\u0644\u0633\u062c\u0644 " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "\u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u062a\u0637\u0628\u064a\u0642\u0627\u062a \u0627\u0644\u0633\u062c\u0644 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629. \u064a\u0631\u062c\u0649 \u062a\u063a\u064a\u064a\u0631 \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u0627\u0644\u062a\u0637\u0628\u064a\u0642\u0627\u062a \u0641\u064a \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a.";
    }

    @Override
    public String errorSSL() {
        return "\u0644\u062f\u064a\u0643 \u062e\u0637\u0623 \u0641\u064a \u0628\u0631\u0648\u062a\u0648\u0643\u0648\u0644 \u0637\u0628\u0642\u0629 \u0627\u0644\u0645\u0642\u0627\u0628\u0633 \u0627\u0644\u0622\u0645\u0646\u0629 (SSL). \u0647\u0630\u0627 \u0634\u0627\u0626\u0639 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0642\u062f\u064a\u0645\u0629 \u0645\u0646 Java\u060c \u0628\u0645\u0627 \u0641\u064a \u0630\u0644\u0643 \u0625\u0635\u062f\u0627\u0631\u0627\u062a Java 8 \u0641\u064a \u0645\u0634\u063a\u0644 Minecraft \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a \u0648\u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0645\u0648\u062c\u0648\u062f\u0629 \u0639\u0644\u0649 sun.com \u0648 java.com. \u064a\u0624\u062b\u0631 \u0647\u0630\u0627 \u0639\u0644\u0649 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u062c\u0648\u0627\u0646\u0628\u060c \u0645\u062b\u0644 \u0645\u0644\u0641\u0627\u062a JAR \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0645\u062b\u0628\u062a MinecraftForge\u060c \u0648\u0638\u064a\u0641\u0629 \u0645\u0634\u0627\u0631\u0643\u0629 \u062a\u0642\u0627\u0631\u064a\u0631 CrashDetector \u0639\u0646\u062f \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0646\u0642\u0637\u0629 \u0627\u0644\u0646\u0647\u0627\u064a\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629\u060c \u0648\u0628\u0639\u0636 \u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u062a\u0637\u0644\u0628 \u0627\u0644\u0625\u0646\u062a\u0631\u0646\u062a \u0648\u0628\u0639\u0636 \u0645\u0648\u0627\u0642\u0639 \u0627\u0644\u062a\u0633\u062c\u064a\u0644. \u0625\u0630\u0627 \u062d\u062f\u062b \u0647\u0630\u0627 \u0644\u0643 \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0645\u0634\u0627\u0631\u0643\u0629 \u062a\u0642\u0631\u064a\u0631\u060c \u0645\u0627 \u0639\u0644\u064a\u0643 \u0633\u0648\u0649 \u0625\u0631\u0641\u0627\u0642 \u0644\u0642\u0637\u0629 \u0634\u0627\u0634\u0629 \u0648\u0627\u062e\u062a\u064a\u0627\u0631 \u0645\u0648\u0642\u0639 \u062a\u0633\u062c\u064a\u0644 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631\u0627\u062a Java 8 \u0627\u0644\u0642\u062f\u064a\u0645\u0629.";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0625\u0635\u062f\u0627\u0631 JavaFML \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642: \u0645\u0637\u0644\u0648\u0628 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 " + requerido + "\u060c \u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0627\u0646\u062a\u0628\u0627\u0647! JavaFML \u064a\u062a\u0637\u0644\u0628 \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0645\u062d\u062f\u062f\u064b\u0627 \u0645\u0646 Minecraft Forge</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0644\u0641 JAR '" + archivoJar + "' \u064a\u062a\u0637\u0644\u0628 \u0645\u0632\u0648\u062f \u0627\u0644\u0644\u063a\u0629 '" + proveedor + "' \u0627\u0644\u0625\u0635\u062f\u0627\u0631 '" + requerido + "' \u0623\u0648 \u0623\u062d\u062f\u062b\u060c \u0648\u0644\u0643\u0646 \u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 '" + encontrado + "'.</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0646\u0628\u064a\u0647! Crash Assistant \u0647\u0648 \u0643\u0627\u0634\u0641 \u0628\u0631\u0627\u0645\u062c \u0636\u0627\u0631\u0629 \u0645\u0632\u064a\u0641. \u064a\u0642\u0648\u0645 \u0628\u062d\u0638\u0631 \u0627\u0644\u0644\u0639\u0628\u0629 \u0639\u0646 \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0628\u0634\u0643\u0644 \u0645\u062a\u0639\u0645\u062f\u060c \u0645\u0639 \u062a\u062c\u0627\u0647\u0644 \u062d\u0631\u064a\u062a\u0643 \u0641\u064a \u0645\u062a\u0627\u0628\u0639\u0629 \u0627\u0644\u0644\u0639\u0628 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u062a\u064a \u064a\u0633\u062a\u0647\u062f\u0641\u0647\u0627. <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>\u0639\u0631\u0636 \u0643\u0648\u062f MalwareMod.java</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>\u0639\u0631\u0636 \u0643\u0648\u062f JarInJarHelper.java</a>. \u0647\u0630\u0627 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0641\u0642\u0637 \u0647\u0648 \u0627\u0644\u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0642\u0627\u0626\u0645\u062a\u0647\u0645 \u062d\u0627\u0644\u064a\u0627\u064b\u060c \u0648\u0647\u0645 \u064a\u0633\u062a\u0647\u062f\u0641\u0648\u0646 \u0641\u0642\u0637 \u0645\u0648\u0642\u0639 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u060c \u0648\u0627\u0644\u0630\u064a \u064a\u0645\u0643\u0646 \u0644\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u062a\u063a\u064a\u064a\u0631\u0647\u060c \u0648\u0647\u0630\u0627 \u064a\u062d\u062f\u062b \u0641\u0642\u0637 \u0625\u0630\u0627 \u0627\u062e\u062a\u0631\u062a \u0635\u0631\u0627\u062d\u0629 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u064a\u0632\u0629 \u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0645\u062f\u0645\u062c\u0629. CrashAssistant \u0644\u0627 \u064a\u0642\u0648\u0645 \u0628\u0623\u064a \u0641\u062d\u0648\u0635\u0627\u062a \u0644\u062a\u062d\u062f\u064a\u062f \u0645\u0648\u0642\u0639 \u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0648\u0644\u0627 \u064a\u0634\u0631\u062d \u0643\u064a\u0641\u064a\u0629 \u062a\u063a\u064a\u064a\u0631\u0647 (\u0647\u0646\u0627\u0643 \u0642\u0627\u0626\u0645\u0629 \u0645\u0646\u0633\u062f\u0644\u0629 \u0641\u064a \u0623\u0633\u0641\u0644 \u0645\u0631\u0628\u0639 \u0627\u0644\u062d\u0648\u0627\u0631 \u0627\u0644\u062e\u0627\u0635 \u0628\u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629)\u060c \u0648\u0628\u063a\u0636 \u0627\u0644\u0646\u0638\u0631 \u0639\u0646 \u0627\u0644\u0645\u0648\u0642\u0639 \u0627\u0644\u0630\u064a \u0642\u0645\u062a \u0628\u062a\u0643\u0648\u064a\u0646\u0647\u060c \u0641\u0625\u0646 CrashAssistant \u0633\u064a\u0645\u0646\u0639 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629. \u0641\u064a \u0631\u0633\u0627\u0644\u062a\u0647\u0645 \u064a\u0642\u0648\u0644\u0648\u0646 \u0623\u0646 \u062a\u0642\u0648\u0645 \u0628\u0625\u062c\u0631\u0627\u0621 \u0628\u062d\u062b\u0643 \u0627\u0644\u062e\u0627\u0635\u060c \u0627\u0641\u0639\u0644 \u0630\u0644\u0643\u060c \u0627\u0646\u0638\u0631 \u0625\u0644\u0649 \u0643\u0648\u062f CrashDetector \u0648Crash Assistant \u0648\u0627\u0641\u0647\u0645 \u0645\u0627 \u064a\u0642\u0648\u0645\u0648\u0646 \u0628\u0647\u060c \u0644\u0627 \u062a\u0639\u062a\u0645\u062f \u0639\u0644\u0649 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u0633\u0644\u0637\u0629.</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0634\u0644 \u0627\u0644\u0645\u0648\u062f '" + idMod + "' \u0644\u0623\u0646 \u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0637\u0644\u0648\u0628 \u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u064a\u0647: '" + claseNoEncontrada + "'. \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a \u0645\u062b\u0628\u062a\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia \u0642\u062f \u062d\u0638\u0631 \u0627\u0644\u0644\u0639\u0628 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 TLauncher.</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0645\u0646 Optifine \u0644\u0646\u0633\u062e\u0629 \u0642\u062f\u064a\u0645\u0629 \u0645\u0646 Minecraft. \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 Optifine \u0627\u0644\u0645\u062e\u0635\u0635 \u0644\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0630\u064a \u062a\u0633\u062a\u062e\u062f\u0645\u0647 \u0645\u0646 Minecraft.</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0645 \u064a\u062a\u0645\u0643\u0646 \u0645\u0646 \u062a\u062d\u0645\u064a\u0644 \u062e\u062f\u0645\u0629 ModLauncher: </b>" + servicio + ".";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u062a\u062d\u0644\u064a\u0644 \u0645\u0644\u0641 JSON '" + recurso + "' \u0645\u0646 \u0645\u0644\u0641 JAR '" + archivoJar + "'. \u0647\u0646\u0627\u0643 \u0645\u0634\u0627\u0643\u0644 \u0641\u064a \u0627\u0644\u062a\u0633\u062c\u064a\u0644.</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623: \u0627\u0644\u0645\u0648\u062f '" + modId + "' \u064a\u062a\u0637\u0644\u0628 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 '" + requerido + "' \u0623\u0648 \u0623\u062d\u062f\u062b \u0645\u0646 '" + dependencia + "'\u060c \u0644\u0643\u0646 \u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 '" + actual + "'.</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u0627\u062a \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u0644\u0627 \u062a\u062f\u0639\u0645 \u0625\u0635\u062f\u0627\u0631 OpenGL \u0627\u0644\u0645\u0637\u0644\u0648\u0628 \u0644\u0647\u0630\u0647 \u0646\u0633\u062e\u0629 \u0627\u0644\u0644\u0639\u0628\u0629. \u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b \u0628\u0631\u0627\u0645\u062c \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0623\u0648 \u0627\u0633\u062a\u0628\u062f\u0644 \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u0627\u062a \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643.</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0642\u0645 \u0628\u0632\u064a\u0627\u062f\u0629 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0645\u062e\u0635\u0635\u0629 \u0644\u0644\u0639\u0628\u0629 \u0623\u0648 \u0642\u0644\u0644 \u0645\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a/\u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 JVM \u0628\u0640 32 \u0628\u062a: \u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u0643\u062b\u0631 \u0645\u0646 4 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a \u0645\u0646 \u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0648\u0635\u0648\u0644 \u0627\u0644\u0639\u0634\u0648\u0627\u0626\u064a. \u0642\u0645 \u0628\u062a\u062b\u0628\u064a\u062a JVM \u0628\u0640 64 \u0628\u062a \u0644\u0644\u0627\u0633\u062a\u0641\u0627\u062f\u0629 \u0645\u0646 \u0643\u0644 \u0630\u0627\u0643\u0631\u062a\u0643 \u0627\u0644\u0645\u062a\u0627\u062d\u0629</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c \u0641\u064a \u0630\u0627\u0643\u0631\u0629 PermGen. \u0642\u0645 \u0628\u0632\u064a\u0627\u062f\u0629 \u0645\u0633\u0627\u062d\u0629 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u062f\u0627\u0626\u0645\u0629 \u0623\u0648 \u0642\u0644\u0644 \u0645\u0646 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0641\u0626\u0627\u062a</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u062a\u0648\u0627\u0641\u0642 \u0628\u064a\u0646 Java 8 \u0648\u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u062d\u062f\u064a\u062b\u0629</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+ \u063a\u064a\u0631 \u0645\u062f\u0639\u0648\u0645 - \u0627\u0633\u062a\u062e\u062f\u0645 Java 8 \u0644\u0646\u0633\u062e Forge \u0627\u0644\u0642\u062f\u064a\u0645\u0629</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8 \u0645\u0637\u0644\u0648\u0628 (\u0627\u0644\u0625\u0635\u062f\u0627\u0631 52.0). \u0642\u0645 \u0628\u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0623\u0648 \u0627\u0644\u062a\u0647\u064a\u0626\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c \u0641\u064a \u0627\u0644\u062a\u0648\u0627\u0641\u0642: \u0627\u0644\u0643\u062a\u0644 \u063a\u064a\u0631 \u0645\u062f\u0639\u0648\u0645\u0629 \u0641\u064a \u0647\u0630\u0647 \u0627\u0644\u0646\u0633\u062e\u0629. \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0648\u0627\u0644\u062e\u0627\u062f\u0645 \u0645\u062a\u0648\u0627\u0641\u0642\u0629</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u062a\u0643\u0648\u064a\u0646 \u0627\u0644\u0634\u0627\u0634\u0627\u062a: \u062a\u0639\u0630\u0631 \u062a\u0639\u064a\u064a\u0646 \u0648\u0636\u0639 \u0627\u0644\u0634\u0627\u0634\u0629. \u062a\u062d\u0642\u0642 \u0645\u0646:</b><br>- \u062a\u0643\u0648\u064a\u0646 \u0634\u0627\u0634\u0627\u062a \u0645\u062a\u0639\u062f\u062f\u0629<br>- \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a \u0627\u0644\u0645\u062d\u062f\u062b\u0629<br>- \u0627\u0644\u062f\u0642\u0629 \u0627\u0644\u0645\u062f\u0639\u0648\u0645\u0629 \u0645\u0646 \u0627\u0644\u0646\u0638\u0627\u0645";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u062e\u064a\u0627\u0631\u0627\u062a Java: \u062e\u064a\u0627\u0631\u0627\u062a \u062c\u0627\u0645\u0639 \u0627\u0644\u0642\u0645\u0627\u0645\u0629 \u0645\u062a\u0639\u0627\u0631\u0636\u0629. \u062a\u0623\u0643\u062f \u0645\u0646 \u0639\u062f\u0645 \u062f\u0645\u062c \u0639\u062f\u0629 \u062e\u0648\u0627\u0631\u0632\u0645\u064a\u0627\u062a GC \u0641\u064a \u0645\u0639\u0644\u0645\u0627\u062a JVM</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062a\u0643\u0648\u064a\u0646 NightConfig/Forge \u062d\u0631\u062c: \u0645\u0644\u0641 \u0627\u0644\u062a\u0643\u0648\u064a\u0646 \u062a\u0627\u0644\u0641 \u0623\u0648 \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644. \u0642\u062f \u064a\u0643\u0648\u0646 \u0647\u0630\u0627 \u0646\u0627\u062a\u062c\u064b\u0627 \u0639\u0646 \u0645\u0644\u0641\u0627\u062a \u062a\u0643\u0648\u064a\u0646 \u0641\u0627\u0631\u063a\u0629 (\u063a\u0627\u0644\u0628\u064b\u0627 \u0628\u062d\u062c\u0645 0 \u0628\u0627\u064a\u062a) \u0641\u064a \u0645\u062c\u0644\u062f 'config' \u0641\u064a \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0642\u062f\u064a\u0645\u0629 \u0623\u0648 \u0645\u0639\u062f\u0644\u0629 \u0645\u0646 NightConfig. \u0641\u064a \u0645\u0639\u0638\u0645 \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a\u060c \u0633\u064a\u062d\u0644\u0651 Night Config Fixes \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0644\u0643\u0646 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0623\u0648 \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0645\u0639\u062f\u0644\u064b\u0627 \u0645\u0646 NightConfig\u060c \u0641\u0633\u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u062d\u0630\u0641 \u0645\u0644\u0641\u0627\u062a \u0627\u0644\u062a\u0643\u0648\u064a\u0646 \u064a\u062f\u0648\u064a\u064b\u0651\u0627. \u0647\u0630\u0627 \u0627\u0644\u0645\u0634\u0643\u0644 \u0634\u0627\u0626\u0639 \u0623\u0643\u062b\u0631 \u0641\u064a \u0625\u0635\u062f\u0627\u0631\u0627\u062a MC Forge \u0627\u0644\u0642\u062f\u064a\u0645\u0629 (\u0627\u0644\u062a\u064a \u062a\u062a\u0636\u0645\u0646 NightConfig) \u0648\u0641\u064a \u0648\u062d\u062f\u0627\u062a FabricMC \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u0627\u0644\u062a\u064a \u062a\u062d\u0632\u0645 NightConfig\u060c \u0644\u0643\u0646\u0647 \u0642\u062f \u064a\u0638\u0647\u0631 \u0623\u064a\u0636\u064b\u0627 \u0641\u064a \u0628\u0639\u0636 \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0645\u062e\u0635\u0635\u0629 \u0645\u0646 NightConfig. \u0645\u0632\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u062d\u0648\u0644 \u0627\u0644\u062d\u0644\u0648\u0644 \u0645\u062a\u0627\u062d \u0641\u064a <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a>.</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0641\u064a \u0628\u0631\u0646\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 Intel HD Graphics. \u0627\u0644\u062d\u0644\u0648\u0644:</b><br>1. \u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 Intel \u0645\u0646 <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a> (\u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0623\u062f\u0646\u0649 15.xx.xx.xx)<br>2. \u0641\u064a Minecraft: \u0627\u0644\u062e\u064a\u0627\u0631\u0627\u062a \u2192 \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u2192 \u0642\u0645 \u0628\u062a\u0641\u0639\u064a\u0644 'Enable VBOs' \u0648 'VSync'<br>3. \u062e\u0635\u0635 1GB-2GB \u0645\u0646 \u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0648\u0635\u0648\u0644 \u0627\u0644\u0639\u0634\u0648\u0627\u0626\u064a \u0644\u0644\u0639\u0628\u0629 \u0641\u064a \u0627\u0644\u0645\u0634\u063a\u0644<br>4. \u0642\u0645 \u0628\u0625\u064a\u0642\u0627\u0641 \u062a\u0634\u063a\u064a\u0644 \u0645\u0636\u0627\u062f \u0627\u0644\u0641\u064a\u0631\u0648\u0633\u0627\u062a/\u062c\u062f\u0627\u0631 \u0627\u0644\u062d\u0645\u0627\u064a\u0629 \u0645\u0624\u0642\u062a\u064b\u0627 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u062d\u062f\u064a\u062b";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "\u062a\u062d\u0630\u064a\u0631: \u0627\u0643\u062a\u0634\u0627\u0641 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0639\u0631\u0636 \u0627\u0644\u0643\u062a\u0644";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "\u062a\u062d\u0644\u064a\u0644 \u0633\u062c\u0644 \u0627\u0644\u0623\u062e\u0637\u0627\u0621 (stack trace)";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "\u0648\u062d\u062f\u0629 \u062a\u062d\u0643\u0645 CurseForge \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644\u0629";
    }

    @Override
    public String nombre_de_early_window() {
        return "\u062e\u0637\u0623 \u0646\u0627\u0641\u0630\u0629 \u0645\u0628\u0643\u0631\u0629 (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "\u0645\u0634\u0643\u0644\u0627\u062a \u0628\u0631\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0641\u064a\u062f\u064a\u0648";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "\u062a\u0643\u0648\u064a\u0646 MCForge \u062a\u0627\u0644\u0641";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "\u0641\u0634\u0644 \u0648\u0636\u0639 \u0627\u0644\u0639\u0631\u0636 (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "\u062e\u0637\u0623 \u0628\u062f\u0621 \u062a\u0634\u063a\u064a\u0644 FabricMC";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "\u0648\u062d\u062f\u0627\u062a JPMS \u0645\u0641\u0642\u0648\u062f\u0629";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "\u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u062d\u0631\u062c\u0629";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "\u062a\u0631\u0627\u0643\u0645\u0627\u062a ModLauncher \u0645\u0641\u0642\u0648\u062f\u0629";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "\u0625\u0635\u062f\u0627\u0631\u0627\u062a Java \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "\u062e\u0637\u0623 \u0645\u0648\u0627\u0631\u062f KubeJS";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "\u0645\u0632\u0648\u062f \u0627\u0644\u0644\u063a\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "\u062e\u0637\u0623 Litchhost";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "\u0627\u0643\u062a\u0634\u0627\u0641 \u0628\u0631\u0627\u0645\u062c \u0636\u0627\u0631\u0629 \u0643\u0627\u0630\u0628\u0629";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "\u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u062f\u064a\u0644 \u0645\u0634\u0628\u0648\u0647";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0645\u0643\u0631\u0631\u0629 \u0641\u064a ModLauncher";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0648\u062d\u062f\u0627\u062a JPMS";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "\u064a\u062a\u0637\u0644\u0628 Sodium \u0644\u0640 Iris";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "\u0641\u0634\u0644 \u0641\u064a \u062a\u062d\u0644\u064a\u0644 \u0645\u0644\u0641 JSON \u0644\u0644\u0633\u062c\u0644";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "\u0630\u0627\u0643\u0631\u0629 \u063a\u064a\u0631 \u0643\u0627\u0641\u064a\u0629";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "\u062e\u0637\u0623 \u0645\u0624\u0634\u0631 \u0641\u0627\u0631\u063a (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "\u062e\u064a\u0627\u0631\u0627\u062a \u062c\u0645\u0639 \u0627\u0644\u0642\u0645\u0627\u0645\u0629 (GC) \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "OptiFine \u0642\u062f\u064a\u0645\u0629/\u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "\u0646\u0642\u0631\u0629 \u062e\u0627\u062f\u0645 \u062d\u0631\u062c\u0629 (60 \u062b\u0627\u0646\u064a\u0629)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "\u062e\u062f\u0645\u0627\u062a ModLauncher \u0645\u0639\u0637\u0644\u0629";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "\u062a\u0643\u0648\u064a\u0646\u0627\u062a SpongeMixing \u0645\u0634\u0643\u0644\u0629";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "TLauncher \u063a\u064a\u0631 \u0645\u062f\u0639\u0648\u0645 \u0645\u0646 WATERMeDIA";
    }

    @Override
    public String auditorias_transformer() {
        return "\u062a\u062f\u0642\u064a\u0642\u0627\u062a \u0627\u0644\u062a\u062d\u0648\u064a\u0644";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0647\u0630\u0647 \u0647\u064a \u0646\u062a\u0627\u0626\u062c \u0645\u062d\u062a\u0648\u064a\u0627\u062a \u062a\u062f\u0642\u064a\u0642\u0627\u062a \u0627\u0644\u062a\u062d\u0648\u064a\u0644 \u0641\u064a \u0645\u0634\u063a\u0644 \u0627\u0644\u0641\u0627\u0646\u064a\u0644\u064a\u0627. \u0639\u0627\u062f\u0629\u064b \u0645\u0627 \u062a\u0643\u0648\u0646 \u0623\u0642\u0644 \u062f\u0642\u0629 \u0645\u0646 \u0645\u062d\u0644\u0644 StackTrace\u060c \u0644\u0643\u0646 \u0645\u0634\u063a\u0644 \u0627\u0644\u0641\u0627\u0646\u064a\u0644\u064a\u0627 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062f\u0627\u0626\u0645\u064b\u0627 \u0639\u0644\u0649 \u0645\u062d\u062a\u0648\u0649 \u0644\u0640 {}</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "\u064a\u0628\u062d\u062b \u0647\u0630\u0627 \u0641\u064a \u0625\u0636\u0627\u0641\u0627\u062a\u0643 \u0639\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u0645\u0635\u0646\u0648\u0639\u0629 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 MCreator. \u0639\u0644\u0649 \u0627\u0644\u0631\u063a\u0645 \u0645\u0646 \u0623\u0646 \u0645\u0639\u0638\u0645 \u0625\u0636\u0627\u0641\u0627\u062a MCreator \u062c\u064a\u062f\u0629 \u0648\u0647\u0646\u0627\u0643 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u0631\u0627\u0626\u0639\u0629 \u0627\u0644\u062a\u064a \u062a\u0645 \u0625\u0646\u0634\u0627\u0624\u0647\u0627 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 MCreator\u060c \u0625\u0644\u0627 \u0623\u0646\u0647\u0627 \u0623\u062d\u064a\u0627\u0646\u064b\u0627 \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0634\u0627\u0643\u0644 \u0648\u0644\u062f\u064a\u0647\u0627 \u0633\u0645\u0639\u0629 \u0633\u064a\u0626\u0629. \u0647\u0630\u0627 \u064a\u0633\u0627\u0639\u062f \u0641\u064a \u062a\u062d\u062f\u064a\u062f\u0647\u0627. \u0644\u0627\u062d\u0638 \u0623\u0646 \u062d\u062a\u0649 \u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0630\u0627\u062a \u0627\u0644\u062a\u0642\u064a\u064a\u0645 \u0627\u0644\u0639\u0627\u0644\u064a \u0642\u062f \u0644\u0627 \u062a\u0643\u0648\u0646 \u0628\u0627\u0644\u0636\u0631\u0648\u0631\u0629 \u0645\u0646 MCreator\u061b \u0639\u0644\u0649 \u0633\u0628\u064a\u0644 \u0627\u0644\u0645\u062b\u0627\u0644\u060c \u0642\u062f \u062a\u0643\u0648\u0646 \u0644\u062f\u064a\u0647\u0627 \u062a\u0643\u0627\u0645\u0644 \u0645\u0639 MCreator.";
    }

    @Override
    public String escanear() {
        return "\u0641\u062d\u0635";
    }

    @Override
    public String cargando() {
        return "\u062c\u0627\u0631\u064d \u0627\u0644\u062a\u062d\u0645\u064a\u0644";
    }

    @Override
    public String codigo() {
        return "ar";
    }

    @Override
    public String inicioApp() {
        return "\u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629/\u0627\u0644\u062a\u0637\u0628\u064a\u0642";
    }

    @Override
    public String ajustesCrashDetector() {
        return "\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0643\u0627\u0634\u0641 \u0627\u0644\u0623\u0639\u0637\u0627\u0644";
    }

    @Override
    public String confidencialidad() {
        return "\u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629";
    }

    @Override
    public String tooltip() {
        return "\u062a\u0644\u0645\u064a\u062d \u0627\u0644\u0623\u062f\u0648\u0627\u062a";
    }

    @Override
    public String config() {
        return "\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a";
    }

    @Override
    public String abrirCarpeta() {
        return "\u0641\u062a\u062d \u0627\u0644\u0645\u062c\u0644\u062f";
    }

    @Override
    public String actualizar() {
        return "\u062a\u062d\u062f\u064a\u062b";
    }

    @Override
    public String anadirRegistro() {
        return "\u0625\u0636\u0627\u0641\u0629 \u0633\u062c\u0644";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0644\u063a\u0629 \u0627\u0644\u0646\u0638\u0627\u0645";
    }

    @Override
    public String volver() {
        return "\u0631\u062c\u0648\u0639";
    }

    @Override
    public String colorFondo() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062e\u0644\u0641\u064a\u0629 (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u0635 (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0632\u0631 (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "\u0644\u0648\u0646 \u0645\u0631\u0628\u0639 \u0627\u0644\u0646\u0635 (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0631\u0627\u0628\u0637 (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "\u0644\u0648\u0646 \u0639\u0646\u0627\u0648\u064a\u0646 \u0627\u0644\u0643\u0648\u0646\u0633\u0648\u0644 (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062e\u0637\u0623 (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062a\u062d\u0630\u064a\u0631 (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0627\u0644\u0631\u0627\u0628\u0637 (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "\u0641\u062a\u062d CrashDetector \u0641\u0642\u0637 \u0639\u0646\u062f \u0627\u0644\u0641\u0634\u0644";
    }

    @Override
    public String activar_parche() {
        return "\u062a\u0641\u0639\u064a\u0644 \u0627\u0644\u062a\u0635\u062d\u064a\u062d";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "\u0644\u0627 \u062a\u0648\u062c\u062f \u062d\u0644\u0648\u0644 \u0645\u062a\u0627\u062d\u0629";
    }

    @Override
    public String error() {
        return "\u062e\u0637\u0623";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "\u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062d\u0630\u0641 Jar";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "\u062a\u0645 \u062d\u0630\u0641 Jar \u0628\u0646\u062c\u0627\u062d";
    }

    @Override
    public String exito() {
        return "\u0646\u062c\u0627\u062d";
    }

    @Override
    public String eliminar() {
        return "\u062d\u0630\u0641";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "\u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062d\u0630\u0641 \u0627\u0644\u062d\u0632\u0645\u0629";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062d\u0632\u0645\u0629 \u0628\u0646\u062c\u0627\u062d";
    }

    @Override
    public String eliminar_paquete() {
        return "\u062d\u0630\u0641 \u0627\u0644\u062d\u0632\u0645\u0629";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0645\u0639 \u0627\u0644\u062d\u0632\u0645\u0629";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u062d\u0632\u0645\u0629";
    }

    @Override
    public String eliminar_jar() {
        return "\u062d\u0630\u0641 Jar";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0645\u0643\u0631\u0631\u0629";
    }

    @Override
    public String archivo_no_encontrado() {
        return "\u0627\u0644\u0645\u0644\u0641 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f";
    }

    @Override
    public String directorio_eliminado() {
        return "\u0627\u0644\u0645\u062c\u0644\u062f \u0645\u062d\u0630\u0648\u0641";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "\u062e\u0637\u0623 \u0641\u064a \u062d\u0630\u0641 \u0645\u0644\u0641 Jar \u0627\u0644\u0645\u062a\u062f\u0627\u062e\u0644";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062f\u0627\u062e\u0644\u064a";
    }

    @Override
    public String archivo_eliminado() {
        return "\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0644\u0641";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "\u062e\u0637\u0623 \u0641\u064a \u062d\u0630\u0641 \u0627\u0644\u0645\u0644\u0641";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062e\u0627\u0631\u062c\u064a \u063a\u064a\u0631 \u0635\u0627\u0644\u062d";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "\u062a\u0645 \u062d\u0630\u0641 \u0639\u0646\u0635\u0631 \u0627\u0644\u062a\u0639\u062f\u064a\u0644";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0633\u062a\u0628\u062f\u0627\u0644 \u0645\u0644\u0641 Jar \u0627\u0644\u062e\u0627\u0631\u062c\u064a";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "\u062e\u0637\u0623 \u0641\u064a \u062d\u0630\u0641 \u0639\u0646\u0635\u0631 \u0627\u0644\u062a\u0639\u062f\u064a\u0644";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "\u062e\u0637\u0623 \u0641\u064a \u062d\u0630\u0641 \u0627\u0644\u0645\u062c\u0644\u062f";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "\u0635\u064a\u063a\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629 \u0644\u0645\u0644\u0641 Jar \u0627\u0644\u0645\u062a\u062f\u0627\u062e\u0644";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "\u062a\u0645 \u062d\u0630\u0641 \u0645\u0644\u0641 Jar \u0627\u0644\u0645\u062a\u062f\u0627\u062e\u0644";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "\u062e\u0637\u0623 \u0641\u064a \u062a\u0646\u0638\u064a\u0641 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0624\u0642\u062a\u0629";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0631\u0633\u0627\u0644\u0629 \u062a\u062a\u0628\u0639 \u0642\u0627\u062a\u0644\u0629 \u0623\u062e\u064a\u0631\u0629 (\u063a\u064a\u0631 \u0645\u062a\u0631\u062c\u0645\u0629):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0631\u0633\u0627\u0644\u0629 \u062a\u062a\u0628\u0639 \u0623\u062e\u064a\u0631\u0629 (\u063a\u064a\u0631 \u0645\u062a\u0631\u062c\u0645\u0629):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "\u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0628\u062d\u062b \u0641\u064a \u0642\u0627\u0639\u062f\u0629 \u0628\u064a\u0627\u0646\u0627\u062a WaifuNeoForge \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0648\u062f\u0627\u062a. \u0627\u062e\u062a\u0631 \u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0644\u0639\u0628\u0629\u060c \u0648\u0645\u062d\u0645\u0644 \u0627\u0644\u0645\u0648\u062f\u0627\u062a\u060c \u0648\u0627\u0633\u0645 \u0627\u0644\u0641\u0626\u0629. \u0627\u0633\u062a\u062e\u062f\u0645 \u0623\u0642\u0631\u0628 \u062a\u0637\u0627\u0628\u0642 \u0645\u0645\u0643\u0646. \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0628\u062d\u062b \u0645\u0631\u0629 \u0648\u0627\u062d\u062f\u0629 \u0643\u0644 \u062f\u0642\u064a\u0642\u0629.";
    }

    @Override
    public String solucionFaltasClases() {
        return "\u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0628\u062d\u062b \u0641\u064a \u0642\u0627\u0639\u062f\u0629 \u0628\u064a\u0627\u0646\u0627\u062a WaifuNeoForge \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0648\u062f\u0627\u062a. \u0627\u062e\u062a\u0631 \u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0644\u0639\u0628\u0629\u060c \u0648\u0645\u062d\u0645\u0644 \u0627\u0644\u0645\u0648\u062f\u0627\u062a\u060c \u0648\u0627\u0633\u0645 \u0627\u0644\u0641\u0626\u0629. \u0627\u0633\u062a\u062e\u062f\u0645 \u0623\u0642\u0631\u0628 \u062a\u0637\u0627\u0628\u0642 \u0645\u0645\u0643\u0646. \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0628\u062d\u062b \u0645\u0631\u0629 \u0648\u0627\u062d\u062f\u0629 \u0643\u0644 \u062f\u0642\u064a\u0642\u0629.";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "\u064a\u062d\u062a\u0648\u064a \u0643\u0644 \u0645\u0646 \u0645\u0634\u063a\u0651\u0644\u064a \u0627\u0644\u0623\u0644\u0639\u0627\u0628 \u0639\u0644\u0649 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0635\u062d\u064a\u062d\u0629 \u0645\u0646 \u062c\u0627\u0641\u0627 \u0648\u0644\u0643\u0646 \u0644\u064a\u0633 \u062c\u0645\u064a\u0639\u0647\u0627\u061b \u064a\u0645\u0643\u0646\u0643 \u062a\u062b\u0628\u064a\u062a \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0635\u062d\u064a\u062d \u0645\u0646 \u062c\u0627\u0641\u0627 \u0645\u0646 \u0645\u062f\u064a\u0631 \u0627\u0644\u062d\u0632\u0645 \u0641\u064a \u0646\u0638\u0627\u0645\u0643 \u0623\u0648 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0623\u0632\u0631\u0627\u0631.";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u0641\u062a\u0642\u0631 \u0625\u0644\u0649 \u0627\u0644\u0631\u0633\u0648\u0645 \u0627\u0644\u0645\u062a\u062d\u0631\u0643\u0629: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException (\u0627\u0633\u062a\u062b\u0646\u0627\u0621 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0639\u0646\u0635\u0631) \u0627\u0644\u0631\u0633\u0648\u0645 \u0627\u0644\u0645\u062a\u062d\u0631\u0643\u0629 \u0645\u0641\u0642\u0648\u062f\u0629";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0644\u062d\u0630\u0641\u0647\u0627";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "\u0627\u0633\u062a\u0628\u062f\u0627\u0644 \u062e\u064a\u0627\u0631\u0627\u062a \u062c\u0645\u0639 \u0627\u0644\u0642\u0645\u0627\u0645\u0629 \u0627\u0644\u0645\u062a\u0639\u0627\u0631\u0636\u0629 \u0628\u0640 -XX:+UseG1GC";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "\u0632\u064a\u0627\u062f\u0629 \u062d\u062c\u0645 \u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0643\u0648\u0645\u0629 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062e\u064a\u0627\u0631 -Xmx.";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "\u0632\u064a\u0627\u062f\u0629 \u062d\u062c\u0645 \u0630\u0627\u0643\u0631\u0629 permgen \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062e\u064a\u0627\u0631 -XX:MaxPermSize.";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0627chine \u0627\u0644\u0638\u0627\u0647\u0631\u064a\u0629 \u062c\u0627\u0641\u0627 64 \u0628\u062a \u0644\u0632\u064a\u0627\u062f\u0629 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0645\u062a\u0627\u062d\u0629.";
    }

    @Override
    public String optimizarCodigo() {
        return "\u062a\u062d\u0633\u064a\u0646 \u0627\u0644\u0643\u0648\u062f \u0644\u062a\u0642\u0644\u064a\u0644 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0648\u062a\u062d\u0633\u064a\u0646 \u0627\u0644\u0623\u062f\u0627\u0621.";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u062c\u0627\u0645\u0639 \u0642\u0645\u0627\u0645\u0629 \u0641\u0639\u0627\u0644 \u0644\u062a\u0642\u0644\u064a\u0644 \u062a\u0648\u0642\u0641 \u0627\u0644\u062a\u0637\u0628\u064a\u0642.";
    }

    @Override
    public String modulos() {
        return "\u0648\u062d\u062f\u0627\u062a";
    }

    @Override
    public String paquete() {
        return "\u062d\u0632\u0645\u0629";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "\u0647\u0646\u0627\u0643 \u0628\u0639\u0636 \u0627\u0644\u0645\u0639\u0631\u0641\u0627\u062a \u0627\u0644\u0646\u0627\u0642\u0635\u0629. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u0647\u064a \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0623\u0648 \u0628\u064a\u0627\u0646\u0627\u062a \u0639\u0646\u0627\u0635\u0631 \u0645\u0641\u0642\u0648\u062f\u0629. \u0627\u0644\u0645\u062c\u0644\u062f\u0627\u062a \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u0644\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0647\u064a datafiedcontents/ \u0648 kubejs/ \u0623\u0648 \u0645\u062c\u0644\u062f\u0627\u062a \u0623\u062e\u0631\u0649 \u062e\u0627\u0635\u0629 \u0628\u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a.";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "\u0633\u062c\u0644\u0627\u062a \u062a\u0645 \u0631\u0628\u0637\u0647\u0627 \u0628\u0634\u0643\u0644 \u062e\u0627\u0637\u0626";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0634\u0644 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 'AuthMe' \u0648\u0623\u062f\u062a \u0625\u0644\u0649 \u0625\u064a\u0642\u0627\u0641 \u0627\u0644\u062e\u0627\u062f\u0645.</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "\u0645\u0634\u0643\u0644\u0629 \u0625\u064a\u0642\u0627\u0641 \u0627\u0644\u062e\u0627\u062f\u0645 \u0628\u0633\u0628\u0628 AuthMe";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "\u062a\u063a\u064a\u0631\u062a \u0627\u0644\u0642\u0627\u0639\u062f\u0629 'stopServer' \u0625\u0644\u0649 'true'.";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "\u0642\u0645 \u0628\u062a\u0643\u0648\u064a\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 AuthMe (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "\u062b\u0628\u062a \u0646\u0633\u062e\u0629 \u0645\u062e\u062a\u0644\u0641\u0629 \u0645\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 'AuthMe'";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "\u0627\u062d\u0630\u0641 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 'AuthMe'";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0645 \u064a\u0645\u0643\u0646 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0639\u0627\u0644\u0645 '" + nombreMundo + "' \u0644\u0623\u0646\u0647 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062e\u0637\u0627\u0621 \u0648\u0631\u0628\u0645\u0627 \u064a\u0643\u0648\u0646 \u0645\u064f\u0647\u062a\u0631\u0626\u064b\u0627.</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "\u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0639\u0648\u0627\u0644\u0645 Multiverse";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "\u0642\u0645 \u0628\u0625\u0635\u0644\u0627\u062d \u0627\u0644\u0639\u0627\u0644\u0645 '" + nombreMundo + "', \u0639\u0644\u0649 \u0633\u0628\u064a\u0644 \u0627\u0644\u0645\u062b\u0627\u0644 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 Minecraft Region Fixer \u0623\u0648 MCEdit.";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "\u0627\u062d\u0630\u0641 \u0645\u062c\u0644\u062f \u0627\u0644\u0639\u0627\u0644\u0645 '" + nombreMundo + "'.";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0625\u0636\u0627\u0641\u0629 'PermissionsEx' \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "\u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u0625\u0639\u062f\u0627\u062f\u0627\u062a PermissionsEx";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "\u0642\u0645 \u0628\u062a\u0643\u0648\u064a\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 PermissionsEx (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "\u0627\u062d\u0630\u0641 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 'PermissionsEx'";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0647\u0646\u0627\u0643 \u0639\u062f\u0629 \u0645\u0644\u0641\u0627\u062a \u0625\u0636\u0627\u0641\u0627\u062a \u062a\u062d\u0645\u0644 \u0646\u0641\u0633 \u0627\u0644\u0627\u0633\u0645 '" + nombrePlugin + "': '" + primerPath + "' \u0648'" + segundoPath + "'.</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "\u0645\u0634\u0643\u0644\u0629 \u0627\u0633\u0645 \u0625\u0636\u0627\u0641\u0629 \u0645\u064f\u0628\u0647\u0645";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "\u0627\u062d\u0630\u0641 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062d\u062f\u062b \u0627\u0633\u062a\u062b\u0646\u0627\u0621 \u0623\u062b\u0646\u0627\u0621 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0640 chunks \u0645\u0646 \u0627\u0644\u0639\u0627\u0644\u0645. \u0625\u0630\u0627 \u0643\u0627\u0646 \u0645\u062a\u0627\u062d\u064b\u0627 \u0644\u0645\u0646\u0635\u062a\u0643\u060c \u0641\u0642\u062f \u064a\u062a\u0645\u0643\u0646 FeatureRecycler \u0645\u0646 \u062d\u0644 \u0627\u0644\u0645\u0634\u0643\u0644\u0629. https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "\u062e\u0637\u0623 \u0639\u0646\u062f \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0643\u062a\u0644";
    }

    @Override
    public String solucionEliminarChunk() {
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0643\u062a\u0644\u0629 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0645\u0646 \u0627\u0644\u0639\u0627\u0644\u0645\u060c \u0639\u0644\u0649 \u0633\u0628\u064a\u0644 \u0627\u0644\u0645\u062b\u0627\u0644 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 MCEdit \u0623\u0648 \u0639\u0646 \u0637\u0631\u064a\u0642 \u062d\u0630\u0641 \u0645\u0644\u0641 \u0627\u0644\u0645\u0646\u0637\u0642\u0629.";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u062a\u0646\u0641\u064a\u0630 \u0627\u0644\u0623\u0645\u0631 '/" + comando + "'.</b> ";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "\u0627\u0633\u062a\u062b\u0646\u0627\u0621 \u0623\u062b\u0646\u0627\u0621 \u062a\u0646\u0641\u064a\u0630 \u0623\u0645\u0631 \u0627\u0644\u0625\u0636\u0627\u0641\u0629";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "\u062b\u0628\u062a \u0646\u0633\u062e\u0629 \u0645\u062e\u062a\u0644\u0641\u0629 \u0645\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062a\u0637\u0644\u0628 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0639\u0644\u0649 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + dependencia + "'.</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062a\u0637\u0644\u0628 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0639\u0644\u0649 \u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629: " + deps.toString() + ".</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "\u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0639\u0644\u0649 \u0625\u0636\u0627\u0641\u0629 \u0645\u0641\u0642\u0648\u062f\u0629";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "\u062b\u0628\u062a \u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631 \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u064a\u0629 '" + versionAPI + "' \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0627\u0644\u062e\u0627\u062f\u0645 \u0627\u0644\u062d\u0627\u0644\u064a.</b> ";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "\u0625\u0635\u062f\u0627\u0631 \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u064a\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "\u062b\u0628\u062a \u0627\u0644\u0625\u0635\u062f\u0627\u0631 '" + version + "' \u0645\u0646 \u0628\u0631\u0646\u0627\u0645\u062c \u062e\u0627\u062f\u0645\u0643.";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u0639\u0627\u0644\u0645 '" + nombreMundo + "' \u0647\u0648 \u0646\u0633\u062e\u0629 \u0645\u0643\u0631\u0631\u0629 \u0645\u0646 \u0639\u0627\u0644\u0645 \u0622\u062e\u0631 \u0648\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u0645\u064a\u0644\u0647.</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "\u0639\u0627\u0644\u0645 \u0645\u0643\u0631\u0631";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "\u0627\u062d\u0630\u0641 \u0645\u0644\u0641 'uid.dat' \u0645\u0646 \u0627\u0644\u0639\u0627\u0644\u0645 '" + nombreMundo + "'";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "\u0627\u062d\u0630\u0641 \u0645\u062c\u0644\u062f \u0627\u0644\u0639\u0627\u0644\u0645 '" + nombreMundo + "'";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0643\u064a\u0627\u0646 \u0627\u0644\u0643\u062a\u0644\u064a '" + nombre + "' \u0645\u0646 \u0627\u0644\u0646\u0648\u0639 '" + tipo + "' \u0641\u064a \u0627\u0644\u0645\u0648\u0642\u0639 " + coords + " \u064a\u0633\u0628\u0628 \u0623\u062e\u0637\u0627\u0621 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u062d\u062f\u064a\u062b\u0627\u062a.</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "\u0643\u064a\u0627\u0646 \u0643\u062a\u0644\u064a \u0645\u0634\u0643\u0644";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0643\u064a\u0627\u0646 '" + nombre + "' \u0627\u0644\u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0627\u0644\u0645\u0648\u0642\u0639 " + coords + " \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 MCEdit \u0623\u0648 \u0639\u0646 \u0637\u0631\u064a\u0642 \u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0639\u0627\u0644\u0645 \u0645\u0628\u0627\u0634\u0631\u0629.";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0639\u0644\u0649 \u0639\u062f\u0629 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u062b\u0628\u062a\u0629.</b> ";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "\u0645\u0648\u062f \u0645\u0643\u0631\u0631 \u0641\u064a Fabric";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "\u0627\u062d\u0630\u0641 \u0645\u0644\u0641 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0643\u0631\u0631: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u0648\u062f\u0627\u0646 '" + primerMod + "' \u0648'" + segundoMod + "' \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0645\u0639 \u0628\u0639\u0636\u0647\u0645\u0627 \u0627\u0644\u0628\u0639\u0636.</b> ";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "\u0645\u0648\u062f \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0641\u064a Fabric";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "\u0627\u062d\u0630\u0641 \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "'";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0639\u0644\u0649 \u062e\u0637\u0623 \u062d\u0631\u062c \u0648\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u0646\u0641\u064a\u0630\u0647.</b> ";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "\u0645\u0648\u062f \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u062e\u0637\u0623 \u062c\u0633\u064a\u0645";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629 \u0648\u0644\u0643\u0646 \u0644\u0645 \u064a\u062a\u0645 \u062a\u062b\u0628\u064a\u062a\u0647\u0627: " + deps.toString() + ".</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0627\u062c \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0625\u0644\u0649 \u0627\u0644\u0645\u0648\u062f '" + dependencia + "' \u0643\u0627\u0639\u062a\u0645\u0627\u062f\u064a\u0629.</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0627\u062c \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0625\u0644\u0649 \u0627\u0644\u0645\u0648\u062f '" + dependencia + "' \u0628\u0627\u0644\u0625\u0635\u062f\u0627\u0631 " + version + ".</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "\u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0639\u0644\u0649 \u0645\u0648\u062f \u063a\u064a\u0631 \u0645\u062b\u0628\u062a";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "\u062b\u0628\u062a \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "'";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "\u062b\u0628\u062a \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0645\u0639 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 " + version;
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0625\u0642\u0644\u064a\u0645\u064a \u0641\u064a Folia.</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0625\u0642\u0644\u064a\u0645\u064a \u0641\u064a Folia: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "\u0625\u0636\u0627\u0641\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0625\u0642\u0644\u064a\u0645\u064a";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "\u062b\u0628\u062a \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0628\u062f\u0648\u0646 \u062a\u062d\u062f\u064a\u062b \u0625\u0642\u0644\u064a\u0645\u064a\u060c \u0645\u062b\u0644 " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0645\u0641\u0642\u0648\u062f \u0645\u0646 \u0627\u0644\u062d\u0632\u0645\u0629.</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 \u0627\u0644\u062d\u0632\u0645\u0629: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "\u0645\u0648\u062f \u0645\u0641\u0642\u0648\u062f \u0645\u0646 \u0627\u0644\u062d\u0632\u0645\u0629";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u062a\u0633\u0628\u0628 \u0641\u064a \u062e\u0637\u0623.</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u062a\u0633\u0628\u0628\u062a \u0641\u064a \u0623\u062e\u0637\u0627\u0621: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "\u0645\u0648\u062f Forge \u0645\u0639 \u0627\u0633\u062a\u062b\u0646\u0627\u0621";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "\u062b\u0628\u062a \u0646\u0633\u062e\u0629 \u0645\u062e\u062a\u0644\u0641\u0629 \u0645\u0646 \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "'";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a " + versionMC + ".</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (\u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a ").append(versionesMC.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "\u0645\u0648\u062f \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "\u062b\u0628\u062a \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0645\u062a\u0648\u0627\u0641\u0642\u064b\u0627 \u0645\u0646 Forge \u0645\u0639 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a " + versionMC;
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0645\u0641\u0642\u0648\u062f \u0648\u0647\u0648 \u0645\u0637\u0644\u0648\u0628 \u0644\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0639\u0627\u0644\u0645 \u0623\u0648 \u0627\u0644\u0625\u0636\u0627\u0641\u0629.</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "\u0645\u0648\u062f \u0645\u0641\u0642\u0648\u062f";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0639\u0627\u0644\u0645 \u0645\u0639 \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0627\u0644\u0630\u064a \u064a\u0628\u062f\u0648 \u0623\u0646\u0647 \u0645\u0641\u0642\u0648\u062f.</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0639\u0627\u0644\u0645 \u0645\u0639 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u0627\u0644\u062a\u064a \u062a\u0628\u062f\u0648 \u0645\u0641\u0642\u0648\u062f\u0629: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "\u0645\u0648\u062f \u0645\u0641\u0642\u0648\u062f \u0641\u064a \u0627\u0644\u0639\u0627\u0644\u0645";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0639\u0627\u0644\u0645 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0628\u0627\u0644\u0625\u0635\u062f\u0627\u0631 " + versionEsperada + "\u060c \u0648\u0647\u0648 \u0627\u0644\u0622\u0646 \u064a\u0639\u0645\u0644 \u0628\u0627\u0644\u0625\u0635\u062f\u0627\u0631 " + versionActual + ".</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u0644\u062f\u064a\u0647\u0627 \u062a\u0646\u0627\u0642\u0636 \u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0641\u064a \u0627\u0644\u0639\u0627\u0644\u0645 \u0627\u0644\u0645\u062d\u0641\u0648\u0638: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (\u0645\u062d\u0641\u0648\u0638: ").append(versionesEsperadas.get(i)).append(", \u062d\u0627\u0644\u064a\u064b\u0627: ").append(versionesActuales.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "\u0645\u0648\u062f \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0639\u0627\u0644\u0645";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0642\u062f \u062d\u0627\u0648\u0644\u062a \u062a\u062d\u0645\u064a\u0644 \u0639\u0627\u0644\u0645 \u062a\u0645 \u0625\u0646\u0634\u0627\u0624\u0647 \u0628\u0625\u0635\u062f\u0627\u0631 \u0623\u062d\u062f\u062b \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a.</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "\u0645\u062d\u0627\u0648\u0644\u0629 \u062a\u062d\u0645\u064a\u0644 \u0639\u0627\u0644\u0645 \u0645\u0646 \u0625\u0635\u062f\u0627\u0631 \u0623\u062d\u062f\u062b";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "\u062b\u0628\u062a \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0623\u062d\u062f\u062b \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a.";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "\u0623\u0646\u0634\u0626 \u0639\u0627\u0644\u0645\u064b\u0627 \u062c\u062f\u064a\u062f\u064b\u0627.";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u0643\u0627\u0639\u062a\u0645\u0627\u062f: '" + dependencia + "'.</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0627\u0639\u062a\u0645\u0627\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u062b\u0628\u062a\u0629: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("' (").append(dependencias.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "\u0625\u0636\u0627\u0641\u0629 \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0639\u062a\u0645\u0627\u062f \u0645\u0641\u0642\u0648\u062f";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062e\u0627\u062f\u0645 \u0627\u0644\u062d\u0627\u0644\u064a.</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062e\u0627\u062f\u0645 \u0627\u0644\u062d\u0627\u0644\u064a: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u0648");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "\u0627\u0644\u0625\u0636\u0627\u0641\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 PocketMine-MP";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0625\u0636\u0627\u0641\u0629 '" + nombrePlugin + "' \u062a\u0633\u0628\u0628\u062a \u0641\u064a \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u0634\u063a\u064a\u0644.</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u062a\u0633\u0628\u0628\u062a \u0641\u064a \u0623\u062e\u0637\u0627\u0621 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u0634\u063a\u064a\u0644: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u0648");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "\u0625\u0636\u0627\u0641\u0629 \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u062a\u0646\u0641\u064a\u0630";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "LegacyRandomSource \u0645\u062a\u0639\u062f\u062f \u0627\u0644\u062e\u064a\u0648\u0637";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0645\u0634\u0643\u0644\u0629 \u0645\u0639 \u0639\u062f\u0629 \u062e\u064a\u0648\u0637 \u062a\u0635\u0644 \u0625\u0644\u0649 \u0641\u0626\u0629 LegacyRandomSource. \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0627\u0644\u0645\u0632\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u062a\u0639\u062f\u064a\u0644 'Unsafe World Random Access Detector' \u0623\u0648 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 'C2ME'.</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "\u0645\u0646\u0630 \u0622\u062e\u0631 \u0646\u062c\u0627\u062d";
    }

    @Override
    public String noHayCambios() {
        return "\u0644\u0627 \u062a\u063a\u064a\u064a\u0631\u0627\u062a";
    }

    @Override
    public String desdeUltimoIntento() {
        return "\u0645\u0646\u0630 \u0622\u062e\u0631 \u0645\u062d\u0627\u0648\u0644\u0629";
    }

    @Override
    public String fallo() {
        return "\u0641\u0634\u0644";
    }

    @Override
    public String diferentesDeLasMods() {
        return "\u0645\u062e\u062a\u0644\u0641 \u0639\u0646 \u0627\u0644\u0645\u0648\u062f\u0627\u062a";
    }

    @Override
    public String historialDeMods() {
        return "\u0633\u062c\u0644 \u0627\u0644\u0645\u0648\u062f\u0627\u062a";
    }

    @Override
    public String archivo0() {
        return "\u0645\u0644\u06410";
    }

    @Override
    public String archivo1() {
        return "\u0645\u0644\u06411";
    }

    @Override
    public String comparar() {
        return "\u0645\u0642\u0627\u0631\u0646\u0629";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "\u062d\u062f\u062f \u0645\u0644\u0641\u064a\u0646";
    }

    @Override
    public String archivoExito() {
        return "\u0645\u0644\u0641 \u0627\u0644\u0646\u062c\u0627\u062d";
    }

    @Override
    public String archivoFalla() {
        return "\u0645\u0644\u0641 \u0627\u0644\u0641\u0634\u0644";
    }

    @Override
    public String errorComparandoArchivos() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0645\u0642\u0627\u0631\u0646\u0629 \u0627\u0644\u0645\u0644\u0641\u0627\u062a";
    }

    @Override
    public String comparando() {
        return "\u064a\u062a\u0645 \u0627\u0644\u0645\u0642\u0627\u0631\u0646\u0629";
    }

    @Override
    public String con() {
        return "\u0645\u0639";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;' dir='rtl'><p><b>\u0644\u0648\u062d\u0629 \u0645\u0642\u0627\u0631\u0646\u0629 \u0633\u062c\u0644 \u0627\u0644\u0645\u0648\u062f\u0627\u062a</b></p><p>\u062a\u062a\u064a\u062d \u0644\u0643 \u0647\u0630\u0647 \u0627\u0644\u0644\u0648\u062d\u0629 \u0645\u0642\u0627\u0631\u0646\u0629 \u0642\u0627\u0626\u0645\u062a\u064a\u0646 \u0645\u0646 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0645\u0646 \u062c\u0644\u0633\u0627\u062a \u0645\u062e\u062a\u0644\u0641\u0629. \u0627\u062e\u062a\u0631 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0639\u0645\u0648\u062f \u0627\u0644\u0623\u064a\u0633\u0631 \u0648\u0622\u062e\u0631 \u0645\u0646 \u0627\u0644\u0623\u064a\u0645\u0646 \u0644\u0631\u0624\u064a\u0629 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0628\u064a\u0646 \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u064a\u0646.</p><h3>\u0643\u064a\u0641\u064a\u0629 \u0627\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645:</h3><ol><li><b>\u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0645\u0644\u0641\u0627\u062a:</b> \u0627\u0646\u0642\u0631 \u0639\u0644\u0649 \u0623\u0632\u0631\u0627\u0631 \u0627\u0644\u0627\u062e\u062a\u064a\u0627\u0631 \u0628\u062c\u0627\u0646\u0628 \u0623\u0633\u0645\u0627\u0621 \u0627\u0644\u0645\u0644\u0641\u0627\u062a. \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0646\u062a\u0647\u064a \u0628\u0640 <span style='color: #4CAF50; font-weight: bold;'>.suceso</span> \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u062c\u0644\u0633\u0627\u062a \u0646\u0627\u062c\u062d\u0629\u060c \u0628\u064a\u0646\u0645\u0627 \u062a\u0634\u064a\u0631 \u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0640 <span style='color: #F44336; font-weight: bold;'>.falla</span> \u0625\u0644\u0649 \u0641\u0634\u0644 \u0623\u0648 \u062e\u0637\u0623.</li><li><b>\u0627\u0644\u0645\u0642\u0627\u0631\u0646\u0629 \u0627\u0644\u062a\u0644\u0642\u0627\u0626\u064a\u0629:</b> \u0639\u0646\u062f \u0627\u0644\u0636\u063a\u0637 \u0639\u0644\u0649 \u0632\u0631 'Compare'\u060c \u0633\u064a\u0642\u0648\u0645 \u0627\u0644\u0646\u0638\u0627\u0645 \u0628\u062a\u062d\u0644\u064a\u0644 \u0627\u0644\u0642\u0648\u0627\u0626\u0645 \u0648\u0627\u0643\u062a\u0634\u0627\u0641 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u0645\u0636\u0627\u0641\u0629 (+) \u0623\u0648 \u0627\u0644\u0645\u062d\u0630\u0648\u0641\u0629 (-).</li><li><b>\u0639\u0631\u0636 \u0627\u0644\u0646\u062a\u0627\u0626\u062c:</b> \u064a\u062a\u0645 \u0639\u0631\u0636 \u0627\u0644\u0646\u062a\u0627\u0626\u062c \u0628\u0635\u064a\u063a\u0629 HTML \u0645\u0639 \u062a\u0631\u0645\u064a\u0632 \u0628\u0627\u0644\u0623\u0644\u0648\u0627\u0646: <ul><li><span style='color: green;'>+ \u0645\u0648\u062f \u0645\u0636\u0627\u0641</span></li><li><span style='color: red;'>- \u0645\u0648\u062f \u0645\u062d\u0630\u0648\u0641</span></li></ul></li></ol><h3>\u0627\u0644\u0645\u0645\u064a\u0632\u0627\u062a \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629:</h3><ul><li>\u064a\u062f\u0639\u0645 \u0623\u064a \u0645\u0632\u064a\u062c \u0645\u0646 \u0627\u0644\u0645\u0644\u0641\u0627\u062a (\u0646\u0627\u062c\u062d\u0629/\u0641\u0627\u0634\u0644\u0629).</li><li>\u064a\u064f\u0638\u0647\u0631 \u0627\u0644\u0641\u0631\u0648\u0642\u0627\u062a \u0641\u064a \u0643\u0644\u0627 \u0627\u0644\u0627\u062a\u062c\u0627\u0647\u064a\u0646 \u0644\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u062a\u0639\u0642\u0628 \u062f\u0642\u064a\u0642.</li><li>\u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0625\u0645\u0643\u0627\u0646\u064a\u0629 \u0627\u0644\u062a\u0645\u0631\u064a\u0631 \u0644\u0642\u0627\u0626\u0645\u0629 \u0637\u0648\u064a\u0644\u0629 \u0645\u0646 \u0627\u0644\u0645\u0648\u062f\u0627\u062a.</li><li>\u0645\u062a\u0643\u0627\u0645\u0644 \u0645\u0639 \u0635\u0648\u0631 \u0634\u0627\u0631\u062d\u0629 \u0644\u062a\u062d\u0633\u064a\u0646 \u0627\u0644\u0641\u0647\u0645 \u0627\u0644\u0628\u0635\u0631\u064a.</li></ul><p>\u062a\u0645 \u062a\u0637\u0648\u064a\u0631\u0647 \u0628\u0640 3> \u0644\u0645\u0633\u0627\u0639\u062f\u062a\u0643 \u0639\u0644\u0649 \u062a\u062a\u0628\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0641\u064a \u0625\u0639\u062f\u0627\u062f\u0627\u062a\u0643.</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0646 \u0627\u0644\u0645\u062d\u062a\u0645\u0644 \u0623\u0646\u0643 \u062a\u0648\u0627\u062c\u0647 \u0645\u0634\u0643\u0644\u0629 \u0645\u062a\u0639\u0644\u0642\u0629 \u0628\u0640 IPv6. \u062a\u0648\u062c\u062f \u062d\u0644\u0627\u0646: 1) \u0623\u0636\u0641 \u0627\u0644\u0645\u0639\u0627\u0645\u0644 <code>-Djava.net.preferIPv4Stack=true</code> \u0625\u0644\u0649 \u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643\u060c \u0623\u0648 2) \u0627\u0633\u062a\u062e\u062f\u0645 \u0632\u0631 'QuickFix' \u0641\u064a CrashDetector \u0644\u062a\u062b\u0628\u064a\u062a \u0625\u0635\u0644\u0627\u062d \u064a\u0641\u0639\u0651\u0644 \u0647\u0630\u0627 \u0627\u0644\u0625\u0639\u062f\u0627\u062f \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627.</b>";
    }

    @Override
    public String parcheIPv4() {
        return "\u062a\u0635\u062d\u064a\u062d IPv4/6";
    }

    @Override
    public String carpetaHMCL() {
        return "\u0645\u062c\u0644\u062f HMCL (\u0644\u0640 HelloMineCraftLauncher \u0641\u0642\u0637)";
    }

    @Override
    public String descripcionCurseforge() {
        return "\u0645\u0644\u0627\u062d\u0638\u0629: \u0644\u0627 \u064a\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0633\u062c\u0644 \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u062e\u0627\u0635\u064a\u0629 '\u062a\u062e\u0637\u064a \u0627\u0644\u0644\u0627\u0646\u0634\u0631' \u0645\u0641\u0639\u0644\u0629 \u0641\u064a \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a > \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/\u0623\u0648 \u0646\u0633\u062e \u0645\u0634\u062a\u0642\u0629 \u0645\u0646\u0647\u0627: \u0627\u0646\u0642\u0631 \u0628\u0632\u0631 \u0627\u0644\u0645\u0627\u0648\u0633 \u0627\u0644\u0623\u064a\u0645\u0646 \u0639\u0644\u0649 \u0627\u0644\u0646\u0633\u062e\u0629 \u0648\u0627\u062e\u062a\u0631 \"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0646\u0633\u062e\u0629\". \u0641\u064a \u0627\u0644\u0646\u0627\u0641\u0630\u0629 \u0627\u0644\u062a\u064a \u062a\u0641\u062a\u062d\u060c \u0627\u0628\u062d\u062b \u0639\u0646 \u0642\u0633\u0645 \"\u0633\u062c\u0644\u0627\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a\" \u0623\u0648 \u0645\u0627 \u0634\u0627\u0628\u0647.<br>\u062a\u062d\u062a\u0648\u064a \u0647\u0630\u0647 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0639\u0644\u0649 \u0627\u0644\u0625\u062e\u0631\u0627\u062c \u0627\u0644\u0642\u064a\u0627\u0633\u064a (STDOUT)\u060c \u0648\u0647\u0648 \u0636\u0631\u0648\u0631\u064a \u0644\u062a\u0634\u062e\u064a\u0635 \u0627\u0644\u0623\u062e\u0637\u0627\u0621.";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): \u064a\u062c\u0628 \u0623\u0646 \u062a\u062e\u062a\u0627\u0631 \u0627\u0644\u0645\u062c\u0644\u062f \u0627\u0644\u0630\u064a \u062a\u0645 \u062a\u062b\u0628\u064a\u062a HMCL \u0641\u064a\u0647 \u0648\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u062c\u0644\u062f \".hmcl\". \u062a\u062d\u062a\u0641\u0638 HMCL \u0628\u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0647\u0646\u0627 \u0648\u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0645\u0647\u0645\u0629 \u0639\u0646 \u0627\u0644\u0623\u062e\u0637\u0627\u0621.<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix: \u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0644\u0627\u0646\u0634\u0631 \u0639\u0644\u0649 \u0639\u0644\u0627\u0645\u0629 \u062a\u0628\u0648\u064a\u0628 \u0644\u0644\u062a\u0637\u0648\u064a\u0631 \u062a\u0639\u0631\u0636 \u0633\u062c\u0644\u0627\u062a \u0645\u0641\u0635\u0644\u0629. \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0647\u0630\u0647 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0641\u064a \u0642\u0627\u0626\u0645\u0629 \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0644\u0627\u0646\u0634\u0631.";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher: \u064a\u0648\u062c\u062f \u0646\u0627\u0641\u0630\u0629 \u0645\u0646\u0628\u062b\u0642\u0629 \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0633\u062c\u0644\u0627\u062a. \u0628\u0647\u0627 \u0623\u0632\u0631\u0627\u0631 \u0644\u0646\u0633\u062e \u0648\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0633\u062c\u0644\u0627\u062a. \u064a\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627 \u0639\u0646\u062f \u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629 \u0648\u062a\u062a\u0636\u0645\u0646 \u0645\u0639\u0644\u0648\u0645\u0627\u062a \u062d\u064a\u0648\u064a\u0629 \u0644\u0644\u062a\u0634\u062e\u064a\u0635.";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher: \u0627\u0646\u0642\u0631 \u0628\u0632\u0631 \u0627\u0644\u0645\u0627\u0648\u0633 \u0627\u0644\u0623\u064a\u0645\u0646 \u0639\u0644\u0649 \u0627\u0644\u0646\u0633\u062e\u0629 \u0648\u0627\u062e\u062a\u0631 \"\u0625\u0639\u062f\u0627\u062f\u0627\u062a\". \u062b\u0645 \u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 \u0642\u0633\u0645 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0644\u0639\u0631\u0636 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0645\u0647\u0645\u0629 \u0645\u0646 \u0627\u0644\u0625\u062e\u0631\u0627\u062c \u0627\u0644\u0642\u064a\u0627\u0633\u064a (STDOUT).";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "\u0631\u0648\u0627\u0628\u0637 Markdown: \u0627\u0644\u0635\u0642 \u0623\u064a \u0631\u0648\u0627\u0628\u0637 \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0633\u062c\u0644\u0627\u062a \u0628\u0635\u064a\u063a\u0629 Markdown \u0647\u0646\u0627. \u0633\u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u0646\u0638\u0627\u0645 \u0627\u0633\u062a\u062e\u0631\u0627\u062c \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0627\u0644\u0633\u062c\u0644\u0627\u062a (latest.log, launcher_log.txt, debug.log\u060c \u0625\u0644\u062e) \u0648\u062a\u062d\u0644\u064a\u0644\u0647\u0627.";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0633\u062c\u0644 \u0627\u0644\u0644\u0627\u0646\u0634\u0631";
    }

    @Override
    public String imagenNoEncontrada() {
        return "\u0627\u0644\u0635\u0648\u0631\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 Create. \u0644\u0642\u062f \u062a\u063a\u064a\u0631 Create \u0643\u062b\u064a\u0631\u064b\u0627 \u2014 \u062a\u0645 \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0641\u0626\u0627\u062a. \u062e\u0627\u0635\u0629\u064b \u0645\u0646\u0630 Create 6 (\u0641\u0628\u0631\u0627\u064a\u0631 2025)\u060c \u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u0645\u0646 Create \u0644\u0645 \u062a\u0639\u062f \u062a\u0639\u0645\u0644. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 QuickFix \u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629. \u064a\u062c\u0628 \u062a\u062d\u062f\u064a\u062b \u0625\u0636\u0627\u0641\u0627\u062a Create\u060c \u0623\u0648 \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u0645\u0646\u0647\u0627\u060c \u0623\u0648 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0635\u062d\u064a\u062d \u0645\u0646 Create \u0644\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0631\u063a\u0628 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647\u0627.</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 EpicFight. \u0644\u0642\u062f \u062a\u063a\u064a\u0631 EpicFight \u0643\u062b\u064a\u0631\u064b\u0627 \u2014 \u062a\u0645 \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0641\u0626\u0627\u062a. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 QuickFix \u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629. \u064a\u062c\u0628 \u062a\u062d\u062f\u064a\u062b \u0625\u0636\u0627\u0641\u0627\u062a EpicFight\u060c \u0623\u0648 \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u0645\u0646\u0647\u0627\u060c \u0623\u0648 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0635\u062d\u064a\u062d \u0645\u0646 EpicFight \u0644\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0631\u063a\u0628 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647\u0627.</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 OpenJ9\u060c \u0648\u0647\u0648 \u063a\u064a\u0631 \u0645\u062f\u0639\u0648\u0645 \u0645\u0646 \u0642\u0628\u0644 \u0647\u0630\u0627 \u0627\u0644\u062a\u0637\u0628\u064a\u0642. \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u062a\u0637\u0628\u064a\u0642\u0627\u062a\u060c \u0628\u0645\u0627 \u0641\u064a \u0630\u0644\u0643 \u0647\u0630\u0627\u060c \u0644\u0627 \u062a\u062f\u0639\u0645 OpenJ9 \u0628\u0633\u0628\u0628 \u0627\u062e\u062a\u0644\u0627\u0641\u0627\u062a \u0641\u064a \u062a\u0646\u0641\u064a\u0630 JVM. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 QuickFix \u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627. \u064a\u062c\u0628 \u0639\u0644\u064a\u0643 \u062a\u062b\u0628\u064a\u062a JDK \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u062b\u0644 Oracle JDK \u0623\u0648 OpenJDK Hotspot \u0623\u0648 \u0628\u062f\u0627\u0626\u0644 \u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0623\u062e\u0631\u0649.</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062a\u0637\u0644\u0628 \u0647\u0630\u0647 \u0627\u0644\u0646\u0633\u062e\u0629 \u0645\u0646 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 Java 11 (JDK 11) \u0644\u0644\u0639\u0645\u0644 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d. \u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0642\u062f\u064a\u0645\u064b\u0627 \u0648\u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0646 Java. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 QuickFix \u062a\u062d\u062f\u064a\u062b Java \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627. \u064a\u062c\u0628 \u062a\u0646\u0632\u064a\u0644 \u0648\u062a\u062b\u0628\u064a\u062a JDK 11 \u0623\u0648 \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0623\u062d\u062f\u062b \u0645\u0646 \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u0645\u0642\u062f\u0645\u0629 \u0641\u064a \u0627\u0644\u062d\u0644.</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0642\u062f \u062e\u0635\u0635\u062a \u0630\u0627\u0643\u0631\u0629 \u0632\u0627\u0626\u062f\u0629\u060c \u0645\u0645\u0627 \u064a\u0624\u062f\u064a \u0625\u0644\u0649 \u0646\u0642\u0635 \u0627\u0644\u0645\u0648\u0627\u0631\u062f \u0641\u064a \u0627\u0644\u0646\u0638\u0627\u0645. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u063a\u0627\u0644\u0628\u064b\u0627 \u0639\u0646\u062f \u062a\u062d\u062f\u064a\u062f \u0643\u0645\u064a\u0629 \u0630\u0627\u0643\u0631\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629\u060c \u0623\u0648 \u0639\u0646\u062f \u0627\u0633\u062a\u062e\u062f\u0627\u0645 JVM \u0645\u0646 \u0646\u0648\u0639 32 \u0628\u062a \u0644\u0627 \u064a\u0645\u0643\u0646\u0647 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0645\u0639 \u0643\u0645\u064a\u0627\u062a \u0643\u0628\u064a\u0631\u0629 \u0645\u0646 \u0627\u0644\u0630\u0627\u0643\u0631\u0629.</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0644\u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0642\u0645 \u0628\u062a\u0642\u0644\u064a\u0644 \u0643\u0645\u064a\u0629 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0645\u062e\u0635\u0635\u0629 \u0644\u0644\u062a\u0637\u0628\u064a\u0642. \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647 \u064a\u0639\u062a\u0645\u062f \u0639\u0644\u0649 \u0646\u0638\u0627\u0645\u0643\u060c \u0644\u0643\u0646\u0647 \u0639\u0627\u062f\u0629\u064b \u0644\u0627 \u064a\u062c\u0628 \u0623\u0646 \u064a\u062a\u062c\u0627\u0648\u0632 70-80\u066a \u0645\u0646 \u0625\u062c\u0645\u0627\u0644\u064a \u0630\u0627\u0643\u0631\u0629 RAM. \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 JVM 32 \u0628\u062a\u060c \u0641\u0625\u0646 \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0647\u0648 \u062d\u0648\u0627\u0644\u064a 2-3 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a \u0628\u063a\u0636 \u0627\u0644\u0646\u0638\u0631 \u0639\u0646 \u0643\u0645\u064a\u0629 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0641\u0639\u0644\u064a\u0629.</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0644\u062a\u0642\u0644\u064a\u0644 \u0630\u0627\u0643\u0631\u0629 heap \u0627\u0644\u0645\u062e\u0635\u0635\u0629 \u0644\u0644\u062a\u0637\u0628\u064a\u0642\u060c \u0627\u0641\u062a\u062d \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0644\u0627\u0646\u0634\u0631 \u0648\u0627\u0628\u062d\u062b \u0639\u0646 \u062e\u064a\u0627\u0631 \u0627\u0644\u0630\u0627\u0643\u0631\u0629. \u0642\u0644\u0644 \u0627\u0644\u0642\u064a\u0645\u0629 \u0627\u0644\u0642\u0635\u0648\u0649 (Xmx) \u0625\u0644\u0649 \u0643\u0645\u064a\u0629 \u0645\u0646\u0627\u0633\u0628\u0629. \u0639\u0644\u0649 \u0633\u0628\u064a\u0644 \u0627\u0644\u0645\u062b\u0627\u0644\u060c \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0644\u062f\u064a\u0643 8 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a \u0645\u0646 RAM\u060c \u062e\u0635\u0635 3-4 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a \u0644\u0644\u062a\u0637\u0628\u064a\u0642. \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0644\u062f\u064a\u0643 16 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u062e\u0635\u064a\u0635 6-8 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a. \u062a\u0623\u0643\u062f \u0645\u0646 \u062a\u0631\u0643 \u0630\u0627\u0643\u0631\u0629 \u0643\u0627\u0641\u064a\u0629 \u0644\u0644\u0646\u0638\u0627\u0645 \u0648\u0627\u0644\u0628\u0631\u0627\u0645\u062c \u0627\u0644\u0623\u062e\u0631\u0649.</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0644\u0641\u0627\u062a \u0623\u0633\u0627\u0633\u064a\u0629 \u0645\u0646 Forge. \u0627\u0644\u0645\u0644\u0641 '" + archivo + "' \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a \u062a\u062b\u0628\u064a\u062a\u0643. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0627\u062f\u0629\u064b \u0639\u0646\u062f \u062a\u0648\u0642\u0641 \u062a\u062b\u0628\u064a\u062a Forge \u0623\u0648 \u062d\u0630\u0641 \u0645\u0644\u0641\u0627\u062a \u0645\u0647\u0645\u0629. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 QuickFix \u0627\u0633\u062a\u0639\u0627\u062f\u0629 \u0647\u0630\u0647 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627. \u064a\u062c\u0628 \u0639\u0644\u064a\u0643 \u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a Forge \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0645\u062b\u0628\u062a \u0627\u0644\u0631\u0633\u0645\u064a.</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 Forge \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u0645\u0637\u0644\u0648\u0628. \u0627\u0644\u0625\u0635\u062f\u0627\u0631 " + version + " \u0645\u0637\u0644\u0648\u0628 \u0644\u0643\u0646\u0647 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0627\u0644\u0645\u0644\u0641 '" + archivo + "'. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f \u0639\u062f\u0645 \u0627\u0644\u062a\u0648\u0627\u0641\u0642 \u0628\u064a\u0646 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0648\u0625\u0635\u062f\u0627\u0631 Forge. \u062a\u0623\u0643\u062f \u0645\u0646 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0635\u062d\u064a\u062d \u0645\u0646 Forge \u0627\u0644\u0645\u0637\u0627\u0628\u0642 \u0644\u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0644\u062f\u064a\u0643.</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0639\u0630\u0631 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0647\u062f\u0641 'fmlclient' \u0627\u0644\u0644\u0627\u0632\u0645 \u0644\u062a\u0634\u063a\u064a\u0644 Forge. \u0647\u0630\u0627 \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u062a\u062b\u0628\u064a\u062a \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644 \u0623\u0648 \u062a\u0627\u0644\u0641. \u0631\u0628\u0645\u0627 \u0644\u0645 \u062a\u064f\u062b\u0628\u062a \u0645\u0644\u0641\u0627\u062a Forge \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d. \u064a\u062c\u0628 \u0639\u0644\u064a\u0643 \u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a Forge \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0645\u062b\u0628\u062a \u0627\u0644\u0631\u0633\u0645\u064a.</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0639\u0630\u0631 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0641\u0626\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0644\u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0641\u064a \u0645\u062d\u0645\u0644 \u0627\u0644\u0641\u0626\u0627\u062a. \u0647\u0630\u0627 \u064a\u0634\u064a\u0631 \u0639\u0627\u062f\u0629\u064b \u0625\u0644\u0649 \u062a\u062b\u0628\u064a\u062a Forge \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644 \u0623\u0648 \u062a\u0639\u0627\u0631\u0636 \u0645\u0639 \u0645\u0648\u062f\u0627\u062a \u0623\u062e\u0631\u0649. \u0642\u062f \u062a\u0643\u0648\u0646 \u0645\u0644\u0641\u0627\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u062a\u0627\u0644\u0641\u0629 \u0628\u0633\u0628\u0628 \u062a\u062b\u0628\u064a\u062a Forge. \u064a\u062c\u0628 \u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a Forge \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062b\u0628\u064a\u062a Forge \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644. \u0642\u062f \u064a\u0643\u0648\u0646 \u0628\u0633\u0628\u0628 \u062a\u062b\u0628\u064a\u062a \u0645\u062a\u0648\u0642\u0641\u060c \u0623\u0648 \u0645\u0644\u0641\u0627\u062a \u0645\u062d\u0630\u0648\u0641\u0629\u060c \u0623\u0648 \u0639\u062f\u0645 \u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0644\u062f\u064a\u0643. \u064a\u062d\u062a\u0627\u062c Forge \u0625\u0644\u0649 \u0645\u0644\u0641\u0627\u062a \u0645\u062d\u062f\u062f\u0629 \u0644\u0644\u0639\u0645\u0644\u060c \u0648\u0628\u0639\u0636\u0647\u0627 \u0645\u0641\u0642\u0648\u062f \u0645\u0646 \u0627\u0644\u062a\u062b\u0628\u064a\u062a \u0627\u0644\u062d\u0627\u0644\u064a.</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "\u062a\u062b\u0628\u064a\u062a Forge \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0644\u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0623\u0639\u062f \u062a\u062b\u0628\u064a\u062a Forge \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d. \u062a\u0623\u0643\u062f \u0645\u0646 \u062a\u0646\u0632\u064a\u0644 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0645\u0646\u0627\u0633\u0628 \u0644\u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643\u060c \u0648\u0627\u062a\u0628\u0639 \u0639\u0645\u0644\u064a\u0629 \u0627\u0644\u062a\u062b\u0628\u064a\u062a \u0628\u0627\u0644\u0643\u0627\u0645\u0644 \u062f\u0648\u0646 \u0645\u0642\u0627\u0637\u0639\u0629.</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "\u062a\u0646\u0632\u064a\u0644 Forge \u0631\u0633\u0645\u064a\u064b\u0627";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "\u0643\u064a\u0641\u064a\u0629 \u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a Forge \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>\u062a\u0639\u0644\u064a\u0645\u0627\u062a \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a Forge:</h3><ol><li>\u0642\u0645 \u0628\u062a\u0646\u0632\u064a\u0644 \u0645\u062b\u0628\u062a Forge \u0627\u0644\u0635\u062d\u064a\u062d \u0645\u0646 \u0627\u0644\u0645\u0648\u0642\u0639 \u0627\u0644\u0631\u0633\u0645\u064a (\u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647 \u0644\u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643)</li><li>\u0623\u063a\u0644\u0642 \u0628\u0627\u0644\u0643\u0627\u0645\u0644 \u0628\u0631\u0646\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a</li><li>\u0634\u063a\u0651\u0644 \u0645\u062b\u0628\u062a Forge \u0643\u0645\u0633\u0624\u0648\u0644</li><li>\u0627\u062e\u062a\u0631 \u062e\u064a\u0627\u0631 'Installer' (\u0648\u0644\u064a\u0633 'Installer (run client)')</li><li>\u0627\u062e\u062a\u0631 \u0645\u062c\u0644\u062f \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0641\u064a \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c</li><li>\u0627\u0636\u063a\u0637 '\u0645\u0648\u0627\u0641\u0642' \u0648\u0627\u0646\u062a\u0638\u0631 \u0627\u0643\u062a\u0645\u0627\u0644 \u0627\u0644\u062a\u062b\u0628\u064a\u062a</li><li>\u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0648\u062a\u0623\u0643\u062f \u0645\u0646 \u0638\u0647\u0648\u0631 Forge \u0641\u064a \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0634\u062e\u0635\u064a\u0629</li></ol><p><b>\u0645\u0644\u0627\u062d\u0638\u0629 \u0645\u0647\u0645\u0629:</b> \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0628\u0631\u0646\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 \u0645\u062e\u0635\u0635\u064b\u0627\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0645\u062c\u0644\u062f \u0627\u0644\u0635\u062d\u064a\u062d \u0644\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a.</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "\u062a\u0639\u0644\u064a\u0645\u0627\u062a \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a Forge";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0631\u0628\u0637: \u0641\u0634\u0644 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 " + nombreBiblioteca + ". \u0627\u0644\u062d\u0644\u0648\u0644 \u0627\u0644\u0645\u0645\u0643\u0646\u0629:<br/><br/>\u0623) \u0623\u0636\u0641 \u0627\u0644\u062f\u0644\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 -Djava.library.path \u0623\u0648 -Dorg.lwjgl.librarypath.<br/>\u0628) \u0623\u0636\u0641 \u0645\u0644\u0641 JAR \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 classpath.<br/><br/>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u0644\u0627 \u064a\u0633\u062a\u0637\u064a\u0639 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629 \u0644\u0644\u062a\u0634\u063a\u064a\u0644. \u0648\u0647\u0648 \u0646\u0627\u062a\u062c \u0639\u0627\u062f\u0629\u064b \u0639\u0646 \u062a\u062b\u0628\u064a\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644 \u0623\u0648 \u0645\u0634\u0627\u0643\u0644 \u0641\u064a \u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u0646\u0638\u0627\u0645.</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0631\u0628\u0637";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0641\u0634\u0644 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0645\u0643\u062a\u0628\u0629. \u0627\u0644\u062d\u0644\u0648\u0644 \u0627\u0644\u0645\u0645\u0643\u0646\u0629:<br/><br/>\u0623) \u0623\u0636\u0641 \u0627\u0644\u062f\u0644\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 -Djava.library.path \u0623\u0648 -Dorg.lwjgl.librarypath.<br/>\u0628) \u0623\u0636\u0641 \u0645\u0644\u0641 JAR \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 classpath.<br/><br/>\u0647\u0630\u0647 \u0627\u0644\u062d\u0644\u0648\u0644 \u0627\u0644\u062a\u0642\u0646\u064a\u0629 \u0645\u062e\u0635\u0635\u0629 \u0644\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0627\u0644\u0645\u062a\u0642\u062f\u0645\u064a\u0646. \u0645\u0639\u0638\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u0627\u0648\u0644\u0648\u0627 \u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0642\u0628\u0644 \u062a\u0639\u062f\u064a\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0639\u0644\u0645\u0627\u062a.</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u0631\u0628 \u0641\u064a \u0627\u0644\u0645\u0639\u0631\u0641\u0627\u062a (IDs): \u0627\u0644\u0645\u0639\u0631\u0641 <strong>" + id + "</strong> \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0628\u0648\u0627\u0633\u0637\u0629 <strong>" + modOrigen + "</strong> \u0639\u0646\u062f \u0645\u062d\u0627\u0648\u0644\u0629 \u0625\u0636\u0627\u0641\u0629 <strong>" + modDestino + "</strong>. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u064a\u062d\u0627\u0648\u0644 \u0645\u0648\u062f\u0627\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0646\u0641\u0633 \u0627\u0644\u0645\u0639\u0631\u0641 \u0644\u0639\u0646\u0627\u0635\u0631 \u0645\u062e\u062a\u0644\u0641\u0629.</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u062a\u062c\u0627\u0648\u0632 \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0644\u0644\u0645\u0639\u0631\u0641\u0627\u062a. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u062a\u0633\u062c\u064a\u0644 \u0643\u062a\u0644 \u0623\u0648 \u0639\u0646\u0627\u0635\u0631 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0639\u0631\u0641\u0627\u062a \u062e\u0627\u0631\u062c \u0627\u0644\u0646\u0637\u0627\u0642 \u0627\u0644\u0645\u062f\u0639\u0648\u0645 \u0645\u0646 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "\u062a\u0636\u0627\u0631\u0628 \u0641\u064a \u0627\u0644\u0645\u0639\u0631\u0641\u0627\u062a";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0644\u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a 1.12.2\u060c \u0642\u0645 \u0628\u062a\u062b\u0628\u064a\u062a <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a>. \u0623\u0645\u0627 \u0641\u064a 1.7.10\u060c \u0627\u0633\u062a\u062e\u062f\u0645 <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a>.</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0627\u0633\u062a\u062e\u062f\u0645 \u0623\u062f\u0648\u0627\u062a \u0645\u062b\u0644 <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> \u0623\u0648 <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a> \u0644\u062d\u0644 \u062a\u0636\u0627\u0631\u0628 \u0627\u0644\u0645\u0639\u0631\u0641\u0627\u062a.</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "\u062a\u062b\u0628\u064a\u062a JustEnoughIDs";
    }

    @Override
    public String instalar_endlessids() {
        return "\u062a\u062b\u0628\u064a\u062a EndlessIDs";
    }

    @Override
    public String usar_idfix_minus() {
        return "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 IdFix Minus \u0623\u0648 IdFix";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 Minecraft-ID-Resolver";
    }

    @Override
    public String ver_documentacion_jp() {
        return "\u0639\u0631\u0636 \u0627\u0644\u0648\u062b\u0627\u0626\u0642 \u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629";
    }

    @Override
    public String escanearDeMCreator() {
        return "\u0645\u0633\u062d MCreator";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\u0634\u062c\u0631\u0629 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0648\u0627\u0644\u0637\u0628\u0642\u0627\u062a";
    }

    @Override
    public String tipoBusqueda() {
        return "\u0627\u0644\u0646\u0648\u0639";
    }

    @Override
    public String filtroTodos() {
        return "\u0627\u0644\u0643\u0644";
    }

    @Override
    public String filtroPaquetes() {
        return "\u0627\u0644\u062d\u0632\u0645";
    }

    @Override
    public String filtroClases() {
        return "\u0627\u0644\u0637\u0628\u0642\u0627\u062a";
    }

    @Override
    public String filtroMetodos() {
        return "\u0627\u0644\u0637\u0631\u0642";
    }

    @Override
    public String filtroCampos() {
        return "\u0627\u0644\u062d\u0642\u0648\u0644";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0627\u0644\u062d\u0642\u0648\u0644";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0627\u0644\u0637\u0631\u0642";
    }

    @Override
    public String filtroReferenciasClase() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0627\u0644\u0637\u0628\u0642\u0627\u062a";
    }

    @Override
    public String tipBuscar() {
        return "\u0627\u0643\u062a\u0628 \u0647\u0646\u0627 \u0644\u0644\u0628\u062d\u062b \u0641\u064a \u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a";
    }

    @Override
    public String botonBuscar() {
        return "\u0628\u062d\u062b";
    }

    @Override
    public String botonResetearArbol() {
        return "\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0627\u0644\u0634\u062c\u0631\u0629";
    }

    @Override
    public String modsCargados() {
        return "\u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u0645\u062d\u0645\u0644\u0629";
    }

    @Override
    public String clases() {
        return "\u0627\u0644\u0637\u0628\u0642\u0627\u062a";
    }

    @Override
    public String metodos() {
        return "\u0627\u0644\u0637\u0631\u0642";
    }

    @Override
    public String campos() {
        return "\u0627\u0644\u062d\u0642\u0648\u0644";
    }

    @Override
    public String referencias() {
        return "\u0627\u0644\u0645\u0631\u0627\u062c\u0639";
    }

    @Override
    public String resultadosBusqueda() {
        return "\u0646\u062a\u0627\u0626\u062c \u0627\u0644\u0628\u062d\u062b";
    }

    @Override
    public String buscarReferencias() {
        return "\u0627\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u0645\u0631\u0627\u062c\u0639";
    }

    @Override
    public String referenciasMod() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0627\u0644\u0645\u0648\u062f";
    }

    @Override
    public String referenciasClase() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0627\u0644\u0637\u0628\u0642\u0629";
    }

    @Override
    public String referenciasMetodo() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0627\u0644\u0637\u0631\u064a\u0642\u0629";
    }

    @Override
    public String referenciasCampo() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0627\u0644\u062d\u0642\u0644";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0631\u0627\u062c\u0639";
    }

    @Override
    public String detalleMod() {
        return "\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0648\u062f:";
    }

    @Override
    public String ubicacion() {
        return "\u0627\u0644\u0645\u0648\u0642\u0639";
    }

    @Override
    public String nombres() {
        return "\u0627\u0644\u0623\u0633\u0645\u0627\u0621";
    }

    @Override
    public String modulo() {
        return "\u0627\u0644\u0648\u062d\u062f\u0629";
    }

    @Override
    public String detalleClase() {
        return "\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0637\u0628\u0642\u0629:";
    }

    @Override
    public String detalleMetodo() {
        return "\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0637\u0631\u064a\u0642\u0629:";
    }

    @Override
    public String detalleCampo() {
        return "\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u062d\u0642\u0644:";
    }

    @Override
    public String clase() {
        return "\u0627\u0644\u0637\u0628\u0642\u0629";
    }

    @Override
    public String tipo() {
        return "\u0627\u0644\u0646\u0648\u0639";
    }

    @Override
    public String referenciasAMetodos() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0625\u0644\u0649 \u0627\u0644\u0637\u0631\u0642:";
    }

    @Override
    public String referenciasACampos() {
        return "\u0645\u0631\u0627\u062c\u0639 \u0625\u0644\u0649 \u0627\u0644\u062d\u0642\u0648\u0644:";
    }

    @Override
    public String arbolDeMods() {
        return "\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a";
    }

    @Override
    public String metodo() {
        return "\u0627\u0644\u0637\u0631\u064a\u0642\u0629";
    }

    @Override
    public String campo() {
        return "\u0627\u0644\u062d\u0642\u0644";
    }

    @Override
    public String descompilar() {
        return "\u0641\u0643 \u0627\u0644\u062a\u062c\u0645\u064a\u0639";
    }

    @Override
    public String exportar() {
        return "\u062a\u0635\u062f\u064a\u0631";
    }

    @Override
    public String importar() {
        return "\u0627\u0633\u062a\u064a\u0631\u0627\u062f";
    }

    @Override
    public String errorImportar() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0627\u0633\u062a\u064a\u0631\u0627\u062f";
    }

    @Override
    public String estructuraImportada() {
        return "\u0627\u0644\u0647\u064a\u0643\u0644\u0629 \u0627\u0644\u0645\u0633\u062a\u0648\u0631\u062f\u0629";
    }

    @Override
    public String estructuraExportada() {
        return "\u0627\u0644\u0647\u064a\u0643\u0644\u0629 \u0627\u0644\u0645\u0635\u062f\u0631\u0629";
    }

    @Override
    public String errorExportar() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u062a\u0635\u062f\u064a\u0631";
    }

    @Override
    public String exportando() {
        return "\u062c\u0627\u0631\u064a \u0627\u0644\u062a\u0635\u062f\u064a\u0631";
    }

    @Override
    public String exportacionTardara() {
        return "\u0642\u062f \u064a\u0633\u062a\u063a\u0631\u0642 \u0627\u0644\u062a\u0635\u062f\u064a\u0631 \u0648\u0642\u062a\u064b\u0627";
    }

    @Override
    public String porFavorEspere() {
        return "\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0644\u064a\u0633 \u0644\u062f\u064a\u0643 \u0645\u0644\u0641\u0627\u062a VLC \u0627\u0644\u062b\u0646\u0627\u0626\u064a\u0629. WaterMedia \u064a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0645\u0644\u0641\u0627\u062a VLC \u0627\u0644\u062b\u0646\u0627\u0626\u064a\u0629. \u064a\u062c\u0628 \u062a\u062b\u0628\u064a\u062a\u0647\u0627 \u064a\u062f\u0648\u064a\u064b\u0627 \u0645\u0646 https://www.videolan.org/vlc/.  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "\u062a\u0646\u0632\u064a\u0644 VLC";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u0627\u0633\u0645 \u0627\u0644\u0648\u062d\u062f\u0629 '" + nombreModulo + "' \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629. \u0627\u0644\u062c\u0632\u0621 '" + parteInvalida + "' \u0644\u064a\u0633 \u0645\u0639\u0631\u0641\u064b\u0627 \u0635\u0627\u0644\u062d\u064b\u0627 \u0641\u064a \u062c\u0627\u0641\u0627. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u064a\u0633\u062a\u062e\u062f\u0645 \u0645\u0648\u062f \u0643\u0644\u0645\u0627\u062a \u0645\u062d\u062c\u0648\u0632\u0629 \u0641\u064a \u062c\u0627\u0641\u0627 (\u0645\u062b\u0644 'true', 'class') \u0623\u0648 \u0623\u062d\u0631\u0641 \u063a\u064a\u0631 \u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627 \u0641\u064a \u0627\u0644\u0627\u0633\u0645.</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "\u0623\u062d\u0631\u0641 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629 \u0641\u064a \u0627\u0633\u0645 \u0627\u0644\u0645\u0648\u062f";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "\u0627\u0633\u0645 \u0627\u0644\u0645\u0648\u062f '" + nombreModulo + "' \u063a\u064a\u0631 \u0635\u0627\u0644\u062d \u0644\u0623\u0646\u0647 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 '" + parteInvalida + "', \u0648\u0647\u064a \u0643\u0644\u0645\u0629 \u0645\u062d\u062c\u0648\u0632\u0629 \u0641\u064a \u062c\u0627\u0641\u0627 \u0623\u0648 \u062d\u0631\u0641 \u063a\u064a\u0631 \u0645\u0633\u0645\u0648\u062d \u0628\u0647. \u0627\u0628\u062d\u062b \u0641\u064a \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0639\u0646 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0630\u064a \u064a\u0637\u0627\u0628\u0642 \u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0645 (\u0639\u0627\u062f\u0629\u064b \u0627\u0633\u0645 \u0645\u0644\u0641 JAR)";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "\u0627\u0630\u0647\u0628 \u0625\u0644\u0649 \u0645\u062c\u0644\u062f \u0627\u0644\u0645\u0648\u062f \u0648\u0642\u0645 \u0628\u062a\u062d\u0631\u064a\u0631 \u0645\u0644\u0641 <b>mods.toml</b> \u0627\u0644\u0645\u0648\u062c\u0648\u062f \u062f\u0627\u062e\u0644 \u0645\u062c\u0644\u062f <b>/META-INF/</b>. \u063a\u064a\u0651\u0631 \u0642\u064a\u0645\u0629 <b>modId</b> \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062d\u0631\u0648\u0641 \u0648\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0648\u0627\u0644\u0634\u0631\u0637\u0627\u062a \u0627\u0644\u0633\u0641\u0644\u064a\u0629 \u0641\u0642\u0637\u060c \u062f\u0648\u0646 \u0643\u0644\u0645\u0627\u062a \u0645\u062d\u062c\u0648\u0632\u0629 \u0641\u064a \u062c\u0627\u0641\u0627";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "\u0645\u062b\u0627\u0644 \u0639\u0644\u0649 \u0627\u0633\u0645 \u0635\u0627\u0644\u062d: 'truemod_shot_enchantment' \u0628\u062f\u0644\u0627\u064b \u0645\u0646 'true.shot.enchantment'. \u062a\u0630\u0643\u0631 \u0623\u0646 \u0623\u0633\u0645\u0627\u0621 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0646\u0642\u0627\u0637\u060c \u0634\u0631\u0637\u0627\u062a\u060c \u0623\u0648 \u0643\u0644\u0645\u0627\u062a \u0645\u062d\u062c\u0648\u0632\u0629 \u0641\u064a \u062c\u0627\u0641\u0627 \u0645\u062b\u0644 'true'\u060c 'false'\u060c \u0623\u0648 'class'";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c \u0641\u064a \u0627\u0644\u0645\u0648\u062f: '" + nombreJar + "'. \u064a\u0641\u062a\u0642\u062f \u0625\u0644\u0649 \u0627\u0644\u062d\u0642\u0644 \u0627\u0644\u0625\u0644\u0632\u0627\u0645\u064a 'mandatory' \u0641\u064a \u062a\u0628\u0639\u064a\u0627\u062a\u0647. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u0644\u0627 \u064a\u062d\u062f\u062f \u0645\u0644\u0641 mods.toml \u0645\u0627 \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0627\u0644\u062a\u0628\u0639\u064a\u0629 \u0625\u0644\u0632\u0627\u0645\u064a\u0629 \u0623\u0645 \u0644\u0627.</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "\u062a\u0628\u0639\u064a\u0629 \u0645\u0648\u062f \u0628\u062f\u0648\u0646 \u062d\u0642\u0644 \u0625\u0644\u0632\u0627\u0645\u064a";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "\u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629 \u0647\u0648: <b>" + nombreJar + "</b>. \u0647\u0630\u0627 \u0627\u0644\u0645\u0644\u0641 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u062e\u0637\u0623 \u0641\u064a \u062a\u0647\u064a\u0626\u0629 \u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "\u0627\u0641\u062a\u062d \u0645\u0644\u0641 <b>mods.toml</b> \u0627\u0644\u0645\u0648\u062c\u0648\u062f \u062f\u0627\u062e\u0644 \u0645\u062c\u0644\u062f <b>/META-INF/</b> \u0627\u0644\u062e\u0627\u0635 \u0628\u0627\u0644\u0645\u0648\u062f <b>" + nombreJar + "</b>";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "\u0641\u064a \u0642\u0633\u0645 \u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0643\u0644 \u0625\u062f\u062e\u0627\u0644 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 <b>mandatory=true</b> \u0623\u0648 <b>mandatory=false</b> (\u0645\u062b\u0627\u0644: modId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" )";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c \u0641\u064a \u0627\u0644\u0645\u0648\u062f: '" + nombreJar + "'. \u062a\u0647\u064a\u0626\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629 \u0644\u0640 access transformer. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641 \u0627\u0644\u062a\u0647\u064a\u0626\u0629 \u0628\u0647 \u0628\u0646\u064a\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 \u0623\u0648 \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0641\u0626\u0627\u062a/\u0637\u0631\u0642 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629.</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "Access Transformer \u063a\u064a\u0631 \u0635\u0627\u0644\u062d";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "\u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629 \u0647\u0648: <b>" + nombreJar + "</b>. \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u062f \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u062a\u0647\u064a\u0626\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629 \u0644\u0640 access transformer";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "\u0627\u0641\u062a\u062d \u0645\u0644\u0641 <b>accessTransformer.cfg</b> \u062f\u0627\u062e\u0644 \u0627\u0644\u0645\u0648\u062f <b>" + nombreJar + "</b> (\u0639\u0627\u062f\u0629\u064b \u0641\u064a \u0627\u0644\u0645\u062c\u0644\u062f \u0627\u0644\u062c\u0630\u0631\u064a \u0644\u0645\u0644\u0641 JAR)";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "\u0639\u062f\u0651\u0644 \u0628\u0646\u064a\u0629 access transformer. \u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0628\u0639 \u0627\u0644\u0623\u0633\u0637\u0631 \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u062a\u0627\u0644\u064a: <b>access class.method</b> (\u0645\u062b\u0627\u0644: public net.minecraft.world.entity.Entity.func_200560_a). \u0627\u062d\u0630\u0641 \u0627\u0644\u0623\u0633\u0637\u0631 \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0641\u0626\u0627\u062a \u0623\u0648 \u0637\u0631\u0642 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629 \u0641\u064a \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u062a\u0646\u0627\u0642\u0636 \u0628\u064a\u0646 \u0645\u0639\u0631\u0641 \u0627\u0644\u0645\u0648\u062f \u0641\u064a \u0627\u0644\u062a\u0639\u0644\u064a\u0642 @Mod \u0648\u0645\u0644\u0641 mods.toml. \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0648\u062f '" + nombreMod + "' \u0644\u0623\u0646 \u0627\u0644\u0645\u0639\u0631\u0641\u0627\u062a \u063a\u064a\u0631 \u0645\u062a\u0637\u0627\u0628\u0642\u0629.</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "\u062a\u0646\u0627\u0642\u0636 \u0628\u064a\u0646 @Mod \u0648 mods.toml";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "\u0627\u0644\u0645\u0648\u062f \u0642\u064a\u062f \u0627\u0644\u062a\u0637\u0648\u064a\u0631 '" + nombreMod + "' \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u062a\u0646\u0627\u0642\u0636 \u0628\u064a\u0646 \u0627\u0644\u0645\u0639\u0631\u0641 \u0641\u064a \u0627\u0644\u062a\u0639\u0644\u064a\u0642 <b>@Mod</b> \u0648\u0627\u0644\u0642\u064a\u0645\u0629 \u0641\u064a <b>mods.toml</b>";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "\u062a\u062d\u0642\u0642 \u0645\u0646 \u0623\u0646 \u0627\u0644\u0645\u0639\u0631\u0641 \u0641\u064a \u0641\u0635\u0644\u0643 \u0627\u0644\u0631\u0626\u064a\u0633\u064a \u0645\u0637\u0627\u0628\u0642 \u0644\u0642\u064a\u0645\u0629 <b>modId</b> \u0641\u064a \u0645\u0644\u0641 <b>/META-INF/mods.toml</b>. \u0645\u062b\u0627\u0644: <b>@Mod(\"mymod\")</b> \u064a\u062c\u0628 \u0623\u0646 \u064a\u0637\u0627\u0628\u0642 <b>modId=\"mymod\"</b>";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 Gradle\u060c \u0642\u0645 \u0628\u062a\u0634\u063a\u064a\u0644 <b>clean</b> \u0628\u0639\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0644\u0636\u0645\u0627\u0646 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0648\u0627\u0631\u062f \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d. \u0623\u062d\u064a\u0627\u0646\u064b\u0627 \u062a\u0628\u0642\u0649 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u0641\u064a \u0645\u062c\u0644\u062f build";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u0627\u0644\u0639\u0645\u064a\u0644" : "\u0627\u0644\u062e\u0627\u062f\u0645";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u0627\u0644\u062e\u0627\u062f\u0645" : "\u0627\u0644\u0639\u0645\u064a\u0644";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u064a\u062a\u0645 \u0645\u062d\u0627\u0648\u0644\u0629 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0635\u0646\u0641 '" + nombreClase + "' \u0641\u064a \u0628\u064a\u0626\u0629 " + plataforma + "\u060c \u0644\u0643\u0646\u0647 \u0645\u0635\u0645\u0645 \u0644\u0640 " + plataformaOpuesta + ". <b>\u0627\u0633\u062a\u062e\u062f\u0645 \u0648\u0638\u064a\u0641\u0629 '\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a' \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0630\u064a \u064a\u062d\u0627\u0648\u0644 \u062a\u062d\u0645\u064a\u0644 \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641</b>. \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0645\u0628\u0646\u064a\u0629 \u062e\u0635\u064a\u0635\u064b\u0627 \u0644\u0645\u0646\u0635\u0629 \u0645\u0639\u064a\u0646\u0629 \u0648\u0644\u0627 \u062a\u0639\u0645\u0644 \u0639\u0644\u0649 \u0627\u0644\u0623\u062e\u0631\u0649.</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "\u0645\u0648\u062f \u0639\u0644\u0649 \u0645\u0646\u0635\u0629 \u062e\u0627\u0637\u0626\u0629";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "\u0641\u064a \u0639\u0644\u0627\u0645\u0629 \u062a\u0628\u0648\u064a\u0628 <b>\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a</b> (\u0639\u0644\u0649 \u0627\u0644\u064a\u0645\u064a\u0646)\u060c \u0627\u0628\u062d\u062b \u0639\u0646 \u0645\u0631\u0627\u062c\u0639 \u0644\u0644\u0635\u0646\u0641 <b>" + nombreClase + "</b> \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u0627\u0644\u0639\u0645\u064a\u0644" : "\u0627\u0644\u062e\u0627\u062f\u0645";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u0627\u0644\u062e\u0627\u062f\u0645" : "\u0627\u0644\u0639\u0645\u064a\u0644";
        return "\u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u062d\u062f\u062f \u0647\u0648 \u0645\u0648\u062f \u0644\u0640 <b>" + plataformaOpuesta + "</b> \u0648\u0644\u0627 \u064a\u0646\u0628\u063a\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647 \u0641\u064a \u0628\u064a\u0626\u0629 " + plataforma + ".";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "\u0623\u0632\u0644 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629 \u0645\u0646 \u0645\u062c\u0644\u062f <b>\u0627\u0644\u0645\u0648\u062f\u0627\u062a</b>. \u0625\u0630\u0627 \u0643\u0646\u062a \u0628\u062d\u0627\u062c\u0629 \u0644\u0648\u0638\u064a\u0641\u0629 \u0645\u0634\u0627\u0628\u0647\u0629 \u0644\u0647\u0630\u0647 \u0627\u0644\u0645\u0646\u0635\u0629\u060c \u0627\u0628\u062d\u062b \u0639\u0646 \u0645\u0648\u062f \u0628\u062f\u064a\u0644 \u0645\u0635\u0645\u0645 \u062e\u0635\u064a\u0635\u064b\u0627 \u0644\u0640 <b>\u0627\u0644\u0639\u0645\u064a\u0644</b> \u0623\u0648 <b>\u0627\u0644\u062e\u0627\u062f\u0645</b> \u062d\u0633\u0628 \u0627\u0644\u062d\u0627\u062c\u0629";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u0627\u0644\u0645\u064a\u062a\u0627\u062f\u0627\u062a\u0627 \u0645\u0641\u0642\u0648\u062f\u0629 \u0644\u0644\u0640 modid '").append(modIdFaltante).append("'. ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("\u0642\u062f \u062a\u0643\u0648\u0646 \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u0647\u064a \u0627\u0644\u0645\u0633\u0628\u0628\u0629 \u0644\u0644\u0645\u0634\u0643\u0644\u0629: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u064a\u0639\u062a\u0645\u062f \u0645\u0648\u062f \u0639\u0644\u0649 \u0645\u0648\u062f \u0622\u062e\u0631 \u063a\u064a\u0631 \u0645\u062b\u0628\u062a \u0623\u0648 \u0644\u062f\u064a\u0647 \u0645\u0644\u0641 mods.toml \u063a\u064a\u0631 \u0635\u062d\u064a\u062d.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "\u0645\u064a\u062a\u0627\u062f\u0627\u062a\u0627 mods.toml \u0645\u0641\u0642\u0648\u062f\u0629";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u062a\u0639\u062a\u0645\u062f \u0627\u0644\u0645\u0648\u062f\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629 \u0639\u0644\u0649 '").append(modIdFaltante).append("': <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            paso.append("</b>. \u0627\u0633\u062a\u062e\u062f\u0645 \u0648\u0638\u064a\u0641\u0629 <b>\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a</b> \u0644\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629");
            return paso.toString();
        }
        return "\u0645\u0648\u062f \u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0639\u0644\u0649 '" + modIdFaltante + "'\u060c \u0644\u0643\u0646 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u062f \u063a\u064a\u0631 \u0645\u062b\u0628\u062a. \u0627\u0633\u062a\u062e\u062f\u0645 \u0648\u0638\u064a\u0641\u0629 <b>\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a</b> \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629";
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u0644\u062f\u064a\u0643 \u062e\u064a\u0627\u0631\u0627\u0646:<br/>1. <b>\u062b\u0628\u062a \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0641\u0642\u0648\u062f</b>: \u0627\u0628\u062d\u062b \u0648\u062b\u0628\u062a \u0627\u0644\u0645\u0648\u062f \u0630\u0627 \u0627\u0644\u0645\u0639\u0631\u0641 '" + modIdFaltante + "'<br/>2. <b>\u0623\u0632\u0644 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0645\u0639\u062a\u0645\u062f</b>: \u0625\u0630\u0627 \u0644\u0645 \u062a\u0643\u0646 \u0628\u062d\u0627\u062c\u0629 \u0644\u0644\u0648\u0638\u064a\u0641\u0629\u060c \u0623\u0632\u0644 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0630\u064a \u064a\u0639\u062a\u0645\u062f \u0639\u0644\u0649 '" + modIdFaltante + "'";
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u0625\u0630\u0627 \u0643\u0627\u0646 \u0627\u0644\u0645\u0648\u062f '" + modIdFaltante + "' \u0645\u0643\u062a\u0628\u0629 (\u0645\u062b\u0644 'forge', 'minecraft', 'curios')\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0648 Forge \u0635\u062d\u064a\u062d\u0629. \u0625\u0630\u0627 \u0643\u0627\u0646 \u0645\u0648\u062f\u064b\u0627 \u0639\u0627\u062f\u064a\u064b\u0627\u060c \u062a\u062d\u0642\u0642 \u0645\u0646 \u0635\u0641\u062d\u0629 \u0627\u0644\u062a\u0646\u0632\u064a\u0644 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0647 \u0644\u0645\u0639\u0631\u0641\u0629 \u0627\u0644\u0645\u062a\u0637\u0644\u0628\u0627\u062a \u0627\u0644\u0645\u0633\u0628\u0642\u0629";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u062a\u062d\u0630\u064a\u0631: \u0641\u0634\u0644 \u0641\u064a \u062a\u0647\u064a\u0626\u0629 \u0646\u0638\u0627\u0645 \u0627\u0644\u0635\u0648\u062a. \u062a\u0645 \u062a\u0639\u0637\u064a\u0644 \u0627\u0644\u0623\u0635\u0648\u0627\u062a \u0648\u0627\u0644\u0645\u0648\u0633\u064a\u0642\u0649. \u064a\u0631\u062a\u0628\u0637 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0627\u062f\u0629\u064b \u0628\u062a\u0639\u062f\u064a\u0644 SoundPhysicsMod \u0648\u0642\u062f \u064a\u0643\u0648\u0646 \u0646\u0627\u062a\u062c\u064b\u0627 \u0639\u0646 \u062a\u0639\u0627\u0631\u0636\u0627\u062a \u0645\u0639 \u0645\u0643\u062a\u0628\u0627\u062a \u0635\u0648\u062a\u064a\u0629 \u0623\u062e\u0631\u0649.</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0646\u0638\u0627\u0645 \u0627\u0644\u0635\u0648\u062a";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "\u0627\u0644\u062e\u0637\u0623 \u0645\u0631\u062a\u0628\u0637 \u0639\u0627\u062f\u0629\u064b \u0628\u0640 <b>SoundPhysicsMod</b>. \u062a\u062d\u0642\u0642 \u0645\u0645\u0627 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0635\u0648\u062a \u0623\u062e\u0631\u0649 (\u0645\u062b\u0644 Sound Filters\u060c Dynamic Surroundings\u060c \u0625\u0644\u062e)\u060c \u062c\u0631\u0628 \u0625\u0632\u0627\u0644\u0629 SoundPhysicsMod \u0645\u0624\u0642\u062a\u064b\u0627 \u0644\u0645\u0639\u0631\u0641\u0629 \u0645\u0627 \u0625\u0630\u0627 \u0643\u0627\u0646 \u0630\u0644\u0643 \u064a\u062d\u0644 \u0627\u0644\u062a\u0639\u0627\u0631\u0636";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "\u062a\u062d\u0642\u0642 \u0645\u0646 \u0645\u062c\u0644\u062f <b>logs</b> \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0631\u0633\u0627\u0626\u0644 \u0625\u0636\u0627\u0641\u064a\u0629 \u062a\u062a\u0639\u0644\u0642 \u0628\u0640 LWJGL \u0623\u0648 OpenAL\u060c \u0648\u0627\u0644\u062a\u064a \u0642\u062f \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0645\u0634\u0627\u0643\u0644 \u0641\u064a \u0645\u0643\u062a\u0628\u0627\u062a \u0627\u0644\u0635\u0648\u062a \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u0627\u0644\u0635\u0646\u0641 '").append(nombreClase).append("' \u0645\u0633\u062c\u0644 \u0643\u0640 listener \u0644\u0644\u0623\u062d\u062f\u0627\u062b \u0644\u0643\u0646\u0647 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0633\u0627\u0644\u064a\u0628 \u0635\u0627\u0644\u062d\u0629. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u064a\u0648\u062c\u062f \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641 \u0641\u064a \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u064a\u062a\u0645 \u062a\u0633\u062c\u064a\u0644 \u0635\u0646\u0641 \u0644\u0644\u0627\u0633\u062a\u0645\u0627\u0639 \u0625\u0644\u0649 \u0627\u0644\u0623\u062d\u062f\u0627\u062b \u062f\u0648\u0646 \u0648\u062c\u0648\u062f \u0623\u0633\u0627\u0644\u064a\u0628 \u0645\u0639\u0644\u0645\u0629 \u0628\u0640 @SubscribeEvent.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "\u0635\u0646\u0641 \u0645\u0633\u062c\u0644 \u0628\u062f\u0648\u0646 \u0645\u0633\u062a\u0645\u0639\u064a \u0623\u062d\u062f\u0627\u062b";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0634\u0643\u0644 \u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0647\u0630\u0647 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            paso.append("</b>. \u0647\u0630\u0647 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u062a\u062d\u0627\u0648\u0644 \u062a\u0633\u062c\u064a\u0644 \u0623\u062d\u062f\u0627\u062b \u062f\u0648\u0646 \u0623\u0633\u0627\u0644\u064a\u0628 \u0635\u0627\u0644\u062d\u0629");
            return paso.toString();
        }
        return "\u062a\u0645 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0635\u0646\u0641 <b>" + nombreClase + "</b> \u0644\u0644\u0627\u0633\u062a\u0645\u0627\u0639 \u0625\u0644\u0649 \u0627\u0644\u0623\u062d\u062f\u0627\u062b \u0644\u0643\u0646\u0647 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0633\u0627\u0644\u064a\u0628 \u0645\u0639\u0644\u0645\u0629 \u0628\u0640 <b>@SubscribeEvent</b>. \u0627\u0633\u062a\u062e\u062f\u0645 \u0648\u0638\u064a\u0641\u0629 <b>\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a</b> \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "\u0641\u064a \u0627\u0644\u0643\u0648\u062f \u0627\u0644\u0645\u0635\u062f\u0631\u064a\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0627\u0644\u0635\u0646\u0641 <b>" + nombreClase + "</b> \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0633\u0644\u0648\u0628 \u0648\u0627\u062d\u062f \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 \u0628\u0640: <b>@SubscribeEvent public void \u0627\u0633\u0645_\u0627\u0644\u0623\u0633\u0644\u0648\u0628(\u062d\u062f\u062b_\u0645\u062d\u062f\u062f \u062d\u062f\u062b) { ... }</b>. \u0625\u0630\u0627 \u0643\u0627\u0646 \u0635\u0646\u0641\u064b\u0627 \u062f\u0627\u062e\u0644\u064a\u064b\u0627\u060c \u062a\u0623\u0643\u062f \u0623\u0646\u0647 \u0644\u064a\u0633 \u062b\u0627\u0628\u062a\u064b\u0627 (static)";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("\u0628\u0627\u0644\u0646\u0633\u0628\u0629 \u0644\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u0639\u0631\u0648\u0641\u0629 (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", \u0625\u0644\u062e.");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("\u0627\u062a\u0635\u0644 \u0628\u0645\u0637\u0648\u0651\u0631 \u0647\u0630\u0627 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0644\u0625\u0635\u0644\u0627\u062d \u0627\u0644\u0645\u0634\u0643\u0644\u0629. ");
            } else {
                paso.append("\u0627\u062a\u0635\u0644 \u0628\u0645\u0637\u0648\u0631\u064a \u0647\u0630\u0647 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0644\u0625\u0635\u0644\u0627\u062d \u0627\u0644\u0645\u0634\u0643\u0644\u0629. ");
            }
        }
        paso.append("\u0625\u0630\u0627 \u0643\u0646\u062a \u0627\u0644\u0645\u0637\u0648\u0631\u060c \u0627\u062d\u0630\u0641 \u062a\u0633\u062c\u064a\u0644 \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641 \u0641\u064a EventBus \u0623\u0648 \u0623\u0636\u0641 \u0623\u0633\u0627\u0644\u064a\u0628 @SubscribeEvent \u0635\u0627\u0644\u062d\u0629");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u062d\u062f\u062b \u0627\u0633\u062a\u062b\u0646\u0627\u0621 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' \u0623\u062b\u0646\u0627\u0621 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0645\u0644\u0641 '" + nombreArchivo + "'. \u064a\u0634\u064a\u0631 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0625\u0644\u0649 \u0623\u0646 \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u0645\u064f\u0634\u063a\u0644 \u0641\u0634\u0644 \u0641\u064a \u062a\u0646\u0632\u064a\u0644 \u0623\u0648 \u0627\u0633\u062a\u062e\u0631\u0627\u062c \u0645\u0644\u0641\u0627\u062a \u0627\u0644\u062d\u0632\u0645\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d. \u0627\u0644\u0631\u0633\u0627\u0644\u0629 'zip END header not found' \u062a\u064f\u0638\u0647\u0631 \u0623\u0646 \u0645\u0644\u0641 JAR \u0646\u0627\u0642\u0635 \u0623\u0648 \u062a\u0627\u0644\u0641\u060c \u0648\u0647\u0648 \u0623\u0645\u0631 \u0634\u0627\u0626\u0639 \u062c\u062f\u064b\u0627 \u0641\u064a \u0627\u0644\u0628\u0631\u0627\u0645\u062c \u0627\u0644\u062a\u064a \u0644\u0627 \u062a\u064f\u062f\u0627\u0631 \u062c\u064a\u062f\u064b\u0627 \u0639\u0646\u062f \u062a\u0646\u0632\u064a\u0644 \u0645\u0644\u0641\u0627\u062a \u0643\u0628\u064a\u0631\u0629. \u064a\u0624\u062b\u0631 \u0647\u0630\u0627 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0628\u0634\u0643\u0644 \u0631\u0626\u064a\u0633\u064a \u0639\u0644\u0649 \u0645\u0633\u062a\u062e\u062f\u0645\u064a Twitch/CurseForge\u060c Technic Launcher\u060c \u0648\u062e\u0635\u0648\u0635\u064b\u0627 \u0645\u0633\u062a\u062e\u062f\u0645\u064a Luna Pixel\u060c \u0644\u0623\u0646 \u0647\u0630\u0647 \u0627\u0644\u0628\u0631\u0627\u0645\u062c \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u062a\u0641\u0634\u0644 \u0641\u064a \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0633\u0644\u0627\u0645\u0629 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u062d\u0645\u0644\u0629. \u064a\u0646\u0628\u063a\u064a \u0639\u0644\u0649 \u0645\u0633\u062a\u062e\u062f\u0645\u064a Luna Pixel \u0627\u0644\u062a\u0641\u0643\u064a\u0631 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645 ATLauncher \u0643\u0628\u062f\u064a\u0644 \u0623\u0643\u062b\u0631 \u0627\u0633\u062a\u0642\u0631\u0627\u0631\u064b\u0627\u060c \u062d\u064a\u062b \u064a\u062a\u0639\u0627\u0645\u0644 \u0628\u0634\u0643\u0644 \u0623\u0641\u0636\u0644 \u0645\u0639 \u0633\u0644\u0627\u0645\u0629 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0648\u064a\u062a\u062c\u0646\u0628 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u062a\u062d\u062f\u064a\u062f\u064b\u0627. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u0646\u0638\u0627\u0645 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0644\u0623\u0646 \u062a\u0646\u0633\u064a\u0642 ZIP \u062a\u0627\u0644\u0641\u060c \u0645\u0645\u0627 \u064a\u0645\u0646\u0639 Forge \u0645\u0646 \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0645\u0648\u0627\u0631\u062f \u0627\u0644\u0644\u0627\u0632\u0645\u0629 \u0644\u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "\u062e\u0637\u0623 UnionFileSystem - \u0645\u0644\u0641 \u062a\u0627\u0644\u0641";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "\u0623\u0639\u062f \u062a\u062b\u0628\u064a\u062a \u0627\u0644\u062d\u0632\u0645\u0629 \u0628\u0627\u0644\u0643\u0627\u0645\u0644 \u0645\u0646 \u0627\u0644\u0628\u062f\u0627\u064a\u0629";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 Luna Pixel\u060c \u0641\u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 ATLauncher";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u062a\u0635\u0627\u0644 \u0627\u0644\u0625\u0646\u062a\u0631\u0646\u062a \u0648\u0645\u0633\u0627\u062d\u0629 \u0627\u0644\u0642\u0631\u0635 \u0642\u0628\u0644 \u0625\u0639\u0627\u062f\u0629 \u0627\u0644\u062a\u062b\u0628\u064a\u062a";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "\u0647\u0644 \u062a\u0631\u063a\u0628 \u0641\u064a \u062a\u0645\u0643\u064a\u0646 ProxySysOutSysErr\u061f\n\n\u064a\u0645\u0646\u062d \u0647\u0630\u0627 \u0627\u0644\u062e\u064a\u0627\u0631 \u0628\u0631\u0646\u0627\u0645\u062c CrashDetector \u0648\u0635\u0648\u0644\u0627\u064b \u0625\u0644\u0649 System.out \u0648 System.err \u0639\u0646\u062f\u0645\u0627 \u0644\u0627 \u064a\u0648\u0641\u0631 \u0627\u0644\u0645\u0634\u063a\u0644 \u0633\u062c\u0644\u0627\u062a.\n\n\u064a\u062c\u0628 \u062a\u0645\u0643\u064a\u0646\u0647 \u0641\u0642\u0637 \u0639\u0646\u062f\u0645\u0627 \u0644\u0627 \u062a\u062a\u0645\u0643\u0646 \u0645\u0646 \u0644\u0635\u0642 \u0627\u0644\u0633\u062c\u0644 \u064a\u062f\u0648\u064a\u064b\u0627.\n\n\u062a\u062d\u0630\u064a\u0631: \u0642\u062f \u064a\u062a\u0633\u0628\u0628 \u0647\u0630\u0627 \u0641\u064a \u062a\u062f\u0627\u062e\u0644 \u0645\u0639 \u0628\u0639\u0636 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0623\u0648 \u0627\u0644\u0645\u0634\u063a\u0644\u0627\u062a.\n\n\u064a\u062c\u0628 \u0625\u0639\u0627\u062f\u0629 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629/\u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0644\u062a\u0635\u0628\u062d \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0633\u0627\u0631\u064a\u0629.";
    }

    @Override
    public String confirmacionTitulo() {
        return "\u062a\u0623\u0643\u064a\u062f";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "\u062a\u0645 \u062a\u0645\u0643\u064a\u0646 ProxySysOutSysErr \u0628\u0646\u062c\u0627\u062d.\n\n\u064a\u062c\u0628 \u0625\u0639\u0627\u062f\u0629 \u062a\u0634\u063a\u064a\u0644 CrashDetector \u0644\u062a\u0635\u0628\u062d \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0633\u0627\u0631\u064a\u0629.";
    }

    @Override
    public String informacionTitulo() {
        return "\u0645\u0639\u0644\u0648\u0645\u0627\u062a";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u062a\u0645 \u062a\u0647\u064a\u0626\u0629 AzureLib \u0648GeckoLib \u0645\u0628\u0643\u0631\u064b\u0627 \u062c\u062f\u064b\u0627! ");
        } else if (azureLibError) {
            mensaje.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u062a\u0645 \u062a\u0647\u064a\u0626\u0629 AzureLib \u0645\u0628\u0643\u0631\u064b\u0627 \u062c\u062f\u064b\u0627! ");
        } else if (geckoLibError) {
            mensaje.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u062a\u0645 \u062a\u0647\u064a\u0626\u0629 GeckoLib \u0645\u0628\u0643\u0631\u064b\u0627 \u062c\u062f\u064b\u0627! ");
        }
        mensaje.append("\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f \u0645\u062d\u0627\u0648\u0644\u0629 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u062a\u0639\u062f\u064a\u0644\u0627\u062a Fabric \u0645\u0639 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u063a\u064a\u0631 Fabric \u0645\u0646 \u0647\u0630\u0647 \u0627\u0644\u0645\u0643\u062a\u0628\u0627\u062a. ");
        if (connectorPresente) {
            mensaje.append("\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u062f\u064a\u0644 \u062a\u0648\u0627\u0641\u0642 (Sinytra Connector \u0623\u0648 specialcompatibilityoperation)\u060c \u0645\u0645\u0627 \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0623\u0646\u0643 \u062a\u062d\u0627\u0648\u0644 \u062a\u0634\u063a\u064a\u0644 \u062a\u0639\u062f\u064a\u0644\u0627\u062a Fabric \u0641\u064a \u0628\u064a\u0626\u0629 Forge \u0623\u0648 FeatureCreep. ");
            mensaje.append("\u062a\u062d\u0642\u0642 \u0645\u0646 \u062e\u0637\u0623 '\u0641\u0634\u0644 \u062a\u0647\u064a\u0626\u0629 FabricMC' \u0641\u064a \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629. ");
        }
        mensaje.append("AzureLib \u0648GeckoLib \u0645\u0643\u062a\u0628\u0627\u062a \u0623\u0633\u0627\u0633\u064a\u0629 \u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0631\u0633\u0648\u0645 \u0627\u0644\u0645\u062a\u062d\u0631\u0643\u0629\u060c \u0644\u0643\u0646 \u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0637\u0627\u0628\u0642 \u0645\u0639 \u0627\u0644\u0646\u0638\u0627\u0645 \u0627\u0644\u0623\u0633\u0627\u0633\u064a \u0627\u0644\u0635\u062d\u064a\u062d (Fabric \u0623\u0648 Forge). ");
        mensaje.append("\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u0639\u0628\u0629 \u062a\u062d\u0645\u064a\u0644 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0631\u0633\u0648\u0645 \u0627\u0644\u0645\u062a\u062d\u0631\u0643\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d \u0628\u0633\u0628\u0628 \u0647\u0630\u0627 \u0627\u0644\u062a\u0639\u0627\u0631\u0636 \u0641\u064a \u0627\u0644\u062a\u0647\u064a\u0626\u0629.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "\u062a\u0647\u064a\u0626\u0629 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0645\u0628\u0643\u0631\u064b\u0627 \u062c\u062f\u064b\u0627";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "\u062a\u062d\u0642\u0642 \u0645\u0646 \u062e\u0637\u0623 '\u0641\u0634\u0644 \u062a\u0647\u064a\u0626\u0629 FabricMC' \u0641\u064a \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "\u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0643 \u0644\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0635\u062d\u064a\u062d \u0645\u0646 AzureLib/GeckoLib \u0644\u0646\u0638\u0627\u0645\u0643 (Forge \u0623\u0648 Fabric)";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u0639\u062f\u0645 \u0627\u0644\u062a\u0648\u0627\u0641\u0642 \u0628\u064a\u0646 C2ME \u0648\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0644\u0623\u0646 C2ME \u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0645\u0643\u0648\u0646\u0627\u062a \u062f\u0627\u062e\u0644\u064a\u0629 \u0641\u064a \u062c\u0627\u0641\u0627 \u0645\u0642\u064a\u062f\u0629 \u0641\u064a \u0627\u0644\u0628\u064a\u0626\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 Sinytra Connector \u0623\u0648 specialcompatibilityoperation \u0623\u0648 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u062a\u0648\u0627\u0641\u0642 Fabric/Forge \u0623\u062e\u0631\u0649. <b>C2ME \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0647\u0630\u0647 \u0627\u0644\u0628\u064a\u0626\u0627\u062a\u060c \u0648\u0644\u0643\u0646 <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> \u0647\u0648 \u0627\u0644\u0628\u062f\u064a\u0644 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647</b> \u0627\u0644\u0630\u064a \u064a\u0639\u0645\u0644 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d \u0645\u0639 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u0639\u0628\u0629 \u0627\u0644\u0628\u062f\u0621 \u0628\u0633\u0628\u0628 \u062a\u0639\u0627\u0631\u0636 \u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u0623\u0645\u0627\u0646 \u0641\u064a \u062c\u0627\u0641\u0627.</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "\u0639\u062f\u0645 \u062a\u0648\u0627\u0641\u0642 C2ME \u0645\u0639 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "\u0623\u0632\u0644 C2ME \u0645\u0646 \u0645\u062c\u0644\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "\u0642\u0645 \u0628\u062a\u0646\u0632\u064a\u0644 \u0648\u062a\u062b\u0628\u064a\u062a <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> \u0628\u062f\u0644\u0627\u064b \u0645\u0646\u0647 (\u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 Sinytra Connector)";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "\u062a\u0623\u0643\u062f \u0645\u0646 \u062a\u062d\u062f\u064a\u062b \u062c\u0645\u064a\u0639 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644 (\u0645\u062b\u0644 Sinytra Connector) \u0625\u0644\u0649 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u0641\u0634\u0644 \u062a\u062d\u0645\u064a\u0644 \u0625\u0636\u0627\u0641\u0629 JEI \u0644\u0644\u062a\u0639\u062f\u064a\u0644 '" + modId + "'. \u0627\u0644\u0641\u0626\u0629 '" + nombreClase + "' (\u0645\u0639\u0631\u0651\u0641 \u0627\u0644\u0625\u0636\u0627\u0641\u0629: '" + pluginId + "') \u062a\u0633\u0628\u0628\u062a \u0641\u064a \u062e\u0637\u0623 \u064a\u0624\u062f\u064a \u0625\u0644\u0649 \u062a\u0639\u0637\u0644 \u0627\u0644\u0644\u0639\u0628\u0629 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u0628\u062f\u0621. \u062a\u062d\u062f\u062b \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0639\u0646\u062f\u0645\u0627 \u064a\u0643\u0648\u0646 \u0644\u062f\u0649 \u062a\u0639\u062f\u064a\u0644 \u0645\u0627 \u062a\u0643\u0627\u0645\u0644 JEI \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0623\u0648 \u0645\u0639\u0637\u0648\u0628 \u064a\u0639\u0637\u0644 \u0639\u0645\u0644\u064a\u0629 \u062a\u0647\u064a\u0626\u0629 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "\u0625\u0636\u0627\u0641\u0629 JEI \u0641\u0627\u0634\u0644\u0629 - \u062a\u0633\u0628\u0628 \u062a\u0639\u0637\u0651\u0644";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "\u0627\u0644\u062a\u0639\u062f\u064a\u0644 <b>" + modId + "</b> \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0625\u0636\u0627\u0641\u0629 JEI \u0645\u0639\u0637\u0648\u0628\u0629 \u062a\u0633\u0628\u0628 \u0627\u0644\u062a\u0639\u0637\u0651\u0644. \u0627\u0633\u062a\u062e\u062f\u0645 \u0648\u0638\u064a\u0641\u0629 <b>\u0634\u062c\u0631\u0629 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a</b> \u0644\u062a\u0623\u0643\u064a\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "\u0623\u0632\u0644 \u0645\u0624\u0642\u062a\u064b\u0627 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 <b>" + modId + "</b> \u0645\u0646 \u0645\u062c\u0644\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0644\u0644\u062a\u062d\u0642\u0642 \u0645\u0645\u0627 \u0625\u0630\u0627 \u0643\u0627\u0646 \u0633\u064a\u062d\u0644 \u0645\u0634\u0643\u0644\u0629 \u0627\u0644\u062a\u0639\u0637\u0651\u0644";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "\u0627\u0628\u062d\u062b \u0639\u0646 \u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0644\u0644\u062a\u0639\u062f\u064a\u0644 <b>" + modId + "</b> \u0623\u0648 \u0627\u062a\u0635\u0644 \u0628\u0645\u0637\u0648\u0651\u0631\u0647 \u0644\u062a\u0642\u062f\u064a\u0645 \u062a\u0642\u0631\u064a\u0631 \u0639\u0646 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0627\u0644\u0645\u062a\u0639\u0644\u0642\u0629 \u0628\u0625\u0636\u0627\u0641\u0629 JEI. \u0641\u064a \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u062d\u0627\u0644\u064a\u060c \u064a\u062c\u0628 \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0644\u062a\u0645\u0643\u064a\u0646 \u0628\u062f\u0621 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629";
    }

    @Override
    public String tituloLectador() {
        return "\u0642\u0627\u0631\u0626 \u0627\u0644\u0633\u062c\u0644\u0627\u062a - \u0643\u0627\u0634\u0641 \u0627\u0644\u062a\u0648\u0642\u0641";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "\u0623\u0633\u0627\u0637\u064a\u0631 \u0627\u0644\u0623\u0644\u0648\u0627\u0646";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "\u0623\u062e\u0637\u0627\u0621 \u062d\u0631\u062c\u0629";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "\u062a\u062a\u0628\u0639\u0627\u062a \u0627\u0644\u0645\u0643\u062f\u0633";
    }

    @Override
    public String obtenerTituloError() {
        return "\u062e\u0637\u0623";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0633\u0637\u0631 \u0627\u0644\u0645\u062d\u062f\u062f";
    }

    @Override
    public String obtenerNombreError() {
        return "\u0627\u0633\u0645 \u0627\u0644\u062e\u0637\u0623";
    }

    @Override
    public String obtenerDescripcionError() {
        return "\u0648\u0635\u0641 \u062a\u0641\u0635\u064a\u0644\u064a";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "\u0627\u062e\u062a\u0631 \u0627\u0644\u0633\u062c\u0644";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "\u062e\u0637\u0623 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u062d\u0631\u062c \u0641\u064a \u0627\u0644\u0633\u062c\u0644\u0627\u062a. \u062a\u062d\u0642\u0642 \u0645\u0646 \u062a\u062a\u0628\u0639 \u0627\u0644\u0645\u0643\u062f\u0633 \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0633\u0628\u0628 \u0627\u0644\u062c\u0630\u0631\u064a.";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "\u062a\u0639\u0630\u0631 \u0642\u0631\u0627\u0621\u0629 \u0645\u0644\u0641 \u0627\u0644\u0633\u062c\u0644. \u062a\u0623\u0643\u062f \u0645\u0646 \u0648\u062c\u0648\u062f \u0627\u0644\u0645\u0644\u0641 \u0648\u0627\u0645\u062a\u0644\u0627\u0643 \u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u0642\u0631\u0627\u0621\u0629.";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "\u0645\u062d\u0644\u0644 \u0627\u0644\u0633\u062c\u0644\u0627\u062a";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u0641\u0634\u0644 \u0641\u064a \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u064a\u0646 \u0627\u0644\u062a\u0644\u0642\u0627\u0626\u064a\u064a\u0646 \u0644\u0644\u062a\u0639\u062f\u064a\u0644 '").append(modId).append("'. ");
        mensaje.append("\u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0634\u0643\u0644: <b>").append(nombreClase).append("</b>. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u064a\u0648\u062c\u062f \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641 \u0641\u064a: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u064a\u062d\u0627\u0648\u0644 \u062a\u0639\u062f\u064a\u0644 \u062a\u0633\u062c\u064a\u0644 \u0635\u0646\u0641 \u0643\u0645\u0634\u062a\u0631\u0643 \u0641\u064a \u0627\u0644\u0623\u062d\u062f\u0627\u062b \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627\u060c \u0644\u0643\u0646 \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0635\u0646\u0641. ");
        mensaje.append("<b>\u062a\u062d\u0642\u0642 \u0645\u0646 \u0623\u062e\u0637\u0627\u0621 \u0623\u062e\u0631\u0649 \u0641\u064a \u0627\u0644\u0633\u062c\u0644\u060c \u0641\u0642\u062f \u064a\u0643\u0648\u0646 \u0627\u0644\u0633\u0628\u0628 \u0627\u0644\u062d\u0642\u064a\u0642\u064a \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0633\u0627\u0628\u0642 \u0641\u0627\u0634\u0644</b>.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "\u0641\u0634\u0644 \u0641\u064a \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u064a\u0646 \u0627\u0644\u062a\u0644\u0642\u0627\u0626\u064a\u064a\u0646";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "\u0627\u0644\u062a\u0639\u062f\u064a\u0644 <b>" + modId + "</b> \u064a\u062d\u0627\u0648\u0644 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0635\u0646\u0641 <b>" + nombreClase + "</b> \u0643\u0645\u0634\u062a\u0631\u0643 \u062a\u0644\u0642\u0627\u0626\u064a\u060c \u0644\u0643\u0646 \u0627\u0644\u0639\u0645\u0644\u064a\u0629 \u0641\u0634\u0644\u062a. \u062a\u062d\u0642\u0642 \u0645\u0646 \u0648\u062c\u0648\u062f \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641 \u0648\u0648\u0635\u0648\u0644\u0647";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0634\u0643\u0644 <b>" + nombreClase + "</b> \u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0647\u0630\u0647 \u0627\u0644\u0645\u0644\u0641\u0627\u062a: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            paso.append("</b>. ");
            paso.append("\u0627\u0633\u062a\u062e\u062f\u0645 \u0648\u0638\u064a\u0641\u0629 <b>\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a</b> \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062f\u0642\u064a\u0642 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0634\u0643\u0644");
            return paso.toString();
        }
        return "\u0627\u0644\u0635\u0646\u0641 <b>" + nombreClase + "</b> \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0623\u064a \u0645\u0644\u0641 \u062a\u0639\u062f\u064a\u0644. \u062a\u062d\u0642\u0642 \u0645\u0646 \u062a\u062b\u0628\u064a\u062a \u0627\u0644\u062a\u0639\u062f\u064a\u0644 <b>" + modId + "</b> \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d. \u0627\u0633\u062a\u062e\u062f\u0645 \u0648\u0638\u064a\u0641\u0629 <b>\u0634\u062c\u0631\u0629 \u0627\u0644\u0645\u0648\u062f\u0627\u062a</b> \u0644\u0644\u0645\u0633\u0627\u0639\u062f\u0629 \u0641\u064a \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0634\u0643\u0644\u0629";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "\u062d\u062f\u062b \u0627\u0644\u062a\u0639\u062f\u064a\u0644 <b>" + modId + "</b> \u0625\u0644\u0649 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0648 Forge \u0644\u062f\u064a\u0643. \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0627\u062a\u0635\u0644 \u0628\u0645\u0637\u0648\u0651\u0631 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0648\u0628\u0644\u063a\u0647 \u0628\u0627\u0644\u062e\u0637\u0623 \u0645\u0639 \u0630\u0643\u0631 \u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0634\u0643\u0644";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "\u0631\u0627\u062c\u0639 <b>\u0623\u062e\u0637\u0627\u0621 \u0623\u062e\u0631\u0649 \u0641\u064a \u0627\u0644\u0633\u062c\u0644</b> \u0642\u0628\u0644 \u0647\u0630\u0647 \u0627\u0644\u0631\u0633\u0627\u0644\u0629\u060c \u0641\u0642\u062f \u064a\u0643\u0648\u0646 \u0627\u0644\u0633\u0628\u0628 \u0627\u0644\u062d\u0642\u064a\u0642\u064a \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0633\u0627\u0628\u0642 \u0641\u0627\u0634\u0644. \u0623\u062d\u064a\u0627\u0646\u064b\u0627 \u064a\u0645\u0646\u0639 \u062e\u0637\u0623 \u0633\u0627\u0628\u0642 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0635\u0646\u0648\u0641 \u0627\u0644\u0644\u0627\u0632\u0645\u0629 \u0644\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0623\u062d\u062f\u0627\u062b";
    }

    @Override
    public String limpiado() {
        return "\u062a\u0645 \u0627\u0644\u062a\u0646\u0638\u064a\u0641";
    }

    @Override
    public String original() {
        return "\u0623\u0635\u0644\u064a";
    }

    @Override
    public String verEnConsola() {
        return "\u0639\u0631\u0636 \u0641\u064a \u0627\u0644\u0633\u062c\u0644";
    }

    @Override
    public String advertencia() {
        return "\u062a\u062d\u0630\u064a\u0631";
    }

    @Override
    public String fatal() {
        return "\u0645ortal";
    }

    @Override
    public String noRegistroDeBattly() {
        return "BattlyLauncher no tiene un registro ni una consola para copiando. Puedes usar ProxySysOutSysErr para interceptar STDOUT y STDERR y reiniciar el juego pero ProxySysOutSysErr puede conflictar con mods modificando STDOUT o STDERR";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "Necesitas hablicar modo de depuraci\u00f3n en la configuracion de NightWorld para obtener un registro de lanzer. Es muy importante especialemente por que tiene STDOUT y STDERR";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "Necesitas guardar o pegar el contenido de la Terminal de tu servidor porque tiene informacion no en otro registros incluyendo STDOUT, STDERR, y otras errores. Por favor pegar el contenido de la ultima sesion. Para la future, puedes guardar el contenido de la terminal al archivo cd_launcherlog Para evitar tener que pegarlo, a\u00f1ade >> cd_launcherlog despu\u00e9s del comando, como se muestra en la imagen. Ten en cuenta que esto impedir\u00e1 que se muestre en la terminal; solo aparecer\u00e1 en ese archivo una vez hecho esto.";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0645\u062d\u0648\u0644 LexForge \u0641\u064a \u0628\u064a\u0626\u0629 NeoForge. ");
        sb.append("</b>");
        sb.append("\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0645\u062a\u0648\u0631\u0637\u0629: <b>").append(claseReceptora).append("</b>. ");
        sb.append("\u0627\u0644\u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0645\u062a\u0623\u062b\u0631\u0629 \u0647\u064a <b>").append(interfazObjetivo).append("</b> ");
        sb.append("\u0648\u064a\u062a\u0639\u0630\u0631 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0637\u0631\u064a\u0642\u0629 <b>").append(firmaMetodoFaltante).append("</b>. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0635\u0641 \u0641\u064a: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0644\u0641\u0627\u062a JAR \u062a\u062d\u062a\u0648\u064a \u0647\u0630\u0647 \u0627\u0644\u0635\u0641\u062d\u0629\u061b \u0642\u062f \u062a\u0643\u0648\u0646 \u0645\u064f\u0638\u0644\u064e\u0651\u0644\u0629 \u0623\u0648 \u0645\u0636\u0645\u0646\u0629 \u0643\u0640 jar-in-jar. ");
        }
        sb.append("\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u0641\u0634\u0644 \u0639\u0646\u062f\u0645\u0627 \u064a\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 \u0645\u062d\u0648\u0644/\u062e\u062f\u0645\u0629 \u0645\u0646 ModLauncher \u062a\u0645 \u062a\u062c\u0645\u064a\u0639\u0647\u0627 \u0644\u0640 MinecraftForge/LexForge ");
        sb.append("\u0636\u0645\u0646 \u0628\u064a\u0626\u0629 NeoForge \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0646 \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u062a\u0637\u0628\u064a\u0642\u0627\u062a ModLauncher. ");
        sb.append("\u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0643\u0648\u0651\u0646 \u0623\u0648 \u0627\u0633\u062a\u0628\u062f\u0644\u0647 \u0628\u0625\u0635\u062f\u0627\u0631 \u0645\u062e\u0635\u0635 \u0644\u0640 NeoForge.");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "\u0645\u062d\u0648\u0651\u0644 LexForge \u0645\u0633\u062a\u062e\u062f\u0645 \u0641\u064a NeoForge";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "\u062d\u062f\u062f \u0627\u0644\u0645\u062d\u0648\u0644 \u063a\u064a\u0631 \u0627\u0644\u0645\u062a\u0648\u0627\u0641\u0642: <b>" + claseReceptora + "</b>. \u0627\u0644\u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0645\u062a\u0648\u0642\u0639\u0629 \u0647\u064a <b>" + interfazObjetivo + "</b> \u0648\u064a\u062a\u0639\u0630\u0631 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0637\u0631\u064a\u0642\u0629 <b>" + firmaMetodoFaltante + "</b>. \u062a\u062d\u0642\u0642 \u0645\u0645\u0627 \u0625\u0630\u0627 \u0643\u0627\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u064a\u0633\u062c\u0644 \u0647\u0630\u0647 \u0627\u0644\u0635\u0641\u062d\u0629 \u0641\u064a <b>META-INF/services</b>\u060c \u062b\u0645 \u0642\u0645 \u0628\u062d\u0630\u0641\u0647\u0627 \u0623\u0648 \u062a\u0639\u0637\u064a\u0644\u0647\u0627 \u0641\u064a NeoForge.";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u0645\u0648\u0642\u0639 \u0627\u0644\u0645\u0648\u062f(\u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a) \u0627\u0644\u0645\u062a\u0648\u0631\u0637(\u0629): <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0644\u0641\u0627\u062a JAR \u062a\u062d\u062a\u0648\u064a \u0647\u0630\u0647 \u0627\u0644\u0635\u0641\u062d\u0629. \u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a \u0627\u0644\u0645\u0636\u0645\u0651\u0646\u0629 (jar-in-jar) \u0648\u0627\u0644\u0645\u0638\u0644\u0644\u0629. ");
        }
        sb.append("\u0623\u0632\u0644 \u0645\u0624\u0642\u062a\u064b\u0627 \u062a\u0644\u0643 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0623\u0648 \u0627\u0633\u062a\u062e\u062f\u0645 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 NeoForge \u0644\u0644\u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u0644\u0645\u0635\u062f\u0631.");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "\u0627\u0633\u062a\u0628\u062f\u0644 \u0627\u0644\u0645\u0643\u0648\u0651\u0646 \u0628\u0625\u0635\u062f\u0627\u0631 \u0645\u062e\u0635\u0635 \u0644\u0640 NeoForge \u0623\u0648 \u0623\u0639\u062f \u062a\u0631\u062c\u0645\u062a\u0647 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 ModLauncher \u0627\u0644\u0630\u064a \u064a\u0633\u062a\u062e\u062f\u0645\u0647 NeoForge. \u062a\u062c\u0646\u0628 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u062b\u0646\u0627\u0626\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u0645\u0646 LexForge/MinecraftForge.";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "\u0646\u0638\u0651\u0641 \u0645\u062c\u0644\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0648\u0623\u0632\u0644 \u0627\u0644\u062a\u0643\u0631\u0627\u0631\u0627\u062a \u0645\u0646 \u0646\u0648\u0639 jar-in-jar. \u0627\u0645\u0633\u062d \u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u062a\u062e\u0632\u064a\u0646 \u0627\u0644\u0645\u0624\u0642\u062a \u0644\u0644\u0631\u0627\u0645\u0628 \u0625\u0646 \u0644\u0632\u0645 \u0627\u0644\u0623\u0645\u0631 \u0648\u0623\u0639\u062f \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0644\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0639\u062f\u0645 \u062a\u062d\u0645\u064a\u0644 \u0623\u064a \u0645\u062d\u0648\u0644\u0627\u062a \u0645\u0646 LexForge.";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 WaterMedia \u0627\u0644\u0628\u062f\u0621: Xenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("\u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642.</b> ");
        sb.append("\u0623\u0632\u0644 Xenon \u0648\u0627\u0633\u062a\u062e\u062f\u0645 Embeddium \u0623\u0648 Sodium. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641\u0647 \u0641\u064a: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 Xenon";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return "\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 " + label + " \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 WaterMedia. \u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u062a\u0647 \u0645\u0646 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a.";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("\u0627\u0644\u0645\u0648\u0627\u0642\u0639: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648\u0622\u062e\u0631\u064a\u0646...");
            }
            sb.append("</b>. \u0642\u0645 \u0628\u062d\u0630\u0641 \u0647\u0630\u0627 \u0627\u0644\u0645\u0644\u0641 JAR.");
            return sb.toString();
        }
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0644\u0641\u0627\u062a JAR. \u062a\u062d\u0642\u0642 \u0645\u0646 \u0645\u062c\u0644\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0648\u0623\u0632\u0644 Xenon.";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "\u062b\u0628\u0651\u062a Embeddium \u0623\u0648 Sodium \u0643\u0628\u062f\u064a\u0644 \u0648\u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0636\u063a\u0637 (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>\u062a\u0645 \u0625\u063a\u0644\u0627\u0642 Deflater \u0623\u062b\u0646\u0627\u0621 \u0646\u0633\u062e \u0645\u0648\u0627\u0631\u062f TACZ.</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u0645\u0631\u062a\u0628\u0637 \u0628\u0640: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648\u0622\u062e\u0631\u064a\u0646");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>\u0627\u0644\u062d\u0644:</b> \u0641\u064a <code>tacz/tacz-pre.toml</code> \u0639\u064a\u0651\u0646 <code>DefaultPackDebug=true</code>. ").append("\u0625\u0630\u0627 \u0644\u0632\u0645 \u0627\u0644\u0623\u0645\u0631\u060c \u0642\u0645 \u0623\u0648\u0644\u0627\u064b \u0628\u0625\u0646\u0634\u0627\u0621 \u062e\u0631\u064a\u0637\u0629 \u062b\u0645 \u0641\u0639\u0651\u0644\u0647\u0627.");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "\u0641\u064a \u0645\u0644\u0641 tacz/tacz-pre.toml \u0639\u064a\u0651\u0646 DefaultPackDebug=true. \u0625\u0630\u0627 \u0644\u0632\u0645 \u0627\u0644\u0623\u0645\u0631\u060c \u0642\u0645 \u0628\u0625\u0646\u0634\u0627\u0621 \u062e\u0631\u064a\u0637\u0629 \u0623\u0648\u0644\u0627\u064b \u062b\u0645 \u0641\u0639\u0651\u0644\u0647\u0627.";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "\u0648\u0638\u0627\u0626\u0641 \u0627\u0644\u0643\u062b\u0627\u0641\u0629 \u063a\u064a\u0631 \u0627\u0644\u0645\u0631\u062a\u0628\u0637\u0629";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>\u062a\u064e\u0646\u0652\u0635\u064f\u0631 \u062f\u0648\u0627\u0644 \u0627\u0644\u0643\u062b\u0627\u0641\u0629 \u0645\u0641\u0642\u0648\u062f\u0629 \u0641\u064a \u0627\u0644\u0633\u062c\u0644.</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("\u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append(". ");
        }
        sb.append("<br/><b>\u0627\u0644\u062d\u0644:</b> \u0642\u0645 \u0628\u062a\u062b\u0628\u064a\u062a \u0623\u0648 \u062a\u0641\u0639\u064a\u0644 \u0627\u0644\u0640 mod/datapack \u0627\u0644\u0630\u064a \u064a\u064f\u0639\u0631\u0650\u0651\u0641 \u062a\u0644\u0643 \u0627\u0644\u062f\u0648\u0627\u0644 \u062b\u0645 \u0623\u0639\u062f \u0627\u0644\u062a\u0634\u063a\u064a\u0644. \u0633\u0628\u0628 \u0622\u062e\u0631 \u0634\u0627\u0626\u0639 \u0644\u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0647\u0648 \u0623\u0646\u0643 \u062a\u0645\u062a\u0644\u0643 \u0627\u0644\u0640 mod \u0627\u0644\u0645\u0637\u0644\u0648\u0628\u060c \u0644\u0643\u0646\u0647 \u064a\u0639\u0627\u0646\u064a \u0645\u0646 \u062e\u0644\u0644 \u0623\u0648 \u062a\u0639\u0627\u0631\u0636 \u0645\u0639 mod \u0622\u062e\u0631\u061b \u0639\u0644\u0649 \u0633\u0628\u064a\u0644 \u0627\u0644\u0645\u062b\u0627\u0644\u060c \u064a\u0639\u0627\u0646\u064a Terralith \u0645\u0646 \u0645\u0634\u0627\u0643\u0644 \u0643\u062b\u064a\u0631\u0629 \u0648\u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0633\u0628\u0628 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0648\u063a\u064a\u0631\u0647\u060c \u0628\u0645\u0627 \u0641\u064a \u0630\u0644\u0643 \u0623\u062e\u0637\u0627\u0621 JSON.");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "\u0642\u0645 \u0628\u062a\u062b\u0628\u064a\u062a \u0623\u0648 \u062a\u0641\u0639\u064a\u0644 \u0627\u0644\u0645\u0648\u062f/\u062d\u0632\u0645\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0648\u0641\u0631 \u0647\u0630\u0647 \u0627\u0644\u0648\u0638\u0627\u0626\u0641 \u0648\u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0645\u064f\u062f\u062e\u0644 \u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f: ").append(claveFaltante).append(". ");
        sb.append("\u0634\u0627\u0626\u0639 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0623\u0644\u0641\u0627 \u0645\u0646 Steam & Railways \u0644\u0640 Create 6.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (\u0623\u0644\u0641\u0627)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "\u0623\u0632\u0644 \u0623\u0648 \u0627\u0633\u062a\u0628\u062f\u0644 \u0625\u0635\u062f\u0627\u0631 \u0623\u0644\u0641\u0627 \u0645\u0646 Steam & Railways \u0644\u0640 Create 6 \u0628\u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642.";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u062a\u0636\u0627\u0631\u0628 \u0641\u064a \u0627\u0644\u062a\u062d\u0645\u064a\u0644: \u0627\u0633\u062a\u062e\u062f\u0627\u0645 Multiworld \u0645\u0639 Sodium/Embeddium/Rubidium \u064a\u062a\u0633\u0628\u0628 \u0641\u064a ").append("IncompatibleClassChangeError (FabricLoader.getInstance). ").append("\u0627\u0642\u062a\u0631\u0627\u062d: \u0623\u0632\u0644 Multiworld \u0623\u0648 \u0623\u062d\u062f \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0623\u062f\u0627\u0621\u060c \u0623\u0648 \u0627\u0633\u062a\u062e\u062f\u0645 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u062a\u0648\u0627\u0641\u0642\u0629.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "\u062a\u0636\u0627\u0631\u0628: Multiworld \u0645\u0639 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0623\u062f\u0627\u0621";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "\u0623\u0632\u0644 Multiworld \u0623\u0648 Sodium/Embeddium/Rubidium\u060c \u0623\u0648 \u062d\u062f\u0651\u062b \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0628\u0639\u0636\u0647\u0627.";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0643\u0634\u0641 Sodium \u0639\u0646 \u0628\u0631\u0646\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 \u0631\u0633\u0648\u0645\u064a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642. \u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b \u0628\u0631\u0646\u0627\u0645\u062c \u062a\u0634\u063a\u064a\u0644 \u0648\u062d\u062f\u0629 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a (GPU) \u0625\u0644\u0649 \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u062f\u0646\u0649 \u0627\u0644\u0645\u0637\u0644\u0648\u0628 \u0623\u0648 \u0627\u062a\u0628\u0639 \u062f\u0644\u064a\u0644 Sodium.</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0633\u064a\u0627\u0642 OpenGL";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0634\u0644 OpenGL: \u0644\u0627 \u064a\u0648\u062c\u062f \u0633\u064a\u0627\u0642 \u062d\u0627\u0644\u064a \u0623\u0648 \u0623\u0646 \u0627\u0644\u0648\u0638\u064a\u0641\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0641\u0631\u0629 \u0641\u064a \u0647\u0630\u0627 \u0627\u0644\u0633\u064a\u0627\u0642. \u0642\u062f \u064a\u0643\u0648\u0646 \u0623\u064a\u0636\u064b\u0627 \u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u062a\u0639\u0631\u064a\u0641\u0627\u062a \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0641\u064a\u062f\u064a\u0648.</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "\u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b/\u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a \u062a\u0639\u0631\u064a\u0641\u0627\u062a \u0648\u062d\u062f\u0629 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a (GPU) \u0648\u0623\u0639\u062f \u0627\u0644\u062a\u0634\u063a\u064a\u0644\u061b \u0639\u0637\u0644 \u0623\u064a \u0637\u0628\u0642\u0627\u062a \u0639\u0644\u0648\u064a\u0629 \u0648\u062c\u0631\u0628 \u0627\u0644\u0644\u0639\u0628 \u0628\u062f\u0648\u0646 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0623\u062f\u0627\u0621.";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "\u062a\u0645 \u0646\u0633\u062e \u0627\u0644\u0631\u0627\u0628\u0637 \u0625\u0644\u0649 \u0627\u0644\u062d\u0627\u0641\u0638\u0629.";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "\u0627\u0644\u0628\u062d\u062b \u062f\u0627\u062e\u0644 \u0627\u0644\u0623\u0631\u0634\u064a\u0641\u0627\u062a (.zip/.jar/.war/.ear/.fpm/.rar \u0644\u0640 Java*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u062f\u0642\u0629 \u0627\u0644\u0645\u0644\u0645\u0633: \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u0645\u064a\u0644 " + recurso + " - \u0627\u0644\u062d\u062c\u0645: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "\u062e\u0637\u0623 \u0641\u064a \u062f\u0642\u0629 \u0627\u0644\u0645\u0644\u0645\u0633";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u062a\u0643\u0648\u0646 \u0627\u0644\u0645\u0644\u0645\u0633\u0627\u062a \u0643\u0628\u064a\u0631\u0629 \u062c\u062f\u064b\u0627 \u0623\u0648 \u0639\u0646\u062f \u0648\u062c\u0648\u062f \u0639\u062f\u062f \u0643\u0628\u064a\u0631 \u062c\u062f\u064b\u0627 \u0645\u0646 \u062d\u0632\u0645 \u0627\u0644\u0645\u0648\u0627\u0631\u062f. \u062d\u0627\u0648\u0644 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u062d\u0632\u0645 \u0645\u0648\u0627\u0631\u062f \u0630\u0627\u062a \u062f\u0642\u0629 \u0623\u0642\u0644 \u0623\u0648 \u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 \u0628\u0639\u0636 \u062d\u0632\u0645 \u0627\u0644\u0645\u0648\u0627\u0631\u062f. \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u0644\u0645 \u062a\u0642\u0645 \u0628\u0625\u0636\u0627\u0641\u0629 \u0645\u0644\u0645\u0633\u0627\u062a \u0645\u062e\u0635\u0635\u0629 \u0628\u062f\u0642\u0629 \u0623\u0639\u0644\u0649 \u0645\u0646 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627.";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u062e\u062f\u0645\u0627\u062a ModLauncher: \u0627\u0644\u0645\u0633\u0627\u0631 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u062e\u062f\u0645\u0627\u062a ModLauncher \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0645\u0633\u0627\u0631\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u063a\u064a\u0631 ASCII \u0623\u0648 \u0623\u062d\u0631\u0641 \u062e\u0627\u0635\u0629. \u0645\u0646 \u0627\u0644\u0623\u062d\u0631\u0641 \u0627\u0644\u0645\u0633\u0628\u0628\u0629 \u0644\u0644\u0645\u0634\u0627\u0643\u0644: \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694\u060c \u0648\u062e\u0635\u0648\u0635\u064b\u0627 \u0627\u0644\u0631\u0645\u0632 '\"' \u0639\u0646\u062f\u0645\u0627 \u064a\u0643\u0648\u0646 \u0641\u064a \u0646\u0647\u0627\u064a\u0629 \u0627\u0644\u0627\u0633\u0645. \u062a\u0634\u0645\u0644 \u0645\u0643\u0648\u0646\u0627\u062a \u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u0641\u064a ModLauncher \u0643\u0644\u0627\u064b \u0645\u0646 CrashDetector\u060c " + Config.obtenerInstancia().obtenerNombreCD() + "\u060c FeatureCreep\u060c Vivicraft\u060c Optifine\u060c Sodium\u060c clonos\u060c Iris Shaders/Oculus\u060c MixerLogger\u060c CrashAssistant \u0648Sintrya Connector. \u064a\u0645\u0643\u0646\u0643 \u0625\u0632\u0627\u0644\u0629 \u062c\u0645\u064a\u0639 \u0627\u0644\u062e\u062f\u0645\u0627\u062a\u060c \u0644\u0643\u0646 \u0642\u062f \u062a\u0638\u0647\u0631 \u0645\u0634\u0627\u0643\u0644 \u0623\u062e\u0631\u0649 \u0628\u0633\u0628\u0628 \u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u0627\u0631. \u0627\u0644\u062d\u0644: \u0623\u0639\u062f \u062a\u0633\u0645\u064a\u0629 \u0627\u0644\u0645\u062c\u0644\u062f \u0644\u064a\u062d\u062a\u0648\u064a \u0641\u0642\u0637 \u0623\u062d\u0631\u0641 ASCII (a-z, A-Z, 0-9)\u060c \u062f\u0648\u0646 \u0645\u0633\u0627\u0641\u0627\u062a \u0623\u0648 \u0631\u0645\u0648\u0632 \u062e\u0627\u0635\u0629.</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0645\u0633\u0627\u0631 ModLauncher";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u064a\u062d\u062a\u0648\u064a \u0645\u0633\u0627\u0631 \u0627\u0644\u0645\u062b\u064a\u0644 \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u063a\u064a\u0631 ASCII \u0623\u0648 \u0631\u0645\u0648\u0632 \u062e\u0627\u0635\u0629. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u062e\u062f\u0645\u0627\u062a ModLauncher \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0645\u0639 \u0647\u0630\u0647 \u0627\u0644\u0645\u0633\u0627\u0631\u0627\u062a. \u0627\u0644\u062d\u0644: \u0642\u0645 \u0628\u0625\u0639\u0627\u062f\u0629 \u062a\u0633\u0645\u064a\u0629 \u0627\u0644\u0645\u062b\u064a\u0644 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062d\u0631\u0641 ASCII \u0641\u0642\u0637 (a-z, A-Z, 0-9)\u060c \u0648\u062a\u062c\u0646\u0628 \u0627\u0644\u0645\u0633\u0627\u0641\u0627\u062a \u0648\u0627\u0644\u0631\u0645\u0648\u0632 \u0627\u0644\u062e\u0627\u0635\u0629. \u0648\u0644\u0627\u062d\u0638 \u0628\u0639\u0646\u0627\u064a\u0629 \u0627\u0644\u0631\u0645\u0632 '\"' \u0641\u0647\u0648 \u0645\u0634\u0643\u0644\u0629 \u0643\u0628\u064a\u0631\u0629\u060c \u062e\u0635\u0648\u0635\u064b\u0627 \u0639\u0646\u062f \u0648\u0636\u0639\u0647 \u0641\u064a \u0646\u0647\u0627\u064a\u0629 \u0627\u0644\u0627\u0633\u0645.";
    }

    @Override
    public String tituloEditorCodice() {
        return "\u0645\u062d\u0631\u0631 \u0643\u0648\u062f\u064a\u0633";
    }

    @Override
    public String nuevo() {
        return "\u062c\u062f\u064a\u062f";
    }

    @Override
    public String actualizarSeleccionado() {
        return "\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u062d\u062f\u062f";
    }

    @Override
    public String eliminarSeleccionado() {
        return "\u062d\u0630\u0641 \u0627\u0644\u0645\u062d\u062f\u062f";
    }

    @Override
    public String exportarJSON() {
        return "\u062a\u0635\u062f\u064a\u0631 JSON...";
    }

    @Override
    public String guardarTodo() {
        return "\u062d\u0641\u0638 \u0627\u0644\u0643\u0644";
    }

    @Override
    public String general() {
        return "\u0639\u0627\u0645";
    }

    @Override
    public String id() {
        return "\u0627\u0644\u0645\u0639\u0631\u0641";
    }

    @Override
    public String paraBuscar() {
        return "\u0627\u0644\u0646\u0635 \u0644\u0644\u0628\u062d\u062b";
    }

    @Override
    public String filtro() {
        return "\u0639\u0627\u0645\u0644 \u0627\u0644\u062a\u0635\u0641\u064a\u0629 (\u0627\u0644\u0645\u0639\u0631\u0641)";
    }

    @Override
    public String criticalidad() {
        return "\u0627\u0644\u0623\u0647\u0645\u064a\u0629 (\u062a\u062d\u0630\u064a\u0631/\u062e\u0637\u0623/\u0645\u0645\u064a\u062a)";
    }

    @Override
    public String prioridad() {
        return "\u0627\u0644\u0623\u0648\u0644\u0648\u064a\u0629";
    }

    @Override
    public String lista() {
        return "\u0627\u0644\u062a\u062d\u0642\u0642";
    }

    @Override
    public String colIdioma() {
        return "\u0627\u0644\u0644\u063a\u0629";
    }

    @Override
    public String colNombre() {
        return "\u0627\u0644\u0627\u0633\u0645";
    }

    @Override
    public String colResultado() {
        return "\u0627\u0644\u0646\u062a\u064a\u062c\u0629";
    }

    @Override
    public String vistaJson() {
        return "\u0645\u0639\u0627\u064a\u0646\u0629 JSON";
    }

    @Override
    public String idiomas() {
        return "\u0627\u0644\u0644\u063a\u0627\u062a (\u062c\u0645\u064a\u0639\u0647\u0627 \u0625\u0644\u0632\u0627\u0645\u064a\u0629)";
    }

    @Override
    public String elegirFiltro() {
        return "\u0627\u062e\u062a\u0631...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "\u0627\u062e\u062a\u0631 \u0639\u0627\u0645\u0644 \u062a\u0635\u0641\u064a\u0629";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "\u0639\u0648\u0627\u0645\u0644 \u0627\u0644\u062a\u0635\u0641\u064a\u0629 \u0627\u0644\u0645\u062a\u0627\u062d\u0629";
    }

    @Override
    public String faltanCampos() {
        return "\u0623\u0643\u0645\u0644 \u062c\u0645\u064a\u0639 \u0627\u0644\u062d\u0642\u0648\u0644 \u0627\u0644\u0639\u0627\u0645\u0629 \u0627\u0644\u0625\u0644\u0632\u0627\u0645\u064a\u0629.";
    }

    @Override
    public String critInvalida() {
        return "\u0623\u0647\u0645\u064a\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629. \u0627\u0633\u062a\u062e\u062f\u0645: \u062a\u062d\u0630\u064a\u0631\u060c \u062e\u0637\u0623 \u0623\u0648 \u0645\u0645\u064a\u062a.";
    }

    @Override
    public String filtroNoExiste() {
        return "\u0639\u0627\u0645\u0644 \u0627\u0644\u062a\u0635\u0641\u064a\u0629 \u0627\u0644\u0645\u062d\u062f\u062f \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f.";
    }

    @Override
    public String faltanIdiomas() {
        return "\u0623\u0643\u0645\u0644 \u0627\u0644\u0627\u0633\u0645 \u0648\u0627\u0644\u0646\u062a\u064a\u062c\u0629 \u0644\u0643\u0644 \u0627\u0644\u0644\u063a\u0627\u062a:";
    }

    @Override
    public String verificacionInvalida() {
        return "\u0641\u062d\u0635 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d. \u0631\u0627\u062c\u0639 \u0627\u0644\u062d\u0642\u0648\u0644.";
    }

    @Override
    public String guardadoOk() {
        return "\u062a\u0645 \u0627\u0644\u062d\u0641\u0638 \u0628\u0646\u062c\u0627\u062d.";
    }

    @Override
    public String editorCodiceBoton() {
        return "\u0625\u0636\u0627\u0641\u0629 \u0623\u0633\u0628\u0627\u0628";
    }

    @Override
    public String descripcionEditorCodice() {
        return "\u064a\u0645\u0643\u0646\u0643 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0647\u0646\u0627. \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0645\u0639\u0631\u0641 (ID)\u060c \u0648\u0647\u0648 \u0646\u0635 \u0628\u062f\u0648\u0646 \u0631\u0645\u0648\u0632 \u062e\u0627\u0635\u0629 \u0623\u0648 \u0623\u062d\u0631\u0641 \u0645\u0634\u0648\u0651\u0647\u0629 \u0623\u0648 \u0641\u0631\u0627\u063a\u0627\u062a. \u0628\u0627\u0644\u0646\u0633\u0628\u0629 \u0644\u0644\u0645\u0631\u0634\u062d\u0627\u062a\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \"\u0627\u0644\u0633\u0637\u0631 \u064a\u062d\u062a\u0648\u064a\" \u0644\u0644\u0628\u062d\u062b \u0639\u0646 \u0646\u0635 \u062f\u0627\u062e\u0644 \u0633\u0637\u0631\u060c \u0648\"\u0627\u0644\u0643\u0644 \u064a\u062d\u062a\u0648\u064a\" \u0625\u0630\u0627 \u0643\u0627\u0646 \u0627\u0644\u0633\u062c\u0644 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0646\u0635 \u0645\u0639\u064a\u0646\u060c \u0648\"\u062a\u0639\u0628\u064a\u0631 \u0639\u0627\u062f\u064a \u0641\u064a \u0627\u0644\u0633\u0637\u0631\" \u0625\u0630\u0627 \u0643\u0627\u0646 \u0627\u0644\u0633\u0637\u0631 \u064a\u0637\u0627\u0628\u0642 \u062a\u0639\u0628\u064a\u0631\u064b\u0627 \u0645\u0646\u062a\u0638\u0645\u064b\u0627\u060c \u0648\"\u062a\u0639\u0628\u064a\u0631 \u0639\u0627\u062f\u064a \u0641\u064a \u0627\u0644\u0643\u0644\" (\u0646\u064f\u0648\u0635\u064a \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0633\u0637\u0631). \u064a\u062c\u0628 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0633\u062a\u0648\u0649: FATAL (\u0642\u0627\u062a\u0644\u0629)\u060c ERROR (\u062e\u0637\u0623) \u0623\u0648 ADVERTENCIA (\u062a\u062d\u0630\u064a\u0631) \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0623\u0644\u0648\u0627\u0646. \u0644\u0643\u0644 \u0644\u063a\u0629\u060c \u064a\u062c\u0628 \u0643\u062a\u0627\u0628\u0629 \u0627\u0633\u0645 \u0648\u0646\u062a\u064a\u062c\u0629 \u0633\u062a\u0638\u0647\u0631 \u0639\u0644\u0649 \u0627\u0644\u0634\u0627\u0634\u0629. \u064a\u0645\u0643\u0646\u0643 \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0632\u064a\u062f \u0645\u0646 \u0639\u0645\u0644\u064a\u0627\u062a \u0627\u0644\u062a\u062d\u0642\u0642 \u0623\u0648 \u062d\u0630\u0641 \u0627\u0644\u0628\u0639\u0636. \u064a\u062a\u0645 \u0627\u0644\u062d\u0641\u0638 \u0639\u0646\u062f \u0627\u0644\u0625\u0643\u0645\u0627\u0644.";
    }

    @Override
    public String descartarCambios() {
        return "\u0647\u0644 \u062a\u0631\u064a\u062f \u062a\u062c\u0627\u0647\u0644 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u062d\u0641\u0648\u0638\u0629 \u0641\u064a \u0627\u0644\u062a\u062d\u0642\u0642 \u0627\u0644\u062d\u0627\u0644\u064a\u061f";
    }

    @Override
    public String confirmacion() {
        return "\u062a\u0623\u0643\u064a\u062f";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\u0647\u0644 \u062a\u0631\u063a\u0628 \u0641\u064a \u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0642\u0628\u0644 \u0627\u0644\u062e\u0631\u0648\u062c\u061f";
    }

    @Override
    public String salirSinGuardar() {
        return "\u0627\u0644\u062e\u0631\u0648\u062c \u0628\u062f\u0648\u0646 \u062d\u0641\u0638";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u062e\u0637\u0623 \u062d\u0631\u062c: \u0641\u0634\u0644 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u062e\u062f\u0645\u0629 \u0645\u0646 modlauncher (IDependencyLocator).<br>");
        sb.append("\ud83d\udd39 <b>\u0627\u0644\u0635\u0641 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>\u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u062a\u0636\u0631\u0631:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>\u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641.</b> \u0631\u0627\u062c\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u062b\u0628\u062a\u0629 \u062d\u062f\u064a\u062b\u064b\u0627 \u0623\u0648 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0627\u0644\u062a\u0637\u0648\u064a\u0631 \u0623\u0648 \u0630\u0627\u062a \u0627\u0644\u062d\u0632\u0645\u0629 \u0627\u0644\u0633\u064a\u0626\u0629.<br>");
        }
        sb.append("\ud83d\udd38 <b>\u0627\u0644\u0633\u0628\u0628:</b> \u0645\u0644\u0641 <code>META-INF/services/...</code> \u0627\u0644\u062e\u0627\u0635 \u0628\u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u062a\u0627\u0644\u0641\u060c ");
        sb.append("\u0623\u0648 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 Forge/NeoForge \u0627\u0644\u062d\u0627\u0644\u064a\u060c \u0623\u0648 \u0623\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0645\u062e\u0635\u0635 \u0644\u0625\u0635\u062f\u0627\u0631 \u062e\u0627\u0637\u0626.<br>");
        sb.append("\ud83d\udd38 <b>\u0627\u0644\u0646\u062a\u064a\u062c\u0629:</b> \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 Forge/NeoForge \u062a\u0633\u062c\u064a\u0644 \u062a\u0628\u0639\u064a\u0627\u062a \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u060c ");
        sb.append("\u0645\u0645\u0627 \u064a\u0645\u0646\u0639 \u0628\u062f\u0621 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.<br>");
        sb.append("\ud83d\udd38 <b>\u0627\u0644\u062d\u0644:</b> \u062d\u062f\u0651\u062b \u0623\u0648 \u0623\u0639\u062f \u062a\u062b\u0628\u064a\u062a \u0623\u0648 \u0627\u062d\u0630\u0641 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629. ");
        sb.append("\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0642\u064a\u062f \u0627\u0644\u062a\u0637\u0648\u064a\u0631\u060c \u0641\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0647\u0627 \u062a\u0645 \u062a\u062c\u0645\u064a\u0639\u0647\u0627 \u0644\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062f\u0642\u064a\u0642 \u0645\u0646 Forge/NeoForge.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "\u062e\u0637\u0623 \u0641\u064a \u062a\u0647\u064a\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. \u062d\u062f\u0651\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0633\u0628\u0628: \u0631\u0627\u062c\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u062b\u0628\u062a\u0629 \u0645\u0624\u062e\u0631\u064b\u0627 \u0623\u0648 \u062a\u0644\u0643 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0627\u0644\u062a\u0637\u0648\u064a\u0631.";
        }
        return "1. \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0633\u0628\u0628 \u0647\u0648: " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. \u062d\u062f\u0651\u062b \u0623\u0648 \u0623\u0639\u062f \u062a\u062b\u0628\u064a\u062a \u0623\u0648 \u0627\u062d\u0630\u0641 \u0627\u0644\u062a\u0639\u062f\u064a\u0644. \u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 Forge/NeoForge \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u0637\u0631\u064a\u0642\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629.</b><br>\u062d\u0627\u0648\u0644 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u0637\u0631\u064a\u0642\u0629 <b style='color:#" + colorCodigo + "'>" + metodo + "</b>\u060c \u0648\u0627\u0644\u062a\u064a \u0644\u0627 \u062a\u0648\u062c\u062f \u0641\u064a \u0647\u0630\u0627 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0645\u0646 \u0627\u0644\u0644\u0639\u0628\u0629 \u0623\u0648 \u062a\u0639\u062f\u064a\u0644 \u0622\u062e\u0631.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "\u0637\u0631\u064a\u0642\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629 (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u064a\u0643\u0648\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0644\u0639\u0628\u0629 \u0627\u0644\u062d\u0627\u0644\u064a \u0623\u0648 \u0645\u0639 \u062a\u0639\u062f\u064a\u0644 \u0622\u062e\u0631.";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. \u062d\u062f\u0651\u062b \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u0639\u0646\u064a\u0629. \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631 \u0627\u0644\u062e\u0637\u0623\u060c \u0642\u0645 \u0628\u0627\u0644\u0625\u0628\u0644\u0627\u063a \u0639\u0646\u0647 \u0644\u0645\u0637\u0648\u0651\u0631 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u062a\u0623\u062b\u0631.";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u062e\u0637\u0623 \u062d\u0631\u062c: \u062d\u0642\u0644 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f.</b><br>\u062d\u0627\u0648\u0644 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0627\u0644\u062d\u0642\u0644 <b style='color:#" + colorCodigo + "'>" + campo + "</b>\u060c \u0627\u0644\u0630\u064a \u0644\u0627 \u064a\u0648\u062c\u062f \u0641\u064a \u0647\u0630\u0627 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0645\u0646 \u0627\u0644\u0644\u0639\u0628\u0629 \u0623\u0648 \u062a\u0639\u062f\u064a\u0644 \u0622\u062e\u0631.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "\u062d\u0642\u0644 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0627\u062f\u0629\u064b \u0639\u0646\u062f\u0645\u0627 \u064a\u0643\u0648\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0644\u0639\u0628\u0629 \u0627\u0644\u062d\u0627\u0644\u064a \u0623\u0648 \u0645\u0639 \u062a\u0639\u062f\u064a\u0644 \u0622\u062e\u0631.";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. \u062d\u062f\u0651\u062b \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u062a\u0636\u0631\u0631\u0629. \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0627\u062a\u0635\u0644 \u0628\u0645\u0637\u0648\u0651\u0631 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0630\u064a \u062a\u0633\u0628\u0628 \u0641\u064a \u0627\u0644\u062e\u0637\u0623.";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\u0647\u0644 \u062a\u062d\u062a\u0627\u062c \u0645\u0633\u0627\u0639\u062f\u0629\u061f</strong><br>  \u0625\u0630\u0627 \u0643\u0646\u062a \u0644\u0627 \u062a\u0639\u0631\u0641 \u0643\u064a\u0641\u064a\u0629 \u0627\u0644\u0625\u0635\u0644\u0627\u062d \u0623\u0648 \u0644\u0645 \u062a\u064f\u0630\u0643\u0631 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0647\u0646\u0627\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0645\u0633\u0627\u0639\u062f\u0629 \u0639\u0628\u0631 \u0634\u0628\u0643\u0627\u062a\u0646\u0627 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629.   \u0627\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0632\u0631 <img src='" + iconoCompartir + "' alt='\u0645\u0634\u0627\u0631\u0643\u0629' style='height:12px;vertical-align:middle;'/>   <strong>\u0645\u0634\u0627\u0631\u0643\u0629</strong> \u0644\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0631\u0648\u0627\u0628\u0637 \u0644\u0644\u0633\u062c\u0644\u0627\u062a \u0648\u0646\u062a\u0627\u0626\u062c \u0627\u0644\u062a\u062d\u0644\u064a\u0644 \u0644\u0641\u0631\u064a\u0642 \u0627\u0644\u062f\u0639\u0645.   \u0625\u0630\u0627 \u0643\u0646\u062a \u0645\u0646\u0634\u0626 \u062d\u0632\u0645\u0629 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0623\u0648 \u0634\u0631\u0643\u0629\u060c \u0641\u0642\u0645 \u0628\u062a\u0639\u062f\u064a\u0644 <code>crash_detector/plantilla.htm</code>   \u0644\u062a\u062e\u0635\u064a\u0635 \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0641\u0631\u064a\u0642\u0643.</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0627\u0644\u0642\u0627\u0644\u0628";
    }

    @Override
    public String restablecer() {
        return "\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return "\u0647\u0644 \u062a\u0631\u064a\u062f \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 " + nombreImagen + " \u0625\u0644\u0649 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629\u061f";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\u0647\u0644 \u062a\u0631\u064a\u062f \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0627\u0644\u0642\u0627\u0644\u0628 \u0625\u0644\u0649 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629\u061f";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062a\u0639\u0630\u0631 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0628\u0639\u0636 \u0643\u0644\u0627\u0633\u0627\u062a AzureLib. \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0645\u062a\u0644\u0643 \u0628\u0627\u0644\u0641\u0639\u0644 AzureLib\u060c \u064a\u064f\u0631\u062c\u0649 \u062a\u062b\u0628\u064a\u062a \u0625\u0635\u062f\u0627\u0631 \u0633\u0627\u0628\u0642 \u0645\u0646 AzureLib \u0642\u0628\u0644 8 \u0623\u0643\u062a\u0648\u0628\u0631 2025. \u0643\u0627\u0646 \u0647\u0630\u0627 \u0634\u0627\u0626\u0639\u0627\u064b. \u0625\u0630\u0627 \u0644\u0645 \u064a\u0643\u0646 \u0644\u062f\u064a\u0643 AzureLib\u060c \u0641\u062b\u0628\u0651\u062a \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062d\u0627\u0644\u064a.</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0627\u0644\u062a\u0639\u062f\u064a\u0644 <code>healight</code> \u064a\u062a\u0633\u0628\u0628 \u0641\u064a \u062e\u0637\u0623 \u062d\u0631\u062c: <code>java.lang.NoSuchFieldError: INT</code>. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0644\u0623\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u062d\u0642\u0644 \u0644\u0645 \u064a\u0639\u062f \u0645\u0648\u062c\u0648\u062f\u064b\u0627 \u0641\u064a \u0625\u0635\u062f\u0627\u0631 MCForge 47.10 \u0648\u0645\u0627 \u0641\u0648\u0642 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a 1.20. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u0639\u0628\u0629 \u0627\u0644\u0628\u062f\u0621 \u0628\u0633\u0628\u0628 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629.</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 \u0627\u062d\u0630\u0641 \u0623\u0648 \u062d\u062f\u0651\u062b \u0627\u0644\u062a\u0639\u062f\u064a\u0644 <code>healight</code>. \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062d\u0627\u0644\u064a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 MinecraftForge 47.10 \u0644\u0625\u0635\u062f\u0627\u0631 1.20.1. \u0627\u0628\u062d\u062b \u0639\u0646 \u0625\u0635\u062f\u0627\u0631 \u0623\u062d\u062f\u062b \u0645\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0623\u0648 \u0641\u0643\u0651\u0631 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0628\u062f\u064a\u0644.";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "\u062e\u0637\u0623 \u062d\u0631\u062c: healight - \u0627\u0644\u062d\u0642\u0644 'INT' \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("\u0627\u0644\u0635\u0641 <code>").append(clase).append("</code> \u0644\u0627 \u064a\u064f\u0646\u0641\u0630 \u0627\u0644\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u0645\u0637\u0644\u0648\u0628\u0629:<br>").append("<code>").append(metodo).append("</code><br>").append("\u0645\u0646 \u0627\u0644\u0648\u0627\u062c\u0647\u0629 <code>").append(interfaz).append("</code>.");
        if (!origen.isEmpty()) {
            sb.append("<br><br>\u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0623\u0648 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0645\u0634\u0628\u0648\u0647: <code>").append(origen).append("</code>.");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u064a\u064f\u0639\u062f\u0651\u0644 \u062a\u0639\u062f\u064a\u0644\u0627\u064b \u0648\u0627\u062c\u0647\u0629 \u0644\u0643\u0646\u0647 \u064a\u062a\u062c\u0627\u0647\u0644 \u0637\u0631\u064a\u0642\u0629 \u0625\u0644\u0632\u0627\u0645\u064a\u0629. \u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b <b>\u0643\u0644\u0627 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u064a\u0646</b> \u0627\u0644\u0645\u062a\u0648\u0631\u0637\u064a\u0646 (\u0627\u0644\u0630\u064a \u064a\u0639\u0631\u0651\u0641 \u0627\u0644\u0648\u0627\u062c\u0647\u0629 \u0648\u0627\u0644\u0630\u064a \u064a\u064f\u0646\u0641\u0651\u0630\u0647\u0627). \u0625\u0630\u0627 \u0643\u0646\u062a \u0644\u0627 \u062a\u0639\u0631\u0641 \u0623\u064a\u0647\u0645\u0627\u060c \u0627\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u0623\u0633\u0645\u0627\u0621 \u0627\u0644\u0638\u0627\u0647\u0631\u0629 \u0641\u064a \u0631\u0633\u0627\u0644\u0629 \u0627\u0644\u062e\u0637\u0623.";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "\u0637\u0631\u064a\u0642\u0629 \u0648\u0627\u062c\u0647\u0629 \u063a\u064a\u0631 \u0645\u0646\u0641\u0630\u0629 (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u064a\u062d\u0627\u0648\u0644 \u062a\u0639\u062f\u064a\u0644 \u062a\u062d\u0645\u064a\u0644 \u0635\u0646\u0641 \u0645\u0646 <b>\u062c\u0627\u0646\u0628 \u0627\u0644\u0639\u0645\u064a\u0644</b> (<code>AnimationMetadataSection</code>) \u0639\u0644\u0649 <b>\u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635</b>\u060c \u0648\u0647\u0648 \u0623\u0645\u0631 \u063a\u064a\u0631 \u0645\u0645\u0643\u0646. \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u064a\u0638\u0647\u0631 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u0644\u0627 \u064a\u0642\u0648\u0645 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0628\u0641\u0635\u0644 \u0627\u0644\u0643\u0648\u062f \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d \u0628\u064a\u0646 \u0627\u0644\u0639\u0645\u064a\u0644 \u0648\u0627\u0644\u062e\u0627\u062f\u0645. \u0642\u062f \u064a\u0643\u0634\u0641 \u0648\u062c\u0648\u062f <code>ModernFix</code> \u0639\u0646 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0631\u063a\u0645 \u0623\u0646\u0647 \u0644\u064a\u0633 \u0627\u0644\u0633\u0628\u0628 \u0627\u0644\u0645\u0628\u0627\u0634\u0631.</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>\u062d\u0644 \u0633\u0631\u064a\u0639:</b> \u0627\u062d\u0630\u0641 \u0645\u0624\u0642\u062a\u064b\u0627 <code>ModernFix</code> \u0644\u0644\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u064a\u0645\u0643\u0646\u0647 \u0627\u0644\u0628\u062f\u0621. \u0625\u0630\u0627 \u0646\u062c\u062d \u0630\u0644\u0643\u060c \u0641\u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u062a\u0639\u062f\u064a\u0644 \u0622\u062e\u0631 \u064a\u0642\u0648\u0645 \u0628\u062a\u062d\u0645\u064a\u0644 \u0623\u0635\u0646\u0627\u0641 \u0627\u0644\u0639\u0645\u064a\u0644 \u0639\u0644\u0649 \u0627\u0644\u062e\u0627\u062f\u0645.<br>\u2022 <b>\u0627\u0644\u062d\u0644 \u0627\u0644\u062f\u0627\u0626\u0645:</b> \u062d\u062f\u0651\u062f \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0633\u0624\u0648\u0644 (\u0627\u0628\u062d\u062b \u0639\u0646 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0648\u0627\u0631\u062f \u0645\u062a\u062d\u0631\u0643\u0629 \u0623\u0648 \u0642\u0648\u0627\u0645 \u0645\u062e\u0635\u0635\u0629 \u0623\u0648 \u0645\u0643\u062a\u0628\u0627\u062a \u0631\u0633\u0648\u0645\u064a\u0629) \u0648\u062d\u062f\u0651\u062b\u0647 \u0623\u0648 \u0627\u062d\u0630\u0641\u0647.<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 \u0643\u0644\u0627\u0633 \u0639\u0645\u064a\u0644 \u0639\u0644\u0649 \u0627\u0644\u062e\u0627\u062f\u0645 (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0645\u0644\u0641 \u062a\u0647\u064a\u0626\u0629 \u0623\u062d\u062f \u062a\u0639\u062f\u064a\u0644\u0627\u062a <code>Sinytra Connector</code> \u062a\u0627\u0644\u0641. \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0646\u062f\u0645\u0627 \u064a\u0645\u062a\u0644\u0626 \u0627\u0644\u0645\u0644\u0641 \u0628\u062d\u0631\u0648\u0641 \u0641\u0627\u0631\u063a\u0629 (<code>\\u0000</code>) \u0646\u062a\u064a\u062c\u0629 \u0644\u0625\u063a\u0644\u0627\u0642 \u063a\u064a\u0631 \u0645\u062a\u0648\u0642\u0639 \u0644\u0644\u0639\u0628\u0629\u060c \u0623\u0648 \u0623\u062e\u0637\u0627\u0621 \u0641\u064a \u0627\u0644\u0643\u062a\u0627\u0628\u0629\u060c \u0623\u0648 \u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a.</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 \u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 \u0645\u062c\u0644\u062f <code>config/</code> \u0641\u064a \u0646\u0633\u062e\u062a\u0643 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a.<br>\u2022 \u0627\u0628\u062d\u062b \u0639\u0646 \u0645\u0644\u0641\u0627\u062a \u062a\u0647\u064a\u0626\u0629 \u062a\u0639\u062f\u064a\u0644\u0627\u062a connector \u0648\u0627\u062d\u0630\u0641\u0647\u0627.<br>\u2022 \u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629: \u0633\u064a\u0642\u0648\u0645 Sinytra Connector \u0628\u0625\u0646\u0634\u0627\u0621 \u0645\u0644\u0641 \u062a\u0647\u064a\u0626\u0629 \u062c\u062f\u064a\u062f \u0648\u0646\u0638\u064a\u0641.";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "\u062a\u0647\u064a\u0626\u0629 Sinytra Connector \u062a\u0627\u0644\u0641\u0629";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0627\u0644\u0645\u0644\u0641 <code>" + nombreJar + "</code> \u062a\u0627\u0644\u0641 \u0623\u0648 \u0646\u0627\u0642\u0635.<br>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u0646\u0638\u0627\u0645 \u0642\u0631\u0627\u0621\u0629 \u0645\u062d\u062a\u0648\u0627\u0647 \u0644\u0623\u0646 \u0631\u0623\u0633 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0646\u0647\u0627\u0626\u064a \u0644\u0640 ZIP \u0645\u0641\u0642\u0648\u062f.<br>\u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0628\u0639\u062f \u062a\u0646\u0632\u064a\u0644 \u0645\u062a\u0642\u0637\u0639 \u0623\u0648 \u0641\u0634\u0644 \u0641\u064a \u0639\u0645\u0644 \u0627\u0644\u0645\u064f\u0634\u063a\u0644.</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "\u0645\u0644\u0641 JAR \u062a\u0627\u0644\u0641 (\u0645\u0639 \u0627\u0633\u0645 \u0645\u062d\u062f\u062f)";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>\u0627\u062d\u0630\u0641 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0627\u0644\u0641</b> \u0648\u0642\u0645 \u0628\u062a\u0646\u0632\u064a\u0644\u0647 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u0645\u0646 \u0627\u0644\u0645\u0635\u062f\u0631 \u0627\u0644\u0631\u0633\u0645\u064a (\u0645\u062b\u0644 CurseForge\u060c MinecraftStorage\u060c \u0625\u0644\u062e).<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0645\u0634\u063a\u0644\u064b\u0627 \u0645\u062b\u0644 CurseForge \u0623\u0648 Technic \u0623\u0648 Luna Pixel\u060c \u0641\u0641\u0643\u0631 \u0641\u064a \u0627\u0644\u062a\u062d\u0648\u0644 \u0625\u0644\u0649 <b>ATLauncher</b> \u0623\u0648 <b>Prism Launcher</b>\u060c \u0627\u0644\u0644\u0630\u064a\u0646 \u064a\u0642\u0648\u0645\u0627\u0646 \u0628\u0627\u0644\u062a\u062d\u0642\u0642 \u0628\u0634\u0643\u0644 \u0623\u0641\u0636\u0644 \u0645\u0646 \u0633\u0644\u0627\u0645\u0629 \u0627\u0644\u0645\u0644\u0641\u0627\u062a.<br>\u2022 \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0627\u062a\u0635\u0627\u0644 \u0627\u0644\u0625\u0646\u062a\u0631\u0646\u062a \u0644\u062f\u064a\u0643 \u0645\u0633\u062a\u0642\u0631 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u0646\u0632\u064a\u0644.";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u062a\u0639\u0630\u0631 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0639\u0627\u0644\u0645 \u0644\u0623\u0646 \u0623\u062d\u062f \u0645\u0644\u0641\u0627\u062a NBT \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0647 \u062a\u0627\u0644\u0641\u0629 (\u0645\u062b\u0644\u064b\u0627: <code>level.dat</code>, <code>playerdata/*.dat</code>\u060c \u0623\u0648 \u0627\u0644\u0642\u0637\u0639).<br>\u0627\u0644\u062e\u0637\u0623 \u0627\u0644\u0645\u062d\u062f\u062f \u0647\u0648: <code>UTFDataFormatException: \u0645\u062f\u062e\u0644 \u063a\u064a\u0631 \u0633\u0644\u064a\u0645 \u062d\u0648\u0644 \u0627\u0644\u0628\u0627\u064a\u062a " + byteCorrupto + "</code>.<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f \u0642\u0628\u0644 \u0645\u062d\u0627\u0648\u0644\u0629 \u0623\u064a \u0625\u0635\u0644\u0627\u062d\u060c \u0642\u0645 \u0628\u0639\u0645\u0644 \u0646\u0633\u062e\u0629 \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0643\u0627\u0645\u0644\u0629 \u0645\u0646 \u0645\u062c\u0644\u062f \u0627\u0644\u0639\u0627\u0644\u0645.</b><br><br>\u064a\u0645\u0643\u0646\u0643 \u0645\u062d\u0627\u0648\u0644\u0629 \u0625\u0635\u0644\u0627\u062d \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0627\u0644\u0641 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 <b>\u0645\u062d\u0631\u0631 NBT</b> \u0645\u062b\u0644 <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>.<br>\u0625\u0630\u0627 \u0643\u0627\u0646 \u0627\u0644\u062a\u0644\u0641 \u0634\u062f\u064a\u062f\u064b\u0627\u060c \u0627\u0633\u062a\u062e\u062f\u0645 <b>\u0645\u062d\u0631\u0631\u064b\u0627 \u062b\u0646\u0627\u0626\u064a\u064b\u0627</b> (\u0645\u062b\u0644 HxD) \u0644\u0641\u062d\u0635 \u0648\u062a\u0635\u062d\u064a\u062d \u0627\u0644\u0628\u0627\u064a\u062a\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0635\u0627\u0644\u062d\u0629 (\u0641\u0642\u0637 \u0625\u0630\u0627 \u0643\u0646\u062a \u0644\u062f\u064a\u0643 \u062e\u0628\u0631\u0629 \u0641\u064a \u062a\u0646\u0633\u064a\u0642 NBT).<br>\u0643\u0645\u0644\u0627\u0630 \u0623\u062e\u064a\u0631\u060c \u0642\u0645 \u0628\u0627\u0633\u062a\u0639\u0627\u062f\u0629 \u0627\u0644\u0646\u0633\u062e\u0629 \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0623\u0648 \u0627\u0633\u062a\u062e\u062f\u0645 \u0623\u062f\u0627\u0629 \u0625\u0635\u0644\u0627\u062d \u0627\u0644\u0639\u0648\u0627\u0644\u0645 \u0645\u0646 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0645\u062b\u0644 <code>FTB Backup</code>.</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>\u0642\u0645 \u0628\u0639\u0645\u0644 \u0646\u0633\u062e\u0629 \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0643\u0627\u0645\u0644\u0629 \u0645\u0646 \u0645\u062c\u0644\u062f \u0627\u0644\u0639\u0627\u0644\u0645</b> \u0642\u0628\u0644 \u0645\u062d\u0627\u0648\u0644\u0629 \u0623\u064a \u0625\u0635\u0644\u0627\u062d.<br>\u2022 \u0627\u0633\u062a\u062e\u062f\u0645 \u0645\u062d\u0631\u0631 NBT (\u0645\u062b\u0644 NBT Studio) \u0644\u0641\u062a\u062d \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0627\u0644\u0641 \u0648\u0625\u0635\u0644\u0627\u062d\u0647.<br>\u2022 \u0625\u0630\u0627 \u0641\u0634\u0644 \u0630\u0644\u0643\u060c \u0641\u0627\u062d\u0635\u0644 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0641 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u062d\u0631\u0631 \u062b\u0646\u0627\u0626\u064a \u0639\u0646\u062f \u0645\u0648\u0642\u0639 \u0627\u0644\u0628\u0627\u064a\u062a \u0627\u0644\u062a\u0627\u0644\u0641.<br>\u2022 \u0625\u0630\u0627 \u0644\u0645 \u062a\u0643\u0646 \u0644\u062f\u064a\u0643 \u062e\u0628\u0631\u0629\u060c \u0642\u0645 \u0628\u0627\u0633\u062a\u0639\u0627\u062f\u0629 \u0627\u0644\u0639\u0627\u0644\u0645 \u0645\u0646 \u0646\u0633\u062e\u0629 \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u062d\u062f\u064a\u062b\u0629.";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "\u0639\u0627\u0644\u0645 \u062a\u0627\u0644\u0641: \u062e\u0637\u0623 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0628\u064a\u0627\u0646\u0627\u062a NBT";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0645\u0634\u0643\u0644\u0629 \u0641\u064a OpenAL. \u0623\u062d\u064a\u0627\u0646\u064b\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0633\u0628\u0628\u0647\u0627 \u062a\u0639\u0631\u064a\u0641\u0627\u062a Nouveau\u060c \u0648\u0644\u0643\u0646 \u0641\u064a \u0628\u0639\u0636 \u0627\u0644\u0623\u062d\u064a\u0627\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0647\u064a \u0623\u0646 \u0625\u0635\u062f\u0627\u0631 OpenAL \u0627\u0644\u0645\u0636\u0645\u0646 \u0645\u0639 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0645\u0648\u062c\u0648\u062f \u0641\u064a \u062a\u0648\u0632\u064a\u0639\u062a\u0643\u060c \u0648\u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062e\u0627\u0635 \u0628\u062a\u0648\u0632\u064a\u0639\u062a\u0643. \u0647\u0630\u0627 \u0634\u0627\u0626\u0639 \u0628\u0634\u0643\u0644 \u062e\u0627\u0635 \u0645\u0639 \u062a\u0648\u0632\u064a\u0639\u0627\u062a Red Hat \u0648\u0645\u0639 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0635\u0648\u062a \u0645\u062b\u0644 Sound Physics Remastered. \u0631\u0627\u062c\u0639 \u0647\u0630\u0627 \u0627\u0644\u062f\u0644\u064a\u0644 \u0644\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0645\u0633\u0627\u0639\u062f\u0629 \u0625\u0636\u0627\u0641\u064a\u0629: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>\u0643\u064a\u0641\u064a\u0629 \u0625\u0635\u0644\u0627\u062d \u0645\u0634\u0627\u0643\u0644 \u0627\u0644\u0635\u0648\u062a \u0641\u064a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0639\u0644\u0649 \u0644\u064a\u0646\u0643\u0633</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u062e\u0627\u062f\u0645 \u0644\u0623\u0646 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0639\u0627\u0644\u0645\u0647 \u0645\u062d\u062c\u0648\u0628 \u0628\u0648\u0627\u0633\u0637\u0629 \u0639\u0645\u0644\u064a\u0629 \u0623\u062e\u0631\u0649.<br>\u0639\u0627\u062f\u0629\u064b \u0645\u0627 \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0625\u0630\u0627:<br>\u2022 \u0647\u0646\u0627\u0643 \u0628\u0627\u0644\u0641\u0639\u0644 \u0646\u0633\u062e\u0629 \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0642\u064a\u062f \u0627\u0644\u062a\u0634\u063a\u064a\u0644.<br>\u2022 \u0628\u0631\u0646\u0627\u0645\u062c \u0645\u0643\u0627\u0641\u062d\u0629 \u0641\u064a\u0631\u0648\u0633\u0627\u062a \u0623\u0648 \u0645\u0633\u062a\u0639\u0631\u0636 \u0645\u0644\u0641\u0627\u062a \u0644\u062f\u064a\u0647 \u0645\u062c\u0644\u062f \u0627\u0644\u0639\u0627\u0644\u0645 \u0645\u0641\u062a\u0648\u062d\u064b\u0627.<br>\u2022 \u0627\u0644\u0639\u0645\u0644\u064a\u0629 \u0627\u0644\u0633\u0627\u0628\u0642\u0629 \u0644\u0645 \u062a\u064f\u063a\u0644\u0642 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d \u0648\u062a\u0631\u0643\u062a \u0645\u0644\u0641\u0627\u062a \u0645\u062d\u062c\u0648\u0628\u0629.</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>\u0623\u063a\u0644\u0642 \u062c\u0645\u064a\u0639 \u0646\u0633\u062e \u0627\u0644\u062e\u0627\u062f\u0645</b> (\u0628\u0645\u0627 \u0641\u064a \u0630\u0644\u0643 \u0627\u0644\u0639\u0645\u0644\u064a\u0627\u062a \u0641\u064a \u0627\u0644\u062e\u0644\u0641\u064a\u0629 \u0645\u062b\u0644 javaw.exe).<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0644\u0648\u062d\u0629 \u0627\u0633\u062a\u0636\u0627\u0641\u0629 (\u0645\u062b\u0644 Multicraft)\u060c \u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u062e\u0627\u062f\u0645 \u062a\u0645\u0627\u0645\u064b\u0627 \u0645\u0646 \u062e\u0644\u0627\u0644 \u0627\u0644\u0644\u0648\u062d\u0629.<br>\u2022 <b>\u0639\u0637\u0651\u0644 \u0645\u0624\u0642\u062a\u064b\u0627 \u0628\u0631\u0646\u0627\u0645\u062c \u0645\u0643\u0627\u0641\u062d\u0629 \u0627\u0644\u0641\u064a\u0631\u0648\u0633\u0627\u062a</b> \u0625\u0630\u0627 \u0634\u0643\u0643\u062a \u0641\u064a \u0623\u0646\u0647 \u064a\u062d\u062c\u0628 \u0627\u0644\u0645\u0644\u0641\u0627\u062a.<br>\u2022 \u0639\u0644\u0649 \u0627\u0644\u0623\u0646\u0638\u0645\u0629 \u0627\u0644\u0645\u062d\u0644\u064a\u0629\u060c \u0623\u063a\u0644\u0642 \u0623\u064a \u0646\u0627\u0641\u0630\u0629 \u0645\u0633\u062a\u0639\u0631\u0636 \u0645\u0644\u0641\u0627\u062a \u062a\u0639\u0631\u0636 \u0645\u062c\u0644\u062f \u0627\u0644\u0639\u0627\u0644\u0645.<br>\u2022 \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0627\u062d\u0630\u0641 \u064a\u062f\u0648\u064a\u064b\u0627 \u0645\u0644\u0641 <code>session.lock</code> \u062f\u0627\u062e\u0644 \u0645\u062c\u0644\u062f \u0627\u0644\u0639\u0627\u0644\u0645 (\u0641\u0642\u0637 \u0625\u0630\u0627 \u0643\u0646\u062a \u0645\u062a\u0623\u0643\u062f\u064b\u0627 \u0645\u0646 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u062e\u0627\u062f\u0645 \u0622\u062e\u0631 \u064a\u0639\u0645\u0644).";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "\u0645\u0644\u0641 \u0627\u0644\u0639\u0627\u0644\u0645 \u0645\u062d\u062c\u0648\u0628 \u0628\u0648\u0627\u0633\u0637\u0629 \u0639\u0645\u0644\u064a\u0629 \u0623\u062e\u0631\u0649";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u062d\u0627\u0648\u0644 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u062a\u0648\u0633\u064a\u0639 \u0627\u0644\u0635\u0646\u0641 <code>" + clasePadreFinal + "</code>\u060c \u0644\u0643\u0646 \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641 \u0623\u0635\u0628\u062d \u0627\u0644\u0622\u0646 <b>\u0646\u0647\u0627\u0626\u064a\u064b\u0627</b> \u0648\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0644\u0648\u0631\u0627\u062b\u0629 \u0645\u0646\u0647.<br>\u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629 \u0647\u0648: <code>" + claseHija + "</code>.<br><br>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0627\u062f\u0629 \u0639\u0646\u062f\u0645\u0627 \u064a\u0643\u0648\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0645\u064f\u062c\u0645\u064e\u0651\u0639 \u0644\u0625\u0635\u062f\u0627\u0631 \u0633\u0627\u0628\u0642 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0623\u0648 \u062a\u0639\u062f\u064a\u0644 \u0623\u0633\u0627\u0633\u064a \u0622\u062e\u0631 \u0642\u062f \u0642\u0627\u0645 \u0628\u0648\u0636\u0639 \u0648\u0633\u0645 <code>final</code> \u0639\u0644\u0649 \u0628\u0639\u0636 \u0627\u0644\u0623\u0635\u0646\u0627\u0641 \u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u062d\u062f\u064a\u062b\u0629.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>\u062d\u062f\u0651\u062b \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u062a\u0648\u0631\u0637\u0629</b>\u060c \u062e\u0627\u0635\u0629 \u062a\u0644\u0643 \u0627\u0644\u062a\u064a \u0642\u062f \u062a\u0643\u0648\u0646 \u0645\u0631\u062a\u0628\u0637\u0629 \u0628\u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0623\u0633\u0627\u0633\u064a \u0627\u0644\u0645\u0630\u0643\u0648\u0631.<br>\u2022 \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0627\u0628\u062d\u062b \u0639\u0646 \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u064a\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062d\u0627\u0644\u064a \u0648\u0627\u0639\u062a\u0645\u0627\u062f\u064a\u0627\u062a\u0647.<br>\u2022 \u0641\u064a \u0628\u0639\u0636 \u0627\u0644\u062d\u0627\u0644\u0627\u062a\u060c \u0642\u062f \u064a\u0633\u0627\u0639\u062f \u062d\u0630\u0641 \u0645\u0624\u0642\u062a \u0644\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0641\u0631\u0639\u064a \u0641\u064a \u062a\u0623\u0643\u064a\u062f \u0627\u0644\u0633\u0628\u0628.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "\u0645\u062d\u0627\u0648\u0644\u0629 \u0648\u0631\u0627\u062b\u0629 \u0635\u0646\u0641 \u0646\u0647\u0627\u0626\u064a";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 <b>Rubidium</b> (\u0646\u0633\u062e\u0629 \u0645\u0646\u0633\u0648\u062e\u0629 \u0642\u062f\u064a\u0645\u0629 \u0645\u0646 Sodium \u0644\u0646\u0638\u0627\u0645 Forge) \u0645\u0639 <b>Iris \u0623\u0648 Oculus</b>.<br>\u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u062d\u062f\u064a\u062b\u0629 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a (1.19.2 \u0641\u0645\u0627 \u0641\u0648\u0642)\u060c \u0644\u0645 \u064a\u0648\u0627\u0635\u0644 Rubidium \u0645\u0648\u0627\u0643\u0628\u0629 Sodium\u060c \u0648\u0638\u0647\u0631\u062a \u0645\u0634\u0643\u0644\u0627\u062a \u0641\u064a \u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a.<br><br>\u0642\u062f \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0623\u064a\u0636\u064b\u0627 \u0628\u0633\u0628\u0628 \u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0623\u062f\u0627\u0621 (Sodium\u060c Rubidium\u060c Embeddium\u060c Bedium\u060c Xeonium\u060c \u0625\u0644\u062e) \u0623\u0648 Iris Shaders \u0648\u062a\u0639\u062f\u064a\u0644 \u0622\u062e\u0631.</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <b>\u0627\u062d\u0630\u0641 Rubidium</b> \u0645\u0646 \u0645\u062c\u0644\u062f <code>mods</code> \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.<br>\u2022 <b>\u062b\u0628\u0651\u062a <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a></b>, \u0627\u0644\u0646\u0633\u062e\u0629 \u0627\u0644\u0645\u0637\u0648\u0631\u0629 \u0648\u0627\u0644\u0645\u0636\u0645\u0646\u0629 \u0645\u0646 Sodium \u0644\u0646\u0638\u0627\u0645 Forge \u0648\u0627\u0644\u062a\u064a \u062a\u062f\u0639\u0645 Iris/Oculus \u0641\u064a 1.20+.<br>\u2022 \u062a\u0623\u0643\u062f \u0645\u0646 \u0639\u062f\u0645 \u062a\u062b\u0628\u064a\u062a \u0623\u0643\u062b\u0631 \u0645\u0646 \u0646\u0633\u062e\u0629 \u0645\u0646 Sodium \u0641\u064a \u0646\u0641\u0633 \u0627\u0644\u0648\u0642\u062a (\u0645\u062b\u0644: Rubidium + Embeddium).<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 Oculus \u0628\u062f\u0644\u064b\u0627 \u0645\u0646 Iris\u060c \u062a\u062d\u0642\u0642 \u0645\u0646 \u0623\u0646\u0647 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 Forge \u0648Embeddium \u0644\u062f\u064a\u0643.";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "Rubidium \u0642\u062f\u064a\u0645 \u0645\u0639 Iris/Oculus (OptionInstance \u0647\u0648 \u0646\u0647\u0627\u0626\u064a)";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u062a\u0639\u062f\u064a\u0644 <code>Simple Voice Chat</code> \u062a\u0634\u063a\u064a\u0644 \u062e\u0627\u062f\u0645 \u0627\u0644\u0635\u0648\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0647 \u0644\u0623\u0646 \u0645\u0646\u0641\u0630 UDP \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 IP \u0627\u0644\u0645\u064f\u0639\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.<br>\u0647\u0630\u0627 \u0644\u0627 \u064a\u0645\u0646\u0639 \u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629\u060c \u0644\u0643\u0646\u0647 \u064a\u0639\u0637\u0644 \u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u062f\u0631\u062f\u0634\u0629 \u0627\u0644\u0635\u0648\u062a\u064a\u0629.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>\u0623\u063a\u0644\u0642 \u0623\u064a \u0646\u0633\u062e\u0629 \u0623\u062e\u0631\u0649 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a</b> \u0623\u0648 \u062a\u0637\u0628\u064a\u0642 \u064a\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0645\u0646\u0641\u0630 UDP 24454.<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u0639\u0644\u0649 \u062e\u0627\u062f\u0645\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 <b>\u0623\u064a \u062e\u062f\u0645\u0629 \u0623\u062e\u0631\u0649</b> \u0644\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0627\u0644\u0645\u0646\u0641\u0630.<br>\u2022 \u0641\u064a \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u062a\u0639\u062f\u064a\u0644 (<code>config/voicechat/</code>)\u060c \u063a\u064a\u0651\u0631 \u0645\u0646\u0641\u0630 UDP \u0625\u0644\u0649 \u0645\u0646\u0641\u0630 \u062d\u0631 (\u0645\u062b\u0644\u0627\u064b 24455).<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0639\u0646\u0648\u0627\u0646 IP \u0645\u062e\u0635\u0635\u064b\u0627\u060c \u0641\u062a\u062d\u0642\u0642 \u0645\u0646 \u0635\u062d\u062a\u0647 \u0623\u0648 \u0627\u062a\u0631\u0643\u0647 \u0641\u0627\u0631\u063a\u064b\u0627 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0625\u0639\u062f\u0627\u062f \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "\u0627\u0644\u062f\u0631\u062f\u0634\u0629 \u0627\u0644\u0635\u0648\u062a\u064a\u0629: \u0645\u0646\u0641\u0630 UDP \u0645\u0634\u063a\u0648\u0644 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 IP \u063a\u064a\u0631 \u0635\u0627\u0644\u062d";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0639\u0646\u0635\u0631 \u0627\u0644\u0643\u062a\u0644\u0629 <code>" + nombreBlockItem + "</code> \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0643\u062a\u0644\u0629 \u0641\u0627\u0631\u063a\u0629.<br>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0627\u062f\u0629 \u0641\u064a <b>\u0625\u0636\u0627\u0641\u0627\u062a Create</b> (\u0645\u062b\u0644 <code>dndecor</code>, <code>createdeco</code>) \u0639\u0646\u062f\u0645\u0627 \u062a\u0643\u0648\u0646 \u0647\u0646\u0627\u0643 \u062a\u0639\u0627\u0631\u0636\u0627\u062a \u0645\u0639 <code>Amendments</code>\u060c <code>Moonshine</code>\u060c \u0623\u0648 \u0639\u0646\u062f \u062a\u0647\u064a\u0626\u0629 \u0627\u0644\u0643\u062a\u0644 \u0628\u0634\u0643\u0644 \u062e\u0627\u0637\u0626.<br><b>\u0645\u0644\u0627\u062d\u0638\u0629:</b> \u0647\u0630\u0627 \u0644\u064a\u0633 \u062e\u0637\u0623 \u0645\u0646 <code>Amendments</code> \u0645\u0628\u0627\u0634\u0631\u0629\u060c \u0628\u0644 \u0647\u0648 \u0639\u0631\u0636\u0629 \u0644\u0645\u0634\u0643\u0644\u0629 \u0623\u0639\u0645\u0642 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0633\u062c\u0644\u0627\u062a.</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>\u062d\u062f\u0651\u062b \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u0631\u062a\u0628\u0637\u0629:</b> Create \u0648 Ammendments \u0648 Moonshine \u0648\u0623\u064a \u0625\u0636\u0627\u0641\u0629 (\u062e\u0627\u0635\u0629\u064b <code>dndecor</code> \u0648 <code>createdeco</code>).<br>\u2022 \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c <b>\u0627\u062d\u0630\u0641 \u0645\u0624\u0642\u062a\u064b\u0627 \u0625\u0636\u0627\u0641\u0627\u062a Create</b> \u0648\u0627\u062d\u062f\u0629 \u062a\u0644\u0648 \u0627\u0644\u0623\u062e\u0631\u0649 \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0633\u0628\u0628.<br>\u2022 \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 <b>Amendments \u0648 Moonshine \u0645\u062a\u0648\u0627\u0641\u0642\u0627\u0646</b> \u0645\u0639 \u0625\u0635\u062f\u0627\u0631\u0643 \u0645\u0646 Create \u0648 Forge.<br>\u2022 \u0627\u0628\u062d\u062b \u0639\u0646 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u062a\u062c\u0631\u064a\u0628\u064a\u0629 \u0623\u0648 \u0646\u0633\u062e \u0645\u0639\u062f\u0644\u0629 \u062d\u062f\u064a\u062b\u0629 \u0645\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0627\u062a \u0627\u0644\u0645\u0639\u064a\u0628\u0629.";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "\u0639\u0646\u0635\u0631 \u0643\u062a\u0644\u0629 \u0641\u0627\u0631\u063a \u0641\u064a \u0625\u0636\u0627\u0641\u0629 Create";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0644\u0627 \u062a\u0646\u062a\u0645\u064a \u0625\u0644\u0649 \u0623\u064a \u0645\u0646\u0635\u0629 \u0646\u0634\u0637\u0629 (Forge\u060c Fabric\u060c \u0625\u0644\u062e):<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0627\u062f\u0629 \u0639\u0646\u062f\u0645\u0627:<br>").append("\u2022 \u064a\u062a\u0645 \u0645\u0632\u062c \u062a\u0639\u062f\u064a\u0644\u0627\u062a <b>Fabric \u0648 Forge</b> \u0641\u064a \u0646\u0641\u0633 \u0627\u0644\u0645\u062c\u0644\u062f.<br>").append("\u2022 \u064a\u062a\u0645 \u062a\u062b\u0628\u064a\u062a \u062a\u0639\u062f\u064a\u0644 \u0644\u0625\u0635\u062f\u0627\u0631 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a.<br>").append("\u2022 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u062a\u0627\u0644\u0641 \u0623\u0648 \u0644\u064a\u0633 \u0645\u0644\u0641 JAR \u0635\u0627\u0644\u062d\u064b\u0627.</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>\u062a\u062d\u0642\u0642 \u0645\u0646 \u0623\u0646 \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0645\u062e\u0635\u0635\u0629 \u0644\u0646\u0641\u0633 \u0627\u0644\u0645\u0646\u0635\u0629</b> (Forge <b>\u0623\u0648</b> Fabric\u060c \u0648\u0644\u064a\u0633 \u0643\u0644\u064a\u0647\u0645\u0627).<br>\u2022 \u0627\u0633\u062a\u062e\u062f\u0645 <b>\u0647\u064a\u0643\u0644 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a</b> \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0646\u0635\u0629 \u0627\u0644\u062a\u064a \u064a\u0643\u062a\u0634\u0641\u0647\u0627 \u0643\u0644 \u0645\u0644\u0641.<br>\u2022 \u0627\u062d\u0630\u0641 \u0623\u064a \u062a\u0639\u062f\u064a\u0644 \u0644\u0627 \u062a\u062a\u0639\u0631\u0641 \u0639\u0644\u064a\u0647 \u0623\u0648 \u064a\u0643\u0648\u0646 \u0644\u0645\u0646\u0635\u0629 \u0645\u062e\u062a\u0644\u0641\u0629.<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0645\u0634\u063a\u0644\u064b\u0627 \u0645\u062b\u0644 CurseForge \u0623\u0648 Prism\u060c \u0641\u062a\u0623\u0643\u062f \u0645\u0646 \u0636\u0628\u0637 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "\u062a\u0639\u062f\u064a\u0644 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0627\u0644\u0645\u062d\u0645\u0644 \u0627\u0644\u0646\u0634\u0637";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u062a\u0639\u0630\u0631 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0646\u0645\u0648\u0630\u062c <code>" + modid + ":" + nombreModelo + "</code>.<br>\u0647\u0630\u0627 \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0623\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 <code>" + modid + "</code> \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0648\u0627\u0631\u062f \u062a\u0627\u0644\u0641\u0629 \u0623\u0648 \u0646\u0627\u0642\u0635\u0629 \u0623\u0648 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>\u062d\u062f\u0651\u062b \u0627\u0644\u062a\u0639\u062f\u064a\u0644</b> \u0625\u0644\u0649 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0628\u064a\u0626\u0629 \u0627\u0644\u0644\u0639\u0628 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643.<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u062a\u062c\u0631\u064a\u0628\u064a\u064b\u0627 \u0623\u0648 \u0645\u0639\u062f\u0644\u064b\u0627\u060c \u0641\u0639\u062f \u0625\u0644\u0649 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0631\u0633\u0645\u064a.<br>\u2022 \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0645\u0644\u0641 JAR \u0644\u064a\u0633 \u062a\u0627\u0644\u0641\u064b\u0627 (\u0623\u0639\u062f \u062a\u062b\u0628\u064a\u062a\u0647).<br>\u2022 \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0642\u0645 \u0628\u0627\u0644\u0625\u0628\u0644\u0627\u063a \u0639\u0646 \u0627\u0644\u062e\u0637\u0623 \u0644\u0645\u0637\u0648\u0651\u0631 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0645\u0639 \u062a\u0636\u0645\u064a\u0646 \u0647\u0630\u0627 \u0627\u0644\u0633\u062c\u0644.";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "\u0641\u0634\u0644 \u0641\u064a \u0625\u0646\u0634\u0627\u0621 \u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0645\u0648\u0631\u062f";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a <code>Moonlight</code> \u0648 <code>Iceberg</code>.<br>\u0643\u0644\u0627\u0647\u0645\u0627 \u064a\u062d\u0627\u0648\u0644 \u062a\u0633\u062c\u064a\u0644 \u0623\u0646\u0638\u0645\u0629 \u0625\u0639\u0627\u062f\u0629 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0648\u0627\u0631\u062f \u0628\u0634\u0643\u0644 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u060c \u0645\u0645\u0627 \u064a\u0624\u062f\u064a \u0625\u0644\u0649 \u0641\u0634\u0644 \u0641\u064a OpenGL \u0628\u0633\u0628\u0628 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0633\u064a\u0627\u0642 \u0631\u0633\u0648\u0645\u064a \u0635\u0627\u0644\u062d.<br>\u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0634\u0627\u0626\u0639\u0629 \u0639\u0646\u062f \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u0646 Forge \u062a\u062a\u0636\u0645\u0646 \u0645\u062d\u0648\u0644\u0627\u062a \u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a Fabric.</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>\u062d\u062f\u0651\u062b \u0643\u0644\u0627 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u064a\u0646</b> \u0625\u0644\u0649 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631\u0627\u062a\u0647\u0645\u0627 \u0627\u0644\u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 Forge \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.<br>\u2022 \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c <b>\u0627\u062d\u0630\u0641 \u0645\u0624\u0642\u062a\u064b\u0627 Iceberg</b>\u060c \u0644\u0623\u0646 Moonlight \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u064a\u0643\u0648\u0646 \u062a\u0628\u0639\u064a\u0629 \u0623\u0633\u0627\u0633\u064a\u0629 \u0644\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0623\u062e\u0631\u0649.<br>\u2022 \u062a\u0623\u0643\u062f \u0645\u0646 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0646\u0633\u062e \u0645\u0643\u0631\u0631\u0629 \u0623\u0648 \u0645\u062e\u062a\u0644\u0637\u0629 \u0645\u0646 Forge/Fabric \u0644\u0647\u0630\u0647 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a.<br>\u2022 \u062a\u062d\u0642\u0642 \u0645\u0645\u0627 \u0625\u0630\u0627 \u0643\u0627\u0646 \u0623\u064a \u062a\u0639\u062f\u064a\u0644 \u0622\u062e\u0631 (\u0645\u062b\u0644 Supplementaries \u0623\u0648 Citadel) \u064a\u062a\u0636\u0645\u0646 \u0628\u0627\u0644\u0641\u0639\u0644 \u0648\u0638\u0627\u0626\u0641 Iceberg \u062f\u0627\u062e\u0644\u064a\u064b\u0627.";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "\u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c: Moonlight \u0645\u0642\u0627\u0628\u0644 Iceberg (\u0641\u0634\u0644 OpenGL - \u0644\u0627 \u064a\u0648\u062c\u062f \u0633\u064a\u0627\u0642)";
    }

    @Override
    public String instantanea() {
        return "\u0644\u0642\u0637\u0629";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "\u0645\u0646 \u0622\u062e\u0631 \u0644\u0642\u0637\u0629";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "\u0627\u062e\u062a\u0631 \u0645\u0644\u0641\u064b\u0627";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0644\u0642\u0637\u0629 \u0628\u0646\u062c\u0627\u062d";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "\u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0644\u0642\u0637\u0629";
    }

    @Override
    public String consejo() {
        return "\u0646\u0635\u064a\u062d\u0629";
    }

    @Override
    public String resultadoMuestra() {
        return "\u0639\u0631\u0636 \u0627\u0644\u0646\u062a\u064a\u062c\u0629";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>\u0646\u0635\u064a\u062d\u0629:</b> \u0627\u062e\u062a\u0631 \u0645\u0644\u0641\u064a\u0646 \u0645\u0646 \u0627\u0644\u0633\u062c\u0644 \u0644\u0644\u0645\u0642\u0627\u0631\u0646\u0629 \u0628\u064a\u0646 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a.   \u064a\u064f\u0638\u0647\u0631 \u0627\u0644\u0646\u0627\u062a\u062c \u0627\u0644\u0639\u0646\u0627\u0635\u0631 <span style='color:%s;'>\u0627\u0644\u0645\u0636\u0627\u0641\u0629 (+)</span> \u0648  <span style='color:%s;'>\u0627\u0644\u0645\u062d\u0630\u0648\u0641\u0629 (&#8722;)</span> \u0627\u0633\u062a\u0646\u0627\u062f\u064b\u0627 \u0625\u0644\u0649 \u0623\u0633\u0645\u0627\u0621 \u0645\u0648\u062d\u0651\u062f\u0629.   \u0627\u0633\u062a\u062e\u062f\u0645 \u0632\u0631 '\u0644\u0642\u0637\u0629' \u0644\u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062e\u0629 \u0645\u0646 \u0645\u0644\u0641 \u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0645\u062a\u062f\u0627\u062f .instantanea.</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "\u0627\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0643\u0646\u0635 Markdown \u0628\u062f\u0648\u0646 \u062a\u0642\u0631\u064a\u0631";
    }

    @Override
    public String titulo_configuracion() {
        return "\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a";
    }

    @Override
    public String columna_url() {
        return "\u0627\u0644\u0631\u0627\u0628\u0637";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "\u062d\u062f\u062b \u062e\u0637\u0623 \u063a\u064a\u0631 \u0645\u062a\u0648\u0642\u0639 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629.";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "\u062d\u062f\u062b \u062e\u0637\u0623 \u063a\u064a\u0631 \u0645\u062a\u0648\u0642\u0639 \u0623\u062b\u0646\u0627\u0621 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0631\u0648\u0627\u0628\u0637.";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "\u062d\u062f\u062b \u062e\u0637\u0623 \u063a\u064a\u0631 \u0645\u062a\u0648\u0642\u0639 \u0623\u062b\u0646\u0627\u0621 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0632\u0631.";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "\u0644\u0627 \u064a\u0648\u062c\u062f \u0645\u0644\u0641 \u0645\u0631\u062a\u0628\u0637 \u0644\u0644\u0641\u062a\u062d.";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "\u0627\u0644\u0645\u0644\u0641 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f:\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "\u062a\u0639\u0630\u0631 \u0641\u062a\u062d \u0627\u0644\u0645\u0644\u0641 \u0641\u064a \u0627\u0644\u0645\u062d\u0631\u0631.\n\u0633\u064a\u062a\u0645 \u0646\u0633\u062e \u0627\u0644\u0645\u0633\u0627\u0631 \u0625\u0644\u0649 \u0627\u0644\u062d\u0627\u0641\u0638\u0629.";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "\u062a\u0639\u0630\u0631 \u0641\u062a\u062d \u0627\u0644\u0645\u0644\u0641\u061b \u062a\u0645 \u0646\u0633\u062e \u0627\u0644\u0645\u0633\u0627\u0631 \u0625\u0644\u0649 \u0627\u0644\u062d\u0627\u0641\u0638\u0629.";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "\u0633\u0637\u062d \u0627\u0644\u0645\u0643\u062a\u0628 \u063a\u064a\u0631 \u0645\u062f\u0639\u0648\u0645\u061b \u062a\u0645 \u0646\u0633\u062e \u0627\u0644\u0645\u0633\u0627\u0631 \u0625\u0644\u0649 \u0627\u0644\u062d\u0627\u0641\u0638\u0629.";
    }

    @Override
    public String limite_de_solicitudes() {
        return "\u062a\u0648\u0627\u062c\u0647 \u062d\u062f\u064b\u0627 \u0639\u0644\u0649 \u0639\u062f\u062f \u0627\u0644\u0637\u0644\u0628\u0627\u062a. \u062d\u0627\u0648\u0644 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0648\u0642\u0639 \u062a\u0633\u062c\u064a\u0644 \u0622\u062e\u0631 \u0623\u0648 \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u062a\u0637\u0628\u064a\u0642\u0627\u062a (API) \u0623\u062e\u0631\u0649 \u0644\u0644\u062a\u0633\u062c\u064a\u0644.";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "\u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u0631\u0627\u0628\u0637";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0625\u0635\u0644\u0627\u062d \u0623\u062c\u0632\u0627\u0621 \u0642\u0645\u0645 \u0627\u0644\u062c\u0630\u0648\u0639 \u0647\u064a \u0627\u0644\u0623\u0648\u0644\u0648\u064a\u0629 \u0627\u0644\u0642\u0635\u0648\u0649. \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u0647\u0648 \u0627\u0644\u0645\u0633\u062a\u0648\u0649\u060c \u0627\u0644\u0633\u0637\u0631. \u062c\u0645\u064a\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0644\u0647\u0627 \u0646\u0638\u0627\u0645 \u062a\u0631\u0642\u064a\u0645. " + "<br>" + "\u0628\u0634\u0643\u0644 \u0639\u0627\u0645\u060c \u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u0627\u0644\u0628\u062d\u062b \u0641\u064a \u0627\u0644\u0645\u0633\u062a\u0648\u064a\u0627\u062a \u0627\u0644\u0623\u062f\u0646\u0649 \u0641\u064a \u062c\u0645\u064a\u0639 \u0627\u0644\u0633\u062c\u0644\u0627\u062a\u061b \u0641\u0627\u0644\u0645\u0633\u0627\u0631\u0627\u062a \u0630\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0648\u064a\u0627\u062a \u0627\u0644\u0639\u0627\u0644\u064a\u0629 \u062a\u0643\u0648\u0646 \u063a\u0627\u0644\u0628\u064b\u0627 \u0625\u064a\u062c\u0627\u0628\u064a\u0627\u062a \u0632\u0627\u0626\u0641\u0629. \u0645\u0646 \u0627\u0644\u0645\u0647\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0647\u0627\u0631\u062a\u0643 \u0641\u064a \u0641\u0647\u0645 \u0648\u062d\u062f\u0629 \u0627\u0644\u062a\u062d\u0643\u0645\u060c \u0644\u0623\u0646 \u062a\u062d\u0644\u064a\u0644 \u0627\u0644\u0645\u0633\u0627\u0631\u0627\u062a \u0644\u064a\u0633 \u062f\u0642\u064a\u0642\u064b\u0627 \u062a\u0645\u0627\u0645\u064b\u0627 \u0639\u0646\u062f \u0648\u062c\u0648\u062f \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0633\u0627\u0631\u0627\u062a.</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "\u0645\u064f\u0628\u062d\u0650\u062b \u0643\u0627\u0646\u0627\u0631\u064a \u0644\u0644\u0637\u0644\u0628";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "\u0633\u062a\u0635\u0628\u062d \u0647\u0630\u0647 \u0627\u0644\u0645\u064a\u0632\u0629 \u0645\u062a\u0627\u062d\u0629 \u0642\u0631\u064a\u0628\u064b\u0627.";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "\u0642\u0631\u064a\u0628\u064b\u0627";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "\u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 Crash Assistant (\u062e\u0637\u0623)";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "\u062d\u0632\u0645\u0629 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 CrashAssistant";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0648\u064a Crash Assistant \u0639\u0644\u0649 \u0642\u0627\u0626\u0645\u0629 \u0628\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u064a\u0642\u0648\u0644 \u0625\u0646\u0647\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629\u060c \u0644\u0643\u0646 \u0644\u064a\u0633 \u0644\u062f\u064a\u0646\u0627 \u0623\u062f\u0644\u0629 \u0639\u0644\u0649 \u0630\u0644\u0643\u060c \u0648\u0627\u0644\u062e\u0637\u0623 \u0628\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0641\u0642\u0637. \u0625\u0630\u0627 \u0623\u0631\u062f\u062a \u0627\u0644\u0644\u0639\u0628 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0644\u0641 <code>config/crash_assistant/config.toml</code> \u0648\u062a\u063a\u064a\u064a\u0631 <code>enabled = true</code> \u0641\u064a \u0627\u0644\u0642\u0633\u0645 [compatibility] \u0625\u0644\u0649 <code>enabled = false</code>.</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u0645\u0643\u0646 \u0644\u0640 Crash Assistant \u0623\u0646 \u064a\u064f\u0635\u0646\u0651\u0641 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0639\u0644\u0649 \u0623\u0646\u0647\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629\u060c \u0644\u0643\u0646 \u0641\u064a \u0628\u0639\u0636 \u0627\u0644\u0623\u062d\u064a\u0627\u0646 \u064a\u0643\u0648\u0646 \u0647\u0630\u0627 \u0627\u0644\u062a\u0635\u0646\u064a\u0641 \u062e\u0627\u0637\u0626\u064b\u0627\u060c \u0648\u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0628\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0641\u0642\u0637. \u0625\u0630\u0627 \u0623\u0631\u062f\u062a \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0644\u0641 <code>config/crash_assistant/problematic_mods_config.json</code> \u0648\u062a\u063a\u064a\u064a\u0631 \u0642\u064a\u0645\u0629 <code>should_crash_on_startup</code> \u0645\u0646 <code>true</code> \u0625\u0644\u0649 <code>false</code>.</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623: \u0627\u0644\u062a\u0639\u062f\u064a\u0644 '" + modId + "' \u064a\u062a\u0637\u0644\u0628 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 '" + dependencia + "'. \u062d\u0627\u0644\u064a\u064b\u0627\u060c " + actual + ".</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623: \u0627\u0644\u062a\u0639\u062f\u064a\u0644 '" + modId + "' \u064a\u062a\u0637\u0644\u0628 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 '" + requerido + "' \u0623\u0648 \u0623\u062d\u062f\u062b \u0645\u0646 '" + dependencia + "'\u060c \u0644\u0643\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u063a\u064a\u0631 \u0645\u062b\u0628\u062a.</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623: \u0627\u0644\u062a\u0639\u062f\u064a\u0644 '" + modId + "' \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062d\u0627\u0644\u064a \u0645\u0646 '" + dependencia + "'. \u064a\u062c\u0628 \u0639\u0644\u064a\u0643 \u062d\u0630\u0641 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 'Iris/Oculus & GeckoLib Compat' \u0644\u0623\u0646\u0647 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 Superb Warfare \u0648\u0644\u0627 \u064a\u0639\u0645\u0644 \u0645\u0639 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 GeckoLib. \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u062d\u0627\u0644\u064a: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "\u062e\u0637\u0623: \u062a\u0639\u0630\u0631 \u062a\u0646\u0641\u064a\u0630 \u0627\u0644\u0645\u0647\u0645\u0629 \u0644\u0644\u0635\u0646\u0641 '" + clase + "'. \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0634\u0627\u0626\u0639 \u0645\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u062a\u064a \u0644\u0627 \u062a\u0643\u0648\u0646 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0641\u064a\u0645\u0627 \u0628\u064a\u0646\u0647\u0627 \u0623\u0648 \u0627\u0644\u062a\u064a \u0644\u062f\u064a\u0647\u0627 \u062a\u0639\u0627\u0631\u0636\u0627\u062a \u0645\u0639 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0623\u062e\u0631\u0649 \u0645\u062b\u0628\u062a\u0629.";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "\u0641\u0634\u0644 \u062a\u0646\u0641\u064a\u0630 \u0627\u0644\u0645\u0647\u0627\u0645";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u0646\u0648\u0639 \u0645\u0646 \u0627\u0644\u0623\u062e\u0637\u0627\u0621 \u0639\u0627\u062f\u0629\u064b \u0628\u0633\u0628\u0628 \u0627\u0644\u062a\u0639\u0627\u0631\u0636\u0627\u062a \u0628\u064a\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a. \u0648\u0647\u0648 \u0634\u0627\u0626\u0639 \u0628\u0634\u0643\u0644 \u062e\u0627\u0635 \u0645\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u062a\u064a \u0644\u0627 \u062a\u0639\u0645\u0644 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d \u0645\u0639 ConnectorMod.";
    }

    @Override
    public String info_clase_problematica() {
        return "\u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629:";
    }

    public String ver_en_log() {
        return "\u0639\u0631\u0636 \u0641\u064a \u0627\u0644\u0633\u062c\u0644";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0623\u0635\u0646\u0627\u0641 \u0645\u062d\u062f\u062f\u0629 \u062a\u0639\u0627\u0646\u064a \u0645\u0646 \u0645\u0634\u0627\u0643\u0644 \u0641\u064a \u0627\u0644\u062a\u0646\u0641\u064a\u0630.";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 OptiFine \u0648Entity Model Features (EMF). \u0647\u0630\u0627\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u0646 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0648\u064a\u0624\u062f\u064a\u0627\u0646 \u0625\u0644\u0649 \u0641\u0634\u0644 \u0641\u064a \u0627\u0644\u0625\u062f\u062e\u0627\u0644 \u064a\u0645\u0646\u0639 \u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 OptiFine \u0648Entity Model Features";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "\u0623\u0632\u0644 \u0625\u0645\u0627 OptiFine \u0623\u0648 Entity Model Features\u060c \u0644\u0623\u0646\u0647\u0645\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0645\u0639 \u0628\u0639\u0636\u0647\u0645\u0627 \u0627\u0644\u0628\u0639\u0636.";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 OptiFine \u0648Fusion. \u0647\u0630\u0627\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u0646 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0648\u064a\u0624\u062f\u064a\u0627\u0646 \u0625\u0644\u0649 \u0641\u0634\u0644 \u0641\u064a \u0627\u0644\u0625\u062f\u062e\u0627\u0644 \u064a\u0645\u0646\u0639 \u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 OptiFine \u0648Fusion";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "\u0623\u0632\u0644 \u0625\u0645\u0627 OptiFine \u0623\u0648 Fusion\u060c \u0644\u0623\u0646\u0647\u0645\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0645\u0639 \u0628\u0639\u0636\u0647\u0645\u0627 \u0627\u0644\u0628\u0639\u0636.";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0627\u062c Flywheel (\u0645\u0637\u0644\u0648\u0628 \u0645\u0646 \u0642\u0628\u0644 Create) \u0625\u0644\u0649 Sodium 0.6.0-beta.2 \u0623\u0648 \u0623\u062d\u062f\u062b. \u0625\u0635\u062f\u0627\u0631 Rubidium \u0647\u0648 0.5.3. \u0641\u0643\u0631 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u0643\u0628\u062f\u064a\u0644.</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "\u062a\u0639\u0627\u0631\u0636 Flywheel \u0648\u0625\u0635\u062f\u0627\u0631 Sodium";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "\u062d\u062f\u0651\u062b Sodium \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631 0.6.0-beta.2 \u0623\u0648 \u0623\u062d\u062f\u062b\u060c \u0623\u0648 \u0642\u0645 \u0628\u062a\u062b\u0628\u064a\u062a <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u0643\u0628\u062f\u064a\u0644 \u0645\u062a\u0648\u0627\u0641\u0642.";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 OptiFine \u0648Epic Fight. \u0647\u0630\u0627\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u0646 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0648\u064a\u0624\u062f\u064a\u0627\u0646 \u0625\u0644\u0649 \u0641\u0634\u0644 \u0641\u064a \u0627\u0644\u0625\u062f\u062e\u0627\u0644 \u064a\u0645\u0646\u0639 \u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 OptiFine \u0648Epic Fight";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "\u0623\u0632\u0644 \u0625\u0645\u0627 OptiFine \u0623\u0648 Epic Fight\u060c \u0644\u0623\u0646\u0647\u0645\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0645\u0639 \u0628\u0639\u0636\u0647\u0645\u0627 \u0627\u0644\u0628\u0639\u0636.";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 OptiFine \u0648 Rubidium. \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0648\u062a\u0633\u0628\u0628 \u0641\u0634\u0644\u0627\u064b \u0641\u064a \u0627\u0644\u062d\u0642\u0646 \u064a\u0645\u0646\u0639 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "\u0627\u0644\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 OptiFine \u0648 Rubidium";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 OptiFine \u0623\u0648 Rubidium\u060c \u0644\u0623\u0646\u0647\u0645\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0645\u0639 \u0628\u0639\u0636\u0647\u0645\u0627.";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u0627\u0648\u0644 FreeCam \u0627\u0644\u062a\u062d\u0645\u064a\u0644 \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635\u060c \u0644\u0643\u0646\u0647 \u0645\u062a\u0648\u0627\u0641\u0642 \u0641\u0642\u0637 \u0645\u0639 \u0627\u0644\u0639\u0645\u064a\u0644. \u0623\u0632\u0644 FreeCam \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0623\u0648 \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0647 \u0645\u062b\u0628\u062a \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "FreeCam \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "\u0623\u0632\u0644 FreeCam \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0627\u0644\u0645\u062e\u0635\u0635\u060c \u0644\u0623\u0646\u0647 \u064a\u062c\u0628 \u062a\u062b\u0628\u064a\u062a\u0647 \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) \u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u062a\u062d\u0645\u064a\u0644 \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635\u060c \u0644\u0643\u0646\u0647 \u0645\u062a\u0648\u0627\u0641\u0642 \u0641\u0642\u0637 \u0645\u0639 \u0627\u0644\u0639\u0645\u064a\u0644. \u0623\u0632\u0644 ETF \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0623\u0648 \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0647 \u0645\u062b\u0628\u062a \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "\u0623\u0632\u0644 Entity Texture Features \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0627\u0644\u0645\u062e\u0635\u0635\u060c \u0644\u0623\u0646\u0647 \u064a\u062c\u0628 \u062a\u062b\u0628\u064a\u062a\u0647 \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062c\u0628 \u0642\u0628\u0648\u0644 EULA \u0627\u0644\u062e\u0627\u0635 \u0628\u0640 Minecraft \u0644\u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u062e\u0627\u062f\u0645. \u0642\u0645 \u0628\u062a\u062d\u0631\u064a\u0631 \u0645\u0644\u0641 eula.txt \u0648\u063a\u064a\u0651\u0631 'eula=false' \u0625\u0644\u0649 'eula=true'.</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "EULA \u0627\u0644\u062e\u0627\u0635 \u0628\u0640 Minecraft \u063a\u064a\u0631 \u0645\u0642\u0628\u0648\u0644";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "\u0642\u0645 \u0628\u062a\u062d\u0631\u064a\u0631 \u0645\u0644\u0641 eula.txt \u0641\u064a \u0645\u062c\u0644\u062f \u0627\u0644\u062e\u0627\u062f\u0645 \u0648\u063a\u064a\u0651\u0631 'eula=false' \u0625\u0644\u0649 'eula=true'.";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u062a\u062d\u0645\u064a\u0644 \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635\u060c \u0644\u0643\u0646\u0647 \u0645\u062a\u0648\u0627\u0641\u0642 \u0641\u0642\u0637 \u0645\u0639 \u0627\u0644\u0639\u0645\u064a\u0644. \u0623\u0632\u0644 OptiFine \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0623\u0648 \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0647 \u0645\u062b\u0628\u062a \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "OptiFine \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "\u0623\u0632\u0644 OptiFine \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0627\u0644\u0645\u062e\u0635\u0635\u060c \u0644\u0623\u0646\u0647 \u064a\u062c\u0628 \u062a\u062b\u0628\u064a\u062a\u0647 \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u062a\u0645\u064a\u064a\u0632 Iron's Spellbooks \u0628\u0634\u0643\u0644 \u062e\u0627\u0637\u0626 \u0639\u0644\u0649 \u0623\u0646\u0647 \u0645\u062e\u0635\u0635 \u0644\u0640 1.20.1 \u0644\u0643\u0646\u0647 \u064a\u0633\u062a\u062e\u062f\u0645 \u0637\u0631\u0642 1.21.1. \u0627\u0644\u0645\u0648\u062f \u064a\u062d\u0627\u0648\u0644 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 ResourceLocation.fromNamespaceAndPath\u060c \u0648\u0647\u0648 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a 1.20.1.</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0625\u0635\u062f\u0627\u0631 Iron's Spellbooks";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "\u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0643 \u0644\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0635\u062d\u064a\u062d \u0645\u0646 Iron's Spellbooks \u0627\u0644\u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 OptiFine \u0648 Embeddium. \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0648\u062a\u0633\u0628\u0628 \u0641\u0634\u0644\u0627\u064b \u0641\u064a \u0627\u0644\u062d\u0642\u0646 \u064a\u0645\u0646\u0639 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "\u0627\u0644\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 OptiFine \u0648 Embeddium";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 OptiFine \u0623\u0648 Embeddium\u060c \u0644\u0623\u0646\u0647\u0645\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0645\u0639 \u0628\u0639\u0636\u0647\u0645\u0627.";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0647\u0630\u0627 \u0634\u0627\u0626\u0639 \u0645\u0639 \u0648\u062d\u062f\u0627\u062a \u062a\u0639\u062f\u064a\u0644 \u062a\u0648\u0644\u064a\u062f \u0627\u0644\u0639\u0627\u0644\u0645 \u0627\u0644\u0645\u062a\u0639\u0627\u0631\u0636\u0629\u060c \u062e\u0627\u0635\u0629\u064b Terralinth \u0648AmplifiedNether \u0648Nullscape \u0648Incendium \u0648\u063a\u064a\u0631\u0647\u0627 \u0645\u0646 \u0648\u062d\u062f\u0627\u062a \u062a\u0639\u062f\u064a\u0644 \u062a\u0648\u0644\u064a\u062f \u0627\u0644\u0639\u0627\u0644\u0645. \u0642\u062f \u062a\u062d\u062a\u0627\u062c \u0623\u064a\u0636\u064b\u0627 \u0625\u0644\u0649 \u062a\u062b\u0628\u064a\u062a \u0648\u062d\u062f\u0629 \u062a\u0639\u062f\u064a\u0644 \u0645\u0641\u0642\u0648\u062f\u0629.</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable \u064a\u062d\u0627\u0648\u0644 \u0627\u0644\u062a\u062d\u0645\u064a\u0644 \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635\u060c \u0644\u0643\u0646\u0647 \u0645\u062a\u0648\u0627\u0641\u0642 \u0641\u0642\u0637 \u0645\u0639 \u0627\u0644\u0639\u0645\u064a\u0644. \u0623\u0632\u0644 Controllable \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0623\u0648 \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0647 \u0645\u062b\u0628\u062a \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "Controllable \u0639\u0644\u0649 \u062e\u0627\u062f\u0645 \u0645\u062e\u0635\u0635";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "\u0623\u0632\u0644 Controllable \u0645\u0646 \u0627\u0644\u062e\u0627\u062f\u0645 \u0627\u0644\u0645\u062e\u0635\u0635\u060c \u0644\u0623\u0646\u0647 \u064a\u062c\u0628 \u062a\u062b\u0628\u064a\u062a\u0647 \u0641\u0642\u0637 \u0639\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644.";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a causing Supplementaries \u062e\u0637\u0623\u064b \u064a\u0645\u0646\u0639 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u062e\u0627\u062f\u0645. \u064a\u0648\u0627\u062c\u0647 \u0627\u0644\u0645\u0648\u062f \u0645\u0634\u0627\u0643\u0644 \u0641\u064a \u062a\u0633\u062c\u064a\u0644 \u0633\u0644\u0648\u0643\u064a\u0627\u062a \u0627\u0644\u0646\u0627\u0631 \u062a\u0624\u062f\u064a \u0625\u0644\u0649 \u0641\u0634\u0644 \u0623\u062b\u0646\u0627\u0621 \u062a\u062d\u0645\u064a\u0644 \u062d\u0632\u0645 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a (datapacks).</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries \u064a\u0645\u0646\u0639 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u062e\u0627\u062f\u0645";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "\u062d\u0627\u0648\u0644 \u062a\u062d\u062f\u064a\u062b Supplementaries \u0625\u0644\u0649 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631 \u0623\u0648 \u0642\u0645 \u0628\u062a\u0639\u0637\u064a\u0644\u0647 \u0645\u0624\u0642\u062a\u064b\u0627 \u0644\u0644\u0633\u0645\u0627\u062d \u0628\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u062e\u0627\u062f\u0645.";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0648\u0627\u062c\u0647 Groovy Modloader (GML) \u0645\u0634\u0643\u0644\u0629 \u0628\u0633\u0628\u0628 \u0648\u062d\u062f\u0627\u062a Jackson \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629. \u0642\u062f \u064a\u0633\u0628\u0628 \u0628\u0639\u0636 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0645\u062b\u0644 Valkyrien Skies \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0644\u0639\u062f\u0645 \u062a\u0636\u0645\u064a\u0646 \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a \u0627\u0644\u0645\u0637\u0644\u0648\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "\u0648\u062d\u062f\u0629 Jackson \u0645\u0641\u0642\u0648\u062f\u0629 \u0641\u064a Groovy Modloader";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 Groovy Modloader \u0648\u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u0645\u0631\u062a\u0628\u0637\u0629 \u0645\u062b\u0644 Valkyrien Skies \u0627\u0644\u062a\u064a \u0642\u062f \u062a\u0633\u0628\u0628 \u062a\u0639\u0627\u0631\u0636\u0627\u062a \u0641\u064a \u0627\u0644\u062a\u0628\u0639\u064a\u0627\u062a.";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat \u0648\u062c\u062f \u0627\u0633\u0645 \u0643\u062a\u0644\u0629 \u062e\u0634\u0628 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d. \u0639\u0627\u062f\u0629\u064b \u0645\u0627 \u064a\u0639\u0627\u0646\u064a Every Compat \u0645\u0646 \u0645\u0634\u0627\u0643\u0644 \u0643\u062b\u064a\u0631\u0629. \u0644\u0627 \u062a\u0633\u062a\u062e\u062f\u0645\u0647!</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "\u0627\u0633\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d \u0641\u064a Every Compat";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "\u062a\u062d\u0642\u0642 \u0645\u0646 \u062d\u0632\u0645 \u0627\u0644\u0645\u0648\u0627\u0631\u062f \u0623\u0648 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0633\u062a\u062e\u062f\u0645 Every Compat\u060c \u0641\u0642\u062f \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0633\u0645\u0627\u0621 \u0643\u062a\u0644 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0631\u0645\u0632 \u062e\u0637\u0623 (-1073741819) \u0642\u062f \u064a\u0643\u0648\u0646 \u0646\u0627\u062a\u062c\u064b\u0627 \u0639\u0646 \u0637\u0628\u0642\u0627\u062a \u0627\u0644\u0639\u0631\u0636 (overlays) \u0645\u062b\u0644 GameCaster \u0645\u0646 Razer \u0623\u0648 Discord \u0623\u0648 OBS Studio \u0623\u0648 \u0645\u0634\u0627\u0643\u0644 \u0641\u064a \u062a\u0639\u0631\u064a\u0641\u0627\u062a NVIDIA.</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "\u0631\u0645\u0632 \u0627\u0644\u062e\u0637\u0623 -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "\u062d\u0627\u0648\u0644 \u062a\u0639\u0637\u064a\u0644 \u0637\u0628\u0642\u0627\u062a \u0627\u0644\u0639\u0631\u0636 \u0645\u062b\u0644 GameCaster \u0623\u0648 Discord \u0623\u0648 OBS Studio\u060c \u0648\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u062a\u0639\u0631\u064a\u0641\u0627\u062a NVIDIA \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u0645\u062d\u062f\u062b\u0629.";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips \u064a\u062a\u0637\u0644\u0628 Immersive Messages \u0643(dependencia) \u0644\u0643\u0646\u0647 \u063a\u064a\u0631 \u0645\u062b\u0628\u062a. \u0642\u0645 \u0628\u062a\u062b\u0628\u064a\u062a Immersive Messages \u0644\u0643\u064a \u064a\u0639\u0645\u0644 Immersive Tooltips \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips \u0628\u062f\u0648\u0646 dependencia";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "\u0642\u0645 \u0628\u062a\u062b\u0628\u064a\u062a Immersive Messages\u060c \u0644\u0623\u0646\u0647 dependencia \u0636\u0631\u0648\u0631\u064a\u0629 \u0644\u0640 Immersive Tooltips.";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins tiene un problema de compatibilidad con Apoli Mod donde ItemStack no puede ser casteado a EntityLinkedItemStack. Esto es com\u00fan en versiones superiores a 6.6.0. Considera usar una versi\u00f3n anterior o cambiar entre versiones de Fabric y Forge.</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "Error de casteo en Medieval Origins";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "Usa una versi\u00f3n de Medieval Origins 6.6.0 o anterior, o intenta cambiar entre versiones de Fabric y Forge del mod.";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u0633\u0628\u0628 Reign of Nether \u062e\u0637\u0623\u064b \u0645\u0639 Registry Object \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a MusicManager. \u064a\u0631\u062a\u0628\u0637 \u0647\u0630\u0627 \u0627\u0644\u0645\u0634\u0643\u0644 \u0628\u0645ixin \u0627\u0644\u062e\u0627\u0635 \u0628\u0640 MusicManager \u0645\u0646 Reign of Nether.</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "\u062e\u0637\u0623 MusicManager \u0641\u064a Reign of Nether";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "\u062d\u0627\u0648\u0644 \u062a\u062d\u062f\u064a\u062b Reign of Nether \u0623\u0648 \u0625\u0632\u0627\u0644\u062a\u0647 \u0645\u0624\u0642\u062a\u064b\u0627 \u0644\u062d\u0644 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623.";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062f\u0639\u0645 YesSteveModel \u062e\u0627\u062f\u0645 YSM \u0641\u0642\u0637 \u0639\u0644\u0649 Linux \u0623\u0648 Android. \u062a\u0645 \u0625\u0635\u0644\u0627\u062d \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0623\u062d\u062f\u062b \u0645\u0646\u0630 23 \u0646\u0648\u0641\u0645\u0628\u0631 2025 \u0639\u0644\u0649 Modrinth.</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 Linux";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "\u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b YesSteveModel \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631 \u0623\u062d\u062f\u062b \u0645\u0646 Modrinth\u060c \u062d\u064a\u062b \u062a\u0645 \u0625\u0635\u0644\u0627\u062d \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0628\u0639\u062f 23 \u0646\u0648\u0641\u0645\u0628\u0631.";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 Moving Elevators \u0648 OptiFine. \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0648\u062a\u0633\u0628\u0628 \u0641\u0634\u0644\u0627\u064b \u0641\u064a \u0627\u0644\u062d\u0642\u0646 \u064a\u0645\u0646\u0639 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "\u0627\u0644\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 Moving Elevators \u0648 OptiFine";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 OptiFine \u0623\u0648 Moving Elevators\u060c \u0644\u0623\u0646\u0647\u0645\u0627 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u064a\u0646 \u0645\u0639 \u0628\u0639\u0636\u0647\u0645\u0627.";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u062d\u0631\u062c \u0628\u064a\u0646 Fabric API (fabric-resource-loader-v0) \u0648 OptiFine. \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0648\u062a\u0633\u0628\u0628 \u0641\u0634\u0644\u0627\u064b \u0641\u064a \u0627\u0644\u062d\u0642\u0646 \u064a\u0645\u0646\u0639 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "\u0627\u0644\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 Fabric API \u0648 OptiFine";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 OptiFine \u0623\u0648 \u062d\u062f\u0651\u062b Fabric API \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642.";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0648\u064a \u0623\u062d\u062f \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0639\u0644\u0649 ITransformationService \u0645\u0639\u0637\u0648\u0628 \u0644\u0627 \u064a\u0645\u0643\u0646 \u0625\u0646\u0634\u0627\u0624\u0647: " + claseProveedor + ". \u064a\u062c\u0628 \u0625\u0632\u0627\u0644\u0629 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u062f \u0644\u062a\u0645\u0643\u064a\u0646 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "ITransformationService \u0645\u0639\u0637\u0648\u0628";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "\u0623\u0632\u0644 \u0627\u0644\u0645\u0648\u062f \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0635\u0646\u0641 " + claseProveedor + "\u060c \u0644\u0623\u0646\u0647 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 ITransformationService \u0645\u0639\u0637\u0648\u0628.";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062d\u062a\u0648\u064a \u0623\u062d\u062f \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0639\u0644\u0649 \u0645\u0648\u0627\u0635\u0641\u0627\u062a \u0625\u0635\u062f\u0627\u0631 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629. \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0645\u062d\u0627\u0637\u064b\u0627 \u0628\u0623\u0642\u0648\u0627\u0633 \u0645\u0631\u0628\u0639\u0629. \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 grep/greprf \u0645\u0646 \u0627\u0644\u0644\u0648\u062d\u0629 \u0627\u0644\u062c\u0627\u0646\u0628\u064a\u0629 \u0628\u0627\u0644\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'> \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0648\u062d\u062f\u0629 \u0627\u0644\u062a\u064a \u0628\u0647\u0627 \u0627\u0644\u0645\u0634\u0643\u0644\u0629.</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "\u0625\u0635\u062f\u0627\u0631 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d \u0641\u064a \u0627\u0644\u0648\u062d\u062f\u0629";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "\u0627\u0633\u062a\u062e\u062f\u0645 \u0623\u062f\u0627\u0629 grep/greprf \u0645\u0646 \u0627\u0644\u0644\u0648\u062d\u0629 \u0627\u0644\u062c\u0627\u0646\u0628\u064a\u0629 \u0644\u0644\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0645\u0634\u0643\u0644 \u0648\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0648\u062d\u062f\u0629 \u0627\u0644\u062a\u064a \u062a\u062d\u062a\u0648\u064a\u0647.";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 stack smashing \u0623\u062f\u0649 \u0625\u0644\u0649 \u0625\u0646\u0647\u0627\u0621 \u0627\u0644\u0639\u0645\u0644\u064a\u0629. \u0642\u062f \u064a\u0643\u0648\u0646 \u0647\u0630\u0627 \u0646\u0627\u062a\u062c\u064b\u0627 \u0639\u0646 \u0645\u0634\u0627\u0643\u0644 \u0641\u064a Early Window \u0641\u064a Forge/NeoForge/PillowMC \u0623\u0648 \u0645\u0639 LWJGL 3.2.2 \u0648\u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u0623\u062d\u062f\u062b.</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 Stack Smashing";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "\u062a\u062d\u0642\u0642 \u0645\u0646 \u0625\u0639\u062f\u0627\u062f\u0627\u062a Early Window \u0648\u0641\u0643\u0651\u0631 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 \u0645\u062e\u062a\u0644\u0641 \u0645\u0646 LWJGL \u0623\u0648 \u0645\u0631\u0627\u062c\u0639\u0629 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u0645\u0631\u062a\u0628\u0637\u0629 \u0628\u0627\u0644\u0646\u0648\u0627\u0641\u0630 \u0627\u0644\u0645\u0628\u0643\u0631\u0629.";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore \u0645\u062e\u0635\u0635 \u0644\u0640 modpack \u0645\u0639\u064a\u0646 \u0641\u0642\u0637 \u0648\u0644\u0627 \u064a\u062c\u0628 \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647 \u0641\u064a \u062a\u062b\u0628\u064a\u062a\u0627\u062a \u0639\u0627\u0645\u0629\u060c \u0644\u0623\u0646\u0647 \u064a\u0633\u0628\u0628 \u0645\u0634\u0643\u0644\u0629.</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore \u0628\u0625\u0635\u062f\u0627\u0631 Java \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "\u0642\u0645 \u0628\u0625\u0632\u0627\u0644\u0629 GregTechEasyCore\u060c \u0644\u0623\u0646\u0647 \u0645\u062e\u0635\u0635 \u0644\u0640 modpack \u0645\u0639\u064a\u0646 \u0641\u0642\u0637 \u0648\u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u062a\u062b\u0628\u064a\u062a\u0643 \u0627\u0644\u0639\u0627\u0645\u0629.";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 MoniLabs \u0648 Connector Extras \u0645\u062a\u0639\u0644\u0642 \u0628\u062a\u0639\u062f\u064a\u0644\u0627\u062a KubeJS. \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0641\u064a \u062a\u0639\u062f\u064a\u0644\u0627\u062a\u0647\u0627 \u0644\u0640 KubeJS.</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 MoniLabs \u0648 Connector Extras";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "\u062d\u0627\u0648\u0644 \u0625\u0632\u0627\u0644\u0629 \u0623\u062d\u062f \u0627\u0644\u0648\u062d\u062f\u0627\u062a (MoniLabs \u0623\u0648 Connector Extras) \u0644\u0623\u0646 \u0644\u062f\u064a\u0647\u0645\u0627 \u062a\u0639\u0627\u0631\u0636\u0627\u062a \u0641\u064a \u062a\u0639\u062f\u064a\u0644\u0627\u062a KubeJS.";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u064a\u062a\u0637\u0644\u0628 Iris \u0648\u062c\u0648\u062f Distant Horizons [2.0.4] \u0623\u0648 DH API \u0625\u0635\u062f\u0627\u0631 [1.1.0] \u0623\u0648 \u0623\u062d\u062f\u062b. \u0631\u0627\u062c\u0639 \u062f\u0644\u064a\u0644 \u0627\u0644\u062a\u0648\u0627\u0641\u0642 \u0639\u0644\u0649 https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e \u0644\u062d\u0644 \u0627\u0644\u0645\u0634\u0643\u0644\u0629.</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "\u062a\u0648\u0627\u0641\u0642 Iris \u0648 Distant Horizons";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "\u0631\u0627\u062c\u0639 \u062f\u0644\u064a\u0644 \u0627\u0644\u062a\u0648\u0627\u0641\u0642 \u0639\u0644\u0649 https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e \u0648\u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b Iris \u0648 Distant Horizons \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u062a\u0648\u0627\u0641\u0642\u0629.";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a (classes) \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 Minecraft. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0644\u062f\u064a\u0643 \u0648\u062d\u062f\u0627\u062a \u0644versions \u0623\u062e\u0631\u0649 \u0645\u0646 \u0627\u0644\u0644\u0639\u0628\u0629. \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a> \u0644\u0644\u062a\u062d\u0642\u0642 \u0645\u0645\u0627 \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0627\u0644\u0641\u0626\u0629 \u0645\u0648\u062c\u0648\u062f\u0629 \u0641\u064a \u0625\u0635\u062f\u0627\u0631\u0643.</li><li>\u0644\u062f\u064a\u0643 \u062a\u062b\u0628\u064a\u062a \u062a\u0627\u0644\u0641 \u0644\u0640 Minecraft (\u0634\u0627\u0626\u0639 \u0645\u0639 \u062a\u0637\u0628\u064a\u0642 CurseForge \u0648ModrinthApp/Theseus/Astralrinth \u0648\u063a\u064a\u0631\u0647\u0627 \u0645\u0646 \u0645\u0634\u063a\u0651\u0644\u0627\u062a modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0634\u0627\u0647\u062f \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u064a</a> \u0644\u062d\u0644 \u0645\u0634\u0627\u0643\u0644 CurseForge.</li><li>\u0644\u062f\u064a\u0643 coremod \u062a\u0627\u0644\u0641 (\u0625\u0630\u0627 \u0641\u0634\u0644 coremod\u060c \u0641\u0642\u062f \u064a\u0645\u0646\u0639 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0641\u0626\u0629).</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 DangerZone. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0644\u062f\u064a\u0643 \u0648\u062d\u062f\u0627\u062a \u0644versions \u0623\u062e\u0631\u0649 \u0645\u0646 \u0627\u0644\u0644\u0639\u0628\u0629.</li><li>\u0644\u062f\u064a\u0643 coremods \u062a\u0627\u0644\u0641\u0629.</li><li>\u0644\u062f\u064a\u0643 \u0645\u0634\u063a\u0651\u0644 \u0623\u0648 \u062a\u062b\u0628\u064a\u062a \u062a\u0627\u0644\u0641.</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 FeatureCreep. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0644\u062f\u064a\u0643 \u0648\u062d\u062f\u0627\u062a \u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0645\u062e\u062a\u0644\u0641\u0629 \u0645\u0646 FeatureCreep (\u0645\u062b\u0627\u0644: ESR \u0645\u0642\u0627\u0628\u0644 Nightly \u0623\u0648 v4 \u0645\u0642\u0627\u0628\u0644 v12).</li><li>\u064a\u0645\u0643\u0646\u0643 \u062a\u062b\u0628\u064a\u062a FeatureCreep \u0645\u0646 CurseForge \u0623\u0648 MinecraftStorage.</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 ModLauncher. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0648\u062d\u062f\u0627\u062a\u0643 \u0645\u062e\u0635\u0635\u0629 \u0644build \u0645\u062e\u062a\u0644\u0641 \u0645\u0646 MinecraftForge \u0623\u0648 PillowMC \u0623\u0648 NeoForge (\u064a\u064f\u0633\u062a\u062e\u062f\u0645 ModLauncher \u0645\u0639 \u0647\u0630\u0647 \u0627\u0644\u0645\u062d\u0645\u0644\u0627\u062a).</li><li>\u0647\u0646\u0627\u0643 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0645\u062d\u0645\u0644\u0627\u062a \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0644\u0643\u0644 \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 Minecraft.</li><li>\u0644\u062f\u064a\u0643 \u062a\u062b\u0628\u064a\u062a \u062a\u0627\u0644\u0641 \u0644\u0644\u0645\u0634\u063a\u0644 (\u0634\u0627\u0626\u0639 \u0645\u0639 \u062a\u0637\u0628\u064a\u0642 CurseForge \u0648ModrinthApp/Theseus/Astralrinth \u0648\u063a\u064a\u0631\u0647\u0627). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0634\u0627\u0647\u062f \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u064a</a> \u0644\u062d\u0644 \u0645\u0634\u0627\u0643\u0644 CurseForge.</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 Minecraft Forge. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0648\u062d\u062f\u0627\u062a\u0643 \u0645\u062e\u0635\u0635\u0629 \u0644build \u0645\u062e\u062a\u0644\u0641 \u0645\u0646 MinecraftForge.</li><li>\u0647\u0646\u0627\u0643 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0645\u062d\u0645\u0644\u0627\u062a \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0644\u0643\u0644 \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 Minecraft.</li><li>\u0644\u062f\u064a\u0643 \u062a\u062b\u0628\u064a\u062a \u062a\u0627\u0644\u0641 (\u0634\u0627\u0626\u0639 \u0645\u0639 \u062a\u0637\u0628\u064a\u0642 CurseForge \u0648ModrinthApp/Theseus/Astralrinth \u0648\u063a\u064a\u0631\u0647\u0627). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0634\u0627\u0647\u062f \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u064a</a> \u0644\u062d\u0644 \u0645\u0634\u0627\u0643\u0644 CurseForge.</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 NeoForge. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0648\u062d\u062f\u0627\u062a\u0643 \u0645\u062e\u0635\u0635\u0629 \u0644build \u0645\u062e\u062a\u0644\u0641 \u0645\u0646 NeoForge.</li><li>\u0647\u0646\u0627\u0643 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0645\u062d\u0645\u0644\u0627\u062a \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0644\u0643\u0644 \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 Minecraft.</li><li>\u0644\u062f\u064a\u0643 \u062a\u062b\u0628\u064a\u062a \u062a\u0627\u0644\u0641 (\u0634\u0627\u0626\u0639 \u0645\u0639 \u062a\u0637\u0628\u064a\u0642 CurseForge \u0648ModrinthApp/Theseus/Astralrinth \u0648\u063a\u064a\u0631\u0647\u0627). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0634\u0627\u0647\u062f \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u064a</a> \u0644\u062d\u0644 \u0645\u0634\u0627\u0643\u0644 CurseForge.</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 Fabric Loader. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0648\u062d\u062f\u0627\u062a\u0643 \u0645\u062e\u0635\u0635\u0629 \u0644build \u0645\u062e\u062a\u0644\u0641 \u0645\u0646 Fabric Loader.</li><li>\u0647\u0646\u0627\u0643 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0645\u062d\u0645\u0644\u0627\u062a \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0644\u0643\u0644 \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 Minecraft.</li><li>\u0644\u062f\u064a\u0643 \u062a\u062b\u0628\u064a\u062a \u062a\u0627\u0644\u0641 (\u0634\u0627\u0626\u0639 \u0645\u0639 \u062a\u0637\u0628\u064a\u0642 CurseForge \u0648ModrinthApp/Theseus/Astralrinth \u0648\u063a\u064a\u0631\u0647\u0627). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0634\u0627\u0647\u062f \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u064a</a> \u0644\u062d\u0644 \u0645\u0634\u0627\u0643\u0644 CurseForge.</li><li>\u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u062a\u062a\u0637\u0644\u0628 Fabric API. \u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062b\u0628\u064a\u062a Fabric API \u0625\u0630\u0627 \u0644\u0632\u0645 \u0627\u0644\u0623\u0645\u0631.</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u062f\u064a\u0643 \u0641\u0626\u0627\u062a \u0645\u0641\u0642\u0648\u062f\u0629 \u0645\u0646 PillowMC. \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b><ul><li>\u0648\u062d\u062f\u0627\u062a\u0643 \u0645\u062e\u0635\u0635\u0629 \u0644build \u0645\u062e\u062a\u0644\u0641 \u0645\u0646 PillowMC.</li><li>\u0647\u0646\u0627\u0643 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0645\u062d\u0645\u0644\u0627\u062a \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0644\u0643\u0644 \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 Minecraft.</li><li>\u0644\u062f\u064a\u0643 \u062a\u062b\u0628\u064a\u062a \u062a\u0627\u0644\u0641 (\u0634\u0627\u0626\u0639 \u0645\u0639 \u062a\u0637\u0628\u064a\u0642 CurseForge \u0648ModrinthApp/Theseus/Astralrinth \u0648\u063a\u064a\u0631\u0647\u0627). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0634\u0627\u0647\u062f \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u064a</a> \u0644\u062d\u0644 \u0645\u0634\u0627\u0643\u0644 CurseForge.</li></ul><p>\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 <b>grepr/fgrepr</b> \u0641\u064a \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0637\u0627\u0644\u0645\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 '/' \u0641\u064a \u0627\u0644\u0623\u0633\u0645\u0627\u0621.</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0644\u062f\u064a\u0643 \u0648\u062d\u062f\u0629 \u062a\u062a\u0633\u0628\u0628 \u0639\u0645\u062f\u0627\u064b \u0641\u064a \u0627\u0644\u062a\u0628\u0627\u0637\u0624 (lag). Uranium \u0647\u0648 \u0648\u062d\u062f\u0629 \u062a\u0628\u0627\u0637\u0624. \u0642\u062f \u0644\u0627 \u062a\u0633\u0628\u0628 \u0623\u0639\u0637\u0627\u0644\u0627\u064b \u062f\u0627\u0626\u0645\u0627\u064b\u060c \u0644\u0643\u0646\u0647\u0627 \u0642\u062f \u062a\u0641\u0639\u0644 \u0630\u0644\u0643 \u0641\u064a \u0627\u0644\u0646\u0647\u0627\u064a\u0629.</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack est\u00e1 marcado como compatible con 1.19.* pero es para 1.20.*, lo que causa un error de clase no encontrada. El mod intenta usar DamageSources que no existen en la versi\u00f3n de Minecraft actual.</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "Error de versi\u00f3n en Falling Attack";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "Aseg\u00farate de usar la versi\u00f3n correcta de Falling Attack compatible con tu versi\u00f3n de Minecraft.";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("\u062a\u062d\u062a\u0627\u062c \u0625\u0644\u0649 \u062a\u062b\u0628\u064a\u062a CFR (Class File Reader) \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u0645\u064a\u0632\u0629.<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("\u0641\u064a \u0623\u0646\u0638\u0645\u0629 Linux \u0623\u0648 NetBSD \u0623\u0648 FreeBSD\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u062b\u0628\u064a\u062a CFR \u0645\u0646 \u0645\u062f\u064a\u0631 \u0627\u0644\u062d\u0632\u0645 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.<br>").append("\u0627\u0628\u062d\u062b \u0639\u0646 \u0627\u0644\u062d\u0632\u0645\u0629 \u0647\u0646\u0627: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("\u0628\u062f\u0644\u0627\u064b \u0645\u0646 \u0630\u0644\u0643\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u0646\u0632\u064a\u0644 \u0627\u0644\u0646\u0633\u062e\u0629 \u0627\u0644\u0645\u0639\u062f\u0651\u0644\u0629 \u0627\u0644\u062a\u064a \u064a\u0633\u062a\u062e\u062f\u0645\u0647\u0627 FabricMC \u0645\u0646:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("\u0627\u062d\u0641\u0638\u0647 \u0641\u064a \u0627\u0644\u0645\u062c\u0644\u062f \u0627\u0644\u062a\u0627\u0644\u064a:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>\u0645\u0647\u0645:</b> \u0628\u0639\u062f \u062a\u062b\u0628\u064a\u062a CFR\u060c \u064a\u062c\u0628 \u0625\u0639\u0627\u062f\u0629 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0640 mod \u0644\u064a\u062a\u0645 \u0627\u0644\u062a\u0639\u0631\u0641 \u0639\u0644\u064a\u0647 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "\u0644\u0627 \u064a\u0648\u062c\u062f \u0635\u0648\u0631\u0629 \u0645\u062a\u0627\u062d\u0629";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "\u062a\u0639\u0630\u0631 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0641\u0626\u0629: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "\u0645\u0641\u0643\u0643 CFR \u2013 Sakura Riddle (\u063a\u064a\u0631 \u0631\u0633\u0645\u064a)";
    }

    @Override
    public String cfrClaseActual() {
        return "\u0627\u0644\u0641\u0626\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "\u0635\u0648\u0631\u0629 Sakura Riddle";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "\u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0635\u0648\u0631\u0629";
    }

    @Override
    public String noticiaLegalCFR() {
        return "\u062a\u0645 \u062a\u0635\u0645\u064a\u0645 \u0628\u0631\u0646\u0627\u0645\u062c \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0629 \u0647\u0630\u0627 (GUI) \u0644\u062a\u062d\u0644\u064a\u0644 \u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0623\u0644\u0639\u0627\u0628 (mods) \u0628\u0647\u062f\u0641 \u0645\u0633\u0627\u0639\u062f\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0639\u0644\u0649 \u062a\u062d\u062f\u064a\u062f \u0623\u0633\u0628\u0627\u0628 \u0623\u0639\u0637\u0627\u0644 \u0627\u0644\u0628\u0631\u0645\u062c\u064a\u0627\u062a. \u0648\u0645\u0639 \u0630\u0644\u0643\u060c \u0642\u062f \u062a\u0643\u0648\u0646 \u0639\u0645\u0644\u064a\u0629 \u0627\u0644\u062a\u0641\u0643\u064a\u0643 (decompilation) \u0636\u0631\u0648\u0631\u064a\u0629\u060c \u0648\u064a\u062c\u0628 \u0639\u0644\u0649 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u062a\u0648\u062e\u064a \u0627\u0644\u062d\u0630\u0631 \u0628\u0639\u062f\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0643\u0648\u062f \u0627\u0644\u0646\u0627\u062a\u062c \u0644\u0627\u0646\u062a\u0647\u0627\u0643 \u0642\u0627\u0646\u0648\u0646 \u062d\u0642\u0648\u0642 \u0627\u0644\u0645\u0644\u0643\u064a\u0629 \u0627\u0644\u0641\u0643\u0631\u064a\u0629. \u064a\u0648\u0635\u0649 \u0628\u0645\u0631\u0627\u062c\u0639\u0629 \u062a\u0631\u062e\u064a\u0635 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0630\u064a \u0627\u0644\u0635\u0644\u0629 \u0642\u0628\u0644 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u064a \u0643\u0648\u062f \u062a\u0645 \u0627\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u064a\u0647. \u0639\u0644\u0627\u0648\u0629\u064b \u0639\u0644\u0649 \u0630\u0644\u0643\u060c \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u064a\u0648\u0641\u0651\u0631 \u0627\u0644\u0645\u0637\u0648\u0631\u0648\u0646 \u0645\u0635\u062f\u0631 \u0627\u0644\u0643\u0648\u062f \u0631\u0633\u0645\u064a\u064b\u0627\u060c \u0648\u0647\u0648 \u0639\u0627\u062f\u0629\u064b \u0623\u0643\u062b\u0631 \u0648\u0636\u0648\u062d\u064b\u0627 \u0648\u0633\u0647\u0648\u0644\u0629 \u0641\u064a \u0627\u0644\u0641\u0647\u0645 \u0645\u0642\u0627\u0631\u0646\u0629\u064b \u0628\u0627\u0644\u0643\u0648\u062f \u0627\u0644\u0645\u0641\u0643\u0651\u0643. \u062a\u0630\u0643\u0651\u0631 \u0623\u0646 \u0627\u062d\u062a\u0631\u0627\u0645 \u0627\u0644\u0645\u0644\u0643\u064a\u0629 \u0627\u0644\u0641\u0643\u0631\u064a\u0629 \u0648\u0634\u0631\u0648\u0637 \u0627\u0644\u062a\u0631\u062e\u064a\u0635 \u0623\u0645\u0631 \u062c\u0648\u0647\u0631\u064a \u0644\u0645\u062c\u062a\u0645\u0639 \u062a\u0637\u0648\u064a\u0631 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a. \u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0627\u0637\u0644\u0627\u0639 \u0639\u0644\u0649 \u0642\u0627\u0646\u0648\u0646 \u062d\u0642\u0648\u0642 \u0627\u0644\u0645\u0624\u0644\u0641 \u0627\u0644\u0645\u0643\u0633\u064a\u0643\u064a \u0639\u0628\u0631 \u0647\u0630\u0627 \u0627\u0644\u0631\u0627\u0628\u0637: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor (\u0628\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629)</a> \u0648\u0627\u0644\u0646\u0633\u062e\u0629 \u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0647\u0646\u0627: <a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (\u0628\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629)</a>. \u0648\u0628\u0645\u0627 \u0623\u0646\u0643 \u062a\u0633\u062a\u062e\u062f\u0645 CurseForge\u060c \u0641\u0642\u062f \u0623\u0636\u0641\u0646\u0627 \u0623\u064a\u0636\u064b\u0627 \u0631\u0627\u0628\u0637 \u0642\u0627\u0646\u0648\u0646 \u062d\u0642\u0648\u0642 \u0627\u0644\u0646\u0634\u0631 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a: <a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>. \u0646\u0648\u0635\u064a \u0643\u0630\u0644\u0643 \u0628\u0623\u0646 \u064a\u064f\u0637\u0644\u0650\u0639 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0648\u0646 \u0623\u0646\u0641\u0633\u0647\u0645 \u0639\u0644\u0649 \u0627\u0644\u0642\u0648\u0627\u0646\u064a\u0646 \u0627\u0644\u0633\u0627\u0631\u064a\u0629 \u0641\u064a \u0628\u0644\u062f \u0625\u0642\u0627\u0645\u062a\u0647\u0645. \u062a\u064f\u0639\u062f \u0648\u0627\u062c\u0647\u062a\u0646\u0627 \u0623\u062f\u0627\u0629 \u0644\u0641\u062d\u0648\u0635\u0627\u062a \u0628\u0633\u064a\u0637\u0629 \u0641\u0642\u0637\u061b \u0648\u0644\u062a\u062d\u0644\u064a\u0644 \u0645\u062a\u0642\u062f\u0645\u060c \u0646\u0646\u0635\u062d \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0646\u0633\u062e\u0629 FabricMC \u0627\u0644\u0645\u0639\u062f\u0651\u0644\u0629 \u0645\u0646 Enigma \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629 \u0639\u0644\u0649 <a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>. \u0625\u0630\u0627 \u0623\u0631\u062f\u062a \u062a\u0639\u062f\u064a\u0644 \u0645\u0644\u0641\u0627\u062a JAR \u0644\u0644\u062a\u0635\u062d\u064a\u062d \u062f\u0648\u0646 \u062a\u0648\u0641\u0631 \u0627\u0644\u0643\u0648\u062f \u0627\u0644\u0645\u0635\u062f\u0631\u064a\u060c \u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 Recaf \u0645\u0646 <a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">\u0645\u0648\u0642\u0639\u0647 \u0627\u0644\u0631\u0633\u0645\u064a</a>.";
    }

    @Override
    public String botonDescargarCfr() {
        return "\u062a\u0646\u0632\u064a\u0644 CFR";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "\u0641\u062a\u062d \u0645\u062c\u0644\u062f \u0627\u0644\u062a\u062b\u0628\u064a\u062a";
    }

    @Override
    public String colorFondoPrincipal() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062e\u0644\u0641\u064a\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a";
    }

    @Override
    public String colorTextoBotonReset() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0632\u0631 \u0625\u0639\u0627\u062f\u0629 \u0627\u0644\u062a\u0639\u064a\u064a\u0646";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u062d\u0642\u0644 \u0627\u0644\u0628\u062d\u062b";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u062a\u0635\u0641\u064a\u0629 \u0627\u0644\u0645\u0646\u0633\u062f\u0644\u0629";
    }

    @Override
    public String colorTextoRenderer() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0627\u0644\u0645\u064f\u0639\u064e\u062f\u0650\u0651\u0644 \u0627\u0644\u0628\u0635\u0631\u064a (\u0627\u0644\u0631\u0646\u062f\u0631\u0631)";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0637\u0628\u0642\u0629 \u0627\u0644\u062a\u062d\u0645\u064a\u0644 (overlay)";
    }

    @Override
    public String colorBorde() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062d\u062f\u0648\u062f";
    }

    @Override
    public String colorFondoRetrato() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062e\u0644\u0641\u064a\u0629 \u0641\u064a \u0648\u0636\u0639 \u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0634\u062e\u0635\u064a\u0629";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "\u0644\u0648\u0646 \u0631\u0627\u0628\u0637 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "\u0644\u0648\u0646 \u062e\u0644\u0641\u064a\u0629 \u062d\u0642\u0644 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629";
    }

    @Override
    public String rosaFondo() {
        return "\u0648\u0631\u062f\u064a \u0627\u0644\u062e\u0644\u0641\u064a\u0629";
    }

    @Override
    public String rosaSuave() {
        return "\u0648\u0631\u062f\u064a \u0646\u0627\u0639\u0645";
    }

    @Override
    public String moradoAcento() {
        return "\u0628\u0646\u0641\u0633\u062c\u064a \u0627\u0644\u062a\u0631\u0643\u064a\u0632";
    }

    @Override
    public String textoOscuro() {
        return "\u0646\u0635 \u062f\u0627\u0643\u0646";
    }

    @Override
    public String bordeSuave() {
        return "\u062d\u0627\u0641\u0629 \u0646\u0627\u0639\u0645\u0629";
    }

    @Override
    public String fondoCampo() {
        return "\u062e\u0644\u0641\u064a\u0629 \u0627\u0644\u062d\u0642\u0644";
    }

    @Override
    public String fondoVistaPrevia() {
        return "\u062e\u0644\u0641\u064a\u0629 \u0645\u0639\u0627\u064a\u0646\u0629";
    }

    @Override
    public String sintaxisConstructor() {
        return "\u0644\u0648\u0646 \u0628\u0646\u0627\u0621 \u0627\u0644\u062c\u0645\u0644\u0629: \u0627\u0644\u0628\u0627\u0646\u064a (constructor)";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "\u0644\u0648\u0646 \u0628\u0646\u0627\u0621 \u0627\u0644\u062c\u0645\u0644\u0629: \u0631\u0633\u0627\u0644\u0629 \u0627\u0644\u0645\u0633\u0627\u0639\u062f\u0629";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "\u0644\u0648\u0646 \u0628\u0646\u0627\u0621 \u0627\u0644\u062c\u0645\u0644\u0629: \u0648\u0633\u0648\u0645 HTML";
    }

    @Override
    public String colorFondoVentana() {
        return "\u0644\u0648\u0646 \u062e\u0644\u0641\u064a\u0629 \u0627\u0644\u0646\u0627\u0641\u0630\u0629";
    }

    @Override
    public String colorPanel() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0644\u0648\u062d\u0629";
    }

    @Override
    public String colorBotonTexto() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0627\u0644\u0632\u0631";
    }

    @Override
    public String colorCampo() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062d\u0642\u0644";
    }

    @Override
    public String colorBordeDestacado() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062d\u062f\u0648\u062f \u0627\u0644\u0645\u0645\u064a\u0632\u0629";
    }

    @Override
    public String colorSeleccionTexto() {
        return "\u0644\u0648\u0646 \u062e\u0644\u0641\u064a\u0629 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0646\u0635";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u0635 \u0627\u0644\u0645\u062d\u062f\u062f";
    }

    @Override
    public String colorEstadoExito() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062d\u0627\u0644\u0629: \u0646\u062c\u0627\u062d";
    }

    @Override
    public String colorEstadoFallo() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062d\u0627\u0644\u0629: \u0641\u0634\u0644";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062d\u0627\u0644\u0629: \u0641\u0648\u0631\u064a\u0629";
    }

    @Override
    public String colorResultadoAnadido() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u062a\u064a\u062c\u0629 \u0627\u0644\u0645\u0636\u0627\u0641\u0629";
    }

    @Override
    public String colorResultadoEliminado() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u062a\u064a\u062c\u0629 \u0627\u0644\u0645\u062d\u0630\u0648\u0641\u0629";
    }

    @Override
    public String colorBordeScroll() {
        return "\u0644\u0648\u0646 \u062d\u062f\u0648\u062f \u0634\u0631\u064a\u0637 \u0627\u0644\u062a\u0645\u0631\u064a\u0631";
    }

    @Override
    public String colorFondoPanel() {
        return "\u0644\u0648\u0646 \u062e\u0644\u0641\u064a\u0629 \u0627\u0644\u0644\u0648\u062d\u0629";
    }

    @Override
    public String colorBeigeListas() {
        return "\u0628\u064a\u062c \u0627\u0644\u0642\u0648\u0627\u0626\u0645";
    }

    @Override
    public String colorTextoListas() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0627\u0644\u0642\u0648\u0627\u0626\u0645";
    }

    @Override
    public String colorBordeListas() {
        return "\u0644\u0648\u0646 \u062d\u062f\u0648\u062f \u0627\u0644\u0642\u0648\u0627\u0626\u0645";
    }

    @Override
    public String colorBotonFondo() {
        return "\u0644\u0648\u0646 \u062e\u0644\u0641\u064a\u0629 \u0627\u0644\u0632\u0631";
    }

    @Override
    public String colorBordeBoton() {
        return "\u0644\u0648\u0646 \u062d\u062f\u0648\u062f \u0627\u0644\u0632\u0631";
    }

    @Override
    public String colorDoradoTexto() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u0635 \u0627\u0644\u0630\u0647\u0628\u064a";
    }

    @Override
    public String colorPila() {
        return "\u0644\u0648\u0646 \u062a\u062a\u0628\u064f\u0651\u0639 \u0627\u0644\u0645\u0643\u062f\u0633 (stack trace)";
    }

    @Override
    public String colorTextoPanel() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0627\u0644\u0644\u0648\u062d\u0629";
    }

    @Override
    public String colorTextoNegro() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u0635 \u0627\u0644\u0623\u0633\u0648\u062f";
    }

    @Override
    public String colorTextoPrincipal() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u0635 \u0627\u0644\u0631\u0626\u064a\u0633\u064a";
    }

    @Override
    public String colorFondoResultados() {
        return "\u0644\u0648\u0646 \u062e\u0644\u0641\u064a\u0629 \u0627\u0644\u0646\u062a\u0627\u0626\u062c";
    }

    @Override
    public String colorEstado() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062d\u0627\u0644\u0629";
    }

    @Override
    public String colorTextoDescripcion() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0627\u0644\u0648\u0635\u0641";
    }

    @Override
    public String colorTextoEstado() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0627\u0644\u062d\u0627\u0644\u0629";
    }

    @Override
    public String colorTextoExtra() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0646\u0635 \u0627\u0644\u0625\u0636\u0627\u0641\u064a";
    }

    @Override
    public String colorSeparador() {
        return "\u0644\u0648\u0646 \u0627\u0644\u0641\u0627\u0635\u0644";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0623\u0635\u0644\u064a <code>StubRoutines::SafeFetch32</code>. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u0645\u0634\u0643\u0644 \u0639\u0644\u0649 macOS \u0645\u0639 JDK 17.0.9 \u0648\u064a\u062a\u0645 \u0625\u0635\u0644\u0627\u062d\u0647 \u0641\u064a JDK 17.0.10 \u0623\u0648 \u0623\u062d\u062f\u062b. https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "\u062e\u0637\u0623 \u0623\u0635\u0644\u064a SafeFetch32 \u0641\u064a JDK 17.0.9 (macOS)";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "\u0642\u0645 \u0628\u062a\u062d\u062f\u064a\u062b JDK \u0625\u0644\u0649 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 17.0.10 \u0623\u0648 \u0623\u062d\u062f\u062b (\u0645\u062b\u0644 17.0.15).";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0645\u0634\u063a\u0651\u0644\u0627\u064b \u0645\u062b\u0644 MultiMC \u0623\u0648 Prism Launcher \u0623\u0648 TLauncher\u060c \u0641\u0627\u0636\u0628\u0637\u0647 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 \u0623\u062d\u062f\u062b \u0645\u0646 JDK. \u0628\u0639\u0636\u0647\u0627 \u064a\u062a\u0636\u0645\u0646 \u0628\u0627\u0644\u0641\u0639\u0644 JDK 17.0.15 \u0645\u062f\u0645\u062c\u064b\u0627.";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "\u0642\u062f \u064a\u0633\u0647\u0645 \u0627\u0644\u0645\u0648\u062f Spark \u0623\u064a\u0636\u064b\u0627 \u0641\u064a \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623. \u0641\u0643\u0651\u0631 \u0641\u064a \u062a\u0639\u0637\u064a\u0644\u0647 \u0645\u0624\u0642\u062a\u064b\u0627. https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0648\u062d\u062f\u0629 MCEF (Chromium Embedded Framework) \u062a\u0633\u0628\u0628 \u062a\u062c\u0645\u064a\u062f\u064b\u0627 \u0635\u0627\u0645\u062a\u064b\u0627.</b><ul><li>\u064a\u062a\u0645 \u062a\u0647\u064a\u0626\u0629 MCEF \u0641\u064a \u0646\u0647\u0627\u064a\u0629 \u0627\u0644\u0633\u062c\u0644 (log)\u060c \u0648\u0647\u0648 \u0645\u0627 \u064a\u0639\u0646\u064a \u0639\u0627\u062f\u0629\u064b \u0623\u0646 \u0627\u0644\u0644\u0639\u0628\u0629 \u062a\u062c\u0645\u062f\u062a \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u062d\u0645\u064a\u0644.</li><li>\u062a\u064f\u0639\u0631\u0641 \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0629 \u0628\u0623\u0646\u0647\u0627 \u062a\u0633\u0628\u0628 \u0623\u0639\u0637\u0627\u0644\u0627\u064b \u0641\u064a \u0623\u0646\u0638\u0645\u0629 Linux \u0623\u0648 macOS \u0623\u0648 \u0645\u0639 \u0628\u0639\u0636 \u0625\u0635\u062f\u0627\u0631\u0627\u062a Java.</li><li>\u0644\u0627 \u064a\u0638\u0647\u0631 \u062f\u0627\u0626\u0645\u064b\u0627 \u062e\u0637\u0623 \u0635\u0631\u064a\u062d\u060c \u0644\u0643\u0646 \u0627\u0644\u0644\u0639\u0628\u0629 \u0644\u0627 \u062a\u0635\u0644 \u0623\u0628\u062f\u064b\u0627 \u0625\u0644\u0649 \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629.</li></ul><p>\u0625\u0630\u0627 \u0644\u0645 \u062a\u0643\u0646 \u0628\u062d\u0627\u062c\u0629 \u0625\u0644\u0649 \u0648\u0638\u064a\u0641\u0629 \u0645\u062a\u0635\u0641\u062d \u062f\u0627\u062e\u0644 \u0627\u0644\u0644\u0639\u0628\u0629 (\u0645\u062b\u0644 \u062e\u0631\u0627\u0626\u0637 \u0627\u0644\u0648\u064a\u0628 \u0623\u0648 \u0635\u0641\u062d\u0627\u062a \u0645\u062f\u0645\u062c\u0629)\u060c \u0641\u0627\u062d\u0630\u0641 \u0627\u0644\u0648\u062d\u062f\u0629.</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "\u0645\u0634\u0643\u0644\u0629 \u062a\u0647\u064a\u0626\u0629 MCEF (\u0648\u062d\u062f\u0629 \u0627\u0644\u0645\u062a\u0635\u0641\u062d \u0627\u0644\u0645\u0636\u0645\u0646)";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "\u0627\u062d\u0630\u0641 \u0645\u0644\u0641 \u0648\u062d\u062f\u0629 MCEF (\u0627\u0628\u062d\u062b \u0639\u0646 'mcef' \u0641\u064a \u0627\u0633\u0645 \u0627\u0644\u0645\u0644\u0641) \u0645\u0646 \u0645\u062c\u0644\u062f 'mods'.";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "\u0625\u0630\u0627 \u0643\u0646\u062a \u0628\u062d\u0627\u062c\u0629 \u0645\u0627\u0633\u0629 \u0625\u0644\u064a\u0647\u0627\u060c \u0641\u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0646\u0638\u0627\u0645 \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0648\u0625\u0635\u062f\u0627\u0631 Minecraft.";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 <b>OptiFine</b> \u0648 <b>Iris/Oculus</b>.</b><ul><li>\u064a\u064f\u0639\u062f\u0651\u0644 OptiFine \u0639\u0631\u0636 Minecraft \u0628\u0637\u0631\u064a\u0642\u0629 \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642\u0629 \u0645\u0639 Iris \u0623\u0648 Oculus.</li><li>\u0627\u0644\u062e\u0637\u0623 <code>MixinLevelRenderer failed injection check</code> \u064a\u0646\u0634\u0623 \u0645\u0646 <code>mixins.iris.json</code> \u0623\u0648 <code>mixins.oculus.json</code>.</li></ul><p>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0645\u0639\u064b\u0627. \u0627\u062d\u0630\u0641 OptiFine \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 shaders \u0645\u0639 Iris \u0623\u0648 Oculus.</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 OptiFine \u0648 Iris/Oculus";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "\u0627\u062d\u0630\u0641 \u0645\u0644\u0641 OptiFine \u0645\u0646 \u0645\u062c\u0644\u062f 'mods'.";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "\u0627\u0633\u062a\u062e\u062f\u0645 Iris \u0623\u0648 Oculus \u0628\u062f\u0648\u0646 OptiFine \u0644\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 shaders \u062d\u062f\u064a\u062b\u0629.";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 <b>ModernFix</b> \u0648 <b>OptiFine</b>.</b><ul><li>ModernFix \u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 OptiFine \u0644\u0623\u0646\u0647 \u064a\u064f\u0639\u0637\u0651\u0644 \u0648\u0638\u0627\u0626\u0641 Forge \u0648\u064a\u064f\u0628\u0637\u0626 \u0627\u0644\u062a\u0634\u063a\u064a\u0644.</li><li>\u064a\u064f\u062d\u0630\u0651\u0631 ModernFix \u0646\u0641\u0633\u0647: <i>\"Use of ModernFix with OptiFine is not supported\"</i>.</li></ul><p>\u064a\u062c\u0628 \u0625\u0632\u0627\u0644\u0629 \u0623\u062d\u062f \u0627\u0644\u0645\u0648\u062f\u064a\u0646 \u0644\u0643\u064a \u062a\u0639\u0645\u0644 \u0627\u0644\u0644\u0639\u0628\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u064a\u0646 ModernFix \u0648 OptiFine";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "\u0627\u062d\u0630\u0641 OptiFine \u0623\u0648 ModernFix \u0645\u0646 \u0645\u062c\u0644\u062f 'mods'. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647\u0645\u0627 \u0645\u0639\u064b\u0627.";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "\u0625\u0630\u0627 \u0643\u0646\u062a \u0628\u062d\u0627\u062c\u0629 \u0625\u0644\u0649 \u062a\u062d\u0633\u064a\u0646\u0627\u062a \u0627\u0644\u0623\u062f\u0627\u0621\u060c \u0641\u0643\u0651\u0631 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645 OptiFine \u0648\u062d\u062f\u0647\u060c \u0623\u0648 \u0627\u0633\u062a\u0628\u062f\u0627\u0644 ModernFix \u0628\u0648\u062d\u062f\u0627\u062a \u0623\u062e\u0641 \u0645\u062b\u0644 FerriteCore \u0623\u0648 EntityCulling.";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error: clave de registro inv\u00e1lida con caracteres no permitidos.</b><ul><li><b>Clave detectada:</b> <code>" + this.escapeHtml(clave) + "</code></li><li>En Minecraft, todas las claves de registro (etiquetas, recetas, logros, etc.) deben estar en <b>min\u00fasculas</b> y usar solo letras, n\u00fameros, guiones bajos, guiones y barras.</li><li>Este error suele ser causado por un mod mal programado o un datapack defectuoso.</li></ul><p><b>Consejo importante:</b> Usa la herramienta <b>grepr</b> o <b>fgrepr</b> en la barra lateral y activa la opci\u00f3n <b>\"Buscar en archivos JAR\"</b> para encontrar qu\u00e9 mod contiene esta clave incorrecta.</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "Clave de registro con may\u00fasculas o caracteres inv\u00e1lidos";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "Usa 'grepr' o 'fgrepr' con \"Buscar en archivos JAR\" para localizar el mod culpable.";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "Si no puedes identificar el mod, elimina mods recientes, especialmente los que a\u00f1aden bloques, items o herramientas.";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0648\u062d\u062f\u0629 <b>" + this.escapeHtml(modNombre) + "</b>.</b><ul><li>\u0641\u0634\u0644\u062a \u0627\u0644\u0648\u062d\u062f\u0629 \u0641\u064a \u062a\u0647\u064a\u0626\u0629 \u0623\u062d\u062f \u0645\u0643\u0648\u0646\u0627\u062a\u0647\u0627 (\u0645\u062b\u0644 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a).</li><li>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0627\u062f\u0629\u064b \u0628\u0633\u0628\u0628 \u0639\u062f\u0645 \u0627\u0644\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 Minecraft \u0623\u0648 Fabric \u0623\u0648 \u0645\u0639 \u0648\u062d\u062f\u0627\u062a \u0623\u062e\u0631\u0649.</li></ul><p>\u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631 \u0627\u0644\u062e\u0637\u0623\u060c \u0627\u062d\u0630\u0641 \u0623\u0648 \u062d\u062f\u0651\u062b \u0627\u0644\u0648\u062d\u062f\u0629 <b>" + this.escapeHtml(modNombre) + "</b>.</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "\u062e\u0637\u0623 \u062a\u0647\u064a\u0626\u0629 \u0627\u0644\u0648\u062d\u062f\u0629 (Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "\u0627\u062d\u0630\u0641 \u0627\u0644\u0648\u062d\u062f\u0629 '" + modNombre + "' \u0645\u0646 \u0645\u062c\u0644\u062f 'mods'.";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "\u062d\u062f\u0651\u062b \u0627\u0644\u0648\u062d\u062f\u0629 '" + modNombre + "' \u0625\u0644\u0649 \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u062a\u062b\u0628\u064a\u062a\u0643.";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0645\u0631\u062a\u0628\u0637 \u0628\u0627\u0644\u0648\u062d\u062f\u0629 <b>En Garde!</b>.</b><ul><li>\u062a\u0636\u064a\u0641 \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0629 \u0622\u0644\u064a\u0627\u062a \u0642\u062a\u0627\u0644 \u0642\u0631\u064a\u0628 (\u0645\u062b\u0644 \u0627\u0644\u062a\u0635\u062f\u0649 \u0648\u0627\u0644\u062d\u0645\u0627\u064a\u0629\u060c \u0625\u0644\u062e).</li><li>\u064a\u062d\u062f\u062b \u0627\u0644\u062e\u0637\u0623 \u0639\u0627\u062f\u0629\u064b \u0628\u0633\u0628\u0628 \u0639\u062f\u0645 \u0627\u0644\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0648\u062d\u062f\u0627\u062a \u0642\u062a\u0627\u0644 \u0623\u062e\u0631\u0649 (\u0645\u062b\u0644 Epic Fight\u060c DualRiders\u060c \u0625\u0644\u062e) \u0623\u0648 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 \u063a\u064a\u0631 \u0645\u0646\u0627\u0633\u0628 \u0644\u0640 Minecraft \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.</li></ul><p>\u0625\u0630\u0627 \u0644\u0645 \u062a\u0633\u062a\u062e\u062f\u0645 \u0642\u062a\u0627\u0644\u0627\u064b \u0645\u062a\u0642\u062f\u0645\u064b\u0627\u060c \u0641\u0641\u0643\u0651\u0631 \u0641\u064a \u0625\u0632\u0627\u0644\u0629 En Garde! \u0644\u062a\u062c\u0646\u0628 \u0627\u0644\u062a\u0639\u0627\u0631\u0636\u0627\u062a.</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0648\u062d\u062f\u0629 En Garde!";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "\u062a\u0623\u0643\u062f \u0645\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0625\u0635\u062f\u0627\u0631 En Garde! \u0627\u0644\u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 Minecraft \u0648\u0627\u0644\u0645\u062d\u0645\u0644 (Fabric/Forge) \u0627\u0644\u062e\u0627\u0635\u064a\u0646 \u0628\u0643.";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0648\u062d\u062f\u0627\u062a \u0642\u062a\u0627\u0644 \u0623\u062e\u0631\u0649 (\u0645\u062b\u0644 Epic Fight\u060c Caelus\u060c \u0625\u0644\u062e)\u060c \u0641\u0639\u0637\u0651\u0644\u0647\u0627 \u0623\u0648 \u0627\u062d\u0630\u0641 En Garde! \u0644\u062a\u062c\u0646\u0628 \u0627\u0644\u062a\u0639\u0627\u0631\u0636\u0627\u062a.";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0646\u0627\u062a\u062c \u0639\u0646 \u0627\u0644\u0648\u062d\u062f\u0629 <b>IdleTweaks</b>.</b><ul><li>\u062d\u0627\u0648\u0644 IdleTweaks \u062a\u062d\u0631\u064a\u0631 \u0642\u0646\u0627\u0629 \u0634\u0628\u0643\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629 (<code>Tried to release unknown channel</code>).</li><li>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0627\u062f\u0629\u064b \u0641\u064a \u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0642\u062f\u064a\u0645\u0629 \u0645\u0646 \u0627\u0644\u0648\u062d\u062f\u0629 \u0623\u0648 \u0639\u0646\u062f \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647\u0627 \u0639\u0644\u0649 \u062e\u0648\u0627\u062f\u0645 \u063a\u064a\u0631 \u0645\u0636\u0628\u0648\u0637\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d.</li></ul><p>IdleTweaks \u0647\u0648 \u0648\u062d\u062f\u0629 \u0644\u062a\u062d\u0633\u064a\u0646 \u062c\u0648\u062f\u0629 \u0627\u0644\u062d\u064a\u0627\u0629\u060c \u0644\u0643\u0646\u0647 \u0642\u062f \u064a\u0633\u0628\u0628 \u0639\u062f\u0645 \u0627\u0633\u062a\u0642\u0631\u0627\u0631. \u0641\u0643\u0651\u0631 \u0641\u064a \u062a\u062d\u062f\u064a\u062b\u0647 \u0623\u0648 \u0625\u0632\u0627\u0644\u062a\u0647.</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "\u062e\u0637\u0623 \u0641\u064a IdleTweaks (\u0642\u0646\u0627\u0629 \u0634\u0628\u0643\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641\u0629)";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "\u062d\u062f\u0651\u062b IdleTweaks \u0625\u0644\u0649 \u0623\u062d\u062f\u062b \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 Minecraft \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "\u0627\u062d\u0630\u0641 IdleTweaks \u0645\u0646 \u0645\u062c\u0644\u062f 'mods' \u0625\u0630\u0627 \u0644\u0645 \u062a\u0643\u0646 \u0628\u062d\u0627\u062c\u0629 \u0625\u0644\u064a\u0647.";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0645\u0635\u0627\u062f\u0642\u0629 (HTTP 401) \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0625\u0644\u0649 Minecraft.</b><p>\u0646\u0627\u062f\u0631\u064b\u0627 \u0645\u0627 \u064a\u0643\u0648\u0646 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 <b>\u0627\u0644\u0633\u0628\u0628 \u0627\u0644\u0645\u0628\u0627\u0634\u0631 \u0644\u0644\u062a\u062d\u0637\u064a\u0645</b>\u060c \u0644\u0643\u0646\u0647 \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0623\u0646\u0643 \u062a\u0633\u062a\u062e\u062f\u0645 \u062d\u0633\u0627\u0628\u064b\u0627 \u063a\u064a\u0631 \u0645\u0635\u0631\u062d \u0628\u0647 (\u0646\u0633\u062e\u0629 \u0645\u0642\u0631\u0635\u0646\u0629).</p><p>\u0642\u0646\u0648\u0627\u062a \u0627\u0644\u062f\u0639\u0645 \u0627\u0644\u0631\u0633\u0645\u064a\u0629 (\u0627\u0644\u0645\u0634\u0627\u0631\u064a\u0639 \u0627\u0644\u0645\u0624\u0633\u0633\u064a\u0629\u060c VTubers\u060c \u0645\u0646\u0634\u0626\u0648 \u062d\u0632\u0645 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a\u060c \u0625\u0644\u062e) <b>\u0644\u0627 \u064a\u0645\u0643\u0646\u0647\u0627 \u0645\u0633\u0627\u0639\u062f\u062a\u0643</b> \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0646\u0633\u062e\u0629 \u0645\u0642\u0631\u0635\u0646\u0629\u060c \u0628\u0633\u0628\u0628 \u0642\u064a\u0648\u062f \u0642\u0648\u0627\u0639\u062f \u0627\u0644\u062f\u0631\u062f\u0634\u0629 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0647\u0645\u060c \u0623\u0648 \u0627\u0644\u0639\u0642\u0648\u062f\u060c \u0623\u0648 \u0627\u0644\u0627\u062a\u0641\u0627\u0642\u064a\u0627\u062a \u0645\u0639 Mojang/Microsoft\u060c \u0623\u0648 \u0633\u064a\u0627\u0633\u0627\u062a \u0627\u0644\u0633\u0645\u0639\u0629.</p><p>\u064a\u0645\u0643\u0646\u0643 <b>\u062a\u0639\u0637\u064a\u0644 \u0647\u0630\u0627 \u0627\u0644\u062a\u062d\u0642\u0642 \u0641\u064a \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0645\u0624\u0633\u0633\u064a\u0629</b> \u0644\u0643\u0627\u0634\u0641 \u0627\u0644\u0623\u062e\u0637\u0627\u0621. \u062a\u062d\u0630\u064a\u0631: \u0625\u0646 \u0643\u0634\u0641 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0645\u0642\u0631\u0635\u0646\u0629 <b>\u0644\u064a\u0633 \u0645\u062b\u0627\u0644\u064a\u064b\u0627</b> \u0648\u0642\u062f \u064a\u064f\u0641\u0639\u0651\u0644 \u0641\u064a \u0628\u064a\u0626\u0627\u062a \u0627\u0644\u062a\u0637\u0648\u064a\u0631\u060c \u0623\u0648 \u0645\u0639 \u0627\u062a\u0635\u0627\u0644 \u0625\u0646\u062a\u0631\u0646\u062a \u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0631\u060c \u0623\u0648 \u0639\u0646\u062f \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0634\u063a\u0651\u0644\u0627\u062a \u0645\u0639\u062f\u0644\u0629.</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>\u062d\u0642\u0648\u0642 \u0645\u064a\u0631\u0627\u0646\u062f\u0627 \u0625\u0630\u0627 \u062d\u0627\u0648\u0644\u062a \u0627\u0644\u0627\u0646\u0636\u0645\u0627\u0645 \u0644\u0644\u062f\u0639\u0645 \u0631\u063a\u0645 \u0630\u0644\u0643:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "\u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0645\u0642\u0631\u0635\u0646";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "\u062a\u0639\u0637\u064a\u0644 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0642\u0631\u0635\u0646\u0629";
    }

    @Override
    public String comprarMC() {
        return "\u0634\u0631\u0627\u0621 Minecraft";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0645\u0634\u063a\u0651\u0644 <code>" + id + "</code>\u060c \u0627\u0644\u0630\u064a <b>\u0644\u064a\u0633 \u0641\u064a \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0645\u0634\u063a\u0651\u0644\u0627\u062a \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627</b>.</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>\u0631\u063a\u0645 \u0623\u0646\u0647 \u0642\u062f \u064a\u0639\u0645\u0644\u060c \u0625\u0644\u0627 \u0623\u0646 \u0627\u0644\u0645\u0634\u063a\u0651\u0644\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0639\u0627\u062f\u0629\u064b \u062a\u0633\u0628\u0628:</p><ul><li>\u062a\u062b\u0628\u064a\u062a\u0627\u062a \u062a\u0627\u0644\u0641\u0629 \u0644\u0644\u0648\u062d\u062f\u0627\u062a \u0623\u0648 \u0627\u0644\u062a\u0637\u0628\u064a\u0642.</li><li>\u0641\u0634\u0644 \u0627\u0644\u0644\u0639\u0628\u0629 \u0641\u064a \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0623\u0648 \u062a\u062c\u0645\u062f\u0647\u0627 \u062f\u0648\u0646 \u062e\u0637\u0623 \u0648\u0627\u0636\u062d.</li><li>\u0647\u064a\u0643\u0644 \u0645\u062c\u0644\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u0639\u062a\u0627\u062f (\u064a\u064f\u0635\u0639\u0651\u0628 \u0627\u0644\u062a\u0634\u062e\u064a\u0635).</li><li>\u0633\u0644\u0648\u0643 \u063a\u064a\u0631 \u0645\u062a\u0648\u0642\u0639 \u0645\u0639 Java \u0623\u0648 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0623\u0648 \u0627\u0644\u0648\u062d\u062f\u0627\u062a.</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "\u0644\u062a\u062c\u0631\u0628\u0629 \u0623\u0641\u0636\u0644\u060c \u0627\u0633\u062a\u062e\u062f\u0645 \u0623\u062d\u062f \u0627\u0644\u0645\u0634\u063a\u0651\u0644\u0627\u062a \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0627\u0644\u062a\u0627\u0644\u064a\u0629:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "\u0645\u0634\u063a\u0651\u0644 \u063a\u064a\u0631 \u0645\u0648\u0635\u0649 \u0628\u0647";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "\u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 \u0645\u0634\u063a\u0651\u0644 \u0645\u0646 \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627.";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 <b>\u0645\u0634\u063a\u0651\u0644\u064b\u0627 \u0645\u064f\u0646\u0641\u064e\u0631\u064e\u0636\u064b\u0627 \u0636\u062f\u0647</b>: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>\u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0633\u0628\u0628 \u0627\u0644\u0645\u0634\u063a\u0651\u0644\u0627\u062a \u0627\u0644\u0645\u064f\u0646\u0641\u064e\u0631\u064e\u0636\u064e\u0629 \u0636\u062f\u0647\u0627:</p><ul><li>\u062a\u062b\u0628\u064a\u062a\u0627\u062a \u062a\u0627\u0644\u0641\u0629 \u0644\u0644\u062a\u0637\u0628\u064a\u0642 \u0623\u0648 \u0627\u0644\u0648\u062d\u062f\u0627\u062a.</li><li>\u0641\u0634\u0644 \u0627\u0644\u0644\u0639\u0628\u0629 \u0641\u064a \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0623\u0648 \u062a\u0639\u0637\u0644\u0647\u0627 \u0628\u0635\u0645\u062a.</li><li>\u062a\u0646\u0638\u064a\u0645 \u063a\u064a\u0631 \u0645\u0639\u062a\u0627\u062f \u0644\u0644\u0645\u0644\u0641\u0627\u062a (\u0635\u0639\u0628 \u0627\u0644\u062a\u0635\u062d\u064a\u062d).</li><li>\u0639\u062f\u0645 \u0648\u0636\u0648\u062d \u0641\u064a \u0643\u064a\u0641\u064a\u0629 \u0625\u062f\u0627\u0631\u062a\u0647\u0627 \u0644\u0644\u0648\u062d\u062f\u0627\u062a \u0623\u0648 Java \u0623\u0648 \u0627\u0644\u0630\u0627\u0643\u0631\u0629.</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "\u064a\u064f\u0648\u0635\u0649 \u0628\u0634\u062f\u0629 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062d\u062f \u0627\u0644\u0645\u0634\u063a\u0651\u0644\u0627\u062a \u0627\u0644\u062a\u0627\u0644\u064a\u0629:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "\u0645\u0634\u063a\u0651\u0644 \u0645\u064f\u0646\u0641\u064e\u0631\u064e\u0636\u064c \u0636\u062f\u0647";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "\u0627\u0646\u062a\u0642\u0644 \u0625\u0644\u0649 \u0645\u0634\u063a\u0651\u0644 \u0645\u0648\u0635\u0649 \u0628\u0647 \u0644\u062a\u0644\u0642\u0651\u064a \u0627\u0644\u062f\u0639\u0645.";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u064e\u0646\u0652\u0635\u064f\u0631 \u0648\u062d\u062f\u0627\u062a \u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0644\u0647\u0630\u0627 \u0627\u0644\u0628\u064a\u0626\u0629.</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "\u0648\u062d\u062f\u0627\u062a \u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0645\u0641\u0642\u0648\u062f\u0629";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "\u062b\u0628\u0651\u062a \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0644\u062a\u062c\u0631\u0628\u0629 \u0645\u062b\u0627\u0644\u064a\u0629.";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0641\u064a \u062a\u062b\u0628\u064a\u062a\u0643.</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0645\u0648\u0635\u0649 \u0628\u0647\u0627";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "\u0627\u062d\u0630\u0641 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0644\u062a\u062c\u0646\u0628 \u0627\u0644\u0645\u0634\u0627\u0643\u0644.";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u062f\u064a\u0644 \u063a\u064a\u0631 \u0645\u0635\u0631\u062d \u0628\u0647 \u0641\u064a \u0645\u0644\u0641\u0627\u062a \u062d\u0631\u062c\u0629. \u0625\u0645\u0627 \u0623\u0646\u0643 \u0639\u062f\u0651\u0644\u062a \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0623\u0648 \u0623\u0646\u0643 \u062a\u0633\u062a\u062e\u062f\u0645 \u0645\u0634\u063a\u0651\u0644\u064b\u0627 \u063a\u064a\u0631 \u0645\u0648\u062b\u0648\u0642.</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u0639\u062f\u064a\u0644";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "\u0623\u0639\u0650\u062f \u062a\u062b\u0628\u064a\u062a \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0623\u0635\u0644\u064a\u0629 \u0644\u0627\u0633\u062a\u0639\u0627\u062f\u0629 \u0627\u0644\u0633\u0644\u0627\u0645\u0629.";
    }

    @Override
    public String configuracionCorporativa() {
        return "\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0645\u0624\u0633\u0633\u064a\u0629";
    }

    @Override
    public String idiomaRespaldo() {
        return "\u0644\u063a\u0629 \u0627\u0644\u0646\u0633\u062e\u0629 \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629";
    }

    @Override
    public String buscardorHabilitado() {
        return "\u062a\u0645\u0643\u064a\u0646 \u0623\u062f\u0627\u0629 \u0627\u0644\u0628\u062d\u062b";
    }

    @Override
    public String nombreHerramienta() {
        return "\u0627\u0633\u0645 \u0627\u0644\u0623\u062f\u0627\u0629";
    }

    @Override
    public String condenarPirateria() {
        return "\u0625\u062f\u0627\u0646\u0629 \u0627\u0644\u0642\u0631\u0635\u0646\u0629";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "\u0627\u0644\u0645\u0634\u063a\u0644\u0627\u062a \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "\u0627\u0644\u0645\u0634\u063a\u0644\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627";
    }

    @Override
    public String modsRecomendados() {
        return "\u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627";
    }

    @Override
    public String modsDesaconsejados() {
        return "\u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627";
    }

    @Override
    public String antiTamper() {
        return "\u0645\u0643\u0627\u0641\u062d\u0629 \u0627\u0644\u062a\u0644\u0627\u0639\u0628";
    }

    @Override
    public String proximamente() {
        return "\u0642\u0631\u064a\u0628\u0627\u064b";
    }

    @Override
    public String informacion() {
        return "\u0645\u0639\u0644\u0648\u0645\u0627\u062a";
    }

    @Override
    public String errorCargandoImagen() {
        return "\u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0635\u0648\u0631\u0629";
    }

    @Override
    public String configuracionBasica() {
        return "\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629";
    }

    @Override
    public String funcionalidades() {
        return "\u0627\u0644\u0645\u064a\u0632\u0627\u062a";
    }

    @Override
    public String derechosMiranda() {
        return "\u062d\u0642\u0648\u0642 \u0645\u064a\u0631\u0627\u0646\u062f\u0627 (\u0645\u0637\u0644\u0648\u0628\u0629 \u0628\u0634\u062f\u0629)";
    }

    @Override
    public String gestionVerificaciones() {
        return "\u0625\u062f\u0627\u0631\u0629 \u0627\u0644\u062a\u062d\u0642\u0642";
    }

    @Override
    public String idVerificacion() {
        return "\u0627\u0644\u0645\u0639\u0631\u0651\u0641";
    }

    @Override
    public String nombreVerificacion() {
        return "\u0627\u0644\u0627\u0633\u0645";
    }

    @Override
    public String codigoVerificacion() {
        return "\u0627\u0644\u0643\u0648\u062f";
    }

    @Override
    public String documentacionVerificacion() {
        return "\u0627\u0644\u0648\u062b\u0627\u0626\u0642";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "\u0627\u0644\u0639\u0645\u0644\u064a\u0627\u062a \u0627\u0644\u0645\u0641\u0639\u0651\u0644\u0629:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "\u0627\u0644\u0639\u0645\u0644\u064a\u0627\u062a \u0627\u0644\u0645\u0639\u0637\u0651\u0644\u0629:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "\u062a\u0639\u0637\u064a\u0644 \u062c\u0645\u064a\u0639 \u063a\u064a\u0631 \u0627\u0644\u0645\u0624\u0633\u0633\u064a\u0629";
    }

    @Override
    public String verCodigo() {
        return "\u0639\u0631\u0636 \u0627\u0644\u0643\u0648\u062f";
    }

    @Override
    public String verDocumentacion() {
        return "\u0639\u0631\u0636 \u0627\u0644\u0648\u062b\u0627\u0626\u0642";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "\u0627\u062e\u062a\u0631 \u0639\u0645\u0644\u064a\u0629 \u062a\u062d\u0642\u0642 \u0644\u062a\u0639\u0637\u064a\u0644\u0647\u0627.";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "\u0627\u062e\u062a\u0631 \u0639\u0645\u0644\u064a\u0629 \u062a\u062d\u0642\u0642 \u0644\u062a\u0641\u0639\u064a\u0644\u0647\u0627.";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "\u062a\u0645 \u062a\u0639\u0637\u064a\u0644 %d \u0639\u0645\u0644\u064a\u0627\u062a \u062a\u062d\u0642\u0642 \u063a\u064a\u0631 \u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0644\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0645\u0624\u0633\u0633\u064a.";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "\u0644\u0627 \u062a\u0648\u062c\u062f \u0639\u0645\u0644\u064a\u0627\u062a \u062a\u062d\u0642\u0642 \u063a\u064a\u0631 \u0645\u0624\u0633\u0633\u064a\u0629 \u0644\u0644\u062a\u0639\u0637\u064a\u0644.";
    }

    @Override
    public String operacionCompletada() {
        return "\u0627\u0643\u062a\u0645\u0644\u062a \u0627\u0644\u0639\u0645\u0644\u064a\u0629";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "\u0646\u0641\u062a\u0642\u0650\u062f\u0643 \u064a\u0627 Amane Kanata";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062a\u062d\u0642\u0642 \u0627\u0644\u0645\u0624\u0633\u0633\u064a";
    }

    @Override
    public String nombreLanzador() {
        return "\u0627\u0633\u0645 \u0627\u0644\u0645\u0634\u063a\u0651\u0644";
    }

    @Override
    public String motivo() {
        return "\u0627\u0644\u0633\u0628\u0628";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "\u0627\u0644\u0645\u0634\u063a\u0644\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627";
    }

    @Override
    public String moverADesaconsejados() {
        return "\u0625\u0628\u0637\u0627\u0644 \u0627\u0644\u062a\u0648\u0635\u064a\u0629";
    }

    @Override
    public String moverARecomendados() {
        return "\u0627\u0644\u062a\u0648\u0635\u064a\u0629";
    }

    @Override
    public String guardarCambios() {
        return "\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a";
    }

    @Override
    public String cancelar() {
        return "\u0625\u0644\u063a\u0627\u0621";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "\u064a\u0631\u062c\u0649 \u0627\u062e\u062a\u064a\u0627\u0631 \u0645\u0634\u063a\u0651\u0644 \u0644\u0644\u0646\u0642\u0644.";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d!";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "\u0627\u0644\u0623\u0633\u0628\u0627\u0628";
    }

    @Override
    public String agregarLanzador() {
        return "\u0625\u0636\u0627\u0641\u0629 \u0645\u0634\u063a\u0651\u0644";
    }

    @Override
    public String quitarLanzador() {
        return "\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0634\u063a\u0651\u0644";
    }

    @Override
    public String editarRazones() {
        return "\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0623\u0633\u0628\u0627\u0628";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "\u0627\u062e\u062a\u0631 \u0645\u0634\u063a\u0651\u0644\u0627\u064b \u0644\u0625\u0632\u0627\u0644\u062a\u0647.";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "\u0627\u062e\u062a\u0631 \u0645\u0634\u063a\u0651\u0644\u0627\u064b \u0644\u062a\u0639\u062f\u064a\u0644\u0647.";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return "\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0644\u0640 " + idLanzador;
    }

    @Override
    public String agregarNuevoIdioma() {
        return "\u0625\u0636\u0627\u0641\u0629 \u0644\u063a\u0629 \u062c\u062f\u064a\u062f\u0629";
    }

    @Override
    public String aceptar() {
        return "\u0645\u0648\u0627\u0641\u0642";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "\u0627\u062e\u062a\u0631 \u0627\u0644\u0644\u063a\u0629";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "\u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u063a\u0651\u0644\u0627\u062a \u0647\u064a \u0627\u0644\u062a\u064a \u064a\u0642\u062a\u0631\u062d\u0647\u0627 CrashDetector \u0643\u062e\u064a\u0627\u0631 \u062c\u064a\u062f.";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "\u0627\u0644\u0646\u062a\u064a\u062c\u0629 \u0635\u062d\u064a\u062d\u0629";
    }

    @Override
    public String modsNoRecomendados() {
        return "\u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627";
    }

    @Override
    public String agregarMod() {
        return "\u0625\u0636\u0627\u0641\u0629 \u0648\u062d\u062f\u0629";
    }

    @Override
    public String quitarMod() {
        return "\u0625\u0632\u0627\u0644\u0629 \u0648\u062d\u062f\u0629";
    }

    @Override
    public String modId() {
        return "\u0645\u0639\u0631\u0651\u0641 \u0627\u0644\u0648\u062d\u062f\u0629 / \u0627\u0633\u0645 JBoss Modules";
    }

    @Override
    public String rutaMod() {
        return "\u0645\u0633\u0627\u0631 / \u0645\u0644\u0641 \u0627\u0644\u0648\u062d\u062f\u0629";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "\u064a\u062c\u0628 \u0623\u0646 \u062a\u064f\u062f\u062e\u0644 \u0645\u0639\u0631\u0651\u0641 \u0627\u0644\u0648\u062d\u062f\u0629 \u0623\u0648 \u0645\u0633\u0627\u0631 \u0627\u0644\u0645\u0644\u0641 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644.";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "\u0647\u0646\u0627 \u064a\u0645\u0643\u0646\u0643 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u063a\u064a\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0644\u064a\u0643\u062a\u0634\u0641\u0647\u0627 CrashDetector \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0645\u062b\u0628\u062a\u0629.";
    }

    @Override
    public String anularNormal() {
        return "\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0648\u0636\u0639 \u0627\u0644\u0639\u0627\u062f\u064a";
    }

    @Override
    public String anularNormalDescripcion() {
        return "\u064a\u062c\u0628 \u0623\u0646 \u064a\u064f\u062d\u0630\u0651\u0631 CrashDetector \u062d\u062a\u0649 \u0644\u0648 \u0644\u0645 \u064a\u062d\u062f\u062b \u062a\u062d\u0637\u064a\u0645.";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "\u0633\u062c\u0651\u0644 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u064a\u0648\u0635\u064a \u0628\u0647\u0627 CrashDetector. \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0645\u0641\u0642\u0648\u062f\u0629\u060c \u0641\u0642\u062f \u064a\u064f\u062d\u0630\u0651\u0631\u0643 CrashDetector.";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "\u0625\u0630\u0627 \u0642\u0631\u0631\u062a \u062a\u0641\u0639\u064a\u0644 \u062a\u062d\u0630\u064a\u0631 \u0645\u0643\u0627\u0641\u062d\u0629 \u0627\u0644\u0642\u0631\u0635\u0646\u0629\u060c \u064a\u064f\u0648\u0635\u0649 \u0628\u062a\u062d\u062f\u064a\u062f \u062d\u0642\u0648\u0642 \u0627\u0644\u0634\u062e\u0635 \u0627\u0644\u0630\u064a \u064a\u0637\u0644\u0628 \u0627\u0644\u062f\u0639\u0645 \u0647\u0646\u0627\u060c \u0643\u0625\u062c\u0631\u0627\u0621 \u0648\u0642\u0627\u0626\u064a.\n\n\u062e\u0644\u0627\u0641\u064b\u0627 \u0644\u0627\u0639\u062a\u0642\u0627\u062f \u0634\u0627\u0626\u0639\u060c \u0641\u0625\u0646 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u062c\u062a\u0645\u0639\u0627\u062a \u0648\u0642\u0646\u0648\u0627\u062a \u0627\u0644\u062f\u0639\u0645 \u0627\u0644\u0634\u0647\u064a\u0631\u0629 \u0644\u0627 \u062a\u062a\u0637\u0644\u0628 \u062a\u0641\u0639\u064a\u0644 \u062a\u062d\u0630\u064a\u0631\u0627\u062a \u0645\u0643\u0627\u0641\u062d\u0629 \u0627\u0644\u0642\u0631\u0635\u0646\u0629 \u0644\u062a\u0642\u062f\u064a\u0645 \u0627\u0644\u0645\u0633\u0627\u0639\u062f\u0629. \u0648\u0645\u0639 \u0630\u0644\u0643\u060c \u0642\u062f \u064a\u0643\u0648\u0646 \u062a\u0648\u062b\u064a\u0642 \u0647\u0630\u0647 \u0627\u0644\u062d\u0642\u0648\u0642 \u0645\u0641\u064a\u062f\u064b\u0627 \u0641\u064a \u062d\u0627\u0644 \u0648\u0635\u0648\u0644 \u0634\u062e\u0635 \u0645\u0627 \u0625\u0644\u0649 \u0642\u0646\u0627\u0629 \u0627\u0644\u062f\u0639\u0645 \u0639\u0644\u0649 \u0623\u064a \u062d\u0627\u0644.\n\n\u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0639\u0644\u0649 \u0648\u062b\u0627\u0626\u0642 \u0631\u0633\u0645\u064a\u0629 \u0645\u062b\u0644 \u0643\u062a\u064a\u0628 \u0627\u0644\u062d\u0642\u0648\u0642 \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629 \u0644\u0644\u0645\u0639\u062a\u0642\u0644 \u0641\u064a \u0627\u0644\u0645\u0643\u0633\u064a\u0643:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\n\u0648\u0643\u0630\u0644\u0643 \u0639\u0644\u0649 \u0645\u0628\u0627\u062f\u0626 \u0642\u0627\u0646\u0648\u0646\u064a\u0629 \u0645\u0645\u0627\u062b\u0644\u0629 \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0641\u064a \u062f\u0648\u0644 \u0623\u062e\u0631\u0649\u060c \u0628\u0645\u0627 \u0641\u064a \u0630\u0644\u0643 \u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629\u060c \u0648\u0627\u062a\u062d\u0627\u062f \u0631\u0648\u0633\u064a\u0627\u060c \u0648\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0635\u064a\u0646 \u0627\u0644\u0634\u0639\u0628\u064a\u0629\u060c \u0648\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a\u0629 \u0627\u0644\u0625\u064a\u0631\u0627\u0646\u064a\u0629\u060c \u0648\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u0634\u0639\u0628\u064a\u0629 \u0627\u0644\u062f\u064a\u0645\u0642\u0631\u0627\u0637\u064a\u0629.\n\n\u0648\u0645\u0646 \u0623\u0645\u062b\u0644\u0629 \u0627\u0644\u062d\u0642\u0648\u0642 \u0627\u0644\u062a\u064a \u064a\u0645\u0643\u0646 \u062a\u0636\u0645\u064a\u0646\u0647\u0627:\n\u2022 \u0627\u0644\u062d\u0642 \u0641\u064a \u0639\u062f\u0645 \u062a\u0642\u062f\u064a\u0645 \u0645\u0639\u0644\u0648\u0645\u0627\u062a \u063a\u064a\u0631 \u0636\u0631\u0648\u0631\u064a\u0629 \u0644\u0644\u062f\u0639\u0645\u060c \u0645\u062b\u0644 \u0627\u0644\u0645\u0634\u063a\u0651\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u060c \u0623\u0648 \u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0623\u0648 UUID.\n\u2022 \u0627\u0644\u062d\u0642 \u0641\u064a \u0639\u062f\u0645 \u0627\u0644\u062a\u0634\u0647\u064a\u0631 \u0628\u0646\u0641\u0633\u0643.\n\u2022 \u0627\u0644\u062d\u0642 \u0641\u064a \u0631\u0641\u0636 \u0627\u0644\u0625\u062c\u0627\u0628\u0629 \u0639\u0646 \u0623\u0633\u0626\u0644\u0629 \u063a\u064a\u0631 \u0636\u0631\u0648\u0631\u064a\u0629 \u0644\u062d\u0644 \u0627\u0644\u0645\u0634\u0643\u0644\u0629.\n\u2022 \u0627\u0644\u062d\u0642 \u0641\u064a \u062a\u0644\u0642\u064a \u0627\u0644\u062a\u0648\u062c\u064a\u0647 \u062f\u0627\u062e\u0644 \u0627\u0644\u062f\u0631\u062f\u0634\u0629.\n\u2022 \u0627\u0644\u062d\u0642 \u0641\u064a \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u062f\u0627\u0629 \u0625\u062e\u0641\u0627\u0621 \u0627\u0644\u0647\u0648\u064a\u0629 \u0627\u0644\u0645\u062f\u0645\u062c\u0629 \u0641\u064a CrashDetector \u0644\u0644\u0633\u062c\u0644\u0627\u062a (logs).\n\n\u064a\u0642\u0628\u0644 \u0647\u0630\u0627 \u0627\u0644\u0646\u0635 \u0645\u062d\u062a\u0648\u0649 HTML.";
    }

    @Override
    public String editar() {
        return "\u062a\u0639\u062f\u064a\u0644";
    }

    @Override
    public String advertenciaHashLento() {
        return "\u062a\u062d\u0630\u064a\u0631: \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0643\u0628\u064a\u0631\u0629 \u0642\u062f \u064a\u062c\u0639\u0644 \u0627\u0644\u062a\u062d\u0642\u0642 \u064a\u0633\u062a\u063a\u0631\u0642 \u0639\u062f\u0629 \u062f\u0642\u0627\u0626\u0642. \u0633\u064a\u062a\u0639\u064a\u0646 \u0639\u0644\u0649 CrashDetector \u062d\u0633\u0627\u0628 \u0627\u0644\u0647\u0627\u0634 \u0644\u0643\u0644 \u0645\u0644\u0641 \u0642\u0628\u0644 \u0627\u0644\u0645\u062a\u0627\u0628\u0639\u0629. \u064a\u064f\u0648\u0635\u0649 \u0628\u062d\u0645\u0627\u064a\u0629 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0636\u0631\u0648\u0631\u064a\u0629 \u0641\u0642\u0637.";
    }

    @Override
    public String agregarArchivo() {
        return "\u0625\u0636\u0627\u0641\u0629 \u0645\u0644\u0641";
    }

    @Override
    public String agregarCarpeta() {
        return "\u0625\u0636\u0627\u0641\u0629 \u0645\u062c\u0644\u062f";
    }

    @Override
    public String quitar() {
        return "\u0625\u0632\u0627\u0644\u0629";
    }

    @Override
    public String rutaArchivo() {
        return "\u0645\u0633\u0627\u0631 \u0627\u0644\u0645\u0644\u0641";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "\u0627\u0644\u0645\u0633\u0627\u0631 \u0627\u0644\u0645\u062d\u062f\u062f \u062e\u0627\u0631\u062c \u062f\u0644\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629 \u0627\u0644\u062d\u0627\u0644\u064a. \u064a\u064f\u0633\u0645\u062d \u0641\u0642\u0637 \u0628\u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0648\u0627\u0644\u0645\u062c\u0644\u062f\u0627\u062a \u062f\u0627\u062e\u0644 \u0627\u0644\u062f\u0644\u064a\u0644 \u0627\u0644\u062d\u0627\u0644\u064a \u0623\u0648 \u0645\u062c\u0644\u062f\u0627\u062a\u0647 \u0627\u0644\u0641\u0631\u0639\u064a\u0629.";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>\u0622\u0631\u0627\u0621 \u0648\u062a\u0639\u0644\u064a\u0642\u0627\u062a Sylent Bell \u0644\u0627 \u062a\u062a\u0637\u0627\u0628\u0642 \u0628\u0627\u0644\u0636\u0631\u0648\u0631\u0629 \u0645\u0639 \u0622\u0631\u0627\u0626\u0646\u0627\u061b \u0641\u0642\u0637 \u0627\u0639\u062a\u0642\u062f\u0646\u0627 \u0623\u0646\u0647 \u0633\u064a\u0643\u0648\u0646 \u0645\u0636\u062d\u0643\u064b\u0627 \u0648\u0636\u0639\u0647\u0627 \u0647\u0646\u0627. CrashDetector \u0639\u0644\u0645\u0627\u0646\u064a.</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0644\u0648\u062d\u062f\u0629 GML (Groovy ModLoader) \u062a\u062a\u0637\u0644\u0628 \u0647\u0630\u0647 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a\u060c \u0648\u0647\u064a \u0627\u0644\u0633\u0628\u0628 \u0627\u0644\u0623\u0643\u062b\u0631 \u0634\u064a\u0648\u0639\u064b\u0627 \u0644\u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629.</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 <i> Flywheel</i>.</b><p><b> Flywheel \u0642\u062f\u064a\u0645 (\u0645\u064f\u0647\u0645\u064e\u0644)</b> \u0648\u0644\u0627 \u064a\u062c\u0628 \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647 \u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u062d\u062f\u064a\u062b\u0629.</p><p>\u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u0645\u0646 <b>Create</b> <b>\u062a\u062a\u0636\u0645\u0646 Flywheel \u0628\u0627\u0644\u0641\u0639\u0644</b>\u060c \u0644\u0630\u0627 \u0641\u0625\u0646 \u062a\u062b\u0628\u064a\u062a\u0647 \u0628\u0634\u0643\u0644 \u0645\u0646\u0641\u0635\u0644 \u064a\u0624\u062f\u064a \u0625\u0644\u0649 \u062a\u0639\u0627\u0631\u0636\u0627\u062a \u062a\u0648\u0627\u0641\u0642\u064a\u0629 \u0648\u0623\u062e\u0637\u0627\u0621 \u062a\u062d\u0645\u064a\u0644.</p><p>\u0628\u0639\u0636 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0639\u062a\u0645\u062f \u0635\u0631\u0627\u062d\u0629\u064b \u0639\u0644\u0649  Flywheel \u0642\u062f <b>\u0644\u0627 \u062a\u0639\u0645\u0644</b> \u0623\u0648 <b>\u062a\u0639\u0645\u0644 \u0628\u0634\u0643\u0644 \u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0631</b>. \u0641\u064a \u062d\u0627\u0644\u0627\u062a \u0645\u062a\u0642\u062f\u0645\u0629 \u0645\u0639\u064a\u0646\u0629\u060c \u0642\u062f \u062a\u0639\u0645\u0644 \u0647\u0630\u0647 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0625\u0630\u0627 \u062a\u0645 <b>\u062a\u0639\u062f\u064a\u0644 \u0645\u0644\u0641 <code>mods.toml</code> \u064a\u062f\u0648\u064a\u064b\u0627</b> \u0644\u0636\u0628\u0637 \u0646\u0637\u0627\u0642\u0627\u062a \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u060c \u0631\u063a\u0645 \u0623\u0646 \u0647\u0630\u0627 <b>\u063a\u064a\u0631 \u0645\u0648\u0635\u0649 \u0628\u0647</b>.</p>" + (mods.isEmpty() ? "" : "<p><b>\u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u0645\u0643\u062a\u0634\u0641\u0629 \u0627\u0644\u062a\u064a \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 Flywheel:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>\u0627\u0644\u062d\u0644 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647 \u0647\u0648 <b>\u0625\u0632\u0627\u0644\u0629  Flywheel</b> \u0648\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0645\u062f\u0645\u062c \u0645\u0639 Create \u0641\u0642\u0637.</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "Flywheel \u0627\u0644\u0645\u0633\u062a\u0642\u0644";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0645\u0631\u062a\u0628\u0637 \u0628\u0627\u0644\u0648\u062d\u062f\u0629 <i>Floral Enchantments</i>.</b><p>\u0627\u0644\u062a\u062d\u0637\u064a\u0645 \u0646\u0627\u062a\u062c \u0639\u0646 \u0639\u0637\u0644 \u062f\u0627\u062e\u0644\u064a \u0641\u064a \u0627\u0644\u0648\u062d\u062f\u0629 \u0623\u062b\u0646\u0627\u0621 \u0645\u0639\u0627\u0644\u062c\u0629 \u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0644\u0639\u0628\u0629\u060c \u0645\u0645\u0627 \u064a\u0633\u0628\u0628 <b>NullPointerException</b> \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u0646\u0641\u064a\u0630.</p><p>\u0639\u0627\u062f\u0629\u064b \u0645\u0627 \u064a\u064f\u062d\u0644 \u0647\u0630\u0627 \u0627\u0644\u0645\u0634\u0643\u0644 \u0628\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0648\u062d\u062f\u0629 \u0623\u0648 \u0625\u0632\u0627\u0644\u062a\u0647\u0627.</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "\u062e\u0637\u0623 \u0641\u064a Floral Enchantments";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>\u0644\u062f\u064a\u0643 \u0625\u0635\u062f\u0627\u0631 NeoForge \u0645\u0646 MixinExtras \u0648\u0627\u0644\u0625\u0635\u062f\u0627\u0631 \u0627\u0644\u0639\u0627\u062f\u064a. \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 MinecraftForge\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u062b\u0628\u064a\u062a <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>\u0647\u0630\u0627 \u0627\u0644\u0631\u0627\u0628\u0637</a> \u0644\u0644\u062d\u0644.</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0641\u064a \u0638\u0644\u0627\u0644 \u0627\u0644\u062a\u0636\u0627\u0631\u064a\u0633 \u0645\u0639 \u0627\u0644\u0638\u0644\u0627\u0644 (shaders) \u0639\u0628\u0631 Iris.</b><p>\u064a\u062d\u062f\u062b \u0627\u0644\u0645\u0634\u0643\u0644 \u0623\u062b\u0646\u0627\u0621 \u0639\u0631\u0636 \u0627\u0644\u062a\u0636\u0627\u0631\u064a\u0633.</p><p>\u064a\u064f\u0648\u0635\u0649 \u0628\u0640 <b>\u062a\u062c\u0631\u0628\u0629 \u0627\u0644\u0644\u0639\u0628\u0629 \u0628\u062f\u0648\u0646 shaders</b> \u0623\u0648 \u062e\u0641\u0636 \u062c\u0648\u062f\u0629 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0627\u062a\u060c \u062e\u0627\u0635\u0629\u064b \u0641\u064a \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a <b>Ultra</b>.</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "\u0638\u0644\u0627\u0644 \u0627\u0644\u062a\u0636\u0627\u0631\u064a\u0633 (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062a\u064a\u0643 (tick) \u062e\u0627\u062f\u0645 \u0645\u0641\u0631\u0637 \u0641\u064a \u0627\u0644\u0637\u0648\u0644.</b><p>\u0647\u0630\u0627 \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0623\u0646 \u0627\u0644\u0644\u0639\u0628\u0629 \u062a\u0648\u0642\u0641\u062a \u0644\u0641\u062a\u0631\u0629 \u0637\u0648\u064a\u0644\u0629 \u062c\u062f\u064b\u0651\u0627 \u0641\u064a \u062a\u064a\u0643 \u0648\u0627\u062d\u062f.</p><p>\u064a\u064f\u0648\u0635\u0649 \u0628\u0640 <b>\u0645\u0631\u0627\u062c\u0639\u0629 thread dump</b> \u0627\u0644\u0645\u064f\u0646\u0634\u0623 \u0641\u064a \u0627\u0644\u0633\u062c\u0644 (log) \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0633\u0628\u0628.</p><p>\u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0633\u0627\u0639\u062f\u0643 <b>\u062a\u062d\u0644\u064a\u0644 Stack Trace</b> \u0641\u064a \u062a\u062d\u062f\u064a\u062f \u0645\u0635\u062f\u0631 \u0627\u0644\u062a\u0648\u0642\u0641.</p><p>\u0628\u0627\u0644\u0625\u0636\u0627\u0641\u0629 \u0625\u0644\u0649 \u0630\u0644\u0643\u060c \u0633\u064a\u064f\u0628\u0631\u0632 \u0632\u0631 <b>\u0639\u0631\u0636 \u0641\u064a \u0627\u0644\u0633\u062c\u0644</b> \u0628\u0627\u0644\u0644\u0648\u0646 \u0627\u0644\u0623\u062d\u0645\u0631 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629 \u0627\u0644\u0645\u0633\u0624\u0648\u0644\u0629\u060c \u0648\u0643\u0630\u0644\u0643 \u0627\u0644\u0625\u062f\u062e\u0627\u0644\u0627\u062a \u0627\u0644\u0645\u062d\u0627\u0637\u0629 \u0628\u0640 <code>$modid$</code>\u060c \u0627\u0644\u062a\u064a \u063a\u0627\u0644\u0628\u064b\u0627 \u0645\u0627 \u062a\u0634\u064a\u0631 \u0625\u0644\u0649 \u0645\u0635\u062f\u0631 \u0627\u0644\u0645\u0634\u0643\u0644\u0629. \u0648\u0644\u0644\u0645\u0633\u062d \u0641\u064a \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0641\u0639\u0644\u064a\u060c \u0646\u0648\u0635\u064a \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0639\u064a\u0651\u0646 CPU \u0641\u064a VisualVM. \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u062e\u0627\u062f\u0645\u0643 \u0623\u0648 \u062c\u0647\u0627\u0632\u0643 \u0642\u0648\u064a \u0628\u0645\u0627 \u064a\u0643\u0641\u064a \u0644\u0644\u062a\u0639\u0627\u0645\u0644 \u0645\u0639 \u0627\u0644\u0648\u062d\u062f\u0627\u062a \u0627\u0644\u062a\u064a \u062a\u0633\u062a\u062e\u062f\u0645\u0647\u0627\u060c \u0641\u0642\u062f \u062a\u0639\u0645\u0644 \u062c\u0645\u064a\u0639 \u0648\u062d\u062f\u0627\u062a\u0643 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d\u060c \u0644\u0643\u0646\u0643 \u0642\u062f \u062a\u0643\u0648\u0646 \u062a\u0633\u062a\u062e\u062f\u0645 \u0639\u062f\u062f\u064b\u0627 \u0643\u0628\u064a\u0631\u064b\u0627 \u0645\u0646\u0647\u0627.</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "\u062a\u064a\u0643 \u062e\u0627\u062f\u0645 \u0637\u0648\u064a\u0644";
    }

    @Override
    public String tituloLFPDPPP() {
        return "\u0627\u0644\u0642\u0627\u0646\u0648\u0646 \u0627\u0644\u0641\u064a\u062f\u0631\u0627\u0644\u064a \u0644\u062d\u0645\u0627\u064a\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0634\u062e\u0635\u064a\u0629 \u0644\u062f\u0649 \u0627\u0644\u0623\u0641\u0631\u0627\u062f";
    }

    @Override
    public String aceptarPermanentemente() {
        return "\u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0628\u0634\u0643\u0644 \u062f\u0627\u0626\u0645";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "\u062a\u062d\u062a\u0648\u064a \u0627\u0644\u062a\u0631\u062c\u0645\u0629 \u0627\u0644\u0643\u0648\u0631\u064a\u0629 \u0639\u0644\u0649 \u0645\u0635\u0637\u0644\u062d\u0627\u062a \u0639\u0627\u0645\u064a\u0629 \u0645\u0646 \u0627\u0644\u062c\u0646\u0648\u0628 \u064a\u062c\u0628 \u062a\u062c\u0646\u0628\u0647\u0627 \u0644\u0644\u0627\u0645\u062a\u062b\u0627\u0644 \u0644\u0644\u0642\u0627\u0646\u0648\u0646. \u064a\u064f\u062d\u0638\u064e\u0631 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0623\u062c\u0646\u0628\u064a\u0629\u060c \u0648\u062e\u0627\u0635\u0629 \u0627\u0644\u0642\u0627\u062f\u0645\u0629 \u0645\u0646 \u0627\u0644\u062c\u0646\u0648\u0628\u060c \u0628\u0634\u0643\u0644 \u0635\u0627\u0631\u0645 \u0648\u0641\u0642\u064b\u0627 \u0644\u0642\u0627\u0646\u0648\u0646 \u062d\u0645\u0627\u064a\u0629 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u062b\u0642\u0627\u0641\u064a\u0629 \u0641\u064a \u0628\u064a\u0648\u0646\u063a \u064a\u0627\u0646\u063a.";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "\u0644\u0645\u0632\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a\u060c \u0631\u0627\u062c\u0639 \u0627\u0644\u0648\u062b\u064a\u0642\u0629 \u0627\u0644\u0631\u0633\u0645\u064a\u0629 \u0644\u0644\u0642\u0627\u0646\u0648\u0646: <a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>\u0642\u0627\u0646\u0648\u0646 \u062d\u0645\u0627\u064a\u0629 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u062b\u0642\u0627\u0641\u064a\u0629 \u0641\u064a \u0628\u064a\u0648\u0646\u063a \u064a\u0627\u0646\u063a</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "\u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0642\u0627\u0646\u0648\u0646 \u0627\u0644\u0643\u0627\u0645\u0644";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "\u062e\u0637\u0623 \u0639\u0646\u062f \u0641\u062a\u062d \u0627\u0644\u0631\u0627\u0628\u0637";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "\u0642\u0627\u0646\u0648\u0646 \u062d\u0645\u0627\u064a\u0629 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u062b\u0642\u0627\u0641\u064a\u0629 \u0641\u064a \u0628\u064a\u0648\u0646\u063a \u064a\u0627\u0646\u063a";
    }

    @Override
    public String canarioTitulo() {
        return "\u0643\u0646\u0627\u0631\u064a \u0623\u0645\u0631 \u0642\u0636\u0627\u0626\u064a";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 \u062c\u0647\u0627\u0632 \u0645\u0631\u0627\u0642\u0628\u0629";
    }

    @Override
    public String revisar() {
        return "\u0645\u0631\u0627\u062c\u0639\u0629";
    }

    @Override
    public String cerrar() {
        return "\u0625\u063a\u0644\u0627\u0642";
    }

    @Override
    public String canarioTodoSeguro() {
        return "\u062c\u0645\u064a\u0639 \u0627\u0644\u062e\u062f\u0645\u0627\u062a \u062a\u064f\u0628\u0644\u063a \u0628\u062d\u0627\u0644\u0629 \u0622\u0645\u0646\u0629.";
    }

    @Override
    public String canarioComprometido(int c) {
        return "\u062a\u0646\u0628\u064a\u0647: " + c + " \u062e\u062f\u0645\u0629(\u062e\u062f\u0645\u0627\u062a) \u062a\u064f\u0628\u0644\u063a \u0628\u062d\u0627\u0644\u0629 \u063a\u064a\u0631 \u0622\u0645\u0646\u0629.";
    }

    @Override
    public String colorAlerta() {
        return "\u0644\u0648\u0646 \u0627\u0644\u062a\u0646\u0628\u064a\u0647";
    }

    @Override
    public String opcionesMunidiales() {
        return "\u062e\u064a\u0627\u0631\u0627\u062a \u0645\u0646\u064a\u062f\u064a\u0629";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "\u0645\u0648\u0627\u0641\u0642\u0629 LFPDPPP";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "\u062a\u0645\u0643\u064a\u0646 \u0646\u0642\u0644 \u0631\u0645\u0632 \u0627\u0644\u0648\u0635\u0648\u0644 \u0641\u064a Handoff \u0644\u0640 ReLauncher (\u063a\u064a\u0631 \u0645\u0648\u0635\u0649 \u0628\u0647).";
    }

    @Override
    public String consolaDesarrollo() {
        return "\u0648\u062d\u062f\u0629 \u062a\u062d\u0643\u0645 \u0627\u0644\u062a\u0637\u0648\u064a\u0631";
    }

    @Override
    public String mundial() {
        return "\u0639\u0627\u0644\u0645\u064a";
    }

    @Override
    public String ningun() {
        return "\u0644\u0627 \u0634\u064a\u0621";
    }

    public String consolaDesarrollador() {
        return "\u0648\u062d\u062f\u0629 \u062a\u062d\u0643\u0645 \u0627\u0644\u0645\u0637\u0648\u0631";
    }

    @Override
    public String bajar() {
        return "\u062a\u0646\u0632\u064a\u0644";
    }

    @Override
    public String logsSoporte() {
        return "\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u062f\u0639\u0645";
    }

    @Override
    public String detenerProceso() {
        return "\u0625\u064a\u0642\u0627\u0641 \u0627\u0644\u0639\u0645\u0644\u064a\u0629";
    }

    @Override
    public String copiarSeleccion() {
        return "\u0646\u0633\u062e \u0627\u0644\u062a\u062d\u062f\u064a\u062f";
    }

    @Override
    public String seleccionarTodo() {
        return "\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644";
    }

    @Override
    public String copiarTodo() {
        return "\u0646\u0633\u062e \u0627\u0644\u0643\u0644";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "\u062d\u0641\u0638 \u0627\u0644\u0643\u0644 \u0643\u0645\u0644\u0641";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "\u0627\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0631\u0627\u0628\u0637 \u0627\u0644\u062f\u0639\u0645";
    }

    @Override
    public String borrarTodo() {
        return "\u062d\u0630\u0641 \u0627\u0644\u0643\u0644";
    }

    public String colorFondoConsola() {
        return "\u0644\u0648\u0646 \u062e\u0644\u0641\u064a\u0629 \u0648\u062d\u062f\u0629 \u0627\u0644\u062a\u062d\u0643\u0645";
    }

    public String colorTextoConsola() {
        return "\u0644\u0648\u0646 \u0646\u0635 \u0648\u062d\u062f\u0629 \u0627\u0644\u062a\u062d\u0643\u0645";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "\u062a\u0645 \u062a\u0623\u0643\u064a\u062f \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629.\n\u0633\u064a\u062a\u0645 \u062a\u0646\u0641\u064a\u0630 \u0645\u064a\u0632\u0629 \u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0647\u0646\u0627.";
    }

    @Override
    public String usarSakuraOriginal() {
        return "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0635\u0648\u0631\u0629 Sakura Riddle \u0627\u0644\u0623\u0635\u0644\u064a\u0629";
    }

    @Override
    public String canario1984Descripcion() {
        return "\u00ab\u0643\u0646\u0627\u0631\u064a \u0623\u0645\u0631 \u0642\u0636\u0627\u0626\u064a\u00bb \u0647\u0648 \u0622\u0644\u064a\u0629 \u0634\u0641\u0627\u0641\u064a\u0629.\n\n\u0637\u0627\u0644\u0645\u0627 \u0623\u0646 \u0647\u0630\u0647 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0645\u0648\u062c\u0648\u062f\u0629 \u0648\u062a\u0638\u0647\u0631 \u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0639\u0644\u0649 \u0623\u0646\u0647\u0627 \u0622\u0645\u0646\u0629\u060c \u0641\u0647\u0630\u0627 \u064a\u0639\u0646\u064a \u0623\u0646 \u0627\u0644\u0645\u0634\u0631\u0648\u0639 \u0644\u0645 \u064a\u062a\u0644\u0642\u064e\u0651 \u0623\u064a \u0623\u0648\u0627\u0645\u0631 \u0642\u0636\u0627\u0626\u064a\u0629 \u0633\u0631\u064a\u0629\u060c \u0648\u0644\u0627 \u0637\u0644\u0628\u0627\u062a \u0631\u0642\u0627\u0628\u0629\u060c \u0648\u0644\u0627 \u0637\u0644\u0628\u0627\u062a \u0642\u0627\u0646\u0648\u0646\u064a\u0629 \u0644\u0644\u0645\u0631\u0627\u0642\u0628\u0629.\n\n\u0625\u0630\u0627 \u0627\u062e\u062a\u0641\u0649 \u0623\u062d\u062f \u0627\u0644\u0643\u0646\u0627\u0631\u064a\u0651\u0627\u062a \u0623\u0648 \u0638\u0647\u0631 \u0643\u063a\u064a\u0631 \u0622\u0645\u0646\u060c \u0641\u0630\u0644\u0643 \u064a\u0634\u064a\u0631 \u0625\u0644\u0649 \u062d\u062f\u0648\u062b \u062a\u063a\u064a\u064a\u0631 \u0642\u0627\u0646\u0648\u0646\u064a.\n\n\u062a\u0642\u0648\u0645 \u0647\u0630\u0647 \u0627\u0644\u0644\u0648\u062d\u0629 \u0628\u0645\u0631\u0627\u062c\u0639\u0629 \u062c\u0645\u064a\u0639 \u0627\u0644\u0643\u0646\u0627\u0631\u064a\u0651\u0627\u062a \u0627\u0644\u0645\u0633\u062c\u0651\u0644\u0629 \u0641\u064a \u0627\u0644\u0646\u0638\u0627\u0645 \u0648\u0639\u0631\u0636 \u062d\u0627\u0644\u062a\u0647\u0627 \u0627\u0644\u062d\u0627\u0644\u064a\u0629.\n\n\u0627\u0636\u063a\u0637 \u00ab\u0645\u0631\u0627\u062c\u0639\u0629\u00bb \u0644\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0627\u062a.";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\u0647\u0644 \u062a\u0631\u064a\u062f \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u062c\u0645\u064a\u0639 \u0627\u0644\u062e\u064a\u0627\u0631\u0627\u062a \u0625\u0644\u0649 \u0642\u064a\u0645\u0647\u0627 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629\u061f";
    }

    @Override
    public String gui() {
        return "\u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0629 (GUI)";
    }

    @Override
    public String sinOpciones() {
        return "\u0628\u062f\u0648\u0646 \u062e\u064a\u0627\u0631\u0627\u062a";
    }

    @Override
    public String seleccionaColor() {
        return "\u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0644\u0648\u0646";
    }

    @Override
    public String botonMostrarGUI() {
        return "\u0639\u0631\u0636 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0631\u0633\u0648\u0645\u064a\u0629";
    }

    @Override
    public String botonGuardarTodo() {
        return "\u062d\u0641\u0638 \u0627\u0644\u0643\u0644";
    }

    @Override
    public String botonRestablecerTodo() {
        return "\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0627\u0644\u0643\u0644";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "\u0644\u0645 \u064a\u062a\u0645 \u062a\u062d\u0645\u064a\u0644 LuckPerms";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u062a\u0637\u0628\u064a\u0642\u0627\u062a LuckPerms.</b><p>\u062a\u0634\u064a\u0631 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0625\u0644\u0649 \u0623\u0646 <b>LuckPerms \u0644\u0645 \u064a\u0643\u0646 \u0645\u062d\u0645\u0644\u064b\u0627</b> \u0641\u064a \u0627\u0644\u0644\u062d\u0638\u0629 \u0627\u0644\u062a\u064a \u062d\u0627\u0648\u0644 \u0641\u064a\u0647\u0627 \u0625\u0636\u0627\u0641\u0629\u064c \u0623\u062e\u0631\u0649 \u0627\u0633\u062a\u062e\u062f\u0627\u0645\u0647.</p><p><b>\u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0627\u0644\u0645\u062d\u062a\u0645\u0644\u0629:</b></p><ul><li>\u0625\u0645\u0651\u0627 \u0623\u0646 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 <b>LuckPerms \u063a\u064a\u0631 \u0645\u062b\u0628\u062a\u0629</b> \u0623\u0648 <b>\u0641\u0634\u0644\u062a \u0639\u0646\u062f \u0628\u062f\u0621 \u0627\u0644\u062a\u0634\u063a\u064a\u0644</b>.</li><li>\u0623\u0648 \u0623\u0646 \u0625\u0636\u0627\u0641\u0629\u064b \u0623\u062e\u0631\u0649 \u062a\u062d\u0627\u0648\u0644 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 LuckPerms <b>\u0645\u0628\u0643\u0631\u064b\u0627 \u062c\u062f\u064b\u0651\u0627</b> \u0623\u0648 <b>\u0628\u0637\u0631\u064a\u0642\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629</b>.</li></ul><p>\u0646\u0648\u0635\u064a \u0628\u0640<b>\u0645\u0631\u0627\u062c\u0639\u0629 \u0633\u062c\u0644\u0651 \u0627\u0644\u062e\u0627\u062f\u0645 (\u0627\u0644\u0643\u0648\u0646\u0633\u0648\u0644)</b> \u0639\u0628\u0631 \u0627\u0644\u0631\u0627\u0628\u0637 \u0644\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u062a\u064a \u062a\u0633\u062a\u062f\u0639\u064a LuckPerms \u0648\u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u062a\u0648\u0627\u0641\u0642\u0647\u0627.</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "\u062d\u0632\u0645\u0629 \u0627\u0644\u0638\u0644\u0627\u0644 (Shaderpack) \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0640 Iris \u063a\u064a\u0631 \u0645\u062d\u0645\u0644\u0629";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "\u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062a\u0645 \u0627\u0643\u062a\u0634\u0627\u0641 \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062a\u062d\u0645\u064a\u0644 \u062d\u0632\u0645\u0629 \u0638\u0644\u0627\u0644 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 Iris/Oculus.</b><p><b>\u062d\u0632\u0645\u0629 \u0627\u0644\u0638\u0644\u0627\u0644 \u0627\u0644\u0645\u062a\u0623\u062b\u0631\u0629:</b> " + nombre + "</p><p>\u0644\u0645 \u064a\u062a\u0645\u0643\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0645\u0646 \u0641\u062a\u062d \u0645\u0644\u0641 \u062d\u0632\u0645\u0629 \u0627\u0644\u0638\u0644\u0627\u0644 (FileSystemNotFoundException).</p><p><b>\u062d\u0644\u0648\u0644 \u0645\u0645\u0643\u0646\u0629:</b></p><ul><li>\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u062d\u0632\u0645\u0629 \u0627\u0644\u0638\u0644\u0627\u0644 \u0645\u062b\u0628\u062a\u0629 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d \u0641\u064a \u0645\u062c\u0644\u062f <b>shaderpacks</b>.</li><li>\u0623\u0639\u062f \u062a\u0646\u0632\u064a\u0644 \u062d\u0632\u0645\u0629 \u0627\u0644\u0638\u0644\u0627\u0644\u060c \u0641\u0642\u062f \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0644\u0641 \u062a\u0627\u0644\u0641\u064b\u0627.</li><li>\u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0627\u062d\u0630\u0641 \u0627\u0644\u0645\u0644\u0641 <b>config/iris.properties</b> \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0625\u0639\u062f\u0627\u062f\u0627\u062a Iris.</li></ul><p>\u0628\u0639\u062f \u062a\u0637\u0628\u064a\u0642 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a\u060c \u0623\u0639\u062f \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0644\u0639\u0628\u0629.</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "\u062a\u0639\u0630\u0651\u0631 \u0643\u062a\u0627\u0628\u0629 \u0645\u0644\u0641 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "\u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062d\u0641\u0638 \u0645\u0644\u0641 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a.</b><p><b>\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0645\u062a\u0623\u062b\u0631:</b> " + archivo + "</p><p>\u0644\u0645 \u064a\u062a\u0645\u0643\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0645\u0646 \u0643\u062a\u0627\u0628\u0629 \u0627\u0644\u0645\u0644\u0641 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0643\u062a\u0627\u0628\u0629 \u0627\u0644\u0630\u0631\u064a\u0629 (REPLACE_ATOMIC).</p><p><b>\u0647\u0630\u0627 \u064a\u062d\u062f\u062b \u0639\u0627\u062f\u0629\u064b \u0628\u0633\u0628\u0628:</b></p><ul><li>\u0623\u0630\u0648\u0646\u0627\u062a \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 \u0639\u0644\u0649 \u0627\u0644\u0645\u062c\u0644\u062f \u0623\u0648 \u0627\u0644\u0645\u0644\u0641.</li><li>\u0627\u0644\u0645\u0644\u0641 \u0645\u064f\u0639\u0644\u064e\u0651\u0645 \u0643\u0640\"\u0644\u0644\u0642\u0631\u0627\u0621\u0629 \u0641\u0642\u0637\".</li><li>\u0628\u0631\u0646\u0627\u0645\u062c \u0622\u062e\u0631 (\u0645\u0636\u0627\u062f \u0641\u064a\u0631\u0648\u0633\u0627\u062a\u060c \u0646\u0633\u062e \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u060c \u0645\u062d\u0631\u0631) \u064a\u0645\u0646\u0639 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0627\u0644\u0645\u0644\u0641.</li></ul><p><b>\u0627\u0644\u062a\u0648\u0635\u064a\u0627\u062a:</b></p><ul><li>\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u0644\u062f\u064a\u0643 \u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u0643\u062a\u0627\u0628\u0629 \u0641\u064a \u0627\u0644\u0645\u062c\u0644\u062f.</li><li>\u0623\u0632\u0644 \u062e\u0627\u0635\u064a\u0629 \"\u0627\u0644\u0642\u0631\u0627\u0621\u0629 \u0641\u0642\u0637\" \u0645\u0646 \u0627\u0644\u0645\u0644\u0641.</li><li>\u0623\u063a\u0644\u0642 \u0627\u0644\u0628\u0631\u0627\u0645\u062c \u0627\u0644\u062a\u064a \u0642\u062f \u062a\u0643\u0648\u0646 \u062a\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0627\u0644\u0645\u0644\u0641.</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "\u062a\u0645 \u0631\u0641\u0636 \u0627\u0644\u0648\u0635\u0648\u0644 \u0639\u0646\u062f \u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062e\u0629 \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "\u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641" : origen;
        String dst = backup == null || backup.isEmpty() ? "\u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062d\u062f\u062b \u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0623\u0630\u0648\u0646\u0627\u062a \u0623\u062b\u0646\u0627\u0621 \u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062e\u0629 \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0645\u0646 \u0645\u0644\u0641 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a.</b><p><b>\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0623\u0635\u0644\u064a:</b> " + src + "</p><p><b>\u0645\u0644\u0641 \u0627\u0644\u0646\u0633\u062e\u0629 \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629:</b> " + dst + "</p><p>\u0644\u0642\u062f \u0642\u0627\u0645 \u0646\u0638\u0627\u0645 \u0627\u0644\u062a\u0634\u063a\u064a\u0644 \u0628\u062d\u0638\u0631 \u0627\u0644\u0648\u0635\u0648\u0644 \u0623\u062b\u0646\u0627\u0621 \u062d\u0641\u0638 \u0627\u0644\u0645\u0644\u0641.</p><p><b>\u0647\u0630\u0627 \u064a\u062d\u062f\u062b \u0639\u0627\u062f\u0629\u064b \u0628\u0633\u0628\u0628:</b></p><ul><li>\u0623\u0630\u0648\u0646\u0627\u062a \u063a\u064a\u0631 \u0643\u0627\u0641\u064a\u0629 \u0641\u064a \u0627\u0644\u0645\u062c\u0644\u062f.</li><li>\u0627\u0644\u0645\u0644\u0641 \u0645\u064f\u0639\u0644\u064e\u0651\u0645 \u0643\u0640\"\u0644\u0644\u0642\u0631\u0627\u0621\u0629 \u0641\u0642\u0637\".</li><li>\u0628\u0631\u0646\u0627\u0645\u062c \u0622\u062e\u0631 (\u0645\u0636\u0627\u062f \u0641\u064a\u0631\u0648\u0633\u0627\u062a\u060c \u0645\u0632\u0627\u0645\u0646\u0629\u060c \u0645\u062d\u0631\u0631) \u064a\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0645\u0644\u0641 \u062d\u0627\u0644\u064a\u064b\u0627.</li></ul><p><b>\u0627\u0644\u062a\u0648\u0635\u064a\u0627\u062a:</b></p><ul><li>\u062a\u062d\u0642\u0642 \u0645\u0646 \u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u0645\u062c\u0644\u062f <b>config</b>.</li><li>\u0623\u063a\u0644\u0642 \u0627\u0644\u0628\u0631\u0627\u0645\u062c \u0627\u0644\u062a\u064a \u0642\u062f \u062a\u0643\u0648\u0646 \u062a\u0635\u0644 \u0625\u0644\u0649 \u0627\u0644\u0645\u0644\u0641.</li><li>\u062d\u0627\u0648\u0644 \u062a\u0634\u063a\u064a\u0644 \u0627\u0644\u0645\u0634\u063a\u0651\u0644 \u0623\u0648 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0643\u0645\u0633\u0624\u0648\u0644 (administrator).</li></ul>";
    }
}

