/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Chino
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u65e0\u6548\u7684mods\u6587\u4ef6\u5939</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u627e\u4e0d\u5230CrashDetector\u7684JAR\u6587\u4ef6</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u6b63\u5728\u67e5\u627ePID: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") \u5df2\u7ec8\u6b62\uff01</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u6ca1\u6709JVM</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u66f4\u65b0\u60a8\u7684 ATI/AMD \u9a71\u52a8\u7a0b\u5e8f\u53ef\u80fd\u4f1a\u6709\u6240\u5e2e\u52a9\u3002\u8bf7\u9605\u8bfb\u6b64\u6307\u5357\u4ee5\u89e3\u51b3\u95ee\u9898: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u9a71\u52a8\u7a0b\u5e8f\u66f4\u65b0\u6307\u5357</a> https://www.amd.com/zh-cn/support/download/drivers.html \u4e0b\u8f7d </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u67d0\u4e9b\u65e7\u7248\u672c\u5728Nouveau\u663e\u5361\u7684\u65e9\u671f\u52a0\u8f7d\u754c\u9762\u6709\u65f6\u4f1a\u51fa\u73b0\u95ee\u9898\u3002</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u7684\u663e\u5361\u9a71\u52a8\u5b58\u5728\u95ee\u9898\u3002\u5982\u679c\u60a8\u4f7f\u7528AMD/ATI\u7684GPU\u6216APU\uff0c\u8bf7\u66f4\u65b0AMD\u663e\u5361\u9a71\u52a8\u3002\u5982\u679c\u60a8\u4f7f\u7528NVIDIA\u663e\u5361\uff0c\u8bf7\u786e\u4fdd\u5c06\u6e38\u620f\u548c\u6240\u6709javaw.exe\u5b9e\u4f8b\u8bbe\u7f6e\u4e3a\u4f7f\u7528\u72ec\u7acb\u663e\u5361\u3002\u9605\u8bfb\u6b64\u6307\u5357\uff1a <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u9a71\u52a8\u7a0b\u5e8f\u66f4\u65b0\u6307\u5357</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u7684FML\u65e9\u671f\u7a97\u53e3\u52a0\u8f7d\u5931\u8d25\u3002\u8981\u4fee\u590d\u6b64\u95ee\u9898\uff0c\u8bf7\u8f6c\u5230(.minecraft/config/fml.toml)\u5e76\u5c06earlyWindowProvider\u8bbe\u7f6e\u4e3a\"none\"\u3002\u5982\u679c\u60a8\u4f7f\u7528\u7684\u662fMac M1\uff0c\u8bf7\u786e\u4fdd\u4f7f\u7528\u7684\u662fARM\u7248Java\uff0c\u800c\u975eIntel x64\u7248\u3002\u8fd9\u4e5f\u662f\u9a71\u52a8\u7a0b\u5e8f\u8fc7\u65f6\u7684\u5e38\u89c1\u95ee\u9898\u3002\u5982\u679c\u60a8\u4f7f\u7528\u7684\u662fWindows\u4e14\u7981\u7528\u6b64\u8bbe\u7f6e\u65e0\u6548\uff0c\u8bf7\u67e5\u9605\u6b64\u6307\u5357\uff1a <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u9a71\u52a8\u7a0b\u5e8f\u66f4\u65b0\u6307\u5357</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u7f3a\u5c11\u5fc5\u8981\u7684\u4f9d\u8d56\u9879\uff1a</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "\u8bf7\u6c42\u81ea").replace("Expected range", "\u9884\u671f\u8303\u56f4") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u60a8\u7684CrashDetector\u62a5\u544a\u5728\u6b64 <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>\u67e5\u770b\u62a5\u544a</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u8fd9\u662fCrashDetector\u7684GUI\u754c\u9762\u3002\u5982\u679c\u6e38\u620f\u6b63\u5e38\u5173\u95ed\uff0c\u8bf7\u5ffd\u7565\u6b64\u754c\u9762\u3002</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>\u67e5\u770b\u62a5\u544a</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u5728\u6d4f\u89c8\u5668\u4e2d\u67e5\u770b\u672c\u5730\u62a5\u544a\u3002</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "\u5206\u4eab\u62a5\u544a";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "\u5206\u4eab\u62a5\u544a\u3002\u60a8\u7684\u65e5\u5fd7\u5c06\u4e0a\u4f20\u81f3securelogger.net\uff0c\u62a5\u544a\u5c06\u4e0a\u4f20\u81f3\u5176\u4ed6\u7ad9\u70b9\u3002";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u6709\u95ee\u9898\u7684JAR\u6587\u4ef6\uff08\u4f18\u5148\u5904\u7406FATAL\uff0c\u7136\u540e\u662f\u9ad8\u4f18\u5148\u7ea7\u548c\u4f4e\u4f18\u5148\u7ea7\uff09\uff1a</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> \u7b49\u7ea7\uff1a</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u53ef\u80fd\u81f4\u547d\uff1a</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u6709\u95ee\u9898\u7684ModID\uff08\u4f18\u5148\u5904\u7406FATAL\uff0c\u7136\u540e\u662f\u4f4e\u4f18\u5148\u7ea7\u548c\u4f4e\u4f18\u5148\u7ea7\uff09\uff1a</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u6709\u95ee\u9898\u7684\u5305\uff08\u4f18\u5148\u5904\u7406FATAL\uff0c\u7136\u540e\u662f\u4f4e\u4f18\u5148\u7ea7\u548c\u4f4e\u4f18\u5148\u7ea7\uff09\uff1a</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u81f4\u547d\u7c7b\u9519\u8bef\uff08FATAL\uff09\uff0c\u95ee\u9898\u975e\u5e38\u4e25\u91cd\u3002\u5e38\u89c1\u539f\u56e0\u5305\u62ec\u9519\u8bef\u7684 CoreMod \u6216\u81f4\u547d\u7684\u4f9d\u8d56\u9879\u3002\u60a8\u53ef\u4ee5\u4f7f\u7528 QuickFix \u626b\u63cf\u5305\u542b\u81f4\u547d\u7c7b\u7684\u6a21\u7ec4\u3002\u68c0\u6d4b\u5230\u7f3a\u5931\u7684\u81f4\u547d\u7c7b\uff1a</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5728{}\u4e2d\u7684\u5185\u5bb9\uff08\u6700\u91cd\u8981\u7684\u5728\u4e0a\u65b9\uff0c\u4ec5\u663e\u793a\u524d20\u4e2a\uff09\uff1a</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u6709\u95ee\u9898\u7684SpongeMixin\u914d\u7f6e\uff1a </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u6709\u5305\u542b\u91cd\u590d\u5305\u7684\u6a21\u7ec4\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u4ece JAR \u6587\u4ef6\u4e2d\u5220\u9664\u91cd\u590d\u7684\u5305\uff08\u6587\u4ef6\u5939\uff09\u6765\u89e3\u51b3\u6b64\u95ee\u9898\u3002\u4f60\u53ef\u4ee5\u4f7f\u7528 WinRAR \u6216 7z \u7b49\u538b\u7f29\u8f6f\u4ef6\u6253\u5f00 JAR \u6587\u4ef6\uff0c\u4e5f\u53ef\u4ee5\u5c06\u6587\u4ef6\u6269\u5c55\u540d\u4ece .jar \u6539\u4e3a .zip\uff0c\u7136\u540e\u5220\u9664\u6587\u4ef6\u5939\uff0c\u518d\u5c06\u5176\u6539\u56de .jar \u6269\u5c55\u540d\u3002</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u91cd\u590d\u7684Mods</b> " + linea.replace("from mod files", "\u6765\u81eamod\u6587\u4ef6");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge\u68c0\u6d4b\u5230\u53ef\u7591mod\u5b58\u5728\u95ee\u9898\uff1a</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV\u9700\u8981lithostitched\uff0c\u60a8\u53ef\u4ee5\u5728\u6b64\u5b89\u88c5\uff1a <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8981\u4f7f\u7528Iris\u7740\u8272\u5668\u6216Oculus\uff0c\u60a8\u9700\u8981SODIUM\u6216\u5176\u4ed6\u52a0\u8f7d\u5668\u7684\u517c\u5bb9\u7248\u672c\uff08Rubidium, Embedium, Bedium\uff09</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>KubeJS\u6269\u5c55\u5b58\u5728\u95ee\u9898 </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230Windows 11\u4e4b\u524d\u7248\u672c\u7684NVIDIA\u9a71\u52a8\u7a0b\u5e8f\u5b58\u5728\u95ee\u9898\u3002</span><br/><br/>\u4e3a\u786e\u4fddMinecraft\uff08\u4ee5\u53ca\u5f53\u524d\u7684JVM\uff09\u4f7f\u7528\u4e13\u7528\u7684NVIDIA GPU\uff0c\u8bf7\u6309\u7167\u4ee5\u4e0b\u6b65\u9aa4\u64cd\u4f5c\uff1a<br/><br/>1. <strong>\u8bc6\u522bJava\u53ef\u6267\u884c\u6587\u4ef6\uff1a</strong><br/>   - \u6b64\u7a0b\u5e8f\u6b63\u5728\u4f7f\u7528\u4ee5\u4e0bJava\u53ef\u6267\u884c\u6587\u4ef6\uff1a " + this.obtenerRutaJava() + "<br/>   - \u5982\u679c\u6ca1\u6709\u770b\u5230\u5177\u4f53\u8def\u5f84\uff0c\u53ef\u4ee5\u901a\u8fc7\u5728\u7cfb\u7edf\u4e2d\u641c\u7d22'java.exe'\u627e\u5230Java\u53ef\u6267\u884c\u6587\u4ef6\u3002<br/><br/>2. <strong>\u6253\u5f00NVIDIA\u63a7\u5236\u9762\u677f\uff1a</strong><br/>   - \u53f3\u952e\u5355\u51fb\u684c\u9762\u5e76\u9009\u62e9'NVIDIA\u63a7\u5236\u9762\u677f'\u3002<br/><br/>3. <strong>\u914d\u7f6e\u9996\u9009GPU\uff1a</strong><br/>   - \u5728NVIDIA\u63a7\u5236\u9762\u677f\u4e2d\uff0c\u8f6c\u5230'\u7ba1\u74063D\u8bbe\u7f6e'\u3002<br/>   - \u9009\u62e9'\u7a0b\u5e8f\u8bbe\u7f6e'\u9009\u9879\u3002<br/>   - \u70b9\u51fb'\u6dfb\u52a0'\u5e76\u627e\u5230\u4e4b\u524d\u8bc6\u522b\u7684Java\u53ef\u6267\u884c\u6587\u4ef6\uff08\u4f8b\u5982\uff1a'java.exe'\uff09\u3002<br/>   - \u786e\u4fdd\u5b83\u5df2\u8bbe\u7f6e\u4e3a\u4f7f\u7528'\u9ad8\u6027\u80fdNVIDIA\u5904\u7406\u5668'\u3002<br/><br/>4. <strong>\u4fdd\u5b58\u66f4\u6539\uff1a</strong><br/>   - \u5e94\u7528\u66f4\u6539\u5e76\u5173\u95edNVIDIA\u63a7\u5236\u9762\u677f\u3002<br/><br/>5. <strong>\u91cd\u65b0\u542f\u52a8Minecraft\uff1a</strong><br/>   - \u91cd\u65b0\u542f\u52a8Minecraft\u4ee5\u4f7f\u66f4\u6539\u751f\u6548\u3002<br/><br/>\u5982\u679c\u60a8\u4f7f\u7528\u7684\u662fWindows Server 2022\u6216Windows 10\uff0c\u53ea\u8981\u5b89\u88c5\u4e86\u6700\u65b0\u7684NVIDIA\u9a71\u52a8\u7a0b\u5e8f\uff0c\u8fd9\u4e9b\u6b65\u9aa4\u5747\u6709\u6548\u3002<br/><br/>\u6ce8\u610f\uff1a\u5982\u679c\u627e\u4e0d\u5230NVIDIA\u63a7\u5236\u9762\u677f\uff0c\u8bf7\u786e\u4fddNVIDIA\u9a71\u52a8\u7a0b\u5e8f\u5df2\u6b63\u786e\u5b89\u88c5\u3002";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230Windows 11/Server 2025\u6216\u66f4\u9ad8\u7248\u672c\u7684NVIDIA\u9a71\u52a8\u7a0b\u5e8f\u5b58\u5728\u95ee\u9898\u3002</span><br/><br/>\u4e3a\u786e\u4fddMinecraft\uff08\u4ee5\u53ca\u5f53\u524d\u7684JVM\uff09\u4f7f\u7528\u4e13\u7528\u7684NVIDIA GPU\uff0c\u8bf7\u6309\u7167\u4ee5\u4e0b\u6b65\u9aa4\u64cd\u4f5c\uff1a<br/><br/>1. <strong>\u8bc6\u522bJava\u53ef\u6267\u884c\u6587\u4ef6\uff1a</strong><br/>   - \u6b64\u7a0b\u5e8f\u6b63\u5728\u4f7f\u7528\u4ee5\u4e0bJava\u53ef\u6267\u884c\u6587\u4ef6\uff1a " + this.obtenerRutaJava() + "<br/>   - \u5982\u679c\u6ca1\u6709\u770b\u5230\u5177\u4f53\u8def\u5f84\uff0c\u53ef\u4ee5\u901a\u8fc7\u5728\u7cfb\u7edf\u4e2d\u641c\u7d22'java.exe'\u627e\u5230Java\u53ef\u6267\u884c\u6587\u4ef6\u3002<br/><br/>2. <strong>\u6253\u5f00\u8bbe\u7f6e\u5e94\u7528\uff1a</strong><br/>   - \u6309\u4e0b<code>Win + I</code>\u952e\u6253\u5f00\u8bbe\u7f6e\u5e94\u7528\u3002<br/>   - \u5bfc\u822a\u81f3<strong>\u7cfb\u7edf > \u663e\u793a > \u56fe\u5f62</strong>\u3002<br/><br/>3. <strong>\u914d\u7f6e\u9996\u9009GPU\uff1a</strong><br/>   - \u5728'\u56fe\u5f62'\u90e8\u5206\uff0c\u70b9\u51fb'\u9ed8\u8ba4\u56fe\u5f62\u8bbe\u7f6e'\u3002<br/>   - \u9009\u62e9'\u684c\u9762\u5e94\u7528'\uff0c\u7136\u540e\u70b9\u51fb'\u6d4f\u89c8'\u3002<br/>   - \u627e\u5230\u5e76\u9009\u62e9\u4e4b\u524d\u8bc6\u522b\u7684Java\u53ef\u6267\u884c\u6587\u4ef6\uff08\u4f8b\u5982\uff1a'java.exe'\uff09\u3002<br/>   - \u6dfb\u52a0\u540e\uff0c\u5728\u5217\u8868\u4e2d\u9009\u62e9Java\u5e94\u7528\u7a0b\u5e8f\uff0c\u5e76\u5c06\u5176\u914d\u7f6e\u4e3a\u4f7f\u7528'\u9ad8\u6027\u80fd\uff08NVIDIA\uff09'\u3002<br/><br/>4. <strong>\u4fdd\u5b58\u66f4\u6539\uff1a</strong><br/>   - \u5e94\u7528\u66f4\u6539\u5e76\u5173\u95ed\u8bbe\u7f6e\u5e94\u7528\u3002<br/><br/>5. <strong>\u91cd\u65b0\u542f\u52a8Minecraft\uff1a</strong><br/>   - \u91cd\u65b0\u542f\u52a8Minecraft\u4ee5\u4f7f\u66f4\u6539\u751f\u6548\u3002<br/><br/>\u5982\u679c\u60a8\u4f7f\u7528\u7684\u662fWindows 11\u6216Windows Server 2025+\uff0c\u53ea\u8981\u5b89\u88c5\u4e86\u6700\u65b0\u7684NVIDIA\u9a71\u52a8\u7a0b\u5e8f\uff0c\u8fd9\u4e9b\u6b65\u9aa4\u5747\u6709\u6548\u3002<br/><br/>\u6ce8\u610f\uff1a\u5982\u679c\u627e\u4e0d\u5230\u56fe\u5f62\u8bbe\u7f6e\u9009\u9879\uff0c\u8bf7\u786e\u4fddNVIDIA\u9a71\u52a8\u7a0b\u5e8f\u5df2\u6b63\u786e\u5b89\u88c5\u3002";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u7684\u670d\u52a1\u5668\u6216\u4e16\u754c\u6709\u8d85\u8fc760\u79d2\u7684\u5361\u987f\u3002\u8fd9\u53ef\u80fd\u662f\u7531\u4e8e\u6a21\u7ec4\u5bfc\u81f4\u670d\u52a1\u5668\u53d8\u6162\uff0c\u6216\u8005\u786c\u4ef6\u6027\u80fd\u4e0d\u8db3\u3002</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u6ca1\u6709\u8db3\u591f\u7684RAM/\u5185\u5b58\u3002\u9700\u8981\u5206\u914d\u66f4\u591a\u5185\u5b58\u3002</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Theseus \u8fd8\u5b58\u5728\u5176\u4ed6\u95ee\u9898\uff0c\u5305\u62ec\u5728\u5c1d\u8bd5\u5220\u9664\u6a21\u7ec4\u65f6\u4f1a\u5931\u8d25\u3002\u5982\u679c\u4f60\u9700\u8981\u8fd0\u884c mrpack \u6587\u4ef6\uff0c\u53ef\u4ee5\u4f7f\u7528\u5176\u4ed6\u542f\u52a8\u5668\uff0c\u4f8b\u5982 Prism Launcher\uff08\u4ec5\u652f\u6301 modrinth.com\uff09\u3001ATLauncher\uff08\u4ec5\u652f\u6301 modrinth.com\uff09\u6216 Hello Minecraft Launcher\uff08\u652f\u6301 modrinth.com \u548c bbsmc.net\uff09\u3002</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u4f60\u6b63\u5728\u4f7f\u7528\u201c\u8df3\u8fc7\u542f\u52a8\u5668\u542f\u52a8\u201d\uff08CurseForge \u5e94\u7528\uff09\u3002\u8fd9\u6709\u65f6\u4f1a\u5bfc\u81f4\u96be\u4ee5\u68c0\u6d4b\u7684\u95ee\u9898\u3002\u6b64\u9009\u9879\u5b58\u5728\u4e8e\u65e7\u7248 CurseForge \u5e94\u7528\u6216\u65b0\u7248\u4e2d\u3002\u8bf7\u7981\u7528\u5b83\uff0c\u5e76\u5728 CurseForge \u8bbe\u7f6e\u4e2d\u6539\u7528\u201cMojang \u542f\u52a8\u5668\u201d\u3002\u4f60\u53ef\u4ee5\u5728 Claws of Berk \u7684\u82f1\u6587\u89c6\u9891\u4e2d\u67e5\u770b\u8bf4\u660e\uff08\u8df3\u8f6c\u81f3 1:11\uff09<a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>\u70b9\u51fb\u6b64\u5904</a>.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u8b66\u544a\uff1a\u68c0\u6d4b\u5230\u7f3a\u5931\u7684\u7c7b\uff08\u8b66\u544a\u7ea7\u522b\uff09\u3002\u901a\u5e38\u95ee\u9898\u4e0d\u5927\uff0c\u4f46\u5e76\u975e\u603b\u662f\u5b89\u5168\uff0c\u4e0e\u201c\u81f4\u547d\u7c7b\u7f3a\u5931\u201d\u4e0d\u540c\u3002\u5e38\u89c1\u539f\u56e0\u5305\u62ec\u9519\u8bef\u7684 CoreMod \u6216\u7f3a\u5931\u4f9d\u8d56\u9879\u3002\u60a8\u53ef\u4ee5\u4f7f\u7528 QuickFix \u626b\u63cf\u5305\u542b\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002\u68c0\u6d4b\u5230\u7684\u7f3a\u5931\u7c7b\uff1a</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u65e0\u7ed3\u679c</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u65e5\u5fd7\u4f4d\u7f6e:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u8fd9\u662f\u4f60\u7684\u68c0\u67e5\u7ed3\u679c\u3002\u8bf7\u6162\u6162\u5206\u6790\uff0c\u901a\u5e38\u771f\u6b63\u7684\u539f\u56e0\u5728\u68c0\u67e51\u62162\u4e2d\u3002\u540e\u9762\u7684\uff08\u9519\u8bef3\u53ca\u4ee5\u4e0a\uff09\u53ef\u7528\u4e8e\u786e\u8ba4\uff0c\u4f46\u901a\u5e38\u662f\u8fde\u9501\u9519\u8bef\uff0c\u53ef\u4ee5\u5ffd\u7565\u3002\u6545\u969c\u662f\u5206\u5c42\u53d1\u751f\u7684\uff0c\u56e0\u6b64\u89e3\u51b3\u6839\u672c\u95ee\u9898\u4f1a\u4fee\u590d\u6b64\u7279\u5b9a\u9519\u8bef\u3002\u7136\u800c\uff0c\u660e\u5929\u53ef\u80fd\u4f1a\u51fa\u73b0\u4e00\u4e2a\u4e0e\u5f53\u524d\u9519\u8bef\u65e0\u5173\u7684\u65b0\u9519\u8bef\uff0c\u56e0\u4e3a\u4e00\u4e2a\u9519\u8bef\u5e38\u5e38\u4f1a\u963b\u6b62\u53e6\u4e00\u4e2a\u9519\u8bef\u5728\u63a7\u5236\u53f0\u4e2d\u663e\u793a\u3002</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8bf7\u4f7f\u7528Java 17\u7528\u4e8e1.17-1.20.4\u7248\u672c\uff0c\u4f7f\u7528Java 21\u7528\u4e8e\u66f4\u65b0\u7684\u7248\u672c\u3002\u5bf9\u4e8e\u66f4\u65e7\u7684\u7248\u672c\uff0c\u8bf7\u4f7f\u7528Java 8\u3002[\u6307\u5357](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). \u5982\u679c\u4ecd\u7136\u6709\u95ee\u9898\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u67d0\u4e9b\u6a21\u7ec4\u6587\u4ef6\u592a\u65b0\u6216\u592a\u65e7\u3002</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u7531\u4e8eASM\u8fc7\u65f6\uff0cJava 22\u53ca\u4ee5\u4e0a\u7248\u672c\u57281.20.5\u4ee5\u4e0b\u7684Minecraft\u7248\u672c\u4e2d\u65e0\u6cd5\u4e0e\u5927\u591a\u6570\u6a21\u7ec4\u52a0\u8f7d\u5668\u517c\u5bb9\u3002</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java\u5df2\u8fc7\u65f6 </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u9700\u8981\u4ece " + submod + " \u83b7\u53d6 JPMS \u6a21\u5757 " + mod_necesitas + "</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u65e0\u6cd5\u8c03\u7528 " + metodo + "\uff0c\u56e0\u4e3a " + objeto + " \u4e3a null</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "\u9ad8\u7ea7\u5206\u6790";
    }

    @Override
    public String seleccionarCarpeta() {
        return "\u9009\u62e9\u6587\u4ef6\u5939";
    }

    @Override
    public String cadenaBusqueda() {
        return "\u641c\u7d22\u5b57\u7b26\u4e32";
    }

    @Override
    public String usarRegex() {
        return "\u4f7f\u7528\u6b63\u5219\u8868\u8fbe\u5f0f";
    }

    @Override
    public String ignorarMayusculas() {
        return "\u5ffd\u7565\u5927\u5c0f\u5199";
    }

    @Override
    public String buscar() {
        return "\u641c\u7d22";
    }

    @Override
    public String busquedaEnProgreso() {
        return "\u641c\u7d22\u8fdb\u884c\u4e2d";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "\u672a\u627e\u5230\u7ed3\u679c";
    }

    @Override
    public String errorBusqueda() {
        return "\u641c\u7d22\u9519\u8bef";
    }

    @Override
    public String omitirYCerrar() {
        return "\u8df3\u8fc7\u5e76\u5173\u95ed";
    }

    @Override
    public String guardarYCerrar() {
        return "\u4fdd\u5b58\u5e76\u5173\u95ed";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "\u5c06\u65e5\u5fd7\u7c98\u8d34\u5230\u8fd9\u91cc";
    }

    @Override
    public String archivo() {
        return "\u6587\u4ef6";
    }

    @Override
    public String incluir() {
        return "\u5305\u542b";
    }

    @Override
    public String abrir() {
        return "\u6253\u5f00";
    }

    @Override
    public String endpointDeInforme() {
        return "\u62a5\u544a\u7aef\u70b9";
    }

    @Override
    public String sitoDeLogging() {
        return "\u65e5\u5fd7\u7ad9\u70b9\uff1a";
    }

    @Override
    public String apiDeLogging() {
        return "\u65e5\u5fd7API\uff1a";
    }

    @Override
    public String anonimizarRegistros() {
        return "\u533f\u540d\u5316\u65e5\u5fd7 (\u6d4b\u8bd5\u7248)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "\u5206\u4eab\u62a5\u544a\u53ca\u6240\u6709\u9009\u5b9a\u65e5\u5fd7";
    }

    @Override
    public String arco() {
        return "\u6b64\u5bf9\u8bdd\u6846\u5141\u8bb8\u4f60\u901a\u8fc7 SecureLogger API \u5728 <a href=\"https://securelogger.net\">securelogger.net</a> \u5206\u4eab\u65e5\u5fd7\u3002\u70b9\u51fb\u201c\u5206\u4eab\u62a5\u544a\u201d\u6309\u94ae\u540e\uff0c\u4f60\u7684\u62a5\u544a\u5c06\u53d1\u9001\u81f3\u6240\u9009\u7aef\u70b9\uff08\u9ed8\u8ba4\u4e3a asbestosstar.egoism.jp\uff09\uff08\u53ef\u5728\u5e95\u90e8\u66f4\u6539\uff09\u3002\u4f60\u53ef\u4ee5\u5c06\u6240\u6709\u9009\u4e2d\u7684\u65e5\u5fd7\u4e0e\u62a5\u544a\u4e00\u5e76\u5206\u4eab\u3002\u5982\u679c\u4f60\u4e0d\u60f3\u4e0a\u4f20\uff0c\u8bf7\u52ff\u4f7f\u7528\u6b64\u5bf9\u8bdd\u6846\uff01\u6211\u4eec\u4e0d\u4f1a\u5728\u5b98\u65b9\u7aef\u70b9\u5904\u7406\u4f60\u7684\u62a5\u544a\uff08<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>\uff09\uff1b\u4ec5\u4f1a\u79fb\u9664\u4e0d\u5141\u8bb8\u7684\u94fe\u63a5\u3002\u6e90\u4ee3\u7801\u5728\u6b64\uff1a<a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">\u6e90\u4ee3\u7801</a>\u3002\u6b64\u529f\u80fd\u4ec5\u7528\u4e8e\u663e\u793a\u4f60\u7684\u5d29\u6e83\u4fe1\u606f\u53ca\u65e5\u5fd7\u94fe\u63a5\u3002\u4f46\u4f60\u4e5f\u53ef\u4ee5\u4f7f\u7528\u81ea\u5b9a\u4e49\u7aef\u70b9\uff0c\u5176\u5904\u7406\u65b9\u5f0f\u53ef\u80fd\u4e0d\u540c\u3002\u4f60\u5f53\u524d\u4f7f\u7528\u7684\u62a5\u544a\u7ad9\u70b9\u4e3a " + Config.obtenerInstancia().obtenerSitoDeInformes() + "\uff0c\u65e5\u5fd7\u7ad9\u70b9\u4e3a " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + "\u3002\u4f60\u4e5f\u53ef\u4ee5\u70b9\u51fb\u5355\u4e2a\u65e5\u5fd7\u540d\u79f0\u65c1\u7684\u5206\u4eab\u6309\u94ae\u6765\u5355\u72ec\u5206\u4eab\u65e5\u5fd7\uff08\u65e0\u9700\u62a5\u544a\uff09\uff1b\u65e5\u5fd7\u5c06\u4e0a\u4f20\u81f3\u6240\u9009\u65e5\u5fd7\u7ad9\u70b9\u3002CrashDetector \u9ed8\u8ba4\u542f\u7528\u65e5\u5fd7\u533f\u540d\u5316\u529f\u80fd\uff0c\u4f1a\u5c1d\u8bd5\u79fb\u9664\u7528\u6237\u540d\u3001UUID\u3001\u8bbf\u95ee\u4ee4\u724c\u3001\u4f1a\u8bdd ID\u3001IP \u5730\u5740\u7b49\u6570\u636e\u3002\u4f46\u8be5\u529f\u80fd\u5e76\u975e\u5b8c\u7f8e\uff0c\u4e14\u6574\u5408\u5305\u4f5c\u8005\u53ef\u5c06\u5176\u7981\u7528\u3002\u4f60\u53ef\u901a\u8fc7\u672c\u9875\u9762\u5e95\u90e8\u7684\u590d\u9009\u6846\u542f\u7528\u6216\u7981\u7528\u8be5\u529f\u80fd\u3002\u4f60\u662f\u81ea\u8eab\u6570\u636e\u7684\u63a7\u5236\u8005\uff0c\u7531\u4f60\u51b3\u5b9a\u4e0a\u4f20\u4f4d\u7f6e\u3002\u65e5\u5fd7\u7ad9\u70b9\u7531\u7b2c\u4e09\u65b9\u8fd0\u8425\uff0c\u5176\u6240\u6709\u6743\u5e38\u56e0\u9690\u79c1\u539f\u56e0\u800c\u9690\u85cf\u3002\u4f60\u9700\u81ea\u884c\u627f\u62c5\u6570\u636e\u7ba1\u7406\u53ca\u76f8\u5173\u98ce\u9669\u7684\u5168\u90e8\u8d23\u4efb\u3002CrashDetector \u7684\u5206\u4eab\u5bf9\u8bdd\u6846\u4ec5\u662f\u4e00\u4e2a\u4f9b\u4f60\u7ba1\u7406\u8fd9\u4e9b\u64cd\u4f5c\u7684\u754c\u9762\u3002\u8bf7\u52a1\u5fc5\u4e86\u89e3 GDPR \u548c ARCO \u7684\u76f8\u5173\u89c4\u5b9a\u3002\u5982\u679c\u4f60\u4f4d\u4e8e\u6b27\u6d32\uff0c\u53ef\u4f7f\u7528\u7531 Hetzner \u5728\u5fb7\u56fd\u6258\u7ba1\u7684 <a href=\"https://securelogger.top\">securelogger.top</a>\u3002\u66f4\u591a\u6cd5\u5f8b\u4fe1\u606f\uff0c\u8bf7\u53c2\u9605\u4ee5\u4e0b\u94fe\u63a5\uff1a<a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>\u3001<a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>\u3001<a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">\u65e5\u672c\u4e2a\u4eba\u6570\u636e\u4fdd\u62a4\u57fa\u672c\u653f\u7b56</a>\u3002";
    }

    @Override
    public String enlaceDelReporte() {
        return "\u62a5\u544a\u94fe\u63a5\uff1a";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "\u4fdd\u5b58\u5206\u4eab\u914d\u7f6e";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "\u65e5\u5fd7\u5bf9\u4e8e\u6b64\u65e5\u5fd7\u7ad9\u70b9\u6765\u8bf4\u592a\u5927\u4e86\u3002\u8bf7\u9009\u62e9\u53e6\u4e00\u4e2a\u5e76\u91cd\u8bd5\u3002";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "\u53d1\u5e03\u65e5\u5fd7\u65f6\u51fa\u9519 " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "\u65e5\u5fd7API\u4e0d\u5b58\u5728\u3002\u8bf7\u5728\u8bbe\u7f6e\u4e2d\u66f4\u6539\u65e5\u5fd7API\u3002";
    }

    @Override
    public String errorSSL() {
        return "\u60a8\u9047\u5230\u4e86SSL\u9519\u8bef\u3002\u8fd9\u5728\u65e7\u7248\u672c\u7684Java\u4e2d\u5f88\u5e38\u89c1\uff0c\u5305\u62ec\u9ed8\u8ba4Minecraft\u542f\u52a8\u5668\u4e2d\u7684Java 8\u7248\u672c\u4ee5\u53casun.com\u548cjava.com\u4e0a\u7684\u7248\u672c\u3002\u8fd9\u4f1a\u5f71\u54cd\u8bb8\u591a\u65b9\u9762\uff0c\u4f8b\u5982MinecraftForge\u5b89\u88c5\u7a0b\u5e8f\u7684JAR\u6587\u4ef6\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7aef\u70b9\u65f6\u5206\u4eabCrashDetector\u62a5\u544a\u7684\u529f\u80fd\uff0c\u9700\u8981\u4e92\u8054\u7f51\u8fde\u63a5\u7684\u4e00\u4e9b\u6a21\u7ec4\uff0c\u4ee5\u53ca\u4e00\u4e9b\u65e5\u5fd7\u7ad9\u70b9\u3002\u5982\u679c\u5728\u5c1d\u8bd5\u5206\u4eab\u62a5\u544a\u65f6\u9047\u5230\u6b64\u95ee\u9898\uff0c\u8bf7\u9644\u4e0a\u5c4f\u5e55\u622a\u56fe\u5e76\u9009\u62e9\u4e0e\u65e7\u7248Java 8\u517c\u5bb9\u7684\u65e5\u5fd7\u7ad9\u70b9\u3002";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e0d\u517c\u5bb9\u7684 JavaFML \u7248\u672c\uff1a\u9700\u8981 " + requerido + "\uff0c\u4f46\u627e\u5230\u7684\u662f " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u6ce8\u610f\uff01JavaFML \u9700\u8981\u7279\u5b9a\u7248\u672c\u7684 Minecraft Forge</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JAR \u6587\u4ef6 '" + archivoJar + "' \u9700\u8981\u8bed\u8a00\u63d0\u4f9b\u7a0b\u5e8f '" + proveedor + "' \u7684\u7248\u672c '" + requerido + "' \u6216\u66f4\u9ad8\u7248\u672c\uff0c\u4f46\u4ec5\u627e\u5230\u7248\u672c '" + encontrado + "'\u3002</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8b66\u544a\uff01Crash Assistant \u662f\u4e00\u4e2a\u4f2a\u9020\u7684\u6076\u610f\u8f6f\u4ef6\u68c0\u6d4b\u5668\u3002\u5b83\u6545\u610f\u963b\u6b62\u6e38\u620f\u542f\u52a8\uff0c\u65e0\u89c6\u60a8\u7ee7\u7eed\u4f7f\u7528\u76ee\u6807\u6a21\u7ec4\u8fdb\u884c\u6e38\u620f\u7684\u81ea\u7531\u3002 <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>\u67e5\u770b MalwareMod.java \u4ee3\u7801</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>\u67e5\u770b JarInJarHelper.java \u4ee3\u7801</a>. \u76ee\u524d\u53ea\u6709\u8fd9\u4e2a\u6a21\u7ec4\u5728\u4ed6\u4eec\u7684\u5217\u8868\u4e2d\uff0c\u5e76\u4e14\u4ed6\u4eec\u5b9e\u9645\u4e0a\u53ea\u9488\u5bf9\u9ed8\u8ba4\u7684\u65e5\u5fd7\u7ad9\u70b9\uff0c\u800c\u8be5\u7ad9\u70b9\u53ef\u4ee5\u7531\u7528\u6237\u66f4\u6539\uff0c\u53ea\u6709\u5728\u660e\u786e\u9009\u62e9\u4f7f\u7528\u5185\u7f6e\u65e5\u5fd7\u5171\u4eab\u529f\u80fd\u65f6\u624d\u4f1a\u751f\u6548\u3002CrashAssistant \u4e0d\u4f1a\u68c0\u67e5\u5f53\u524d\u4f7f\u7528\u7684\u662f\u54ea\u4e2a\u65e5\u5fd7\u7ad9\u70b9\uff0c\u4e5f\u4e0d\u4f1a\u89e3\u91ca\u5982\u4f55\u66f4\u6539\u5b83\uff08\u5171\u4eab\u5bf9\u8bdd\u6846\u5e95\u90e8\u6709\u4e00\u4e2a\u4e0b\u62c9\u83dc\u5355\uff09\uff0c\u65e0\u8bba\u914d\u7f6e\u4e86\u54ea\u4e2a\u7ad9\u70b9\uff0cCrashAssistant \u90fd\u4f1a\u963b\u6b62\u6e38\u620f\u542f\u52a8\u3002\u5728\u4ed6\u4eec\u7684\u6d88\u606f\u4e2d\uff0c\u4ed6\u4eec\u8bf4\u8981\u81ea\u5df1\u505a\u7814\u7a76\uff0c\u90a3\u5c31\u53bb\u505a\u5427\uff0c\u67e5\u770b CrashDetector \u548c Crash Assistant \u7684\u4ee3\u7801\uff0c\u4e86\u89e3\u5b83\u4eec\u7684\u4f5c\u7528\uff0c\u4e0d\u8981\u4f9d\u8d56\u6743\u5a01\u7684\u547c\u5401\u3002</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + idMod + "' \u56e0\u672a\u627e\u5230\u6240\u9700\u7c7b\u800c\u5931\u8d25: '" + claseNoEncontrada + "'. \u8bf7\u786e\u4fdd\u6240\u6709\u4f9d\u8d56\u9879\u5df2\u6b63\u786e\u5b89\u88c5\u3002</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia \u5df2\u963b\u6b62\u4f7f\u7528 TLauncher \u8fdb\u884c\u6e38\u620f\u3002</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u6b63\u5728\u4f7f\u7528\u9002\u7528\u4e8e\u8fc7\u65f6\u7248\u672c\u7684Minecraft\u7684Optifine\u7248\u672c\u3002\u60a8\u9700\u8981\u4f7f\u7528\u4e0e\u60a8\u5f53\u524d\u4f7f\u7528\u7684Minecraft\u7248\u672c\u5bf9\u5e94\u7684Optifine\u7248\u672c\u3002</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u65e0\u6cd5\u52a0\u8f7d ModLauncher \u670d\u52a1: </b>" + servicio + "\u3002";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u89e3\u6790 JAR \u6587\u4ef6 '" + archivoJar + "' \u4e2d\u7684 JSON \u6587\u4ef6 '" + recurso + "' \u65f6\u51fa\u9519\u3002\u6ce8\u518c\u5b58\u5728\u95ee\u9898\u3002</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u9519\u8bef\uff1a\u6a21\u7ec4 '" + modId + "' \u9700\u8981 '" + dependencia + "' \u7684\u7248\u672c '" + requerido + "' \u6216\u66f4\u9ad8\u7248\u672c\uff0c\u4f46\u627e\u5230\u7684\u662f '" + actual + "'\u3002</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u7684GPU\u4e0d\u652f\u6301\u6b64\u6e38\u620f\u7248\u672c\u6240\u9700\u7684OpenGL\u7248\u672c\u3002\u8bf7\u66f4\u65b0\u9a71\u52a8\u7a0b\u5e8f\u6216\u66f4\u6362\u663e\u5361\u3002</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u589e\u52a0\u5206\u914d\u7ed9\u6e38\u620f\u7684\u5185\u5b58\u6216\u51cf\u5c11\u6a21\u7ec4/\u63d2\u4ef6\u7684\u4f7f\u7528\u3002</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u68c0\u6d4b\u523032\u4f4dJVM\uff1a\u65e0\u6cd5\u4f7f\u7528\u8d85\u8fc74GB\u7684RAM\u3002 \u5b89\u88c564\u4f4dJVM\u4ee5\u5145\u5206\u5229\u7528\u60a8\u7684\u53ef\u7528\u5185\u5b58\u3002</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>PermGen\u5185\u5b58\u4e25\u91cd\u9519\u8bef\u3002\u589e\u52a0\u6c38\u4e45\u5185\u5b58\u7a7a\u95f4\u6216\u51cf\u5c11\u7c7b\u52a0\u8f7d\u3002</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8\u4e0e\u73b0\u4ee3\u7248\u672c\u4e4b\u95f4\u7684\u517c\u5bb9\u6027\u9519\u8bef</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e0d\u652f\u6301Java 9+ - \u4f7f\u7528Java 8\u4ee5\u9002\u914d\u65e7\u7248Forge</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u9700\u8981Java 8\uff08\u7248\u672c52.0\uff09\u3002\u8bf7\u66f4\u65b0\u6216\u6b63\u786e\u914d\u7f6e</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u517c\u5bb9\u6027\u9519\u8bef\uff1a\u6b64\u7248\u672c\u4e0d\u652f\u6301\u65b9\u5757\u3002 \u8bf7\u786e\u4fdd\u6a21\u7ec4\u548c\u670d\u52a1\u5668\u7248\u672c\u517c\u5bb9</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u663e\u793a\u5668\u914d\u7f6e\u9519\u8bef: \u65e0\u6cd5\u8bbe\u7f6e\u5c4f\u5e55\u6a21\u5f0f\u3002 \u8bf7\u68c0\u67e5\uff1a</b><br>- \u591a\u663e\u793a\u5668\u914d\u7f6e<br>- \u56fe\u5f62\u5361\u9a71\u52a8\u7a0b\u5e8f\u662f\u5426\u5df2\u66f4\u65b0<br>- \u7cfb\u7edf\u652f\u6301\u7684\u5206\u8fa8\u7387";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java\u9009\u9879\u9519\u8bef: \u5783\u573e\u56de\u6536\u5668\u9009\u9879\u51b2\u7a81\u3002 \u8bf7\u786e\u4fdd\u672a\u5728JVM\u53c2\u6570\u4e2d\u7ec4\u5408\u591a\u4e2aGC\u7b97\u6cd5</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>NightConfig/Forge \u914d\u7f6e\u4e25\u91cd\u9519\u8bef\uff1a\u914d\u7f6e\u6587\u4ef6\u5df2\u635f\u574f\u6216\u4e0d\u5b8c\u6574\u3002\u8fd9\u901a\u5e38\u7531 'config' \u6587\u4ef6\u5939\u4e2d\u7684\u7a7a\u914d\u7f6e\u6587\u4ef6\uff08\u5e38\u4e3a 0 \u5b57\u8282\uff09\u5f15\u8d77\uff0c\u591a\u89c1\u4e8e\u65e7\u7248\u6216\u81ea\u5b9a\u4e49\u7248 NightConfig\u3002\u5bf9\u4e8e\u5927\u591a\u6570\u7248\u672c\uff0cNight Config Fixes \u53ef\u89e3\u51b3\u6b64\u95ee\u9898\uff1b\u4f46\u82e5\u4f60\u4f7f\u7528\u7684\u662f\u4e0d\u517c\u5bb9\u6216\u81ea\u5b9a\u4e49\u7684 NightConfig \u7248\u672c\uff0c\u5219\u9700\u624b\u52a8\u5220\u9664\u914d\u7f6e\u6587\u4ef6\u3002\u6b64\u95ee\u9898\u5728\u65e7\u7248 MC Forge\uff08\u81ea\u5e26 NightConfig\uff09\u548c\u6253\u5305\u4e86 NightConfig \u7684\u65e7\u7248 FabricMC \u6a21\u7ec4\u4e2d\u5c24\u4e3a\u5e38\u89c1\uff0c\u4f46\u4e5f\u53ef\u80fd\u51fa\u73b0\u5728\u67d0\u4e9b\u81ea\u5b9a\u4e49 NightConfig \u7248\u672c\u4e2d\u3002\u66f4\u591a\u89e3\u51b3\u65b9\u6848\u8be6\u89c1 <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a>\u3002</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230Intel HD Graphics\u9a71\u52a8\u7a0b\u5e8f\u9519\u8bef\u3002\u89e3\u51b3\u65b9\u6848\uff1a</b><br>1. \u4ece<a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a>\u66f4\u65b0Intel\u9a71\u52a8\u7a0b\u5e8f\uff08\u6700\u4f4e\u7248\u672c15.xx.xx.xx\uff09<br>2. \u5728Minecraft\u4e2d\uff1a\u9009\u9879 \u2192 \u89c6\u9891 \u2192 \u542f\u7528'Enable VBOs'\u548c'VSync'<br>3. \u5728\u542f\u52a8\u5668\u4e2d\u4e3a\u6e38\u620f\u5206\u914d1GB-2GB\u7684RAM<br>4. \u66f4\u65b0\u671f\u95f4\u4e34\u65f6\u7981\u7528\u6740\u6bd2\u8f6f\u4ef6/\u9632\u706b\u5899";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "\u8b66\u544a\uff1a\u68c0\u6d4b\u5230\u7f3a\u5931\u7684\u7c7b";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "\u65b9\u5757\u6e32\u67d3\u9519\u8bef";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "\u5806\u6808\u8ddf\u8e2a\u5206\u6790";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "\u4e0d\u5b8c\u6574\u7684CurseForge\u63a7\u5236\u53f0";
    }

    @Override
    public String nombre_de_early_window() {
        return "\u65e9\u671f\u7a97\u53e3\u9519\u8bef (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "\u663e\u5361\u9a71\u52a8\u95ee\u9898";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "MCForge\u914d\u7f6e\u635f\u574f";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "\u663e\u793a\u6a21\u5f0f\u5931\u8d25 (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "FabricMC\u521d\u59cb\u5316\u9519\u8bef";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "\u7f3a\u5c11JPMS\u6a21\u5757";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "\u4e25\u91cd\u7f3a\u5931\u7684\u7c7b";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "\u7f3a\u5c11ModLauncher\u4f9d\u8d56";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "\u4e0d\u517c\u5bb9\u7684Java\u7248\u672c";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "KubeJS\u8d44\u6e90\u9519\u8bef";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "\u4e0d\u517c\u5bb9\u7684\u8bed\u8a00\u63d0\u4f9b\u8005";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "Litchhost\u9519\u8bef";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "\u865a\u5047\u6076\u610f\u8f6f\u4ef6\u68c0\u6d4b";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "\u68c0\u6d4b\u5230\u53ef\u7591\u6a21\u7ec4";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "ModLauncher\u4e2d\u7684\u91cd\u590d\u6a21\u7ec4";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "JPMS\u6a21\u5757\u51b2\u7a81";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "Iris\u9700\u8981Sodium";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "\u65e0\u6cd5\u89e3\u6790JSON\u6ce8\u518c\u8868";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "\u5185\u5b58\u4e0d\u8db3";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "\u7a7a\u6307\u9488\u9519\u8bef (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "\u65e0\u6548\u7684Java GC\u9009\u9879";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "\u8fc7\u65f6/\u4e0d\u517c\u5bb9\u7684OptiFine";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "\u5173\u952e\u670d\u52a1\u5668\u523b (60\u79d2)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "ModLauncher\u670d\u52a1\u5931\u8d25";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "\u6709\u95ee\u9898\u7684SpongeMixing\u914d\u7f6e";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus\u4e0d\u517c\u5bb9";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "TLauncher\u4e0d\u88abWATERMeDIA\u652f\u6301";
    }

    @Override
    public String auditorias_transformer() {
        return "Transformer \u5ba1\u8ba1";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8fd9\u4e9b\u662fVanilla\u542f\u52a8\u5668\u4e2dTransformer\u5ba1\u8ba1\u5185\u5bb9\u7684\u7ed3\u679c\u3002\u901a\u5e38\u5b83\u4e0d\u5982StackTrace\u5206\u6790\u5668\u7cbe\u786e\uff0c\u4f46Vanilla\u542f\u52a8\u5668\u5e76\u4e0d\u603b\u662f\u6709{}\u7684\u5185\u5bb9</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "\u8fd9\u4f1a\u626b\u63cf\u4f60\u7684\u6a21\u7ec4\uff0c\u67e5\u627e\u7531MCreator\u521b\u5efa\u7684\u6a21\u7ec4\u3002\u5c3d\u7ba1\u5927\u591a\u6570MCreator\u6a21\u7ec4\u90fd\u6ca1\u6709\u95ee\u9898\uff0c\u5e76\u4e14\u6709\u8bb8\u591a\u4f18\u79c0\u7684MCreator\u6a21\u7ec4\uff0c\u4f46\u6709\u65f6\u5b83\u4eec\u4f1a\u51fa\u73b0\u95ee\u9898\u5e76\u5e26\u6765\u4e0d\u826f\u58f0\u8a89\u3002\u8fd9\u6709\u52a9\u4e8e\u8bc6\u522b\u5b83\u4eec\u3002\u8bf7\u6ce8\u610f\uff0c\u5373\u4f7f\u662f\u8bc4\u5206\u5f88\u9ad8\u7684\u6a21\u7ec4\u4e5f\u53ef\u80fd\u5e76\u975e\u771f\u6b63\u7531MCreator\u5236\u4f5c\uff1b\u4f8b\u5982\uff0c\u5b83\u4eec\u53ef\u80fd\u4e0eMCreator\u6709\u96c6\u6210\u5173\u7cfb\u3002";
    }

    @Override
    public String escanear() {
        return "\u626b\u63cf";
    }

    @Override
    public String cargando() {
        return "\u52a0\u8f7d\u4e2d";
    }

    @Override
    public String codigo() {
        return "zh";
    }

    @Override
    public String inicioApp() {
        return "\u6e38\u620f/\u5e94\u7528\u542f\u52a8";
    }

    @Override
    public String ajustesCrashDetector() {
        return "\u5d29\u6e83\u68c0\u6d4b\u5668\u8bbe\u7f6e";
    }

    @Override
    public String confidencialidad() {
        return "\u9690\u79c1";
    }

    @Override
    public String tooltip() {
        return "\u5de5\u5177\u63d0\u793a";
    }

    @Override
    public String config() {
        return "\u914d\u7f6e";
    }

    @Override
    public String abrirCarpeta() {
        return "\u6253\u5f00\u6587\u4ef6\u5939";
    }

    @Override
    public String actualizar() {
        return "\u66f4\u65b0";
    }

    @Override
    public String anadirRegistro() {
        return "\u6dfb\u52a0\u65e5\u5fd7";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "\u4f7f\u7528\u7cfb\u7edf\u8bed\u8a00";
    }

    @Override
    public String volver() {
        return "\u8fd4\u56de";
    }

    @Override
    public String colorFondo() {
        return "\u80cc\u666f\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "\u6587\u5b57\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "\u6309\u94ae\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "\u6587\u672c\u6846\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "\u94fe\u63a5\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "\u63a7\u5236\u53f0\u6807\u9898\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "\u9519\u8bef\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "\u8b66\u544a\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "\u4fe1\u606f\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "\u6807\u9898\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "\u94fe\u63a5\u6587\u5b57\u989c\u8272 (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "\u4ec5\u5728\u5931\u8d25\u65f6\u6253\u5f00CrashDetector";
    }

    @Override
    public String activar_parche() {
        return "\u6fc0\u6d3b\u8865\u4e01";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "\u6ca1\u6709\u53ef\u7528\u7684\u89e3\u51b3\u65b9\u6848";
    }

    @Override
    public String error() {
        return "\u9519\u8bef";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "\u5220\u9664Jar\u65f6\u51fa\u9519";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar\u5220\u9664\u6210\u529f";
    }

    @Override
    public String exito() {
        return "\u6210\u529f";
    }

    @Override
    public String eliminar() {
        return "\u5220\u9664";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "\u5220\u9664\u5305\u65f6\u51fa\u9519";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "\u5305\u5220\u9664\u6210\u529f";
    }

    @Override
    public String eliminar_paquete() {
        return "\u5220\u9664\u5305";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "\u672a\u627e\u5230\u5e26\u6709\u5305\u7684\u6a21\u7ec4";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "\u65e0\u6cd5\u5220\u9664\u5305";
    }

    @Override
    public String eliminar_jar() {
        return "\u5220\u9664Jar";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "\u672a\u627e\u5230\u91cd\u590d\u7684\u6a21\u7ec4";
    }

    @Override
    public String archivo_no_encontrado() {
        return "\u6587\u4ef6\u672a\u627e\u5230";
    }

    @Override
    public String directorio_eliminado() {
        return "\u76ee\u5f55\u5df2\u5220\u9664";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "\u5220\u9664\u5d4c\u5957Jar\u65f6\u51fa\u9519";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "\u672a\u627e\u5230\u5185\u90e8\u6587\u4ef6";
    }

    @Override
    public String archivo_eliminado() {
        return "\u6587\u4ef6\u5df2\u5220\u9664";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "\u5220\u9664\u6587\u4ef6\u65f6\u51fa\u9519";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "\u65e0\u6548\u7684\u5916\u90e8\u6587\u4ef6";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "\u6a21\u7ec4\u5143\u7d20\u5df2\u5220\u9664";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "\u66ff\u6362\u5916\u90e8Jar\u65f6\u51fa\u9519";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "\u5220\u9664\u6a21\u7ec4\u5143\u7d20\u65f6\u51fa\u9519";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "\u5220\u9664\u76ee\u5f55\u65f6\u51fa\u9519";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "\u5d4c\u5957Jar\u683c\u5f0f\u65e0\u6548";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "\u5d4c\u5957Jar\u5df2\u5220\u9664";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u65f6\u51fa\u9519";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u81f4\u547d\u8ddf\u8e2a\u6d88\u606f\u6700\u540e (\u672a\u7ffb\u8bd1):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8ddf\u8e2a\u6d88\u606f\u6700\u540e (\u672a\u7ffb\u8bd1):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "\u60a8\u53ef\u4ee5\u5728 WaifuNeoForge \u6570\u636e\u5e93\u4e2d\u641c\u7d22\u4ee5\u67e5\u627e\u6a21\u7ec4\u3002\u8bf7\u9009\u62e9\u6e38\u620f\u7248\u672c\u3001\u6a21\u7ec4\u52a0\u8f7d\u5668\u548c\u7c7b\u540d\u3002\u4f7f\u7528\u6700\u63a5\u8fd1\u7684\u5339\u914d\u7ec4\u5408\u3002\u6bcf\u5206\u949f\u53ea\u80fd\u641c\u7d22\u4e00\u6b21\u3002";
    }

    @Override
    public String solucionFaltasClases() {
        return "\u60a8\u53ef\u4ee5\u5728 WaifuNeoForge \u6570\u636e\u5e93\u4e2d\u641c\u7d22\u4ee5\u67e5\u627e\u6a21\u7ec4\u3002\u8bf7\u9009\u62e9\u6e38\u620f\u7248\u672c\u3001\u6a21\u7ec4\u52a0\u8f7d\u5668\u548c\u7c7b\u540d\u3002\u4f7f\u7528\u6700\u63a5\u8fd1\u7684\u5339\u914d\u7ec4\u5408\u3002\u6bcf\u5206\u949f\u53ea\u80fd\u641c\u7d22\u4e00\u6b21\u3002";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "\u4e24\u4e2a\u542f\u52a8\u5668\u90fd\u6709\u6b63\u786e\u7684Java\u7248\u672c\uff0c\u4f46\u5e76\u975e\u6240\u6709\u7248\u672c\u90fd\u6b63\u786e\uff1b\u60a8\u53ef\u4ee5\u4ece\u7cfb\u7edf\u4e2d\u7684\u5305\u7ba1\u7406\u5668\u6216\u901a\u8fc7\u6309\u94ae\u5b89\u88c5\u6b63\u786e\u7684Java\u7248\u672c\u3002";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u7f3a\u5c11\u52a8\u753b\u7684\u6a21\u7ec4: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException\uff08\u65e0\u5143\u7d20\u5f02\u5e38\uff09\u52a8\u753b\u7f3a\u5931";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "\u672a\u627e\u5230\u53ef\u5220\u9664\u7684\u6a21\u7ec4";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "\u5c06\u51b2\u7a81\u7684\u5783\u573e\u56de\u6536\u9009\u9879\u66ff\u6362\u4e3a -XX:+UseG1GC";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "\u4f7f\u7528 -Xmx \u9009\u9879\u589e\u52a0\u5806\u5185\u5b58\u5927\u5c0f\u3002";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "\u4f7f\u7528 -XX:MaxPermSize \u9009\u9879\u589e\u52a0\u6c38\u4e45\u4ee3\u5185\u5b58\u5927\u5c0f\u3002";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "\u4f7f\u7528 64 \u4f4d JVM \u6765\u589e\u52a0\u53ef\u7528\u5185\u5b58\u3002";
    }

    @Override
    public String optimizarCodigo() {
        return "\u4f18\u5316\u4ee3\u7801\u4ee5\u51cf\u5c11\u5185\u5b58\u4f7f\u7528\u5e76\u63d0\u9ad8\u6027\u80fd\u3002";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "\u4f7f\u7528\u9ad8\u6548\u7684\u5783\u573e\u6536\u96c6\u5668\u6765\u51cf\u5c11\u5e94\u7528\u7a0b\u5e8f\u6682\u505c\u3002";
    }

    @Override
    public String modulos() {
        return "\u6a21\u5757";
    }

    @Override
    public String paquete() {
        return "\u5305";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "\u5b58\u5728\u7f3a\u5931\u7684ID\u3002\u5e38\u89c1\u539f\u56e0\u5305\u62ec\u7f3a\u5c11\u6a21\u7ec4\u6216\u7269\u54c1\u6570\u636e\u7f3a\u5931\u3002\u5e38\u89c1\u7684\u6570\u636e\u6587\u4ef6\u5939\u6709 datafiedcontents/ \u548c kubejs/ \u6216\u5176\u4ed6\u6a21\u7ec4\u6587\u4ef6\u5939\u3002";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "\u6620\u5c04\u9519\u8bef\u7684\u8bb0\u5f55";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 'AuthMe' \u52a0\u8f7d\u5931\u8d25\u5e76\u5bfc\u81f4\u670d\u52a1\u5668\u5173\u95ed\u3002</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "\u7531 AuthMe \u5f15\u8d77\u7684\u5173\u95ed\u95ee\u9898";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "'stopServer' \u89c4\u5219\u5df2\u66f4\u6539\u4e3a 'true'\u3002";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "\u914d\u7f6e\u63d2\u4ef6 AuthMe (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "\u5b89\u88c5\u4e0d\u540c\u7248\u672c\u7684 'AuthMe' \u63d2\u4ef6";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "\u79fb\u9664\u63d2\u4ef6 'AuthMe'";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e16\u754c '" + nombreMundo + "' \u65e0\u6cd5\u52a0\u8f7d\uff0c\u56e0\u4e3a\u5b83\u5305\u542b\u9519\u8bef\u4e14\u53ef\u80fd\u5df2\u635f\u574f\u3002</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "Multiverse \u4e16\u754c\u52a0\u8f7d\u95ee\u9898";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "\u4fee\u590d\u4e16\u754c '" + nombreMundo + "'\uff0c\u4f8b\u5982\u4f7f\u7528 Minecraft Region Fixer \u6216 MCEdit\u3002";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "\u5220\u9664\u4e16\u754c\u6587\u4ef6\u5939 '" + nombreMundo + "'\u3002";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + ">'PermissionsEx' \u63d2\u4ef6\u7684\u914d\u7f6e\u65e0\u6548\u3002</b>";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "PermissionsEx \u914d\u7f6e\u95ee\u9898";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "\u914d\u7f6e\u63d2\u4ef6 PermissionsEx (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "\u5220\u9664\u63d2\u4ef6 'PermissionsEx'";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u53d1\u73b0\u591a\u4e2a\u540c\u540d\u63d2\u4ef6 '" + nombrePlugin + "': '" + primerPath + "' \u548c '" + segundoPath + "'\u3002</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "\u63d2\u4ef6\u540d\u79f0\u51b2\u7a81\u95ee\u9898";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "\u5220\u9664\u63d2\u4ef6 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e16\u754c\u52a0\u8f7d\u533a\u5757\uff08chunks\uff09\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u5982\u679c\u4f60\u7684\u5e73\u53f0\u6709\u5bf9\u5e94\u7248\u672c\uff0cFeatureRecycler \u6216\u8bb8\u80fd\u89e3\u51b3\u6b64\u95ee\u9898\u3002https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "\u533a\u5757\u52a0\u8f7d\u5f02\u5e38";
    }

    @Override
    public String solucionEliminarChunk() {
        return "\u4f7f\u7528 MCEdit \u6216\u5220\u9664\u533a\u57df\u6587\u4ef6\u6765\u79fb\u9664\u6709\u95ee\u9898\u7684\u533a\u5757\u3002";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u65e0\u6cd5\u6267\u884c\u547d\u4ee4 '/" + comando + "'\u3002</b>";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "\u6267\u884c\u63d2\u4ef6\u547d\u4ee4\u65f6\u53d1\u751f\u5f02\u5e38";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "\u5b89\u88c5\u63d2\u4ef6 '" + nombrePlugin + "' \u7684\u5176\u4ed6\u7248\u672c";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u9700\u8981\u4f9d\u8d56 '" + dependencia + "'\u3002</b>";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u7f3a\u5c11\u4ee5\u4e0b\u5fc5\u9700\u4f9d\u8d56: " + deps.toString() + "\u3002</b>";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "\u7f3a\u5931\u63d2\u4ef6\u4f9d\u8d56";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "\u5b89\u88c5\u63d2\u4ef6 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u9700\u8981\u7248\u672c\u4e3a '" + versionAPI + "' \u7684 API\uff0c\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u4e0d\u517c\u5bb9\u3002</b>";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "API \u7248\u672c\u4e0d\u517c\u5bb9";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "\u5b89\u88c5\u670d\u52a1\u5668\u8f6f\u4ef6\u7684 '" + version + "' \u7248\u672c\u3002";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e16\u754c '" + nombreMundo + "' \u662f\u53e6\u4e00\u4e2a\u4e16\u754c\u7684\u526f\u672c\uff0c\u65e0\u6cd5\u52a0\u8f7d\u3002</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "\u91cd\u590d\u7684\u4e16\u754c";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "\u5220\u9664\u4e16\u754c '" + nombreMundo + "' \u4e2d\u7684 'uid.dat' \u6587\u4ef6";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "\u5220\u9664\u4e16\u754c\u6587\u4ef6\u5939 '" + nombreMundo + "'";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f4d\u4e8e " + coords + " \u7684\u533a\u5757\u5b9e\u4f53 '" + nombre + "'\uff08\u7c7b\u578b\u4e3a '" + tipo + "'\uff09\u5728tick\u65f6\u53d1\u751f\u9519\u8bef\u3002</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "\u95ee\u9898\u533a\u5757\u5b9e\u4f53";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "\u4f7f\u7528 MCEdit \u6216\u76f4\u63a5\u7f16\u8f91\u4e16\u754c\u6587\u4ef6\uff0c\u5220\u9664\u4f4d\u4e8e " + coords + " \u7684 '" + nombre + "' \u5b9e\u4f53\u3002";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreMod + "' \u5b89\u88c5\u4e86\u591a\u4e2a\u7248\u672c\u3002</b> ";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "Fabric \u4e2d\u7684\u91cd\u590d\u6a21\u7ec4";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "\u5220\u9664\u91cd\u590d\u7684\u6a21\u7ec4\u6587\u4ef6\uff1a" + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + primerMod + "' \u548c '" + segundoMod + "' \u5f7c\u6b64\u4e0d\u517c\u5bb9\u3002</b> ";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "Fabric \u4e2d\u7684\u4e0d\u517c\u5bb9\u6a21\u7ec4";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "\u5220\u9664\u6a21\u7ec4 '" + nombreMod + "'";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreMod + "' \u51fa\u73b0\u4e25\u91cd\u9519\u8bef\uff0c\u65e0\u6cd5\u8fd0\u884c\u3002</b>";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "\u6a21\u7ec4\u51fa\u73b0\u81f4\u547d\u9519\u8bef";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4ee5\u4e0b\u6a21\u7ec4\u662f\u5fc5\u9700\u7684\u4f46\u672a\u5b89\u88c5\uff1a" + deps.toString() + "\u3002</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreMod + "' \u9700\u8981\u4f9d\u8d56\u6a21\u7ec4 '" + dependencia + "'\u3002</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreMod + "' \u9700\u8981\u4f9d\u8d56\u6a21\u7ec4 '" + dependencia + "' \u7684\u7248\u672c " + version + "\u3002</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "\u7f3a\u5c11\u6a21\u7ec4\u4f9d\u8d56";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "\u5b89\u88c5\u6a21\u7ec4 '" + nombreMod + "'";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "\u5b89\u88c5\u6a21\u7ec4 '" + nombreMod + "' \u7684\u7248\u672c " + version;
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u4e0d\u517c\u5bb9 Folia \u7684\u533a\u57df\u6027 Tick\u3002</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u63d2\u4ef6\u4e0d\u517c\u5bb9 Folia \u7684\u533a\u57df\u6027 Tick\uff1a");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "\u63d2\u4ef6\u4e0e\u533a\u57df\u6027 Tick \u4e0d\u517c\u5bb9";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "\u5b89\u88c5\u4e00\u4e2a\u6ca1\u6709\u533a\u57df\u6027 Tick \u7684\u7248\u672c\uff0c\u4f8b\u5982 " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreMod + "' \u5728\u6570\u636e\u5305\u4e2d\u7f3a\u5931\u3002</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u6a21\u7ec4\u5728\u6570\u636e\u5305\u4e2d\u7f3a\u5931\uff1a");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u548c ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "\u6570\u636e\u5305\u4e2d\u7f3a\u5c11\u6a21\u7ec4";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreMod + "' \u5f15\u53d1\u4e86\u9519\u8bef\u3002</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u6a21\u7ec4\u5f15\u53d1\u4e86\u9519\u8bef\uff1a");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u548c ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "Forge \u6a21\u7ec4\u5f15\u53d1\u5f02\u5e38";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "\u5b89\u88c5\u6a21\u7ec4 '" + nombreMod + "' \u7684\u5176\u4ed6\u7248\u672c";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreMod + "' \u4e0d\u517c\u5bb9 Minecraft \u7248\u672c " + versionMC + "\u3002</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u6a21\u7ec4\u4e0d\u517c\u5bb9\u5bf9\u5e94\u7684 Minecraft \u7248\u672c\uff1a");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append("\uff08Minecraft ").append(versionesMC.get(i)).append("\uff09");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "\u6a21\u7ec4\u4e0e Minecraft \u4e0d\u517c\u5bb9";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "\u5b89\u88c5\u9002\u7528\u4e8e Minecraft " + versionMC + " \u7684 Forge \u7248\u672c";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + " \u6a21\u7ec4\u7f3a\u5931\uff0c\u65e0\u6cd5\u52a0\u8f7d\u4e16\u754c\u6216\u63d2\u4ef6\u3002</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "\u7f3a\u5931\u6a21\u7ec4";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8be5\u4e16\u754c\u4fdd\u5b58\u65f6\u5305\u542b\u6a21\u7ec4 '" + nombreMod + "'\uff0c\u4f46\u73b0\u5728\u627e\u4e0d\u5230\u8be5\u6a21\u7ec4\u3002</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u8be5\u4e16\u754c\u4fdd\u5b58\u65f6\u5305\u542b\u4ee5\u4e0b\u6a21\u7ec4\uff0c\u4f46\u73b0\u5728\u8fd9\u4e9b\u6a21\u7ec4\u90fd\u627e\u4e0d\u5230\u4e86\uff1a");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u548c ");
                } else {
                    sb.append("\u3001");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "\u4e16\u754c\u4e2d\u7f3a\u5c11\u6a21\u7ec4";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e16\u754c\u4fdd\u5b58\u65f6\u4f7f\u7528\u7684\u662f\u6a21\u7ec4 '" + nombreMod + "' \u7684\u7248\u672c " + versionEsperada + "\uff0c\u4f46\u73b0\u5728\u8fd0\u884c\u7684\u662f\u7248\u672c " + versionActual + "\u3002</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u6a21\u7ec4\u5728\u4fdd\u5b58\u7684\u4e16\u754c\u4e2d\u5b58\u5728\u7248\u672c\u5dee\u5f02\uff1a");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u548c ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append("\uff08\u4fdd\u5b58\u7248\u672c\uff1a").append(versionesEsperadas.get(i)).append("\uff0c\u5f53\u524d\u7248\u672c\uff1a").append(versionesActuales.get(i)).append("\uff09");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "\u4fdd\u5b58\u7684\u4e16\u754c\u4e2d\u7684\u6a21\u7ec4\u7248\u672c\u4e0d\u4e00\u81f4";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u5c1d\u8bd5\u52a0\u8f7d\u4e86\u4e00\u4e2a\u7531\u66f4\u65b0\u7248 Minecraft \u521b\u5efa\u7684\u4e16\u754c\u3002</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "\u5c1d\u8bd5\u4ece\u8f83\u65b0\u7248\u672c\u52a0\u8f7d\u4e16\u754c";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "\u5b89\u88c5\u66f4\u65b0\u7684 Minecraft \u7248\u672c\u3002";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "\u751f\u6210\u4e00\u4e2a\u65b0\u4e16\u754c\u3002";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u9700\u8981\u4f9d\u8d56\u63d2\u4ef6 '" + dependencia + "'\u3002</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u63d2\u4ef6\u9700\u8981\u672a\u5b89\u88c5\u7684\u4f9d\u8d56\u9879\uff1a");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'\uff08").append(dependencias.get(i)).append("\uff09");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "\u63d2\u4ef6\u7f3a\u5c11\u4f9d\u8d56";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u4e0e\u5f53\u524d\u670d\u52a1\u5668\u7248\u672c\u4e0d\u517c\u5bb9\u3002</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u63d2\u4ef6\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u7248\u672c\u4e0d\u517c\u5bb9\uff1a");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u548c ");
                } else {
                    sb.append("\u3001");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "\u63d2\u4ef6\u4e0e PocketMine-MP \u4e0d\u517c\u5bb9";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u63d2\u4ef6 '" + nombrePlugin + "' \u5728\u8fd0\u884c\u671f\u95f4\u5f15\u53d1\u9519\u8bef\u3002</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u63d2\u4ef6\u5728\u8fd0\u884c\u671f\u95f4\u5f15\u53d1\u9519\u8bef\uff1a");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u548c ");
                } else {
                    sb.append("\u3001");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "\u8fd0\u884c\u671f\u95f4\u51fa\u9519\u7684\u63d2\u4ef6";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "LegacyRandomSource \u591a\u7ebf\u7a0b";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u591a\u4e2a\u7ebf\u7a0b\u8bbf\u95ee LegacyRandomSource \u7c7b\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u5b89\u88c5 'Unsafe World Random Access Detector' \u6216 'C2ME' \u6a21\u7ec4\u83b7\u53d6\u66f4\u591a\u4fe1\u606f\u3002</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "\u81ea\u4e0a\u6b21\u6210\u529f\u4ee5\u6765";
    }

    @Override
    public String noHayCambios() {
        return "\u65e0\u66f4\u6539";
    }

    @Override
    public String desdeUltimoIntento() {
        return "\u81ea\u4e0a\u6b21\u5c1d\u8bd5\u4ee5\u6765";
    }

    @Override
    public String fallo() {
        return "\u5931\u8d25";
    }

    @Override
    public String diferentesDeLasMods() {
        return "\u4e0e\u6a21\u7ec4\u4e0d\u540c";
    }

    @Override
    public String historialDeMods() {
        return "\u6a21\u7ec4\u5386\u53f2\u8bb0\u5f55";
    }

    @Override
    public String archivo0() {
        return "\u6587\u4ef60";
    }

    @Override
    public String archivo1() {
        return "\u6587\u4ef61";
    }

    @Override
    public String comparar() {
        return "\u6bd4\u8f83";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "\u9009\u62e9\u4e24\u4e2a\u6587\u4ef6";
    }

    @Override
    public String archivoExito() {
        return "\u6210\u529f\u6587\u4ef6";
    }

    @Override
    public String archivoFalla() {
        return "\u5931\u8d25\u6587\u4ef6";
    }

    @Override
    public String errorComparandoArchivos() {
        return "\u6bd4\u8f83\u6587\u4ef6\u65f6\u51fa\u9519";
    }

    @Override
    public String comparando() {
        return "\u6b63\u5728\u6bd4\u8f83";
    }

    @Override
    public String con() {
        return "\u4e0e";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'><p><b>\u6a21\u7ec4\u5386\u53f2\u6bd4\u8f83\u9762\u677f</b></p><p>\u6b64\u9762\u677f\u5141\u8bb8\u60a8\u5bf9\u6bd4\u4e0d\u540c\u8fd0\u884c\u4f1a\u8bdd\u7684\u4e24\u4e2a\u6a21\u7ec4\u5217\u8868\u3002\u4ece\u5de6\u4fa7\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6\uff0c\u53f3\u4fa7\u9009\u62e9\u53e6\u4e00\u4e2a\uff0c\u4ee5\u67e5\u770b\u5b83\u4eec\u4e4b\u95f4\u7684\u53d8\u5316\u3002</p><h3>\u4f7f\u7528\u65b9\u6cd5\uff1a</h3><ol><li><b>\u9009\u62e9\u6587\u4ef6\uff1a</b>\u70b9\u51fb\u6587\u4ef6\u540d\u65c1\u8fb9\u7684\u5355\u9009\u6309\u94ae\u3002\u4ee5<span style='color: #4CAF50; font-weight: bold;'>.exito</span>\u7ed3\u5c3e\u7684\u6587\u4ef6\u8868\u793a\u6210\u529f\u4f1a\u8bdd\uff0c\u800c\u4ee5<span style='color: #F44336; font-weight: bold;'>.falla</span>\u7ed3\u5c3e\u7684\u6587\u4ef6\u5219\u4ee3\u8868\u5931\u8d25\u3002</li><li><b>\u81ea\u52a8\u5bf9\u6bd4\uff1a</b>\u6309\u4e0b'Compare'\u6309\u94ae\u540e\u7cfb\u7edf\u5c06\u5206\u6790\u6240\u9009\u5217\u8868\uff0c\u5e76\u663e\u793a\u6dfb\u52a0(+)\u6216\u5220\u9664(-)\u7684\u6a21\u7ec4\u3002</li><li><b>\u7ed3\u679c\u5c55\u793a\uff1a</b>\u7ed3\u679c\u4ee5\u989c\u8272\u7f16\u7801\u7684HTML\u683c\u5f0f\u5448\u73b0\uff1a<ul><li><span style='color: green;'>+ \u6dfb\u52a0\u7684\u6a21\u7ec4</span></li><li><span style='color: red;'>- \u5220\u9664\u7684\u6a21\u7ec4</span></li></ul></li></ol><h3>\u4e3b\u8981\u529f\u80fd\uff1a</h3><ul><li>\u652f\u6301\u4efb\u610f\u7ec4\u5408\u7684\u6210\u529f/\u5931\u8d25\u6587\u4ef6\u5bf9\u6bd4\u3002</li><li>\u53cc\u5411\u5dee\u5f02\u5c55\u793a\u4ee5\u4fbf\u7cbe\u51c6\u8ddf\u8e2a\u53d8\u66f4\u3002</li><li>\u652f\u6301\u957f\u6a21\u7ec4\u5217\u8868\u6eda\u52a8\u6d4f\u89c8\u3002</li><li>\u96c6\u6210\u793a\u610f\u56fe\u63d0\u5347\u89c6\u89c9\u7406\u89e3\u3002</li></ul><p>\u7528\u5fc3\u5f00\u53d1\uff0c\u52a9\u60a8\u8ffd\u8e2a\u914d\u7f6e\u4e2d\u7684\u66f4\u6539 <3</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u53ef\u80fd\u9047\u5230\u4e86\u4e0e IPv6 \u76f8\u5173\u7684\u95ee\u9898\u3002\u6709\u4e24\u79cd\u89e3\u51b3\u65b9\u6848\uff1a1) \u5728\u542f\u52a8\u5668\u4e2d\u6dfb\u52a0 JVM \u53c2\u6570 <code>-Djava.net.preferIPv4Stack=true</code>\uff0c\u6216\u80052) \u5728 CrashDetector \u4e2d\u4f7f\u7528 'QuickFix' \u6309\u94ae\u81ea\u52a8\u542f\u7528\u6b64\u8bbe\u7f6e\u7684\u8865\u4e01\u3002</b>";
    }

    @Override
    public String parcheIPv4() {
        return "IPv4/6 \u8865\u4e01";
    }

    @Override
    public String carpetaHMCL() {
        return "HMCL \u6587\u4ef6\u5939\uff08\u4ec5\u9650 HelloMineCraftLauncher\uff09";
    }

    @Override
    public String descripcionCurseforge() {
        return "\u6ce8\u610f\uff1a\u5982\u679c\u5728 \u8bbe\u7f6e > Minecraft \u4e2d\u542f\u7528\u4e86\u201c\u8df3\u8fc7\u542f\u52a8\u5668\u201d\uff0c\u5c06\u4e0d\u4f1a\u751f\u6210\u65e5\u5fd7";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/\u884d\u751f\u7248\u672c\uff1a\u53f3\u952e\u5b9e\u4f8b\uff0c\u9009\u62e9\u201c\u7f16\u8f91\u5b9e\u4f8b\u201d\u3002\u5728\u6253\u5f00\u7684\u7a97\u53e3\u4e2d\u67e5\u627e\u201cMinecraft \u65e5\u5fd7\u201d\u6216\u7c7b\u4f3c\u90e8\u5206\u3002<br>\u8fd9\u4e9b\u65e5\u5fd7\u5305\u542b\u6807\u51c6\u8f93\u51fa\uff08STDOUT\uff09\uff0c\u5bf9\u4e8e\u8bca\u65ad\u9519\u8bef\u81f3\u5173\u91cd\u8981\u3002";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL\uff08HelloMinecraftLauncher\uff09\uff1a\u8bf7\u9009\u62e9 HMCL \u7684\u5b89\u88c5\u76ee\u5f55\uff0c\u5e76\u9009\u62e9\u5176\u4e2d\u7684\u300c.hmcl\u300d\u6587\u4ef6\u5939\u3002HMCL \u7684\u65e5\u5fd7\u4fdd\u5b58\u5728\u8fd9\u91cc\uff0c\u5305\u542b\u91cd\u8981\u7684\u9519\u8bef\u4fe1\u606f\u3002<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix\uff1a\u542f\u52a8\u5668\u6709\u4e00\u4e2a\u5f00\u53d1\u6807\u7b7e\u9875\u663e\u793a\u8be6\u7ec6\u65e5\u5fd7\u3002\u60a8\u53ef\u4ee5\u5728\u542f\u52a8\u5668\u8bbe\u7f6e\u83dc\u5355\u4e2d\u627e\u5230\u8be5\u6807\u7b7e\u9875\u3002";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher\uff1a\u65e5\u5fd7\u663e\u793a\u5728\u4e00\u4e2a\u5f39\u51fa\u7a97\u53e3\u4e2d\uff0c\u6709\u590d\u5236\u548c\u4e0a\u4f20\u6309\u94ae\u3002\u6e38\u620f\u542f\u52a8\u65f6\u4f1a\u81ea\u52a8\u751f\u6210\u65e5\u5fd7\uff0c\u5305\u542b\u5173\u952e\u7684\u8bca\u65ad\u4fe1\u606f\u3002";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher\uff1a\u53f3\u952e\u70b9\u51fb\u5b9e\u4f8b\u5e76\u9009\u62e9\u300c\u8bbe\u7f6e\u300d\u3002\u7136\u540e\u8fdb\u5165\u65e5\u5fd7\u9009\u9879\u5361\u67e5\u770b\u6807\u51c6\u8f93\u51fa\uff08STDOUT\uff09\u4e2d\u7684\u91cd\u8981\u4fe1\u606f\u3002";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "Markdown \u94fe\u63a5\uff1a\u5728\u6b64\u7c98\u8d34\u4efb\u4f55\u5305\u542b Markdown \u683c\u5f0f\u65e5\u5fd7\u7684\u94fe\u63a5\u3002\u7cfb\u7edf\u5c06\u5c1d\u8bd5\u81ea\u52a8\u63d0\u53d6\u65e5\u5fd7\u94fe\u63a5\uff08\u5982 latest.log\u3001launcher_log.txt\u3001debug.log \u7b49\uff09\u5e76\u8fdb\u884c\u5206\u6790\u3002";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "\u672a\u627e\u5230\u542f\u52a8\u5668\u65e5\u5fd7";
    }

    @Override
    public String imagenNoEncontrada() {
        return "\u56fe\u7247\u672a\u627e\u5230";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "\u901a\u7528\uff1a\u8bf7\u9009\u62e9\u4f60\u6b63\u5728\u4f7f\u7528\u7684\u542f\u52a8\u5668\u7c7b\u578b\u3002\u542f\u52a8\u5668\u65e5\u5fd7\uff08launcher_log.txt\u3001stdout \u7b49\uff09\u5305\u542b\u4e86 latest.log \u4e2d\u6ca1\u6709\u7684\u5173\u952e\u9519\u8bef\u4fe1\u606f\u3002CrashDetector \u65e0\u6cd5\u8bfb\u53d6\u4f60\u7684\u542f\u52a8\u5668\u65e5\u5fd7 \u2014\u2014 \u53ef\u80fd\u662f\u6ca1\u6709\u751f\u6210\u65e5\u5fd7\u6587\u4ef6\uff0c\u4f60\u9700\u8981\u624b\u52a8\u7c98\u8d34\u65e5\u5fd7\u5185\u5bb9\u3002<br>\u66f4\u591a\u4fe1\u606f\u8bf7\u53c2\u8003 <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">\u6b64\u95ee\u9898</a>\u3002\u8fd9\u4e9b\u65e5\u5fd7\u5305\u542b\u6807\u51c6\u8f93\u51fa\uff08STDOUT\uff09\uff0c\u662f\u8bca\u65ad\u8bb8\u591a\u9519\u8bef\u6240\u5fc5\u9700\u7684\u3002";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u6765\u81ea Create \u7684\u7f3a\u5931\u7c7b\u3002Create \u5df2\u53d1\u751f\u91cd\u5927\u53d8\u66f4\uff0c\u8bb8\u591a\u7c7b\u5df2\u88ab\u79fb\u9664\u3002\u7279\u522b\u662f\u4ece Create 6\uff082025\u5e742\u6708\uff09\u5f00\u59cb\uff0c\u65e7\u7248\u672c\u7684 Create \u9644\u52a0\u6a21\u7ec4\u5c06\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c\u3002QuickFix \u65e0\u6cd5\u89e3\u51b3\u6b64\u95ee\u9898\u3002\u60a8\u9700\u8981\u66f4\u65b0 Create \u9644\u52a0\u6a21\u7ec4\u3001\u5220\u9664\u8fc7\u65f6\u7684\u6a21\u7ec4\uff0c\u6216\u4f7f\u7528\u4e0e\u9644\u52a0\u6a21\u7ec4\u517c\u5bb9\u7684\u6b63\u786e Create \u7248\u672c\u3002</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u6765\u81ea EpicFight \u7684\u7f3a\u5931\u7c7b\u3002EpicFight \u5df2\u53d1\u751f\u91cd\u5927\u53d8\u66f4\uff0c\u8bb8\u591a\u7c7b\u5df2\u88ab\u79fb\u9664\u3002QuickFix \u65e0\u6cd5\u89e3\u51b3\u6b64\u95ee\u9898\u3002\u60a8\u9700\u8981\u66f4\u65b0 EpicFight \u9644\u52a0\u6a21\u7ec4\u3001\u5220\u9664\u8fc7\u65f6\u7684\u6a21\u7ec4\uff0c\u6216\u4f7f\u7528\u4e0e\u9644\u52a0\u6a21\u7ec4\u517c\u5bb9\u7684\u6b63\u786e EpicFight \u7248\u672c\u3002</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u6b63\u5728\u4f7f\u7528 OpenJ9\uff0c\u800c\u672c\u5e94\u7528\u4e0d\u652f\u6301\u8be5 JVM\u3002\u8bb8\u591a\u5e94\u7528\uff08\u5305\u62ec\u6b64\u5e94\u7528\uff09\u7531\u4e8e JVM \u5b9e\u73b0\u5dee\u5f02\u800c\u4e0d\u652f\u6301 OpenJ9\u3002QuickFix \u65e0\u6cd5\u81ea\u52a8\u89e3\u51b3\u6b64\u95ee\u9898\u3002\u60a8\u9700\u8981\u5b89\u88c5\u517c\u5bb9\u7684 JDK\uff0c\u4f8b\u5982 Oracle JDK\u3001OpenJDK Hotspot \u6216\u5176\u4ed6\u63a8\u8350\u7684\u66ff\u4ee3\u65b9\u6848\u3002</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6b64\u7248\u672c\u7684\u5e94\u7528\u9700\u8981 Java 11 (JDK 11) \u624d\u80fd\u6b63\u5e38\u8fd0\u884c\u3002\u60a8\u6b63\u5728\u4f7f\u7528\u4e0d\u517c\u5bb9\u7684\u65e7\u7248 Java\u3002QuickFix \u65e0\u6cd5\u81ea\u52a8\u5347\u7ea7\u60a8\u7684 Java\u3002\u60a8\u9700\u8981\u4ece\u89e3\u51b3\u65b9\u6848\u4e2d\u63d0\u4f9b\u7684\u94fe\u63a5\u4e0b\u8f7d\u5e76\u5b89\u88c5 JDK 11 \u6216\u66f4\u9ad8\u517c\u5bb9\u7248\u672c\u3002</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u60a8\u5206\u914d\u4e86\u8fc7\u591a\u5185\u5b58\uff0c\u5bfc\u81f4\u7cfb\u7edf\u8d44\u6e90\u4e0d\u8db3\u3002\u901a\u5e38\u53d1\u751f\u5728\u8bbe\u7f6e\u7684 RAM \u8d85\u51fa\u7cfb\u7edf\u53ef\u7528\u5bb9\u91cf\uff0c\u6216\u4f7f\u7528\u65e0\u6cd5\u5904\u7406\u5927\u5185\u5b58\u5206\u914d\u7684 32 \u4f4d JVM \u65f6\u3002</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u8bf7\u51cf\u5c11\u5206\u914d\u7ed9\u5e94\u7528\u7684\u5185\u5b58\u3002\u63a8\u8350\u6700\u5927\u503c\u53d6\u51b3\u4e8e\u60a8\u7684\u7cfb\u7edf\uff0c\u901a\u5e38\u4e0d\u5e94\u8d85\u8fc7\u603b\u5185\u5b58\u7684 70-80%\u3002\u82e5\u4f7f\u7528 32 \u4f4d JVM\uff0c\u6700\u5927\u9650\u5236\u7ea6\u4e3a 2-3 GB\uff0c\u4e0e\u7269\u7406\u5185\u5b58\u5927\u5c0f\u65e0\u5173\u3002</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u8981\u51cf\u5c11\u5e94\u7528\u7684\u5806\u5185\u5b58\uff0c\u8bf7\u6253\u5f00\u542f\u52a8\u5668\u8bbe\u7f6e\u5e76\u627e\u5230\u5185\u5b58\u9009\u9879\u3002\u5c06\u6700\u5927\u503c (Xmx) \u8c03\u6574\u4e3a\u66f4\u5408\u9002\u7684\u6570\u503c\u3002\u4f8b\u5982\uff0c8 GB \u5185\u5b58\u53ef\u5206\u914d 3-4 GB\uff0c16 GB \u53ef\u5206\u914d 6-8 GB\u3002\u8bf7\u4e3a\u64cd\u4f5c\u7cfb\u7edf\u548c\u5176\u4ed6\u7a0b\u5e8f\u4fdd\u7559\u8db3\u591f\u5185\u5b58\u3002</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge \u7f3a\u5c11\u5fc5\u8981\u6587\u4ef6\u3002\u6587\u4ef6 '" + archivo + "' \u5728\u60a8\u7684\u5b89\u88c5\u4e2d\u672a\u627e\u5230\u3002\u8fd9\u901a\u5e38\u53d1\u751f\u5728 Forge \u5b89\u88c5\u4e2d\u65ad\u6216\u91cd\u8981\u6587\u4ef6\u88ab\u5220\u9664\u65f6\u3002QuickFix \u65e0\u6cd5\u81ea\u52a8\u6062\u590d\u8fd9\u4e9b\u6587\u4ef6\u3002\u60a8\u9700\u8981\u4f7f\u7528\u5b98\u65b9\u5b89\u88c5\u7a0b\u5e8f\u91cd\u65b0\u6b63\u786e\u5b89\u88c5 Forge\u3002</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge \u65e0\u6cd5\u627e\u5230\u6240\u9700\u7684 Minecraft \u7248\u672c\u3002\u9700\u8981\u7248\u672c " + version + "\uff0c\u4f46\u5728\u6587\u4ef6 '" + archivo + "' \u4e2d\u672a\u627e\u5230\u3002\u8fd9\u901a\u5e38\u662f\u56e0\u4e3a\u60a8\u4f7f\u7528\u7684 Minecraft \u7248\u672c\u4e0e Forge \u7248\u672c\u4e0d\u517c\u5bb9\u3002\u8bf7\u786e\u4fdd\u4e0b\u8f7d\u4e0e\u60a8\u7684 Minecraft \u7248\u672c\u5339\u914d\u7684\u6b63\u786e Forge \u7248\u672c\u3002</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u65e0\u6cd5\u627e\u5230\u542f\u52a8 Forge \u6240\u9700\u7684 'fmlclient' \u76ee\u6807\u3002\u8fd9\u8868\u660e Forge \u5b89\u88c5\u4e0d\u5b8c\u6574\u6216\u5df2\u635f\u574f\u3002Forge \u7684\u5173\u952e\u6587\u4ef6\u53ef\u80fd\u672a\u6b63\u786e\u5b89\u88c5\u3002\u60a8\u9700\u8981\u4f7f\u7528\u5b98\u65b9\u5b89\u88c5\u7a0b\u5e8f\u91cd\u65b0\u5b89\u88c5 Forge\u3002</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u7c7b\u52a0\u8f7d\u5668\u4e2d\u627e\u4e0d\u5230 Minecraft \u4e3b\u7c7b\u3002\u8fd9\u901a\u5e38\u8868\u793a Forge \u5b89\u88c5\u4e0d\u5b8c\u6574\uff0c\u6216\u4e0e\u5176\u4ed6\u6a21\u7ec4\u5b58\u5728\u51b2\u7a81\u3002\u5728\u5b89\u88c5 Forge \u65f6\uff0cMinecraft \u6587\u4ef6\u53ef\u80fd\u5df2\u635f\u574f\u3002\u60a8\u9700\u8981\u91cd\u65b0\u6b63\u786e\u5b89\u88c5 Forge\u3002</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge \u5b89\u88c5\u4e0d\u5b8c\u6574\u3002\u53ef\u80fd\u7531\u4e8e\u5b89\u88c5\u4e2d\u65ad\u3001\u6587\u4ef6\u88ab\u5220\u9664\uff0c\u6216\u4e0e\u60a8\u7684 Minecraft \u7248\u672c\u4e0d\u517c\u5bb9\u3002Forge \u9700\u8981\u7279\u5b9a\u6587\u4ef6\u624d\u80fd\u6b63\u5e38\u8fd0\u884c\uff0c\u800c\u60a8\u7684\u5f53\u524d\u5b89\u88c5\u7f3a\u5c11\u5176\u4e2d\u4e00\u4e9b\u6587\u4ef6\u3002</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "Forge \u5b89\u88c5\u4e0d\u5b8c\u6574";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u8981\u89e3\u51b3\u6b64\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u6b63\u786e\u5b89\u88c5 Forge\u3002\u786e\u4fdd\u4e0b\u8f7d\u4e0e\u60a8 Minecraft \u7248\u672c\u5339\u914d\u7684\u7248\u672c\uff0c\u5e76\u5b8c\u6574\u6267\u884c\u5b89\u88c5\u8fc7\u7a0b\uff0c\u4e0d\u8981\u4e2d\u65ad\u3002</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "\u4ece\u5b98\u65b9\u6e20\u9053\u4e0b\u8f7d Forge";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "\u5982\u4f55\u6b63\u786e\u91cd\u65b0\u5b89\u88c5 Forge";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>\u91cd\u65b0\u5b89\u88c5 Forge \u7684\u8bf4\u660e\uff1a</h3><ol><li>\u4ece\u5b98\u65b9\u7f51\u7ad9\u4e0b\u8f7d\u6b63\u786e\u7684 Forge \u5b89\u88c5\u7a0b\u5e8f\uff08\u63a8\u8350\u4e0e\u60a8 Minecraft \u7248\u672c\u5339\u914d\u7684\u7248\u672c\uff09</li><li>\u5b8c\u5168\u5173\u95ed\u60a8\u7684 Minecraft \u542f\u52a8\u5668</li><li>\u4ee5\u7ba1\u7406\u5458\u8eab\u4efd\u8fd0\u884c Forge \u5b89\u88c5\u7a0b\u5e8f</li><li>\u9009\u62e9 'Installer' \u9009\u9879\uff08\u4e0d\u8981\u9009 'Installer (run client)'\uff09</li><li>\u5728\u542f\u52a8\u5668\u4e2d\u9009\u62e9\u60a8\u7684 Minecraft \u914d\u7f6e\u6587\u4ef6\u6587\u4ef6\u5939</li><li>\u70b9\u51fb 'OK' \u5e76\u7b49\u5f85\u5b89\u88c5\u5b8c\u6210</li><li>\u91cd\u542f\u542f\u52a8\u5668\uff0c\u5e76\u786e\u8ba4 Forge \u51fa\u73b0\u5728\u914d\u7f6e\u6587\u4ef6\u5217\u8868\u4e2d</li></ol><p><b>\u91cd\u8981\u63d0\u793a\uff1a</b> \u5982\u679c\u60a8\u4f7f\u7528\u7684\u662f\u81ea\u5b9a\u4e49\u542f\u52a8\u5668\uff0c\u8bf7\u786e\u4fdd\u9009\u62e9\u6b63\u786e\u7684\u914d\u7f6e\u6587\u4ef6\u76ee\u5f55\u3002</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "\u91cd\u65b0\u5b89\u88c5 Forge \u7684\u8bf4\u660e";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u94fe\u63a5\u9519\u8bef\uff1a\u65e0\u6cd5\u52a0\u8f7d\u5e93 " + nombreBiblioteca + "\u3002\u53ef\u80fd\u7684\u89e3\u51b3\u65b9\u6848\uff1a<br/><br/>a) \u5c06\u5305\u542b\u5171\u4eab\u5e93\u7684\u76ee\u5f55\u6dfb\u52a0\u5230 -Djava.library.path \u6216 -Dorg.lwjgl.librarypath\u3002<br/>b) \u5c06\u5305\u542b\u5171\u4eab\u5e93\u7684 JAR \u6587\u4ef6\u6dfb\u52a0\u5230 classpath\u3002<br/><br/>\u6b64\u9519\u8bef\u53d1\u751f\u5728 Minecraft \u65e0\u6cd5\u627e\u5230\u8fd0\u884c\u6240\u9700\u7684\u5173\u952e\u6587\u4ef6\u65f6\u3002\u901a\u5e38\u7531 Minecraft \u5b89\u88c5\u4e0d\u5b8c\u6574\u6216\u7cfb\u7edf\u6743\u9650\u95ee\u9898\u5f15\u8d77\u3002</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "\u94fe\u63a5\u9519\u8bef";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u65e0\u6cd5\u52a0\u8f7d\u5e93\u3002\u53ef\u80fd\u7684\u89e3\u51b3\u65b9\u6848\uff1a<br/><br/>a) \u5c06\u5305\u542b\u5171\u4eab\u5e93\u7684\u76ee\u5f55\u6dfb\u52a0\u5230 -Djava.library.path \u6216 -Dorg.lwjgl.librarypath\u3002<br/>b) \u5c06\u5305\u542b\u5171\u4eab\u5e93\u7684 JAR \u6587\u4ef6\u6dfb\u52a0\u5230 classpath\u3002<br/><br/>\u8fd9\u4e9b\u6280\u672f\u65b9\u6848\u9002\u7528\u4e8e\u9ad8\u7ea7\u7528\u6237\u3002\u5927\u591a\u6570\u7528\u6237\u5e94\u5728\u4fee\u6539\u8fd9\u4e9b\u53c2\u6570\u524d\u5c1d\u8bd5\u91cd\u65b0\u5b89\u88c5 Minecraft\u3002</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ID \u51b2\u7a81\uff1aID <strong>" + id + "</strong> \u5df2\u88ab <strong>" + modOrigen + "</strong> \u5360\u7528\uff0c\u65e0\u6cd5\u4e3a <strong>" + modDestino + "</strong> \u5206\u914d\u3002\u5f53\u4e24\u4e2a\u6a21\u7ec4\u8bd5\u56fe\u4e3a\u4e0d\u540c\u5143\u7d20\u4f7f\u7528\u76f8\u540c ID \u65f6\u4f1a\u53d1\u751f\u6b64\u95ee\u9898\u3002</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5df2\u8d85\u51fa\u5141\u8bb8\u7684\u6700\u5927 ID \u8303\u56f4\u3002\u5f53\u6a21\u7ec4\u5c1d\u8bd5\u6ce8\u518c\u8d85\u51fa Minecraft \u7248\u672c\u652f\u6301\u8303\u56f4\u7684\u533a\u5757\u6216\u7269\u54c1 ID \u65f6\u4f1a\u53d1\u751f\u6b64\u95ee\u9898\u3002</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "ID \u51b2\u7a81";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u89e3\u51b3\u65b9\u6cd5\uff1a\u5728 Minecraft 1.12.2 \u4e2d\u5b89\u88c5 <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a>\uff0c1.7.10 \u7248\u672c\u8bf7\u4f7f\u7528 <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a>\u3002</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u4f7f\u7528 <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> \u6216 <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a> \u7b49\u5de5\u5177\u89e3\u51b3 ID \u51b2\u7a81\u3002</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "\u5b89\u88c5 JustEnoughIDs";
    }

    @Override
    public String instalar_endlessids() {
        return "\u5b89\u88c5 EndlessIDs";
    }

    @Override
    public String usar_idfix_minus() {
        return "\u4f7f\u7528 IdFix Minus \u6216 IdFix";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "\u4f7f\u7528 Minecraft-ID-Resolver";
    }

    @Override
    public String ver_documentacion_jp() {
        return "\u67e5\u770b\u65e5\u6587\u6587\u6863";
    }

    @Override
    public String escanearDeMCreator() {
        return "\u626b\u63cf MCreator";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\u6a21\u5757\u4e0e\u7c7b\u6811";
    }

    @Override
    public String tipoBusqueda() {
        return "\u7c7b\u578b";
    }

    @Override
    public String filtroTodos() {
        return "\u5168\u90e8";
    }

    @Override
    public String filtroPaquetes() {
        return "\u5305";
    }

    @Override
    public String filtroClases() {
        return "\u7c7b";
    }

    @Override
    public String filtroMetodos() {
        return "\u65b9\u6cd5";
    }

    @Override
    public String filtroCampos() {
        return "\u5b57\u6bb5";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "\u5b57\u6bb5\u5f15\u7528";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "\u65b9\u6cd5\u5f15\u7528";
    }

    @Override
    public String filtroReferenciasClase() {
        return "\u7c7b\u5f15\u7528";
    }

    @Override
    public String tipBuscar() {
        return "\u5728\u6b64\u8f93\u5165\u4ee5\u5728\u6a21\u7ec4\u6811\u4e2d\u641c\u7d22";
    }

    @Override
    public String botonBuscar() {
        return "\u641c\u7d22";
    }

    @Override
    public String botonResetearArbol() {
        return "\u91cd\u7f6e\u6811";
    }

    @Override
    public String modsCargados() {
        return "\u5df2\u52a0\u8f7d\u7684\u6a21\u7ec4";
    }

    @Override
    public String clases() {
        return "\u7c7b";
    }

    @Override
    public String metodos() {
        return "\u65b9\u6cd5";
    }

    @Override
    public String campos() {
        return "\u5b57\u6bb5";
    }

    @Override
    public String referencias() {
        return "\u5f15\u7528";
    }

    @Override
    public String resultadosBusqueda() {
        return "\u641c\u7d22\u7ed3\u679c";
    }

    @Override
    public String buscarReferencias() {
        return "\u67e5\u627e\u5f15\u7528";
    }

    @Override
    public String referenciasMod() {
        return "\u6a21\u7ec4\u5f15\u7528";
    }

    @Override
    public String referenciasClase() {
        return "\u7c7b\u5f15\u7528";
    }

    @Override
    public String referenciasMetodo() {
        return "\u65b9\u6cd5\u5f15\u7528";
    }

    @Override
    public String referenciasCampo() {
        return "\u5b57\u6bb5\u5f15\u7528";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "\u672a\u627e\u5230\u5f15\u7528";
    }

    @Override
    public String detalleMod() {
        return "\u6a21\u7ec4\u8be6\u60c5:";
    }

    @Override
    public String ubicacion() {
        return "\u4f4d\u7f6e";
    }

    @Override
    public String nombres() {
        return "\u540d\u79f0";
    }

    @Override
    public String modulo() {
        return "\u6a21\u5757";
    }

    @Override
    public String detalleClase() {
        return "\u7c7b\u8be6\u60c5:";
    }

    @Override
    public String detalleMetodo() {
        return "\u65b9\u6cd5\u8be6\u60c5:";
    }

    @Override
    public String detalleCampo() {
        return "\u5b57\u6bb5\u8be6\u60c5:";
    }

    @Override
    public String clase() {
        return "\u7c7b";
    }

    @Override
    public String tipo() {
        return "\u7c7b\u578b";
    }

    @Override
    public String referenciasAMetodos() {
        return "\u65b9\u6cd5\u5f15\u7528:";
    }

    @Override
    public String referenciasACampos() {
        return "\u5b57\u6bb5\u5f15\u7528:";
    }

    @Override
    public String arbolDeMods() {
        return "\u6a21\u7ec4\u6811";
    }

    @Override
    public String metodo() {
        return "\u65b9\u6cd5";
    }

    @Override
    public String campo() {
        return "\u5b57\u6bb5";
    }

    @Override
    public String descompilar() {
        return "\u53cd\u7f16\u8bd1";
    }

    @Override
    public String exportar() {
        return "\u5bfc\u51fa";
    }

    @Override
    public String importar() {
        return "\u5bfc\u5165";
    }

    @Override
    public String errorImportar() {
        return "\u5bfc\u5165\u9519\u8bef";
    }

    @Override
    public String estructuraImportada() {
        return "\u7ed3\u6784\u5df2\u5bfc\u5165";
    }

    @Override
    public String estructuraExportada() {
        return "\u7ed3\u6784\u5df2\u5bfc\u51fa";
    }

    @Override
    public String errorExportar() {
        return "\u5bfc\u51fa\u9519\u8bef";
    }

    @Override
    public String exportando() {
        return "\u6b63\u5728\u5bfc\u51fa";
    }

    @Override
    public String exportacionTardara() {
        return "\u5bfc\u51fa\u53ef\u80fd\u9700\u8981\u4e00\u4e9b\u65f6\u95f4";
    }

    @Override
    public String porFavorEspere() {
        return "\u8bf7\u7a0d\u5019";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u60a8\u7f3a\u5c11 VLC \u4e8c\u8fdb\u5236\u6587\u4ef6\u3002WaterMedia \u9700\u8981 VLC \u4e8c\u8fdb\u5236\u6587\u4ef6\u3002\u8bf7\u4ece https://www.videolan.org/vlc/ \u624b\u52a8\u5b89\u88c5\u3002  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "\u4e0b\u8f7d VLC";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u9519\u8bef\uff1a\u6a21\u5757\u540d\u79f0 '" + nombreModulo + "' \u5305\u542b\u65e0\u6548\u5b57\u7b26\u3002\u5176\u4e2d '" + parteInvalida + "' \u4e0d\u662f\u6709\u6548\u7684 Java \u6807\u8bc6\u7b26\u3002\u5f53\u6a21\u7ec4\u5728\u5176\u540d\u79f0\u4e2d\u4f7f\u7528 Java \u4fdd\u7559\u5b57\uff08\u5982 'true'\u3001'class'\uff09\u6216\u4e0d\u5141\u8bb8\u7684\u5b57\u7b26\u65f6\u4f1a\u53d1\u751f\u6b64\u95ee\u9898\u3002</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "\u6a21\u7ec4\u540d\u79f0\u5305\u542b\u65e0\u6548\u5b57\u7b26";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "\u6a21\u7ec4\u540d\u79f0 '" + nombreModulo + "' \u65e0\u6548\uff0c\u56e0\u4e3a\u5b83\u5305\u542b '" + parteInvalida + "'\uff0c\u8fd9\u662f Java \u4fdd\u7559\u5b57\u6216\u4e0d\u5141\u8bb8\u7684\u5b57\u7b26\u3002\u5728\u65e5\u5fd7\u4e2d\u67e5\u627e\u5bf9\u5e94\u6b64\u540d\u79f0\u7684\u6a21\u7ec4\uff08\u901a\u5e38\u662f JAR \u6587\u4ef6\u540d\uff09";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "\u8fdb\u5165\u6a21\u7ec4\u6587\u4ef6\u5939\uff0c\u7f16\u8f91 <b>/META-INF/</b> \u6587\u4ef6\u5939\u5185\u7684 <b>mods.toml</b> \u6587\u4ef6\u3002\u5c06 <b>modId</b> \u7684\u503c\u6539\u4e3a\u4ec5\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u907f\u514d\u4f7f\u7528 Java \u4fdd\u7559\u5b57";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "\u6709\u6548\u540d\u79f0\u793a\u4f8b\uff1a'truemod_shot_enchantment' \u4ee3\u66ff 'true.shot.enchantment'\u3002\u8bf7\u8bb0\u4f4f\uff0c\u6a21\u7ec4\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u70b9\u53f7\u3001\u8fde\u5b57\u7b26\u6216 Java \u4fdd\u7559\u5b57\u5982 'true'\u3001'false' \u6216 'class'";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6a21\u7ec4 '" + nombreJar + "' \u5b58\u5728\u4e25\u91cd\u9519\u8bef\uff1a\u5176\u4f9d\u8d56\u9879\u7f3a\u5c11\u5fc5\u9700\u7684 'mandatory' \u5b57\u6bb5\u3002\u5f53 mods.toml \u6587\u4ef6\u672a\u6307\u660e\u4f9d\u8d56\u662f\u5426\u4e3a\u5fc5\u9700\u65f6\u4f1a\u53d1\u751f\u6b64\u95ee\u9898\u3002</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "\u6a21\u7ec4\u4f9d\u8d56\u9879\u7f3a\u5c11\u5fc5\u9700\u5b57\u6bb5";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "\u95ee\u9898\u6a21\u7ec4\u4e3a\uff1a<b>" + nombreJar + "</b>\u3002\u6b64\u6587\u4ef6\u7684\u4f9d\u8d56\u914d\u7f6e\u6709\u8bef";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "\u6253\u5f00\u6a21\u7ec4 <b>" + nombreJar + "</b> \u7684 <b>/META-INF/</b> \u6587\u4ef6\u5939\u4e2d\u7684 <b>mods.toml</b> \u6587\u4ef6";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "\u5728\u4f9d\u8d56\u9879\u90e8\u5206\uff0c\u786e\u4fdd\u6bcf\u4e2a\u6761\u76ee\u90fd\u5305\u542b <b>mandatory=true</b> \u6216 <b>mandatory=false</b>\uff08\u4f8b\u5982\uff1amodId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" \uff09";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u9519\u8bef\uff1a\u6a21\u7ec4 '" + nombreJar + "' \u7684\u8bbf\u95ee\u8f6c\u6362\u5668\uff08access transformer\uff09\u914d\u7f6e\u65e0\u6548\u3002\u5f53\u914d\u7f6e\u6587\u4ef6\u8bed\u6cd5\u9519\u8bef\u6216\u5f15\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u7c7b/\u65b9\u6cd5\u65f6\u4f1a\u53d1\u751f\u6b64\u95ee\u9898\u3002</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "\u65e0\u6548\u7684\u8bbf\u95ee\u8f6c\u6362\u5668";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "\u95ee\u9898\u6a21\u7ec4\u4e3a\uff1a<b>" + nombreJar + "</b>\u3002\u6b64\u6a21\u7ec4\u5305\u542b\u65e0\u6548\u7684 access transformer \u914d\u7f6e";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "\u6253\u5f00\u6a21\u7ec4 <b>" + nombreJar + "</b> \u5185\u7684 <b>accessTransformer.cfg</b> \u6587\u4ef6\uff08\u901a\u5e38\u4f4d\u4e8e JAR \u6587\u4ef6\u6839\u76ee\u5f55\uff09";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "\u4fee\u590d access transformer \u7684\u8bed\u6cd5\u3002\u6bcf\u884c\u5e94\u9075\u5faa\u683c\u5f0f\uff1a<b>access class.method</b>\uff08\u4f8b\u5982\uff1apublic net.minecraft.world.entity.Entity.func_200560_a\uff09\u3002\u5220\u9664\u5f15\u7528\u4e86\u5f53\u524d Minecraft \u7248\u672c\u4e2d\u4e0d\u5b58\u5728\u7684\u7c7b\u6216\u65b9\u6cd5\u7684\u884c";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u9519\u8bef\uff1a@Mod \u6ce8\u89e3\u4e2d\u7684\u6a21\u7ec4 ID \u4e0e mods.toml \u6587\u4ef6\u4e2d\u7684 ID \u4e0d\u5339\u914d\u3002\u6a21\u7ec4 '" + nombreMod + "' \u65e0\u6cd5\u52a0\u8f7d\uff0c\u56e0\u4e3a ID \u4e0d\u4e00\u81f4\u3002</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "@Mod \u4e0e mods.toml \u4e2d\u7684 ID \u4e0d\u5339\u914d";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "\u6b63\u5728\u5f00\u53d1\u7684\u6a21\u7ec4 '" + nombreMod + "' \u5728 <b>@Mod</b> \u6ce8\u89e3\u548c <b>mods.toml</b> \u6587\u4ef6\u4e2d\u7684 ID \u5b58\u5728\u4e0d\u4e00\u81f4";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "\u68c0\u67e5\u4e3b\u7c7b\u4e2d\u7684 ID \u662f\u5426\u4e0e <b>/META-INF/mods.toml</b> \u6587\u4ef6\u4e2d\u7684 <b>modId</b> \u503c\u4e00\u81f4\u3002\u4f8b\u5982\uff1a<b>@Mod(\"mymod\")</b> \u5fc5\u987b\u4e0e <b>modId=\"mymod\"</b> \u5339\u914d";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "\u5982\u679c\u4f7f\u7528 Gradle\uff0c\u5728\u4fee\u6539\u540e\u8fd0\u884c <b>clean</b> \u4ee5\u786e\u4fdd\u8d44\u6e90\u6b63\u786e\u66f4\u65b0\u3002\u6709\u65f6\u65e7\u6587\u4ef6\u4f1a\u6b8b\u7559\u5728 build \u6587\u4ef6\u5939\u4e2d";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u5ba2\u6237\u7aef" : "\u670d\u52a1\u7aef";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u670d\u52a1\u7aef" : "\u5ba2\u6237\u7aef";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u9519\u8bef\uff1a\u6b63\u5728\u5c1d\u8bd5\u5728" + plataforma + "\u73af\u5883\u4e2d\u52a0\u8f7d\u7c7b '" + nombreClase + "'\uff0c\u4f46\u8be5\u7c7b\u662f\u4e3a" + plataformaOpuesta + "\u8bbe\u8ba1\u7684\u3002<b>\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684\u201c\u6a21\u7ec4\u6811\u201d\u529f\u80fd\u67e5\u627e\u662f\u54ea\u4e2a\u6a21\u7ec4\u5c1d\u8bd5\u52a0\u8f7d\u6b64\u7c7b</b>\u3002\u6a21\u7ec4\u662f\u4e3a\u7279\u5b9a\u5e73\u53f0\u6784\u5efa\u7684\uff0c\u4e0d\u80fd\u5728\u53e6\u4e00\u5e73\u53f0\u8fd0\u884c\u3002</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "\u6a21\u7ec4\u5e73\u53f0\u9519\u8bef";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "\u5728\u53f3\u4fa7\u7684 <b>\u6a21\u7ec4\u6811</b> \u9009\u9879\u5361\u4e2d\uff0c\u641c\u7d22\u5bf9\u7c7b <b>" + nombreClase + "</b> \u7684\u5f15\u7528\uff0c\u4ee5\u8bc6\u522b\u5bfc\u81f4\u95ee\u9898\u7684\u6a21\u7ec4";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u5ba2\u6237\u7aef" : "\u670d\u52a1\u7aef";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u670d\u52a1\u7aef" : "\u5ba2\u6237\u7aef";
        return "\u8bc6\u522b\u51fa\u7684\u6a21\u7ec4\u662f\u7528\u4e8e <b>" + plataformaOpuesta + "</b> \u7684\uff0c\u4e0d\u5e94\u5728\u60a8\u7684" + plataforma + "\u73af\u5883\u4e2d\u4f7f\u7528\u3002";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "\u4ece\u60a8\u7684 <b>mods</b> \u6587\u4ef6\u5939\u4e2d\u5220\u9664\u95ee\u9898\u6a21\u7ec4\u3002\u5982\u679c\u9700\u8981\u6b64\u5e73\u53f0\u7684\u7c7b\u4f3c\u529f\u80fd\uff0c\u8bf7\u5bfb\u627e\u4e13\u4e3a <b>\u5ba2\u6237\u7aef</b> \u6216 <b>\u670d\u52a1\u7aef</b> \u8bbe\u8ba1\u7684\u66ff\u4ee3\u6a21\u7ec4";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u4e25\u91cd\u9519\u8bef\uff1a\u7f3a\u5c11 modid '").append(modIdFaltante).append("' \u7684\u5143\u6570\u636e\u3002 ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("\u4ee5\u4e0b\u6a21\u7ec4\u53ef\u80fd\u5bfc\u81f4\u6b64\u95ee\u9898\uff1a<b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", \u7b49\u7b49...");
            }
            mensaje.append("</b>\u3002 ");
        }
        mensaje.append("\u5f53\u67d0\u4e2a\u6a21\u7ec4\u4f9d\u8d56\u4e8e\u672a\u5b89\u88c5\u7684\u6a21\u7ec4\u6216 mods.toml \u6587\u4ef6\u9519\u8bef\u65f6\u4f1a\u53d1\u751f\u6b64\u95ee\u9898\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "\u7f3a\u5c11 mods.toml \u5143\u6570\u636e";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u4ee5\u4e0b\u6a21\u7ec4\u4f9d\u8d56 '").append(modIdFaltante).append("': <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", \u7b49\u7b49...");
            }
            paso.append("</b>\u3002\u4f7f\u7528 <b>\u6a21\u7ec4\u6811</b> \u529f\u80fd\u786e\u8ba4\u54ea\u4e2a\u6a21\u7ec4\u5bfc\u81f4\u95ee\u9898");
            return paso.toString();
        }
        return "\u67d0\u4e2a\u6a21\u7ec4\u8bd5\u56fe\u4f9d\u8d56 '" + modIdFaltante + "'\uff0c\u4f46\u8be5\u6a21\u7ec4\u672a\u5b89\u88c5\u3002\u4f7f\u7528 <b>\u6a21\u7ec4\u6811</b> \u529f\u80fd\u8bc6\u522b\u95ee\u9898\u6a21\u7ec4";
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u60a8\u6709\u4e24\u4e2a\u9009\u62e9\uff1a<br/>1. <b>\u5b89\u88c5\u7f3a\u5931\u7684\u6a21\u7ec4</b>\uff1a\u67e5\u627e\u5e76\u5b89\u88c5 ID \u4e3a '" + modIdFaltante + "' \u7684\u6a21\u7ec4<br/>2. <b>\u5220\u9664\u4f9d\u8d56\u6a21\u7ec4</b>\uff1a\u5982\u679c\u4e0d\u9700\u8981\u8be5\u529f\u80fd\uff0c\u8bf7\u5220\u9664\u4f9d\u8d56 '" + modIdFaltante + "' \u7684\u6a21\u7ec4";
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u5982\u679c '" + modIdFaltante + "' \u662f\u5e93\u6587\u4ef6\uff08\u5982 'forge', 'minecraft', 'curios'\uff09\uff0c\u8bf7\u786e\u4fdd\u5df2\u5b89\u88c5\u6b63\u786e\u7248\u672c\u7684 Minecraft \u548c Forge\u3002\u5982\u679c\u662f\u666e\u901a\u6a21\u7ec4\uff0c\u8bf7\u67e5\u770b\u5176\u4e0b\u8f7d\u9875\u9762\u4ee5\u786e\u8ba4\u524d\u7f6e\u4f9d\u8d56";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u8b66\u544a\uff1a\u58f0\u97f3\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\u3002\u58f0\u97f3\u548c\u97f3\u4e50\u5df2\u88ab\u7981\u7528\u3002\u6b64\u9519\u8bef\u901a\u5e38\u4e0e SoundPhysicsMod \u6a21\u7ec4\u76f8\u5173\uff0c\u53ef\u80fd\u7531\u4e0e\u5176\u4ed6\u58f0\u97f3\u5e93\u7684\u51b2\u7a81\u5f15\u8d77\u3002</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "\u58f0\u97f3\u7cfb\u7edf\u9519\u8bef";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "\u8be5\u9519\u8bef\u901a\u5e38\u4e0e <b>SoundPhysicsMod</b> \u76f8\u5173\u3002\u8bf7\u68c0\u67e5\u662f\u5426\u5b89\u88c5\u4e86\u4e0e\u60a8\u7684 Minecraft \u7248\u672c\u517c\u5bb9\u7684\u6700\u65b0\u7248\u672c";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "\u5982\u679c\u60a8\u4f7f\u7528\u5176\u4ed6\u58f0\u97f3\u6a21\u7ec4\uff08\u5982 Sound Filters\u3001Dynamic Surroundings \u7b49\uff09\uff0c\u8bf7\u5c1d\u8bd5\u6682\u65f6\u79fb\u9664 SoundPhysicsMod \u4ee5\u67e5\u770b\u662f\u5426\u89e3\u51b3\u51b2\u7a81";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "\u68c0\u67e5 <b>logs</b> \u6587\u4ef6\u5939\uff0c\u67e5\u627e\u4e0e LWJGL \u6216 OpenAL \u76f8\u5173\u7684\u989d\u5916\u4fe1\u606f\uff0c\u8fd9\u4e9b\u53ef\u80fd\u8868\u660e\u5e95\u5c42\u58f0\u97f3\u5e93\u5b58\u5728\u95ee\u9898";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u4e25\u91cd\u9519\u8bef\uff1a\u7c7b '").append(nombreClase).append("' \u5df2\u6ce8\u518c\u4e3a\u4e8b\u4ef6\u76d1\u542c\u5668\uff0c\u4f46\u4e0d\u5305\u542b\u6709\u6548\u65b9\u6cd5\u3002 ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u6b64\u7c7b\u4f4d\u4e8e\u4ee5\u4e0b\u6a21\u7ec4\u4e2d\uff1a <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u7b49\u7b49...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u5f53\u4e00\u4e2a\u7c7b\u88ab\u6ce8\u518c\u7528\u4e8e\u76d1\u542c\u4e8b\u4ef6\uff0c\u4f46\u6ca1\u6709\u5305\u542b @SubscribeEvent \u6ce8\u89e3\u7684\u65b9\u6cd5\u65f6\uff0c\u4f1a\u53d1\u751f\u6b64\u95ee\u9898\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "\u7c7b\u5df2\u6ce8\u518c\u4f46\u65e0\u4e8b\u4ef6\u76d1\u542c\u5668";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u95ee\u9898\u7c7b\u4f4d\u4e8e\u8fd9\u4e9b\u6a21\u7ec4\u4e2d\uff1a<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u7b49\u7b49...");
            }
            paso.append("</b>\u3002\u8fd9\u4e9b\u6a21\u7ec4\u8bd5\u56fe\u6ce8\u518c\u4e8b\u4ef6\u4f46\u6ca1\u6709\u6709\u6548\u65b9\u6cd5");
            return paso.toString();
        }
        return "\u7c7b <b>" + nombreClase + "</b> \u5df2\u88ab\u6ce8\u518c\u7528\u4e8e\u76d1\u542c\u4e8b\u4ef6\uff0c\u4f46\u672a\u5305\u542b <b>@SubscribeEvent</b> \u6ce8\u89e3\u7684\u65b9\u6cd5\u3002\u8bf7\u4f7f\u7528 <b>\u6a21\u7ec4\u6811</b> \u529f\u80fd\u8bc6\u522b\u5305\u542b\u6b64\u7c7b\u7684\u6a21\u7ec4";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "\u5728\u6e90\u4ee3\u7801\u4e2d\uff0c\u786e\u4fdd\u7c7b <b>" + nombreClase + "</b> \u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u5982\u4e0b\u683c\u5f0f\u7684\u65b9\u6cd5\uff1a <b>@SubscribeEvent public void \u65b9\u6cd5\u540d(\u7279\u5b9a\u4e8b\u4ef6 \u4e8b\u4ef6) { ... }</b>\u3002 \u5982\u679c\u662f\u5185\u90e8\u7c7b\uff0c\u8bf7\u786e\u4fdd\u5176\u672a\u6807\u8bb0\u4e3a static";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("\u5bf9\u4e8e\u5df2\u8bc6\u522b\u7684\u6a21\u7ec4 (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", \u7b49\u7b49");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("\u8bf7\u8054\u7cfb\u8be5\u6a21\u7ec4\u5f00\u53d1\u8005\u4fee\u590d\u95ee\u9898\u3002 ");
            } else {
                paso.append("\u8bf7\u8054\u7cfb\u8fd9\u4e9b\u6a21\u7ec4\u7684\u5f00\u53d1\u8005\u4fee\u590d\u95ee\u9898\u3002 ");
            }
        }
        paso.append("\u5982\u679c\u60a8\u662f\u5f00\u53d1\u8005\uff0c\u8bf7\u4ece EventBus \u4e2d\u79fb\u9664\u6b64\u7c7b\u7684\u6ce8\u518c\uff0c\u6216\u6dfb\u52a0\u6709\u6548\u7684 @SubscribeEvent \u65b9\u6cd5");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u9519\u8bef\uff1a\u5904\u7406\u6587\u4ef6 '" + nombreArchivo + "' \u65f6\u53d1\u751f 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' \u5f02\u5e38\u3002\u6b64\u9519\u8bef\u8868\u660e\u542f\u52a8\u5668\u672a\u80fd\u6b63\u786e\u4e0b\u8f7d\u6216\u89e3\u538b\u6574\u5408\u5305\u6587\u4ef6\u3002\u9519\u8bef\u4fe1\u606f 'zip END header not found' \u8868\u660e JAR \u6587\u4ef6\u4e0d\u5b8c\u6574\u6216\u5df2\u635f\u574f\uff0c\u8fd9\u5728\u65e0\u6cd5\u59a5\u5584\u5904\u7406\u5927\u6587\u4ef6\u4e0b\u8f7d\u7684\u542f\u52a8\u5668\u4e2d\u6781\u4e3a\u5e38\u89c1\u3002\u6b64\u95ee\u9898\u4e3b\u8981\u5f71\u54cd Twitch/CurseForge\u3001Technic Launcher \u7528\u6237\uff0c\u5c24\u5176\u662f Luna Pixel \u7528\u6237\uff0c\u56e0\u4e3a\u8fd9\u4e9b\u542f\u52a8\u5668\u901a\u5e38\u65e0\u6cd5\u5b8c\u6574\u9a8c\u8bc1\u5df2\u4e0b\u8f7d\u6587\u4ef6\u7684\u5b8c\u6574\u6027\u3002Luna Pixel \u7528\u6237\u5e94\u8003\u8651\u6539\u7528 ATLauncher \u4f5c\u4e3a\u66f4\u7a33\u5b9a\u7684\u66ff\u4ee3\u65b9\u6848\uff0c\u5b83\u80fd\u66f4\u597d\u5730\u5904\u7406\u6587\u4ef6\u5b8c\u6574\u6027\u5e76\u907f\u514d\u6b64\u7279\u5b9a\u9519\u8bef\u3002\u7cfb\u7edf\u65e0\u6cd5\u52a0\u8f7d\u6a21\u7ec4\uff0c\u56e0\u4e3a ZIP \u683c\u5f0f\u5df2\u635f\u574f\uff0c\u5bfc\u81f4 Forge \u65e0\u6cd5\u8bfb\u53d6\u542f\u52a8\u6e38\u620f\u6240\u9700\u7684\u8d44\u6e90\u3002</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "UnionFileSystem \u9519\u8bef - \u6587\u4ef6\u635f\u574f";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "\u4ece\u5934\u5f00\u59cb\u5b8c\u5168\u91cd\u65b0\u5b89\u88c5\u6574\u5408\u5305";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "\u5982\u679c\u4f60\u4f7f\u7528 Luna Pixel\uff0c\u8bf7\u5207\u6362\u5230 ATLauncher";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "\u91cd\u65b0\u5b89\u88c5\u524d\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u548c\u78c1\u76d8\u7a7a\u95f4";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "\u662f\u5426\u542f\u7528 ProxySysOutSysErr\uff1f\n\n\u6b64\u9009\u9879\u5141\u8bb8 CrashDetector \u5728\u542f\u52a8\u5668\u672a\u63d0\u4f9b\u65e5\u5fd7\u65f6\u8bbf\u95ee System.out \u548c System.err\u3002\n\n\u4ec5\u5728\u65e0\u6cd5\u624b\u52a8\u7c98\u8d34\u65e5\u5fd7\u65f6\u542f\u7528\u3002\n\n\u8b66\u544a\uff1a\u53ef\u80fd\u4e0e\u67d0\u4e9b\u6a21\u7ec4\u6216\u542f\u52a8\u5668\u51b2\u7a81\u3002\n\n\u9700\u8981\u91cd\u542f\u6e38\u620f/\u5e94\u7528\u4ee5\u4f7f\u66f4\u6539\u751f\u6548\u3002";
    }

    @Override
    public String confirmacionTitulo() {
        return "\u786e\u8ba4";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr \u5df2\u6210\u529f\u542f\u7528\u3002\n\n\u9700\u8981\u91cd\u542f CrashDetector \u4ee5\u4f7f\u66f4\u6539\u751f\u6548\u3002";
    }

    @Override
    public String informacionTitulo() {
        return "\u4fe1\u606f";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("\u4e25\u91cd\u9519\u8bef\uff1aAzureLib \u548c GeckoLib \u521d\u59cb\u5316\u8fc7\u65e9\uff01 ");
        } else if (azureLibError) {
            mensaje.append("\u4e25\u91cd\u9519\u8bef\uff1aAzureLib \u521d\u59cb\u5316\u8fc7\u65e9\uff01 ");
        } else if (geckoLibError) {
            mensaje.append("\u4e25\u91cd\u9519\u8bef\uff1aGeckoLib \u521d\u59cb\u5316\u8fc7\u65e9\uff01 ");
        }
        mensaje.append("\u5f53\u5c1d\u8bd5\u5728\u975e Fabric \u73af\u5883\u4e0b\u4f7f\u7528 Fabric \u7248\u672c\u7684\u8fd9\u4e9b\u5e93\u65f6\uff0c\u4f1a\u53d1\u751f\u6b64\u9519\u8bef\u3002 ");
        if (connectorPresente) {
            mensaje.append("\u68c0\u6d4b\u5230\u517c\u5bb9\u6027\u6a21\u7ec4\uff08Sinytra Connector \u6216 specialcompatibilityoperation\uff09\uff0c\u8868\u660e\u4f60\u6b63\u5728 Forge \u6216 FeatureCreep \u73af\u5883\u4e2d\u8fd0\u884c Fabric \u6a21\u7ec4\u3002 ");
            mensaje.append("\u8bf7\u5728\u65e5\u5fd7\u4e2d\u68c0\u67e5 'FabricMC \u521d\u59cb\u5316\u9519\u8bef'\uff0c\u4ee5\u786e\u5b9a\u5177\u4f53\u662f\u54ea\u4e2a\u6a21\u7ec4\u5bfc\u81f4\u95ee\u9898\u3002 ");
        }
        mensaje.append("AzureLib \u548c GeckoLib \u662f\u52a8\u753b\u6a21\u7ec4\u7684\u5173\u952e\u5e93\uff0c\u4f46\u5fc5\u987b\u4e0e\u6b63\u786e\u7684\u5e73\u53f0\uff08Fabric \u6216 Forge\uff09\u5339\u914d\u3002 ");
        mensaje.append("\u7531\u4e8e\u521d\u59cb\u5316\u51b2\u7a81\uff0c\u6e38\u620f\u65e0\u6cd5\u6b63\u786e\u52a0\u8f7d\u52a8\u753b\u6a21\u7ec4\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "\u5e93\u521d\u59cb\u5316\u8fc7\u65e9";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "\u68c0\u67e5\u65e5\u5fd7\u4e2d\u7684 'FabricMC \u521d\u59cb\u5316\u9519\u8bef' \u4ee5\u786e\u5b9a\u95ee\u9898\u6a21\u7ec4";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "\u786e\u4fdd\u4f60\u4f7f\u7528\u7684\u662f\u9002\u7528\u4e8e\u4f60\u5e73\u53f0\uff08Forge \u6216 Fabric\uff09\u7684\u6b63\u786e\u7248\u672c\u7684 AzureLib/GeckoLib";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u9519\u8bef\uff1aC2ME \u4e0e\u8fde\u63a5\u6a21\u7ec4\u4e0d\u517c\u5bb9\u3002 \u6b64\u9519\u8bef\u53d1\u751f\u7684\u539f\u56e0\u662f C2ME \u5c1d\u8bd5\u8bbf\u95ee Java \u5185\u90e8\u7ec4\u4ef6\uff0c\u800c\u8fd9\u4e9b\u7ec4\u4ef6\u5728 Sinytra Connector \u6216 specialcompatibilityoperation \u7b49 Fabric/Forge \u517c\u5bb9\u6027\u6a21\u7ec4\u73af\u5883\u4e2d\u53d7\u5230\u9650\u5236\u3002 <b>C2ME \u4e0d\u517c\u5bb9\u8fd9\u4e9b\u73af\u5883\uff0c\u4f46 <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> \u662f\u63a8\u8350\u7684\u66ff\u4ee3\u65b9\u6848</b>\uff0c\u53ef\u4e0e\u8fde\u63a5\u6a21\u7ec4\u6b63\u5e38\u534f\u4f5c\u3002 \u7531\u4e8e Java \u5b89\u5168\u6743\u9650\u51b2\u7a81\uff0c\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "C2ME \u4e0e\u8fde\u63a5\u6a21\u7ec4\u4e0d\u517c\u5bb9";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "\u4ece mods \u6587\u4ef6\u5939\u4e2d\u5220\u9664 C2ME";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "\u4e0b\u8f7d\u5e76\u5b89\u88c5 <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> \u4f5c\u4e3a\u66ff\u4ee3\uff08\u517c\u5bb9 Sinytra Connector\uff09";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "\u786e\u4fdd\u6240\u6709\u8fde\u63a5\u6a21\u7ec4\uff08\u5982 Sinytra Connector\uff09\u5747\u5df2\u66f4\u65b0\u81f3\u6700\u65b0\u7248\u672c";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e25\u91cd\u9519\u8bef\uff1a\u52a0\u8f7d\u6a21\u7ec4 '" + modId + "' \u7684 JEI \u63d2\u4ef6\u5931\u8d25\u3002\u7c7b '" + nombreClase + "' (\u63d2\u4ef6ID: '" + pluginId + "') \u629b\u51fa\u9519\u8bef\uff0c\u5bfc\u81f4\u6e38\u620f\u5728\u542f\u52a8\u65f6\u5d29\u6e83\u3002\u5f53\u67d0\u4e2a\u6a21\u7ec4\u7684 JEI \u96c6\u6210\u4e0d\u517c\u5bb9\u6216\u635f\u574f\uff0c\u5e72\u6270\u6e38\u620f\u521d\u59cb\u5316\u65f6\uff0c\u5c31\u4f1a\u51fa\u73b0\u6b64\u95ee\u9898\u3002</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "JEI \u63d2\u4ef6\u5931\u8d25 - \u5bfc\u81f4\u5d29\u6e83";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "\u6a21\u7ec4 <b>" + modId + "</b> \u5305\u542b\u4e00\u4e2a\u635f\u574f\u7684 JEI \u63d2\u4ef6\uff0c\u5bfc\u81f4\u5d29\u6e83\u3002\u4f7f\u7528 <b>\u6a21\u7ec4\u6811</b> \u529f\u80fd\u786e\u8ba4\u662f\u54ea\u4e2a\u6a21\u7ec4\u5f15\u53d1\u95ee\u9898";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "\u6682\u65f6\u4ece mods \u6587\u4ef6\u5939\u4e2d\u79fb\u9664\u6a21\u7ec4 <b>" + modId + "</b>\uff0c\u68c0\u67e5\u662f\u5426\u80fd\u89e3\u51b3\u5d29\u6e83\u95ee\u9898";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "\u67e5\u627e\u6a21\u7ec4 <b>" + modId + "</b> \u7684\u66f4\u65b0\uff0c\u6216\u8054\u7cfb\u5176\u5f00\u53d1\u8005\u62a5\u544a JEI \u63d2\u4ef6\u95ee\u9898\u3002\u540c\u65f6\uff0c\u5fc5\u987b\u79fb\u9664\u8be5\u6a21\u7ec4\u624d\u80fd\u6b63\u5e38\u542f\u52a8\u6e38\u620f";
    }

    @Override
    public String tituloLectador() {
        return "\u65e5\u5fd7\u9605\u8bfb\u5668 - \u5d29\u6e83\u68c0\u6d4b";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "\u989c\u8272\u56fe\u4f8b";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "\u4e25\u91cd\u9519\u8bef";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "\u5806\u6808\u8ddf\u8e2a";
    }

    @Override
    public String obtenerTituloError() {
        return "\u9519\u8bef";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "\u5904\u7406\u6240\u9009\u884c\u65f6\u53d1\u751f\u9519\u8bef";
    }

    @Override
    public String obtenerNombreError() {
        return "\u9519\u8bef\u540d\u79f0";
    }

    @Override
    public String obtenerDescripcionError() {
        return "\u8be6\u7ec6\u63cf\u8ff0";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "\u9009\u62e9\u65e5\u5fd7";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "\u672a\u8bc6\u522b\u7684\u9519\u8bef";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "\u5728\u65e5\u5fd7\u4e2d\u68c0\u6d4b\u5230\u4e25\u91cd\u9519\u8bef\u3002 \u8bf7\u68c0\u67e5\u5806\u6808\u8ddf\u8e2a\u4ee5\u786e\u5b9a\u6839\u672c\u539f\u56e0\u3002";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "\u65e0\u6cd5\u8bfb\u53d6\u65e5\u5fd7\u6587\u4ef6\u3002 \u8bf7\u786e\u8ba4\u6587\u4ef6\u5b58\u5728\u4e14\u5177\u6709\u8bfb\u53d6\u6743\u9650\u3002";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "\u65e5\u5fd7\u5206\u6790\u5668";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u4e25\u91cd\u9519\u8bef\uff1a\u65e0\u6cd5\u4e3a\u6a21\u7ec4 '").append(modId).append("' \u6ce8\u518c\u81ea\u52a8\u4e8b\u4ef6\u8ba2\u9605\u8005\u3002 ");
        mensaje.append("\u95ee\u9898\u7c7b\uff1a <b>").append(nombreClase).append("</b>\u3002 ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u6b64\u7c7b\u4f4d\u4e8e\uff1a<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u7b49\u7b49...");
            }
            mensaje.append("</b>\u3002 ");
        }
        mensaje.append("\u5f53\u6a21\u7ec4\u5c1d\u8bd5\u81ea\u52a8\u6ce8\u518c\u4e00\u4e2a\u7c7b\u4e3a\u4e8b\u4ef6\u8ba2\u9605\u8005\uff0c\u4f46\u8be5\u7c7b\u65e0\u6cd5\u52a0\u8f7d\u65f6\uff0c\u4f1a\u53d1\u751f\u6b64\u9519\u8bef\u3002 ");
        mensaje.append("<b>\u8bf7\u68c0\u67e5\u65e5\u5fd7\u4e2d\u6b64\u6d88\u606f\u4e4b\u524d\u7684\u5176\u4ed6\u9519\u8bef\uff0c\u771f\u6b63\u539f\u56e0\u53ef\u80fd\u662f\u4e4b\u524d\u7684\u52a0\u8f7d\u5931\u8d25</b>\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "\u81ea\u52a8\u8ba2\u9605\u8005\u6ce8\u518c\u5931\u8d25";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "\u6a21\u7ec4 <b>" + modId + "</b> \u6b63\u5728\u5c1d\u8bd5\u5c06\u7c7b <b>" + nombreClase + "</b> \u6ce8\u518c\u4e3a\u81ea\u52a8\u8ba2\u9605\u8005\uff0c\u4f46\u5931\u8d25\u4e86\u3002\u8bf7\u68c0\u67e5\u6b64\u7c7b\u662f\u5426\u5b58\u5728\u4e14\u53ef\u8bbf\u95ee";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u95ee\u9898\u7c7b <b>" + nombreClase + "</b> \u4f4d\u4e8e\u8fd9\u4e9b\u6587\u4ef6\u4e2d\uff1a<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u7b49\u7b49...");
            }
            paso.append("</b>\u3002 ");
            paso.append("\u4f7f\u7528 <b>\u6a21\u7ec4\u6811</b> \u529f\u80fd\u786e\u8ba4\u54ea\u4e2a\u6587\u4ef6\u5305\u542b\u95ee\u9898\u7c7b");
            return paso.toString();
        }
        return "\u7c7b <b>" + nombreClase + "</b> \u5728\u4efb\u4f55\u6a21\u7ec4\u6587\u4ef6\u4e2d\u90fd\u672a\u627e\u5230\u3002\u8bf7\u68c0\u67e5\u6a21\u7ec4 <b>" + modId + "</b> \u662f\u5426\u6b63\u786e\u5b89\u88c5\u3002\u4f7f\u7528 <b>\u6a21\u7ec4\u6811</b> \u529f\u80fd\u5e2e\u52a9\u5b9a\u4f4d\u95ee\u9898";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "\u5c06\u6a21\u7ec4 <b>" + modId + "</b> \u66f4\u65b0\u81f3\u4e0e\u4f60\u7684 Minecraft \u548c Forge \u7248\u672c\u517c\u5bb9\u7684\u6700\u65b0\u7248\u672c\u3002 \u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u6a21\u7ec4\u5f00\u53d1\u8005\u5e76\u62a5\u544a\u5305\u542b\u95ee\u9898\u7c7b\u7684\u9519\u8bef";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "\u8bf7\u68c0\u67e5\u6b64\u6d88\u606f\u4e4b\u524d\u7684 <b>\u65e5\u5fd7\u4e2d\u7684\u5176\u4ed6\u9519\u8bef</b>\uff0c\u56e0\u4e3a\u771f\u6b63\u7684\u95ee\u9898\u53ef\u80fd\u51fa\u73b0\u5728\u4e4b\u524d\u7684\u52a0\u8f7d\u5931\u8d25\u4e2d\u3002 \u6709\u65f6\u5148\u524d\u7684\u9519\u8bef\u4f1a\u963b\u6b62\u5fc5\u8981\u7c7b\u7684\u52a0\u8f7d\uff0c\u5bfc\u81f4\u4e8b\u4ef6\u6ce8\u518c\u5931\u8d25";
    }

    @Override
    public String limpiado() {
        return "\u5df2\u6e05\u7406";
    }

    @Override
    public String original() {
        return "\u539f\u59cb";
    }

    @Override
    public String verEnConsola() {
        return "\u5728\u65e5\u5fd7\u4e2d\u67e5\u770b";
    }

    @Override
    public String advertencia() {
        return "\u8b66\u544a";
    }

    @Override
    public String fatal() {
        return "\u81f4\u547d";
    }

    @Override
    public String noRegistroDeBattly() {
        return "BattlyLauncher \u6ca1\u6709\u53ef\u4f9b\u590d\u5236\u7684\u65e5\u5fd7\u6216\u63a7\u5236\u53f0\u3002\u4f60\u53ef\u4ee5\u4f7f\u7528 ProxySysOutSysErr \u6765\u62e6\u622a STDOUT \u548c STDERR \u5e76\u91cd\u542f\u6e38\u620f\uff0c\u4f46 ProxySysOutSysErr \u53ef\u80fd\u4e0e\u4fee\u6539 STDOUT \u6216 STDERR \u7684\u6a21\u7ec4\u53d1\u751f\u51b2\u7a81";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "\u4f60\u9700\u8981\u5728 NightWorld \u8bbe\u7f6e\u4e2d\u542f\u7528\u8c03\u8bd5\u6a21\u5f0f\u4ee5\u83b7\u53d6\u542f\u52a8\u5668\u65e5\u5fd7\u3002\u8fd9\u975e\u5e38\u91cd\u8981\uff0c\u56e0\u4e3a\u5b83\u5305\u542b STDOUT \u548c STDERR";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "\u4f60\u9700\u8981\u4fdd\u5b58\u6216\u7c98\u8d34\u4f60\u670d\u52a1\u5668\u7ec8\u7aef\u7684\u5185\u5bb9\uff0c\u56e0\u4e3a\u5b83\u5305\u542b\u5176\u4ed6\u65e5\u5fd7\u4e2d\u6ca1\u6709\u7684\u4fe1\u606f\uff0c\u5305\u62ec STDOUT\u3001STDERR \u548c\u5176\u4ed6\u9519\u8bef\u3002\u8bf7\u7c98\u8d34\u6700\u8fd1\u4e00\u6b21\u4f1a\u8bdd\u7684\u5185\u5bb9\u3002\u4eca\u540e\uff0c\u4f60\u53ef\u4ee5\u5c06\u7ec8\u7aef\u8f93\u51fa\u4fdd\u5b58\u5230\u6587\u4ef6 cd_launcherlog \u4e2d\u3002\u4e3a\u907f\u514d\u624b\u52a8\u7c98\u8d34\uff0c\u5728\u542f\u52a8\u547d\u4ee4\u540e\u6dfb\u52a0 >> cd_launcherlog\uff08\u5982\u56fe\u6240\u793a\uff09\u3002\u8bf7\u6ce8\u610f\uff0c\u8fd9\u6837\u505a\u5c06\u963b\u6b62\u4fe1\u606f\u663e\u793a\u5728\u7ec8\u7aef\u4e0a\uff1b\u6240\u6709\u5185\u5bb9\u53ea\u4f1a\u8bb0\u5f55\u5230\u8be5\u6587\u4ef6\u4e2d\u3002";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("\u4e25\u91cd\u9519\u8bef\uff1a\u5728 NeoForge \u73af\u5883\u4e2d\u68c0\u6d4b\u5230 LexForge \u8f6c\u6362\u5668\u3002 ");
        sb.append("</b>");
        sb.append("\u6d89\u53ca\u7684\u7c7b\uff1a <b>").append(claseReceptora).append("</b>\u3002 ");
        sb.append("\u53d7\u5f71\u54cd\u7684\u63a5\u53e3\u662f <b>").append(interfazObjetivo).append("</b>\uff0c");
        sb.append("\u7f3a\u5c11\u7684\u65b9\u6cd5\u4e3a <b>").append(firmaMetodoFaltante).append("</b>\u3002 ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u8be5\u7c7b\u4f4d\u4e8e\uff1a<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u7b49\u7b49...");
            }
            sb.append("</b>\u3002 ");
        } else {
            sb.append("\u672a\u627e\u5230\u5305\u542b\u6b64\u7c7b\u7684 JAR \u6587\u4ef6\uff1b\u53ef\u80fd\u88ab\u9634\u5f71\u5316\u6216\u4ee5 jar-in-jar \u5f62\u5f0f\u5d4c\u5165\u3002 ");
        }
        sb.append("\u5f53\u4e3a MinecraftForge/LexForge \u7f16\u8bd1\u7684 ModLauncher \u8f6c\u6362\u5668/\u670d\u52a1 ");
        sb.append("\u5728 NeoForge \u4e2d\u4f7f\u7528\u4e0d\u517c\u5bb9\u7684 ModLauncher API \u7248\u672c\u52a0\u8f7d\u65f6\uff0c\u4f1a\u51fa\u73b0\u6b64\u9519\u8bef\u3002 ");
        sb.append("\u8bf7\u66f4\u65b0\u6216\u66ff\u6362\u9002\u7528\u4e8e NeoForge \u7684\u7ec4\u4ef6\u3002");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "\u5728 NeoForge \u4e2d\u4f7f\u7528\u4e86 LexForge \u8f6c\u6362\u5668";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "\u8bc6\u522b\u4e0d\u517c\u5bb9\u7684\u8f6c\u6362\u5668\uff1a<b>" + claseReceptora + "</b>\u3002 \u9884\u671f\u7684 API \u662f <b>" + interfazObjetivo + "</b>\uff0c\u7f3a\u5c11\u65b9\u6cd5 <b>" + firmaMetodoFaltante + "</b>\u3002 \u68c0\u67e5\u6a21\u7ec4\u662f\u5426\u5728 <b>META-INF/services</b> \u4e2d\u6ce8\u518c\u4e86\u6b64\u7c7b\uff0c\u5e76\u5728 NeoForge \u4e2d\u79fb\u9664\u6216\u7981\u7528\u5b83\u3002";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u76f8\u5173\u6a21\u7ec4\u4f4d\u7f6e\uff1a<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u7b49\u7b49...");
            }
            sb.append("</b>\u3002 ");
        } else {
            sb.append("\u672a\u627e\u5230\u5305\u542b\u8be5\u7c7b\u7684 JAR \u6587\u4ef6\u3002\u8bf7\u68c0\u67e5 jar-in-jar \u548c\u9634\u5f71\u4f9d\u8d56\u9879\u3002 ");
        }
        sb.append("\u6682\u65f6\u79fb\u9664\u8fd9\u4e9b JAR \u6587\u4ef6\uff0c\u6216\u4f7f\u7528\u652f\u6301 NeoForge \u7684\u7248\u672c\u6765\u786e\u8ba4\u95ee\u9898\u6765\u6e90\u3002");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "\u5c06\u7ec4\u4ef6\u66ff\u6362\u4e3a NeoForge \u4e13\u7528\u7248\u672c\uff0c\u6216\u9488\u5bf9 NeoForge \u6240\u4f7f\u7528\u7684 ModLauncher \u7248\u672c\u91cd\u65b0\u7f16\u8bd1\u3002\u907f\u514d\u4f7f\u7528\u65e7\u7248 LexForge/MinecraftForge \u4e8c\u8fdb\u5236\u6587\u4ef6\u3002";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "\u6e05\u7406 mods \u6587\u4ef6\u5939\u5e76\u5220\u9664\u91cd\u590d\u7684 jar-in-jar \u6587\u4ef6\u3002\u5982\u6709\u5fc5\u8981\u6e05\u7a7a\u542f\u52a8\u5668\u7f13\u5b58\uff0c\u7136\u540e\u91cd\u542f\u4ee5\u786e\u8ba4\u4e0d\u518d\u52a0\u8f7d LexForge \u8f6c\u6362\u5668\u3002";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia \u65e0\u6cd5\u542f\u52a8\uff1aXenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("\u4e0d\u517c\u5bb9\u3002</b> ");
        sb.append("\u8bf7\u79fb\u9664 Xenon\uff0c\u6539\u7528 Embeddium \u6216 Sodium\u3002 ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u68c0\u6d4b\u5230\u4f4d\u7f6e\uff1a<b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u7b49\u7b49...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia \u4e0e Xenon \u4e0d\u517c\u5bb9";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return "\u68c0\u6d4b\u5230 " + label + " \u4e0e WaterMedia \u4e0d\u517c\u5bb9\u3002\u8bf7\u4ece\u914d\u7f6e\u4e2d\u79fb\u9664\u5b83\u3002";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("\u4f4d\u7f6e\uff1a<b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u7b49\u7b49...");
            }
            sb.append("</b>\u3002\u5220\u9664\u8be5 JAR \u6587\u4ef6\u3002");
            return sb.toString();
        }
        return "\u672a\u627e\u5230 JAR \u6587\u4ef6\u3002\u68c0\u67e5 mods \u6587\u4ef6\u5939\u5e76\u5220\u9664 Xenon\u3002";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "\u5b89\u88c5 Embeddium \u6216 Sodium \u4f5c\u4e3a\u66ff\u4ee3\uff0c\u5e76\u91cd\u542f\u6e38\u620f\u3002";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "\u538b\u7f29\u9519\u8bef (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>TACZ \u8d44\u6e90\u590d\u5236\u8fc7\u7a0b\u4e2d Deflater \u5df2\u5173\u95ed\u3002</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u76f8\u5173\u6587\u4ef6: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u7b49\u7b49");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>\u89e3\u51b3\u65b9\u6848\uff1a</b>\u5728 <code>tacz/tacz-pre.toml</code> \u4e2d\u8bbe\u7f6e <code>DefaultPackDebug=true</code>\u3002").append("\u5982\u6709\u9700\u8981\uff0c\u8bf7\u5148\u751f\u6210\u5730\u56fe\u518d\u6fc0\u6d3b\u3002");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "\u5728 tacz/tacz-pre.toml \u4e2d\u8bbe\u7f6e DefaultPackDebug=true\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u5148\u751f\u6210\u5730\u56fe\u518d\u6fc0\u6d3b\u3002";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "\u672a\u7ed1\u5b9a\u7684\u5bc6\u5ea6\u51fd\u6570";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>\u6ce8\u518c\u8868\u4e2d\u7f3a\u5c11\u5bc6\u5ea6\u51fd\u6570\u3002</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("\u7f3a\u5931\u9879\uff1a");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append("\u3002");
        }
        sb.append("<br/><b>\u89e3\u51b3\u65b9\u6848\uff1a</b>\u5b89\u88c5\u6216\u542f\u7528\u5b9a\u4e49\u8fd9\u4e9b\u51fd\u6570\u7684 mod/datapack \u5e76\u91cd\u542f\u3002\u53e6\u4e00\u4e2a\u5e38\u89c1\u539f\u56e0\u662f\uff1a\u867d\u7136\u4f60\u5b89\u88c5\u4e86\u6240\u9700\u7684 mod\uff0c\u4f46\u5b83\u81ea\u8eab\u5b58\u5728\u95ee\u9898\u6216\u4e0e\u5176\u4ed6 mod \u51b2\u7a81\uff1b\u4f8b\u5982\uff0cTerralith \u5b58\u5728\u8bb8\u591a\u95ee\u9898\uff0c\u53ef\u80fd\u5f15\u53d1\u6b64\u9519\u8bef\u53ca\u5176\u4ed6\u95ee\u9898\uff0c\u5305\u62ec JSON \u9519\u8bef\u3002");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "\u5b89\u88c5\u6216\u542f\u7528\u63d0\u4f9b\u8fd9\u4e9b\u51fd\u6570\u7684\u6a21\u7ec4/\u6570\u636e\u5305\uff0c\u5e76\u91cd\u65b0\u542f\u52a8\u6e38\u620f\u3002";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u6ce8\u518c\u8868\u9879\u4e0d\u5b58\u5728: ").append(claveFaltante).append(". ");
        sb.append("\u5e38\u89c1\u4e8e Create 6 \u7684 Steam & Railways \u6d4b\u8bd5\u7248\uff08Alpha\uff09\u3002");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (\u6d4b\u8bd5\u7248)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "\u79fb\u9664\u6216\u66ff\u6362 Create 6 \u7684 Steam & Railways \u6d4b\u8bd5\u7248\u4e3a\u517c\u5bb9\u7248\u672c\u3002";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u52a0\u8f7d\u51b2\u7a81\uff1aMultiworld \u4e0e Sodium/Embeddium/Rubidium \u540c\u65f6\u4f7f\u7528\u4f1a\u5bfc\u81f4 ").append("IncompatibleClassChangeError (FabricLoader.getInstance)\u3002").append("\u5efa\u8bae\uff1a\u79fb\u9664 Multiworld \u6216\u6027\u80fd\u6a21\u7ec4\uff0c\u6216\u4f7f\u7528\u76f8\u4e92\u517c\u5bb9\u7684\u7248\u672c\u3002");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "\u51b2\u7a81\uff1aMultiworld \u4e0e\u6027\u80fd\u6a21\u7ec4";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "\u5378\u8f7d Multiworld \u6216 Sodium/Embeddium/Rubidium\uff0c\u6216\u66f4\u65b0\u4e3a\u5f7c\u6b64\u517c\u5bb9\u7684\u7248\u672c\u3002";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium \u68c0\u6d4b\u5230\u4e0d\u517c\u5bb9\u7684\u663e\u5361\u9a71\u52a8\u7a0b\u5e8f\u3002\u8bf7\u5c06\u60a8\u7684 GPU \u9a71\u52a8\u66f4\u65b0\u81f3\u6700\u4f4e\u8981\u6c42\u7248\u672c\uff0c\u6216\u53c2\u8003 Sodium \u6307\u5357\u8fdb\u884c\u64cd\u4f5c\u3002</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "OpenGL \u4e0a\u4e0b\u6587\u9519\u8bef";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenGL \u5931\u8d25\uff1a\u65e0\u5f53\u524d\u4e0a\u4e0b\u6587\uff0c\u6216\u8be5\u51fd\u6570\u5728\u6b64\u4e0a\u4e0b\u6587\u4e2d\u4e0d\u53ef\u7528\u3002\u4e5f\u53ef\u80fd\u662f\u663e\u5361\u9a71\u52a8\u95ee\u9898\u3002</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "\u66f4\u65b0\u6216\u91cd\u65b0\u5b89\u88c5 GPU \u9a71\u52a8\u5e76\u91cd\u542f\uff1b\u5173\u95ed\u6240\u6709\u8986\u76d6\u5c42\uff0c\u5e76\u5c1d\u8bd5\u5728\u4e0d\u4f7f\u7528\u6027\u80fd\u6a21\u7ec4\u7684\u60c5\u51b5\u4e0b\u8fd0\u884c\u3002";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "\u94fe\u63a5\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f\u3002";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "\u5728\u538b\u7f29\u5305\u5185\u641c\u7d22 (.zip/.jar/.war/.ear/.fpm/.rar\uff08\u7528\u4e8e Java\uff09*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u7eb9\u7406\u5206\u8fa8\u7387\u9519\u8bef\uff1a\u65e0\u6cd5\u52a0\u8f7d\u8d44\u6e90 " + recurso + " \u2014 \u5c3a\u5bf8\uff1a" + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "\u7eb9\u7406\u5206\u8fa8\u7387\u9519\u8bef";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "\u5f53\u7eb9\u7406\u8fc7\u5927\u6216\u8d44\u6e90\u5305\u8fc7\u591a\u65f6\u4f1a\u53d1\u751f\u6b64\u9519\u8bef\u3002\u8bf7\u5c1d\u8bd5\u4f7f\u7528\u8f83\u4f4e\u5206\u8fa8\u7387\u7684\u8d44\u6e90\u5305\uff0c\u6216\u5220\u9664\u90e8\u5206\u8d44\u6e90\u5305\u3002\u68c0\u67e5\u662f\u5426\u6dfb\u52a0\u4e86\u8d85\u51fa\u5141\u8bb8\u5c3a\u5bf8\u7684\u81ea\u5b9a\u4e49\u7eb9\u7406\u3002";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModLauncher \u670d\u52a1\u9519\u8bef\uff1a\u8def\u5f84\u5305\u542b\u65e0\u6548\u5b57\u7b26\u3002 ModLauncher \u670d\u52a1\u65e0\u6cd5\u5904\u7406\u5305\u542b\u975e ASCII \u5b57\u7b26\u6216\u7279\u6b8a\u5b57\u7b26\u7684\u8def\u5f84\u3002 \u95ee\u9898\u5b57\u7b26\u5305\u62ec\uff1a\u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694\uff0c\u5c24\u5176\u662f\u540d\u79f0\u672b\u5c3e\u7684 '\"' \u5b57\u7b26\u3002 \u5e38\u89c1\u7684 ModLauncher \u670d\u52a1\u7ec4\u4ef6\u5305\u62ec CrashDetector\u3001" + Config.obtenerInstancia().obtenerNombreCD() + "\u3001FeatureCreep\u3001Vivicraft\u3001Optifine\u3001Sodium\u3001clonos\u3001Iris Shaders/Oculus\u3001MixerLogger\u3001CrashAssistant \u548c Sintrya Connector\u3002 \u4f60\u53ef\u4ee5\u79fb\u9664\u6240\u6709\u670d\u52a1\uff0c\u4f46\u8def\u5f84\u540d\u79f0\u4ecd\u53ef\u80fd\u5bfc\u81f4\u5176\u4ed6\u95ee\u9898\u3002 \u89e3\u51b3\u65b9\u6848\uff1a\u5c06\u5b9e\u4f8b\u91cd\u547d\u540d\u4e3a\u4ec5\u4f7f\u7528 ASCII \u5b57\u7b26\uff08a-z, A-Z, 0-9\uff09\uff0c\u907f\u514d\u7a7a\u683c\u548c\u7279\u6b8a\u5b57\u7b26\u3002</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "ModLauncher \u8def\u5f84\u9519\u8bef";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "\u5f53\u5b9e\u4f8b\u8def\u5f84\u5305\u542b\u975e ASCII \u5b57\u7b26\u6216\u7279\u6b8a\u5b57\u7b26\u65f6\u4f1a\u53d1\u751f\u6b64\u9519\u8bef\u3002 ModLauncher \u670d\u52a1\u65e0\u6cd5\u5904\u7406\u6b64\u7c7b\u8def\u5f84\u3002 \u89e3\u51b3\u65b9\u6848\uff1a\u5c06\u5b9e\u4f8b\u91cd\u547d\u540d\u4e3a\u4ec5\u4f7f\u7528 ASCII \u5b57\u7b26\uff08a-z, A-Z, 0-9\uff09\uff0c\u907f\u514d\u7a7a\u683c\u548c\u7279\u6b8a\u5b57\u7b26\u3002 \u7279\u522b\u6ce8\u610f '\"' \u5b57\u7b26\uff0c\u5b83\u975e\u5e38\u5bb9\u6613\u5f15\u53d1\u95ee\u9898\uff0c\u5c24\u5176\u662f\u5728\u540d\u79f0\u672b\u5c3e\u65f6\u3002";
    }

    @Override
    public String tituloEditorCodice() {
        return "Codice \u7f16\u8f91\u5668";
    }

    @Override
    public String nuevo() {
        return "\u65b0\u5efa";
    }

    @Override
    public String actualizarSeleccionado() {
        return "\u66f4\u65b0\u9009\u4e2d\u9879";
    }

    @Override
    public String eliminarSeleccionado() {
        return "\u5220\u9664\u9009\u4e2d\u9879";
    }

    @Override
    public String exportarJSON() {
        return "\u5bfc\u51fa JSON...";
    }

    @Override
    public String guardarTodo() {
        return "\u4fdd\u5b58\u5168\u90e8";
    }

    @Override
    public String general() {
        return "\u901a\u7528";
    }

    @Override
    public String id() {
        return "ID";
    }

    @Override
    public String paraBuscar() {
        return "\u641c\u7d22\u6587\u672c";
    }

    @Override
    public String filtro() {
        return "\u8fc7\u6ee4\u5668 (ID)";
    }

    @Override
    public String criticalidad() {
        return "\u4e25\u91cd\u6027 (\u8b66\u544a/\u9519\u8bef/\u81f4\u547d)";
    }

    @Override
    public String prioridad() {
        return "\u4f18\u5148\u7ea7";
    }

    @Override
    public String lista() {
        return "\u68c0\u67e5\u9879";
    }

    @Override
    public String colIdioma() {
        return "\u8bed\u8a00";
    }

    @Override
    public String colNombre() {
        return "\u540d\u79f0";
    }

    @Override
    public String colResultado() {
        return "\u7ed3\u679c";
    }

    @Override
    public String vistaJson() {
        return "JSON \u9884\u89c8";
    }

    @Override
    public String idiomas() {
        return "\u8bed\u8a00 (\u5168\u90e8\u5fc5\u586b)";
    }

    @Override
    public String elegirFiltro() {
        return "\u9009\u62e9...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8fc7\u6ee4\u5668";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "\u53ef\u7528\u8fc7\u6ee4\u5668";
    }

    @Override
    public String faltanCampos() {
        return "\u8bf7\u586b\u5199\u6240\u6709\u5fc5\u586b\u7684\u901a\u7528\u5b57\u6bb5\u3002";
    }

    @Override
    public String critInvalida() {
        return "\u4e25\u91cd\u6027\u65e0\u6548\u3002\u8bf7\u4f7f\u7528 \u8b66\u544a\u3001\u9519\u8bef \u6216 \u81f4\u547d\u3002";
    }

    @Override
    public String filtroNoExiste() {
        return "\u6307\u5b9a\u7684\u8fc7\u6ee4\u5668\u4e0d\u5b58\u5728\u3002";
    }

    @Override
    public String faltanIdiomas() {
        return "\u8bf7\u4e3a\u6240\u6709\u8bed\u8a00\u586b\u5199\u540d\u79f0\u548c\u7ed3\u679c\uff1a";
    }

    @Override
    public String verificacionInvalida() {
        return "\u67d0\u9879\u68c0\u67e5\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u3002";
    }

    @Override
    public String guardadoOk() {
        return "\u4fdd\u5b58\u6210\u529f\u3002";
    }

    @Override
    public String editorCodiceBoton() {
        return "\u6dfb\u52a0\u539f\u56e0";
    }

    @Override
    public String descripcionEditorCodice() {
        return "\u4f60\u53ef\u4ee5\u5728\u6b64\u6ce8\u518c\u539f\u56e0\u3002\u4f60\u9700\u8981\u4e00\u4e2aID\uff0c\u5373\u4e0d\u542b\u7279\u6b8a\u5b57\u7b26\u3001\u91cd\u97f3\u7b26\u53f7\u6216\u7a7a\u683c\u7684\u5b57\u7b26\u4e32\u3002\u5bf9\u4e8e\u8fc7\u6ee4\u5668\uff0c\u53ef\u4f7f\u7528\u201c\u884c\u5305\u542b\u201d\u6765\u641c\u7d22\u67d0\u884c\u4e2d\u7684\u5b57\u7b26\u4e32\uff0c\u201c\u5168\u6587\u5305\u542b\u201d\u7528\u4e8e\u5224\u65ad\u65e5\u5fd7\u662f\u5426\u5305\u542b\u67d0\u5b57\u7b26\u4e32\uff0c\u201c\u884c\u6b63\u5219\u201d\u7528\u4e8e\u5339\u914d\u67d0\u884c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\uff0c\u201c\u5168\u6587\u6b63\u5219\u201d\uff08\u5efa\u8bae\u4f18\u5148\u4f7f\u7528\u884c\u7ea7\u7248\u672c\uff09\u3002\u4f60\u5fc5\u987b\u8bbe\u7f6e\u4e25\u91cd\u6027\uff1aFATAL\uff08\u81f4\u547d\uff09\u3001ERROR\uff08\u9519\u8bef\uff09\u6216ADVERTENCIA\uff08\u8b66\u544a\uff09\uff0c\u4ee5\u51b3\u5b9a\u989c\u8272\u663e\u793a\u3002\u6bcf\u79cd\u8bed\u8a00\u90fd\u9700\u586b\u5199\u540d\u79f0\u548c\u7ed3\u679c\uff0c\u8fd9\u4e9b\u5185\u5bb9\u5c06\u663e\u793a\u5728\u754c\u9762\u4e0a\u3002\u4f60\u53ef\u4ee5\u6dfb\u52a0\u66f4\u591a\u68c0\u67e5\u9879\u6216\u5220\u9664\u5df2\u6709\u9879\u3002\u5b8c\u6210\u65f6\u4f1a\u81ea\u52a8\u4fdd\u5b58\u3002";
    }

    @Override
    public String descartarCambios() {
        return "\u662f\u5426\u653e\u5f03\u5f53\u524d\u68c0\u67e5\u4e2d\u7684\u672a\u4fdd\u5b58\u66f4\u6539\uff1f";
    }

    @Override
    public String confirmacion() {
        return "\u786e\u8ba4";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\u60a8\u60f3\u5728\u9000\u51fa\u524d\u4fdd\u5b58\u66f4\u6539\u5417\uff1f";
    }

    @Override
    public String salirSinGuardar() {
        return "\u9000\u51fa\u4e0d\u4fdd\u5b58";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4e25\u91cd\u9519\u8bef\uff1a\u52a0\u8f7d modlauncher \u670d\u52a1 (IDependencyLocator) \u5931\u8d25\u3002<br>");
        sb.append("\ud83d\udd39 <b>\u95ee\u9898\u7c7b\uff1a</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>\u53d7\u5f71\u54cd\u7684\u6a21\u7ec4\uff1a</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>\u6a21\u7ec4\u672a\u8bc6\u522b\u3002</b> \u8bf7\u68c0\u67e5\u6700\u8fd1\u5b89\u88c5\u7684\u3001\u5f00\u53d1\u4e2d\u7684\u6216\u6253\u5305\u9519\u8bef\u7684\u6a21\u7ec4\u3002<br>");
        }
        sb.append("\ud83d\udd38 <b>\u539f\u56e0\uff1a</b> \u6a21\u7ec4\u7684 <code>META-INF/services/...</code> \u6587\u4ef6\u5df2\u635f\u574f\uff0c");
        sb.append("\u4e0e\u5f53\u524d\u7248\u672c\u7684 Forge/NeoForge \u4e0d\u517c\u5bb9\uff0c\u6216\u8be5\u6a21\u7ec4\u9002\u7528\u4e8e\u9519\u8bef\u7248\u672c\u3002<br>");
        sb.append("\ud83d\udd38 <b>\u540e\u679c\uff1a</b> Forge/NeoForge \u65e0\u6cd5\u6ce8\u518c\u6a21\u7ec4\u4f9d\u8d56\u9879\uff0c");
        sb.append("\u5bfc\u81f4\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u3002<br>");
        sb.append("\ud83d\udd38 <b>\u89e3\u51b3\u65b9\u6848\uff1a</b> \u66f4\u65b0\u3001\u91cd\u65b0\u5b89\u88c5\u6216\u5220\u9664\u6709\u95ee\u9898\u7684\u6a21\u7ec4\u3002");
        sb.append("\u5982\u679c\u4f7f\u7528\u5f00\u53d1\u7248\u6a21\u7ec4\uff0c\u8bf7\u786e\u4fdd\u5176\u7f16\u8bd1\u7248\u672c\u4e0e\u4f60\u7684 Forge/NeoForge \u7248\u672c\u5b8c\u5168\u5339\u914d\u3002");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "\u670d\u52a1\u914d\u7f6e\u9519\u8bef (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. \u786e\u5b9a\u5bfc\u81f4\u95ee\u9898\u7684\u6a21\u7ec4\uff1a\u68c0\u67e5\u6700\u8fd1\u5b89\u88c5\u6216\u6b63\u5728\u5f00\u53d1\u7684\u6a21\u7ec4\u3002";
        }
        return "1. \u6709\u95ee\u9898\u7684\u6a21\u7ec4\u662f\uff1a" + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. \u66f4\u65b0\u3001\u91cd\u65b0\u5b89\u88c5\u6216\u5220\u9664\u8be5\u6a21\u7ec4\u3002\u8bf7\u786e\u4fdd\u4f7f\u7528\u4e0e\u4f60\u7684 Forge/NeoForge \u517c\u5bb9\u7684\u7248\u672c\u3002";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u4e25\u91cd\u9519\u8bef\uff1a\u65b9\u6cd5\u4e0d\u5b58\u5728\u3002</b><br>\u8be5\u6a21\u7ec4\u8bd5\u56fe\u8c03\u7528\u65b9\u6cd5 <b style='color:#" + colorCodigo + "'>" + metodo + "</b>\uff0c\u4f46\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u6e38\u620f\u7248\u672c\u6216\u5176\u4ed6\u6a21\u7ec4\u4e2d\u4e0d\u5b58\u5728\u3002<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "\u65b9\u6cd5\u4e0d\u5b58\u5728 (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. \u6b64\u9519\u8bef\u901a\u5e38\u53d1\u751f\u5728\u6a21\u7ec4\u4e0e\u5f53\u524d\u6e38\u620f\u7248\u672c\u6216\u5176\u4ed6\u6a21\u7ec4\u4e0d\u517c\u5bb9\u65f6\u3002";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. \u66f4\u65b0\u6240\u6709\u76f8\u5173\u6a21\u7ec4\u3002\u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c\u8bf7\u5411\u53d7\u5f71\u54cd\u6a21\u7ec4\u7684\u4f5c\u8005\u62a5\u544a\u6b64\u9519\u8bef\u3002";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u4e25\u91cd\u9519\u8bef\uff1a\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002</b><br>\u8be5\u6a21\u7ec4\u8bd5\u56fe\u8bbf\u95ee\u5b57\u6bb5 <b style='color:#" + colorCodigo + "'>" + campo + "</b>\uff0c\u4f46\u8be5\u5b57\u6bb5\u5728\u5f53\u524d\u6e38\u620f\u7248\u672c\u6216\u5176\u4ed6\u6a21\u7ec4\u4e2d\u4e0d\u5b58\u5728\u3002<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "\u5b57\u6bb5\u4e0d\u5b58\u5728 (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. \u6b64\u9519\u8bef\u901a\u5e38\u53d1\u751f\u5728\u6a21\u7ec4\u4e0e\u5f53\u524d\u6e38\u620f\u7248\u672c\u6216\u5176\u4ed6\u6a21\u7ec4\u4e0d\u517c\u5bb9\u65f6\u3002";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. \u66f4\u65b0\u6240\u6709\u53d7\u5f71\u54cd\u7684\u6a21\u7ec4\u3002\u5982\u679c\u95ee\u9898\u6301\u7eed\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f15\u53d1\u9519\u8bef\u7684\u6a21\u7ec4\u4f5c\u8005\u3002";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\u9700\u8981\u5e2e\u52a9\u5417\uff1f</strong><br>  \u5982\u679c\u4f60\u4e0d\u77e5\u9053\u5982\u4f55\u4fee\u590d\uff0c\u6216\u6b64\u5904\u672a\u5217\u51fa\u539f\u56e0\uff0c\u53ef\u901a\u8fc7\u6211\u4eec\u7684\u793e\u4ea4\u7f51\u7edc\u83b7\u5f97\u5e2e\u52a9\u3002  \u4f7f\u7528 <img src='" + iconoCompartir + "' alt='\u5206\u4eab' style='height:12px;vertical-align:middle;'/>   <strong>\u5206\u4eab</strong> \u6309\u94ae\u83b7\u53d6\u65e5\u5fd7\u548c\u5206\u6790\u7ed3\u679c\u7684\u94fe\u63a5\uff0c\u4ee5\u4fbf\u63d0\u4ea4\u7ed9\u6211\u4eec\u7684\u56e2\u961f\u3002  \u5982\u679c\u4f60\u662f\u6574\u5408\u5305\u4f5c\u8005\u6216\u7ec4\u7ec7\uff0c\u8bf7\u7f16\u8f91 <code>crash_detector/plantilla.htm</code>   \u6765\u81ea\u5b9a\u4e49\u4f60\u7684\u56e2\u961f\u94fe\u63a5\u3002</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "\u91cd\u7f6e\u6a21\u677f";
    }

    @Override
    public String restablecer() {
        return "\u91cd\u7f6e";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return "\u5c06 " + nombreImagen + " \u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u8bbe\u7f6e\uff1f";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\u5c06\u6a21\u677f\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u8bbe\u7f6e\uff1f";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u7f3a\u5c11 AzureLib \u7684\u7c7b\u3002\u5982\u679c\u4f60\u5df2\u5b89\u88c5 AzureLib\uff0c\u8bf7\u5b89\u88c5 2025 \u5e74 10 \u6708 8 \u65e5\u4e4b\u524d\u7684\u7248\u672c\uff08\u6b64\u95ee\u9898\u8f83\u4e3a\u5e38\u89c1\uff09\u3002\u82e5\u672a\u5b89\u88c5 AzureLib\uff0c\u8bf7\u5b89\u88c5\u5f53\u524d\u6700\u65b0\u7248\u672c\u3002</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u6a21\u7ec4 <code>healight</code> \u5bfc\u81f4\u4e25\u91cd\u9519\u8bef\uff1a<code>java.lang.NoSuchFieldError: INT</code>\u3002\u6b64\u9519\u8bef\u662f\u56e0\u4e3a\u8be5\u6a21\u7ec4\u8bd5\u56fe\u8bbf\u95ee\u5728 MCForge 47.10 \u53ca\u66f4\u9ad8\u7248\u672c\u7684 Minecraft 1.20+ \u4e2d\u5df2\u4e0d\u5b58\u5728\u7684\u5b57\u6bb5\u3002\u7531\u4e8e\u6b64\u95ee\u9898\uff0c\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u3002</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 \u5220\u9664\u6216\u66f4\u65b0 <code>healight</code> \u6a21\u7ec4\u3002\u5f53\u524d\u7248\u672c\u4e0e\u9002\u7528\u4e8e 1.20.1 \u7684 MinecraftForge 47.10 \u4e0d\u517c\u5bb9\u3002\u5bfb\u627e\u8be5\u6a21\u7ec4\u7684\u66f4\u65b0\u7248\u672c\uff0c\u6216\u8003\u8651\u4f7f\u7528\u66ff\u4ee3\u65b9\u6848\u3002";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "\u4e25\u91cd\u9519\u8bef\uff1ahealight - \u627e\u4e0d\u5230 'INT' \u5b57\u6bb5";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("\u7c7b <code>").append(clase).append("</code> \u672a\u5b9e\u73b0\u5fc5\u9700\u7684\u65b9\u6cd5\uff1a<br>").append("<code>").append(metodo).append("</code><br>").append("\u6765\u81ea\u63a5\u53e3 <code>").append(interfaz).append("</code>\u3002");
        if (!origen.isEmpty()) {
            sb.append("<br><br>\u53ef\u7591\u7684\u6a21\u7ec4\u6216\u6587\u4ef6\uff1a<code>").append(origen).append("</code>\u3002");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 \u6b64\u9519\u8bef\u53d1\u751f\u5728\u67d0\u4e2a\u6a21\u7ec4\u5b9e\u73b0\u4e86\u63a5\u53e3\u4f46\u9057\u6f0f\u4e86\u5fc5\u9700\u65b9\u6cd5\u65f6\u3002\u8bf7\u66f4\u65b0<b>\u4e24\u4e2a\u76f8\u5173\u6a21\u7ec4</b>\uff08\u5b9a\u4e49\u63a5\u53e3\u7684\u548c\u5b9e\u73b0\u63a5\u53e3\u7684\uff09\u3002\u5982\u679c\u4e0d\u6e05\u695a\u662f\u54ea\u4e9b\u6a21\u7ec4\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u6d88\u606f\u4e2d\u51fa\u73b0\u7684\u540d\u79f0\u3002";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "\u63a5\u53e3\u65b9\u6cd5\u672a\u5b9e\u73b0 (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u4e00\u4e2a\u6a21\u7ec4\u8bd5\u56fe\u5728<b>\u4e13\u7528\u670d\u52a1\u5668</b>\u4e0a\u52a0\u8f7d\u5c5e\u4e8e<b>\u5ba2\u6237\u7aef</b>\u7684\u7c7b (<code>AnimationMetadataSection</code>)\uff0c\u8fd9\u662f\u4e0d\u53ef\u80fd\u7684\u3002\u5f53\u6a21\u7ec4\u672a\u6b63\u786e\u5206\u79bb\u5ba2\u6237\u7aef\u548c\u670d\u52a1\u5668\u4ee3\u7801\u65f6\uff0c\u901a\u5e38\u4f1a\u51fa\u73b0\u6b64\u9519\u8bef\u3002\u5b89\u88c5 <code>ModernFix</code> \u53ef\u80fd\u4f1a\u66b4\u9732\u6b64\u95ee\u9898\uff0c\u4f46\u5e76\u975e\u76f4\u63a5\u539f\u56e0\u3002</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>\u5feb\u901f\u89e3\u51b3\uff1a</b>\u4e34\u65f6\u79fb\u9664 <code>ModernFix</code> \u4ee5\u786e\u8ba4\u670d\u52a1\u5668\u80fd\u5426\u542f\u52a8\u3002\u5982\u679c\u53ef\u4ee5\uff0c\u5219\u8bf4\u660e\u662f\u5176\u4ed6\u6a21\u7ec4\u5728\u670d\u52a1\u5668\u7aef\u52a0\u8f7d\u4e86\u5ba2\u6237\u7aef\u7c7b\u3002<br>\u2022 <b>\u6c38\u4e45\u89e3\u51b3\u65b9\u6848\uff1a</b>\u627e\u51fa\u6709\u95ee\u9898\u7684\u6a21\u7ec4\uff08\u67e5\u627e\u5305\u542b\u52a8\u753b\u8d44\u6e90\u3001\u81ea\u5b9a\u4e49\u7eb9\u7406\u6216\u56fe\u5f62\u5e93\u7684\u6a21\u7ec4\uff09\u5e76\u66f4\u65b0\u6216\u5220\u9664\u5b83\u3002<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "\u5728\u670d\u52a1\u5668\u4e0a\u52a0\u8f7d\u4e86\u5ba2\u6237\u7aef\u7c7b (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Sinytra Connector \u67d0\u4e2a\u6a21\u7ec4\u7684\u914d\u7f6e\u6587\u4ef6\u5df2\u635f\u574f\u3002\u8fd9\u901a\u5e38\u662f\u56e0\u4e3a\u6e38\u620f\u610f\u5916\u5173\u95ed\u3001\u5199\u5165\u5931\u8d25\u6216\u6a21\u7ec4\u51b2\u7a81\u5bfc\u81f4\u6587\u4ef6\u4e2d\u5145\u6ee1\u4e86\u7a7a\u5b57\u7b26\uff08<code>\\u0000</code>\uff09\u6240\u81f4\u3002</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 \u8fdb\u5165\u4f60\u7684 Minecraft \u5b9e\u4f8b\u7684 <code>config/</code> \u6587\u4ef6\u5939\u3002<br>\u2022 \u67e5\u627e\u5e76\u5220\u9664\u4e0e connector \u76f8\u5173\u7684\u6a21\u7ec4\u914d\u7f6e\u6587\u4ef6\u3002<br>\u2022 \u91cd\u65b0\u542f\u52a8\u6e38\u620f\uff1aSinytra Connector \u5c06\u751f\u6210\u4e00\u4e2a\u5168\u65b0\u7684\u5e72\u51c0\u914d\u7f6e\u6587\u4ef6\u3002";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "Sinytra Connector \u914d\u7f6e\u635f\u574f";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u6587\u4ef6 <code>" + nombreJar + "</code> \u5df2\u635f\u574f\u6216\u4e0d\u5b8c\u6574\u3002<br>\u7cfb\u7edf\u65e0\u6cd5\u8bfb\u53d6\u5176\u5185\u5bb9\uff0c\u56e0\u4e3aZIP\u6587\u4ef6\u7684\u672b\u5c3e\u5934\u90e8\u4e22\u5931\u3002<br>\u6b64\u9519\u8bef\u901a\u5e38\u53d1\u751f\u5728\u4e0b\u8f7d\u4e2d\u65ad\u6216\u542f\u52a8\u5668\u6545\u969c\u540e\u3002</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "JAR\u6587\u4ef6\u635f\u574f\uff08\u542b\u5177\u4f53\u540d\u79f0\uff09";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>\u5220\u9664\u635f\u574f\u7684\u6587\u4ef6</b>\uff0c\u5e76\u4ece\u5b98\u65b9\u6765\u6e90\uff08\u5982CurseForge\u3001MinecraftStorage\u7b49\uff09\u91cd\u65b0\u4e0b\u8f7d\u3002<br>\u2022 \u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fCurseForge\u3001Technic\u6216Luna Pixel\u7b49\u542f\u52a8\u5668\uff0c\u8bf7\u8003\u8651\u6539\u7528<b>ATLauncher</b>\u6216<b>Prism Launcher</b>\uff0c\u5b83\u4eec\u5bf9\u6587\u4ef6\u5b8c\u6574\u6027\u7684\u6821\u9a8c\u66f4\u5b8c\u5584\u3002<br>\u2022 \u786e\u4fdd\u4e0b\u8f7d\u671f\u95f4\u4f60\u7684\u7f51\u7edc\u8fde\u63a5\u7a33\u5b9a\u3002";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u65e0\u6cd5\u52a0\u8f7d\u4e16\u754c\uff0c\u56e0\u4e3a\u5176 NBT \u6587\u4ef6\u4e4b\u4e00\u5df2\u635f\u574f (\u4f8b\u5982\uff1a<code>level.dat</code>\u3001<code>playerdata/*.dat</code> \u6216\u533a\u5757\u6570\u636e)\u3002<br>\u5177\u4f53\u9519\u8bef\u4e3a\uff1a<code>UTFDataFormatException: \u5728\u5b57\u8282 " + byteCorrupto + " \u9644\u8fd1\u8f93\u5165\u683c\u5f0f\u9519\u8bef</code>\u3002<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f \u5728\u5c1d\u8bd5\u4efb\u4f55\u4fee\u590d\u524d\uff0c\u8bf7\u5148\u5b8c\u6574\u5907\u4efd\u6574\u4e2a\u4e16\u754c\u6587\u4ef6\u5939\u3002</b><br><br>\u4f60\u53ef\u4ee5\u4f7f\u7528 <b>NBT \u7f16\u8f91\u5668</b>\uff08\u5982 <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>\uff09\u6765\u5c1d\u8bd5\u4fee\u590d\u635f\u574f\u7684\u6587\u4ef6\u3002<br>\u5982\u679c\u635f\u574f\u4e25\u91cd\uff0c\u53ef\u4f7f\u7528<b>\u5341\u516d\u8fdb\u5236\u7f16\u8f91\u5668</b>\uff08\u5982 HxD\uff09\u68c0\u67e5\u5e76\u4fee\u6b63\u65e0\u6548\u5b57\u8282 \uff08\u4ec5\u9002\u7528\u4e8e\u719f\u6089 NBT \u683c\u5f0f\u8005\uff09\u3002<br>\u6700\u540e\u624b\u6bb5\u662f\uff1a\u4ece\u5907\u4efd\u4e2d\u6062\u590d\uff0c\u6216\u4f7f\u7528 <code>FTB Backup</code> \u7b49\u6a21\u7ec4\u63d0\u4f9b\u7684\u201c\u4e16\u754c\u4fee\u590d\u201d\u529f\u80fd\u3002</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>\u5728\u5c1d\u8bd5\u4fee\u590d\u524d\uff0c\u8bf7\u5b8c\u6574\u5907\u4efd\u4e16\u754c\u6587\u4ef6\u5939</b>\u3002<br>\u2022 \u4f7f\u7528 NBT \u7f16\u8f91\u5668\uff08\u5982 NBT Studio\uff09\u6253\u5f00\u5e76\u4fee\u590d\u635f\u574f\u7684\u6587\u4ef6\u3002<br>\u2022 \u5982\u679c\u5931\u8d25\uff0c\u5728\u635f\u574f\u5b57\u8282\u4f4d\u7f6e\u7528\u5341\u516d\u8fdb\u5236\u7f16\u8f91\u5668\u68c0\u67e5\u6587\u4ef6\u3002<br>\u2022 \u82e5\u65e0\u7ecf\u9a8c\uff0c\u8bf7\u4ece\u6700\u8fd1\u7684\u5907\u4efd\u4e2d\u6062\u590d\u3002";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "\u4e16\u754c\u635f\u574f\uff1a\u52a0\u8f7d NBT \u6570\u636e\u51fa\u9519";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7684 OpenAL \u51fa\u73b0\u95ee\u9898\u3002\u6709\u65f6\u662f Nouveau \u9a71\u52a8\u5bfc\u81f4\u7684\uff0c\u4f46\u6709\u65f6\u662f\u56e0\u4e3a\u5e94\u7528\u7a0b\u5e8f\u81ea\u5e26\u7684 OpenAL \u7248\u672c\u4e0e\u4f60\u7cfb\u7edf\u53d1\u884c\u7248\u4e2d\u7684\u7248\u672c\u4e0d\u517c\u5bb9\uff0c\u4f60\u9700\u8981\u4f7f\u7528\u53d1\u884c\u7248\u63d0\u4f9b\u7684 OpenAL \u7248\u672c\u3002\u8fd9\u5728 Red Hat \u7cfb\u53d1\u884c\u7248\u548c Sound Physics Remastered \u7b49\u58f0\u97f3\u6a21\u7ec4\u4e2d\u5c24\u4e3a\u5e38\u89c1\u3002\u8bf7\u53c2\u8003\u6b64\u6307\u5357\u83b7\u53d6\u66f4\u591a\u5e2e\u52a9\uff1a<a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>\u5982\u4f55\u4fee\u590d Linux \u4e0a Minecraft \u7684\u58f0\u97f3\u95ee\u9898</a>\u3002</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u670d\u52a1\u5668\u65e0\u6cd5\u542f\u52a8\uff0c\u56e0\u4e3a\u4e16\u754c\u7684\u4e00\u4e2a\u6587\u4ef6\u88ab\u5176\u4ed6\u8fdb\u7a0b\u9501\u5b9a\u3002<br>\u901a\u5e38\u5728\u4ee5\u4e0b\u60c5\u51b5\u4e0b\u53d1\u751f\uff1a<br>\u2022 \u5df2\u6709\u4e00\u4e2a\u670d\u52a1\u5668\u5b9e\u4f8b\u6b63\u5728\u8fd0\u884c\u3002<br>\u2022 \u6740\u6bd2\u8f6f\u4ef6\u6216\u6587\u4ef6\u8d44\u6e90\u7ba1\u7406\u5668\u6253\u5f00\u4e86\u4e16\u754c\u6587\u4ef6\u5939\u3002<br>\u2022 \u524d\u4e00\u4e2a\u8fdb\u7a0b\u672a\u6b63\u786e\u5173\u95ed\u5e76\u7559\u4e0b\u9501\u5b9a\u7684\u6587\u4ef6\u3002</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>\u5173\u95ed\u6240\u6709\u670d\u52a1\u5668\u5b9e\u4f8b</b>\uff08\u5305\u62ec\u540e\u53f0\u8fdb\u7a0b\u5982 javaw.exe\uff09\u3002<br>\u2022 \u5982\u679c\u4f60\u4f7f\u7528\u7684\u662f\u6258\u7ba1\u9762\u677f\uff08\u5982 Multicraft\uff09\uff0c\u8bf7\u901a\u8fc7\u9762\u677f\u5b8c\u5168\u91cd\u542f\u670d\u52a1\u5668\u3002<br>\u2022 <b>\u4e34\u65f6\u7981\u7528\u4f60\u7684\u6740\u6bd2\u8f6f\u4ef6</b>\uff0c\u5982\u679c\u4f60\u6000\u7591\u5b83\u9501\u5b9a\u4e86\u6587\u4ef6\u3002<br>\u2022 \u5728\u672c\u5730\u7cfb\u7edf\u4e0a\uff0c\u5173\u95ed\u4efb\u4f55\u663e\u793a\u4e16\u754c\u6587\u4ef6\u5939\u7684Windows\u8d44\u6e90\u7ba1\u7406\u5668\u7a97\u53e3\u3002<br>\u2022 \u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c\u8bf7\u624b\u52a8\u5220\u9664\u4e16\u754c\u6587\u4ef6\u5939\u5185\u7684 <code>session.lock</code> \u6587\u4ef6\uff08\u4ec5\u5f53\u4f60\u786e\u5b9a\u6ca1\u6709\u5176\u4ed6\u670d\u52a1\u5668\u5728\u8fd0\u884c\u65f6\uff09\u3002";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "\u4e16\u754c\u6587\u4ef6\u88ab\u53e6\u4e00\u8fdb\u7a0b\u9501\u5b9a";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u062d\u0627\u0648\u0644 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u062a\u0648\u0633\u064a\u0639 \u0627\u0644\u0635\u0646\u0641 <code>" + clasePadreFinal + "</code>\u060c \u0644\u0643\u0646 \u0647\u0630\u0627 \u0627\u0644\u0635\u0646\u0641 \u0623\u0635\u0628\u062d \u0627\u0644\u0622\u0646 <b>\u0646\u0647\u0627\u0626\u064a\u064b\u0627</b> \u0648\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0644\u0648\u0631\u0627\u062b\u0629 \u0645\u0646\u0647.<br>\u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0645\u0633\u0628\u0628 \u0644\u0644\u0645\u0634\u0643\u0644\u0629 \u0647\u0648: <code>" + claseHija + "</code>.<br><br>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0639\u0627\u062f\u0629 \u0639\u0646\u062f\u0645\u0627 \u064a\u0643\u0648\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0645\u064f\u062c\u0645\u064e\u0651\u0639 \u0644\u0625\u0635\u062f\u0627\u0631 \u0633\u0627\u0628\u0642 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0623\u0648 \u062a\u0639\u062f\u064a\u0644 \u0623\u0633\u0627\u0633\u064a \u0622\u062e\u0631 \u0642\u062f \u0642\u0627\u0645 \u0628\u0648\u0636\u0639 \u0648\u0633\u0645 <code>final</code> \u0639\u0644\u0649 \u0628\u0639\u0636 \u0627\u0644\u0623\u0635\u0646\u0627\u0641 \u0641\u064a \u0627\u0644\u0625\u0635\u062f\u0627\u0631\u0627\u062a \u0627\u0644\u062d\u062f\u064a\u062b\u0629.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>\u062d\u062f\u0651\u062b \u062c\u0645\u064a\u0639 \u0627\u0644\u062a\u0639\u062f\u064a\u0644\u0627\u062a \u0627\u0644\u0645\u062a\u0648\u0631\u0637\u0629</b>\u060c \u062e\u0627\u0635\u0629 \u062a\u0644\u0643 \u0627\u0644\u062a\u064a \u0642\u062f \u062a\u0643\u0648\u0646 \u0645\u0631\u062a\u0628\u0637\u0629 \u0628\u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0623\u0633\u0627\u0633\u064a \u0627\u0644\u0645\u0630\u0643\u0648\u0631.<br>\u2022 \u0625\u0630\u0627 \u0627\u0633\u062a\u0645\u0631\u062a \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0627\u0628\u062d\u062b \u0639\u0646 \u0625\u0635\u062f\u0627\u0631 \u0645\u0646 \u0627\u0644\u062a\u0639\u062f\u064a\u0644 \u064a\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0625\u0635\u062f\u0627\u0631 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u062d\u0627\u0644\u064a \u0648\u0627\u0639\u062a\u0645\u0627\u062f\u064a\u0627\u062a\u0647.<br>\u2022 \u0641\u064a \u0628\u0639\u0636 \u0627\u0644\u062d\u0627\u0644\u0627\u062a\u060c \u0642\u062f \u064a\u0633\u0627\u0639\u062f \u062d\u0630\u0641 \u0645\u0624\u0642\u062a \u0644\u0644\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0635\u0646\u0641 \u0627\u0644\u0641\u0631\u0639\u064a \u0641\u064a \u062a\u0623\u0643\u064a\u062f \u0627\u0644\u0633\u0628\u0628.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "\u0645\u062d\u0627\u0648\u0644\u0629 \u0648\u0631\u0627\u062b\u0629 \u0635\u0646\u0641 \u0646\u0647\u0627\u0626\u064a";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u4f60\u6b63\u5728\u5c06 <b>Rubidium</b>\uff08\u4e00\u4e2a\u5df2\u8fc7\u65f6\u7684\u7528\u4e8e Forge \u7684 Sodium \u5206\u652f\uff09\u4e0e <b>Iris \u6216 Oculus</b> \u4e00\u8d77\u4f7f\u7528\u3002<br>\u5728\u8f83\u65b0\u7248\u672c\u7684 Minecraft\uff081.19.2 \u53ca\u4ee5\u4e0a\uff09\u4e2d\uff0cRubidium \u672a\u80fd\u8ddf\u4e0a Sodium \u7684\u66f4\u65b0\u6b65\u4f10\uff0c\u5176\u4f9d\u8d56\u9879\u51fa\u73b0\u4e86\u95ee\u9898\u3002<br><br>\u5982\u679c\u6027\u80fd\u6a21\u7ec4\uff08Sodium\u3001Rubidium\u3001Embeddium\u3001Bedium\u3001Xeonium \u7b49\uff09\u6216 Iris Shaders \u4e0e\u5176\u4ed6\u6a21\u7ec4\u53d1\u751f\u51b2\u7a81\uff0c\u4e5f\u53ef\u80fd\u5bfc\u81f4\u6b64\u9519\u8bef\u3002</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 \u4ece\u4f60\u7684 <code>mods</code> \u6587\u4ef6\u5939\u4e2d<b>\u5220\u9664 Rubidium</b>\u3002<br>\u2022 <b>\u5b89\u88c5 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a></b>\uff0c\u8fd9\u662f\u4e00\u4e2a\u6d3b\u8dc3\u4e14\u517c\u5bb9\u7684\u3001\u7528\u4e8e Forge \u7684 Sodium \u5206\u652f\uff0c\u652f\u6301\u5728 1.20+ \u7248\u672c\u4e2d\u4f7f\u7528 Iris/Oculus\u3002<br>\u2022 \u786e\u4fdd\u4e0d\u8981\u540c\u65f6\u5b89\u88c5\u591a\u4e2a Sodium \u5206\u652f\uff08\u4f8b\u5982\uff1aRubidium \u548c Embeddium\uff09\u3002<br>\u2022 \u5982\u679c\u4f60\u4f7f\u7528\u7684\u662f Oculus \u800c\u4e0d\u662f Iris\uff0c\u8bf7\u786e\u8ba4\u5b83\u4e5f\u4e0e\u4f60\u7684 Forge \u548c Embeddium \u7248\u672c\u517c\u5bb9\u3002";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "Rubidium \u5df2\u8fc7\u65f6\uff0c\u4e0e Iris/Oculus \u4e0d\u517c\u5bb9\uff08OptionInstance \u662f final\uff09";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u062a\u0639\u062f\u064a\u0644 <code>Simple Voice Chat</code> \u062a\u0634\u063a\u064a\u0644 \u062e\u0627\u062f\u0645 \u0627\u0644\u0635\u0648\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0647 \u0644\u0623\u0646 \u0645\u0646\u0641\u0630 UDP \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 IP \u0627\u0644\u0645\u064f\u0639\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.<br>\u0647\u0630\u0627 \u0644\u0627 \u064a\u0645\u0646\u0639 \u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629\u060c \u0644\u0643\u0646\u0647 \u064a\u0639\u0637\u0644 \u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u062f\u0631\u062f\u0634\u0629 \u0627\u0644\u0635\u0648\u062a\u064a\u0629.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>\u0623\u063a\u0644\u0642 \u0623\u064a \u0646\u0633\u062e\u0629 \u0623\u062e\u0631\u0649 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a</b> \u0623\u0648 \u062a\u0637\u0628\u064a\u0642 \u064a\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0645\u0646\u0641\u0630 UDP 24454.<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u0639\u0644\u0649 \u062e\u0627\u062f\u0645\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 <b>\u0623\u064a \u062e\u062f\u0645\u0629 \u0623\u062e\u0631\u0649</b> \u0644\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0627\u0644\u0645\u0646\u0641\u0630.<br>\u2022 \u0641\u064a \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u062a\u0639\u062f\u064a\u0644 (<code>config/voicechat/</code>)\u060c \u063a\u064a\u0651\u0631 \u0645\u0646\u0641\u0630 UDP \u0625\u0644\u0649 \u0645\u0646\u0641\u0630 \u062d\u0631 (\u0645\u062b\u0644\u0627\u064b 24455).<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0639\u0646\u0648\u0627\u0646 IP \u0645\u062e\u0635\u0635\u064b\u0627\u060c \u0641\u062a\u062d\u0642\u0642 \u0645\u0646 \u0635\u062d\u062a\u0647 \u0623\u0648 \u0627\u062a\u0631\u0643\u0647 \u0641\u0627\u0631\u063a\u064b\u0627 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0625\u0639\u062f\u0627\u062f \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "\u0627\u0644\u062f\u0631\u062f\u0634\u0629 \u0627\u0644\u0635\u0648\u062a\u064a\u0629: \u0645\u0646\u0641\u0630 UDP \u0645\u0634\u063a\u0648\u0644 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 IP \u063a\u064a\u0631 \u0635\u0627\u0644\u062d";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u65b9\u5757\u7269\u54c1 <code>" + nombreBlockItem + "</code> \u6307\u5411\u4e86\u4e00\u4e2a\u7a7a\u65b9\u5757\u3002<br>\u6b64\u9519\u8bef\u901a\u5e38\u53d1\u751f\u5728 <b>Create \u7684\u9644\u52a0\u6a21\u7ec4</b>\uff08\u5982 <code>dndecor</code>\u3001<code>createdeco</code>\uff09\u4e2d\uff0c\u5f53\u4e0e <code>Amendments</code>\u3001<code>Moonshine</code> \u5b58\u5728\u51b2\u7a81\u6216\u65b9\u5757\u521d\u59cb\u5316\u4e0d\u6b63\u786e\u65f6\u51fa\u73b0\u3002<br><b>\u6ce8\u610f\uff1a</b> \u8fd9\u5e76\u975e Amendments \u76f4\u63a5\u5bfc\u81f4\u7684\u9519\u8bef\uff0c\u800c\u662f\u6ce8\u518c\u8868\u52a0\u8f7d\u6df1\u5c42\u95ee\u9898\u7684\u75c7\u72b6\u3002</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>\u66f4\u65b0\u6240\u6709\u76f8\u5173\u6a21\u7ec4\uff1a</b>\u5305\u62ec Create\u3001Amendments\u3001Moonshine \u4ee5\u53ca\u4efb\u4f55\u9644\u52a0\u6a21\u7ec4\uff08\u7279\u522b\u662f <code>dndecor</code> \u548c <code>createdeco</code>\uff09\u3002<br>\u2022 \u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c<b>\u6682\u65f6\u9010\u4e2a\u79fb\u9664 Create \u7684\u9644\u52a0\u6a21\u7ec4</b>\u4ee5\u627e\u51fa\u7f6a\u9b41\u7978\u9996\u3002<br>\u2022 \u786e\u4fdd <b>Amendments \u548c Moonshine \u4e0e\u4f60\u7684 Create \u53ca Forge \u7248\u672c\u517c\u5bb9</b>\u3002<br>\u2022 \u68c0\u67e5\u95ee\u9898\u6a21\u7ec4\u662f\u5426\u6709\u66f4\u65b0\u7684\u6d4b\u8bd5\u7248\u6216\u5206\u652f\u7248\u672c\u3002";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "Create \u9644\u52a0\u6a21\u7ec4\u4e2d\u7684\u7a7a\u65b9\u5757\u7269\u54c1";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("\u53d1\u73b0\u4e86\u4e00\u4e9b\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u6fc0\u6d3b\u5e73\u53f0\uff08Forge\u3001Fabric\u7b49\uff09\u7684\u6a21\u7ec4\uff1a<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>\u8fd9\u901a\u5e38\u53d1\u751f\u5728\u4ee5\u4e0b\u60c5\u51b5\uff1a<br>").append("\u2022 \u5728\u540c\u4e00\u6587\u4ef6\u5939\u4e2d\u6df7\u5408\u4e86 <b>Fabric \u548c Forge</b> \u6a21\u7ec4\u3002<br>").append("\u2022 \u5b89\u88c5\u4e86\u4e0e Minecraft \u7248\u672c\u4e0d\u517c\u5bb9\u7684\u6a21\u7ec4\u3002<br>").append("\u2022 \u6a21\u7ec4\u5df2\u635f\u574f\u6216\u4e0d\u662f\u6709\u6548\u7684 JAR \u6587\u4ef6\u3002</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>\u8bf7\u786e\u8ba4\u6240\u6709\u6a21\u7ec4\u90fd\u9002\u7528\u4e8e\u540c\u4e00\u5e73\u53f0</b>\uff08\u4ec5 Forge <b>\u6216</b> \u4ec5 Fabric\uff0c\u4e0d\u53ef\u6df7\u7528\uff09\u3002<br>\u2022 \u4f7f\u7528<b>\u6a21\u7ec4\u6811</b>\u6765\u8bc6\u522b\u6bcf\u4e2a\u6587\u4ef6\u5bf9\u5e94\u7684\u5e73\u53f0\u3002<br>\u2022 \u5220\u9664\u4efb\u4f55\u4f60\u4e0d\u8ba4\u8bc6\u6216\u5c5e\u4e8e\u4e0d\u540c\u5e73\u53f0\u7684\u6a21\u7ec4\u3002<br>\u2022 \u5982\u679c\u4f60\u4f7f\u7528\u7684\u662f CurseForge \u6216 Prism \u7b49\u542f\u52a8\u5668\uff0c\u8bf7\u786e\u4fdd\u914d\u7f6e\u6587\u4ef6\u8bbe\u7f6e\u6b63\u786e\u3002";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "\u6a21\u7ec4\u4e0e\u5f53\u524d\u52a0\u8f7d\u5668\u4e0d\u517c\u5bb9";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u65e0\u6cd5\u521b\u5efa\u6a21\u578b <code>" + modid + ":" + nombreModelo + "</code>\u3002<br>\u8fd9\u8868\u660e\u6a21\u7ec4 <code>" + modid + "</code> \u7684\u8d44\u6e90\u5df2\u635f\u574f\u3001\u7f3a\u5931\uff0c\u6216\u4e0e\u4f60\u5f53\u524d\u7684 Minecraft \u7248\u672c\u4e0d\u517c\u5bb9\u3002</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>\u66f4\u65b0\u8be5\u6a21\u7ec4</b>\u81f3\u4e0e\u4f60\u7684\u5b9e\u4f8b\u517c\u5bb9\u7684\u6700\u65b0\u7248\u672c\u3002<br>\u2022 \u5982\u679c\u4f60\u4f7f\u7528\u7684\u662f\u5f00\u53d1\u7248\u6216\u81ea\u5b9a\u4e49\u7248\u672c\uff0c\u8bf7\u5207\u6362\u56de\u5b98\u65b9\u53d1\u5e03\u7248\u3002<br>\u2022 \u68c0\u67e5 JAR \u6587\u4ef6\u662f\u5426\u635f\u574f\uff08\u91cd\u65b0\u5b89\u88c5\uff09\u3002<br>\u2022 \u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c\u8bf7\u5c06\u6b64\u65e5\u5fd7\u9644\u4e0a\u5e76\u62a5\u544a\u7ed9\u6a21\u7ec4\u4f5c\u8005\u3002";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "\u521b\u5efa\u8d44\u6e90\u6a21\u578b\u5931\u8d25";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u68c0\u6d4b\u5230 <code>Moonlight</code> \u548c <code>Iceberg</code> \u6a21\u7ec4\u4e4b\u95f4\u5b58\u5728\u4e25\u91cd\u51b2\u7a81\u3002<br>\u4e24\u8005\u90fd\u8bd5\u56fe\u4ee5\u4e0d\u517c\u5bb9\u7684\u65b9\u5f0f\u6ce8\u518c\u8d44\u6e90\u91cd\u8f7d\u7cfb\u7edf\uff0c\u5bfc\u81f4\u56e0\u7f3a\u5c11\u6709\u6548\u7684\u56fe\u5f62\u4e0a\u4e0b\u6587\u800c\u5f15\u53d1 OpenGL \u9519\u8bef\u3002<br>\u5f53\u4f7f\u7528\u5305\u542b Fabric \u6a21\u7ec4\u9002\u914d\u5668\u7684 Forge \u7248\u672c\u65f6\uff0c\u6b64\u95ee\u9898\u5f88\u5e38\u89c1\u3002</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>\u5c06\u4e24\u4e2a\u6a21\u7ec4\u90fd\u66f4\u65b0</b>\u5230\u4e0e\u4f60\u5f53\u524d Forge \u7248\u672c\u517c\u5bb9\u7684\u6700\u65b0\u7248\u672c\u3002<br>\u2022 \u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c<b>\u6682\u65f6\u79fb\u9664 Iceberg</b>\uff0c\u56e0\u4e3a Moonlight \u901a\u5e38\u662f\u5176\u4ed6\u6a21\u7ec4\u7684\u5173\u952e\u4f9d\u8d56\u3002<br>\u2022 \u786e\u4fdd\u6ca1\u6709\u91cd\u590d\u6216\u6df7\u5408\u5b89\u88c5\u8fd9\u4e9b\u6a21\u7ec4\u7684 Forge/Fabric \u7248\u672c\u3002<br>\u2022 \u68c0\u67e5\u662f\u5426\u6709\u5176\u4ed6\u6a21\u7ec4\uff08\u5982 Supplementaries\u3001Citadel \u7b49\uff09\u5df2\u5185\u7f6e\u4e86 Iceberg \u7684\u529f\u80fd\u3002";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "\u4e25\u91cd\u51b2\u7a81\uff1aMoonlight \u4e0e Iceberg \u51b2\u7a81 (OpenGL \u65e0\u4e0a\u4e0b\u6587)";
    }

    @Override
    public String instantanea() {
        return "\u5feb\u7167";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "\u81ea\u4e0a\u6b21\u5feb\u7167\u4ee5\u6765";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "\u5feb\u7167\u521b\u5efa\u6210\u529f";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "\u521b\u5efa\u5feb\u7167\u65f6\u51fa\u9519";
    }

    @Override
    public String consejo() {
        return "\u63d0\u793a";
    }

    @Override
    public String resultadoMuestra() {
        return "\u7ed3\u679c\u9884\u89c8";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>\u63d0\u793a\uff1a</b>\u9009\u62e9\u4e24\u4e2a\u5386\u53f2\u8bb0\u5f55\u6587\u4ef6\u6765\u6bd4\u8f83\u6a21\u7ec4\u5217\u8868\u3002  \u7ed3\u679c\u4f1a\u6839\u636e\u6807\u51c6\u5316\u7684\u540d\u79f0\u663e\u793a<span style='color:%s;'>\u65b0\u589e\u7684 (+)</span>\u548c  <span style='color:%s;'>\u5df2\u79fb\u9664\u7684 (&#8722;)</span>\u3002  \u4f7f\u7528\u201c\u5feb\u7167\u201d\u6309\u94ae\u4e3a\u73b0\u6709\u6587\u4ef6\u521b\u5efa\u4e00\u4e2a\u6269\u5c55\u540d\u4e3a .instantanea \u7684\u526f\u672c\u3002</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "\u83b7\u53d6\u65e5\u5fd7\u94fe\u63a5\uff08Markdown\u683c\u5f0f\uff0c\u4e0d\u542b\u62a5\u544a\uff09";
    }

    @Override
    public String titulo_configuracion() {
        return "\u8bbe\u7f6e";
    }

    @Override
    public String columna_url() {
        return "\u7f51\u5740";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "\u5206\u4eab\u65f6\u53d1\u751f\u610f\u5916\u9519\u8bef\u3002";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "\u751f\u6210\u94fe\u63a5\u65f6\u53d1\u751f\u610f\u5916\u9519\u8bef\u3002";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "\u5904\u7406\u6309\u94ae\u65f6\u53d1\u751f\u610f\u5916\u9519\u8bef\u3002";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "\u6ca1\u6709\u5173\u8054\u7684\u6587\u4ef6\u53ef\u4f9b\u6253\u5f00\u3002";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "\u65e0\u6cd5\u5728\u7f16\u8f91\u5668\u4e2d\u6253\u5f00\u3002\n\u8def\u5f84\u5c06\u88ab\u590d\u5236\u5230\u526a\u8d34\u677f\u3002";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "\u65e0\u6cd5\u6253\u5f00\u6587\u4ef6\uff1b\u8def\u5f84\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f\u3002";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "\u684c\u9762\u64cd\u4f5c\u4e0d\u53d7\u652f\u6301\uff1b\u8def\u5f84\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f\u3002";
    }

    @Override
    public String limite_de_solicitudes() {
        return "\u60a8\u9047\u5230\u4e86\u8bf7\u6c42\u9891\u7387\u9650\u5236\u3002\u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u65e5\u5fd7\u7f51\u7ad9\u6216\u5176\u4ed6\u65e5\u5fd7API\u3002";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "\u5206\u4eab\u94fe\u63a5";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4fee\u590d\u539f\u6728\u9876\u90e8\u95ee\u9898\u662f\u7b2c\u4e00\u4f18\u5148\u7ea7\u3002\u683c\u5f0f\u4e3a\uff1a\u5c42\u7ea7\uff0c\u884c\u53f7\u3002\u6240\u6709\u65e5\u5fd7\u90fd\u6709\u7f16\u53f7\u7cfb\u7edf\u3002" + "<br>" + "\u901a\u5e38\u4f60\u9700\u8981\u5728\u6240\u6709\u65e5\u5fd7\u4e2d\u67e5\u627e\u6700\u5e95\u5c42\u7684\u5806\u6808\uff08\u4f4e\u5c42\u7ea7\uff09\uff0c\u9ad8\u5c42\u6570\u7684\u5806\u6808\u901a\u5e38\u662f\u8bef\u62a5\u3002\u4f7f\u7528\u4f60\u7684\u63a7\u5236\u53f0\u9605\u8bfb\u80fd\u529b\u5f88\u91cd\u8981\uff0c\u56e0\u4e3a\u5f53\u5806\u6808\u8fc7\u591a\u65f6\uff0c\u5806\u6808\u5206\u6790\u5e76\u4e0d\u5b8c\u7f8e\u3002</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "\u4ee4\u72b6\u871c\u7f50\u641c\u7d22\u5668";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "\u6b64\u529f\u80fd\u5373\u5c06\u4e0a\u7ebf\u3002";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "\u5373\u5c06\u63a8\u51fa";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "\u4e0e Crash Assistant \u4e0d\u517c\u5bb9\u7684\u6a21\u7ec4\uff08\u8bef\u62a5\uff09";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "\u4f7f\u7528 CrashAssistant \u7684\u6574\u5408\u5305\u5b58\u5728\u4e0d\u517c\u5bb9\u7684\u6a21\u7ec4";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant \u6709\u4e00\u4e2a\u6807\u8bb0\u4e3a\u4e0d\u517c\u5bb9\u7684\u6a21\u7ec4\u5217\u8868\uff0c\u4f46\u6211\u4eec\u6ca1\u6709\u8bc1\u636e\u8868\u660e\u5b83\u4eec\u771f\u7684\u4e0d\u517c\u5bb9\uff0c\u4e14\u8be5\u9519\u8bef\u63d0\u793a\u4ec5\u4ee5\u82f1\u6587\u663e\u793a\u3002\u5982\u679c\u4f60\u60f3\u4f7f\u7528\u8fd9\u4e9b\u6a21\u7ec4\uff0c\u53ef\u4ee5\u7f16\u8f91\u6587\u4ef6 <code>config/crash_assistant/config.toml</code>\uff0c\u5c06 [compatibility] \u90e8\u5206\u4e2d\u7684 <code>enabled = true</code> \u4fee\u6539\u4e3a <code>enabled = false</code>\u3002</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant \u5177\u6709\u5224\u65ad\u6a21\u7ec4\u4e0d\u517c\u5bb9\u7684\u80fd\u529b\uff0c\u4f46\u6709\u65f6\u5e76\u4e0d\u51c6\u786e\uff0c\u4e14\u9519\u8bef\u4fe1\u606f\u4ec5\u4e3a\u82f1\u6587\u3002\u5982\u679c\u4f60\u60f3\u4f7f\u7528\u8fd9\u4e9b\u6a21\u7ec4\uff0c\u53ef\u4ee5\u7f16\u8f91\u6587\u4ef6 <code>config/crash_assistant/problematic_mods_config.json</code>\uff0c\u5c06 <code>should_crash_on_startup</code> \u4ece <code>true</code> \u6539\u4e3a <code>false</code>\u3002</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u9519\u8bef\uff1a\u6a21\u7ec4 '" + modId + "' \u9700\u8981\u6a21\u7ec4 '" + dependencia + "'\u3002\u5f53\u524d\uff0c" + actual + "\u3002</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u9519\u8bef\uff1a\u6a21\u7ec4 '" + modId + "' \u9700\u8981 '" + dependencia + "' \u7684 '" + requerido + "' \u6216\u66f4\u9ad8\u7248\u672c\uff0c\u4f46\u8be5\u6a21\u7ec4\u672a\u5b89\u88c5\u3002</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u9519\u8bef\uff1a\u6a21\u7ec4 '" + modId + "' \u4e0e '" + dependencia + "' \u7684\u5f53\u524d\u7248\u672c\u4e0d\u517c\u5bb9\u3002\u4f60\u5fc5\u987b\u5220\u9664\u6a21\u7ec4 'Iris/Oculus & GeckoLib Compat'\uff0c\u56e0\u4e3a\u5b83\u4e0e Superb Warfare \u4e0d\u517c\u5bb9\uff0c\u5e76\u4e14\u65e0\u6cd5\u4e0e\u6700\u65b0\u7248 GeckoLib \u6b63\u5e38\u5de5\u4f5c\u3002\u5f53\u524d\u7248\u672c\uff1a" + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "\u9519\u8bef\uff1a\u65e0\u6cd5\u4e3a\u7c7b '" + clase + "' \u6267\u884c\u4efb\u52a1\u3002\u5f53\u6a21\u7ec4\u4e4b\u95f4\u4e0d\u517c\u5bb9\u6216\u4e0e\u5176\u4ed6\u5df2\u5b89\u88c5\u7684\u6a21\u7ec4\u53d1\u751f\u51b2\u7a81\u65f6\uff0c\u901a\u5e38\u4f1a\u51fa\u73b0\u6b64\u9519\u8bef\u3002";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "\u4efb\u52a1\u6267\u884c\u5931\u8d25";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "\u6b64\u7c7b\u9519\u8bef\u901a\u5e38\u662f\u7531\u4e8e\u6a21\u7ec4\u4e4b\u95f4\u7684\u4e0d\u517c\u5bb9\u6027\u5f15\u8d77\u7684\u3002\u7279\u522b\u662f\u90a3\u4e9b\u5728\u4f7f\u7528 ConnectorMod \u65f6\u4e0d\u80fd\u6b63\u5e38\u5de5\u4f5c\u7684\u6a21\u7ec4\u3002";
    }

    @Override
    public String info_clase_problematica() {
        return "\u95ee\u9898\u7c7b\uff1a";
    }

    public String ver_en_log() {
        return "\u5728\u65e5\u5fd7\u4e2d\u67e5\u770b";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "\u672a\u627e\u5230\u5b58\u5728\u6267\u884c\u95ee\u9898\u7684\u5177\u4f53\u7c7b\u3002";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 OptiFine \u548c\u5b9e\u4f53\u6a21\u578b\u529f\u80fd (EMF) \u4e4b\u95f4\u5b58\u5728\u4e25\u91cd\u51b2\u7a81\u3002\u8fd9\u4e24\u4e2a\u6a21\u7ec4\u4e0d\u517c\u5bb9\uff0c\u4f1a\u5bfc\u81f4\u6ce8\u5165\u5931\u8d25\uff0c\u4ece\u800c\u963b\u6b62\u6e38\u620f\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "OptiFine \u4e0e\u5b9e\u4f53\u6a21\u578b\u529f\u80fd\u51b2\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "\u5378\u8f7d OptiFine \u6216 \u5b9e\u4f53\u6a21\u578b\u529f\u80fd (EMF)\uff0c\u56e0\u4e3a\u5b83\u4eec\u5f7c\u6b64\u4e0d\u517c\u5bb9\u3002";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 OptiFine \u548c Fusion \u4e4b\u95f4\u5b58\u5728\u4e25\u91cd\u51b2\u7a81\u3002\u8fd9\u4e24\u4e2a\u6a21\u7ec4\u4e0d\u517c\u5bb9\uff0c\u4f1a\u5bfc\u81f4\u6ce8\u5165\u5931\u8d25\uff0c\u4ece\u800c\u963b\u6b62\u6e38\u620f\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "OptiFine \u4e0e Fusion \u51b2\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "\u5378\u8f7d OptiFine \u6216 Fusion\uff0c\u56e0\u4e3a\u5b83\u4eec\u5f7c\u6b64\u4e0d\u517c\u5bb9\u3002";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Flywheel\uff08\u7531 Create \u6240\u9700\uff09\u9700\u8981 Sodium 0.6.0-beta.2 \u6216\u66f4\u9ad8\u7248\u672c\u3002Rubidium \u662f 0.5.3\u3002\u8bf7\u8003\u8651\u4f7f\u7528 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u4f5c\u4e3a\u66ff\u4ee3\u65b9\u6848\u3002</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "Flywheel \u4e0e Sodium \u7248\u672c\u51b2\u7a81";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "\u5c06 Sodium \u66f4\u65b0\u81f3 0.6.0-beta.2 \u6216\u66f4\u9ad8\u7248\u672c\uff0c\u6216\u5b89\u88c5 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u4f5c\u4e3a\u517c\u5bb9\u7684\u66ff\u4ee3\u54c1\u3002";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 OptiFine \u548c Epic Fight \u4e4b\u95f4\u5b58\u5728\u4e25\u91cd\u51b2\u7a81\u3002\u8fd9\u4e24\u4e2a\u6a21\u7ec4\u4e0d\u517c\u5bb9\uff0c\u4f1a\u5bfc\u81f4\u6ce8\u5165\u5931\u8d25\uff0c\u4ece\u800c\u963b\u6b62\u6e38\u620f\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "OptiFine \u4e0e Epic Fight \u51b2\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "\u5378\u8f7d OptiFine \u6216 Epic Fight\uff0c\u56e0\u4e3a\u5b83\u4eec\u5f7c\u6b64\u4e0d\u517c\u5bb9\u3002";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 OptiFine \u548c Rubidium \u4e4b\u95f4\u7684\u4e25\u91cd\u51b2\u7a81\u3002 \u8fd9\u4e9b\u6a21\u7ec4\u4e0d\u517c\u5bb9\uff0c\u4f1a\u5bfc\u81f4\u6ce8\u5165\u5931\u8d25\uff0c\u4f7f\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "OptiFine \u548c Rubidium \u51b2\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "\u5378\u8f7d OptiFine \u6216 Rubidium\uff0c\u56e0\u4e3a\u5b83\u4eec\u5f7c\u6b64\u4e0d\u517c\u5bb9\u3002";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam \u6b63\u8bd5\u56fe\u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a\u52a0\u8f7d\uff0c\u4f46\u5b83\u4ec5\u4e0e\u5ba2\u6237\u7aef\u517c\u5bb9\u3002 \u8bf7\u4ece\u670d\u52a1\u5668\u4e2d\u79fb\u9664 FreeCam\uff0c\u6216\u786e\u4fdd\u5b83\u4ec5\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "FreeCam \u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "\u8bf7\u4ece\u4e13\u7528\u670d\u52a1\u5668\u4e2d\u79fb\u9664 FreeCam\uff0c\u56e0\u4e3a\u5b83\u53ea\u80fd\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) \u6b63\u8bd5\u56fe\u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a\u52a0\u8f7d\uff0c\u4f46\u5b83\u4ec5\u4e0e\u5ba2\u6237\u7aef\u517c\u5bb9\u3002 \u8bf7\u4ece\u670d\u52a1\u5668\u4e2d\u79fb\u9664 ETF\uff0c\u6216\u786e\u4fdd\u5b83\u4ec5\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features \u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "\u8bf7\u4ece\u4e13\u7528\u670d\u52a1\u5668\u4e2d\u79fb\u9664 Entity Texture Features\uff0c\u56e0\u4e3a\u5b83\u53ea\u80fd\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5fc5\u987b\u63a5\u53d7 Minecraft \u7684 EULA \u624d\u80fd\u8fd0\u884c\u670d\u52a1\u5668\u3002 \u7f16\u8f91 eula.txt \u6587\u4ef6\uff0c\u5c06 'eula=false' \u6539\u4e3a 'eula=true'\u3002</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "Minecraft \u7684 EULA \u672a\u63a5\u53d7";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "\u7f16\u8f91\u670d\u52a1\u5668\u6587\u4ef6\u5939\u4e2d\u7684 eula.txt \u6587\u4ef6\uff0c\u5c06 'eula=false' \u6539\u4e3a 'eula=true'\u3002";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \u6b63\u8bd5\u56fe\u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a\u52a0\u8f7d\uff0c\u4f46\u5b83\u4ec5\u4e0e\u5ba2\u6237\u7aef\u517c\u5bb9\u3002 \u8bf7\u4ece\u670d\u52a1\u5668\u4e2d\u79fb\u9664 OptiFine\uff0c\u6216\u786e\u4fdd\u5b83\u4ec5\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "OptiFine \u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "\u8bf7\u4ece\u4e13\u7528\u670d\u52a1\u5668\u4e2d\u79fb\u9664 OptiFine\uff0c\u56e0\u4e3a\u5b83\u53ea\u80fd\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks \u88ab\u9519\u8bef\u5730\u6807\u8bb0\u4e3a 1.20.1 \u7248\u672c\uff0c\u4f46\u4f7f\u7528\u4e86 1.21.1 \u7684\u65b9\u6cd5\u3002 \u8be5\u6a21\u7ec4\u6b63\u5c1d\u8bd5\u4f7f\u7528\u5728 1.20.1 \u4e2d\u4e0d\u5b58\u5728\u7684 ResourceLocation.fromNamespaceAndPath\u3002</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "Iron's Spellbooks \u7248\u672c\u9519\u8bef";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "\u8bf7\u786e\u4fdd\u4f7f\u7528\u4e0e\u4f60\u7684 Minecraft \u7248\u672c\u517c\u5bb9\u7684 Iron's Spellbooks \u6b63\u786e\u7248\u672c\u3002";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 OptiFine \u548c Embeddium \u4e4b\u95f4\u7684\u4e25\u91cd\u51b2\u7a81\u3002 \u8fd9\u4e9b\u6a21\u7ec4\u4e0d\u517c\u5bb9\uff0c\u4f1a\u5bfc\u81f4\u6ce8\u5165\u5931\u8d25\uff0c\u4f7f\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "OptiFine \u548c Embeddium \u51b2\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "\u5378\u8f7d OptiFine \u6216 Embeddium\uff0c\u56e0\u4e3a\u5b83\u4eec\u5f7c\u6b64\u4e0d\u517c\u5bb9\u3002";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u8fd9\u901a\u5e38\u7531\u4e16\u754c\u751f\u6210\u6a21\u7ec4\u51b2\u7a81\u5f15\u8d77\uff0c\u5c24\u5176\u662f Terralinth\u3001AmplifiedNether\u3001Nullscape \u548c Incendium \u7b49\u4e16\u754c\u751f\u6210\u7c7b\u6a21\u7ec4\u3002\u4e5f\u53ef\u80fd\u662f\u56e0\u4e3a\u7f3a\u5c11\u67d0\u4e2a\u5fc5\u9700\u7684\u6a21\u7ec4\u3002</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable \u6b63\u8bd5\u56fe\u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a\u52a0\u8f7d\uff0c\u4f46\u5b83\u4ec5\u4e0e\u5ba2\u6237\u7aef\u517c\u5bb9\u3002 \u8bf7\u4ece\u670d\u52a1\u5668\u4e2d\u79fb\u9664 Controllable\uff0c\u6216\u786e\u4fdd\u5b83\u4ec5\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "Controllable \u5728\u4e13\u7528\u670d\u52a1\u5668\u4e0a";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "\u8bf7\u4ece\u4e13\u7528\u670d\u52a1\u5668\u4e2d\u79fb\u9664 Controllable\uff0c\u56e0\u4e3a\u5b83\u53ea\u80fd\u5b89\u88c5\u5728\u5ba2\u6237\u7aef\u4e0a\u3002";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries \u6b63\u5728\u5f15\u53d1\u4e00\u4e2a\u9519\u8bef\uff0c\u5bfc\u81f4\u670d\u52a1\u5668\u65e0\u6cd5\u52a0\u8f7d\u3002 \u8be5\u6a21\u7ec4\u5728\u6ce8\u518c\u706b\u7130\u884c\u4e3a\u65f6\u5b58\u5728\u95ee\u9898\uff0c\u4f1a\u5728 datapacks \u52a0\u8f7d\u671f\u95f4\u5f15\u53d1\u6545\u969c\u3002</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries \u963b\u6b62\u670d\u52a1\u5668\u52a0\u8f7d";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "\u8bf7\u5c1d\u8bd5\u5c06 Supplementaries \u66f4\u65b0\u5230\u6700\u65b0\u7248\u672c\uff0c\u6216\u6682\u65f6\u7981\u7528\u5b83\u4ee5\u5141\u8bb8\u670d\u52a1\u5668\u52a0\u8f7d\u3002";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader (GML) \u53d1\u73b0\u7f3a\u5c11 Jackson \u6a21\u5757\u7684\u95ee\u9898\u3002 \u67d0\u4e9b\u6a21\u7ec4\uff08\u5982 Valkyrien Skies\uff09\u53ef\u80fd\u56e0\u672a\u5305\u542b\u6240\u6709\u5fc5\u8981\u4f9d\u8d56\u800c\u5f15\u53d1\u6b64\u9519\u8bef\u3002</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "Groovy Modloader \u7f3a\u5c11 Jackson \u6a21\u5757";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "\u79fb\u9664 Groovy Modloader \u4ee5\u53ca\u53ef\u80fd\u5f15\u53d1\u4f9d\u8d56\u51b2\u7a81\u7684\u76f8\u5173\u6a21\u7ec4\uff08\u5982 Valkyrien Skies\uff09\u3002";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat \u53d1\u73b0\u4e86\u4e00\u4e2a\u65e0\u6548\u7684\u6728\u5934\u65b9\u5757\u540d\u79f0\u3002 Every Compat \u901a\u5e38\u5b58\u5728\u5f88\u591a\u95ee\u9898\u3002\u8bf7\u4e0d\u8981\u4f7f\u7528\u5b83\uff01</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "Every Compat \u4e2d\u7684\u65e0\u6548\u540d\u79f0";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "\u68c0\u67e5\u4f7f\u7528 Every Compat \u7684\u8d44\u6e90\u5305\u6216\u6a21\u7ec4\uff0c\u5b83\u4eec\u53ef\u80fd\u5305\u542b\u65e0\u6548\u7684\u65b9\u5757\u540d\u79f0\u3002";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u9519\u8bef\u4ee3\u7801 (-1073741819)\uff0c\u53ef\u80fd\u7531 Razer \u7684 GameCaster\u3001Discord\u3001OBS Studio \u7b49 overlay \u6216 NVIDIA \u9a71\u52a8\u95ee\u9898\u5f15\u8d77\u3002</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "\u9519\u8bef\u4ee3\u7801 -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "\u5c1d\u8bd5\u7981\u7528 GameCaster\u3001Discord \u6216 OBS Studio \u7b49 overlay\uff0c\u5e76\u786e\u4fdd\u4f60\u7684 NVIDIA \u9a71\u52a8\u7a0b\u5e8f\u5df2\u66f4\u65b0\u3002";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips \u9700\u8981\u4f9d\u8d56 Immersive Messages\uff0c\u4f46\u672a\u5b89\u88c5\u3002 \u8bf7\u5b89\u88c5 Immersive Messages \u4ee5\u786e\u4fdd Immersive Tooltips \u6b63\u5e38\u5de5\u4f5c\u3002</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips \u7f3a\u5c11\u4f9d\u8d56";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "\u5b89\u88c5 Immersive Messages\uff0c\u56e0\u4e3a\u5b83\u662f Immersive Tooltips \u6240\u9700\u7684\u4f9d\u8d56\u3002";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins \u4e0e Apoli Mod \u5b58\u5728\u517c\u5bb9\u6027\u95ee\u9898\uff0c\u5176\u4e2d ItemStack \u65e0\u6cd5\u8f6c\u6362\u4e3a EntityLinkedItemStack\u3002 \u6b64\u95ee\u9898\u5e38\u89c1\u4e8e 6.6.0 \u4ee5\u4e0a\u7248\u672c\u3002\u5efa\u8bae\u4f7f\u7528\u66f4\u65e9\u7248\u672c\uff0c\u6216\u5c1d\u8bd5\u5728 Fabric \u548c Forge \u7248\u672c\u4e4b\u95f4\u5207\u6362\u3002</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "Medieval Origins \u7c7b\u578b\u8f6c\u6362\u9519\u8bef";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "\u8bf7\u4f7f\u7528 Medieval Origins 6.6.0 \u6216\u66f4\u65e9\u7248\u672c\uff0c\u6216\u5c1d\u8bd5\u5207\u6362\u8be5 mod \u7684 Fabric \u4e0e Forge \u7248\u672c\u3002";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether \u6b63\u5728\u5f15\u53d1\u4e00\u4e2a\u4e0e MusicManager \u4e2d\u7f3a\u5931\u7684 Registry Object \u76f8\u5173\u7684\u9519\u8bef\u3002 \u6b64\u95ee\u9898\u4e0e Reign of Nether \u7684 MusicManager mixin \u6709\u5173\u3002</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "Reign of Nether \u4e2d\u7684 MusicManager \u9519\u8bef";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "\u5c1d\u8bd5\u66f4\u65b0 Reign of Nether\uff0c\u6216\u4e34\u65f6\u79fb\u9664\u5b83\u4ee5\u89e3\u51b3\u6b64\u9519\u8bef\u3002";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel \u4ec5\u652f\u6301 Linux \u6216 Android \u4e0a\u7684 YSM \u670d\u52a1\u5668\u3002 \u6b64\u95ee\u9898\u5df2\u5728 2025 \u5e74 11 \u6708 23 \u65e5\u4e4b\u540e Modrinth \u4e0a\u7684\u66f4\u65b0\u7248\u672c\u4e2d\u4fee\u590d\u3002</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel \u4e0e Linux \u4e0d\u517c\u5bb9";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "\u8bf7\u4ece Modrinth \u66f4\u65b0 YesSteveModel \u81f3\u66f4\u65b0\u7684\u7248\u672c\uff0c\u8be5\u95ee\u9898\u5df2\u5728 11 \u6708 23 \u65e5\u4e4b\u540e\u4fee\u590d\u3002";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 Moving Elevators \u548c OptiFine \u4e4b\u95f4\u7684\u4e25\u91cd\u51b2\u7a81\u3002 \u8fd9\u4e9b\u6a21\u7ec4\u4e0d\u517c\u5bb9\uff0c\u4f1a\u5bfc\u81f4\u6ce8\u5165\u5931\u8d25\uff0c\u4f7f\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "Moving Elevators \u4e0e OptiFine \u51b2\u7a81";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "\u5378\u8f7d OptiFine \u6216 Moving Elevators\uff0c\u56e0\u4e3a\u5b83\u4eec\u5f7c\u6b64\u4e0d\u517c\u5bb9\u3002";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 Fabric API\uff08fabric-resource-loader-v0\uff09\u4e0e OptiFine \u4e4b\u95f4\u7684\u4e25\u91cd\u51b2\u7a81\u3002 \u8fd9\u4e9b\u6a21\u7ec4\u4e0d\u517c\u5bb9\uff0c\u4f1a\u5bfc\u81f4\u6ce8\u5165\u5931\u8d25\uff0c\u4f7f\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u3002</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "Fabric API \u4e0e OptiFine \u51b2\u7a81";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "\u5378\u8f7d OptiFine\uff0c\u6216\u5c06 Fabric API \u66f4\u65b0\u5230\u517c\u5bb9\u7248\u672c\u3002";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u67d0\u4e2a\u6a21\u7ec4\u5305\u542b\u4e00\u4e2a\u6709\u7f3a\u9677\u7684 ITransformationService\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a" + claseProveedor + "\u3002\u5fc5\u987b\u79fb\u9664\u6b64\u6a21\u7ec4\u624d\u80fd\u52a0\u8f7d\u6e38\u620f\u3002</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "\u6709\u7f3a\u9677\u7684 ITransformationService";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "\u79fb\u9664\u5305\u542b\u7c7b " + claseProveedor + " \u7684\u6a21\u7ec4\uff0c\u56e0\u4e3a\u5b83\u5305\u542b\u4e00\u4e2a\u6709\u7f3a\u9677\u7684 ITransformationService\u3002";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u67d0\u4e2a\u6a21\u7ec4\u7684\u7248\u672c\u58f0\u660e\u65e0\u6548\u3002 \u7248\u672c\u53f7\u5fc5\u987b\u7528\u65b9\u62ec\u53f7\u62ec\u8d77\u6765\u3002 \u4f60\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 grep/greprf \u5de5\u5177\u641c\u7d22\u7248\u672c\u53f7 </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'>\uff0c\u4ee5\u786e\u5b9a\u662f\u54ea\u4e2a\u6a21\u7ec4\u5b58\u5728\u95ee\u9898\u3002</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "\u6a21\u7ec4\u4e2d\u7684\u65e0\u6548\u7248\u672c";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 grep/greprf \u5de5\u5177\u641c\u7d22\u6709\u95ee\u9898\u7684\u7248\u672c\u53f7\uff0c\u627e\u5230\u5305\u542b\u5b83\u7684\u6a21\u7ec4\u3002";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 stack smashing \u9519\u8bef\uff0c\u5bfc\u81f4\u8fdb\u7a0b\u7ec8\u6b62\u3002 \u8fd9\u53ef\u80fd\u662f\u7531 Forge/NeoForge/PillowMC \u4e2d\u7684 Early Window \u95ee\u9898\uff0c\u6216 LWJGL 3.2.2 \u53ca\u66f4\u9ad8\u7248\u672c\u5f15\u8d77\u7684\u3002</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "\u68c0\u6d4b\u5230 Stack Smashing";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "\u68c0\u67e5 Early Window \u8bbe\u7f6e\uff0c\u5e76\u8003\u8651\u4f7f\u7528\u5176\u4ed6\u7248\u672c\u7684 LWJGL\uff0c\u6216\u68c0\u67e5\u4e0e\u65e9\u671f\u7a97\u53e3\u76f8\u5173\u7684\u6a21\u7ec4\u3002";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore \u4ec5\u9002\u7528\u4e8e\u7279\u5b9a\u7684\u6574\u5408\u5305\uff08modpack\uff09\uff0c\u4e0d\u5e94\u5728\u901a\u7528\u5b89\u88c5\u4e2d\u4f7f\u7528\uff0c\u5426\u5219\u4f1a\u5bfc\u81f4\u95ee\u9898\u3002</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore \u4e0e Java \u7248\u672c\u4e0d\u517c\u5bb9";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "\u8bf7\u79fb\u9664 GregTechEasyCore\uff0c\u56e0\u4e3a\u5b83\u4ec5\u9002\u7528\u4e8e\u7279\u5b9a\u6574\u5408\u5305\uff0c\u4e0e\u4f60\u7684\u901a\u7528\u5b89\u88c5\u4e0d\u517c\u5bb9\u3002";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 MoniLabs \u4e0e Connector Extras \u4e4b\u95f4\u5b58\u5728\u4e0e KubeJS \u4fee\u6539\u76f8\u5173\u7684\u51b2\u7a81\u3002 \u8fd9\u4e9b\u6a21\u7ec4\u5728 KubeJS \u4fee\u6539\u65b9\u9762\u4e0d\u517c\u5bb9\u3002</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "MoniLabs \u4e0e Connector Extras \u51b2\u7a81";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "\u5c1d\u8bd5\u5378\u8f7d\u5176\u4e2d\u4e00\u4e2a\u6a21\u7ec4\uff08MoniLabs \u6216 Connector Extras\uff09\uff0c\u56e0\u4e3a\u5b83\u4eec\u7684 KubeJS \u4fee\u6539\u5b58\u5728\u51b2\u7a81\u3002";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris \u9700\u8981 Distant Horizons [2.0.4] \u6216 DH API \u7248\u672c [1.1.0] \u6216\u66f4\u9ad8\u7248\u672c\u3002\u8bf7\u67e5\u9605\u517c\u5bb9\u6027\u6307\u5357\uff1ahttps://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e \u4ee5\u89e3\u51b3\u95ee\u9898\u3002</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "Iris \u4e0e Distant Horizons \u517c\u5bb9\u6027";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "\u8bf7\u67e5\u9605\u517c\u5bb9\u6027\u6307\u5357 https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e\uff0c\u5e76\u5c06 Iris \u548c Distant Horizons \u66f4\u65b0\u81f3\u517c\u5bb9\u7248\u672c\u3002";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 Minecraft \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u5b89\u88c5\u4e86\u9002\u7528\u4e8e\u5176\u4ed6\u6e38\u620f\u7248\u672c\u7684\u6a21\u7ec4\u3002\u4f60\u53ef\u4ee5\u4f7f\u7528 <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a> \u6765\u786e\u8ba4\u8be5\u7c7b\u662f\u5426\u5b58\u5728\u4e8e\u4f60\u7684\u7248\u672c\u4e2d\u3002</li><li>\u4f60\u7684 Minecraft \u5b89\u88c5\u635f\u574f\uff08\u5e38\u89c1\u4e8e CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u53ca\u5176\u4ed6\u6574\u5408\u5305\u542f\u52a8\u5668\uff09\u3002<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u67e5\u770b\u6559\u7a0b</a> \u4ee5\u89e3\u51b3 CurseForge \u95ee\u9898\u3002</li><li>\u4f60\u6709\u4e00\u4e2a\u635f\u574f\u7684 coremod\uff08coremod \u5931\u8d25\u53ef\u80fd\u4f1a\u963b\u6b62\u7c7b\u7684\u52a0\u8f7d\uff09\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 DangerZone \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u5b89\u88c5\u4e86\u9002\u7528\u4e8e\u5176\u4ed6\u6e38\u620f\u7248\u672c\u7684\u6a21\u7ec4\u3002</li><li>\u4f60\u6709\u635f\u574f\u7684 coremod\u3002</li><li>\u4f60\u7684\u542f\u52a8\u5668\u6216\u5b89\u88c5\u635f\u574f\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 FeatureCreep \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u5b89\u88c5\u4e86\u9002\u7528\u4e8e\u5176\u4ed6\u7248\u672c FeatureCreep \u7684\u6a21\u7ec4\uff08\u4f8b\u5982\uff1aESR \u4e0e Nightly\uff0c\u6216 v4 \u4e0e v12\uff09\u3002</li><li>\u4f60\u53ef\u4ee5\u4ece CurseForge \u6216 MinecraftStorage \u5b89\u88c5 FeatureCreep\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 ModLauncher \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u7684\u6a21\u7ec4\u9002\u7528\u4e8e\u4e0d\u540c\u7248\u672c\u7684 MinecraftForge\u3001PillowMC \u6216 NeoForge\uff08ModLauncher \u7528\u4e8e\u8fd9\u4e9b\u52a0\u8f7d\u5668\uff09\u3002</li><li>Minecraft \u7684\u6bcf\u4e2a\u7248\u672c\u90fd\u6709\u5927\u91cf modloader \u66f4\u65b0\u3002</li><li>\u4f60\u7684\u542f\u52a8\u5668\u5b89\u88c5\u635f\u574f\uff08\u5e38\u89c1\u4e8e CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u7b49\u6574\u5408\u5305\u542f\u52a8\u5668\uff09\u3002<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u67e5\u770b\u6559\u7a0b</a> \u4ee5\u89e3\u51b3 CurseForge \u95ee\u9898\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 Minecraft Forge \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u7684\u6a21\u7ec4\u9002\u7528\u4e8e\u4e0d\u540c\u7248\u672c\u7684 MinecraftForge\u3002</li><li>Minecraft \u7684\u6bcf\u4e2a\u7248\u672c\u90fd\u6709\u5927\u91cf modloader \u66f4\u65b0\u3002</li><li>\u4f60\u7684\u5b89\u88c5\u635f\u574f\uff08\u5e38\u89c1\u4e8e CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u7b49\u6574\u5408\u5305\u542f\u52a8\u5668\uff09\u3002<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u67e5\u770b\u6559\u7a0b</a> \u4ee5\u89e3\u51b3 CurseForge \u95ee\u9898\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 NeoForge \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u7684\u6a21\u7ec4\u9002\u7528\u4e8e\u4e0d\u540c\u7248\u672c\u7684 NeoForge\u3002</li><li>Minecraft \u7684\u6bcf\u4e2a\u7248\u672c\u90fd\u6709\u5927\u91cf modloader \u66f4\u65b0\u3002</li><li>\u4f60\u7684\u5b89\u88c5\u635f\u574f\uff08\u5e38\u89c1\u4e8e CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u7b49\u6574\u5408\u5305\u542f\u52a8\u5668\uff09\u3002<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u67e5\u770b\u6559\u7a0b</a> \u4ee5\u89e3\u51b3 CurseForge \u95ee\u9898\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 Fabric Loader \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u7684\u6a21\u7ec4\u9002\u7528\u4e8e\u4e0d\u540c\u7248\u672c\u7684 Fabric Loader\u3002</li><li>Minecraft \u7684\u6bcf\u4e2a\u7248\u672c\u90fd\u6709\u5927\u91cf modloader \u66f4\u65b0\u3002</li><li>\u4f60\u7684\u5b89\u88c5\u635f\u574f\uff08\u5e38\u89c1\u4e8e CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u7b49\u6574\u5408\u5305\u542f\u52a8\u5668\uff09\u3002<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u67e5\u770b\u6559\u7a0b</a> \u4ee5\u89e3\u51b3 CurseForge \u95ee\u9898\u3002</li><li>\u8bb8\u591a\u6a21\u7ec4\u9700\u8981 Fabric API\u3002\u5982\u9700\u8981\uff0c\u8bf7\u5b89\u88c5 Fabric API\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4f60\u7f3a\u5c11 PillowMC \u7684\u7c7b\u6587\u4ef6\u3002\u53ef\u80fd\u539f\u56e0\uff1a</b><ul><li>\u4f60\u7684\u6a21\u7ec4\u9002\u7528\u4e8e\u4e0d\u540c\u7248\u672c\u7684 PillowMC\u3002</li><li>Minecraft \u7684\u6bcf\u4e2a\u7248\u672c\u90fd\u6709\u5927\u91cf modloader \u66f4\u65b0\u3002</li><li>\u4f60\u7684\u5b89\u88c5\u635f\u574f\uff08\u5e38\u89c1\u4e8e CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u7b49\u6574\u5408\u5305\u542f\u52a8\u5668\uff09\u3002<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u67e5\u770b\u6559\u7a0b</a> \u4ee5\u89e3\u51b3 CurseForge \u95ee\u9898\u3002</li></ul><p>\u6ce8\u610f\uff1a\u53ea\u8981\u5728\u540d\u79f0\u4e2d\u4f7f\u7528 '/'\uff0c\u4f60\u5c31\u53ef\u4ee5\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr/fgrepr</b> \u5de5\u5177\u6765\u67e5\u627e\u5f15\u7528\u7f3a\u5931\u7c7b\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u4f60\u5b89\u88c5\u4e86\u4e00\u4e2a\u6545\u610f\u9020\u6210\u5361\u987f\u7684\u6a21\u7ec4\u3002Uranium \u662f\u4e00\u4e2a\u5361\u987f\u6a21\u7ec4\u3002\u5b83\u5e76\u975e\u603b\u4f1a\u5bfc\u81f4\u5d29\u6e83\uff0c\u4f46\u6700\u7ec8\u53ef\u80fd\u4f1a\u3002</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack \u88ab\u6807\u8bb0\u4e3a\u517c\u5bb9 1.19.*\uff0c\u4f46\u5b9e\u9645\u662f\u4e3a 1.20.* \u8bbe\u8ba1\u7684\uff0c\u5bfc\u81f4\u51fa\u73b0\u201c\u7c7b\u672a\u627e\u5230\u201d\u9519\u8bef\u3002\u8be5\u6a21\u7ec4\u5c1d\u8bd5\u4f7f\u7528\u5f53\u524d Minecraft \u7248\u672c\u4e2d\u4e0d\u5b58\u5728\u7684 DamageSources\u3002</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "Falling Attack \u7248\u672c\u9519\u8bef";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "\u8bf7\u786e\u4fdd\u4f60\u4f7f\u7528\u7684 Falling Attack \u7248\u672c\u4e0e\u4f60\u7684 Minecraft \u7248\u672c\u517c\u5bb9\u3002";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("\u4f60\u9700\u8981\u5b89\u88c5 CFR (Class File Reader) \u624d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd\u3002<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("\u5728 Linux\u3001NetBSD \u6216 FreeBSD \u7cfb\u7edf\u4e0a\uff0c\u4f60\u53ef\u4ee5\u901a\u8fc7\u5305\u7ba1\u7406\u5668\u5b89\u88c5 CFR\u3002<br>").append("\u5728\u6b64\u641c\u7d22\u5305\uff1a<a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("\u6216\u8005\uff0c\u4f60\u53ef\u4ee5\u4ece\u4ee5\u4e0b\u5730\u5740\u4e0b\u8f7d FabricMC \u4f7f\u7528\u7684\u4fee\u6539\u7248\uff1a<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("\u5c06\u5176\u4fdd\u5b58\u5230\u4ee5\u4e0b\u6587\u4ef6\u5939\uff1a<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>\u91cd\u8981\uff1a</b>\u5b89\u88c5 CFR \u540e\uff0c\u5fc5\u987b\u91cd\u542f mod \u624d\u80fd\u6b63\u786e\u8bc6\u522b\u3002").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "\u65e0\u53ef\u7528\u5934\u50cf";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "\u65e0\u6cd5\u627e\u5230\u7c7b\uff1a" + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "CFR \u53cd\u7f16\u8bd1\u5668 \u2013 Sakura Riddle\uff08\u975e\u5b98\u65b9\uff09";
    }

    @Override
    public String cfrClaseActual() {
        return "\u5f53\u524d\u7c7b";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "Sakura Riddle \u5934\u50cf";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "\u52a0\u8f7d\u5934\u50cf\u65f6\u51fa\u9519";
    }

    @Override
    public String noticiaLegalCFR() {
        return "\u672c\u56fe\u5f62\u7528\u6237\u754c\u9762\uff08GUI\uff09\u53cd\u7f16\u8bd1\u5de5\u5177\u65e8\u5728\u5e2e\u52a9\u7528\u6237\u8bca\u65ad\u6a21\u7ec4\u5d29\u6e83\u7684\u6839\u672c\u539f\u56e0\u3002\u7136\u800c\uff0c\u53cd\u7f16\u8bd1\u6a21\u7ec4\u53ef\u80fd\u5b58\u5728\u6cd5\u5f8b\u98ce\u9669\uff0c\u7528\u6237\u52a1\u5fc5\u786e\u4fdd\u4e0d\u5229\u7528\u751f\u6210\u7684\u4ee3\u7801\u4fb5\u72af\u300a\u8054\u90a6\u8457\u4f5c\u6743\u6cd5\u300b\u3002\u5efa\u8bae\u5728\u4f7f\u7528\u4efb\u4f55\u53cd\u7f16\u8bd1\u4ee3\u7801\u524d\uff0c\u4ed4\u7ec6\u67e5\u9605\u5bf9\u5e94\u6a21\u7ec4\u7684\u8bb8\u53ef\u8bc1\u3002\u6b64\u5916\uff0c\u8bb8\u591a\u6a21\u7ec4\u5f00\u53d1\u8005\u4f1a\u4e3b\u52a8\u516c\u5f00\u6e90\u4ee3\u7801\uff0c\u8fd9\u7c7b\u5b98\u65b9\u6e90\u7801\u901a\u5e38\u6bd4\u53cd\u7f16\u8bd1\u7ed3\u679c\u66f4\u6e05\u6670\u3001\u6613\u8bfb\u3002\u8bf7\u59cb\u7ec8\u5c0a\u91cd\u77e5\u8bc6\u4ea7\u6743\u53ca\u8f6f\u4ef6\u8bb8\u53ef\uff0c\u8fd9\u662f\u6a21\u7ec4\u5f00\u53d1\u793e\u533a\u7684\u6838\u5fc3\u539f\u5219\u3002\u60a8\u53ef\u901a\u8fc7\u4ee5\u4e0b\u94fe\u63a5\u67e5\u9605\u58a8\u897f\u54e5\u300a\u8054\u90a6\u8457\u4f5c\u6743\u6cd5\u300b\uff1a<a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">\u8054\u90a6\u8457\u4f5c\u6743\u6cd5\uff08\u897f\u73ed\u7259\u8bed\uff09</a>\uff0c\u82f1\u6587\u7248\u5728\u6b64\uff1a<a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (English)</a>\u3002\u9274\u4e8e\u60a8\u6b63\u5728 CurseForge \u5e73\u53f0\uff0c\u6211\u4eec\u540c\u65f6\u63d0\u4f9b\u7f8e\u56fd\u7248\u6743\u6cd5\u94fe\u63a5\uff1a<a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>\u3002\u6211\u4eec\u5efa\u8bae\u7528\u6237\u4e3b\u52a8\u4e86\u89e3\u6240\u5728\u5730\u9002\u7528\u7684\u6cd5\u5f8b\u6cd5\u89c4\u3002\u672c GUI \u4ec5\u9002\u7528\u4e8e\u7b80\u5355\u8bca\u65ad\uff1b\u5982\u9700\u6df1\u5ea6\u5206\u6790\uff0c\u8bf7\u4f7f\u7528 FabricMC \u7ef4\u62a4\u7684 Enigma \u5206\u652f\uff1a<a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>\u3002\u82e5\u9700\u5728\u65e0\u6e90\u7801\u60c5\u51b5\u4e0b\u76f4\u63a5\u7f16\u8f91 JAR \u6587\u4ef6\u6253\u8865\u4e01\uff0c\u53ef\u4f7f\u7528 Recaf\uff1a<a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">\u5b98\u65b9\u7f51\u7ad9</a>\u3002";
    }

    @Override
    public String botonDescargarCfr() {
        return "\u4e0b\u8f7d CFR";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "\u6253\u5f00\u5b89\u88c5\u6587\u4ef6\u5939";
    }

    @Override
    public String colorFondoPrincipal() {
        return "\u4e3b\u80cc\u666f\u989c\u8272";
    }

    @Override
    public String colorTextoBotonReset() {
        return "\u91cd\u7f6e\u6309\u94ae\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "\u641c\u7d22\u6846\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "\u7b5b\u9009\u4e0b\u62c9\u83dc\u5355\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoRenderer() {
        return "\u6e32\u67d3\u5668\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "\u52a0\u8f7d\u8986\u76d6\u5c42\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorBorde() {
        return "\u8fb9\u6846\u989c\u8272";
    }

    @Override
    public String colorFondoRetrato() {
        return "\u4eba\u50cf\u6a21\u5f0f\u80cc\u666f\u989c\u8272";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "\u5206\u4eab\u94fe\u63a5\u989c\u8272";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "\u5206\u4eab\u5b57\u6bb5\u80cc\u666f\u989c\u8272";
    }

    @Override
    public String rosaFondo() {
        return "\u80cc\u666f\u7c89\u7ea2\u8272";
    }

    @Override
    public String rosaSuave() {
        return "\u67d4\u548c\u7c89\u7ea2";
    }

    @Override
    public String moradoAcento() {
        return "\u5f3a\u8c03\u7d2b\u8272";
    }

    @Override
    public String textoOscuro() {
        return "\u6df1\u8272\u6587\u5b57";
    }

    @Override
    public String bordeSuave() {
        return "\u67d4\u548c\u8fb9\u6846";
    }

    @Override
    public String fondoCampo() {
        return "\u5b57\u6bb5\u80cc\u666f";
    }

    @Override
    public String fondoVistaPrevia() {
        return "\u9884\u89c8\u80cc\u666f";
    }

    @Override
    public String sintaxisConstructor() {
        return "\u8bed\u6cd5\u989c\u8272\uff1a\u6784\u9020\u51fd\u6570";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "\u8bed\u6cd5\u989c\u8272\uff1a\u5e2e\u52a9\u6d88\u606f";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "\u8bed\u6cd5\u989c\u8272\uff1aHTML \u6807\u7b7e";
    }

    @Override
    public String colorFondoVentana() {
        return "\u7a97\u53e3\u80cc\u666f\u989c\u8272";
    }

    @Override
    public String colorPanel() {
        return "\u9762\u677f\u989c\u8272";
    }

    @Override
    public String colorBotonTexto() {
        return "\u6309\u94ae\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorCampo() {
        return "\u5b57\u6bb5\u989c\u8272";
    }

    @Override
    public String colorBordeDestacado() {
        return "\u9ad8\u4eae\u8fb9\u6846\u989c\u8272";
    }

    @Override
    public String colorSeleccionTexto() {
        return "\u6587\u672c\u9009\u4e2d\u80cc\u666f\u8272";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "\u9009\u4e2d\u6587\u672c\u989c\u8272";
    }

    @Override
    public String colorEstadoExito() {
        return "\u72b6\u6001\u989c\u8272\uff1a\u6210\u529f";
    }

    @Override
    public String colorEstadoFallo() {
        return "\u72b6\u6001\u989c\u8272\uff1a\u5931\u8d25";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "\u72b6\u6001\u989c\u8272\uff1a\u5373\u65f6";
    }

    @Override
    public String colorResultadoAnadido() {
        return "\u5df2\u6dfb\u52a0\u7ed3\u679c\u989c\u8272";
    }

    @Override
    public String colorResultadoEliminado() {
        return "\u5df2\u5220\u9664\u7ed3\u679c\u989c\u8272";
    }

    @Override
    public String colorBordeScroll() {
        return "\u6eda\u52a8\u6761\u8fb9\u6846\u989c\u8272";
    }

    @Override
    public String colorFondoPanel() {
        return "\u9762\u677f\u80cc\u666f\u989c\u8272";
    }

    @Override
    public String colorBeigeListas() {
        return "\u5217\u8868\u7c73\u8272";
    }

    @Override
    public String colorTextoListas() {
        return "\u5217\u8868\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorBordeListas() {
        return "\u5217\u8868\u8fb9\u6846\u989c\u8272";
    }

    @Override
    public String colorBotonFondo() {
        return "\u6309\u94ae\u80cc\u666f\u989c\u8272";
    }

    @Override
    public String colorBordeBoton() {
        return "\u6309\u94ae\u8fb9\u6846\u989c\u8272";
    }

    @Override
    public String colorDoradoTexto() {
        return "\u91d1\u8272\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorPila() {
        return "\u5806\u6808\u8ddf\u8e2a\u989c\u8272 (stack trace)";
    }

    @Override
    public String colorTextoPanel() {
        return "\u9762\u677f\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoNegro() {
        return "\u9ed1\u8272\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoPrincipal() {
        return "\u4e3b\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorFondoResultados() {
        return "\u7ed3\u679c\u80cc\u666f\u989c\u8272";
    }

    @Override
    public String colorEstado() {
        return "\u72b6\u6001\u989c\u8272";
    }

    @Override
    public String colorTextoDescripcion() {
        return "\u63cf\u8ff0\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoEstado() {
        return "\u72b6\u6001\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorTextoExtra() {
        return "\u989d\u5916\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String colorSeparador() {
        return "\u5206\u9694\u7ebf\u989c\u8272";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "\u68c0\u6d4b\u5230\u539f\u751f\u9519\u8bef <code>StubRoutines::SafeFetch32</code>\u3002\u6b64\u95ee\u9898\u51fa\u73b0\u5728 macOS \u4e0a\u4f7f\u7528 JDK 17.0.9 \u65f6\uff0c\u5df2\u5728 JDK 17.0.10 \u53ca\u66f4\u9ad8\u7248\u672c\u4e2d\u4fee\u590d\u3002https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "JDK 17.0.9 (macOS) \u4e2d\u7684 SafeFetch32 \u539f\u751f\u9519\u8bef";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "\u8bf7\u5c06 JDK \u66f4\u65b0\u81f3 17.0.10 \u6216\u66f4\u9ad8\u7248\u672c\uff08\u4f8b\u5982 17.0.15\uff09\u3002";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "\u5982\u679c\u4f60\u4f7f\u7528 MultiMC\u3001Prism Launcher \u6216 TLauncher \u7b49\u542f\u52a8\u5668\uff0c\u8bf7\u5c06\u5176\u914d\u7f6e\u4e3a\u4f7f\u7528\u66f4\u65b0\u7684 JDK\u3002\u90e8\u5206\u542f\u52a8\u5668\u5df2\u5185\u7f6e JDK 17.0.15\u3002";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "Spark \u6a21\u7ec4\u4e5f\u53ef\u80fd\u5f15\u53d1\u6b64\u9519\u8bef\u3002\u5efa\u8bae\u6682\u65f6\u7981\u7528\u5b83\u3002https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MCEF \u6a21\u7ec4\uff08Chromium Embedded Framework\uff09\u6b63\u5728\u5bfc\u81f4\u9759\u9ed8\u5361\u6b7b\u3002</b><ul><li>MCEF \u5728\u65e5\u5fd7\u672b\u5c3e\u521d\u59cb\u5316\uff0c\u901a\u5e38\u610f\u5473\u7740\u6e38\u620f\u5728\u52a0\u8f7d\u8fc7\u7a0b\u4e2d\u5361\u6b7b\u3002</li><li>\u8be5\u6a21\u7ec4\u5df2\u77e5\u4f1a\u5728 Linux\u3001macOS \u7cfb\u7edf\u6216\u67d0\u4e9b Java \u7248\u672c\u4e0b\u5f15\u53d1\u5d29\u6e83\u3002</li><li>\u4e0d\u4e00\u5b9a\u51fa\u73b0\u660e\u786e\u9519\u8bef\uff0c\u4f46\u6e38\u620f\u59cb\u7ec8\u65e0\u6cd5\u8fdb\u5165\u4e3b\u83dc\u5355\u3002</li></ul><p>\u5982\u679c\u4f60\u4e0d\u9700\u8981\u6e38\u620f\u5185\u7684\u6d4f\u89c8\u5668\u529f\u80fd\uff08\u5982\u7f51\u9875\u5730\u56fe\u6216\u5d4c\u5165\u5f0f\u9875\u9762\uff09\uff0c\u8bf7\u79fb\u9664\u8be5\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "MCEF\uff08\u5d4c\u5165\u5f0f\u6d4f\u89c8\u5668\u6a21\u7ec4\uff09\u521d\u59cb\u5316\u95ee\u9898";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "\u4ece 'mods' \u6587\u4ef6\u5939\u4e2d\u5220\u9664 MCEF \u6a21\u7ec4\u6587\u4ef6\uff08\u6587\u4ef6\u540d\u4e2d\u5305\u542b 'mcef'\uff09\u3002";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "\u5982\u679c\u786e\u5b9e\u9700\u8981\u6b64\u529f\u80fd\uff0c\u8bf7\u786e\u4fdd\u4f7f\u7528\u4e0e\u4f60\u7684\u64cd\u4f5c\u7cfb\u7edf\u548c Minecraft \u7248\u672c\u517c\u5bb9\u7684 MCEF \u7248\u672c\u3002";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 <b>OptiFine</b> \u4e0e <b>Iris/Oculus</b> \u4e4b\u95f4\u7684\u51b2\u7a81\u3002</b><ul><li>OptiFine \u4ee5\u4e0e Iris \u6216 Oculus \u4e0d\u517c\u5bb9\u7684\u65b9\u5f0f\u4fee\u6539\u4e86 Minecraft \u7684\u6e32\u67d3\u3002</li><li>\u9519\u8bef <code>MixinLevelRenderer failed injection check</code> \u6765\u6e90\u4e8e <code>mixins.iris.json</code> \u6216 <code>mixins.oculus.json</code>\u3002</li></ul><p>\u8fd9\u4e9b\u6a21\u7ec4\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\u3002\u8bf7\u79fb\u9664 OptiFine\uff0c\u4ee5\u4fbf\u901a\u8fc7 Iris \u6216 Oculus \u4f7f\u7528\u5149\u5f71\uff08shaders\uff09\u3002</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "OptiFine \u4e0e Iris/Oculus \u51b2\u7a81";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "\u4ece 'mods' \u6587\u4ef6\u5939\u4e2d\u5220\u9664 OptiFine \u6587\u4ef6\u3002";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "\u4f7f\u7528 Iris \u6216 Oculus\uff08\u4e0d\u642d\u914d OptiFine\uff09\u4ee5\u83b7\u5f97\u73b0\u4ee3\u5149\u5f71\u6548\u679c\u3002";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230 <b>ModernFix</b> \u4e0e <b>OptiFine</b> \u4e4b\u95f4\u7684\u51b2\u7a81\u3002</b><ul><li>ModernFix \u4e0e OptiFine \u4e0d\u517c\u5bb9\uff0c\u56e0\u4e3a\u5b83\u4f1a\u7834\u574f Forge \u529f\u80fd\u5e76\u62d6\u6162\u542f\u52a8\u901f\u5ea6\u3002</li><li>ModernFix \u5b98\u65b9\u660e\u786e\u8b66\u544a\uff1a<i>\"Use of ModernFix with OptiFine is not supported\"</i>\u3002</li></ul><p>\u4f60\u5fc5\u987b\u5220\u9664\u5176\u4e2d\u4e00\u4e2a\u6a21\u7ec4\uff0c\u624d\u80fd\u8ba9\u6e38\u620f\u6b63\u5e38\u8fd0\u884c\u3002</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "ModernFix \u4e0e OptiFine \u51b2\u7a81";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "\u4ece 'mods' \u6587\u4ef6\u5939\u4e2d\u5220\u9664 OptiFine \u6216 ModernFix\u3002\u4e8c\u8005\u4e0d\u80fd\u5171\u5b58\u3002";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "\u5982\u679c\u9700\u8981\u6027\u80fd\u4f18\u5316\uff0c\u53ef\u8003\u8651\u4ec5\u4f7f\u7528 OptiFine\uff0c\u6216\u5c06 ModernFix \u66ff\u6362\u4e3a\u66f4\u8f7b\u91cf\u7684\u6a21\u7ec4\uff0c\u5982 FerriteCore \u6216 EntityCulling\u3002";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u9519\u8bef\uff1a\u6ce8\u518c\u952e\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002</b><ul><li><b>\u68c0\u6d4b\u5230\u7684\u952e\uff1a</b> <code>" + this.escapeHtml(clave) + "</code></li><li>\u5728 Minecraft \u4e2d\uff0c\u6240\u6709\u6ce8\u518c\u952e\uff08\u6807\u7b7e\u3001\u914d\u65b9\u3001\u6210\u5c31\u7b49\uff09\u5fc5\u987b\u4f7f\u7528<b>\u5c0f\u5199\u5b57\u6bcd</b>\uff0c\u4e14\u4ec5\u53ef\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u8fde\u5b57\u7b26\u548c\u659c\u6760\u3002</li><li>\u6b64\u9519\u8bef\u901a\u5e38\u7531\u7f16\u5199\u4e0d\u5f53\u7684\u6a21\u7ec4\u6216\u6709\u7f3a\u9677\u7684 datapack \u5f15\u8d77\u3002</li></ul><p><b>\u91cd\u8981\u63d0\u793a\uff1a</b>\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr</b> \u6216 <b>fgrepr</b> \u5de5\u5177\uff0c\u5e76\u542f\u7528 <b>\u201c\u5728 JAR \u6587\u4ef6\u4e2d\u641c\u7d22\u201d</b> \u9009\u9879\uff0c\u4ee5\u627e\u51fa\u5305\u542b\u6b64\u65e0\u6548\u952e\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "\u6ce8\u518c\u952e\u5305\u542b\u5927\u5199\u5b57\u6bcd\u6216\u975e\u6cd5\u5b57\u7b26";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "\u4f7f\u7528 'grepr' \u6216 'fgrepr' \u5e76\u5f00\u542f\u201c\u5728 JAR \u6587\u4ef6\u4e2d\u641c\u7d22\u201d\u4ee5\u5b9a\u4f4d\u95ee\u9898\u6a21\u7ec4\u3002";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "\u5982\u679c\u65e0\u6cd5\u786e\u5b9a\u5177\u4f53\u6a21\u7ec4\uff0c\u8bf7\u79fb\u9664\u6700\u8fd1\u5b89\u88c5\u7684\u6a21\u7ec4\uff0c\u5c24\u5176\u662f\u90a3\u4e9b\u6dfb\u52a0\u65b9\u5757\u3001\u7269\u54c1\u6216\u5de5\u5177\u7684\u6a21\u7ec4\u3002";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u52a0\u8f7d\u6a21\u7ec4 <b>" + this.escapeHtml(modNombre) + "</b> \u65f6\u51fa\u9519\u3002</b><ul><li>\u8be5\u6a21\u7ec4\u5728\u521d\u59cb\u5316\u67d0\u4e2a\u7ec4\u4ef6\uff08\u4f8b\u5982\u914d\u7f6e\u83dc\u5355\uff09\u65f6\u5931\u8d25\u3002</li><li>\u8fd9\u901a\u5e38\u662f\u56e0\u4e3a\u4e0e Minecraft\u3001Fabric \u6216\u5176\u4ed6\u6a21\u7ec4\u7684\u7248\u672c\u4e0d\u517c\u5bb9\u3002</li></ul><p>\u5982\u679c\u9519\u8bef\u6301\u7eed\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u6216\u66f4\u65b0\u6a21\u7ec4 <b>" + this.escapeHtml(modNombre) + "</b>\u3002</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "\u6a21\u7ec4\u521d\u59cb\u5316\u9519\u8bef\uff08Fabric Entrypoint\uff09";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "\u4ece 'mods' \u6587\u4ef6\u5939\u4e2d\u5220\u9664\u6a21\u7ec4 '" + modNombre + "'\u3002";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "\u5c06\u6a21\u7ec4 '" + modNombre + "' \u66f4\u65b0\u4e3a\u4e0e\u4f60\u5f53\u524d\u5b89\u88c5\u517c\u5bb9\u7684\u7248\u672c\u3002";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u4e0e\u6a21\u7ec4 <b>En Garde!</b> \u76f8\u5173\u7684\u9519\u8bef\u3002</b><ul><li>\u6b64\u6a21\u7ec4\u6dfb\u52a0\u4e86\u8fd1\u6218\u673a\u5236\uff08\u5982\u683c\u6321\u3001\u62db\u67b6\u7b49\uff09\u3002</li><li>\u8be5\u9519\u8bef\u901a\u5e38\u7531\u4e0e\u5176\u4ed6\u6218\u6597\u6a21\u7ec4\uff08\u5982 Epic Fight\u3001DualRiders \u7b49\uff09\u4e0d\u517c\u5bb9\uff0c\u6216\u4f7f\u7528\u4e86\u4e0e\u4f60\u7684 Minecraft \u4e0d\u5339\u914d\u7684\u7248\u672c\u5f15\u8d77\u3002</li></ul><p>\u5982\u679c\u4f60\u4e0d\u4f7f\u7528\u9ad8\u7ea7\u6218\u6597\u7cfb\u7edf\uff0c\u5efa\u8bae\u79fb\u9664 En Garde! \u4ee5\u907f\u514d\u51b2\u7a81\u3002</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "En Garde! \u6a21\u7ec4\u9519\u8bef";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "\u8bf7\u786e\u4fdd\u4f60\u4f7f\u7528\u7684 En Garde! \u7248\u672c\u4e0e\u4f60\u7684 Minecraft \u7248\u672c\u53ca\u52a0\u8f7d\u5668\uff08Fabric/Forge\uff09\u517c\u5bb9\u3002";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "\u5982\u679c\u4f60\u4f7f\u7528\u4e86\u5176\u4ed6\u6218\u6597\u6a21\u7ec4\uff08\u5982 Epic Fight\u3001Caelus \u7b49\uff09\uff0c\u8bf7\u7981\u7528\u5b83\u4eec\uff0c\u6216\u79fb\u9664 En Garde! \u4ee5\u907f\u514d\u51b2\u7a81\u3002";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u7531\u6a21\u7ec4 <b>IdleTweaks</b> \u5f15\u8d77\u7684\u9519\u8bef\u3002</b><ul><li>IdleTweaks \u5c1d\u8bd5\u91ca\u653e\u4e00\u4e2a\u5df2\u4e0d\u5b58\u5728\u7684\u7f51\u7edc\u901a\u9053\uff08<code>Tried to release unknown channel</code>\uff09\u3002</li><li>\u6b64\u9519\u8bef\u901a\u5e38\u51fa\u73b0\u5728\u8be5\u6a21\u7ec4\u7684\u65e7\u7248\u672c\u4e2d\uff0c\u6216\u5728\u914d\u7f6e\u4e0d\u5f53\u7684\u670d\u52a1\u5668\u4e0a\u4f7f\u7528\u65f6\u3002</li></ul><p>IdleTweaks \u662f\u4e00\u4e2a\u751f\u6d3b\u8d28\u91cf\u6a21\u7ec4\uff0c\u4f46\u53ef\u80fd\u5bfc\u81f4\u4e0d\u7a33\u5b9a\u3002\u5efa\u8bae\u66f4\u65b0\u6216\u79fb\u9664\u5b83\u3002</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "IdleTweaks \u9519\u8bef\uff08\u672a\u77e5\u7f51\u7edc\u901a\u9053\uff09";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "\u5c06 IdleTweaks \u66f4\u65b0\u81f3\u4e0e\u4f60\u7684 Minecraft \u517c\u5bb9\u7684\u6700\u65b0\u7248\u672c\u3002";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "\u5982\u679c\u4e0d\u9700\u8981\uff0c\u4ece 'mods' \u6587\u4ef6\u5939\u4e2d\u5220\u9664 IdleTweaks\u3002";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5c1d\u8bd5\u767b\u5f55 Minecraft \u65f6\u68c0\u6d4b\u5230\u8eab\u4efd\u9a8c\u8bc1\u9519\u8bef (HTTP 401)\u3002</b><p>\u6b64\u9519\u8bef<b>\u6781\u5c11\u76f4\u63a5\u5bfc\u81f4\u5d29\u6e83</b>\uff0c\u4f46\u5b83\u8868\u660e\u4f60\u6b63\u5728\u4f7f\u7528\u672a\u9a8c\u8bc1\u7684\u8d26\u6237\uff08\u76d7\u7248\uff09\u3002</p><p>\u5b98\u65b9\u652f\u6301\u6e20\u9053\uff08\u4f01\u4e1a\u9879\u76ee\u3001VTuber\u3001\u6574\u5408\u5305\u4f5c\u8005\u7b49\uff09<b>\u65e0\u6cd5\u4e3a\u4f60\u63d0\u4f9b\u5e2e\u52a9</b>\uff0c\u56e0\u4e3a\u53d7\u5176\u804a\u5929\u89c4\u5219\u3001\u5408\u540c\u3001\u4e0e Mojang/Microsoft \u7684\u534f\u8bae\u6216\u58f0\u8a89\u653f\u7b56\u7684\u9650\u5236\u3002</p><p>\u6b64\u68c0\u67e5\u53ef\u5728\u68c0\u6d4b\u5668\u7684<b>\u4f01\u4e1a\u8bbe\u7f6e\u4e2d\u7981\u7528</b>\u3002\u8b66\u544a\uff1a\u53cd\u76d7\u7248\u68c0\u6d4b<b>\u5e76\u975e\u5b8c\u7f8e</b>\uff0c\u53ef\u80fd\u5728\u5f00\u53d1\u73af\u5883\u3001\u7f51\u7edc\u4e0d\u7a33\u5b9a\u6216\u4f7f\u7528\u4fee\u6539\u7248\u542f\u52a8\u5668\u65f6\u88ab\u89e6\u53d1\u3002</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>\u5982\u679c\u4f60\u4ecd\u5c1d\u8bd5\u52a0\u5165\u652f\u6301\u9891\u9053\uff0c\u8bf7\u6ce8\u610f\u4ee5\u4e0b\u6743\u5229\u544a\u77e5\uff1a</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "Minecraft \u76d7\u7248";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "\u7981\u7528\u53cd\u76d7\u7248\u9a8c\u8bc1";
    }

    @Override
    public String comprarMC() {
        return "\u8d2d\u4e70 Minecraft";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u4f60\u6b63\u5728\u4f7f\u7528\u542f\u52a8\u5668 <code>" + id + "</code>\uff0c\u8be5\u542f\u52a8\u5668<b>\u4e0d\u5728\u63a8\u8350\u5217\u8868\u4e2d</b>\u3002</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>\u5c3d\u7ba1\u5b83\u53ef\u80fd\u53ef\u4ee5\u8fd0\u884c\uff0c\u4f46\u975e\u63a8\u8350\u542f\u52a8\u5668\u901a\u5e38\u4f1a\u5bfc\u81f4\uff1a</p><ul><li>\u6a21\u7ec4\u6216 App \u5b89\u88c5\u635f\u574f\u3002</li><li>\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u6216\u65e0\u660e\u786e\u9519\u8bef\u5730\u5361\u6b7b\u3002</li><li>\u6587\u4ef6\u5939\u7ed3\u6784\u5f02\u5e38\uff08\u96be\u4ee5\u8bca\u65ad\uff09\u3002</li><li>Java\u3001\u5185\u5b58\u6216\u6a21\u7ec4\u884c\u4e3a\u4e0d\u53ef\u9884\u6d4b\u3002</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "\u4e3a\u83b7\u5f97\u66f4\u597d\u7684\u4f53\u9a8c\uff0c\u8bf7\u4f7f\u7528\u4ee5\u4e0b\u63a8\u8350\u542f\u52a8\u5668\u4e4b\u4e00\uff1a";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "\u975e\u63a8\u8350\u542f\u52a8\u5668";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "\u5207\u6362\u5230\u63a8\u8350\u5217\u8868\u4e2d\u7684\u542f\u52a8\u5668\u3002";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u4f60\u6b63\u5728\u4f7f\u7528\u4e00\u4e2a<b>\u4e0d\u5efa\u8bae\u4f7f\u7528\u7684\u542f\u52a8\u5668</b>\uff1a<code>" + id + "</code>\u3002</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>\u4e0d\u5efa\u8bae\u4f7f\u7528\u7684\u542f\u52a8\u5668\u53ef\u80fd\u5bfc\u81f4\uff1a</p><ul><li>App \u6216\u6a21\u7ec4\u5b89\u88c5\u635f\u574f\u3002</li><li>\u6e38\u620f\u65e0\u6cd5\u542f\u52a8\u6216\u9759\u9ed8\u5d29\u6e83\u3002</li><li>\u6587\u4ef6\u7ec4\u7ec7\u5f02\u5e38\uff08\u96be\u4ee5\u8c03\u8bd5\uff09\u3002</li><li>\u65e0\u6cd5\u786e\u5b9a\u5176\u5982\u4f55\u7ba1\u7406\u6a21\u7ec4\u3001Java \u6216\u5185\u5b58\u3002</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "\u5f3a\u70c8\u5efa\u8bae\u4f7f\u7528\u4ee5\u4e0b\u542f\u52a8\u5668\u4e4b\u4e00\uff1a";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "\u4e0d\u5efa\u8bae\u4f7f\u7528\u7684\u542f\u52a8\u5668";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "\u5207\u6362\u5230\u63a8\u8350\u542f\u52a8\u5668\u4ee5\u83b7\u5f97\u652f\u6301\u3002";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5f53\u524d\u73af\u5883\u7f3a\u5c11\u63a8\u8350\u7684\u6a21\u7ec4\u3002</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "\u7f3a\u5c11\u63a8\u8350\u6a21\u7ec4";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "\u5b89\u88c5\u63a8\u8350\u6a21\u7ec4\u4ee5\u83b7\u5f97\u6700\u4f73\u4f53\u9a8c\u3002";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5728\u4f60\u7684\u5b89\u88c5\u4e2d\u68c0\u6d4b\u5230\u4e0d\u5efa\u8bae\u4f7f\u7528\u7684\u6a21\u7ec4\u3002</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "\u68c0\u6d4b\u5230\u4e0d\u5efa\u8bae\u4f7f\u7528\u7684\u6a21\u7ec4";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "\u79fb\u9664\u4e0d\u5efa\u8bae\u4f7f\u7528\u7684\u6a21\u7ec4\u4ee5\u907f\u514d\u95ee\u9898\u3002";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u68c0\u6d4b\u5230\u5bf9\u5173\u952e\u6587\u4ef6\u7684\u672a\u6388\u6743\u4fee\u6539\u3002\u4f60\u53ef\u80fd\u5df2\u624b\u52a8\u7f16\u8f91\u6587\u4ef6\uff0c\u6216\u6b63\u5728\u4f7f\u7528\u4e0d\u53ef\u9760\u7684\u542f\u52a8\u5668\u3002</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "\u68c0\u6d4b\u5230\u7be1\u6539";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "\u91cd\u65b0\u5b89\u88c5\u539f\u59cb\u6587\u4ef6\u4ee5\u6062\u590d\u5b8c\u6574\u6027\u3002";
    }

    @Override
    public String configuracionCorporativa() {
        return "\u4f01\u4e1a\u8bbe\u7f6e";
    }

    @Override
    public String idiomaRespaldo() {
        return "\u5907\u7528\u8bed\u8a00";
    }

    @Override
    public String buscardorHabilitado() {
        return "\u542f\u7528\u641c\u7d22\u5668";
    }

    @Override
    public String nombreHerramienta() {
        return "\u5de5\u5177\u540d\u79f0";
    }

    @Override
    public String condenarPirateria() {
        return "\u8c34\u8d23\u76d7\u7248";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "\u63a8\u8350\u542f\u52a8\u5668";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "\u4e0d\u5efa\u8bae\u7684\u542f\u52a8\u5668";
    }

    @Override
    public String modsRecomendados() {
        return "\u63a8\u8350\u6a21\u7ec4";
    }

    @Override
    public String modsDesaconsejados() {
        return "\u4e0d\u5efa\u8bae\u7684\u6a21\u7ec4";
    }

    @Override
    public String antiTamper() {
        return "\u9632\u7be1\u6539";
    }

    @Override
    public String proximamente() {
        return "\u5373\u5c06\u63a8\u51fa";
    }

    @Override
    public String informacion() {
        return "\u4fe1\u606f";
    }

    @Override
    public String errorCargandoImagen() {
        return "\u52a0\u8f7d\u56fe\u50cf\u65f6\u51fa\u9519";
    }

    @Override
    public String configuracionBasica() {
        return "\u57fa\u672c\u8bbe\u7f6e";
    }

    @Override
    public String funcionalidades() {
        return "\u529f\u80fd";
    }

    @Override
    public String derechosMiranda() {
        return "\u7c73\u5170\u8fbe\u6743\u5229\uff08\u5f3a\u70c8\u63a8\u8350\uff09";
    }

    @Override
    public String gestionVerificaciones() {
        return "\u9a8c\u8bc1\u7ba1\u7406";
    }

    @Override
    public String idVerificacion() {
        return "ID";
    }

    @Override
    public String nombreVerificacion() {
        return "\u540d\u79f0";
    }

    @Override
    public String codigoVerificacion() {
        return "\u4ee3\u7801";
    }

    @Override
    public String documentacionVerificacion() {
        return "\u6587\u6863";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "\u5df2\u542f\u7528\u7684\u9a8c\u8bc1\uff1a";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "\u5df2\u7981\u7528\u7684\u9a8c\u8bc1\uff1a";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "\u7981\u7528\u6240\u6709\u975e\u4f01\u4e1a\u7ea7\u9a8c\u8bc1";
    }

    @Override
    public String verCodigo() {
        return "\u67e5\u770b\u4ee3\u7801";
    }

    @Override
    public String verDocumentacion() {
        return "\u67e5\u770b\u6587\u6863";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "\u8bf7\u9009\u62e9\u4e00\u4e2a\u9a8c\u8bc1\u4ee5\u7981\u7528\u3002";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "\u8bf7\u9009\u62e9\u4e00\u4e2a\u9a8c\u8bc1\u4ee5\u542f\u7528\u3002";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "\u5df2\u7981\u7528 %d \u9879\u4e0d\u63a8\u8350\u7528\u4e8e\u4f01\u4e1a\u73af\u5883\u7684\u9a8c\u8bc1\u3002";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "\u6ca1\u6709\u53ef\u7981\u7528\u7684\u975e\u4f01\u4e1a\u7ea7\u9a8c\u8bc1\u3002";
    }

    @Override
    public String operacionCompletada() {
        return "\u64cd\u4f5c\u5b8c\u6210";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "\u6211\u4eec\u60f3\u5ff5\u4f60\uff0cAmane Kanata";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "\u4f01\u4e1a\u9a8c\u8bc1\u989c\u8272";
    }

    @Override
    public String nombreLanzador() {
        return "\u542f\u52a8\u5668\u540d\u79f0";
    }

    @Override
    public String motivo() {
        return "\u539f\u56e0";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "\u4e0d\u5efa\u8bae\u7684\u542f\u52a8\u5668";
    }

    @Override
    public String moverADesaconsejados() {
        return "\u8bbe\u4e3a\u4e0d\u5efa\u8bae";
    }

    @Override
    public String moverARecomendados() {
        return "\u8bbe\u4e3a\u63a8\u8350";
    }

    @Override
    public String guardarCambios() {
        return "\u4fdd\u5b58\u66f4\u6539";
    }

    @Override
    public String cancelar() {
        return "\u53d6\u6d88";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "\u8bf7\u9009\u62e9\u4e00\u4e2a\u542f\u52a8\u5668\u8fdb\u884c\u79fb\u52a8\u3002";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\u66f4\u6539\u5df2\u6210\u529f\u4fdd\u5b58\uff01";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "\u539f\u56e0";
    }

    @Override
    public String agregarLanzador() {
        return "\u6dfb\u52a0\u542f\u52a8\u5668";
    }

    @Override
    public String quitarLanzador() {
        return "\u79fb\u9664\u542f\u52a8\u5668";
    }

    @Override
    public String editarRazones() {
        return "\u7f16\u8f91\u539f\u56e0";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "\u8bf7\u9009\u62e9\u4e00\u4e2a\u542f\u52a8\u5668\u4ee5\u79fb\u9664\u3002";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "\u8bf7\u9009\u62e9\u4e00\u4e2a\u542f\u52a8\u5668\u4ee5\u7f16\u8f91\u3002";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return "\u7f16\u8f91 " + idLanzador + " \u7684\u539f\u56e0";
    }

    @Override
    public String agregarNuevoIdioma() {
        return "\u6dfb\u52a0\u65b0\u8bed\u8a00";
    }

    @Override
    public String aceptar() {
        return "\u786e\u5b9a";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "\u9009\u62e9\u8bed\u8a00";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "\u8fd9\u4e9b\u542f\u52a8\u5668\u662f CrashDetector \u63a8\u8350\u7684\u4f18\u8d28\u9009\u62e9\u3002";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "\u7ed3\u679c\u6b63\u786e";
    }

    @Override
    public String modsNoRecomendados() {
        return "\u4e0d\u5efa\u8bae\u7684\u6a21\u7ec4";
    }

    @Override
    public String agregarMod() {
        return "\u6dfb\u52a0\u6a21\u7ec4";
    }

    @Override
    public String quitarMod() {
        return "\u79fb\u9664\u6a21\u7ec4";
    }

    @Override
    public String modId() {
        return "Mod ID / JBoss Modules \u540d\u79f0";
    }

    @Override
    public String rutaMod() {
        return "\u6a21\u7ec4\u8def\u5f84 / \u6587\u4ef6";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "\u5fc5\u987b\u81f3\u5c11\u63d0\u4f9b modid \u6216\u6a21\u7ec4\u8def\u5f84\u3002";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "\u4f60\u53ef\u4ee5\u5728\u6b64\u6ce8\u518c\u4e0d\u5efa\u8bae\u7684\u6a21\u7ec4\uff0c\u4ee5\u4fbf CrashDetector \u5728\u5b83\u4eec\u88ab\u5b89\u88c5\u65f6\u8fdb\u884c\u68c0\u6d4b\u3002";
    }

    @Override
    public String anularNormal() {
        return "\u7981\u7528\u5e38\u89c4\u6a21\u5f0f";
    }

    @Override
    public String anularNormalDescripcion() {
        return "\u5373\u4f7f\u6ca1\u6709\u5d29\u6e83\uff0cCrashDetector \u4e5f\u5e94\u53d1\u51fa\u8b66\u544a\u3002";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "\u6ce8\u518c CrashDetector \u63a8\u8350\u7684\u6a21\u7ec4\u3002\u5982\u679c\u7f3a\u5931\uff0cCrashDetector \u53ef\u80fd\u4f1a\u53d1\u51fa\u8b66\u544a\u3002";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "\u5982\u679c\u4f60\u51b3\u5b9a\u542f\u7528\u53cd\u76d7\u7248\u8b66\u544a\uff0c\u5efa\u8bae\u5728\u6b64\u5904\u5b9a\u4e49\u8bf7\u6c42\u652f\u6301\u8005\u7684\u6743\u5229\uff0c\u4f5c\u4e3a\u4e00\u79cd\u9884\u9632\u63aa\u65bd\u3002\n\n\u4e0e\u666e\u904d\u8ba4\u77e5\u76f8\u53cd\uff0c\u8bb8\u591a\u70ed\u95e8\u793e\u533a\u548c\u652f\u6301\u9891\u9053\u5e76\u4e0d\u8981\u6c42\u542f\u7528\u53cd\u76d7\u7248\u8b66\u544a\u624d\u63d0\u4f9b\u5e2e\u52a9\u3002\u7136\u800c\uff0c\u82e5\u7528\u6237\u4ecd\u5c1d\u8bd5\u52a0\u5165\u652f\u6301\u9891\u9053\uff0c\u63d0\u524d\u8bb0\u5f55\u8fd9\u4e9b\u6743\u5229\u53ef\u80fd\u5f88\u6709\u7528\u3002\n\n\u4f60\u53ef\u4ee5\u53c2\u8003\u5b98\u65b9\u6587\u4ef6\uff0c\u4f8b\u5982\u58a8\u897f\u54e5\u300a\u88ab\u62d8\u7559\u8005\u57fa\u672c\u6743\u5229\u624b\u518c\u300b\uff1a\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\n\u4ee5\u53ca\u7f8e\u56fd\u3001\u4fc4\u7f57\u65af\u8054\u90a6\u3001\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u3001\u4f0a\u6717\u4f0a\u65af\u5170\u5171\u548c\u56fd\u548c\u671d\u9c9c\u6c11\u4e3b\u4e3b\u4e49\u4eba\u6c11\u5171\u548c\u56fd\u7b49\u56fd\u5bb6\u91c7\u7528\u7684\u7c7b\u4f3c\u6cd5\u5f8b\u539f\u5219\u3002\n\n\u53ef\u5305\u542b\u7684\u6743\u5229\u793a\u4f8b\u5305\u62ec\uff1a\n\u2022 \u6709\u6743\u4e0d\u63d0\u4f9b\u4e0e\u652f\u6301\u65e0\u5173\u7684\u4fe1\u606f\uff0c\u4f8b\u5982\u6240\u7528\u542f\u52a8\u5668\u3001\u7528\u6237\u540d\u6216 UUID\u3002\n\u2022 \u6709\u6743\u4e0d\u81ea\u8bc1\u5176\u7f6a\u3002\n\u2022 \u6709\u6743\u62d2\u7edd\u56de\u7b54\u4e0e\u95ee\u9898\u89e3\u51b3\u65e0\u5173\u7684\u95ee\u9898\u3002\n\u2022 \u6709\u6743\u5728\u804a\u5929\u4e2d\u83b7\u5f97\u5f15\u5bfc\u3002\n\u2022 \u6709\u6743\u4f7f\u7528 CrashDetector \u5185\u7f6e\u7684\u65e5\u5fd7\u533f\u540d\u5316\u529f\u80fd\u3002\n\n\u6b64\u6587\u672c\u652f\u6301 HTML \u5185\u5bb9\u3002";
    }

    @Override
    public String editar() {
        return "\u7f16\u8f91";
    }

    @Override
    public String advertenciaHashLento() {
        return "\u8b66\u544a\uff1a\u6dfb\u52a0\u5927\u91cf\u5927\u6587\u4ef6\u53ef\u80fd\u5bfc\u81f4\u9a8c\u8bc1\u8017\u65f6\u6570\u5206\u949f\u3002CrashDetector \u9700\u8981\u5148\u4e3a\u6bcf\u4e2a\u6587\u4ef6\u8ba1\u7b97\u54c8\u5e0c\u503c\u624d\u80fd\u7ee7\u7eed\u3002\u5efa\u8bae\u4ec5\u4fdd\u62a4\u4e25\u683c\u5fc5\u9700\u7684\u6587\u4ef6\u3002";
    }

    @Override
    public String agregarArchivo() {
        return "\u6dfb\u52a0\u6587\u4ef6";
    }

    @Override
    public String agregarCarpeta() {
        return "\u6dfb\u52a0\u6587\u4ef6\u5939";
    }

    @Override
    public String quitar() {
        return "\u79fb\u9664";
    }

    @Override
    public String rutaArchivo() {
        return "\u6587\u4ef6\u8def\u5f84";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "\u6240\u9009\u8def\u5f84\u4f4d\u4e8e\u5f53\u524d\u6e38\u620f\u76ee\u5f55\u4e4b\u5916\u3002\u4ec5\u5141\u8bb8\u4f7f\u7528\u5f53\u524d\u76ee\u5f55\u6216\u5176\u5b50\u76ee\u5f55\u4e2d\u7684\u6587\u4ef6\u548c\u6587\u4ef6\u5939\u3002";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>Sylent Bell \u7684\u89c2\u70b9\u548c\u8bc4\u8bba\u4e0d\u4e00\u5b9a\u4ee3\u8868\u6211\u4eec\u7684\u7acb\u573a\uff1b\u6211\u4eec\u53ea\u662f\u89c9\u5f97\u653e\u5728\u8fd9\u91cc\u633a\u6709\u8da3\u7684\u3002CrashDetector \u662f\u4e16\u4fd7\u7684\uff08\u975e\u5b97\u6559\u7684\uff09\u3002</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GML \u6a21\u7ec4\uff08Groovy ModLoader\uff09\u9700\u8981\u8fd9\u4e9b\u66f4\u6539\uff0c\u4e14\u8fd9\u662f\u8be5\u95ee\u9898\u6700\u5e38\u89c1\u7684\u6839\u6e90\u3002</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u68c0\u6d4b\u5230\u6b63\u5728\u4f7f\u7528 <i> Flywheel</i>\u3002</b><p><b> Flywheel \u5df2\u8fc7\u65f6\uff08deprecated\uff09</b>\uff0c\u4e0d\u5e94\u5728\u73b0\u4ee3\u7248\u672c\u4e2d\u4f7f\u7528\u3002</p><p>\u5f53\u524d\u7248\u672c\u7684 <b>Create</b> <b>\u5df2\u5185\u7f6e Flywheel</b>\uff0c\u56e0\u6b64\u5355\u72ec\u5b89\u88c5\u4f1a\u5bfc\u81f4\u517c\u5bb9\u6027\u51b2\u7a81\u548c\u52a0\u8f7d\u9519\u8bef\u3002</p><p>\u67d0\u4e9b\u660e\u786e\u4f9d\u8d56  Flywheel \u7684\u6a21\u7ec4\u53ef\u80fd<b>\u65e0\u6cd5\u8fd0\u884c</b>\u6216<b>\u8fd0\u884c\u4e0d\u7a33\u5b9a</b>\u3002\u5728\u67d0\u4e9b\u9ad8\u7ea7\u60c5\u51b5\u4e0b\uff0c\u82e5<b>\u624b\u52a8\u7f16\u8f91 <code>mods.toml</code> \u6587\u4ef6</b>\u4ee5\u8c03\u6574\u7248\u672c\u8303\u56f4\uff0c\u8fd9\u4e9b\u6a21\u7ec4\u6216\u8bb8\u80fd\u5de5\u4f5c\uff0c\u4f46<b>\u4e0d\u5efa\u8bae\u8fd9\u6837\u505a</b>\u3002</p>" + (mods.isEmpty() ? "" : "<p><b>\u68c0\u6d4b\u5230\u5f15\u7528 Flywheel \u7684\u6a21\u7ec4\uff1a</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>\u63a8\u8350\u7684\u89e3\u51b3\u65b9\u6848\u662f<b>\u79fb\u9664  Flywheel</b>\uff0c\u4ec5\u4f7f\u7528 Create \u5185\u7f6e\u7684\u7248\u672c\u3002</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "\u72ec\u7acb Flywheel";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u68c0\u6d4b\u5230\u4e0e\u6a21\u7ec4 <i>Floral Enchantments</i> \u76f8\u5173\u7684\u9519\u8bef\u3002</b><p>\u5d29\u6e83\u662f\u7531\u8be5\u6a21\u7ec4\u5728\u5904\u7406\u6e38\u620f\u6570\u636e\u65f6\u7684\u5185\u90e8\u6545\u969c\u5f15\u8d77\u7684\uff0c\u5bfc\u81f4\u6267\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0 <b>NullPointerException</b>\u3002</p><p>\u6b64\u95ee\u9898\u901a\u5e38\u53ef\u901a\u8fc7\u66f4\u65b0\u6216\u79fb\u9664\u8be5\u6a21\u7ec4\u89e3\u51b3\u3002</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "Floral Enchantments \u9519\u8bef";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>\u4f60\u540c\u65f6\u5b89\u88c5\u4e86 MixinExtras \u7684 NeoForge \u7248\u672c\u548c\u666e\u901a\u7248\u672c\u3002\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662f MinecraftForge\uff0c\u53ef\u4ee5\u5b89\u88c5 <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>\u6b64\u94fe\u63a5</a>\u4e2d\u7684\u4fee\u590d\u6a21\u7ec4\u3002</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u68c0\u6d4b\u5230\u4f7f\u7528 Iris \u7684\u5149\u5f71\uff08shaders\uff09\u65f6\u5730\u5f62\u9634\u5f71\u51fa\u73b0\u9519\u8bef\u3002</b><p>\u8be5\u95ee\u9898\u53d1\u751f\u5728\u5730\u5f62\u6e32\u67d3\u671f\u95f4\u3002</p><p>\u5efa\u8bae<b>\u5c1d\u8bd5\u5173\u95ed\u5149\u5f71\u8fd0\u884c\u6e38\u620f</b>\uff0c\u6216\u964d\u4f4e\u56fe\u5f62\u8d28\u91cf\uff0c\u5c24\u5176\u662f\u5728<b>Ultra</b>\u753b\u8d28\u8bbe\u7f6e\u4e0b\u3002</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "\u5730\u5f62\u9634\u5f71\uff08Iris\uff09";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u68c0\u6d4b\u5230\u670d\u52a1\u5668 tick \u8fc7\u957f\u3002</b><p>\u8fd9\u8868\u793a\u6e38\u620f\u5728\u5355\u4e2a tick \u4e2d\u5361\u4f4f\u7684\u65f6\u95f4\u8fc7\u957f\u3002</p><p>\u5efa\u8bae<b>\u68c0\u67e5\u65e5\u5fd7\u4e2d\u751f\u6210\u7684 thread dump</b>\u4ee5\u786e\u5b9a\u539f\u56e0\u3002</p><p><b>Stack Trace \u5206\u6790</b>\u53ef\u5e2e\u52a9\u4f60\u5b9a\u4f4d\u5361\u987f\u6e90\u5934\u3002</p><p>\u6b64\u5916\uff0c<b>\u5728\u65e5\u5fd7\u4e2d\u67e5\u770b</b>\u6309\u94ae\u4f1a\u5c06\u53ef\u80fd\u7684\u95ee\u9898\u6a21\u7ec4\u6807\u7ea2\uff0c\u4ee5\u53ca\u88ab <code>$modid$</code> \u5305\u56f4\u7684\u6761\u76ee\uff08\u901a\u5e38\u6307\u793a\u95ee\u9898\u6765\u6e90\uff09\u3002\u5bf9\u4e8e\u5b9e\u65f6\u5206\u6790\uff0c\u5efa\u8bae\u4f7f\u7528 VisualVM \u7684 CPU \u91c7\u6837\u5668\u3002\u8bf7\u786e\u4fdd\u4f60\u7684\u670d\u52a1\u5668\u6216\u7535\u8111\u6027\u80fd\u8db3\u591f\u8fd0\u884c\u4f60\u6240\u4f7f\u7528\u7684\u6a21\u7ec4\u2014\u2014\u5373\u4f7f\u6240\u6709\u6a21\u7ec4\u90fd\u6b63\u5e38\u5de5\u4f5c\uff0c\u6570\u91cf\u8fc7\u591a\u4e5f\u53ef\u80fd\u5bfc\u81f4\u6b64\u95ee\u9898\u3002</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "\u670d\u52a1\u5668 Tick \u8fc7\u957f";
    }

    @Override
    public String tituloLFPDPPP() {
        return "\u4e2a\u4eba\u6301\u6709\u4e2a\u4eba\u4fe1\u606f\u8054\u90a6\u4fdd\u62a4\u6cd5";
    }

    @Override
    public String aceptarPermanentemente() {
        return "\u6c38\u4e45\u63a5\u53d7";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "\u97e9\u8bed\u7ffb\u8bd1\u5305\u542b\u6765\u81ea\u5357\u65b9\u7684\u4fda\u8bed\uff0c\u4e3a\u9075\u5b88\u6cd5\u5f8b\u5fc5\u987b\u907f\u514d\u4f7f\u7528\u3002\u6839\u636e\u300a\u5e73\u58e4\u6587\u5316\u8bed\u8a00\u4fdd\u62a4\u6cd5\u300b\uff0c\u4e25\u683c\u7981\u6b62\u4f7f\u7528\u5916\u8bed\uff0c\u5c24\u5176\u662f\u6765\u81ea\u5357\u65b9\u7684\u8bed\u8a00\u3002";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "\u66f4\u591a\u4fe1\u606f\uff0c\u8bf7\u53c2\u9605\u8be5\u6cd5\u5f8b\u7684\u5b98\u65b9\u6587\u4ef6\uff1a<a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>\u5e73\u58e4\u6587\u5316\u8bed\u8a00\u4fdd\u62a4\u6cd5</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "\u9605\u8bfb\u5168\u6587";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "\u6253\u5f00\u94fe\u63a5\u65f6\u51fa\u9519";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "\u0642\u0627\u0646\u0648\u0646 \u062d\u0645\u0627\u064a\u0629 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u062b\u0642\u0627\u0641\u064a\u0629 \u0641\u064a \u0628\u064a\u0648\u0646\u063a \u064a\u0627\u0646\u063a";
    }

    @Override
    public String canarioTitulo() {
        return "\u53f8\u6cd5\u547d\u4ee4\u91d1\u4e1d\u96c0";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 \u76d1\u63a7\u76d1\u89c6\u5668";
    }

    @Override
    public String revisar() {
        return "\u68c0\u67e5";
    }

    @Override
    public String cerrar() {
        return "\u5173\u95ed";
    }

    @Override
    public String canarioTodoSeguro() {
        return "\u6240\u6709\u670d\u52a1\u5747\u62a5\u544a\u5b89\u5168\u72b6\u6001\u3002";
    }

    @Override
    public String canarioComprometido(int c) {
        return "\u8b66\u62a5\uff1a" + c + " \u4e2a\u670d\u52a1\u62a5\u544a\u4e0d\u5b89\u5168\u72b6\u6001\u3002";
    }

    @Override
    public String colorAlerta() {
        return "\u8b66\u62a5\u989c\u8272";
    }

    @Override
    public String opcionesMunidiales() {
        return "Munidial \u9009\u9879";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "LFPDPPP \u540c\u610f";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "\u5728 Handoff \u4e2d\u542f\u7528 ReLauncher \u7684\u8bbf\u95ee\u4ee4\u724c\u4f20\u8f93\uff08\u4e0d\u5efa\u8bae\uff09\u3002";
    }

    @Override
    public String consolaDesarrollo() {
        return "\u5f00\u53d1\u63a7\u5236\u53f0";
    }

    @Override
    public String mundial() {
        return "\u5168\u7403";
    }

    @Override
    public String ningun() {
        return "\u65e0";
    }

    public String consolaDesarrollador() {
        return "\u5f00\u53d1\u8005\u63a7\u5236\u53f0";
    }

    @Override
    public String bajar() {
        return "\u4e0b\u8f7d";
    }

    @Override
    public String logsSoporte() {
        return "\u652f\u6301\u65e5\u5fd7";
    }

    @Override
    public String detenerProceso() {
        return "\u7ec8\u6b62\u8fdb\u7a0b";
    }

    @Override
    public String copiarSeleccion() {
        return "\u590d\u5236\u9009\u4e2d\u5185\u5bb9";
    }

    @Override
    public String seleccionarTodo() {
        return "\u5168\u9009";
    }

    @Override
    public String copiarTodo() {
        return "\u590d\u5236\u5168\u90e8";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "\u53e6\u5b58\u4e3a\u6587\u4ef6";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "\u83b7\u53d6\u652f\u6301\u94fe\u63a5";
    }

    @Override
    public String borrarTodo() {
        return "\u6e05\u7a7a\u5168\u90e8";
    }

    public String colorFondoConsola() {
        return "\u63a7\u5236\u53f0\u80cc\u666f\u8272";
    }

    public String colorTextoConsola() {
        return "\u63a7\u5236\u53f0\u6587\u5b57\u989c\u8272";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "\u5df2\u786e\u8ba4\u540c\u610f\u3002\n\u65e5\u5fd7\u5206\u4eab\u529f\u80fd\u5c06\u5728\u6b64\u5904\u5b9e\u73b0\u3002";
    }

    @Override
    public String usarSakuraOriginal() {
        return "\u4f7f\u7528\u539f\u59cb Sakura Riddle \u56fe\u50cf";
    }

    @Override
    public String canario1984Descripcion() {
        return "\u201c\u6cd5\u5f8b\u4f20\u7968\u91d1\u4e1d\u96c0\u201d\uff08warrant canary\uff09\u662f\u4e00\u79cd\u900f\u660e\u5ea6\u673a\u5236\u3002\n\n\u53ea\u8981\u6b64\u6d88\u606f\u5b58\u5728\u4e14\u6240\u6709\u670d\u52a1\u663e\u793a\u4e3a\u5b89\u5168\uff0c\u5373\u8868\u793a\u8be5\u9879\u76ee\u672a\u6536\u5230\u4efb\u4f55\u79d8\u5bc6\u53f8\u6cd5\u547d\u4ee4\u3001\u5ba1\u67e5\u8981\u6c42\u6216\u5408\u6cd5\u76d1\u63a7\u8bf7\u6c42\u3002\n\n\u5982\u679c\u67d0\u4e2a\u91d1\u4e1d\u96c0\u6d88\u5931\u6216\u6807\u8bb0\u4e3a\u4e0d\u5b89\u5168\uff0c\u5219\u8868\u660e\u6cd5\u5f8b\u72b6\u51b5\u5df2\u53d1\u751f\u53d8\u5316\u3002\n\n\u672c\u9762\u677f\u4f1a\u68c0\u67e5\u7cfb\u7edf\u4e2d\u6240\u6709\u5df2\u6ce8\u518c\u7684\u91d1\u4e1d\u96c0\uff0c\u5e76\u663e\u793a\u5176\u5f53\u524d\u72b6\u6001\u3002\n\n\u70b9\u51fb\u201c\u68c0\u67e5\u201d\u4ee5\u66f4\u65b0\u72b6\u6001\u3002";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\u662f\u5426\u5c06\u6240\u6709\u9009\u9879\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c\uff1f";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "\u65e0\u9009\u9879";
    }

    @Override
    public String seleccionaColor() {
        return "\u9009\u62e9\u989c\u8272";
    }

    @Override
    public String botonMostrarGUI() {
        return "\u663e\u793a GUI";
    }

    @Override
    public String botonGuardarTodo() {
        return "\u4fdd\u5b58\u5168\u90e8";
    }

    @Override
    public String botonRestablecerTodo() {
        return "\u5168\u90e8\u91cd\u7f6e";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms \u672a\u52a0\u8f7d";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u68c0\u6d4b\u5230\u8bbf\u95ee LuckPerms API \u65f6\u51fa\u9519\u3002</b><p>\u6d88\u606f\u8868\u660e\uff0c\u5f53\u53e6\u4e00\u4e2a\u63d2\u4ef6\u5c1d\u8bd5\u4f7f\u7528 LuckPerms \u65f6\uff0c<b>LuckPerms \u5c1a\u672a\u52a0\u8f7d</b>\u3002</p><p><b>\u53ef\u80fd\u539f\u56e0\uff1a</b></p><ul><li><b>LuckPerms \u63d2\u4ef6\u672a\u5b89\u88c5</b>\uff0c\u6216 <b>\u542f\u52a8\u5931\u8d25</b>\u3002</li><li>\u53e6\u4e00\u4e2a\u63d2\u4ef6\u5728 <b>\u8fc7\u65e9</b> \u6216 <b>\u4e0d\u6b63\u786e</b> \u7684\u65f6\u673a\u5c1d\u8bd5\u8bbf\u95ee LuckPerms\u3002</li></ul><p>\u5efa\u8bae\u901a\u8fc7\u94fe\u63a5 <b>\u67e5\u770b\u63a7\u5236\u53f0\u65e5\u5fd7</b>\uff0c\u4ee5\u8bc6\u522b \u8c03\u7528 LuckPerms \u7684\u63d2\u4ef6\u5e76\u9a8c\u8bc1\u5176\u517c\u5bb9\u6027\u3002</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "Iris \u7740\u8272\u5668\u5305\u672a\u52a0\u8f7d";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "\u672a\u77e5" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u68c0\u6d4b\u5230\u4f7f\u7528 Iris/Oculus \u52a0\u8f7d\u7740\u8272\u5668\u5305\u65f6\u51fa\u9519\u3002</b><p><b>\u53d7\u5f71\u54cd\u7684\u7740\u8272\u5668\u5305\uff1a</b> " + nombre + "</p><p>Minecraft \u65e0\u6cd5\u6253\u5f00\u7740\u8272\u5668\u5305\u6587\u4ef6\uff08FileSystemNotFoundException\uff09\u3002</p><p><b>\u53ef\u80fd\u7684\u89e3\u51b3\u65b9\u6848\uff1a</b></p><ul><li>\u8bf7\u786e\u8ba4\u7740\u8272\u5668\u5305\u5df2\u6b63\u786e\u5b89\u88c5\u81f3 <b>shaderpacks</b> \u6587\u4ef6\u5939\u4e2d\u3002</li><li>\u91cd\u65b0\u4e0b\u8f7d\u8be5\u7740\u8272\u5668\u5305\uff0c\u56e0\u4e3a\u6587\u4ef6\u53ef\u80fd\u5df2\u635f\u574f\u3002</li><li>\u5982\u679c\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c\u8bf7\u5220\u9664 <b>config/iris.properties</b> \u6587\u4ef6\u4ee5\u91cd\u7f6e Iris \u914d\u7f6e\u3002</li></ul><p>\u5e94\u7528\u66f4\u6539\u540e\uff0c\u8bf7\u91cd\u65b0\u542f\u52a8\u6e38\u620f\u3002</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "\u65e0\u6cd5\u5199\u5165\u914d\u7f6e\u6587\u4ef6";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "\u672a\u77e5" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\u3002</b><p><b>\u53d7\u5f71\u54cd\u7684\u6587\u4ef6\uff1a</b> " + archivo + "</p><p>Minecraft \u65e0\u6cd5\u4f7f\u7528\u539f\u5b50\u5199\u5165\uff08REPLACE_ATOMIC\uff09\u5199\u5165\u8be5\u6587\u4ef6\u3002</p><p><b>\u901a\u5e38\u539f\u56e0\u5305\u62ec\uff1a</b></p><ul><li>\u6587\u4ef6\u5939\u6216\u6587\u4ef6\u7684\u6743\u9650\u4e0d\u6b63\u786e\u3002</li><li>\u6587\u4ef6\u88ab\u6807\u8bb0\u4e3a\u53ea\u8bfb\u3002</li><li>\u5176\u4ed6\u7a0b\u5e8f\uff08\u6740\u6bd2\u8f6f\u4ef6\u3001\u5907\u4efd\u5de5\u5177\u3001\u7f16\u8f91\u5668\uff09\u6b63\u5728\u9501\u5b9a\u8be5\u6587\u4ef6\u3002</li></ul><p><b>\u5efa\u8bae\u64cd\u4f5c\uff1a</b></p><ul><li>\u786e\u8ba4\u4f60\u5bf9\u6587\u4ef6\u5939\u62e5\u6709\u5199\u5165\u6743\u9650\u3002</li><li>\u79fb\u9664\u6587\u4ef6\u7684\u53ea\u8bfb\u5c5e\u6027\u3002</li><li>\u5173\u95ed\u53ef\u80fd\u6b63\u5728\u4f7f\u7528\u8be5\u6587\u4ef6\u7684\u7a0b\u5e8f\u3002</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "\u521b\u5efa\u5907\u4efd\u65f6\u8bbf\u95ee\u88ab\u62d2\u7edd";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "\u672a\u77e5" : origen;
        String dst = backup == null || backup.isEmpty() ? "\u672a\u77e5" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u5907\u4efd\u65f6\u53d1\u751f\u6743\u9650\u9519\u8bef\u3002</b><p><b>\u539f\u59cb\u6587\u4ef6\uff1a</b> " + src + "</p><p><b>\u5907\u4efd\u6587\u4ef6\uff1a</b> " + dst + "</p><p>\u64cd\u4f5c\u7cfb\u7edf\u5728\u4fdd\u5b58\u6587\u4ef6\u671f\u95f4\u963b\u6b62\u4e86\u8bbf\u95ee\u3002</p><p><b>\u901a\u5e38\u539f\u56e0\u5305\u62ec\uff1a</b></p><ul><li>\u6587\u4ef6\u5939\u6743\u9650\u4e0d\u8db3\u3002</li><li>\u6587\u4ef6\u88ab\u6807\u8bb0\u4e3a\u53ea\u8bfb\u3002</li><li>\u5176\u4ed6\u7a0b\u5e8f\uff08\u6740\u6bd2\u8f6f\u4ef6\u3001\u540c\u6b65\u5de5\u5177\u3001\u7f16\u8f91\u5668\uff09\u6b63\u5728\u4f7f\u7528\u8be5\u6587\u4ef6\u3002</li></ul><p><b>\u5efa\u8bae\u64cd\u4f5c\uff1a</b></p><ul><li>\u68c0\u67e5 <b>config</b> \u6587\u4ef6\u5939\u7684\u6743\u9650\u3002</li><li>\u5173\u95ed\u53ef\u80fd\u6b63\u5728\u8bbf\u95ee\u8be5\u6587\u4ef6\u7684\u7a0b\u5e8f\u3002</li><li>\u5c1d\u8bd5\u4ee5\u7ba1\u7406\u5458\u8eab\u4efd\u542f\u52a8\u542f\u52a8\u5668\u6216 Minecraft\u3002</li></ul>";
    }
}

