/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Coreano
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc798\ubabb\ub41c mods \ud3f4\ub354</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>CrashDetector\uc758 JAR \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>PID \uac80\uc0c9 \uc911: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") \uc885\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4!</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>JVM \uc5c6\uc74c</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>ATI/AMD \ub4dc\ub77c\uc774\ubc84\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uba74 \ub3c4\uc6c0\uc774 \ub420 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc774\ub97c \ud574\uacb0\ud558\ub824\uba74 \ub2e4\uc74c \uac00\uc774\ub4dc\ub97c \uc77d\uc73c\uc138\uc694: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\ub4dc\ub77c\uc774\ubc84 \uc5c5\ub370\uc774\ud2b8 \uac00\uc774\ub4dc</a> https://www.amd.com/ko/support/download/drivers.html \ub2e4\uc6b4\ub85c\ub4dc </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>\uc77c\ubd80\u65e7\ubc84\uc804\uc5d0\uc11c Nouveau \uadf8\ub798\ud53d \uce74\ub4dc\uc758 \ucd08\uae30 \ub85c\ub4dc \ud654\uba74\uc5d0\uc11c\ub54c\ub54c\ub85c\ubb38\uc81c\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uadf8\ub798\ud53d \uce74\ub4dc \ub4dc\ub77c\uc774\ubc84\uc5d0 \ubb38\uc81c\uac00 \uc788\uc2b5\ub2c8\ub2e4. AMD/ATI GPU \ub610\ub294 APU\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0 AMD \uadf8\ub798\ud53d \ub4dc\ub77c\uc774\ubc84\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uc2ed\uc2dc\uc624. NVIDIA \uadf8\ub798\ud53d \uce74\ub4dc\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0 \uac8c\uc784 \ubc0f \ubaa8\ub4e0 javaw.exe \uc778\uc2a4\ud134\uc2a4\ub97c\u7368\u7acb\u663e\u5361\ub85c \uc124\uc815\ud558\uc2ed\uc2dc\uc624. \uc774 \uac00\uc774\ub4dc\ub97c \uc77d\uc73c\uc2ed\uc2dc\uc624: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\ub4dc\ub77c\uc774\ubc84 \uc5c5\ub370\uc774\ud2b8 \uac00\uc774\ub4dc</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>FML \ucd08\uae30 \ucc3d \ub85c\ub4dc\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc218\uc815\ud558\ub824\uba74 (.minecraft/config/fml.toml)\ub85c \uc774\ub3d9\ud558\uc5ec earlyWindowProvider\ub97c \"none\"\uc73c\ub85c \uc124\uc815\ud558\uc2ed\uc2dc\uc624. Mac M1\uc744 \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0 Intel x64 \ubc84\uc804\uc774 \uc544\ub2cc ARM \ubc84\uc804 Java\ub97c \uc0ac\uc6a9 \uc911\uc778\uc9c0 \ud655\uc778\ud558\uc2ed\uc2dc\uc624. \uc774\uac83\uc740 \ub610\ud55c \ub4dc\ub77c\uc774\ubc84\uac00 \uc624\ub798\ub41c \uacbd\uc6b0\uc758 \uc77c\ubc18\uc801\uc778 \ubb38\uc81c\uc785\ub2c8\ub2e4. Windows\ub97c \uc0ac\uc6a9 \uc911\uc774\uace0 \uc774 \uc124\uc815\uc744 \uc0ac\uc6a9\ud558\uc9c0 \uc54a\uc73c\uba74 \uc774 \uac00\uc774\ub4dc\ub97c \ucc38\uc870\ud558\uc2ed\uc2dc\uc624: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\ub4dc\ub77c\uc774\ubc84 \uc5c5\ub370\uc774\ud2b8 \uac00\uc774\ub4dc</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\ud544\uc694\ud55c \uc758\uc874\uc131\uc774 \uc5c6\uc2b5\ub2c8\ub2e4:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "\uc694\uccad\uc790").replace("Expected range", "\uc608\uc0c1 \ubc94\uc704") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>CrashDetector \ubcf4\uace0\uc11c\ub294 \uc5ec\uae30\uc5d0\uc11c \ud655\uc778\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4 <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>\ubcf4\uace0\uc11c \ubcf4\uae30</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>CrashDetector\uc758 GUI \uc778\ud130\ud398\uc774\uc2a4\uc785\ub2c8\ub2e4. \uac8c\uc784\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \uc885\ub8cc\ub41c \uacbd\uc6b0 \uc774 \uc778\ud130\ud398\uc774\uc2a4\ub97c \ubb34\uc2dc\ud558\uc2ed\uc2dc\uc624.</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>\ubcf4\uace0\uc11c \ubcf4\uae30</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\ube0c\ub77c\uc6b0\uc800\uc5d0\uc11c \ub85c\uceec \ubcf4\uace0\uc11c\ub97c \ud655\uc778\ud569\ub2c8\ub2e4.</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "\ubcf4\uace0\uc11c \uacf5\uc720";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "\ubcf4\uace0\uc11c \uacf5\uc720. \ub85c\uadf8\uac00 securelogger.net\uc5d0 \uc5c5\ub85c\ub4dc\ub418\uace0 \ubcf4\uace0\uc11c\uac00 \ub2e4\ub978 \uc0ac\uc774\ud2b8\uc5d0 \uc5c5\ub85c\ub4dc\ub429\ub2c8\ub2e4.";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubb38\uc81c \uc788\ub294 JAR \ud30c\uc77c \uac10\uc9c0(FATAL \uc6b0\uc120, \uadf8 \ub2e4\uc74c\uc740 \uace0\uc6b0\uc120\uc21c\uc704 \ubc0f \u4f4e\uc6b0\uc120\uc21c\uc704):</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> \ub4f1\uae09:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801\uc77c \uc218 \uc788\uc74c:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubb38\uc81c \uc788\ub294 ModID \uac10\uc9c0(FATAL \uc6b0\uc120, \uadf8 \ub2e4\uc74c\uc740 \u4f4e\uc6b0\uc120\uc21c\uc704 \ubc0f \u4f4e\uc6b0\uc120\uc21c\uc704):</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubb38\uc81c \uc788\ub294 \ud328\ud0a4\uc9c0 \uac10\uc9c0(FATAL \uc6b0\uc120, \uadf8 \ub2e4\uc74c\uc740 \u4f4e\uc6b0\uc120\uc21c\uc704 \ubc0f \u4f4e\uc6b0\uc120\uc21c\uc704):</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801\uc778 \ud074\ub798\uc2a4(FATAL) \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4. \ub9e4\uc6b0 \uc2ec\uac01\ud55c \ubb38\uc81c\uc774\uba70, \uc8fc\ub85c \uc798\ubabb\ub41c CoreMod \ub610\ub294 \uce58\uba85\uc801\uc778 \uc758\uc874\uc131 \ubb38\uc81c\uc5d0\uc11c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. QuickFix\ub97c \uc0ac\uc6a9\ud558\uc5ec \uce58\uba85\uc801 \ud074\ub798\uc2a4\ub97c \uac00\uc9c4 \ubaa8\ub4dc\ub97c \ud0d0\uc9c0\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uac10\uc9c0\ub41c \ub204\ub77d\ub41c \uce58\uba85\uc801 \ud074\ub798\uc2a4:</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>{} \ub0b4\uc6a9(\uac00\uc7a5 \uc911\uc694\ud55c \ub0b4\uc6a9\uc774 \uc0c1\ub2e8\uc5d0 \uc788\uc73c\uba70 \ucc98\uc74c 20\uac1c\ub9cc \ud45c\uc2dc\ub428):</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubb38\uc81c \uc788\ub294 SpongeMixin \uad6c\uc131 \uac10\uc9c0: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc911\ubcf5\ub41c \ud328\ud0a4\uc9c0\ub97c \uac00\uc9c4 \ubaa8\ub4dc\uac00 \uc788\uc2b5\ub2c8\ub2e4. JAR \ud30c\uc77c\uc5d0\uc11c \uc911\ubcf5\ub41c \ud328\ud0a4\uc9c0(\ud3f4\ub354)\ub97c \uc0ad\uc81c\ud558\uc5ec \ud574\uacb0\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. WinRAR\ub098 7z \uac19\uc740 \uc555\ucd95 \ud504\ub85c\uadf8\ub7a8\uc73c\ub85c JAR \ud30c\uc77c\uc744 \uc5f4 \uc218\ub3c4 \uc788\uace0, \ud30c\uc77c \ud655\uc7a5\uc790\ub97c .jar\uc5d0\uc11c .zip\uc73c\ub85c \ubc14\uafbc \ud6c4 \ud3f4\ub354\ub97c \uc0ad\uc81c\ud558\uace0 \ub2e4\uc2dc .jar \ud655\uc7a5\uc790\ub85c \ubcc0\uacbd\ud560 \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4.</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc911\ubcf5 Mods \uac10\uc9c0</b> " + linea.replace("from mod files", "mod \ud30c\uc77c\uc5d0\uc11c");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge\uc5d0\uc11c \uc758\uc2ec\uc2a4\ub7ec\uc6b4 mod \ubb38\uc81c \uac10\uc9c0:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV\uc5d0\ub294 lithostitched\uac00 \ud544\uc694\ud569\ub2c8\ub2e4. \uc5ec\uae30\uc5d0\uc11c \uc124\uce58\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris \uc170\uc774\ub354 \ub610\ub294 Oculus\ub97c \uc0ac\uc6a9\ud558\ub824\uba74 SODIUM \ub610\ub294 \ub2e4\ub978 \ub85c\ub354\uc758 \ud638\ud658 \ubc84\uc804(Rubidium, Embedium, Bedium)\uc774 \ud544\uc694\ud569\ub2c8\ub2e4</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>KubeJS \ud655\uc7a5\uc5d0 \ubb38\uc81c\uac00 \uc788\uc2b5\ub2c8\ub2e4 </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Windows 11 \uc774\uc804 \ubc84\uc804\uc5d0\uc11c NVIDIA \ub4dc\ub77c\uc774\ubc84 \ubb38\uc81c \uac10\uc9c0\ub428.</span><br/><br/>Minecraft(\ubc0f \ud604\uc7ac JVM)\uc774 \uc804\uc6a9 NVIDIA GPU\ub97c \uc0ac\uc6a9\ud558\ub3c4\ub85d \ud558\ub824\uba74 \ub2e4\uc74c \ub2e8\uacc4\ub97c \ub530\ub974\uc138\uc694:<br/><br/>1. <strong>Java \uc2e4\ud589 \ud30c\uc77c \uc2dd\ubcc4\ud558\uae30:</strong><br/>   - \uc774 \ud504\ub85c\uadf8\ub7a8\uc740 \ub2e4\uc74c Java \uc2e4\ud589 \ud30c\uc77c\uc744 \uc0ac\uc6a9 \uc911\uc785\ub2c8\ub2e4: " + this.obtenerRutaJava() + "<br/>   - \ud2b9\uc815 \uacbd\ub85c\uac00 \ubcf4\uc774\uc9c0 \uc54a\ub294 \uacbd\uc6b0, \uc2dc\uc2a4\ud15c\uc5d0\uc11c 'java.exe'\ub97c \uac80\uc0c9\ud558\uc5ec Java \uc2e4\ud589 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.<br/><br/>2. <strong>NVIDIA \uc81c\uc5b4\ud310 \uc5f4\uae30:</strong><br/>   - \ubc14\ud0d5 \ud654\uba74\uc5d0\uc11c \ub9c8\uc6b0\uc2a4 \uc624\ub978\ucabd \ubc84\ud2bc\uc744 \ud074\ub9ad\ud558\uace0 'NVIDIA \uc81c\uc5b4\ud310'\uc744 \uc120\ud0dd\ud558\uc138\uc694.<br/><br/>3. <strong>\uc120\ud638\ud558\ub294 GPU \uc124\uc815\ud558\uae30:</strong><br/>   - NVIDIA \uc81c\uc5b4\ud310\uc5d0\uc11c '3D \uc124\uc815 \uad00\ub9ac'\ub85c \uc774\ub3d9\ud569\ub2c8\ub2e4.<br/>   - '\ud504\ub85c\uadf8\ub7a8 \uc124\uc815' \uc635\uc158\uc744 \uc120\ud0dd\ud569\ub2c8\ub2e4.<br/>   - '\ucd94\uac00'\ub97c \ud074\ub9ad\ud558\uace0 \uc55e\uc11c \uc2dd\ubcc4\ud55c Java \uc2e4\ud589 \ud30c\uc77c(ex.: 'java.exe')\uc744 \ucc3e\uc2b5\ub2c8\ub2e4.<br/>   - '\uace0\uc131\ub2a5 NVIDIA \ud504\ub85c\uc138\uc11c'\ub97c \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815\ub418\uc5c8\ub294\uc9c0 \ud655\uc778\ud569\ub2c8\ub2e4.<br/><br/>4. <strong>\ubcc0\uacbd \uc0ac\ud56d \uc800\uc7a5\ud558\uae30:</strong><br/>   - \ubcc0\uacbd \uc0ac\ud56d\uc744 \uc801\uc6a9\ud558\uace0 NVIDIA \uc81c\uc5b4\ud310\uc744 \ub2eb\uc2b5\ub2c8\ub2e4.<br/><br/>5. <strong>Minecraft \uc7ac\uc2dc\uc791\ud558\uae30:</strong><br/>   - Minecraft\ub97c \uc7ac\uc2dc\uc791\ud558\uc5ec \ubcc0\uacbd \uc0ac\ud56d\uc744 \uc801\uc6a9\ud569\ub2c8\ub2e4.<br/><br/>Windows Server 2022 \ub610\ub294 Windows 10\uc744 \uc0ac\uc6a9 \uc911\uc778 \uacbd\uc6b0, \ucd5c\uc2e0 NVIDIA \ub4dc\ub77c\uc774\ubc84\uac00 \uc124\uce58\ub418\uc5b4 \uc788\ub294 \ud55c \uc774\ub7ec\ud55c \ub2e8\uacc4\ub294 \uc720\ud6a8\ud569\ub2c8\ub2e4.<br/><br/>\ucc38\uace0: NVIDIA \uc81c\uc5b4\ud310\uc744 \ucc3e\uc744 \uc218 \uc5c6\ub294 \uacbd\uc6b0, NVIDIA \ub4dc\ub77c\uc774\ubc84\uac00 \uc62c\ubc14\ub974\uac8c \uc124\uce58\ub418\uc5b4 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Windows 11/Server 2025 \uc774\ud6c4 \ubc84\uc804\uc5d0\uc11c NVIDIA \ub4dc\ub77c\uc774\ubc84 \ubb38\uc81c \uac10\uc9c0\ub428.</span><br/><br/>Minecraft(\ubc0f \ud604\uc7ac JVM)\uc774 \uc804\uc6a9 NVIDIA GPU\ub97c \uc0ac\uc6a9\ud558\ub3c4\ub85d \ud558\ub824\uba74 \ub2e4\uc74c \ub2e8\uacc4\ub97c \ub530\ub974\uc138\uc694:<br/><br/>1. <strong>Java \uc2e4\ud589 \ud30c\uc77c \uc2dd\ubcc4\ud558\uae30:</strong><br/>   - \uc774 \ud504\ub85c\uadf8\ub7a8\uc740 \ub2e4\uc74c Java \uc2e4\ud589 \ud30c\uc77c\uc744 \uc0ac\uc6a9 \uc911\uc785\ub2c8\ub2e4: " + this.obtenerRutaJava() + "<br/>   - \ud2b9\uc815 \uacbd\ub85c\uac00 \ubcf4\uc774\uc9c0 \uc54a\ub294 \uacbd\uc6b0, \uc2dc\uc2a4\ud15c\uc5d0\uc11c 'java.exe'\ub97c \uac80\uc0c9\ud558\uc5ec Java \uc2e4\ud589 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.<br/><br/>2. <strong>\uc124\uc815 \uc571 \uc5f4\uae30:</strong><br/>   - <code>Win + I</code> \ud0a4\ub97c \ub20c\ub7ec \uc124\uc815 \uc571\uc744 \uc5fd\ub2c8\ub2e4.<br/>   - <strong>\uc2dc\uc2a4\ud15c > \ub514\uc2a4\ud50c\ub808\uc774 > \uadf8\ub798\ud53d</strong>\uc73c\ub85c \uc774\ub3d9\ud569\ub2c8\ub2e4.<br/><br/>3. <strong>\uc120\ud638\ud558\ub294 GPU \uc124\uc815\ud558\uae30:</strong><br/>   - '\uadf8\ub798\ud53d' \uc139\uc158\uc5d0\uc11c '\uae30\ubcf8 \uadf8\ub798\ud53d \uc124\uc815'\uc744 \ud074\ub9ad\ud569\ub2c8\ub2e4.<br/>   - '\ub370\uc2a4\ud06c\ud1b1 \uc571'\uc744 \uc120\ud0dd\ud558\uace0 '\ucc3e\uc544\ubcf4\uae30'\ub97c \ud074\ub9ad\ud569\ub2c8\ub2e4.<br/>   - \uc55e\uc11c \uc2dd\ubcc4\ud55c Java \uc2e4\ud589 \ud30c\uc77c(ex.: 'java.exe')\uc744 \ucc3e\uc544 \uc120\ud0dd\ud569\ub2c8\ub2e4.<br/>   - \ucd94\uac00 \ud6c4, \ubaa9\ub85d\uc5d0\uc11c Java \uc560\ud50c\ub9ac\ucf00\uc774\uc158\uc744 \uc120\ud0dd\ud558\uace0 '\uace0\uc131\ub2a5(NVIDIA)'\uc744 \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815\ud569\ub2c8\ub2e4.<br/><br/>4. <strong>\ubcc0\uacbd \uc0ac\ud56d \uc800\uc7a5\ud558\uae30:</strong><br/>   - \ubcc0\uacbd \uc0ac\ud56d\uc744 \uc801\uc6a9\ud558\uace0 \uc124\uc815 \uc571\uc744 \ub2eb\uc2b5\ub2c8\ub2e4.<br/><br/>5. <strong>Minecraft \uc7ac\uc2dc\uc791\ud558\uae30:</strong><br/>   - Minecraft\ub97c \uc7ac\uc2dc\uc791\ud558\uc5ec \ubcc0\uacbd \uc0ac\ud56d\uc744 \uc801\uc6a9\ud569\ub2c8\ub2e4.<br/><br/>Windows 11 \ub610\ub294 Windows Server 2025+\ub97c \uc0ac\uc6a9 \uc911\uc778 \uacbd\uc6b0, \ucd5c\uc2e0 NVIDIA \ub4dc\ub77c\uc774\ubc84\uac00 \uc124\uce58\ub418\uc5b4 \uc788\ub294 \ud55c \uc774\ub7ec\ud55c \ub2e8\uacc4\ub294 \uc720\ud6a8\ud569\ub2c8\ub2e4.<br/><br/>\ucc38\uace0: \uadf8\ub798\ud53d \uc124\uc815 \uc635\uc158\uc744 \ucc3e\uc744 \uc218 \uc5c6\ub294 \uacbd\uc6b0, NVIDIA \ub4dc\ub77c\uc774\ubc84\uac00 \uc62c\ubc14\ub974\uac8c \uc124\uce58\ub418\uc5b4 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc11c\ubc84 \ub610\ub294 \uc6d4\ub4dc\uc758 \ud2f1\uc774 60\ucd08 \uc774\uc0c1\uc785\ub2c8\ub2e4. \uc774\ub294 \ubaa8\ub4dc\uac00 \uc11c\ubc84\ub97c \ub290\ub9ac\uac8c \ub9cc\ub4e4\uac70\ub098 \ud558\ub4dc\uc6e8\uc5b4\uac00 \ub108\ubb34 \uc57d\ud55c \uacbd\uc6b0\uc77c \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ucda9\ubd84\ud55c RAM/\uba54\ubaa8\ub9ac\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \ub354 \ub9ce\uc740 \uba54\ubaa8\ub9ac\ub97c \ud560\ub2f9\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Theseus\ub294 \ub610\ud55c \ubaa8\ub4dc\ub97c \uc0ad\uc81c\ud558\ub824 \ud560 \ub54c \uc2e4\ud328\ud558\ub294 \ub4f1\uc758 \ucd94\uac00\uc801\uc778 \ubb38\uc81c\uac00 \uc788\uc2b5\ub2c8\ub2e4. mrpack \ud30c\uc77c\uc744 \uc0ac\uc6a9\ud574\uc57c \ud55c\ub2e4\uba74, Prism Launcher(modrinth.com \uc804\uc6a9), ATLauncher(modrinth.com \uc804\uc6a9), \ub610\ub294 Hello Minecraft Launcher(modrinth.com \ubc0f bbsmc.net \uc9c0\uc6d0)\uc640 \uac19\uc740 \ub2e4\ub978 \ub7f0\ucc98\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\"\ub7f0\ucc98 \uc2dc\uc791 \uac74\ub108\ub6f0\uae30\"(CurseForge \uc571)\ub97c \uc0ac\uc6a9 \uc911\uc785\ub2c8\ub2e4. \uc774\ub85c \uc778\ud574 \uac10\uc9c0\ud558\uae30 \uc5b4\ub824\uc6b4 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc774\ub294 \uad6c\ud615 CurseForge \uc571\uc774\ub098 \ucd5c\uc2e0 \ubc84\uc804\uc758 \"\ub7f0\ucc98 \uc2dc\uc791 \uac74\ub108\ub6f0\uae30\" \uc635\uc158 \ub54c\ubb38\uc785\ub2c8\ub2e4. \uc774\ub97c \ube44\ud65c\uc131\ud654\ud558\uace0 CurseForge \uc124\uc815\uc5d0\uc11c \"Mojang \ub7f0\ucc98\"\ub97c \uc0ac\uc6a9\ud558\uc138\uc694. Claws of Berk\uc758 \uc601\ubb38 \uc601\uc0c1(1\ubd84 11\ucd08 \ubd80\ubd84)\uc744 <a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>\uc5ec\uae30\uc11c</a> \ud655\uc778\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\uacbd\uace0: \ub204\ub77d\ub41c \ud074\ub798\uc2a4\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4(\uacbd\uace0 \uc218\uc900). \uc77c\ubc18\uc801\uc73c\ub85c \uad1c\ucc2e\uc9c0\ub9cc \ud56d\uc0c1 \uc548\uc804\ud55c \uac83\uc740 \uc544\ub2d9\ub2c8\ub2e4. \uce58\uba85\uc801\uc778 \ud074\ub798\uc2a4 \uc624\ub958\uc640\ub294 \ub2e4\ub985\ub2c8\ub2e4. \uc8fc\uc694 \uc6d0\uc778\uc73c\ub85c\ub294 \uc798\ubabb\ub41c CoreMod \ub610\ub294 \ub204\ub77d\ub41c \uc758\uc874\uc131 \ub4f1\uc774 \uc788\uc2b5\ub2c8\ub2e4. QuickFix\ub97c \uc0ac\uc6a9\ud558\uc5ec \ub204\ub77d\ub41c \ud074\ub798\uc2a4\uac00 \uc788\ub294 \ubaa8\ub4dc\ub97c \ud0d0\uc9c0\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uac10\uc9c0\ub41c \ub204\ub77d\ub41c \ud074\ub798\uc2a4:</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uacb0\uacfc \uc5c6\uc74c</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\ub85c\uadf8 \uc704\uce58:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\uc5ec\uae30\uc5d0 \ub2f9\uc2e0\uc758 \uac80\uc0ac \uacb0\uacfc\uac00 \uc788\uc2b5\ub2c8\ub2e4. \ucc9c\ucc9c\ud788 \uc9c4\ud589\ud558\uc138\uc694. \uc77c\ubc18\uc801\uc73c\ub85c \uc62c\ubc14\ub978 \uc6d0\uc778\uc740 \uac80\uc0ac 1 \ub610\ub294 2\uc5d0 \uc788\uc2b5\ub2c8\ub2e4. \ub098\uba38\uc9c0(\uc624\ub958 3 \uc774\uc0c1)\ub294 \ud655\uc778\uc6a9\uc73c\ub85c \uc0ac\uc6a9\ud560 \uc218 \uc788\uc9c0\ub9cc, \ub300\uac1c \uc5f0\uc1c4 \uc624\ub958\uc774\ubbc0\ub85c \ubb34\uc2dc\ud574\ub3c4 \ub429\ub2c8\ub2e4. \uc624\ub958\ub294 \uacc4\uce35\uc801\uc73c\ub85c \ubc1c\uc0dd\ud558\ubbc0\ub85c \ud575\uc2ec \ubb38\uc81c\ub97c \ud574\uacb0\ud558\uba74 \uc774 \ud2b9\uc815 \uc624\ub958\uac00 \ud574\uacb0\ub429\ub2c8\ub2e4. \ud558\uc9c0\ub9cc \ub0b4\uc77c \ud604\uc7ac \uc624\ub958\uc640 \uad00\ub828 \uc5c6\ub294 \uc0c8\ub85c\uc6b4 \uc624\ub958\uac00 \ub2e4\uc2dc \ub098\ud0c0\ub0a0 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc65c\ub0d0\ud558\uba74 \ud55c \uc624\ub958\uac00 \ub2e4\ub978 \uc624\ub958\uc758 \ucf58\uc194 \ud45c\uc2dc\ub97c \ub9c9\uc744 \uc218 \uc788\uae30 \ub54c\ubb38\uc785\ub2c8\ub2e4.</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>1.17-1.20.4 \ubc84\uc804\uc740 Java 17\uc744 \uc0ac\uc6a9\ud558\uace0, \uadf8 \uc774\uc0c1\uc758 \ubc84\uc804\uc740 Java 21\uc744 \uc0ac\uc6a9\ud558\uc138\uc694. \uc774\uc804 \ubc84\uc804\uc740 Java 8\uc744 \uc0ac\uc6a9\ud558\uc138\uc694. [\uac00\uc774\ub4dc](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). \uc5ec\uc804\ud788 \ubb38\uc81c\uac00 \uc788\ub2e4\uba74 \uc77c\ubd80 \ubaa8\ub4dc \ud30c\uc77c\uc774 \ub108\ubb34 \uc624\ub798\ub418\uc5c8\uac70\ub098 \ub108\ubb34 \ucd5c\uc2e0\uc77c \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 22 \uc774\uc0c1\uc740 ASM\uc774 \uc624\ub798\ub418\uc5b4 1.20.5 \ubbf8\ub9cc\uc758 Minecraft \ubc84\uc804\uc5d0\uc11c\ub294 \ub300\ubd80\ubd84\uc758 \ubaa8\ub4dc \ub85c\ub354\uc5d0\uc11c \uc791\ub3d9\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java\ub294 \uc624\ub798\ub418\uc5c8\uc2b5\ub2c8\ub2e4 </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JPMS \ubaa8\ub4c8 " + mod_necesitas + " \uc744(\ub97c) " + submod + " \uc5d0\uc11c \uac00\uc838\uc640\uc57c \ud569\ub2c8\ub2e4</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + metodo + "\uc744(\ub97c) \ud638\ucd9c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc774\uc720: " + objeto + "\uc774(\uac00) null\uc785\ub2c8\ub2e4</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "\uace0\uae09 \ubd84\uc11d";
    }

    @Override
    public String seleccionarCarpeta() {
        return "\ud3f4\ub354 \uc120\ud0dd";
    }

    @Override
    public String cadenaBusqueda() {
        return "\uac80\uc0c9 \ubb38\uc790\uc5f4";
    }

    @Override
    public String usarRegex() {
        return "\uc815\uaddc\uc2dd \uc0ac\uc6a9";
    }

    @Override
    public String ignorarMayusculas() {
        return "\ub300\uc18c\ubb38\uc790 \ubb34\uc2dc";
    }

    @Override
    public String buscar() {
        return "\uac80\uc0c9";
    }

    @Override
    public String busquedaEnProgreso() {
        return "\uac80\uc0c9 \uc9c4\ud589 \uc911";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "\uacb0\uacfc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String errorBusqueda() {
        return "\uac80\uc0c9 \uc624\ub958";
    }

    @Override
    public String omitirYCerrar() {
        return "\uac74\ub108\ub6f0\uace0 \ub2eb\uae30";
    }

    @Override
    public String guardarYCerrar() {
        return "\uc800\uc7a5\ud558\uace0 \ub2eb\uae30";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "\ub85c\uadf8\ub97c \uc5ec\uae30\uc5d0 \ubd99\uc5ec\ub123\uae30";
    }

    @Override
    public String archivo() {
        return "\ud30c\uc77c";
    }

    @Override
    public String incluir() {
        return "\ud3ec\ud568";
    }

    @Override
    public String abrir() {
        return "\uc5f4\uae30";
    }

    @Override
    public String endpointDeInforme() {
        return "\ubcf4\uace0\uc11c \uc5d4\ub4dc\ud3ec\uc778\ud2b8";
    }

    @Override
    public String sitoDeLogging() {
        return "\ub85c\uadf8 \uae30\ub85d \uc0ac\uc774\ud2b8:";
    }

    @Override
    public String apiDeLogging() {
        return "\ub85c\uadf8 API:";
    }

    @Override
    public String anonimizarRegistros() {
        return "\ub85c\uadf8 \uc775\uba85\ud654 (\ubca0\ud0c0)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "\ubcf4\uace0\uc11c \ubc0f \uc120\ud0dd\ud55c \ubaa8\ub4e0 \ub85c\uadf8 \uacf5\uc720";
    }

    @Override
    public String arco() {
        return "\uc774 \ub300\ud654\uc0c1\uc790\ub294 SecureLogger API\ub97c \uc0ac\uc6a9\ud558\uc5ec <a href=\"https://securelogger.net\">securelogger.net</a>\uc5d0 \ub85c\uadf8\ub97c \uacf5\uc720\ud560 \uc218 \uc788\uac8c \ud574\uc90d\ub2c8\ub2e4. \ubcf4\uace0\uc11c \uacf5\uc720 \ubc84\ud2bc\uc744 \ub204\ub974\uba74, \ubcf4\uace0\uc11c\uac00 \uc120\ud0dd\ub41c \uc5d4\ub4dc\ud3ec\uc778\ud2b8(asbestosstar.egoism.jp, \uae30\ubcf8\uac12)\ub85c \uc804\uc1a1\ub429\ub2c8\ub2e4(\ud558\ub2e8\uc5d0\uc11c \ubcc0\uacbd \uac00\ub2a5). \uc120\ud0dd\ud55c \ubaa8\ub4e0 \ub85c\uadf8\ub97c \ubcf4\uace0\uc11c\uc640 \ud568\uaed8 \uacf5\uc720\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc5c5\ub85c\ub4dc\ub97c \uc6d0\ud558\uc9c0 \uc54a\uc73c\uc2dc\uba74 \uc774 \ub300\ud654\uc0c1\uc790\ub97c \uc0ac\uc6a9\ud558\uc9c0 \ub9c8\uc2ed\uc2dc\uc624! \uacf5\uc2dd \uc5d4\ub4dc\ud3ec\uc778\ud2b8(<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>)\uc5d0\uc11c\ub294 \ubcf4\uace0\uc11c\ub97c \ucc98\ub9ac\ud558\uc9c0 \uc54a\uc73c\uba70, \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc740 \ub9c1\ud06c\ub9cc \uc81c\uac70\ud569\ub2c8\ub2e4. \uc18c\uc2a4 \ucf54\ub4dc\ub294 \uc5ec\uae30 \uc788\uc2b5\ub2c8\ub2e4: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">\uc18c\uc2a4 \ucf54\ub4dc</a>. \uc774\ub294 \ub2e8\uc9c0 \uc624\ub958 \uc815\ubcf4\uc640 \ub85c\uadf8 \ub9c1\ud06c\ub97c \ud45c\uc2dc\ud558\uae30 \uc704\ud55c \uac83\uc785\ub2c8\ub2e4. \uadf8\ub7ec\ub098 \ub3d9\uc77c\ud55c \ubc29\uc2dd\uc744 \ub530\ub974\uc9c0 \uc54a\uc744 \uc218 \uc788\ub294 \uc0ac\uc6a9\uc790 \uc815\uc758 \uc5d4\ub4dc\ud3ec\uc778\ud2b8\ub3c4 \uc0ac\uc6a9 \uac00\ub2a5\ud569\ub2c8\ub2e4. \ud604\uc7ac \ubcf4\uace0\uc11c \uc0ac\uc774\ud2b8\ub294 " + Config.obtenerInstancia().obtenerSitoDeInformes() + ", \ub85c\uadf8 \uc0ac\uc774\ud2b8\ub294 " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + "\ub97c \uc0ac\uc6a9 \uc911\uc785\ub2c8\ub2e4. \uac1c\ubcc4 \ub85c\uadf8 \uc774\ub984 \uc606\uc758 \uacf5\uc720 \ubc84\ud2bc\uc744 \ub20c\ub7ec \ubcf4\uace0\uc11c \uc5c6\uc774 \uac1c\ubcc4 \ub85c\uadf8\ub9cc \uacf5\uc720\ud560 \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4; \ub85c\uadf8\ub294 \uc120\ud0dd\ub41c \ub85c\uadf8 \uc0ac\uc774\ud2b8\ub85c \uc804\uc1a1\ub429\ub2c8\ub2e4. CrashDetector\ub294 \uae30\ubcf8\uc801\uc73c\ub85c \ub85c\uadf8 \uc775\uba85\ud654 \uae30\ub2a5\uc744 \uc81c\uacf5\ud558\uba70, \uc0ac\uc6a9\uc790 \uc774\ub984, UUID, \uc561\uc138\uc2a4 \ud1a0\ud070, \uc138\uc158 ID, IP \uc8fc\uc18c \ub4f1\uc744 \uc81c\uac70\ud558\ub824 \uc2dc\ub3c4\ud569\ub2c8\ub2e4. \uadf8\ub7ec\ub098 \uc644\ubcbd\ud558\uc9c0 \uc54a\uc73c\uba70, \ubaa8\ub4dc\ud329 \uc81c\uc791\uc790\uac00 \uc774\ub97c \ube44\ud65c\uc131\ud654\ud560 \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4. \uc774 \uae30\ub2a5\uc740 \ud654\uba74 \ud558\ub2e8\uc758 \uccb4\ud06c\ubc15\uc2a4\ub85c \ud65c\uc131\ud654/\ube44\ud65c\uc131\ud654\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uadc0\ud558\ub294 \uc790\uc2e0\uc758 \ub370\uc774\ud130\ub97c \ud1b5\uc81c\ud558\uba70, \uc5b4\ub514\uc5d0 \ub370\uc774\ud130\ub97c \uc5c5\ub85c\ub4dc\ud560\uc9c0 \uacb0\uc815\ud569\ub2c8\ub2e4. \ub85c\uadf8 \uc0ac\uc774\ud2b8\ub294 \uc18c\uc720\uad8c\uc774 \ud504\ub77c\uc774\ubc84\uc2dc\ub85c \uc778\ud574 \uc885\uc885 \uc228\uaca8\uc9c4 \uc81c3\uc790\uc758 \uc18c\uc720\uc785\ub2c8\ub2e4. \uadc0\ud558\ub294 \ub370\uc774\ud130 \uad00\ub9ac \ubc0f \uad00\ub828 \ub9ac\uc2a4\ud06c\uc5d0 \ub300\ud55c \ubaa8\ub4e0 \ucc45\uc784\uc744 \uc9d1\ub2c8\ub2e4. CrashDetector\uc758 \uacf5\uc720 \ub300\ud654\uc0c1\uc790\ub294 \uc774\ub97c \uad00\ub9ac\ud560 \uc218 \uc788\ub3c4\ub85d \ud558\ub294 \ub2e8\uc21c\ud55c \uc778\ud130\ud398\uc774\uc2a4\uc77c \ubfd0\uc785\ub2c8\ub2e4. GDPR \ubc0f ARCO\uc5d0 \ub300\ud574 \uc219\uc9c0\ud558\ub294 \uac83\uc774 \uc911\uc694\ud569\ub2c8\ub2e4. \uc720\ub7fd\uc5d0 \uacc4\uc2e0\ub2e4\uba74 Hetzner\uac00 \ub3c5\uc77c\uc5d0\uc11c \ud638\uc2a4\ud305\ud558\ub294 <a href=\"https://securelogger.top\">securelogger.top</a>\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \ubc95\uc801 \uc815\ubcf4\ub294 \ub2e4\uc74c \ub9c1\ud06c\ub97c \ucc38\uc870\ud558\uc138\uc694: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>, <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>, <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">\uc77c\ubcf8 \uac1c\uc778\uc815\ubcf4 \ubcf4\ud638 \uae30\ubcf8 \uc815\ucc45</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "\ubcf4\uace0\uc11c \ub9c1\ud06c:";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "\uacf5\uc720 \uc124\uc815 \uc800\uc7a5";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "\ub85c\uadf8\uac00 \uc774 \ub85c\uadf8 \uc0ac\uc774\ud2b8\uc5d0 \ub108\ubb34 \ud07d\ub2c8\ub2e4. \ub2e4\ub978 \uc0ac\uc774\ud2b8\ub97c \uc120\ud0dd\ud558\uace0 \ub2e4\uc2dc \uc2dc\ub3c4\ud558\uc2ed\uc2dc\uc624.";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "\ub85c\uadf8 \uac8c\uc2dc \uc911 \uc624\ub958 \ubc1c\uc0dd " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "\ub85c\uadf8 API\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc124\uc815\uc5d0\uc11c \ub85c\uadf8 API\ub97c \ubcc0\uacbd\ud558\uc2ed\uc2dc\uc624.";
    }

    @Override
    public String errorSSL() {
        return "SSL \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc774\ub294 \uad6c\ud615 Java \ubc84\uc804\uc5d0\uc11c \ud754\ud788 \ubc1c\uc0dd\ud558\uba70, \uae30\ubcf8 Minecraft \ub7f0\ucc98\uc758 Java 8 \ubc84\uc804 \ubc0f sun.com\uacfc java.com\uc758 \ubc84\uc804\uc5d0\ub3c4 \ud3ec\ud568\ub429\ub2c8\ub2e4. \uc774 \ubb38\uc81c\ub294 MinecraftForge \uc124\uce58 \ud504\ub85c\uadf8\ub7a8\uc758 JAR \ud30c\uc77c, \uae30\ubcf8 \uc5d4\ub4dc\ud3ec\uc778\ud2b8\ub97c \uc0ac\uc6a9\ud55c CrashDetector \ubcf4\uace0\uc11c \uacf5\uc720 \uae30\ub2a5, \uc778\ud130\ub137\uc774 \ud544\uc694\ud55c \uc77c\ubd80 \ubaa8\ub4dc \ubc0f \uc77c\ubd80 \ub85c\uadf8 \uc0ac\uc774\ud2b8\uc5d0 \uc601\ud5a5\uc744 \ubbf8\uce69\ub2c8\ub2e4. \ubcf4\uace0\uc11c\ub97c \uacf5\uc720\ud558\ub824 \ud560 \ub54c \uc774 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud558\uba74 \uc2a4\ud06c\ub9b0\uc0f7\uc744 \ucca8\ubd80\ud558\uace0 Java 8 \uc774\uc804 \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294 \ub85c\uadf8 \uc0ac\uc774\ud2b8\ub97c \uc120\ud0dd\ud558\uc138\uc694.";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud638\ud658\ub418\uc9c0 \uc54a\ub294 JavaFML \ubc84\uc804: \ud544\uc694\ud55c \ubc84\uc804\uc740 " + requerido + "\uc774\uc9c0\ub9cc \ubc1c\uacac\ub41c \ubc84\uc804\uc740 " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\uc8fc\uc758! JavaFML\uc740 \ud2b9\uc815 \ubc84\uc804\uc758 Minecraft Forge\ub97c \ud544\uc694\ub85c \ud569\ub2c8\ub2e4</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JAR \ud30c\uc77c '" + archivoJar + "'\uc740(\ub294) \uc5b8\uc5b4 \uacf5\uae09\uc790 '" + proveedor + "'\uc758 \ubc84\uc804 '" + requerido + "' \uc774\uc0c1\uc774 \ud544\uc694\ud558\uc9c0\ub9cc, \ubc1c\uacac\ub41c \ubc84\uc804\uc740 '" + encontrado + "'\uc785\ub2c8\ub2e4.</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uacbd\uace0! Crash Assistant\ub294 \uac00\uc9dc \uc545\uc131\ucf54\ub4dc \uac10\uc9c0\uae30\uc785\ub2c8\ub2e4. \uc774 \ud504\ub85c\uadf8\ub7a8\uc740 \uc758\ub3c4\uc801\uc73c\ub85c \uac8c\uc784 \uc2e4\ud589\uc744 \ucc28\ub2e8\ud558\uba70, \ud0c0\uac9f\ud305\ub41c \ubaa8\ub4dc\ub85c \uacc4\uc18d \ud50c\ub808\uc774\ud560 \uc790\uc720\ub97c \ubb34\uc2dc\ud569\ub2c8\ub2e4. <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>MalwareMod.java \ucf54\ub4dc \ubcf4\uae30</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>JarInJarHelper.java \ucf54\ub4dc \ubcf4\uae30</a>. \ud604\uc7ac \ub9ac\uc2a4\ud2b8\uc5d0\ub294 \uc774 \ubaa8\ub4dc\ub9cc \uc788\uc73c\uba70, \uc2e4\uc81c\ub85c\ub294 \uc0ac\uc6a9\uc790\uac00 \ubcc0\uacbd\ud560 \uc218 \uc788\ub294 \uae30\ubcf8 \ub85c\uadf8 \uc0ac\uc774\ud2b8\ub9cc\uc744 \ub300\uc0c1\uc73c\ub85c \ud569\ub2c8\ub2e4. \uc774 \uae30\ub2a5\uc740 \ub0b4\uc7a5\ub41c \ub85c\uadf8 \uacf5\uc720 \uae30\ub2a5\uc744 \uba85\uc2dc\uc801\uc73c\ub85c \uc120\ud0dd\ud55c \uacbd\uc6b0\uc5d0\ub9cc \uc791\ub3d9\ud569\ub2c8\ub2e4. CrashAssistant\ub294 \uc5b4\ub5a4 \ub85c\uadf8 \uc0ac\uc774\ud2b8\uac00 \uc124\uc815\ub418\uc5c8\ub294\uc9c0 \ud655\uc778\ud558\uc9c0 \uc54a\uc73c\uba70, \ubcc0\uacbd \ubc29\ubc95(\uacf5\uc720 \ub300\ud654 \uc0c1\uc790\uc758 \ud558\ub2e8\uc5d0 \ub4dc\ub86d\ub2e4\uc6b4 \uba54\ub274 \uc788\uc74c)\ub3c4 \uc124\uba85\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc124\uc815\ub41c \uc0ac\uc774\ud2b8\uc640 \uad00\uacc4\uc5c6\uc774 CrashAssistant\ub294 \uac8c\uc784 \uc2e4\ud589\uc744 \ucc28\ub2e8\ud569\ub2c8\ub2e4. \uadf8\ub4e4\uc758 \uba54\uc2dc\uc9c0\uc5d0\uc11c\ub294 \uc9c1\uc811 \uc870\uc0ac\ud558\ub77c\uace0 \ud558\uc9c0\ub9cc, \uc2e4\uc81c\ub85c \uadf8\ub807\uac8c \ud558\uc2ed\uc2dc\uc624. CrashDetector\uc640 Crash Assistant\uc758 \ucf54\ub4dc\ub97c \uc0b4\ud3b4\ubcf4\uace0 \ubb34\uc5c7\uc744 \ud558\ub294\uc9c0 \uc774\ud574\ud558\uc2ed\uc2dc\uc624. \uad8c\uc704\uc5d0 \ud638\uc18c\ud558\ub294 \uac83\uc5d0 \uc758\uc874\ud558\uc9c0 \ub9c8\uc2ed\uc2dc\uc624.</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubaa8\ub4dc '" + idMod + "'\uac00 \ud544\uc694\ud55c \ud074\ub798\uc2a4\ub97c \ucc3e\uc9c0 \ubabb\ud574 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: '" + claseNoEncontrada + "'. \ubaa8\ub4e0 \uc885\uc18d\uc131\uc774 \uc62c\ubc14\ub974\uac8c \uc124\uce58\ub418\uc5c8\ub294\uc9c0 \ud655\uc778\ud558\uc2ed\uc2dc\uc624.</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia\uac00 TLauncher\ub85c \ud50c\ub808\uc774\ud558\ub294 \uac83\uc744 \ucc28\ub2e8\ud588\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc0ac\uc6a9 \uc911\uc778 Optifine \ubc84\uc804\uc774 Minecraft\uc758 \uc624\ub798\ub41c \ubc84\uc804\uc6a9\uc785\ub2c8\ub2e4. \ud604\uc7ac \uc0ac\uc6a9 \uc911\uc778 Minecraft \ubc84\uc804\uc5d0 \ub9de\ub294 Optifine \ubc84\uc804\uc744 \uc0ac\uc6a9\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModLauncher \uc11c\ube44\uc2a4\ub97c \ub85c\ub4dc\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4: </b>" + servicio + ".";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JAR \ud30c\uc77c '" + archivoJar + "'\uc758 JSON \ud30c\uc77c '" + recurso + "'\uc744(\ub97c) \ubd84\uc11d\ud558\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub4f1\ub85d\uc5d0 \ubb38\uc81c\uac00 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc624\ub958: \ubaa8\ub4dc '" + modId + "'\ub294 '" + dependencia + "'\uc758 \ubc84\uc804 '" + requerido + "' \uc774\uc0c1\uc774 \ud544\uc694\ud558\uc9c0\ub9cc '" + actual + "'\uc774(\uac00) \ubc1c\uacac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ub2f9\uc2e0\uc758 GPU\ub294 \uc774 \uac8c\uc784 \ubc84\uc804\uc5d0\uc11c \uc694\uad6c\ud558\ub294 OpenGL \ubc84\uc804\uc744 \uc9c0\uc6d0\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ub4dc\ub77c\uc774\ubc84\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uadf8\ub798\ud53d \uce74\ub4dc\ub97c \ubcc0\uacbd\ud558\uc138\uc694.</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\uac8c\uc784\uc5d0 \ud560\ub2f9\ub41c \uba54\ubaa8\ub9ac\ub97c \ub298\ub9ac\uac70\ub098 \ubaa8\ub4dc/\ud50c\ub7ec\uadf8\uc778 \uc0ac\uc6a9\ub7c9\uc744 \uc904\uc774\uc138\uc694.</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>32\ube44\ud2b8 JVM\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4: 4GB \uc774\uc0c1\uc758 RAM\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \ubaa8\ub4e0 \uba54\ubaa8\ub9ac\ub97c \ud65c\uc6a9\ud558\ub824\uba74 64\ube44\ud2b8 JVM\uc744 \uc124\uce58\ud558\uc138\uc694.</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>PermGen \uba54\ubaa8\ub9ac\uc5d0 \uc2ec\uac01\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc601\uad6c \uba54\ubaa8\ub9ac \uacf5\uac04\uc744 \ub298\ub9ac\uac70\ub098 \ud074\ub798\uc2a4 \ub85c\ub4dc\ub97c \uc904\uc774\uc138\uc694.</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8\uacfc \ucd5c\uc2e0 \ubc84\uc804 \uac04\uc758 \ud638\ud658\uc131 \uc624\ub958</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+\ub294 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc74c - \uc774\uc804 Forge \ubc84\uc804\uc5d0\ub294 Java 8\uc744 \uc0ac\uc6a9\ud558\uc138\uc694</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8\uc774 \ud544\uc694\ud569\ub2c8\ub2e4 (\ubc84\uc804 52.0). \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uc62c\ubc14\ub974\uac8c \uc124\uc815\ud558\uc138\uc694</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801\uc778 \ud638\ud658\uc131 \uc624\ub958: \uc774 \ubc84\uc804\uc5d0\uc11c\ub294 \ube14\ub85d\uc774 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ubaa8\ub4dc \ubc0f \uc11c\ubc84 \ubc84\uc804\uc774 \ud638\ud658\ub418\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubaa8\ub2c8\ud130 \uc124\uc815 \uc624\ub958: \ud654\uba74 \ubaa8\ub4dc\ub97c \uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ud655\uc778\ud558\uc138\uc694:</b><br>- \ub2e4\uc911 \ubaa8\ub2c8\ud130 \uc124\uc815<br>- \ucd5c\uc2e0 \uadf8\ub798\ud53d \uce74\ub4dc \ub4dc\ub77c\uc774\ubc84<br>- \uc2dc\uc2a4\ud15c\uc5d0\uc11c \uc9c0\uc6d0\ud558\ub294 \ud574\uc0c1\ub3c4";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java \uc635\uc158 \uc624\ub958: \ucda9\ub3cc\ud558\ub294 \uac00\ube44\uc9c0 \uceec\ub809\ud130 \uc635\uc158\uc785\ub2c8\ub2e4. JVM \ub9e4\uac1c\ubcc0\uc218\uc5d0\uc11c \uc5ec\ub7ec GC \uc54c\uace0\ub9ac\uc998\uc744 \uacb0\ud569\ud558\uc9c0 \uc54a\uc558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>NightConfig/Forge \uad6c\uc131 \uce58\uba85\uc801 \uc624\ub958: \uad6c\uc131 \ud30c\uc77c\uc774 \uc190\uc0c1\ub418\uc5c8\uac70\ub098 \ubd88\uc644\uc804\ud569\ub2c8\ub2e4. \uc774\ub294 'config' \ud3f4\ub354\uc5d0 \uc788\ub294 \ube48 \uad6c\uc131 \ud30c\uc77c(\uc885\uc885 0\ubc14\uc774\ud2b8)\ub85c \uc778\ud574 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc73c\uba70, \uc774\ub294 \uc774\uc804 \ubc84\uc804\uc774\ub098 \uc0ac\uc6a9\uc790 \uc815\uc758 NightConfig\uc5d0\uc11c \ud754\ud569\ub2c8\ub2e4. \ub300\ubd80\ubd84\uc758 \ubc84\uc804\uc5d0\uc11c\ub294 Night Config Fixes\uac00 \ubb38\uc81c\ub97c \ud574\uacb0\ud558\uc9c0\ub9cc, \ud638\ud658\ub418\uc9c0 \uc54a\uac70\ub098 \uc0ac\uc6a9\uc790 \uc815\uc758 NightConfig\ub97c \uc0ac\uc6a9 \uc911\uc774\ub77c\uba74 \uad6c\uc131 \ud30c\uc77c\uc744 \uc218\ub3d9\uc73c\ub85c \uc0ad\uc81c\ud574\uc57c \ud569\ub2c8\ub2e4. \uc774 \ubb38\uc81c\ub294 NightConfig\uac00 \ud3ec\ud568\ub41c \uc774\uc804 MC Forge \ubc84\uc804\uacfc NightConfig\ub97c \ubc88\ub4e4\ub85c \uc81c\uacf5\ud558\ub294 \uad6c\ud615 FabricMC \ubaa8\ub4dc\uc5d0\uc11c \ub354 \ud754\ud558\uc9c0\ub9cc, \uc77c\ubd80 \uc0ac\uc6a9\uc790 \uc815\uc758 NightConfig \ubc84\uc804\uc5d0\uc11c\ub3c4 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \ud574\uacb0 \ubc29\ubc95\uc5d0 \ub300\ud55c \uc790\uc138\ud55c \ub0b4\uc6a9\uc740 <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a>\uc5d0\uc11c \ud655\uc778\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Intel HD Graphics \ub4dc\ub77c\uc774\ubc84 \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ud574\uacb0\ucc45:</b><br>1. <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a>\uc5d0\uc11c Intel \ub4dc\ub77c\uc774\ubc84\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694 (\ucd5c\uc18c \ubc84\uc804 15.xx.xx.xx)<br>2. Minecraft\uc5d0\uc11c: \uc635\uc158 \u2192 \ube44\ub514\uc624 \u2192 'Enable VBOs' \ubc0f 'VSync' \ud65c\uc131\ud654<br>3. \ub7f0\ucc98\uc5d0\uc11c \uac8c\uc784\uc5d0 1GB-2GB\uc758 RAM \ud560\ub2f9<br>4. \uc5c5\ub370\uc774\ud2b8 \uc911 \ubc29\ud654\ubcbd/\uc548\ud2f0\ubc14\uc774\ub7ec\uc2a4\ub97c \uc77c\uc2dc\uc801\uc73c\ub85c \ube44\ud65c\uc131\ud654";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "\uacbd\uace0: \ub204\ub77d\ub41c \ud074\ub798\uc2a4\uac00 \uac10\uc9c0\ub428";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "\ube14\ub85d \ub80c\ub354\ub9c1 \uc624\ub958";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "\uc2a4\ud0dd \ud2b8\ub808\uc774\uc2a4 \ubd84\uc11d";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "\ubd88\uc644\uc804\ud55c CurseForge \ucf58\uc194";
    }

    @Override
    public String nombre_de_early_window() {
        return "\ucd08\uae30 \uc708\ub3c4\uc6b0 \uc624\ub958 (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "\ube44\ub514\uc624 \ub4dc\ub77c\uc774\ubc84 \ubb38\uc81c";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "MCForge \uad6c\uc131 \uc190\uc0c1";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "\ub514\uc2a4\ud50c\ub808\uc774 \ubaa8\ub4dc \uc2e4\ud328 (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "FabricMC \ucd08\uae30\ud654 \uc624\ub958";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "\ub204\ub77d\ub41c JPMS \ubaa8\ub4c8";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "\uce58\uba85\uc801\uc778 \ub204\ub77d \ud074\ub798\uc2a4";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "ModLauncher \uc758\uc874\uc131 \ub204\ub77d";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "\ud638\ud658\ub418\uc9c0 \uc54a\ub294 Java \ubc84\uc804";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "KubeJS \ub9ac\uc18c\uc2a4 \uc624\ub958";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "\ud638\ud658\ub418\uc9c0 \uc54a\ub294 \uc5b8\uc5b4 \uc81c\uacf5\uc790";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "\uc870\uc120\ubbfc\uc8fc\uc8fc\uc758\uc778\ubbfc\uacf5\ud654\uad6d(Litchhost) \uad00\ub828 \uc624\ub958";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "\uac70\uc9d3 \uc545\uc131 \uc18c\ud504\ud2b8\uc6e8\uc5b4 \ud0d0\uc9c0";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "\uc758\uc2ec\uc2a4\ub7ec\uc6b4 \ubaa8\ub4dc \uac10\uc9c0\ub428";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "ModLauncher\uc5d0\uc11c \uc911\ubcf5\ub41c \ubaa8\ub4dc";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "JPMS \ubaa8\ub4c8 \ucda9\ub3cc";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "Iris\ub97c \uc704\ud574 Sodium\uc774 \ud544\uc694\ud568";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "JSON \ub4f1\ub85d \uc815\ubcf4\ub97c \ubd84\uc11d\ud560 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "\uba54\ubaa8\ub9ac \ubd80\uc871";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "\ub110 \ud3ec\uc778\ud130 \uc624\ub958 (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "\uc798\ubabb\ub41c Java GC \uc635\uc158";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "\uc624\ub798\ub41c/\ud638\ud658\ub418\uc9c0 \uc54a\ub294 OptiFine";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "\uc704\ud5d8\ud55c \uc11c\ubc84 \ud2f1 (60\ucd08)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "ModLauncher \uc11c\ube44\uc2a4 \uc2e4\ud328";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "\ubb38\uc81c\uac00 \uc788\ub294 SpongeMixing \uad6c\uc131";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus \ud638\ud658\ub418\uc9c0 \uc54a\uc74c";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "TLauncher\ub294 WATERMeDIA\uc5d0\uc11c \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc74c";
    }

    @Override
    public String auditorias_transformer() {
        return "\ud2b8\ub79c\uc2a4\ud3ec\uba38 \uac10\uc0ac";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc774\uac83\uc740 \ubc14\ub2d0\ub77c \ub7f0\ucc98\uc5d0\uc11c \ud2b8\ub79c\uc2a4\ud3ec\uba38 \uac10\uc0ac \ub0b4\uc6a9\uc758 \uacb0\uacfc\uc785\ub2c8\ub2e4. \uc77c\ubc18\uc801\uc73c\ub85c StackTrace \ubd84\uc11d\uae30\ubcf4\ub2e4 \ub35c \uc815\ud655\ud558\uc9c0\ub9cc, \ubc14\ub2d0\ub77c \ub7f0\ucc98\uc5d0\ub294 \ud56d\uc0c1 {}\uc758 \ub0b4\uc6a9\uc774 \uc788\ub294 \uac83\uc740 \uc544\ub2d9\ub2c8\ub2e4</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "\uc774 \uae30\ub2a5\uc740 MCreator\ub85c \ub9cc\ub4e0 \ubaa8\ub4dc\ub97c \uac80\uc0c9\ud569\ub2c8\ub2e4. \ub300\ubd80\ubd84\uc758 MCreator \ubaa8\ub4dc\ub294 \uad1c\ucc2e\uace0 \ud6cc\ub96d\ud55c \ubaa8\ub4dc\ub3c4 \ub9ce\uc9c0\ub9cc, \ub54c\ub85c\ub294 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud558\uace0 \ub098\uc05c \ud3c9\ud310\uc744 \uac00\uc9c8 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc774\ub97c \ud1b5\ud574 \ud574\ub2f9 \ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \ucc38\uace0\ub85c \ub9e4\uc6b0 \ub192\uc740 \ud3c9\uac00\ub97c \ubc1b\uc740 \ubaa8\ub4dc\ub77c\ub3c4 \ubc18\ub4dc\uc2dc MCreator\ub85c \uc81c\uc791\ub41c \uac83\uc740 \uc544\ub2d0 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc608\ub97c \ub4e4\uc5b4 MCreator\uc640\uc758 \ud1b5\ud569\uc744 \ud3ec\ud568\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String escanear() {
        return "\uac80\uc0ac";
    }

    @Override
    public String cargando() {
        return "\ub85c\ub529 \uc911";
    }

    @Override
    public String codigo() {
        return "ko";
    }

    @Override
    public String inicioApp() {
        return "\uac8c\uc784/\uc571 \uc2dc\uc791";
    }

    @Override
    public String ajustesCrashDetector() {
        return "\ud06c\ub798\uc2dc \uac10\uc9c0\uae30 \uc124\uc815";
    }

    @Override
    public String confidencialidad() {
        return "\uac1c\uc778\uc815\ubcf4 \ubcf4\ud638";
    }

    @Override
    public String tooltip() {
        return "\ud234\ud301";
    }

    @Override
    public String config() {
        return "\uc124\uc815";
    }

    @Override
    public String abrirCarpeta() {
        return "\ud3f4\ub354 \uc5f4\uae30";
    }

    @Override
    public String actualizar() {
        return "\uc5c5\ub370\uc774\ud2b8";
    }

    @Override
    public String anadirRegistro() {
        return "\ub85c\uadf8 \ucd94\uac00";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "\uc2dc\uc2a4\ud15c \uc5b8\uc5b4 \uc0ac\uc6a9";
    }

    @Override
    public String volver() {
        return "\ub4a4\ub85c";
    }

    @Override
    public String colorFondo() {
        return "\ubc30\uacbd\uc0c9 (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "\ud14d\uc2a4\ud2b8 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "\ubc84\ud2bc \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "\ud14d\uc2a4\ud2b8 \uc0c1\uc790 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "\ub9c1\ud06c \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "\ucf58\uc194 \uc81c\ubaa9 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "\uc624\ub958 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "\uacbd\uace0 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "\uc815\ubcf4 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "\uc81c\ubaa9 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "\ub9c1\ud06c \ud14d\uc2a4\ud2b8 \uc0c9\uc0c1 (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "\uc624\ub958 \ubc1c\uc0dd \uc2dc\uc5d0\ub9cc CrashDetector \uc5f4\uae30";
    }

    @Override
    public String activar_parche() {
        return "\ud328\uce58 \ud65c\uc131\ud654";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "\uc0ac\uc6a9 \uac00\ub2a5\ud55c \uc194\ub8e8\uc158\uc774 \uc5c6\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String error() {
        return "\uc624\ub958";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "Jar \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar\uc774 \uc131\uacf5\uc801\uc73c\ub85c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String exito() {
        return "\uc131\uacf5";
    }

    @Override
    public String eliminar() {
        return "\uc0ad\uc81c";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "\ud328\ud0a4\uc9c0 \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "\ud328\ud0a4\uc9c0\uac00 \uc131\uacf5\uc801\uc73c\ub85c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String eliminar_paquete() {
        return "\ud328\ud0a4\uc9c0 \uc0ad\uc81c";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "\ud328\ud0a4\uc9c0\uac00 \ud3ec\ud568\ub41c \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "\ud328\ud0a4\uc9c0\ub97c \uc0ad\uc81c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String eliminar_jar() {
        return "Jar \uc0ad\uc81c";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "\uc911\ubcf5\ub41c \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String archivo_no_encontrado() {
        return "\ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String directorio_eliminado() {
        return "\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c\ub428";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "\uc911\ucca9\ub41c Jar \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "\ub0b4\ubd80 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String archivo_eliminado() {
        return "\ud30c\uc77c \uc0ad\uc81c\ub428";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "\ud30c\uc77c \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc678\ubd80 \ud30c\uc77c";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "\ubaa8\ub4dc \uc694\uc18c \uc0ad\uc81c\ub428";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "\uc678\ubd80 Jar \uad50\uccb4 \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "\ubaa8\ub4dc \uc694\uc18c \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "\uc911\ucca9\ub41c Jar\uc5d0 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud615\uc2dd";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "\uc911\ucca9\ub41c Jar \uc0ad\uc81c\ub428";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "\uc784\uc2dc \ud30c\uc77c \uc815\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801 \ud2b8\ub808\uc774\uc2a4 \uba54\uc2dc\uc9c0 \ub9c8\uc9c0\ub9c9 (\ubc88\uc5ed\ub418\uc9c0 \uc54a\uc74c):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud2b8\ub808\uc774\uc2a4 \uba54\uc2dc\uc9c0 \ub9c8\uc9c0\ub9c9 (\ubc88\uc5ed\ub418\uc9c0 \uc54a\uc74c):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "WaifuNeoForge \ub370\uc774\ud130\ubca0\uc774\uc2a4\uc5d0\uc11c \ubaa8\ub4dc\ub97c \uac80\uc0c9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uac8c\uc784 \ubc84\uc804, \ubaa8\ub4dc \ub85c\ub354 \ubc0f \ud074\ub798\uc2a4\ub97c \uc120\ud0dd\ud558\uc138\uc694. \uac00\uc7a5 \uc720\uc0ac\ud55c \uc870\ud569\uc744 \uc0ac\uc6a9\ud558\uc138\uc694. 1\ubd84\uc5d0 \ud55c \ubc88\ub9cc \uac80\uc0c9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String solucionFaltasClases() {
        return "WaifuNeoForge \ub370\uc774\ud130\ubca0\uc774\uc2a4\uc5d0\uc11c \ubaa8\ub4dc\ub97c \uac80\uc0c9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uac8c\uc784 \ubc84\uc804, \ubaa8\ub4dc \ub85c\ub354 \ubc0f \ud074\ub798\uc2a4\ub97c \uc120\ud0dd\ud558\uc138\uc694. \uac00\uc7a5 \uc720\uc0ac\ud55c \uc870\ud569\uc744 \uc0ac\uc6a9\ud558\uc138\uc694. 1\ubd84\uc5d0 \ud55c \ubc88\ub9cc \uac80\uc0c9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "\ub450 \ub7f0\ucc98 \ubaa8\ub450 \uc62c\ubc14\ub978 Java \ubc84\uc804\uc744 \uac00\uc9c0\uace0 \uc788\uc9c0\ub9cc \ubaa8\ub4e0 \ubc84\uc804\uc774 \uc788\ub294 \uac83\uc740 \uc544\ub2d9\ub2c8\ub2e4. \uc2dc\uc2a4\ud15c\uc758 \ud328\ud0a4\uc9c0 \uad00\ub9ac\uc790\ub098 \ubc84\ud2bc\uc744 \uc0ac\uc6a9\ud558\uc5ec \uc62c\ubc14\ub978 Java \ubc84\uc804\uc744 \uc124\uce58\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc560\ub2c8\uba54\uc774\uc158\uc774 \uc5c6\ub294 \ubaa8\ub4dc: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException(\uc694\uc18c \uc5c6\uc74c \uc608\uc678) \uc560\ub2c8\uba54\uc774\uc158 \ubd80\uc7ac";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "\uc0ad\uc81c\ud560 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "\uc0c1\ucda9\ub418\ub294 GC \uc635\uc158\uc744 -XX:+UseG1GC\ub85c \uad50\uccb4\ud558\uae30";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "-Xmx \uc635\uc158\uc744 \uc0ac\uc6a9\ud558\uc5ec \ud799 \uba54\ubaa8\ub9ac \ud06c\uae30 \uc99d\uac00\uc2dc\ud0a4\uae30.";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "-XX:MaxPermSize \uc635\uc158\uc744 \uc0ac\uc6a9\ud558\uc5ec \uc601\uad6c \uc0dd\uc131 \uc601\uc5ed \uba54\ubaa8\ub9ac \ud06c\uae30 \uc99d\uac00\uc2dc\ud0a4\uae30.";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "\uc0ac\uc6a9 \uac00\ub2a5\ud55c \uba54\ubaa8\ub9ac\ub97c \ub298\ub9ac\uae30 \uc704\ud574 64\ube44\ud2b8 JVM \uc0ac\uc6a9\ud558\uae30.";
    }

    @Override
    public String optimizarCodigo() {
        return "\uba54\ubaa8\ub9ac \uc0ac\uc6a9\ub7c9\uc744 \uc904\uc774\uace0 \uc131\ub2a5\uc744 \uac1c\uc120\ud558\uae30 \uc704\ud574 \ucf54\ub4dc \ucd5c\uc801\ud654\ud558\uae30.";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "\uc560\ud50c\ub9ac\ucf00\uc774\uc158\uc758 \uc77c\uc2dc \uc911\uc9c0\ub97c \uc904\uc774\uae30 \uc704\ud574 \ud6a8\uc728\uc801\uc778 \uac00\ube44\uc9c0 \uceec\ub809\ud130 \uc0ac\uc6a9\ud558\uae30.";
    }

    @Override
    public String modulos() {
        return "\ubaa8\ub4c8\ub4e4";
    }

    @Override
    public String paquete() {
        return "\ud328\ud0a4\uc9c0";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "ID\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ud754\ud55c \uc6d0\uc778\uc73c\ub85c\ub294 \ub204\ub77d\ub41c \ubaa8\ub4dc\ub098 \uc544\uc774\ud15c \ub370\uc774\ud130 \ubd80\uc871\uc774 \uc788\uc2b5\ub2c8\ub2e4. \uc77c\ubc18\uc801\uc778 \ub370\uc774\ud130 \ud3f4\ub354\ub294 datafiedcontents/\uc640 kubejs/ \ub610\ub294 \ub2e4\ub978 \ubaa8\ub4dc \ud3f4\ub354\uc785\ub2c8\ub2e4.";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "\uc798\ubabb \ub9e4\ud551\ub41c \uae30\ub85d\ub4e4";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud50c\ub7ec\uadf8\uc778 'AuthMe'\uc758 \ub85c\ub4dc \uc2e4\ud328\ub85c \uc778\ud574 \uc11c\ubc84\uac00 \uc885\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "AuthMe\ub85c \uc778\ud55c \uc885\ub8cc \ubb38\uc81c";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "'stopServer' \uaddc\uce59\uc774 'true'\ub85c \ubcc0\uacbd\ub428.";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "\ud50c\ub7ec\uadf8\uc778 AuthMe \uc124\uc815 (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "'AuthMe' \ud50c\ub7ec\uadf8\uc778\uc758 \ub2e4\ub978 \ubc84\uc804 \uc124\uce58";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "\ud50c\ub7ec\uadf8\uc778 'AuthMe' \uc81c\uac70";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc138\uacc4 '" + nombreMundo + "'\uc740(\ub294) \uc624\ub958\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uace0 \uc190\uc0c1\ub418\uc5c8\uc744 \uac00\ub2a5\uc131\uc774 \uc788\uc5b4 \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "Multiverse \uc138\uacc4 \ub85c\ub4dc \ubb38\uc81c";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "'" + nombreMundo + "' \uc138\uacc4\ub97c \ubcf5\uad6c\ud558\uc138\uc694. \uc608: Minecraft Region Fixer \ub610\ub294 MCEdit \uc0ac\uc6a9.";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "'" + nombreMundo + "' \uc138\uacc4 \ud3f4\ub354 \uc0ad\uc81c.";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud655\uc7a5\uae30\ub2a5 'PermissionsEx'\uc758 \uc124\uc815\uc774 \uc798\ubabb\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "PermissionsEx \uc124\uc815 \ubb38\uc81c";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "PermissionsEx \ud50c\ub7ec\uadf8\uc778 \uc124\uc815 (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "\ud50c\ub7ec\uadf8\uc778 'PermissionsEx' \uc0ad\uc81c";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ub3d9\uc77c\ud55c \uc774\ub984 '" + nombrePlugin + "'\uc744 \uac00\uc9c4 \ud50c\ub7ec\uadf8\uc778 \ud30c\uc77c\uc774 \uc5ec\ub7ec \uac1c \uc788\uc2b5\ub2c8\ub2e4: '" + primerPath + "' \ubc0f '" + segundoPath + "'.</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "\ubaa8\ud638\ud55c \ud50c\ub7ec\uadf8\uc778 \uc774\ub984 \ubb38\uc81c";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "'" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778 \uc81c\uac70";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc6d4\ub4dc\uac00 \uccad\ud06c\ub97c \ub85c\ub4dc\ud558\ub294 \ub3c4\uc911 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uadc0\ud558\uc758 \ud50c\ub7ab\ud3fc\uc6a9\uc73c\ub85c \uc874\uc7ac\ud55c\ub2e4\uba74, FeatureRecycler\uac00 \ubb38\uc81c\ub97c \ud574\uacb0\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "\uccad\ud06c \ub85c\ub529 \uc624\ub958";
    }

    @Override
    public String solucionEliminarChunk() {
        return "MCEdit \uc0ac\uc6a9 \ub610\ub294 \uc9c0\uc5ed \ud30c\uc77c \uc0ad\uc81c\ub97c \ud1b5\ud574 \ubb38\uc81c\uac00 \uc788\ub294 \uccad\ud06c\ub97c \uc81c\uac70\ud558\uc2ed\uc2dc\uc624.";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>/" + comando + "' \uba85\ub839\uc744 \uc2e4\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ud50c\ub7ec\uadf8\uc778: '" + nombrePlugin + "'</b>";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "\ud50c\ub7ec\uadf8\uc778 \uba85\ub839 \uc2e4\ud589 \uc624\ub958";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "'" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778\uc758 \ub2e4\ub978 \ubc84\uc804 \uc124\uce58";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778\uc740 '" + dependencia + "' \uc758\uc874\uc131\uc744 \ud544\uc694\ub85c \ud569\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778\uc740 \ub2e4\uc74c \uc758\uc874\uc131\uc774 \ubd80\uc871\ud569\ub2c8\ub2e4: " + deps.toString() + ".</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "\ubd80\uc871\ud55c \ud50c\ub7ec\uadf8\uc778 \uc758\uc874\uc131";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "'" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778 \uc124\uce58";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778\uc740 \uc11c\ubc84\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 API \ubc84\uc804 '" + versionAPI + "'\uc744(\ub97c) \ud544\uc694\ub85c \ud569\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "\ud638\ud658\ub418\uc9c0 \uc54a\ub294 API \ubc84\uc804";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "\uc11c\ubc84 \uc18c\ud504\ud2b8\uc6e8\uc5b4\uc758 '" + version + "' \ubc84\uc804\uc744 \uc124\uce58\ud558\uc138\uc694.";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMundo + "' \uc138\uacc4\ub294 \ub2e4\ub978 \uc138\uacc4\uc640 \uc911\ubcf5\ub418\uc5b4 \ubd88\ub7ec\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "\uc911\ubcf5\ub41c \uc138\uacc4";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "'" + nombreMundo + "' \uc138\uacc4\uc5d0\uc11c 'uid.dat' \ud30c\uc77c \uc0ad\uc81c";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "'" + nombreMundo + "' \uc138\uacc4 \ud3f4\ub354 \uc0ad\uc81c";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + coords + " \uc704\uce58\uc758 \ube14\ub85d \uc5d4\ud2f0\ud2f0 '" + nombre + "'(\uc720\ud615: '" + tipo + "')\uac00 \ud2f1 \uc911\uc5d0 \uc624\ub958\ub97c \uc77c\uc73c\ud0a4\uace0 \uc788\uc2b5\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "\ubb38\uc81c \uc788\ub294 \ube14\ub85d \uc5d4\ud2f0\ud2f0";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "'" + coords + " \uc704\uce58\uc758 '" + nombre + "' \uc5d4\ud2f0\ud2f0\ub97c MCEdit \ub610\ub294 \uc9c1\uc811 \ud3b8\uc9d1\ud558\uc5ec \uc0ad\uc81c\ud558\uc2ed\uc2dc\uc624.";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubaa8\ub4dc '" + nombreMod + "'\uc774(\uac00) \uc5ec\ub7ec \ubc84\uc804 \uc124\uce58\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "Fabric\uc5d0\uc11c \uc911\ubcf5\ub41c \ubaa8\ub4dc";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "\uc911\ubcf5\ub41c \ubaa8\ub4dc \ud30c\uc77c \uc0ad\uc81c: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubaa8\ub4dc '" + primerMod + "'\uacfc(\uc640) '" + segundoMod + "'\uc740(\ub294) \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "Fabric\uc5d0\uc11c \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubaa8\ub4dc";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "'" + nombreMod + "' \ubaa8\ub4dc \uc0ad\uc81c";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubaa8\ub4dc '" + nombreMod + "'\uc5d0 \uce58\uba85\uc801\uc778 \uc624\ub958\uac00 \uc788\uc5b4 \uc2e4\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "\uce58\uba85\uc801 \uc624\ub958\ub97c \uac00\uc9c4 \ubaa8\ub4dc";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ub2e4\uc74c \ubaa8\ub4dc\ub4e4\uc774 \ud544\uc694\ud558\uc9c0\ub9cc \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4: " + deps.toString() + ".</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + "' \ubaa8\ub4dc\ub294 '" + dependencia + "' \ubaa8\ub4dc \uc758\uc874\uc131\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + "' \ubaa8\ub4dc\ub294 '" + dependencia + "' \ubaa8\ub4dc\uc758 \ubc84\uc804 " + version + "\uc774(\uac00) \ud544\uc694\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "\ubd80\uc871\ud55c \ubaa8\ub4dc \uc758\uc874\uc131";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "'" + nombreMod + "' \ubaa8\ub4dc\ub97c \uc124\uce58\ud558\uc138\uc694";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "'" + nombreMod + "' \ubaa8\ub4dc\uc758 \ubc84\uc804 " + version + "\uc744(\ub97c) \uc124\uce58\ud558\uc138\uc694";
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778\uc740 Folia\uc758 \uc9c0\uc5ed \ud2f1\ud0b9\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub2e4\uc74c \ud50c\ub7ec\uadf8\uc778\ub4e4\uc740 Folia\uc758 \uc9c0\uc5ed \ud2f1\ud0b9\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "\uc9c0\uc5ed \ud2f1\ud0b9\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ud50c\ub7ec\uadf8\uc778";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "\uc9c0\uc5ed \ud2f1\ud0b9\uc774 \uc5c6\ub294 \ubc84\uc804\uc744 \uc124\uce58\ud558\uc138\uc694. \uc608: " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>/" + nombreMod + "' \ubaa8\ub4dc\uac00 \ub370\uc774\ud130\ud329\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub370\uc774\ud130\ud329\uc5d0\uc11c \ub2e4\uc74c \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \ubc0f ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "\ub370\uc774\ud130\ud329\uc5d0 \ubaa8\ub4dc\uac00 \uc5c6\uc74c";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + " \ubaa8\ub4dc\uc5d0\uc11c \uc624\ub958 \ubc1c\uc0dd</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub2e4\uc74c \ubaa8\ub4dc\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \ubc0f ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "Forge \ubaa8\ub4dc\uc5d0 \uc608\uc678 \ubc1c\uc0dd";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "'" + nombreMod + "' \ubaa8\ub4dc\uc758 \ub2e4\ub978 \ubc84\uc804 \uc124\uce58";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + "' \ubaa8\ub4dc\ub294 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 " + versionMC + "\uacfc(\uc640) \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub2e4\uc74c \ubaa8\ub4dc\ub294 \ud574\ub2f9 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc74c: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (\ub9c8\uc778\ud06c\ub798\ud504\ud2b8 ").append(versionesMC.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "\ub9c8\uc778\ud06c\ub798\ud504\ud2b8\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubaa8\ub4dc";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "Minecraft " + versionMC + "\uacfc(\uc640) \ud638\ud658\ub418\ub294 Forge \ubc84\uc804\uc744 \uc124\uce58\ud558\uc2ed\uc2dc\uc624.";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + " \ubaa8\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uc138\uacc4 \ub610\ub294 \ud50c\ub7ec\uadf8\uc778 \ub85c\ub4dc\uc5d0 \ud544\uc694\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "\ubd80\uc871\ud55c \ubaa8\ub4dc";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc138\uacc4\ub97c \uc800\uc7a5\ud560 \ub54c '" + nombreMod + "' \ubaa8\ub4dc\uac00 \uc0ac\uc6a9\ub418\uc5c8\uc73c\ub098, \uc9c0\uae08\uc740 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\uc138\uacc4\ub97c \uc800\uc7a5\ud560 \ub54c \ub2e4\uc74c \ubaa8\ub4dc\ub4e4\uc774 \uc0ac\uc6a9\ub418\uc5c8\uc73c\ub098, \uc9c0\uae08\uc740 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \ubc0f ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "\uc138\uacc4\uc5d0\uc11c \ubd80\uc871\ud55c \ubaa8\ub4dc";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + "' \ubaa8\ub4dc\uac00 \ubc84\uc804 " + versionEsperada + "\uc73c\ub85c \uc800\uc7a5\ub418\uc5c8\uc73c\ub098 \ud604\uc7ac \uc2e4\ud589 \uc911\uc778 \ubc84\uc804\uc740 " + versionActual + "\uc785\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub2e4\uc74c \ubaa8\ub4dc\ub4e4\uc740 \uc800\uc7a5\ub41c \uc138\uacc4\uc640 \ubc84\uc804\uc774 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \ubc0f ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (\uc800\uc7a5\ub428: ").append(versionesEsperadas.get(i)).append(", \ud604\uc7ac: ").append(versionesActuales.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "\uc800\uc7a5\ub41c \uc138\uacc4\uc758 \ubaa8\ub4dc \ubc84\uc804 \ubd88\uc77c\uce58";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ub354 \ucd5c\uc2e0 \ubc84\uc804\uc758 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\ub85c \uc0dd\uc131\ub41c \uc138\uacc4\ub97c \ub85c\ub4dc\ud558\ub824\uace0 \ud588\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "\ub354 \ucd5c\uc2e0 \ubc84\uc804\uc758 \uc138\uacc4\ub97c \ub85c\ub4dc\ud558\ub824\ub294 \uc2dc\ub3c4";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "\ub354 \ucd5c\uc2e0 \ubc84\uc804\uc758 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\ub97c \uc124\uce58\ud558\uc138\uc694.";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "\uc0c8\ub85c\uc6b4 \uc138\uacc4\ub97c \uc0dd\uc131\ud558\uc138\uc694.";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778\uc740 '" + dependencia + "' \ud50c\ub7ec\uadf8\uc778 \uc758\uc874\uc131\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub2e4\uc74c \ud50c\ub7ec\uadf8\uc778\ub4e4\uc740 \uc124\uce58\ub418\uc9c0 \uc54a\uc740 \uc758\uc874\uc131\ub4e4\uc774 \uc788\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("' (").append(dependencias.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "\ubd80\uc871\ud55c \ud50c\ub7ec\uadf8\uc778 \uc758\uc874\uc131";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombrePlugin + "' \ud50c\ub7ec\uadf8\uc778\uc740 \uc11c\ubc84\uc758 \ud604\uc7ac \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub2e4\uc74c \ud50c\ub7ec\uadf8\uc778\ub4e4\uc740 \uc11c\ubc84\uc758 \ud604\uc7ac \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \ubc0f ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "\ud50c\ub7ec\uadf8\uc778\uc774 PocketMine-MP\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\uc74c";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombrePlugin + " \ud50c\ub7ec\uadf8\uc778 \uc2e4\ud589 \ub3c4\uc911 \uc624\ub958 \ubc1c\uc0dd</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub2e4\uc74c \ud50c\ub7ec\uadf8\uc778\ub4e4\uc774 \uc2e4\ud589 \uc911\uc5d0 \uc624\ub958\ub97c \ubc1c\uc0dd\uc2dc\ucf30\uc2b5\ub2c8\ub2e4: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \ubc0f ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "\uc2e4\ud589 \uc624\ub958\uac00 \uc788\ub294 \ud50c\ub7ec\uadf8\uc778";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "\uc5ec\ub7ec \uc2a4\ub808\ub4dc \uc0ac\uc6a9\ud558\ub294 LegacyRandomSource";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc5ec\ub7ec \uc2a4\ub808\ub4dc\uac00 LegacyRandomSource \ud074\ub798\uc2a4\uc5d0 \uc811\uadfc\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. 'Unsafe World Random Access Detector' \ub610\ub294 'C2ME' \ubaa8\ub4dc\ub85c \uc790\uc138\ud55c \uc815\ubcf4\ub97c \ud655\uc778\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "\ub9c8\uc9c0\ub9c9 \uc131\uacf5 \uc774\ud6c4";
    }

    @Override
    public String noHayCambios() {
        return "\ubcc0\uacbd \uc0ac\ud56d \uc5c6\uc74c";
    }

    @Override
    public String desdeUltimoIntento() {
        return "\ub9c8\uc9c0\ub9c9 \uc2dc\ub3c4 \uc774\ud6c4";
    }

    @Override
    public String fallo() {
        return "\uc2e4\ud328";
    }

    @Override
    public String diferentesDeLasMods() {
        return "\ubaa8\ub4dc\uc640 \ub2e4\ub984";
    }

    @Override
    public String historialDeMods() {
        return "\ubaa8\ub4dc \uae30\ub85d";
    }

    @Override
    public String archivo0() {
        return "\ud30c\uc77c0";
    }

    @Override
    public String archivo1() {
        return "\ud30c\uc77c1";
    }

    @Override
    public String comparar() {
        return "\ube44\uad50\ud558\uae30";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "\ub450 \ud30c\uc77c \uc120\ud0dd";
    }

    @Override
    public String archivoExito() {
        return "\uc131\uacf5\ud55c \ud30c\uc77c";
    }

    @Override
    public String archivoFalla() {
        return "\uc2e4\ud328\ud55c \ud30c\uc77c";
    }

    @Override
    public String errorComparandoArchivos() {
        return "\ud30c\uc77c \ube44\uad50 \uc911 \uc624\ub958";
    }

    @Override
    public String comparando() {
        return "\ube44\uad50 \uc911";
    }

    @Override
    public String con() {
        return "\uc640(\uacfc)";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'><p><b>\ubaa8\ub4dc \uc774\ub825 \ube44\uad50 \ud328\ub110</b></p><p>\uc774 \ud328\ub110\uc744 \uc0ac\uc6a9\ud558\uba74 \uc11c\ub85c \ub2e4\ub978 \uc2e4\ud589 \uc138\uc158\uc758 \ub450 \ubaa8\ub4dc \ubaa9\ub85d\uc744 \ube44\uad50\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc88c\uce21\uc5d0\uc11c \ud558\ub098, \uc6b0\uce21\uc5d0\uc11c \ub2e4\ub978 \ud30c\uc77c\uc744 \uc120\ud0dd\ud574 \ubcc0\uacbd\ub41c \ub0b4\uc6a9\uc744 \ud655\uc778\ud558\uc138\uc694.</p><h3>\uc0ac\uc6a9 \ubc29\ubc95:</h3><ol><li><b>\ud30c\uc77c \uc120\ud0dd:</b> \ud30c\uc77c \uc774\ub984 \uc606\uc758 \ub77c\ub514\uc624 \ubc84\ud2bc\uc744 \ud074\ub9ad\ud558\uc138\uc694. <span style='color: #4CAF50; font-weight: bold;'>.\uc131\uacf5</span>\uc73c\ub85c \ub05d\ub098\ub294 \ud30c\uc77c\uc740 \uc131\uacf5\ud55c \uc138\uc158\uc785\ub2c8\ub2e4. <span style='color: #F44336; font-weight: bold;'>.\uc2e4\ud328</span>\ub294 \uc624\ub958\uac00 \ubc1c\uc0dd\ud55c \uc138\uc158\uc785\ub2c8\ub2e4.</li><li><b>\uc790\ub3d9 \ube44\uad50:</b> '\ube44\uad50' \ubc84\ud2bc\uc744 \ub204\ub974\uba74 \uc2dc\uc2a4\ud15c\uc774 \ub450 \ubaa9\ub85d\uc744 \ubd84\uc11d\ud558\uc5ec \ucd94\uac00(+) \ub610\ub294 \uc81c\uac70(-)\ub41c \ubaa8\ub4dc\ub97c \ubcf4\uc5ec\uc90d\ub2c8\ub2e4.</li><li><b>\uacb0\uacfc \ubcf4\uae30:</b> \uacb0\uacfc\ub294 \uc0c9\uc0c1 \ucf54\ub4dc\ub85c \uad6c\ubd84\ub41c HTML \ud615\uc2dd\uc73c\ub85c \ud45c\uc2dc\ub429\ub2c8\ub2e4: <ul><li><span style='color: green;'>+ \ucd94\uac00\ub41c \ubaa8\ub4dc</span></li><li><span style='color: red;'>- \uc81c\uac70\ub41c \ubaa8\ub4dc</span></li></ul></li></ol><h3>\uc8fc\uc694 \uae30\ub2a5:</h3><ul><li>\uc131\uacf5/\uc2e4\ud328 \ud30c\uc77c \uc870\ud569 \uc9c0\uc6d0</li><li>\uc815\ud655\ud55c \ucd94\uc801\uc744 \uc704\ud55c \uc591\ubc29\ud5a5 \ucc28\uc774\uc810 \ud45c\uc2dc</li><li>\uae34 \ubaa8\ub4dc \ubaa9\ub85d\uc744 \uc704\ud55c \uc2a4\ud06c\ub864 \uc9c0\uc6d0</li><li>\uc2dc\uac01\uc801 \uc774\ud574\ub97c \ub3d5\ub294 \uc124\uba85 \uc774\ubbf8\uc9c0 \ud1b5\ud569</li></ul><p>\uc124\uc815 \ubcc0\uacbd \uc0ac\ud56d\uc744 \ucd94\uc801\ud560 \uc218 \uc788\ub3c4\ub85d <3\ufe0f\uc640 \ud568\uaed8 \uac1c\ubc1c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>IPv6 \uad00\ub828 \ubb38\uc81c\uac00 \uc788\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \ud574\uacb0 \ubc29\ubc95\uc740 \ub450 \uac00\uc9c0\uc785\ub2c8\ub2e4: 1) \ub7f0\ucc98\uc5d0 JVM \uc778\uc218 <code>-Djava.net.preferIPv4Stack=true</code>\ub97c \ucd94\uac00\ud558\uac70\ub098, 2) CrashDetector\uc5d0\uc11c 'QuickFix' \ubc84\ud2bc\uc744 \ub20c\ub7ec \uc790\ub3d9\uc73c\ub85c \uc124\uc815\uc744 \ud65c\uc131\ud654\ud558\ub294 \ud328\uce58\ub97c \uc801\uc6a9\ud558\uc138\uc694.</b>";
    }

    @Override
    public String parcheIPv4() {
        return "IPv4/6 \ud328\uce58";
    }

    @Override
    public String carpetaHMCL() {
        return "HMCL \ud3f4\ub354 (HelloMineCraftLauncher \uc804\uc6a9)";
    }

    @Override
    public String descripcionCurseforge() {
        return "\uc8fc\uc758: \uc124\uc815 > \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\uc5d0\uc11c '\ub7f0\ucc98 \uac74\ub108\ub6f0\uae30'\uac00 \ud65c\uc131\ud654\ub418\uba74 \ub85c\uadf8 \ud30c\uc77c\uc774 \uc0dd\uc131\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/\ud30c\uc0dd\ub41c \ub7f0\ucc98: \uc778\uc2a4\ud134\uc2a4\ub97c \uc6b0\ud074\ub9ad\ud558\uace0 '\uc778\uc2a4\ud134\uc2a4 \ud3b8\uc9d1'\uc744 \uc120\ud0dd\ud569\ub2c8\ub2e4. \uc5f4\ub9b0 \ucc3d\uc5d0\uc11c '\ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ub85c\uadf8' \ub610\ub294 \uc720\uc0ac\ud55c \ud56d\ubaa9\uc744 \ucc3e\uc73c\uc138\uc694.<br>\uc774\ub7ec\ud55c \ub85c\uadf8\ub294 \uc624\ub958 \uc9c4\ub2e8\uc5d0 \ud544\uc218\uc801\uc778 \ud45c\uc900 \ucd9c\ub825(STDOUT)\uc744 \ud3ec\ud568\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): HMCL\uc774 \uc124\uce58\ub41c \ud3f4\ub354\ub97c \uc120\ud0dd\ud558\uace0 '.hmcl' \ud3f4\ub354\ub97c \uc9c0\uc815\ud574\uc57c \ud569\ub2c8\ub2e4. HMCL \ub85c\uadf8\ub294 \uc774 \uc704\uce58\uc5d0 \uc800\uc7a5\ub418\uba70 \uc911\uc694\ud55c \uc624\ub958 \uc815\ubcf4\ub97c \ub2f4\uace0 \uc788\uc2b5\ub2c8\ub2e4.<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix: \ub7f0\ucc98\uc5d0\ub294 \uc0c1\uc138\ud55c \ub85c\uadf8\ub97c \ubcf4\uc5ec\uc8fc\ub294 \uac1c\ubc1c \ud0ed\uc774 \uc788\uc2b5\ub2c8\ub2e4. \ub7f0\ucc98 \uc124\uc815 \uba54\ub274\uc5d0\uc11c \uc774 \ud0ed\uc744 \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher: \ud31d\uc5c5 \ucc3d\uc5d0 \ub85c\uadf8\uac00 \ud45c\uc2dc\ub429\ub2c8\ub2e4. \ubcf5\uc0ac \ubc0f \uc5c5\ub85c\ub4dc \ubc84\ud2bc\uc774 \uc788\uc73c\uba70, \uac8c\uc784 \uc2dc\uc791 \uc2dc \uc790\ub3d9\uc73c\ub85c \uc0dd\uc131\ub418\uace0 \uc911\uc694\ud55c \uc9c4\ub2e8 \uc815\ubcf4\ub97c \ub2f4\uace0 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher: \uc778\uc2a4\ud134\uc2a4\ub97c \uc6b0\ud074\ub9ad\ud558\uc5ec '\uc124\uc815'\uc744 \ud074\ub9ad\ud55c \ub2e4\uc74c \ub85c\uadf8 \uc139\uc158\uc5d0\uc11c \ud45c\uc900 \ucd9c\ub825(STDOUT)\uc758 \uc911\uc694\ud55c \uc815\ubcf4\ub97c \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "Markdown \ub9c1\ud06c: Markdown \ud615\uc2dd\uc758 \ub85c\uadf8\ub97c \ud3ec\ud568\ud558\ub294 \ubaa8\ub4e0 \ub9c1\ud06c\ub97c \uc5ec\uae30\uc5d0 \ubd99\uc5ec\ub123\uc73c\uc138\uc694. \uc2dc\uc2a4\ud15c\uc740 \ub85c\uadf8 \ub9c1\ud06c(latest.log, launcher_log.txt, debug.log \ub4f1)\ub97c \uc790\ub3d9\uc73c\ub85c \ucd94\ucd9c\ud558\uace0 \ubd84\uc11d\ud560 \uac83\uc785\ub2c8\ub2e4.";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "\ub7f0\ucc98 \ub85c\uadf8\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String imagenNoEncontrada() {
        return "\uc774\ubbf8\uc9c0\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "\uc77c\ubc18: \uc0ac\uc6a9 \uc911\uc778 \ub7f0\ucc98 \uc885\ub958\ub97c \uc120\ud0dd\ud558\uc138\uc694. \ub7f0\ucc98 \ub85c\uadf8(launcher_log.txt, stdout \ub4f1)\ub294 latest.log\uc5d0 \uc5c6\ub294 \uc911\uc694\ud55c \uc624\ub958 \uc815\ubcf4\ub97c \ud3ec\ud568\ud569\ub2c8\ub2e4. CrashDetector\uac00 \ub7f0\ucc98 \ub85c\uadf8\ub97c \uc77d\uc9c0 \ubabb\ud560 \uc218\ub3c4 \uc788\ub294\ub370, \ub85c\uadf8 \ud30c\uc77c\uc774 \uc0dd\uc131\ub418\uc9c0 \uc54a\uc558\uc744 \uc218 \uc788\uc73c\ubbc0\ub85c \uc218\ub3d9\uc73c\ub85c \ub85c\uadf8\ub97c \ubd99\uc5ec\ub123\uc5b4\uc57c \ud560 \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4.<br>\uc790\uc138\ud55c \ub0b4\uc6a9\uc740 <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">\uc774 \ubb38\uc81c\ub97c \ucc38\uc870\ud558\uc138\uc694</a>. \uc774\ub7ec\ud55c \ub85c\uadf8\ub294 \ud45c\uc900 \ucd9c\ub825(STDOUT)\uc744 \ud3ec\ud568\ud558\uba70, \ub9ce\uc740 \uc624\ub958\ub97c \uc9c4\ub2e8\ud558\ub294 \ub370 \ud544\uc694\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Create\uc5d0\uc11c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. Create\ub294 \ub9ce\uc740 \ubcc0\uacbd\uc774 \uc788\uc5c8\uc73c\uba70, \ub9ce\uc740 \ud074\ub798\uc2a4\uac00 \uc81c\uac70\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ud2b9\ud788 Create 6(2025\ub144 2\uc6d4) \uc774\ud6c4\ub85c \uc624\ub798\ub41c Create \ubc84\uc804\uc758 \uc560\ub4dc\uc628\uc740 \ub354 \uc774\uc0c1 \uc791\ub3d9\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. QuickFix\ub294 \uc774 \ubb38\uc81c\uc5d0 \ub300\ud55c \ud574\uacb0\ucc45\uc744 \uc81c\uacf5\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. Create \uc560\ub4dc\uc628\uc744 \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098, \ub354 \uc774\uc0c1 \uc0ac\uc6a9\ud558\uc9c0 \uc54a\ub294 \uc560\ub4dc\uc628\uc744 \uc81c\uac70\ud558\uac70\ub098, \uc0ac\uc6a9\ud558\ub824\ub294 \uc560\ub4dc\uc628\uc5d0 \ub9de\ub294 \uc62c\ubc14\ub978 Create \ubc84\uc804\uc744 \uc0ac\uc6a9\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>EpicFight\uc5d0\uc11c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. EpicFight\ub294 \ub9ce\uc740 \ubcc0\uacbd\uc774 \uc788\uc5c8\uc73c\uba70, \ub9ce\uc740 \ud074\ub798\uc2a4\uac00 \uc81c\uac70\ub418\uc5c8\uc2b5\ub2c8\ub2e4. QuickFix\ub294 \uc774 \ubb38\uc81c\uc5d0 \ub300\ud55c \ud574\uacb0\ucc45\uc744 \uc81c\uacf5\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. EpicFight \uc560\ub4dc\uc628\uc744 \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098, \ub354 \uc774\uc0c1 \uc0ac\uc6a9\ud558\uc9c0 \uc54a\ub294 \uc560\ub4dc\uc628\uc744 \uc81c\uac70\ud558\uac70\ub098, \uc0ac\uc6a9\ud558\ub824\ub294 \uc560\ub4dc\uc628\uc5d0 \ub9de\ub294 \uc62c\ubc14\ub978 EpicFight \ubc84\uc804\uc744 \uc0ac\uc6a9\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenJ9\ub97c \uc0ac\uc6a9\ud558\uace0 \uacc4\uc2e0\ub370, \uc774 \uc560\ud50c\ub9ac\ucf00\uc774\uc158\uc740 OpenJ9\ub97c \uc9c0\uc6d0\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc774 \uc571\uc744 \ud3ec\ud568\ud55c \ub9ce\uc740 \uc571\ub4e4\uc774 JVM \uad6c\ud604 \ubc29\uc2dd\uc758 \ucc28\uc774\ub85c \uc778\ud574 OpenJ9\ub97c \uc9c0\uc6d0\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. QuickFix\ub85c\ub294 \uc774 \ubb38\uc81c\ub97c \uc790\ub3d9\uc73c\ub85c \ud574\uacb0\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. Oracle JDK, OpenJDK Hotspot \ub610\ub294 \uae30\ud0c0 \uad8c\uc7a5\ub418\ub294 \ud638\ud658 \uac00\ub2a5\ud55c JDK\ub97c \uc124\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc774 \uc571\uc758 \ubc84\uc804\uc740 \uc815\uc0c1 \uc791\ub3d9\uc744 \uc704\ud574 Java 11(JDK 11)\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. \ud604\uc7ac \uc0ac\uc6a9 \uc911\uc778 Java \ubc84\uc804\uc774 \uc624\ub798\ub418\uc5b4 \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. QuickFix\ub294 Java\ub97c \uc790\ub3d9\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ud574\uacb0 \ubc29\ubc95\uc5d0 \uc81c\uacf5\ub41c \ub9c1\ud06c\uc5d0\uc11c JDK 11 \uc774\uc0c1\uc758 \ud638\ud658 \uac00\ub2a5\ud55c \ubc84\uc804\uc744 \ub2e4\uc6b4\ub85c\ub4dc\ud558\uc5ec \uc124\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ub108\ubb34 \ub9ce\uc740 \uba54\ubaa8\ub9ac\ub97c \ud560\ub2f9\ud558\uc5ec \uc2dc\uc2a4\ud15c \ub9ac\uc18c\uc2a4\uac00 \ubd80\uc871\ud574\uc84c\uc2b5\ub2c8\ub2e4. \uc77c\ubc18\uc801\uc73c\ub85c \uc2dc\uc2a4\ud15c\uc5d0 \uc788\ub294 RAM\ubcf4\ub2e4 \ub354 \ub9ce\uc740 \uba54\ubaa8\ub9ac\ub97c \uc9c0\uc815\ud588\uac70\ub098, \ub300\uc6a9\ub7c9 \uba54\ubaa8\ub9ac\ub97c \ucc98\ub9ac\ud560 \uc218 \uc5c6\ub294 32\ube44\ud2b8 JVM\uc744 \uc0ac\uc6a9\ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\uc774 \ubb38\uc81c\ub97c \ud574\uacb0\ud558\ub824\uba74 \uc571\uc5d0 \ud560\ub2f9\ub41c \uba54\ubaa8\ub9ac \uc591\uc744 \uc904\uc5ec\uc57c \ud569\ub2c8\ub2e4. \ucd94\ucc9c \ucd5c\ub300\uce58\ub294 \uc2dc\uc2a4\ud15c\uc5d0 \ub530\ub77c \ub2e4\ub985\ub2c8\ub2e4\ub9cc, \uc77c\ubc18\uc801\uc73c\ub85c \uc804\uccb4 RAM\uc758 70~80%\ub97c \ucd08\uacfc\ud558\uc9c0 \uc54a\uc544\uc57c \ud569\ub2c8\ub2e4. 32\ube44\ud2b8 JVM\uc744 \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0 \ubb3c\ub9ac\uc801 RAM \uc591\uacfc \uad00\uacc4\uc5c6\uc774 \uc57d 2~3GB\uac00 \ucd5c\ub300\uce58\uc785\ub2c8\ub2e4.</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\uc571\uc758 \ud799(heap) \uba54\ubaa8\ub9ac\ub97c \uc904\uc774\ub824\uba74, \ub7f0\ucc98 \uc124\uc815\uc744 \uc5f4\uace0 RAM \uc635\uc158\uc744 \ucc3e\uc73c\uc138\uc694. \ucd5c\ub300\uac12(Xmx)\uc744 \ub354 \uc801\uc808\ud55c \uc218\uce58\ub85c \uc904\uc774\uc138\uc694. \uc608\ub97c \ub4e4\uc5b4, 8GB RAM\uc744 \uac00\uc9c4 \uacbd\uc6b0 3~4GB\ub97c, 16GB\ub97c \uac00\uc9c4 \uacbd\uc6b0 6~8GB\ub97c \ud560\ub2f9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc6b4\uc601\uccb4\uc81c\uc640 \ub2e4\ub978 \ud504\ub85c\uadf8\ub7a8\uc744 \uc704\ud574 \ucda9\ubd84\ud55c \uba54\ubaa8\ub9ac\ub97c \ub0a8\uaca8\ub450\ub294 \uac83\uc744 \uc78a\uc9c0 \ub9c8\uc138\uc694.</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge\uc758 \ud544\uc218 \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. '" + archivo + "' \ud30c\uc77c\uc774 \uc124\uce58 \ud3f4\ub354\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc77c\ubc18\uc801\uc73c\ub85c Forge \uc124\uce58\uac00 \uc911\ub2e8\ub418\uac70\ub098 \uc911\uc694\ud55c \ud30c\uc77c\uc774 \uc0ad\uc81c\ub418\uc5c8\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. QuickFix\ub294 \uc774 \ud30c\uc77c\ub4e4\uc744 \uc790\ub3d9\uc73c\ub85c \ubcf5\uad6c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uacf5\uc2dd \uc124\uce58 \ud504\ub85c\uadf8\ub7a8\uc744 \uc0ac\uc6a9\ud558\uc5ec Forge\ub97c \ub2e4\uc2dc \uc124\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge\uac00 \ud544\uc694\ud55c \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ubc84\uc804 " + version + "\uc774 \ud544\uc694\ud558\uc9c0\ub9cc '" + archivo + "' \ud30c\uc77c\uc5d0\uc11c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uacfc \uc0ac\uc6a9 \uc911\uc778 Forge \ubc84\uc804\uc774 \ub9de\uc9c0 \uc54a\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uc5d0 \ub9de\ub294 \uc62c\ubc14\ub978 Forge \ubc84\uc804\uc744 \ub2e4\uc6b4\ub85c\ub4dc\ud588\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge\ub97c \uc2dc\uc791\ud558\ub294 \ub370 \ud544\uc694\ud55c 'fmlclient' \ud0c0\uac9f\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc774\ub294 Forge \uc124\uce58\uac00 \ubd88\uc644\uc804\ud558\uac70\ub098 \uc190\uc0c1\ub418\uc5c8\uc74c\uc744 \uc758\ubbf8\ud569\ub2c8\ub2e4. Forge\uc758 \ud575\uc2ec \ud30c\uc77c\uc774 \uc81c\ub300\ub85c \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uacf5\uc2dd \uc124\uce58 \ud504\ub85c\uadf8\ub7a8\uc744 \uc0ac\uc6a9\ud558\uc5ec Forge\ub97c \ub2e4\uc2dc \uc124\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud074\ub798\uc2a4 \ub85c\ub354\uc5d0\uc11c \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \uba54\uc778 \ud074\ub798\uc2a4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc774\ub294 Forge \uc124\uce58\uac00 \ubd88\uc644\uc804\ud558\uac70\ub098 \ub2e4\ub978 \ubaa8\ub4dc\uc640 \ucda9\ub3cc\ud588\uc74c\uc744 \ub098\ud0c0\ub0c5\ub2c8\ub2e4. Forge \uc124\uce58 \uc911 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ud30c\uc77c\uc774 \uc190\uc0c1\ub418\uc5c8\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4. Forge\ub97c \ub2e4\uc2dc \uc62c\ubc14\ub974\uac8c \uc124\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge \uc124\uce58\uac00 \uc644\ub8cc\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4. \uc124\uce58 \ub3c4\uc911 \uc911\ub2e8\ub418\uc5c8\uac70\ub098 \ud30c\uc77c\uc774 \uc0ad\uc81c\ub418\uc5c8\uac70\ub098 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4. Forge\ub294 \uc815\uc0c1 \uc791\ub3d9\uc744 \uc704\ud574 \ud2b9\uc815 \ud30c\uc77c\uc774 \ud544\uc694\ud558\uba70, \uc77c\ubd80 \ud30c\uc77c\uc774 \ud604\uc7ac \uc124\uce58\uc5d0 \ub204\ub77d\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "Forge \uc124\uce58 \ubbf8\uc644\ub8cc";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\uc774 \ubb38\uc81c\ub97c \ud574\uacb0\ud558\ub824\uba74 Forge\ub97c \ub2e4\uc2dc \uc62c\ubc14\ub974\uac8c \uc124\uce58\ud558\uc138\uc694. \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uc5d0 \ub9de\ub294 \uc62c\ubc14\ub978 \ubc84\uc804\uc744 \ub2e4\uc6b4\ub85c\ub4dc\ud558\uace0 \uc124\uce58 \uacfc\uc815\uc744 \uc911\ub2e8\ud558\uc9c0 \ub9d0\uace0 \uc644\ub8cc\ud558\uc138\uc694.</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "\uacf5\uc2dd \uc0ac\uc774\ud2b8\uc5d0\uc11c Forge \ub2e4\uc6b4\ub85c\ub4dc";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "Forge\ub97c \uc62c\ubc14\ub974\uac8c \ub2e4\uc2dc \uc124\uce58\ud558\ub294 \ubc29\ubc95";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>Forge \ub2e4\uc2dc \uc124\uce58 \ubc29\ubc95:</h3><ol><li>\uacf5\uc2dd \uc0ac\uc774\ud2b8\uc5d0\uc11c \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uc5d0 \ub9de\ub294 Forge \uc124\uce58 \ud504\ub85c\uadf8\ub7a8\uc744 \ub2e4\uc6b4\ub85c\ub4dc\ud558\uc138\uc694</li><li>\ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ub7f0\ucc98\ub97c \uc644\uc804\ud788 \uc885\ub8cc\ud558\uc138\uc694</li><li>\uad00\ub9ac\uc790 \uad8c\ud55c\uc73c\ub85c Forge \uc124\uce58 \ud504\ub85c\uadf8\ub7a8\uc744 \uc2e4\ud589\ud558\uc138\uc694</li><li>'Installer' \uc635\uc158\uc744 \uc120\ud0dd\ud558\uc138\uc694 ('Installer (run client)' \uc544\ub2d8)</li><li>\ub7f0\ucc98\uc5d0\uc11c \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ud504\ub85c\ud544 \ud3f4\ub354\ub97c \uc120\ud0dd\ud558\uc138\uc694</li><li>'OK'\ub97c \ub204\ub974\uace0 \uc124\uce58\uac00 \uc644\ub8cc\ub420 \ub54c\uae4c\uc9c0 \uae30\ub2e4\ub9ac\uc138\uc694</li><li>\ub7f0\ucc98\ub97c \uc7ac\uc2dc\uc791\ud558\uace0 Forge\uac00 \ud504\ub85c\ud544 \ubaa9\ub85d\uc5d0 \ub098\ud0c0\ub098\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694</li></ol><p><b>\uc911\uc694:</b> \uc0ac\uc6a9\uc790 \uc815\uc758 \ub7f0\ucc98\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0 \uc62c\ubc14\ub978 \ud504\ub85c\ud544 \ud3f4\ub354\ub97c \uc120\ud0dd\ud588\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "Forge \ub2e4\uc2dc \uc124\uce58 \ubc29\ubc95";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ub9c1\ud06c \uc624\ub958: \ub77c\uc774\ube0c\ub7ec\ub9ac " + nombreBiblioteca + "\uc744(\ub97c) \ub85c\ub4dc\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \ud574\uacb0 \ubc29\ubc95:<br/><br/>a) \uacf5\uc720 \ub77c\uc774\ube0c\ub7ec\ub9ac\uac00 \uc788\ub294 \ub514\ub809\ud130\ub9ac\ub97c -Djava.library.path \ub610\ub294 -Dorg.lwjgl.librarypath\uc5d0 \ucd94\uac00\ud558\uc138\uc694.<br/>b) \uacf5\uc720 \ub77c\uc774\ube0c\ub7ec\ub9ac\ub97c \ud3ec\ud568\ud558\ub294 JAR \ud30c\uc77c\uc744 classpath\uc5d0 \ucd94\uac00\ud558\uc138\uc694.<br/><br/>\uc774 \uc624\ub958\ub294 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\uac00 \uc2e4\ud589\uc5d0 \ud544\uc694\ud55c \ud575\uc2ec \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ub300\ubd80\ubd84 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \uc124\uce58\uac00 \ubd88\uc644\uc804\ud558\uac70\ub098 \uc2dc\uc2a4\ud15c \uad8c\ud55c \ubb38\uc81c\ub85c \uc778\ud574 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "\ub9c1\ud06c \uc624\ub958";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\ub77c\uc774\ube0c\ub7ec\ub9ac \ub85c\ub4dc \uc2e4\ud328. \uac00\ub2a5\ud55c \ud574\uacb0 \ubc29\ubc95:<br/><br/>a) \uacf5\uc720 \ub77c\uc774\ube0c\ub7ec\ub9ac\uac00 \uc788\ub294 \ub514\ub809\ud130\ub9ac\ub97c -Djava.library.path \ub610\ub294 -Dorg.lwjgl.librarypath\uc5d0 \ucd94\uac00\ud558\uc138\uc694.<br/>b) \uacf5\uc720 \ub77c\uc774\ube0c\ub7ec\ub9ac\ub97c \ud3ec\ud568\ud558\ub294 JAR \ud30c\uc77c\uc744 classpath\uc5d0 \ucd94\uac00\ud558\uc138\uc694.<br/><br/>\uc774\ub7ec\ud55c \uae30\uc220\uc801 \ud574\uacb0\ucc45\uc740 \uace0\uae09 \uc0ac\uc6a9\uc790\ub97c \uc704\ud55c \uac83\uc785\ub2c8\ub2e4. \ub300\ubd80\ubd84\uc758 \uc0ac\uc6a9\uc790\ub294 \uc774\ub7ec\ud55c \ub9e4\uac1c\ubcc0\uc218\ub97c \uc218\uc815\ud558\uae30 \uc804\uc5d0 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\ub97c \uc7ac\uc124\uce58\ud558\ub294 \uac83\uc774 \uc88b\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ID \ucda9\ub3cc: <strong>" + id + "</strong> \ubc88 ID\uac00 <strong>" + modOrigen + "</strong>\uc5d0 \uc758\ud574 \uc774\ubbf8 \uc0ac\uc6a9 \uc911\uc774\uba70, <strong>" + modDestino + "</strong>\uc744(\ub97c) \ucd94\uac00\ud558\ub824\uace0 \ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ub450 \uac1c\uc758 \ubaa8\ub4dc\uac00 \uc11c\ub85c \ub2e4\ub978 \uc694\uc18c\uc5d0 \ub3d9\uc77c\ud55c ID\ub97c \uc0ac\uc6a9\ud558\ub824 \ud560 \ub54c \uc774 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud5c8\uc6a9\ub41c \ucd5c\ub300 ID \ubc94\uc704\ub97c \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4. \ubaa8\ub4dc\uac00 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uc5d0\uc11c \ud5c8\uc6a9\ud558\ub294 \ubc94\uc704\ub97c \ubc97\uc5b4\ub09c ID\ub85c \ube14\ub85d\uc774\ub098 \uc544\uc774\ud15c\uc744 \ub4f1\ub85d\ud558\ub824 \ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "ID \ucda9\ub3cc";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\uc774 \ubb38\uc81c\ub97c \ud574\uacb0\ud558\ub824\uba74 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 1.12.2\uc5d0 <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a>\ub97c \uc124\uce58\ud558\uc138\uc694. 1.7.10\uc758 \uacbd\uc6b0 <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a>\ub97c \uc0ac\uc6a9\ud558\uc138\uc694.</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>ID \ucda9\ub3cc\uc744 \ud574\uacb0\ud558\ub824\uba74 <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> \ub610\ub294 <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a>\uc640 \uac19\uc740 \ub3c4\uad6c\ub97c \uc0ac\uc6a9\ud558\uc138\uc694.</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "JustEnoughIDs \uc124\uce58";
    }

    @Override
    public String instalar_endlessids() {
        return "EndlessIDs \uc124\uce58";
    }

    @Override
    public String usar_idfix_minus() {
        return "IdFix Minus \ub610\ub294 IdFix \uc0ac\uc6a9";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "Minecraft-ID-Resolver \uc0ac\uc6a9";
    }

    @Override
    public String ver_documentacion_jp() {
        return "\uc77c\ubcf8\uc5b4 \ubb38\uc11c \ubcf4\uae30";
    }

    @Override
    public String escanearDeMCreator() {
        return "MCreator \uc2a4\uce94";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\ubaa8\ub4c8 \ubc0f \ud074\ub798\uc2a4 \ud2b8\ub9ac";
    }

    @Override
    public String tipoBusqueda() {
        return "\uc720\ud615";
    }

    @Override
    public String filtroTodos() {
        return "\uc804\uccb4";
    }

    @Override
    public String filtroPaquetes() {
        return "\ud328\ud0a4\uc9c0";
    }

    @Override
    public String filtroClases() {
        return "\ud074\ub798\uc2a4";
    }

    @Override
    public String filtroMetodos() {
        return "\uba54\uc11c\ub4dc";
    }

    @Override
    public String filtroCampos() {
        return "\ud544\ub4dc";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "\ud544\ub4dc \ucc38\uc870";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "\uba54\uc11c\ub4dc \ucc38\uc870";
    }

    @Override
    public String filtroReferenciasClase() {
        return "\ud074\ub798\uc2a4 \ucc38\uc870";
    }

    @Override
    public String tipBuscar() {
        return "\ubaa8\ub4dc \ud2b8\ub9ac\uc5d0\uc11c \uac80\uc0c9\ud558\ub824\uba74 \uc5ec\uae30\uc5d0 \uc785\ub825\ud558\uc138\uc694";
    }

    @Override
    public String botonBuscar() {
        return "\uac80\uc0c9";
    }

    @Override
    public String botonResetearArbol() {
        return "\ud2b8\ub9ac \ucd08\uae30\ud654";
    }

    @Override
    public String modsCargados() {
        return "\ub85c\ub4dc\ub41c \ubaa8\ub4dc";
    }

    @Override
    public String clases() {
        return "\ud074\ub798\uc2a4";
    }

    @Override
    public String metodos() {
        return "\uba54\uc11c\ub4dc";
    }

    @Override
    public String campos() {
        return "\ud544\ub4dc";
    }

    @Override
    public String referencias() {
        return "\ucc38\uc870";
    }

    @Override
    public String resultadosBusqueda() {
        return "\uac80\uc0c9 \uacb0\uacfc";
    }

    @Override
    public String buscarReferencias() {
        return "\ucc38\uc870 \ucc3e\uae30";
    }

    @Override
    public String referenciasMod() {
        return "\ubaa8\ub4dc \ucc38\uc870";
    }

    @Override
    public String referenciasClase() {
        return "\ud074\ub798\uc2a4 \ucc38\uc870";
    }

    @Override
    public String referenciasMetodo() {
        return "\uba54\uc11c\ub4dc \ucc38\uc870";
    }

    @Override
    public String referenciasCampo() {
        return "\ud544\ub4dc \ucc38\uc870";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "\ucc38\uc870\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String detalleMod() {
        return "\ubaa8\ub4dc \uc815\ubcf4:";
    }

    @Override
    public String ubicacion() {
        return "\uc704\uce58";
    }

    @Override
    public String nombres() {
        return "\uc774\ub984";
    }

    @Override
    public String modulo() {
        return "\ubaa8\ub4c8";
    }

    @Override
    public String detalleClase() {
        return "\ud074\ub798\uc2a4 \uc815\ubcf4:";
    }

    @Override
    public String detalleMetodo() {
        return "\uba54\uc11c\ub4dc \uc815\ubcf4:";
    }

    @Override
    public String detalleCampo() {
        return "\ud544\ub4dc \uc815\ubcf4:";
    }

    @Override
    public String clase() {
        return "\ud074\ub798\uc2a4";
    }

    @Override
    public String tipo() {
        return "\uc720\ud615";
    }

    @Override
    public String referenciasAMetodos() {
        return "\uba54\uc11c\ub4dc \ucc38\uc870:";
    }

    @Override
    public String referenciasACampos() {
        return "\ud544\ub4dc \ucc38\uc870:";
    }

    @Override
    public String arbolDeMods() {
        return "\ubaa8\ub4dc \ud2b8\ub9ac";
    }

    @Override
    public String metodo() {
        return "\uba54\uc11c\ub4dc";
    }

    @Override
    public String campo() {
        return "\ud544\ub4dc";
    }

    @Override
    public String descompilar() {
        return "\ub514\ucef4\ud30c\uc77c";
    }

    @Override
    public String exportar() {
        return "\ub0b4\ubcf4\ub0b4\uae30";
    }

    @Override
    public String importar() {
        return "\uac00\uc838\uc624\uae30";
    }

    @Override
    public String errorImportar() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430";
    }

    @Override
    public String estructuraImportada() {
        return "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0430";
    }

    @Override
    public String estructuraExportada() {
        return "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0430";
    }

    @Override
    public String errorExportar() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430";
    }

    @Override
    public String exportando() {
        return "\ub0b4\ubcf4\ub0b4\ub294 \uc911";
    }

    @Override
    public String exportacionTardara() {
        return "\ub0b4\ubcf4\ub0b4\uae30\uc5d0 \uc2dc\uac04\uc774 \uac78\ub9b4 \uc218 \uc788\uc74c";
    }

    @Override
    public String porFavorEspere() {
        return "\uc7a0\uc2dc \uae30\ub2e4\ub824 \uc8fc\uc138\uc694";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>VLC \ubc14\uc774\ub108\ub9ac\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. WaterMedia\ub294 VLC \ubc14\uc774\ub108\ub9ac\uac00 \ud544\uc694\ud569\ub2c8\ub2e4. https://www.videolan.org/vlc/ \uc5d0\uc11c \uc218\ub3d9\uc73c\ub85c \uc124\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "VLC \ub2e4\uc6b4\ub85c\ub4dc";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801 \uc624\ub958: \ubaa8\ub4c8 \uc774\ub984 '" + nombreModulo + "'\uc5d0 \uc798\ubabb\ub41c \ubb38\uc790\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4. '" + parteInvalida + "' \ubd80\ubd84\uc740 \uc720\ud6a8\ud55c Java \uc2dd\ubcc4\uc790\uac00 \uc544\ub2d9\ub2c8\ub2e4. \uc790\ubc14 \uc608\uc57d\uc5b4('true', 'class' \ub4f1)\ub098 \uc774\ub984\uc5d0 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\ub294 \ubb38\uc790\ub97c \ubaa8\ub4dc\uac00 \uc0ac\uc6a9\ud560 \uacbd\uc6b0 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "\ubaa8\ub4dc \uc774\ub984\uc5d0 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ubb38\uc790 \ud3ec\ud568";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "\ubaa8\ub4dc \uc774\ub984 '" + nombreModulo + "'\uc740(\ub294) '" + parteInvalida + "'\uc744(\ub97c) \ud3ec\ud568\ud558\uace0 \uc788\uc5b4 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc774\ub294 \uc790\ubc14 \uc608\uc57d\uc5b4\uc774\uac70\ub098 \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \ubb38\uc790\uc785\ub2c8\ub2e4. \ub85c\uadf8\uc5d0\uc11c \uc774 \uc774\ub984\uacfc \uc77c\uce58\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc73c\uc138\uc694 (\uc77c\ubc18\uc801\uc73c\ub85c JAR \ud30c\uc77c \uc774\ub984)";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "\ubaa8\ub4dc \ud3f4\ub354\ub85c \uc774\ub3d9\ud558\uc5ec <b>/META-INF/</b> \ud3f4\ub354 \ub0b4 <b>mods.toml</b> \ud30c\uc77c\uc744 \ud3b8\uc9d1\ud558\uc138\uc694. <b>modId</b> \uac12\uc744 \uc790\ubc14 \uc608\uc57d\uc5b4 \uc5c6\uc774 \ubb38\uc790, \uc22b\uc790, \ubc11\uc904\ub9cc \uc0ac\uc6a9\ud558\ub3c4\ub85d \ubcc0\uacbd\ud558\uc138\uc694";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "\uc720\ud6a8\ud55c \uc774\ub984 \uc608\uc2dc: 'true.shot.enchantment' \ub300\uc2e0 'truemod_shot_enchantment' \uc0ac\uc6a9. \ubaa8\ub4dc \uc774\ub984\uc5d0\ub294 \uc810, \ud558\uc774\ud508, \uc790\ubc14 \uc608\uc57d\uc5b4('true', 'false', 'class')\ub97c \ud3ec\ud568\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ubaa8\ub4dc '" + nombreJar + "'\uc5d0\uc11c \uce58\uba85\uc801 \uc624\ub958 \ubc1c\uc0dd: \uc758\uc874\uc131\uc5d0 \ud544\uc218 \ud544\ub4dc 'mandatory'\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. mods.toml \ud30c\uc77c\uc774 \uc758\uc874\uc131\uc774 \ud544\uc218\uc778\uc9c0 \uba85\uc2dc\ud558\uc9c0 \uc54a\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "\uc758\uc874\uc131 \ubaa8\ub4dc\uc5d0 \ud544\uc218 \ud544\ub4dc \ub204\ub77d";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "\ubb38\uc81c \uc788\ub294 \ubaa8\ub4dc\ub294 <b>" + nombreJar + "</b>\uc785\ub2c8\ub2e4. \uc774 \ud30c\uc77c\uc758 \uc758\uc874\uc131 \uc124\uc815\uc5d0 \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "<b>" + nombreJar + "</b> \ubaa8\ub4dc\uc758 <b>/META-INF/</b> \ud3f4\ub354 \ub0b4 <b>mods.toml</b> \ud30c\uc77c\uc744 \uc5f4\uae30";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "\uc758\uc874\uc131 \uc139\uc158\uc5d0\uc11c \uac01 \ud56d\ubaa9\uc774 <b>mandatory=true</b> \ub610\ub294 <b>mandatory=false</b>\ub97c \ud3ec\ud568\ud558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694 (\uc608: modId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" )";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc2ec\uac01\ud55c \uc624\ub958: '" + nombreJar + "' \ubaa8\ub4dc\uc758 access transformer \uc124\uc815\uc774 \uc798\ubabb\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc124\uc815 \ud30c\uc77c\uc758 \uad6c\ubb38\uc774 \uc798\ubabb\ub418\uc5c8\uac70\ub098 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \ud074\ub798\uc2a4/\uba54\uc11c\ub4dc\ub97c \ucc38\uc870\ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "\uc798\ubabb\ub41c Access Transformer";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "\ubb38\uc81c \uc788\ub294 \ubaa8\ub4dc\ub294 <b>" + nombreJar + "</b>\uc785\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub294 \uc798\ubabb\ub41c access transformer \uc124\uc815\uc744 \ud3ec\ud568\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "<b>" + nombreJar + "</b> \ubaa8\ub4dc \ub0b4\ubd80\uc758 <b>accessTransformer.cfg</b> \ud30c\uc77c\uc744 \uc5fd\ub2c8\ub2e4 (\uc77c\ubc18\uc801\uc73c\ub85c JAR \ud30c\uc77c\uc758 \ub8e8\ud2b8 \ud3f4\ub354\uc5d0 \uc788\uc74c)";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "access transformer \uad6c\ubb38\uc744 \uc218\uc815\ud558\uc138\uc694. \uac01 \uc904\uc740 <b>access class.method</b> \ud615\uc2dd\uc744 \ub530\ub77c\uc57c \ud569\ub2c8\ub2e4 (\uc608: public net.minecraft.world.entity.Entity.func_200560_a). \ud604\uc7ac \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \ud074\ub798\uc2a4\ub098 \uba54\uc11c\ub4dc\ub97c \ucc38\uc870\ud558\ub294 \uc904\uc740 \uc0ad\uc81c\ud558\uc138\uc694";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc2ec\uac01\ud55c \uc624\ub958: @Mod \uc8fc\uc11d\uc758 \ubaa8\ub4dc ID\uc640 mods.toml \ud30c\uc77c\uc758 ID\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. '" + nombreMod + "' \ubaa8\ub4dc\ub294 ID \ubd88\uc77c\uce58\ub85c \uc778\ud574 \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "@Mod\uc640 mods.toml \uac04 ID \ubd88\uc77c\uce58";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "\uac1c\ubc1c \uc911\uc778 \ubaa8\ub4dc '" + nombreMod + "'\uc5d0\uc11c <b>@Mod</b> \uc8fc\uc11d\uacfc <b>mods.toml</b>\uc758 ID\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "\uae30\ubcf8 \ud074\ub798\uc2a4\uc758 ID\uac00 <b>/META-INF/mods.toml</b> \ud30c\uc77c\uc758 <b>modId</b> \uac12\uacfc \uc77c\uce58\ud558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694. \uc608: <b>@Mod(\"mymod\")</b>\ub294 <b>modId=\"mymod\"</b>\uacfc \uc77c\uce58\ud574\uc57c \ud569\ub2c8\ub2e4";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "Gradle\uc744 \uc0ac\uc6a9 \uc911\uc774\ub77c\uba74 \ubcc0\uacbd \ud6c4 <b>clean</b>\uc744 \uc2e4\ud589\ud558\uc5ec \ub9ac\uc18c\uc2a4\uac00 \uc62c\ubc14\ub974\uac8c \uc5c5\ub370\uc774\ud2b8\ub418\ub3c4\ub85d \ud558\uc138\uc694. \ub54c\ub54c\ub85c \uc774\uc804 \ud30c\uc77c\uc774 build \ud3f4\ub354\uc5d0 \ub0a8\uc544 \uc788\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\ud074\ub77c\uc774\uc5b8\ud2b8" : "\uc11c\ubc84";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\uc11c\ubc84" : "\ud074\ub77c\uc774\uc5b8\ud2b8";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc2ec\uac01\ud55c \uc624\ub958: '" + nombreClase + "' \ud074\ub798\uc2a4\ub97c " + plataforma + " \ud658\uacbd\uc5d0\uc11c \ub85c\ub4dc\ud558\ub824 \ud558\uc9c0\ub9cc, \uc774 \ud074\ub798\uc2a4\ub294 " + plataformaOpuesta + "\uc6a9\uc73c\ub85c \uc124\uacc4\ub418\uc5c8\uc2b5\ub2c8\ub2e4. <b>\uc0ac\uc774\ub4dc\ubc14\uc758 '\ubaa8\ub4dc \ud2b8\ub9ac' \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud574 \uc774 \ud074\ub798\uc2a4\ub97c \ub85c\ub4dc\ud558\ub824\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc73c\uc138\uc694</b>. \ubaa8\ub4dc\ub294 \ud2b9\uc815 \ud50c\ub7ab\ud3fc \uc804\uc6a9\uc73c\ub85c \uc81c\uc791\ub418\uba70 \ub2e4\ub978 \ud50c\ub7ab\ud3fc\uc5d0\uc11c\ub294 \uc791\ub3d9\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "\uc798\ubabb\ub41c \ud50c\ub7ab\ud3fc\uc758 \ubaa8\ub4dc";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "<b>\ubaa8\ub4dc \ud2b8\ub9ac</b> \ud0ed(\uc624\ub978\ucabd)\uc5d0\uc11c <b>" + nombreClase + "</b> \ud074\ub798\uc2a4\uc5d0 \ub300\ud55c \ucc38\uc870\ub97c \uac80\uc0c9\ud574 \ubb38\uc81c\ub97c \uc77c\uc73c\ud0a4\ub294 \ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud558\uc138\uc694";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\ud074\ub77c\uc774\uc5b8\ud2b8" : "\uc11c\ubc84";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\uc11c\ubc84" : "\ud074\ub77c\uc774\uc5b8\ud2b8";
        return "\uc2dd\ubcc4\ub41c \ubaa8\ub4dc\ub294 <b>" + plataformaOpuesta + "</b> \uc804\uc6a9 \ubaa8\ub4dc\uc774\uba70, " + plataforma + " \ud658\uacbd\uc5d0\uc11c \uc0ac\uc6a9\ud558\uba74 \uc548 \ub429\ub2c8\ub2e4.";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "\ubb38\uc81c \uc788\ub294 \ubaa8\ub4dc\ub97c <b>mods</b> \ud3f4\ub354\uc5d0\uc11c \uc81c\uac70\ud558\uc138\uc694. \uc774 \ud50c\ub7ab\ud3fc\uc5d0\uc11c \uc720\uc0ac\ud55c \uae30\ub2a5\uc774 \ud544\uc694\ud558\ub2e4\uba74, <b>\ud074\ub77c\uc774\uc5b8\ud2b8</b> \ub610\ub294 <b>\uc11c\ubc84</b> \uc804\uc6a9\uc73c\ub85c \uc124\uacc4\ub41c \ub300\uccb4 \ubaa8\ub4dc\ub97c \ucc3e\uc544\ubcf4\uc138\uc694";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\uc2ec\uac01\ud55c \uc624\ub958: modid '").append(modIdFaltante).append("'.\uc5d0 \ub300\ud55c \uba54\ud0c0\ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("\ub2e4\uc74c \ubaa8\ub4dc\uac00 \ubb38\uc81c\ub97c \uc77c\uc73c\ud0ac \uc218 \uc788\uc2b5\ub2c8\ub2e4: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", \uae30\ud0c0...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\ubaa8\ub4dc\uac00 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uac70\ub098 mods.toml \ud30c\uc77c\uc774 \uc798\ubabb\ub41c \uacbd\uc6b0 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "\ub204\ub77d\ub41c mods.toml \uba54\ud0c0\ub370\uc774\ud130";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("\ub2e4\uc74c \ubaa8\ub4dc\uac00 '").append(modIdFaltante).append("'.\uc5d0 \uc758\uc874\ud569\ub2c8\ub2e4: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", \uae30\ud0c0...");
            }
            paso.append("</b>. <b>\ubaa8\ub4dc \ud2b8\ub9ac</b> \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud574 \ubb38\uc81c \ubaa8\ub4dc\ub97c \ud655\uc778\ud558\uc138\uc694");
            return paso.toString();
        }
        return "'".concat(modIdFaltante).concat("'\uc5d0 \uc758\uc874\ud558\ub824\ub294 \ubaa8\ub4dc\uac00 \uc788\uc9c0\ub9cc, \ud574\ub2f9 \ubaa8\ub4dc\uac00 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4. <b>\ubaa8\ub4dc \ud2b8\ub9ac</b> \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud574 \ubb38\uc81c \ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud558\uc138\uc694");
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\ub450 \uac00\uc9c0 \uc120\ud0dd\uc9c0\uac00 \uc788\uc2b5\ub2c8\ub2e4:<br/>" + "1. <b>\ub204\ub77d\ub41c \ubaa8\ub4dc \uc124\uce58</b>: ID\uac00 '".concat(modIdFaltante).concat("'\uc778 \ubaa8\ub4dc\ub97c \ucc3e\uc544 \uc124\uce58\ud558\uc138\uc694<br/>") + "2. <b>\uc758\uc874 \ubaa8\ub4dc \uc81c\uac70</b>: \uae30\ub2a5\uc774 \ud544\uc694\ud558\uc9c0 \uc54a\ub2e4\uba74, '".concat(modIdFaltante).concat("'\uc5d0 \uc758\uc874\ud558\ub294 \ubaa8\ub4dc\ub97c \uc81c\uac70\ud558\uc138\uc694");
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "'".concat(modIdFaltante).concat("'\uac00 \ub77c\uc774\ube0c\ub7ec\ub9ac(\uc608: 'forge', 'minecraft', 'curios')\ub77c\uba74, ") + "\uc62c\ubc14\ub978 \ubc84\uc804\uc758 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\uc640 \ud3ec\uc9c0\uac00 \uc124\uce58\ub418\uc5b4 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694. \uc77c\ubc18 \ubaa8\ub4dc\ub77c\uba74 \ub2e4\uc6b4\ub85c\ub4dc \ud398\uc774\uc9c0\uc5d0\uc11c \ud544\uc218 \uc804\uc81c \uc870\uac74\uc744 \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\uacbd\uace0: \uc0ac\uc6b4\ub4dc \uc2dc\uc2a4\ud15c \ucd08\uae30\ud654 \uc2e4\ud328. \uc18c\ub9ac\uc640 \uc74c\uc545\uc774 \ube44\ud65c\uc131\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c SoundPhysicsMod\uacfc \uad00\ub828\uc774 \uc788\uc73c\uba70 \ub2e4\ub978 \uc0ac\uc6b4\ub4dc \ub77c\uc774\ube0c\ub7ec\ub9ac\uc640\uc758 \ucda9\ub3cc\ub85c \uc778\ud574 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "\uc0ac\uc6b4\ub4dc \uc2dc\uc2a4\ud15c \uc624\ub958";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "\uc774 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c <b>SoundPhysicsMod</b>\uacfc \uad00\ub828\uc774 \uc788\uc2b5\ub2c8\ub2e4. \uc0ac\uc6a9 \uc911\uc778 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294 \ucd5c\uc2e0 \ubc84\uc804\uc744 \uc124\uce58\ud588\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "\ub2e4\ub978 \uc0ac\uc6b4\ub4dc \ubaa8\ub4dc(\uc608: Sound Filters, Dynamic Surroundings \ub4f1)\ub97c \uc0ac\uc6a9 \uc911\uc774\ub77c\uba74, SoundPhysicsMod\uc744 \uc784\uc2dc\ub85c \uc81c\uac70\ud558\uc5ec \ucda9\ub3cc\uc774 \ud574\uacb0\ub418\ub294\uc9c0 \ud655\uc778\ud574 \ubcf4\uc138\uc694";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "<b>logs</b> \ud3f4\ub354\ub97c \ud655\uc778\ud558\uc5ec LWJGL \ub610\ub294 OpenAL \uad00\ub828 \ucd94\uac00 \uba54\uc2dc\uc9c0\ub97c \ucc3e\uc544\ubcf4\uc138\uc694. \uc774\ub294 \uae30\ubcf8 \uc0ac\uc6b4\ub4dc \ub77c\uc774\ube0c\ub7ec\ub9ac\uc5d0 \ubb38\uc81c\uac00 \uc788\uc74c\uc744 \ub098\ud0c0\ub0bc \uc218 \uc788\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\uce58\uba85\uc801 \uc624\ub958: '").append(nombreClase).append("' \ud074\ub798\uc2a4\uac00 \uc774\ubca4\ud2b8 \ub9ac\uc2a4\ub108\ub85c \ub4f1\ub85d\ub418\uc5c8\uc9c0\ub9cc \uc720\ud6a8\ud55c \uba54\uc11c\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\uc774 \ud074\ub798\uc2a4\ub294 \ub2e4\uc74c \ubaa8\ub4dc\uc5d0 \uc788\uc2b5\ub2c8\ub2e4: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \uae30\ud0c0...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\uc774\ubca4\ud2b8\ub97c \uc218\uc2e0\ud558\ub3c4\ub85d \ud074\ub798\uc2a4\ub97c \ub4f1\ub85d\ud588\uc9c0\ub9cc @SubscribeEvent\ub85c \uc8fc\uc11d \ucc98\ub9ac\ub41c \uba54\uc11c\ub4dc\uac00 \uc5c6\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "\uc774\ubca4\ud2b8 \ub9ac\uc2a4\ub108 \uc5c6\uc774 \ub4f1\ub85d\ub41c \ud074\ub798\uc2a4";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\ubb38\uc81c \uc788\ub294 \ud074\ub798\uc2a4\ub294 \ub2e4\uc74c \ubaa8\ub4dc\uc5d0 \uc788\uc2b5\ub2c8\ub2e4: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \uae30\ud0c0...");
            }
            paso.append("</b>. \uc774 \ubaa8\ub4dc\ub4e4\uc740 \uc720\ud6a8\ud55c \uba54\uc11c\ub4dc \uc5c6\uc774 \uc774\ubca4\ud2b8\ub97c \ub4f1\ub85d\ud558\ub824\uace0 \uc2dc\ub3c4\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4");
            return paso.toString();
        }
        return "\ud074\ub798\uc2a4 <b>" + nombreClase + "</b>\uac00 \uc774\ubca4\ud2b8 \uc218\uc2e0\uc744 \uc704\ud574 \ub4f1\ub85d\ub418\uc5c8\uc9c0\ub9cc <b>@SubscribeEvent</b> \uc8fc\uc11d\uc774 \ubd99\uc740 \uba54\uc11c\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. <b>\ubaa8\ub4dc \ud2b8\ub9ac</b> \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud558\uc5ec \uc774 \ud074\ub798\uc2a4\ub97c \ud3ec\ud568\ud55c \ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud558\uc138\uc694";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "\uc18c\uc2a4 \ucf54\ub4dc\uc5d0\uc11c \ud074\ub798\uc2a4 <b>" + nombreClase + "</b>\uac00 \ub2e4\uc74c \ud615\uc2dd\uc758 \uba54\uc11c\ub4dc\ub97c \ucd5c\uc18c\ud55c \ud558\ub098 \ud3ec\ud568\ud558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694: <b>@SubscribeEvent public void \uba54\uc11c\ub4dc\uc774\ub984(\ud2b9\uc815\uc774\ubca4\ud2b8 \uc774\ubca4\ud2b8) { ... }</b>. \ub0b4\ubd80 \ud074\ub798\uc2a4\ub77c\uba74 static\uc73c\ub85c \ud45c\uc2dc\ub418\uc9c0 \uc54a\uc558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("\uc2dd\ubcc4\ub41c \ubaa8\ub4dc\ub4e4\uc5d0 \ub300\ud574 (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", \ub4f1");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("\ud574\ub2f9 \ubaa8\ub4dc \uac1c\ubc1c\uc790\uc5d0\uac8c \uc5f0\ub77d\ud558\uc5ec \ubb38\uc81c\ub97c \ud574\uacb0\ud558\ub3c4\ub85d \ud558\uc138\uc694. ");
            } else {
                paso.append("\uc774 \ubaa8\ub4dc\ub4e4\uc758 \uac1c\ubc1c\uc790\ub4e4\uc5d0\uac8c \uc5f0\ub77d\ud558\uc5ec \ubb38\uc81c\ub97c \ud574\uacb0\ud558\ub3c4\ub85d \ud558\uc138\uc694. ");
            }
        }
        paso.append("\uac1c\ubc1c\uc790\ub77c\uba74 EventBus\uc5d0\uc11c \uc774 \ud074\ub798\uc2a4\uc758 \ub4f1\ub85d\uc744 \uc81c\uac70\ud558\uac70\ub098 \uc720\ud6a8\ud55c @SubscribeEvent \uba54\uc11c\ub4dc\ub97c \ucd94\uac00\ud558\uc138\uc694");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801 \uc624\ub958: '" + nombreArchivo + "' \ud30c\uc77c \ucc98\ub9ac \uc911 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc774 \uc624\ub958\ub294 \ub7f0\ucc98\uac00 \ubaa8\ub4dc\ud329 \ud30c\uc77c\uc744 \uc81c\ub300\ub85c \ub2e4\uc6b4\ub85c\ub4dc\ud558\uac70\ub098 \ucd94\ucd9c\ud558\uc9c0 \ubabb\ud588\uc74c\uc744 \uc758\ubbf8\ud569\ub2c8\ub2e4. 'zip END header not found' \uba54\uc2dc\uc9c0\ub294 JAR \ud30c\uc77c\uc774 \ubd88\uc644\uc804\ud558\uac70\ub098 \uc190\uc0c1\ub418\uc5c8\uc74c\uc744 \ub098\ud0c0\ub0b4\uba70, \ub300\uc6a9\ub7c9 \ud30c\uc77c \ub2e4\uc6b4\ub85c\ub4dc\ub97c \uc81c\ub300\ub85c \ucc98\ub9ac\ud558\uc9c0 \ubabb\ud558\ub294 \ub7f0\ucc98\uc5d0\uc11c \ub9e4\uc6b0 \ud754\ud788 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \uc774 \ubb38\uc81c\ub294 \uc8fc\ub85c Twitch/CurseForge, Technic Launcher \uc0ac\uc6a9\uc790\uc5d0\uac8c \uc601\ud5a5\uc744 \ubbf8\uce58\uba70, \ud2b9\ud788 Luna Pixel \uc0ac\uc6a9\uc790\uc5d0\uac8c \uc2ec\uac01\ud569\ub2c8\ub2e4. \uc774\ub7ec\ud55c \ub7f0\ucc98\ub294 \uc885\uc885 \ub2e4\uc6b4\ub85c\ub4dc\ub41c \ud30c\uc77c\uc758 \uc804\uccb4 \ubb34\uacb0\uc131\uc744 \ud655\uc778\ud558\uc9c0 \ubabb\ud569\ub2c8\ub2e4. Luna Pixel \uc0ac\uc6a9\uc790\ub294 ATLauncher\ub85c \uc804\ud658\ud558\ub294 \uac83\uc774 \uc88b\uc2b5\ub2c8\ub2e4. ATLauncher\ub294 \ud30c\uc77c \ubb34\uacb0\uc131\uc744 \ub354 \uc798 \uad00\ub9ac\ud558\uba70 \uc774 \ud2b9\uc815 \uc624\ub958\ub97c \ubc29\uc9c0\ud560 \uc218 \uc788\ub294 \ub354 \uc548\uc815\uc801\uc778 \ub300\uc548\uc785\ub2c8\ub2e4. ZIP \ud615\uc2dd\uc774 \uc190\uc0c1\ub418\uc5b4 \uc2dc\uc2a4\ud15c\uc774 \ubaa8\ub4dc\ub97c \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc73c\uba70, Forge\uac00 \uac8c\uc784 \uc2dc\uc791\uc5d0 \ud544\uc694\ud55c \ub9ac\uc18c\uc2a4\ub97c \uc77d\ub294 \uac83\uc744 \ubc29\ud574\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "UnionFileSystem \uc624\ub958 - \uc190\uc0c1\ub41c \ud30c\uc77c";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "\ubaa8\ub4dc\ud329\uc744 \ucc98\uc74c\ubd80\ud130 \uc644\uc804\ud788 \uc7ac\uc124\uce58\ud558\uc138\uc694";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "Luna Pixel\uc744 \uc0ac\uc6a9 \uc911\uc774\ub77c\uba74 ATLauncher\ub85c \uc804\ud658\ud558\uc138\uc694";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "\uc7ac\uc124\uce58 \uc804\uc5d0 \uc778\ud130\ub137 \uc5f0\uacb0 \uc0c1\ud0dc\uc640 \ub514\uc2a4\ud06c \uc5ec\uc720 \uacf5\uac04\uc744 \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "ProxySysOutSysErr\ub97c \ud65c\uc131\ud654\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?\n\n\uc774 \uc635\uc158\uc740 \ub7f0\ucc98\uac00 \ub85c\uadf8\ub97c \uc81c\uacf5\ud558\uc9c0 \uc54a\uc744 \ub54c CrashDetector\uac00 System.out\uacfc System.err\uc5d0 \uc811\uadfc\ud560 \uc218 \uc788\uac8c \ud574\uc90d\ub2c8\ub2e4.\n\n\uc218\ub3d9\uc73c\ub85c \ub85c\uadf8\ub97c \ubd99\uc5ec\ub123\uc744 \uc218 \uc5c6\uc744 \uacbd\uc6b0\uc5d0\ub9cc \ud65c\uc131\ud654\ud574\uc57c \ud569\ub2c8\ub2e4.\n\n\uacbd\uace0: \uc77c\ubd80 \ubaa8\ub4dc\ub098 \ub7f0\ucc98\uc640 \ucda9\ub3cc\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.\n\n\ubcc0\uacbd \uc0ac\ud56d\uc744 \uc801\uc6a9\ud558\ub824\uba74 \uac8c\uc784/\uc571\uc744 \ub2e4\uc2dc \uc2dc\uc791\ud574\uc57c \ud569\ub2c8\ub2e4.";
    }

    @Override
    public String confirmacionTitulo() {
        return "\ud655\uc778";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr\uac00 \uc131\uacf5\uc801\uc73c\ub85c \ud65c\uc131\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\n\ubcc0\uacbd \uc0ac\ud56d\uc744 \uc801\uc6a9\ud558\ub824\uba74 CrashDetector\ub97c \ub2e4\uc2dc \uc2dc\uc791\ud574\uc57c \ud569\ub2c8\ub2e4.";
    }

    @Override
    public String informacionTitulo() {
        return "\uc815\ubcf4";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("\uce58\uba85\uc801 \uc624\ub958: AzureLib \ubc0f GeckoLib\uc774(\uac00) \ub108\ubb34 \uc77c\ucc0d \ucd08\uae30\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4! ");
        } else if (azureLibError) {
            mensaje.append("\uce58\uba85\uc801 \uc624\ub958: AzureLib\uc774(\uac00) \ub108\ubb34 \uc77c\ucc0d \ucd08\uae30\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4! ");
        } else if (geckoLibError) {
            mensaje.append("\uce58\uba85\uc801 \uc624\ub958: GeckoLib\uc774(\uac00) \ub108\ubb34 \uc77c\ucc0d \ucd08\uae30\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4! ");
        }
        mensaje.append("\uc774 \uc624\ub958\ub294 Fabric \ubaa8\ub4dc\ub97c Fabric\uc774 \uc544\ub2cc \ubc84\uc804\uc758 \ub77c\uc774\ube0c\ub7ec\ub9ac\ub85c \uc0ac\uc6a9\ud558\ub824 \ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. ");
        if (connectorPresente) {
            mensaje.append("\ud638\ud658\uc131 \ubaa8\ub4dc(Sinytra Connector \ub610\ub294 specialcompatibilityoperation)\uac00 \uac10\uc9c0\ub418\uc5b4 Forge \ub610\ub294 FeatureCreep \ud658\uacbd\uc5d0\uc11c Fabric \ubaa8\ub4dc\ub97c \uc2e4\ud589\ud558\ub824 \ud55c\ub2e4\ub294 \uac83\uc744 \uc758\ubbf8\ud569\ub2c8\ub2e4. ");
            mensaje.append("\ubb38\uc81c\ub97c \uc77c\uc73c\ud0a4\ub294 \ud2b9\uc815 \ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud558\ub824\uba74 \ub85c\uadf8\uc5d0\uc11c 'FabricMC \ucd08\uae30\ud654 \uc624\ub958'\ub97c \ud655\uc778\ud558\uc138\uc694. ");
        }
        mensaje.append("AzureLib\uacfc GeckoLib\uc740 \uc560\ub2c8\uba54\uc774\uc158 \ubaa8\ub4dc\uc5d0 \ud544\uc218\uc801\uc774\uc9c0\ub9cc \uc62c\ubc14\ub978 \ud50c\ub7ab\ud3fc(Fabric \ub610\ub294 Forge)\uacfc \uc77c\uce58\ud574\uc57c \ud569\ub2c8\ub2e4. ");
        mensaje.append("\uc774 \ucd08\uae30\ud654 \ucda9\ub3cc\ub85c \uc778\ud574 \uac8c\uc784\uc774 \uc560\ub2c8\uba54\uc774\uc158 \ubaa8\ub4dc\ub97c \uc81c\ub300\ub85c \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "\ub77c\uc774\ube0c\ub7ec\ub9ac\uac00 \ub108\ubb34 \uc77c\ucc0d \ucd08\uae30\ud654\ub428";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "\ub85c\uadf8\uc5d0\uc11c 'FabricMC \ucd08\uae30\ud654 \uc624\ub958'\ub97c \ud655\uc778\ud558\uc5ec \ubb38\uc81c \uc788\ub294 \ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud558\uc138\uc694";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "\ud50c\ub7ab\ud3fc(Forge \ub610\ub294 Fabric)\uc5d0 \ub9de\ub294 \uc62c\ubc14\ub978 \ubc84\uc804\uc758 AzureLib/GeckoLib\uc744 \uc0ac\uc6a9\ud558\uace0 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801 \uc624\ub958: C2ME\uc640 \uc5f0\uacb0 \ubaa8\ub4dc \uac04\uc758 \ud638\ud658\uc131 \ubb38\uc81c. \uc774 \uc624\ub958\ub294 C2ME\uac00 Sinytra Connector \ub610\ub294 specialcompatibilityoperation\uacfc \uac19\uc740 \uc5f0\uacb0 \ubaa8\ub4dc \ud658\uacbd\uc5d0\uc11c \uc81c\ud55c\ub41c Java \ub0b4\ubd80 \uad6c\uc131 \uc694\uc18c\uc5d0 \uc561\uc138\uc2a4\ud558\ub824 \ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. <b>C2ME\ub294 \uc774\ub7ec\ud55c \ud658\uacbd\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc9c0\ub9cc, <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a>\ub294 \ucd94\ucc9c \ub300\uccb4 \uc635\uc158</b>\uc73c\ub85c, \uc5f0\uacb0 \ubaa8\ub4dc\uc640 \uc815\uc0c1\uc801\uc73c\ub85c \uc791\ub3d9\ud569\ub2c8\ub2e4. Java \ubcf4\uc548 \uad8c\ud55c \ucda9\ub3cc\ub85c \uc778\ud574 \uac8c\uc784\uc744 \uc2dc\uc791\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "C2ME\uc640 \uc5f0\uacb0 \ubaa8\ub4dc\uc758 \ud638\ud658\uc131 \ubb38\uc81c";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "mods \ud3f4\ub354\uc5d0\uc11c C2ME\ub97c \uc81c\uac70\ud558\uc138\uc694";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "\ub300\uc2e0 <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a>\ub97c \ub2e4\uc6b4\ub85c\ub4dc\ud558\uc5ec \uc124\uce58\ud558\uc138\uc694 (Sinytra Connector\uc640 \ud638\ud658\ub428)";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "\ubaa8\ub4e0 \uc5f0\uacb0 \ubaa8\ub4dc(Sinytra Connector \ub4f1)\uac00 \ucd5c\uc2e0 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ub418\uc5c8\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uce58\uba85\uc801 \uc624\ub958: '" + modId + "' \ubaa8\ub4dc\uc758 JEI \ud50c\ub7ec\uadf8\uc778 \ub85c\ub529 \uc2e4\ud328. \ud074\ub798\uc2a4 '" + nombreClase + "' (\ud50c\ub7ec\uadf8\uc778 ID: '" + pluginId + "') \uac00 \uc624\ub958\ub97c \ubc1c\uc0dd\uc2dc\ucf1c \uac8c\uc784 \uc2dc\uc791 \uc911 \ucda9\ub3cc\uc774 \ubc1c\uc0dd\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uac8c\uc784 \ucd08\uae30\ud654\ub97c \ubc29\ud574\ud558\ub294 \ud638\ud658\ub418\uc9c0 \uc54a\uac70\ub098 \uc190\uc0c1\ub41c JEI \ud1b5\ud569\uc744 \ubaa8\ub4dc\uac00 \uac00\uc9c0\uace0 \uc788\uc744 \ub54c \uc774 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "JEI \ud50c\ub7ec\uadf8\uc778 \uc2e4\ud328 - \ucda9\ub3cc \uc720\ubc1c";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "\ubaa8\ub4dc <b>" + modId + "</b> \uc5d0 \ubb38\uc81c\uac00 \uc788\ub294 JEI \ud50c\ub7ec\uadf8\uc778\uc774 \ud3ec\ud568\ub418\uc5b4 \ucda9\ub3cc\uc744 \uc77c\uc73c\ud0a4\uace0 \uc788\uc2b5\ub2c8\ub2e4. <b>\ubaa8\ub4dc \ud2b8\ub9ac</b> \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud558\uc5ec \ubb38\uc81c\ub97c \uc77c\uc73c\ud0a4\ub294 \ubaa8\ub4dc\ub97c \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "\ucda9\ub3cc\uc774 \ud574\uacb0\ub418\ub294\uc9c0 \ud655\uc778\ud558\uae30 \uc704\ud574 \ubaa8\ub4dc \ud3f4\ub354\uc5d0\uc11c \uc77c\uc2dc\uc801\uc73c\ub85c \ubaa8\ub4dc <b>" + modId + "</b> \ub97c \uc81c\uac70\ud558\uc138\uc694";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "\ubaa8\ub4dc <b>" + modId + "</b> \uc758 \uc5c5\ub370\uc774\ud2b8\ub97c \ucc3e\uac70\ub098 JEI \ud50c\ub7ec\uadf8\uc778 \ubb38\uc81c\ub97c \uac1c\ubc1c\uc790\uc5d0\uac8c \ubcf4\uace0\ud558\uc138\uc694. \uadf8\ub3d9\uc548 \uac8c\uc784\uc744 \uc2dc\uc791\ud558\ub824\uba74 \ubaa8\ub4dc\ub97c \uc81c\uac70\ud574\uc57c \ud569\ub2c8\ub2e4";
    }

    @Override
    public String tituloLectador() {
        return "\ub85c\uadf8 \ub9ac\ub354 - \ucda9\ub3cc \ud0d0\uc9c0\uae30";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "\uc0c9\uc0c1 \ubc94\ub840";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "\uce58\uba85\uc801 \uc624\ub958";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "\uc2a4\ud0dd \ud2b8\ub808\uc774\uc2a4";
    }

    @Override
    public String obtenerTituloError() {
        return "\uc624\ub958";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "\uc120\ud0dd\ud55c \uc904\uc744 \ucc98\ub9ac\ud558\ub294 \ub3c4\uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String obtenerNombreError() {
        return "\uc624\ub958 \uc774\ub984";
    }

    @Override
    public String obtenerDescripcionError() {
        return "\uc790\uc138\ud55c \uc124\uba85";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "\ub85c\uadf8 \uc120\ud0dd";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "\ubbf8\ud655\uc778 \uc624\ub958";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "\uae30\ub85d\uc5d0\uc11c \uce58\uba85\uc801\uc778 \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uadfc\ubcf8 \uc6d0\uc778\uc744 \ud30c\uc545\ud558\ub824\uba74 \uc2a4\ud0dd \ud2b8\ub808\uc774\uc2a4\ub97c \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "\uae30\ub85d \ud30c\uc77c\uc744 \uc77d\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uace0 \uc77d\uae30 \uad8c\ud55c\uc774 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "\ub85c\uadf8 \ubd84\uc11d\uae30";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\uce58\uba85\uc801 \uc624\ub958: '").append(modId).append("' \ubaa8\ub4dc\uc758 \uc790\ub3d9 \uc774\ubca4\ud2b8 \uad6c\ub3c5\uc790 \ub4f1\ub85d\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. ");
        mensaje.append("\ubb38\uc81c \uc788\ub294 \ud074\ub798\uc2a4: <b>").append(nombreClase).append("</b>. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\uc774 \ud074\ub798\uc2a4\ub294 \ub2e4\uc74c \uc704\uce58\uc5d0 \uc788\uc2b5\ub2c8\ub2e4: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \uae30\ud0c0...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\ubaa8\ub4dc\uac00 \uc774\ubca4\ud2b8 \uad6c\ub3c5\uc790\ub85c \ud074\ub798\uc2a4\ub97c \uc790\ub3d9 \ub4f1\ub85d\ud558\ub824 \ud558\uc9c0\ub9cc \ud074\ub798\uc2a4\ub97c \ub85c\ub4dc\ud560 \uc218 \uc5c6\uc744 \ub54c \uc774 \uc624\ub958\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. ");
        mensaje.append("<b>\ub85c\uadf8\uc5d0\uc11c \uc774 \uba54\uc2dc\uc9c0 \uc774\uc804\uc758 \ub2e4\ub978 \uc624\ub958\ub97c \ud655\uc778\ud558\uc138\uc694. \uc2e4\uc81c \uc6d0\uc778\uc740 \uc774\uc804 \ub85c\ub4dc \uc2e4\ud328\uc77c \uc218 \uc788\uc2b5\ub2c8\ub2e4</b>.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "\uc790\ub3d9 \uad6c\ub3c5\uc790 \ub4f1\ub85d \uc2e4\ud328";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "\ubaa8\ub4dc <b>" + modId + "</b>\uac00 \ud074\ub798\uc2a4 <b>" + nombreClase + "</b>\ub97c \uc790\ub3d9 \uad6c\ub3c5\uc790\ub85c \ub4f1\ub85d\ud558\ub824 \ud558\uc9c0\ub9cc \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc774 \ud074\ub798\uc2a4\uac00 \uc874\uc7ac\ud558\uace0 \uc811\uadfc \uac00\ub2a5\ud55c\uc9c0 \ud655\uc778\ud558\uc138\uc694";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\ubb38\uc81c \uc788\ub294 \ud074\ub798\uc2a4 <b>" + nombreClase + "</b>\ub294 \ub2e4\uc74c \ud30c\uc77c\uc5d0 \uc788\uc2b5\ub2c8\ub2e4: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \uae30\ud0c0...");
            }
            paso.append("</b>. ");
            paso.append("<b>\ubaa8\ub4dc \ud2b8\ub9ac</b> \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud574 \ubb38\uc81c \uc788\ub294 \ud074\ub798\uc2a4\ub97c \ud3ec\ud568\ud55c \uc815\ud655\ud55c \ud30c\uc77c\uc744 \ud655\uc778\ud558\uc138\uc694");
            return paso.toString();
        }
        return "\ud074\ub798\uc2a4 <b>" + nombreClase + "</b>\uac00 \uc5b4\ub5a4 \ubaa8\ub4dc \ud30c\uc77c\uc5d0\ub3c4 \uc5c6\uc2b5\ub2c8\ub2e4. \ubaa8\ub4dc <b>" + modId + "</b>\uac00 \uc62c\ubc14\ub974\uac8c \uc124\uce58\ub418\uc5c8\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694. <b>\ubaa8\ub4dc \ud2b8\ub9ac</b> \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud574 \ubb38\uc81c\ub97c \ucc3e\uc73c\uc138\uc694";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "\ubaa8\ub4dc <b>" + modId + "</b>\ub97c \uc0ac\uc6a9 \uc911\uc778 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc0f \ud3ec\uc9c0 \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294 \ucd5c\uc2e0 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694. \ubb38\uc81c\uac00 \uc9c0\uc18d\ub418\uba74 \uac1c\ubc1c\uc790\uc5d0\uac8c \ubb38\uc81c \ud074\ub798\uc2a4\uc640 \ud568\uaed8 \uc624\ub958\ub97c \ubcf4\uace0\ud558\uc138\uc694";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "<b>\ub85c\uadf8\uc758 \uc774 \uba54\uc2dc\uc9c0 \uc774\uc804 \uc624\ub958\ub4e4</b>\uc744 \ud655\uc778\ud558\uc138\uc694. \uc2e4\uc81c \ubb38\uc81c\ub294 \uc774\uc804 \ub85c\ub4dc \uc2e4\ud328\uc77c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \ub54c\ub54c\ub85c \uc774\uc804 \uc624\ub958\uac00 \uc774\ubca4\ud2b8 \ub4f1\ub85d\uc5d0 \ud544\uc694\ud55c \ud074\ub798\uc2a4 \ub85c\ub4dc\ub97c \ubc29\ud574\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String limpiado() {
        return "\uc815\ub9ac\ub428";
    }

    @Override
    public String original() {
        return "\uc6d0\ubcf8";
    }

    @Override
    public String verEnConsola() {
        return "\ub85c\uadf8\uc5d0\uc11c \ubcf4\uae30";
    }

    @Override
    public String advertencia() {
        return "\uacbd\uace0";
    }

    @Override
    public String fatal() {
        return "\uce58\uba85\uc801";
    }

    @Override
    public String noRegistroDeBattly() {
        return "BattlyLauncher\uc5d0\ub294 \ubcf5\uc0ac\ud560 \uc218 \uc788\ub294 \ub85c\uadf8\ub098 \ucf58\uc194\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \uac8c\uc784\uc744 \uc7ac\uc2dc\uc791\ud558\uba74\uc11c STDOUT\uacfc STDERR\ub97c \uac00\ub85c\ucc44\uae30 \uc704\ud574 ProxySysOutSysErr\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc788\uc9c0\ub9cc, STDOUT\uc774\ub098 STDERR\ub97c \uc218\uc815\ud558\ub294 \ubaa8\ub4dc\uc640 \ucda9\ub3cc\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "NightWorld \uc124\uc815\uc5d0\uc11c \ub514\ubc84\uadf8 \ubaa8\ub4dc\ub97c \ud65c\uc131\ud654\ud558\uc5ec \ub7f0\ucc98 \ub85c\uadf8\ub97c \ud655\ubcf4\ud574\uc57c \ud569\ub2c8\ub2e4. \ud2b9\ud788 STDOUT\uacfc STDERR\ub97c \ud3ec\ud568\ud558\uae30 \ub54c\ubb38\uc5d0 \ub9e4\uc6b0 \uc911\uc694\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "\uc11c\ubc84 \ud130\ubbf8\ub110\uc758 \ub0b4\uc6a9\uc744 \uc800\uc7a5\ud558\uac70\ub098 \ubd99\uc5ec\ub123\uc5b4\uc57c \ud569\ub2c8\ub2e4. \ub2e4\ub978 \ub85c\uadf8\uc5d0\ub294 \uc5c6\ub294 \uc815\ubcf4(\uc608: STDOUT, STDERR \ubc0f \uae30\ud0c0 \uc624\ub958)\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uae30 \ub54c\ubb38\uc785\ub2c8\ub2e4. \ucd5c\uadfc \uc138\uc158\uc758 \ub0b4\uc6a9\uc744 \ubd99\uc5ec\ub123\uc5b4 \uc8fc\uc138\uc694. \uc55e\uc73c\ub85c\ub294 \ub9e4\ubc88 \ubd99\uc5ec\ub123\uc9c0 \uc54a\ub3c4\ub85d \ud558\ub824\uba74 \uba85\ub839\uc5b4 \ub4a4\uc5d0 >> cd_launcherlog\ub97c \ucd94\uac00\ud558\uc5ec \ud130\ubbf8\ub110 \ucd9c\ub825\uc744 \ud30c\uc77c\uc5d0 \uc800\uc7a5\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4(\uc774\ubbf8\uc9c0 \ucc38\uc870). \uc774\ub807\uac8c \ud558\uba74 \ud130\ubbf8\ub110\uc5d0 \ud45c\uc2dc\ub418\uc9c0 \uc54a\uace0 \ud574\ub2f9 \ud30c\uc77c\uc5d0\ub9cc \uae30\ub85d\ub429\ub2c8\ub2e4.";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("\uce58\uba85\uc801 \uc624\ub958: NeoForge \ud658\uacbd\uc5d0\uc11c LexForge \ubcc0\ud658\uae30\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. ");
        sb.append("</b>");
        sb.append("\uad00\ub828 \ud074\ub798\uc2a4: <b>").append(claseReceptora).append("</b>. ");
        sb.append("\uc601\ud5a5\uc744 \ubc1b\ub294 \uc778\ud130\ud398\uc774\uc2a4\ub294 <b>").append(interfazObjetivo).append("</b>\uc774\uba70, ");
        sb.append("\ub2e4\uc74c \uba54\uc11c\ub4dc\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4: <b>").append(firmaMetodoFaltante).append("</b>. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\ud074\ub798\uc2a4 \uc704\uce58: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \uae30\ud0c0...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("\ud574\ub2f9 \ud074\ub798\uc2a4\ub97c \ud3ec\ud568\ud558\ub294 JAR \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uadf8\ub9bc\uc790 \ucc98\ub9ac\ub418\uc5c8\uac70\ub098 jar-in-jar\ub85c \ud3ec\ud568\ub418\uc5c8\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4. ");
        }
        sb.append("MinecraftForge/LexForge\uc6a9\uc73c\ub85c \ucef4\ud30c\uc77c\ub41c ModLauncher \ubcc0\ud658\uae30/\uc11c\ube44\uc2a4\uac00 ");
        sb.append("\ud638\ud658\ub418\uc9c0 \uc54a\ub294 ModLauncher API \ubc84\uc804\uacfc \ud568\uaed8 NeoForge\uc5d0\uc11c \ub85c\ub4dc\ub420 \ub54c \uc774 \uc624\ub958\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. ");
        sb.append("NeoForge \uc804\uc6a9 \ubc84\uc804\uc73c\ub85c \uad6c\uc131 \uc694\uc18c\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uad50\uccb4\ud558\uc138\uc694.");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "NeoForge\uc5d0\uc11c \uc0ac\uc6a9\ub41c LexForge \ubcc0\ud658\uae30";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "\ube44\ud638\ud658 \ubcc0\ud658\uae30\ub97c \uc2dd\ubcc4\ud558\uc138\uc694: <b>" + claseReceptora + "</b>. \uae30\ub300\ub418\ub294 API\ub294 <b>" + interfazObjetivo + "</b>\uc774\uba70, \ub2e4\uc74c\uc774 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4: <b>" + firmaMetodoFaltante + "</b>. Mod\uac00 <b>META-INF/services</b>\uc5d0 \uc774 \ud074\ub798\uc2a4\ub97c \ub4f1\ub85d\ud588\ub294\uc9c0 \ud655\uc778\ud558\uace0, NeoForge\uc5d0\uc11c \uc81c\uac70\ud558\uac70\ub098 \ube44\ud65c\uc131\ud654\ud558\uc138\uc694.";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\uad00\ub828 \ubaa8\ub4dc \uc704\uce58: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \uae30\ud0c0...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("\ud574\ub2f9 \ud074\ub798\uc2a4\ub97c \ud3ec\ud568\ud558\ub294 JAR\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. jar-in-jar \ubc0f \uc250\ub3c4\uc789\ub41c \uc885\uc18d\uc131\uc744 \ud655\uc778\ud558\uc138\uc694. ");
        }
        sb.append("\uc77c\uc2dc\uc801\uc73c\ub85c \ud574\ub2f9 JAR\ub97c \uc81c\uac70\ud558\uac70\ub098 NeoForge \ud638\ud658 \ubc84\uc804\uc744 \uc0ac\uc6a9\ud558\uc5ec \uc6d0\uc778\uc744 \ud655\uc778\ud558\uc138\uc694.");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "\uad6c\uc131 \uc694\uc18c\ub97c NeoForge \uc804\uc6a9 \ubc84\uc804\uc73c\ub85c \uad50\uccb4\ud558\uac70\ub098, NeoForge\uc5d0\uc11c \uc0ac\uc6a9\ud558\ub294 ModLauncher \ubc84\uc804\uc744 \uae30\uc900\uc73c\ub85c \ub2e4\uc2dc \ucef4\ud30c\uc77c\ud558\uc138\uc694. \uc624\ub798\ub41c LexForge/MinecraftForge \ubc14\uc774\ub108\ub9ac\ub97c \ud53c\ud558\uc138\uc694.";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "Mods \ud3f4\ub354\ub97c \uc815\ub9ac\ud558\uace0 \uc911\ubcf5\ub41c jar-in-jar \ud56d\ubaa9\uc744 \uc81c\uac70\ud558\uc138\uc694. \ud544\uc694 \uc2dc \ub7f0\ucc98 \uce90\uc2dc\ub97c \uc0ad\uc81c\ud558\uace0 \uc7ac\uc2dc\uc791\ud558\uc5ec LexForge \ubcc0\ud658\uae30\uac00 \ub354 \uc774\uc0c1 \ub85c\ub4dc\ub418\uc9c0 \uc54a\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia\ub97c \uc2dc\uc791\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: Xenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b> ");
        sb.append("Xenon\uc744 \uc81c\uac70\ud558\uace0 Embeddium \ub610\ub294 Sodium\uc744 \uc0ac\uc6a9\ud558\uc138\uc694. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\ubc1c\uacac \uc704\uce58: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \uae30\ud0c0...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia\uc640 Xenon \ubd88\ud638\ud658";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return label + "\uc774(\uac00) WaterMedia\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ud504\ub85c\ud544\uc5d0\uc11c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("\uc704\uce58: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \uae30\ud0c0...");
            }
            sb.append("</b>. \ud574\ub2f9 JAR \ud30c\uc77c\uc744 \uc0ad\uc81c\ud558\uc138\uc694.");
            return sb.toString();
        }
        return "JAR \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. mods \ud3f4\ub354\ub97c \ud655\uc778\ud558\uace0 Xenon\uc744 \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "Embeddium \ub610\ub294 Sodium\uc744 \ub300\uccb4\ub85c \uc124\uce58\ud558\uace0 \uac8c\uc784\uc744 \uc7ac\uc2dc\uc791\ud558\uc138\uc694.";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "\uc555\ucd95 \uc624\ub958 (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>TACZ \ub9ac\uc18c\uc2a4 \ubcf5\uc0ac \ub3c4\uc911 Deflater\uac00 \uc885\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\uad00\ub828\ub41c \ud56d\ubaa9: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \uae30\ud0c0");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>\ud574\uacb0 \ubc29\ubc95:</b> <code>tacz/tacz-pre.toml</code>\uc5d0\uc11c <code>DefaultPackDebug=true</code>\ub85c \uc124\uc815\ud558\uc138\uc694. ").append("\ud544\uc694\uc2dc \uba3c\uc800 \ub9f5\uc744 \uc0dd\uc131\ud55c \ud6c4 \ud65c\uc131\ud654\ud558\uc138\uc694.");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "tacz/tacz-pre.toml\uc5d0\uc11c DefaultPackDebug=true\ub85c \uc124\uc815\ud558\uc138\uc694. \ud544\uc694\ud558\uba74 \uba3c\uc800 \ub9f5\uc744 \uc0dd\uc131\ud558\uace0 \ud65c\uc131\ud654\ud558\uc138\uc694.";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "\ubc00\ub3c4 \ud568\uc218 \ubbf8\ubc14\uc778\ub529";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>\ub808\uc9c0\uc2a4\ud2b8\ub9ac\uc5d0 \ubc00\ub3c4 \ud568\uc218\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("\ub204\ub77d\ub428: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append(". ");
        }
        sb.append("<br/><b>\ud574\uacb0 \ubc29\ubc95:</b> \ud574\ub2f9 \ud568\uc218\ub97c \uc815\uc758\ud558\ub294 mod/datapack\uc744 \uc124\uce58\ud558\uac70\ub098 \ud65c\uc131\ud654\ud558\uace0 \uc7ac\uc2dc\uc791\ud558\uc138\uc694. \uc774 \ubb38\uc81c\uc758 \ub610 \ub2e4\ub978 \ud754\ud55c \uc6d0\uc778\uc740 \ud544\uc694\ud55c mod\ub294 \uc124\uce58\ud588\uc9c0\ub9cc, \uadf8 mod\uc5d0 \ubb38\uc81c\uac00 \uc788\uac70\ub098 \ub2e4\ub978 mod\uc640 \ucda9\ub3cc\ud558\ub294 \uacbd\uc6b0\uc785\ub2c8\ub2e4. \uc608\ub97c \ub4e4\uc5b4, Terralith\ub294 \ub9ce\uc740 \ubb38\uc81c\ub97c \uc77c\uc73c\ud0a4\uba70 \uc774 \uc624\ub958\uc640 JSON \uc624\ub958\ub97c \ud3ec\ud568\ud55c \ub2e4\uc591\ud55c \ubb38\uc81c\ub97c \uc720\ubc1c\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "\ud574\ub2f9 \ud568\uc218\ub97c \uc81c\uacf5\ud558\ub294 \ubaa8\ub4dc/\ub370\uc774\ud130\ud329\uc744 \uc124\uce58\ud558\uac70\ub098 \ud65c\uc131\ud654\ud558\uace0 \uac8c\uc784\uc744 \uc7ac\uc2dc\uc791\ud558\uc138\uc694.";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub4f1\ub85d \ud56d\ubaa9\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c: ").append(claveFaltante).append(". ");
        sb.append("Create 6\uc6a9 Steam & Railways \uc54c\ud30c \ubc84\uc804\uc5d0\uc11c \uc790\uc8fc \ubc1c\uc0dd\ud569\ub2c8\ub2e4.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (\uc54c\ud30c)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "Create 6\uc6a9 Steam & Railways \uc54c\ud30c \ubc84\uc804\uc744 \ud638\ud658 \uac00\ub2a5\ud55c \ubc84\uc804\uc73c\ub85c \uc81c\uac70\ud558\uac70\ub098 \uad50\uccb4\ud558\uc138\uc694.";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\ub85c\ub529 \ucda9\ub3cc: Multiworld\uc640 Sodium/Embeddium/Rubidium \ud568\uaed8 \uc0ac\uc6a9 \uc2dc ").append("IncompatibleClassChangeError (FabricLoader.getInstance) \ubc1c\uc0dd. ").append("\uad8c\uc7a5: Multiworld \ub610\ub294 \uc131\ub2a5 \ubaa8\ub4dc \uc911 \ud558\ub098\ub97c \uc81c\uac70\ud558\uac70\ub098 \ud638\ud658\ub418\ub294 \ubc84\uc804\uc744 \uc0ac\uc6a9\ud558\uc138\uc694.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "\ucda9\ub3cc: Multiworld\uacfc \uc131\ub2a5 \ubaa8\ub4dc";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "Multiworld \ub610\ub294 Sodium/Embeddium/Rubidium\uc744 \uc81c\uac70\ud558\uac70\ub098, \uc11c\ub85c \ud638\ud658\ub418\ub294 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium\uc774 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \uadf8\ub798\ud53d \ub4dc\ub77c\uc774\ubc84\ub97c \uac10\uc9c0\ud588\uc2b5\ub2c8\ub2e4. GPU \ub4dc\ub77c\uc774\ubc84\ub97c \ucd5c\uc18c \uc694\uad6c \uc0ac\uc591 \uc774\uc0c1\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 Sodium \uac00\uc774\ub4dc\ub97c \ub530\ub974\uc138\uc694.</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "OpenGL \ucee8\ud14d\uc2a4\ud2b8 \uc624\ub958";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenGL \uc2e4\ud328: \ud604\uc7ac \ucee8\ud14d\uc2a4\ud2b8\uac00 \uc5c6\uac70\ub098 \uc774 \ucee8\ud14d\uc2a4\ud2b8\uc5d0\uc11c \ud574\ub2f9 \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ube44\ub514\uc624 \ub4dc\ub77c\uc774\ubc84 \ubb38\uc81c\uc77c \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "GPU \ub4dc\ub77c\uc774\ubc84\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uc7ac\uc124\uce58\ud558\uace0 \uc7ac\uc2dc\uc791\ud558\uc138\uc694. \uc624\ubc84\ub808\uc774 \uae30\ub2a5\uc744 \ube44\ud65c\uc131\ud654\ud558\uace0 \uc131\ub2a5 \ubaa8\ub4dc \uc5c6\uc774 \uc2e4\ud589\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "\ub9c1\ud06c\uac00 \ud074\ub9bd\ubcf4\ub4dc\uc5d0 \ubcf5\uc0ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "\uc555\ucd95 \ud30c\uc77c \ub0b4\ubd80 \uac80\uc0c9 (.zip/.jar/.war/.ear/.fpm/.rar(\uc790\ubc14\uc6a9)*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud14d\uc2a4\ucc98 \ud574\uc0c1\ub3c4 \uc624\ub958: \ub2e4\uc74c\uc744 \uc870\uc815\ud560 \uc218 \uc5c6\uc74c " + recurso + " - \ud06c\uae30: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "\ud14d\uc2a4\ucc98 \ud574\uc0c1\ub3c4 \uc624\ub958";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "\uc774 \uc624\ub958\ub294 \ud14d\uc2a4\ucc98\uac00 \ub108\ubb34 \ud06c\uac70\ub098 \ub9ac\uc18c\uc2a4 \ud329\uc774 \uc9c0\ub098\uce58\uac8c \ub9ce\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ud574\uc0c1\ub3c4\uac00 \ub0ae\uc740 \ub9ac\uc18c\uc2a4 \ud329\uc744 \uc0ac\uc6a9\ud558\uac70\ub098 \uc77c\ubd80 \ub9ac\uc18c\uc2a4 \ud329\uc744 \uc81c\uac70\ud574 \ubcf4\uc138\uc694. \ud5c8\uc6a9\ub41c \ud574\uc0c1\ub3c4\ub97c \ucd08\uacfc\ud558\ub294 \ub9de\ucda4\ud615 \ud14d\uc2a4\ucc98\ub97c \ucd94\uac00\ud558\uc9c0 \uc54a\uc558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModLauncher \uc11c\ube44\uc2a4 \uc624\ub958: \uc798\ubabb\ub41c \ubb38\uc790\uac00 \ud3ec\ud568\ub41c \uacbd\ub85c. ModLauncher \uc11c\ube44\uc2a4\ub294 ASCII \uc774\uc678\uc758 \ubb38\uc790\ub098 \ud2b9\uc218 \ubb38\uc790\ub97c \ud3ec\ud568\ud55c \uacbd\ub85c\ub97c \ucc98\ub9ac\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ubb38\uc81c\uac00 \ub418\ub294 \ubb38\uc790\uc5d0\ub294 \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694 \uac00 \uc788\uc73c\uba70, \ud2b9\ud788 \uc774\ub984 \ub05d\uc5d0 \uc788\ub294 '\"' \ubb38\uc790\ub294 \ub9e4\uc6b0 \uce58\uba85\uc801\uc785\ub2c8\ub2e4. ModLauncher\uc5d0\uc11c \ud754\ud788 \uc0ac\uc6a9\ub418\ub294 \uc11c\ube44\uc2a4 \ucef4\ud3ec\ub10c\ud2b8\ub85c\ub294 CrashDetector, " + Config.obtenerInstancia().obtenerNombreCD() + ", FeatureCreep, Vivicraft, Optifine, Sodium, clonos, Iris Shaders/Oculus, MixerLogger, CrashAssistant \ubc0f Sintrya Connector \ub4f1\uc774 \uc788\uc2b5\ub2c8\ub2e4. \ubaa8\ub4e0 \uc11c\ube44\uc2a4\ub97c \uc81c\uac70\ud560 \uc218\ub294 \uc788\uc9c0\ub9cc, \uacbd\ub85c \uc774\ub984 \uc790\uccb4\ub85c \uc778\ud574 \ub2e4\ub978 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \ud574\uacb0 \ubc29\ubc95: \uacf5\ubc31\uc774\ub098 \ud2b9\uc218 \ubb38\uc790 \uc5c6\uc774 ASCII \ubb38\uc790(a-z, A-Z, 0-9)\ub9cc \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc778\uc2a4\ud134\uc2a4 \uc774\ub984\uc744 \ubcc0\uacbd\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "ModLauncher \uacbd\ub85c \uc624\ub958";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "\uc778\uc2a4\ud134\uc2a4 \uacbd\ub85c\uc5d0 ASCII\uac00 \uc544\ub2cc \ubb38\uc790\ub098 \ud2b9\uc218 \ubb38\uc790\uac00 \ud3ec\ud568\ub420 \uacbd\uc6b0 \uc774 \uc624\ub958\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. ModLauncher \uc11c\ube44\uc2a4\ub294 \uc774\ub7ec\ud55c \uacbd\ub85c\ub97c \ucc98\ub9ac\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ud574\uacb0 \ubc29\ubc95: \uc778\uc2a4\ud134\uc2a4 \uc774\ub984\uc744 ASCII \ubb38\uc790(a-z, A-Z, 0-9)\ub9cc \uc0ac\uc6a9\ud558\ub3c4\ub85d \ubc14\uafb8\uace0, \uacf5\ubc31\uacfc \ud2b9\uc218 \ubb38\uc790\ub294 \ud53c\ud558\uc138\uc694. \ud2b9\ud788 \uc774\ub984 \ub05d\uc5d0 \uc788\ub294 '\"' \ubb38\uc790\ub294 \ub9e4\uc6b0 \ubb38\uc81c\ub97c \uc77c\uc73c\ud0a4\ubbc0\ub85c \uc8fc\uc758 \uae4a\uac8c \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String tituloEditorCodice() {
        return "\ucf54\ub514\uccb4 \ud3b8\uc9d1\uae30";
    }

    @Override
    public String nuevo() {
        return "\uc0c8\ub85c \ub9cc\ub4e4\uae30";
    }

    @Override
    public String actualizarSeleccionado() {
        return "\uc120\ud0dd \ud56d\ubaa9 \uc5c5\ub370\uc774\ud2b8";
    }

    @Override
    public String eliminarSeleccionado() {
        return "\uc120\ud0dd \ud56d\ubaa9 \uc0ad\uc81c";
    }

    @Override
    public String exportarJSON() {
        return "JSON \ub0b4\ubcf4\ub0b4\uae30...";
    }

    @Override
    public String guardarTodo() {
        return "\ubaa8\ub450 \uc800\uc7a5";
    }

    @Override
    public String general() {
        return "\uc77c\ubc18";
    }

    @Override
    public String id() {
        return "ID";
    }

    @Override
    public String paraBuscar() {
        return "\uac80\uc0c9\ud560 \ud14d\uc2a4\ud2b8";
    }

    @Override
    public String filtro() {
        return "\ud544\ud130 (ID)";
    }

    @Override
    public String criticalidad() {
        return "\uc911\uc694\ub3c4 (\uacbd\uace0/\uc624\ub958/\uce58\uba85\uc801)";
    }

    @Override
    public String prioridad() {
        return "\uc6b0\uc120\uc21c\uc704";
    }

    @Override
    public String lista() {
        return "\uac80\uc0ac \ubaa9\ub85d";
    }

    @Override
    public String colIdioma() {
        return "\uc5b8\uc5b4";
    }

    @Override
    public String colNombre() {
        return "\uc774\ub984";
    }

    @Override
    public String colResultado() {
        return "\uacb0\uacfc";
    }

    @Override
    public String vistaJson() {
        return "JSON \ubbf8\ub9ac\ubcf4\uae30";
    }

    @Override
    public String idiomas() {
        return "\uc5b8\uc5b4 (\ubaa8\ub450 \ud544\uc218)";
    }

    @Override
    public String elegirFiltro() {
        return "\uc120\ud0dd...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "\ud544\ud130\ub97c \uc120\ud0dd\ud558\uc138\uc694";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "\uc0ac\uc6a9 \uac00\ub2a5\ud55c \ud544\ud130";
    }

    @Override
    public String faltanCampos() {
        return "\ubaa8\ub4e0 \ud544\uc218 \uc77c\ubc18 \ud56d\ubaa9\uc744 \uc785\ub825\ud558\uc138\uc694.";
    }

    @Override
    public String critInvalida() {
        return "\uc798\ubabb\ub41c \uc911\uc694\ub3c4\uc785\ub2c8\ub2e4. ADVERTENCIA(\uacbd\uace0), ERROR(\uc624\ub958), FATAL(\uce58\uba85\uc801) \uc911 \ud558\ub098\ub97c \uc0ac\uc6a9\ud558\uc138\uc694.";
    }

    @Override
    public String filtroNoExiste() {
        return "\uc9c0\uc815\ud55c \ud544\ud130\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String faltanIdiomas() {
        return "\ubaa8\ub4e0 \uc5b8\uc5b4\uc5d0 \ub300\ud574 \uc774\ub984\uacfc \uacb0\uacfc\ub97c \uc785\ub825\ud558\uc138\uc694:";
    }

    @Override
    public String verificacionInvalida() {
        return "\uac80\uc0ac \ud56d\ubaa9\uc774 \uc798\ubabb\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ud544\ub4dc\ub97c \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String guardadoOk() {
        return "\uc800\uc7a5 \uc644\ub8cc.";
    }

    @Override
    public String editorCodiceBoton() {
        return "\uc774\uc720 \ucd94\uac00";
    }

    @Override
    public String descripcionEditorCodice() {
        return "\uc5ec\uae30\uc5d0 \uc774\uc720\ub97c \ub4f1\ub85d\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. ID\uac00 \ud544\uc694\ud558\uba70, \ud2b9\uc218 \ubb38\uc790, \uc545\uc13c\ud2b8 \uae30\ud638, \uacf5\ubc31 \uc5c6\uc774 \ubb38\uc790\uc5f4\ub85c \uc791\uc131\ud574\uc57c \ud569\ub2c8\ub2e4. \ud544\ud130\uc5d0\ub294 \"\uc904 \ud3ec\ud568\"\uc744 \uc0ac\uc6a9\ud558\uc5ec \uc904 \ub0b4 \ubb38\uc790\uc5f4 \uac80\uc0c9, \"\uc804\uccb4 \ud3ec\ud568\"\uc740 \ub85c\uadf8 \uc804\uccb4\uc5d0 \ud2b9\uc815 \ubb38\uc790\uc5f4\uc774 \uc788\ub294\uc9c0 \ud655\uc778, \"\uc815\uaddc\uc2dd \uc904\"\uc740 \uc904 \ub2e8\uc704 \uc815\uaddc\uc2dd \ub9e4\uce6d, \"\uc815\uaddc\uc2dd \uc804\uccb4\"\ub294 \uc804\uccb4 \ub85c\uadf8\uc5d0\uc11c \uc815\uaddc\uc2dd \uac80\uc0c9(\uc904 \ub2e8\uc704 \ubc84\uc804 \uc0ac\uc6a9 \uad8c\uc7a5)\uc744 \ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc0c9\uc0c1\uc744 \uc9c0\uc815\ud558\ub824\uba74 FATAL(\uce58\uba85\uc801), ERROR(\uc624\ub958), ADVERTENCIA(\uacbd\uace0) \uc911 \ud558\ub098\uc758 \uc911\uc694\ub3c4\ub97c \uc124\uc815\ud574\uc57c \ud569\ub2c8\ub2e4. \ubaa8\ub4e0 \uc5b8\uc5b4\uc5d0 \ub300\ud574 \ud654\uba74\uc5d0 \ud45c\uc2dc\ub420 \uc774\ub984\uacfc \uacb0\uacfc\ub97c \uc785\ub825\ud574\uc57c \ud569\ub2c8\ub2e4. \uac80\uc0ac \ud56d\ubaa9\uc744 \ucd94\uac00\ud558\uac70\ub098 \uc0ad\uc81c\ud560 \uc218 \uc788\uc73c\uba70, \uc644\ub8cc \uc2dc \uc800\uc7a5\ub429\ub2c8\ub2e4.";
    }

    @Override
    public String descartarCambios() {
        return "\ud604\uc7ac \uac80\uc0ac\uc5d0\uc11c \uc800\uc7a5\ub418\uc9c0 \uc54a\uc740 \ubcc0\uacbd \uc0ac\ud56d\uc744 \ucde8\uc18c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
    }

    @Override
    public String confirmacion() {
        return "\ud655\uc778";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\ub098\uac00\uae30 \uc804\uc5d0 \ubcc0\uacbd \uc0ac\ud56d\uc744 \uc800\uc7a5\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
    }

    @Override
    public String salirSinGuardar() {
        return "\uc800\uc7a5\ud558\uc9c0 \uc54a\uace0 \ub098\uac00\uae30";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\uce58\uba85\uc801 \uc624\ub958: modlauncher \uc11c\ube44\uc2a4(IDependencyLocator) \ub85c\ub529 \uc2e4\ud328.<br>");
        sb.append("\ud83d\udd39 <b>\ubb38\uc81c \ud074\ub798\uc2a4:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>\uc601\ud5a5\ubc1b\uc740 \ubaa8\ub4dc:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>\ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b> \ucd5c\uadfc \uc124\uce58\ud55c \ubaa8\ub4dc, \uac1c\ubc1c \uc911\uc778 \ubaa8\ub4dc \ub610\ub294 \uc798\ubabb \ud328\ud0a4\uc9d5\ub41c \ubaa8\ub4dc\ub97c \ud655\uc778\ud558\uc138\uc694.<br>");
        }
        sb.append("\ud83d\udd38 <b>\uc6d0\uc778:</b> \ubaa8\ub4dc\uc758 <code>META-INF/services/...</code> \ud30c\uc77c\uc774 \uc190\uc0c1\ub418\uc5c8\uac70\ub098, ");
        sb.append("\ud604\uc7ac Forge/NeoForge \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uac70\ub098, \uc798\ubabb\ub41c \ubc84\uc804\uc6a9 \ubaa8\ub4dc\uc785\ub2c8\ub2e4.<br>");
        sb.append("\ud83d\udd38 <b>\uacb0\uacfc:</b> Forge/NeoForge\uac00 \ubaa8\ub4dc\uc758 \uc758\uc874\uc131\uc744 \ub4f1\ub85d\ud560 \uc218 \uc5c6\uc5b4 ");
        sb.append("\uac8c\uc784 \uc2dc\uc791\uc774 \ucc28\ub2e8\ub429\ub2c8\ub2e4.<br>");
        sb.append("\ud83d\udd38 <b>\ud574\uacb0\ucc45:</b> \ubb38\uc81c \uc788\ub294 \ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8, \uc7ac\uc124\uce58 \ub610\ub294 \uc0ad\uc81c\ud558\uc138\uc694. ");
        sb.append("\uac1c\ubc1c \uc911\uc778 \ubaa8\ub4dc\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0 \uc815\ud655\ud55c Forge/NeoForge \ubc84\uc804\uc5d0 \ub9de\uac8c \ucef4\ud30c\uc77c\ub418\uc5c8\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "\uc11c\ube44\uc2a4 \uad6c\uc131 \uc624\ub958 (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. \uc6d0\uc778 \ubaa8\ub4dc \uc2dd\ubcc4: \ucd5c\uadfc \uc124\uce58\ud558\uac70\ub098 \uac1c\ubc1c \uc911\uc778 \ubaa8\ub4dc\ub97c \ud655\uc778\ud558\uc138\uc694.";
        }
        return "1. \ubb38\uc81c\uac00 \uc788\ub294 \ubaa8\ub4dc\ub294: " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. \ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8, \uc7ac\uc124\uce58 \ub610\ub294 \uc0ad\uc81c\ud558\uc138\uc694. Forge/NeoForge\uc640 \ud638\ud658\ub418\ub294 \ubc84\uc804\uc744 \uc0ac\uc6a9\ud558\uace0 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\uce58\uba85\uc801 \uc624\ub958: \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uba54\uc11c\ub4dc.</b><br>\ubaa8\ub4dc\uac00 <b style='color:#" + colorCodigo + "'>" + metodo + "</b> \uba54\uc11c\ub4dc\ub97c \ud638\ucd9c\ud558\ub824 \ud588\uc9c0\ub9cc, \uc774 \uba54\uc11c\ub4dc\ub294 \ud604\uc7ac \uac8c\uc784 \ub610\ub294 \ub2e4\ub978 \ubaa8\ub4dc \ubc84\uc804\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uba54\uc11c\ub4dc (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. \uc774 \uc624\ub958\ub294 \ubaa8\ub4dc\uac00 \ud604\uc7ac \uac8c\uc784 \ubc84\uc804\uc774\ub098 \ub2e4\ub978 \ubaa8\ub4dc\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. \uad00\ub828\ub41c \ubaa8\ub4e0 \ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694. \uc9c0\uc18d\ub418\uba74 \uc601\ud5a5\uc744 \ubc1b\uc740 \ubaa8\ub4dc\uc758 \uc81c\uc791\uc790\uc5d0\uac8c \uc624\ub958\ub97c \ubcf4\uace0\ud558\uc138\uc694.";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\uce58\uba85\uc801 \uc624\ub958: \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \ud544\ub4dc.</b><br>\ubaa8\ub4dc\uac00 <b style='color:#" + colorCodigo + "'>" + campo + "</b> \ud544\ub4dc\uc5d0 \uc811\uadfc\ud558\ub824 \ud588\uc9c0\ub9cc, \uc774 \ud544\ub4dc\ub294 \ud604\uc7ac \uac8c\uc784 \ub610\ub294 \ub2e4\ub978 \ubaa8\ub4dc \ubc84\uc804\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \ud544\ub4dc (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. \uc774 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ubaa8\ub4dc\uac00 \ud604\uc7ac \uac8c\uc784 \ubc84\uc804\uc774\ub098 \ub2e4\ub978 \ubaa8\ub4dc\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\uc744 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. \uc601\ud5a5\ubc1b\uc740 \ubaa8\ub4e0 \ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694. \ubb38\uc81c\uac00 \uacc4\uc18d\ub418\uba74 \uc624\ub958\ub97c \uc720\ubc1c\ud55c \ubaa8\ub4dc\uc758 \uac1c\ubc1c\uc790\uc5d0\uac8c \ubb38\uc758\ud558\uc138\uc694.";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\ub3c4\uc6c0\uc774 \ud544\uc694\ud558\uc2ed\ub2c8\uae4c?</strong><br>  \ud574\uacb0 \ubc29\ubc95\uc744 \ubaa8\ub974\uac70\ub098 \uc5ec\uae30\uc5d0 \uc6d0\uc778\uc774 \uc5c6\uc73c\uba74 \uc18c\uc15c \ubbf8\ub514\uc5b4\ub97c \ud1b5\ud574 \ub3c4\uc6c0\uc744 \ubc1b\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.   <img src='" + iconoCompartir + "' alt='\uacf5\uc720' style='height:12px;vertical-align:middle;'/>   <strong>\uacf5\uc720</strong> \ubc84\ud2bc\uc744 \uc0ac\uc6a9\ud558\uc5ec \ub85c\uadf8\uc640 \ubd84\uc11d \uacb0\uacfc \ub9c1\ud06c\ub97c \ud300\uc5d0 \uc804\ub2ec\ud558\uc138\uc694.   \ubaa8\ub4dc\ud329 \uc81c\uc791\uc790\ub098 \uae30\uad00\uc774\ub77c\uba74 <code>crash_detector/plantilla.htm</code> \ud30c\uc77c\uc744 \uc218\uc815\ud558\uc5ec   \ud300 \uc804\uc6a9 \ub9c1\ud06c\ub97c \ub9de\ucda4 \uc124\uc815\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "\ud15c\ud50c\ub9bf \ucd08\uae30\ud654";
    }

    @Override
    public String restablecer() {
        return "\ucd08\uae30\ud654";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return nombreImagen + "\uc744(\ub97c) \uae30\ubcf8\uac12\uc73c\ub85c \ucd08\uae30\ud654\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\ud15c\ud50c\ub9bf\uc744 \uae30\ubcf8\uac12\uc73c\ub85c \ucd08\uae30\ud654\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>AzureLib \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774\ubbf8 AzureLib\uc774 \uc788\ub2e4\uba74, 2025\ub144 10\uc6d4 8\uc77c \uc774\uc804 \ubc84\uc804\uc744 \uc124\uce58\ud558\uc138\uc694. \ud754\ud788 \ubc1c\uc0dd\ud558\ub294 \ubb38\uc81c\uc785\ub2c8\ub2e4. AzureLib\uc774 \uc5c6\ub2e4\uba74 \ucd5c\uc2e0 \ubc84\uc804\uc744 \uc124\uce58\ud558\uc138\uc694.</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\ubaa8\ub4dc <code>healight</code> \uac00 \uce58\uba85\uc801\uc778 \uc624\ub958\ub97c \ubc1c\uc0dd\uc2dc\ud0a4\uace0 \uc788\uc2b5\ub2c8\ub2e4: <code>java.lang.NoSuchFieldError: INT</code>. \uc774 \uc624\ub958\ub294 \ubaa8\ub4dc\uac00 MCForge 47.10 \uc774\uc0c1\uc758 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 1.20+ \ubc84\uc804\uc5d0\uc11c\ub294 \ub354 \uc774\uc0c1 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \ud544\ub4dc\uc5d0 \uc811\uadfc\ud558\ub824 \ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \uc774 \ubb38\uc81c\ub85c \uc778\ud574 \uac8c\uc784\uc744 \uc2dc\uc791\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 \ubaa8\ub4dc <code>healight</code> \ub97c \uc0ad\uc81c\ud558\uac70\ub098 \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694. \ud604\uc7ac \ubc84\uc804\uc740 1.20.1\uc6a9 MinecraftForge 47.10\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ubaa8\ub4dc\uc758 \ucd5c\uc2e0 \ubc84\uc804\uc744 \ucc3e\uac70\ub098 \ub300\uccb4 \uc635\uc158\uc744 \uace0\ub824\ud558\uc138\uc694.";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "\uce58\uba85\uc801 \uc624\ub958: healight - 'INT' \ud544\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("\ud074\ub798\uc2a4 <code>").append(clase).append("</code>\uac00 \ub2e4\uc74c \ud544\uc218 \uba54\uc11c\ub4dc\ub97c \uad6c\ud604\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4:<br>").append("<code>").append(metodo).append("</code><br>").append("\uc778\ud130\ud398\uc774\uc2a4 <code>").append(interfaz).append("</code>\uc5d0\uc11c \uc815\uc758\ub428.");
        if (!origen.isEmpty()) {
            sb.append("<br><br>\uc758\uc2ec\ub418\ub294 \ubaa8\ub4dc \ub610\ub294 \ud30c\uc77c: <code>").append(origen).append("</code>.");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 \uc774 \uc624\ub958\ub294 \ubaa8\ub4dc\uac00 \uc778\ud130\ud398\uc774\uc2a4\ub97c \uad6c\ud604\ud558\uc9c0\ub9cc \ud544\uc218 \uba54\uc11c\ub4dc\ub97c \uc0dd\ub7b5\ud560 \ub54c \ubc1c\uc0dd\ud569\ub2c8\ub2e4. <b>\ub450 \ubaa8\ub4dc \ubaa8\ub450</b> \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694 (\uc778\ud130\ud398\uc774\uc2a4\ub97c \uc815\uc758\ud558\ub294 \ubaa8\ub4dc\uc640 \uc774\ub97c \uad6c\ud604\ud558\ub294 \ubaa8\ub4dc). \uc5b4\ub5a4 \ubaa8\ub4dc\uc778\uc9c0 \ubaa8\ub974\uaca0\ub2e4\uba74 \uc624\ub958 \uba54\uc2dc\uc9c0\uc5d0 \ub098\ud0c0\ub09c \uc774\ub984\uc744 \ucc3e\uc544\ubcf4\uc138\uc694.";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "\uad6c\ud604\ub418\uc9c0 \uc54a\uc740 \uc778\ud130\ud398\uc774\uc2a4 \uba54\uc11c\ub4dc (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\ubaa8\ub4dc\uac00 <b>\uc804\uc6a9 \uc11c\ubc84</b>\uc5d0\uc11c <b>\ud074\ub77c\uc774\uc5b8\ud2b8 \uce21</b> \ud074\ub798\uc2a4\uc778 (<code>AnimationMetadataSection</code>)\ub97c \ub85c\ub4dc\ud558\ub824 \uc2dc\ub3c4\ud558\uace0 \uc788\uc73c\ub098, \uc774\ub294 \ubd88\uac00\ub2a5\ud569\ub2c8\ub2e4. \uc774 \uc624\ub958\ub294 \ubaa8\ub4dc\uac00 \ud074\ub77c\uc774\uc5b8\ud2b8\uc640 \uc11c\ubc84 \ucf54\ub4dc\ub97c \uc81c\ub300\ub85c \ubd84\ub9ac\ud558\uc9c0 \uc54a\uc558\uc744 \ub54c \uc790\uc8fc \ubc1c\uc0dd\ud569\ub2c8\ub2e4. <code>ModernFix</code>\uac00 \uc124\uce58\ub418\uc5b4 \uc788\uc73c\uba74 \uc774 \ubb38\uc81c\ub97c \ub4dc\ub7ec\ub0bc \uc218 \uc788\uc9c0\ub9cc, \uc9c1\uc811\uc801\uc778 \uc6d0\uc778\uc740 \uc544\ub2d9\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>\ube60\ub978 \ud574\uacb0\ucc45:</b> <code>ModernFix</code>\ub97c \uc784\uc2dc\ub85c \uc81c\uac70\ud558\uc5ec \uc11c\ubc84\uac00 \uc2dc\uc791\ub418\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694. \uc2dc\uc791\ub41c\ub2e4\uba74 \ubb38\uc81c\ub294 \ub2e4\ub978 \ubaa8\ub4dc\uac00 \uc11c\ubc84\uc5d0 \ud074\ub77c\uc774\uc5b8\ud2b8 \ud074\ub798\uc2a4\ub97c \ub85c\ub4dc\ud558\uace0 \uc788\uae30 \ub54c\ubb38\uc785\ub2c8\ub2e4.<br>\u2022 <b>\uc601\uad6c\uc801 \ud574\uacb0\ucc45:</b> \ubb38\uc81c\uc758 \uc6d0\uc778\uc774 \ub418\ub294 \ubaa8\ub4dc(\uc560\ub2c8\uba54\uc774\uc158 \ub9ac\uc18c\uc2a4, \ub9de\ucda4 \ud14d\uc2a4\ucc98 \ub610\ub294 \uadf8\ub798\ud53d \ub77c\uc774\ube0c\ub7ec\ub9ac\ub97c \uc0ac\uc6a9\ud558\ub294 \ubaa8\ub4dc)\ub97c \ucc3e\uc544 \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uc0ad\uc81c\ud558\uc138\uc694.<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "\uc11c\ubc84\uc5d0\uc11c \ud074\ub77c\uc774\uc5b8\ud2b8 \ud074\ub798\uc2a4 \ub85c\ub4dc\ub428 (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'><code>Sinytra Connector</code> \ubaa8\ub4dc\uc758 \uc124\uc815 \ud30c\uc77c\uc774 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac8c\uc784\uc774 \uc608\uae30\uce58 \uc54a\uac8c \uc885\ub8cc\ub418\uac70\ub098, \uc4f0\uae30 \uc624\ub958, \ubaa8\ub4dc \ucda9\ub3cc\ub85c \uc778\ud574 \ud30c\uc77c\uc5d0 \ub110 \ubb38\uc790(<code>\\u0000</code>)\uac00 \uac00\ub4dd \ucc28\ub294 \uacbd\uc6b0 \uc774 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \uc778\uc2a4\ud134\uc2a4\uc758 <code>config/</code> \ud3f4\ub354\ub85c \uc774\ub3d9\ud558\uc138\uc694.<br>\u2022 connector \uad00\ub828 \ubaa8\ub4dc\uc758 \uc124\uc815 \ud30c\uc77c\uc744 \ucc3e\uc544 \uc0ad\uc81c\ud558\uc138\uc694.<br>\u2022 \uac8c\uc784\uc744 \ub2e4\uc2dc \uc2dc\uc791\ud558\uc138\uc694: Sinytra Connector\uac00 \uc0c8\ub86d\uace0 \uae68\ub057\ud55c \uc124\uc815 \ud30c\uc77c\uc744 \uc0dd\uc131\ud560 \uac83\uc785\ub2c8\ub2e4.";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "Sinytra Connector \uc124\uc815 \uc190\uc0c1";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\ud30c\uc77c <code>" + nombreJar + "</code>\uc774(\uac00) \uc190\uc0c1\ub418\uc5c8\uac70\ub098 \ubd88\uc644\uc804\ud569\ub2c8\ub2e4.<br>ZIP \ud30c\uc77c\uc758 \ub9c8\uc9c0\ub9c9 \ud5e4\ub354\uac00 \ub204\ub77d\ub418\uc5b4 \uc2dc\uc2a4\ud15c\uc774 \ub0b4\uc6a9\uc744 \uc77d\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.<br>\uc774 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ub2e4\uc6b4\ub85c\ub4dc \uc911\ub2e8\uc774\ub098 \ub7f0\ucc98 \uc624\ub958 \ud6c4\uc5d0 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "\uc190\uc0c1\ub41c JAR \ud30c\uc77c (\ud2b9\uc815 \uc774\ub984 \ud3ec\ud568)";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>\uc190\uc0c1\ub41c \ud30c\uc77c\uc744 \uc0ad\uc81c</b>\ud558\uace0 \uacf5\uc2dd \ucd9c\ucc98(CurseForge, MinecraftStorage \ub4f1)\uc5d0\uc11c \ub2e4\uc2dc \ub2e4\uc6b4\ub85c\ub4dc\ud558\uc138\uc694.<br>\u2022 CurseForge, Technic \ub610\ub294 Luna Pixel \uac19\uc740 \ub7f0\ucc98\ub97c \uc0ac\uc6a9\ud55c\ub2e4\uba74, \ud30c\uc77c \ubb34\uacb0\uc131\uc744 \ub354 \uc798 \uac80\uc0ac\ud558\ub294 <b>ATLauncher</b> \ub610\ub294 <b>Prism Launcher</b>\ub85c \uc804\ud658\ud558\ub294 \uac83\uc744 \uace0\ub824\ud558\uc138\uc694.<br>\u2022 \ub2e4\uc6b4\ub85c\ub4dc \uc911 \uc778\ud130\ub137 \uc5f0\uacb0\uc774 \uc548\uc815\uc801\uc778\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\uc138\uacc4\ub97c \ubd88\ub7ec\uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. NBT \ud30c\uc77c \uc911 \ud558\ub098\uac00 \uc190\uc0c1\ub418\uc5c8\uae30 \ub54c\ubb38\uc785\ub2c8\ub2e4 (\uc608: <code>level.dat</code>, <code>playerdata/*.dat</code>, \ub610\ub294 \uccad\ud06c \ub370\uc774\ud130).<br>\uad6c\uccb4\uc801\uc778 \uc624\ub958\ub294 \ub2e4\uc74c\uacfc \uac19\uc2b5\ub2c8\ub2e4: <code>UTFDataFormatException: \ubc14\uc774\ud2b8 " + byteCorrupto + " \uadfc\ucc98\uc5d0\uc11c \uc798\ubabb\ub41c \uc785\ub825 \ud615\uc2dd</code>.<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f \ubcf5\uad6c \uc2dc\ub3c4 \uc804\uc5d0 \ubc18\ub4dc\uc2dc \uc138\uacc4 \ud3f4\ub354 \uc804\uccb4\ub97c \ubc31\uc5c5\ud558\uc138\uc694.</b><br><br>\uc190\uc0c1\ub41c \ud30c\uc77c\uc740 <b>NBT \ud3b8\uc9d1\uae30</b>(\uc608: <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>)\ub97c \uc0ac\uc6a9\ud574 \ubcf5\uad6c\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.<br>\uc2ec\uac01\ud558\uac8c \uc190\uc0c1\ub41c \uacbd\uc6b0, <b>\ud5e5\uc0ac \uc5d0\ub514\ud130</b>(HxD \ub4f1)\ub85c \ubb34\ud6a8 \ubc14\uc774\ud2b8\ub97c \uac80\uc0ac\ud558\uace0 \uc218\uc815\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4 (\ub2e8, NBT \ud615\uc2dd\uc5d0 \uc775\uc219\ud55c \uacbd\uc6b0\uc5d0\ub9cc \uad8c\uc7a5).<br>\ub9c8\uc9c0\ub9c9 \uc218\ub2e8\uc73c\ub85c \ubc31\uc5c5\ubcf8\uc5d0\uc11c \ubcf5\uc6d0\ud558\uac70\ub098, <code>FTB Backup</code> \ub4f1\uc758 MOD\uc5d0\uc11c \uc81c\uacf5\ud558\ub294 '\uc6d4\ub4dc \ubcf5\uad6c' \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud558\uc138\uc694.</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>\ubcf5\uad6c \uc2dc\ub3c4 \uc804\uc5d0 \uc138\uacc4 \ud3f4\ub354\ub97c \uc644\uc804\ud788 \ubc31\uc5c5\ud558\uc138\uc694</b>.<br>\u2022 NBT \ud3b8\uc9d1\uae30(NBT Studio \ub4f1)\ub97c \uc0ac\uc6a9\ud558\uc5ec \uc190\uc0c1\ub41c \ud30c\uc77c\uc744 \uc5f4\uace0 \uc218\uc815\ud558\uc138\uc694.<br>\u2022 \uc2e4\ud328\ud558\uba74 \ud5e5\uc0ac \uc5d0\ub514\ud130\ub85c \uc190\uc0c1\ub41c \ubc14\uc774\ud2b8 \uc704\uce58\ub97c \ud655\uc778\ud558\uc138\uc694.<br>\u2022 \uacbd\ud5d8\uc774 \uc5c6\ub2e4\uba74 \ucd5c\uadfc \ubc31\uc5c5\ubcf8\uc5d0\uc11c \ubcf5\uc6d0\ud558\uc138\uc694.";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "\uc138\uacc4 \uc190\uc0c1: NBT \ub370\uc774\ud130 \ub85c\ub4dc \uc624\ub958";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>OpenAL\uc5d0 \ubb38\uc81c\uac00 \uc788\uc2b5\ub2c8\ub2e4. \uac00\ub054 Nouveau \ub4dc\ub77c\uc774\ubc84\uac00 \uc6d0\uc778\uc77c \uc218 \uc788\uc9c0\ub9cc, \ub54c\ub85c\ub294 \uc560\ud50c\ub9ac\ucf00\uc774\uc158\uc758 OpenAL \ubc84\uc804\uc774 \ubc30\ud3ec\ud310\uc758 \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc544 \ubc30\ud3ec\ud310\uc5d0\uc11c \uc81c\uacf5\ud558\ub294 \ubc84\uc804\uc744 \uc0ac\uc6a9\ud574\uc57c \ud560 \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4. \uc774\ub294 \ud2b9\ud788 Red Hat \uacc4\uc5f4 \ubc30\ud3ec\ud310 \ubc0f Sound Physics Remastered \uac19\uc740 \uc0ac\uc6b4\ub4dc \ubaa8\ub4dc\uc640 \ud568\uaed8 \uc0ac\uc6a9\ud560 \ub54c \ud754\ud788 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ub354 \ub9ce\uc740 \ub3c4\uc6c0\uc744 \ubc1b\uc73c\ub824\uba74 \ub2e4\uc74c \uac00\uc774\ub4dc\ub97c \ucc38\uc870\ud558\uc138\uc694: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>\ub9ac\ub205\uc2a4\uc5d0\uc11c \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \uc0ac\uc6b4\ub4dc \ubb38\uc81c \ud574\uacb0 \ubc29\ubc95</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\uc11c\ubc84\ub97c \uc2dc\uc791\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc138\uacc4\uc758 \ud30c\uc77c\uc774 \ub2e4\ub978 \ud504\ub85c\uc138\uc2a4\uc5d0 \uc758\ud574 \uc7a0\uaca8 \uc788\uae30 \ub54c\ubb38\uc785\ub2c8\ub2e4.<br>\ub2e4\uc74c\uacfc \uac19\uc740 \uacbd\uc6b0\uc5d0 \ubc1c\uc0dd\ud569\ub2c8\ub2e4:<br>\u2022 \uc774\ubbf8 \uc11c\ubc84 \uc778\uc2a4\ud134\uc2a4\uac00 \uc2e4\ud589 \uc911\uc785\ub2c8\ub2e4.<br>\u2022 \ubc14\uc774\ub7ec\uc2a4 \ubc31\uc2e0 \ud504\ub85c\uadf8\ub7a8\uc774\ub098 \ud30c\uc77c \ud0d0\uc0c9\uae30\uac00 \uc138\uacc4 \ud3f4\ub354\ub97c \uc5f4\uace0 \uc788\uc2b5\ub2c8\ub2e4.<br>\u2022 \uc774\uc804 \ud504\ub85c\uc138\uc2a4\uac00 \uc815\uc0c1\uc801\uc73c\ub85c \uc885\ub8cc\ub418\uc9c0 \uc54a\uc544 \ud30c\uc77c\uc774 \uc7a0\uae34 \uc0c1\ud0dc\uc785\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>\ubaa8\ub4e0 \uc11c\ubc84 \uc778\uc2a4\ud134\uc2a4\ub97c \uc885\ub8cc\ud558\uc138\uc694</b> (javaw.exe\uc640 \uac19\uc740 \ubc31\uadf8\ub77c\uc6b4\ub4dc \ud504\ub85c\uc138\uc2a4 \ud3ec\ud568).<br>\u2022 \ud638\uc2a4\ud305 \ud328\ub110(Multicraft \ub4f1)\uc744 \uc0ac\uc6a9\ud55c\ub2e4\uba74 \ud328\ub110\uc5d0\uc11c \uc11c\ubc84\ub97c \uc644\uc804\ud788 \uc7ac\uc2dc\uc791\ud558\uc138\uc694.<br>\u2022 \ud30c\uc77c\uc744 \uc7a0\uadf8\uace0 \uc788\ub2e4\uace0 \uc758\uc2ec\ub418\uba74 <b>\ubc14\uc774\ub7ec\uc2a4 \ubc31\uc2e0\uc744 \uc77c\uc2dc\uc801\uc73c\ub85c \ube44\ud65c\uc131\ud654\ud558\uc138\uc694</b>.<br>\u2022 \ub85c\uceec \uc2dc\uc2a4\ud15c\uc5d0\uc11c\ub294 \uc138\uacc4 \ud3f4\ub354\ub97c \ud45c\uc2dc\ud558\ub294 \ubaa8\ub4e0 Windows \ud0d0\uc0c9\uae30 \ucc3d\uc744 \ub2eb\uc73c\uc138\uc694.<br>\u2022 \ubb38\uc81c\uac00 \uc9c0\uc18d\ub418\uba74, \uc138\uacc4 \ud3f4\ub354 \ub0b4\ubd80\uc758 <code>session.lock</code> \ud30c\uc77c\uc744 \uc218\ub3d9\uc73c\ub85c \uc0ad\uc81c\ud558\uc138\uc694 (\ub2e4\ub978 \uc11c\ubc84\uac00 \uc2e4\ud589 \uc911\uc774\uc9c0 \uc54a\ub2e4\ub294 \ud655\uc2e0\uc774 \uc788\uc744 \ub54c\ub9cc).";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "\ub2e4\ub978 \ud504\ub85c\uc138\uc2a4\uc5d0 \uc758\ud574 \uc7a0\uae34 \uc138\uacc4 \ud30c\uc77c";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\ubaa8\ub4dc\uac00 <code>" + clasePadreFinal + "</code> \ud074\ub798\uc2a4\ub97c \ud655\uc7a5\ud558\ub824 \ud588\uc9c0\ub9cc, \uc774 \ud074\ub798\uc2a4\ub294 \uc774\uc81c <b>final</b>\ub85c \uc124\uc815\ub418\uc5b4 \uc0c1\uc18d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.<br>\ubb38\uc81c\uac00 \uc788\ub294 \ud074\ub798\uc2a4\ub294: <code>" + claseHija + "</code>\uc785\ub2c8\ub2e4.<br><br>\uc774\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ubaa8\ub4dc\uac00 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ub610\ub294 \ub2e4\ub978 \uae30\ubcf8 \ubaa8\ub4dc\uc758 \uc774\uc804 \ubc84\uc804\uc6a9\uc73c\ub85c \ucef4\ud30c\uc77c\ub418\uc5c8\uc73c\uba70, \ud574\ub2f9 \uae30\ubcf8 \ubaa8\ub4dc\uac00 \ucd5c\uadfc \ubc84\uc804\uc5d0\uc11c \ud2b9\uc815 \ud074\ub798\uc2a4\ub97c <code>final</code>\ub85c \uc9c0\uc815\ud55c \uacbd\uc6b0\uc5d0 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>\uad00\ub828\ub41c \ubaa8\ub4e0 \ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694</b>, \ud2b9\ud788 \uc5b8\uae09\ub41c \uae30\ubcf8 \ubaa8\ub4dc\uc640 \uad00\ub828\uc774 \uc788\uc744 \uc218 \uc788\ub294 \ubaa8\ub4dc\ub4e4.<br>\u2022 \ubb38\uc81c\uac00 \uc9c0\uc18d\ub418\uba74 \ud604\uc7ac \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uacfc \uc885\uc18d\uc131\uacfc \ud638\ud658\ub418\ub294 \ubaa8\ub4dc \ubc84\uc804\uc744 \ucc3e\uc544\ubcf4\uc138\uc694.<br>\u2022 \uc77c\ubd80 \uacbd\uc6b0, \uc790\uc2dd \ud074\ub798\uc2a4\ub97c \ud3ec\ud568\ud55c \ubaa8\ub4dc\ub97c \uc77c\uc2dc\uc801\uc73c\ub85c \uc81c\uac70\ud558\uba74 \uc6d0\uc778\uc744 \ud655\uc778\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "final \ud074\ub798\uc2a4 \uc0c1\uc18d \uc2dc\ub3c4";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'><b>Rubidium</b>(\ud3ec\uc9c0\uc6a9 \uc18c\ub4d0 \ud3ec\ud06c \uc911 \ud3d0\uae30\ub41c \ubc84\uc804)\uc744 <b>Iris \ub610\ub294 Oculus</b>\uc640 \ud568\uaed8 \uc0ac\uc6a9\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.<br>\ucd5c\uadfc \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804(1.19.2 \uc774\uc0c1)\uc5d0\uc11c Rubidium\uc740 \uc18c\ub4d0\uc758 \uc5c5\ub370\uc774\ud2b8\ub97c \ub530\ub77c\uac00\uc9c0 \ubabb\ud588\uace0 \uad00\ub828 \ubaa8\ub4dc\uc5d0 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.<br><br>\uc131\ub2a5 \ud5a5\uc0c1 \ubaa8\ub4dc(Sodium, Rubidium, Embeddium, Bedium, Xeonium \ub4f1) \ub610\ub294 Iris Shaders\uac00 \ub2e4\ub978 \ubaa8\ub4dc\uc640 \ucda9\ub3cc\ud560 \ub54c\ub3c4 \uc774 \uc624\ub958\uac00 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <b>mods</b> \ud3f4\ub354\uc5d0\uc11c <b>Rubidium\uc744 \uc81c\uac70\ud558\uc138\uc694</b>.<br>\u2022 <b><a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a>\uc744 \uc124\uce58\ud558\uc138\uc694</b>, \uc774\uac83\uc740 1.20+ \ubc84\uc804\uc5d0\uc11c Iris/Oculus\ub97c \uc9c0\uc6d0\ud558\ub294, \ud3ec\uc9c0\uc6a9\uc73c\ub85c \ud65c\ubc1c\ud788 \uc720\uc9c0\ubcf4\uc218\ub418\ub294 \uc18c\ub4d0 \ud3ec\ud06c\uc785\ub2c8\ub2e4.<br>\u2022 \ub3d9\uc2dc\uc5d0 \uc5ec\ub7ec \uac1c\uc758 \uc18c\ub4d0 \ud3ec\ud06c\ub97c \uc124\uce58\ud558\uc9c0 \uc54a\ub3c4\ub85d \ud558\uc138\uc694(Rubidium\uacfc Embeddium \uac19\uc774 \uc124\uce58 \uae08\uc9c0).<br>\u2022 Iris \ub300\uc2e0 Oculus\ub97c \uc0ac\uc6a9\ud55c\ub2e4\uba74, \uadf8\uac83\ub3c4 \ub2f9\uc2e0\uc758 \ud3ec\uc9c0 \ubc0f Embeddium \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "\uc0ac\uc6a9 \uc911\ub2e8\ub41c Rubidium\uacfc Iris/Oculus \ud568\uaed8 \uc0ac\uc6a9 (OptionInstance\ub294 final\uc784)";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0644\u062a\u0639\u062f\u064a\u0644 <code>Simple Voice Chat</code> \u062a\u0634\u063a\u064a\u0644 \u062e\u0627\u062f\u0645 \u0627\u0644\u0635\u0648\u062a \u0627\u0644\u062e\u0627\u0635 \u0628\u0647 \u0644\u0623\u0646 \u0645\u0646\u0641\u0630 UDP \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 IP \u0627\u0644\u0645\u064f\u0639\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.<br>\u0647\u0630\u0627 \u0644\u0627 \u064a\u0645\u0646\u0639 \u0628\u062f\u0621 \u0627\u0644\u0644\u0639\u0628\u0629\u060c \u0644\u0643\u0646\u0647 \u064a\u0639\u0637\u0644 \u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u062f\u0631\u062f\u0634\u0629 \u0627\u0644\u0635\u0648\u062a\u064a\u0629.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>\u0623\u063a\u0644\u0642 \u0623\u064a \u0646\u0633\u062e\u0629 \u0623\u062e\u0631\u0649 \u0645\u0646 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a</b> \u0623\u0648 \u062a\u0637\u0628\u064a\u0642 \u064a\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0645\u0646\u0641\u0630 UDP 24454.<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u0639\u0644\u0649 \u062e\u0627\u062f\u0645\u060c \u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 <b>\u0623\u064a \u062e\u062f\u0645\u0629 \u0623\u062e\u0631\u0649</b> \u0644\u0627 \u062a\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u0627\u0644\u0645\u0646\u0641\u0630.<br>\u2022 \u0641\u064a \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u062a\u0639\u062f\u064a\u0644 (<code>config/voicechat/</code>)\u060c \u063a\u064a\u0651\u0631 \u0645\u0646\u0641\u0630 UDP \u0625\u0644\u0649 \u0645\u0646\u0641\u0630 \u062d\u0631 (\u0645\u062b\u0644\u0627\u064b 24455).<br>\u2022 \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0639\u0646\u0648\u0627\u0646 IP \u0645\u062e\u0635\u0635\u064b\u0627\u060c \u0641\u062a\u062d\u0642\u0642 \u0645\u0646 \u0635\u062d\u062a\u0647 \u0623\u0648 \u0627\u062a\u0631\u0643\u0647 \u0641\u0627\u0631\u063a\u064b\u0627 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0625\u0639\u062f\u0627\u062f \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "\u0627\u0644\u062f\u0631\u062f\u0634\u0629 \u0627\u0644\u0635\u0648\u062a\u064a\u0629: \u0645\u0646\u0641\u0630 UDP \u0645\u0634\u063a\u0648\u0644 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 IP \u063a\u064a\u0631 \u0635\u0627\u0644\u062d";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\ube14\ub85d \uc544\uc774\ud15c <code>" + nombreBlockItem + "</code>\uc774(\uac00) \ube14\ub85d\uc744 null\ub85c \ucc38\uc870\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.<br>\uc774 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c <b>Create \uc560\ub4dc\uc628</b>(\uc608: <code>dndecor</code>, <code>createdeco</code>)\uc5d0\uc11c \ubc1c\uc0dd\ud558\uba70, <code>Amendments</code>, <code>Moonshine</code>\uacfc\uc758 \ucda9\ub3cc \ub610\ub294 \ube14\ub85d \ucd08\uae30\ud654 \uc624\ub958\ub85c \uc778\ud574 \ub098\ud0c0\ub0a9\ub2c8\ub2e4.<br><b>\ucc38\uace0:</b> \uc774 \uc624\ub958\ub294 Amendments \uc790\uccb4\uc758 \ubb38\uc81c\uac00 \uc544\ub2c8\ub77c \ub4f1\ub85d \ub85c\ub4dc \uacfc\uc815\uc758 \ub354 \uae4a\uc740 \ubb38\uc81c\ub97c \ub098\ud0c0\ub0c5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>\uad00\ub828\ub41c \ubaa8\ub4e0 \ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694:</b> Create, Amendments, Moonshine \ubc0f \ubaa8\ub4e0 \uc560\ub4dc\uc628(<code>dndecor</code>, <code>createdeco</code> \ud3ec\ud568).<br>\u2022 \ubb38\uc81c\uac00 \uc9c0\uc18d\ub418\uba74 <b>Create \uc560\ub4dc\uc628\uc744 \uc77c\uc2dc\uc801\uc73c\ub85c \ud558\ub098\uc529 \uc81c\uac70</b>\ud558\uc5ec \uc6d0\uc778\uc744 \ucc3e\uc544\ubcf4\uc138\uc694.<br>\u2022 <b>Amendments\uc640 Moonshine\uc774 \uc0ac\uc6a9 \uc911\uc778 Create \ubc0f Forge \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294\uc9c0</b> \ud655\uc778\ud558\uc138\uc694.<br>\u2022 \ubb38\uc81c\uac00 \uc788\ub294 \uc560\ub4dc\uc628\uc758 \ubca0\ud0c0 \ubc84\uc804\uc774\ub098 \ucd5c\uc2e0 \ud3ec\ud06c\uac00 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "Create \uc560\ub4dc\uc628\uc5d0\uc11c\uc758 null \ube14\ub85d \uc544\uc774\ud15c";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("\ud65c\uc131\ud654\ub41c \ud50c\ub7ab\ud3fc(Forge, Fabric \ub4f1)\uc5d0 \uc18d\ud558\uc9c0 \uc54a\ub294 \ubaa8\ub4dc\uac00 \ubc1c\uacac\ub418\uc5c8\uc2b5\ub2c8\ub2e4:<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>\uc774 \ubb38\uc81c\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ub2e4\uc74c \uacbd\uc6b0\uc5d0 \ubc1c\uc0dd\ud569\ub2c8\ub2e4:<br>").append("\u2022 \uac19\uc740 \ud3f4\ub354\uc5d0 <b>Fabric\uc640 Forge</b> \ubaa8\ub4dc\ub97c \uc11e\uc5c8\uc744 \ub54c.<br>").append("\u2022 Minecraft\uc758 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubc84\uc804\uc6a9 \ubaa8\ub4dc\ub97c \uc124\uce58\ud588\uc744 \ub54c.<br>").append("\u2022 \ubaa8\ub4dc\uac00 \uc190\uc0c1\ub418\uc5c8\uac70\ub098 \uc720\ud6a8\ud55c JAR \ud30c\uc77c\uc774 \uc544\ub2d0 \ub54c.</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>\ubaa8\ub4e0 \ubaa8\ub4dc\uac00 \ub3d9\uc77c\ud55c \ud50c\ub7ab\ud3fc\uc6a9\uc778\uc9c0 \ud655\uc778\ud558\uc138\uc694</b> (Forge <b>\ub610\ub294</b> Fabric, \ub458 \ub2e4 \uc544\ub2d8).<br>\u2022 \uac01 \ud30c\uc77c\uc774 \uc5b4\ub5a4 \ud50c\ub7ab\ud3fc\uc73c\ub85c \uc778\uc2dd\ub418\ub294\uc9c0 \ud655\uc778\ud558\ub824\uba74 <b>\ubaa8\ub4dc \ud2b8\ub9ac</b>\ub97c \uc0ac\uc6a9\ud558\uc138\uc694.<br>\u2022 \uc54c \uc218 \uc5c6\uac70\ub098 \ub2e4\ub978 \ud50c\ub7ab\ud3fc\uc6a9\uc778 \ubaa8\ub4dc\ub294 \uc0ad\uc81c\ud558\uc138\uc694.<br>\u2022 CurseForge\ub098 Prism \uac19\uc740 \ub7f0\ucc98\ub97c \uc0ac\uc6a9\ud55c\ub2e4\uba74 \ud504\ub85c\ud544 \uc124\uc815\uc774 \uc62c\ubc14\ub978\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "\ud65c\uc131 \ub85c\ub354\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubaa8\ub4dc";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\ubaa8\ub378 <code>" + modid + ":" + nombreModelo + "</code>\uc744(\ub97c) \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.<br>\uc774\ub294 \ubaa8\ub4dc <code>" + modid + "</code>\uc758 \ub9ac\uc18c\uc2a4\uac00 \uc190\uc0c1\ub418\uc5c8\uac70\ub098 \ub204\ub77d\ub418\uc5c8\uac70\ub098 \uc0ac\uc6a9 \uc911\uc778 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8 \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc74c\uc744 \uc758\ubbf8\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>\ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694</b>, \uc778\uc2a4\ud134\uc2a4\uc640 \ud638\ud658\ub418\ub294 \ucd5c\uc2e0 \ubc84\uc804\uc73c\ub85c.<br>\u2022 \uac1c\ubc1c \uc911\uc774\uac70\ub098 \uc0ac\uc6a9\uc790 \uc815\uc758\ub41c \ubc84\uc804\uc744 \uc0ac\uc6a9 \uc911\uc774\ub77c\uba74 \uacf5\uc2dd \ubc84\uc804\uc73c\ub85c \ub418\ub3cc\ub9ac\uc138\uc694.<br>\u2022 JAR \ud30c\uc77c\uc774 \uc190\uc0c1\ub418\uc9c0 \uc54a\uc558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694(\ub2e4\uc2dc \uc124\uce58).<br>\u2022 \ubb38\uc81c\uac00 \uc9c0\uc18d\ub418\uba74 \uc774 \ub85c\uadf8\ub97c \ucca8\ubd80\ud558\uc5ec \ubaa8\ub4dc \uc81c\uc791\uc790\uc5d0\uac8c \uc624\ub958\ub97c \ubcf4\uace0\ud558\uc138\uc694.";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "\ub9ac\uc18c\uc2a4 \ubaa8\ub378 \uc0dd\uc131 \uc2e4\ud328";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'><code>Moonlight</code>\uacfc <code>Iceberg</code> \ubaa8\ub4dc \uc0ac\uc774\uc5d0 \uce58\uba85\uc801\uc778 \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.<br>\ub450 \ubaa8\ub4dc \ubaa8\ub450 \uc790\uc6d0 \uc7ac\ub85c\ub529 \uc2dc\uc2a4\ud15c\uc744 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubc29\uc2dd\uc73c\ub85c \ub4f1\ub85d\ud558\ub824 \ud558\uba70, \uc774\ub294 \uc720\ud6a8\ud55c \uadf8\ub798\ud53d \ucee8\ud14d\uc2a4\ud2b8\uac00 \uc5c6\uc5b4 OpenGL \uc624\ub958\ub97c \uc720\ubc1c\ud569\ub2c8\ub2e4.<br>\uc774 \ubb38\uc81c\ub294 Fabric \ubaa8\ub4dc \uc5b4\ub311\ud130\ub97c \ud3ec\ud568\ud558\ub294 Forge \ubc84\uc804\uc744 \uc0ac\uc6a9\ud560 \ub54c \ud754\ud788 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>\ub450 \ubaa8\ub4dc \ubaa8\ub450</b> \ud604\uc7ac Forge \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294 \ucd5c\uc2e0 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.<br>\u2022 \ubb38\uc81c\uac00 \uc9c0\uc18d\ub418\uba74 <b>\uc77c\uc2dc\uc801\uc73c\ub85c Iceberg\ub97c \uc81c\uac70\ud558\uc138\uc694</b>. Moonlight\uc740 \ub2e4\ub978 \ub9ce\uc740 \ubaa8\ub4dc\uc758 \ud575\uc2ec \uc885\uc18d\uc131\uc778 \uacbd\uc6b0\uac00 \ub9ce\uc2b5\ub2c8\ub2e4.<br>\u2022 \uc911\ubcf5\ub418\uac70\ub098 \ud63c\ud569\ub41c Forge/Fabric \ubc84\uc804\uc744 \uc124\uce58\ud558\uc9c0 \uc54a\uc558\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.<br>\u2022 \ub2e4\ub978 \ubaa8\ub4dc(Supplementaries, Citadel \ub4f1)\uac00 \uc774\ubbf8 Iceberg \uae30\ub2a5\uc744 \ub0b4\uc7a5\ud558\uace0 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "\uce58\uba85\uc801 \ucda9\ub3cc: Moonlight \ub300 Iceberg (OpenGL \ucee8\ud14d\uc2a4\ud2b8 \uc5c6\uc74c)";
    }

    @Override
    public String instantanea() {
        return "\uc2a4\ub0c5\uc0f7";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "\ub9c8\uc9c0\ub9c9 \uc2a4\ub0c5\uc0f7 \uc774\ud6c4";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "\ud30c\uc77c \uc120\ud0dd";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "\uc2a4\ub0c5\uc0f7\uc774 \uc131\uacf5\uc801\uc73c\ub85c \uc0dd\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "\uc2a4\ub0c5\uc0f7 \uc0dd\uc131 \uc911 \uc624\ub958 \ubc1c\uc0dd";
    }

    @Override
    public String consejo() {
        return "\ud301";
    }

    @Override
    public String resultadoMuestra() {
        return "\uacb0\uacfc \ubcf4\uae30";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>\ud301:</b> \ub450 \uac1c\uc758 \uae30\ub85d \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc5ec \ubaa8\ub4dc \ubaa9\ub85d\uc744 \ube44\uad50\ud558\uc138\uc694.   \uacb0\uacfc\ub294 \uc815\uaddc\ud654\ub41c \uc774\ub984\uc744 \uae30\uc900\uc73c\ub85c <span style='color:%s;'>\ucd94\uac00\ub428 (+)</span>\uacfc   <span style='color:%s;'>\uc81c\uac70\ub428 (&#8722;)</span>\uc744 \ud45c\uc2dc\ud569\ub2c8\ub2e4.   '\uc2a4\ub0c5\uc0f7' \ubc84\ud2bc\uc744 \uc0ac\uc6a9\ud558\uba74 \uae30\uc874 \ud30c\uc77c\uc758 .instantanea \ud655\uc7a5\uc790 \ubcf5\uc0ac\ubcf8\uc744 \ub9cc\ub4e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "\ub85c\uadf8 \ub9c1\ud06c\ub97c \ub9c8\ud06c\ub2e4\uc6b4 \ud615\uc2dd\uc73c\ub85c \uac00\uc838\uc624\uae30 (\ubcf4\uace0\uc11c \uc5c6\uc74c)";
    }

    @Override
    public String titulo_configuracion() {
        return "\uc124\uc815";
    }

    @Override
    public String columna_url() {
        return "URL";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "\uacf5\uc720 \uc911 \uc608\uae30\uce58 \ubabb\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "\ub9c1\ud06c \uc0dd\uc131 \uc911 \uc608\uae30\uce58 \ubabb\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "\ubc84\ud2bc \ucc98\ub9ac \uc911 \uc608\uae30\uce58 \ubabb\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "\uc5f4 \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "\ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4:\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "\ud3b8\uc9d1\uae30\uc5d0\uc11c \uc5f4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n\uacbd\ub85c\uac00 \ud074\ub9bd\ubcf4\ub4dc\uc5d0 \ubcf5\uc0ac\ub429\ub2c8\ub2e4.";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "\ud30c\uc77c\uc744 \uc5f4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uacbd\ub85c\uac00 \ud074\ub9bd\ubcf4\ub4dc\uc5d0 \ubcf5\uc0ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "\ub370\uc2a4\ud06c\ud0d1\uc774 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uacbd\ub85c\uac00 \ud074\ub9bd\ubcf4\ub4dc\uc5d0 \ubcf5\uc0ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String limite_de_solicitudes() {
        return "\uc694\uccad \uc81c\ud55c\uc744 \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\ub978 \ub85c\uadf8 \uc0ac\uc774\ud2b8\ub098 \ub2e4\ub978 \ub85c\uadf8 API\ub97c \uc0ac\uc6a9\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "\ub9c1\ud06c \uacf5\uc720";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ub098\ubb34 \uc904\uae30\uc758 \uc0c1\ub2e8 \ubd80\ubd84\uc744 \uace0\uce58\ub294 \uac83\uc774 \ucd5c\uc6b0\uc120\uc785\ub2c8\ub2e4. \ud615\uc2dd\uc740 \ub808\ubca8, \ub77c\uc778\uc785\ub2c8\ub2e4. \ubaa8\ub4e0 \ub85c\uadf8\uc5d0\ub294 \ubc88\ud638 \uccb4\uacc4\uac00 \uc788\uc2b5\ub2c8\ub2e4. " + "<br>" + "\uc77c\ubc18\uc801\uc73c\ub85c \ubaa8\ub4e0 \ub85c\uadf8\uc5d0\uc11c \uac00\uc7a5 \ub0ae\uc740 \ub808\ubca8\uc744 \ucc3e\uc544\uc57c \ud569\ub2c8\ub2e4. \ub192\uc740 \ub808\ubca8\uc758 \ud2b8\ub808\uc774\uc2a4\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \uc798\ubabb\ub41c \uae0d\uc815\uc785\ub2c8\ub2e4. \ud2b8\ub808\uc774\uc2a4\uac00 \ub9ce\uc744 \ub54c \ubd84\uc11d\uc774 \uc644\ubcbd\ud558\uc9c0 \uc54a\uc73c\ubbc0\ub85c \ucf58\uc194\uc744 \uc9c1\uc811 \ubcf4\ub294 \ub2a5\ub825\uc744 \uc0ac\uc6a9\ud558\ub294 \uac83\uc774 \uc911\uc694\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "\uc601\uc7a5 \uce90\ub098\ub9ac \uac80\uc0c9\uae30";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "\uc774 \uae30\ub2a5\uc740 \uace7 \uc0ac\uc6a9 \uac00\ub2a5\ud558\uac8c \ub420 \uc608\uc815\uc785\ub2c8\ub2e4.";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "\uace7 \ucd9c\uc2dc \uc608\uc815";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "Crash Assistant\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubaa8\ub4dc (\uac70\uc9d3)";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "CrashAssistant\ub97c \uc0ac\uc6a9\ud558\ub294 \ubaa8\ub4dc\ud329\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubaa8\ub4dc";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant\ub294 \ud638\ud658\ub418\uc9c0 \uc54a\ub294\ub2e4\uace0 \ud45c\uc2dc\ud558\ub294 \ubaa8\ub4dc \ubaa9\ub85d\uc774 \uc788\uc9c0\ub9cc, \uc2e4\uc81c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\ub294\ub2e4\ub294 \uc99d\uac70\ub294 \uc5c6\uc73c\uba70 \uc624\ub958 \uba54\uc2dc\uc9c0\ub294 \uc601\uc5b4\ub85c\ub9cc \uc81c\uacf5\ub429\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub4e4\uacfc \ud568\uaed8 \uac8c\uc784\uc744 \ud558\uace0 \uc2f6\ub2e4\uba74, <code>config/crash_assistant/config.toml</code> \ud30c\uc77c\uc744 \uc5f4\uc5b4 [compatibility] \uc139\uc158\uc758 <code>enabled = true</code>\ub97c <code>enabled = false</code>\ub85c \ubcc0\uacbd\ud558\uba74 \ub429\ub2c8\ub2e4.</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant\ub294 \ubaa8\ub4dc\uac00 \ud638\ud658\ub418\uc9c0 \uc54a\ub294\ub2e4\uace0 \ud310\ub2e8\ud560 \uc218 \uc788\uc9c0\ub9cc, \ub54c\ub54c\ub85c \uc798\ubabb\ub41c \ud310\ub2e8\uc744 \ud558\uba70 \uc624\ub958 \uba54\uc2dc\uc9c0\uac00 \uc601\uc5b4\ub85c\ub9cc \ub098\uc635\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub4e4\uc744 \uc0ac\uc6a9\ud558\uace0 \uc2f6\ub2e4\uba74, <code>config/crash_assistant/problematic_mods_config.json</code> \ud30c\uc77c\uc744 \ud3b8\uc9d1\ud558\uc5ec <code>should_crash_on_startup</code> \uac12\uc744 <code>true</code>\uc5d0\uc11c <code>false</code>\ub85c \ubc14\uafb8\uba74 \ub429\ub2c8\ub2e4.</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc624\ub958: \ubaa8\ub4dc '" + modId + "'\uc740(\ub294) '" + dependencia + "' \ubaa8\ub4dc\ub97c \ud544\uc694\ub85c \ud569\ub2c8\ub2e4. \ud604\uc7ac " + actual + "\uc785\ub2c8\ub2e4.</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc624\ub958: \ubaa8\ub4dc '" + modId + "'\uc740(\ub294) '" + dependencia + "'\uc758 \ubc84\uc804 '" + requerido + "' \uc774\uc0c1\uc774 \ud544\uc694\ud558\uc9c0\ub9cc, \ud574\ub2f9 \ubaa8\ub4dc\uac00 \uc124\uce58\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc624\ub958: '" + modId + "' \ubaa8\ub4dc\ub294 '" + dependencia + "'\uc758 \ud604\uc7ac \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. 'Iris/Oculus & GeckoLib Compat' \ubaa8\ub4dc\ub97c \uc81c\uac70\ud574\uc57c \ud569\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub294 Superb Warfare\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70 \ucd5c\uc2e0 \ubc84\uc804\uc758 GeckoLib\uacfc \ud568\uaed8 \uc791\ub3d9\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ud604\uc7ac \ubc84\uc804: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "\uc624\ub958: '" + clase + "' \ud074\ub798\uc2a4\uc758 \uc791\uc5c5\uc744 \uc2e4\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc774 \uc624\ub958\ub294 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uac70\ub098 \uc124\uce58\ub41c \ub2e4\ub978 \ubaa8\ub4dc\uc640 \ucda9\ub3cc\ud558\ub294 \ubaa8\ub4dc\uc5d0\uc11c \ud754\ud788 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "\uc791\uc5c5 \uc2e4\ud589 \uc2e4\ud328";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "\uc774\ub7ec\ud55c \uc885\ub958\uc758 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ubaa8\ub4dc \uac04\uc758 \ud638\ud658\uc131 \ubb38\uc81c\ub85c \uc778\ud574 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ud2b9\ud788 ConnectorMod\uacfc \ud568\uaed8 \uc81c\ub300\ub85c \uc791\ub3d9\ud558\uc9c0 \uc54a\ub294 \ubaa8\ub4dc\uc5d0\uc11c \ud754\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String info_clase_problematica() {
        return "\ubb38\uc81c \uc788\ub294 \ud074\ub798\uc2a4:";
    }

    public String ver_en_log() {
        return "\ub85c\uadf8\uc5d0\uc11c \ubcf4\uae30";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "\uc2e4\ud589 \ubb38\uc81c\uac00 \uc788\ub294 \ud2b9\uc815 \ud074\ub798\uc2a4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine\uacfc Entity Model Features(EMF) \uc0ac\uc774\uc5d0 \uce58\uba85\uc801\uc778 \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ub450 \ubaa8\ub4dc\ub294 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70 \uac8c\uc784 \uc2dc\uc791\uc744 \ubc29\ud574\ud558\ub294 \uc8fc\uc785 \uc624\ub958\ub97c \uc720\ubc1c\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "OptiFine \ubc0f Entity Model Features \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "OptiFine \ub610\ub294 Entity Model Features\ub97c \uc81c\uac70\ud558\uc138\uc694. \uc774 \ub458\uc740 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine\uacfc Fusion \uc0ac\uc774\uc5d0 \uce58\uba85\uc801\uc778 \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ub450 \ubaa8\ub4dc\ub294 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70 \uac8c\uc784 \uc2dc\uc791\uc744 \ubc29\ud574\ud558\ub294 \uc8fc\uc785 \uc624\ub958\ub97c \uc720\ubc1c\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "OptiFine \ubc0f Fusion \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "OptiFine \ub610\ub294 Fusion\ub97c \uc81c\uac70\ud558\uc138\uc694. \uc774 \ub458\uc740 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Create\uc5d0\uc11c \uc694\uad6c\ud558\ub294 Flywheel\uc740 Sodium 0.6.0-beta.2 \uc774\uc0c1\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. Rubidium\uc740 0.5.3\uc785\ub2c8\ub2e4. \ub300\uc548\uc73c\ub85c <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \uc0ac\uc6a9\uc744 \uace0\ub824\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "Flywheel\uacfc Sodium \ubc84\uc804 \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "Sodium\ub97c 0.6.0-beta.2 \uc774\uc0c1\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098, \ud638\ud658 \uac00\ub2a5\ud55c \ub300\uccb4\ud488\uc73c\ub85c <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a>\uc744 \uc124\uce58\ud558\uc138\uc694.";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine\uacfc Epic Fight \uc0ac\uc774\uc5d0 \uce58\uba85\uc801\uc778 \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ub450 \ubaa8\ub4dc\ub294 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70 \uac8c\uc784 \uc2dc\uc791\uc744 \ubc29\ud574\ud558\ub294 \uc8fc\uc785 \uc624\ub958\ub97c \uc720\ubc1c\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "OptiFine \ubc0f Epic Fight \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "OptiFine \ub610\ub294 Epic Fight\ub97c \uc81c\uac70\ud558\uc138\uc694. \uc774 \ub458\uc740 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \uacfc Rubidium \uac04\uc5d0 \uc2ec\uac01\ud55c \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub4e4\uc740 \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70, \uc8fc\uc785 \uc2e4\ud328\ub85c \uc778\ud574 \uac8c\uc784 \uc2dc\uc791\uc744 \ubc29\ud574\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "OptiFine \uacfc Rubidium \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "OptiFine \ub610\ub294 Rubidium\uc744 \uc81c\uac70\ud558\uc138\uc694. \uc774 \ub458\uc740 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam\uc774 \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \ub85c\ub4dc\ub97c \uc2dc\ub3c4\ud558\uace0 \uc788\uc9c0\ub9cc, \uc774\ub294 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\uc11c\ub9cc \ud638\ud658\ub429\ub2c8\ub2e4. \uc11c\ubc84\uc5d0\uc11c FreeCam\uc744 \uc81c\uac70\ud558\uac70\ub098, \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ub418\uc5b4 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "\uc804\uc6a9 \uc11c\ubc84\uc758 FreeCam";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "FreeCam\uc740 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ud574\uc57c \ud558\ubbc0\ub85c \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF)\uac00 \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \ub85c\ub4dc\ub97c \uc2dc\ub3c4\ud558\uace0 \uc788\uc9c0\ub9cc, \uc774\ub294 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\uc11c\ub9cc \ud638\ud658\ub429\ub2c8\ub2e4. \uc11c\ubc84\uc5d0\uc11c ETF\ub97c \uc81c\uac70\ud558\uac70\ub098, \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ub418\uc5b4 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "\uc804\uc6a9 \uc11c\ubc84\uc758 Entity Texture Features";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features\ub294 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ud574\uc57c \ud558\ubbc0\ub85c \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc11c\ubc84\ub97c \uc2e4\ud589\ud558\ub824\uba74 Minecraft\uc758 EULA\uc5d0 \ub3d9\uc758\ud574\uc57c \ud569\ub2c8\ub2e4. eula.txt \ud30c\uc77c\uc744 \ud3b8\uc9d1\ud558\uc5ec 'eula=false'\ub97c 'eula=true'\ub85c \ubcc0\uacbd\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "Minecraft EULA \ubbf8\ub3d9\uc758";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "\uc11c\ubc84 \ud3f4\ub354\uc758 eula.txt \ud30c\uc77c\uc744 \ud3b8\uc9d1\ud558\uc5ec 'eula=false'\ub97c 'eula=true'\ub85c \ubcc0\uacbd\ud558\uc138\uc694.";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine\uc774 \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \ub85c\ub4dc\ub97c \uc2dc\ub3c4\ud558\uace0 \uc788\uc9c0\ub9cc, \uc774\ub294 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\uc11c\ub9cc \ud638\ud658\ub429\ub2c8\ub2e4. \uc11c\ubc84\uc5d0\uc11c OptiFine\uc744 \uc81c\uac70\ud558\uac70\ub098, \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ub418\uc5b4 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "\uc804\uc6a9 \uc11c\ubc84\uc758 OptiFine";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "OptiFine\uc740 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ud574\uc57c \ud558\ubbc0\ub85c \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks\uac00 1.20.1\uc6a9\uc73c\ub85c \uc798\ubabb \ud45c\uc2dc\ub418\uc5c8\uc9c0\ub9cc 1.21.1\uc758 \uba54\uc11c\ub4dc\ub97c \uc0ac\uc6a9\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \ubaa8\ub4dc\uac00 1.20.1\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 ResourceLocation.fromNamespaceAndPath\ub97c \uc0ac\uc6a9\ud558\ub824\uace0 \uc2dc\ub3c4\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "Iron's Spellbooks \ubc84\uc804 \uc624\ub958";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "Minecraft \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294 \uc62c\ubc14\ub978 \ubc84\uc804\uc758 Iron's Spellbooks\ub97c \uc0ac\uc6a9\ud558\uace0 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \uacfc Embeddium \uac04\uc5d0 \uc2ec\uac01\ud55c \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub4e4\uc740 \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70, \uc8fc\uc785 \uc2e4\ud328\ub85c \uc778\ud574 \uac8c\uc784 \uc2dc\uc791\uc744 \ubc29\ud574\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "OptiFine \uacfc Embeddium \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "OptiFine \ub610\ub294 Embeddium\uc744 \uc81c\uac70\ud558\uc138\uc694. \uc774 \ub458\uc740 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc774\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \uc138\uacc4 \uc0dd\uc131 \ubaa8\ub4dc \uac04\uc758 \ucda9\ub3cc\ub85c \uc778\ud574 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ud2b9\ud788 Terralinth, AmplifiedNether, Nullscape, Incendium \ubc0f \uae30\ud0c0 \uc138\uacc4 \uc0dd\uc131 \ubaa8\ub4dc\uc5d0\uc11c \ud754\ud569\ub2c8\ub2e4. \ub204\ub77d\ub41c \ubaa8\ub4dc\ub97c \uc124\uce58\ud574\uc57c \ud560 \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4.</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable\uc774 \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \ub85c\ub4dc\ub97c \uc2dc\ub3c4\ud558\uace0 \uc788\uc9c0\ub9cc, \uc774\ub294 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\uc11c\ub9cc \ud638\ud658\ub429\ub2c8\ub2e4. \uc11c\ubc84\uc5d0\uc11c Controllable\uc744 \uc81c\uac70\ud558\uac70\ub098, \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ub418\uc5b4 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "\uc804\uc6a9 \uc11c\ubc84\uc758 Controllable";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "Controllable\uc740 \ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\ub9cc \uc124\uce58\ud574\uc57c \ud558\ubbc0\ub85c \uc804\uc6a9 \uc11c\ubc84\uc5d0\uc11c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries\uac00 \uc11c\ubc84 \ub85c\ub4dc\ub97c \ubc29\ud574\ud558\ub294 \uc624\ub958\ub97c \uc77c\uc73c\ud0a4\uace0 \uc788\uc2b5\ub2c8\ub2e4. \ud574\ub2f9 \ubaa8\ub4dc\ub294 \ud654\uc5fc \ub3d9\uc791 \ub4f1\ub85d \uc2dc \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud558\uc5ec datapack \ub85c\ub4dc \ub3c4\uc911 \uc2e4\ud328\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries\uac00 \uc11c\ubc84 \ub85c\ub4dc\ub97c \ubc29\ud574\ud568";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "Supplementaries\ub97c \ucd5c\uc2e0 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098, \uc11c\ubc84 \ub85c\ub4dc\ub97c \ud5c8\uc6a9\ud558\uae30 \uc704\ud574 \uc784\uc2dc\ub85c \ube44\ud65c\uc131\ud654\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader(GML)\uac00 \ub204\ub77d\ub41c Jackson \ubaa8\ub4c8\ub85c \uc778\ud574 \ubb38\uc81c\ub97c \ubc1c\uacac\ud588\uc2b5\ub2c8\ub2e4. Valkyrien Skies\uc640 \uac19\uc740 \uc77c\ubd80 \ubaa8\ub4dc\ub294 \ud544\uc694\ud55c \ubaa8\ub4e0 \uc885\uc18d\uc131\uc744 \ud3ec\ud568\ud558\uc9c0 \uc54a\uc544 \uc774 \uc624\ub958\ub97c \uc77c\uc73c\ud0ac \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "Groovy Modloader\uc758 Jackson \ubaa8\ub4c8 \ub204\ub77d";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "\uc885\uc18d\uc131 \ucda9\ub3cc\uc744 \uc720\ubc1c\ud560 \uc218 \uc788\ub294 Groovy Modloader \ubc0f Valkyrien Skies\uc640 \uac19\uc740 \uad00\ub828 \ubaa8\ub4dc\ub97c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat\uac00 \uc798\ubabb\ub41c \ub098\ubb34 \ube14\ub85d \uc774\ub984\uc744 \ubc1c\uacac\ud588\uc2b5\ub2c8\ub2e4. Every Compat\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ub9ce\uc740 \ubb38\uc81c\ub97c \uc77c\uc73c\ud0b5\ub2c8\ub2e4. \uc0ac\uc6a9\ud558\uc9c0 \ub9c8\uc138\uc694!</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "Every Compat\uc758 \uc798\ubabb\ub41c \uc774\ub984";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "Every Compat\ub97c \uc0ac\uc6a9\ud558\ub294 \ub9ac\uc18c\uc2a4 \ud329\uc774\ub098 \ubaa8\ub4dc\ub97c \ud655\uc778\ud558\uc138\uc694. \uc798\ubabb\ub41c \ube14\ub85d \uc774\ub984\uc774 \ud3ec\ud568\ub418\uc5b4 \uc788\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc624\ub958 \ucf54\ub4dc(-1073741819)\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774\ub294 Razer\uc758 GameCaster, Discord, OBS Studio\uc640 \uac19\uc740 \uc624\ubc84\ub808\uc774 \ub610\ub294 NVIDIA \ub4dc\ub77c\uc774\ubc84 \ubb38\uc81c\ub85c \uc778\ud574 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "\uc624\ub958 \ucf54\ub4dc -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "GameCaster, Discord, OBS Studio\uc640 \uac19\uc740 \uc624\ubc84\ub808\uc774\ub97c \ube44\ud65c\uc131\ud654\ud558\uace0, NVIDIA \ub4dc\ub77c\uc774\ubc84\uac00 \ucd5c\uc2e0 \uc0c1\ud0dc\uc778\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips\ub294 dependencia\uc778 Immersive Messages\uac00 \ud544\uc694\ud558\uc9c0\ub9cc \uc124\uce58\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. Immersive Tooltips\uac00 \uc81c\ub300\ub85c \uc791\ub3d9\ud558\ub824\uba74 Immersive Messages\ub97c \uc124\uce58\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "dependencia \uc5c6\ub294 Immersive Tooltips";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips\uc5d0 \ud544\uc694\ud55c dependencia\uc778 Immersive Messages\ub97c \uc124\uce58\ud558\uc138\uc694.";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins\uac00 Apoli Mod\uc640 \ud638\ud658\uc131 \ubb38\uc81c\uac00 \uc788\uc73c\uba70, ItemStack\uc744 EntityLinkedItemStack\uc73c\ub85c \uce90\uc2a4\ud2b8\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc774\ub294 6.6.0\ubcf4\ub2e4 \ub192\uc740 \ubc84\uc804\uc5d0\uc11c \ud754\ud569\ub2c8\ub2e4. \uc774\uc804 \ubc84\uc804\uc744 \uc0ac\uc6a9\ud558\uac70\ub098 Fabric\uacfc Forge \ubc84\uc804 \uac04\uc5d0 \uc804\ud658\ud558\ub294 \uac83\uc744 \uace0\ub824\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "Medieval Origins \uce90\uc2a4\ud2b8 \uc624\ub958";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "Medieval Origins 6.6.0 \uc774\ud558 \ubc84\uc804\uc744 \uc0ac\uc6a9\ud558\uac70\ub098, mod\uc758 Fabric\uacfc Forge \ubc84\uc804 \uac04\uc5d0 \uc804\ud658\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether\uac00 MusicManager\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 Registry Object\ub85c \uc778\ud574 \uc624\ub958\ub97c \uc77c\uc73c\ud0a4\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc774 \ubb38\uc81c\ub294 Reign of Nether\uc758 MusicManager mixin\uacfc \uad00\ub828\uc774 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "Reign of Nether\uc758 MusicManager \uc624\ub958";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "\uc774 \uc624\ub958\ub97c \ud574\uacb0\ud558\ub824\uba74 Reign of Nether\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uc784\uc2dc\ub85c \uc81c\uac70\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel\uc740 Linux \ub610\ub294 Android\uc5d0\uc11c\ub9cc YSM \uc11c\ubc84\ub97c \uc9c0\uc6d0\ud569\ub2c8\ub2e4. \uc774 \ubb38\uc81c\ub294 2025\ub144 11\uc6d4 23\uc77c \uc774\ud6c4 Modrinth\uc758 \ucd5c\uc2e0 \ubc84\uc804\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel\uc774 Linux\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\uc74c";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "Modrinth\uc5d0\uc11c YesSteveModel\uc744 \ucd5c\uc2e0 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694. \uc774 \ubb38\uc81c\ub294 11\uc6d4 23\uc77c \uc774\ud6c4 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Moving Elevators\uc640 OptiFine \uac04\uc5d0 \uc2ec\uac01\ud55c \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub4e4\uc740 \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70, \uc8fc\uc785 \uc2e4\ud328\ub85c \uc778\ud574 \uac8c\uc784 \uc2dc\uc791\uc744 \ubc29\ud574\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "Moving Elevators\uc640 OptiFine \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "Moving Elevators \ub610\ub294 OptiFine\uc744 \uc81c\uac70\ud558\uc138\uc694. \uc774 \ub458\uc740 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Fabric API(fabric-resource-loader-v0)\uc640 OptiFine \uac04\uc5d0 \uc2ec\uac01\ud55c \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub4e4\uc740 \ud638\ud658\ub418\uc9c0 \uc54a\uc73c\uba70, \uc8fc\uc785 \uc2e4\ud328\ub85c \uc778\ud574 \uac8c\uc784 \uc2dc\uc791\uc744 \ubc29\ud574\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "Fabric API\uc640 OptiFine \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "OptiFine\uc744 \uc81c\uac70\ud558\uac70\ub098 Fabric API\ub97c \ud638\ud658\ub418\ub294 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc77c\ubd80 \ubaa8\ub4dc\uc5d0 \uc778\uc2a4\ud134\uc2a4\ud654\ud560 \uc218 \uc5c6\ub294 \uacb0\ud568 \uc788\ub294 ITransformationService\uac00 \uc788\uc2b5\ub2c8\ub2e4: " + claseProveedor + ". \uac8c\uc784 \ub85c\ub4dc\ub97c \ud5c8\uc6a9\ud558\ub824\uba74 \uc774 \ubaa8\ub4dc\ub97c \uc81c\uac70\ud574\uc57c \ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "\uacb0\ud568 \uc788\ub294 ITransformationService";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "\uacb0\ud568 \uc788\ub294 ITransformationService\ub97c \uac00\uc9c4 " + claseProveedor + " \ud074\ub798\uc2a4\ub97c \ud3ec\ud568\ud55c \ubaa8\ub4dc\ub97c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\uc77c\ubd80 \ubaa8\ub4dc\uac00 \uc798\ubabb\ub41c \ubc84\uc804 \uc9c0\uc815\uc744 \uac00\uc9c0\uace0 \uc788\uc2b5\ub2c8\ub2e4. \ubc84\uc804\uc740 \ub300\uad04\ud638([])\ub85c \ub458\ub7ec\uc2f8\uc5ec\uc57c \ud569\ub2c8\ub2e4. \uce21\uba74 \ud328\ub110\uc758 grep/greprf \uc720\ud2f8\ub9ac\ud2f0\ub97c \uc0ac\uc6a9\ud558\uc5ec \ubc84\uc804 </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'> \uc744 \uac80\uc0c9\ud574 \ubb38\uc81c\uc758 \ubaa8\ub4dc\ub97c \uc2dd\ubcc4\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "\ubaa8\ub4dc\uc758 \uc798\ubabb\ub41c \ubc84\uc804";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "\uce21\uba74 \ud328\ub110\uc758 grep/greprf \uc720\ud2f8\ub9ac\ud2f0\ub97c \uc0ac\uc6a9\ud558\uc5ec \ubb38\uc81c\uc758 \ubc84\uc804\uc744 \uac80\uc0c9\ud558\uace0 \uc774\ub97c \ud3ec\ud568\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc73c\uc138\uc694.";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>stack smashing \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc5b4 \ud504\ub85c\uc138\uc2a4\uac00 \uc885\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774\ub294 Forge/NeoForge/PillowMC\uc758 Early Window \ubb38\uc81c\ub098 LWJGL 3.2.2 \uc774\uc0c1 \ubc84\uc804\uacfc \uad00\ub828\ub420 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "Stack Smashing \uac10\uc9c0\ub428";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "Early Window \uc124\uc815\uc744 \ud655\uc778\ud558\uace0, \ub2e4\ub978 \ubc84\uc804\uc758 LWJGL\uc744 \uc0ac\uc6a9\ud558\uac70\ub098 \ucd08\uae30 \ucc3d \uad00\ub828 \ubaa8\ub4dc\ub97c \uc810\uac80\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore\ub294 \ud2b9\uc815 modpack \uc804\uc6a9\uc774\uba70, \uc77c\ubc18 \uc124\uce58\uc5d0 \uc0ac\uc6a9\ud574\uc11c\ub294 \uc548 \ub429\ub2c8\ub2e4. \uadf8\ub807\uc9c0 \uc54a\uc73c\uba74 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "Java \ubc84\uc804\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\ub294 GregTechEasyCore";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore\ub97c \uc81c\uac70\ud558\uc138\uc694. \uc774\ub294 \ud2b9\uc815 modpack \uc804\uc6a9\uc774\uba70 \uc77c\ubc18 \uc124\uce58\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MoniLabs\uc640 Connector Extras \uc0ac\uc774\uc5d0 KubeJS \uc218\uc815\uacfc \uad00\ub828\ub41c \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ubaa8\ub4dc\ub4e4\uc740 KubeJS \uc218\uc815 \uce21\uba74\uc5d0\uc11c \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "MoniLabs\uc640 Connector Extras \ucda9\ub3cc";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "KubeJS \uc218\uc815\uc774 \ucda9\ub3cc\ud558\ubbc0\ub85c MoniLabs \ub610\ub294 Connector Extras \uc911 \ud558\ub098\ub97c \uc81c\uac70\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris\ub294 Distant Horizons [2.0.4] \ub610\ub294 DH API \ubc84\uc804 [1.1.0] \uc774\uc0c1\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. \ubb38\uc81c\ub97c \ud574\uacb0\ud558\ub824\uba74 \ud638\ud658\uc131 \uc548\ub0b4\ub97c \ucc38\uc870\ud558\uc138\uc694: https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "Iris\uc640 Distant Horizons \ud638\ud658\uc131";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e \uc5d0\uc11c \ud638\ud658\uc131 \uc548\ub0b4\ub97c \ud655\uc778\ud558\uace0 Iris \ubc0f Distant Horizons\ub97c \ud638\ud658\ub418\ub294 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Minecraft\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ub2e4\ub978 \uac8c\uc784 \ubc84\uc804\uc6a9 \ubaa8\ub4dc\ub97c \uc0ac\uc6a9\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a>\ub97c \uc0ac\uc6a9\ud558\uc5ec \ud574\ub2f9 \ud074\ub798\uc2a4\uac00 \uc0ac\uc6a9 \uc911\uc778 \ubc84\uc804\uc5d0 \uc874\uc7ac\ud558\ub294\uc9c0 \ud655\uc778\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</li><li>Minecraft \uc124\uce58\uac00 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4 (CurseForge \uc571, ModrinthApp/Theseus/Astralrinth \ub4f1 \ubaa8\ub4dc\ud329 \ub7f0\ucc98\uc5d0\uc11c \ud754\ud568). CurseForge \ubb38\uc81c \ud574\uacb0\uc744 \uc704\ud574 <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\ud29c\ud1a0\ub9ac\uc5bc \ubcf4\uae30</a>.</li><li>\uc190\uc0c1\ub41c coremod\uac00 \uc788\uc2b5\ub2c8\ub2e4 (coremod\uac00 \uc2e4\ud328\ud558\uba74 \ud074\ub798\uc2a4 \ub85c\ub4dc\ub97c \ub9c9\uc744 \uc218 \uc788\uc74c).</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>DangerZone\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ub2e4\ub978 \uac8c\uc784 \ubc84\uc804\uc6a9 \ubaa8\ub4dc\ub97c \uc0ac\uc6a9\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.</li><li>\uc190\uc0c1\ub41c coremod\uac00 \uc788\uc2b5\ub2c8\ub2e4.</li><li>\ub7f0\ucc98 \ub610\ub294 \uc124\uce58\uac00 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FeatureCreep\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ub2e4\ub978 \ubc84\uc804\uc758 FeatureCreep(\uc608: ESR \ub300 Nightly \ub610\ub294 v4 \ub300 v12)\uc6a9 \ubaa8\ub4dc\ub97c \uc0ac\uc6a9\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.</li><li>CurseForge\ub098 MinecraftStorage\uc5d0\uc11c FeatureCreep\uc744 \uc124\uce58\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModLauncher\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ubaa8\ub4dc\uac00 MinecraftForge, PillowMC \ub610\ub294 NeoForge\uc758 \ub2e4\ub978 \ube4c\ub4dc\uc6a9\uc785\ub2c8\ub2e4 (ModLauncher\ub294 \uc774 \ub85c\ub354\ub4e4\uacfc \ud568\uaed8 \uc0ac\uc6a9\ub428).</li><li>Minecraft \ud55c \ubc84\uc804\uc5d0 \ub300\ud574 \uc5ec\ub7ec modloader \uc5c5\ub370\uc774\ud2b8\uac00 \uc874\uc7ac\ud569\ub2c8\ub2e4.</li><li>\ub7f0\ucc98 \uc124\uce58\uac00 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4 (CurseForge \uc571, ModrinthApp/Theseus/Astralrinth \ub4f1\uc5d0\uc11c \ud754\ud568). CurseForge \ubb38\uc81c \ud574\uacb0\uc744 \uc704\ud574 <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\ud29c\ud1a0\ub9ac\uc5bc \ubcf4\uae30</a>.</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Minecraft Forge\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ubaa8\ub4dc\uac00 MinecraftForge\uc758 \ub2e4\ub978 \ube4c\ub4dc\uc6a9\uc785\ub2c8\ub2e4.</li><li>Minecraft \ud55c \ubc84\uc804\uc5d0 \ub300\ud574 \uc5ec\ub7ec modloader \uc5c5\ub370\uc774\ud2b8\uac00 \uc874\uc7ac\ud569\ub2c8\ub2e4.</li><li>\uc124\uce58\uac00 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4 (CurseForge \uc571, ModrinthApp/Theseus/Astralrinth \ub4f1\uc5d0\uc11c \ud754\ud568). CurseForge \ubb38\uc81c \ud574\uacb0\uc744 \uc704\ud574 <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\ud29c\ud1a0\ub9ac\uc5bc \ubcf4\uae30</a>.</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>NeoForge\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ubaa8\ub4dc\uac00 NeoForge\uc758 \ub2e4\ub978 \ube4c\ub4dc\uc6a9\uc785\ub2c8\ub2e4.</li><li>Minecraft \ud55c \ubc84\uc804\uc5d0 \ub300\ud574 \uc5ec\ub7ec modloader \uc5c5\ub370\uc774\ud2b8\uac00 \uc874\uc7ac\ud569\ub2c8\ub2e4.</li><li>\uc124\uce58\uac00 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4 (CurseForge \uc571, ModrinthApp/Theseus/Astralrinth \ub4f1\uc5d0\uc11c \ud754\ud568). CurseForge \ubb38\uc81c \ud574\uacb0\uc744 \uc704\ud574 <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\ud29c\ud1a0\ub9ac\uc5bc \ubcf4\uae30</a>.</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Fabric Loader\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ubaa8\ub4dc\uac00 Fabric Loader\uc758 \ub2e4\ub978 \ube4c\ub4dc\uc6a9\uc785\ub2c8\ub2e4.</li><li>Minecraft \ud55c \ubc84\uc804\uc5d0 \ub300\ud574 \uc5ec\ub7ec modloader \uc5c5\ub370\uc774\ud2b8\uac00 \uc874\uc7ac\ud569\ub2c8\ub2e4.</li><li>\uc124\uce58\uac00 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4 (CurseForge \uc571, ModrinthApp/Theseus/Astralrinth \ub4f1\uc5d0\uc11c \ud754\ud568). CurseForge \ubb38\uc81c \ud574\uacb0\uc744 \uc704\ud574 <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\ud29c\ud1a0\ub9ac\uc5bc \ubcf4\uae30</a>.</li><li>\ub9ce\uc740 \ubaa8\ub4dc\uac00 Fabric API\ub97c \ud544\uc694\ub85c \ud569\ub2c8\ub2e4. \ud544\uc694\ud558\ub2e4\uba74 Fabric API\ub97c \uc124\uce58\ud558\uc138\uc694.</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>PillowMC\uc758 \ud074\ub798\uc2a4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uc6d0\uc778:</b><ul><li>\ubaa8\ub4dc\uac00 PillowMC\uc758 \ub2e4\ub978 \ube4c\ub4dc\uc6a9\uc785\ub2c8\ub2e4.</li><li>Minecraft \ud55c \ubc84\uc804\uc5d0 \ub300\ud574 \uc5ec\ub7ec modloader \uc5c5\ub370\uc774\ud2b8\uac00 \uc874\uc7ac\ud569\ub2c8\ub2e4.</li><li>\uc124\uce58\uac00 \uc190\uc0c1\ub418\uc5c8\uc2b5\ub2c8\ub2e4 (CurseForge \uc571, ModrinthApp/Theseus/Astralrinth \ub4f1\uc5d0\uc11c \ud754\ud568). CurseForge \ubb38\uc81c \ud574\uacb0\uc744 \uc704\ud574 <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\ud29c\ud1a0\ub9ac\uc5bc \ubcf4\uae30</a>.</li></ul><p>\ucc38\uace0: \uc774\ub984\uc5d0 '/'\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \uc0ac\uc774\ub4dc\ubc14\uc758 <b>grepr/fgrepr</b> \ub3c4\uad6c\ub85c \ub204\ub77d\ub41c \ud074\ub798\uc2a4\ub97c \ucc38\uc870\ud558\ub294 \ubaa8\ub4dc\ub97c \ucc3e\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\uc758\ub3c4\uc801\uc73c\ub85c \ub809\uc744 \uc720\ubc1c\ud558\ub294 \ubaa8\ub4dc\uac00 \uc124\uce58\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4. Uranium\uc740 \ub809 \ubaa8\ub4dc\uc785\ub2c8\ub2e4. \ud56d\uc0c1 \uc624\ub958\ub97c \uc77c\uc73c\ud0a4\ub294 \uac83\uc740 \uc544\ub2c8\uc9c0\ub9cc \uacb0\uad6d \ubb38\uc81c\ub97c \uc77c\uc73c\ud0ac \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack\ub294 1.19.*\uc640 \ud638\ud658\ub418\ub294 \uac83\uc73c\ub85c \ud45c\uc2dc\ub418\uc5b4 \uc788\uc9c0\ub9cc \uc2e4\uc81c\ub85c\ub294 1.20.*\uc6a9\uc774\uba70, \uc774\ub85c \uc778\ud574 \ud074\ub798\uc2a4\ub97c \ucc3e\uc744 \uc218 \uc5c6\ub2e4\ub294 \uc624\ub958\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ud574\ub2f9 \ubaa8\ub4dc\ub294 \ud604\uc7ac Minecraft \ubc84\uc804\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 DamageSources\ub97c \uc0ac\uc6a9\ud558\ub824\uace0 \uc2dc\ub3c4\ud569\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "Falling Attack \ubc84\uc804 \uc624\ub958";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "\uc0ac\uc6a9 \uc911\uc778 Minecraft \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294 \uc62c\ubc14\ub978 Falling Attack \ubc84\uc804\uc744 \uc0ac\uc6a9\ud558\uace0 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("\uc774 \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud558\ub824\uba74 CFR(Class File Reader)\ub97c \uc124\uce58\ud574\uc57c \ud569\ub2c8\ub2e4.<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("Linux, NetBSD \ub610\ub294 FreeBSD \uc2dc\uc2a4\ud15c\uc5d0\uc11c\ub294 \ud328\ud0a4\uc9c0 \uad00\ub9ac\uc790\ub97c \ud1b5\ud574 CFR\ub97c \uc124\uce58\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.<br>").append("\ub2e4\uc74c\uc5d0\uc11c \ud328\ud0a4\uc9c0\ub97c \uac80\uc0c9\ud558\uc138\uc694: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("\ub610\ub294 FabricMC\uac00 \uc0ac\uc6a9\ud558\ub294 \uc218\uc815\ub41c \ubc84\uc804\uc744 \ub2e4\uc74c\uc5d0\uc11c \ub2e4\uc6b4\ub85c\ub4dc\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("\ub2e4\uc74c\uc744 \ud3f4\ub354\uc5d0 \uc800\uc7a5\ud558\uc138\uc694:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>\uc911\uc694:</b> CFR \uc124\uce58 \ud6c4 mod\ub97c \uc7ac\uc2dc\uc791\ud574\uc57c \uc815\uc0c1\uc801\uc73c\ub85c \uc778\uc2dd\ub429\ub2c8\ub2e4.").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "\uc0ac\uc6a9 \uac00\ub2a5\ud55c \ucd08\uc0c1\ud654 \uc5c6\uc74c";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "\ud074\ub798\uc2a4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "CFR \ub514\ucef4\ud30c\uc77c\ub7ec \u2013 Sakura Riddle (\ube44\uacf5\uc2dd)";
    }

    @Override
    public String cfrClaseActual() {
        return "\ud604\uc7ac \ud074\ub798\uc2a4";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "Sakura Riddle \ucd08\uc0c1\ud654";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "\ucd08\uc0c1\ud654 \ub85c\ub4dc \uc624\ub958";
    }

    @Override
    public String noticiaLegalCFR() {
        return "\uc774 \uadf8\ub798\ud53d \uc0ac\uc6a9\uc790 \uc778\ud130\ud398\uc774\uc2a4(GUI) \ub514\ucef4\ud30c\uc77c \ud504\ub85c\uadf8\ub7a8\uc740 \ubaa8\ub4dc\uc758 \uc18c\ud504\ud2b8\uc6e8\uc5b4 \uc624\ub958 \uc6d0\uc778\uc744 \ud30c\uc545\ud558\ub294 \ub370 \ub3c4\uc6c0\uc744 \uc8fc\uae30 \uc704\ud574 \uc124\uacc4\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uadf8\ub7ec\ub098 \ubaa8\ub4dc \ub514\ucef4\ud30c\uc77c\uc740 \ud544\uc694\ud560 \uc218 \uc788\uc73c\ub098, \uc0ac\uc6a9\uc790\ub294 \uc0dd\uc131\ub41c \ucf54\ub4dc\ub85c \uc800\uc791\uad8c\ubc95\uc744 \uc704\ubc18\ud558\uc9c0 \uc54a\ub3c4\ub85d \uc8fc\uc758\ud574\uc57c \ud569\ub2c8\ub2e4. \uc5bb\uc740 \ucf54\ub4dc\ub97c \uc0ac\uc6a9\ud558\uae30 \uc804 \ud574\ub2f9 \ubaa8\ub4dc\uc758 \ub77c\uc774\uc120\uc2a4\ub97c \ubc18\ub4dc\uc2dc \ud655\uc778\ud558\uc2ed\uc2dc\uc624. \ub9ce\uc740 \ubaa8\ub4dc\ub294 \uacf5\uc2dd\uc801\uc73c\ub85c \uc18c\uc2a4 \ucf54\ub4dc\ub97c \uc81c\uacf5\ud558\uba70, \uc774\ub294 \ub514\ucef4\ud30c\uc77c\ub41c \ucf54\ub4dc\ubcf4\ub2e4 \uc77c\ubc18\uc801\uc73c\ub85c \ub354 \uae54\ub054\ud558\uace0 \uc774\ud574\ud558\uae30 \uc27d\uc2b5\ub2c8\ub2e4. \uc9c0\uc801 \uc7ac\uc0b0\uad8c\uacfc \uc0ac\uc6a9 \ub77c\uc774\uc120\uc2a4\ub97c \uc874\uc911\ud558\ub294 \uac83\uc774 \ubaa8\ub4dc \uac1c\ubc1c \ucee4\ubba4\ub2c8\ud2f0\uc758 \uae30\ubcf8\uc785\ub2c8\ub2e4. \uba55\uc2dc\ucf54 \uc5f0\ubc29 \uc800\uc791\uad8c\ubc95\uc740 \ub2e4\uc74c \ub9c1\ud06c\uc5d0\uc11c \ud655\uc778\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor (\uc2a4\ud398\uc778\uc5b4)</a> \uc601\ubb38\ud310\uc740 \uc5ec\uae30\uc5d0\uc11c: <a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (\uc601\uc5b4)</a>. CurseForge \uc0ac\uc6a9\uc790\uc784\uc744 \uace0\ub824\ud558\uc5ec \ubbf8\uad6d \uc800\uc791\uad8c\ubc95 \ub9c1\ud06c\ub3c4 \uc81c\uacf5\ud569\ub2c8\ub2e4: <a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>. \uc0ac\uc6a9\uc790\ub294 \uc790\uc2e0\uc758 \uc704\uce58\uc5d0\uc11c \uc801\uc6a9\ub418\ub294 \ubc95\ub960\uc744 \uc219\uc9c0\ud558\ub294 \uac83\uc774 \uc911\uc694\ud569\ub2c8\ub2e4. \uc774 GUI\ub294 \uac04\ub2e8\ud55c \ud655\uc778 \uc804\uc6a9\uc774\uba70, \uace0\uae09 \ubd84\uc11d\uc744 \uc704\ud574\uc11c\ub294 FabricMC\uc758 Enigma \ud3ec\ud06c\ub97c \uc0ac\uc6a9\ud558\uc2ed\uc2dc\uc624: <a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>. \uc18c\uc2a4 \ucf54\ub4dc\uac00 \uc5c6\uc744 \ub54c JAR \ud30c\uc77c\uc744 \uc9c1\uc811 \ud3b8\uc9d1\ud574 \ud328\uce58\ud558\ub824\uba74 Recaf\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4: <a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">\uacf5\uc2dd \uc0ac\uc774\ud2b8</a>.";
    }

    @Override
    public String botonDescargarCfr() {
        return "CFR \ub2e4\uc6b4\ub85c\ub4dc";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "\uc124\uce58 \ud3f4\ub354 \uc5f4\uae30";
    }

    @Override
    public String colorFondoPrincipal() {
        return "\uc8fc \ubc30\uacbd\uc0c9";
    }

    @Override
    public String colorTextoBotonReset() {
        return "\ucd08\uae30\ud654 \ub2e8\ucd94 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "\uac80\uc0c9\ub780 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "\ud544\ud130 \ud3bc\uce68\uba54\ub274 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoRenderer() {
        return "\ub80c\ub354\ub7ec \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "\ub85c\ub529 \uc624\ubc84\ub808\uc774 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorBorde() {
        return "\ud14c\ub450\ub9ac \uc0c9";
    }

    @Override
    public String colorFondoRetrato() {
        return "\ucd08\uc0c1\ud654 \ubaa8\ub4dc \ubc30\uacbd\uc0c9";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "\uacf5\uc720 \ub9c1\ud06c \uc0c9\uc0c1";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "\uacf5\uc720\ub780 \ubc30\uacbd\uc0c9";
    }

    @Override
    public String rosaFondo() {
        return "\ubc30\uacbd \ud551\ud06c\uc0c9";
    }

    @Override
    public String rosaSuave() {
        return "\ubd80\ub4dc\ub7ec\uc6b4 \ud551\ud06c";
    }

    @Override
    public String moradoAcento() {
        return "\uac15\uc870 \ubcf4\ub77c\uc0c9";
    }

    @Override
    public String textoOscuro() {
        return "\uc5b4\ub450\uc6b4 \uae00\uc790";
    }

    @Override
    public String bordeSuave() {
        return "\ubd80\ub4dc\ub7ec\uc6b4 \ud14c\ub450\ub9ac";
    }

    @Override
    public String fondoCampo() {
        return "\ud544\ub4dc \ubc30\uacbd";
    }

    @Override
    public String fondoVistaPrevia() {
        return "\ubbf8\ub9ac\ubcf4\uae30 \ubc30\uacbd";
    }

    @Override
    public String sintaxisConstructor() {
        return "\uad6c\ubb38 \uac15\uc870 \uc0c9: \uc0dd\uc131\uc790";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "\uad6c\ubb38 \uac15\uc870 \uc0c9: \ub3c4\uc6c0\ub9d0 \uba54\uc2dc\uc9c0";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "\uad6c\ubb38 \uac15\uc870 \uc0c9: HTML \ud0dc\uadf8";
    }

    @Override
    public String colorFondoVentana() {
        return "\ucc3d \ubc30\uacbd\uc0c9";
    }

    @Override
    public String colorPanel() {
        return "\ud328\ub110 \uc0c9";
    }

    @Override
    public String colorBotonTexto() {
        return "\ub2e8\ucd94 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorCampo() {
        return "\ud544\ub4dc \uc0c9";
    }

    @Override
    public String colorBordeDestacado() {
        return "\uac15\uc870 \ud14c\ub450\ub9ac \uc0c9";
    }

    @Override
    public String colorSeleccionTexto() {
        return "\ud14d\uc2a4\ud2b8 \uc120\ud0dd \ubc30\uacbd\uc0c9";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "\uc120\ud0dd\ub41c \uae00\uc790\uc0c9";
    }

    @Override
    public String colorEstadoExito() {
        return "\uc0c1\ud0dc \uc0c9: \uc131\uacf5";
    }

    @Override
    public String colorEstadoFallo() {
        return "\uc0c1\ud0dc \uc0c9: \uc2e4\ud328";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "\uc0c1\ud0dc \uc0c9: \uc989\uc2dc";
    }

    @Override
    public String colorResultadoAnadido() {
        return "\ucd94\uac00\ub41c \uacb0\uacfc \uc0c9";
    }

    @Override
    public String colorResultadoEliminado() {
        return "\uc0ad\uc81c\ub41c \uacb0\uacfc \uc0c9";
    }

    @Override
    public String colorBordeScroll() {
        return "\uc2a4\ud06c\ub864 \ud14c\ub450\ub9ac \uc0c9";
    }

    @Override
    public String colorFondoPanel() {
        return "\ud328\ub110 \ubc30\uacbd\uc0c9";
    }

    @Override
    public String colorBeigeListas() {
        return "\ubaa9\ub85d \ubca0\uc774\uc9c0\uc0c9";
    }

    @Override
    public String colorTextoListas() {
        return "\ubaa9\ub85d \uae00\uc790\uc0c9";
    }

    @Override
    public String colorBordeListas() {
        return "\ubaa9\ub85d \ud14c\ub450\ub9ac \uc0c9";
    }

    @Override
    public String colorBotonFondo() {
        return "\ub2e8\ucd94 \ubc30\uacbd\uc0c9";
    }

    @Override
    public String colorBordeBoton() {
        return "\ub2e8\ucd94 \ud14c\ub450\ub9ac \uc0c9";
    }

    @Override
    public String colorDoradoTexto() {
        return "\ud669\uae08\ube5b \uae00\uc790\uc0c9";
    }

    @Override
    public String colorPila() {
        return "\uc2a4\ud0dd \ud2b8\ub808\uc774\uc2a4 \uc0c9";
    }

    @Override
    public String colorTextoPanel() {
        return "\ud328\ub110 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoNegro() {
        return "\uac80\uc815 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoPrincipal() {
        return "\uc8fc\uc694 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorFondoResultados() {
        return "\uacb0\uacfc \ubc30\uacbd\uc0c9";
    }

    @Override
    public String colorEstado() {
        return "\uc0c1\ud0dc \uc0c9";
    }

    @Override
    public String colorTextoDescripcion() {
        return "\uc124\uba85 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoEstado() {
        return "\uc0c1\ud0dc \uae00\uc790\uc0c9";
    }

    @Override
    public String colorTextoExtra() {
        return "\ucd94\uac00 \uae00\uc790\uc0c9";
    }

    @Override
    public String colorSeparador() {
        return "\ubd84\ub9ac\uc120 \uc0c9";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "\uae30\ubcf8 \uc624\ub958 <code>StubRoutines::SafeFetch32</code>\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774 \ubb38\uc81c\ub294 macOS\uc5d0\uc11c JDK 17.0.9\ub97c \uc0ac\uc6a9\ud560 \ub54c \ubc1c\uc0dd\ud558\uba70, JDK 17.0.10 \uc774\uc0c1\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4. https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "JDK 17.0.9(macOS)\uc758 SafeFetch32 \uae30\ubcf8 \uc624\ub958";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "JDK\ub97c 17.0.10 \uc774\uc0c1(\uc608: 17.0.15)\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "MultiMC, Prism Launcher \ub610\ub294 TLauncher\uc640 \uac19\uc740 \ub7f0\ucc98\ub97c \uc0ac\uc6a9\ud558\ub294 \uacbd\uc6b0, \ucd5c\uc2e0 JDK\ub97c \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815\ud558\uc138\uc694. \uc77c\ubd80 \ub7f0\ucc98\ub294 \uc774\ubbf8 JDK 17.0.15\ub97c \ub0b4\uc7a5\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "Spark \ubaa8\ub4dc\ub3c4 \uc774 \uc624\ub958\uc5d0 \uc601\ud5a5\uc744 \uc904 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc784\uc2dc\ub85c \ube44\ud65c\uc131\ud654\ud574 \ubcf4\uc138\uc694. https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MCEF(Chromium Embedded Framework) \ubaa8\ub4dc\uac00 \ubb34\uc18c\ub9ac \uc815\uc9c0 \ud604\uc0c1\uc744 \uc77c\uc73c\ud0a4\uace0 \uc788\uc2b5\ub2c8\ub2e4.</b><ul><li>MCEF\uac00 \ub85c\uadf8 \ub05d\ubd80\ubd84\uc5d0\uc11c \ucd08\uae30\ud654\ub418\uace0 \uc788\uc73c\uba70, \uc774\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ub85c\ub529 \uc911 \uac8c\uc784\uc774 \uba48\ucdc4\uc74c\uc744 \uc758\ubbf8\ud569\ub2c8\ub2e4.</li><li>\uc774 \ubaa8\ub4dc\ub294 Linux, macOS \uc2dc\uc2a4\ud15c\uc774\ub098 \ud2b9\uc815 Java \ubc84\uc804\uc5d0\uc11c \ucda9\ub3cc\uc744 \uc720\ubc1c\ud558\uae30\ub85c \uc720\uba85\ud569\ub2c8\ub2e4.</li><li>\uba85\ud655\ud55c \uc624\ub958\uac00 \ud56d\uc0c1 \ub098\ud0c0\ub098\ub294 \uac83\uc740 \uc544\ub2c8\uc9c0\ub9cc, \uac8c\uc784\uc774 \uba54\uc778 \uba54\ub274\uc5d0 \ub3c4\ub2ec\ud558\uc9c0 \ubabb\ud569\ub2c8\ub2e4.</li></ul><p>\uac8c\uc784 \ub0b4 \ube0c\ub77c\uc6b0\uc800 \uae30\ub2a5(\uc6f9 \uc9c0\ub3c4\ub098 \ub0b4\uc7a5 \ud398\uc774\uc9c0 \ub4f1)\uc774 \ud544\uc694 \uc5c6\ub2e4\uba74 \uc774 \ubaa8\ub4dc\ub97c \uc81c\uac70\ud558\uc138\uc694.</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "MCEF(\ub0b4\uc7a5 \ube0c\ub77c\uc6b0\uc800 \ubaa8\ub4dc) \ucd08\uae30\ud654 \ubb38\uc81c";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "'mods' \ud3f4\ub354\uc5d0\uc11c MCEF \ubaa8\ub4dc \ud30c\uc77c(\ud30c\uc77c\uba85\uc5d0 'mcef' \ud3ec\ud568)\uc744 \uc0ad\uc81c\ud558\uc138\uc694.";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "\ubc18\ub4dc\uc2dc \ud544\uc694\ud558\ub2e4\uba74, \uc6b4\uc601\uccb4\uc81c\uc640 Minecraft \ubc84\uc804\uacfc \ud638\ud658\ub418\ub294 MCEF \ubc84\uc804\uc744 \uc0ac\uc6a9\ud558\uc138\uc694.";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>OptiFine</b>\uc640 <b>Iris/Oculus</b> \uc0ac\uc774\uc5d0 \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><ul><li>OptiFine\ub294 Minecraft \ub80c\ub354\ub9c1\uc744 Iris\ub098 Oculus\uc640 \ud638\ud658\ub418\uc9c0 \uc54a\ub294 \ubc29\uc2dd\uc73c\ub85c \uc218\uc815\ud569\ub2c8\ub2e4.</li><li><code>MixinLevelRenderer failed injection check</code> \uc624\ub958\ub294 <code>mixins.iris.json</code> \ub610\ub294 <code>mixins.oculus.json</code>\uc5d0\uc11c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</li></ul><p>\uc774 \ubaa8\ub4dc\ub4e4\uc740 \ud568\uaed8 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. Iris\ub098 Oculus\ub85c \uc250\uc774\ub354\ub97c \uc0ac\uc6a9\ud558\ub824\uba74 OptiFine\uc744 \uc81c\uac70\ud558\uc138\uc694.</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "OptiFine\uacfc Iris/Oculus \ucda9\ub3cc";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "'mods' \ud3f4\ub354\uc5d0\uc11c OptiFine \ud30c\uc77c\uc744 \uc0ad\uc81c\ud558\uc138\uc694.";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "\ud604\ub300\uc2dd \uc250\uc774\ub354\ub97c \uc704\ud574 OptiFine \uc5c6\uc774 Iris \ub610\ub294 Oculus\ub97c \uc0ac\uc6a9\ud558\uc138\uc694.";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>ModernFix</b>\uc640 <b>OptiFine</b> \uc0ac\uc774\uc5d0 \ucda9\ub3cc\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><ul><li>ModernFix\ub294 Forge \uae30\ub2a5\uc744 \ub9dd\uac00\ub728\ub9ac\uace0 \uc2dc\uc791 \uc18d\ub3c4\ub97c \ub290\ub9ac\uac8c \ud558\ubbc0\ub85c OptiFine\uacfc \ud638\ud658\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.</li><li>ModernFix \uc790\uccb4\uac00 \uacbd\uace0\ud569\ub2c8\ub2e4: <i>\"Use of ModernFix with OptiFine is not supported\"</i>.</li></ul><p>\uac8c\uc784\uc774 \uc81c\ub300\ub85c \uc791\ub3d9\ud558\ub824\uba74 \ub450 \ubaa8\ub4dc \uc911 \ud558\ub098\ub97c \uc81c\uac70\ud574\uc57c \ud569\ub2c8\ub2e4.</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "ModernFix\uc640 OptiFine \ucda9\ub3cc";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "'mods' \ud3f4\ub354\uc5d0\uc11c OptiFine \ub610\ub294 ModernFix\ub97c \uc0ad\uc81c\ud558\uc138\uc694. \ud568\uaed8 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "\ucd5c\uc801\ud654\uac00 \ud544\uc694\ud558\ub2e4\uba74 OptiFine\ub9cc \uc0ac\uc6a9\ud558\uac70\ub098, ModernFix \ub300\uc2e0 FerriteCore\ub098 EntityCulling \uac19\uc740 \uac00\ubcbc\uc6b4 \ubaa8\ub4dc\ub97c \uc0ac\uc6a9\ud574 \ubcf4\uc138\uc694.";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u9519\u8bef\uff1a\u6ce8\u518c\u952e\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002</b><ul><li><b>\u68c0\u6d4b\u5230\u7684\u952e\uff1a</b> <code>" + this.escapeHtml(clave) + "</code></li><li>\u5728 Minecraft \u4e2d\uff0c\u6240\u6709\u6ce8\u518c\u952e\uff08\u6807\u7b7e\u3001\u914d\u65b9\u3001\u6210\u5c31\u7b49\uff09\u5fc5\u987b\u4f7f\u7528<b>\u5c0f\u5199\u5b57\u6bcd</b>\uff0c\u4e14\u4ec5\u53ef\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u8fde\u5b57\u7b26\u548c\u659c\u6760\u3002</li><li>\u6b64\u9519\u8bef\u901a\u5e38\u7531\u7f16\u5199\u4e0d\u5f53\u7684\u6a21\u7ec4\u6216\u6709\u7f3a\u9677\u7684 datapack \u5f15\u8d77\u3002</li></ul><p><b>\u91cd\u8981\u63d0\u793a\uff1a</b>\u4f7f\u7528\u4fa7\u8fb9\u680f\u4e2d\u7684 <b>grepr</b> \u6216 <b>fgrepr</b> \u5de5\u5177\uff0c\u5e76\u542f\u7528 <b>\u201c\u5728 JAR \u6587\u4ef6\u4e2d\u641c\u7d22\u201d</b> \u9009\u9879\uff0c\u4ee5\u627e\u51fa\u5305\u542b\u6b64\u65e0\u6548\u952e\u7684\u6a21\u7ec4\u3002</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "\u6ce8\u518c\u952e\u5305\u542b\u5927\u5199\u5b57\u6bcd\u6216\u975e\u6cd5\u5b57\u7b26";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "\u4f7f\u7528 'grepr' \u6216 'fgrepr' \u5e76\u5f00\u542f\u201c\u5728 JAR \u6587\u4ef6\u4e2d\u641c\u7d22\u201d\u4ee5\u5b9a\u4f4d\u95ee\u9898\u6a21\u7ec4\u3002";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "\u5982\u679c\u65e0\u6cd5\u786e\u5b9a\u5177\u4f53\u6a21\u7ec4\uff0c\u8bf7\u79fb\u9664\u6700\u8fd1\u5b89\u88c5\u7684\u6a21\u7ec4\uff0c\u5c24\u5176\u662f\u90a3\u4e9b\u6dfb\u52a0\u65b9\u5757\u3001\u7269\u54c1\u6216\u5de5\u5177\u7684\u6a21\u7ec4\u3002";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>" + this.escapeHtml(modNombre) + "</b> \ubaa8\ub4dc\ub97c \ub85c\ub4dc\ud558\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.</b><ul><li>\ud574\ub2f9 \ubaa8\ub4dc\uac00 \uad6c\uc131 \uc694\uc18c(\uc608: \uc124\uc815 \uba54\ub274)\ub97c \ucd08\uae30\ud654\ud558\ub294 \ub370 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.</li><li>\uc774\ub294 \uc77c\ubc18\uc801\uc73c\ub85c Minecraft, Fabric \ub610\ub294 \ub2e4\ub978 \ubaa8\ub4dc\uc640\uc758 \ubc84\uc804 \ubd88\uc77c\uce58\ub85c \uc778\ud574 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</li></ul><p>\uc624\ub958\uac00 \uc9c0\uc18d\ub418\uba74 <b>" + this.escapeHtml(modNombre) + "</b> \ubaa8\ub4dc\ub97c \uc0ad\uc81c\ud558\uac70\ub098 \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "\ubaa8\ub4dc \ucd08\uae30\ud654 \uc624\ub958(Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "'mods' \ud3f4\ub354\uc5d0\uc11c '" + modNombre + "' \ubaa8\ub4dc\ub97c \uc0ad\uc81c\ud558\uc138\uc694.";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "'" + modNombre + "' \ubaa8\ub4dc\ub97c \ud604\uc7ac \uc124\uce58\uc640 \ud638\ud658\ub418\ub294 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>En Garde!</b> \ubaa8\ub4dc\uc640 \uad00\ub828\ub41c \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><ul><li>\uc774 \ubaa8\ub4dc\ub294 \uadfc\uc811 \uc804\ud22c \uba54\ucee4\ub2c8\uc998(\ud328\ub9ac, \ube14\ub85c\ud0b9 \ub4f1)\uc744 \ucd94\uac00\ud569\ub2c8\ub2e4.</li><li>\uc774 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ub2e4\ub978 \uc804\ud22c \ubaa8\ub4dc(Epic Fight, DualRiders \ub4f1)\uc640\uc758 \ud638\ud658\uc131 \ubb38\uc81c\ub098 Minecraft\uc5d0 \ub9de\uc9c0 \uc54a\ub294 \ubc84\uc804 \uc0ac\uc6a9\uc73c\ub85c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</li></ul><p>\uace0\uae09 \uc804\ud22c\ub97c \uc0ac\uc6a9\ud558\uc9c0 \uc54a\ub294\ub2e4\uba74 \ucda9\ub3cc\uc744 \ubc29\uc9c0\ud558\uae30 \uc704\ud574 En Garde!\ub97c \uc81c\uac70\ud558\ub294 \uac83\uc744 \uace0\ub824\ud574 \ubcf4\uc138\uc694.</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "En Garde! \ubaa8\ub4dc \uc624\ub958";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "En Garde!\uc758 \ubc84\uc804\uc774 \uc0ac\uc6a9 \uc911\uc778 Minecraft \ubc0f \ub85c\ub354(Fabric/Forge)\uc640 \ud638\ud658\ub418\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "\ub2e4\ub978 \uc804\ud22c \ubaa8\ub4dc(Epic Fight, Caelus \ub4f1)\ub97c \uc0ac\uc6a9 \uc911\uc774\ub77c\uba74 \ube44\ud65c\uc131\ud654\ud558\uac70\ub098 En Garde!\ub97c \uc81c\uac70\ud558\uc5ec \ucda9\ub3cc\uc744 \ubc29\uc9c0\ud558\uc138\uc694.";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>IdleTweaks</b> \ubaa8\ub4dc\ub85c \uc778\ud55c \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><ul><li>IdleTweaks\uac00 \uc774\ubbf8 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \ub124\ud2b8\uc6cc\ud06c \ucc44\ub110\uc744 \ud574\uc81c\ud558\ub824 \uc2dc\ub3c4\ud588\uc2b5\ub2c8\ub2e4 (<code>Tried to release unknown channel</code>).</li><li>\uc774 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ubaa8\ub4dc\uc758 \uc774\uc804 \ubc84\uc804\uc774\ub098 \uc798\ubabb \uad6c\uc131\ub41c \uc11c\ubc84\uc5d0\uc11c \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</li></ul><p>IdleTweaks\ub294 \ud3b8\uc758\uc131 \ubaa8\ub4dc\uc774\uc9c0\ub9cc \ubd88\uc548\uc815\uc744 \uc720\ubc1c\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uc81c\uac70\ud558\ub294 \uac83\uc744 \uace0\ub824\ud558\uc138\uc694.</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "IdleTweaks \uc624\ub958 (\uc54c \uc218 \uc5c6\ub294 \ub124\ud2b8\uc6cc\ud06c \ucc44\ub110)";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "IdleTweaks\ub97c \uc0ac\uc6a9 \uc911\uc778 Minecraft\uc640 \ud638\ud658\ub418\ub294 \ucd5c\uc2e0 \ubc84\uc804\uc73c\ub85c \uc5c5\ub370\uc774\ud2b8\ud558\uc138\uc694.";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "\ud544\uc694\ud558\uc9c0 \uc54a\ub2e4\uba74 'mods' \ud3f4\ub354\uc5d0\uc11c IdleTweaks\ub97c \uc0ad\uc81c\ud558\uc138\uc694.";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Minecraft\uc5d0 \ub85c\uadf8\uc778 \uc2dc\ub3c4 \uc911 \uc778\uc99d \uc624\ub958(HTTP 401)\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><p>\uc774 \uc624\ub958\ub294 <b>\ud06c\ub798\uc2dc\uc758 \uc9c1\uc811\uc801 \uc6d0\uc778\uc774 \ub4dc\ubb3c\uc9c0\ub9cc</b>, \uc778\uc99d\ub418\uc9c0 \uc54a\uc740 \uacc4\uc815(\ubd88\ubc95 \ubcf5\uc81c\ud310)\uc744 \uc0ac\uc6a9 \uc911\uc784\uc744 \ub098\ud0c0\ub0c5\ub2c8\ub2e4.</p><p>\uacf5\uc2dd \uc9c0\uc6d0 \ucc44\ub110(\uae30\uc5c5 \ud504\ub85c\uc81d\ud2b8, VTuber, \ubaa8\ub4dc\ud329 \uc81c\uc791\uc790 \ub4f1)\uc740 \ubcf5\uc81c\ud310\uc744 \uc0ac\uc6a9\ud560 \uacbd\uc6b0 <b>\ub3c4\uc6c0\uc744 \uc904 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4</b>. \uc774\ub294 \ucc44\ud305 \uaddc\uc815, \uacc4\uc57d, Mojang/Microsoft\uc640\uc758 \ud611\uc57d, \ub610\ub294 \uba85\uc131 \uc815\ucc45\uc0c1\uc758 \uc81c\ud55c \ub54c\ubb38\uc785\ub2c8\ub2e4.</p><p>\uc774 \ud655\uc778\uc740 \uac80\ucd9c\uae30\uc758 <b>\uae30\uc5c5 \uc124\uc815\uc5d0\uc11c \ube44\ud65c\uc131\ud654\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4</b>. \uacbd\uace0: \ubd88\ubc95 \ubcf5\uc81c \uac10\uc9c0\ub294 <b>\uc644\ubcbd\ud558\uc9c0 \uc54a\uc73c\uba70</b>, \uac1c\ubc1c \ud658\uacbd, \ubd88\uc548\uc815\ud55c \uc778\ud130\ub137, \uc218\uc815\ub41c \ub7f0\ucc98 \uc0ac\uc6a9 \uc2dc \uc798\ubabb \uc791\ub3d9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>\uadf8\ub798\ub3c4 \uc9c0\uc6d0\uc5d0 \ucc38\uc5ec\ud558\ub824 \ud55c\ub2e4\uba74, \ub2e4\uc74c \uad8c\ub9ac \uc548\ub0b4\ub97c \uc219\uc9c0\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "\ubd88\ubc95 \ubcf5\uc81c\ub41c Minecraft";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "\ubd88\ubc95 \ubcf5\uc81c \ud655\uc778 \ube44\ud65c\uc131\ud654";
    }

    @Override
    public String comprarMC() {
        return "Minecraft \uad6c\ub9e4";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\ub2f9\uc2e0\uc740 \ucd94\ucc9c \ubaa9\ub85d\uc5d0 \uc5c6\ub294 \ub7f0\ucc98 <code>" + id + "</code>\ub97c \uc0ac\uc6a9\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>\uc791\ub3d9\ud560 \uc218\ub3c4 \uc788\uc9c0\ub9cc, \ube44\ucd94\ucc9c \ub7f0\ucc98\ub294 \ud754\ud788 \ub2e4\uc74c\uc744 \uc77c\uc73c\ud0b5\ub2c8\ub2e4:</p><ul><li>\ubaa8\ub4dc \ub610\ub294 \uc571\uc758 \uc190\uc0c1\ub41c \uc124\uce58.</li><li>\uac8c\uc784\uc774 \uc2dc\uc791\ub418\uc9c0 \uc54a\uac70\ub098 \uba85\ud655\ud55c \uc624\ub958 \uc5c6\uc774 \uba48\ucda4.</li><li>\ube44\uc815\uc0c1\uc801\uc778 \ud3f4\ub354 \uad6c\uc870(\uc9c4\ub2e8\uc744 \uc5b4\ub835\uac8c \ud568).</li><li>Java, \uba54\ubaa8\ub9ac \ub610\ub294 \ubaa8\ub4dc\uc5d0 \ub300\ud55c \uc608\uce21 \ubd88\uac00\ud55c \ub3d9\uc791.</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "\ub354 \ub098\uc740 \uacbd\ud5d8\uc744 \uc704\ud574 \ub2e4\uc74c \ucd94\ucc9c \ub7f0\ucc98 \uc911 \ud558\ub098\ub97c \uc0ac\uc6a9\ud558\uc138\uc694:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "\ube44\ucd94\ucc9c \ub7f0\ucc98";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "\ucd94\ucc9c \ubaa9\ub85d\uc758 \ub7f0\ucc98\ub85c \ubcc0\uacbd\ud558\uc138\uc694.";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\ub2f9\uc2e0\uc740 <b>\uc0ac\uc6a9\uc744 \uad8c\uc7a5\ud558\uc9c0 \uc54a\ub294 \ub7f0\ucc98</b>\ub97c \uc0ac\uc6a9 \uc911\uc785\ub2c8\ub2e4: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>\uad8c\uc7a5\ud558\uc9c0 \uc54a\ub294 \ub7f0\ucc98\ub294 \ub2e4\uc74c\uc744 \uc57c\uae30\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4:</p><ul><li>\uc571 \ub610\ub294 \ubaa8\ub4dc\uc758 \uc190\uc0c1\ub41c \uc124\uce58.</li><li>\uac8c\uc784\uc774 \uc2dc\uc791\ub418\uc9c0 \uc54a\uac70\ub098 \uc870\uc6a9\ud788 \uc2e4\ud328.</li><li>\ube44\uc815\uc0c1\uc801\uc778 \ud30c\uc77c \uad6c\uc870(\ub514\ubc84\uadf8 \uace4\ub780).</li><li>\ubaa8\ub4dc, Java, \uba54\ubaa8\ub9ac\ub97c \uc5b4\ub5bb\uac8c \uad00\ub9ac\ud558\ub294\uc9c0 \ubd88\ud655\uc2e4.</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "\ub2e4\uc74c \ub7f0\ucc98 \uc911 \ud558\ub098\ub97c \uc0ac\uc6a9\ud558\ub294 \uac83\uc744 \uac15\ub825\ud788 \uad8c\uc7a5\ud569\ub2c8\ub2e4:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "\uad8c\uc7a5\ud558\uc9c0 \uc54a\ub294 \ub7f0\ucc98";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "\uc9c0\uc6d0\uc744 \ubc1b\uc73c\ub824\uba74 \ucd94\ucc9c \ub7f0\ucc98\ub85c \ubcc0\uacbd\ud558\uc138\uc694.";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc774 \ud658\uacbd\uc5d0 \uad8c\uc7a5\ub418\ub294 \ubaa8\ub4dc\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "\uad8c\uc7a5 \ubaa8\ub4dc \ub204\ub77d";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "\ucd5c\uc801\uc758 \uacbd\ud5d8\uc744 \uc704\ud574 \uad8c\uc7a5 \ubaa8\ub4dc\ub97c \uc124\uce58\ud558\uc138\uc694.";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\uc124\uce58\ubcf8\uc5d0\uc11c \uad8c\uc7a5\ud558\uc9c0 \uc54a\ub294 \ubaa8\ub4dc\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "\uad8c\uc7a5\ud558\uc9c0 \uc54a\ub294 \ubaa8\ub4dc \uac10\uc9c0\ub428";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "\ubb38\uc81c\ub97c \ubc29\uc9c0\ud558\ub824\uba74 \uad8c\uc7a5\ud558\uc9c0 \uc54a\ub294 \ubaa8\ub4dc\ub97c \uc81c\uac70\ud558\uc138\uc694.";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\ud575\uc2ec \ud30c\uc77c\uc5d0 \ubb34\ub2e8 \uc870\uc791\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ud30c\uc77c\uc744 \uc9c1\uc811 \uc218\uc815\ud588\uac70\ub098 \uc2e0\ub8b0\ud560 \uc218 \uc5c6\ub294 \ub7f0\ucc98\ub97c \uc0ac\uc6a9 \uc911\uc77c \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "\uc870\uc791 \uac10\uc9c0\ub428";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "\ubb34\uacb0\uc131\uc744 \ubcf5\uc6d0\ud558\ub824\uba74 \uc6d0\ubcf8 \ud30c\uc77c\uc744 \ub2e4\uc2dc \uc124\uce58\ud558\uc138\uc694.";
    }

    @Override
    public String configuracionCorporativa() {
        return "\uae30\uc5c5 \uc124\uc815";
    }

    @Override
    public String idiomaRespaldo() {
        return "\ubc31\uc5c5 \uc5b8\uc5b4";
    }

    @Override
    public String buscardorHabilitado() {
        return "\uac80\uc0c9\uae30 \ud65c\uc131\ud654";
    }

    @Override
    public String nombreHerramienta() {
        return "\ub3c4\uad6c \uc774\ub984";
    }

    @Override
    public String condenarPirateria() {
        return "\ud574\uc801\ud310 \ube44\ub09c";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "\ucd94\ucc9c \ub7f0\ucc98";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "\ube44\ucd94\ucc9c \ub7f0\ucc98";
    }

    @Override
    public String modsRecomendados() {
        return "\ucd94\ucc9c \ubaa8\ub4dc";
    }

    @Override
    public String modsDesaconsejados() {
        return "\ube44\ucd94\ucc9c \ubaa8\ub4dc";
    }

    @Override
    public String antiTamper() {
        return "\ubb34\uacb0\uc131 \ubcf4\ud638";
    }

    @Override
    public String proximamente() {
        return "\ucd9c\uc2dc \uc608\uc815";
    }

    @Override
    public String informacion() {
        return "\uc815\ubcf4";
    }

    @Override
    public String errorCargandoImagen() {
        return "\uc774\ubbf8\uc9c0 \ubd88\ub7ec\uc624\uae30 \uc624\ub958";
    }

    @Override
    public String configuracionBasica() {
        return "\uae30\ubcf8 \uc124\uc815";
    }

    @Override
    public String funcionalidades() {
        return "\uae30\ub2a5";
    }

    @Override
    public String derechosMiranda() {
        return "\ubbf8\ub780\ub2e4 \uad8c\ub9ac (\ub9e4\uc6b0 \uad8c\uc7a5\ub428)";
    }

    @Override
    public String gestionVerificaciones() {
        return "\uac80\uc99d \uad00\ub9ac";
    }

    @Override
    public String idVerificacion() {
        return "ID";
    }

    @Override
    public String nombreVerificacion() {
        return "\uc774\ub984";
    }

    @Override
    public String codigoVerificacion() {
        return "\ucf54\ub4dc";
    }

    @Override
    public String documentacionVerificacion() {
        return "\ubb38\uc11c";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "\ud65c\uc131\ud654\ub41c \uac80\uc99d:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "\ube44\ud65c\uc131\ud654\ub41c \uac80\uc99d:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "\ubaa8\ub4e0 \ube44\uae30\uc5c5\uc6a9 \uac80\uc99d \ube44\ud65c\uc131\ud654";
    }

    @Override
    public String verCodigo() {
        return "\ucf54\ub4dc \ubcf4\uae30";
    }

    @Override
    public String verDocumentacion() {
        return "\ubb38\uc11c \ubcf4\uae30";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "\ube44\ud65c\uc131\ud654\ud560 \uac80\uc99d\uc744 \uc120\ud0dd\ud558\uc138\uc694.";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "\ud65c\uc131\ud654\ud560 \uac80\uc99d\uc744 \uc120\ud0dd\ud558\uc138\uc694.";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "\uae30\uc5c5\uc6a9\uc73c\ub85c \uad8c\uc7a5\ub418\uc9c0 \uc54a\ub294 \uac80\uc99d %d\uac1c\uac00 \ube44\ud65c\uc131\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "\ube44\ud65c\uc131\ud654\ud560 \ube44\uae30\uc5c5\uc6a9 \uac80\uc99d\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String operacionCompletada() {
        return "\uc791\uc5c5 \uc644\ub8cc";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "\uc6b0\ub9ac\ub294 Amane Kanata\ub97c \uadf8\ub9ac\uc6cc\ud569\ub2c8\ub2e4";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "\uae30\uc5c5 \uac80\uc99d \uc0c9\uc0c1";
    }

    @Override
    public String nombreLanzador() {
        return "\ub7f0\ucc98 \uc774\ub984";
    }

    @Override
    public String motivo() {
        return "\uc0ac\uc720";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "\ube44\ucd94\ucc9c \ub7f0\ucc98";
    }

    @Override
    public String moverADesaconsejados() {
        return "\ube44\ucd94\ucc9c\uc73c\ub85c \uc124\uc815";
    }

    @Override
    public String moverARecomendados() {
        return "\ucd94\ucc9c\uc73c\ub85c \uc124\uc815";
    }

    @Override
    public String guardarCambios() {
        return "\ubcc0\uacbd \uc0ac\ud56d \uc800\uc7a5";
    }

    @Override
    public String cancelar() {
        return "\ucde8\uc18c";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "\uc774\ub3d9\ud560 \ub7f0\ucc98\ub97c \uc120\ud0dd\ud558\uc138\uc694.";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\ubcc0\uacbd \uc0ac\ud56d\uc774 \uc131\uacf5\uc801\uc73c\ub85c \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4!";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "\uc0ac\uc720";
    }

    @Override
    public String agregarLanzador() {
        return "\ub7f0\ucc98 \ucd94\uac00";
    }

    @Override
    public String quitarLanzador() {
        return "\ub7f0\ucc98 \uc81c\uac70";
    }

    @Override
    public String editarRazones() {
        return "\uc0ac\uc720 \ud3b8\uc9d1";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "\uc81c\uac70\ud560 \ub7f0\ucc98\ub97c \uc120\ud0dd\ud558\uc138\uc694.";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "\ud3b8\uc9d1\ud560 \ub7f0\ucc98\ub97c \uc120\ud0dd\ud558\uc138\uc694.";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return idLanzador + "\uc758 \uc0ac\uc720 \ud3b8\uc9d1";
    }

    @Override
    public String agregarNuevoIdioma() {
        return "\uc0c8 \uc5b8\uc5b4 \ucd94\uac00";
    }

    @Override
    public String aceptar() {
        return "\ud655\uc778";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "\uc5b8\uc5b4 \uc120\ud0dd";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "\uc774 \ub7f0\ucc98\ub4e4\uc740 CrashDetector\uac00 \uc88b\uc740 \uc120\ud0dd\uc73c\ub85c \uc81c\uc548\ud558\ub294 \uac83\ub4e4\uc785\ub2c8\ub2e4.";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "\uc815\uc0c1 \uacb0\uacfc";
    }

    @Override
    public String modsNoRecomendados() {
        return "\ube44\ucd94\ucc9c \ubaa8\ub4dc";
    }

    @Override
    public String agregarMod() {
        return "\ubaa8\ub4dc \ucd94\uac00";
    }

    @Override
    public String quitarMod() {
        return "\ubaa8\ub4dc \uc81c\uac70";
    }

    @Override
    public String modId() {
        return "\ubaa8\ub4dc ID / JBoss Modules \uc774\ub984";
    }

    @Override
    public String rutaMod() {
        return "\ubaa8\ub4dc \uacbd\ub85c / \ud30c\uc77c";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "\ucd5c\uc18c\ud55c modid \ub610\ub294 \ubaa8\ub4dc \uacbd\ub85c\ub97c \uc9c0\uc815\ud574\uc57c \ud569\ub2c8\ub2e4.";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "\uc5ec\uae30\uc5d0 \ube44\ucd94\ucc9c \ubaa8\ub4dc\ub97c \ub4f1\ub85d\ud558\uc5ec \uc124\uce58\ub41c \uacbd\uc6b0 CrashDetector\uac00 \uac10\uc9c0\ud558\ub3c4\ub85d \ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String anularNormal() {
        return "\uc77c\ubc18 \ubaa8\ub4dc \ud574\uc81c";
    }

    @Override
    public String anularNormalDescripcion() {
        return "\ud06c\ub798\uc2dc\uac00 \ubc1c\uc0dd\ud558\uc9c0 \uc54a\ub354\ub77c\ub3c4 CrashDetector\uac00 \uacbd\uace0\ud574\uc57c \ud569\ub2c8\ub2e4.";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "CrashDetector\uac00 \ucd94\ucc9c\ud558\ub294 \ubaa8\ub4dc\ub97c \ub4f1\ub85d\ud558\uc138\uc694. \ub204\ub77d\ub41c \uacbd\uc6b0 CrashDetector\uac00 \uacbd\uace0\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "\ubc18\ub3c4\uc6a9 \uacbd\uace0\ub97c \ud65c\uc131\ud654\ud558\uae30\ub85c \uacb0\uc815\ud55c \uacbd\uc6b0, \uc608\ubc29 \uc870\uce58\ub85c\uc11c \uc9c0\uc6d0\uc744 \uc694\uccad\ud558\ub294 \uc0ac\ub78c\uc758 \uad8c\ub9ac\ub97c \uc5ec\uae30\uc5d0 \uc815\uc758\ud558\ub294 \uac83\uc774 \uc88b\uc2b5\ub2c8\ub2e4.\n\n\ud754\ud55c \uc624\ud574\uc640 \ub2ec\ub9ac, \ub9ce\uc740 \uc778\uae30 \ucee4\ubba4\ub2c8\ud2f0 \ubc0f \uc9c0\uc6d0 \ucc44\ub110\uc740 \ub3c4\uc6c0\uc744 \uc81c\uacf5\ud558\uae30 \uc704\ud574 \ubc18\ub3c4\uc6a9 \uacbd\uace0\ub97c \uc694\uad6c\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uadf8\ub7ec\ub098 \uc0ac\uc6a9\uc790\uac00 \uc5b4\uca0c\ub4e0 \uc9c0\uc6d0 \ucc44\ub110\uc5d0 \uc811\uadfc\ud560 \uacbd\uc6b0 \uc774\ub7ec\ud55c \uad8c\ub9ac\ub97c \ubb38\uc11c\ud654\ud558\ub294 \uac83\uc774 \uc720\uc6a9\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.\n\n\uba55\uc2dc\ucf54\uc758 \u300c\uad6c\uae08\uc790 \uae30\ubcf8\uad8c \uc548\ub0b4\uc11c\u300d\uc640 \uac19\uc740 \uacf5\uc2dd \ubb38\uc11c\ub97c \ucc38\uace0\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\n\ub610\ud55c \ubbf8\uad6d, \ub7ec\uc2dc\uc544 \uc5f0\ubc29, \uc911\ud654\uc778\ubbfc\uacf5\ud654\uad6d, \uc774\ub780 \uc774\uc2ac\ub78c \uacf5\ud654\uad6d, \uc870\uc120\ubbfc\uc8fc\uc8fc\uc758\uc778\ubbfc\uacf5\ud654\uad6d \ub4f1 \ub2e4\ub978 \uad6d\uac00\uc5d0\uc11c \uc0ac\uc6a9\ub418\ub294 \uc720\uc0ac\ud55c \ubc95\uc801 \uc6d0\uce59\ub3c4 \ucc38\uace0\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.\n\n\ud3ec\ud568\ud560 \uc218 \uc788\ub294 \uad8c\ub9ac\uc758 \uc608:\n\u2022 \uc9c0\uc6d0\uc5d0 \ubd88\ud544\uc694\ud55c \uc815\ubcf4(\uc608: \uc0ac\uc6a9 \uc911\uc778 \ub7f0\ucc98, \uc0ac\uc6a9\uc790 \uc774\ub984, UUID)\ub97c \uc81c\uacf5\ud558\uc9c0 \uc54a\uc744 \uad8c\ub9ac.\n\u2022 \uc790\uae30 \uc790\uc2e0\uc744 \uace0\ubc1c\ud558\uc9c0 \uc54a\uc744 \uad8c\ub9ac.\n\u2022 \ubb38\uc81c \ud574\uacb0\uc5d0 \ubd88\ud544\uc694\ud55c \uc9c8\ubb38\uc5d0 \ub2f5\ud558\uc9c0 \uc54a\uc744 \uad8c\ub9ac.\n\u2022 \ucc44\ud305 \ub0b4\uc5d0\uc11c \uc548\ub0b4\ub97c \ubc1b\uc744 \uad8c\ub9ac.\n\u2022 CrashDetector\uc5d0 \ub0b4\uc7a5\ub41c \ub85c\uadf8 \uc775\uba85\ud654 \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud560 \uad8c\ub9ac.\n\n\uc774 \ud14d\uc2a4\ud2b8\ub294 HTML \ucf58\ud150\uce20\ub97c \uc9c0\uc6d0\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String editar() {
        return "\ud3b8\uc9d1";
    }

    @Override
    public String advertenciaHashLento() {
        return "\uacbd\uace0: \ud070 \ud30c\uc77c\uc744 \ub9ce\uc774 \ucd94\uac00\ud558\uba74 \uac80\uc99d\uc5d0 \uc218 \ubd84\uc774 \uac78\ub9b4 \uc218 \uc788\uc2b5\ub2c8\ub2e4. CrashDetector\ub294 \uacc4\uc18d\ud558\uae30 \uc804\uc5d0 \uac01 \ud30c\uc77c\uc758 \ud574\uc2dc\ub97c \uacc4\uc0b0\ud574\uc57c \ud569\ub2c8\ub2e4. \ubc18\ub4dc\uc2dc \ud544\uc694\ud55c \ud30c\uc77c\ub9cc \ubcf4\ud638\ud558\ub294 \uac83\uc774 \uc88b\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String agregarArchivo() {
        return "\ud30c\uc77c \ucd94\uac00";
    }

    @Override
    public String agregarCarpeta() {
        return "\ud3f4\ub354 \ucd94\uac00";
    }

    @Override
    public String quitar() {
        return "\uc81c\uac70";
    }

    @Override
    public String rutaArchivo() {
        return "\ud30c\uc77c \uacbd\ub85c";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "\uc120\ud0dd\ud55c \uacbd\ub85c\uac00 \ud604\uc7ac \uac8c\uc784 \ub514\ub809\ud130\ub9ac \uc678\ubd80\uc5d0 \uc788\uc2b5\ub2c8\ub2e4. \ud604\uc7ac \ub514\ub809\ud130\ub9ac \ub610\ub294 \uadf8 \ud558\uc704 \ub514\ub809\ud130\ub9ac \ub0b4\uc758 \ud30c\uc77c\uacfc \ud3f4\ub354\ub9cc \ud5c8\uc6a9\ub429\ub2c8\ub2e4.";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>Sylent Bell\uc758 \uc758\uacac\uacfc \uc5b8\uae09\uc740 \ubc18\ub4dc\uc2dc \uc6b0\ub9ac\uc640 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4; \uc5ec\uae30\uc5d0 \ub123\ub294 \uac83\uc774 \uc7ac\ubbf8\uc788\uc744 \uac83 \uac19\uc544\uc11c\uc785\ub2c8\ub2e4. CrashDetector\ub294 \uc138\uc18d\uc801\uc785\ub2c8\ub2e4.</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GML(Groovy ModLoader) \ubaa8\ub4dc\ub294 \uc774\ub7ec\ud55c \ubcc0\uacbd\uc774 \ud544\uc694\ud558\uba70, \uc774 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud558\ub294 \uac00\uc7a5 \ud754\ud55c \uc6d0\uc778\uc785\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'><i> Flywheel</i> \uc0ac\uc6a9\uc774 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><p><b> Flywheel\uc740 \ub354 \uc774\uc0c1 \uc0ac\uc6a9\ub418\uc9c0 \uc54a\uc74c(deprecated)</b>\uc774\uba70 \ucd5c\uc2e0 \ubc84\uc804\uc5d0\uc11c\ub294 \uc0ac\uc6a9\ud574\uc11c\ub294 \uc548 \ub429\ub2c8\ub2e4.</p><p>\ud604\uc7ac <b>Create</b> \ubc84\uc804\uc740 <b>Flywheel\uc744 \uc774\ubbf8 \ud3ec\ud568</b>\ud558\uace0 \uc788\uc73c\ubbc0\ub85c \ubcc4\ub3c4\ub85c \uc124\uce58\ud558\uba74 \ud638\ud658\uc131 \ucda9\ub3cc\uacfc \ub85c\ub529 \uc624\ub958\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</p><p> Flywheel\uc5d0 \uba85\uc2dc\uc801\uc73c\ub85c \uc758\uc874\ud558\ub294 \uc77c\ubd80 \ubaa8\ub4dc\ub294 <b>\uc791\ub3d9\ud558\uc9c0 \uc54a\uac70\ub098</b> <b>\ubd88\uc548\uc815\ud558\uac8c \uc791\ub3d9</b>\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \ud2b9\uc815 \uace0\uae09 \uc0c1\ud669\uc5d0\uc11c\ub294 <b><code>mods.toml</code> \ud30c\uc77c\uc744 \uc218\ub3d9\uc73c\ub85c \ud3b8\uc9d1</b>\ud558\uc5ec \ubc84\uc804 \ubc94\uc704\ub97c \uc870\uc815\ud558\uba74 \uc791\ub3d9\ud560 \uc218\ub3c4 \uc788\uc9c0\ub9cc, \uc774\ub294 <b>\uad8c\uc7a5\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4</b>.</p>" + (mods.isEmpty() ? "" : "<p><b>Flywheel\uc744 \ucc38\uc870\ud558\ub294 \uac10\uc9c0\ub41c \ubaa8\ub4dc:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>\uad8c\uc7a5\ub418\ub294 \ud574\uacb0\ucc45\uc740 <b>Flywheel\uc744 \uc81c\uac70</b>\ud558\uace0 Create\uc5d0 \ub0b4\uc7a5\ub41c \ubc84\uc804\ub9cc \uc0ac\uc6a9\ud558\ub294 \uac83\uc785\ub2c8\ub2e4.</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "\ub3c5\ub9bd\ud615 Flywheel";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'><i>Floral Enchantments</i> \ubaa8\ub4dc\uc640 \uad00\ub828\ub41c \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><p>\ud06c\ub798\uc2dc\ub294 \uac8c\uc784 \ub370\uc774\ud130\ub97c \ucc98\ub9ac\ud558\ub294 \ub3c4\uc911 \ubaa8\ub4dc \ub0b4\ubd80 \uc624\ub958\ub85c \uc778\ud574 \ubc1c\uc0dd\ud558\uba70, \uc2e4\ud589 \uc911 <b>NullPointerException</b>\uc744 \uc720\ubc1c\ud569\ub2c8\ub2e4.</p><p>\uc774 \ubb38\uc81c\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ubaa8\ub4dc\ub97c \uc5c5\ub370\uc774\ud2b8\ud558\uac70\ub098 \uc81c\uac70\ud558\uc5ec \ud574\uacb0\ub429\ub2c8\ub2e4.</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "Floral Enchantments \uc624\ub958";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>NeoForge \ubc84\uc804\uc758 MixinExtras\uc640 \uc77c\ubc18 \ubc84\uc804\uc744 \ubaa8\ub450 \uc124\uce58\ud588\uc2b5\ub2c8\ub2e4. MinecraftForge\ub97c \uc0ac\uc6a9 \uc911\uc774\ub77c\uba74, \ud574\uacb0\uc744 \uc704\ud574 <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>\uc774 \ub9c1\ud06c</a>\uc5d0\uc11c \ubaa8\ub4dc\ub97c \uc124\uce58\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Iris\uc5d0\uc11c \uc250\uc774\ub354(shaders)\ub97c \uc0ac\uc6a9\ud560 \ub54c \uc9c0\ud615 \uadf8\ub9bc\uc790 \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><p>\uc774 \ubb38\uc81c\ub294 \uc9c0\ud615 \ub80c\ub354\ub9c1 \uc911 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.</p><p><b>\uc250\uc774\ub354 \uc5c6\uc774 \uac8c\uc784\uc744 \uc2e4\ud589\ud574 \ubcf4\uac70\ub098</b> \uadf8\ub798\ud53d \ud488\uc9c8\uc744 \ub0ae\ucd94\ub294 \uac83\uc774 \uc88b\uc2b5\ub2c8\ub2e4, \ud2b9\ud788 <b>Ultra</b> \uc124\uc815\uc5d0\uc11c\uc694.</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "\uc9c0\ud615 \uadf8\ub9bc\uc790 (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\uc11c\ubc84 \ud2f1\uc774 \uc9c0\ub098\uce58\uac8c \uae38\uac8c \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.</b><p>\uc774\ub294 \uac8c\uc784\uc774 \ud55c \ubc88\uc758 \ud2f1 \ub3d9\uc548 \ub108\ubb34 \uc624\ub798 \uba48\ucdb0 \uc788\uc5c8\ub2e4\ub294 \uac83\uc744 \uc758\ubbf8\ud569\ub2c8\ub2e4.</p><p>\uc6d0\uc778\uc744 \ud30c\uc545\ud558\uae30 \uc704\ud574 \ub85c\uadf8\uc5d0 \uc0dd\uc131\ub41c <b>thread dump\ub97c \ud655\uc778</b>\ud558\ub294 \uac83\uc774 \uc88b\uc2b5\ub2c8\ub2e4.</p><p><b>Stack Trace \ubd84\uc11d</b>\uc740 \uba48\ucda4\uc758 \uadfc\uc6d0\uc744 \ucc3e\ub294 \ub370 \ub3c4\uc6c0\uc774 \ub420 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</p><p>\ub610\ud55c <b>\ub85c\uadf8\uc5d0\uc11c \ubcf4\uae30</b> \ubc84\ud2bc\uc740 \ubb38\uc81c\uc758 \uc6d0\uc778\uc77c \uc218 \uc788\ub294 \ubaa8\ub4dc\ub97c \ube68\uac04\uc0c9\uc73c\ub85c \uac15\uc870 \ud45c\uc2dc\ud558\uba70, <code>$modid$</code>\ub85c \ub458\ub7ec\uc2f8\uc778 \ud56d\ubaa9\ub3c4 \ud568\uaed8 \ud45c\uc2dc\ud569\ub2c8\ub2e4(\uc774\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ubb38\uc81c\uc758 \ucd9c\ucc98\ub97c \ub098\ud0c0\ub0c5\ub2c8\ub2e4). \uc2e4\uc2dc\uac04 \uc2a4\uce94\uc758 \uacbd\uc6b0 VisualVM\uc758 CPU \uc0d8\ud50c\ub7ec \uc0ac\uc6a9\uc744 \uad8c\uc7a5\ud569\ub2c8\ub2e4. \ubaa8\ub4e0 \ubaa8\ub4dc\uac00 \uc815\uc0c1\uc801\uc73c\ub85c \uc791\ub3d9\ud558\ub354\ub77c\ub3c4 \ub108\ubb34 \ub9ce\uc774 \uc124\uce58\ud588\uc744 \uc218 \uc788\uc73c\ubbc0\ub85c, \uc11c\ubc84\ub098 \ucef4\ud4e8\ud130 \uc131\ub2a5\uc774 \uc0ac\uc6a9 \uc911\uc778 \ubaa8\ub4dc\ub97c \uac10\ub2f9\ud560 \ub9cc\ud07c \ucda9\ubd84\ud55c\uc9c0 \ud655\uc778\ud558\uc138\uc694.</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "\uc11c\ubc84 \ud2f1 \uc9c0\uc5f0";
    }

    @Override
    public String tituloLFPDPPP() {
        return "\uac1c\uc778 \uc18c\uc720 \uac1c\uc778\uc815\ubcf4 \ubcf4\ud638\uc5d0 \uad00\ud55c \uc5f0\ubc29\ubc95";
    }

    @Override
    public String aceptarPermanentemente() {
        return "\uc601\uad6c\uc801\uc73c\ub85c \uc218\ub77d";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "\uc870\uc120\uc5b4 \ubc88\uc5ed\uc5d0\ub294 \ub0a8\uc870\uc120\uc2dd \uc18d\uc5b4\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc73c\uba70, \ubc95\uc744 \uc900\uc218\ud558\uae30 \uc704\ud574 \uc774\ub97c \ud53c\ud574\uc57c \ud569\ub2c8\ub2e4. \uc678\uad6d\uc5b4, \ud2b9\ud788 \ub0a8\ucabd\uc5d0\uc11c \uc720\uc785\ub41c \uc5b8\uc5b4\uc758 \uc0ac\uc6a9\uc740 \u300c\ud3c9\uc591 \ubb38\ud654\uc5b4 \ubcf4\ud638\ubc95\u300d\uc5d0 \ub530\ub77c \uc5c4\uaca9\ud788 \uae08\uc9c0\ub429\ub2c8\ub2e4.";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "\uc790\uc138\ud55c \ub0b4\uc6a9\uc740 \ubc95\ub839 \uacf5\uc2dd \ubb38\uc11c\ub97c \ucc38\uc870\ud558\uc2ed\uc2dc\uc624: <a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>\ud3c9\uc591 \ubb38\ud654\uc5b4 \ubcf4\ud638\ubc95</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "\ubc95 \uc804\ubb38 \ubcf4\uae30";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "\ub9c1\ud06c \uc5f4\uae30 \uc624\ub958";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "\ud3c9\uc591 \ubb38\ud654\uc5b4 \ubcf4\ud638\ubc95";
    }

    @Override
    public String canarioTitulo() {
        return "\uc0ac\ubc95 \uba85\ub839 \uce74\ub098\ub9ac\uc544";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 \uac10\uc2dc \ubaa8\ub2c8\ud130";
    }

    @Override
    public String revisar() {
        return "\ud655\uc778";
    }

    @Override
    public String cerrar() {
        return "\ub2eb\uae30";
    }

    @Override
    public String canarioTodoSeguro() {
        return "\ubaa8\ub4e0 \uc11c\ube44\uc2a4\uac00 \uc548\uc804 \uc0c1\ud0dc\ub97c \ubcf4\uace0\ud588\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String canarioComprometido(int c) {
        return "\uacbd\uace0: " + c + "\uac1c\uc758 \uc11c\ube44\uc2a4\uac00 \ube44\uc548\uc804 \uc0c1\ud0dc\ub97c \ubcf4\uace0\ud588\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String colorAlerta() {
        return "\uacbd\uace0 \uc0c9\uc0c1";
    }

    @Override
    public String opcionesMunidiales() {
        return "\ubb34\ub2c8\ub514\uc54c \uc635\uc158";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "LFPDPPP \ub3d9\uc758";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "ReLauncher\uc6a9 Handoff\uc5d0\uc11c \uc561\uc138\uc2a4 \ud1a0\ud070 \uc804\uc1a1\uc744 \ud65c\uc131\ud654 (\ube44\ucd94\ucc9c).";
    }

    @Override
    public String consolaDesarrollo() {
        return "\uac1c\ubc1c \ucf58\uc194";
    }

    @Override
    public String mundial() {
        return "\uc138\uacc4\uc801";
    }

    @Override
    public String ningun() {
        return "\uc5c6\uc74c";
    }

    public String consolaDesarrollador() {
        return "\uac1c\ubc1c\uc790 \ucf58\uc194";
    }

    @Override
    public String bajar() {
        return "\ub2e4\uc6b4\ub85c\ub4dc";
    }

    @Override
    public String logsSoporte() {
        return "\uc9c0\uc6d0 \ub85c\uadf8";
    }

    @Override
    public String detenerProceso() {
        return "\ud504\ub85c\uc138\uc2a4 \uc911\uc9c0";
    }

    @Override
    public String copiarSeleccion() {
        return "\uc120\ud0dd \ud56d\ubaa9 \ubcf5\uc0ac";
    }

    @Override
    public String seleccionarTodo() {
        return "\uc804\uccb4 \uc120\ud0dd";
    }

    @Override
    public String copiarTodo() {
        return "\uc804\uccb4 \ubcf5\uc0ac";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "\uc804\uccb4\ub97c \ud30c\uc77c\ub85c \uc800\uc7a5";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "\uc9c0\uc6d0 \ub9c1\ud06c \uc5bb\uae30";
    }

    @Override
    public String borrarTodo() {
        return "\uc804\uccb4 \uc0ad\uc81c";
    }

    public String colorFondoConsola() {
        return "\ucf58\uc194 \ubc30\uacbd\uc0c9";
    }

    public String colorTextoConsola() {
        return "\ucf58\uc194 \ud14d\uc2a4\ud2b8 \uc0c9\uc0c1";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "\ub3d9\uc758\uac00 \ud655\uc778\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\ub85c\uadf8 \uacf5\uc720 \uae30\ub2a5\uc740 \uc5ec\uae30\uc5d0 \uad6c\ud604\ub420 \uc608\uc815\uc785\ub2c8\ub2e4.";
    }

    @Override
    public String usarSakuraOriginal() {
        return "\uc6d0\ubcf8 Sakura Riddle \uc774\ubbf8\uc9c0 \uc0ac\uc6a9";
    }

    @Override
    public String canario1984Descripcion() {
        return "\u300c\uc601\uc7a5 \uce74\ub098\ub9ac\uc544(warrant canary)\u300d\ub294 \ud22c\uba85\uc131 \uba54\ucee4\ub2c8\uc998\uc785\ub2c8\ub2e4.\n\n\uc774 \uba54\uc2dc\uc9c0\uac00 \uc874\uc7ac\ud558\uace0 \uc11c\ube44\uc2a4\ub4e4\uc774 \uc548\uc804\ud558\uac8c \ud45c\uc2dc\ub418\ub294 \ud55c, \ud574\ub2f9 \ud504\ub85c\uc81d\ud2b8\ub294 \ube44\ubc00 \uc0ac\ubc95 \uba85\ub839, \uac80\uc5f4 \uc694\uccad, \ud569\ubc95\uc801 \uac10\uc2dc \uc694\uad6c\ub97c \ubc1b\uc9c0 \uc54a\uc558\uc74c\uc744 \uc758\ubbf8\ud569\ub2c8\ub2e4.\n\n\uc5b4\ub5a4 \uce74\ub098\ub9ac\uc544\uac00 \uc0ac\ub77c\uc9c0\uac70\ub098 \ube44\uc548\uc804 \uc0c1\ud0dc\ub85c \ud45c\uc2dc\ub418\uba74, \uc774\ub294 \ubc95\uc801 \uc0c1\ud669\uc5d0 \ubcc0\ud654\uac00 \uc788\uc74c\uc744 \ub098\ud0c0\ub0c5\ub2c8\ub2e4.\n\n\uc774 \ud328\ub110\uc740 \uc2dc\uc2a4\ud15c\uc5d0 \ub4f1\ub85d\ub41c \ubaa8\ub4e0 \uce74\ub098\ub9ac\uc544\ub97c \uc810\uac80\ud558\uc5ec \ud604\uc7ac \uc0c1\ud0dc\ub97c \ud45c\uc2dc\ud569\ub2c8\ub2e4.\n\n\u300c\ud655\uc778\u300d\uc744 \ub20c\ub7ec \uc0c1\ud0dc\ub97c \uac31\uc2e0\ud558\uc138\uc694.";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\ubaa8\ub4e0 \uc635\uc158\uc744 \uae30\ubcf8\uac12\uc73c\ub85c \uc7ac\uc124\uc815\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "\uc635\uc158 \uc5c6\uc74c";
    }

    @Override
    public String seleccionaColor() {
        return "\uc0c9\uc0c1 \uc120\ud0dd";
    }

    @Override
    public String botonMostrarGUI() {
        return "GUI \ud45c\uc2dc";
    }

    @Override
    public String botonGuardarTodo() {
        return "\ubaa8\ub450 \uc800\uc7a5";
    }

    @Override
    public String botonRestablecerTodo() {
        return "\ubaa8\ub450 \uc7ac\uc124\uc815";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms\uac00 \uc801\uc7ac\ub418\uc9c0 \uc54a\uc74c";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>LuckPerms API\uc5d0 \uc811\uadfc\ud558\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc600\uc2b5\ub2c8\ub2e4.</b><p>\uc774 \uba54\uc2dc\uc9c0\ub294 \ub2e4\ub978 \ud50c\ub7ec\uadf8\uc778\uc774 \uc0ac\uc6a9\ud558\ub824 \ud560 \ub54c <b>LuckPerms\uac00 \uc544\uc9c1 \uc801\uc7ac\ub418\uc9c0 \uc54a\uc558\ub2e4</b>\ub294 \uac83\uc744 \uac00\ub9ac\ud0b5\ub2c8\ub2e4.</p><p><b>\uac00\ub2a5\ud55c \uc6d0\uc778:</b></p><ul><li><b>LuckPerms \ud50c\ub7ec\uadf8\uc778\uc774 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uac70\ub098</b>, <b>\uc2dc\uc791 \uacfc\uc815\uc5d0\uc11c \uc2e4\ud328\ud558\uc600\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</b></li><li>\ub2e4\ub978 \ud50c\ub7ec\uadf8\uc778\uc774 LuckPerms\uc5d0 <b>\ub108\ubb34 \uc77c\ucc0d</b> \ub610\ub294 <b>\uc798\ubabb\ub41c \ubc29\uc2dd\uc73c\ub85c</b> \uc811\uadfc\ud558\uace0 \uc788\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.</li></ul><p>\ub9c1\ud06c\ub97c \ud1b5\ud574 <b>\ucf58\uc194\uc744 \uac80\ud1a0\ud558\uc5ec</b> LuckPerms\ub97c \ud638\ucd9c\ud558\ub294 \ud50c\ub7ec\uadf8\uc778\uc744 \ud655\uc778\ud558\uace0 \ud638\ud658\uc131\uc744 \uac80\uc99d\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "Iris \uc170\uc774\ub354\ud329\uc774 \uc801\uc7ac\ub418\uc9c0 \uc54a\uc74c";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "\uc54c \uc218 \uc5c6\uc74c" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Iris/Oculus\ub85c \uc170\uc774\ub354\ud329\uc744 \ubd88\ub7ec\ub4e4\uc774\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \uac10\uc9c0\ub418\uc600\uc2b5\ub2c8\ub2e4.</b><p><b>\uc601\ud5a5 \ubc1b\uc740 \uc170\uc774\ub354\ud329:</b> " + nombre + "</p><p>\ub9c8\uc778\ud06c\ub798\ud504\ud2b8\uac00 \uc170\uc774\ub354\ud329 \ud30c\uc77c\uc744 \uc5f4\uc9c0 \ubabb \ud558\uc600\uc2b5\ub2c8\ub2e4 (FileSystemNotFoundException).</p><p><b>\uac00\ub2a5\ud55c \ud574\uacb0 \ubc29\ubc95:</b></p><ul><li><b>shaderpacks</b> \ud3f4\ub354\uc5d0 \uc170\uc774\ub354\ud329\uc774 \uc62c\ubc14\ub974\uac8c \uc124\uce58\ub418\uc600\ub294\uc9c0 \ud655\uc778\ud558\uc2ed\uc2dc\uc624.</li><li>\ud30c\uc77c\uc774 \uc190\uc0c1\ub418\uc600\uc744 \uc218 \uc788\uc73c\ubbc0\ub85c \uc170\uc774\ub354\ud329\uc744 \ub2e4\uc2dc \ub0b4\ub824\ubc1b\uc73c\uc2ed\uc2dc\uc624.</li><li>\ubb38\uc81c\uac00 \uacc4\uc18d\ub418\uba74 Iris \uc124\uc815\uc744 \ucd08\uae30\ud654\ud558\uae30 \uc704\ud574 <b>config/iris.properties</b> \ud30c\uc77c\uc744 \uc0ad\uc81c\ud558\uc2ed\uc2dc\uc624.</li></ul><p>\ubcc0\uacbd\uc0ac\ud56d\uc744 \uc801\uc6a9\ud55c \ud6c4 \uac8c\uc784\uc744 \ub2e4\uc2dc \uc2dc\uc791\ud558\uc2ed\uc2dc\uc624.</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "\uc124\uc815 \ud30c\uc77c\uc744 \uc4f8 \uc218 \uc5c6\uc74c";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "\uc54c \uc218 \uc5c6\uc74c" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\uc124\uc815 \ud30c\uc77c\uc744 \uc800\uc7a5\ud558\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.</b><p><b>\uc601\ud5a5 \ubc1b\uc740 \ud30c\uc77c:</b> " + archivo + "</p><p>\ub9c8\uc778\ud06c\ub798\ud504\ud2b8\uac00 \uc6d0\uc790\uc801 \uc4f0\uae30(REPLACE_ATOMIC) \ubc29\uc2dd\uc73c\ub85c \ud30c\uc77c\uc744 \uc4f0\uc9c0 \ubabb \ud558\uc600\uc2b5\ub2c8\ub2e4.</p><p><b>\uc774\ub294 \ubcf4\ud1b5 \ub2e4\uc74c \uc6d0\uc778\uc73c\ub85c \uc77c\uc5b4\ub0a9\ub2c8\ub2e4:</b></p><ul><li>\ud3f4\ub354 \ub610\ub294 \ud30c\uc77c\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc74c.</li><li>\ud30c\uc77c\uc774 \uc77d\uae30 \uc804\uc6a9\uc73c\ub85c \ud45c\uc2dc\ub418\uc5ec \uc788\uc74c.</li><li>\ub2e4\ub978 \ud504\ub85c\uadf8\ub78c(\ubc14\uc774\ub7ec\uc2a4 \ubc31\uc2e0, \ubc31\uc5c5 \uc18c\ud504\ud2b8\uc6e8\uc5b4, \ud3b8\uc9d1\uae30 \ub4f1)\uc774 \ud30c\uc77c\uc744 \uc810\uc720\ud558\uace0 \uc788\uc74c.</li></ul><p><b>\uad8c\uc7a5 \uc870\uce58:</b></p><ul><li>\ud3f4\ub354\uc5d0 \uc4f0\uae30 \uad8c\ud55c\uc774 \uc788\ub294\uc9c0 \ud655\uc778\ud558\uc2ed\uc2dc\uc624.</li><li>\ud30c\uc77c\uc758 \uc77d\uae30 \uc804\uc6a9 \uc18d\uc131\uc744 \ud574\uc81c\ud558\uc2ed\uc2dc\uc624.</li><li>\ud574\ub2f9 \ud30c\uc77c\uc744 \uc0ac\uc6a9\ud558\uace0 \uc788\uc744 \uc218 \uc788\ub294 \ud504\ub85c\uadf8\ub78c\ub4e4\uc744 \uc885\ub8cc\ud558\uc2ed\uc2dc\uc624.</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "\ubc31\uc5c5 \uc0dd\uc131 \uc2dc \uc811\uadfc \uac70\ubd80\ub428";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "\uc54c \uc218 \uc5c6\uc74c" : origen;
        String dst = backup == null || backup.isEmpty() ? "\uc54c \uc218 \uc5c6\uc74c" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\uc124\uc815 \ud30c\uc77c\uc758 \ubc31\uc5c5\uc744 \ub9cc\ub4dc\ub294 \ub3c4\uc911 \uad8c\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.</b><p><b>\uc6d0\ubcf8 \ud30c\uc77c:</b> " + src + "</p><p><b>\ubc31\uc5c5 \ud30c\uc77c:</b> " + dst + "</p><p>\uc6b4\uc601\uccb4\uacc4\uac00 \ud30c\uc77c \uc800\uc7a5 \uacfc\uc815\uc5d0\uc11c \uc811\uadfc\uc744 \ucc28\ub2e8\ud558\uc600\uc2b5\ub2c8\ub2e4.</p><p><b>\uc774\ub294 \ubcf4\ud1b5 \ub2e4\uc74c \uc6d0\uc778\uc73c\ub85c \uc77c\uc5b4\ub0a9\ub2c8\ub2e4:</b></p><ul><li>\ud3f4\ub354\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \ubd80\uc871\ud568.</li><li>\ud30c\uc77c\uc774 \uc77d\uae30 \uc804\uc6a9\uc73c\ub85c \ud45c\uc2dc\ub418\uc5ec \uc788\uc74c.</li><li>\ub2e4\ub978 \ud504\ub85c\uadf8\ub78c(\ubc14\uc774\ub7ec\uc2a4 \ubc31\uc2e0, \ub3d9\uae30\ud654 \uc18c\ud504\ud2b8\uc6e8\uc5b4, \ud3b8\uc9d1\uae30 \ub4f1)\uc774 \ud30c\uc77c\uc744 \uc0ac\uc6a9\ud558\uace0 \uc788\uc74c.</li></ul><p><b>\uad8c\uc7a5 \uc870\uce58:</b></p><ul><li><b>config</b> \ud3f4\ub354\uc758 \uad8c\ud55c\uc744 \ud655\uc778\ud558\uc2ed\uc2dc\uc624.</li><li>\ud574\ub2f9 \ud30c\uc77c\uc5d0 \uc811\uadfc\ud558\uace0 \uc788\uc744 \uc218 \uc788\ub294 \ud504\ub85c\uadf8\ub78c\ub4e4\uc744 \uc885\ub8cc\ud558\uc2ed\uc2dc\uc624.</li><li>\ub7f0\ucc98 \ub610\ub294 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\ub97c \uad00\ub9ac\uc790 \uad8c\ud55c\uc73c\ub85c \uc2e4\ud589\ud574 \ubcf4\uc2ed\uc2dc\uc624.</li></ul>";
    }
}

