/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Espanol
implements Idioma {
    Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>no es una carpeta de mods valida</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>No se donde esta el archivo JAR de CrashDetector</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Buscando para PID: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") esta muerto!</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>No tenemos JVM</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Actualizar tus controladores ATI/AMD podr\u00eda ayudarte.Lee esta gu\u00eda para solucionarlo: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Gu\u00eda de actualizaci\u00f3n de controladores</a> https://www.amd.com/es/support/download/drivers.html Descargar </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>Algunas versiones antiguas a veces tienen algunos problemas con algunos gr\u00e1ficos Nouveau en la pantalla de carga temprana.</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Tienes un problema con tus controladores gr\u00e1ficos. Si tienes una GPU o APU AMD/ATI, actualiza tus controladores gr\u00e1ficos AMD. Si tienes una tarjeta gr\u00e1fica NVIDIA, aseg\u00farate de marcar el juego y todas las instancias de javaw.exe para usar la tarjeta gr\u00e1fica dedicada. Lee esta gu\u00eda: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Gu\u00eda de actualizaci\u00f3n de controladores</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Tu ventana FML Early est\u00e1 fallando. Para cambiar esto, ve a (.minecraft/config/fml.toml) y edita earlyWindowProvider para que sea earlyWindowProvider=\"none\". Si est\u00e1s en una Mac M1, tambi\u00e9n aseg\u00farate de estar usando una versi\u00f3n ARM de Java, no una versi\u00f3n Intel x64. Este tambi\u00e9n es un problema com\u00fan si tienes controladores desactualizados. Consulta esta gu\u00eda si est\u00e1s en Windows y desactivar esto no funciona: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Gu\u00eda de actualizaci\u00f3n de controladores</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>No tienes todas las dependencias necesarias:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "Solicitado por").replace("Expected range", "rango esperado") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Tu Informe de CrashDetector esta aqui <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>ver informe</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Esta es el GUI de CrashDetector. Si el juego cierra sin problemas, ignoralo.</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>Ver Informe</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Ver Un Informe Local en tu navegador.</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "Compartir Informe";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "Compartir Informe. Sus registros se cargar\u00e1n en securelogger.net y tu informe se cargar\u00e1 a otro sitio.";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Archivos JAR problem\u00e1ticos detectados (Priorizar FATAL, luego nivel alto y l\u00ednea baja):</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> nivel:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Posiblemente Fatal:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModIDs problem\u00e1ticos detectados (Priorizar FATAL, luego nivel bajo y l\u00ednea baja):</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Paquetes problem\u00e1ticos detectados (Priorizar FATAL, luego nivel bajo y l\u00ednea baja):</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes Clases fatales (FATAL), es muy importante, causas comunes son Coremods Malos o Fatals Dependencias. Puedes Usar QuickFix para buscar para mods con las clases fatales. Clases fatales faltantes detectadas:</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Contenido en {} (Lo m\u00e1s importante arriba, solo 20 primeros):</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Configuraci\u00f3n problem\u00e1tica de SpongeMixin detectada: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Tienes Mods con Packages/Paquetes duplicados. Puedes solucionarlo eliminando el paquete (carpeta) del jar, puedes abrir el jar en un software de archivo como WinRAR o 7z, tambi\u00e9n puedes cambiar la extensi\u00f3n del archivo de .jar a zip y luego eliminar la carpeta y luego cambiarla nuevamente a un archivo .jar.</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes Mods duplicado</b> " + linea.replace("from mod files", "de mod archivos ");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge sospechosos esta mod tiene una ploblema:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV Necesita lithostitched, puedes instalarlo aqu\u00ed: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Para usar Iris Shaders o Oculus necesitas SODIUM o una copia para otra cargadora (Rubidium, Embedium, Bedium)</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Problema con KubeJS extension </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Problemas detectados con controladores NVIDIA en versiones anteriores a Windows 11.</span><br/><br/>Para asegurarte de que Minecraft (y la JVM actual) utilice la tarjeta gr\u00e1fica dedicada NVIDIA, sigue estos pasos:<br/><br/>1. <strong>Identifica el ejecutable de Java:</strong><br/>   - Este programa est\u00e1 utilizando el siguiente ejecutable de Java: " + this.obtenerRutaJava() + "<br/>   - Si no ves una ruta espec\u00edfica, puedes encontrar el ejecutable de Java buscando 'java.exe' en tu sistema.<br/><br/>2. <strong>Abre el Panel de Control de NVIDIA:</strong><br/>   - Haz clic derecho en el escritorio y selecciona 'Panel de control de NVIDIA'.<br/><br/>3. <strong>Configura la GPU preferida:</strong><br/>   - En el Panel de Control de NVIDIA, ve a 'Administrar configuraci\u00f3n 3D'.<br/>   - Selecciona la opci\u00f3n 'Programa espec\u00edfico'.<br/>   - Haz clic en 'Agregar' y busca el ejecutable de Java identificado anteriormente (ej.: 'java.exe').<br/>   - Aseg\u00farate de que est\u00e9 configurado para usar el 'Procesador de alto rendimiento (NVIDIA)'.<br/><br/>4. <strong>Guarda los cambios:</strong><br/>   - Aplica los cambios y cierra el Panel de Control de NVIDIA.<br/><br/>5. <strong>Reinicia Minecraft:</strong><br/>   - Reinicia Minecraft para que los cambios surtan efecto.<br/><br/>Si usas Windows Server 2022 o Windows 10, estos pasos son v\u00e1lidos siempre que tengas instalados los controladores NVIDIA m\u00e1s recientes.<br/><br/>Nota: Si no puedes encontrar el Panel de Control de NVIDIA, aseg\u00farate de que los controladores NVIDIA est\u00e9n correctamente instalados.";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Problemas detectados con controladores NVIDIA en Windows 11/Server 2025 o posterior.</span><br/><br/>Para asegurarte de que Minecraft (y la JVM actual) utilice la tarjeta gr\u00e1fica dedicada NVIDIA, sigue estos pasos:<br/><br/>1. <strong>Identifica el ejecutable de Java:</strong><br/>   - Este programa est\u00e1 utilizando el siguiente ejecutable de Java: " + this.obtenerRutaJava() + "<br/>   - Si no ves una ruta espec\u00edfica, puedes encontrar el ejecutable de Java buscando 'java.exe' en tu sistema.<br/><br/>2. <strong>Abre la aplicaci\u00f3n Configuraci\u00f3n:</strong><br/>   - Presiona las teclas <code>Win + I</code> para abrir la aplicaci\u00f3n Configuraci\u00f3n.<br/>   - Navega a <strong>Sistema > Pantalla > Gr\u00e1ficos</strong>.<br/><br/>3. <strong>Configura la GPU preferida:</strong><br/>   - En la secci\u00f3n 'Gr\u00e1ficos', haz clic en 'Configuraci\u00f3n de gr\u00e1ficos predeterminada'.<br/>   - Selecciona 'Aplicaciones de escritorio' y luego haz clic en 'Examinar'.<br/>   - Busca y selecciona el ejecutable de Java identificado anteriormente (ej.: 'java.exe').<br/>   - Una vez a\u00f1adido, selecciona la aplicaci\u00f3n Java en la lista y config\u00farala para usar el 'Rendimiento alto (NVIDIA)'.<br/><br/>4. <strong>Guarda los cambios:</strong><br/>   - Aplica los cambios y cierra la aplicaci\u00f3n Configuraci\u00f3n.<br/><br/>5. <strong>Reinicia Minecraft:</strong><br/>   - Reinicia Minecraft para que los cambios surtan efecto.<br/><br/>Si usas Windows 11 o Windows Server 2025+, estos pasos son v\u00e1lidos siempre que tengas instalados los controladores NVIDIA m\u00e1s recientes.<br/><br/>Nota: Si no encuentras la opci\u00f3n de configuraci\u00f3n de gr\u00e1ficos, aseg\u00farate de que los controladores NVIDIA est\u00e9n correctamente instalados.";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tu Serivdor o Mundo tiene tics mas de 60 segundos. Esto puede deberse a que los mods hacen que el servidor sea m\u00e1s lento o a que el hardware es demasiado d\u00e9bil.</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No tienes sufficiente RAM/Memoria. Necesitas asignar mas.</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Theseus tambi\u00e9n tiene m\u00e1s problemas, incluyendo fallas al eliminar mods cuando lo intentas. Si necesitas jugar con archivos mrpack, puedes usar otros lanzadores como Prism Launcher (solo para modrinth.com), ATLauncher (solo para modrinth.com) o Hello Minecraft Launcher (compatible con modrinth.com y bbsmc.net).</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Est\u00e1s usando \"Omitir inicio Launcher\" (CurseForge App). A veces esto causa problemas dif\u00edciles de detectar. Esto se debe a la opci\u00f3n \"Omitir inicio Launcher\" en versiones antiguas de la App CurseForge o en la versi\u00f3n nueva. Desact\u00edvala y usa la opci\u00f3n \"Mojang Launcher\" en la configuraci\u00f3n de CurseForge. Puedes ver este video en ingl\u00e9s de Claws of Berk (ir a 1:11) <a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>aqu\u00ed</a>.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Advertencia: Tienes faltas clases (Advertencia), generalmente est\u00e1 bien pero no siempre, es diferente de faltas clases fatalas. Coremods malos o faltas dependencias son razones comunes para este problema. Puedes usar QuickFix para buscar para mods con los clases. Clases faltantes detectadas:</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No Resultos</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Ubicaci\u00f3n de Logs:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Aqu\u00ed est\u00e1n los resultados de tus verificaciones. Hazlo lentamente, generlmente la razon correcto es en verificion 1 o 2, otras (errores 3+) puedes usar para confirmacion pero generalment son errores cascades y puedes ignorar son. Los fallos se producen en capas, por lo que solucionar el problema correcto solucionar\u00e1 este error en particular hoy, pero es posible que ma\u00f1ana vuelva a aparecer un nuevo error no relacionado con el error actual, ya que a menudo un error puede impedir que otro aparezca en la consola.</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Por favor, usa Java 17 para las versiones 1.17-1.20.4 y Java 21 para cualquier versi\u00f3n m\u00e1s nueva. Usa Java 8 para versiones m\u00e1s antiguas. [Gu\u00eda](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). Si a\u00fan tienes problemas, podr\u00eda ser porque alg\u00fan mod tiene archivos demasiado nuevos o antiguos.</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 22 y superior no funcionan en versiones de Minecraft inferiores a 1.20.5 para la mayor\u00eda de los cargadores de mods debido a que ASM est\u00e1 desactualizado.</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java est\u00e1 obsoleto </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Necesitas JPMS Module" + mod_necesitas + " desde " + submod + "</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No se puede invocar " + metodo + " porque " + objeto + " es nulo</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "An\u00e1lisis Avanzado";
    }

    @Override
    public String seleccionarCarpeta() {
        return "Seleccionar Carpeta";
    }

    @Override
    public String cadenaBusqueda() {
        return "Cadena de B\u00fasqueda";
    }

    @Override
    public String usarRegex() {
        return "Usar Regex";
    }

    @Override
    public String ignorarMayusculas() {
        return "Ignorar May\u00fasculas";
    }

    @Override
    public String buscar() {
        return "Buscar";
    }

    @Override
    public String busquedaEnProgreso() {
        return "B\u00fasqueda en Progreso";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "No Se Encontraron Resultados";
    }

    @Override
    public String errorBusqueda() {
        return "Error en la B\u00fasqueda";
    }

    @Override
    public String omitirYCerrar() {
        return "Omitir y Cerrar";
    }

    @Override
    public String guardarYCerrar() {
        return "Guardar y Cerrar";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "Pega los registros aqu\u00ed";
    }

    @Override
    public String archivo() {
        return "Archivo";
    }

    @Override
    public String incluir() {
        return "Incluir";
    }

    @Override
    public String abrir() {
        return "Abrir";
    }

    @Override
    public String endpointDeInforme() {
        return "Endpoint del Informe";
    }

    @Override
    public String sitoDeLogging() {
        return "Sitio de Logging:";
    }

    @Override
    public String apiDeLogging() {
        return "API de Logging:";
    }

    @Override
    public String anonimizarRegistros() {
        return "Anonimizar registros (Beta)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "Compartir Informe y todos los registros seleccionados";
    }

    @Override
    public String arco() {
        return "Este di\u00e1logo te permite compartir registros utilizando la API de SecureLogger en <a href=\"https://securelogger.net\">securelogger.net</a>. Al presionar el bot\u00f3n para compartir el informe, tu informe se env\u00eda al punto final seleccionado (por defecto asbestosstar.egoism.jp) (se puede cambiar en la parte inferior). Puedes compartir todos los registros seleccionados junto con el informe. Si no deseas subir, \u00a1no uses este di\u00e1logo! No procesamos tu informe en el punto final oficial (<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>); solo eliminamos enlaces no permitidos. El c\u00f3digo est\u00e1 aqu\u00ed: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">c\u00f3digo fuente</a>. Esto se utiliza \u00fanicamente para mostrar informaci\u00f3n sobre tu fallo y el enlace a los registros. Sin embargo, es posible usar un punto final personalizado que podr\u00eda no tener los mismos m\u00e9todos. Est\u00e1s usando el sitio de informes " + Config.obtenerInstancia().obtenerSitoDeInformes() + " y el sitio de registros " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + ". Tambi\u00e9n puedes compartir registros individuales sin un informe presionando los botones de compartir junto a los nombres de los registros individuales; los registros ir\u00e1n al sitio de registros seleccionado. CrashDetector tiene una anonimizaci\u00f3n de registros predeterminada, que intenta eliminar nombres de usuario, UUID, tokens de acceso, IDs de sesi\u00f3n, direcciones IP y otros datos. Sin embargo, no es perfecta. A\u00fan as\u00ed, el autor del modpack puede desactivarla. Se puede activar o desactivar con la casilla de verificaci\u00f3n en la parte inferior de esta pantalla. Eres el controlador de tus propios datos; t\u00fa decides d\u00f3nde subes tus datos. Los sitios de registro son propiedad de terceros cuya propiedad a menudo est\u00e1 oculta por privacidad. Asumes toda la responsabilidad de gestionar tus datos y los riesgos involucrados. El Di\u00e1logo de Compartir de CrashDetector es simplemente una interfaz que te permite gestionar eso. Es importante que est\u00e9s al tanto del RGPD y ARCO. Si est\u00e1s en Europa, puedes usar <a href=\"https://securelogger.top\">securelogger.top</a> alojado en Alemania por Hetzner. Para m\u00e1s informaci\u00f3n legal, consulta los siguientes enlaces: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>, <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">RGPD</a>, <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">Pol\u00edtica B\u00e1sica de Protecci\u00f3n de Datos en Jap\u00f3n</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "Enlance de Informe:";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "Guardar Config de Compartir";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "El registro es demasiado grande para este sitio de registro. Elija otro e int\u00e9ntelo nuevamente.";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "Error publicando registro " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "API de Registro no existe. Por favor cambiar API de registro en la configuraci\u00f3n.";
    }

    @Override
    public String errorSSL() {
        return "Tienes Error SSL. Es com\u00fan con versiones de Java viejas, incluye las versiones de Java 8 en el Launcher Minecraft predeterminado y las versiones en sun.com y java.com. Esto afecta a muchos aspectos, como los archivos JAR del instalador de MinecraftForge, la funci\u00f3n para compartir informes de CrashDetector al usar el endpoint predeterminado, algunos mods que requieren internet y algunos sitios de registro. Si te ocurre esto al intentar compartir un informe, simplemente adjunta una captura de pantalla y selecciona un sitio de registro compatible con versiones anteriores de Java 8.";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JavaFML Incompatible: Requiere versi\u00f3n " + requerido + ", detectado " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u00a1Atenci\u00f3n! JavaFML requiere una versi\u00f3n espec\u00edfica de Minecraft Forge</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El archivo JAR '" + archivoJar + "' requiere el proveedor de lenguaje '" + proveedor + "' versi\u00f3n '" + requerido + "' o superior, pero solo se encontr\u00f3 la versi\u00f3n '" + encontrado + "'.</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u00a1ALERTA! Crash Assistant es un detector de malware falso. Bloquea intencionalmente el lanzamiento del juego, ignorando tu libertad de seguir jugando con los mods que apunta. <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>Ver c\u00f3digo MalwareMod.java</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>Ver c\u00f3digo JarInJarHelper.java</a>. Solo este mod est\u00e1 en su lista en este momento y solo est\u00e1n yendo realmente tras el sitio de registro predeterminado, que puede ser cambiado por el usuario, y eso solo ocurre si eliges expl\u00edcitamente usar la funci\u00f3n integrada de compartir registros. CrashAssistant NO realiza ninguna verificaci\u00f3n para determinar qu\u00e9 sitio de registro se est\u00e1 utilizando ni explica c\u00f3mo cambiarlo (hay un men\u00fa desplegable en la parte inferior del cuadro de di\u00e1logo de compartir), y sin importar qu\u00e9 sitio tengas configurado, CrashAssistant bloquear\u00e1 el lanzamiento del juego. En su mensaje dicen que hagas tu propia investigaci\u00f3n, HAZLO, investiga el c\u00f3digo de CrashDetector y Crash Assistant y entiende lo que hacen, NO te bases en una apelaci\u00f3n a la autoridad.</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + idMod + "' ha fallado porque no se encontr\u00f3 la clase requerida: '" + claseNoEncontrada + "'. Aseg\u00farate de que todas las dependencias est\u00e9n instaladas correctamente.</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia ha bloqeuado jugar con TLauncher.</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e1s usando una versi\u00f3n de Optifine para una versi\u00f3n de Minecraft obsoleta. Necesitas usar la versi\u00f3n de Optifine para la versi\u00f3n de Minecraft que est\u00e1s usando.</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No se pudo cargar el Servicio de ModLauncher: </b>" + servicio + ".";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error al analizar el archivo JSON '" + recurso + "' del archivo JAR '" + archivoJar + "'. Tiene problemas con el registro.</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Error: El mod '" + modId + "' requiere la versi\u00f3n '" + requerido + "' o superior de '" + dependencia + "', pero se encontr\u00f3 '" + actual + "'.</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tu GPU no soporta la versi\u00f3n de OpenGL requerida por esta Version del Juego. Actualiza tus drivers o cambia de tarjeta gr\u00e1fica</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Aumenta la memoria asignada al juego o reduce el consumo de mods/plugins</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>JVM de 32 bits detectada: No puede utilizar m\u00e1s de 4GB de RAM. Instala una JVM de 64 bits para aprovechar toda tu memoria disponible</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico de memoria PermGen. Aumenta el espacio de memoria permanente o reduce la carga de clases</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error de compatibilidad entre Java 8 y versiones modernas</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+ no compatible - Usa Java 8 para Forge antiguo</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8 requerido (versi\u00f3n 52.0). Actualiza o configura correctamente</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico de compatibilidad: Bloques no soportados en esta versi\u00f3n. Verifica que las versiones de mods y servidor sean compatibles</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error de configuraci\u00f3n de monitores: No se pudo establecer el modo de pantalla. Verifica:</b><br>- Configuraci\u00f3n de m\u00faltiples monitores<br>- Controladores de tarjeta gr\u00e1fica actualizados<br>- Resoluci\u00f3n soportada por el sistema";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error en opciones de Java: Opciones de recolector de basura conflictivas. Verifica que no combines m\u00faltiples algoritmos GC en los par\u00e1metros JVM</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico de configuraci\u00f3n NightConfig/Forge: Archivo de configuraci\u00f3n corrupto o incompleto. Esto puede ser causado por archivos de configuraci\u00f3n vac\u00edos (a menudo de 0 bytes) en la carpeta 'config' en versiones anteriores o personalizadas de NightConfig. Para la mayor\u00eda de las versiones, Night Config Fixes resolver\u00e1 el problema, pero si est\u00e1s utilizando una versi\u00f3n no compatible o una versi\u00f3n personalizada de NightConfig, deber\u00e1s eliminar los archivos de configuraci\u00f3n manualmente. Este problema es m\u00e1s com\u00fan en versiones antiguas de MC Forge (que viene con NightConfig) y en mods de FabricMC antiguos que empaquetan NightConfig, pero tambi\u00e9n puede existir en algunas versiones personalizadas de NightConfig. M\u00e1s informaci\u00f3n sobre las soluciones est\u00e1 disponible en <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a>.</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error de controlador Intel HD Graphics detectado. Soluciones:</b><br>1. Actualiza los controladores Intel desde <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a> (versi\u00f3n m\u00ednima 15.xx.xx.xx)<br>2. En Minecraft: Opciones \u2192 Video \u2192 Activa 'Enable VBOs' y 'VSync'<br>3. Asigna 1GB-2GB de RAM al juego en el launcher<br>4. Desactiva temporalmente antivirus/firewall durante la actualizaci\u00f3n";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "Advertencia: Clases faltantes detectadas";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "Error de renderizado de bloques";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "An\u00e1lisis de stack trace";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "Consola CurseForge incompleta";
    }

    @Override
    public String nombre_de_early_window() {
        return "Error de ventana temprana (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "Problemas con controladores de video";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "Configuraci\u00f3n corrupta de MCForge";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "Fallo en modo de visualizaci\u00f3n (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "Error de inicializaci\u00f3n de FabricMC";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "M\u00f3dulos JPMS faltantes";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "Clases cr\u00edticas faltantes";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "Dependencias faltantes de ModLauncher";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "Versiones de Java incompatibles";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "Error de recursos KubeJS";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "Proveedor de lenguaje incompatible";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "Litchhost";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "Falso positivo de malware detectado";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "Mod sospechoso detectado";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "Mods duplicados en ModLauncher";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "Conflictos de m\u00f3dulos JPMS";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "Sodium requerido para Iris";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "Error al analizar JSON de registro";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "Memoria insuficiente";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "Error de puntero nulo (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "Opciones de GC de Java inv\u00e1lidas";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "OptiFine obsoleta/no compatible";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "Tick de servidor cr\u00edtico (60s)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "Servicios ModLauncher fallidos";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "Configuraciones SpongeMixing problem\u00e1ticas";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus no compatible";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "Launcher TLauncher no soportado por WATERMeDIA";
    }

    @Override
    public String auditorias_transformer() {
        return "Auditor\u00edas Transformer";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Estos son los resultados de los contenidos de las Auditor\u00edas Transformer en el Launcher Vainilla. Generalmente es menos preciso que el analizador de StackTrace, pero el Launcher Vainilla no siempre tiene contenido de {}</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "Esto busca en tus mods aquellos creados con MCreator. Aunque la mayor\u00eda de los mods de MCreator est\u00e1n bien y hay muchos mods geniales hechos con MCreator, a veces tienen problemas y tienen mala reputaci\u00f3n. Esto ayuda a identificarlos. Ten en cuenta que incluso los mejor valorados pueden no ser realmente de MCreator; por ejemplo, pueden tener integraci\u00f3n con MCreator.";
    }

    @Override
    public String escanear() {
        return "Escanear";
    }

    @Override
    public String cargando() {
        return "Cargando";
    }

    @Override
    public String codigo() {
        return "es";
    }

    @Override
    public String inicioApp() {
        return "Inicio de Juego/App";
    }

    @Override
    public String ajustesCrashDetector() {
        return "Ajustes CrashDetector";
    }

    @Override
    public String confidencialidad() {
        return "Confidencialidad";
    }

    @Override
    public String tooltip() {
        return "Tooltip";
    }

    @Override
    public String config() {
        return "Configuraci\u00f3n";
    }

    @Override
    public String abrirCarpeta() {
        return "Abrir Carpeta";
    }

    @Override
    public String actualizar() {
        return "Actualizar";
    }

    @Override
    public String anadirRegistro() {
        return "A\u00f1adir Registro";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "Usar idioma del sistema";
    }

    @Override
    public String volver() {
        return "Volver";
    }

    @Override
    public String colorFondo() {
        return "Color de fondo (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "Color de texto (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "Color de bot\u00f3n (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "Color de caja de texto (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "Color de enlace (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "Color de t\u00edtulos de consolas (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "Color de error (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "Color de advertencia (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "Color de informaci\u00f3n (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "Color de t\u00edtulo (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "Color de enlace texto (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "Solo abrir CrashDetector en falla";
    }

    @Override
    public String activar_parche() {
        return "Activar Parche";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "No Hay Soluci\u00f3n Disponible";
    }

    @Override
    public String error() {
        return "error";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "Error al eliminar Jar";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar eliminado exitosamente";
    }

    @Override
    public String exito() {
        return "\u00e9xito";
    }

    @Override
    public String eliminar() {
        return "eliminar";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "Error al eliminar paquete";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "Paquete eliminado exitosamente";
    }

    @Override
    public String eliminar_paquete() {
        return "Eliminar paquete";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "No se encontraron mods con paquete";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "No se puede eliminar paquete";
    }

    @Override
    public String eliminar_jar() {
        return "Eliminar jar";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "No se encontraron mods duplicados";
    }

    @Override
    public String archivo_no_encontrado() {
        return "Archivo No Encontrado";
    }

    @Override
    public String directorio_eliminado() {
        return "Directorio Eliminado";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "Error al eliminar jar anidado";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "Archivo interno no encontrado";
    }

    @Override
    public String archivo_eliminado() {
        return "archivo eliminado";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "error al eliminar archivo";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "archivo externo no valido";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "Elemento mod eliminado";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "Error al reemplazar jar externo";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "error al eliminar elemento mod";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "error al eliminar directorio";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "formato invalido para jar anidado";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "jar anidado eliminado";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "error al limpiar temporales";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mensaje de Trace Fatal \u00daltima (No traducido):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mensaje de Trace \u00daltima (No traducido):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "Puedes buscar en la base de datos WaifuNeoForge para encontrar mods. Selecciona la versi\u00f3n del juego, el cargador de mods y la clase. Usa la combinaci\u00f3n m\u00e1s similar. Puedes buscar una vez por minuto.";
    }

    @Override
    public String solucionFaltasClases() {
        return "Puedes buscar en la base de datos WaifuNeoForge para encontrar mods. Selecciona la versi\u00f3n del juego, el cargador de mods y la clase. Usa la combinaci\u00f3n m\u00e1s similar. Puedes buscar una vez por minuto.";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "Ambos lanzadores tienen las versiones de Java correctas pero no todas, puedes instalar la versi\u00f3n de Java correcta desde el Administrador de paquetes en tu sistema o con los botones.";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mod con Animaci\u00f3n Falta: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException (Excepci\u00f3n No Elemento) Falta Animaci\u00f3n";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "No se encontraron mods para eliminar";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "Reemplazar opciones de GC conflictivas con -XX:+UseG1GC";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "Aumentar el tama\u00f1o de la memoria del heap utilizando la opci\u00f3n -Xmx.";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "Aumentar el tama\u00f1o de la memoria permgen utilizando la opci\u00f3n -XX:MaxPermSize.";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "Utilizar una JVM de 64 bits para aumentar la memoria disponible.";
    }

    @Override
    public String optimizarCodigo() {
        return "Optimizar el c\u00f3digo para reducir el uso de memoria y mejorar el rendimiento.";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "Utilizar un recolector de basura eficiente para reducir la pausa de la aplicaci\u00f3n.";
    }

    @Override
    public String modulos() {
        return "M\u00f3dulos";
    }

    @Override
    public String paquete() {
        return "Paquete";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "Hay faltas IDs. Causas comunes son mods faltantes o datos de art\u00edculos faltantes. Carpetas comunes de datos son datafiedcontents/ y kubejs/ u otras carpetas de mods.";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "registros mal mapeados";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin 'AuthMe' fall\u00f3 al cargar y ha cerrado el servidor.</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "Problema de cierre por AuthMe";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "La regla 'stopServer' cambi\u00f3 a 'true'.";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "Configurar el plugin AuthMe (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "Instalar una versi\u00f3n diferente del plugin 'AuthMe'";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "Eliminar el plugin 'AuthMe'";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mundo '" + nombreMundo + "' no se pudo cargar porque contiene errores y probablemente est\u00e1 corrupto.</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "Problema de carga de Multiverse";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "Repara el mundo '" + nombreMundo + "', por ejemplo usando Minecraft Region Fixer o MCEdit.";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "Elimina la carpeta del mundo '" + nombreMundo + "'.";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La configuraci\u00f3n de la extensi\u00f3n 'PermissionsEx' es inv\u00e1lida.</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "Problema de configuraci\u00f3n de PermissionsEx";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "Configurar el plugin PermissionsEx (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "Eliminar el plugin 'PermissionsEx'";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Hay m\u00faltiples archivos de plugins para el plugin de nombre '" + nombrePlugin + "': '" + primerPath + "' y '" + segundoPath + "'.</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "Problema de nombre ambiguo de plugin";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "Eliminar el plugin '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Hubo una excepci\u00f3n mientras el mundo cargaba los chunks. Si existe para tu plataforma, es posible que FeatureRecycler pueda resolver el problema. https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "Excepci\u00f3n al cargar chunks";
    }

    @Override
    public String solucionEliminarChunk() {
        return "Quita el chunk problem\u00e1tico del mundo, por ejemplo con MCEdit o quitando el archivo de regi\u00f3n.";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin '" + nombrePlugin + "' no puede ejecutar el comando '/" + comando + "'.</b> ";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "Excepci\u00f3n al ejecutar comando de plugin";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "Instalar una versi\u00f3n diferente del plugin '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin '" + nombrePlugin + "' necesita como dependencia la extensi\u00f3n '" + dependencia + "'.</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin '" + nombrePlugin + "' es falto de los siguientes plugins requeridos " + deps.toString() + ".</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "Dependencia de plugin faltante";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "Instalar el plugin '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin '" + nombrePlugin + "' necesita la versi\u00f3n de API '" + versionAPI + "' que no es compatible con el servidor actual.</b> ";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "Versi\u00f3n de API incompatible";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "Instala la versi\u00f3n '" + version + "' del software de tu servidor.";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mundo '" + nombreMundo + "' es un duplicado de otro mundo y no se puede cargar.</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "Mundo Duplicado";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "Elimina el archivo 'uid.dat' del mundo '" + nombreMundo + "'";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "Elimina la carpeta del mundo '" + nombreMundo + "'";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La entidad de bloque '" + nombre + "' del tipo '" + tipo + "' en la ubicaci\u00f3n " + coords + " est\u00e1 causando errores durante el ticking.</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "Entidad de Bloque Problem\u00e1tica";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "Elimina la entidad '" + nombre + "' en la ubicaci\u00f3n " + coords + " usando MCEdit o editando el mundo directamente.";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' tiene m\u00faltiples versiones instaladas.</b> ";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "Mod Duplicado en Fabric";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "Elimina el archivo duplicado del mod: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Los mods '" + primerMod + "' y '" + segundoMod + "' son incompatibles entre s\u00ed.</b> ";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "Mod Incompatible en Fabric";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "Elimina el mod '" + nombreMod + "'";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' tiene un error cr\u00edtico y no puede ejecutarse.</b> ";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "Mod con Error Cr\u00edtico";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Los siguientes mods son requeridos y no est\u00e1n instalados: " + deps.toString() + ".</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' necesita como dependencia el mod '" + dependencia + "'.</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' necesita el mod '" + dependencia + "' con versi\u00f3n " + version + ".</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "Dependencia de mod faltante";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "Instale el mod '" + nombreMod + "'";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "Instale el mod '" + nombreMod + "' con la versi\u00f3n " + version;
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin '" + nombrePlugin + "' no es compatible con ticking regional de Folia.</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Los siguientes plugins no son compatibles con el ticking regional de Folia: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "Plugin incompatible con Ticking Regional";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "Instalar un software sin ticking regional, como " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' est\u00e1 faltando en el datapack.</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Los siguientes mods est\u00e1n faltando en el datapack: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" y ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "Mod faltante en datapack";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' ha generado un error.</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Los siguientes mods han generado errores: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" y ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "Mod de Forge con Excepci\u00f3n";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "Instalar una versi\u00f3n diferente del mod '" + nombreMod + "'";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' no es compatible con la versi\u00f3n de Minecraft " + versionMC + ".</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Los siguientes mods no son compatibles con las versiones de Minecraft: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (Minecraft ").append(versionesMC.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "Mod incompatible con Minecraft";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "Instalar una versi\u00f3n de Forge compatible con Minecraft " + versionMC;
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod '" + nombreMod + "' est\u00e1 faltando y es requerido para cargar el mundo o plugin.</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "Mod faltante";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mundo fue guardado con el mod '" + nombreMod + "' que parece estar ausente.</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("El mundo fue guardado con los siguientes mods que parecen estar ausentes: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" y ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "Mod faltante en el mundo";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mundo fue guardado con el mod '" + nombreMod + "' versi\u00f3n " + versionEsperada + ", y ahora est\u00e1 en la versi\u00f3n " + versionActual + ".</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Los siguientes mods tienen discrepancias de versi\u00f3n en el mundo guardado: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" y ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (Guardado: ").append(versionesEsperadas.get(i)).append(", Actual: ").append(versionesActuales.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "Versi\u00f3n de mod en el mundo guardado";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Intentaste cargar un mundo creado con una versi\u00f3n m\u00e1s nueva de Minecraft.</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "Intento de cargar un mundo desde una versi\u00f3n inferior";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "Instalar una nueva versi\u00f3n de Minecraft.";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "Generar un nuevo mundo.";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin '" + nombrePlugin + "' necesita como dependencia el plugin '" + dependencia + "'.</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Los siguientes plugins necesitan dependencias que no est\u00e1n instaladas: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("' (").append(dependencias.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "Plugin con dependencia faltante";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La extensi\u00f3n '" + nombrePlugin + "' es incompatible con la versi\u00f3n actual del servidor.</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Las siguientes extensiones son incompatibles con la versi\u00f3n actual del servidor: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" y ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "Plugin incompatible con PocketMine-MP";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El plugin '" + nombrePlugin + "' ha generado un error durante la ejecuci\u00f3n.</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Los siguientes plugins han generado errores durante la ejecuci\u00f3n: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" y ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "Plugin con error de ejecuci\u00f3n";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "LegacyRandomSource Multi Hilos";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes problema con mutiple hilos acesando la clase LegacyRandomSource. Puedes obtaner mas information con la mod Unsafe World Random Access Detector o la mod C2ME.</b> ";
    }

    @Override
    public String desdeUltimoExito() {
        return "Desde Ultima Exito";
    }

    @Override
    public String noHayCambios() {
        return "No Hay Cambios";
    }

    @Override
    public String desdeUltimoIntento() {
        return "Desde Ultimo Intento";
    }

    @Override
    public String fallo() {
        return "Fallo";
    }

    @Override
    public String diferentesDeLasMods() {
        return "Diferentes De Las Mods";
    }

    @Override
    public String historialDeMods() {
        return "HistorialDeMods";
    }

    @Override
    public String archivo0() {
        return "Archivo0";
    }

    @Override
    public String archivo1() {
        return "Archivo1";
    }

    @Override
    public String comparar() {
        return "Comparar";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "Seleccionar Dos Archivos";
    }

    @Override
    public String archivoExito() {
        return "Archivo Exito";
    }

    @Override
    public String archivoFalla() {
        return "Archivo Falla";
    }

    @Override
    public String errorComparandoArchivos() {
        return "Error Comparando Archivos";
    }

    @Override
    public String comparando() {
        return "Comparando";
    }

    @Override
    public String con() {
        return "Con";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'><p><b>Panel de Comparaci\u00f3n de Historial de Mods</b></p><p>Este panel le permite comparar dos listas de mods (m\u00f3dulos) de diferentes sesiones de ejecuci\u00f3n. Seleccione un archivo de la columna izquierda y otro de la derecha para ver los cambios realizados entre ambas versiones.</p><h3>C\u00f3mo usarlo:</h3><ol><li><b>Selecci\u00f3n de archivos:</b> Haga clic en los botones de radio junto a los nombres de los archivos. Los archivos terminados en <span style='color: #4CAF50; font-weight: bold;'>.exito</span> indican sesiones exitosas, mientras que los de <span style='color: #F44336; font-weight: bold;'>.falla</span> corresponden a fallos.</li><li><b>Comparaci\u00f3n autom\u00e1tica:</b> Al presionar el bot\u00f3n 'Compare', el sistema analizar\u00e1 las dos listas seleccionadas y mostrar\u00e1 los mods a\u00f1adidos (+) o eliminados (-) en cada direcci\u00f3n.</li><li><b>Visualizaci\u00f3n de resultados:</b> Los resultados se presentan en formato HTML con colores codificados: <ul><li><span style='color: green;'>+ Mod a\u00f1adido</span></li><li><span style='color: red;'>- Mod eliminado</span></li></ul></li></ol><h3>Caracter\u00edsticas clave:</h3><ul><li>Soporta selecci\u00f3n de cualquier combinaci\u00f3n de archivos (\u00e9xito/fallo).</li><li>Muestra diferencias bidireccionales para identificar cambios precisos.</li><li>Incluye scroll para navegar por listas largas de mods.</li><li>Integraci\u00f3n con im\u00e1genes explicativas para mejorar la comprensi\u00f3n visual.</li></ul><p>Desarrollado con <3\ufe0f para ayudarle a rastrear modificaciones en sus configuraciones.</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Es posible que tengas un problema relacionado con IPv6. Existen dos soluciones: 1) Agregar el argumento JVM <code>-Djava.net.preferIPv4Stack=true</code> en tu lanzador, o 2) Usar el bot\u00f3n 'QuickFix' en CrashDetector para aplicar un parche que active esta configuraci\u00f3n autom\u00e1ticamente.</b>";
    }

    @Override
    public String parcheIPv4() {
        return "Parche IPV4/6";
    }

    @Override
    public String carpetaHMCL() {
        return "Carpeta HMCL (Solo para HelloMineCraftLauncher)";
    }

    @Override
    public String descripcionCurseforge() {
        return "Nota: No se genera registro si est\u00e1 activada la opci\u00f3n \"Saltar Launcher\" en Ajustes > Minecraft";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/Derivados: Haga clic derecho sobre la instancia y seleccione \"Editar Instancia\". En la ventana que se abre, busque la secci\u00f3n \"Registros de Minecraft\" o similar.<br>Estos registros contienen la salida est\u00e1ndar (STDOUT) que es fundamental para diagnosticar errores.";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): Debe seleccionar la carpeta donde HMCL est\u00e1 instalado y elegir la carpeta \".hcml\". Los registros de HMCL se guardan en esta ubicaci\u00f3n y contienen informaci\u00f3n importante sobre errores.<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix: El lanzador tiene una pesta\u00f1a de desarrollo que muestra registros detallados. Puede encontrar esta pesta\u00f1a en el men\u00fa de opciones del lanzador.";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher: Hay un di\u00e1logo emergente con los registros. Tiene botones para copiar y subir los registros. Los registros se generan autom\u00e1ticamente al iniciar el juego y contienen informaci\u00f3n cr\u00edtica para diagn\u00f3stico.";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher: Haga clic derecho sobre la instancia y seleccione \"Configuraci\u00f3n\". Luego vaya a la secci\u00f3n de Registros para ver la informaci\u00f3n importante que contiene la salida est\u00e1ndar (STDOUT).";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "Enlaces con Markdown: Pegue aqu\u00ed cualquier enlace que contenga registros en formato Markdown. El sistema intentar\u00e1 extraer autom\u00e1ticamente los enlaces a registros (latest.log, launcher_log.txt, debug.log, etc.) y analizarlos.";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "Registro de Launcher No Encontrado";
    }

    @Override
    public String imagenNoEncontrada() {
        return "Imagen no encontrada";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "GEN\u00c9RICO: Seleccione el tipo de launcher que est\u00e1 utilizando. Los registros del launcher (launcher_log.txt, stdout, etc.) contienen informaci\u00f3n crucial sobre errores que no aparecen en latest.log. CrashDetector no puede leer los registros de tu Launcher, es posible que no tenga un archivo de registro y deba pegar los registros manualmente.<br>Para m\u00e1s informaci\u00f3n, consulte <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">este problema</a>. Estos registros contienen la salida est\u00e1ndar (STDOUT), necesaria para diagnosticar muchos tipos de errores.";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de Create. Create cambi\u00f3 mucho: muchas clases fueron eliminadas. Especialmente desde Create 6 (febrero 2025), los addons para versiones antiguas de Create no funcionan. QuickFix no tiene una soluci\u00f3n para este problema. Necesitas actualizar los addons de Create, eliminar los obsoletos, o usar la versi\u00f3n correcta de Create para los addons que deseas usar.</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de EpicFight. EpicFight cambi\u00f3 mucho: muchas clases fueron eliminadas. QuickFix no tiene una soluci\u00f3n para este problema. Necesitas actualizar los addons de EpicFight, eliminar los obsoletos, o usar la versi\u00f3n correcta de EpicFight para los addons que deseas usar.</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e1s utilizando OpenJ9, que no es compatible con Esta Aplicacion. Muchos apps, incluido \u00e9ste, no soportan OpenJ9 debido a diferencias en la implementaci\u00f3n de la JVM. QuickFix no puede resolver este problema autom\u00e1ticamente. Necesitas instalar un JDK compatible como Oracle JDK, OpenJDK Hotspot u otros alternativos recomendados.</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Esta versi\u00f3n de la applicacion requiere Java 11 (JDK 11) para funcionar correctamente. Est\u00e1s utilizando una versi\u00f3n anterior de Java que no es compatible. QuickFix no puede actualizar tu Java autom\u00e1ticamente. Necesitas descargar e instalar JDK 11 o una versi\u00f3n superior compatible desde los enlaces proporcionados en la soluci\u00f3n.</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Has asignado demasiada memoria, lo que est\u00e1 causando que el sistema no tenga suficientes recursos para funcionar correctamente. Esto suele ocurrir cuando se especifica una cantidad de RAM mayor a la disponible en tu sistema o cuando se usa una JVM de 32 bits que no puede manejar grandes cantidades de memoria.</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Para resolver este problema, debes reducir la cantidad de memoria asignada a la app. La cantidad m\u00e1xima recomendada depende de tu sistema, pero generalmente no debe exceder el 70-80% de tu memoria RAM total. Si usas una JVM de 32 bits, el l\u00edmite m\u00e1ximo es de aproximadamente 2-3 GB, independientemente de la cantidad de RAM f\u00edsica que tengas.</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Para disminuir la memoria heap asignada a la app, abre la configuraci\u00f3n de tu lanzador y busca la opci\u00f3n de memoria RAM. Reduce el valor m\u00e1ximo (Xmx) a una cantidad m\u00e1s adecuada. Por ejemplo, si tienes 8 GB de RAM, asigna entre 3-4 GB a la app. Si tienes 16 GB de RAM, puedes asignar entre 6-8 GB. Recuerda dejar suficiente memoria para el sistema operativo y otros programas.</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Faltan archivos esenciales de Forge. El archivo '" + archivo + "' no se encuentra en tu instalaci\u00f3n. Esto suele ocurrir cuando la instalaci\u00f3n de Forge se interrumpi\u00f3 o se eliminaron archivos importantes. QuickFix no puede recuperar estos archivos autom\u00e1ticamente. Necesitas reinstalar Forge correctamente desde el instalador oficial.</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge no puede encontrar la versi\u00f3n de Minecraft requerida. Se necesita la versi\u00f3n " + version + " pero no se encuentra en el archivo '" + archivo + "'. Esto ocurre cuando hay una incompatibilidad entre la versi\u00f3n de Minecraft y la versi\u00f3n de Forge que est\u00e1s utilizando. Aseg\u00farate de descargar la versi\u00f3n correcta de Forge que coincida con tu versi\u00f3n de Minecraft.</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No se puede encontrar el target 'fmlclient' necesario para iniciar Forge. Esto indica que la instalaci\u00f3n de Forge est\u00e1 incompleta o da\u00f1ada. Es probable que los archivos esenciales de Forge no se hayan instalado correctamente. Necesitas reinstalar Forge usando el instalador oficial.</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No se puede encontrar la clase principal de Minecraft en el cargador de clases. Esto suele indicar que la instalaci\u00f3n de Forge est\u00e1 incompleta o que hay un conflicto con otros mods. Es posible que los archivos de Minecraft se hayan da\u00f1ado durante la instalaci\u00f3n de Forge. Necesitas reinstalar Forge correctamente.</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La instalaci\u00f3n de Forge no est\u00e1 completa. Esto puede deberse a una instalaci\u00f3n interrumpida, archivos eliminados o una incompatibilidad con tu versi\u00f3n de Minecraft. Forge necesita archivos espec\u00edficos para funcionar correctamente, y algunos de ellos est\u00e1n faltando en tu instalaci\u00f3n actual.</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "Instalaci\u00f3n incompleta de Forge";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Para resolver este problema, necesitas reinstalar Forge correctamente. Aseg\u00farate de descargar la versi\u00f3n adecuada para tu versi\u00f3n de Minecraft y seguir el proceso de instalaci\u00f3n completo sin interrumpirlo.</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "Descargar Forge oficialmente";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "C\u00f3mo reinstalar Forge correctamente";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>Instrucciones para reinstalar Forge:</h3><ol><li>Descarga el instalador correcto de Forge desde el sitio oficial (versi\u00f3n recomendada para tu versi\u00f3n de Minecraft)</li><li>Cierra completamente tu launcher de Minecraft</li><li>Ejecuta el instalador de Forge como administrador</li><li>Selecciona la opci\u00f3n 'Installer' (no 'Installer (run client)')</li><li>Elige la carpeta de tu perfil de Minecraft en el launcher</li><li>Presiona 'OK' y espera a que termine la instalaci\u00f3n</li><li>Reinicia tu launcher y verifica que Forge aparezca en la lista de perfiles</li></ol><p><b>Nota importante:</b> Si usas un launcher personalizado, aseg\u00farate de seleccionar la carpeta correcta del perfil.</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "Instrucciones para reinstalar Forge";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error de enlace insatisfecho: No se pudo cargar la biblioteca " + nombreBiblioteca + ". Posibles soluciones:<br/><br/>a) A\u00f1ade el directorio que contiene la biblioteca compartida a -Djava.library.path o -Dorg.lwjgl.librarypath.<br/>b) A\u00f1ade el archivo JAR que contiene la biblioteca compartida al classpath.<br/><br/>Este error ocurre cuando Minecraft no puede encontrar archivos esenciales para su funcionamiento. Esto suele deberse a una instalaci\u00f3n incompleta de Minecraft o a problemas con los permisos del sistema.</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "Error de enlace insatisfecho";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>No se pudo cargar una biblioteca. Posibles soluciones:<br/><br/>a) A\u00f1ade el directorio que contiene la biblioteca compartida a -Djava.library.path o -Dorg.lwjgl.librarypath.<br/>b) A\u00f1ade el archivo JAR que contiene la biblioteca compartida al classpath.<br/><br/>Estas soluciones t\u00e9cnicas son para usuarios avanzados. La mayor\u00eda de los usuarios deber\u00edan intentar reinstalar Minecraft antes de modificar estos par\u00e1metros.</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Colisi\u00f3n de IDs: El ID <strong>" + id + "</strong> ya est\u00e1 ocupado por <strong>" + modOrigen + "</strong> al intentar agregar <strong>" + modDestino + "</strong>. Esto sucede cuando dos mods intentan usar el mismo ID para diferentes elementos.</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se ha excedido el rango m\u00e1ximo de IDs permitidos. Esto ocurre cuando los mods intentan registrar bloques o \u00edtems con IDs fuera del rango permitido por tu versi\u00f3n de Minecraft.</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "Conflicto de IDs";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Para resolver esto en Minecraft 1.12.2, instala <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a>. Para 1.7.10, usa <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a>.</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Usa herramientas como <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> o <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a> para resolver colisiones de IDs.</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "Instalar JustEnoughIDs";
    }

    @Override
    public String instalar_endlessids() {
        return "Instalar EndlessIDs";
    }

    @Override
    public String usar_idfix_minus() {
        return "Usar IdFix Minus o IdFix";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "Usar Minecraft-ID-Resolver";
    }

    @Override
    public String ver_documentacion_jp() {
        return "Ver documentaci\u00f3n japonesa";
    }

    @Override
    public String escanearDeMCreator() {
        return "Escanear MCreator";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\u00c1rbol de M\u00f3dulos y Clases";
    }

    @Override
    public String tipoBusqueda() {
        return "Tipo";
    }

    @Override
    public String filtroTodos() {
        return "Todos";
    }

    @Override
    public String filtroPaquetes() {
        return "Paquetes";
    }

    @Override
    public String filtroClases() {
        return "Clases";
    }

    @Override
    public String filtroMetodos() {
        return "M\u00e9todos";
    }

    @Override
    public String filtroCampos() {
        return "Campos";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "Referencias de Campo";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "Referencias de M\u00e9todo";
    }

    @Override
    public String filtroReferenciasClase() {
        return "Referencias de Clase";
    }

    @Override
    public String tipBuscar() {
        return "Escriba aqu\u00ed para buscar en el \u00e1rbol de mods";
    }

    @Override
    public String botonBuscar() {
        return "Buscar";
    }

    @Override
    public String botonResetearArbol() {
        return "Resetear \u00c1rbol";
    }

    @Override
    public String modsCargados() {
        return "Mods Cargados";
    }

    @Override
    public String clases() {
        return "Clases";
    }

    @Override
    public String metodos() {
        return "M\u00e9todos";
    }

    @Override
    public String campos() {
        return "Campos";
    }

    @Override
    public String referencias() {
        return "Referencias";
    }

    @Override
    public String resultadosBusqueda() {
        return "Resultados de B\u00fasqueda";
    }

    @Override
    public String buscarReferencias() {
        return "Buscar Referencias";
    }

    @Override
    public String referenciasMod() {
        return "Referencias del Mod";
    }

    @Override
    public String referenciasClase() {
        return "Referencias de la Clase";
    }

    @Override
    public String referenciasMetodo() {
        return "Referencias del M\u00e9todo";
    }

    @Override
    public String referenciasCampo() {
        return "Referencias del Campo";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "No se encontraron referencias";
    }

    @Override
    public String detalleMod() {
        return "Detalles del Mod:";
    }

    @Override
    public String ubicacion() {
        return "Ubicaci\u00f3n";
    }

    @Override
    public String nombres() {
        return "Nombres";
    }

    @Override
    public String modulo() {
        return "M\u00f3dulo";
    }

    @Override
    public String detalleClase() {
        return "Detalles de la Clase:";
    }

    @Override
    public String detalleMetodo() {
        return "Detalles del M\u00e9todo:";
    }

    @Override
    public String detalleCampo() {
        return "Detalles del Campo:";
    }

    @Override
    public String clase() {
        return "Clase";
    }

    @Override
    public String tipo() {
        return "Tipo";
    }

    @Override
    public String referenciasAMetodos() {
        return "Referencias a M\u00e9todos:";
    }

    @Override
    public String referenciasACampos() {
        return "Referencias a Campos:";
    }

    @Override
    public String arbolDeMods() {
        return "\u00c1rbol de Mods";
    }

    @Override
    public String metodo() {
        return "M\u00e9todo";
    }

    @Override
    public String campo() {
        return "Campo";
    }

    @Override
    public String descompilar() {
        return "Descompilar";
    }

    @Override
    public String exportar() {
        return "Exportar";
    }

    @Override
    public String importar() {
        return "Importar";
    }

    @Override
    public String errorImportar() {
        return "Error Importar";
    }

    @Override
    public String estructuraImportada() {
        return "Estructura Importada";
    }

    @Override
    public String estructuraExportada() {
        return "Estructura Exportada";
    }

    @Override
    public String errorExportar() {
        return "Error Exportar";
    }

    @Override
    public String exportando() {
        return "Exportando";
    }

    @Override
    public String exportacionTardara() {
        return "Exportacion Tardara";
    }

    @Override
    public String porFavorEspere() {
        return "Por Favor Espere";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>No tienes las binarias de VLC. Necesitas las binarias de VLC para WaterMedia. Necesitas instalar manualmente desde https://www.videolan.org/vlc/.  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "Descargar VLC";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico: El nombre del m\u00f3dulo '" + nombreModulo + "' contiene caracteres inv\u00e1lidos. La parte '" + parteInvalida + "' no es un identificador Java v\u00e1lido. Esto ocurre cuando un mod usa palabras reservadas de Java (como 'true', 'class') o caracteres no permitidos en su nombre.</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "Caracteres Inv\u00e1lidos en Nombre de Mod";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "El nombre del mod '" + nombreModulo + "' es inv\u00e1lido porque contiene '" + parteInvalida + "', que es una palabra reservada de Java o un car\u00e1cter no permitido. Busca en los logs qu\u00e9 mod corresponde a este nombre (normalmente el nombre del archivo JAR)";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "Accede a la carpeta del mod y edita el archivo <b>mods.toml</b> dentro de la carpeta <b>/META-INF/</b>. Cambia el valor de <b>modId</b> para que use solo letras, n\u00fameros y guiones bajos, sin palabras reservadas de Java";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "Ejemplo de nombre v\u00e1lido: 'truemod_shot_enchantment' en lugar de 'true.shot.enchantment'. Recuerda que los nombres de mod no pueden contener puntos, guiones, ni palabras reservadas de Java como 'true', 'false' o 'class'";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico con el mod: '" + nombreJar + "'. Falta el campo obligatorio 'mandatory' en sus dependencias. Esto ocurre cuando el archivo mods.toml no especifica si la dependencia es obligatoria.</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "Dependencia de Mod con Campo Obligatorio Faltante";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "El mod problem\u00e1tico es: <b>" + nombreJar + "</b>. Este archivo tiene un error en su configuraci\u00f3n de dependencias";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "Abre el archivo <b>mods.toml</b> dentro de la carpeta <b>/META-INF/</b> del mod <b>" + nombreJar + "</b>";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "En la secci\u00f3n de dependencias, aseg\u00farate que cada entrada incluya <b>mandatory=true</b> o <b>mandatory=false</b> (ej: modId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" )";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico con el mod: '" + nombreJar + "'. Configuraci\u00f3n inv\u00e1lida de access transformer. Esto ocurre cuando el archivo de configuraci\u00f3n tiene sintaxis incorrecta o referencias a clases/m\u00e9todos que no existen.</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "Access Transformer Inv\u00e1lido";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "El mod problem\u00e1tico es: <b>" + nombreJar + "</b>. Este mod contiene una configuraci\u00f3n inv\u00e1lida de access transformer";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "Abre el archivo <b>accessTransformer.cfg</b> dentro del mod <b>" + nombreJar + "</b> (normalmente en la carpeta ra\u00edz del archivo JAR)";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "Corrige la sintaxis del access transformer. Las l\u00edneas deben seguir el formato: <b>access class.method</b> (ej: public net.minecraft.world.entity.Entity.func_200560_a). Elimina l\u00edneas con referencias a clases o m\u00e9todos que no existan en tu versi\u00f3n de Minecraft";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico: Discrepancia entre el ID del mod en la anotaci\u00f3n @Mod y el archivo mods.toml. El mod '" + nombreMod + "' no puede cargarse porque los IDs no coinciden.</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "Discrepancia entre @Mod y mods.toml";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "El mod en desarrollo '" + nombreMod + "' tiene una discrepancia entre el ID en la anotaci\u00f3n <b>@Mod</b> y el valor en <b>mods.toml</b>";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "Verifica que el ID en tu clase principal coincida con el valor <b>modId</b> en el archivo <b>/META-INF/mods.toml</b>. Ejemplo: <b>@Mod(\"mimod\")</b> debe coincidir con <b>modId=\"mimod\"</b>";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "Si est\u00e1s usando Gradle, ejecuta <b>clean</b> despu\u00e9s de hacer cambios para asegurar que los recursos se actualicen correctamente. A veces los archivos antiguos permanecen en la carpeta build";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "cliente" : "servidor";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "servidor" : "cliente";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico: Se est\u00e1 intentando cargar la clase '" + nombreClase + "' en el entorno de " + plataforma + ", pero est\u00e1 dise\u00f1ada para " + plataformaOpuesta + ". <b>Usa la funci\u00f3n 'Arbol de Mods' en la barra lateral para buscar qu\u00e9 mod est\u00e1 intentando cargar esta clase</b>. Los mods est\u00e1n construidos espec\u00edficamente para una plataforma y no funcionan en la otra.</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "Mod en Plataforma Incorrecta";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "En la pesta\u00f1a <b>Arbol de Mods</b> (a la derecha), busca referencias a la clase <b>" + nombreClase + "</b> para identificar qu\u00e9 mod est\u00e1 causando el problema";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "cliente" : "servidor";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "servidor" : "cliente";
        return "El mod identificado es un mod de <b>" + plataformaOpuesta + "</b> y no debe usarse en tu entorno de " + plataforma + ".";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "Elimina el mod problem\u00e1tico de tu carpeta <b>mods</b>. Si necesitas funcionalidad similar para esta plataforma, busca un mod alternativo espec\u00edficamente dise\u00f1ado para <b>cliente</b> o <b>servidor</b> seg\u00fan corresponda";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Error cr\u00edtico: Falta metadata para el modid '").append(modIdFaltante).append("'. ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("Los siguientes mods podr\u00edan estar causando el problema: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", y otros...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Esto ocurre cuando un mod depende de otro mod que no est\u00e1 instalado o tiene un archivo mods.toml incorrecto.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "Metadata de mods.toml Faltante";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("Los siguientes mods dependen de '").append(modIdFaltante).append("': <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", y otros...");
            }
            paso.append("</b>. Usa la funci\u00f3n <b>Arbol de Mods</b> para confirmar qu\u00e9 mod est\u00e1 causando el problema");
            return paso.toString();
        }
        return "Un mod est\u00e1 intentando depender de '" + modIdFaltante + "', pero este mod no est\u00e1 instalado. Usa la funci\u00f3n <b>Arbol de Mods</b> para identificar qu\u00e9 mod est\u00e1 causando el problema";
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "Tienes dos opciones:<br/>1. <b>Instala el mod faltante</b>: Busca e instala el mod con ID '" + modIdFaltante + "'<br/>2. <b>Elimina el mod dependiente</b>: Si no necesitas la funcionalidad, elimina el mod que depende de '" + modIdFaltante + "'";
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "Si el mod '" + modIdFaltante + "' es una biblioteca (como 'forge', 'minecraft', 'curios'), aseg\u00farate de tener instalada la versi\u00f3n correcta de Minecraft y Forge. Si es un mod regular, busca en su p\u00e1gina de descarga los requisitos previos necesarios";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Advertencia: Error al iniciar el sistema de sonido. Se han desactivado los sonidos y la m\u00fasica. Este error est\u00e1 com\u00fanmente asociado con el mod SoundPhysicsMod y puede deberse a conflictos con otras librer\u00edas de sonido.</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "Error en el Sistema de Sonido";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "El error est\u00e1 com\u00fanmente relacionado con <b>SoundPhysicsMod</b>. Verifica si tienes instalada la versi\u00f3n m\u00e1s reciente compatible con tu versi\u00f3n de Minecraft";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "Si usas otros mods de sonido (como Sound Filters, Dynamic Surroundings, etc.), prueba eliminando temporalmente SoundPhysicsMod para ver si resuelve el conflicto";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "Revisa la carpeta <b>logs</b> para encontrar mensajes adicionales relacionados con LWJGL o OpenAL, que pueden indicar problemas con las librer\u00edas de sonido subyacentes";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Error cr\u00edtico: La clase '").append(nombreClase).append("' est\u00e1 registrada como listener de eventos pero no contiene m\u00e9todos v\u00e1lidos. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("Esta clase se encuentra en los siguientes mods: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", y otros...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Esto ocurre cuando se registra una clase para escuchar eventos sin tener m\u00e9todos anotados con @SubscribeEvent.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "Clase Registrada sin Listeners de Eventos";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("La clase problem\u00e1tica se encuentra en estos mods: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", y otros...");
            }
            paso.append("</b>. Estos mods est\u00e1n intentando registrar eventos sin m\u00e9todos v\u00e1lidos");
            return paso.toString();
        }
        return "La clase <b>" + nombreClase + "</b> fue registrada para escuchar eventos pero no contiene m\u00e9todos con la anotaci\u00f3n <b>@SubscribeEvent</b>. Usa la funci\u00f3n <b>Arbol de Mods</b> para identificar qu\u00e9 mod contiene esta clase";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "En el c\u00f3digo fuente, verifica que la clase <b>" + nombreClase + "</b> contenga al menos un m\u00e9todo con: <b>@SubscribeEvent public void nombreMetodo(EventoEspecifico evento) { ... }</b>. Si es una clase interna, aseg\u00farate que no est\u00e9 marcada como est\u00e1tica";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("Para los mods identificados (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", etc.");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("contacta al desarrollador de este mod para que corrija el problema. ");
            } else {
                paso.append("contacta a los desarrolladores de estos mods para que corrijan el problema. ");
            }
        }
        paso.append("Si eres el desarrollador, elimina el registro de esta clase en el EventBus o a\u00f1ade m\u00e9todos @SubscribeEvent v\u00e1lidos");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        String mensaje = "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico: Error en UnionFileSystem al procesar '" + nombreArchivo + "'. ";
        mensaje = mensaje + "Este error es muy com\u00fan en modpacks preconfigurados y est\u00e1 directamente relacionado con problemas del lanzador. ";
        mensaje = mensaje + "El sistema no puede leer correctamente los archivos del mod debido a que est\u00e1n corruptos o incompletos.</b>";
        return mensaje;
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "Error UnionFileSystem - Archivo Corrupto";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        String paso = "Se detect\u00f3 el error espec\u00edfico <b>cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException</b> con el archivo <b>" + nombreArchivo + "</b>.";
        paso = paso + " Este es un error conocido en lanzadores de modpacks cuando los archivos no se descargan completamente.";
        return paso;
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "Reinstala completamente el modpack. Este error ocurre principalmente cuando el lanzador no completa la descarga de todos los archivos. Si est\u00e1s usando <b>Luna Pixel</b>, te recomendamos encarecidamente usar <b>ATLauncher</b> en su lugar, ya que este lanzador maneja mejor los archivos de mods y evita este error espec\u00edfico.";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "Si el problema persiste despu\u00e9s de reinstalar: <br/>1. <b>Cambia a otro lanzador</b> <br/>2. Si usas <b>Luna Pixel</b>, <b>usa ATLauncher</b> que es m\u00e1s confiable para evitar este error espec\u00edfico<br/>3. Verifica tu conexi\u00f3n a internet y espacio en disco antes de reinstalar el modpack";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "\u00bfHabilitar ProxySysOutSysErr?\n\nEsta opci\u00f3n da a CrashDetector acceso a System.out y System.err cuando el launcher no proporciona registros.\n\nSolo debe habilitarse cuando no puedas pegar un registro manualmente.\n\nAdvertencia: Esto puede interferir con algunos mods o launchers.\n\nSe requiere reiniciar el juego/app para que los cambios surtan efecto.";
    }

    @Override
    public String confirmacionTitulo() {
        return "Confirmaci\u00f3n";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr habilitado correctamente.\n\nSe requiere reiniciar CrashDetector para que los cambios surtan efecto.";
    }

    @Override
    public String informacionTitulo() {
        return "Informaci\u00f3n";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("Error cr\u00edtico: \u00a1AzureLib y GeckoLib se inicializaron demasiado pronto! ");
        } else if (azureLibError) {
            mensaje.append("Error cr\u00edtico: \u00a1AzureLib se inicializ\u00f3 demasiado pronto! ");
        } else if (geckoLibError) {
            mensaje.append("Error cr\u00edtico: \u00a1GeckoLib se inicializ\u00f3 demasiado pronto! ");
        }
        mensaje.append("Este error ocurre cuando se intenta usar mods Fabric con versiones no-Fabric de estas librer\u00edas. ");
        if (connectorPresente) {
            mensaje.append("Se detect\u00f3 un mod de compatibilidad (Sinytra Connector o specialcompatibilityoperation), lo que indica que est\u00e1s intentando usar mods Fabric en un entorno Forge o FeatureCreep. ");
            mensaje.append("Revisa el error 'Error de inicializaci\u00f3n de FabricMC' en los logs para identificar qu\u00e9 mod espec\u00edfico est\u00e1 causando el problema. ");
        }
        mensaje.append("AzureLib y GeckoLib son librer\u00edas esenciales para mods de animaci\u00f3n, pero deben coincidir con la plataforma correcta (Fabric o Forge). ");
        mensaje.append("El juego no puede cargar correctamente los mods de animaci\u00f3n debido a este conflicto de inicializaci\u00f3n.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "Librer\u00eda Inicializada Demasiado Pronto";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "Revisa el error 'Error de inicializaci\u00f3n de FabricMC' para identificar el mod problem\u00e1tico";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "Verifica que est\u00e9s usando la versi\u00f3n correcta de AzureLib/GeckoLib para tu plataforma (Forge o Fabric)";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico: Incompatibilidad entre C2ME y mods de conexi\u00f3n. Este error ocurre porque C2ME intenta acceder a componentes internos de Java que est\u00e1n restringidos en entornos con Sinytra Connector o specialcompatibilityoperation u otros mods de compatibilidad Fabric/Forge. <b>C2ME no es compatible con estos entornos, pero <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> es la alternativa recomendada</b> que funciona correctamente con mods de conexi\u00f3n. El juego no puede iniciar debido a este conflicto de permisos de seguridad de Java.</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "Incompatibilidad C2ME con Mods de Conexi\u00f3n";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "Elimina C2ME de tu carpeta de mods";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "Descarga e instala <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> en su lugar (compatible con Sinytra Connector)";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "Verifica que todos los mods de conexi\u00f3n (como Sinytra Connector) est\u00e9n actualizados a su \u00faltima versi\u00f3n";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error cr\u00edtico: Fallo al cargar el plugin JEI para el mod '" + modId + "'. La clase '" + nombreClase + "' (plugin ID: '" + pluginId + "') gener\u00f3 un error que est\u00e1 causando que el juego se bloquee durante el inicio. Este problema ocurre cuando un mod tiene una integraci\u00f3n JEI incompatible o defectuosa que interrumpe la inicializaci\u00f3n del juego.</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "Plugin JEI Fallido - Causa Crash";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "El mod <b>" + modId + "</b> contiene un plugin JEI defectuoso que est\u00e1 causando el crash. Usa la funci\u00f3n <b>Arbol de Mods</b> para confirmar qu\u00e9 mod est\u00e1 generando el problema";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "Elimina temporalmente el mod <b>" + modId + "</b> de tu carpeta de mods para verificar si resuelve el crash";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "Busca actualizaciones del mod <b>" + modId + "</b> o contacta a su desarrollador reportando el problema con el plugin JEI. Mientras tanto, el mod debe ser eliminado para poder iniciar el juego";
    }

    @Override
    public String tituloLectador() {
        return "Lector de Consolas - Crash Detector";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "LEYENDA DE COLORES";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "Errores cr\u00edticos";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "Trazas de pila";
    }

    @Override
    public String obtenerTituloError() {
        return "Error";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "Ocurri\u00f3 un error al procesar la l\u00ednea seleccionada";
    }

    @Override
    public String obtenerNombreError() {
        return "NOMBRE DEL ERROR";
    }

    @Override
    public String obtenerDescripcionError() {
        return "DESCRIPCI\u00d3N DETALLADA";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "SELECCIONAR CONSOLA";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "Error no identificado";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "Se detect\u00f3 un error cr\u00edtico en los registros. Revise la traza de pila para identificar la causa ra\u00edz.";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "No se pudo leer el archivo de registros. Verifique que el archivo existe y tiene permisos de lectura.";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "Analizador de Logs";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Error cr\u00edtico: Fallo al registrar suscriptores autom\u00e1ticos para el mod '").append(modId).append("'. ");
        mensaje.append("Clase problem\u00e1tica: <b>").append(nombreClase).append("</b>. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("Esta clase se encuentra en: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", y otros...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Este error ocurre cuando un mod intenta registrar una clase como suscriptor autom\u00e1tico pero la clase no se puede cargar correctamente. ");
        mensaje.append("<b>Revisa otros errores en el log, ya que el problema real podr\u00eda estar en otra parte del registro</b>.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "Fallo en Registro de Suscriptores Autom\u00e1ticos";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "El mod <b>" + modId + "</b> est\u00e1 intentando registrar la clase <b>" + nombreClase + "</b> como suscriptor autom\u00e1tico, pero ha fallado. Verifica que esta clase exista y sea accesible";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("La clase problem\u00e1tica <b>" + nombreClase + "</b> se encuentra en estos archivos: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", y otros...");
            }
            paso.append("</b>. ");
            paso.append("Usa la funci\u00f3n <b>Arbol de Mods</b> para confirmar qu\u00e9 archivo espec\u00edfico contiene la clase problem\u00e1tica");
            return paso.toString();
        }
        return "La clase <b>" + nombreClase + "</b> no se encuentra en ning\u00fan archivo de mod. Verifica que el mod <b>" + modId + "</b> est\u00e9 correctamente instalado. Usa la funci\u00f3n <b>Arbol de Mods</b> para ayudar a identificar el problema";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "Actualiza el mod <b>" + modId + "</b> a la \u00faltima versi\u00f3n compatible con tu versi\u00f3n de Minecraft y Forge. Si el problema persiste, contacta al desarrollador del mod reportando el error con la clase problem\u00e1tica";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "Revisa <b>otros errores en el log</b> antes de este mensaje, ya que el problema real podr\u00eda estar en otra parte del registro. A veces un error previo impide que se carguen correctamente las clases necesarias para el registro de suscriptores";
    }

    @Override
    public String limpiado() {
        return "Limpiado";
    }

    @Override
    public String original() {
        return "Original";
    }

    @Override
    public String verEnConsola() {
        return "Ver en Consola";
    }

    @Override
    public String advertencia() {
        return "Advertencia";
    }

    @Override
    public String fatal() {
        return "Fatal";
    }

    @Override
    public String noRegistroDeBattly() {
        return "BattlyLauncher no tiene un registro ni una consola para copiando. Puedes usar ProxySysOutSysErr para interceptar STDOUT y STDERR y reiniciar el juego pero ProxySysOutSysErr puede conflictar con mods modificando STDOUT o STDERR";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "Necesitas hablicar modo de depuraci\u00f3n en la configuracion de NightWorld para obtener un registro de lanzer. Es muy importante especialemente por que tiene STDOUT y STDERR";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "Necesitas guardar o pegar el contenido de la Terminal de tu servidor porque tiene informacion no en otro registros incluyendo STDOUT, STDERR, y otras errores. Por favor pegar el contenido de la ultima sesion. Para la future, puedes guardar el contenido de la terminal al archivo cd_launcherlog Para evitar tener que pegarlo, a\u00f1ade >> cd_launcherlog despu\u00e9s del comando, como se muestra en la imagen. Ten en cuenta que esto impedir\u00e1 que se muestre en la terminal; solo aparecer\u00e1 en ese archivo una vez hecho esto.";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("Error cr\u00edtico: transformador de LexForge detectado en un entorno NeoForge. ");
        sb.append("</b>");
        sb.append("Clase implicada: <b>").append(claseReceptora).append("</b>. ");
        sb.append("La interfaz afectada es <b>").append(interfazObjetivo).append("</b> ");
        sb.append("y falta el m\u00e9todo <b>").append(firmaMetodoFaltante).append("</b>. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("La clase se encontr\u00f3 en: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", y otros...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("No se localizaron JARs que contengan esa clase; podr\u00eda estar sombreada o incluida como jar-in-jar. ");
        }
        sb.append("Este fallo aparece cuando un transformador/servicio de ModLauncher compilado para MinecraftForge/LexForge ");
        sb.append("se carga bajo NeoForge con una versi\u00f3n incompatible de la API de ModLauncher. ");
        sb.append("Actualiza o reemplaza el componente para NeoForge.");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "Transformador de LexForge usado en NeoForge";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "Identifica el transformador incompatible: <b>" + claseReceptora + "</b>. La API esperada es <b>" + interfazObjetivo + "</b> y falta <b>" + firmaMetodoFaltante + "</b>. Revisa si el mod registra esta clase en <b>META-INF/services</b> y elim\u00ednala o desact\u00edvala en NeoForge.";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Ubicaci\u00f3n del/los mod(s) implicados: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", y otros...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("No se encontraron JARs que contengan la clase. Comprueba jar-in-jar y dependencias sombreadas. ");
        }
        sb.append("Retira temporalmente esos JARs o usa versiones compatibles con NeoForge para confirmar el origen.");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "Sustituye el componente por una versi\u00f3n espec\u00edfica de NeoForge o recomp\u00edlalo contra la versi\u00f3n de ModLauncher usada por NeoForge. Evita binarios antiguos de LexForge/MinecraftForge.";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "Limpia la carpeta de mods y elimina duplicados jar-in-jar. Vac\u00eda cach\u00e9s del lanzador si es necesario y vuelve a iniciar para verificar que no se cargan transformadores de LexForge.";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia no puede iniciar: Xenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("es incompatible.</b> ");
        sb.append("Retira Xenon y usa Embeddium o Sodium. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Detectado en: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", y otros...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia incompatible con Xenon";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return "Se detect\u00f3 " + label + " incompatible con WaterMedia. Qu\u00edtalo del perfil.";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("Ubicaciones: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", y otros...");
            }
            sb.append("</b>. Elimina ese JAR.");
            return sb.toString();
        }
        return "No se localizaron JARs. Revisa la carpeta mods y elimina Xenon.";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "Instala Embeddium o Sodium como sustituto y reinicia el juego.";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "Error al comprimir (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>Deflater cerrado durante copia de recursos de TACZ.</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Relacionado con: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", y otros");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>Soluci\u00f3n:</b> en <code>tacz/tacz-pre.toml</code> pon <code>DefaultPackDebug=true</code>. ").append("Si hace falta, genera un mapa primero y luego act\u00edvalo.");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "En tacz/tacz-pre.toml pon DefaultPackDebug=true. Si hace falta, genera un mapa primero y luego act\u00edvalo.";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "Funciones de densidad no vinculadas";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>Faltan funciones de densidad en el registro.</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("Faltan: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append(". ");
        }
        sb.append("<br/><b>Soluci\u00f3n:</b> instala o activa el mod/datapack que define esas funciones y reinicia. Otra raz\u00f3n com\u00fan para este problema es cuando tienes el mod necesario, pero tiene un problema o conflicto con otro mod; por ejemplo, Terralith tiene muchos problemas y puede provocar este error y otros, incluyendo errores con JSON.");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "Instala o activa el mod/datapack que aporta esas funciones y reinicia el juego.";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Entrada de registro no presente: ").append(claveFaltante).append(". ");
        sb.append("Frecuente con la alfa de Steam & Railways para Create 6.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (alpha)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "Quita o reemplaza la alfa de Steam & Railways para Create 6 por una versi\u00f3n compatible.";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Conflicto de carga: Multiworld junto con Sodium/Embeddium/Rubidium provoca ").append("IncompatibleClassChangeError (FabricLoader.getInstance). ").append("Sugerencia: quita Multiworld o el mod de rendimiento, o usa versiones compatibles.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "Conflicto: Multiworld con mods de rendimiento";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "Desinstala Multiworld o Sodium/Embeddium/Rubidium, o actualiza a versiones compatibles entre s\u00ed.";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium detect\u00f3 un controlador gr\u00e1fico incompatible. Actualiza el driver de tu GPU al m\u00ednimo requerido o sigue la gu\u00eda de Sodium.</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "Error de contexto OpenGL";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenGL fall\u00f3: no hay contexto actual o la funci\u00f3n no est\u00e1 disponible en este contexto. Tambi\u00e9n puede ser un problema de controladores de v\u00eddeo.</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "Actualiza/reinstala los controladores de la GPU y reinicia; desactiva superposiciones y prueba sin mods de rendimiento.";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "Enlace copiado al portapapeles.";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "Buscar dentro de comprimidos (.zip/.jar/.war/.ear/.fpm/.rar de Java*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error de resoluci\u00f3n de texturas: No se puede ajustar " + recurso + " - tama\u00f1o: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "Error de Resoluci\u00f3n de Texturas";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "Este error ocurre cuando las texturas son demasiado grandes o hay demasiados paquetes de recursos. Intenta usar paquetes de recursos de menor resoluci\u00f3n o elimina algunos paquetes de recursos. Verifica que no hayas agregado texturas personalizadas con resoluci\u00f3n mayor a la permitida.";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error de servicios de ModLauncher: Ruta con caracteres no v\u00e1lidos. Los servicios de ModLauncher no pueden procesar rutas que contienen caracteres no ASCII o caracteres especiales. Caracteres problem\u00e1ticos incluyen: \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694, y especialmente el car\u00e1cter '\"' cuando est\u00e1 al final del nombre. Componentes de servicios comunes en ModLauncher incluyen CrashDetector, " + Config.obtenerInstancia().obtenerNombreCD() + ", FeatureCreep, Vivicraft, Optifine, Sodium, clonos, Iris Shaders/Oculus, MixerLogger, CrashAssistant y Sintrya Connector. Puedes eliminar todos los servicios, pero otros problemas pueden surgir debido al nombre de la ruta. Soluci\u00f3n: Renombra la instancia para usar solo caracteres ASCII (a-z, A-Z, 0-9), sin espacios ni caracteres especiales.</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "Error de Ruta en ModLauncher";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "Este error ocurre cuando la ruta de la instancia contiene caracteres no ASCII o caracteres especiales. Los servicios de ModLauncher no pueden manejar estas rutas. Soluci\u00f3n: Renombra la instancia para usar solo caracteres ASCII (a-z, A-Z, 0-9) y evita espacios y caracteres especiales. Presta especial atenci\u00f3n al car\u00e1cter '\"' que es muy problem\u00e1tico, especialmente cuando est\u00e1 al final del nombre.";
    }

    @Override
    public String tituloEditorCodice() {
        return "Editor de Codice";
    }

    @Override
    public String nuevo() {
        return "Nuevo";
    }

    @Override
    public String actualizarSeleccionado() {
        return "Actualizar seleccionado";
    }

    @Override
    public String eliminarSeleccionado() {
        return "Eliminar seleccionado";
    }

    @Override
    public String exportarJSON() {
        return "Exportar JSON...";
    }

    @Override
    public String guardarTodo() {
        return "Guardar todo";
    }

    @Override
    public String general() {
        return "General";
    }

    @Override
    public String id() {
        return "ID";
    }

    @Override
    public String paraBuscar() {
        return "Texto a buscar";
    }

    @Override
    public String filtro() {
        return "Filtro (id)";
    }

    @Override
    public String criticalidad() {
        return "Criticalidad (ADVERTENCIA/ERROR/FATAL)";
    }

    @Override
    public String prioridad() {
        return "Prioridad";
    }

    @Override
    public String lista() {
        return "Verificaciones";
    }

    @Override
    public String colIdioma() {
        return "Idioma";
    }

    @Override
    public String colNombre() {
        return "Nombre";
    }

    @Override
    public String colResultado() {
        return "Resultado";
    }

    @Override
    public String vistaJson() {
        return "Vista previa JSON";
    }

    @Override
    public String idiomas() {
        return "Idiomas (todos obligatorios)";
    }

    @Override
    public String elegirFiltro() {
        return "Elegir...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "Seleccione un filtro";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "Filtros disponibles";
    }

    @Override
    public String faltanCampos() {
        return "Complete todos los campos generales obligatorios.";
    }

    @Override
    public String critInvalida() {
        return "Criticalidad inv\u00e1lida. Use ADVERTENCIA, ERROR o FATAL.";
    }

    @Override
    public String filtroNoExiste() {
        return "El filtro indicado no existe.";
    }

    @Override
    public String faltanIdiomas() {
        return "Complete nombre y resultado para todos los idiomas:";
    }

    @Override
    public String verificacionInvalida() {
        return "Una verificaci\u00f3n es inv\u00e1lida. Revise los campos.";
    }

    @Override
    public String guardadoOk() {
        return "Guardado correcto.";
    }

    @Override
    public String editorCodiceBoton() {
        return "Agregar razones";
    }

    @Override
    public String descripcionEditorCodice() {
        return "Puedes registrar razones aqui. Neceistas una ID, una string sin caractares speciales o marcos accentos o espacios. Para filtros puedes usar son \"linea containe\" para buscar para un string en una linea, \"todo containe\" si el registro tiene un string, \"regex linea\" si una linea tiene regex, y \"regex todos\" sugeste usar las versiones de linea. Necesitas poder la criticalidad, FATAL, ERROR, o ADVERTENCIA para los colores. Para todas las idiomas necesitas escribir un nombre y respunta para la pantalla.Puedes agregar mas verificaciones o eliminar otras. Guardas cunado completa.";
    }

    @Override
    public String descartarCambios() {
        return "\u00bfDescartar los cambios no guardados en la verificaci\u00f3n actual?";
    }

    @Override
    public String confirmacion() {
        return "Confirmaci\u00f3n";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\u00bfDesea guardar los cambios antes de salir?";
    }

    @Override
    public String salirSinGuardar() {
        return "Salir sin guardar";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Error critico: Falla al cargar un servicio de modlauncher (IDependencyLocator).<br>");
        sb.append("\ud83d\udd39 <b>Clase problematica:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>Mod afectado:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>Mod no identificado.</b> Revisa mods recientes, de desarrollo o mal empaquetados.<br>");
        }
        sb.append("\ud83d\udd38 <b>Causa:</b> El archivo <code>META-INF/services/...</code> del mod esta corrupto, ");
        sb.append("es incompatible con esta version de Forge/NeoForge, o el mod es para una version incorrecta.<br>");
        sb.append("\ud83d\udd38 <b>Consecuencia:</b> Forge/NeoForge no puede registrar dependencias del mod, ");
        sb.append("lo que impide el inicio del juego.<br>");
        sb.append("\ud83d\udd38 <b>Solucion:</b> Actualiza, reinstala o elimina el mod problem\u00e1tico. ");
        sb.append("Si usas mods de desarrollo, asegurate de que esten compilados para tu version exacta de Forge/NeoForge.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "Error de Configuracion de Servicio (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. Identifica el mod causante: revisa mods instalados recientemente o de desarrollo.";
        }
        return "1. El mod problem\u00e1tico es: " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. Actualiza, reinstala o elimina el mod. Asegurate de usar una version compatible con tu Forge/NeoForge.";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>Error critico: Campo inexistente.</b><br>El mod intento acceder al campo <b style='color:#" + colorCodigo + "'>" + campo + "</b>, que no existe en esta version del juego o de otro mod.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "Campo Inexistente (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. Este error suele ocurrir cuando un mod es incompatible con la version actual del juego o de otro mod.";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. Actualiza todos los mods afectados. Si el problema persiste, contacta al autor del mod que genero el error.";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>Error critico: Metodo inexistente.</b><br>El mod intento llamar al metodo <b style='color:#" + colorCodigo + "'>" + metodo + "</b>, que no existe en esta version del juego o de otro mod.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "Metodo Inexistente (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. Este error ocurre cuando un mod es incompatible con la version actual del juego o de otro mod.";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. Actualiza todos los mods involucrados. Si persiste, reporta el error al autor del mod afectado.";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\u00bfNecesitas ayuda?</strong><br>  Si no sabes c\u00f3mo arreglarlo o la raz\u00f3n no est\u00e1 aqu\u00ed, puedes recibir ayuda en nuestras redes sociales.   Usa el bot\u00f3n <img src='" + iconoCompartir + "' alt='Compartir' style='height:12px;vertical-align:middle;'/>   <strong>Compartir</strong> para obtener enlaces a los registros y a los resultados para nuestro equipo.   Si eres un creador de modpack o una corporaci\u00f3n, edita <code>crash_detector/plantilla.htm</code>   para personalizar los enlaces de tu equipo.</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "Restablecer Plantilla";
    }

    @Override
    public String restablecer() {
        return "Restablecer";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return "\u00bfRestablecer " + nombreImagen + " a valores predeterminados?";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\u00bfRestablecer plantilla a valores predeterminados?";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Faltan clases de AzureLib. Si ya tienes AzureLib, por favor instala una versi\u00f3n anterior al 8 de octubre de 2025. Era com\u00fan. Si no tienes AzureLib, instala la versi\u00f3n actual.</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>El mod <code>healight</code> est\u00e1 causando un error cr\u00edtico: <code>java.lang.NoSuchFieldError: INT</code>. Este error ocurre porque el mod intenta acceder a un campo que ya no existe en la version de MCForge 47.10 Minecraft 1.20+. El juego no puede iniciar debido a este problema.</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 Elimina o actualiza el mod <code>healight</code>. La versi\u00f3n actual no es compatible con MinecraftForge 47.10 para 1.20.1. Busca una versi\u00f3n m\u00e1s reciente del mod o considera usar una alternativa.";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "Error cr\u00edtico: healight - Campo 'INT' no encontrado";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("La clase <code>").append(clase).append("</code> no implementa el m\u00e9todo requerido:<br>").append("<code>").append(metodo).append("</code><br>").append("de la interfaz <code>").append(interfaz).append("</code>.");
        if (!origen.isEmpty()) {
            sb.append("<br><br>Mod o archivo sospechoso: <code>").append(origen).append("</code>.");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 Este error ocurre cuando un mod implementa una interfaz pero omite un m\u00e9todo obligatorio. Actualiza <b>ambos mods</b> involucrados (el que define la interfaz y el que la implementa). Si no sabes cu\u00e1les son, busca los nombres que aparecen en el mensaje de error.";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "M\u00e9todo de interfaz no implementado (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Un mod est\u00e1 intentando cargar una clase del <b>lado del cliente</b> (<code>AnimationMetadataSection</code>) en un <b>servidor dedicado</b>, lo que es imposible. Este error suele aparecer cuando un mod no separa correctamente su c\u00f3digo entre cliente y servidor. La presencia de <code>ModernFix</code> puede exponer este problema, aunque no es la causa directa.</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>Opci\u00f3n r\u00e1pida:</b> Elimina temporalmente <code>ModernFix</code> para confirmar si el servidor inicia. Si funciona, el problema est\u00e1 en otro mod que carga clases del cliente en el servidor.<br>\u2022 <b>Soluci\u00f3n permanente:</b> Identifica el mod culpable (busca mods con recursos animados, texturas personalizadas o librer\u00edas gr\u00e1ficas) y actual\u00edzalo o elim\u00ednalo.<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "Clase de cliente cargada en servidor (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>El archivo de configuraci\u00f3n de un mod de <code>Sinytra Connector</code> est\u00e1 corrupto. Esto suele ocurrir cuando el archivo se llena de caracteres nulos (<code>\\u0000</code>) debido a un cierre inesperado del juego, fallos de escritura o conflictos de mods.</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 Navega a la carpeta <code>config/</code> de tu instancia de Minecraft.<br>\u2022 Busca y elimina las configs de mods de connector.<br>\u2022 Reinicia el juego: Sinytra Connector generar\u00e1 un nuevo archivo de configuraci\u00f3n limpio.";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "Configuraci\u00f3n de Sinytra Connector corrupta";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>El archivo <code>" + nombreJar + "</code> est\u00e1 corrupto o incompleto.<br>El sistema no puede leer su contenido porque falta el encabezado final del archivo ZIP.<br>Este error suele ocurrir tras una descarga interrumpida o un fallo del lanzador.</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "Archivo JAR corrupto (con nombre espec\u00edfico)";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>Elimina el archivo corrupto</b> y vuelve a descargarlo desde la fuente oficial (CurseForge, MinecraftStorage, etc.).<br>\u2022 Si usas un lanzador como CurseForge, Technic o Luna Pixel, considera cambiar a <b>ATLauncher</b> o <b>Prism Launcher</b>, que verifican mejor la integridad de los archivos.<br>\u2022 Aseg\u00farate de que tu conexi\u00f3n a internet sea estable durante la descarga.";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>No se puede cargar el mundo porque uno de sus archivos NBT est\u00e1 corrupto (por ejemplo: <code>level.dat</code>, <code>playerdata/*.dat</code>, o chunks).<br>El error espec\u00edfico es: <code>UTFDataFormatException: malformed input around byte " + byteCorrupto + "</code>.<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f Antes de intentar cualquier reparaci\u00f3n, haz una copia de seguridad completa de la carpeta del mundo.</b><br><br>Puedes intentar reparar el archivo corrupto usando un <b>editor NBT</b> como <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>.<br>Si el da\u00f1o es grave, usa un <b>editor hexadecimal</b> (como HxD) para inspeccionar y corregir bytes inv\u00e1lidos (solo si tienes experiencia con el formato NBT).<br>Como \u00faltimo recurso, restaura desde una copia de seguridad o usa el <i>world repair</i> de mods como <code>FTB Backup</code>.</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>Haz una copia de seguridad completa de la carpeta del mundo</b> antes de intentar cualquier reparaci\u00f3n.<br>\u2022 Usa un editor NBT (como NBT Studio) para abrir y corregir el archivo da\u00f1ado.<br>\u2022 Si falla, inspecciona el archivo con un editor hexadecimal en la posici\u00f3n del byte corrupto.<br>\u2022 Si no tienes experiencia, restaura desde una copia de seguridad reciente.";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "Mundo corrupto: error al cargar datos NBT";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Tienes un problema con OpenAL. A veces los controladores Nouveau pueden causarlo, pero a veces la versi\u00f3n de OpenAL incluida en la aplicaci\u00f3n no es compatible con la versi\u00f3n en tu distribuci\u00f3n y necesitas usar la versi\u00f3n proporcionada por tu distro, es especialmente com\u00fan con distribuciones Red Hat y con mods de sonido como Sound Physics Remastered. Consulta esta gu\u00eda para m\u00e1s ayuda: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>Soluci\u00f3n a problemas de sonido en Minecraft en Linux</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>El servidor no puede iniciar porque un archivo del mundo est\u00e1 bloqueado por otro proceso.<br>Esto suele ocurrir si:<br>\u2022 Ya hay una instancia del servidor en ejecuci\u00f3n.<br>\u2022 Un antivirus o explorador de archivos tiene abierta la carpeta del mundo.<br>\u2022 El proceso anterior no se cerr\u00f3 correctamente y dej\u00f3 archivos bloqueados.</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>Cierra todas las instancias del servidor</b> (incluyendo procesos en segundo plano como javaw.exe).<br>\u2022 Si usas un panel de hosting (como Multicraft), reinicia completamente el servidor desde el panel.<br>\u2022 <b>Desactiva temporalmente tu antivirus</b> si sospechas que est\u00e1 bloqueando los archivos.<br>\u2022 En sistemas locales, cierra cualquier ventana del Explorador de Windows que muestre la carpeta del mundo.<br>\u2022 Si el problema persiste, elimina manualmente el archivo <code>session.lock</code> dentro de la carpeta del mundo (solo si est\u00e1s seguro de que no hay otro servidor activo).";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "Archivo del mundo bloqueado por otro proceso";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>El mod intent\u00f3 extender la clase <code>" + clasePadreFinal + "</code>, pero esta clase ahora es <b>final</b> y no puede heredarse.<br>La clase problem\u00e1tica es: <code>" + claseHija + "</code>.<br><br>Esto suele ocurrir cuando un mod est\u00e1 compilado para una versi\u00f3n anterior de Minecraft o de otro mod base, que ha marcado clases como <code>final</code> en versiones recientes.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>Actualiza todos los mods involucrados</b>, especialmente aquellos que podr\u00edan estar relacionados con el mod base mencionado.<br>\u2022 Si el problema persiste, busca una versi\u00f3n del mod compatible con tu versi\u00f3n actual de Minecraft y sus dependencias.<br>\u2022 En algunos casos, eliminar temporalmente el mod que contiene la clase hija puede ayudar a confirmar la causa.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "Intento de heredar de una clase final";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Est\u00e1s usando <b>Rubidium</b> (un fork obsoleto de Sodium para Forge) junto con <b>Iris u Oculus</b>.<br>En versiones recientes de Minecraft (1.19.2+), Rubidium no ha seguido el ritmo de Sodium y sus dependencias han tenido problemas.<br><br>Este error tambi\u00e9n puede ocurrir si hay un conflicto entre mods de rendimiento (Sodium, Rubidium, Embeddium, Bedium, Xeonium, etc.) o Iris Shaders y otro mod.</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <b>Elimina Rubidium</b> de tu carpeta <code>mods</code>.<br>\u2022 <b>Instala <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a></b>, el fork activo y compatible de Sodium para Forge que s\u00ed soporta Iris/Oculus en 1.20+.<br>\u2022 Aseg\u00farate de no tener m\u00e1s de un fork de Sodium instalado al mismo tiempo (por ejemplo: Rubidium + Embeddium).<br>\u2022 Si usas Oculus en lugar de Iris, verifica que tambi\u00e9n sea compatible con tu versi\u00f3n de Forge y Embeddium.";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "Rubidium obsoleto con Iris/Oculus (OptionInstance es final)";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>El mod <code>Simple Voice Chat</code> no puede iniciar su servidor de voz porque el puerto UDP ya est\u00e1 en uso o la direcci\u00f3n IP configurada no es v\u00e1lida.<br>Esto no impide que el juego se inicie, pero desactiva la funcionalidad de chat de voz.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>Cierra cualquier otra instancia de Minecraft</b> o aplicaci\u00f3n que use el puerto UDP 24454.<br>\u2022 Si est\u00e1s en un servidor, aseg\u00farate de que <b>ning\u00fan otro servicio</b> est\u00e9 usando ese puerto.<br>\u2022 En la configuraci\u00f3n del mod (<code>config/voicechat/</code>), cambia el puerto UDP a uno libre (por ejemplo, 24455).<br>\u2022 Si usas una direcci\u00f3n IP personalizada, verifica que sea correcta o d\u00e9jala en blanco para usar la predeterminada.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "Voice Chat: puerto UDP ocupado o IP inv\u00e1lida";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>El BlockItem <code>" + nombreBlockItem + "</code> tiene un bloque nulo.<br>Este error suele ocurrir en <b>addons de Create</b> (como <code>dndecor</code>, <code>createdeco</code>) cuando hay conflictos con <code>Amendments</code>, <code>Moonshine</code>, o una inicializaci\u00f3n incorrecta de bloques.<br><b>Nota:</b> Este no es un error de Amendments directamente, sino un s\u00edntoma de un problema m\u00e1s profundo en la carga de registros.</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>Actualiza todos los mods relacionados:</b> Create, Amendments, Moonshine, y cualquier addon (especialmente <code>dndecor</code> y <code>createdeco</code>).<br>\u2022 Si el problema persiste, <b>elimina temporalmente los addons de Create</b> uno por uno para identificar al culpable.<br>\u2022 Aseg\u00farate de que <b>Amendments y Moonshine sean compatibles</b> con tu versi\u00f3n de Create y Forge.<br>\u2022 Revisa si hay versiones beta o forks actualizados de los addons problem\u00e1ticos.";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "BlockItem nulo en addon de Create";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("Se encontraron mods que no pertenecen a ninguna plataforma activa (Forge, Fabric, etc.):<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>Esto suele ocurrir cuando:<br>").append("\u2022 Se mezclan mods de <b>Fabric y Forge</b> en la misma carpeta.<br>").append("\u2022 Se instala un mod para una versi\u00f3n incompatible de Minecraft.<br>").append("\u2022 El mod est\u00e1 corrupto o no es un archivo JAR v\u00e1lido.</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>Verifica que todos los mods sean para la misma plataforma</b> (Forge <b>o</b> Fabric, no ambos).<br>\u2022 Usa el <b>\u00e1rbol de mods</b> para identificar qu\u00e9 plataforma detecta cada archivo.<br>\u2022 Elimina cualquier mod que no reconozcas o que sea de una plataforma diferente.<br>\u2022 Si usas un lanzador como CurseForge o Prism, aseg\u00farate de que el perfil est\u00e9 configurado correctamente.";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "Mod incompatible con cargador activo";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>No se pudo crear el modelo <code>" + modid + ":" + nombreModelo + "</code>.<br>Esto indica que el mod <code>" + modid + "</code> tiene recursos corruptos, faltantes o incompatibles con tu versi\u00f3n de Minecraft.</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>Actualiza el mod</b> a la \u00faltima versi\u00f3n compatible con tu instancia.<br>\u2022 Si usas una versi\u00f3n de desarrollo o personalizada, vuelve a la versi\u00f3n oficial.<br>\u2022 Verifica que el archivo JAR no est\u00e9 corrupto (reinst\u00e1lalo).<br>\u2022 Si el problema persiste, reporta el error al autor del mod incluyendo este log.";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "Fallo al crear modelo de recurso";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Se ha detectado un conflicto cr\u00edtico entre los mods <code>Moonlight</code> e <code>Iceberg</code>.<br>Ambos intentan registrar sistemas de recarga de recursos de forma incompatible, lo que provoca un fallo de OpenGL al no haber un contexto gr\u00e1fico v\u00e1lido.<br>Este problema es com\u00fan cuando se usan versiones de Forge que incluyen adaptadores de mods de Fabric.</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>Actualiza ambos mods</b> a sus \u00faltimas versiones compatibles con tu versi\u00f3n de Forge.<br>\u2022 Si el problema persiste, <b>elimina temporalmente Iceberg</b>, ya que Moonlight suele ser una dependencia m\u00e1s cr\u00edtica para otros mods.<br>\u2022 Aseg\u00farate de no tener versiones duplicadas o mezcladas de Forge/Fabric de estos mods.<br>\u2022 Revisa si alg\u00fan otro mod (como Supplementaries, Citadel, etc.) ya incluye funcionalidad de Iceberg internamente.";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "Conflicto cr\u00edtico: Moonlight vs Iceberg (OpenGL sin contexto)";
    }

    @Override
    public String instantanea() {
        return "Instant\u00e1nea";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "Desde \u00daltima Instant\u00e1nea";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "Seleccionar un archivo";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "Instant\u00e1nea creada correctamente";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "Error al crear la instant\u00e1nea";
    }

    @Override
    public String consejo() {
        return "Consejo";
    }

    @Override
    public String resultadoMuestra() {
        return "Resultado Muestra";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>Consejo:</b> Selecciona dos archivos de historial para comparar la lista de mods.   El resultado muestra <span style='color:%s;'>a\u00f1adidos (+)</span> y   <span style='color:%s;'>eliminados (&#8722;)</span> basados en nombres normalizados.   Usa el bot\u00f3n 'Instant\u00e1nea' para crear una copia de un archivo existente con extensi\u00f3n .instantanea.</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "Obtener Enlaces a Registros Como Markdown sin Informe";
    }

    @Override
    public String titulo_configuracion() {
        return "Configuraci\u00f3n";
    }

    @Override
    public String columna_url() {
        return "URL";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "Error inesperado al compartir.";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "Error inesperado al generar enlaces.";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "Error inesperado al procesar el bot\u00f3n.";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "No hay archivo asociado para abrir.";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "El archivo no existe:\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "No se pudo abrir en un editor.\nSe copiar\u00e1 la ruta al portapapeles.";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "No se pudo abrir el archivo; la ruta se copi\u00f3 al portapapeles.";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "El escritorio no est\u00e1 soportado; se copi\u00f3 la ruta al portapapeles.";
    }

    @Override
    public String limite_de_solicitudes() {
        return "Est\u00e1s experimentando un l\u00edmite de solicitudes. Intenta usar otro sitio de registro o otra API de registro.";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "Compartir Enlace";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Arreglar las partes superiores de los troncos es la primera prioridad. El formato es Nivel, L\u00ednea. Todos los registros tienen un sistema de numeraci\u00f3n. " + "<br>" + "Generalmente necesitas buscar en los niveles m\u00e1s bajos en todos los registros; trazos con niveles altos generalmente son falsos positivos. Es importante usar tu habilidad para ver en la consola, ya que el an\u00e1lisis de trazos no es perfecto cuando hay muchos trazos.</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "Buscador de canario de orden";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "Esta funci\u00f3n estar\u00e1 disponible pr\u00f3ximamente.";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "Pr\u00f3ximamente";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "Mods Incompatibles Con Crash Assistant (Falso)";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "Mod Incompatible Con Paquete de Mods (Modpack) usando CrashAssistant";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant tiene una lista de mods que dice son incompatibles, pero no tenemos evidencia de que lo sean y el error solo est\u00e1 en ingl\u00e9s. Si deseas jugar con estos mods, puedes editar el archivo <code>config/crash_assistant/config.toml</code> y cambiar <code>enabled = true</code> en la secci\u00f3n [compatibility] a <code>enabled = false</code>.</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant tiene la capacidad de marcar mods como incompatibles, pero a veces esto es incorrecto y el mensaje de error solo est\u00e1 disponible en ingl\u00e9s. Si deseas jugar con estos mods, puedes editar el archivo <code>config/crash_assistant/problematic_mods_config.json</code> y cambiar <code>should_crash_on_startup</code> de <code>true</code> a <code>false</code>.</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Error: El mod '" + modId + "' requiere el mod '" + dependencia + "'. Actualmente, " + actual + ".</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Error: El mod '" + modId + "' requiere la versi\u00f3n '" + requerido + "' o superior de '" + dependencia + "', pero el mod no est\u00e1 instalado.</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Error: El mod '" + modId + "' es incompatible con la versi\u00f3n actual de '" + dependencia + "'. Debes eliminar el mod 'Iris/Oculus & GeckoLib Compat' ya que es incompatible con Superb Warfare y no funciona con la \u00faltima versi\u00f3n de GeckoLib. Versi\u00f3n actual: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "Error: No se pudo ejecutar la tarea para la clase '" + clase + "'. Este error es com\u00fan con mods que no son compatibles entre s\u00ed o que tienen conflictos con otros mods instalados.";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "Fallos en la ejecuci\u00f3n de tareas";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "Este tipo de error suele ocurrir cuando hay incompatibilidades entre mods. Especialmente com\u00fan con mods que no funcionan correctamente con ConnectorMod.";
    }

    @Override
    public String info_clase_problematica() {
        return "Clase problem\u00e1tica:";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "No se encontraron clases espec\u00edficas con problemas de ejecuci\u00f3n.";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto cr\u00edtico entre OptiFine y Entity Model Features (EMF). Estos mods no son compatibles y provocan un fallo de inyecci\u00f3n que impide el inicio del juego.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "Conflicto OptiFine y Entity Model Features";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "Desinstala OptiFine o Entity Model Features, ya que no son compatibles entre s\u00ed.";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto cr\u00edtico entre OptiFine y Fusion. Estos mods no son compatibles y provocan un fallo de inyecci\u00f3n que impide el inicio del juego.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "Conflicto OptiFine y Fusion";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "Desinstala OptiFine o Fusion, ya que no son compatibles entre s\u00ed.";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Flywheel (requerido por Create) necesita Sodium 0.6.0-beta.2 o superior. Rubidium es 0.5.3. Considera usar <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> como alternativa.</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "Conflicto Flywheel y versi\u00f3n de Sodium";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "Actualiza Sodium a 0.6.0-beta.2 o superior, o instala <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> como alternativa compatible.";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto cr\u00edtico entre OptiFine y Epic Fight. Estos mods no son compatibles y provocan un fallo de inyecci\u00f3n que impide el inicio del juego.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "Conflicto OptiFine y Epic Fight";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "Desinstala OptiFine o Epic Fight, ya que no son compatibles entre s\u00ed.";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto cr\u00edtico entre OptiFine y Rubidium. Estos mods no son compatibles y provocan un fallo de inyecci\u00f3n que impide el inicio del juego.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "Conflicto OptiFine y Rubidium";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "Desinstala OptiFine o Rubidium, ya que no son compatibles entre s\u00ed.";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam est\u00e1 intentando cargar en un servidor dedicado, pero solo es compatible con el cliente. Elimina FreeCam del servidor o aseg\u00farate de que solo est\u00e9 instalado en el cliente.</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "FreeCam en servidor dedicado";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "Elimina FreeCam del servidor dedicado, ya que solo debe estar instalado en el cliente.";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) est\u00e1 intentando cargar en un servidor dedicado, pero solo es compatible con el cliente. Elimina ETF del servidor o aseg\u00farate de que solo est\u00e9 instalado en el cliente.</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features en servidor dedicado";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "Elimina Entity Texture Features del servidor dedicado, ya que solo debe estar instalado en el cliente.";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Debes aceptar el EULA de Minecraft para ejecutar el servidor. Edita el archivo eula.txt y cambia 'eula=false' a 'eula=true'.</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "EULA de Minecraft no aceptado";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "Edita el archivo eula.txt en la carpeta del servidor y cambia 'eula=false' a 'eula=true'.";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine est\u00e1 intentando cargar en un servidor dedicado, pero solo es compatible con el cliente. Elimina OptiFine del servidor o aseg\u00farate de que solo est\u00e9 instalado en el cliente.</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "OptiFine en servidor dedicado";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "Elimina OptiFine del servidor dedicado, ya que solo debe estar instalado en el cliente.";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks est\u00e1 marcado incorrectamente para 1.20.1 pero usa m\u00e9todos de 1.21.1. El mod est\u00e1 intentando usar ResourceLocation.fromNamespaceAndPath, que no existe en 1.20.1.</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "Error de versi\u00f3n en Iron's Spellbooks";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "Aseg\u00farate de usar la versi\u00f3n correcta de Iron's Spellbooks compatible con tu versi\u00f3n de Minecraft.";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto cr\u00edtico entre OptiFine y Embeddium. Estos mods no son compatibles y provocan un fallo de inyecci\u00f3n que impide el inicio del juego.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "Conflicto OptiFine y Embeddium";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "Desinstala OptiFine o Embeddium, ya que no son compatibles entre s\u00ed.";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Es com\u00fan con mods de generaci\u00f3n del mundo conflictivos, especialmente Terralinth, AmplifiedNether, Nullscape e Incendium, y otros mods de generaci\u00f3n de mundo. Tambi\u00e9n es posible que necesites instalar un mod faltante.</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable est\u00e1 intentando cargar en un servidor dedicado, pero solo es compatible con el cliente. Elimina Controllable del servidor o aseg\u00farate de que solo est\u00e9 instalado en el cliente.</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "Controllable en servidor dedicado";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "Elimina Controllable del servidor dedicado, ya que solo debe estar instalado en el cliente.";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries est\u00e1 causando un error que impide la carga del servidor. El mod tiene problemas con el registro de comportamientos de fuego que provocan un fallo durante la carga de datapacks.</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries impide la carga del servidor";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "Intenta actualizar Supplementaries a la \u00faltima versi\u00f3n o desact\u00edvalo temporalmente para permitir la carga del servidor.";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader (GML) encontr\u00f3 un problema con m\u00f3dulos Jackson faltantes. Algunos mods como Valkyrien Skies pueden causar este error al no incluir todas las dependencias necesarias.</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "M\u00f3dulo Jackson faltante en Groovy Modloader";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "Elimina Groovy Modloader y mods relacionados como Valkyrien Skies que puedan causar conflictos de dependencias.";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat encontr\u00f3 un nombre de bloque de madera inv\u00e1lido. Every Compat generalmente tiene muchos problemas. \u00a1No lo uses!</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "Nombre inv\u00e1lido en Every Compat";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "Verifica los packs de recursos o mods que usan Every Compat, ya que pueden tener nombres de bloques inv\u00e1lidos.";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un c\u00f3digo de error (-1073741819) que puede ser causado por overlays como GameCaster de Razer, Discord, OBS Studio o problemas con drivers de NVIDIA.</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "C\u00f3digo de error -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "Intenta desactivar overlays como GameCaster, Discord o OBS Studio, y verifica que tus drivers de NVIDIA est\u00e9n actualizados.";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips requiere Immersive Messages como dependencia pero no est\u00e1 instalada. Instala Immersive Messages para que Immersive Tooltips funcione correctamente.</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips sin dependencia";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "Instala Immersive Messages, ya que es una dependencia necesaria para Immersive Tooltips.";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins tiene un problema de compatibilidad con Apoli Mod donde ItemStack no puede ser casteado a EntityLinkedItemStack. Esto es com\u00fan en versiones superiores a 6.6.0. Considera usar una versi\u00f3n anterior o cambiar entre versiones de Fabric y Forge.</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "Error de casteo en Medieval Origins";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "Usa una versi\u00f3n de Medieval Origins 6.6.0 o anterior, o intenta cambiar entre versiones de Fabric y Forge del mod.";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether est\u00e1 causando un error con un Registry Object no presente en MusicManager. Este problema est\u00e1 relacionado con el mixin de MusicManager de Reign of Nether.</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "Error de MusicManager en Reign of Nether";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "Intenta actualizar Reign of Nether o eliminarlo temporalmente para resolver el error.";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel solo soporta el servidor YSM en Linux o Android. Este problema ha sido corregido en versiones m\u00e1s recientes desde el 23 de noviembre de 2025 en Modrinth.</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel no compatible con Linux";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "Actualiza YesSteveModel a una versi\u00f3n m\u00e1s reciente desde Modrinth, ya que el problema ha sido corregido despu\u00e9s del 23 de noviembre.";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto cr\u00edtico entre Moving Elevators y OptiFine. Estos mods no son compatibles y provocan un fallo de inyecci\u00f3n que impide el inicio del juego.</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "Conflicto Moving Elevators y OptiFine";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "Desinstala OptiFine o Moving Elevators, ya que no son compatibles entre s\u00ed.";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto cr\u00edtico entre Fabric API (fabric-resource-loader-v0) y OptiFine. Estos mods no son compatibles y provocan un fallo de inyecci\u00f3n que impide el inicio del juego.</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "Conflicto Fabric API y OptiFine";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "Desinstala OptiFine o actualiza Fabric API a una versi\u00f3n compatible.";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Un mod tiene un ITransformationService defectuoso que no puede ser instanciado: " + claseProveedor + ". Este mod debe ser eliminado para permitir la carga del juego.</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "ITransformationService defectuoso";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "Elimina el mod que contiene la clase " + claseProveedor + ", ya que tiene un ITransformationService defectuoso.";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Un mod tiene una especificaci\u00f3n de versi\u00f3n inv\u00e1lida. La versi\u00f3n debe estar rodeada por corchetes cuadrados. Puedes usar la utilidad grep/greprf del panel lateral buscando la versi\u00f3n </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'> para identificar qu\u00e9 mod tiene el problema.</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "Versi\u00f3n inv\u00e1lida en mod";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "Usa la utilidad grep/greprf del panel lateral para buscar la versi\u00f3n problem\u00e1tica y encuentra el mod que la contiene.";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un error de stack smashing que termin\u00f3 el proceso. Esto puede ser causado por problemas con Early Window en Forge/NeoForge/PillowMC o con LWJGL 3.2.2 y m\u00e1s nuevos.</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "Stack Smashing Detectado";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "Verifica los ajustes de Early Window y considera usar una versi\u00f3n diferente de LWJGL o revisar los mods relacionados con la ventana temprana.";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore solo es para un modpack espec\u00edfico y no debe usarse en instalaciones generales, ya que causa un problema.</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore con versi\u00f3n incompatible de Java";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "Elimina GregTechEasyCore, ya que solo es para un modpack espec\u00edfico y no es compatible con tu instalaci\u00f3n general.";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 un conflicto entre MoniLabs y Connector Extras relacionado con modificaciones de KubeJS. Estos mods no son compatibles en sus modificaciones de KubeJS.</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "Conflicto MoniLabs y Connector Extras";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "Intenta desinstalar uno de los mods (MoniLabs o Connector Extras) ya que tienen conflictos con sus modificaciones de KubeJS.";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris requiere Distant Horizons [2.0.4] o DH API versi\u00f3n [1.1.0] o m\u00e1s reciente. Consulta la gu\u00eda de compatibilidad en https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e para resolver el problema.</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "Compatibilidad Iris y Distant Horizons";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "Consulta la gu\u00eda de compatibilidad en https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e y actualiza Iris y Distant Horizons a versiones compatibles.";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de Minecraft. Posibles razones:</b><ul><li>Tienes mods para otras versiones del juego. Puedes usar <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a> para verificar si la clase existe en tu versi\u00f3n.</li><li>Tienes una instalaci\u00f3n defectuosa de Minecraft (com\u00fan con CurseForge App, ModrinthApp/Theseus/Astralrinth y otros lanzadores de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Ver tutorial</a> para solucionar problemas con CurseForge.</li><li>Tienes un coremod defectuoso (si un coremod falla, puede bloquear la carga de la clase).</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de DangerZone. Posibles razones:</b><ul><li>Tienes mods para otras versiones del juego.</li><li>Tienes coremods defectuosos.</li><li>Tienes un lanzador o instalaci\u00f3n defectuosa.</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de FeatureCreep. Posibles razones:</b><ul><li>Tienes mods para otras versiones de FeatureCreep (ej.: ESR vs Nightly o v4 vs v12).</li><li>Puedes instalar FeatureCreep desde CurseForge o MinecraftStorage.</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de ModLauncher. Posibles razones:</b><ul><li>Tus mods son para una build diferente de MinecraftForge, PillowMC o NeoForge (ModLauncher es usado con estos cargadores).</li><li>Hay muchas actualizaciones de modloaders para una versi\u00f3n de Minecraft.</li><li>Tienes una instalaci\u00f3n defectuosa de tu lanzador (com\u00fan con CurseForge App, ModrinthApp/Theseus/Astralrinth y otros lanzadores de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Ver tutorial</a> para solucionar problemas con CurseForge.</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de Minecraft Forge. Posibles razones:</b><ul><li>Tus mods son para una build diferente de MinecraftForge.</li><li>Hay muchas actualizaciones de modloaders para una versi\u00f3n de Minecraft.</li><li>Tienes una instalaci\u00f3n defectuosa (com\u00fan con CurseForge App, ModrinthApp/Theseus/Astralrinth y otros lanzadores de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Ver tutorial</a> para solucionar problemas con CurseForge.</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de NeoForge. Posibles razones:</b><ul><li>Tus mods son para una build diferente de NeoForge.</li><li>Hay muchas actualizaciones de modloaders para una versi\u00f3n de Minecraft.</li><li>Tienes una instalaci\u00f3n defectuosa (com\u00fan con CurseForge App, ModrinthApp/Theseus/Astralrinth y otros lanzadores de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Ver tutorial</a> para solucionar problemas con CurseForge.</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de Fabric Loader. Posibles razones:</b><ul><li>Tus mods son para una build diferente de Fabric Loader.</li><li>Hay muchas actualizaciones de modloaders para una versi\u00f3n de Minecraft.</li><li>Tienes una instalaci\u00f3n defectuosa (com\u00fan con CurseForge App, ModrinthApp/Theseus/Astralrinth y otros lanzadores de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Ver tutorial</a> para solucionar problemas con CurseForge.</li><li>Muchos mods requieren Fabric API. Por favor, instala Fabric API si es necesario.</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Tienes clases faltantes de PillowMC. Posibles razones:</b><ul><li>Tus mods son para una build diferente de PillowMC.</li><li>Hay muchas actualizaciones de modloaders para una versi\u00f3n de Minecraft.</li><li>Tienes una instalaci\u00f3n defectuosa (com\u00fan con CurseForge App, ModrinthApp/Theseus/Astralrinth y otros lanzadores de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Ver tutorial</a> para solucionar problemas con CurseForge.</li></ul><p>Nota: Puedes usar la herramienta <b>grepr/fgrepr</b> en la barra lateral para encontrar los mods que hacen referencia a las clases faltantes, siempre que uses '/' en los nombres.</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Tienes un mod que intencionalmente causa lag. Uranium es un mod de lag. No siempre causa fallos, pero eventualmente puede hacerlo.</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack est\u00e1 marcado como compatible con 1.19.* pero es para 1.20.*, lo que causa un error de clase no encontrada. El mod intenta usar DamageSources que no existen en la versi\u00f3n de Minecraft actual.</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "Error de versi\u00f3n en Falling Attack";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "Aseg\u00farate de usar la versi\u00f3n correcta de Falling Attack compatible con tu versi\u00f3n de Minecraft.";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("Necesitas instalar CFR (Class File Reader) para usar esta funcionalidad.<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("En sistemas Linux, NetBSD o FreeBSD, puedes instalar CFR desde tu gestor de paquetes.<br>").append("Busca el paquete en: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("Alternativamente, puedes descargar la versi\u00f3n modificada usada por FabricMC desde:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("Gu\u00e1rdalo en la siguiente carpeta:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>Importante:</b> despu\u00e9s de instalar CFR, debes reiniciar el mod para que lo reconozca correctamente.").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "Sin retrato disponible";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "No se pudo encontrar la clase: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "Descompilador CFR \u2013 Sakura Riddle (No Oficial)";
    }

    @Override
    public String cfrClaseActual() {
        return "Clase actual";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "Retrato de Sakura Riddle";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "Error al cargar el retrato";
    }

    @Override
    public String noticiaLegalCFR() {
        return "Este programa de interfaz gr\u00e1fica (GUI) para decompilar mods est\u00e1 dise\u00f1ado para ayudar a los usuarios a identificar las causas de fallos en el software. Sin embargo, la decompilaci\u00f3n de mods puede ser necesaria, y los usuarios deben tener cuidado de no utilizar el c\u00f3digo generado para infringir la Ley Federal de Derechos de Autor. Se recomienda revisar la licencia del mod correspondiente antes de usar cualquier c\u00f3digo obtenido. Adem\u00e1s, a menudo los mods proporcionan su c\u00f3digo fuente oficialmente, que es generalmente m\u00e1s limpio y f\u00e1cil de entender que el c\u00f3digo descompilado. Recuerde que el respeto por la propiedad intelectual y las licencias de uso es fundamental para la comunidad de desarrollo de mods. Puede consultar la Ley Federal de Derechos de Autor en el siguiente enlace: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor (Espa\u00f1ol)</a> y la versi\u00f3n en ingl\u00e9s aqu\u00ed: <a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (English)</a>. Dado que estamos en CurseForge, tambi\u00e9n proporcionamos el enlace a la Ley de Derechos de Autor de EE. UU. en ingl\u00e9s: <a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>. Adem\u00e1s, se recomienda que los usuarios consulten d\u00f3nde se encuentran y se informen sobre las leyes aplicables en su ubicaci\u00f3n. Nuestra GUI es solo para comprobaciones simples; para un an\u00e1lisis m\u00e1s avanzado, deber\u00edan usar el Fork Enigma de FabricMC disponible en <a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>. Si desean editar archivos JAR para hacer parches cuando no hay c\u00f3digo fuente disponible, pueden utilizar Recaf en <a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">su sitio web</a>.";
    }

    @Override
    public String botonDescargarCfr() {
        return "Descargar CFR";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "Abrir carpeta de instalaci\u00f3n";
    }

    @Override
    public String colorFondoPrincipal() {
        return "Color de fondo principal";
    }

    @Override
    public String colorTextoBotonReset() {
        return "Color del texto del bot\u00f3n de reinicio";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "Color del texto del campo de b\u00fasqueda";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "Color del texto del men\u00fa desplegable de filtro";
    }

    @Override
    public String colorTextoRenderer() {
        return "Color del texto del renderizador";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "Color del texto del overlay de carga";
    }

    @Override
    public String colorBorde() {
        return "Color del borde";
    }

    @Override
    public String colorFondoRetrato() {
        return "Color de fondo en modo retrato";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "Color del enlace para compartir";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "Color de fondo del campo de compartir";
    }

    @Override
    public String rosaFondo() {
        return "Rosa de fondo";
    }

    @Override
    public String rosaSuave() {
        return "Rosa suave";
    }

    @Override
    public String moradoAcento() {
        return "Morado de acento";
    }

    @Override
    public String textoOscuro() {
        return "Texto oscuro";
    }

    @Override
    public String bordeSuave() {
        return "Borde suave";
    }

    @Override
    public String fondoCampo() {
        return "Fondo de campo";
    }

    @Override
    public String fondoVistaPrevia() {
        return "Fondo de vista previa";
    }

    @Override
    public String sintaxisConstructor() {
        return "Color de sintaxis: constructor";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "Color de sintaxis: mensaje de ayuda";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "Color de sintaxis: etiquetas HTML";
    }

    @Override
    public String colorFondoVentana() {
        return "Color de fondo de la ventana";
    }

    @Override
    public String colorPanel() {
        return "Color del panel";
    }

    @Override
    public String colorBotonTexto() {
        return "Color del texto del bot\u00f3n";
    }

    @Override
    public String colorCampo() {
        return "Color del campo";
    }

    @Override
    public String colorBordeDestacado() {
        return "Color del borde destacado";
    }

    @Override
    public String colorSeleccionTexto() {
        return "Color de fondo de selecci\u00f3n de texto";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "Color del texto seleccionado";
    }

    @Override
    public String colorEstadoExito() {
        return "Color de estado: \u00e9xito";
    }

    @Override
    public String colorEstadoFallo() {
        return "Color de estado: fallo";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "Color de estado: instant\u00e1nea";
    }

    @Override
    public String colorResultadoAnadido() {
        return "Color de resultado a\u00f1adido";
    }

    @Override
    public String colorResultadoEliminado() {
        return "Color de resultado eliminado";
    }

    @Override
    public String colorBordeScroll() {
        return "Color del borde del scroll";
    }

    @Override
    public String colorFondoPanel() {
        return "Color de fondo del panel";
    }

    @Override
    public String colorBeigeListas() {
        return "Beige de las listas";
    }

    @Override
    public String colorTextoListas() {
        return "Color del texto en listas";
    }

    @Override
    public String colorBordeListas() {
        return "Color del borde de las listas";
    }

    @Override
    public String colorBotonFondo() {
        return "Color de fondo del bot\u00f3n";
    }

    @Override
    public String colorBordeBoton() {
        return "Color del borde del bot\u00f3n";
    }

    @Override
    public String colorDoradoTexto() {
        return "Color dorado del texto";
    }

    @Override
    public String colorPila() {
        return "Color de la pila (stack trace)";
    }

    @Override
    public String colorTextoPanel() {
        return "Color del texto del panel";
    }

    @Override
    public String colorTextoNegro() {
        return "Color de texto negro";
    }

    @Override
    public String colorTextoPrincipal() {
        return "Color del texto principal";
    }

    @Override
    public String colorFondoResultados() {
        return "Color de fondo de los resultados";
    }

    @Override
    public String colorEstado() {
        return "Color de estado";
    }

    @Override
    public String colorTextoDescripcion() {
        return "Color del texto de descripci\u00f3n";
    }

    @Override
    public String colorTextoEstado() {
        return "Color del texto de estado";
    }

    @Override
    public String colorTextoExtra() {
        return "Color del texto extra";
    }

    @Override
    public String colorSeparador() {
        return "Color del separador";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "Se ha detectado un error nativo <code>StubRoutines::SafeFetch32</code>. Este problema ocurre en macOS con JDK 17.0.9 y se corrige en JDK 17.0.10 o versiones posteriores. https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "Error nativo SafeFetch32 en JDK 17.0.9 (macOS)";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "Actualiza tu JDK a la versi\u00f3n 17.0.10 o superior (por ejemplo, 17.0.15).";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "Si usas un lanzador como MultiMC, Prism Launcher o TLauncher, config\u00faralo para usar un JDK m\u00e1s reciente. Algunos ya incluyen JDK 17.0.15 integrado.";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "El mod Spark tambi\u00e9n puede contribuir a este error. Considera desactivarlo temporalmente. https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod MCEF (Chromium Embedded Framework) est\u00e1 causando un cuelgue silencioso.</b><ul><li>MCEF se est\u00e1 inicializando al final del log, lo que normalmente significa que el juego se qued\u00f3 colgado durante la carga.</li><li>Este mod es conocido por causar fallos en sistemas Linux, macOS o con ciertas versiones de Java.</li><li>No siempre aparece un error expl\u00edcito, pero el juego nunca llega al men\u00fa principal.</li></ul><p>Si no necesitas funcionalidad de navegador dentro del juego (como mapas web o p\u00e1ginas integradas), elimina el mod.</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "Problema de inicializaci\u00f3n de MCEF (mod de navegador embebido)";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "Elimina el archivo del mod MCEF (busca 'mcef' en el nombre del archivo) de la carpeta 'mods'.";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "Si realmente lo necesitas, aseg\u00farate de usar una versi\u00f3n compatible con tu sistema operativo y versi\u00f3n de Minecraft.";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se ha detectado un conflicto entre <b>OptiFine</b> e <b>Iris/Oculus</b>.</b><ul><li>OptiFine modifica el renderizado de Minecraft de forma incompatible con Iris u Oculus.</li><li>El error <code>MixinLevelRenderer failed injection check</code> proviene de <code>mixins.iris.json</code> o <code>mixins.oculus.json</code>.</li></ul><p>Estos mods no pueden usarse juntos. Elimina OptiFine para usar shaders con Iris u Oculus.</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "Conflicto entre OptiFine e Iris/Oculus";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "Elimina el archivo de OptiFine de la carpeta 'mods'.";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "Usa Iris u Oculus sin OptiFine para shaders modernos.";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se ha detectado un conflicto entre <b>ModernFix</b> y <b>OptiFine</b>.</b><ul><li>ModernFix no es compatible con OptiFine porque rompe funcionalidades de Forge y ralentiza el inicio.</li><li>El propio ModernFix advierte: <i>\"Use of ModernFix with OptiFine is not supported\"</i>.</li></ul><p>Debes eliminar uno de los dos mods para que el juego funcione correctamente.</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "Conflicto entre ModernFix y OptiFine";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "Elimina OptiFine o ModernFix de la carpeta 'mods'. No pueden usarse juntos.";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "Si necesitas optimizaciones, considera usar solo OptiFine, o remplazar ModernFix por mods m\u00e1s ligeros como FerriteCore o EntityCulling.";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error: clave de registro inv\u00e1lida con caracteres no permitidos.</b><ul><li><b>Clave detectada:</b> <code>" + this.escapeHtml(clave) + "</code></li><li>En Minecraft, todas las claves de registro (etiquetas, recetas, logros, etc.) deben estar en <b>min\u00fasculas</b> y usar solo letras, n\u00fameros, guiones bajos, guiones y barras.</li><li>Este error suele ser causado por un mod mal programado o un datapack defectuoso.</li></ul><p><b>Consejo importante:</b> Usa la herramienta <b>grepr</b> o <b>fgrepr</b> en la barra lateral y activa la opci\u00f3n <b>\"Buscar en archivos JAR\"</b> para encontrar qu\u00e9 mod contiene esta clave incorrecta.</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "Clave de registro con may\u00fasculas o caracteres inv\u00e1lidos";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "Usa 'grepr' o 'fgrepr' con \"Buscar en archivos JAR\" para localizar el mod culpable.";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "Si no puedes identificar el mod, elimina mods recientes, especialmente los que a\u00f1aden bloques, items o herramientas.";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Error al cargar el mod <b>" + this.escapeHtml(modNombre) + "</b>.</b><ul><li>El mod fall\u00f3 al inicializar uno de sus componentes (por ejemplo, el men\u00fa de configuraci\u00f3n).</li><li>Esto suele ocurrir por incompatibilidad con la versi\u00f3n de Minecraft, Fabric o con otros mods.</li></ul><p>Si el error persiste, elimina o actualiza el mod <b>" + this.escapeHtml(modNombre) + "</b>.</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "Error de inicializaci\u00f3n de mod (Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "Elimina el mod '" + modNombre + "' de la carpeta 'mods'.";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "Actualiza el mod '" + modNombre + "' a una versi\u00f3n compatible con tu instalaci\u00f3n.";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se ha detectado un error relacionado con el mod <b>En Garde!</b>.</b><ul><li>Este mod a\u00f1ade mec\u00e1nicas de combate cuerpo a cuerpo (parry, bloqueo, etc.).</li><li>El error suele ocurrir por incompatibilidad con otros mods de combate (como Epic Fight, DualRiders, etc.) o por usar una versi\u00f3n incorrecta para tu Minecraft.</li></ul><p>Si no usas combate avanzado, considera eliminar En Garde! para evitar conflictos.</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "Error en el mod En Garde!";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "Aseg\u00farate de usar la versi\u00f3n de En Garde! compatible con tu versi\u00f3n de Minecraft y tu cargador (Fabric/Forge).";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "Si usas otros mods de combate (Epic Fight, Caelus, etc.), desact\u00edvalos o elimina En Garde! para evitar conflictos.";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se ha detectado un error causado por el mod <b>IdleTweaks</b>.</b><ul><li>IdleTweaks intent\u00f3 liberar un canal de red que ya no existe (<code>Tried to release unknown channel</code>).</li><li>Este error suele ocurrir en versiones antiguas del mod o al usarlo en servidores mal configurados.</li></ul><p>IdleTweaks es un mod de calidad de vida, pero puede causar inestabilidad. Considera actualizarlo o eliminarlo.</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "Error en IdleTweaks (canal de red desconocido)";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "Actualiza IdleTweaks a la \u00faltima versi\u00f3n compatible con tu Minecraft.";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "Elimina IdleTweaks de la carpeta 'mods' si no lo necesitas.";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se ha detectado un error de autenticaci\u00f3n (HTTP 401) al intentar iniciar sesi\u00f3n en Minecraft.</b><p>Este error <b>rara vez es la causa directa del crash</b>, pero indica que est\u00e1s usando una cuenta no autenticada (pirata).</p><p>Los canales de soporte oficiales (proyectos corporativos, VTubers, creadores de modpacks, etc.) <b>no pueden ayudarte</b> si usas una copia pirata, debido a restricciones de sus reglas de chat, contratos, acuerdos con Mojang/Microsoft, o pol\u00edticas de reputaci\u00f3n.</p><p>Esta verificaci\u00f3n se puede <b>deshabilitar en la configuraci\u00f3n corporativa</b> del detector. Advertencia: la detecci\u00f3n antipirater\u00eda <b>no es perfecta</b> y puede activarse en entornos de desarrollo, con internet inestable, o al usar launchers modificados.</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>Derechos Miranda si intentas unirte al soporte igualmente:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "Minecraft pirateado";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "Deshabilitar verificaci\u00f3n antipirater\u00eda";
    }

    @Override
    public String comprarMC() {
        return "Comprar Minecraft";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Est\u00e1s usando el lanzador <code>" + id + "</code>, que <b>no est\u00e1 en la lista de lanzadores recomendados</b>.</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>Aunque puede funcionar, los lanzadores no recomendados suelen causar:</p><ul><li>Instalaciones corruptas de mods o la App.</li><li>El juego no inicia o se cuelga sin error claro.</li><li>Estructura de carpetas inusual (dificulta el diagn\u00f3stico).</li><li>Comportamiento impredecible con Java, memoria o mods.</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "Para una mejor experiencia, usa uno de estos lanzadores recomendados:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "Lanzador no recomendado";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "Cambia a un lanzador de la lista recomendada.";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Est\u00e1s usando un <b>lanzador desaconsejado</b>: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>Los lanzadores desaconsejados pueden causar:</p><ul><li>Instalaciones corruptas de la App o mods.</li><li>El juego no inicia o falla silenciosamente.</li><li>Organizaci\u00f3n inusual de archivos (dif\u00edcil de depurar).</li><li>Incertidumbre sobre c\u00f3mo gestiona mods, Java o memoria.</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "Se recomienda encarecidamente usar uno de los siguientes lanzadores:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "Lanzador desaconsejado";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "Cambia a un lanzador recomendado para recibir soporte.";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Faltan mods recomendados para este entorno.</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "Faltan mods recomendados";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "Instala los mods recomendados para una experiencia \u00f3ptima.";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detectaron mods desaconsejados en tu instalaci\u00f3n.</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "Mods desaconsejados detectados";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "Elimina los mods desaconsejados para evitar problemas.";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Se detect\u00f3 manipulaci\u00f3n no autorizada en archivos cr\u00edticos. Has modificado archivos o est\u00e1s usando un lanzador no confiable.</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "Manipulaci\u00f3n detectada";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "Reinstala los archivos originales para restaurar la integridad.";
    }

    @Override
    public String configuracionCorporativa() {
        return "Configuraci\u00f3n Corporativa";
    }

    @Override
    public String idiomaRespaldo() {
        return "Idioma de Respaldo";
    }

    @Override
    public String buscardorHabilitado() {
        return "Habilitar Buscardor";
    }

    @Override
    public String nombreHerramienta() {
        return "Nombre de la Herramienta";
    }

    @Override
    public String condenarPirateria() {
        return "Condenar Pirater\u00eda";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "Lanzadores Recomendados";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "Lanzadores Desaconsejados";
    }

    @Override
    public String modsRecomendados() {
        return "Mods Recomendados";
    }

    @Override
    public String modsDesaconsejados() {
        return "Mods Desaconsejados";
    }

    @Override
    public String antiTamper() {
        return "AntiTamper";
    }

    @Override
    public String proximamente() {
        return "Pr\u00f3ximamente";
    }

    @Override
    public String informacion() {
        return "Informaci\u00f3n";
    }

    @Override
    public String errorCargandoImagen() {
        return "Error cargando imagen";
    }

    @Override
    public String configuracionBasica() {
        return "Configuraci\u00f3n B\u00e1sica";
    }

    @Override
    public String funcionalidades() {
        return "Funcionalidades";
    }

    @Override
    public String derechosMiranda() {
        return "Derechos Miranda (MUY recomendados)";
    }

    @Override
    public String gestionVerificaciones() {
        return "Gesti\u00f3n de Verificaciones";
    }

    @Override
    public String idVerificacion() {
        return "ID";
    }

    @Override
    public String nombreVerificacion() {
        return "Nombre";
    }

    @Override
    public String codigoVerificacion() {
        return "C\u00f3digo";
    }

    @Override
    public String documentacionVerificacion() {
        return "Documentaci\u00f3n";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "Verificaciones Habilitadas:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "Verificaciones Deshabilitadas:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "Deshabilitar todas no corporativas";
    }

    @Override
    public String verCodigo() {
        return "Ver C\u00f3digo";
    }

    @Override
    public String verDocumentacion() {
        return "Ver Documentaci\u00f3n";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "Seleccione una verificaci\u00f3n para deshabilitar.";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "Seleccione una verificaci\u00f3n para habilitar.";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "Se deshabilitaron %d verificaciones no recomendadas para uso corporativo.";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "No hay verificaciones no corporativas para deshabilitar.";
    }

    @Override
    public String operacionCompletada() {
        return "Operaci\u00f3n completada";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "Te extra\u00f1amos Amane Kanata";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "Color de Verificaci\u00f3n Corporativa";
    }

    @Override
    public String nombreLanzador() {
        return "Nombre del Lanzador";
    }

    @Override
    public String motivo() {
        return "Motivo";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "Lanzadores Desaconsejados";
    }

    @Override
    public String moverADesaconsejados() {
        return "Desaconsejar";
    }

    @Override
    public String moverARecomendados() {
        return "Recomendar";
    }

    @Override
    public String guardarCambios() {
        return "Guardar Cambios";
    }

    @Override
    public String cancelar() {
        return "Cancelar";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "Por favor selecciona un lanzador para mover.";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\u00a1Los cambios han sido guardados exitosamente!";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "Razones";
    }

    @Override
    public String agregarLanzador() {
        return "Agregar lanzador";
    }

    @Override
    public String quitarLanzador() {
        return "Quitar lanzador";
    }

    @Override
    public String editarRazones() {
        return "Editar razones";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "Selecciona un lanzador para quitar.";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "Selecciona un lanzador para editar.";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return "Editar razones para " + idLanzador;
    }

    @Override
    public String agregarNuevoIdioma() {
        return "Agregar nuevo idioma";
    }

    @Override
    public String aceptar() {
        return "Aceptar";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "Selecciona el idioma";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "Estos lanzadores son los que CrashDetector sugiere como buenos.";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "Resultado correcto";
    }

    @Override
    public String modsNoRecomendados() {
        return "Mods desaconsejados";
    }

    @Override
    public String agregarMod() {
        return "Agregar mod";
    }

    @Override
    public String quitarMod() {
        return "Quitar mod";
    }

    @Override
    public String modId() {
        return "Mod ID/Nombre JBoss Modules";
    }

    @Override
    public String rutaMod() {
        return "Ruta / archivo del mod";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "Debe indicar al menos el modid o la ruta del mod.";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "Aqu\u00ed puedes registrar mods desaconsejados para que CrashDetector los detecte si est\u00e1n instalados.";
    }

    @Override
    public String anularNormal() {
        return "Anular Normal";
    }

    @Override
    public String anularNormalDescripcion() {
        return "CrashDetector deber\u00eda avisar aunque no crashee";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "Registra mods que CrashDetector recomienda. Si faltan, CrashDetector puede avisar.";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "Si decides habilitar la advertencia antipirater\u00eda, se recomienda definir aqu\u00ed los derechos de la persona que solicita soporte, como medida preventiva.\n\nContrario a una creencia com\u00fan, muchas comunidades y canales de soporte populares NO requieren activar advertencias antipirater\u00eda para brindar ayuda. Sin embargo, documentar estos derechos puede ser \u00fatil en caso de que una persona acceda al canal de soporte de todos modos.\n\nPuedes basarte en documentos oficiales como la Cartilla de Derechos B\u00e1sicos del Detenido en M\u00e9xico:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\nAs\u00ed como en principios legales comparables utilizados en otros pa\u00edses, incluyendo Estados Unidos, la Federaci\u00f3n de Rusia, la Rep\u00fablica Popular China, la Rep\u00fablica Isl\u00e1mica de Ir\u00e1n y la Rep\u00fablica Popular Democr\u00e1tica de Corea.\n\nAlgunos ejemplos de derechos que pueden incluirse son:\n\u2022 El derecho a no proporcionar informaci\u00f3n innecesaria para el soporte, como el lanzador utilizado, el nombre de usuario o el UUID.\n\u2022 El derecho a no autoincriminarse.\n\u2022 El derecho a rechazar responder preguntas que no sean necesarias para la resoluci\u00f3n del problema.\n\u2022 El derecho a recibir orientaci\u00f3n dentro del chat.\n\u2022 El derecho a utilizar el anonimizado de registros (logs) integrado en CrashDetector.\n\nEste texto acepta contenido HTML.";
    }

    @Override
    public String editar() {
        return "Editar";
    }

    @Override
    public String advertenciaHashLento() {
        return "Advertencia: a\u00f1adir muchos archivos grandes puede hacer que la verificaci\u00f3n tarde varios minutos. CrashDetector deber\u00e1 calcular el hash de cada archivo antes de continuar. Se recomienda proteger solo los archivos estrictamente necesarios.";
    }

    @Override
    public String agregarArchivo() {
        return "Agregar archivo";
    }

    @Override
    public String agregarCarpeta() {
        return "Agregar carpeta";
    }

    @Override
    public String quitar() {
        return "Quitar";
    }

    @Override
    public String rutaArchivo() {
        return "Ruta del archivo";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "La ruta seleccionada est\u00e1 fuera del directorio actual del juego. Solo se permiten archivos y carpetas dentro del directorio actual o sus subdirectorios.";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>Las opiniones y comentarios de Sylent Bell no necesariamente coinciden con los nuestros; solo pensamos que ser\u00eda gracioso ponerla aqu\u00ed. CrashDetector es secular.</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>El mod GML (Groovy ModLoader) requiere estos cambios y es el origen m\u00e1s com\u00fan de este problema.</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha detectado el uso de <i>Independiente Flywheel</i>.</b><p><b>Independiente Flywheel est\u00e1 obsoleto (deprecated)</b> y no debe utilizarse en versiones modernas.</p><p>Las versiones actuales de <b>Create</b> <b>ya incluyen Flywheel</b>, por lo que instalarlo de forma independiente provoca conflictos de compatibilidad y errores de carga.</p><p>Algunos mods que dependen expl\u00edcitamente de Independiente Flywheel pueden <b>no funcionar</b> o <b>funcionar de forma inestable</b>. En ciertos casos avanzados, estos mods pueden llegar a funcionar si se <b>edita manualmente el archivo <code>mods.toml</code></b> para ajustar los rangos de versi\u00f3n, aunque esto <b>no es recomendado</b>.</p>" + (mods.isEmpty() ? "" : "<p><b>Mods detectados que hacen referencia a Flywheel:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>La soluci\u00f3n recomendada es <b>eliminar Independiente Flywheel</b> y utilizar \u00fanicamente la versi\u00f3n incluida con Create.</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "Flywheel Independiente";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha detectado un error relacionado con el mod <i>Floral Enchantments</i>.</b><p>El crash est\u00e1 causado por un fallo interno del mod al manejar datos del juego, lo que provoca una <b>NullPointerException</b> durante la ejecuci\u00f3n.</p><p>Este problema suele resolverse actualizando el mod o elimin\u00e1ndolo .</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "Error de Floral Enchantments";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>Tienes la versi\u00f3n NeoForge de MixinExtras y la versi\u00f3n normal. Si est\u00e1s en MinecraftForge, puedes instalar <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>este enlace</a> para la soluci\u00f3n.</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha detectado un error en las sombras del terreno con shaders (Iris).</b><p>El problema ocurre durante el renderizado del terreno.</p><p>Se recomienda <b>probar el juego sin shaders</b> o reducir la calidad gr\u00e1fica, especialmente en configuraciones <b>Ultra</b>.</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "Sombras del terreno (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha detectado un tick del servidor excesivamente largo.</b><p>Esto indica que el juego se ha quedado bloqueado durante demasiado tiempo en un solo tick.</p><p>Se recomienda <b>revisar el thread dump</b> generado en el log para identificar la causa.</p><p>El <b>An\u00e1lisis de Stack Trace</b> puede ayudarte a localizar el origen del bloqueo.</p><p>Adem\u00e1s, el bot\u00f3n <b>Ver en log</b> resaltar\u00e1 en rojo los posibles mods responsables, as\u00ed como entradas rodeadas por <code>$modid$</code>, que suelen indicar el origen del problema. Para el escaneo en tiempo real, recomendamos usar el muestreador de CPU en VisualVM. Aseg\u00farate de que tu servidor o computadora sea lo suficientemente potente como para manejar los mods que est\u00e1s usando, ya que es posible que todos tus mods funcionen correctamente, pero que tengas demasiados.</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "Tick largo del servidor";
    }

    @Override
    public String tituloLFPDPPP() {
        return "LEY FEDERAL DE PROTECCI\u00d3N DE DATOS PERSONALES EN POSESI\u00d3N DE LOS PARTICULARES";
    }

    @Override
    public String aceptarPermanentemente() {
        return "Aceptar permanentemente";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "Acta de Protecci\u00f3n del Idioma Cultural de Pyongyang";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "La traducci\u00f3n coreana contiene t\u00e9rminos de slang del sur que deben evitarse para cumplir con la ley. El uso de lenguaje extranjero, especialmente proveniente  del Sur, est\u00e1 estrictamente prohibido seg\u00fan el Acta de Protecci\u00f3n del Idioma Cultural de Pyongyang.";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "Para m\u00e1s informaci\u00f3n, consulte el documento oficial de la ley: <a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>Acta de Protecci\u00f3n del Idioma Cultural de Pyongyang</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "Leer Ley Completa";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "Error al abrir el enlace";
    }

    @Override
    public String canarioTitulo() {
        return "Canario de Orden Judicial";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 Monitor de Vigilancia";
    }

    @Override
    public String revisar() {
        return "Revisar";
    }

    @Override
    public String cerrar() {
        return "Cerrar";
    }

    @Override
    public String canarioTodoSeguro() {
        return "Todos los servicios reportan estado seguro.";
    }

    @Override
    public String canarioComprometido(int c) {
        return "ALERTA: " + c + " servicio(s) reportan estado inseguro.";
    }

    @Override
    public String colorAlerta() {
        return "Color de alerta";
    }

    @Override
    public String opcionesMunidiales() {
        return "Opciones munidiales";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "Consentimiento LFPDPPP";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "Habilitar la transferencia del token de acceso en Handoff para ReLauncher (desaconsejado).";
    }

    @Override
    public String consolaDesarrollo() {
        return "Consola de desarrollo";
    }

    @Override
    public String mundial() {
        return "Mundial";
    }

    @Override
    public String ningun() {
        return "Ning\u00fan";
    }

    public String consolaDesarrollador() {
        return "Consola del desarrollador";
    }

    @Override
    public String bajar() {
        return "Bajar";
    }

    @Override
    public String logsSoporte() {
        return "Logs para soporte";
    }

    @Override
    public String detenerProceso() {
        return "Detener proceso";
    }

    @Override
    public String copiarSeleccion() {
        return "Copiar selecci\u00f3n";
    }

    @Override
    public String seleccionarTodo() {
        return "Seleccionar todo";
    }

    @Override
    public String copiarTodo() {
        return "Copiar todo";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "Guardar todo como archivo";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "Obtener enlace de soporte";
    }

    @Override
    public String borrarTodo() {
        return "Borrar todo";
    }

    public String colorFondoConsola() {
        return "Color de fondo de la consola";
    }

    public String colorTextoConsola() {
        return "Color del texto de la consola";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "Consentimiento confirmado.\nLa integraci\u00f3n de compartir logs se implementar\u00e1 aqu\u00ed.";
    }

    @Override
    public String usarSakuraOriginal() {
        return "Usar la Imagen de Sakura Riddle Original";
    }

    @Override
    public String canario1984Descripcion() {
        return "Un \"warrant canary\" es un mecanismo de transparencia.\n\nMientras este mensaje exista y los servicios aparezcan como seguros, significa que el proyecto NO ha recibido \u00f3rdenes judiciales secretas, requerimientos de censura, ni solicitudes legales de vigilancia.\n\nSi alg\u00fan canario deja de estar presente o marca como inseguro, eso indica que algo ha cambiado legalmente.\n\nEste panel revisa todos los canarios registrados en el sistema y muestra su estado actual.\n\nPulsa \"Revisar\" para actualizar los estados.";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\u00bfRestablecer todas las opciones a sus valores por defecto?";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "Sin Opciones";
    }

    @Override
    public String seleccionaColor() {
        return "Seleccionar color";
    }

    @Override
    public String botonMostrarGUI() {
        return "Mostrar GUI";
    }

    @Override
    public String botonGuardarTodo() {
        return "Guardar todo";
    }

    @Override
    public String botonRestablecerTodo() {
        return "Restablecer todo";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms no cargado";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha detectado un error al acceder a la API de LuckPerms.</b><p>El mensaje indica que <b>LuckPerms no estaba cargado</b> en el momento en que otro plugin intent\u00f3 usarlo.</p><p><b>Posibles causas:</b></p><ul><li>El plugin <b>LuckPerms no est\u00e1 instalado</b> o <b>fall\u00f3 al iniciarse</b>.</li><li>Otro plugin est\u00e1 intentando acceder a LuckPerms demasiado pronto o de forma incorrecta.</li></ul><p>Se recomienda <b>revisar la consola</b> usando el enlace para identificar el plugin que est\u00e1 llamando a LuckPerms y verificar su compatibilidad.</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "Shaderpack de Iris no cargado";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "desconocido" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha detectado un error al cargar un shaderpack con Iris/Oculus.</b><p><b>Shaderpack afectado:</b> " + nombre + "</p><p>Minecraft no pudo abrir el archivo del shaderpack (FileSystemNotFoundException).</p><p><b>Posibles soluciones:</b></p><ul><li>Verifica que el shaderpack est\u00e9 correctamente instalado en la carpeta <b>shaderpacks</b>.</li><li>Vuelve a descargar el shaderpack, ya que el archivo podr\u00eda estar corrupto.</li><li>Si el problema persiste, elimina el archivo <b>config/iris.properties</b> para reiniciar la configuraci\u00f3n de Iris.</li></ul><p>Despu\u00e9s de aplicar los cambios, inicia el juego nuevamente.</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "No se pudo escribir el archivo de configuraci\u00f3n";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "desconocido" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha producido un error al guardar un archivo de configuraci\u00f3n.</b><p><b>Archivo afectado:</b> " + archivo + "</p><p>Minecraft no pudo escribir el archivo usando escritura at\u00f3mica (REPLACE_ATOMIC).</p><p><b>Esto suele ocurrir por:</b></p><ul><li>Permisos incorrectos en la carpeta o el archivo.</li><li>El archivo est\u00e1 marcado como solo lectura.</li><li>Otro programa (antivirus, backup, editor) est\u00e1 bloqueando el archivo.</li></ul><p><b>Recomendaciones:</b></p><ul><li>Verifica que tienes permisos de escritura en la carpeta.</li><li>Quita el atributo de solo lectura del archivo.</li><li>Cierra programas que puedan estar usando ese archivo.</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "Acceso denegado al crear copia de seguridad";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "desconocido" : origen;
        String dst = backup == null || backup.isEmpty() ? "desconocido" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Se ha producido un error de permisos al crear una copia de seguridad del archivo de configuraci\u00f3n.</b><p><b>Archivo original:</b> " + src + "</p><p><b>Archivo de respaldo:</b> " + dst + "</p><p>El sistema operativo ha bloqueado el acceso durante el guardado del archivo.</p><p><b>Esto suele ocurrir por:</b></p><ul><li>Permisos insuficientes en la carpeta.</li><li>El archivo est\u00e1 marcado como solo lectura.</li><li>Otro programa (antivirus, sincronizaci\u00f3n, editor) est\u00e1 usando el archivo.</li></ul><p><b>Recomendaciones:</b></p><ul><li>Verifica los permisos de la carpeta <b>config</b>.</li><li>Cierra programas que puedan estar accediendo al archivo.</li><li>Intenta iniciar el launcher o Minecraft como administrador.</li></ul>";
    }
}

