/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Esperanto
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Malvalida mod-dosierujo</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Ne troveblas JAR-dosiero de CrashDetector</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Ser\u0109ante PID: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") \u0109esis funkcii!</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Mankas JVM</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u011cisdatigi viajn kontrolilojn ATI/AMD eble helpas vin. Legu \u0109i tiun gvidilon por ripari \u011din: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Gvidilo pri \u011disdatigo de kontroliloj</a> https://www.amd.com/es/support/download/drivers.html El\u015duti </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>Kelkaj malnovaj versioj foje havas problemojn kun fruaj \u015dar\u011doj de Nouveau-kartoj.</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Estas problemo kun via grafik-\u015doforprogramo. Se vi uzas AMD/ATI GPU a\u016d APU, \u011disdatigu viajn AMD-\u015doforprogramojn. Se vi uzas NVIDIA-karton, certigu ke la ludo kaj \u0109iuj javaw.exe-ekzempleroj uzas apartan grafikkarton. Legu \u0109i tiun gvidilon: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Gvido por \u011disdatigi \u015doforprogramojn</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Via FML-frua fenestro malsukcesis \u015dargi. Por ripari, iru al (.minecraft/config/fml.toml) kaj agordu 'earlyWindowProvider' al \"none\". Se vi uzas Mac M1, certigu ke vi uzas ARM-version de Java, ne Intel x64. \u0108i tio anka\u016d ofte okazas pro malnovaj \u015doforprogramoj. Se vi uzas Windows kaj mal\u015dalti \u0109i tiun agordon ne helpas, konsultu \u0109i tiun gvidilon: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Gvido por \u011disdatigi \u015doforprogramojn</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Mankas necesaj dependa\u0135oj:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "Petita de").replace("Expected range", "Atendata amplekso") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Via CrashDetector-raporto trovi\u011das \u0109i tie <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>Vidi raporton</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u0108i tiu estas la GUI de CrashDetector. Se la ludo normale fermi\u011dis, ignoru \u0109i tiun ekranon.</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>Vidi raporton</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Vidi lokan raporton en retumilo.</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "Kunhavigi raporton";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "Kunhavigi raporton. Viaj protokoloj estos al\u015dutitaj al securelogger.net, kaj la raporto al aliaj ejoj.";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita problema JAR-dosiero (prioritatu FATAL, poste alta kaj malalta prioritato):</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> Nivelo:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eble fatala:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektitaj problemaj ModID (prioritatu FATAL, poste alta kaj malalta prioritato):</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektitaj problemaj pakoj (prioritatu FATAL, poste alta kaj malalta prioritato):</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi havas fatalajn klasojn (FATAL), tio estas tre gravega. Oftaj ka\u016dzoj estas malbonaj CoreMods a\u016d fatalaj dependecoj. Vi povas uzi QuickFix por ser\u0109i modojn kun fatalaj klasoj. Mankantaj fatalaj klasoj trovitaj:</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Enhavo de {} (plej grava supre, nur unua 20 montritaj):</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita problema SpongeMixin-agordo: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Vi havas modojn kun duplikitaj paka\u0135oj. Vi povas solvi tion forigante la duplikitan paka\u0135on (dosierujon) el la JAR-dosiero. Vi povas malfermi la JAR-on en arkivilo kiel WinRAR a\u016d 7z, a\u016d vi povas \u015dan\u011di la dosiernomon de .jar al zip kaj poste forigi la dosierujon kaj tiam re\u015dan\u011di \u011din al .jar dosiero.</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektitaj duoblaj Modoj</b> " + linea.replace("from mod files", "el mod-dosieroj");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge detektis problemojn kun suspektinda mod:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV bezonas lithostitched, instalebla \u0109i tie: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Por uzi Iris-\u015dejnilojn a\u016d Oculus, vi bezonas kongruan version de SODIUM a\u016d alia \u015dar\u011dilo (Rubidium, Embedium, Bedium)</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Problemo kun KubeJS-etenda\u0135o </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Problemoj detektitaj kun NVIDIA-drajviloj en versioj anta\u016d Windows 11.</span><br/><br/>Por certigi, ke Minecraft (kaj la nuna JVM) uzas la dedi\u0109itan grafikan karton NVIDIA, sekvi tiujn pa\u015dojn:<br/><br/>1. <strong>Identigu la Java-ekzekuteblon:</strong><br/>   - \u0108i tiu programo uzas la jenan Java-ekzekuteblon: " + this.obtenerRutaJava() + "<br/>   - Se vi ne vidas specifan vojon, vi povas trovi la Java-ekzekuteblon per ser\u0109ado de 'java.exe' en via sistemo.<br/><br/>2. <strong>Malfermu la NVIDIA-Kontrolpanelon:</strong><br/>   - Alklaku dekstre sur la labortablo kaj elektu 'NVIDIA-Kontrolpanelo'.<br/><br/>3. <strong>Agordu la preferatan GPU-on:</strong><br/>   - En la NVIDIA-Kontrolpanelo, iru al 'Administri 3D-agordojn'.<br/>   - Elektu la opcion 'Programa agordo'.<br/>   - Alklaku 'Aldoni' kaj ser\u0109u la jam identigitan Java-ekzekuteblon (ekz.: 'java.exe').<br/>   - Certigu, ke \u011di estas agordita por uzi la 'Alta-rendimentan NVIDIA-procesoron'.<br/><br/>4. <strong>Konservu la \u015dan\u011dojn:</strong><br/>   - Apliku la \u015dan\u011dojn kaj fermu la NVIDIA-Kontrolpanelon.<br/><br/>5. <strong>Restartu Minecraft:</strong><br/>   - Restartu Minecraft por ke la \u015dan\u011doj efektivi\u011du.<br/><br/>Se vi uzas Windows Server 2022 a\u016d Windows 10, tiuj pa\u015doj validas se vi havas la plej novajn NVIDIA-drajvilojn instalitajn.<br/><br/>Notu: Se vi ne povas trovi la NVIDIA-Kontrolpanelon, certigu, ke la NVIDIA-drajviloj estas \u011duste instalitaj.";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Problemoj detektitaj kun NVIDIA-drajviloj en Windows 11/Server 2025 a\u016d poste.</span><br/><br/>Por certigi, ke Minecraft (kaj la nuna JVM) uzas la dedi\u0109itan grafikan karton NVIDIA, sekvi tiujn pa\u015dojn:<br/><br/>1. <strong>Identigu la Java-ekzekuteblon:</strong><br/>   - \u0108i tiu programo uzas la jenan Java-ekzekuteblon: " + this.obtenerRutaJava() + "<br/>   - Se vi ne vidas specifan vojon, vi povas trovi la Java-ekzekuteblon per ser\u0109ado de 'java.exe' en via sistemo.<br/><br/>2. <strong>Malfermu la Agordan Aplika\u0135on:</strong><br/>   - Premu la klavojn <code>Win + I</code> por malfermi la Agordan Aplika\u0135on.<br/>   - Navigu al <strong>Sistemo > Ekrano > Grafiko</strong>.<br/><br/>3. <strong>Agordu la preferatan GPU-on:</strong><br/>   - En la sekcio 'Grafiko', alklaku 'Defa\u016dltaj grafikaj agordoj'.<br/>   - Elektu 'Labortablaj aplika\u0135oj' kaj poste alklaku 'Foliumi'.<br/>   - Ser\u0109u kaj elektu la jam identigitan Java-ekzekuteblon (ekz.: 'java.exe').<br/>   - Post aldono, elektu la Java-aplika\u0135on en la listo kaj agordu \u011din por uzi 'Alta rendimento (NVIDIA)'.<br/><br/>4. <strong>Konservu la \u015dan\u011dojn:</strong><br/>   - Apliku la \u015dan\u011dojn kaj fermu la Agordan Aplika\u0135on.<br/><br/>5. <strong>Restartu Minecraft:</strong><br/>   - Restartu Minecraft por ke la \u015dan\u011doj efektivi\u011du.<br/><br/>Se vi uzas Windows 11 a\u016d Windows Server 2025+, tiuj pa\u015doj validas se vi havas la plej novajn NVIDIA-drajvilojn instalitajn.<br/><br/>Notu: Se vi ne povas trovi la grafikagordan opcion, certigu, ke la NVIDIA-drajviloj estas \u011duste instalitaj.";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Via Servilo a\u016d Mondo havas tiko pli longaj ol 60 sekundoj. Tio povas esti pro tio, ke aldona\u0135oj malrapidigas la servilon a\u016d la aparataro estas tro malforta.</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi ne havas sufi\u0109e da RAM/Memoro. Vi devas atribui pli.</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Theseus havas pliajn problemojn, inkluzive de malsukceso dum forigo de aldona\u0135oj kiam vi provas. Se vi bezonas ludi kun mrpack-dosieroj, vi povas uzi aliajn lan\u0109ilojn kiel Prism Launcher (nur por modrinth.com), ATLauncher (nur por modrinth.com), a\u016d Hello Minecraft Launcher (por modrinth.com kai bbsmc.net).</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Vi uzas \"Preterlasi lan\u0109ilon\" (CurseForge App). Foje tio ka\u016dzas malfacile detekteblajn problemojn. Tio devenas de la opcio \"Preterlasi lan\u0109ilon\" en malnovaj versioj de la CurseForge App a\u016d en la nova versio. Mal\u015daltu \u011din kaj uzu la opcion \"Mojang Launcher\" en la agordoj de CurseForge. Vi povas rigardi tiun anglalingvan videon de Claws of Berk (iru al 1:11) <a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>\u0109i tie</a>.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Averto: Mankas klasoj (averta nivelo). Kutime ne grave, sed povas okazi problemoj \u2014 malsamas de fatalaj klasaj eraroj. Oftaj ka\u016dzoj estas malbonaj CoreMods a\u016d mankantaj dependecoj. Vi povas uzi QuickFix por ser\u0109i modojn kun mankantaj klasoj. Mankantaj klasoj trovitaj:</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Neniu rezulto</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Lokoj de protokoloj:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Jen viaj rezultoj de kontroloj. Faru \u0109ion pa\u0109e; kutime la \u0109efa ka\u016dzo trovi\u011das en la unua a\u016d dua kontrolo. La ceteraj (eraroj 3 kai pli supre) povas esti uzitaj por konfirmo, sed ili estas plejofte kaskadaj eraroj kiujn vi povas \u0109ifone ignori. Malsukcesoj okazas en tavoloj, do solvante la \u0109efan problemon vi solvos tiun apartan eraron. Tamen, eble morga\u016d aperos nova eraro ne rilatanta al nuna, \u0109ar ofte unu eraro malebligas alian aperi en la konzolo.</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Bonvolu uzi Java 17 por versioj 1.17-1.20.4 kaj Java 21 por iu ajn pli nova versio. Uzu Java 8 por pli malnovaj versioj. [Gvidilo](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). Se vi ankora\u016d havas problemojn, eble pro tio ke iu mod havas tro novajn a\u016d malnovajn dosierojn.</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 22 kaj super ne funkcias en Minecraft-versioj sub 1.20.5 por plej multaj mod\u015dar\u011diloj pro malaktuala ASM.</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java estas malmoderna </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi bezonas la JPMS-modulon " + mod_necesitas + " el " + submod + "</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Ne eblas voki " + metodo + " \u0109ar " + objeto + " estas nula</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "Progresinta Analizo";
    }

    @Override
    public String seleccionarCarpeta() {
        return "Elekti Dosierujon";
    }

    @Override
    public String cadenaBusqueda() {
        return "Ser\u0109a \u0108eno";
    }

    @Override
    public String usarRegex() {
        return "Uzi Regulajn Esprimojn";
    }

    @Override
    public String ignorarMayusculas() {
        return "Ignori Majusklojn";
    }

    @Override
    public String buscar() {
        return "Ser\u0109i";
    }

    @Override
    public String busquedaEnProgreso() {
        return "Ser\u0109o en Progreso";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "Neniuj Rezultoj Trovitaj";
    }

    @Override
    public String errorBusqueda() {
        return "Eraro en Ser\u0109o";
    }

    @Override
    public String omitirYCerrar() {
        return "Preterpasi kaj Feri";
    }

    @Override
    public String guardarYCerrar() {
        return "Konservi kaj Feri";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "Algluu la protokolojn \u0109i tie";
    }

    @Override
    public String archivo() {
        return "Dosiero";
    }

    @Override
    public String incluir() {
        return "Inkluzivi";
    }

    @Override
    public String abrir() {
        return "Malfermi";
    }

    @Override
    public String endpointDeInforme() {
        return "Fina Punkto de Raporto";
    }

    @Override
    public String sitoDeLogging() {
        return "Protokola Retpa\u011daro:";
    }

    @Override
    public String apiDeLogging() {
        return "Protokola API:";
    }

    @Override
    public String anonimizarRegistros() {
        return "Anonimigi protokolojn (Beta)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "Kunhavigi Raporton kaj \u0109iujn elektitajn protokolojn";
    }

    @Override
    public String arco() {
        return "\u0108i tiu dialogo permesas al vi kunhavigi protokolojn uzante la API de SecureLogger \u0109e <a href=\"https://securelogger.net\">securelogger.net</a>. Premante la butonon por kunhavigi la raporton, via raporto sendi\u011das al la elektita finpunkto (defa\u016dlte asbestosstar.egoism.jp) (\u015dan\u011debla malsupre). Vi povas kunhavigi \u0109iujn elektitajn protokolojn kune kun la raporto. Se vi ne volas al\u015duti, ne uzu \u0109i tiun dialogon! Ni ne prilaboras vian raporton \u0109e la oficala finpunkto (<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>); ni nur forigas malpermesitajn ligilojn. La kodo estas \u0109i tie: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">fontkodo</a>. \u0108i tio estas uzata sole por montri informojn pri via kra\u015do kaj ligilon al la protokoloj. Tamen, eblas uzi propran finpunkton, kiu eble ne havas la samajn metodojn. Vi uzas la raport-siton " + Config.obtenerInstancia().obtenerSitoDeInformes() + " kaj la protokol-siton " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + ". Vi anka\u016d povas kunhavigi unuopajn protokolojn sen raporto per premado de la kunhavig-butonoj apud la nomoj de la unuopaj protokoloj; la protokoloj iros al la elektita protokol-sito. CrashDetector havas defa\u016dltan anonimigon de protokoloj, kiu provas forigi uzantnomojn, UUID-ojn, alirkodojn, seanco-ID-ojn, IP-adresojn kaj aliajn datumojn. Tamen, \u011di ne estas perfekta. Tamen, la kreinto de la modpaka\u0135o povas mal\u015dalti \u011din. \u011ci povas esti \u015daltita a\u016d mal\u015daltita per la markobutono malsupre en \u0109i tiu ekrano. Vi estas la reganto de viaj propraj datumoj; vi decidu kien vi al\u015dutas viajn datumojn. La protokol-sitoj estas posedataj de triaj partioj, kies posedeco ofte ka\u015di\u011das pro privateco. Vi prenas tutan respondecon pri administrado de viaj datumoj kaj la implikitaj riskoj. La Kunhavig-Dialogo de CrashDetector estas simple interfaco, kiu permesas al vi administri tion. Estas grava, ke vi sciu pri GDPR kaj ARCO. Se vi estas en E\u016dropo, vi povas uzi <a href=\"https://securelogger.top\">securelogger.top</a> gastigatan en Germanio de Hetzner. Por pli da jura informo, vidu la jenajn ligilojn: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>, <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>, <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">Baza Politiko pri Datumprotekto en Japanio</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "Ligilo de Raporto:";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "Konservi Kunhavigan Agordon";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "La protokolo estas tro granda por \u0109i tiu protokola retejo. Bonvolu elekti alian kaj provu denove.";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "Eraro dum publikigo de protokolo " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "Protokola API ne ekzistas. Bonvolu \u015dan\u011di la protokolan API-on en la agordoj.";
    }

    @Override
    public String errorSSL() {
        return "Vi havas eraron de SSL. Tio estas ofta kun malnovaj versioj de Java, inkluzive de Java 8 versioj en la defa\u016dlta Minecraft-Lan\u0109ilo kaj versioj \u0109e sun.com kaj java.com. Tio influas multajn aspektojn, kiel ekzemple la JAR-dosieroj de la instalilo de MinecraftForge, la funkcio por kunhavigi raportojn de CrashDetector dum vi uzas la defa\u016dltan finpunkton, iu modifoj kiuj bezonas interretan konekton kaj iujn protokolajn retejojn. Se tio okazas al vi dum provo kunhavigi raporton, simple aldonu ekranbildon kaj elektu protokolan retejon kiu kongruas kun malnovaj versioj de Java 8.";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Ne kongrua versio de JavaFML: necesas " + requerido + ", trovi\u011dis " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Atentu! JavaFML bezonas specifan version de Minecraft Forge</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La JAR-dosiero '" + archivoJar + "' bezonas la lingvo-provizanton '" + proveedor + "' version '" + requerido + "' a\u016d pli novan, sed nur la versio '" + encontrado + "' estis trovita.</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ATENTU! Crash Assistant estas falsa malprogram-detektilo. \u011ci intence blokas la lan\u0109on de la ludo, ignorante vian liberecon da\u016drigi ludi kun la celitaj kromprogramoj. <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>Vidi kodon de MalwareMod.java</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>Vidi kodon de JarInJarHelper.java</a>. Nur \u0109i tiu kromprogramo estas nuntempe sur ilia listo, kaj ili fakte nur celas la defa\u016dltan protokolregistran retejon, kiun la uzanto povas \u015dan\u011di, kaj tio nur okazas se vi elekte uzas la enigitan protokolan kunhavigan funkcion. CrashAssistant NE faras iujn ajn kontroladojn por e\u0109 determini kiu protokolregistra retejo estas uzata kaj ne klarigas kiel \u015dan\u011di \u011din (estas falmenuo \u0109e la malsupra parto de la kunhaviga dialogo), kaj sendepende de la agordita retejo, CrashAssistant blokos la lan\u0109on de la ludo. En sia mesa\u011do, ili diras fari vian propran esploradon, FARU \u011cIN, rigardu la kodon de CrashDetector kaj Crash Assistant kaj komprenu kion ili faras, NE fidas al a\u016dtoritato.</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La modulo '" + idMod + "' malsukcesis \u0109ar la bezonata klaso ne estis trovita: '" + claseNoEncontrada + "'. Certigu, ke \u0109iuj dependecoj estas instalitaj \u011duste.</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia blokis ludi per TLauncher.</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi uzas version de Optifine por malaktuala versio de Minecraft. Vi devas uzi la version de Optifine por la versio de Minecraft kiun vi uzas.</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Ne eblis \u015dargi la servon de ModLauncher: </b>" + servicio + ".";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro dum analizado de la JSON-dosiero '" + recurso + "' el la JAR-dosiero '" + archivoJar + "'. Estas problemoj kun la registrado.</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Eraro: La modulo '" + modId + "' bezonas la version '" + requerido + "' a\u016d pli novan de '" + dependencia + "', sed trovi\u011dis '" + actual + "'.</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Via grafika procezilo (GPU) ne subtenas la bezonatan version de OpenGL por \u0109i tiu ludo-versio. \u011cisdatigu viajn pelilojn a\u016d \u015dan\u011du vian grafikan karton.</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Pligrandigu la memoron asignitan al la ludo a\u016d malpliigu la uzadon de kromprogramoj/kroma\u0135oj</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>32-bita JVM detektita: Ne povas uzi pli ol 4GB da RAM. Instalu 64-bitan JVM por profiti \u0109iun vian disponeblan memoron</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Kritika eraro de PermGen-memoro. Pligrandigu la konstantan memorospacon a\u016d malpliigu la \u015dar\u011don de klasoj</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Kongrua eraro inter Java 8 kaj modernaj versioj</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+ ne subtenata - Uzu Java 8 por malnovaj versioj de Forge</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8 bezonata (versio 52.0). \u011cisdatigu a\u016d agordu \u011duste</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Kritika eraro de kongrueco: Blokoj ne subtenataj en \u0109i tiu versio. Kontrolu, ke la versioj de modoj kaj servilo estas kongruaj</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro de agordado de monitoroj: Ne eblis difini ekranan modon. Kontrolu:</b><br>- Agordo de multaj monitoroj<br>- \u011cisdatigitaj grafikaj peliloj<br>- Sistem-subebla rezolucio";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro en opcioj de Java: Konfliktantaj rubkolektaj opcioj. Kontrolu, ke vi ne kombinas plurajn GC-algoritmojn en JVM-parametroj</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro de agordo de NightConfig/Forge: Agorda dosiero difektita a\u016d nekompleta. Tio povas esti ka\u016dzita de malplenaj agorddosieroj (ofte 0 bajtoj) en la dosierujo 'config' en pli malnovaj a\u016d modifitaj versioj de NightConfig. Por la plej multaj versioj, Night Config Fixes solvos la problemon, sed se vi uzas nekongruan a\u016d propran versioon de NightConfig, vi devos forigi la agorddosierojn mane. \u0108i tiu problemo estas pli komuna en malnovaj versioj de MC Forge (kiuj inkluzivas NightConfig) kaj en malnovaj modoj de FabricMC kiuj pakas NightConfig, sed \u011di anka\u016d povas ekzisti en iuj propraj versioj de NightConfig. Pli da informo pri solvoj haveblas \u0109e <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a>.</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Intel HD Graphics-pelila eraro detektita. Solvoj:</b><br>1. \u011cisdatigu Intel-pelilojn el <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a> (minimuma versio 15.xx.xx.xx)<br>2. En Minecraft: Opcioj \u2192 Video \u2192 Aktivigu 'Enable VBOs' kaj 'VSync'<br>3. Atribuu 1GB-2GB da RAM al la ludo en la lan\u0109ilo<br>4. \u0108armpere malaktivigu antivirusan programon/tufekranon dum \u011disdatigo";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "Averto: Mankantaj klasoj trovitaj";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "Eraro de blok-rendado";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "Analizo de stapleraroj (stack trace)";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "Nekompleta CurseForge-konzolo";
    }

    @Override
    public String nombre_de_early_window() {
        return "Eraro de frua fenestro (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "Problemoj kun grafikaj peliloj";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "Difektita agordo de MCForge";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "Malsukceso de vidiga re\u011dimo (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "Eraro de komencigo de FabricMC";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "Mankantaj JPMS-moduloj";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "Grave mankantaj klasoj";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "Mankantaj dependecoj de ModLauncher";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "Nekongruaj versioj de Java";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "Eraro de KubeJS-rimedo";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "Nekongrua lingvo-provizanto";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "Eraro de Litchhost";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "Malvera detekto de malprogramoj";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "Trovo de suspekta modifo";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "Duoblaj modifoj en ModLauncher";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "Konfliktoj de JPMS-moduloj";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "Iris bezonas Sodium";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "Ne eblas analizi la JSON-registron";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "Memoro ne sufi\u0109as";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "Eraro de nuligita indiko (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "Nevalidaj opcioj de Java GC";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "Malaktuala/nekonforma OptiFine";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "Kritika servila tiko (60 sekundoj)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "Malsukceso de ModLauncher-servoj";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "Problemaj SpongeMixing-agordoj";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus ne konformas";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "TLauncher ne estas subtenata de WATERMeDIA";
    }

    @Override
    public String auditorias_transformer() {
        return "Transformaj Kontroloj";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Jen estas la rezultoj de la enhavo de la Transformaj Kontroloj en la Vanilla-Lan\u0109ilo. \u011cenerale, \u011di estas malpli preciza ol la StackTrace-analizilo, sed la Vanilla-Lan\u0109ilo ne \u0109iam havas enhavon por {}</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "\u0108i tio kontrolas viajn modifojn por trovi tiujn kreitajn per MCreator. Kvankam la plejparto de la modifoj faritaj per MCreator estas bonaj kaj ekzistas multaj grandaj modifoj kreitaj per MCreator, foje ili havas problemojn kaj malbonan reputacion. \u0108i tio helpas ilin identigi. Rimarku, ke e\u0109 la tre alte valorigitaj povas fakte ne esti de MCreator; ekzemple, ili povas havi integri\u011don kun MCreator.";
    }

    @Override
    public String escanear() {
        return "Skani";
    }

    @Override
    public String cargando() {
        return "\u015car\u011dante";
    }

    @Override
    public String codigo() {
        return "eo";
    }

    @Override
    public String inicioApp() {
        return "Komenco de Ludo/Aplika\u0135o";
    }

    @Override
    public String ajustesCrashDetector() {
        return "Agordoj de CrashDetector";
    }

    @Override
    public String confidencialidad() {
        return "Privateco";
    }

    @Override
    public String tooltip() {
        return "Ilustro";
    }

    @Override
    public String config() {
        return "Agordo";
    }

    @Override
    public String abrirCarpeta() {
        return "Malfermi Dosierujon";
    }

    @Override
    public String actualizar() {
        return "\u011cisdatigi";
    }

    @Override
    public String anadirRegistro() {
        return "Aldoni Registradon";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "Uzi sistem-lingvon";
    }

    @Override
    public String volver() {
        return "Reiri";
    }

    @Override
    public String colorFondo() {
        return "Fona koloro (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "Teksta koloro (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "Butona koloro (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "Tekstokesta koloro (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "Ligila koloro (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "Konsoltitola koloro (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "Erara koloro (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "Averto-koloro (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "Informa koloro (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "Titola koloro (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "Ligila teksta koloro (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "Malfermu nur CrashDetector dum malsukceso";
    }

    @Override
    public String activar_parche() {
        return "Aktivigi flikon";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "Neniu solvo disponeblas";
    }

    @Override
    public String error() {
        return "eraro";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "Eraro dum forigo de Jar";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar sukcese forigita";
    }

    @Override
    public String exito() {
        return "sukceso";
    }

    @Override
    public String eliminar() {
        return "forigi";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "Eraro dum forigo de paka\u0135o";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "Paka\u0135o sukcese forigita";
    }

    @Override
    public String eliminar_paquete() {
        return "Forigi paka\u0135on";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "Neniu mod kun paka\u0135o trovita";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "Ne eblas forigi la paka\u0135on";
    }

    @Override
    public String eliminar_jar() {
        return "Forigi Jar";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "Neniu duobligita mod trovita";
    }

    @Override
    public String archivo_no_encontrado() {
        return "Dosiero ne trovita";
    }

    @Override
    public String directorio_eliminado() {
        return "Dosierujo forigita";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "Eraro dum forigo de enigita Jar";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "Interna dosiero ne trovita";
    }

    @Override
    public String archivo_eliminado() {
        return "dosiero forigita";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "eraro dum forigo de dosiero";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "nevalida ekstera dosiero";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "Mod-elemento forigita";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "Eraro dum anstata\u016digo de ekstera Jar";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "eraro dum forigo de mod-elemento";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "eraro dum forigo de dosierujo";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "nevalida formato por enigita Jar";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "enigita Jar forigita";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "eraro dum purigo de provizoraj dosieroj";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Fina fatale spurmesa\u011do (Ne tradukita):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Fina spurmesa\u011do (Ne tradukita):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "Vi povas ser\u0109i en la datumbazo WaifuNeoForge por trovi kromprogramojn. Elektu la ludversion, mod\u015dar\u011dilon kaj klason. Uzu la plej similan kombina\u0135on. Vi povas ser\u0109i nur unufoje en unu minuto.";
    }

    @Override
    public String solucionFaltasClases() {
        return "Vi povas ser\u0109i en la datumbazo WaifuNeoForge por trovi kromprogramojn. Elektu la ludversion, mod\u015dar\u011dilon kaj klason. Uzu la plej similan kombina\u0135on. Vi povas ser\u0109i nur unufoje en unu minuto.";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "Amba\u016d lan\u0109iloj havas la \u011dustajn versiojn de Java, sed ne \u0109iujn; vi povas instali la \u011dustan version de Java per la paka\u0135administrilo en via sistemo a\u016d per la butonoj.";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Modo kun Mankanta Animo: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException (Eraro pri Mankanta Elemento) Mankas Animo";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "Ne trovis modojn por forigi";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "Anstata\u016di konfliktantajn GC-opciojn per -XX:+UseG1GC";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "Pligrandigu la grandon de la heap-memoro uzante la opcio -Xmx.";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "Pligrandigu la grandon de la permgen-memoro uzante la opcio -XX:MaxPermSize.";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "Uzu 64-bitan JVM por pliigi la haveblan memoron.";
    }

    @Override
    public String optimizarCodigo() {
        return "Optimizu la kodon por malpliigi la memoruzadon kaj plibonigi la efikecon.";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "Uzu efikan rubobruligon por malpliigi la pa\u016dzojn en la aplika\u0135o.";
    }

    @Override
    public String modulos() {
        return "Moduloj";
    }

    @Override
    public String paquete() {
        return "Paka\u0135o";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "Manqas kelkaj ID-oj. Komunaj kialoj estas mankantaj modoj a\u016d datumoj pri objektoj. Komunaj datumbibliotekoj estas datafiedcontents/ kaj kubejs/ a\u016d aliaj mod-bibliotekoj.";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "malbone mapitaj registri\u011doj";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo 'AuthMe' ne sukcesis \u015dargi kaj haltigis la servilon.</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "Problemo pri haltigo pro AuthMe";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "La regulo 'stopServer' \u015dan\u011dis al 'true'.";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "Agordu la kromprogramon AuthMe (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "Instalu alian version de la kromprogramo 'AuthMe'";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "Forigu la kromprogramon 'AuthMe'";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La mondo '" + nombreMundo + "' ne povis \u015dargi \u0109ar \u011di enhavas erarojn kaj ver\u015dajne estas difektita.</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "Problemeco pri \u015dar\u011do de Multiverse-mondo";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "Riparu la mondo '" + nombreMundo + "', ekzemple per Minecraft Region Fixer a\u016d MCEdit.";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "Forigu la dosierujon de la mondo '" + nombreMundo + "'.";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La agordo de la kromprogramo 'PermissionsEx' estas nesprava.</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "Agordoproblemo de PermissionsEx";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "Agordu la kromprogramon PermissionsEx (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "Forigu la kromprogramon 'PermissionsEx'";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Estas pluraj kromprogramdosieroj kun la nomo '" + nombrePlugin + "': '" + primerPath + "' kaj '" + segundoPath + "'.</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "Nepreciza kromprogramnomo";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "Forigu la kromprogramon '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Okazis escepto dum la mondo \u015dargis chunk-ojn. Se \u011di ekzistas por via platformo, eble FeatureRecycler povas solvi la problemon. https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "Eraro dum \u015dar\u011dado de chunk-oj";
    }

    @Override
    public String solucionEliminarChunk() {
        return "Forigu la probleman chunk-on de la mondo, ekzemple per MCEdit a\u016d forigante la regionan dosieron.";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' ne povas plenumi la komandon '/" + comando + "'.</b> ";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "Eraro dum plenumo de kromprogramkomando";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "Instalu diferenan version de la kromprogramo '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' bezonas la dependecon '" + dependencia + "'.</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' mankas jenajn dependecojn: " + deps.toString() + ".</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "Mankanta kromprogramdependeco";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "Instalu la kromprogramon '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' postulas API-version '" + versionAPI + "' kiu ne estas kongrua kun la nuna servilo.</b> ";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "Nekongrua API-versio";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "Instalu version '" + version + "' de via servila programaro.";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La mondo '" + nombreMundo + "' estas duplikato de alia mondo kaj ne povas esti \u015dargita.</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "Duplikata mondo";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "Forigu la dosieron 'uid.dat' en la mondo '" + nombreMundo + "'";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "Forigu la mondodossieron '" + nombreMundo + "'";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La bloka ento '" + nombre + "' de tipo '" + tipo + "' je la koordinatoj " + coords + " ka\u016dzas erarojn dum takto.</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "Erara bloka ento";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "Forigu la enton '" + nombre + "' je la koordinatoj " + coords + " per MCEdit a\u016d rekte en la mondo.";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombreMod + "' havas plurajn versiojn instalitajn.</b> ";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "Duplikita kromprogramo en Fabric";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "Forigu la duplikitan kromprogramdosieron: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramoj '" + primerMod + "' kaj '" + segundoMod + "' ne estas reciproke kongruaj.</b> ";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "Nekongrua kromprogramo en Fabric";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "Forigu la kromprogramon '" + nombreMod + "'";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombreMod + "' havas gravan eraron kaj ne povas ruli.</b> ";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "Kromprogramo kun grava eraro";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Jenaj kromprogramoj estas bezonataj sed mankas: " + deps.toString() + ".</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombreMod + "' postulas la kromprogramon '" + dependencia + "' kiel dependecon.</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombreMod + "' postulas la kromprogramon '" + dependencia + "' en versio " + version + ".</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "Mankanta kromprogramdependeco";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "Instalu la kromprogramon '" + nombreMod + "'";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "Instalu la kromprogramon '" + nombreMod + "' kun versio " + version;
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' ne kongruas kun la regiona takto de Folia.</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj kromprogramoj ne kongruas kun la regiona takto de Folia: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "Kromprogramo nekongrua kun regiona takto";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "Instalu version sen regiona takto, ekzemple " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Manko de mod '" + nombreMod + "' en la datumasko.</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj modoj mankas en la datumasko: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" kaj ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "Modo mankanta en datumasko";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombreMod + "' ka\u016dzis eraron.</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj kromprogramoj ka\u016dzis erarojn: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" kaj ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "Forge-kromprogramo kun Eraro";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "Instalu alian version de la kromprogramo '" + nombreMod + "'";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombreMod + "' ne estas kongrua kun Minecraft versio " + versionMC + ".</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj kromprogramoj ne estas kongruaj kun iliaj Minecraft-versioj: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (Minecraft ").append(versionesMC.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "Ne kongrua kromprogramo kun Minecraft";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "Instalu Forge-version kongruan kun Minecraft " + versionMC;
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombreMod + "' mankas kaj necesas por \u015dargi la mondon a\u016d kromprogramon.</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "Mankanta kromprogramo";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La mondo estis konservita kun kromprogramo '" + nombreMod + "', kiu nun mankas.</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("La mondo estis konservita kun jenaj kromprogramoj, kiuj nun mankas: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" kaj ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "Mankanta kromprogramo en la mondo";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La mondo estis konservita kun kromprogramo '" + nombreMod + "' versio " + versionEsperada + ", sed nun estas uzata versio " + versionActual + ".</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj kromprogramoj havas versiodiferencojn en la konservita mondo: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" kaj ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (Konservita: ").append(versionesEsperadas.get(i)).append(", Nuntempa: ").append(versionesActuales.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "Versia nekongruo de kromprogramo en konservita mondo";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi provis \u015dargi mondon kreitan per pli nova versio de Minecraft.</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "Klopodo \u015dargi mondon el pli nova versio";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "Instalu pli novan version de Minecraft.";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "Kreu novan mondon.";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' postulas jenan dependecon: '" + dependencia + "'.</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj kromprogramoj postulas neinstalitajn dependecojn: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("' (").append(dependencias.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "Kromprogramo kun mankanta dependeco";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' ne estas kongrua kun la nuna servila versio.</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj kromprogramoj ne estas kongruaj kun la nuna servila versio: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" kaj ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "Nekongrua kromprogramo kun PocketMine-MP";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La kromprogramo '" + nombrePlugin + "' ka\u016dzis eraron dum plenumo.</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Jenaj kromprogramoj ka\u016dzis erarojn dum plenumo: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" kaj ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "Kromprogramo kun rultempa eraro";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "Multobla hilo en LegacyRandomSource";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Kelkaj hiloj aliras la klason LegacyRandomSource samtempe. Por pluaj informoj, uzu la modon 'Unsafe World Random Access Detector' a\u016d 'C2ME'.</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "Ekde lasta sukceso";
    }

    @Override
    public String noHayCambios() {
        return "Neniu \u015dan\u011do";
    }

    @Override
    public String desdeUltimoIntento() {
        return "Ekde lasta provo";
    }

    @Override
    public String fallo() {
        return "Malsukcesis";
    }

    @Override
    public String diferentesDeLasMods() {
        return "Malsama de la kromprogramoj";
    }

    @Override
    public String historialDeMods() {
        return "Mod-historio";
    }

    @Override
    public String archivo0() {
        return "Dosiero0";
    }

    @Override
    public String archivo1() {
        return "Dosiero1";
    }

    @Override
    public String comparar() {
        return "Kompari";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "Elektu du dosierojn";
    }

    @Override
    public String archivoExito() {
        return "Sukcesa dosiero";
    }

    @Override
    public String archivoFalla() {
        return "Fiaska dosiero";
    }

    @Override
    public String errorComparandoArchivos() {
        return "Eraro dum komparo de dosieroj";
    }

    @Override
    public String comparando() {
        return "Komparante";
    }

    @Override
    public String con() {
        return "kun";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'><p><b>Panelo por MOD-historia komparo</b></p><p>Tiu \u0109i panelo ebligas al vi kompari du listojn de MOD-oj el diversaj sesioj. Elektu unu dosieron el la maldekstra kolumno kaj alian el la dekstra por vidi \u015dan\u011dojn inter amba\u016d versioj.</p><h3>Kiel uzi:</h3><ol><li><b>Dosierselektado:</b> Klaku la radiobutonojn apud la dosiernomoj. Dosieroj finitaj per <span style='color: #4CAF50; font-weight: bold;'>.exito</span> indikas sukcesajn sesiojn, dum tiuj kun <span style='color: #F44336; font-weight: bold;'>.falla</span> montras fiaskojn.</li><li><b>A\u016dtomata komparo:</b> Premante butonon 'Kompari', la sistemo analizos la du listojn kaj montramos kiujn MOD-ojn oni aldonis (+) a\u016d forigis (-).</li><li><b>Rezultmontrado:</b> La rezultoj estas prezentitaj en HTML-kolora formato: <ul><li><span style='color: green;'>+ Aldonita MOD</span></li><li><span style='color: red;'>- Forigita MOD</span></li></ul></li></ol><h3>\u0108efaj funkcioj:</h3><ul><li>Subtenas ajnan kombina\u0135on de sukcesaj/malsukcesaj dosieroj.</li><li>Bidirektaj diferencoj por preciza sekvo de \u015dan\u011doj.</li><li>Rulumilo inkluzive por longaj MOD-listoj.</li><li>Integri\u011das kun klarigaj bildoj por plibonigi vidan komprenon.</li></ul><p>Evoluinta kun <3\ufe0f por helpi vin sekvi \u015dan\u011dojn en via agordo.</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eblas, ke vi havas problemon rilatantan al IPv6. Estas du solvoj: 1) Aldonu la JVM-argumenton <code>-Djava.net.preferIPv4Stack=true</code> al via lan\u0109ilo, a\u016d 2) Uzu la butonon 'QuickFix' en CrashDetector por apliki korekton, kiu a\u016dtomate \u015daltas tiun agordon.</b>";
    }

    @Override
    public String parcheIPv4() {
        return "IPv4/6 Korekto";
    }

    @Override
    public String carpetaHMCL() {
        return "HMCL Dosierujo (Nur por HelloMineCraftLauncher)";
    }

    @Override
    public String descripcionCurseforge() {
        return "Noto: Ne estas kreita loko se aktivigas \"Preterlasi Lan\u0109ilon\" en Agordoj > Minecraft";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/Deriva\u0135oj: Alklaku per dekstra butono sur la instanco kaj elektu \"Redakti Instancon\". En la malfermita fenestro ser\u0109u sekcion \"Minecraft-a loko\" a\u016d similan.<br>\u0108i tiuj lokoj enhavas norman eliron (STDOUT), kiu gravas por diagnozi erarojn.";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): Devus elekti la dosierujon kie HMCL estas instalita kaj trovi la dosierujon \".hmcl\". La HMCL-lokoj estas konservata tie kaj enhavas gravajn informojn pri eraroj.<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix: La lan\u0109ilo havas fakon por evoluo montranta detalan lokon. \u011cin trovu en la agorda menuo de la lan\u0109ilo.";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher: Ekzistas elireta fenestro kun lokoj. \u011ci havas butonojn por kopii kaj al\u015duti ilin. Lokoj estas generitaj a\u016dtomate dum ludo kaj enhavas gravajn diagnozajn informojn.";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher: Dekstre klaku sur la instanco kaj elektu \"Agordoj\". Poste iru al la loko-sekcio por vidi gravan informon el la norma eliro (STDOUT).";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "Markdown-ligiloj: Algluu ajnan Markdown-formatan ligilon al loko-tiedoj. La sistemo provos a\u016dtomate ekstrakti lokajn ligilojn (latest.log, launcher_log.txt, debug.log ktp.) kaj analizi ilin.";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "Loko de Lan\u0109ilo ne trovita";
    }

    @Override
    public String imagenNoEncontrada() {
        return "Bildo ne trovita";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "\u011cENERALA: Elektu la tipon de lan\u0109ilo kiun vi uzas. La loko-dosieroj de lan\u0109ilo (launcher_log.txt, stdout, ktp.) enhavas gravajn erarinformojn, kiujn latest.log ne montras. CrashDetector ne povas legi viajn loko-dosierojn \u2014 eble mankas loko-dosiero kaj vi devas alglui la lokon.<br>Por pli da informo, vidu <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">tiun problemon</a>. \u0108i tiuj lokoj enhavas la norman eliron (STDOUT) necesa por diagnozi multajn erartipojn.";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mankas klaso(j) el Create. Create multe \u015dan\u011dis \u2014 multaj klasoj estas forigitaj. \u0108efe ekde Create 6 (februaro 2025), aldona\u0135oj por pli fruaj versioj ne plu funkcias. QuickFix ne havas solvon por \u0109i tiu problemo. Vi devas \u011disdatigi viajn Create-aldona\u0135ojn, forigi malnovajn a\u016d uzi la \u011dustan Create-version por viaj dezirataj aldona\u0135oj.</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mankas klaso(j) el EpicFight. EpicFight multe \u015dan\u011dis \u2014 multaj klasoj estas forigitaj. QuickFix ne havas solvon por \u0109i tiu problemo. Vi devas \u011disdatigi viajn EpicFight-aldona\u0135ojn, forigi malnovajn a\u016d uzi la \u011dustan EpicFight-version por viaj dezirataj aldona\u0135oj.</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenJ9 \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f OpenJ9 \u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u591a\u304f\u306e\u30a2\u30d7\u30ea\uff08\u3053\u306e\u30a2\u30d7\u30ea\u3082\u542b\u3080\uff09\u306f JVM \u5b9f\u88c5\u306e\u9055\u3044\u306b\u3088\u308a OpenJ9 \u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002QuickFix \u3067\u306f\u3053\u306e\u554f\u984c\u3092\u81ea\u52d5\u7684\u306b\u89e3\u6c7a\u3067\u304d\u307e\u305b\u3093\u3002Oracle JDK\u3001OpenJDK Hotspot\u3001\u307e\u305f\u306f\u305d\u306e\u4ed6\u306e\u63a8\u5968\u4ee3\u66ff JDK \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3053\u306e\u30a2\u30d7\u30ea\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306f\u6b63\u5e38\u306b\u52d5\u4f5c\u3059\u308b\u305f\u3081\u306b Java 11 (JDK 11) \u304c\u5fc5\u8981\u3067\u3059\u3002\u73fe\u5728\u3001\u4e92\u63db\u6027\u306e\u306a\u3044\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Java \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002QuickFix \u3067\u306f Java \u306e\u30a2\u30c3\u30d7\u30b0\u30ec\u30fc\u30c9\u306f\u81ea\u52d5\u7684\u306b\u884c\u3048\u307e\u305b\u3093\u3002\u89e3\u6c7a\u7b56\u306b\u8a18\u8f09\u3055\u308c\u305f\u30ea\u30f3\u30af\u304b\u3089 JDK 11 \u307e\u305f\u306f\u305d\u308c\u4ee5\u4e0a\u306e\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30fb\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e1\u30e2\u30ea\u3092\u904e\u5270\u306b\u5272\u308a\u5f53\u3066\u3066\u304a\u308a\u3001\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u308c\u306f\u3001\u30b7\u30b9\u30c6\u30e0\u306e\u5b9f\u88c5\u5bb9\u91cf\u3092\u8d85\u3048\u308b RAM \u3092\u6307\u5b9a\u3057\u305f\u5834\u5408\u3084\u3001\u5927\u5bb9\u91cf\u30e1\u30e2\u30ea\u3092\u6271\u3048\u306a\u3044 32 \u30d3\u30c3\u30c8 JVM \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u3053\u306e\u554f\u984c\u3092\u89e3\u6c7a\u3059\u308b\u306b\u306f\u3001\u30a2\u30d7\u30ea\u306b\u5272\u308a\u5f53\u3066\u308b\u30e1\u30e2\u30ea\u91cf\u3092\u6e1b\u3089\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u63a8\u5968\u3055\u308c\u308b\u6700\u5927\u5024\u306f\u30b7\u30b9\u30c6\u30e0\u306b\u3088\u308a\u307e\u3059\u304c\u3001\u4e00\u822c\u7684\u306b\u5168 RAM \u306e 70\uff5e80\uff05\u3092\u8d85\u3048\u306a\u3044\u3088\u3046\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u300232 \u30d3\u30c3\u30c8 JVM \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u7269\u7406 RAM \u306e\u91cf\u306b\u95a2\u4fc2\u306a\u304f\u3001\u4e0a\u9650\u306f\u7d04 2\uff5e3 GB \u3067\u3059\u3002</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u30a2\u30d7\u30ea\u306b\u5272\u308a\u5f53\u3066\u3089\u308c\u305f\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u3092\u6e1b\u3089\u3059\u306b\u306f\u3001\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u8a2d\u5b9a\u3092\u958b\u304d\u3001RAM \u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u63a2\u3057\u307e\u3059\u3002\u6700\u5927\u5024 (Xmx) \u3092\u9069\u5207\u306a\u91cf\u306b\u4e0b\u3052\u3066\u304f\u3060\u3055\u3044\u3002\u4f8b\uff1a8GB \u306e RAM \u304c\u3042\u308b\u5834\u5408\u30013\uff5e4GB \u3092\u5272\u308a\u5f53\u3066\u307e\u3059\u300216GB \u306e\u5834\u5408\u30016\uff5e8GB \u304c\u9069\u5207\u3067\u3059\u3002OS \u3084\u4ed6\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u305f\u3081\u306b\u5341\u5206\u306a\u30e1\u30e2\u30ea\u3092\u6b8b\u3059\u3053\u3068\u3092\u5fd8\u308c\u306a\u3044\u3067\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Famas gravaj dosieroj de Forge. La dosiero '" + archivo + "' ne trovi\u011das en via instalo. Tio okazas kutime se la instalo de Forge \u0109esis a\u016d gravaj dosieroj forvi\u015di\u011dis. QuickFix ne povas denove trovi tiujn dosierojn a\u016dtomate. Vi devas reinstali Forge per la oficiala instalejo.</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge ne povas trovi la bezonatan version de Minecraft. Versio " + version + " estas bezonata sed ne trovi\u011das en dosiero '" + archivo + "'. Tio okazas se ekzistas nekongruo inter via Minecraft-versio kaj via Forge-versio. Certi\u011du, ke vi el\u015dutis la \u011dustan Forge-version por via Minecraft-versio.</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La celo 'fmlclient' bezonata por lan\u0109i Forge ne trovi\u011das. Tio indikas nekompletan a\u016d difektitan Forge-instalon. Eble gravaj dosieroj ne \u011duste instali\u011dis. Vi devas reinstali Forge per la oficiala instalejo.</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La \u0109efa Minecraft-klaso ne trovi\u011das en la klas\u015dar\u011dilo. Tio kutime indikas nekompletan Forge-instalon a\u016d konflikton kun aliaj kromprogramoj. Eble dosieroj de Minecraft difekti\u011dis dum la instalo. Vi devas reinstali Forge \u011duste.</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La Forge-instalo ne estas plena. Tio povas okazi pro interrompita instalo, forvi\u015ditaj dosieroj a\u016d nekongruo kun via Minecraft-versio. Forge bezonas specifajn dosierojn por funkcii, sed iuj el ili mankas nun.</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "Nekompleta Forge-instalo";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Por solvi tion, reinstalu Forge \u011duste. Certi\u011du pri la \u011dusta versio por via Minecraft-versio kaj plenumu la instalprocezon sen interrompo.</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "El\u015duti Forge Oficiale";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "Kiel Reininstali Forge \u011custe";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>Instrukcioj por Reininstali Forge:</h3><ol><li>El\u015dutu la \u011dustan Forge-instalejon el la oficiala retejo (rekomendita versio por via Minecraft)</li><li>Fermu vian Minecraft-lan\u0109ilon tute</li><li>\u0108erpu la Forge-instalejon kiel administranto</li><li>Elektu 'Installer' (ne 'Installer (run client)')</li><li>Elektu vian Minecraft-profilan dosierujon en la lan\u0109ilo</li><li>Premu 'OK' kaj atendu plenan instalon</li><li>Restartigu vian lan\u0109ilon kaj kontrolu ke Forge aperas en la profila listo</li></ol><p><b>Grava:</b> Se vi uzas \u0109efan lan\u0109ilon, certi\u011du ke vi elektis la \u011dustan profilan dosierujon.</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "Instrukcioj por Reininstali Forge";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro pri nesolvita ligilo: Malsukcesis \u015dargi bibliotekon " + nombreBiblioteca + ". Eblaj solvoj:<br/><br/>a) Aldonu la dosierujon kun la komuna biblioteko al -Djava.library.path a\u016d -Dorg.lwjgl.librarypath.<br/>b) Aldonu la JAR-dosieron kun la komuna biblioteko al la classpath.<br/><br/>Tiu eraro okazas kiam Minecraft ne povas trovi gravajn dosierojn por sia funkciado. \u011ci kutime okazas pro neprofunda instalo a\u016d permesaj problemoj de la sistemo.</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "Eraro pri nesolvita ligilo";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Malsukcesis \u015dargi bibliotekon. Eblaj solvoj:<br/><br/>a) Aldonu la dosierujon kun la komuna biblioteko al -Djava.library.path a\u016d -Dorg.lwjgl.librarypath.<br/>b) Aldonu la JAR-dosieron kun la komuna biblioteko al la classpath.<br/><br/>Tiuj teknikaj solvoj estas por spertaj uzantoj. Plej multaj uzantoj devus provi reinstali Minecraft anta\u016d ol \u015dan\u011di tiujn parametrojn.</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ID-Konflikto: La ID <strong>" + id + "</strong> jam okupita de <strong>" + modOrigen + "</strong> dum provo aldoni <strong>" + modDestino + "</strong>. Tio okazas kiam du kromprogramoj provas uzi la saman ID por malsamaj elementoj.</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La maksimuma permesita ID-\u011damo estas transpasita. Tio okazas kiam kromprogramoj provas registri blokojn a\u016d erojn kun ID-oj ekster la permesita \u0109irka\u016d\u0135eto por via Minecraft-versio.</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "ID-Konflikto";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Por solvi tion en Minecraft 1.12.2, instalu <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a>. Por 1.7.10, uzu <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a>.</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Uzu ilojn kiel <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> a\u016d <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a> por solvi ID-konfliktojn.</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "Instali JustEnoughIDs";
    }

    @Override
    public String instalar_endlessids() {
        return "Instali EndlessIDs";
    }

    @Override
    public String usar_idfix_minus() {
        return "Uzi IdFix Minus a\u016d IdFix";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "Uzi Minecraft-ID-Resolver";
    }

    @Override
    public String ver_documentacion_jp() {
        return "Vidi la japanan dokumenton";
    }

    @Override
    public String escanearDeMCreator() {
        return "Skani MCreator";
    }

    @Override
    public String tituloArbolDeMods() {
        return "Modula kaj Klasa Arbo";
    }

    @Override
    public String tipoBusqueda() {
        return "Tipo";
    }

    @Override
    public String filtroTodos() {
        return "\u0108iuj";
    }

    @Override
    public String filtroPaquetes() {
        return "Paka\u0135oj";
    }

    @Override
    public String filtroClases() {
        return "Klasoj";
    }

    @Override
    public String filtroMetodos() {
        return "Metodoj";
    }

    @Override
    public String filtroCampos() {
        return "Kampoj";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "Referencoj de kampo";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "Referencoj de metodo";
    }

    @Override
    public String filtroReferenciasClase() {
        return "Referencoj de klaso";
    }

    @Override
    public String tipBuscar() {
        return "Tajpu \u0109i tie por ser\u0109i en la modarbo";
    }

    @Override
    public String botonBuscar() {
        return "Ser\u0109i";
    }

    @Override
    public String botonResetearArbol() {
        return "Re\u015dargi arbon";
    }

    @Override
    public String modsCargados() {
        return "\u015car\u011ditaj modoj";
    }

    @Override
    public String clases() {
        return "Klasoj";
    }

    @Override
    public String metodos() {
        return "Metodoj";
    }

    @Override
    public String campos() {
        return "Kampoj";
    }

    @Override
    public String referencias() {
        return "Referencoj";
    }

    @Override
    public String resultadosBusqueda() {
        return "Ser\u0109rezultoj";
    }

    @Override
    public String buscarReferencias() {
        return "Ser\u0109i referencojn";
    }

    @Override
    public String referenciasMod() {
        return "Referencoj de mod";
    }

    @Override
    public String referenciasClase() {
        return "Referencoj de klaso";
    }

    @Override
    public String referenciasMetodo() {
        return "Referencoj de metodo";
    }

    @Override
    public String referenciasCampo() {
        return "Referencoj de kampo";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "Neniu referenco trovita";
    }

    @Override
    public String detalleMod() {
        return "Detaloj de mod:";
    }

    @Override
    public String ubicacion() {
        return "Loko";
    }

    @Override
    public String nombres() {
        return "Nomoj";
    }

    @Override
    public String modulo() {
        return "Modulo";
    }

    @Override
    public String detalleClase() {
        return "Detaloj de klaso:";
    }

    @Override
    public String detalleMetodo() {
        return "Detaloj de metodo:";
    }

    @Override
    public String detalleCampo() {
        return "Detaloj de kampo:";
    }

    @Override
    public String clase() {
        return "Klaso";
    }

    @Override
    public String tipo() {
        return "Tipo";
    }

    @Override
    public String referenciasAMetodos() {
        return "Referencoj al metodoj:";
    }

    @Override
    public String referenciasACampos() {
        return "Referencoj al kampoj:";
    }

    @Override
    public String arbolDeMods() {
        return "Modarbo";
    }

    @Override
    public String metodo() {
        return "Metodo";
    }

    @Override
    public String campo() {
        return "Kampo";
    }

    @Override
    public String descompilar() {
        return "Malkomposti";
    }

    @Override
    public String exportar() {
        return "Eksporti";
    }

    @Override
    public String importar() {
        return "Importi";
    }

    @Override
    public String errorImportar() {
        return "Importa Eraro";
    }

    @Override
    public String estructuraImportada() {
        return "Strukturo Importita";
    }

    @Override
    public String estructuraExportada() {
        return "Strukturo Eksporita";
    }

    @Override
    public String errorExportar() {
        return "Eksporta Eraro";
    }

    @Override
    public String exportando() {
        return "Eksporatas";
    }

    @Override
    public String exportacionTardara() {
        return "Eksporo povas da\u016dri iom da tempo";
    }

    @Override
    public String porFavorEspere() {
        return "Bonvolu atendi";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Vi ne havas la VLC-binarojn. WaterMedia bezonas la VLC-binarojn. Vi devas instali ilin mane el https://www.videolan.org/vlc/.  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "El\u015duti VLC";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro: La modula nomo '" + nombreModulo + "' enhavas nevalidajn signojn. La parto '" + parteInvalida + "' ne estas valida Java-identigilo. Tio okazas kiam mod uzas rezervitajn vortojn de Java (kiel 'true', 'class') a\u016d nepermesitajn signojn en sia nomo.</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "Nevalidaj Signoj en Modnomo";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "La modnomo '" + nombreModulo + "' estas nevalida \u0109ar \u011di enhavas '" + parteInvalida + "', kiu estas rezervita vorto de Java a\u016d nepermesita signo. Ser\u0109u en la protokoloj kiun modon \u0109i tiu nomo reprezentas (plejofte la nomo de la JAR-dosiero)";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "Iru al la dosierujo de la mod kaj redaktu la dosieron <b>mods.toml</b> ene de la dosierujo <b>/META-INF/</b>. \u015can\u011du la valoron de <b>modId</b> por uzi nur literojn, ciferojn kaj substrekojn, sen Java-rezervitaj vortoj";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "Ekzemplo de valida nomo: 'truemod_shot_enchantment' anstata\u016d 'true.shot.enchantment'. Memoru ke modnomoj ne povas enhavi punktojn, strekojn a\u016d Java-rezervitajn vortojn kiel 'true', 'false' a\u016d 'class'";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro kun la mod: '" + nombreJar + "'. Mankas la deviga kampo 'mandatory' en \u011diaj dependoj. Tio okazas kiam la dosiero mods.toml ne specifas \u0109u dependo estas deviga.</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "Moddependeco sen Mankanta Deviga Kampo";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "La problemeca mod estas: <b>" + nombreJar + "</b>. \u0108i tiu dosiero havas eraron en sia dependeca agordo";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "Malfermu la dosieron <b>mods.toml</b> ene de la dosierujo <b>/META-INF/</b> de la mod <b>" + nombreJar + "</b>";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "En la dependecoj sekcio, certi\u011du ke \u0109iu enigo inkludu <b>mandatory=true</b> a\u016d <b>mandatory=false</b> (ekz: modId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" )";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro \u0109e la mod: '" + nombreJar + "'. Nevalida konfiguro de access transformer. Tio okazas kiam la konfigura dosiero havas mal\u011dustan sintakson a\u016d referencojn al neekzistantaj klasoj/metodoj.</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "Nevalida Access Transformer";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "La problemeca mod estas: <b>" + nombreJar + "</b>. \u0108i tiu mod enhavas nevalidan konfiguron de access transformer";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "Malfermu la dosieron <b>accessTransformer.cfg</b> ene de la mod <b>" + nombreJar + "</b> (plejofte en la \u0109efa dosierujo de la JAR-dosiero)";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "\u011custigu la sintakson de la access transformer. Linioj devas sekvi la formaton: <b>access class.method</b> (ekz: public net.minecraft.world.entity.Entity.func_200560_a). Forigu liniojn kiuj referencas klason a\u016d metodon kiuj ne ekzistas en via Minecraft-versio";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro: Malsameco inter la mod-ID en la @Mod notacio kaj la dosiero mods.toml. La mod '" + nombreMod + "' ne povas \u015dargi\u011di \u0109ar la ID-oj ne samas.</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "Malsameco inter @Mod kaj mods.toml";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "La en-disvolvi\u011danta mod '" + nombreMod + "' havas malsamecon inter la ID en la <b>@Mod</b> notacio kaj la valoro en <b>mods.toml</b>";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "Certigu ke via \u0109efa klaso havas saman ID-on kiel la <b>modId</b> valoro en la dosiero <b>/META-INF/mods.toml</b>. Ekzemple: <b>@Mod(\"mymod\")</b> devas sami kun <b>modId=\"mymod\"</b>";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "Se vi uzas Gradle, rulu <b>clean</b> post \u015dan\u011doj por certigi ke la rimedoj aktualas\u011du \u011duste. Foje malnovaj dosieroj restas en la build dosierujo";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "kliento" : "servilo";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "servilo" : "kliento";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro: Prenas \u015dargi klason '" + nombreClase + "' en la " + plataforma + " medion, sed \u011di estas dizajnita por " + plataformaOpuesta + ". <b>Uzu la funkcion 'Modarbo' en la flanko\u015dranko por trovi kiun modon provas \u015dargi tiun klason</b>. Modoj estas konstruitaj specife por unu platformo kaj ne funkcias en la alia.</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "Modo en Mal\u011dusta Platformo";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "En la langeto <b>Modarbo</b> (dekstre), ser\u0109u referencojn al la klaso <b>" + nombreClase + "</b> por identigi kiun modon ka\u016dzas la problemon";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "kliento" : "servilo";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "servilo" : "kliento";
        return "La identigita mod estas <b>" + plataformaOpuesta + "</b> mod kiu ne devas uzi\u011di en via " + plataforma + " medio.";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "Forigu la probleman modon el via dosierujo <b>modoj</b>. Se vi bezonas similan funkciecon por tiu platformo, ser\u0109u alternativan modon specife dizajnitan por <b>kliento</b> a\u016d <b>servilo</b> la\u016dbezone";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Grava eraro: Mankas metadatenoj por modid '").append(modIdFaltante).append("'. ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("Jenaj modoj povas ka\u016dzi la problemon: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", kaj aliaj...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Tio okazas kiam mod dependas de alia mod neinstalita a\u016d kun mal\u011dusta dosiero mods.toml.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "Mankas Metadatenoj de mods.toml";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("Jenaj modoj dependas de '").append(modIdFaltante).append("': <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", kaj aliaj...");
            }
            paso.append("</b>. Uzu la funkcion <b>Modarbo</b> por konfirmi kiun modon ka\u016dzas la problemon");
            return paso.toString();
        }
        return "Mod provas dependi de '".concat(modIdFaltante).concat("', sed tiu mod ne estas instalita. Uzu la funkcion <b>Modarbo</b> por identigi kiun modon ka\u016dzas la problemon");
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "Vi havas du elektojn:<br/>" + "1. <b>Instalu la mankantan modon</b>: Ser\u0109u kai instalu la modon kun ID '".concat(modIdFaltante).concat("'<br/>") + "2. <b>Forigu la dependan modon</b>: Se vi ne bezonas la funkcion, forigu la modon kiun dependas de '".concat(modIdFaltante).concat("'");
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "Se '".concat(modIdFaltante).concat("' estas biblioteko (kiel 'forge', 'minecraft', 'curios'), ") + "certigu ke vi havas la \u011dustajn versiojn de Minecraft kaj Forge instalitajn. Se estas regula mod, kontrolu \u0109e sia el\u015duta pa\u011do la anta\u016dajn postulojn.";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Averto: Malsukcesis lan\u0109i sonan sistemon. Sonoj kaj muziko estas malebligitaj. \u0108i tiu eraro kutime rilatas al la aldona\u0135o SoundPhysicsMod kaj povas okazi pro konfliktoj kun aliaj sonaj bibliotekoj.</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "Eraro en Sona Sistemo";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "La eraro kutime rilatas al <b>SoundPhysicsMod</b>. Kontrolu \u0109u vi havas la plej novan version kompatan kun via Minecraft versio";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "Se vi uzas aliajn sonajn aldona\u0135ojn (kiel Sound Filters, Dynamic Surroundings, ktp.), provu dumtempe forigi SoundPhysicsMod por vidi \u0109u tio solvas la konflikton";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "Ekzameni la dosierujon <b>logs</b> por trovi pliajn mesa\u011dojn rilatajn al LWJGL a\u016d OpenAL, kiuj povas indiki problemojn kun subaj sonaj bibliotekoj";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Grava eraro: La klaso '").append(nombreClase).append("' estas registrita kiel eventa a\u016dskultanto sed ne enhavas validajn metodojn. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u0108i tiu klaso trovi\u011das en jenaj aldona\u0135oj: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", kaj aliaj...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Tio okazas kiam klason oni registras por a\u016dskulti eventojn sed \u011di ne havas metodojn kun @SubscribeEvent marko.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "Klaso Registrita Sen Eventaj A\u016dskultantoj";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("La problemeca klaso trovi\u011das en \u0109i tiuj aldona\u0135oj: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", kaj aliaj...");
            }
            paso.append("</b>. \u0108i tiuj aldona\u0135oj provas registri eventojn sen validaj metodoj");
            return paso.toString();
        }
        return "La klaso <b>" + nombreClase + "</b> estis registrita por a\u016dskulti eventojn sed ne enhavas metodojn kun marko <b>@SubscribeEvent</b>. Uzu la funkcion <b>Modarbo</b> por identigi kiun aldona\u0135on enhavas \u0109i tiun klason";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "En la fontkodo, certigu ke la klaso <b>" + nombreClase + "</b> enhavu almena\u016d unu metodon kun: <b>@SubscribeEvent public void nomoDeMetodo(SpecifaEvento evento) { ... }</b>. Se estas ena klaso, certigu ke \u011di ne estas markita kiel static";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("Por la identigitaj aldona\u0135oj (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", ktp.");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("kontaktu la programiston de \u0109i tiu aldona\u0135o por ripari la problemon. ");
            } else {
                paso.append("kontaktu la programistojn de \u0109i tiuj aldona\u0135oj por ripari la problemon. ");
            }
        }
        paso.append("Se vi estas programisto, forigu la registron de \u0109i tiu klaso en la EventBus a\u016d aldonu validajn @SubscribeEvent metodojn");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro: Okazis escepto 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' dum prilaborado de la dosiero '" + nombreArchivo + "'. \u0108i tiu specifa eraro indikas ke la lan\u0109ilo malsukcesis \u011duste el\u015duti a\u016d elpaketi la dosierojn de la modopako. La mesa\u011do 'zip END header not found' montras ke la JAR-dosiero estas neprofunda a\u016d difektita, kio estas tre ofta \u0109e lan\u0109iloj kiuj malbone prilaboras grandajn dosierojn. \u0108i tiu problemo \u0109efe tu\u015das uzantojn de Twitch/CurseForge, Technic Launcher, kaj precipe Luna Pixel, \u0109ar tiuj lan\u0109iloj ofte malsukcesas kontroli la plenan integrecon de el\u015dutitaj dosieroj. Uzantoj de Luna Pixel devus konsideri ATLauncher kiel pli stabilan alternativon, kiu pli bone prilaboras dosierajn integrecojn kaj evitas \u0109i tiun eraron. La sistemo ne povas \u015dargi la modojn \u0109ar la ZIP-formo estas difektita, malebligante al Forge legi la necesajn rimedojn por komenci la ludon.</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "UnionFileSystem Eraro - Difektita Dosiero";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "Komplete reinstalu la modopakon el komenco";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "Se vi uzas Luna Pixel, \u015dan\u011du al ATLauncher";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "Kontrolu vian interretan konekton kaj diskospacon anta\u016d ol reinstali";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "\u0108u ebligi ProxySysOutSysErr?\n\n\u0108i tiu opcio donas al CrashDetector aliron al System.out kaj System.err kiam la lan\u0109ilo ne provizas logojn.\n\n\u011ci nur devus esti ebligita se vi ne povas alglui registron mane.\n\nAverto: \u0108i tio povas interferi kun iuj aldona\u0135oj a\u016d lan\u0109iloj.\n\nNecesas restarti la ludon/aplikon por ke la \u015dan\u011doj efektivi\u011du.";
    }

    @Override
    public String confirmacionTitulo() {
        return "Konfirmo";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr sukcese ebligita.\n\nNecesas restarti CrashDetector por ke la \u015dan\u011doj efektivi\u011du.";
    }

    @Override
    public String informacionTitulo() {
        return "Informo";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("Grava eraro: AzureLib kaj GeckoLib frue \u0109ifis! ");
        } else if (azureLibError) {
            mensaje.append("Grava eraro: AzureLib frue \u0109ifis! ");
        } else if (geckoLibError) {
            mensaje.append("Grava eraro: GeckoLib frue \u0109ifis! ");
        }
        mensaje.append("Tiu eraro okazas kiam oni provas uzi Fabric aldona\u0135ojn per ne-Fabric versioj de tiuj bibliotekoj. ");
        if (connectorPresente) {
            mensaje.append("Kompateca aldona\u0135o (Sinytra Connector a\u016d specialcompatibilityoperation) estis detektita, kio indikas ke vi provas ruli Fabric aldona\u0135ojn en Forge a\u016d FeatureCreep medion. ");
            mensaje.append("Rigardu la 'FabricMC komenca eraro' en la protokoloj por trovi kiun precizan aldona\u0135on ka\u016dzas la problemon. ");
        }
        mensaje.append("AzureLib kaj GeckoLib estas esencaj por animaciaj aldona\u0135oj, sed ili devas kongrui kun la \u011dusta platformo (Fabric a\u016d Forge). ");
        mensaje.append("La ludo ne povas bone \u015dargi animaciajn aldona\u0135ojn pro tiu komenca konflikto.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "Biblioteko Komencis Tro Frue";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "Rigardu la eraron 'FabricMC komenca eraro' en la protokoloj por trovi la probleman aldona\u0135on";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "Certigu ke vi uzas la \u011dustan version de AzureLib/GeckoLib por via platformo (Forge a\u016d Fabric)";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro: Malkongrueco inter C2ME kaj konektecaj aldona\u0135oj. Tiu eraro okazas \u0109ar C2ME provas aliri internajn Java komponantojn kiuj estas limigitaj en medioj kun Sinytra Connector a\u016d specialcompatibilityoperation a\u016d aliaj Fabric/Forge kompatiblaj aldona\u0135oj. <b>C2ME ne estas kompatibla kun tiuj medioj, sed <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> estas la rekomendita anstata\u016da\u0135o</b> kiu bone funkcias kun konektecaj aldona\u0135oj. La ludo ne povas lan\u0109i\u011di pro Java sekurecaj permesaj konfliktoj.</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "C2ME Malkongrueco kun Konektecaj Aldona\u0135oj";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "Forigu C2ME el via dosierujo de aldona\u0135oj";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "El\u015dutu kai instalu <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> anstata\u016de (kompatibla kun Sinytra Connector)";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "Certigu ke \u0109iuj konektecaj aldona\u0135oj (kiel Sinytra Connector) estas \u011disdatigitaj al sia plej nova versio";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Grava eraro: Malsukcesis \u015dargi JEI-pluginon por la aldona\u0135o '" + modId + "'. La klaso '" + nombreClase + "' (plugin-ID: '" + pluginId + "') \u0109ifaris eraron ka\u016dzan de \u0135etas\u011do dum lan\u0109o. Tiu problemo okazas kiam aldona\u0135o havas nekompatiblan a\u016d difektitan JEI-integron kiun \u0109esigas la komencan inicialigon.</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "Malsukcesa JEI-plugin - Ka\u016dzas \u0135etas\u011don";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "La aldona\u0135o <b>" + modId + "</b> enhavas difektitan JEI-pluginon ka\u016dzan de la \u0135etas\u011do. Uzu la funkcion <b>Mod-Arbo</b> por konfirmi kiun aldona\u0135on ka\u016dzas la problemon";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "Tempe forigu la aldona\u0135on <b>" + modId + "</b> el via aldona\u0135dosierujo por kontroli \u0109u tio solvas la \u0135etas\u011don";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "Ser\u0109u \u011disdatigojn por la aldona\u0135o <b>" + modId + "</b> a\u016d kontaktu \u011dian programiston pri la JEI-plugin problemo. Dume, la aldona\u0135o devas esti forigita por povi lan\u0109i la ludon";
    }

    @Override
    public String tituloLectador() {
        return "Legilo de \u0134urnaloj - Detektilo de \u0134etas\u011doj";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "KOLORKLAVO";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "Gravaj eraroj";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "Stakspuroj";
    }

    @Override
    public String obtenerTituloError() {
        return "Eraro";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "Okazis eraro dum prilaborado de la elektita linio";
    }

    @Override
    public String obtenerNombreError() {
        return "NOMO DE ERARO";
    }

    @Override
    public String obtenerDescripcionError() {
        return "DETALA PRISKRIBO";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "ELEKTU \u0134URNAOLON";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "Nerilata eraro";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "Grava eraro detektita en la \u0135urnaloj. Bonvolu ekzameni la stakspuron por trovi la \u0109efan ka\u016dzon.";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "Ne povis legi la \u0135urnalan dosieron. Bonvolu kontroli, \u0109u la dosiero ekzistas kaj havas legrajtojn.";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "\u0134urnala Analizilo";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Grava eraro: Malsukcesis registri a\u016dtomatajn eventajn abonantojn por la aldona\u0135o '").append(modId).append("'. ");
        mensaje.append("Problemeca klaso: <b>").append(nombreClase).append("</b>. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u0108i tiu klaso trovi\u011das en: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", kaj aliaj...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Tiu eraro okazas kiam aldona\u0135o provas a\u016dtomate registri klason kiel eventan abonanton, sed la klaso ne povas esti \u015dargita. ");
        mensaje.append("<b>Ekzamenu aliajn erarojn en la protokolo, \u0109ar la vera ka\u016dzo povas esti anta\u016da malsukcesa \u015dargo</b>.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "Malsukceso \u0109e Registro de A\u016dtomataj Abonantoj";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "La aldona\u0135o <b>" + modId + "</b> provas registri la klason <b>" + nombreClase + "</b> kiel a\u016dtomatan abonanton, sed malsukcesis. Kontrolu \u0109u \u0109i tiu klaso ekzistas kaj alireblas";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("La problemeca klaso <b>" + nombreClase + "</b> trovi\u011das en \u0109i tiuj dosieroj: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", kaj aliaj...");
            }
            paso.append("</b>. ");
            paso.append("Uzu la funkcion <b>Modarbo</b> por konfirmi en kiun dosieron estas la problemeca klaso");
            return paso.toString();
        }
        return "La klaso <b>" + nombreClase + "</b> ne trovi\u011das en iu ajn aldona\u0135a dosiero. Kontrolu \u0109u la aldona\u0135o <b>" + modId + "</b> estas \u0109eeste instalita. Uzu la funkcion <b>Modarbo</b> por helpi trovi la problemon";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "\u011cisdatigu la aldona\u0135on <b>" + modId + "</b> al la plej nova versio kompatibla kun viaj versioj de Minecraft kaj Forge. Se la problemo da\u016dras, kontaktu la ellaboranton de la aldona\u0135o kiu raportas la eraron per la problemeca klaso";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "Ekzamenu <b>aliajn erarojn en la protokolo</b> anta\u016d ol \u0109i tiu mesa\u011do, \u0109ar la vera problemo povas esti anta\u016da malsukcesa \u015dargo. Iomatempe anta\u016da eraro malebligas \u015dargi necesajn klasojn por eventa registro";
    }

    @Override
    public String limpiado() {
        return "Purigite";
    }

    @Override
    public String original() {
        return "Originala";
    }

    @Override
    public String verEnConsola() {
        return "Vidi en \u0135urnalo";
    }

    @Override
    public String advertencia() {
        return "Averto";
    }

    @Override
    public String fatal() {
        return "Fatale";
    }

    @Override
    public String noRegistroDeBattly() {
        return "BattlyLauncher ne havas registron a\u016d konzolon por kopii. Vi povas uzi ProxySysOutSysErr por interkapti STDOUT kaj STDERR kai restarti la ludon, sed ProxySysOutSysErr povas malboni kun aldona\u0135oj kiuj modifas STDOUT a\u016d STDERR";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "Vi devas ebligi sencivan re\u011dimon en la agordo de NightWorld por ricevi lan\u0109an registron. Tio estas tre grave, precipe \u0109ar inkluzivas STDOUT kaj STDERR";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "Vi devas konservi a\u016d alglui la enhavon de via servila terminalo, \u0109ar \u011di enhavas informon ne trovitan en aliaj logoj, inkluzive de STDOUT, STDERR kai aliajn erarojn. Bonvolu alglui la enhavon de via lasta sesio. Por estonteco, vi povas savu la terminalan eligon al dosiero cd_launcherlog. Por eviti algluon, aldonu >> cd_launcherlog post via komenco-komando, kiel montrite sur la bildo. Rimarku ke tio malebligos videblon en la terminalo; nur videblas en tiu dosiero post tio.";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("Grava eraro: LexForge-transformilo detektita en NeoForge-medio. ");
        sb.append("</b>");
        sb.append("Rilata klaso: <b>").append(claseReceptora).append("</b>. ");
        sb.append("La influita interfaceto estas <b>").append(interfazObjetivo).append("</b>, ");
        sb.append("kaj mankas la metodo <b>").append(firmaMetodoFaltante).append("</b>. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("La klaso trovi\u011dis en: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", ktp...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("Neniu JAR-dosiero enhavas tiun klason; \u011di povas esti \u015dancelita a\u016d inkludita kiel jar-en-jar. ");
        }
        sb.append("Tiu malsukceso okazas kiam transformilo/afero de ModLauncher kompilita por MinecraftForge/LexForge ");
        sb.append("oni\u015das sub NeoForge per nekompatibla versio de la ModLauncher-API. ");
        sb.append("\u011cisdatigu a\u016d anstata\u016digu la komponenton por NeoForge.");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "LexForge Transformilo uzita en NeoForge";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "Identigu la nekompatan transformilon: <b>" + claseReceptora + "</b>. La atendita API estas <b>" + interfazObjetivo + "</b> kiu bezonas <b>" + firmaMetodoFaltante + "</b>. Kontrolu \u0109u la aldona\u0135o registras tiun klason en <b>META-INF/services</b> kaj forigu \u011din a\u016d malaktivigu en NeoForge.";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Loko de la rilataj aldona\u0135oj: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", ktp...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("Neniu JAR trovita kun tiu klaso. Kontrolu jar-en-jar kaj \u015dancelitajn dependecojn. ");
        }
        sb.append("Tempe forigu tiujn JAR-ojn a\u016d uzu versiojn kompatiblajn kun NeoForge por konfirmi la originon.");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "Anstata\u016digu la komponenton per specifa versio por NeoForge a\u016d remalfraku \u011din kontra\u016d la ModLauncher-versio uzitan de NeoForge. Evitu malnovajn binarojn de LexForge/MinecraftForge.";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "Purigu vian mods-dosierujon kaj forigu duoblajn jar-en-jar-erojn. Vi\u015du lan\u0109ilan ka\u015dmemoron se necese kai restartu por certi\u011di ke neniu LexForge-transformilo plu estos \u015dargita.";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia ne povas lan\u0109i\u011di: Xenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("ne estas kompatibla.</b> ");
        sb.append("Forigu Xenon kai uzu anstata\u016de Embeddium a\u016d Sodium. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Malkovrite en: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", ktp...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia nekompatibla kun Xenon";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return "Malkovri\u011dis " + label + " nekompatiblan kun WaterMedia. Forigu \u011din el via profilo.";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("Lokoj: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", ktp...");
            }
            sb.append("</b>. Forigu tiun JAR-on.");
            return sb.toString();
        }
        return "Neniu JAR trovita. Kontrolu vian mods dosierujon kai forigu Xenon.";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "Instalu Embeddium a\u016d Sodium kiel anstata\u016don kai restartu la ludon.";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "Eraro dum kunpremado (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>Deflater fermi\u011dis dum kopio de rimedoj de TACZ.</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Rilata al: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", ktp");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>Solvo:</b> en <code>tacz/tacz-pre.toml</code> agordu <code>DefaultPackDebug=true</code>. ").append("Se necese, unue generu mapon, poste aktivigu \u011din.");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "En tacz/tacz-pre.toml agordu DefaultPackDebug=true. Se necese, unue generu mapon, poste aktivigu \u011din.";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "Nerilataj densofunkcioj";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>Mankas densecaj funkcioj en la registro.</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("Mankantaj: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append(". ");
        }
        sb.append("<br/><b>Solvo:</b> instalu a\u016d aktivigu la mod/datapack, kiu difinas tiujn funkciojn, kaj restartigu. Alia komuna kialo por tiu \u0109i problemo estas, kiam vi havas la bezonatan modon, sed \u011di havas problemon a\u016d konflikton kun alia mod; ekzemple, Terralith havas multajn problemojn kaj povas ka\u016dzi tiun \u0109i eraron kaj aliajn, inkluzive de eraroj kun JSON.");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "Instalu a\u016d aktivigu la modon/datopakon kiun provizas tiujn funkciojn kai restartu la ludon.";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Registroenskribo ne \u0109eesta: ").append(claveFaltante).append(". ");
        sb.append("Ofte okazas kun la alfaversio de Steam & Railways por Create 6.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (alfa)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "Forigu a\u016d anstata\u016digu la alfaversion de Steam & Railways por Create 6 per kompatibla versio.";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u015car\u011da konflikto: Multiworld kun Sodium/Embeddium/Rubidium ka\u016dzas ").append("IncompatibleClassChangeError (FabricLoader.getInstance). ").append("Propono: \u0109esu uzi Multiworld a\u016d la rapidigan aldona\u0135on, a\u016d uzas kompatiblajn versiojn.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "Konflikto: Multiworld kun rapidigaj aldona\u0135oj";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "Malinstalu Multiworld a\u016d Sodium/Embeddium/Rubidium, a\u016d \u011disdatigu al interkompatiblaj versioj.";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium detektis nekompatan grafikan \u015doforon. \u011cisdatigu vian GPU-\u015doforon al la minimume postulita a\u016d sekvu la gvidilon de Sodium.</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "Eraro de OpenGL-kunteksto";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenGL malsukcesis: neniu nuna kunteksto a\u016d funkcio ne disponeblas en tiu kunteksto. Eble estas problemo kun videaj \u015doforoj.</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "\u011cisdatigu/reinstalu viajn GPU-\u015doforojn kai restartu; \u0109esigu suprenmetojn kai provu sen rapidigaj aldona\u0135oj.";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "Ligilo kopita en la tondejon.";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "Ser\u0109i ene de arkivoj (.zip/.jar/.war/.ear/.fpm/.rar por Java*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro pri tekstura risolucio: ne povas adapti " + recurso + " - grandeco: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "Eraro pri Tekstura Risolucio";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "Tiu eraro okazas kiam teksturoj estas tro grandaj a\u016d ekzistas tro da rimedopakoj. Provu uzi rimedopakojn kun pli malalta risolucio a\u016d forigu kelkajn. Certigu, ke vi ne aldonis kutimajn teksturojn per pli alta ol permesita risolucio.";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro de ModLauncher-servoj: vojo kun nevalidaj signoj. ModLauncher-servoj ne povas prilabori vojojn kiuj enhavas ne-ASCII a\u016d specialajn signojn. Problemaj signoj inkludas: \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694, kiel anka\u016d precipe la signo '\"' se \u011di trovi\u011das je fino de nomo. Komunaj servoj en ModLauncher inkludas CrashDetector, " + Config.obtenerInstancia().obtenerNombreCD() + ", FeatureCreep, Vivicraft, Optifine, Sodium, clonos, Iris Shaders/Oculus, MixerLogger, CrashAssistant kaj Sintrya Connector. Vi povas forigi \u0109iujn servojn, sed eble estos aliaj problemoj pro via voja nomo. Solvado: \u015can\u011du la nomon de via instanco por uzi nur ASCII-signojn (a-z, A-Z, 0-9), sen spacetoj a\u016d specialaj signoj.</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "Eraro pri Vojo en ModLauncher";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "Tiu eraro okazas kiam la instanca vojo enhavas ne-ASCII a\u016d specialajn signojn. ModLauncher-servoj ne povas pritrakti tiujn vojojn. Solvado: \u015dan\u011du la instancan nomon por uzi nur ASCII-signojn (a-z, A-Z, 0-9), evitu spacetojn kaj specialajn signojn. Prestu apartan atenton al la signo '\"', kiu tre problemas, precipe se \u011di estas je fino de nomo.";
    }

    @Override
    public String tituloEditorCodice() {
        return "Redaktilo de Codice";
    }

    @Override
    public String nuevo() {
        return "Nova";
    }

    @Override
    public String actualizarSeleccionado() {
        return "\u011cisdatigi elektitan";
    }

    @Override
    public String eliminarSeleccionado() {
        return "Forigi elektitan";
    }

    @Override
    public String exportarJSON() {
        return "Eksporti JSON...";
    }

    @Override
    public String guardarTodo() {
        return "Konservi \u0109ion";
    }

    @Override
    public String general() {
        return "\u011cenerala";
    }

    @Override
    public String id() {
        return "ID";
    }

    @Override
    public String paraBuscar() {
        return "Teksto por ser\u0109i";
    }

    @Override
    public String filtro() {
        return "Filtra\u0135o (id)";
    }

    @Override
    public String criticalidad() {
        return "Graveco (AVERTO/ERARO/FATALE)";
    }

    @Override
    public String prioridad() {
        return "Prioritato";
    }

    @Override
    public String lista() {
        return "Kontroloj";
    }

    @Override
    public String colIdioma() {
        return "Lingvo";
    }

    @Override
    public String colNombre() {
        return "Nomo";
    }

    @Override
    public String colResultado() {
        return "Rezulto";
    }

    @Override
    public String vistaJson() {
        return "Anta\u016dvido de JSON";
    }

    @Override
    public String idiomas() {
        return "Lingvoj (\u0109iuj devigaj)";
    }

    @Override
    public String elegirFiltro() {
        return "Elekti...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "Bonvolu elekti filtrilon";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "Disponeblaj filtriloj";
    }

    @Override
    public String faltanCampos() {
        return "Plenu \u0109iujn devigajn \u011deneralajn kampojn.";
    }

    @Override
    public String critInvalida() {
        return "Nevalida graveco. Uzu AVERTO, ERARO a\u016d FATALE.";
    }

    @Override
    public String filtroNoExiste() {
        return "La indikita filtrilo ne ekzistas.";
    }

    @Override
    public String faltanIdiomas() {
        return "Bonvolu plenumi nomon kaj rezulton por \u0109iuj lingvoj:";
    }

    @Override
    public String verificacionInvalida() {
        return "Unu kontrolo estas nevalida. Bonvolu revizii la kampojn.";
    }

    @Override
    public String guardadoOk() {
        return "Konservite sukcese.";
    }

    @Override
    public String editorCodiceBoton() {
        return "Aldoni ka\u016dzojn";
    }

    @Override
    public String descripcionEditorCodice() {
        return "Vi povas registri ka\u016dzojn \u0109i tie. Vi bezonas ID-on, tekston sen specialaj signoj, akcentoj a\u016d spacetoj. Por filtriloj vi povas uzi \"linio enhavas\" por ser\u0109i tekston en linio, \"\u0109io enhavas\" se la protokolo havas tekston, \"regex linio\" se linio konformas regulan esprimon, kai \"regex \u0109io\" (rekomencas uzi liniajn versiojn). Vi devas agordi gravecon: FATAL, ERARO a\u016d AVERTO por la koloroj. Por \u0109iuj lingvoj vi devas tajpi nomon kai respondon por la ekrano. Vi povas aldoni pliajn kontrolojn a\u016d forigi aliajn. Vi konservas post kompletigo.";
    }

    @Override
    public String descartarCambios() {
        return "\u0108u \u0109esi senkonservitajn \u015dan\u011dojn en la nuna kontrolo?";
    }

    @Override
    public String confirmacion() {
        return "Konfirmo";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\u0108u vi volas konservi viajn \u015dan\u011dojn anta\u016d ol eliri?";
    }

    @Override
    public String salirSinGuardar() {
        return "Eliri sen konservi";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Grava eraro: Malsukcesis \u015dargi servon de modlauncher (IDependencyLocator).<br>");
        sb.append("\ud83d\udd39 <b>Problema klaso:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>Afektita aldona\u0135o:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>Aldona\u0135o neidentigita.</b> Bonvolu kontroli lastatempe instalitajn, evoluajn a\u016d malbone pakitajn aldona\u0135ojn.<br>");
        }
        sb.append("\ud83d\udd38 <b>Ka\u016dzo:</b> La dosiero <code>META-INF/services/...</code> de la aldona\u0135o estas difektita, ");
        sb.append("nekompatibla kun via versio de Forge/NeoForge, a\u016d la aldona\u0135o estas por mal\u011dusta versio.<br>");
        sb.append("\ud83d\udd38 <b>Konsekvenco:</b> Forge/NeoForge ne povas registri dependecojn de la aldona\u0135o, ");
        sb.append("tio malebligas lan\u0109on de la ludo.<br>");
        sb.append("\ud83d\udd38 <b>Solvo:</b> \u011cisdatigu, reinstalu a\u016d forigu la probleman aldona\u0135on. ");
        sb.append("Se vi uzas evoluajn aldona\u0135ojn, certigu ke ili estas kompilitaj por via ekzakta Forge/NeoForge-versio.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "Eraro pri Servokonfiguracio (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. Identigu la ka\u016dzan aldona\u0135on: kontrolu anta\u016dnelonge instalitajn a\u016d evoluajn aldona\u0135ojn.";
        }
        return "1. La problemeca aldona\u0135o estas: " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. \u011cisdatigu, reinstalu a\u016d forigu la aldona\u0135on. Certigu uzi version kompatan kun via Forge/NeoForge.";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>Grava eraro: Neksista metodo.</b><br>La aldona\u0135o provis voki la metodon <b style='color:#" + colorCodigo + "'>" + metodo + "</b>, kiu ne ekzistas en tiu \u0109i versio de la ludo a\u016d alia aldona\u0135o.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "Neksista Metodo (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. Tiu eraro okazas kiam aldona\u0135o ne estas kompatibla kun la nuna versio de la ludo a\u016d alia aldona\u0135o.";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. \u011cisdatigu \u0109iujn rilatajn aldona\u0135ojn. Se da\u016dras, raportu la eraron al la verkinto de la tu\u015dita aldona\u0135o.";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>Grava eraro: Neksista kampo.</b><br>La aldona\u0135o provis aliri kampon <b style='color:#" + colorCodigo + "'>" + campo + "</b>, kiu ne ekzistas en tiu \u0109i versio de la ludo a\u016d alia aldona\u0135o.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "Neksista Kampo (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. Tiu eraro kutime okazas kiam aldona\u0135o ne estas kompatibla kun la nuna versio de la ludo a\u016d alia aldona\u0135o.";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. \u011cisdatigu \u0109iujn tu\u015ditajn aldona\u0135ojn. Se da\u016dras, kontaktu la verkinton de la aldona\u0135o ka\u016dzanta la eraron.";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\u0108u vi bezonas helpon?</strong><br>  Se vi ne scias kiel ripari \u0109i tion a\u016d se la ka\u016dzo ne estas tie \u0109i, vi povas ricevi helpon per niaj sociaj retoj.   Uzu la butonon <img src='" + iconoCompartir + "' alt='Komunigi' style='height:12px;vertical-align:middle;'/>   <strong>Komunigi</strong> por akiri ligilojn al viaj protokoloj kai rezultoj por nia teamo.   Se vi estas kreinto de modpack a\u016d korporacio, redaktu <code>crash_detector/plantilla.htm</code>   por al\u011dustigi viajn teamajn ligilojn.</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "Restarigi \u015dablonon";
    }

    @Override
    public String restablecer() {
        return "Restarigi";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return "\u0108u restarigi " + nombreImagen + " al defa\u016dltaj valoroj?";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\u0108u restarigi la \u015dablonon al defa\u016dltaj valoroj?";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mankas klasoj de AzureLib. Se vi jam havas AzureLib, bonvolu instali version anta\u016d la 8-a de oktobro 2025. Tio estis komune. Se vi ne havas AzureLib, instalu la aktualan version.</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>La aldona\u0135o <code>healight</code> ka\u016dzas gravan eraron: <code>java.lang.NoSuchFieldError: INT</code>. Tiu eraro okazas \u0109ar la aldona\u0135o provas aliri kampon kiu jam ne ekzistas en MCForge 47.10 por Minecraft 1.20+. La ludo ne povas lan\u0109i\u011di pro tiu problemo.</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 Forigu a\u016d \u011disdatigu la aldona\u0135on <code>healight</code>. La nuna versio ne estas kompatibla kun MinecraftForge 47.10 por 1.20.1. Ser\u0109u pli novan version de la aldona\u0135o a\u016d pripensu uzon de alternativo.";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "Grava eraro: healight - Kampo 'INT' ne trovita";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("La klaso <code>").append(clase).append("</code> ne realigas la postulitan metodon:<br>").append("<code>").append(metodo).append("</code><br>").append("el la interfaceto <code>").append(interfaz).append("</code>.");
        if (!origen.isEmpty()) {
            sb.append("<br><br>\u0108efa afero a\u016d dosiero: <code>").append(origen).append("</code>.");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 Tiu eraro okazas kiam aldona\u0135o realigas interfaceton sed preterprenas devigan metodon. \u011cisdatigu <b>amba\u016dn aldona\u0135ojn</b> implikitajn (tiun kiun difinas la interfaceton kai tiun kiun \u011din realigas). Se vi ne scias kiuj estas, ser\u0109u la nomojn videblajn en la erarmesa\u011do.";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "Nerealigita Interfaceta Metodo (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Aldona\u0135o provas \u015dargi klason de la <b>klienta flanko</b> (<code>AnimationMetadataSection</code>) sur <b>diferencitan servilon</b>, kio estas neebla. Tiu eraro kutime aperas kiam aldona\u0135o ne bone apartigas siajn kodon por kliento kaj servilo. La \u0109eesto de <code>ModernFix</code> povas malkovri tiun problemon, kvankam \u011di ne estas rektan ka\u016dzon.</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>Rapida opcio:</b> Forigu tempore <code>ModernFix</code> por konfirmi \u0109u la servilo lan\u0109i\u011das. Se jes, do la problemo estas en alia aldona\u0135o kiun \u015dargas klientajn klasojn sur servilon.<br>\u2022 <b>Da\u016dra solvo:</b> Identigu la kulpan aldona\u0135on (ser\u0109u aldona\u0135ojn kun animaciitaj rimedoj, \u0109efaj teksturoj a\u016d grafikaj bibliotekoj) kai \u011disdatigu a\u016d forigu \u011din.<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "Client-side class \u015dargita sur servilo (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>La agorda dosiero de <code>Sinytra Connector</code>-aldona\u0135o estas difektita. Tio ofte okazas kiam la dosiero plenas per nulaj signoj (<code>\\u0000</code>) pro neatendita \u0109esigo de la ludo, skribaj malsukcesoj a\u016d aldona\u0135aj konfliktoj.</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 Iru al la dosierujon <code>config/</code> de via Minecraft-instanco.<br>\u2022 Ser\u0109u kai forigu la agordojn de connector-aldona\u0135oj.<br>\u2022 Restartu la ludon: Sinytra Connector estos kreinta novan, puran agordan dosieron.";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "Difektita Agordo de Sinytra Connector";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>La dosiero <code>" + nombreJar + "</code> estas difektita a\u016d nekompleta.<br>La sistemo ne povas legi \u011dian enhavon \u0109ar mankas la fina kapo de la ZIP-dosiero.<br>Tiu eraro kutime okazas post nepropra el\u015duto a\u016d malsukceso de lan\u0109ilo.</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "Difektita JAR-dosiero (kun specifa nomo)";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>Forigu la difektitan dosieron</b> kai el\u015dutu \u011din denove el oficiala fonto (CurseForge, MinecraftStorage, ktp.).<br>\u2022 Se vi uzas lan\u0109ilon kiel CurseForge, Technic a\u016d Luna Pixel, pripensu \u015dan\u011di al <b>ATLauncher</b> a\u016d <b>Prism Launcher</b>, kiuj pli bone kontrolas dosieran integrecon.<br>\u2022 Certigu ke via interreta konekto estu stabila dum la el\u015duto.";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Ne povas \u015dargi mondon \u0109ar unu el liaj NBT-dosieroj estas difektita (ekzemple: <code>level.dat</code>, <code>playerdata/*.dat</code>, a\u016d chunkoj).<br>La specifa eraro estas: <code>UTFDataFormatException: mal\u011dusta enigo apud bajto " + byteCorrupto + "</code>.<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f Anta\u016d ol provi iun riparon, faru plenan kopion de la dosierujo de via mondo.</b><br><br>Vi povas provi ripari la difektitan dosieron uzante <b>redaktilon por NBT</b> kiel <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>.<br>Se la dama\u011do estas grava, uzu <b>heksan redaktilon</b> (kiel HxD) por ekzameni kai \u011fustigi nevalidajn bajtojn (nur se vi havas sperton pri la NBT-formato).<br>Fine, vi povas resta\u016dri el savkopio a\u016d uzi la funkcion <i>repair world</i> de aldona\u0135oj kiel <code>FTB Backup</code>.</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>Faru plenan sekuran kopion de la mondo-dosierujo</b> anta\u016d ol provi iun ajn riparon.<br>\u2022 Uzu NBT-redaktilon (kiel NBT Studio) por malfermi kai ripari la difektitan dosieron.<br>\u2022 Se malsukcesas, ekzamenu la dosieron per heksa redaktilo je la pozicio de la difektita bajto.<br>\u2022 Se vi ne havas sperton, resta\u016dru el lastatempa sekura kopio.";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "Difektita mondo: eraro dum \u015dar\u011dado de NBT datumoj";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Vi havas problemon kun OpenAL. Foje peliloj Nouveau povas ka\u016dzi tion, sed foje la versio de OpenAL en via aplika\u0135o ne estas kompatibla kun tiu en via distribua\u0135o, do vi devas uzi la version el via distribua\u0135o. Tio estas aparte ofta \u0109e Red Hat-similaj distribua\u0135oj kai kun sono-modifoj kiel Sound Physics Remastered. Vidu \u0109i tiun gvidilon por plia helpo: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>Kiel solvi sonojn en Minecraft sur Linux</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>La servilo ne povas lan\u0109i\u011di \u0109ar dosiero de la mondo estas blokita de alia procezo.<br>Tio kutime okazas se:<br>\u2022 Jam ekzistas funkcianta servila instanco.<br>\u2022 Antiviruso a\u016d dosierumilo havas malfermitan la dosierujon de via mondo.<br>\u2022 La anta\u016da procezo ne \u011duste \u0109esis kai lasis dosierojn blokitajn.</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>Fermu \u0109iujn servilajn instancojn</b> (inkluzive de fono-procezoj kiel javaw.exe).<br>\u2022 Se vi uzas gastigan panelon (kiel Multicraft), tute restartigu la servilon per la panelo.<br>\u2022 <b>Tempe malaktivigu vian antiviruson</b> se vi suspektas ke \u011di blokas dosierojn.<br>\u2022 Je lokaj sistemoj, fermu ajnan Fenestron-Eksplorilan fenestron kiun montras vian mondan dosierujon.<br>\u2022 Se da\u016dras la problemo, mane forigu la dosieron <code>session.lock</code> ene de via monda dosierujo (nur se vi certas ke neniu alia servilo funkcias).";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "Monda dosiero blokita de alia procezo";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>La aldona\u0135o provis plilongigi la klason <code>" + clasePadreFinal + "</code>, sed tiu \u0109i klaso nun estas <b>fina</b> kai ne povas esti heredita.<br>La problemeca klaso estas: <code>" + claseHija + "</code>.<br><br>Tio kutime okazas kiam aldona\u0135o estas kompilita por anta\u016da versio de Minecraft a\u016d alia baza aldona\u0135o, kiu markis kelkajn klason kiel <code>final</code> en lastatempaj versioj.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>\u011cisdatigu \u0109iujn implikitajn aldona\u0135ojn</b>, precipe tiujn kiuj eble rilatas al la menciita baza aldona\u0135o.<br>\u2022 Se da\u016dras la problemo, ser\u0109u version de la aldona\u0135o kompatan kun via nuna versio de Minecraft kai ties dependecoj.<br>\u2022 En iuj kazoj, forigo de la aldona\u0135o enhavanta la filan klason povas helpi konfirmi la ka\u016dzon.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "Demando pri heredo de fina klaso";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Vi uzas <b>Rubidium</b> (malnovan furkilon de Sodium por Forge) kun <b>Iris a\u016d Oculus</b>.<br>En lastatempaj versioj de Minecraft (1.19.2+), Rubidium ne sekvis la pacon de Sodium kai havas problemojn pri dependecoj.<br><br>\u0108i tiu eraro anka\u016d povas okazi pro konflikto inter rendimentaj aldona\u0135oj (Sodium, Rubidium, Embeddium, Bedium, Xeonium, ktp.) a\u016d Iris Shaders kun alia aldona\u0135o.</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <b>Forigu Rubidium</b> el via dosierujo <code>mods</code>.<br>\u2022 <b>Instalu <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a></b>, la aktivan kai kompatan furkilon de Sodium por Forge kiun subtenas Iris/Oculus en 1.20+.<br>\u2022 Certigu ke vi ne havas pli ol unu furkilon de Sodium instalitan samtempe (ekzemple: Rubidium + Embeddium).<br>\u2022 Se vi uzas Oculus anstata\u016de de Iris, kontrolu ke \u011di anka\u016d estas kompata kun via versio de Forge kai Embeddium.";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "Malnova Rubidium kun Iris/Oculus (OptionInstance estas final)";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>La aldona\u0135o <code>Simple Voice Chat</code> ne povas lan\u0109i siajn vo\u0109an servilon \u0109ar la UDP-pordo jam estas uzata a\u016d la agordita IP-adreso ne validas.<br>Tio ne malebligas lan\u0109on de la ludo, sed mal\u015daltas la vo\u0109an babilejan funkcion.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>Fermu ajnan alian instancon de Minecraft</b> a\u016d aplika\u0135on kiun uzas la UDP-pordon 24454.<br>\u2022 Se vi estas sur servilo, certigu ke <b>neniu alia servo</b> uzas tiun pordon.<br>\u2022 En la agordoj de la aldona\u0135o (<code>config/voicechat/</code>), \u015dan\u011du la UDP-pordon al libera (ekzemple, 24455).<br>\u2022 Se vi uzas propran IP-adreson, kontrolu ke \u011di estas \u011dusta a\u016d lasu \u011din malplena por uzi la defa\u016dltan.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "Vo\u0109a Babilejo: UDP-pordo okupita a\u016d nevalida IP";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>La BlockItem <code>" + nombreBlockItem + "</code> havas nulan blokon.<br>Tiu eraro kutime okazas en <b>aldona\u0135oj por Create</b> (kiel <code>dndecor</code>, <code>createdeco</code>) kiam ekzistas konfliktoj kun <code>Amendments</code>, <code>Moonshine</code>, a\u016d mal\u011dusta komenca\u0135o de blokoj.<br><b>Noto:</b> Tio ne estas rekte eraro de Amendments, sed simptomo de pli profunda problemo pri registra \u015dar\u011dado.</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>\u011cisdatigu \u0109iujn rilatajn aldona\u0135ojn:</b> Create, Amendments, Moonshine, kai ajnan aldona\u0135on (precipe <code>dndecor</code> kai <code>createdeco</code>).<br>\u2022 Se da\u016dras la problemo, <b>forigu tempore la Create-aldona\u0135ojn</b> unu post alia por trovi la kulpan.<br>\u2022 Certigu ke <b>Amendments kai Moonshine estas kompatoblaj</b> kun via versio de Create kai Forge.<br>\u2022 Kontrolu \u0109u ekzistas beta-versioj a\u016d aktualigitaj fork'oj de la problemaj aldona\u0135oj.";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "Nula BlockItem en Create-aldona\u0135o";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("Malsukcesis trovi aldona\u0135ojn kiuj ne apartenas al iu aktiva platformo (Forge, Fabric, ktp.):<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>Tio kutime okazas kiam:<br>").append("\u2022 Oni miksis aldona\u0135ojn de <b>Fabric kai Forge</b> en la sama dosierujo.<br>").append("\u2022 Oni instalas aldona\u0135on por nekompatibla versio de Minecraft.<br>").append("\u2022 La aldona\u0135o estas difektita a\u016d ne validas kiel dosiero JAR.</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>Kontrolu ke \u0109iuj aldona\u0135oj estas por la sama platformo</b> (Forge <b>a\u016d</b> Fabric, ne amba\u016d).<br>\u2022 Uzu la <b>arbo de aldona\u0135oj</b> por identigi kiun platformon detektas \u0109iu dosiero.<br>\u2022 Forigu ajnan aldona\u0135on kiun vi ne rekonoas a\u016d kiu estas por malsama platformo.<br>\u2022 Se vi uzas lan\u0109ilon kiel CurseForge a\u016d Prism, certigu ke via profilo estas \u0109efe agordita.";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "Aldona\u0135o nekompatibla kun aktiva \u015dar\u011dilo";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Malsukcesis krei modelon <code>" + modid + ":" + nombreModelo + "</code>.<br>Tio indikas ke la aldona\u0135o <code>" + modid + "</code> havas difektitajn, mankantajn a\u016d nekompatiblajn rimedojn por via versio de Minecraft.</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>\u011cisdatigu la aldona\u0135on</b> al la plej nova versio kompata kun via instanco.<br>\u2022 Se vi uzas evoluantan a\u016d \u0109efan version, revenu al la oficiala versio.<br>\u2022 Kontrolu ke la dosiero JAR ne estas difektita (reinstalu \u011din).<br>\u2022 Se da\u016dras la problemo, raportu la eraron al la verkinto de la aldona\u0135o inkluzive \u0109i tiun protokolon.";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "Malsukcesis krei rimedan modelon";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Detektis gravan konflikton inter la aldona\u0135oj <code>Moonlight</code> kai <code>Iceberg</code>.<br>Amba\u016d provas registri rimedajn re\u015dar\u011dajn sistemojn nekompatibile, kiu ka\u016dzas malsukceson de OpenGL pro foresto de valida grafika konteksto.<br>Tiu problemo estas ofta dum uzado de versioj de Forge kiuj inkludas adaptilojn por Fabric-aldona\u0135oj.</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>\u011cisdatigu amba\u016dn aldona\u0135ojn</b> al iliaj lastaj versioj kompatoblaj kun via versio de Forge.<br>\u2022 Se da\u016dras la problemo, <b>forigu tempore Iceberg</b>, \u0109ar Moonlight kutime estas pli grava dependeco por aliaj aldona\u0135oj.<br>\u2022 Certigu ke vi ne havas duoblan a\u016d miksitajn versiojn de Forge/Fabric por tiuj \u0109i aldona\u0135oj.<br>\u2022 Kontrolu \u0109u iu alia aldona\u0135o (kiel Supplementaries, Citadel, ktp.) jam enhavas funkciecon de Iceberg ene.";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "Grava konflikto: Moonlight kontra\u016d Iceberg (OpenGL sen konteksto)";
    }

    @Override
    public String instantanea() {
        return "Bilda\u0135o";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "Ekde lasta bilda\u0135o";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "Elekti dosieron";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "Bilda\u0135o sukcese kreita";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "Eraro dum kreo de bilda\u0135o";
    }

    @Override
    public String consejo() {
        return "Konsilo";
    }

    @Override
    public String resultadoMuestra() {
        return "Montri rezulton";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>Konsilo:</b> Elektu du protokolajn dosierojn por kompari liston de aldona\u0135oj.   La rezulto montras <span style='color:%s;'>aldonitajn (+)</span> kai   <span style='color:%s;'>forigitajn (&#8722;)</span> bazite sur normigitaj nomoj.   Uzu la butonon 'Bilda\u0135o' por krei kopion de ekzistanta dosiero per etendita nomo .instantanea.</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "Akiri retejojn de protokoloj kiel Markdown sen raporto";
    }

    @Override
    public String titulo_configuracion() {
        return "Agordo";
    }

    @Override
    public String columna_url() {
        return "URL";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "Necerta eraro dum kunhavigo.";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "Necerta eraro dum genero de ligiloj.";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "Necerta eraro dum prilaboro de butono.";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "Neniu dosiero estas ligita por malfermi.";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "Dosiero ne ekzistas:\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "Ne povis malfermi en redaktilo.\nLa vojo estos kopita al tondejo.";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "Ne povis malfermi dosieron; la vojo estis kopita al tondejo.";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "Labortablo ne subtenata; la vojo estis kopita al tondejo.";
    }

    @Override
    public String limite_de_solicitudes() {
        return "Vi spertas limon de petoj. Provuzu alian registran retejon a\u016d alian registran API-n.";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "Komuniki ligilon";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Rezolvi suprajn partojn de trunkoj estas unua prioritato. La formato estas Nivelo, Linio. \u0108iuj protokoloj havas nombran sistemon. " + "<br>" + "\u011cenerale vi bezonas ser\u0109i plej malsuprajn nivelojn en \u0109iuj protokoloj; spuradoj kun altpoziciaj niveloj kutime estas malveraj pozitivoj. Gravegas uzi vian kapablon rigardi en la konzolon, \u0109ar analizo de spuradoj ne estas perfekta kiam ekzistas multaj spuradoj.</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "Ser\u0109ilo pri ordo-kanario";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "\u0108i tiu funkcio estos disponebla balda\u016d.";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "Balda\u016d";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "Nekongruaj aldona\u0135oj kun Crash Assistant (Malvera\u0135o)";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "Nekongrua Modpack kun CrashAssistant";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant havas liston de aldona\u0135oj kiujn \u011di diras esti nekongruaj, sed ni ne havas pruvon ke ili estas nekongruaj kai la eraro estas nur angle. Se vi volas ludi per tiuj aldona\u0135oj, vi povas redakti la dosieron <code>config/crash_assistant/config.toml</code> kai \u015dan\u011di <code>enabled = true</code> en [kompatibileco] al <code>enabled = false</code>.</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant povas diri ke iuj aldona\u0135oj estas nekongruaj, sed foje ili estas kompatataj kai la eraro estas nur en unu lingvo. Se vi volas uzi tiujn aldona\u0135ojn, vi povas redakti la dosieron <code>config/crash_assistant/problematic_mods_config.json</code> kai \u015dan\u011di <code>should_crash_on_startup</code> de <code>true</code> al <code>false</code>.</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Eraro: La aldona\u0135o '" + modId + "' bezonas la aldona\u0135on '" + dependencia + "'. Nuntempe, " + actual + ".</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Eraro: La aldona\u0135o '" + modId + "' postulas version '" + requerido + "' a\u016d pli novan de '" + dependencia + "', sed la aldona\u0135o ne estas instalita.</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Eraro: La aldona\u0135o '" + modId + "' ne estas kompata kun la nuna versio de '" + dependencia + "'. Vi devas forigi la aldona\u0135on 'Iris/Oculus & GeckoLib Compat' \u0109ar \u011di ne estas kompata kun Superb Warfare kai ne funkcias per la plej nova versio de GeckoLib. Nuna versio: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "\uc624\ub958: '" + clase + "' \ud074\ub798\uc2a4\uc758 \uc791\uc5c5\uc744 \uc2e4\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc774 \uc624\ub958\ub294 \uc11c\ub85c \ud638\ud658\ub418\uc9c0 \uc54a\uac70\ub098 \uc124\uce58\ub41c \ub2e4\ub978 \ubaa8\ub4dc\uc640 \ucda9\ub3cc\ud558\ub294 \ubaa8\ub4dc\uc5d0\uc11c \ud754\ud788 \ubc1c\uc0dd\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "\uc791\uc5c5 \uc2e4\ud589 \uc2e4\ud328";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "\uc774\ub7ec\ud55c \uc885\ub958\uc758 \uc624\ub958\ub294 \uc77c\ubc18\uc801\uc73c\ub85c \ubaa8\ub4dc \uac04\uc758 \ud638\ud658\uc131 \ubb38\uc81c\ub85c \uc778\ud574 \ubc1c\uc0dd\ud569\ub2c8\ub2e4. \ud2b9\ud788 ConnectorMod\uacfc \ud568\uaed8 \uc81c\ub300\ub85c \uc791\ub3d9\ud558\uc9c0 \uc54a\ub294 \ubaa8\ub4dc\uc5d0\uc11c \ud754\ud569\ub2c8\ub2e4.";
    }

    @Override
    public String info_clase_problematica() {
        return "\ubb38\uc81c \uc788\ub294 \ud074\ub798\uc2a4:";
    }

    public String ver_en_log() {
        return "\ub85c\uadf8\uc5d0\uc11c \ubcf4\uae30";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "\uc2e4\ud589 \ubb38\uc81c\uac00 \uc788\ub294 \ud2b9\uc815 \ud074\ub798\uc2a4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektis gravan konflikton inter OptiFine kai Entity Model Features (EMF). \u0108i tiuj aldona\u0135oj ne estas kompatataj kai ka\u016dzas fiaskon de en\u0135eto kiun malhelpas lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "Konflikto inter OptiFine kai Entity Model Features";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "Malinstalu a\u016d OptiFine a\u016d Entity Model Features, \u0109ar ili ne estas kompatataj inter si.";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektis gravan konflikton inter OptiFine kai Fusion. \u0108i tiuj aldona\u0135oj ne estas kompatataj kai ka\u016dzas fiaskon de en\u0135eto kiun malhelpas lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "Konflikto inter OptiFine kai Fusion";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "Malinstalu a\u016d OptiFine a\u016d Fusion, \u0109ar ili ne estas kompatataj inter si.";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Flywheel (postulita de Create) bezonas Sodium 0.6.0-beta.2 a\u016d pli novan. Rubidium estas 0.5.3. Konsideru uzi <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> kiel alternativon.</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "Konflikto inter Flywheel kai versio de Sodium";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "\u011cisdatigu Sodium al 0.6.0-beta.2 a\u016d pli supre, a\u016d instalu <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> kiel kompatan alternativon.";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektis gravan konflikton inter OptiFine kai Epic Fight. \u0108i tiuj aldona\u0135oj ne estas kompatataj kai ka\u016dzas fiaskon de en\u0135eto kiun malhelpas lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "Konflikto inter OptiFine kai Epic Fight";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "Malinstalu a\u016d OptiFine a\u016d Epic Fight, \u0109ar ili ne estas kompatataj inter si.";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita gravaj konflikto inter OptiFine kaj Rubidium. Tiuj modoj ne estas kongruaj kaj ka\u016dzas enjekcian fiaskon, kiu malpermesas lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "Konflikto inter OptiFine kaj Rubidium";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "Forigu OptiFine a\u016d Rubidium, \u0109ar ili ne estas kongruaj unu kun la alia.";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam provas \u015dargi\u011di sur dedi\u0109ita servilo, sed \u011di estas kompatibla nur kun la kliento. Forigu FreeCam de la servilo a\u016d certigu, ke \u011di estas instalita nur sur la kliento.</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "FreeCam sur dedi\u0109ita servilo";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "Forigu FreeCam de la dedi\u0109ita servilo, \u0109ar \u011di devas esti instalita nur sur la kliento.";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) provas \u015dargi\u011di sur dedi\u0109ita servilo, sed \u011di estas kompatibla nur kun la kliento. Forigu ETF de la servilo a\u016d certigu, ke \u011di estas instalita nur sur la kliento.</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features sur dedi\u0109ita servilo";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "Forigu Entity Texture Features de la dedi\u0109ita servilo, \u0109ar \u011di devas esti instalita nur sur la kliento.";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi devas akcepti la EULOn de Minecraft por ruli la servilon. Redaktu la dosieron eula.txt kaj \u015dan\u011du 'eula=false' al 'eula=true'.</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "EULA de Minecraft ne akceptita";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "Redaktu la dosieron eula.txt en la servila dosierujo kaj \u015dan\u011du 'eula=false' al 'eula=true'.";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine provas \u015dargi\u011di sur dedi\u0109ita servilo, sed \u011di estas kompatibla nur kun la kliento. Forigu OptiFine de la servilo a\u016d certigu, ke \u011di estas instalita nur sur la kliento.</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "OptiFine sur dedi\u0109ita servilo";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "Forigu OptiFine de la dedi\u0109ita servilo, \u0109ar \u011di devas esti instalita nur sur la kliento.";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks estas mal\u011duste markita por 1.20.1 sed uzas metodojn de 1.21.1. La mod provas uzi ResourceLocation.fromNamespaceAndPath, kiu ne ekzistas en 1.20.1.</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "Versio-eraro en Iron's Spellbooks";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "Certigu, ke vi uzas la \u011dustan version de Iron's Spellbooks kongruan kun via Minecraft-versio.";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita gravaj konflikto inter OptiFine kaj Embeddium. Tiuj modoj ne estas kongruaj kaj ka\u016dzas enjekcian fiaskon, kiu malpermesas lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "Konflikto inter OptiFine kaj Embeddium";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "Forigu OptiFine a\u016d Embeddium, \u0109ar ili ne estas kongruaj unu kun la alia.";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Tio estas ofta \u0109e konfliktaj mondo-generantaj modoj, precipe Terralinth, AmplifiedNether, Nullscape kaj Incendium, kaj aliaj mondo-generantaj modoj. Eble vi devas instali mankantan modon.</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable provas \u015dargi\u011di sur dedi\u0109ita servilo, sed \u011di estas kompatibla nur kun la kliento. Forigu Controllable de la servilo a\u016d certigu, ke \u011di estas instalita nur sur la kliento.</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "Controllable sur dedi\u0109ita servilo";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "Forigu Controllable de la dedi\u0109ita servilo, \u0109ar \u011di devas esti instalita nur sur la kliento.";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries ka\u016dzas eraron, kiu malhelpas la \u015dargadon de la servilo. La mod havas problemojn kun la registo de fajrokondutoj, kiuj ka\u016dzas fiaskon dum la \u015dargado de datapack-oj.</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries malhelpas la \u015dargadon de la servilo";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "Provu \u011disdatigi Supplementaries al la plej nova versio a\u016d malaktivigu \u011din provizore por permesi la \u015dargadon de la servilo.";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader (GML) trovis problemon pro mankantaj Jackson-moduloj. Iuj modoj kiel Valkyrien Skies povas ka\u016dzi tiun eraron pro ne inkluzivi \u0109iujn necesajn dependecojn.</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "Mankanta Jackson-modulo en Groovy Modloader";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "Forigu Groovy Modloader kaj rilatajn modojn kiel Valkyrien Skies, kiuj povas ka\u016dzi konfliktojn de dependecoj.";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat trovis nevalidan nomon de lignon blokon. Every Compat \u011denerale havas multajn problemojn. Ne uzu \u011din!</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "Nevalida nomo en Every Compat";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "Kontrolu la risurcpakojn a\u016d modojn, kiuj uzas Every Compat, \u0109ar ili povas enhavi nevalidajn bloknomojn.";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erara kodo (-1073741819) estis trovita, kiu povas esti ka\u016dzita de supermetoj (overlays) kiel GameCaster de Razer, Discord, OBS Studio a\u016d problemoj kun NVIDIA-aj peliloj.</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "Erara kodo -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "Provu mal\u015dalti supermetojn kiel GameCaster, Discord a\u016d OBS Studio, kaj kontrolu ke viaj NVIDIA-aj peliloj estu \u011disdataj.";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips\ub294 dependencia\uc778 Immersive Messages\uac00 \ud544\uc694\ud558\uc9c0\ub9cc \uc124\uce58\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. Immersive Tooltips\uac00 \uc81c\ub300\ub85c \uc791\ub3d9\ud558\ub824\uba74 Immersive Messages\ub97c \uc124\uce58\ud558\uc138\uc694.</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "dependencia \uc5c6\ub294 Immersive Tooltips";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips\uc5d0 \ud544\uc694\ud55c dependencia\uc778 Immersive Messages\ub97c \uc124\uce58\ud558\uc138\uc694.";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins havas kongruecproblemon kun Apoli Mod, kie ItemStack ne povas esti 'cast'-ita al EntityLinkedItemStack. Tio estas komuna en versioj pli novaj ol 6.6.0. Konsideru uzi pli malnovan version a\u016d \u015dan\u011di inter versioj de Fabric kaj Forge.</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "Eraro de 'cast' en Medieval Origins";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "Uzu version de Medieval Origins 6.6.0 a\u016d pli malnovan, a\u016d provu \u015dan\u011di inter versioj de Fabric kaj Forge de la mod.";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether ka\u016dzas eraron kun Registry Object ne \u0109eestanta en MusicManager. \u0108i tiu problemo rilatas al la mixin de MusicManager de Reign of Nether.</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "Eraro de MusicManager en Reign of Nether";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "Provu \u011disdatigi Reign of Nether a\u016d provizore forigi \u011din por solvi la eraron.";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel subtenas la servilon YSM nur sur Linux a\u016d Android. \u0108i tiu problemo estis riparita en pli novaj versioj ekde la 23-a de novembro 2025 sur Modrinth.</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel ne kongruas kun Linux";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "\u011cisdatigu YesSteveModel al pli nova versio el Modrinth, \u0109ar la problemo estis riparita post la 23-a de novembro.";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita grava konflikto inter Moving Elevators kaj OptiFine. Tiuj modoj ne estas kongruaj kaj ka\u016dzas enjekcian fiaskon, kiu malpermesas lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "Konflikto inter Moving Elevators kaj OptiFine";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "Forigu OptiFine a\u016d Moving Elevators, \u0109ar ili ne estas kongruaj unu kun la alia.";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita grava konflikto inter Fabric API (fabric-resource-loader-v0) kaj OptiFine. Tiuj modoj ne estas kongruaj kaj ka\u016dzas enjekcian fiaskon, kiu malpermesas lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "Konflikto inter Fabric API kaj OptiFine";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "Forigu OptiFine a\u016d \u011disdatigu Fabric API al kongrua versio.";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Modo havas difektitan ITransformationService, kiu ne povas esti instancigita: " + claseProveedor + ". \u0108i tiu modo devas esti forigita por permesi lan\u0109on de la ludo.</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "Difektita ITransformationService";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "Forigu la modon, kiu enhavas la klason " + claseProveedor + ", \u0109ar \u011di havas difektitan ITransformationService.";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Modo havas nevalidan versiospecifon. La versio devas esti \u0109irka\u016dita de kvadrataj krampoj. Vi povas uzi la ilon grep/greprf en la flanka panelo ser\u0109ante la version </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'> por identigi, kiu modo havas la problemon.</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "Nevalida versio en modo";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "Uzu la ilon grep/greprf en la flanka panelo por ser\u0109i la probleman version kaj trovi la modon, kiu \u011din enhavas.";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro de stack smashing estis trovita, kiu finis la procezon. Tio povas esti ka\u016dzita de problemoj kun Early Window en Forge/NeoForge/PillowMC a\u016d kun LWJGL 3.2.2 kaj pli novaj.</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "Stack Smashing Detektita";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "Kontrolu la agordojn de Early Window kaj konsideru uzi alian version de LWJGL a\u016d reviziu modojn rilatajn al frua fenestro.";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore estas nur por specifa modpack kaj ne uzebla en \u011deneralaj instala\u0135oj, \u0109ar \u011di ka\u016dzas problemon.</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore kun nekongrua versio de Java";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "Forigu GregTechEasyCore, \u0109ar \u011di estas nur por specifa modpack kaj ne kongruas kun via \u011denerala instala\u0135o.";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita konflikto inter MoniLabs kaj Connector Extras rilate al modifoj de KubeJS. Tiuj modoj ne estas kongruaj en siaj KubeJS-modifoj.</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "Konflikto inter MoniLabs kaj Connector Extras";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "Provu malinstali unu el la modoj (MoniLabs a\u016d Connector Extras), \u0109ar ili konfliktas en siaj KubeJS-modifoj.";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris postulas Distant Horizons [2.0.4] a\u016d DH API versio [1.1.0] a\u016d pli nova. Vidu la kongruec-gvidilon \u0109e https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e por solvi la problemon.</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "Kongrueco de Iris kaj Distant Horizons";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "Vidu la kongruec-gvidilon \u0109e https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e kaj \u011disdatigu Iris kaj Distant Horizons al kongruaj versioj.";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi mankas klasojn de Minecraft. Eblaj kialoj:</b><ul><li>Vi havas modojn por aliaj versioj de la ludo. Vi povas uzi <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a> por kontroli \u0109u la klaso ekzistas en via versio.</li><li>Vi havas difektitan instala\u0135on de Minecraft (komune kun CurseForge App, ModrinthApp/Theseus/Astralrinth kaj aliaj modpack-lan\u0109iloj). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Vidu la lernilon</a> por solvi problemojn kun CurseForge.</li><li>Vi havas difektitan coremod-on (se coremod malsukcesas, \u011di povas bloki la \u015dar\u011don de la klaso).</li></ul><p>Noto: Vi povas uzi la ilon <b>grepr/fgrepr</b> en la flankpanelo por trovi la modojn, kiuj referencas la mankantajn klasojn, \u0109iam kiam vi uzas '/' en la nomoj.</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi mankas klasojn de DangerZone. Eblaj kialoj:</b><ul><li>Vi havas modojn por aliaj versioj de la ludo.</li><li>Vi havas difektitajn coremod-ojn.</li><li>Vi havas difektitan lan\u0109ilon a\u016d instala\u0135on.</li></ul><p>Noto: Vi povas uzi la ilon <b>grepr/fgrepr</b> en la flankpanelo por trovi la modojn, kiuj referencas la mankantajn klasojn, \u0109iam kiam vi uzas '/' en la nomoj.</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>You are missing FeatureCreep classes. Possible reasons:</b><ul><li>You have mods for other versions of FeatureCreep (e.g. ESR vs Nightly or v4 vs v12).</li><li>You can install FeatureCreep from CurseForge or MinecraftStorage.</li></ul><p>Note: You can use the <b>grepr/fgrepr</b> tool in the sidebar to find mods that reference the missing classes, as long as you use '/' in the names.</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>You are missing ModLauncher classes. Possible reasons:</b><ul><li>Your mods are for a different build of MinecraftForge, PillowMC or NeoForge (ModLauncher is used with these loaders).</li><li>There are many modloader updates for a single Minecraft version.</li><li>You have a corrupted launcher installation (common with CurseForge App, ModrinthApp/Theseus/Astralrinth and other modpack launchers). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Watch tutorial</a> to troubleshoot CurseForge issues.</li></ul><p>Note: You can use the <b>grepr/fgrepr</b> tool in the sidebar to find mods that reference the missing classes, as long as you use '/' in the names.</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi mankas klasojn de Minecraft Forge. Eblaj kialoj:</b><ul><li>Viaj modoj estas por alia build de MinecraftForge.</li><li>Ekzistas multaj \u011disdatigoj de modloaders por unu versio de Minecraft.</li><li>Vi havas difektitan instala\u0135on (komune kun CurseForge App, ModrinthApp/Theseus/Astralrinth kaj aliaj modpack-lan\u0109iloj). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Vidu la lernilon</a> por solvi problemojn kun CurseForge.</li></ul><p>Noto: Vi povas uzi la ilon <b>grepr/fgrepr</b> en la flankpanelo por trovi la modojn, kiuj referencas la mankantajn klasojn, \u0109iam kiam vi uzas '/' en la nomoj.</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi mankas klasojn de NeoForge. Eblaj kialoj:</b><ul><li>Viaj modoj estas por alia build de NeoForge.</li><li>Ekzistas multaj \u011disdatigoj de modloaders por unu versio de Minecraft.</li><li>Vi havas difektitan instala\u0135on (komune kun CurseForge App, ModrinthApp/Theseus/Astralrinth kaj aliaj modpack-lan\u0109iloj). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Vidu la lernilon</a> por solvi problemojn kun CurseForge.</li></ul><p>Noto: Vi povas uzi la ilon <b>grepr/fgrepr</b> en la flankpanelo por trovi la modojn, kiuj referencas la mankantajn klasojn, \u0109iam kiam vi uzas '/' en la nomoj.</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi mankas klasojn de Fabric Loader. Eblaj kialoj:</b><ul><li>Viaj modoj estas por alia build de Fabric Loader.</li><li>Ekzistas multaj \u011disdatigoj de modloaders por unu versio de Minecraft.</li><li>Vi havas difektitan instala\u0135on (komune kun CurseForge App, ModrinthApp/Theseus/Astralrinth kaj aliaj modpack-lan\u0109iloj). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Vidu la lernilon</a> por solvi problemojn kun CurseForge.</li><li>Multaj modoj postulas Fabric API. Bonvolu instali Fabric API se necesas.</li></ul><p>Noto: Vi povas uzi la ilon <b>grepr/fgrepr</b> en la flankpanelo por trovi la modojn, kiuj referencas la mankantajn klasojn, \u0109iam kiam vi uzas '/' en la nomoj.</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Vi mankas klasojn de PillowMC. Eblaj kialoj:</b><ul><li>Viaj modoj estas por alia build de PillowMC.</li><li>Ekzistas multaj \u011disdatigoj de modloaders por unu versio de Minecraft.</li><li>Vi havas difektitan instala\u0135on (komune kun CurseForge App, ModrinthApp/Theseus/Astralrinth kaj aliaj modpack-lan\u0109iloj). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Vidu la lernilon</a> por solvi problemojn kun CurseForge.</li></ul><p>Noto: Vi povas uzi la ilon <b>grepr/fgrepr</b> en la flankpanelo por trovi la modojn, kiuj referencas la mankantajn klasojn, \u0109iam kiam vi uzas '/' en la nomoj.</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Vi havas modon, kiu intence ka\u016dzas malrapidon (lag). Uranium estas mod de malrapidigo. \u011ci ne \u0109iam ka\u016dzas kra\u015dojn, sed iam povas fari tion.</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack estas markita kiel kongrua kun 1.19.*, sed estas por 1.20.*, kio ka\u016dzas eraron \"klaso ne trovita\". La mod provas uzi DamageSources, kiuj ne ekzistas en la nuna versio de Minecraft.</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "Versieraro en Falling Attack";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "Certigu, ke vi uzas la \u011dustan version de Falling Attack, kongruan kun via versio de Minecraft.";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("Vi devas instali CFR (Class File Reader) por uzi tiun \u0109i funkcion.<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("En sistemoj Linux, NetBSD a\u016d FreeBSD, vi povas instali CFR per via paka\u0135administrilo.<br>").append("Ser\u0109u la paka\u0135on \u0109e: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("Alternative, vi povas el\u015duti la modifitan version uzatan de FabricMC de:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("Konservu \u011din en la sekva dosierujo:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>Grava:</b> post instali CFR, vi devas restartigi la modon por ke \u011di \u011duste rekonu \u011din.").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "Neniu portreto disponebla";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "Ne eblis trovi la klason: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "Malfasila\u0135ilo CFR \u2013 Sakura Riddle (Neoficiala)";
    }

    @Override
    public String cfrClaseActual() {
        return "Nuna klaso";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "Portreto de Sakura Riddle";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "Eraro dum \u015dargado de la portreto";
    }

    @Override
    public String noticiaLegalCFR() {
        return "\u0108i tiu grafika uzantinterfaco (GUI) por malfasili modojn estas dizajnita por helpi uzantojn identigi la kialojn de programeraroj. Tamen, malfasilo de modoj povas esti necesa, kaj uzantoj devas zorgi ne uzi la generitan kodon por transpasi la Federan Le\u011don pri A\u016dtorrajtoj. Oni rekomendas kontroli la permesilon de la rilata mod anta\u016d ol uzi ajnan akiritan kodon. Plie, ofte modoj ofertas sian fontkodon oficiale, kiu kutime estas pli klara kaj pli facile komprenebla ol malfasilita kodo. Memorindas ke respekto al intelekta propra\u0135o kaj uzpermesiloj estas fundamenta por la mod-elsvolva komunumo. Vi povas konsulti la Federan Le\u011don pri A\u016dtorrajtoj \u0109e: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor (Hispane)</a> kaj la anglan version \u0109i tie: <a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (Angle)</a>. \u0108ar ni estas en CurseForge, ni anka\u016d donas ligilon al la Usona Le\u011do pri A\u016dtorrajto: <a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>. Krome, rekomendi\u011das ke uzantoj esploru la le\u011dojn aplikeblajn en sia propra loko. Nia GUI estas nur por simplaj kontroloj; por pli progresinta analizo, oni devus uzi la Forkon Enigma de FabricMC \u0109e <a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>. Se oni deziras redakti JAR-dosierojn por flikado sen disponebla fontkodo, oni povas uzi Recaf \u0109e <a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">\u011dia retejo</a>.";
    }

    @Override
    public String botonDescargarCfr() {
        return "El\u015duti CFR";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "Malfermi instalan dosierujon";
    }

    @Override
    public String colorFondoPrincipal() {
        return "\u0108efa fona koloro";
    }

    @Override
    public String colorTextoBotonReset() {
        return "Koloro de la teksto de la restar-butono";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "Koloro de la ser\u0109kampa teksto";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "Koloro de la teksto de la falmenuo de filtrado";
    }

    @Override
    public String colorTextoRenderer() {
        return "Koloro de la teksto de la bildigilo (renderilo)";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "Koloro de la teksto de la \u015dar\u011da supermeto (overlay)";
    }

    @Override
    public String colorBorde() {
        return "Koloro de la bordero";
    }

    @Override
    public String colorFondoRetrato() {
        return "Fona koloro en portreta re\u011dimo";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "Koloro de la ligilo por kunhavigi";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "Fona koloro de la kunhaviga kampo";
    }

    @Override
    public String rosaFondo() {
        return "Rozkolora fono";
    }

    @Override
    public String rosaSuave() {
        return "Milda rozo";
    }

    @Override
    public String moradoAcento() {
        return "Akkentpurpuro";
    }

    @Override
    public String textoOscuro() {
        return "Malhela teksto";
    }

    @Override
    public String bordeSuave() {
        return "Milda bordero";
    }

    @Override
    public String fondoCampo() {
        return "Kampa fono";
    }

    @Override
    public String fondoVistaPrevia() {
        return "Anta\u016drigarda fono";
    }

    @Override
    public String sintaxisConstructor() {
        return "Sintaksa koloro: konstruilo";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "Sintaksa koloro: helpmesa\u011do";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "Sintaksa koloro: HTML-etikedoj";
    }

    @Override
    public String colorFondoVentana() {
        return "Fena fona koloro";
    }

    @Override
    public String colorPanel() {
        return "Panela koloro";
    }

    @Override
    public String colorBotonTexto() {
        return "Butona teksta koloro";
    }

    @Override
    public String colorCampo() {
        return "Kampa koloro";
    }

    @Override
    public String colorBordeDestacado() {
        return "Elstara bordera koloro";
    }

    @Override
    public String colorSeleccionTexto() {
        return "Teksta elekta fona koloro";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "Koloro de la elektita teksto";
    }

    @Override
    public String colorEstadoExito() {
        return "Koloro de stato: sukceso";
    }

    @Override
    public String colorEstadoFallo() {
        return "Koloro de stato: malsukceso";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "Koloro de stato: tujtempa";
    }

    @Override
    public String colorResultadoAnadido() {
        return "Koloro de aldonita rezulto";
    }

    @Override
    public String colorResultadoEliminado() {
        return "Koloro de forigita rezulto";
    }

    @Override
    public String colorBordeScroll() {
        return "Koloro de la rul-streka bordero";
    }

    @Override
    public String colorFondoPanel() {
        return "Fona koloro de la panelo";
    }

    @Override
    public String colorBeigeListas() {
        return "Be\u011da koloro de listoj";
    }

    @Override
    public String colorTextoListas() {
        return "Teksta koloro en listoj";
    }

    @Override
    public String colorBordeListas() {
        return "Bordera koloro de listoj";
    }

    @Override
    public String colorBotonFondo() {
        return "Fona koloro de la butono";
    }

    @Override
    public String colorBordeBoton() {
        return "Bordera koloro de la butono";
    }

    @Override
    public String colorDoradoTexto() {
        return "Orkolora teksto";
    }

    @Override
    public String colorPila() {
        return "Koloro de la stakspuro (stack trace)";
    }

    @Override
    public String colorTextoPanel() {
        return "Panea teksta koloro";
    }

    @Override
    public String colorTextoNegro() {
        return "Nigra teksta koloro";
    }

    @Override
    public String colorTextoPrincipal() {
        return "\u0108efa teksta koloro";
    }

    @Override
    public String colorFondoResultados() {
        return "Fona koloro de la rezultoj";
    }

    @Override
    public String colorEstado() {
        return "Koloro de stato";
    }

    @Override
    public String colorTextoDescripcion() {
        return "Priskriba teksta koloro";
    }

    @Override
    public String colorTextoEstado() {
        return "Stata teksta koloro";
    }

    @Override
    public String colorTextoExtra() {
        return "Kroma teksta koloro";
    }

    @Override
    public String colorSeparador() {
        return "Koloro de la dividilo";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "Detektita indi\u011dena eraro <code>StubRoutines::SafeFetch32</code>. \u0108i tiu problemo okazas en macOS kun JDK 17.0.9 kaj estas riparita en JDK 17.0.10 a\u016d pli nova. https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "Indi\u011dena eraro SafeFetch32 en JDK 17.0.9 (macOS)";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "\u011cisdatigu vian JDK al versio 17.0.10 a\u016d pli nova (ekz. 17.0.15).";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "Se vi uzas lan\u0109ilon kiel MultiMC, Prism Launcher a\u016d TLauncher, agordu \u011din por uzi pli novan JDK. Iuj jam inkluzivas JDK 17.0.15 integrite.";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "La mod Spark anka\u016d povas kontribui al \u0109i tiu eraro. Konsideru \u011din provizore mal\u015dalti. https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La mod MCEF (Chromium Embedded Framework) ka\u016dzas silentan \u0109eson.</b><ul><li>MCEF estas iniciatigata \u0109e la fino de la protokolo, kio normale signifas ke la ludo haltis dum \u015dargado.</li><li>\u0108i tiu mod estas konata pro ka\u016dzi kra\u015dojn en Linux, macOS a\u016d kun certaj versioj de Java.</li><li>Ne \u0109iam aperas klara eraro, sed la ludo neniam atingas la \u0109efmenuon.</li></ul><p>Se vi ne bezonas retumilan funkcion en la ludo (kiel retaj mapoj a\u016d enigitaj pa\u011doj), forigu la modon.</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "Problemo de iniciatigo de MCEF (mod de enigita retumilo)";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "Forigu la dosieron de la mod MCEF (ser\u0109u 'mcef' en la dosiernomo) el la dosierujo 'mods'.";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "Se vi vere bezonas \u011din, certigu, ke vi uzas version kongruan kun via operaciumo kaj Minecraft-versio.";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Konflikto estis trovita inter <b>OptiFine</b> kaj <b>Iris/Oculus</b>.</b><ul><li>OptiFine modifas la bildigon de Minecraft nekongrue kun Iris a\u016d Oculus.</li><li>La eraro <code>MixinLevelRenderer failed injection check</code> devenas el <code>mixins.iris.json</code> a\u016d <code>mixins.oculus.json</code>.</li></ul><p>\u0108i tiuj modoj ne uzeblas kune. Forigu OptiFine por uzi shaders kun Iris a\u016d Oculus.</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "Konflikto inter OptiFine kaj Iris/Oculus";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "Forigu la dosieron de OptiFine el la dosierujo 'mods'.";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "Uzu Iris a\u016d Oculus sen OptiFine por modernaj shaders.";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Konflikto estis trovita inter <b>ModernFix</b> kaj <b>OptiFine</b>.</b><ul><li>ModernFix ne estas kongrua kun OptiFine \u0109ar \u011di rompas funkciojn de Forge kaj malrapidigas lan\u0109on.</li><li>ModernFix mem avertas: <i>\"Use of ModernFix with OptiFine is not supported\"</i>.</li></ul><p>Vi devas forigi unu el la du modoj por ke la ludo funkciu \u011duste.</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "Konflikto inter ModernFix kaj OptiFine";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "Forigu OptiFine a\u016d ModernFix el la dosierujo 'mods'. Ili ne uzeblas kune.";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "Se vi bezonas optimumigojn, konsideru uzi nur OptiFine, a\u016d anstata\u016digi ModernFix per pli malpeza\u0135aj modoj kiel FerriteCore a\u016d EntityCulling.";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro: nevalida registra \u015dlosilo kun nepermesitaj signoj.</b><ul><li><b>Detektita \u015dlosilo:</b> <code>" + this.escapeHtml(clave) + "</code></li><li>En Minecraft, \u0109iuj registraj \u015dlosiloj (etikedoj, receptoj, atingoj, ktp.) devas esti <b>minusklaj</b> kaj enhavi nur literojn, ciferojn, substrekojn, strekojn kaj oblikvajn strekojn.</li><li>\u0108i tiu eraro kutime estas ka\u016dzita de malbone programita mod a\u016d difektita datapack.</li></ul><p><b>Grava konsilo:</b> Uzu la ilon <b>grepr</b> a\u016d <b>fgrepr</b> en la flankpanelo kaj aktivigu la opcion <b>\"Ser\u0109i en JAR-dosieroj\"</b> por trovi, kiu mod enhavas \u0109i tiun ne\u011dustan \u015dlosilon.</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "Registra \u015dlosilo kun majuskloj a\u016d nevalidaj signoj";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "Uzu 'grepr' a\u016d 'fgrepr' kun \"Ser\u0109i en JAR-dosieroj\" por lokalizi la kulpan modon.";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "Se vi ne povas identigi la modon, forigu \u0135usajn modojn, precipe tiujn, kiuj aldonas blokojn, objektojn a\u016d ilojn.";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro dum \u015dargado de la mod <b>" + this.escapeHtml(modNombre) + "</b>.</b><ul><li>La mod malsukcesis je la iniciatigo de unu el \u011diaj komponantoj (ekz. agordmenuo).</li><li>Tio kutime okazas pro nekongrueco kun la versio de Minecraft, Fabric a\u016d aliaj modoj.</li></ul><p>Se la eraro persistas, forigu a\u016d \u011disdatigu la mod <b>" + this.escapeHtml(modNombre) + "</b>.</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "Eraro de iniciatigo de mod (Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "Forigu la modon '" + modNombre + "' el la dosierujo 'mods'.";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "\u011cisdatigu la modon '" + modNombre + "' al versio kongrua kun via instala\u0135o.";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro rilata al la mod <b>En Garde!</b> estis trovita.</b><ul><li>\u0108i tiu mod aldonas proksimumkomatajn mekanikojn (parado, blokado, ktp.).</li><li>La eraro kutime okazas pro nekongrueco kun aliaj kombataj modoj (kiel Epic Fight, DualRiders, ktp.) a\u016d pro uzo de mal\u011dusta versio por via Minecraft.</li></ul><p>Se vi ne uzas altnivelan kombaton, konsideru forigi En Garde! por eviti konfliktojn.</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "Eraro en la mod En Garde!";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "Certigu, ke vi uzas la version de En Garde! kongruan kun via Minecraft-versio kaj \u015dargilo (Fabric/Forge).";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "Se vi uzas aliajn kombatajn modojn (Epic Fight, Caelus, ktp.), malaktivigu ilin a\u016d forigu En Garde! por eviti konfliktojn.";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Eraro ka\u016dzita de la mod <b>IdleTweaks</b> estis trovita.</b><ul><li>IdleTweaks provis liberigi neekzistantan retkanalon (<code>Tried to release unknown channel</code>).</li><li>\u0108i tiu eraro kutime okazas en malnovaj versioj de la mod a\u016d kiam \u011di estas uzata sur misagorditaj serviloj.</li></ul><p>IdleTweaks estas mod por plibonigi vivkvaliton, sed \u011di povas ka\u016dzi malstabilecon. Konsideru \u011disdatigi a\u016d forigi \u011din.</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "Eraro en IdleTweaks (nekonata retkanalo)";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "\u011cisdatigu IdleTweaks al la plej nova versio kongrua kun via Minecraft.";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "Forigu IdleTweaks el la dosierujo 'mods' se vi ne bezonas \u011din.";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>A\u016dtentiga eraro (HTTP 401) estis trovita dum provo ensaluti en Minecraft.</b><p>\u0108i tiu eraro <b>malofte estas la rekta kialo de kra\u015do</b>, sed \u011di indikas, ke vi uzas nevalidigitan konton (pirata kopio).</p><p>Oficialaj subtenkanaloj (korporaciaj projektoj, VTubers, kreadintoj de modpaka\u0135oj, ktp.) <b>ne povas helpi vin</b> se vi uzas piratan kopion, pro limigoj en iliaj babilejaj reguloj, kontraktoj, interkonsentoj kun Mojang/Microsoft, a\u016d reputaciaj politikoj.</p><p>\u0108i tiu kontrolo povas esti <b>mal\u015daltita en la korporaciaj agordoj</b> de la detektilo. Averto: la kontra\u016dpirata detekto <b>ne estas perfekta</b> kaj povas aktivi\u011di en programaj medioj, kun malstabila interreto, a\u016d kun modifitaj lan\u0109iloj.</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>Miranda-j rajtoj se vi tamen provas ali\u011di al la subteno:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "Pirata Minecraft";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "Mal\u015dalti kontra\u016dpiratan kontrolon";
    }

    @Override
    public String comprarMC() {
        return "A\u0109eti Minecraft";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Vi uzas la lan\u0109ilon <code>" + id + "</code>, kiu <b>ne estas en la listo de rekomenditaj lan\u0109iloj</b>.</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>\u0108iuj povas funkcii, sed nerekomenditaj lan\u0109iloj kutime ka\u016dzas:</p><ul><li>Difektitan instala\u0135on de modoj a\u016d la Aplika\u0135o.</li><li>Ludo ne lan\u0109i\u011das a\u016d haltas sen klara eraro.</li><li>Nenormalan dosierujan strukturon (malfacilas diagnozon).</li><li>Neprevideblan konduton kun Java, memoro a\u016d modoj.</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "Por pli bona sperto, uzu unu el la sekvaj rekomenditaj lan\u0109iloj:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "Nerekomendita lan\u0109ilo";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "\u015can\u011du al lan\u0109ilo el la rekomendita listo.";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Vi uzas <b>malrekomenditan lan\u0109ilon</b>: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>Malrekomenditaj lan\u0109iloj povas ka\u016dzi:</p><ul><li>Difektitan instala\u0135on de la Aplika\u0135o a\u016d modoj.</li><li>Ludo ne lan\u0109i\u011das a\u016d fiaskas sen bruo.</li><li>Nenormalan aran\u011don de dosieroj (malfacilas depuradon).</li><li>Necerton pri kiel \u011di administras modojn, Java-n a\u016d memoron.</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "Tre rekomendi\u011das uzi unu el la jenaj lan\u0109iloj:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "Malrekomendita lan\u0109ilo";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "\u015can\u011du al rekomendita lan\u0109ilo por ricevi subtenon.";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mankas rekomenditaj modoj por \u0109i tiu medio.</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "Mankantaj rekomenditaj modoj";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "Instalu la rekomenditajn modojn por optimuma sperto.";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Detektita nerekomenditaj modoj en via instala\u0135o.</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "Detektitaj nerekomenditaj modoj";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "Forigu la nerekomenditajn modojn por eviti problemojn.";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Maldol\u0109a manipulado estis trovita en kritikaj dosieroj. Vi a\u016d modifis la dosierojn a\u016d uzas malfidindan lan\u0109ilon.</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "Manipulado detektita";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "Reinstalu la originalajn dosierojn por resta\u016dri la integrecon.";
    }

    @Override
    public String configuracionCorporativa() {
        return "Korporaciaj Agordoj";
    }

    @Override
    public String idiomaRespaldo() {
        return "Rezerva Lingvo";
    }

    @Override
    public String buscardorHabilitado() {
        return "\u015calti Ser\u0109ilon";
    }

    @Override
    public String nombreHerramienta() {
        return "Nomo de la Ilo";
    }

    @Override
    public String condenarPirateria() {
        return "Kondamni Piratadon";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "Rekomenditaj Lan\u0109iloj";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "Nerekomenditaj Lan\u0109iloj";
    }

    @Override
    public String modsRecomendados() {
        return "Rekomenditaj Modoj";
    }

    @Override
    public String modsDesaconsejados() {
        return "Nerekomenditaj Modoj";
    }

    @Override
    public String antiTamper() {
        return "Kontra\u016dManiplado";
    }

    @Override
    public String proximamente() {
        return "Balda\u016d";
    }

    @Override
    public String informacion() {
        return "Informo";
    }

    @Override
    public String errorCargandoImagen() {
        return "Eraro dum \u015dargado de bildo";
    }

    @Override
    public String configuracionBasica() {
        return "Bazaj Agordoj";
    }

    @Override
    public String funcionalidades() {
        return "Funkcioj";
    }

    @Override
    public String derechosMiranda() {
        return "Miranda-j Rajtoj (TRE rekomenditaj)";
    }

    @Override
    public String gestionVerificaciones() {
        return "Administri Kontrolojn";
    }

    @Override
    public String idVerificacion() {
        return "ID";
    }

    @Override
    public String nombreVerificacion() {
        return "Nomo";
    }

    @Override
    public String codigoVerificacion() {
        return "Kodo";
    }

    @Override
    public String documentacionVerificacion() {
        return "Dokumentaro";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "Ebligitaj Kontroloj:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "Malebligitaj Kontroloj:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "Malebligi \u0109iujn ne-korporaciajn";
    }

    @Override
    public String verCodigo() {
        return "Vidi Kodon";
    }

    @Override
    public String verDocumentacion() {
        return "Vidi Dokumentaron";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "Elektu kontrolo por malebligi.";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "Elektu kontrolo por ebligi.";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "Malebligitaj %d kontroloj ne rekomenditaj por korporacia uzo.";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "Neniu ne-korporacia kontrolo por malebligi.";
    }

    @Override
    public String operacionCompletada() {
        return "Operacio finita";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "Ni sopiras vin, Amane Kanata";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "Koloro de Korporacia Kontrolo";
    }

    @Override
    public String nombreLanzador() {
        return "Nomo de la Lan\u0109ilo";
    }

    @Override
    public String motivo() {
        return "Kialo";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "Nerekomenditaj Lan\u0109iloj";
    }

    @Override
    public String moverADesaconsejados() {
        return "Malebligi Rekomendon";
    }

    @Override
    public String moverARecomendados() {
        return "Ebligi Rekomendon";
    }

    @Override
    public String guardarCambios() {
        return "Konservi \u015can\u011dojn";
    }

    @Override
    public String cancelar() {
        return "Nuligi";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "Bonvolu elekti lan\u0109ilon por movi.";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\u015can\u011doj estis sukcese konservitaj!";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "Kialoj";
    }

    @Override
    public String agregarLanzador() {
        return "Aldoni lan\u0109ilon";
    }

    @Override
    public String quitarLanzador() {
        return "Forigi lan\u0109ilon";
    }

    @Override
    public String editarRazones() {
        return "Redakti kialojn";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "Elektu lan\u0109ilon por forigi.";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "Elektu lan\u0109ilon por redakti.";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return "Redakti kialojn por " + idLanzador;
    }

    @Override
    public String agregarNuevoIdioma() {
        return "Aldoni novan lingvon";
    }

    @Override
    public String aceptar() {
        return "Akcepti";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "Elektu la lingvon";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "\u0108i tiuj lan\u0109iloj estas tiuj, kiujn CrashDetector sugestas kiel bonaj.";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "\u011custa rezulto";
    }

    @Override
    public String modsNoRecomendados() {
        return "Nerekomenditaj modoj";
    }

    @Override
    public String agregarMod() {
        return "Aldoni modon";
    }

    @Override
    public String quitarMod() {
        return "Forigi modon";
    }

    @Override
    public String modId() {
        return "Mod-ID / Nomo de JBoss Modules";
    }

    @Override
    public String rutaMod() {
        return "Vojo / dosiero de la modo";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "Vi devas indiki almena\u016d la modid a\u016d la vojon de la modo.";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "\u0108i tie vi povas registri nerekomenditajn modojn por ke CrashDetector detektu ilin, se ili estas instalitaj.";
    }

    @Override
    public String anularNormal() {
        return "Malebligi Normalan";
    }

    @Override
    public String anularNormalDescripcion() {
        return "CrashDetector devus averti e\u0109 se ne okazas kra\u015do.";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "Registru la modojn, kiujn CrashDetector rekomendas. Se ili mankas, CrashDetector povas averti.";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "Se vi decidis ebligi la kontra\u016dpirata averto, rekomendi\u011das difini \u0109i tie la rajtojn de la persono petanta subtenon, kiel preventa mezuro.\n\nKontra\u016de al komuna kredo, multaj popularaj komunumoj kaj subtenkanaloj NE postulas ebligi kontra\u016dpiratajn avertojn por doni helpon. Tamen, dokumenti tiujn rajtojn povas esti utila se iu tamen ali\u011das al la subtenkanalo.\n\nVi povas bazi vin sur oficialaj dokumentoj kiel la Folieto de Bazaj Rajtoj de Arestito en Meksiko:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\nSame kiel sur kompareblaj juraj principoj uzataj en aliaj landoj, inkluzive Usono, Rusia Federacio, Popola Respubliko \u0108inio, Islama Respubliko Iran kaj Demokratia Popola Respubliko Koreio.\n\nKelkaj ekzemploj de rajtoj kiujn oni povas inkluzivi estas:\n\u2022 La rajto ne liveri nenecesajn informojn por subteno, kiel la uzata lan\u0109ilo, uzantnomo a\u016d UUID.\n\u2022 La rajto ne memakuzi sin.\n\u2022 La rajto rifuzi respondi demandojn ne necesajn por solvi la problemon.\n\u2022 La rajto ricevi gvidadon en la babilejo.\n\u2022 La rajto uzi la integritan anonimigilon de protokoloj (logs) en CrashDetector.\n\n\u0108i tiu teksto akceptas HTML-enhavon.";
    }

    @Override
    public String editar() {
        return "Redakti";
    }

    @Override
    public String advertenciaHashLento() {
        return "Averto: aldoni multajn grandajn dosierojn povas igi la kontrolon da\u016dri plurajn minutojn. CrashDetector devos kalkuli la haketon de \u0109iu dosiero anta\u016d ol da\u016drigi. Rekomendi\u011das protekti nur strikte necesajn dosierojn.";
    }

    @Override
    public String agregarArchivo() {
        return "Aldoni dosieron";
    }

    @Override
    public String agregarCarpeta() {
        return "Aldoni dosierujon";
    }

    @Override
    public String quitar() {
        return "Forigi";
    }

    @Override
    public String rutaArchivo() {
        return "Vojo de la dosiero";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "La elektita vojo estas ekster la nuna lud-dosierujo. Nur dosieroj kaj dosierujoj ene de la nuna dosierujo a\u016d \u011diaj subdosierujoj estas permesitaj.";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>La opinioj kaj komentoj de Sylent Bell ne nepre kongruas kun niaj; ni simple pensis, ke estus amuze meti \u015din \u0109i tie. CrashDetector estas laika.</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La mod GML (Groovy ModLoader) postulas tiujn \u015dan\u011dojn kaj estas la plej komuna ka\u016dzo de \u0109i tiu problemo.</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Oni detektis la uzon de <i>Independent Flywheel</i>.</b><p><b>Independent Flywheel estas eksmoda (malrekomendata)</b> kaj ne uzebla en modernaj versioj.</p><p>Aktualaj versioj de <b>Create</b> <b>jam inkluzivas Flywheel</b>, do aparta instalo ka\u016dzas nekongruecojn kaj \u015dargajn erarojn.</p><p>Iuj modoj kiuj eksplicite dependas de Independent Flywheel povas <b>ne funkcii</b> a\u016d <b>funkcii malstabile</b>. En iuj progresintaj kazoj, ili eble funkcios se oni <b>mane redaktas la dosieron <code>mods.toml</code></b> por \u011dustigi versiajn intervalojn, kvankam tio <b>ne rekomendi\u011das</b>.</p>" + (mods.isEmpty() ? "" : "<p><b>Detektitaj modoj referencantaj Flywheel:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>La rekomendita solvo estas <b>forigi Independent Flywheel</b> kaj uzi nur la version inkluzivitan en Create.</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "Sendependa Flywheel";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Eraro rilata al la mod <i>Floral Enchantments</i> estis trovita.</b><p>La kra\u015do estas ka\u016dzita de interna eraro de la mod dum traktado de ludadaj datumoj, kio ka\u016dzas <b>NullPointerException</b> dum ekzekuto.</p><p>\u0108i tiu problemo kutime solvi\u011das per \u011disdatigo a\u016d forigo de la mod.</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "Eraro de Floral Enchantments";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>Vi havas kaj la NeoForge-version kaj la norman version de MixinExtras. Se vi uzas MinecraftForge, vi povas instali <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>\u0109i tiun ligilon</a> por solvi la problemon.</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Eraro estis trovita en terensombroj kun shaders (Iris).</b><p>La problemo okazas dum bildigo de la tereno.</p><p>Oni rekomendas <b>provu ludi sen shaders</b> a\u016d malaltigi grafikan kvaliton, precipe \u0109e agordoj <b>Ultra</b>.</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "Terensombroj (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Tro longa servila tiko estis detektita.</b><p>Tio indikas ke la ludo haltis tro longe dum unu tiko.</p><p>Oni rekomendas <b>kontroli la thread dump</b> generitan en la protokolo por identigi la kialon.</p><p>La <b>Analizo de Stack Trace</b> povas helpi vin trovi la fonton de la blokado.</p><p>Krome tio, la butono <b>Vidi en protokolo</b> markos per ru\u011da koloro eblajn kulpajn modojn, same kiel enirojn \u0109irka\u016ditajn de <code>$modid$</code>, kiuj kutime indikas la probleman fonton. Por realtempa skanado, ni rekomendas uzi la CPU-provanton en VisualVM. Certigu, ke via servilo a\u016d komputilo estas sufi\u0109e pova por pritrakti viajn modojn \u2014 e\u0109 se \u0109iuj funkcias \u011duste, tro multaj povas ka\u016dzi tiun problemon.</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "Longa servila tiko";
    }

    @Override
    public String tituloLFPDPPP() {
        return "FEDERA LE\u011cO PRI PROTEKTO DE PERSONAJ DATUMOJ EN POSIDO DE PRIVATULOJ";
    }

    @Override
    public String aceptarPermanentemente() {
        return "Akcepti permanente";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "La korea traduko enhavas sudajn \u011dargonvortojn, kiujn oni devas eviti por obei la le\u011don. La uzo de fremdlingva\u0135oj, precipe tiuj devenantaj el la Sudo, estas strikte malpermesita la\u016d la Le\u011do pri Protekto de la Kultura Lingvo de Pjongjango.";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "Por pli da informo, vidu la oficialan dokumenton de la le\u011do: <a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>Le\u011do pri Protekto de la Kultura Lingvo de Pjongjango</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "Legi la tutan le\u011don";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "Eraro dum malfermo de la ligilo";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "Le\u011do pri Protekto de la Kultura Lingvo de Pjongjango";
    }

    @Override
    public String canarioTitulo() {
        return "Kanario de Ju\u011da Ordo";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 Videbla Monitoro";
    }

    @Override
    public String revisar() {
        return "Revizii";
    }

    @Override
    public String cerrar() {
        return "Fermi";
    }

    @Override
    public String canarioTodoSeguro() {
        return "\u0108iuj servoj raportas sekuran staton.";
    }

    @Override
    public String canarioComprometido(int c) {
        return "AVERTO: " + c + " servo(j) raportas nesekuran staton.";
    }

    @Override
    public String colorAlerta() {
        return "Averto-koloro";
    }

    @Override
    public String opcionesMunidiales() {
        return "Munidialaj Opcioj";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "Konsento LFPDPPP";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "Ebligi transdonon de alirkodo en Handoff por ReLauncher (malebligita).";
    }

    @Override
    public String consolaDesarrollo() {
        return "Programista Konzolo";
    }

    @Override
    public String mundial() {
        return "Tutmonda";
    }

    @Override
    public String ningun() {
        return "Neniu";
    }

    public String consolaDesarrollador() {
        return "Programista Konzolo";
    }

    @Override
    public String bajar() {
        return "El\u015duti";
    }

    @Override
    public String logsSoporte() {
        return "Protokoloj por subteno";
    }

    @Override
    public String detenerProceso() {
        return "Haltigi procezon";
    }

    @Override
    public String copiarSeleccion() {
        return "Kopii elekta\u0135on";
    }

    @Override
    public String seleccionarTodo() {
        return "Elekti \u0109ion";
    }

    @Override
    public String copiarTodo() {
        return "Kopii \u0109ion";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "Konservi \u0109ion kiel dosieron";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "Akiri ligilon por subteno";
    }

    @Override
    public String borrarTodo() {
        return "Forigi \u0109ion";
    }

    public String colorFondoConsola() {
        return "Fona koloro de la konzolo";
    }

    public String colorTextoConsola() {
        return "Teksta koloro de la konzolo";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "Konsento konfirmi\u011dis.\nLa integrigo por kunhavigi protokolojn estos efektivigita \u0109i tie.";
    }

    @Override
    public String usarSakuraOriginal() {
        return "Uzi la originan bildon de Sakura Riddle";
    }

    @Override
    public String canario1984Descripcion() {
        return "\"Warrant canary\" estas travidebleca mekanismo.\n\nDum \u0109i tiu mesa\u011do ekzistas kaj la servoj aperas kiel sekuraj, tio signifas ke la projekto NE ricevis sekretajn ju\u011dajn ordonojn, cenzurpostulojn, nek le\u011dajn petojn pri surveilado.\n\nSe iu kanario malaperas a\u016d marki\u011das kiel nesekura, tio indikas ke io \u015dan\u011di\u011dis la\u016dle\u011de.\n\n\u0108i tiu panelo kontrolas \u0109iujn registritajn kanariojn en la sistemo kaj montras iliajn aktualajn statojn.\n\nPremu \"Revizii\" por \u011disdatigi la statojn.";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\u0108u restarigi \u0109iujn opciojn al iliaj defa\u016dltaj valoroj?";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "Sen opcioj";
    }

    @Override
    public String seleccionaColor() {
        return "Elekti koloron";
    }

    @Override
    public String botonMostrarGUI() {
        return "Montri GUI";
    }

    @Override
    public String botonGuardarTodo() {
        return "Konservi \u0109ion";
    }

    @Override
    public String botonRestablecerTodo() {
        return "Restarigi \u0109ion";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms ne \u015dargita";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Eraro estis detektita dum aliro al la API de LuckPerms.</b><p>La mesa\u011do indikas ke <b>LuckPerms ne estis \u015dargita</b> kiam alia kroma\u0135o provis uzi \u011din.</p><p><b>Eblaj kialoj:</b></p><ul><li>La kroma\u0135o <b>LuckPerms ne estas instalita</b> a\u016d <b>malsukcesis lan\u0109i\u011di</b>.</li><li>Alia kroma\u0135o provas aliri LuckPerms <b>tropre mature</b> a\u016d <b>mal\u011duste</b>.</li></ul><p>Rekomendi\u011das <b>kontroli la konzolon</b> per la ligilo por identigi la kroma\u0135on, kiu alvokas LuckPerms, kaj kontroli \u011dian kongruecon.</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "Shaderpack de Iris ne \u015dargita";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "nekonata" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Eraro estis detektita dum \u015dargado de shaderpack per Iris/Oculus.</b><p><b>Afektita shaderpack:</b> " + nombre + "</p><p>Minecraft ne povis malfermi la dosieron de la shaderpack (FileSystemNotFoundException).</p><p><b>Eblaj solvoj:</b></p><ul><li>Kontrolu ke la shaderpack estas \u011duste instalita en la dosierujo <b>shaderpacks</b>.</li><li>El\u015dutu la shaderpack denove, \u0109ar la dosiero eble estas difektita.</li><li>Se la problemo da\u016dras, forigu la dosieron <b>config/iris.properties</b> por rekomenci la agordojn de Iris.</li></ul><p>Post apliki la \u015dan\u011dojn, restartigu la ludon.</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "Ne eblis skribi la agorddosieron";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "nekonata" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Eraro okazis dum konservado de agorddosiero.</b><p><b>Afektita dosiero:</b> " + archivo + "</p><p>Minecraft ne povis skribi la dosieron per atoma skribmaniero (REPLACE_ATOMIC).</p><p><b>Tio kutime okazas pro:</b></p><ul><li>Mal\u011dustaj permesoj sur la dosierujo a\u016d dosiero.</li><li>La dosiero estas markita kiel nurlegebla.</li><li>Alia programo (antiviruso, savkopio, redaktilo) blokas la dosieron.</li></ul><p><b>Rekomendoj:</b></p><ul><li>Kontrolu ke vi havas skribpermeson en la dosierujo.</li><li>Forigu la nurlegeblan atributon de la dosiero.</li><li>Fermu programojn kiuj eble uzas tiun dosieron.</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "\ubc31\uc5c5 \uc0dd\uc131 \uc2dc \uc811\uadfc \uac70\ubd80\ub428";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "\uc54c \uc218 \uc5c6\uc74c" : origen;
        String dst = backup == null || backup.isEmpty() ? "\uc54c \uc218 \uc5c6\uc74c" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\uc124\uc815 \ud30c\uc77c\uc758 \ubc31\uc5c5\uc744 \ub9cc\ub4dc\ub294 \ub3c4\uc911 \uad8c\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.</b><p><b>\uc6d0\ubcf8 \ud30c\uc77c:</b> " + src + "</p><p><b>\ubc31\uc5c5 \ud30c\uc77c:</b> " + dst + "</p><p>\uc6b4\uc601\uccb4\uacc4\uac00 \ud30c\uc77c \uc800\uc7a5 \uacfc\uc815\uc5d0\uc11c \uc811\uadfc\uc744 \ucc28\ub2e8\ud558\uc600\uc2b5\ub2c8\ub2e4.</p><p><b>\uc774\ub294 \ubcf4\ud1b5 \ub2e4\uc74c \uc6d0\uc778\uc73c\ub85c \uc77c\uc5b4\ub0a9\ub2c8\ub2e4:</b></p><ul><li>\ud3f4\ub354\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \ubd80\uc871\ud568.</li><li>\ud30c\uc77c\uc774 \uc77d\uae30 \uc804\uc6a9\uc73c\ub85c \ud45c\uc2dc\ub418\uc5ec \uc788\uc74c.</li><li>\ub2e4\ub978 \ud504\ub85c\uadf8\ub78c(\ubc14\uc774\ub7ec\uc2a4 \ubc31\uc2e0, \ub3d9\uae30\ud654 \uc18c\ud504\ud2b8\uc6e8\uc5b4, \ud3b8\uc9d1\uae30 \ub4f1)\uc774 \ud30c\uc77c\uc744 \uc0ac\uc6a9\ud558\uace0 \uc788\uc74c.</li></ul><p><b>\uad8c\uc7a5 \uc870\uce58:</b></p><ul><li><b>config</b> \ud3f4\ub354\uc758 \uad8c\ud55c\uc744 \ud655\uc778\ud558\uc2ed\uc2dc\uc624.</li><li>\ud574\ub2f9 \ud30c\uc77c\uc5d0 \uc811\uadfc\ud558\uace0 \uc788\uc744 \uc218 \uc788\ub294 \ud504\ub85c\uadf8\ub78c\ub4e4\uc744 \uc885\ub8cc\ud558\uc2ed\uc2dc\uc624.</li><li>\ub7f0\ucc98 \ub610\ub294 \ub9c8\uc778\ud06c\ub798\ud504\ud2b8\ub97c \uad00\ub9ac\uc790 \uad8c\ud55c\uc73c\ub85c \uc2e4\ud589\ud574 \ubcf4\uc2ed\uc2dc\uc624.</li></ul>";
    }
}

