/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Japones
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u7121\u52b9\u306amods\u30d5\u30a9\u30eb\u30c0\u30fc</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>CrashDetector\u306eJAR\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>PID\u3092\u691c\u7d22\u4e2d: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") \u7d42\u4e86\u3057\u307e\u3057\u305f\uff01</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>JVM\u304c\u3042\u308a\u307e\u305b\u3093</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>ATI/AMD\u306e\u30c9\u30e9\u30a4\u30d0\u30fc\u3092\u66f4\u65b0\u3059\u308b\u3068\u554f\u984c\u304c\u89e3\u6c7a\u3059\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002\u3053\u306e\u30ac\u30a4\u30c9\u3092\u8aad\u3093\u3067\u4fee\u6b63\u3057\u3066\u304f\u3060\u3055\u3044: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u30c9\u30e9\u30a4\u30d0\u30fc\u66f4\u65b0\u30ac\u30a4\u30c9</a> https://www.amd.com/ja/support/download/drivers.html \u30c0\u30a6\u30f3\u30ed\u30fc\u30c9 </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u4e00\u90e8\u306e\u65e7\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u306f\u3001Nouveau\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u30ab\u30fc\u30c9\u306e\u521d\u671f\u30ed\u30fc\u30c9\u753b\u9762\u3067\u554f\u984c\u304c\u767a\u751f\u3059\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u30c9\u30e9\u30a4\u30d0\u30fc\u306b\u554f\u984c\u304c\u3042\u308a\u307e\u3059\u3002AMD/ATI\u306eGPU\u307e\u305f\u306fAPU\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001AMD\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u30c9\u30e9\u30a4\u30d0\u30fc\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002NVIDIA\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u30ab\u30fc\u30c9\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u30b2\u30fc\u30e0\u3068\u3059\u3079\u3066\u306ejavaw.exe\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u304c\u72ec\u7acb\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u30ab\u30fc\u30c9\u3092\u4f7f\u7528\u3059\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u306e\u30ac\u30a4\u30c9\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u30c9\u30e9\u30a4\u30d0\u30fc\u66f4\u65b0\u30ac\u30a4\u30c9</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>FML\u521d\u671f\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u4fee\u6b63\u3059\u308b\u306b\u306f\u3001(.minecraft/config/fml.toml)\u306b\u79fb\u52d5\u3057\u3001earlyWindowProvider\u3092\"none\"\u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002Mac M1\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001Intel x64\u7248\u3067\u306f\u306a\u304fARM\u7248Java\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u307e\u305f\u3001\u30c9\u30e9\u30a4\u30d0\u30fc\u304c\u53e4\u3044\u3053\u3068\u304c\u539f\u56e0\u3067\u3042\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002Windows\u3067\u3053\u306e\u8a2d\u5b9a\u3092\u7121\u52b9\u306b\u3057\u3066\u3082\u6539\u5584\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u3053\u306e\u30ac\u30a4\u30c9\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u30c9\u30e9\u30a4\u30d0\u30fc\u66f4\u65b0\u30ac\u30a4\u30c9</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u5fc5\u8981\u306a\u4f9d\u5b58\u95a2\u4fc2\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "\u8981\u6c42\u5143").replace("Expected range", "\u671f\u5f85\u7bc4\u56f2") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>CrashDetector\u30ec\u30dd\u30fc\u30c8\u306f\u3053\u3061\u3089 <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>\u30ec\u30dd\u30fc\u30c8\u3092\u898b\u308b</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u3053\u308c\u306fCrashDetector\u306eGUI\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3067\u3059\u3002\u30b2\u30fc\u30e0\u304c\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u305f\u5834\u5408\u306f\u3001\u3053\u306e\u753b\u9762\u3092\u7121\u8996\u3057\u3066\u304f\u3060\u3055\u3044\u3002</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>\u30ec\u30dd\u30fc\u30c8\u3092\u898b\u308b</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u30d6\u30e9\u30a6\u30b6\u3067\u30ed\u30fc\u30ab\u30eb\u30ec\u30dd\u30fc\u30c8\u3092\u8868\u793a\u3057\u307e\u3059\u3002</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "\u30ec\u30dd\u30fc\u30c8\u3092\u5171\u6709";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "\u30ec\u30dd\u30fc\u30c8\u3092\u5171\u6709\u3057\u307e\u3059\u3002\u30ed\u30b0\u306fsecurelogger.net\u306b\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3055\u308c\u3001\u30ec\u30dd\u30fc\u30c8\u306f\u4ed6\u306e\u30b5\u30a4\u30c8\u306b\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3059\u3002";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u554f\u984c\u306e\u3042\u308bJAR\u30d5\u30a1\u30a4\u30eb\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\uff08FATAL\u3092\u512a\u5148\u3057\u3001\u6b21\u306b\u9ad8\u512a\u5148\u5ea6\u3068\u4f4e\u512a\u5148\u5ea6\uff09:</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> \u30ec\u30d9\u30eb:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u81f4\u547d\u7684\u306a\u53ef\u80fd\u6027:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u554f\u984c\u306e\u3042\u308bModID\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\uff08FATAL\u3092\u512a\u5148\u3057\u3001\u6b21\u306b\u4f4e\u512a\u5148\u5ea6\u3068\u4f4e\u512a\u5148\u5ea6\uff09:</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u554f\u984c\u306e\u3042\u308b\u30d1\u30c3\u30b1\u30fc\u30b8\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\uff08FATAL\u3092\u512a\u5148\u3057\u3001\u6b21\u306b\u4f4e\u512a\u5148\u5ea6\u3068\u4f4e\u512a\u5148\u5ea6\uff09:</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u81f4\u547d\u7684\u306a\u30af\u30e9\u30b9 (FATAL) \u304c\u5b58\u5728\u3057\u307e\u3059\u3002\u975e\u5e38\u306b\u6df1\u523b\u306a\u554f\u984c\u3067\u3059\u3002\u539f\u56e0\u306f\u4e0d\u6b63\u306a CoreMod \u3084\u81f4\u547d\u7684\u306a\u4f9d\u5b58\u95a2\u4fc2\u306a\u3069\u3067\u3059\u3002QuickFix \u3092\u4f7f\u3063\u3066\u81f4\u547d\u7684\u30af\u30e9\u30b9\u3092\u6301\u3064 MOD \u3092\u691c\u7d22\u3067\u304d\u307e\u3059\u3002\u691c\u51fa\u3055\u308c\u305f\u6b20\u843d\u3057\u3066\u3044\u308b\u81f4\u547d\u7684\u30af\u30e9\u30b9\uff1a</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>{}\u5185\u306e\u5185\u5bb9\uff08\u6700\u3082\u91cd\u8981\u306a\u3082\u306e\u304c\u4e0a\u306b\u3042\u308a\u3001\u6700\u521d\u306e20\u500b\u306e\u307f\u8868\u793a\uff09:</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u554f\u984c\u306e\u3042\u308bSpongeMixin\u8a2d\u5b9a\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u8907\u3057\u305f\u30d1\u30c3\u30b1\u30fc\u30b8\u3092\u542b\u3080MOD\u304c\u3042\u308a\u307e\u3059\u3002JAR\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u91cd\u8907\u3057\u305f\u30d1\u30c3\u30b1\u30fc\u30b8\uff08\u30d5\u30a9\u30eb\u30c0\uff09\u3092\u524a\u9664\u3059\u308b\u3053\u3068\u3067\u89e3\u6c7a\u3067\u304d\u307e\u3059\u3002WinRAR\u30847z\u306a\u3069\u306e\u30a2\u30fc\u30ab\u30a4\u30d6\u30bd\u30d5\u30c8\u3067JAR\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u304b\u3001\u62e1\u5f35\u5b50\u3092.jar\u304b\u3089.zip\u306b\u5909\u66f4\u3057\u3066\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3057\u3001\u518d\u5ea6.jar\u306b\u623b\u3059\u3053\u3068\u3082\u53ef\u80fd\u3067\u3059\u3002</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u8907\u3059\u308bMods\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f</b> " + linea.replace("from mod files", "mod\u30d5\u30a1\u30a4\u30eb\u304b\u3089");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge\u304c\u7591\u308f\u3057\u3044mod\u306b\u554f\u984c\u304c\u3042\u308b\u3053\u3068\u3092\u691c\u51fa\u3057\u307e\u3057\u305f:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV\u306b\u306flithostitched\u304c\u5fc5\u8981\u3067\u3059\u3002\u3053\u3061\u3089\u304b\u3089\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3067\u304d\u307e\u3059: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris\u30b7\u30a7\u30fc\u30c0\u30fc\u307e\u305f\u306fOculus\u3092\u4f7f\u7528\u3059\u308b\u306b\u306f\u3001SODIUM\u307e\u305f\u306f\u4ed6\u306e\u30ed\u30fc\u30c0\u30fc\u306e\u4e92\u63db\u30d0\u30fc\u30b8\u30e7\u30f3\uff08Rubidium\u3001Embedium\u3001Bedium\uff09\u304c\u5fc5\u8981\u3067\u3059</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>KubeJS\u62e1\u5f35\u306b\u554f\u984c\u304c\u3042\u308a\u307e\u3059 </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Windows 11\u3088\u308a\u524d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3067NVIDIA\u30c9\u30e9\u30a4\u30d0\u30fc\u306b\u95a2\u3059\u308b\u554f\u984c\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</span><br/><br/>Minecraft\uff08\u304a\u3088\u3073\u73fe\u5728\u306eJVM\uff09\u304c\u5c02\u7528\u306eNVIDIA GPU\u3092\u4f7f\u7528\u3059\u308b\u3088\u3046\u306b\u3059\u308b\u306b\u306f\u3001\u6b21\u306e\u624b\u9806\u306b\u5f93\u3063\u3066\u304f\u3060\u3055\u3044\uff1a<br/><br/>1. <strong>Java\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\u3092\u7279\u5b9a\u3057\u307e\u3059\uff1a</strong><br/>   - \u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u6b21\u306eJava\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\uff1a " + this.obtenerRutaJava() + "<br/>   - \u7279\u5b9a\u306e\u30d1\u30b9\u304c\u8868\u793a\u3055\u308c\u306a\u3044\u5834\u5408\u3001\u30b7\u30b9\u30c6\u30e0\u5185\u3067'java.exe'\u3092\u691c\u7d22\u3057\u3066Java\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002<br/><br/>2. <strong>NVIDIA\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u30d1\u30cd\u30eb\u3092\u958b\u304d\u307e\u3059\uff1a</strong><br/>   - \u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u3092\u53f3\u30af\u30ea\u30c3\u30af\u3057\u3001'NVIDIA\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u30d1\u30cd\u30eb'\u3092\u9078\u629e\u3057\u307e\u3059\u3002<br/><br/>3. <strong>\u512a\u5148GPU\u3092\u8a2d\u5b9a\u3057\u307e\u3059\uff1a</strong><br/>   - NVIDIA\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u30d1\u30cd\u30eb\u3067\u3001'3D\u8a2d\u5b9a\u306e\u7ba1\u7406'\u306b\u79fb\u52d5\u3057\u307e\u3059\u3002<br/>   - '\u30d7\u30ed\u30b0\u30e9\u30e0\u8a2d\u5b9a'\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u9078\u629e\u3057\u307e\u3059\u3002<br/>   - '\u8ffd\u52a0'\u3092\u30af\u30ea\u30c3\u30af\u3057\u3001\u524d\u8ff0\u306eJava\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\uff08\u4f8b\uff1a'java.exe'\uff09\u3092\u63a2\u3057\u307e\u3059\u3002<br/>   - '\u9ad8\u6027\u80fdNVIDIA\u30d7\u30ed\u30bb\u30c3\u30b5'\u3092\u4f7f\u7528\u3059\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002<br/><br/>4. <strong>\u5909\u66f4\u3092\u4fdd\u5b58\u3057\u307e\u3059\uff1a</strong><br/>   - \u5909\u66f4\u3092\u9069\u7528\u3057\u3001NVIDIA\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u30d1\u30cd\u30eb\u3092\u9589\u3058\u307e\u3059\u3002<br/><br/>5. <strong>Minecraft\u3092\u518d\u8d77\u52d5\u3057\u307e\u3059\uff1a</strong><br/>   - Minecraft\u3092\u518d\u8d77\u52d5\u3057\u3066\u5909\u66f4\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u3002<br/><br/>Windows Server 2022\u307e\u305f\u306fWindows 10\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u6700\u65b0\u306eNVIDIA\u30c9\u30e9\u30a4\u30d0\u30fc\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u9650\u308a\u3001\u3053\u308c\u3089\u306e\u624b\u9806\u306f\u6709\u52b9\u3067\u3059\u3002<br/><br/>\u6ce8\uff1aNVIDIA\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u30d1\u30cd\u30eb\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u5834\u5408\u306f\u3001NVIDIA\u30c9\u30e9\u30a4\u30d0\u30fc\u304c\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Windows 11/Server 2025\u4ee5\u964d\u3067NVIDIA\u30c9\u30e9\u30a4\u30d0\u30fc\u306b\u95a2\u3059\u308b\u554f\u984c\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</span><br/><br/>Minecraft\uff08\u304a\u3088\u3073\u73fe\u5728\u306eJVM\uff09\u304c\u5c02\u7528\u306eNVIDIA GPU\u3092\u4f7f\u7528\u3059\u308b\u3088\u3046\u306b\u3059\u308b\u306b\u306f\u3001\u6b21\u306e\u624b\u9806\u306b\u5f93\u3063\u3066\u304f\u3060\u3055\u3044\uff1a<br/><br/>1. <strong>Java\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\u3092\u7279\u5b9a\u3057\u307e\u3059\uff1a</strong><br/>   - \u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u6b21\u306eJava\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\uff1a " + this.obtenerRutaJava() + "<br/>   - \u7279\u5b9a\u306e\u30d1\u30b9\u304c\u8868\u793a\u3055\u308c\u306a\u3044\u5834\u5408\u3001\u30b7\u30b9\u30c6\u30e0\u5185\u3067'java.exe'\u3092\u691c\u7d22\u3057\u3066Java\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002<br/><br/>2. <strong>\u8a2d\u5b9a\u30a2\u30d7\u30ea\u3092\u958b\u304d\u307e\u3059\uff1a</strong><br/>   - <code>Win + I</code>\u30ad\u30fc\u3092\u62bc\u3057\u3066\u8a2d\u5b9a\u30a2\u30d7\u30ea\u3092\u958b\u304d\u307e\u3059\u3002<br/>   - <strong>\u30b7\u30b9\u30c6\u30e0 > \u30c7\u30a3\u30b9\u30d7\u30ec\u30a4 > \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9</strong>\u306b\u79fb\u52d5\u3057\u307e\u3059\u3002<br/><br/>3. <strong>\u512a\u5148GPU\u3092\u8a2d\u5b9a\u3057\u307e\u3059\uff1a</strong><br/>   - '\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9'\u30bb\u30af\u30b7\u30e7\u30f3\u3067\u3001'\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u8a2d\u5b9a'\u3092\u30af\u30ea\u30c3\u30af\u3057\u307e\u3059\u3002<br/>   - '\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u30a2\u30d7\u30ea'\u3092\u9078\u629e\u3057\u3001'\u53c2\u7167'\u3092\u30af\u30ea\u30c3\u30af\u3057\u307e\u3059\u3002<br/>   - \u524d\u8ff0\u306eJava\u5b9f\u884c\u53ef\u80fd\u30d5\u30a1\u30a4\u30eb\uff08\u4f8b\uff1a'java.exe'\uff09\u3092\u63a2\u3057\u3066\u9078\u629e\u3057\u307e\u3059\u3002<br/>   - \u8ffd\u52a0\u5f8c\u3001\u30ea\u30b9\u30c8\u304b\u3089Java\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u9078\u629e\u3057\u3001'\u9ad8\u6027\u80fd\uff08NVIDIA\uff09'\u3092\u4f7f\u7528\u3059\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3057\u307e\u3059\u3002<br/><br/>4. <strong>\u5909\u66f4\u3092\u4fdd\u5b58\u3057\u307e\u3059\uff1a</strong><br/>   - \u5909\u66f4\u3092\u9069\u7528\u3057\u3001\u8a2d\u5b9a\u30a2\u30d7\u30ea\u3092\u9589\u3058\u307e\u3059\u3002<br/><br/>5. <strong>Minecraft\u3092\u518d\u8d77\u52d5\u3057\u307e\u3059\uff1a</strong><br/>   - Minecraft\u3092\u518d\u8d77\u52d5\u3057\u3066\u5909\u66f4\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u3002<br/><br/>Windows 11\u307e\u305f\u306fWindows Server 2025+\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u6700\u65b0\u306eNVIDIA\u30c9\u30e9\u30a4\u30d0\u30fc\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u9650\u308a\u3001\u3053\u308c\u3089\u306e\u624b\u9806\u306f\u6709\u52b9\u3067\u3059\u3002<br/><br/>\u6ce8\uff1a\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u8a2d\u5b9a\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u5834\u5408\u3001NVIDIA\u30c9\u30e9\u30a4\u30d0\u30fc\u304c\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3042\u306a\u305f\u306e\u30b5\u30fc\u30d0\u30fc\u307e\u305f\u306f\u30ef\u30fc\u30eb\u30c9\u306760\u79d2\u3092\u8d85\u3048\u308b\u30c6\u30a3\u30c3\u30af\u304c\u767a\u751f\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u308c\u306f\u3001MOD\u304c\u30b5\u30fc\u30d0\u30fc\u3092\u9045\u304f\u3057\u3066\u3044\u308b\u304b\u3001\u30cf\u30fc\u30c9\u30a6\u30a7\u30a2\u304c\u5f31\u3059\u304e\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5341\u5206\u306aRAM/\u30e1\u30e2\u30ea\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u3088\u308a\u591a\u304f\u306e\u30e1\u30e2\u30ea\u3092\u5272\u308a\u5f53\u3066\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Theseus\u306b\u306f\u3001\u524a\u9664\u3092\u8a66\u307f\u3066\u3082MOD\u3092\u524a\u9664\u3067\u304d\u306a\u3044\u306a\u3069\u306e\u8ffd\u52a0\u306e\u554f\u984c\u304c\u3042\u308a\u307e\u3059\u3002mrpack\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u5834\u5408\u306f\u3001Prism Launcher\uff08modrinth.com\u5c02\u7528\uff09\u3001ATLauncher\uff08modrinth.com\u5c02\u7528\uff09\u3001Hello Minecraft Launcher\uff08modrinth.com\u304a\u3088\u3073bbsmc.net\u5bfe\u5fdc\uff09\u306a\u3069\u306e\u4ed6\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u3054\u5229\u7528\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u300c\u30e9\u30f3\u30c1\u30e3\u30fc\u8d77\u52d5\u3092\u30b9\u30ad\u30c3\u30d7\u300d\uff08CurseForge\u30a2\u30d7\u30ea\uff09\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u308c\u306b\u3088\u308a\u3001\u691c\u51fa\u304c\u96e3\u3057\u3044\u554f\u984c\u304c\u767a\u751f\u3059\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002\u3053\u308c\u306f\u3001\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u307e\u305f\u306f\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306eCurseForge\u30a2\u30d7\u30ea\u306b\u3042\u308b\u300c\u30e9\u30f3\u30c1\u30e3\u30fc\u8d77\u52d5\u3092\u30b9\u30ad\u30c3\u30d7\u300d\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u3088\u308b\u3082\u306e\u3067\u3059\u3002\u3053\u308c\u3092\u7121\u52b9\u5316\u3057\u3001CurseForge\u8a2d\u5b9a\u3067\u300cMojang Launcher\u300d\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002Claws of Berk\u306e\u82f1\u8a9e\u52d5\u753b\uff081\u520611\u79d2\u304b\u3089\uff09\u3092<a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>\u3053\u3061\u3089</a>\u3067\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u8b66\u544a\uff1a\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\uff08\u8b66\u544a\u30ec\u30d9\u30eb\uff09\u3002\u81f4\u547d\u7684\u306a\u30a8\u30e9\u30fc\u3068\u306f\u7570\u306a\u308a\u3001\u901a\u5e38\u306f\u554f\u984c\u3042\u308a\u307e\u305b\u3093\u304c\u3001\u5834\u5408\u306b\u3088\u3063\u3066\u306f\u5f71\u97ff\u304c\u51fa\u308b\u3053\u3068\u3082\u3042\u308a\u307e\u3059\u3002\u539f\u56e0\u3068\u3057\u3066\u4e0d\u6b63\u306a CoreMod \u3084\u4e0d\u8db3\u3057\u305f\u4f9d\u5b58\u95a2\u4fc2\u304c\u8003\u3048\u3089\u308c\u307e\u3059\u3002QuickFix \u3092\u4f7f\u7528\u3057\u3066\u3001\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u6301\u3064 MOD \u3092\u691c\u7d22\u3067\u304d\u307e\u3059\u3002\u691c\u51fa\u3055\u308c\u305f\u4e0d\u8db3\u30af\u30e9\u30b9\uff1a</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u7d50\u679c\u306a\u3057</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u30ed\u30b0\u306e\u5834\u6240:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u3053\u3053\u306b\u691c\u8a3c\u7d50\u679c\u3092\u793a\u3057\u307e\u3059\u3002\u3086\u3063\u304f\u308a\u3068\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u901a\u5e38\u3001\u6b63\u3057\u3044\u539f\u56e0\u306f\u30c1\u30a7\u30c3\u30af1\u307e\u305f\u306f2\u306b\u3042\u308a\u307e\u3059\u3002\u305d\u308c\u4ee5\u964d\uff08\u30a8\u30e9\u30fc3\u4ee5\u4e0a\uff09\u306f\u78ba\u8a8d\u7528\u306b\u4f7f\u3048\u307e\u3059\u304c\u3001\u4e00\u822c\u7684\u306b\u306f\u9023\u9396\u7684\u306a\u30a8\u30e9\u30fc\u306a\u306e\u3067\u7121\u8996\u3057\u3066\u69cb\u3044\u307e\u305b\u3093\u3002\u969c\u5bb3\u306f\u5c64\u72b6\u306b\u767a\u751f\u3059\u308b\u305f\u3081\u3001\u6839\u672c\u7684\u306a\u554f\u984c\u3092\u89e3\u6c7a\u3059\u308c\u3070\u3053\u306e\u7279\u5b9a\u306e\u30a8\u30e9\u30fc\u306f\u89e3\u6d88\u3055\u308c\u307e\u3059\u3002\u305f\u3060\u3057\u3001\u3042\u308b\u30a8\u30e9\u30fc\u304c\u5225\u306e\u30a8\u30e9\u30fc\u306e\u30b3\u30f3\u30bd\u30fc\u30eb\u8868\u793a\u3092\u59a8\u3052\u308b\u3053\u3068\u304c\u591a\u3044\u305f\u3081\u3001\u660e\u65e5\u306b\u306a\u3063\u3066\u95a2\u4fc2\u306e\u306a\u3044\u65b0\u3057\u3044\u30a8\u30e9\u30fc\u304c\u73fe\u308c\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>1.17-1.20.4\u306e\u5834\u5408\u306fJava 17\u3092\u4f7f\u7528\u3057\u3001\u305d\u308c\u4ee5\u964d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u5834\u5408\u306fJava 21\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u5834\u5408\u306fJava 8\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002[\u30ac\u30a4\u30c9](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). \u554f\u984c\u304c\u89e3\u6c7a\u3057\u306a\u3044\u5834\u5408\u3001\u4e00\u90e8\u306eMod\u306b\u30d5\u30a1\u30a4\u30eb\u304c\u65b0\u3057\u3059\u304e\u305f\u308a\u53e4\u3059\u304e\u305f\u308a\u3059\u308b\u3053\u3068\u304c\u539f\u56e0\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 22\u4ee5\u964d\u306f\u3001ASM\u304c\u53e4\u3044\u3053\u3068\u306b\u3088\u308a\u30011.20.5\u672a\u6e80\u306eMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u306f\u307b\u3068\u3093\u3069\u306eMod\u30ed\u30fc\u30c0\u30fc\u3067\u52d5\u4f5c\u3057\u307e\u305b\u3093\u3002</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java\u306f\u53e4\u3044\u3067\u3059 </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JPMS\u30e2\u30b8\u30e5\u30fc\u30eb " + mod_necesitas + " \u3092 " + submod + " \u304b\u3089\u53d6\u5f97\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + metodo + " \u3092\u547c\u3073\u51fa\u305b\u307e\u305b\u3093\u3002\u7406\u7531: " + objeto + " \u304c null \u3067\u3059</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "\u9ad8\u5ea6\u306a\u5206\u6790";
    }

    @Override
    public String seleccionarCarpeta() {
        return "\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e";
    }

    @Override
    public String cadenaBusqueda() {
        return "\u691c\u7d22\u6587\u5b57\u5217";
    }

    @Override
    public String usarRegex() {
        return "\u6b63\u898f\u8868\u73fe\u3092\u4f7f\u7528";
    }

    @Override
    public String ignorarMayusculas() {
        return "\u5927\u6587\u5b57\u3092\u7121\u8996";
    }

    @Override
    public String buscar() {
        return "\u691c\u7d22";
    }

    @Override
    public String busquedaEnProgreso() {
        return "\u691c\u7d22\u9032\u884c\u4e2d";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "\u7d50\u679c\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f";
    }

    @Override
    public String errorBusqueda() {
        return "\u691c\u7d22\u30a8\u30e9\u30fc";
    }

    @Override
    public String omitirYCerrar() {
        return "\u30b9\u30ad\u30c3\u30d7\u3057\u3066\u9589\u3058\u308b";
    }

    @Override
    public String guardarYCerrar() {
        return "\u4fdd\u5b58\u3057\u3066\u9589\u3058\u308b";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "\u30ed\u30b0\u3092\u3053\u3053\u306b\u8cbc\u308a\u4ed8\u3051";
    }

    @Override
    public String archivo() {
        return "\u30d5\u30a1\u30a4\u30eb";
    }

    @Override
    public String incluir() {
        return "\u542b\u3081\u308b";
    }

    @Override
    public String abrir() {
        return "\u958b\u304f";
    }

    @Override
    public String endpointDeInforme() {
        return "\u30ec\u30dd\u30fc\u30c8\u30a8\u30f3\u30c9\u30dd\u30a4\u30f3\u30c8";
    }

    @Override
    public String sitoDeLogging() {
        return "\u30ed\u30b0\u30b5\u30a4\u30c8\uff1a";
    }

    @Override
    public String apiDeLogging() {
        return "\u30ed\u30b0API\uff1a";
    }

    @Override
    public String anonimizarRegistros() {
        return "\u30ed\u30b0\u3092\u533f\u540d\u5316 (\u30d9\u30fc\u30bf)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "\u30ec\u30dd\u30fc\u30c8\u3068\u9078\u629e\u3057\u305f\u3059\u3079\u3066\u306e\u30ed\u30b0\u3092\u5171\u6709";
    }

    @Override
    public String arco() {
        return "This dialogue allows you to share logs using the SecureLogger API at <a href=\"https://securelogger.net\">securelogger.net</a>. When you press the button to share the report, your report is sent to the selected endpoint (default: asbestosstar.egoism.jp) (changeable at the bottom). You can share all selected logs together with the report. If you do not wish to upload, do not use this dialogue! We do not process your report on the official endpoint (<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>); we only remove disallowed links. The code is here: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">source code</a>. This is used solely to display information about your crash and the link to the logs. However, you may use a custom endpoint that might not use the same methods. You are using the report site " + Config.obtenerInstancia().obtenerSitoDeInformes() + " and the log site " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + ". You can also share individual logs without a report by pressing the share buttons next to individual log names; the logs will go to the selected log site. CrashDetector has default log anonymisation, which attempts to remove usernames, UUIDs, access tokens, session IDs, IP addresses, and other data. However, it is not perfect. Nevertheless, the modpack author can disable it. It can be enabled or disabled via the checkbox at the bottom of this screen. You are the controller of your own data; you decide where to upload your data. Log sites are owned by third parties whose ownership is often hidden for privacy reasons. You assume full responsibility for managing your data and the associated risks. CrashDetector\u2019s Share Dialogue is merely an interface that allows you to manage this. It is important that you are aware of GDPR and ARCO. If you are in Europe, you can use <a href=\"https://securelogger.top\">securelogger.top</a> hosted in Germany by Hetzner. For more legal information, consult the following links: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>, <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>, <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">Japan\u2019s Basic Policy on Personal Information Protection</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "\u30ec\u30dd\u30fc\u30c8\u30ea\u30f3\u30af\uff1a";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "\u5171\u6709\u8a2d\u5b9a\u3092\u4fdd\u5b58";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "\u30ed\u30b0\u304c\u3053\u306e\u30ed\u30b0\u30b5\u30a4\u30c8\u3067\u306f\u5927\u304d\u3059\u304e\u307e\u3059\u3002\u5225\u306e\u30b5\u30a4\u30c8\u3092\u9078\u3093\u3067\u518d\u5ea6\u304a\u8a66\u3057\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "\u30ed\u30b0\u306e\u516c\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "\u30ed\u30b0API\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u8a2d\u5b9a\u3067\u30ed\u30b0API\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorSSL() {
        return "SSL\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u308c\u306f\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306eJava\u3067\u4e00\u822c\u7684\u3067\u3042\u308a\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u306eMinecraft\u30e9\u30f3\u30c1\u30e3\u30fc\u5185\u306eJava 8\u30d0\u30fc\u30b8\u30e7\u30f3\u3084sun.com\u3001java.com\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u542b\u307e\u308c\u307e\u3059\u3002\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001MinecraftForge\u30a4\u30f3\u30b9\u30c8\u30fc\u30e9\u30fc\u306eJAR\u30d5\u30a1\u30a4\u30eb\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u30a8\u30f3\u30c9\u30dd\u30a4\u30f3\u30c8\u3092\u4f7f\u7528\u3057\u305fCrashDetector\u30ec\u30dd\u30fc\u30c8\u306e\u5171\u6709\u6a5f\u80fd\u3001\u30a4\u30f3\u30bf\u30fc\u30cd\u30c3\u30c8\u3092\u5fc5\u8981\u3068\u3059\u308b\u4e00\u90e8\u306eMOD\u3001\u304a\u3088\u3073\u3044\u304f\u3064\u304b\u306e\u30ed\u30b0\u30b5\u30a4\u30c8\u306b\u5f71\u97ff\u3092\u4e0e\u3048\u307e\u3059\u3002\u3053\u308c\u3092\u30ec\u30dd\u30fc\u30c8\u306e\u5171\u6709\u4e2d\u306b\u906d\u9047\u3057\u305f\u5834\u5408\u3001\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u3092\u6dfb\u4ed8\u3057\u3001\u53e4\u3044Java 8\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u30ed\u30b0\u30b5\u30a4\u30c8\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u4e92\u63db\u6027\u306e\u306a\u3044 JavaFML \u306e\u30d0\u30fc\u30b8\u30e7\u30f3: \u5fc5\u8981\u306a\u306e\u306f " + requerido + " \u3067\u3059\u304c\u3001\u898b\u3064\u304b\u3063\u305f\u306e\u306f " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u6ce8\u610f\uff01 JavaFML \u306f\u7279\u5b9a\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Minecraft Forge \u3092\u5fc5\u8981\u3068\u3057\u307e\u3059</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JAR\u30d5\u30a1\u30a4\u30eb '" + archivoJar + "' \u306f\u3001\u8a00\u8a9e\u30d7\u30ed\u30d0\u30a4\u30c0\u30fc '" + proveedor + "' \u306e\u30d0\u30fc\u30b8\u30e7\u30f3 '" + requerido + "' \u4ee5\u4e0a\u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u304c\u3001\u898b\u3064\u304b\u3063\u305f\u306e\u306f\u30d0\u30fc\u30b8\u30e7\u30f3 '" + encontrado + "' \u3067\u3059\u3002</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8b66\u544a\uff01 Crash Assistant \u306f\u507d\u306e\u30de\u30eb\u30a6\u30a7\u30a2\u691c\u51fa\u30c4\u30fc\u30eb\u3067\u3059\u3002\u610f\u56f3\u7684\u306b\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u30d6\u30ed\u30c3\u30af\u3057\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\u3068\u306a\u308b MOD \u3092\u4f7f\u7528\u3057\u3066\u30d7\u30ec\u30a4\u3059\u308b\u81ea\u7531\u3092\u7121\u8996\u3057\u307e\u3059\u3002 <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>MalwareMod.java \u306e\u30b3\u30fc\u30c9\u3092\u898b\u308b</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>JarInJarHelper.java \u306e\u30b3\u30fc\u30c9\u3092\u898b\u308b</a>. \u73fe\u6642\u70b9\u3067\u306f\u3053\u306e MOD \u3060\u3051\u304c\u30ea\u30b9\u30c8\u306b\u8f09\u3063\u3066\u304a\u308a\u3001\u5f7c\u3089\u306f\u5b9f\u969b\u306b\u306f\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30ed\u30b0\u30b5\u30a4\u30c8\u306e\u307f\u3092\u5bfe\u8c61\u3068\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u306e\u30b5\u30a4\u30c8\u306f\u30e6\u30fc\u30b6\u30fc\u304c\u5909\u66f4\u53ef\u80fd\u3067\u3001\u7d44\u307f\u8fbc\u307f\u306e\u30ed\u30b0\u5171\u6709\u6a5f\u80fd\u3092\u660e\u793a\u7684\u306b\u9078\u629e\u3057\u305f\u5834\u5408\u306b\u306e\u307f\u52d5\u4f5c\u3057\u307e\u3059\u3002CrashAssistant \u306f\u3069\u306e\u30ed\u30b0\u30b5\u30a4\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u304b\u30c1\u30a7\u30c3\u30af\u305b\u305a\u3001\u307e\u305f\u5909\u66f4\u65b9\u6cd5\uff08\u5171\u6709\u30c0\u30a4\u30a2\u30ed\u30b0\u306e\u4e0b\u90e8\u306b\u3042\u308b\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\uff09\u3092\u8aac\u660e\u3057\u307e\u305b\u3093\u3002\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u30b5\u30a4\u30c8\u306b\u95a2\u4fc2\u306a\u304f\u3001CrashAssistant \u306f\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u30d6\u30ed\u30c3\u30af\u3057\u307e\u3059\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u4e2d\u3067\u5f7c\u3089\u306f\u72ec\u81ea\u306e\u8abf\u67fb\u3092\u3059\u308b\u3088\u3046\u306b\u8a00\u3063\u3066\u3044\u307e\u3059\u304c\u3001\u305d\u306e\u901a\u308a\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002CrashDetector \u3068 Crash Assistant \u306e\u30b3\u30fc\u30c9\u3092\u8abf\u3079\u3001\u4f55\u3092\u3057\u3066\u3044\u308b\u306e\u304b\u7406\u89e3\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u6a29\u5a01\u3078\u306e\u4fe1\u983c\u306b\u983c\u3089\u306a\u3044\u3067\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mod '" + idMod + "' \u306f\u3001\u5fc5\u8981\u306a\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u305f\u3081\u5931\u6557\u3057\u307e\u3057\u305f: '" + claseNoEncontrada + "'. \u3059\u3079\u3066\u306e\u4f9d\u5b58\u95a2\u4fc2\u304c\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia \u306f TLauncher \u3092\u4f7f\u7528\u3057\u305f\u30d7\u30ec\u30a4\u3092\u30d6\u30ed\u30c3\u30af\u3057\u307e\u3057\u305f\u3002</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3042\u306a\u305f\u306f\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306eMinecraft\u7528\u306eOptifine\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002\u4f7f\u7528\u3057\u3066\u3044\u308bMinecraft\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5bfe\u5fdc\u3059\u308bOptifine\u3092\u4f7f\u7528\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModLauncher \u30b5\u30fc\u30d3\u30b9\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f: </b>" + servicio + "\u3002";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JAR\u30d5\u30a1\u30a4\u30eb '" + archivoJar + "' \u304b\u3089\u306eJSON\u30d5\u30a1\u30a4\u30eb '" + recurso + "' \u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u767b\u9332\u306b\u554f\u984c\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u30a8\u30e9\u30fc: \u30e2\u30c3\u30c9 '" + modId + "' \u306f '" + dependencia + "' \u306e\u30d0\u30fc\u30b8\u30e7\u30f3 '" + requerido + "' \u4ee5\u4e0a\u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u304c\u3001'" + actual + "' \u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u304a\u4f7f\u3044\u306eGPU\u306f\u3001\u3053\u306e\u30b2\u30fc\u30e0\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u5fc5\u8981\u306aOpenGL\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30c9\u30e9\u30a4\u30d0\u30fc\u3092\u66f4\u65b0\u3059\u308b\u304b\u3001\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30ab\u30fc\u30c9\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u30b2\u30fc\u30e0\u306b\u5272\u308a\u5f53\u3066\u308b\u30e1\u30e2\u30ea\u3092\u5897\u3084\u3057\u305f\u308a\u3001MOD\u3084\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u4f7f\u7528\u3092\u6e1b\u3089\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>32\u30d3\u30c3\u30c8JVM\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f: 4GB\u4ee5\u4e0a\u306eRAM\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002 \u5229\u7528\u53ef\u80fd\u306a\u3059\u3079\u3066\u306e\u30e1\u30e2\u30ea\u3092\u5229\u7528\u3059\u308b\u306b\u306f\u300164\u30d3\u30c3\u30c8JVM\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>PermGen\u30e1\u30e2\u30ea\u306e\u91cd\u5927\u306a\u30a8\u30e9\u30fc\u3067\u3059\u3002\u6c38\u7d9a\u30e1\u30e2\u30ea\u9818\u57df\u3092\u5897\u3084\u3057\u305f\u308a\u3001\u30af\u30e9\u30b9\u306e\u30ed\u30fc\u30c9\u3092\u6e1b\u3089\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8\u3068\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u9593\u3067\u306e\u4e92\u63db\u6027\u30a8\u30e9\u30fc</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093 - \u53e4\u3044Forge\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u306fJava 8\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8\u304c\u5fc5\u8981\u3067\u3059\uff08\u30d0\u30fc\u30b8\u30e7\u30f352.0\uff09\u3002\u66f4\u65b0\u3059\u308b\u304b\u3001\u6b63\u3057\u304f\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u306a\u4e92\u63db\u6027\u30a8\u30e9\u30fc: \u3053\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u306f\u30d6\u30ed\u30c3\u30af\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 MOD\u3068\u30b5\u30fc\u30d0\u30fc\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e92\u63db\u6027\u304c\u3042\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30cb\u30bf\u30fc\u8a2d\u5b9a\u30a8\u30e9\u30fc: \u753b\u9762\u30e2\u30fc\u30c9\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044:</b><br>- \u30de\u30eb\u30c1\u30e2\u30cb\u30bf\u30fc\u8a2d\u5b9a<br>- \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30ab\u30fc\u30c9\u30c9\u30e9\u30a4\u30d0\u30fc\u304c\u6700\u65b0\u304b\u3069\u3046\u304b<br>- \u30b7\u30b9\u30c6\u30e0\u3067\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u308b\u89e3\u50cf\u5ea6";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java\u30aa\u30d7\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc: \u30ac\u30d9\u30fc\u30b8\u30b3\u30ec\u30af\u30bf\u30fc\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u7af6\u5408\u3057\u3066\u3044\u307e\u3059\u3002 \u8907\u6570\u306eGC\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u3092JVM\u30d1\u30e9\u30e1\u30fc\u30bf\u306b\u7d44\u307f\u5408\u308f\u305b\u3066\u3044\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>NightConfig/Forge \u8a2d\u5b9a\u306e\u81f4\u547d\u7684\u30a8\u30e9\u30fc: \u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u307e\u305f\u306f\u4e0d\u5b8c\u5168\u3067\u3059\u3002\u3053\u308c\u306f\u3001\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u3084\u30ab\u30b9\u30bf\u30e0\u7248\u306e NightConfig \u306b\u304a\u3044\u3066\u3001'config' \u30d5\u30a9\u30eb\u30c0\u5185\u306e\u7a7a\u306e\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\uff08\u591a\u304f\u306e\u5834\u5408 0 \u30d0\u30a4\u30c8\uff09\u306b\u3088\u3063\u3066\u5f15\u304d\u8d77\u3053\u3055\u308c\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002\u307b\u3068\u3093\u3069\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u306f Night Config Fixes \u3067\u554f\u984c\u3092\u89e3\u6c7a\u3067\u304d\u307e\u3059\u304c\u3001\u975e\u4e92\u63db\u307e\u305f\u306f\u30ab\u30b9\u30bf\u30e0\u7248\u306e NightConfig \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u624b\u52d5\u3067\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u3053\u306e\u554f\u984c\u306f\u3001NightConfig \u3092\u5185\u8535\u3059\u308b\u53e4\u3044 MC Forge \u30d0\u30fc\u30b8\u30e7\u30f3\u3084\u3001NightConfig \u3092\u540c\u68b1\u3059\u308b\u53e4\u3044 FabricMC \u30e2\u30c3\u30c9\u3067\u3088\u308a\u4e00\u822c\u7684\u3067\u3059\u304c\u3001\u4e00\u90e8\u306e\u30ab\u30b9\u30bf\u30e0 NightConfig \u30d3\u30eb\u30c9\u3067\u3082\u767a\u751f\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u89e3\u6c7a\u7b56\u306e\u8a73\u7d30\u306f <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a> \u3067\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Intel HD Graphics\u30c9\u30e9\u30a4\u30d0\u30fc\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u89e3\u6c7a\u7b56:</b><br>1. <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a>\u304b\u3089Intel\u30c9\u30e9\u30a4\u30d0\u30fc\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u6700\u5c0f\u30d0\u30fc\u30b8\u30e7\u30f315.xx.xx.xx\uff09<br>2. Minecraft\u3067: \u30aa\u30d7\u30b7\u30e7\u30f3 \u2192 \u52d5\u753b \u2192 'Enable VBOs'\u3068'VSync'\u3092\u6709\u52b9\u5316<br>3. \u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u30b2\u30fc\u30e0\u306b1GB-2GB\u306eRAM\u3092\u5272\u308a\u5f53\u3066<br>4. \u66f4\u65b0\u4e2d\u306b\u4e00\u6642\u7684\u306b\u30a2\u30f3\u30c1\u30a6\u30a4\u30eb\u30b9/\u30d5\u30a1\u30a4\u30a2\u30a6\u30a9\u30fc\u30eb\u3092\u7121\u52b9\u5316";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "\u8b66\u544a: \u6b20\u843d\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "\u30d6\u30ed\u30c3\u30af\u306e\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u30a8\u30e9\u30fc";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u89e3\u6790";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "\u4e0d\u5b8c\u5168\u306aCurseForge\u30b3\u30f3\u30bd\u30fc\u30eb";
    }

    @Override
    public String nombre_de_early_window() {
        return "\u65e9\u671f\u30a6\u30a3\u30f3\u30c9\u30a6\u30a8\u30e9\u30fc (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "\u30d3\u30c7\u30aa\u30c9\u30e9\u30a4\u30d0\u306e\u554f\u984c";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "MCForge\u8a2d\u5b9a\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u30e2\u30fc\u30c9\u306e\u5931\u6557 (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "FabricMC\u521d\u671f\u5316\u30a8\u30e9\u30fc";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "\u6b20\u843d\u3057\u3066\u3044\u308bJPMS\u30e2\u30b8\u30e5\u30fc\u30eb";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "\u91cd\u5927\u306a\u6b20\u843d\u30af\u30e9\u30b9";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "ModLauncher\u4f9d\u5b58\u95a2\u4fc2\u304c\u6b20\u843d\u3057\u3066\u3044\u307e\u3059";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "\u4e92\u63db\u6027\u306e\u306a\u3044Java\u30d0\u30fc\u30b8\u30e7\u30f3";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "KubeJS\u30ea\u30bd\u30fc\u30b9\u30a8\u30e9\u30fc";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "\u4e92\u63db\u6027\u306e\u306a\u3044\u8a00\u8a9e\u30d7\u30ed\u30d0\u30a4\u30c0";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "Litchhost\u30a8\u30e9\u30fc";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "\u8aa4\u3063\u305f\u30de\u30eb\u30a6\u30a7\u30a2\u691c\u51fa";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "\u7591\u308f\u3057\u3044MOD\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "ModLauncher\u5185\u306e\u91cd\u8907\u3057\u305fMOD";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "JPMS\u30e2\u30b8\u30e5\u30fc\u30eb\u306e\u7af6\u5408";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "Iris\u306b\u306fSodium\u304c\u5fc5\u8981\u3067\u3059";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "JSON\u30ec\u30b8\u30b9\u30c8\u30ea\u3092\u89e3\u6790\u3067\u304d\u307e\u305b\u3093";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "\u30e1\u30e2\u30ea\u4e0d\u8db3";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "\u30cc\u30eb\u30dd\u30a4\u30f3\u30bf\u30fc\u30a8\u30e9\u30fc (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "\u7121\u52b9\u306aJava GC\u30aa\u30d7\u30b7\u30e7\u30f3";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "\u53e4\u3044/\u4e92\u63db\u6027\u306e\u306a\u3044OptiFine";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "\u30af\u30ea\u30c6\u30a3\u30ab\u30eb\u30b5\u30fc\u30d0\u30fc\u30c6\u30a3\u30c3\u30af (60\u79d2)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "ModLauncher\u30b5\u30fc\u30d3\u30b9\u304c\u5931\u6557\u3057\u307e\u3057\u305f";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "\u554f\u984c\u306e\u3042\u308bSpongeMixing\u8a2d\u5b9a";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus\u306f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "TLauncher\u306fWATERMeDIA\u3067\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093";
    }

    @Override
    public String auditorias_transformer() {
        return "\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u30aa\u30fc\u30c7\u30a3\u30c3\u30c8";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3053\u308c\u3089\u306fVanilla\u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u306e\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u30aa\u30fc\u30c7\u30a3\u30c3\u30c8\u306e\u5185\u5bb9\u7d50\u679c\u3067\u3059\u3002\u4e00\u822c\u7684\u306bStackTrace\u30a2\u30ca\u30e9\u30a4\u30b6\u30fc\u307b\u3069\u6b63\u78ba\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u304c\u3001Vanilla\u30e9\u30f3\u30c1\u30e3\u30fc\u306b\u306f\u5e38\u306b{}\u306e\u5185\u5bb9\u304c\u3042\u308b\u3068\u306f\u9650\u308a\u307e\u305b\u3093</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "\u3053\u308c\u306f\u3001\u3042\u306a\u305f\u306eMOD\u306e\u4e2d\u3067MCreator\u3067\u4f5c\u6210\u3055\u308c\u305f\u3082\u306e\u3092\u691c\u7d22\u3057\u307e\u3059\u3002\u307b\u3068\u3093\u3069\u306eMCreator\u88fd\u306eMOD\u306f\u554f\u984c\u306a\u304f\u3001\u512a\u308c\u305fMOD\u3082\u591a\u3044\u3067\u3059\u304c\u3001\u6642\u3005\u554f\u984c\u304c\u767a\u751f\u3057\u3001\u60aa\u3044\u8a55\u5224\u3092\u6301\u3064\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002\u3053\u308c\u306b\u3088\u308a\u3001\u305d\u308c\u3089\u3092\u7279\u5b9a\u3059\u308b\u306e\u306b\u5f79\u7acb\u3061\u307e\u3059\u3002\u8a55\u4fa1\u304c\u9ad8\u3044\u3082\u306e\u3067\u3082\u5fc5\u305a\u3057\u3082MCreator\u88fd\u3068\u306f\u9650\u3089\u306a\u3044\u3053\u3068\u306b\u6ce8\u610f\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4f8b\u3048\u3070\u3001MCreator\u3068\u306e\u7d71\u5408\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u5834\u5408\u304c\u3042\u308a\u307e\u3059\u3002";
    }

    @Override
    public String escanear() {
        return "\u30b9\u30ad\u30e3\u30f3";
    }

    @Override
    public String cargando() {
        return "\u8aad\u307f\u8fbc\u307f\u4e2d";
    }

    @Override
    public String codigo() {
        return "ja";
    }

    @Override
    public String inicioApp() {
        return "\u30b2\u30fc\u30e0/\u30a2\u30d7\u30ea\u306e\u958b\u59cb";
    }

    @Override
    public String ajustesCrashDetector() {
        return "\u30af\u30e9\u30c3\u30b7\u30e5\u691c\u51fa\u8a2d\u5b9a";
    }

    @Override
    public String confidencialidad() {
        return "\u30d7\u30e9\u30a4\u30d0\u30b7\u30fc";
    }

    @Override
    public String tooltip() {
        return "\u30c4\u30fc\u30eb\u30c1\u30c3\u30d7";
    }

    @Override
    public String config() {
        return "\u8a2d\u5b9a";
    }

    @Override
    public String abrirCarpeta() {
        return "\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f";
    }

    @Override
    public String actualizar() {
        return "\u66f4\u65b0";
    }

    @Override
    public String anadirRegistro() {
        return "\u30ed\u30b0\u3092\u8ffd\u52a0";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "\u30b7\u30b9\u30c6\u30e0\u8a00\u8a9e\u3092\u4f7f\u7528";
    }

    @Override
    public String volver() {
        return "\u623b\u308b";
    }

    @Override
    public String colorFondo() {
        return "\u80cc\u666f\u8272 (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "\u30c6\u30ad\u30b9\u30c8\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "\u30dc\u30bf\u30f3\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "\u30c6\u30ad\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "\u30ea\u30f3\u30af\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "\u30b3\u30f3\u30bd\u30fc\u30eb\u30bf\u30a4\u30c8\u30eb\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "\u30a8\u30e9\u30fc\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "\u8b66\u544a\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "\u60c5\u5831\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "\u30bf\u30a4\u30c8\u30eb\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "\u30ea\u30f3\u30af\u30c6\u30ad\u30b9\u30c8\u306e\u8272 (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "\u5931\u6557\u6642\u306b\u306e\u307fCrashDetector\u3092\u958b\u304f";
    }

    @Override
    public String activar_parche() {
        return "\u30d1\u30c3\u30c1\u3092\u6709\u52b9\u5316";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "\u5229\u7528\u53ef\u80fd\u306a\u89e3\u6c7a\u7b56\u306f\u3042\u308a\u307e\u305b\u3093";
    }

    @Override
    public String error() {
        return "\u30a8\u30e9\u30fc";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "Jar\u306e\u524a\u9664\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar\u304c\u6b63\u5e38\u306b\u524a\u9664\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String exito() {
        return "\u6210\u529f";
    }

    @Override
    public String eliminar() {
        return "\u524a\u9664";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "\u30d1\u30c3\u30b1\u30fc\u30b8\u306e\u524a\u9664\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "\u30d1\u30c3\u30b1\u30fc\u30b8\u304c\u6b63\u5e38\u306b\u524a\u9664\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String eliminar_paquete() {
        return "\u30d1\u30c3\u30b1\u30fc\u30b8\u3092\u524a\u9664";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "\u30d1\u30c3\u30b1\u30fc\u30b8\u4ed8\u304d\u306eMOD\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "\u30d1\u30c3\u30b1\u30fc\u30b8\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093";
    }

    @Override
    public String eliminar_jar() {
        return "Jar\u3092\u524a\u9664";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "\u91cd\u8907\u3057\u305fMOD\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f";
    }

    @Override
    public String archivo_no_encontrado() {
        return "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093";
    }

    @Override
    public String directorio_eliminado() {
        return "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "\u30cd\u30b9\u30c8\u3055\u308c\u305fJar\u306e\u524a\u9664\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "\u5185\u90e8\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093";
    }

    @Override
    public String archivo_eliminado() {
        return "\u30d5\u30a1\u30a4\u30eb\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "\u7121\u52b9\u306a\u5916\u90e8\u30d5\u30a1\u30a4\u30eb\u3067\u3059";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "Mod\u8981\u7d20\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "\u5916\u90e8Jar\u306e\u7f6e\u304d\u63db\u3048\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "Mod\u8981\u7d20\u306e\u524a\u9664\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u524a\u9664\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "\u30cd\u30b9\u30c8\u3055\u308c\u305fJar\u306b\u7121\u52b9\u306a\u5f62\u5f0f\u3067\u3059";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "\u30cd\u30b9\u30c8\u3055\u308c\u305fJar\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u30af\u30ea\u30a2\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u81f4\u547d\u7684\u306a\u30c8\u30ec\u30fc\u30b9\u30e1\u30c3\u30bb\u30fc\u30b8\u6700\u5f8c (\u672a\u7ffb\u8a33):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30c8\u30ec\u30fc\u30b9\u30e1\u30c3\u30bb\u30fc\u30b8\u6700\u5f8c (\u672a\u7ffb\u8a33):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "WaifuNeoForge\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u691c\u7d22\u3057\u3066MOD\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\u30b2\u30fc\u30e0\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3001MOD\u30ed\u30fc\u30c0\u30fc\u3001\u30af\u30e9\u30b9\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u6700\u3082\u8fd1\u3044\u7d44\u307f\u5408\u308f\u305b\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u30021\u5206\u9593\u306b1\u56de\u691c\u7d22\u3067\u304d\u307e\u3059\u3002";
    }

    @Override
    public String solucionFaltasClases() {
        return "WaifuNeoForge\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u691c\u7d22\u3057\u3066MOD\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\u30b2\u30fc\u30e0\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3001MOD\u30ed\u30fc\u30c0\u30fc\u3001\u30af\u30e9\u30b9\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u6700\u3082\u8fd1\u3044\u7d44\u307f\u5408\u308f\u305b\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u30021\u5206\u9593\u306b1\u56de\u691c\u7d22\u3067\u304d\u307e\u3059\u3002";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "\u4e21\u65b9\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u306b\u306f\u6b63\u3057\u3044Java\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u3042\u308a\u307e\u3059\u304c\u3001\u3059\u3079\u3066\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u306e\u30d1\u30c3\u30b1\u30fc\u30b8\u30de\u30cd\u30fc\u30b8\u30e3\u30fc\u307e\u305f\u306f\u30dc\u30bf\u30f3\u3092\u4f7f\u7528\u3057\u3066\u3001\u6b63\u3057\u3044Java\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3067\u304d\u307e\u3059\u3002";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3\u304c\u4e0d\u8db3\u3057\u3066\u3044\u308bMOD: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException\uff08\u8981\u7d20\u306a\u3057\u4f8b\u5916\uff09\u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3\u4e0d\u8db3";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "\u524a\u9664\u3059\u308bMOD\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "\u7af6\u5408\u3059\u308bGC\u30aa\u30d7\u30b7\u30e7\u30f3\u3092-XX:+UseG1GC\u306b\u7f6e\u304d\u63db\u3048\u308b";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "-Xmx\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u306e\u30b5\u30a4\u30ba\u3092\u5897\u52a0\u3055\u305b\u307e\u3059\u3002";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "-XX:MaxPermSize\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u30d1\u30fc\u30de\u30cd\u30f3\u30c8\u9818\u57df\u30e1\u30e2\u30ea\u306e\u30b5\u30a4\u30ba\u3092\u5897\u52a0\u3055\u305b\u307e\u3059\u3002";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "\u5229\u7528\u53ef\u80fd\u306a\u30e1\u30e2\u30ea\u3092\u5897\u3084\u3059\u305f\u3081\u306b64\u30d3\u30c3\u30c8JVM\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002";
    }

    @Override
    public String optimizarCodigo() {
        return "\u30b3\u30fc\u30c9\u3092\u6700\u9069\u5316\u3057\u3001\u30e1\u30e2\u30ea\u4f7f\u7528\u91cf\u3092\u6e1b\u3089\u3057\u3066\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9\u3092\u5411\u4e0a\u3055\u305b\u307e\u3059\u3002";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u4e00\u6642\u505c\u6b62\u3092\u6e1b\u3089\u3059\u305f\u3081\u3001\u52b9\u7387\u7684\u306a\u30ac\u30d9\u30fc\u30b8\u30b3\u30ec\u30af\u30bf\u30fc\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002";
    }

    @Override
    public String modulos() {
        return "\u30e2\u30b8\u30e5\u30fc\u30eb";
    }

    @Override
    public String paquete() {
        return "\u30d1\u30c3\u30b1\u30fc\u30b8";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "ID\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u3088\u304f\u3042\u308b\u539f\u56e0\u306fMOD\u306e\u6b20\u843d\u3084\u30a2\u30a4\u30c6\u30e0\u30c7\u30fc\u30bf\u306e\u6b20\u640d\u3067\u3059\u3002\u4e00\u822c\u7684\u306a\u30c7\u30fc\u30bf\u30d5\u30a9\u30eb\u30c0\u306f datafiedcontents/ \u3084 kubejs/\u3001\u307e\u305f\u306f\u4ed6\u306eMOD\u30d5\u30a9\u30eb\u30c0\u3067\u3059\u3002";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "\u4e0d\u4e00\u81f4\u306a\u30ec\u30b3\u30fc\u30c9";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 'AuthMe' \u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u3001\u30b5\u30fc\u30d0\u30fc\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "AuthMe\u306b\u3088\u308b\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u554f\u984c";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "'stopServer'\u30eb\u30fc\u30eb\u304c'true'\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "\u30d7\u30e9\u30b0\u30a4\u30f3 AuthMe \u3092\u8a2d\u5b9a\u3059\u308b (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "'AuthMe' \u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u5225\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "\u30d7\u30e9\u30b0\u30a4\u30f3 'AuthMe' \u3092\u524a\u9664\u3059\u308b";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30ef\u30fc\u30eb\u30c9 '" + nombreMundo + "' \u306f\u30a8\u30e9\u30fc\u3092\u542b\u307f\u3001\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308b\u305f\u3081\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "Multiverse\u30ef\u30fc\u30eb\u30c9\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "'" + nombreMundo + "' \u30ef\u30fc\u30eb\u30c9\u3092\u4fee\u5fa9\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4f8b\u3068\u3057\u3066 Minecraft Region Fixer \u3084 MCEdit \u3092\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "'" + nombreMundo + "' \u30ef\u30fc\u30eb\u30c9\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u62e1\u5f35\u6a5f\u80fd 'PermissionsEx' \u306e\u8a2d\u5b9a\u304c\u7121\u52b9\u3067\u3059\u3002</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "PermissionsEx \u8a2d\u5b9a\u306e\u554f\u984c";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "\u30d7\u30e9\u30b0\u30a4\u30f3 PermissionsEx \u3092\u8a2d\u5b9a\u3059\u308b (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "\u30d7\u30e9\u30b0\u30a4\u30f3 'PermissionsEx' \u3092\u524a\u9664\u3059\u308b";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3\u540d '" + nombrePlugin + "' \u306b\u8a72\u5f53\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u8907\u6570\u3042\u308a\u307e\u3059: '" + primerPath + "' \u3068 '" + segundoPath + "'\u3002</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "\u30d7\u30e9\u30b0\u30a4\u30f3\u540d\u306e\u7af6\u5408\u554f\u984c";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30ef\u30fc\u30eb\u30c9\u304c\u30c1\u30e3\u30f3\u30af\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u308b\u969b\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u304a\u4f7f\u3044\u306e\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\u5411\u3051\u306b\u5b58\u5728\u3059\u308b\u5834\u5408\u3001FeatureRecycler \u3067\u554f\u984c\u3092\u89e3\u6c7a\u3067\u304d\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "\u30c1\u30e3\u30f3\u30af\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc";
    }

    @Override
    public String solucionEliminarChunk() {
        return "\u554f\u984c\u306e\u3042\u308b\u30c1\u30e3\u30f3\u30af\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4f8b\u3068\u3057\u3066 MCEdit \u3092\u4f7f\u3046\u304b\u3001\u30ea\u30fc\u30b8\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3059\u3002";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u306f\u30b3\u30de\u30f3\u30c9 '/" + comando + "' \u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002</b> ";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "\u30d7\u30e9\u30b0\u30a4\u30f3\u30b3\u30de\u30f3\u30c9\u5b9f\u884c\u6642\u306e\u4f8b\u5916";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "'" + nombrePlugin + "' \u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u5225\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u306f\u4f9d\u5b58\u6027 '" + dependencia + "' \u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u3002</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u306f\u6b21\u306e\u4f9d\u5b58\u6027\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059: " + deps.toString() + "\u3002</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30d7\u30e9\u30b0\u30a4\u30f3\u4f9d\u5b58\u6027";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "'" + nombrePlugin + "' \u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u306f\u73fe\u5728\u306e\u30b5\u30fc\u30d0\u30fc\u3068\u4e92\u63db\u6027\u306e\u306a\u3044 API \u30d0\u30fc\u30b8\u30e7\u30f3 '" + versionAPI + "' \u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u3002</b> ";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "API \u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e92\u63db\u6027\u306a\u3057";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "\u30b5\u30fc\u30d0\u30fc\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u306e\u30d0\u30fc\u30b8\u30e7\u30f3 '" + version + "' \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30ef\u30fc\u30eb\u30c9 '" + nombreMundo + "' \u306f\u4ed6\u306e\u30ef\u30fc\u30eb\u30c9\u3068\u91cd\u8907\u3057\u3066\u304a\u308a\u3001\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "\u91cd\u8907\u3059\u308b\u30ef\u30fc\u30eb\u30c9";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "'" + nombreMundo + "' \u30ef\u30fc\u30eb\u30c9\u5185\u306e 'uid.dat' \u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "'" + nombreMundo + "' \u30ef\u30fc\u30eb\u30c9\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u5ea7\u6a19 " + coords + " \u306e\u30d6\u30ed\u30c3\u30af\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3 '" + nombre + "'\uff08\u30bf\u30a4\u30d7: '" + tipo + "'\uff09\u304c\u30c6\u30a3\u30c3\u30ad\u30f3\u30b0\u4e2d\u306b\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u3044\u307e\u3059\u3002</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "\u554f\u984c\u306e\u3042\u308b\u30d6\u30ed\u30c3\u30af\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "MCEdit \u307e\u305f\u306f\u76f4\u63a5\u7de8\u96c6\u3067\u3001\u5ea7\u6a19 " + coords + " \u306e '" + nombre + "' \u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30c3\u30c9 '" + nombreMod + "' \u306b\u8907\u6570\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "Fabric \u5185\u306e\u91cd\u8907\u3059\u308b\u30e2\u30c3\u30c9";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "\u91cd\u8907\u3057\u305f\u30e2\u30c3\u30c9\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30c3\u30c9 '" + primerMod + "' \u3068 '" + segundoMod + "' \u306f\u4e92\u3044\u306b\u975e\u4e92\u63db\u3067\u3059\u3002</b>";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "Fabric \u5185\u306e\u975e\u4e92\u63db\u30e2\u30c3\u30c9";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "'" + nombreMod + "' \u30e2\u30c3\u30c9\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30c3\u30c9 '" + nombreMod + "' \u306b\u91cd\u5927\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u3001\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002</b> ";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "\u91cd\u5927\u306a\u30a8\u30e9\u30fc\u3092\u542b\u3080\u30e2\u30c3\u30c9";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u6b21\u306e\u30e2\u30c3\u30c9\u304c\u5fc5\u8981\u3067\u3059\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u305b\u3093: " + deps.toString() + "\u3002</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30c3\u30c9 '" + nombreMod + "' \u306f '" + dependencia + "' \u30e2\u30c3\u30c9\u306e\u4f9d\u5b58\u304c\u3042\u308a\u307e\u3059\u3002</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30c3\u30c9 '" + nombreMod + "' \u306f '" + dependencia + "' \u30e2\u30c3\u30c9\u306e\u30d0\u30fc\u30b8\u30e7\u30f3 " + version + " \u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30e2\u30c3\u30c9\u306e\u4f9d\u5b58\u95a2\u4fc2";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "'" + nombreMod + "' \u30e2\u30c3\u30c9\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "'" + nombreMod + "' \u30e2\u30c3\u30c9\u306e\u30d0\u30fc\u30b8\u30e7\u30f3 " + version + " \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u306f Folia \u306e\u30ea\u30fc\u30b8\u30e7\u30ca\u30eb\u30c6\u30a3\u30c3\u30ad\u30f3\u30b0\u3068\u975e\u4e92\u63db\u3067\u3059\u3002</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u306f Folia \u306e\u30ea\u30fc\u30b8\u30e7\u30ca\u30eb\u30c6\u30a3\u30c3\u30ad\u30f3\u30b0\u3068\u975e\u4e92\u63db\u3067\u3059: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "\u30ea\u30fc\u30b8\u30e7\u30ca\u30eb\u30c6\u30a3\u30c3\u30ad\u30f3\u30b0\u975e\u5bfe\u5fdc\u30d7\u30e9\u30b0\u30a4\u30f3";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "\u30ea\u30fc\u30b8\u30e7\u30ca\u30eb\u30c6\u30a3\u30c3\u30ad\u30f3\u30b0\u306a\u3057\u306e\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4f8b: " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>'" + nombreMod + "' \u30e2\u30c3\u30c9\u304c\u30c7\u30fc\u30bf\u30d1\u30c3\u30af\u306b\u3042\u308a\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u6b21\u306e\u30e2\u30c3\u30c9\u304c\u30c7\u30fc\u30bf\u30d1\u30c3\u30af\u306b\u3042\u308a\u307e\u305b\u3093: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u304a\u3088\u3073 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "\u30c7\u30fc\u30bf\u30d1\u30c3\u30af\u5185\u306e\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30e2\u30c3\u30c9";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + " \u30e2\u30c3\u30c9\u304c\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3057\u305f\u3002</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u306e\u30e2\u30c3\u30c9\u304c\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3057\u305f\uff1a");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u304a\u3088\u3073 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "Forge \u30e2\u30c3\u30c9\u306e\u4f8b\u5916";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "'" + nombreMod + "' \u30e2\u30c3\u30c9\u306e\u5225\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>" + nombreMod + "' \u30e2\u30c3\u30c9\u306f Minecraft " + versionMC + " \u3068\u975e\u4e92\u63db\u3067\u3059\u3002</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u306e\u30e2\u30c3\u30c9\u306f\u5bfe\u5fdc\u3059\u308b Minecraft \u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u975e\u4e92\u63db\u3067\u3059\uff1a");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append("\uff08Minecraft ").append(versionesMC.get(i)).append("\uff09");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "Minecraft \u3068\u975e\u4e92\u63db\u306a\u30e2\u30c3\u30c9";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "Minecraft " + versionMC + " \u5bfe\u5fdc\u306e Forge \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30c3\u30c9 '" + nombreMod + "' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u4e16\u754c\u3084\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30ed\u30fc\u30c9\u306b\u5fc5\u8981\u3067\u3059\u3002</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30e2\u30c3\u30c9";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3053\u306e\u4e16\u754c\u306f '" + nombreMod + "' \u30e2\u30c3\u30c9\u3092\u4f7f\u7528\u3057\u3066\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001\u73fe\u5728\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u3053\u306e\u4e16\u754c\u306f\u4ee5\u4e0b\u306e\u30e2\u30c3\u30c9\u3067\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001\u305d\u308c\u3089\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u304a\u3088\u3073 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "\u4e16\u754c\u5185\u306e\u4e0d\u8db3\u30e2\u30c3\u30c9";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3053\u306e\u4e16\u754c\u306f '" + nombreMod + "' \u30e2\u30c3\u30c9\u306e\u30d0\u30fc\u30b8\u30e7\u30f3 " + versionEsperada + " \u3067\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001\u73fe\u5728\u4f7f\u308f\u308c\u3066\u3044\u308b\u306e\u306f\u30d0\u30fc\u30b8\u30e7\u30f3 " + versionActual + " \u3067\u3059\u3002</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4fdd\u5b58\u3055\u308c\u305f\u4e16\u754c\u306b\u542b\u307e\u308c\u308b\u30e2\u30c3\u30c9\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u304a\u3088\u3073 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append("\uff08\u4fdd\u5b58\u6642: ").append(versionesEsperadas.get(i)).append(", \u73fe\u884c: ").append(versionesActuales.get(i)).append("\uff09");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "\u4fdd\u5b58\u3055\u308c\u305f\u4e16\u754c\u306e\u30e2\u30c3\u30c9\u30d0\u30fc\u30b8\u30e7\u30f3\u4e0d\u4e00\u81f4";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3042\u306a\u305f\u306f\u3088\u308a\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Minecraft \u3067\u4f5c\u6210\u3055\u308c\u305f\u4e16\u754c\u3092\u8aad\u307f\u8fbc\u3082\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u4e16\u754c\u3092\u30ed\u30fc\u30c9\u3057\u3088\u3046\u3068\u3057\u305f";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Minecraft \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "\u65b0\u3057\u3044\u4e16\u754c\u3092\u751f\u6210\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u306f\u4ee5\u4e0b\u306e\u4f9d\u5b58\u304c\u3042\u308a\u307e\u3059\uff1a'" + dependencia + "'\u3002</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u306f\u672a\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u306e\u4f9d\u5b58\u304c\u3042\u308a\u307e\u3059\uff1a");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'\uff08").append(dependencias.get(i)).append("\uff09");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30d7\u30e9\u30b0\u30a4\u30f3\u4f9d\u5b58\u6027";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u306f\u30b5\u30fc\u30d0\u30fc\u306e\u73fe\u5728\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u975e\u4e92\u63db\u3067\u3059\u3002</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u306f\u30b5\u30fc\u30d0\u30fc\u306e\u73fe\u5728\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u975e\u4e92\u63db\u3067\u3059\uff1a");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u304a\u3088\u3073 ");
                } else {
                    sb.append("\u3001");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "PocketMine-MP \u3068\u975e\u4e92\u63db\u306a\u30d7\u30e9\u30b0\u30a4\u30f3";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30d7\u30e9\u30b0\u30a4\u30f3 '" + nombrePlugin + "' \u304c\u5b9f\u884c\u4e2d\u306b\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3057\u305f\u3002</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u4ee5\u4e0b\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u5b9f\u884c\u4e2d\u306b\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3057\u305f: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u304a\u3088\u3073 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append("\u3002</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "\u5b9f\u884c\u30a8\u30e9\u30fc\u306e\u3042\u308b\u30d7\u30e9\u30b0\u30a4\u30f3";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "\u30de\u30eb\u30c1\u30b9\u30ec\u30c3\u30c9 LegacyRandomSource";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8907\u6570\u306e\u30b9\u30ec\u30c3\u30c9\u304c LegacyRandomSource \u30af\u30e9\u30b9\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u307e\u3059\u3002\u8a73\u7d30\u306f 'Unsafe World Random Access Detector' \u307e\u305f\u306f 'C2ME' \u30e2\u30c3\u30c9\u3067\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "\u524d\u56de\u306e\u6210\u529f\u4ee5\u964d";
    }

    @Override
    public String noHayCambios() {
        return "\u5909\u66f4\u306a\u3057";
    }

    @Override
    public String desdeUltimoIntento() {
        return "\u524d\u56de\u306e\u8a66\u884c\u4ee5\u964d";
    }

    @Override
    public String fallo() {
        return "\u5931\u6557";
    }

    @Override
    public String diferentesDeLasMods() {
        return "MOD\u3068\u7570\u306a\u308b";
    }

    @Override
    public String historialDeMods() {
        return "MOD\u5c65\u6b74";
    }

    @Override
    public String archivo0() {
        return "\u30d5\u30a1\u30a4\u30eb0";
    }

    @Override
    public String archivo1() {
        return "\u30d5\u30a1\u30a4\u30eb1";
    }

    @Override
    public String comparar() {
        return "\u6bd4\u8f03";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "2\u3064\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String archivoExito() {
        return "\u6210\u529f\u3057\u305f\u30d5\u30a1\u30a4\u30eb";
    }

    @Override
    public String archivoFalla() {
        return "\u5931\u6557\u3057\u305f\u30d5\u30a1\u30a4\u30eb";
    }

    @Override
    public String errorComparandoArchivos() {
        return "\u30d5\u30a1\u30a4\u30eb\u306e\u6bd4\u8f03\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String comparando() {
        return "\u6bd4\u8f03\u4e2d";
    }

    @Override
    public String con() {
        return "\u3068";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'><p><b>MOD\u5c65\u6b74\u6bd4\u8f03\u30d1\u30cd\u30eb</b></p><p>\u3053\u306e\u30d1\u30cd\u30eb\u3067\u306f\u3001\u7570\u306a\u308b\u30bb\u30c3\u30b7\u30e7\u30f3\u306eMOD\u30ea\u30b9\u30c8\u3092\u6bd4\u8f03\u3067\u304d\u307e\u3059\u3002\u5de6\u5074\u304b\u3089\u30d5\u30a1\u30a4\u30eb\u3001\u53f3\u5074\u304b\u3089\u3082\u3046\u4e00\u3064\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3001\u5909\u66f4\u70b9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p><h3>\u4f7f\u3044\u65b9:</h3><ol><li><b>\u30d5\u30a1\u30a4\u30eb\u9078\u629e:</b> \u30d5\u30a1\u30a4\u30eb\u6a2a\u306e\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u307e\u3059\u3002 <span style='color: #4CAF50; font-weight: bold;'>.suceso</span> \u3067\u7d42\u308f\u308b\u30d5\u30a1\u30a4\u30eb\u306f\u6210\u529f\u3057\u305f\u30bb\u30c3\u30b7\u30e7\u30f3\u3001 <span style='color: #F44336; font-weight: bold;'>.falla</span> \u306f\u5931\u6557\u3057\u305f\u30bb\u30c3\u30b7\u30e7\u30f3\u3067\u3059\u3002</li><li><b>\u81ea\u52d5\u6bd4\u8f03:</b>\u300cCompare\u300d\u30dc\u30bf\u30f3\u3092\u62bc\u3059\u3068\u3001\u30b7\u30b9\u30c6\u30e0\u304c\u4e21\u65b9\u306e\u30ea\u30b9\u30c8\u3092\u89e3\u6790\u3057\u3066\u8ffd\u52a0(+)\u307e\u305f\u306f\u524a\u9664(-)\u3055\u308c\u305fMOD\u3092\u8868\u793a\u3057\u307e\u3059\u3002</li><li><b>\u7d50\u679c\u306e\u8868\u793a:</b> \u7d50\u679c\u306f\u8272\u5206\u3051\u3055\u308c\u305fHTML\u5f62\u5f0f\u3067\u8868\u793a\u3055\u308c\u307e\u3059: <ul><li><span style='color: green;'>+ \u8ffd\u52a0\u3055\u308c\u305fMOD</span></li><li><span style='color: red;'>- \u524a\u9664\u3055\u308c\u305fMOD</span></li></ul></li></ol><h3>\u4e3b\u306a\u6a5f\u80fd:</h3><ul><li>\u6210\u529f/\u5931\u6557\u30d5\u30a1\u30a4\u30eb\u306e\u4efb\u610f\u306e\u7d44\u307f\u5408\u308f\u305b\u306b\u5bfe\u5fdc</li><li>\u6b63\u78ba\u306a\u8ffd\u8de1\u306e\u305f\u3081\u306e\u53cc\u65b9\u5411\u5dee\u5206\u8868\u793a</li><li>\u9577\u3044MOD\u30ea\u30b9\u30c8\u7528\u306b\u30b9\u30af\u30ed\u30fc\u30eb\u6a5f\u80fd\u4ed8\u304d</li><li>\u8996\u899a\u7684\u7406\u89e3\u3092\u4fc3\u9032\u3059\u308b\u8aac\u660e\u753b\u50cf\u4ed8\u304d</li></ul><p>\u8a2d\u5b9a\u5185\u306e\u5909\u66f4\u3092\u8ffd\u8de1\u3067\u304d\u308b\u3088\u3046 <3\ufe0f \u3092\u8fbc\u3081\u3066\u958b\u767a\u3057\u307e\u3057\u305f\u3002</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>IPv6 \u306b\u95a2\u9023\u3059\u308b\u554f\u984c\u304c\u767a\u751f\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u89e3\u6c7a\u7b56\u306f\u4ee5\u4e0b\u306e2\u3064\u3067\u3059\uff1a1) \u30e9\u30f3\u30c1\u30e3\u30fc\u306b JVM \u5f15\u6570 <code>-Djava.net.preferIPv4Stack=true</code> \u3092\u8ffd\u52a0\u3059\u308b\u304b\u30012) CrashDetector \u306e 'QuickFix' \u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u81ea\u52d5\u7684\u306b\u3053\u306e\u8a2d\u5b9a\u3092\u6709\u52b9\u306b\u3059\u308b\u30d1\u30c3\u30c1\u3092\u9069\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String parcheIPv4() {
        return "IPv4/6 \u30d1\u30c3\u30c1";
    }

    @Override
    public String carpetaHMCL() {
        return "HMCL \u30d5\u30a9\u30eb\u30c0 (HelloMineCraftLauncher \u5c02\u7528)";
    }

    @Override
    public String descripcionCurseforge() {
        return "\u6ce8\u610f: \u8a2d\u5b9a > Minecraft \u3067\u300c\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u30b9\u30ad\u30c3\u30d7\u300d\u304c\u6709\u52b9\u306b\u306a\u3063\u3066\u3044\u308b\u3068\u30ed\u30b0\u306f\u751f\u6210\u3055\u308c\u307e\u305b\u3093\u3002";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/\u6d3e\u751f\u30bd\u30d5\u30c8: \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u53f3\u30af\u30ea\u30c3\u30af\u3057\u3001\u300c\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u7de8\u96c6\u300d\u3092\u9078\u629e\u3057\u307e\u3059\u3002\u958b\u3044\u305f\u30a6\u30a3\u30f3\u30c9\u30a6\u5185\u3067\u300cMinecraft \u30ed\u30b0\u300d\u3084\u985e\u4f3c\u3059\u308b\u30bb\u30af\u30b7\u30e7\u30f3\u3092\u63a2\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u3053\u308c\u3089\u306e\u30ed\u30b0\u306b\u306f\u30a8\u30e9\u30fc\u8a3a\u65ad\u306b\u4e0d\u53ef\u6b20\u306a\u6a19\u6e96\u51fa\u529b (STDOUT) \u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): HMCL \u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u5148\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3057\u3001\u305d\u306e\u4e2d\u306e \u300c.hmcl\u300d \u30d5\u30a9\u30eb\u30c0\u3092\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002HMCL \u306e\u30ed\u30b0\u306f\u3053\u3053\u306b\u4fdd\u5b58\u3055\u308c\u3066\u304a\u308a\u3001\u91cd\u8981\u306a\u30a8\u30e9\u30fc\u60c5\u5831\u3092\u542b\u307f\u307e\u3059\u3002<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix\uff1a\u30e9\u30f3\u30c1\u30e3\u30fc\u306b\u306f\u8a73\u7d30\u30ed\u30b0\u3092\u8868\u793a\u3059\u308b\u958b\u767a\u8005\u30bf\u30d6\u304c\u3042\u308a\u307e\u3059\u3002\u30e9\u30f3\u30c1\u30e3\u30fc\u8a2d\u5b9a\u30e1\u30cb\u30e5\u30fc\u5185\u306b\u3042\u308a\u307e\u3059\u3002";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher\uff1a\u30ed\u30b0\u306f\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u8868\u793a\u3055\u308c\u307e\u3059\u3002\u30b3\u30d4\u30fc\u304a\u3088\u3073\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30dc\u30bf\u30f3\u304c\u3042\u308a\u3001\u30b2\u30fc\u30e0\u8d77\u52d5\u6642\u306b\u81ea\u52d5\u751f\u6210\u3055\u308c\u308b\u91cd\u8981\u306a\u8a3a\u65ad\u60c5\u5831\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher\uff1a\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u53f3\u30af\u30ea\u30c3\u30af\u3057\u3001\u300c\u8a2d\u5b9a\u300d\u3092\u9078\u629e\u3057\u307e\u3059\u3002\u305d\u306e\u5f8c\u3001\u30ed\u30b0\u30bb\u30af\u30b7\u30e7\u30f3\u304b\u3089\u6a19\u6e96\u51fa\u529b (STDOUT) \u306e\u91cd\u8981\u306a\u60c5\u5831\u3092\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "Markdown\u5f62\u5f0f\u306e\u30ea\u30f3\u30af\uff1aMarkdown\u5f62\u5f0f\u306e\u30ed\u30b0\u304c\u542b\u307e\u308c\u308b\u30ea\u30f3\u30af\u3092\u8cbc\u308a\u4ed8\u3051\u3066\u304f\u3060\u3055\u3044\u3002\u30b7\u30b9\u30c6\u30e0\u304c\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u30ea\u30f3\u30af(latest.log, launcher_log.txt, debug.log\u306a\u3069)\u3092\u81ea\u52d5\u62bd\u51fa\u3057\u3066\u89e3\u6790\u3057\u307e\u3059\u3002";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "\u30e9\u30f3\u30c1\u30e3\u30fc\u30ed\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093";
    }

    @Override
    public String imagenNoEncontrada() {
        return "\u753b\u50cf\u304c\u898b\u3064\u304b\u3089\u306a\u3044";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "\u6c4e\u7528\uff1a\u4f7f\u7528\u3057\u3066\u3044\u308b\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u7a2e\u985e\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u30e9\u30f3\u30c1\u30e3\u30fc\u30ed\u30b0(launcher_log.txt, stdout\u306a\u3069)\u306f latest.log \u306b\u73fe\u308c\u306a\u3044\u91cd\u5927\u306a\u30a8\u30e9\u30fc\u60c5\u5831\u3092\u542b\u307f\u307e\u3059\u3002CrashDetector\u304c\u3042\u306a\u305f\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u30ed\u30b0\u3092\u8aad\u307f\u8fbc\u3081\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059 \u2014 \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u304c\u751f\u6210\u3055\u308c\u3066\u3044\u306a\u3044\u5834\u5408\u3001\u624b\u52d5\u3067\u30ed\u30b0\u3092\u8cbc\u308a\u4ed8\u3051\u306a\u304f\u3066\u306f\u3044\u3051\u307e\u305b\u3093\u3002<br>\u8a73\u7d30\u306b\u3064\u3044\u3066\u306f <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">\u3053\u306e\u554f\u984c</a> \u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u308c\u3089\u306e\u30ed\u30b0\u306b\u306f\u591a\u304f\u306e\u30a8\u30e9\u30fc\u8a3a\u65ad\u306b\u5fc5\u8981\u306a\u6a19\u6e96\u51fa\u529b (STDOUT) \u304c\u542b\u307e\u308c\u307e\u3059\u3002";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Create \u304b\u3089\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002Create \u306f\u5927\u5e45\u306b\u5909\u66f4\u3055\u308c\u3001\u591a\u304f\u306e\u30af\u30e9\u30b9\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f\u3002\u7279\u306b Create 6\uff082025\u5e742\u6708\uff09\u4ee5\u964d\u3001\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Create \u7528\u30a2\u30c9\u30aa\u30f3\u306f\u52d5\u4f5c\u3057\u307e\u305b\u3093\u3002QuickFix \u3067\u306f\u3053\u306e\u554f\u984c\u306b\u5bfe\u51e6\u3067\u304d\u307e\u305b\u3093\u3002Create \u306e\u30a2\u30c9\u30aa\u30f3\u3092\u66f4\u65b0\u3059\u308b\u304b\u3001\u4e0d\u8981\u306a\u30a2\u30c9\u30aa\u30f3\u3092\u524a\u9664\u3059\u308b\u304b\u3001\u4f7f\u7528\u3057\u305f\u3044\u30a2\u30c9\u30aa\u30f3\u306b\u5408\u3063\u305f\u6b63\u3057\u3044 Create \u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>EpicFight \u304b\u3089\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002EpicFight \u306f\u5927\u5e45\u306b\u5909\u66f4\u3055\u308c\u3001\u591a\u304f\u306e\u30af\u30e9\u30b9\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f\u3002QuickFix \u3067\u306f\u3053\u306e\u554f\u984c\u306b\u5bfe\u51e6\u3067\u304d\u307e\u305b\u3093\u3002EpicFight \u306e\u30a2\u30c9\u30aa\u30f3\u3092\u66f4\u65b0\u3059\u308b\u304b\u3001\u4e0d\u8981\u306a\u30a2\u30c9\u30aa\u30f3\u3092\u524a\u9664\u3059\u308b\u304b\u3001\u4f7f\u7528\u3057\u305f\u3044\u30a2\u30c9\u30aa\u30f3\u306b\u5408\u3063\u305f\u6b63\u3057\u3044 EpicFight \u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenJ9 \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f OpenJ9 \u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u591a\u304f\u306e\u30a2\u30d7\u30ea\uff08\u3053\u306e\u30a2\u30d7\u30ea\u3082\u542b\u3080\uff09\u306f JVM \u5b9f\u88c5\u306e\u9055\u3044\u306b\u3088\u308a OpenJ9 \u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002QuickFix \u3067\u306f\u3053\u306e\u554f\u984c\u3092\u81ea\u52d5\u7684\u306b\u89e3\u6c7a\u3067\u304d\u307e\u305b\u3093\u3002Oracle JDK\u3001OpenJDK Hotspot\u3001\u307e\u305f\u306f\u305d\u306e\u4ed6\u306e\u63a8\u5968\u4ee3\u66ff JDK \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3053\u306e\u30a2\u30d7\u30ea\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306f\u6b63\u5e38\u306b\u52d5\u4f5c\u3059\u308b\u305f\u3081\u306b Java 11 (JDK 11) \u304c\u5fc5\u8981\u3067\u3059\u3002\u73fe\u5728\u3001\u4e92\u63db\u6027\u306e\u306a\u3044\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Java \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002QuickFix \u3067\u306f Java \u306e\u30a2\u30c3\u30d7\u30b0\u30ec\u30fc\u30c9\u306f\u81ea\u52d5\u7684\u306b\u884c\u3048\u307e\u305b\u3093\u3002\u89e3\u6c7a\u7b56\u306b\u8a18\u8f09\u3055\u308c\u305f\u30ea\u30f3\u30af\u304b\u3089 JDK 11 \u307e\u305f\u306f\u305d\u308c\u4ee5\u4e0a\u306e\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30fb\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e1\u30e2\u30ea\u3092\u904e\u5270\u306b\u5272\u308a\u5f53\u3066\u3066\u304a\u308a\u3001\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u308c\u306f\u3001\u30b7\u30b9\u30c6\u30e0\u306e\u5b9f\u88c5\u5bb9\u91cf\u3092\u8d85\u3048\u308b RAM \u3092\u6307\u5b9a\u3057\u305f\u5834\u5408\u3084\u3001\u5927\u5bb9\u91cf\u30e1\u30e2\u30ea\u3092\u6271\u3048\u306a\u3044 32 \u30d3\u30c3\u30c8 JVM \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u3053\u306e\u554f\u984c\u3092\u89e3\u6c7a\u3059\u308b\u306b\u306f\u3001\u30a2\u30d7\u30ea\u306b\u5272\u308a\u5f53\u3066\u308b\u30e1\u30e2\u30ea\u91cf\u3092\u6e1b\u3089\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u63a8\u5968\u3055\u308c\u308b\u6700\u5927\u5024\u306f\u30b7\u30b9\u30c6\u30e0\u306b\u3088\u308a\u307e\u3059\u304c\u3001\u4e00\u822c\u7684\u306b\u5168 RAM \u306e 70\uff5e80\uff05\u3092\u8d85\u3048\u306a\u3044\u3088\u3046\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u300232 \u30d3\u30c3\u30c8 JVM \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u7269\u7406 RAM \u306e\u91cf\u306b\u95a2\u4fc2\u306a\u304f\u3001\u4e0a\u9650\u306f\u7d04 2\uff5e3 GB \u3067\u3059\u3002</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u30a2\u30d7\u30ea\u306b\u5272\u308a\u5f53\u3066\u3089\u308c\u305f\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u3092\u6e1b\u3089\u3059\u306b\u306f\u3001\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u8a2d\u5b9a\u3092\u958b\u304d\u3001RAM \u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u63a2\u3057\u307e\u3059\u3002\u6700\u5927\u5024 (Xmx) \u3092\u9069\u5207\u306a\u91cf\u306b\u4e0b\u3052\u3066\u304f\u3060\u3055\u3044\u3002\u4f8b\uff1a8GB \u306e RAM \u304c\u3042\u308b\u5834\u5408\u30013\uff5e4GB \u3092\u5272\u308a\u5f53\u3066\u307e\u3059\u300216GB \u306e\u5834\u5408\u30016\uff5e8GB \u304c\u9069\u5207\u3067\u3059\u3002OS \u3084\u4ed6\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u305f\u3081\u306b\u5341\u5206\u306a\u30e1\u30e2\u30ea\u3092\u6b8b\u3059\u3053\u3068\u3092\u5fd8\u308c\u306a\u3044\u3067\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge\u306e\u5fc5\u9808\u30d5\u30a1\u30a4\u30eb\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb '" + archivo + "' \u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u5185\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u3053\u308c\u306f\u901a\u5e38\u3001Forge\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u4e2d\u65ad\u3055\u308c\u305f\u304b\u3001\u91cd\u8981\u306a\u30d5\u30a1\u30a4\u30eb\u304c\u524a\u9664\u3055\u308c\u305f\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002QuickFix\u3067\u306f\u3053\u308c\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u81ea\u52d5\u5fa9\u5143\u3067\u304d\u307e\u305b\u3093\u3002\u516c\u5f0f\u30a4\u30f3\u30b9\u30c8\u30fc\u30e9\u30fc\u3092\u4f7f\u7528\u3057\u3066Forge\u3092\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge\u304c\u5fc5\u8981\u306aMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u898b\u3064\u3051\u3089\u308c\u307e\u305b\u3093\u3002\u30d0\u30fc\u30b8\u30e7\u30f3 " + version + " \u304c\u5fc5\u8981\u3067\u3059\u304c\u3001\u30d5\u30a1\u30a4\u30eb '" + archivo + "' \u306b\u3042\u308a\u307e\u305b\u3093\u3002\u3053\u308c\u306fMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4f7f\u7528\u4e2d\u306eForge\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e00\u81f4\u3057\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002Minecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5408\u3063\u305f\u6b63\u3057\u3044Forge\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge\u8d77\u52d5\u306b\u5fc5\u8981\u306a 'fmlclient' \u30bf\u30fc\u30b2\u30c3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u3053\u308c\u306fForge\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u4e0d\u5b8c\u5168\u307e\u305f\u306f\u7834\u640d\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002Forge\u306e\u91cd\u8981\u306a\u30d5\u30a1\u30a4\u30eb\u304c\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u516c\u5f0f\u30a4\u30f3\u30b9\u30c8\u30fc\u30e9\u30fc\u3092\u4f7f\u7528\u3057\u3066Forge\u3092\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u30fc\u306bMinecraft\u306e\u30e1\u30a4\u30f3\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u3053\u308c\u306f\u901a\u5e38\u3001Forge\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u4e0d\u5b8c\u5168\u304b\u3001\u4ed6\u306eMOD\u3068\u7af6\u5408\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u793a\u3057\u307e\u3059\u3002Forge\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u4e2d\u306bMinecraft\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002Forge\u3092\u6b63\u3057\u304f\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u5b8c\u4e86\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u4e2d\u65ad\u3055\u308c\u305f\u3001\u30d5\u30a1\u30a4\u30eb\u304c\u524a\u9664\u3055\u308c\u305f\u3001\u307e\u305f\u306fMinecraft\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u304c\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002Forge\u306f\u6b63\u5e38\u306b\u52d5\u4f5c\u3059\u308b\u305f\u3081\u306b\u7279\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5fc5\u8981\u3067\u3059\u304c\u3001\u73fe\u5728\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304b\u3089\u4e00\u90e8\u304c\u6b20\u3051\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "Forge\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u4e0d\u5b8c\u5168";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u3053\u306e\u554f\u984c\u3092\u89e3\u6c7a\u3059\u308b\u306b\u306f\u3001Forge\u3092\u6b63\u3057\u304f\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002Minecraft\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5408\u3063\u305f\u6b63\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3001\u4e2d\u65ad\u305b\u305a\u306b\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u624b\u9806\u3092\u5b8c\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "\u516c\u5f0f\u30b5\u30a4\u30c8\u304b\u3089Forge\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "Forge\u3092\u6b63\u3057\u304f\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u65b9\u6cd5";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>Forge\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u624b\u9806\uff1a</h3><ol><li>\u516c\u5f0f\u30b5\u30a4\u30c8\u304b\u3089\u6b63\u3057\u3044Forge\u30a4\u30f3\u30b9\u30c8\u30fc\u30e9\u30fc\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\uff08Minecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5408\u3063\u305f\u63a8\u5968\u30d0\u30fc\u30b8\u30e7\u30f3\uff09</li><li>Minecraft\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u5b8c\u5168\u306b\u7d42\u4e86</li><li>\u7ba1\u7406\u8005\u6a29\u9650\u3067Forge\u30a4\u30f3\u30b9\u30c8\u30fc\u30e9\u30fc\u3092\u5b9f\u884c</li><li>'Installer'\u3092\u9078\u629e\uff08'Installer (run client)' \u3067\u306f\u306a\u3044\uff09</li><li>\u30e9\u30f3\u30c1\u30e3\u30fc\u5185\u306eMinecraft\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e</li><li>'OK'\u3092\u30af\u30ea\u30c3\u30af\u3057\u3001\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u5b8c\u4e86\u307e\u3067\u5f85\u6a5f</li><li>\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u518d\u8d77\u52d5\u3057\u3001Forge\u304c\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7\u306b\u8868\u793a\u3055\u308c\u308b\u3053\u3068\u3092\u78ba\u8a8d</li></ol><p><b>\u91cd\u8981\uff1a</b>\u30ab\u30b9\u30bf\u30e0\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u4f7f\u7528\u3059\u308b\u5834\u5408\u3001\u6b63\u3057\u3044\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "Forge\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u624b\u9806";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30ea\u30f3\u30af\u30a8\u30e9\u30fc\uff1a\u30e9\u30a4\u30d6\u30e9\u30ea " + nombreBiblioteca + " \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u8003\u3048\u3089\u308c\u308b\u89e3\u6c7a\u7b56\uff1a<br/><br/>a) \u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u542b\u3080\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092 -Djava.library.path \u307e\u305f\u306f -Dorg.lwjgl.librarypath \u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002<br/>b) \u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u542b\u3080 JAR \u30d5\u30a1\u30a4\u30eb\u3092 classpath \u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002<br/><br/>\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001Minecraft \u304c\u5b9f\u884c\u306b\u5fc5\u8981\u306a\u91cd\u8981\u306a\u30d5\u30a1\u30a4\u30eb\u3092\u898b\u3064\u3051\u3089\u308c\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u4e0d\u5b8c\u5168\u3067\u3042\u308b\u304b\u3001\u30b7\u30b9\u30c6\u30e0\u306e\u6a29\u9650\u306b\u554f\u984c\u304c\u3042\u308b\u3053\u3068\u304c\u539f\u56e0\u3067\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "\u30ea\u30f3\u30af\u30a8\u30e9\u30fc";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u8003\u3048\u3089\u308c\u308b\u89e3\u6c7a\u7b56\uff1a<br/><br/>a) \u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u542b\u3080\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092 -Djava.library.path \u307e\u305f\u306f -Dorg.lwjgl.librarypath \u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002<br/>b) \u5171\u6709\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u542b\u3080 JAR \u30d5\u30a1\u30a4\u30eb\u3092 classpath \u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002<br/><br/>\u3053\u308c\u3089\u306e\u6280\u8853\u7684\u89e3\u6c7a\u7b56\u306f\u4e0a\u7d1a\u8005\u5411\u3051\u3067\u3059\u3002\u307b\u3068\u3093\u3069\u306e\u30e6\u30fc\u30b6\u30fc\u306f\u3001\u3053\u308c\u3089\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u5909\u66f4\u3059\u308b\u524d\u306b Minecraft \u3092\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u3053\u3068\u3092\u304a\u52e7\u3081\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ID\u306e\u885d\u7a81: ID <strong>" + id + "</strong> \u306f\u3001<strong>" + modOrigen + "</strong> \u306b\u3088\u3063\u3066\u65e2\u306b\u4f7f\u7528\u3055\u308c\u3066\u304a\u308a\u3001<strong>" + modDestino + "</strong> \u3092\u8ffd\u52a0\u3057\u3088\u3046\u3068\u3057\u305f\u3068\u304d\u306b\u767a\u751f\u3057\u307e\u3059\u3002\u3053\u308c\u306f\u30012\u3064\u306eMOD\u304c\u7570\u306a\u308b\u8981\u7d20\u306b\u540c\u3058ID\u3092\u4f7f\u7528\u3057\u3088\u3046\u3068\u3057\u305f\u5834\u5408\u306b\u8d77\u3053\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u8a31\u53ef\u3055\u308c\u305fID\u306e\u6700\u5927\u7bc4\u56f2\u3092\u8d85\u3048\u307e\u3057\u305f\u3002MOD\u304cMinecraft\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u7bc4\u56f2\u306eID\u3067\u30d6\u30ed\u30c3\u30af\u3084\u30a2\u30a4\u30c6\u30e0\u3092\u767b\u9332\u3057\u3088\u3046\u3068\u3057\u305f\u3068\u304d\u306b\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "ID\u306e\u885d\u7a81";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u3053\u306e\u554f\u984c\u3092\u89e3\u6c7a\u3059\u308b\u306b\u306f\u3001Minecraft 1.12.2\u306b <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a> \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u30021.7.10\u306e\u5834\u5408\u306f <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a> \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>ID\u306e\u885d\u7a81\u3092\u89e3\u6c7a\u3059\u308b\u306b\u306f\u3001<a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> \u3084 <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a> \u306a\u3069\u306e\u30c4\u30fc\u30eb\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "JustEnoughIDs\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb";
    }

    @Override
    public String instalar_endlessids() {
        return "EndlessIDs\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb";
    }

    @Override
    public String usar_idfix_minus() {
        return "IdFix Minus\u307e\u305f\u306fIdFix\u3092\u4f7f\u7528";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "Minecraft-ID-Resolver\u3092\u4f7f\u7528";
    }

    @Override
    public String ver_documentacion_jp() {
        return "\u65e5\u672c\u8a9e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u8868\u793a";
    }

    @Override
    public String escanearDeMCreator() {
        return "MCreator\u3092\u30b9\u30ad\u30e3\u30f3";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\u30e2\u30b8\u30e5\u30fc\u30eb\u3068\u30af\u30e9\u30b9\u306e\u30c4\u30ea\u30fc";
    }

    @Override
    public String tipoBusqueda() {
        return "\u30bf\u30a4\u30d7";
    }

    @Override
    public String filtroTodos() {
        return "\u3059\u3079\u3066";
    }

    @Override
    public String filtroPaquetes() {
        return "\u30d1\u30c3\u30b1\u30fc\u30b8";
    }

    @Override
    public String filtroClases() {
        return "\u30af\u30e9\u30b9";
    }

    @Override
    public String filtroMetodos() {
        return "\u30e1\u30bd\u30c3\u30c9";
    }

    @Override
    public String filtroCampos() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9\u53c2\u7167";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "\u30e1\u30bd\u30c3\u30c9\u53c2\u7167";
    }

    @Override
    public String filtroReferenciasClase() {
        return "\u30af\u30e9\u30b9\u53c2\u7167";
    }

    @Override
    public String tipBuscar() {
        return "\u3053\u3053\u306b\u6587\u5b57\u3092\u5165\u529b\u3057\u3066\u30e2\u30c3\u30c9\u30c4\u30ea\u30fc\u3092\u691c\u7d22";
    }

    @Override
    public String botonBuscar() {
        return "\u691c\u7d22";
    }

    @Override
    public String botonResetearArbol() {
        return "\u30c4\u30ea\u30fc\u3092\u30ea\u30bb\u30c3\u30c8";
    }

    @Override
    public String modsCargados() {
        return "\u30ed\u30fc\u30c9\u6e08\u307f\u306e\u30e2\u30c3\u30c9";
    }

    @Override
    public String clases() {
        return "\u30af\u30e9\u30b9";
    }

    @Override
    public String metodos() {
        return "\u30e1\u30bd\u30c3\u30c9";
    }

    @Override
    public String campos() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9";
    }

    @Override
    public String referencias() {
        return "\u53c2\u7167";
    }

    @Override
    public String resultadosBusqueda() {
        return "\u691c\u7d22\u7d50\u679c";
    }

    @Override
    public String buscarReferencias() {
        return "\u53c2\u7167\u3092\u691c\u7d22";
    }

    @Override
    public String referenciasMod() {
        return "\u30e2\u30c3\u30c9\u306e\u53c2\u7167";
    }

    @Override
    public String referenciasClase() {
        return "\u30af\u30e9\u30b9\u306e\u53c2\u7167";
    }

    @Override
    public String referenciasMetodo() {
        return "\u30e1\u30bd\u30c3\u30c9\u306e\u53c2\u7167";
    }

    @Override
    public String referenciasCampo() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u53c2\u7167";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "\u53c2\u7167\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093";
    }

    @Override
    public String detalleMod() {
        return "\u30e2\u30c3\u30c9\u306e\u8a73\u7d30:";
    }

    @Override
    public String ubicacion() {
        return "\u5834\u6240";
    }

    @Override
    public String nombres() {
        return "\u540d\u524d";
    }

    @Override
    public String modulo() {
        return "\u30e2\u30b8\u30e5\u30fc\u30eb";
    }

    @Override
    public String detalleClase() {
        return "\u30af\u30e9\u30b9\u306e\u8a73\u7d30:";
    }

    @Override
    public String detalleMetodo() {
        return "\u30e1\u30bd\u30c3\u30c9\u306e\u8a73\u7d30:";
    }

    @Override
    public String detalleCampo() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u8a73\u7d30:";
    }

    @Override
    public String clase() {
        return "\u30af\u30e9\u30b9";
    }

    @Override
    public String tipo() {
        return "\u30bf\u30a4\u30d7";
    }

    @Override
    public String referenciasAMetodos() {
        return "\u30e1\u30bd\u30c3\u30c9\u3078\u306e\u53c2\u7167:";
    }

    @Override
    public String referenciasACampos() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9\u3078\u306e\u53c2\u7167:";
    }

    @Override
    public String arbolDeMods() {
        return "\u30e2\u30c3\u30c9\u30c4\u30ea\u30fc";
    }

    @Override
    public String metodo() {
        return "\u30e1\u30bd\u30c3\u30c9";
    }

    @Override
    public String campo() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9";
    }

    @Override
    public String descompilar() {
        return "\u30c7\u30b3\u30f3\u30d1\u30a4\u30eb";
    }

    @Override
    public String exportar() {
        return "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8";
    }

    @Override
    public String importar() {
        return "\u30a4\u30f3\u30dd\u30fc\u30c8";
    }

    @Override
    public String errorImportar() {
        return "\u30a4\u30f3\u30dd\u30fc\u30c8\u30a8\u30e9\u30fc";
    }

    @Override
    public String estructuraImportada() {
        return "\u69cb\u9020\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u307e\u3057\u305f";
    }

    @Override
    public String estructuraExportada() {
        return "\u69cb\u9020\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3057\u307e\u3057\u305f";
    }

    @Override
    public String errorExportar() {
        return "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u30a8\u30e9\u30fc";
    }

    @Override
    public String exportando() {
        return "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u4e2d";
    }

    @Override
    public String exportacionTardara() {
        return "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u306b\u6642\u9593\u304c\u304b\u304b\u308b\u5834\u5408\u304c\u3042\u308a\u307e\u3059";
    }

    @Override
    public String porFavorEspere() {
        return "\u304a\u5f85\u3061\u304f\u3060\u3055\u3044";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>VLC\u306e\u30d0\u30a4\u30ca\u30ea\u304c\u3042\u308a\u307e\u305b\u3093\u3002WaterMedia\u306fVLC\u306e\u30d0\u30a4\u30ca\u30ea\u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u3002https://www.videolan.org/vlc/ \u304b\u3089\u624b\u52d5\u3067\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "VLC\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u30a8\u30e9\u30fc\uff1a\u30e2\u30b8\u30e5\u30fc\u30eb\u540d '" + nombreModulo + "' \u306b\u7121\u52b9\u306a\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002'" + parteInvalida + "' \u306f\u6709\u52b9\u306aJava\u8b58\u5225\u5b50\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002Java\u306e\u4e88\u7d04\u8a9e\uff08\u4f8b\uff1a'true', 'class'\uff09\u3084\u540d\u524d\u306b\u4f7f\u7528\u3067\u304d\u306a\u3044\u6587\u5b57\u3092\u30e2\u30c3\u30c9\u304c\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "\u30e2\u30c3\u30c9\u540d\u306b\u7121\u52b9\u306a\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "\u30e2\u30c3\u30c9\u540d '" + nombreModulo + "' \u306f '" + parteInvalida + "' \u3092\u542b\u3080\u305f\u3081\u7121\u52b9\u3067\u3059\u3002\u3053\u308c\u306fJava\u306e\u4e88\u7d04\u8a9e\u307e\u305f\u306f\u7121\u52b9\u306a\u6587\u5b57\u3067\u3059\u3002 \u30ed\u30b0\u3092\u78ba\u8a8d\u3057\u3066\u3001\u3053\u306e\u540d\u524d\u306b\u5bfe\u5fdc\u3059\u308b\u30e2\u30c3\u30c9\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u901a\u5e38\u306fJAR\u30d5\u30a1\u30a4\u30eb\u540d\uff09";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "\u30e2\u30c3\u30c9\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304d\u3001<b>/META-INF/</b> \u30d5\u30a9\u30eb\u30c0\u5185\u306e <b>mods.toml</b> \u30d5\u30a1\u30a4\u30eb\u3092\u7de8\u96c6\u3057\u3066\u304f\u3060\u3055\u3044\u3002 <b>modId</b> \u306e\u5024\u3092\u3001Java\u306e\u4e88\u7d04\u8a9e\u3092\u4f7f\u308f\u305a\u3001\u82f1\u6570\u5b57\u3068\u30a2\u30f3\u30c0\u30fc\u30b9\u30b3\u30a2\u306e\u307f\u3067\u69cb\u6210\u3055\u308c\u308b\u3088\u3046\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "\u6709\u52b9\u306a\u540d\u524d\u306e\u4f8b\uff1a'true.shot.enchantment' \u306e\u4ee3\u308f\u308a\u306b 'truemod_shot_enchantment' \u3092\u4f7f\u7528\u3002 \u30e2\u30c3\u30c9\u540d\u306b\u306f\u30c9\u30c3\u30c8\u3001\u30cf\u30a4\u30d5\u30f3\u3001Java\u306e\u4e88\u7d04\u8a9e\uff08'true'\u3001'false'\u3001'class'\u306a\u3069\uff09\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30e2\u30c3\u30c9 '" + nombreJar + "' \u306b\u91cd\u5927\u30a8\u30e9\u30fc\uff1a\u4f9d\u5b58\u95a2\u4fc2\u306b\u5fc5\u9808\u30d5\u30a3\u30fc\u30eb\u30c9 'mandatory' \u304c\u3042\u308a\u307e\u305b\u3093\u3002mods.toml \u30d5\u30a1\u30a4\u30eb\u304c\u4f9d\u5b58\u95a2\u4fc2\u304c\u5fc5\u9808\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a\u3057\u3066\u3044\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "\u30e2\u30c3\u30c9\u4f9d\u5b58\u95a2\u4fc2\u306b\u5fc5\u9808\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u4e0d\u8db3";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "\u554f\u984c\u306e\u3042\u308b\u30e2\u30c3\u30c9\u306f\uff1a<b>" + nombreJar + "</b> \u3067\u3059\u3002\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u4f9d\u5b58\u8a2d\u5b9a\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "<b>" + nombreJar + "</b> \u30e2\u30c3\u30c9\u306e <b>/META-INF/</b> \u30d5\u30a9\u30eb\u30c0\u5185\u306b\u3042\u308b <b>mods.toml</b> \u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3044\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "\u4f9d\u5b58\u95a2\u4fc2\u30bb\u30af\u30b7\u30e7\u30f3\u3067\u3001\u5404\u30a8\u30f3\u30c8\u30ea\u306b <b>mandatory=true</b> \u307e\u305f\u306f <b>mandatory=false</b> \u304c\u542b\u307e\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u4f8b\uff1amodId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" \uff09";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u30a8\u30e9\u30fc\uff1a\u30e2\u30c3\u30c9 '" + nombreJar + "' \u306eaccess transformer\u8a2d\u5b9a\u304c\u7121\u52b9\u3067\u3059\u3002\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u69cb\u6587\u304c\u8aa4\u3063\u3066\u3044\u308b\u304b\u3001\u5b58\u5728\u3057\u306a\u3044\u30af\u30e9\u30b9/\u30e1\u30bd\u30c3\u30c9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "\u7121\u52b9\u306a Access Transformer";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "\u554f\u984c\u306e\u3042\u308b\u30e2\u30c3\u30c9\u306f\uff1a<b>" + nombreJar + "</b> \u3067\u3059\u3002\u3053\u306e\u30e2\u30c3\u30c9\u306b\u306f\u7121\u52b9\u306aaccess transformer\u8a2d\u5b9a\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "\u30e2\u30c3\u30c9 <b>" + nombreJar + "</b> \u5185\u306e <b>accessTransformer.cfg</b> \u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3044\u3066\u304f\u3060\u3055\u3044\uff08\u901a\u5e38\u306fJAR\u30d5\u30a1\u30a4\u30eb\u306e\u30eb\u30fc\u30c8\u30d5\u30a9\u30eb\u30c0\u306b\u3042\u308a\u307e\u3059\uff09";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "access transformer\u306e\u69cb\u6587\u3092\u4fee\u6b63\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5404\u884c\u306f <b>access class.method</b> \u306e\u5f62\u5f0f\u306b\u5f93\u3046\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\uff08\u4f8b\uff1apublic net.minecraft.world.entity.Entity.func_200560_a\uff09\u3002\u73fe\u5728\u306eMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5b58\u5728\u3057\u306a\u3044\u30af\u30e9\u30b9\u3084\u30e1\u30bd\u30c3\u30c9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b\u884c\u306f\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u30a8\u30e9\u30fc\uff1a@Mod\u30a2\u30ce\u30c6\u30fc\u30b7\u30e7\u30f3\u306e\u30e2\u30c3\u30c9ID\u3068mods.toml\u30d5\u30a1\u30a4\u30eb\u306eID\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002'" + nombreMod + "' \u30e2\u30c3\u30c9\u306fID\u306e\u4e0d\u4e00\u81f4\u306b\u3088\u308a\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "@Mod\u3068mods.toml\u306eID\u4e0d\u4e00\u81f4";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "\u958b\u767a\u4e2d\u306e\u30e2\u30c3\u30c9 '" + nombreMod + "' \u306f\u3001<b>@Mod</b> \u30a2\u30ce\u30c6\u30fc\u30b7\u30e7\u30f3\u3068 <b>mods.toml</b> \u306eID\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "\u30e1\u30a4\u30f3\u30af\u30e9\u30b9\u306eID\u304c <b>/META-INF/mods.toml</b> \u30d5\u30a1\u30a4\u30eb\u306e <b>modId</b> \u5024\u3068\u4e00\u81f4\u3057\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4f8b\uff1a <b>@Mod(\"mymod\")</b> \u306f <b>modId=\"mymod\"</b> \u3068\u4e00\u81f4\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "Gradle\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u5909\u66f4\u5f8c\u306b <b>clean</b> \u3092\u5b9f\u884c\u3057\u3066\u30ea\u30bd\u30fc\u30b9\u304c\u6b63\u3057\u304f\u66f4\u65b0\u3055\u308c\u308b\u3088\u3046\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u53e4\u3044\u30d5\u30a1\u30a4\u30eb\u304cbuild\u30d5\u30a9\u30eb\u30c0\u306b\u6b8b\u3063\u3066\u3044\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8" : "\u30b5\u30fc\u30d0\u30fc";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u30b5\u30fc\u30d0\u30fc" : "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u30a8\u30e9\u30fc: \u30af\u30e9\u30b9 '" + nombreClase + "' \u3092 " + plataforma + " \u74b0\u5883\u3067\u8aad\u307f\u8fbc\u3082\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u308c\u306f " + plataformaOpuesta + " \u5411\u3051\u306b\u8a2d\u8a08\u3055\u308c\u3066\u3044\u307e\u3059\u3002<b>\u30b5\u30a4\u30c9\u30d0\u30fc\u306e\u300cMod\u30c4\u30ea\u30fc\u300d\u6a5f\u80fd\u3092\u4f7f\u3063\u3066\u3001\u3053\u306e\u30af\u30e9\u30b9\u3092\u8aad\u307f\u8fbc\u3082\u3046\u3068\u3057\u3066\u3044\u308bMod\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3002Mod\u306f\u7279\u5b9a\u306e\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\u5c02\u7528\u3067\u3042\u308a\u3001\u4ed6\u3067\u306f\u52d5\u4f5c\u3057\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "\u8aa4\u3063\u305f\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\u306eMod";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "\u53f3\u5074\u306e <b>Mod\u30c4\u30ea\u30fc</b> \u30bf\u30d6\u3067\u3001<b>" + nombreClase + "</b> \u30af\u30e9\u30b9\u3078\u306e\u53c2\u7167\u3092\u691c\u7d22\u3057\u3001\u554f\u984c\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u3044\u308bMod\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8" : "\u30b5\u30fc\u30d0\u30fc";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u30b5\u30fc\u30d0\u30fc" : "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8";
        return "\u7279\u5b9a\u3055\u308c\u305fMod\u306f <b>" + plataformaOpuesta + "</b> \u5411\u3051\u3067\u3042\u308a\u3001" + plataforma + " \u74b0\u5883\u3067\u306f\u4f7f\u7528\u3059\u3079\u304d\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "\u554f\u984c\u306e\u3042\u308bMod\u3092 <b>mods</b> \u30d5\u30a9\u30eb\u30c0\u304b\u3089\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u306e\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\u3067\u540c\u69d8\u306e\u6a5f\u80fd\u304c\u5fc5\u8981\u306a\u5834\u5408\u306f\u3001<b>\u30af\u30e9\u30a4\u30a2\u30f3\u30c8</b> \u307e\u305f\u306f <b>\u30b5\u30fc\u30d0\u30fc</b> \u5c02\u7528\u306b\u8a2d\u8a08\u3055\u308c\u305f\u4ee3\u66ffMod\u3092\u691c\u7d22\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u91cd\u5927\u30a8\u30e9\u30fc: modid '").append(modIdFaltante).append("'.\u306e\u30e1\u30bf\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093\u3002 ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("\u4ee5\u4e0b\u306eMod\u304c\u539f\u56e0\u3067\u3042\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", \u305d\u306e\u4ed6...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Mod\u304c\u672a\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u307e\u305f\u306fmods.toml\u30d5\u30a1\u30a4\u30eb\u304c\u6b63\u3057\u304f\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "mods.toml \u30e1\u30bf\u30c7\u30fc\u30bf\u306e\u6b20\u843d";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u4ee5\u4e0b\u306eMod\u304c '").append(modIdFaltante).append("'.\u306b\u4f9d\u5b58\u3057\u3066\u3044\u307e\u3059: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", \u305d\u306e\u4ed6...");
            }
            paso.append("</b>. <b>Mod\u30c4\u30ea\u30fc</b> \u6a5f\u80fd\u3067\u554f\u984c\u306eMod\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
            return paso.toString();
        }
        return "Mod\u304c '".concat(modIdFaltante).concat("' \u306b\u4f9d\u5b58\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u306eMod\u306f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002<b>Mod\u30c4\u30ea\u30fc</b> \u6a5f\u80fd\u3067\u554f\u984c\u306eMod\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u4ee5\u4e0b\u306e2\u3064\u306e\u9078\u629e\u80a2\u304c\u3042\u308a\u307e\u3059:<br/>" + "1. <b>\u4e0d\u8db3\u3057\u3066\u3044\u308bMod\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb</b>: ID\u304c '".concat(modIdFaltante).concat("' \u306eMod\u3092\u691c\u7d22\u30fb\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044<br/>") + "2. <b>\u4f9d\u5b58Mod\u3092\u524a\u9664</b>: \u6a5f\u80fd\u304c\u4e0d\u8981\u306a\u5834\u5408\u3001'".concat(modIdFaltante).concat("' \u306b\u4f9d\u5b58\u3059\u308bMod\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044");
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "'".concat(modIdFaltante).concat("' \u304c\u30e9\u30a4\u30d6\u30e9\u30ea\uff08\u4f8b: 'forge', 'minecraft', 'curios'\uff09\u306e\u5834\u5408\u3001") + "\u6b63\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306eMinecraft\u3068Forge\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u901a\u5e38\u306eMod\u306e\u5834\u5408\u306f\u3001\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30da\u30fc\u30b8\u3067\u5fc5\u8981\u306a\u524d\u63d0\u6761\u4ef6\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u8b66\u544a\uff1a\u30b5\u30a6\u30f3\u30c9\u30b7\u30b9\u30c6\u30e0\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30b5\u30a6\u30f3\u30c9\u3068\u97f3\u697d\u306f\u7121\u52b9\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002\u3053\u306e\u30a8\u30e9\u30fc\u306f\u4e00\u822c\u7684\u306bSoundPhysicsMod\u306b\u95a2\u9023\u3057\u3066\u304a\u308a\u3001\u4ed6\u306e\u30b5\u30a6\u30f3\u30c9\u30e9\u30a4\u30d6\u30e9\u30ea\u3068\u306e\u7af6\u5408\u304c\u539f\u56e0\u3067\u3042\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "\u30b5\u30a6\u30f3\u30c9\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "\u3053\u306e\u30a8\u30e9\u30fc\u306f\u901a\u5e38<b>SoundPhysicsMod</b>\u306b\u95a2\u9023\u3057\u3066\u3044\u307e\u3059\u3002\u4f7f\u7528\u3057\u3066\u3044\u308bMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "\u4ed6\u306e\u30b5\u30a6\u30f3\u30c9MOD\uff08Sound Filters\u3001Dynamic Surroundings\u306a\u3069\uff09\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u4e00\u6642\u7684\u306bSoundPhysicsMod\u3092\u524a\u9664\u3057\u3066\u7af6\u5408\u304c\u89e3\u6d88\u3055\u308c\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "<b>logs</b>\u30d5\u30a9\u30eb\u30c0\u3092\u78ba\u8a8d\u3057\u3001LWJGL\u3084OpenAL\u306b\u95a2\u3059\u308b\u8ffd\u52a0\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8abf\u3079\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u308c\u3089\u306f\u57fa\u76e4\u3068\u306a\u308b\u30b5\u30a6\u30f3\u30c9\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u554f\u984c\u304c\u3042\u308b\u53ef\u80fd\u6027\u3092\u793a\u3057\u3066\u3044\u307e\u3059";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u91cd\u5927\u30a8\u30e9\u30fc\uff1a\u30af\u30e9\u30b9'").append(nombreClase).append("'\u306f\u30a4\u30d9\u30f3\u30c8\u30ea\u30b9\u30ca\u30fc\u3068\u3057\u3066\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001\u6709\u52b9\u306a\u30e1\u30bd\u30c3\u30c9\u304c\u3042\u308a\u307e\u305b\u3093\u3002 ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u3053\u306e\u30af\u30e9\u30b9\u306f\u4ee5\u4e0b\u306eMOD\u306b\u3042\u308a\u307e\u3059\uff1a<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u305d\u306e\u4ed6...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("@SubscribeEvent\u30a2\u30ce\u30c6\u30fc\u30b7\u30e7\u30f3\u306e\u3064\u3044\u305f\u30e1\u30bd\u30c3\u30c9\u3092\u6301\u305f\u305a\u306b\u3001\u30a4\u30d9\u30f3\u30c8\u30ea\u30b9\u30ca\u30fc\u3068\u3057\u3066\u30af\u30e9\u30b9\u3092\u767b\u9332\u3057\u305f\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "\u30a4\u30d9\u30f3\u30c8\u30ea\u30b9\u30ca\u30fc\u306a\u3057\u3067\u767b\u9332\u3055\u308c\u305f\u30af\u30e9\u30b9";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u554f\u984c\u306e\u3042\u308b\u30af\u30e9\u30b9\u306f\u4ee5\u4e0b\u306eMOD\u306b\u3042\u308a\u307e\u3059\uff1a<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u305d\u306e\u4ed6...");
            }
            paso.append("</b>\u3002\u3053\u308c\u3089\u306eMOD\u306f\u6709\u52b9\u306a\u30e1\u30bd\u30c3\u30c9\u306a\u3057\u306b\u30a4\u30d9\u30f3\u30c8\u3092\u767b\u9332\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059");
            return paso.toString();
        }
        return "\u30af\u30e9\u30b9<b>" + nombreClase + "</b>\u306f\u30a4\u30d9\u30f3\u30c8\u3092\u30ea\u30c3\u30b9\u30f3\u3059\u308b\u3088\u3046\u306b\u767b\u9332\u3055\u308c\u307e\u3057\u305f\u304c\u3001<b>@SubscribeEvent</b>\u30a2\u30ce\u30c6\u30fc\u30b7\u30e7\u30f3\u306e\u3064\u3044\u305f\u30e1\u30bd\u30c3\u30c9\u304c\u3042\u308a\u307e\u305b\u3093\u3002<b>MOD\u30c4\u30ea\u30fc</b>\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u3053\u306e\u30af\u30e9\u30b9\u3092\u542b\u3080MOD\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u5185\u3067\u3001\u30af\u30e9\u30b9<b>" + nombreClase + "</b>\u304c\u4ee5\u4e0b\u306e\u5f62\u5f0f\u306e\u30e1\u30bd\u30c3\u30c9\u3092\u5c11\u306a\u304f\u3068\u30821\u3064\u6301\u3063\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\uff1a<b>@SubscribeEvent public void \u30e1\u30bd\u30c3\u30c9\u540d(\u7279\u5b9a\u306e\u30a4\u30d9\u30f3\u30c8 \u30a4\u30d9\u30f3\u30c8) { ... }</b>\u3002 \u5185\u90e8\u30af\u30e9\u30b9\u306e\u5834\u5408\u3001static\u3067\u306a\u3044\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("\u8b58\u5225\u3055\u308c\u305fMOD\u306b\u3064\u3044\u3066(<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", \u306a\u3069");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("\u3053\u306eMOD\u306e\u958b\u767a\u8005\u306b\u9023\u7d61\u3057\u3066\u554f\u984c\u3092\u4fee\u6b63\u3057\u3066\u3082\u3089\u3063\u3066\u304f\u3060\u3055\u3044\u3002 ");
            } else {
                paso.append("\u3053\u308c\u3089\u306eMOD\u306e\u958b\u767a\u8005\u306b\u9023\u7d61\u3057\u3066\u554f\u984c\u3092\u4fee\u6b63\u3057\u3066\u3082\u3089\u3063\u3066\u304f\u3060\u3055\u3044\u3002 ");
            }
        }
        paso.append("\u3042\u306a\u305f\u304c\u958b\u767a\u8005\u306e\u5834\u5408\u3001EventBus\u304b\u3089\u306e\u3053\u306e\u30af\u30e9\u30b9\u306e\u767b\u9332\u3092\u524a\u9664\u3059\u308b\u304b\u3001\u6709\u52b9\u306a@SubscribeEvent\u30e1\u30bd\u30c3\u30c9\u3092\u8ffd\u52a0\u3057\u3066\u304f\u3060\u3055\u3044");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u30a8\u30e9\u30fc: \u30d5\u30a1\u30a4\u30eb '" + nombreArchivo + "' \u3092\u51e6\u7406\u4e2d\u306b 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' \u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001\u30e9\u30f3\u30c1\u30e3\u30fc\u304c\u30e2\u30c3\u30c9\u30d1\u30c3\u30af\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u6b63\u3057\u304f\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u307e\u305f\u306f\u5c55\u958b\u3067\u304d\u306a\u304b\u3063\u305f\u3053\u3068\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002 'zip END header not found' \u3068\u3044\u3046\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u3001JAR\u30d5\u30a1\u30a4\u30eb\u304c\u4e0d\u5b8c\u5168\u307e\u305f\u306f\u7834\u640d\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u793a\u3057\u3066\u304a\u308a\u3001\u5927\u5bb9\u91cf\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u9069\u5207\u306b\u51e6\u7406\u3067\u304d\u306a\u3044\u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u975e\u5e38\u306b\u4e00\u822c\u7684\u3067\u3059\u3002 \u3053\u306e\u554f\u984c\u306f\u4e3b\u306bTwitch/CurseForge\u3001Technic Launcher\u3001\u7279\u306bLuna Pixel\u306e\u30e6\u30fc\u30b6\u30fc\u306b\u5f71\u97ff\u3092\u4e0e\u3048\u307e\u3059\u3002\u3053\u308c\u3089\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u306f\u3001\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u306e\u5b8c\u5168\u306a\u6574\u5408\u6027\u3092\u691c\u8a3c\u3067\u304d\u306a\u3044\u3053\u3068\u304c\u3088\u304f\u3042\u308a\u307e\u3059\u3002 Luna Pixel\u30e6\u30fc\u30b6\u30fc\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u6574\u5408\u6027\u3092\u3088\u308a\u9069\u5207\u306b\u51e6\u7406\u3057\u3001\u3053\u306e\u7279\u5b9a\u306e\u30a8\u30e9\u30fc\u3092\u56de\u907f\u3067\u304d\u308bATLauncher\u3078\u306e\u79fb\u884c\u3092\u691c\u8a0e\u3059\u3079\u304d\u3067\u3059\u3002 ZIP\u5f62\u5f0f\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30b7\u30b9\u30c6\u30e0\u306f\u30e2\u30c3\u30c9\u3092\u8aad\u307f\u8fbc\u3081\u305a\u3001Forge\u304c\u30b2\u30fc\u30e0\u8d77\u52d5\u306b\u5fc5\u8981\u306a\u30ea\u30bd\u30fc\u30b9\u3092\u8aad\u307f\u53d6\u308b\u306e\u3092\u59a8\u3052\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "UnionFileSystem\u30a8\u30e9\u30fc - \u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "\u30e2\u30c3\u30c9\u30d1\u30c3\u30af\u3092\u6700\u521d\u304b\u3089\u5b8c\u5168\u306b\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "Luna Pixel\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001ATLauncher\u306b\u5207\u308a\u66ff\u3048\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u524d\u306b\u30a4\u30f3\u30bf\u30fc\u30cd\u30c3\u30c8\u63a5\u7d9a\u3068\u30c7\u30a3\u30b9\u30af\u7a7a\u304d\u5bb9\u91cf\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "ProxySysOutSysErr\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u304b\uff1f\n\n\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u3088\u308a\u3001\u30e9\u30f3\u30c1\u30e3\u30fc\u304c\u30ed\u30b0\u3092\u63d0\u4f9b\u3057\u306a\u3044\u5834\u5408\u3067\u3082CrashDetector\u304cSystem.out\u3068System.err\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u308b\u3088\u3046\u306b\u306a\u308a\u307e\u3059\u3002\n\n\u624b\u52d5\u3067\u30ed\u30b0\u3092\u8cbc\u308a\u4ed8\u3051\u3089\u308c\u306a\u3044\u5834\u5408\u306b\u306e\u307f\u6709\u52b9\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\n\u8b66\u544a\uff1a\u4e00\u90e8\u306eMOD\u3084\u30e9\u30f3\u30c1\u30e3\u30fc\u3068\u5e72\u6e09\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\n\n\u5909\u66f4\u3092\u9069\u7528\u3059\u308b\u306b\u306f\u3001\u30b2\u30fc\u30e0\uff0f\u30a2\u30d7\u30ea\u306e\u518d\u8d77\u52d5\u304c\u5fc5\u8981\u3067\u3059\u3002";
    }

    @Override
    public String confirmacionTitulo() {
        return "\u78ba\u8a8d";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr\u304c\u6b63\u5e38\u306b\u6709\u52b9\u5316\u3055\u308c\u307e\u3057\u305f\u3002\n\n\u5909\u66f4\u3092\u9069\u7528\u3059\u308b\u306b\u306f\u3001CrashDetector\u3092\u518d\u8d77\u52d5\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
    }

    @Override
    public String informacionTitulo() {
        return "\u60c5\u5831";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("\u91cd\u5927\u30a8\u30e9\u30fc: AzureLib \u3068 GeckoLib \u304c\u65e9\u3059\u304e\u308b\u30bf\u30a4\u30df\u30f3\u30b0\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\uff01 ");
        } else if (azureLibError) {
            mensaje.append("\u91cd\u5927\u30a8\u30e9\u30fc: AzureLib \u304c\u65e9\u3059\u304e\u308b\u30bf\u30a4\u30df\u30f3\u30b0\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\uff01 ");
        } else if (geckoLibError) {
            mensaje.append("\u91cd\u5927\u30a8\u30e9\u30fc: GeckoLib \u304c\u65e9\u3059\u304e\u308b\u30bf\u30a4\u30df\u30f3\u30b0\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\uff01 ");
        }
        mensaje.append("\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001Fabric \u30e2\u30c3\u30c9\u3092\u975eFabric\u7248\u306e\u30e9\u30a4\u30d6\u30e9\u30ea\u3067\u4f7f\u7528\u3057\u3088\u3046\u3068\u3057\u305f\u3068\u304d\u306b\u767a\u751f\u3057\u307e\u3059\u3002 ");
        if (connectorPresente) {
            mensaje.append("\u4e92\u63db\u6027\u30e2\u30c3\u30c9\uff08Sinytra Connector \u307e\u305f\u306f specialcompatibilityoperation\uff09\u304c\u691c\u51fa\u3055\u308c\u3001Forge \u3084 FeatureCreep \u74b0\u5883\u3067 Fabric \u30e2\u30c3\u30c9\u3092\u5b9f\u884c\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u308b\u3053\u3068\u304c\u793a\u3055\u308c\u3066\u3044\u307e\u3059\u3002 ");
            mensaje.append("\u30ed\u30b0\u306e 'FabricMC \u521d\u671f\u5316\u30a8\u30e9\u30fc' \u3092\u78ba\u8a8d\u3057\u3066\u3001\u554f\u984c\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u3044\u308b\u7279\u5b9a\u306e\u30e2\u30c3\u30c9\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 ");
        }
        mensaje.append("AzureLib \u3068 GeckoLib \u306f\u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3\u30e2\u30c3\u30c9\u306b\u4e0d\u53ef\u6b20\u3067\u3059\u304c\u3001\u6b63\u3057\u3044\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\uff08Fabric \u307e\u305f\u306f Forge\uff09\u3068\u4e00\u81f4\u3057\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002 ");
        mensaje.append("\u3053\u306e\u521d\u671f\u5316\u306e\u7af6\u5408\u306b\u3088\u308a\u3001\u30b2\u30fc\u30e0\u306f\u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3\u30e2\u30c3\u30c9\u3092\u6b63\u3057\u304f\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u521d\u671f\u5316\u304c\u65e9\u3059\u304e\u307e\u3059";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "\u30ed\u30b0\u3067 'FabricMC \u521d\u671f\u5316\u30a8\u30e9\u30fc' \u3092\u78ba\u8a8d\u3057\u3001\u554f\u984c\u306e\u3042\u308b\u30e2\u30c3\u30c9\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\uff08Forge \u307e\u305f\u306f Fabric\uff09\u306b\u5408\u3063\u305f\u6b63\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e AzureLib/GeckoLib \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u30a8\u30e9\u30fc: C2ME \u3068\u63a5\u7d9a\u30e2\u30c3\u30c9\u306e\u975e\u4e92\u63db\u6027\u3002 \u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001C2ME \u304c Sinytra Connector \u3084 specialcompatibilityoperation \u306a\u3069\u306e\u63a5\u7d9a\u30e2\u30c3\u30c9\u74b0\u5883\u3067\u5236\u9650\u3055\u308c\u3066\u3044\u308b Java \u306e\u5185\u90e8\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u305f\u305f\u3081\u306b\u767a\u751f\u3057\u307e\u3059\u3002 <b>C2ME \u306f\u3053\u308c\u3089\u306e\u74b0\u5883\u3068\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u304c\u3001<a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> \u304c\u63a8\u5968\u3055\u308c\u308b\u4ee3\u66ff\u624b\u6bb5</b>\u3067\u3042\u308a\u3001\u63a5\u7d9a\u30e2\u30c3\u30c9\u3068\u6b63\u5e38\u306b\u52d5\u4f5c\u3057\u307e\u3059\u3002 Java \u306e\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u6a29\u9650\u306e\u7af6\u5408\u306b\u3088\u308a\u3001\u30b2\u30fc\u30e0\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "C2ME \u3068\u63a5\u7d9a\u30e2\u30c3\u30c9\u306e\u975e\u4e92\u63db\u6027";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "mods \u30d5\u30a9\u30eb\u30c0\u304b\u3089 C2ME \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "\u4ee3\u308f\u308a\u306b <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> \u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3066\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\uff08Sinytra Connector \u306b\u5bfe\u5fdc\uff09";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "\u3059\u3079\u3066\u306e\u63a5\u7d9a\u30e2\u30c3\u30c9\uff08Sinytra Connector \u306a\u3069\uff09\u304c\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u5927\u306a\u30a8\u30e9\u30fc: \u30e2\u30c3\u30c9 '" + modId + "' \u306eJEI\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30af\u30e9\u30b9 '" + nombreClase + "' (\u30d7\u30e9\u30b0\u30a4\u30f3ID: '" + pluginId + "') \u304c\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u3001\u30b2\u30fc\u30e0\u8d77\u52d5\u4e2d\u306b\u30af\u30e9\u30c3\u30b7\u30e5\u3057\u3066\u3044\u307e\u3059\u3002 \u3053\u306e\u554f\u984c\u306f\u3001\u30b2\u30fc\u30e0\u306e\u521d\u671f\u5316\u3092\u59a8\u3052\u308b\u4e92\u63db\u6027\u306e\u306a\u3044\u307e\u305f\u306f\u7834\u640d\u3057\u305fJEI\u7d71\u5408\u3092\u6301\u3064\u30e2\u30c3\u30c9\u304c\u3042\u308b\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "JEI\u30d7\u30e9\u30b0\u30a4\u30f3\u5931\u6557 - \u30af\u30e9\u30c3\u30b7\u30e5\u3092\u5f15\u304d\u8d77\u3053\u3059";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "\u30e2\u30c3\u30c9 <b>" + modId + "</b> \u306b\u30af\u30e9\u30c3\u30b7\u30e5\u3092\u5f15\u304d\u8d77\u3053\u3059\u7834\u640d\u3057\u305fJEI\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002<b>Mod\u30c4\u30ea\u30fc</b> \u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u3001\u554f\u984c\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u3044\u308b\u30e2\u30c3\u30c9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "\u30af\u30e9\u30c3\u30b7\u30e5\u304c\u89e3\u6c7a\u3059\u308b\u304b\u78ba\u8a8d\u3059\u308b\u305f\u3081\u306b\u3001\u4e00\u6642\u7684\u306b mods \u30d5\u30a9\u30eb\u30c0\u304b\u3089\u30e2\u30c3\u30c9 <b>" + modId + "</b> \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "\u30e2\u30c3\u30c9 <b>" + modId + "</b> \u306e\u66f4\u65b0\u3092\u78ba\u8a8d\u3059\u308b\u304b\u3001\u958b\u767a\u8005\u306bJEI\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u554f\u984c\u3092\u5831\u544a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u305d\u306e\u9593\u306f\u3001\u30b2\u30fc\u30e0\u3092\u8d77\u52d5\u3059\u308b\u305f\u3081\u306b\u306f\u30e2\u30c3\u30c9\u3092\u524a\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059";
    }

    @Override
    public String tituloLectador() {
        return "\u30ed\u30b0\u30ea\u30fc\u30c0\u30fc - \u30af\u30e9\u30c3\u30b7\u30e5\u691c\u51fa\u5668";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "\u8272\u306e\u51e1\u4f8b";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "\u91cd\u5927\u306a\u30a8\u30e9\u30fc";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9";
    }

    @Override
    public String obtenerTituloError() {
        return "\u30a8\u30e9\u30fc";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "\u9078\u629e\u3057\u305f\u884c\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String obtenerNombreError() {
        return "\u30a8\u30e9\u30fc\u540d";
    }

    @Override
    public String obtenerDescripcionError() {
        return "\u8a73\u7d30\u306a\u8aac\u660e";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "\u30ed\u30b0\u3092\u9078\u629e";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "\u672a\u78ba\u8a8d\u306e\u30a8\u30e9\u30fc";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "\u30ed\u30b0\u306b\u91cd\u5927\u306a\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u6839\u672c\u539f\u56e0\u3092\u7279\u5b9a\u3059\u308b\u306b\u306f\u3001\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u3001\u8aad\u307f\u53d6\u308a\u6a29\u9650\u304c\u3042\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "\u30ed\u30b0\u5206\u6790\u30c4\u30fc\u30eb";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u91cd\u5927\u30a8\u30e9\u30fc: \u30e2\u30c3\u30c9 '").append(modId).append("' \u306e\u81ea\u52d5\u30a4\u30d9\u30f3\u30c8\u30b5\u30d6\u30b9\u30af\u30e9\u30a4\u30d0\u30fc\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 ");
        mensaje.append("\u554f\u984c\u306e\u3042\u308b\u30af\u30e9\u30b9: <b>").append(nombreClase).append("</b>\u3002 ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u3053\u306e\u30af\u30e9\u30b9\u306f\u4ee5\u4e0b\u306e\u5834\u6240\u306b\u3042\u308a\u307e\u3059: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u305d\u306e\u4ed6...");
            }
            mensaje.append("</b>\u3002 ");
        }
        mensaje.append("\u30e2\u30c3\u30c9\u304c\u30af\u30e9\u30b9\u3092\u81ea\u52d5\u7684\u306b\u30a4\u30d9\u30f3\u30c8\u8cfc\u8aad\u8005\u3068\u3057\u3066\u767b\u9332\u3057\u3088\u3046\u3068\u3057\u305f\u304c\u3001\u30af\u30e9\u30b9\u3092\u8aad\u307f\u8fbc\u3081\u306a\u304b\u3063\u305f\u5834\u5408\u306b\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059\u3002 ");
        mensaje.append("<b>\u30ed\u30b0\u5185\u306e\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3088\u308a\u524d\u306e\u4ed6\u306e\u30a8\u30e9\u30fc\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u6839\u672c\u539f\u56e0\u306f\u4ee5\u524d\u306e\u8aad\u307f\u8fbc\u307f\u5931\u6557\u3067\u3042\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059</b>\u3002");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "\u81ea\u52d5\u30b5\u30d6\u30b9\u30af\u30e9\u30a4\u30d0\u30fc\u767b\u9332\u5931\u6557";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "\u30e2\u30c3\u30c9 <b>" + modId + "</b> \u304c\u30af\u30e9\u30b9 <b>" + nombreClase + "</b> \u3092\u81ea\u52d5\u30b5\u30d6\u30b9\u30af\u30e9\u30a4\u30d0\u30fc\u3068\u3057\u3066\u767b\u9332\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u5931\u6557\u3057\u3066\u3044\u307e\u3059\u3002\u3053\u306e\u30af\u30e9\u30b9\u304c\u5b58\u5728\u3057\u3001\u30a2\u30af\u30bb\u30b9\u53ef\u80fd\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u554f\u984c\u306e\u3042\u308b\u30af\u30e9\u30b9 <b>" + nombreClase + "</b> \u306f\u3053\u308c\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u306b\u3042\u308a\u307e\u3059: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u305d\u306e\u4ed6...");
            }
            paso.append("</b>\u3002 ");
            paso.append("<b>Mod\u30c4\u30ea\u30fc</b> \u6a5f\u80fd\u3092\u4f7f\u3063\u3066\u3001\u554f\u984c\u306e\u3042\u308b\u30af\u30e9\u30b9\u3092\u542b\u3080\u6b63\u78ba\u306a\u30d5\u30a1\u30a4\u30eb\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
            return paso.toString();
        }
        return "\u30af\u30e9\u30b9 <b>" + nombreClase + "</b> \u304c\u3069\u306e\u30e2\u30c3\u30c9\u30d5\u30a1\u30a4\u30eb\u306b\u3082\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u30e2\u30c3\u30c9 <b>" + modId + "</b> \u304c\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002<b>Mod\u30c4\u30ea\u30fc</b> \u6a5f\u80fd\u3092\u4f7f\u3063\u3066\u554f\u984c\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "\u30e2\u30c3\u30c9 <b>" + modId + "</b> \u3092\u304a\u4f7f\u3044\u306eMinecraft\u304a\u3088\u3073Forge\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u554f\u984c\u304c\u7d9a\u304f\u5834\u5408\u306f\u3001\u958b\u767a\u8005\u306b\u554f\u984c\u306e\u30af\u30e9\u30b9\u3092\u542b\u3081\u3066\u30a8\u30e9\u30fc\u3092\u5831\u544a\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "<b>\u30ed\u30b0\u5185\u306e\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3088\u308a\u524d\u306e\u4ed6\u306e\u30a8\u30e9\u30fc</b>\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5b9f\u969b\u306e\u554f\u984c\u306f\u4ee5\u524d\u306e\u8aad\u307f\u8fbc\u307f\u5931\u6557\u306b\u3042\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u5834\u5408\u306b\u3088\u3063\u3066\u306f\u3001\u4ee5\u524d\u306e\u30a8\u30e9\u30fc\u304c\u30a4\u30d9\u30f3\u30c8\u767b\u9332\u306b\u5fc5\u8981\u306a\u30af\u30e9\u30b9\u306e\u8aad\u307f\u8fbc\u307f\u3092\u59a8\u3052\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059";
    }

    @Override
    public String limpiado() {
        return "\u30af\u30ea\u30a2\u6e08";
    }

    @Override
    public String original() {
        return "\u30aa\u30ea\u30b8\u30ca\u30eb";
    }

    @Override
    public String verEnConsola() {
        return "\u30ed\u30b0\u3067\u8868\u793a";
    }

    @Override
    public String advertencia() {
        return "\u8b66\u544a";
    }

    @Override
    public String fatal() {
        return "\u91cd\u5927";
    }

    @Override
    public String noRegistroDeBattly() {
        return "BattlyLauncher \u306b\u306f\u30b3\u30d4\u30fc\u53ef\u80fd\u306a\u30ed\u30b0\u3084\u30b3\u30f3\u30bd\u30fc\u30eb\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b2\u30fc\u30e0\u3092\u518d\u8d77\u52d5\u3057\u3066 ProxySysOutSysErr \u3092\u4f7f\u7528\u3057\u3001STDOUT \u3068 STDERR \u3092\u508d\u53d7\u3067\u304d\u307e\u3059\u304c\u3001STDOUT \u3084 STDERR \u3092\u5909\u66f4\u3059\u308bMOD\u3068\u885d\u7a81\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "\u30e9\u30f3\u30c1\u30e3\u30fc\u30ed\u30b0\u3092\u53d6\u5f97\u3059\u308b\u306b\u306f\u3001NightWorld \u306e\u8a2d\u5b9a\u3067\u30c7\u30d0\u30c3\u30b0\u30e2\u30fc\u30c9\u3092\u6709\u52b9\u306b\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u7279\u306b STDOUT \u3068 STDERR \u3092\u542b\u3080\u305f\u3081\u3001\u975e\u5e38\u306b\u91cd\u8981\u3067\u3059";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "\u30b5\u30fc\u30d0\u30fc\u306e\u7aef\u672b\u5185\u5bb9\u3092\u4fdd\u5b58\u307e\u305f\u306f\u8cbc\u308a\u4ed8\u3051\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u4ed6\u306e\u30ed\u30b0\u306b\u306a\u3044\u60c5\u5831\uff08STDOUT\u3001STDERR\u3001\u305d\u306e\u4ed6\u306e\u30a8\u30e9\u30fc\u306a\u3069\uff09\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u305f\u3081\u3067\u3059\u3002\u76f4\u8fd1\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u5185\u5bb9\u3092\u8cbc\u308a\u4ed8\u3051\u3066\u304f\u3060\u3055\u3044\u3002\u4eca\u5f8c\u306f\u3001\u8d77\u52d5\u30b3\u30de\u30f3\u30c9\u5f8c\u306b >> cd_launcherlog \u3092\u8ffd\u52a0\u3057\u3066\u3001\u7aef\u672b\u51fa\u529b\u3092 cd_launcherlog \u3068\u3044\u3046\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u3067\u304d\u307e\u3059\uff08\u753b\u50cf\u53c2\u7167\uff09\u3002\u3053\u308c\u306b\u3088\u308a\u7aef\u672b\u3078\u306e\u8868\u793a\u306f\u3055\u308c\u305a\u3001\u51fa\u529b\u306f\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307f\u8a18\u9332\u3055\u308c\u307e\u3059\u306e\u3067\u3054\u6ce8\u610f\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("\u91cd\u5927\u306a\u30a8\u30e9\u30fc: NeoForge\u74b0\u5883\u3067LexForge\u306e\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 ");
        sb.append("</b>");
        sb.append("\u5bfe\u8c61\u30af\u30e9\u30b9: <b>").append(claseReceptora).append("</b>\u3002 ");
        sb.append("\u5f71\u97ff\u3092\u53d7\u3051\u308b\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306f <b>").append(interfazObjetivo).append("</b> \u3067\u3001");
        sb.append("\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30e1\u30bd\u30c3\u30c9\u306f <b>").append(firmaMetodoFaltante).append("</b> \u3067\u3059\u3002 ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u3053\u306e\u30af\u30e9\u30b9\u306f\u4ee5\u4e0b\u306e\u5834\u6240\u306b\u3042\u308a\u307e\u3059: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u305d\u306e\u4ed6...");
            }
            sb.append("</b>\u3002 ");
        } else {
            sb.append("\u3053\u306e\u30af\u30e9\u30b9\u3092\u542b\u3080JAR\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u30b7\u30a7\u30a4\u30c7\u30a3\u30f3\u30b0\u3055\u308c\u3066\u3044\u308b\u304b\u3001jar-in-jar\u5f62\u5f0f\u3067\u57cb\u3081\u8fbc\u307e\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002 ");
        }
        sb.append("MinecraftForge/LexForge\u5411\u3051\u306b\u30b3\u30f3\u30d1\u30a4\u30eb\u3055\u308c\u305fModLauncher\u306e\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc/\u30b5\u30fc\u30d3\u30b9\u304c\u3001");
        sb.append("\u4e92\u63db\u6027\u306e\u306a\u3044ModLauncher API\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u3068\u3082\u306bNeoForge\u4e0a\u3067\u8aad\u307f\u8fbc\u307e\u308c\u308b\u3068\u3001\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059\u3002 ");
        sb.append("NeoForge\u7528\u306e\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306b\u66f4\u65b0\u307e\u305f\u306f\u7f6e\u304d\u63db\u3048\u3066\u304f\u3060\u3055\u3044\u3002");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "NeoForge\u3067\u4f7f\u7528\u3055\u308c\u305fLexForge\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "\u975e\u4e92\u63db\u306e\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044: <b>" + claseReceptora + "</b>\u3002 \u671f\u5f85\u3055\u308c\u308bAPI\u306f <b>" + interfazObjetivo + "</b> \u3067\u3001\u6b20\u843d\u3057\u3066\u3044\u308b\u30e1\u30bd\u30c3\u30c9\u306f <b>" + firmaMetodoFaltante + "</b> \u3067\u3059\u3002 MOD\u304c <b>META-INF/services</b> \u306b\u3053\u306e\u30af\u30e9\u30b9\u3092\u767b\u9332\u3057\u3066\u3044\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3001NeoForge\u3067\u524a\u9664\u307e\u305f\u306f\u7121\u52b9\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u95a2\u4fc2\u3059\u308bMOD\u306e\u5834\u6240: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u305d\u306e\u4ed6...");
            }
            sb.append("</b>\u3002 ");
        } else {
            sb.append("\u30af\u30e9\u30b9\u3092\u542b\u3080JAR\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002jar-in-jar\u3084\u30b7\u30a7\u30a4\u30c9\u3055\u308c\u305f\u4f9d\u5b58\u95a2\u4fc2\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002 ");
        }
        sb.append("\u4e00\u6642\u7684\u306b\u3053\u308c\u3089\u306eJAR\u3092\u524a\u9664\u3059\u308b\u304b\u3001NeoForge\u5bfe\u5fdc\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u539f\u56e0\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u3092NeoForge\u5c02\u7528\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u7f6e\u304d\u63db\u3048\u308b\u304b\u3001NeoForge\u304c\u4f7f\u7528\u3059\u308bModLauncher\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5bfe\u3057\u3066\u518d\u30b3\u30f3\u30d1\u30a4\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u53e4\u3044LexForge/MinecraftForge\u306e\u30d0\u30a4\u30ca\u30ea\u306f\u907f\u3051\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "mods\u30d5\u30a9\u30eb\u30c0\u3092\u30af\u30ea\u30fc\u30f3\u30a2\u30c3\u30d7\u3057\u3001\u91cd\u8907\u3057\u305fjar-in-jar\u30a8\u30f3\u30c8\u30ea\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5fc5\u8981\u3067\u3042\u308c\u3070\u30e9\u30f3\u30c1\u30e3\u30fc\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u6d88\u53bb\u3057\u3001\u518d\u8d77\u52d5\u3057\u3066LexForge\u306e\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u304c\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u306a\u3044\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\uff1aXenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("\u306f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002</b> ");
        sb.append("Xenon\u3092\u524a\u9664\u3057\u3001\u4ee3\u308f\u308a\u306bEmbeddium\u307e\u305f\u306fSodium\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002 ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u691c\u51fa\u5834\u6240\uff1a<b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u305d\u306e\u4ed6...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia\u3068Xenon\u306e\u4e92\u63db\u6027\u30a8\u30e9\u30fc";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return label + " \u304cWaterMedia\u3068\u4e92\u63db\u6027\u304c\u306a\u3044\u3053\u3068\u304c\u5224\u660e\u3057\u307e\u3057\u305f\u3002\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("\u5834\u6240\uff1a<b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u305d\u306e\u4ed6...");
            }
            sb.append("</b>\u3002\u305d\u306eJAR\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return sb.toString();
        }
        return "JAR\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002mods\u30d5\u30a9\u30eb\u30c0\u3092\u78ba\u8a8d\u3057\u3001Xenon\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "Embeddium\u307e\u305f\u306fSodium\u3092\u4ee3\u66ff\u3068\u3057\u3066\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3001\u30b2\u30fc\u30e0\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "\u5727\u7e2e\u30a8\u30e9\u30fc (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>TACZ\u30ea\u30bd\u30fc\u30b9\u306e\u30b3\u30d4\u30fc\u4e2d\u306bDeflater\u304c\u9589\u3058\u3089\u308c\u307e\u3057\u305f\u3002</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u95a2\u9023\u3059\u308b\u3082\u306e: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u305d\u306e\u4ed6");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>\u89e3\u6c7a\u7b56:</b> <code>tacz/tacz-pre.toml</code> \u3067 <code>DefaultPackDebug=true</code> \u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002").append("\u5fc5\u8981\u306b\u5fdc\u3058\u3066\u3001\u307e\u305a\u30de\u30c3\u30d7\u3092\u751f\u6210\u3057\u3066\u304b\u3089\u6709\u52b9\u5316\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "tacz/tacz-pre.toml \u3067 DefaultPackDebug=true \u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5fc5\u8981\u3067\u3042\u308c\u3070\u3001\u307e\u305a\u30de\u30c3\u30d7\u3092\u751f\u6210\u3057\u3066\u304b\u3089\u6709\u52b9\u5316\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "\u30d0\u30a4\u30f3\u30c9\u3055\u308c\u3066\u3044\u306a\u3044\u5bc6\u5ea6\u95a2\u6570";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>\u30ec\u30b8\u30b9\u30c8\u30ea\u306b\u5bc6\u5ea6\u95a2\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("\u4e0d\u8db3\u3057\u3066\u3044\u308b\u3082\u306e: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append("\u3002");
        }
        sb.append("<br/><b>\u89e3\u6c7a\u65b9\u6cd5:</b> \u3053\u308c\u3089\u306e\u95a2\u6570\u3092\u5b9a\u7fa9\u3059\u308b mod/datapack \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u307e\u305f\u306f\u6709\u52b9\u306b\u3057\u3066\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u306e\u554f\u984c\u306e\u3082\u3046\u4e00\u3064\u306e\u3088\u304f\u3042\u308b\u539f\u56e0\u306f\u3001\u5fc5\u8981\u306a mod \u306f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3082\u306e\u306e\u3001\u305d\u306e mod \u306b\u554f\u984c\u304c\u3042\u308b\u304b\u3001\u4ed6\u306e mod \u3068\u7af6\u5408\u3057\u3066\u3044\u308b\u5834\u5408\u3067\u3059\u3002\u4f8b\u3048\u3070\u3001Terralith \u306f\u591a\u304f\u306e\u554f\u984c\u3092\u62b1\u3048\u3066\u304a\u308a\u3001\u3053\u306e\u30a8\u30e9\u30fc\u3084 JSON \u30a8\u30e9\u30fc\u3092\u542b\u3080\u3055\u307e\u3056\u307e\u306a\u554f\u984c\u3092\u5f15\u304d\u8d77\u3053\u3059\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "\u3053\u308c\u3089\u306e\u95a2\u6570\u3092\u63d0\u4f9b\u3059\u308bMOD/\u30c7\u30fc\u30bf\u30d1\u30c3\u30af\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u307e\u305f\u306f\u6709\u52b9\u5316\u3057\u3001\u30b2\u30fc\u30e0\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u30ec\u30b8\u30b9\u30c8\u30ea\u30a8\u30f3\u30c8\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093: ").append(claveFaltante).append(". ");
        sb.append("Create 6 \u5411\u3051\u306e Steam & Railways \u30a2\u30eb\u30d5\u30a1\u7248\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\u3002");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (\u30a2\u30eb\u30d5\u30a1)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "Create 6 \u5411\u3051\u306e Steam & Railways \u30a2\u30eb\u30d5\u30a1\u7248\u3092\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u7f6e\u304d\u63db\u3048\u308b\u304b\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u8aad\u307f\u8fbc\u307f\u885d\u7a81: Multiworld \u3068 Sodium/Embeddium/Rubidium \u3092\u4f75\u7528\u3059\u308b\u3068 ").append("IncompatibleClassChangeError (FabricLoader.getInstance) \u304c\u767a\u751f\u3057\u307e\u3059\u3002 ").append("\u63d0\u6848: Multiworld \u307e\u305f\u306f\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9MOD\u3092\u524a\u9664\u3059\u308b\u304b\u3001\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "\u885d\u7a81: Multiworld \u3068\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9MOD";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "Multiworld \u307e\u305f\u306f Sodium/Embeddium/Rubidium \u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u304b\u3001\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium\u304c\u4e92\u63db\u6027\u306e\u306a\u3044\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30c9\u30e9\u30a4\u30d0\u30fc\u3092\u691c\u51fa\u3057\u307e\u3057\u305f\u3002 GPU\u30c9\u30e9\u30a4\u30d0\u30fc\u3092\u6700\u4f4e\u8981\u4ef6\u307e\u3067\u66f4\u65b0\u3059\u308b\u304b\u3001Sodium\u306e\u30ac\u30a4\u30c9\u306b\u5f93\u3063\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "OpenGL\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u30a8\u30e9\u30fc";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenGL\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff1a\u73fe\u5728\u306e\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u304c\u3042\u308a\u307e\u305b\u3093\u3001\u307e\u305f\u306f\u3053\u306e\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u3067\u306f\u6a5f\u80fd\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002 \u30d3\u30c7\u30aa\u30c9\u30e9\u30a4\u30d0\u30fc\u306e\u554f\u984c\u3067\u3042\u308b\u53ef\u80fd\u6027\u3082\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "GPU\u30c9\u30e9\u30a4\u30d0\u30fc\u3092\u66f4\u65b0\u30fb\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u30aa\u30fc\u30d0\u30fc\u30ec\u30a4\u3092\u7121\u52b9\u306b\u3057\u3001\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9MOD\u306a\u3057\u3067\u8a66\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "\u30ea\u30f3\u30af\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f\u3002";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "\u5727\u7e2e\u30d5\u30a1\u30a4\u30eb\u5185\u3092\u691c\u7d22\uff08.zip/.jar/.war/.ear/.fpm/.rar\uff08Java \u7528\uff09*\uff09";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30c6\u30af\u30b9\u30c1\u30e3\u89e3\u50cf\u5ea6\u30a8\u30e9\u30fc: \u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093 " + recurso + " - \u30b5\u30a4\u30ba: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "\u30c6\u30af\u30b9\u30c1\u30e3\u89e3\u50cf\u5ea6\u30a8\u30e9\u30fc";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u5927\u304d\u3059\u304e\u308b\u304b\u3001\u30ea\u30bd\u30fc\u30b9\u30d1\u30c3\u30af\u304c\u591a\u3059\u304e\u308b\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002\u89e3\u50cf\u5ea6\u306e\u4f4e\u3044\u30ea\u30bd\u30fc\u30b9\u30d1\u30c3\u30af\u3092\u4f7f\u7528\u3059\u308b\u304b\u3001\u3044\u304f\u3064\u304b\u306e\u30ea\u30bd\u30fc\u30b9\u30d1\u30c3\u30af\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u8a31\u53ef\u3055\u308c\u305f\u89e3\u50cf\u5ea6\u3092\u8d85\u3048\u308b\u30ab\u30b9\u30bf\u30e0\u30c6\u30af\u30b9\u30c1\u30e3\u3092\u8ffd\u52a0\u3057\u3066\u3044\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModLauncher \u30b5\u30fc\u30d3\u30b9\u30a8\u30e9\u30fc\uff1a\u30d1\u30b9\u306b\u7121\u52b9\u306a\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002 ModLauncher \u30b5\u30fc\u30d3\u30b9\u306f\u3001ASCII\u4ee5\u5916\u3084\u7279\u6b8a\u6587\u5b57\u3092\u542b\u3080\u30d1\u30b9\u3092\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002 \u554f\u984c\u306e\u3042\u308b\u6587\u5b57\u306b\u306f \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694 \u304c\u3042\u308a\u3001\u7279\u306b\u540d\u524d\u306e\u672b\u5c3e\u306b\u3042\u308b '\"' \u6587\u5b57\u306f\u6df1\u523b\u3067\u3059\u3002 \u4e00\u822c\u7684\u306a ModLauncher \u30b5\u30fc\u30d3\u30b9\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306b\u306f\u3001CrashDetector\u3001" + Config.obtenerInstancia().obtenerNombreCD() + "\u3001FeatureCreep\u3001Vivicraft\u3001Optifine\u3001Sodium\u3001clonos\u3001Iris Shaders/Oculus\u3001MixerLogger\u3001CrashAssistant\u3001Sintrya Connector \u306a\u3069\u304c\u3042\u308a\u307e\u3059\u3002 \u3059\u3079\u3066\u306e\u30b5\u30fc\u30d3\u30b9\u3092\u524a\u9664\u3067\u304d\u307e\u3059\u304c\u3001\u30d1\u30b9\u540d\u81ea\u4f53\u304c\u539f\u56e0\u3067\u4ed6\u306e\u554f\u984c\u304c\u767a\u751f\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u89e3\u6c7a\u7b56\uff1a\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u540d\u3092 ASCII \u6587\u5b57\uff08a-z, A-Z, 0-9\uff09\u306e\u307f\u3092\u4f7f\u7528\u3059\u308b\u3088\u3046\u306b\u5909\u66f4\u3057\u3001\u30b9\u30da\u30fc\u30b9\u3084\u7279\u6b8a\u6587\u5b57\u306f\u907f\u3051\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "ModLauncher \u30d1\u30b9\u30a8\u30e9\u30fc";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u30d1\u30b9\u306bASCII\u4ee5\u5916\u306e\u6587\u5b57\u3084\u7279\u6b8a\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002 ModLauncher\u306e\u30b5\u30fc\u30d3\u30b9\u306f\u3053\u308c\u3089\u306e\u30d1\u30b9\u3092\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002 \u89e3\u6c7a\u7b56\uff1a\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u540d\u3092ASCII\u6587\u5b57\uff08a-z, A-Z, 0-9\uff09\u306e\u307f\u306b\u5909\u66f4\u3057\u3001\u30b9\u30da\u30fc\u30b9\u3084\u7279\u6b8a\u6587\u5b57\u3092\u907f\u3051\u3066\u304f\u3060\u3055\u3044\u3002 \u7279\u306b\u540d\u524d\u306e\u672b\u5c3e\u306b\u3042\u308b '\"' \u6587\u5b57\u306f\u975e\u5e38\u306b\u554f\u984c\u3068\u306a\u308b\u305f\u3081\u3001\u6ce8\u610f\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String tituloEditorCodice() {
        return "Codice\u30a8\u30c7\u30a3\u30bf\u30fc";
    }

    @Override
    public String nuevo() {
        return "\u65b0\u898f";
    }

    @Override
    public String actualizarSeleccionado() {
        return "\u9078\u629e\u9805\u76ee\u3092\u66f4\u65b0";
    }

    @Override
    public String eliminarSeleccionado() {
        return "\u9078\u629e\u9805\u76ee\u3092\u524a\u9664";
    }

    @Override
    public String exportarJSON() {
        return "JSON\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8...";
    }

    @Override
    public String guardarTodo() {
        return "\u3059\u3079\u3066\u4fdd\u5b58";
    }

    @Override
    public String general() {
        return "\u4e00\u822c";
    }

    @Override
    public String id() {
        return "ID";
    }

    @Override
    public String paraBuscar() {
        return "\u691c\u7d22\u30c6\u30ad\u30b9\u30c8";
    }

    @Override
    public String filtro() {
        return "\u30d5\u30a3\u30eb\u30bf\u30fc (ID)";
    }

    @Override
    public String criticalidad() {
        return "\u91cd\u8981\u5ea6 (\u8b66\u544a/\u30a8\u30e9\u30fc/\u81f4\u547d\u7684)";
    }

    @Override
    public String prioridad() {
        return "\u512a\u5148\u5ea6";
    }

    @Override
    public String lista() {
        return "\u30c1\u30a7\u30c3\u30af\u9805\u76ee";
    }

    @Override
    public String colIdioma() {
        return "\u8a00\u8a9e";
    }

    @Override
    public String colNombre() {
        return "\u540d\u524d";
    }

    @Override
    public String colResultado() {
        return "\u7d50\u679c";
    }

    @Override
    public String vistaJson() {
        return "JSON\u30d7\u30ec\u30d3\u30e5\u30fc";
    }

    @Override
    public String idiomas() {
        return "\u8a00\u8a9e (\u3059\u3079\u3066\u5fc5\u9808)";
    }

    @Override
    public String elegirFiltro() {
        return "\u9078\u629e...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "\u30d5\u30a3\u30eb\u30bf\u30fc\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "\u5229\u7528\u53ef\u80fd\u306a\u30d5\u30a3\u30eb\u30bf\u30fc";
    }

    @Override
    public String faltanCampos() {
        return "\u3059\u3079\u3066\u306e\u5fc5\u9808\u4e00\u822c\u9805\u76ee\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String critInvalida() {
        return "\u7121\u52b9\u306a\u91cd\u8981\u5ea6\u3067\u3059\u3002\u8b66\u544a\u3001\u30a8\u30e9\u30fc\u3001\u307e\u305f\u306f\u81f4\u547d\u7684\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String filtroNoExiste() {
        return "\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a3\u30eb\u30bf\u30fc\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
    }

    @Override
    public String faltanIdiomas() {
        return "\u3059\u3079\u3066\u306e\u8a00\u8a9e\u306b\u3064\u3044\u3066\u540d\u524d\u3068\u7d50\u679c\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff1a";
    }

    @Override
    public String verificacionInvalida() {
        return "\u30c1\u30a7\u30c3\u30af\u9805\u76ee\u304c\u7121\u52b9\u3067\u3059\u3002\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String guardadoOk() {
        return "\u6b63\u5e38\u306b\u4fdd\u5b58\u3055\u308c\u307e\u3057\u305f\u3002";
    }

    @Override
    public String editorCodiceBoton() {
        return "\u7406\u7531\u3092\u8ffd\u52a0";
    }

    @Override
    public String descripcionEditorCodice() {
        return "\u3053\u3053\u306b\u7406\u7531\u3092\u767b\u9332\u3067\u304d\u307e\u3059\u3002ID\u304c\u5fc5\u8981\u3067\u3001\u3053\u308c\u306f\u7279\u6b8a\u6587\u5b57\u30fb\u30a2\u30af\u30bb\u30f3\u30c8\u8a18\u53f7\u30fb\u30b9\u30da\u30fc\u30b9\u3092\u542b\u307e\u306a\u3044\u6587\u5b57\u5217\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u30d5\u30a3\u30eb\u30bf\u30fc\u306b\u306f\u3001\u300c\u884c\u306b\u542b\u307e\u308c\u308b\u300d\u3067\u7279\u5b9a\u306e\u6587\u5b57\u5217\u30921\u884c\u5185\u304b\u3089\u691c\u7d22\u3001\u300c\u5168\u4f53\u306b\u542b\u307e\u308c\u308b\u300d\u3067\u30ed\u30b0\u5168\u4f53\u306b\u6587\u5b57\u5217\u304c\u3042\u308b\u304b\u78ba\u8a8d\u3001\u300c\u884c\u6b63\u898f\u8868\u73fe\u300d\u30671\u884c\u304c\u6b63\u898f\u8868\u73fe\u306b\u4e00\u81f4\u3059\u308b\u304b\u30c1\u30a7\u30c3\u30af\u3001\u300c\u5168\u4f53\u6b63\u898f\u8868\u73fe\u300d\u3067\u30ed\u30b0\u5168\u4f53\u3092\u6b63\u898f\u8868\u73fe\u3067\u691c\u7d22\uff08\u884c\u5358\u4f4d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u4f7f\u7528\u3092\u63a8\u5968\uff09\u3067\u304d\u307e\u3059\u3002\u8272\u5206\u3051\u306e\u305f\u3081\u306b\u3001\u91cd\u5927\u5ea6\u3068\u3057\u3066FATAL\uff08\u81f4\u547d\u7684\uff09\u3001ERROR\uff08\u30a8\u30e9\u30fc\uff09\u3001ADVERTENCIA\uff08\u8b66\u544a\uff09\u306e\u3044\u305a\u308c\u304b\u3092\u8a2d\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u3059\u3079\u3066\u306e\u8a00\u8a9e\u306b\u3064\u3044\u3066\u3001\u753b\u9762\u306b\u8868\u793a\u3055\u308c\u308b\u540d\u524d\u3068\u7d50\u679c\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4ed6\u306e\u691c\u67fb\u9805\u76ee\u3092\u8ffd\u52a0\u307e\u305f\u306f\u524a\u9664\u3067\u304d\u307e\u3059\u3002\u5b8c\u4e86\u6642\u306b\u4fdd\u5b58\u3055\u308c\u307e\u3059\u3002";
    }

    @Override
    public String descartarCambios() {
        return "\u73fe\u5728\u306e\u30c1\u30a7\u30c3\u30af\u3067\u4fdd\u5b58\u3055\u308c\u3066\u3044\u306a\u3044\u5909\u66f4\u3092\u7834\u68c4\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    public String confirmacion() {
        return "\u78ba\u8a8d";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\u7d42\u4e86\u3059\u308b\u524d\u306b\u5909\u66f4\u3092\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    public String salirSinGuardar() {
        return "\u4fdd\u5b58\u305b\u305a\u306b\u7d42\u4e86";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u91cd\u5927\u306a\u30a8\u30e9\u30fc: modlauncher \u30b5\u30fc\u30d3\u30b9 (IDependencyLocator) \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br>");
        sb.append("\ud83d\udd39 <b>\u554f\u984c\u306e\u3042\u308b\u30af\u30e9\u30b9:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>\u5f71\u97ff\u3092\u53d7\u3051\u308bMOD:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>MOD\u304c\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002</b> \u6700\u8fd1\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u305fMOD\u3001\u958b\u767a\u7248MOD\u3001\u307e\u305f\u306f\u4e0d\u9069\u5207\u306b\u30d1\u30c3\u30b1\u30fc\u30b8\u3055\u308c\u305fMOD\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>");
        }
        sb.append("\ud83d\udd38 <b>\u539f\u56e0:</b> MOD\u306e <code>META-INF/services/...</code> \u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u304b\u3001");
        sb.append("\u73fe\u5728\u306eForge/NeoForge\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u304c\u306a\u3044\u304b\u3001\u9593\u9055\u3063\u305f\u30d0\u30fc\u30b8\u30e7\u30f3\u7528\u306eMOD\u3067\u3059\u3002<br>");
        sb.append("\ud83d\udd38 <b>\u7d50\u679c:</b> Forge/NeoForge\u304cMOD\u306e\u4f9d\u5b58\u95a2\u4fc2\u3092\u767b\u9332\u3067\u304d\u305a\u3001");
        sb.append("\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u304c\u59a8\u3052\u3089\u308c\u307e\u3059\u3002<br>");
        sb.append("\ud83d\udd38 <b>\u89e3\u6c7a\u7b56:</b> \u554f\u984c\u306e\u3042\u308bMOD\u3092\u66f4\u65b0\u3001\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3001\u307e\u305f\u306f\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        sb.append("\u958b\u767a\u7248MOD\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u6b63\u78ba\u306aForge/NeoForge\u30d0\u30fc\u30b8\u30e7\u30f3\u5411\u3051\u306b\u30b3\u30f3\u30d1\u30a4\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "\u30b5\u30fc\u30d3\u30b9\u69cb\u6210\u30a8\u30e9\u30fc (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. \u539f\u56e0\u3068\u306a\u308bMOD\u3092\u7279\u5b9a\u3057\u307e\u3059\uff1a\u6700\u8fd1\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u305fMOD\u3084\u958b\u767a\u7248MOD\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        }
        return "1. \u554f\u984c\u306e\u3042\u308bMOD\u306f\uff1a " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. MOD\u3092\u66f4\u65b0\u3001\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3001\u307e\u305f\u306f\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002Forge/NeoForge\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u91cd\u5927\u306a\u30a8\u30e9\u30fc\uff1a\u30e1\u30bd\u30c3\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002</b><br>MOD\u304c\u30e1\u30bd\u30c3\u30c9 <b style='color:#" + colorCodigo + "'>" + metodo + "</b> \u3092\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u307e\u3057\u305f\u304c\u3001\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u73fe\u5728\u306e\u30b2\u30fc\u30e0\u30d0\u30fc\u30b8\u30e7\u30f3\u307e\u305f\u306f\u4ed6\u306eMOD\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "\u30e1\u30bd\u30c3\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093 (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. \u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001MOD\u304c\u73fe\u5728\u306e\u30b2\u30fc\u30e0\u30d0\u30fc\u30b8\u30e7\u30f3\u307e\u305f\u306f\u4ed6\u306eMOD\u3068\u4e92\u63db\u6027\u304c\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. \u95a2\u4fc2\u3059\u308b\u3059\u3079\u3066\u306eMOD\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u554f\u984c\u304c\u7d9a\u304f\u5834\u5408\u306f\u3001\u5f71\u97ff\u3092\u53d7\u3051\u305fMOD\u306e\u4f5c\u8005\u306b\u5831\u544a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u91cd\u5927\u306a\u30a8\u30e9\u30fc\uff1a\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002</b><br>MOD\u304c\u30d5\u30a3\u30fc\u30eb\u30c9 <b style='color:#" + colorCodigo + "'>" + campo + "</b> \u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u305f\u304c\u3001\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u73fe\u5728\u306e\u30b2\u30fc\u30e0\u30d0\u30fc\u30b8\u30e7\u30f3\u307e\u305f\u306f\u4ed6\u306eMOD\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093 (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. \u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001MOD\u304c\u73fe\u5728\u306e\u30b2\u30fc\u30e0\u30d0\u30fc\u30b8\u30e7\u30f3\u307e\u305f\u306f\u4ed6\u306eMOD\u3068\u4e92\u63db\u6027\u304c\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. \u5f71\u97ff\u3092\u53d7\u3051\u308b\u3059\u3079\u3066\u306eMOD\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u554f\u984c\u304c\u89e3\u6c7a\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u305fMOD\u306e\u4f5c\u8005\u306b\u9023\u7d61\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\u52a9\u3051\u304c\u5fc5\u8981\u3067\u3059\u304b\uff1f</strong><br>  \u4fee\u6b63\u65b9\u6cd5\u304c\u308f\u304b\u3089\u306a\u3044\u5834\u5408\u3084\u3001\u3053\u3053\u306b\u7406\u7531\u304c\u8f09\u3063\u3066\u3044\u306a\u3044\u5834\u5408\u306f\u3001\u30bd\u30fc\u30b7\u30e3\u30eb\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3067\u30b5\u30dd\u30fc\u30c8\u3092\u53d7\u3051\u3089\u308c\u307e\u3059\u3002  \u30dc\u30bf\u30f3 <img src='" + iconoCompartir + "' alt='\u5171\u6709' style='height:12px;vertical-align:middle;'/>   <strong>\u5171\u6709</strong> \u3092\u4f7f\u3063\u3066\u3001\u30ed\u30b0\u3068\u89e3\u6790\u7d50\u679c\u306e\u30ea\u30f3\u30af\u3092\u30c1\u30fc\u30e0\u306b\u9001\u4fe1\u3067\u304d\u307e\u3059\u3002  Modpack\u4f5c\u6210\u8005\u307e\u305f\u306f\u4f01\u696d\u306e\u65b9\u306f\u3001<code>crash_detector/plantilla.htm</code> \u3092\u7de8\u96c6\u3057\u3066\u3001  \u30c1\u30fc\u30e0\u5c02\u7528\u306e\u30ea\u30f3\u30af\u3092\u30ab\u30b9\u30bf\u30de\u30a4\u30ba\u3057\u3066\u304f\u3060\u3055\u3044\u3002</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u30ea\u30bb\u30c3\u30c8";
    }

    @Override
    public String restablecer() {
        return "\u30ea\u30bb\u30c3\u30c8";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return nombreImagen + " \u3092\u65e2\u5b9a\u5024\u306b\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u65e2\u5b9a\u5024\u306b\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>AzureLib\u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u3059\u3067\u306bAzureLib\u3092\u5c0e\u5165\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u30012025\u5e7410\u67088\u65e5\u4ee5\u524d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u308c\u306f\u3088\u304f\u3042\u308b\u554f\u984c\u3067\u3059\u3002AzureLib\u3092\u5c0e\u5165\u3057\u3066\u3044\u306a\u3044\u5834\u5408\u306f\u3001\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>MOD <code>healight</code> \u304c\u91cd\u5927\u306a\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u3044\u307e\u3059: <code>java.lang.NoSuchFieldError: INT</code>\u3002 \u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001MOD\u304cMCForge 47.10\u306eMinecraft 1.20+\u3067\u306f\u5b58\u5728\u3057\u306a\u304f\u306a\u3063\u305f\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3088\u3046\u3068\u3057\u305f\u305f\u3081\u306b\u767a\u751f\u3057\u307e\u3059\u3002 \u3053\u306e\u554f\u984c\u306e\u305f\u3081\u3001\u30b2\u30fc\u30e0\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 MOD <code>healight</code> \u3092\u524a\u9664\u307e\u305f\u306f\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u73fe\u5728\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306f1.20.1\u7528\u306eMinecraftForge 47.10\u3068\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002 MOD\u306e\u6700\u65b0\u7248\u3092\u63a2\u3059\u304b\u3001\u4ee3\u66ff\u6848\u306e\u4f7f\u7528\u3092\u691c\u8a0e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "\u91cd\u5927\u306a\u30a8\u30e9\u30fc\uff1ahealight - \u30d5\u30a3\u30fc\u30eb\u30c9 'INT' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("\u30af\u30e9\u30b9 <code>").append(clase).append("</code> \u304c\u5fc5\u9808\u30e1\u30bd\u30c3\u30c9\u3092\u5b9f\u88c5\u3057\u3066\u3044\u307e\u305b\u3093\uff1a<br>").append("<code>").append(metodo).append("</code><br>").append("\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9 <code>").append(interfaz).append("</code> \u304b\u3089\u3002");
        if (!origen.isEmpty()) {
            sb.append("<br><br>\u554f\u984c\u306e\u3042\u308bMOD\u307e\u305f\u306f\u30d5\u30a1\u30a4\u30eb: <code>").append(origen).append("</code>\u3002");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 \u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001MOD\u304c\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3092\u5b9f\u88c5\u3057\u3066\u3044\u308b\u304c\u5fc5\u9808\u30e1\u30bd\u30c3\u30c9\u3092\u7701\u7565\u3057\u305f\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002<b>\u4e21\u65b9\u306eMOD</b> \u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3092\u5b9a\u7fa9\u3057\u3066\u3044\u308b\u3082\u306e\u3068\u305d\u308c\u3092\u5b9f\u88c5\u3057\u3066\u3044\u308b\u3082\u306e\uff09\u3002\u3069\u308c\u304b\u308f\u304b\u3089\u306a\u3044\u5834\u5408\u306f\u3001\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u540d\u524d\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u30e1\u30bd\u30c3\u30c9\u304c\u672a\u5b9f\u88c5 (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>MOD\u304c<b>\u5c02\u7528\u30b5\u30fc\u30d0\u30fc</b>\u4e0a\u3067<b>\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u5074</b>\u306e\u30af\u30e9\u30b9 (<code>AnimationMetadataSection</code>)\u3092\u8aad\u307f\u8fbc\u3082\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u308c\u306f\u4e0d\u53ef\u80fd\u3067\u3059\u3002 \u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001MOD\u304c\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3068\u30b5\u30fc\u30d0\u30fc\u306e\u30b3\u30fc\u30c9\u3092\u6b63\u3057\u304f\u5206\u96e2\u3057\u3066\u3044\u306a\u3044\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\u3002 <code>ModernFix</code> \u306e\u5b58\u5728\u304c\u3053\u306e\u554f\u984c\u3092\u8868\u9762\u5316\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u304c\u3001\u76f4\u63a5\u306e\u539f\u56e0\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>\u5373\u6642\u5bfe\u5fdc\uff1a</b><code>ModernFix</code> \u3092\u4e00\u6642\u7684\u306b\u524a\u9664\u3057\u3066\u30b5\u30fc\u30d0\u30fc\u304c\u8d77\u52d5\u3059\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u8d77\u52d5\u3067\u304d\u305f\u5834\u5408\u3001\u5225\u306eMOD\u304c\u30b5\u30fc\u30d0\u30fc\u4e0a\u3067\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30af\u30e9\u30b9\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u308b\u3053\u3068\u304c\u539f\u56e0\u3067\u3059\u3002<br>\u2022 <b>\u6839\u672c\u7684\u306a\u89e3\u6c7a\u7b56\uff1a</b>\u554f\u984c\u306e\u3042\u308bMOD\uff08\u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3\u30ea\u30bd\u30fc\u30b9\u3001\u30ab\u30b9\u30bf\u30e0\u30c6\u30af\u30b9\u30c1\u30e3\u3001\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f7f\u7528\u3057\u3066\u3044\u308bMOD\u306a\u3069\uff09\u3092\u7279\u5b9a\u3057\u3001\u66f4\u65b0\u307e\u305f\u306f\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "\u30b5\u30fc\u30d0\u30fc\u3067\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u5074\u306e\u30af\u30e9\u30b9\u304c\u8aad\u307f\u8fbc\u307e\u308c\u305f (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'><code>Sinytra Connector</code> \u306eMOD\u306e\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\u3002 \u3053\u308c\u306f\u3001\u30b2\u30fc\u30e0\u306e\u4e88\u671f\u3057\u306a\u3044\u7d42\u4e86\u3001\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u3001\u307e\u305f\u306fMOD\u9593\u306e\u7af6\u5408\u306b\u3088\u308a\u3001\u30d5\u30a1\u30a4\u30eb\u306b\u30cc\u30eb\u6587\u5b57 (<code>\\u0000</code>) \u304c\u8a70\u307e\u3063\u3066\u3057\u307e\u3046\u3053\u3068\u304c\u539f\u56e0\u3067\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 Minecraft\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e <code>config/</code> \u30d5\u30a9\u30eb\u30c0\u3078\u79fb\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 connector\u95a2\u9023\u306eMOD\u306e\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22\u3057\u3001\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u30b2\u30fc\u30e0\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\uff1aSinytra Connector\u304c\u65b0\u3057\u3044\u30af\u30ea\u30fc\u30f3\u306a\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3057\u307e\u3059\u3002";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "Sinytra Connector \u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u7834\u640d";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u30d5\u30a1\u30a4\u30eb <code>" + nombreJar + "</code> \u304c\u7834\u640d\u3057\u3066\u3044\u308b\u304b\u4e0d\u5b8c\u5168\u3067\u3059\u3002<br>\u6700\u7d42\u7684\u306aZIP\u30d5\u30a1\u30a4\u30eb\u306e\u30d8\u30c3\u30c0\u30fc\u304c\u6b20\u843d\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30b7\u30b9\u30c6\u30e0\u306f\u305d\u306e\u5185\u5bb9\u3092\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093\u3002<br>\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u304c\u4e2d\u65ad\u3055\u308c\u305f\u5834\u5408\u3084\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u969c\u5bb3\u5f8c\u306b\u767a\u751f\u3059\u308b\u3053\u3068\u304c\u591a\u3044\u3067\u3059\u3002</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "\u7834\u640d\u3057\u305fJAR\u30d5\u30a1\u30a4\u30eb\uff08\u7279\u5b9a\u306e\u540d\u524d\u4ed8\u304d\uff09";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>\u7834\u640d\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057</b>\u3001\u516c\u5f0f\u30b5\u30a4\u30c8\uff08CurseForge\u3001MinecraftStorage\u306a\u3069\uff09\u304b\u3089\u518d\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 CurseForge\u3001Technic\u3001Luna Pixel\u306a\u3069\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u6574\u5408\u6027\u3092\u3088\u308a\u9069\u5207\u306b\u78ba\u8a8d\u3067\u304d\u308b<b>ATLauncher</b>\u307e\u305f\u306f<b>Prism Launcher</b>\u3078\u306e\u5207\u308a\u66ff\u3048\u3092\u691c\u8a0e\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d\u306f\u30a4\u30f3\u30bf\u30fc\u30cd\u30c3\u30c8\u63a5\u7d9a\u304c\u5b89\u5b9a\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>NBT\u30d5\u30a1\u30a4\u30eb\u306e\u4e00\u3064\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30ef\u30fc\u30eb\u30c9\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093 (\u4f8b: <code>level.dat</code>\u3001<code>playerdata/*.dat</code>\u3001\u307e\u305f\u306f\u30c1\u30e3\u30f3\u30af\u30c7\u30fc\u30bf)\u3002<br>\u5177\u4f53\u7684\u306a\u30a8\u30e9\u30fc\u306f: <code>UTFDataFormatException: \u30d0\u30a4\u30c8 " + byteCorrupto + " \u4ed8\u8fd1\u3067\u4e0d\u6b63\u306a\u5165\u529b\u5f62\u5f0f</code>\u3067\u3059\u3002<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f \u4fee\u5fa9\u3092\u8a66\u307f\u308b\u524d\u306b\u3001\u30ef\u30fc\u30eb\u30c9\u30d5\u30a9\u30eb\u30c0\u5168\u4f53\u3092\u5b8c\u5168\u306b\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b><br><br>\u7834\u640d\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u306f\u3001<a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>\u306e\u3088\u3046\u306a<b>NBT\u30a8\u30c7\u30a3\u30bf</b>\u3092\u4f7f\u7528\u3057\u3066\u4fee\u5fa9\u3067\u304d\u307e\u3059\u3002<br>\u6df1\u523b\u306a\u640d\u50b7\u306e\u5834\u5408\u306f\u3001<b>16\u9032\u6570\u30a8\u30c7\u30a3\u30bf</b>(HxD\u306a\u3069)\u3092\u4f7f\u3063\u3066\u7121\u52b9\u306a\u30d0\u30a4\u30c8\u3092\u691c\u67fb\u30fb\u4fee\u6b63\u3067\u304d\u307e\u3059 (\u305f\u3060\u3057\u3001NBT\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306b\u7cbe\u901a\u3057\u3066\u3044\u308b\u5834\u5408\u306e\u307f\u63a8\u5968)\u3002<br>\u6700\u7d42\u624b\u6bb5\u3068\u3057\u3066\u3001\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304b\u3089\u5fa9\u5143\u3059\u308b\u304b\u3001<code>FTB Backup</code>\u306a\u3069\u306eMOD\u304c\u63d0\u4f9b\u3059\u308b<i>\u30ef\u30fc\u30eb\u30c9\u4fee\u5fa9</i>\u6a5f\u80fd\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>\u4fee\u5fa9\u3092\u8a66\u307f\u308b\u524d\u306b\u3001\u30ef\u30fc\u30eb\u30c9\u30d5\u30a9\u30eb\u30c0\u3092\u5b8c\u5168\u306b\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3002<br>\u2022 NBT\u30a8\u30c7\u30a3\u30bf(NBT Studio\u306a\u3069)\u3092\u4f7f\u7528\u3057\u3066\u3001\u7834\u640d\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304d\u4fee\u6b63\u3057\u307e\u3059\u3002<br>\u2022 \u5931\u6557\u3057\u305f\u5834\u5408\u306f\u3001\u58ca\u308c\u305f\u30d0\u30a4\u30c8\u306e\u4f4d\u7f6e\u306716\u9032\u6570\u30a8\u30c7\u30a3\u30bf\u3067\u30d5\u30a1\u30a4\u30eb\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002<br>\u2022 \u7d4c\u9a13\u304c\u306a\u3051\u308c\u3070\u3001\u6700\u8fd1\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304b\u3089\u5fa9\u5143\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "\u30ef\u30fc\u30eb\u30c9\u7834\u640d\uff1aNBT\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>You have an issue with OpenAL. Sometimes Nouveau drivers can cause this, but sometimes the application's bundled OpenAL version is incompatible with the one in your distribution and you need to use your distro's version. This is especially common with Red Hat-based distributions and sound mods like Sound Physics Remastered. See this guide for more help: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>How to fix Minecraft sound problems using Linux</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u4ed6\u306e\u30d7\u30ed\u30bb\u30b9\u304c\u30ef\u30fc\u30eb\u30c9\u30d5\u30a1\u30a4\u30eb\u3092\u30ed\u30c3\u30af\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30b5\u30fc\u30d0\u30fc\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3002<br>\u3053\u308c\u306f\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u304b\u306e\u5834\u5408\u306b\u767a\u751f\u3057\u307e\u3059\uff1a<br>\u2022 \u3059\u3067\u306b\u30b5\u30fc\u30d0\u30fc\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u304c\u5b9f\u884c\u4e2d\u3067\u3059\u3002<br>\u2022 \u30a6\u30a4\u30eb\u30b9\u5bfe\u7b56\u30bd\u30d5\u30c8\u3084\u30d5\u30a1\u30a4\u30eb\u30a8\u30af\u30b9\u30d7\u30ed\u30fc\u30e9\u30fc\u304c\u30ef\u30fc\u30eb\u30c9\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u3044\u3066\u3044\u307e\u3059\u3002<br>\u2022 \u524d\u56de\u306e\u30d7\u30ed\u30bb\u30b9\u304c\u6b63\u5e38\u306b\u7d42\u4e86\u305b\u305a\u3001\u30d5\u30a1\u30a4\u30eb\u304c\u30ed\u30c3\u30af\u3055\u308c\u305f\u307e\u307e\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>\u3059\u3079\u3066\u306e\u30b5\u30fc\u30d0\u30fc\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044</b>\uff08javaw.exe\u306a\u3069\u306e\u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9\u30d7\u30ed\u30bb\u30b9\u3082\u542b\u3080\uff09\u3002<br>\u2022 \u30db\u30b9\u30c6\u30a3\u30f3\u30b0\u30d1\u30cd\u30eb\uff08Multicraft\u306a\u3069\uff09\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u30d1\u30cd\u30eb\u304b\u3089\u30b5\u30fc\u30d0\u30fc\u3092\u5b8c\u5168\u306b\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u30d5\u30a1\u30a4\u30eb\u3092\u30d6\u30ed\u30c3\u30af\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308b\u5834\u5408\u306f\u3001<b>\u30a6\u30a4\u30eb\u30b9\u5bfe\u7b56\u30bd\u30d5\u30c8\u3092\u4e00\u6642\u7684\u306b\u7121\u52b9\u306b\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3002<br>\u2022 \u30ed\u30fc\u30ab\u30eb\u30b7\u30b9\u30c6\u30e0\u3067\u306f\u3001\u30ef\u30fc\u30eb\u30c9\u30d5\u30a9\u30eb\u30c0\u3092\u8868\u793a\u3057\u3066\u3044\u308bWindows\u30a8\u30af\u30b9\u30d7\u30ed\u30fc\u30e9\u30fc\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u3059\u3079\u3066\u9589\u3058\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u554f\u984c\u304c\u89e3\u6c7a\u3057\u306a\u3044\u5834\u5408\u3001\u30ef\u30fc\u30eb\u30c9\u30d5\u30a9\u30eb\u30c0\u5185\u306e <code>session.lock</code> \u30d5\u30a1\u30a4\u30eb\u3092\u624b\u52d5\u3067\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u5225\u306e\u30b5\u30fc\u30d0\u30fc\u304c\u52d5\u4f5c\u3057\u3066\u3044\u306a\u3044\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304b\u3089\uff09\u3002";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "\u4ed6\u306e\u30d7\u30ed\u30bb\u30b9\u306b\u3088\u3063\u3066\u30ed\u30c3\u30af\u3055\u308c\u305f\u30ef\u30fc\u30eb\u30c9\u30d5\u30a1\u30a4\u30eb";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>MOD\u304c\u30af\u30e9\u30b9 <code>" + clasePadreFinal + "</code> \u3092\u7d99\u627f\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u304c\u3001\u3053\u306e\u30af\u30e9\u30b9\u306f\u73fe\u5728<b>final</b>\u3068\u3057\u3066\u5b9a\u7fa9\u3055\u308c\u3066\u304a\u308a\u3001\u7d99\u627f\u3067\u304d\u307e\u305b\u3093\u3002<br>\u554f\u984c\u306e\u3042\u308b\u30af\u30e9\u30b9\u306f\uff1a<code>" + claseHija + "</code>\u3067\u3059\u3002<br><br>\u3053\u308c\u306f\u901a\u5e38\u3001Minecraft\u307e\u305f\u306f\u4ed6\u306e\u57fa\u672cMOD\u306e\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u5411\u3051\u306b\u30b3\u30f3\u30d1\u30a4\u30eb\u3055\u308c\u305fMOD\u3067\u767a\u751f\u3057\u307e\u3059\u3002\u3053\u308c\u3089\u306e\u57fa\u672cMOD\u306f\u6700\u8fd1\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u30af\u30e9\u30b9\u3092<code>final</code>\u306b\u3057\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>\u95a2\u4fc2\u3059\u308b\u3059\u3079\u3066\u306eMOD\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3002\u7279\u306b\u8a00\u53ca\u3055\u308c\u3066\u3044\u308b\u57fa\u672cMOD\u306b\u95a2\u9023\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308bMOD\u306b\u6ce8\u610f\u3002<br>\u2022 \u554f\u984c\u304c\u89e3\u6c7a\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u73fe\u5728\u306eMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u305d\u306e\u4f9d\u5b58\u95a2\u4fc2\u3068\u4e92\u63db\u6027\u306e\u3042\u308bMOD\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u63a2\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u5834\u5408\u306b\u3088\u3063\u3066\u306f\u3001\u5b50\u30af\u30e9\u30b9\u3092\u542b\u3080MOD\u3092\u4e00\u6642\u7684\u306b\u524a\u9664\u3059\u308b\u3053\u3068\u3067\u539f\u56e0\u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "final\u30af\u30e9\u30b9\u304b\u3089\u306e\u7d99\u627f\u8a66\u884c";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'><b>Rubidium</b>\uff08Forge\u7528\u306eSodium\u306e\u5ec3\u6b62\u3055\u308c\u305f\u30d5\u30a9\u30fc\u30af\uff09\u3092<b>Iris\u307e\u305f\u306fOculus</b>\u3068\u4e00\u7dd2\u306b\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002<br>\u6700\u8fd1\u306eMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\uff081.19.2\u4ee5\u964d\uff09\u3067\u306f\u3001Rubidium\u306fSodium\u306e\u9032\u5316\u306b\u8ffd\u3044\u3064\u3044\u3066\u304a\u3089\u305a\u3001\u4f9d\u5b58\u95a2\u4fc2\u306b\u554f\u984c\u304c\u751f\u3058\u3066\u3044\u307e\u3059\u3002<br><br>\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9MOD\uff08Sodium\u3001Rubidium\u3001Embeddium\u3001Bedium\u3001Xeonium\u306a\u3069\uff09\u307e\u305f\u306fIris Shaders\u3068\u4ed6\u306eMOD\u3068\u306e\u9593\u3067\u7af6\u5408\u304c\u3042\u308b\u5834\u5408\u306b\u3082\u3001\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <code>mods</code>\u30d5\u30a9\u30eb\u30c0\u304b\u3089<b>Rubidium\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3002<br>\u2022 <b><a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a>\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3001\u3053\u308c\u306f1.20+\u3067Iris/Oculus\u3092\u30b5\u30dd\u30fc\u30c8\u3059\u308b\u3001\u30a2\u30af\u30c6\u30a3\u30d6\u3067\u4e92\u63db\u6027\u306e\u3042\u308bForge\u7528Sodium\u306e\u30d5\u30a9\u30fc\u30af\u3067\u3059\u3002<br>\u2022 \u540c\u6642\u306b\u8907\u6570\u306eSodium\u30d5\u30a9\u30fc\u30af\uff08\u4f8b\uff1aRubidium\u3068Embeddium\uff09\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u306a\u3044\u3088\u3046\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 Iris\u3067\u306f\u306a\u304fOculus\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u305d\u308c\u3082\u3042\u306a\u305f\u306eForge\u304a\u3088\u3073Embeddium\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u304c\u3042\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "\u975e\u63a8\u5968\u306eRubidium\u3068Iris/Oculus\u4f75\u7528\uff08OptionInstance\u306ffinal\uff09";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'><code>Simple Voice Chat</code> MOD\u306f\u3001UDP\u30dd\u30fc\u30c8\u304c\u65e2\u306b\u4f7f\u7528\u4e2d\u3067\u3042\u308b\u304b\u3001\u8a2d\u5b9a\u3055\u308c\u305fIP\u30a2\u30c9\u30ec\u30b9\u304c\u7121\u52b9\u306a\u305f\u3081\u3001\u97f3\u58f0\u30b5\u30fc\u30d0\u30fc\u3092\u958b\u59cb\u3067\u304d\u307e\u305b\u3093\u3002<br>\u3053\u308c\u306f\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u307e\u305b\u3093\u304c\u3001\u97f3\u58f0\u30c1\u30e3\u30c3\u30c8\u6a5f\u80fd\u304c\u7121\u52b9\u306b\u306a\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>Minecraft\u306e\u4ed6\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3084</b> UDP\u30dd\u30fc\u30c824454\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u30b5\u30fc\u30d0\u30fc\u4e0a\u3067\u52d5\u4f5c\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001<b>\u4ed6\u306e\u30b5\u30fc\u30d3\u30b9\u304c</b>\u305d\u306e\u30dd\u30fc\u30c8\u3092\u4f7f\u7528\u3057\u3066\u3044\u306a\u3044\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 MOD\u306e\u8a2d\u5b9a (<code>config/voicechat/</code>) \u3067\u3001UDP\u30dd\u30fc\u30c8\u3092\u7a7a\u3044\u3066\u3044\u308b\u3082\u306e\uff08\u4f8b\uff1a24455\uff09\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u30ab\u30b9\u30bf\u30e0IP\u30a2\u30c9\u30ec\u30b9\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u6b63\u3057\u3044\u304b\u78ba\u8a8d\u3059\u308b\u304b\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u3092\u4f7f\u7528\u3059\u308b\u305f\u3081\u306b\u7a7a\u767d\u306e\u307e\u307e\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "\u30dc\u30a4\u30b9\u30c1\u30e3\u30c3\u30c8\uff1aUDP\u30dd\u30fc\u30c8\u304c\u4f7f\u7528\u4e2d\u307e\u305f\u306f\u7121\u52b9\u306aIP";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>BlockItem <code>" + nombreBlockItem + "</code> \u304cnull\u306e\u30d6\u30ed\u30c3\u30af\u3092\u53c2\u7167\u3057\u3066\u3044\u307e\u3059\u3002<br>\u3053\u306e\u30a8\u30e9\u30fc\u306f\u901a\u5e38\u3001<b>Create\u306e\u30a2\u30c9\u30aa\u30f3</b>\uff08\u4f8b\uff1a<code>dndecor</code>\u3001<code>createdeco</code>\uff09\u3067\u767a\u751f\u3057\u3001<code>Amendments</code>\u3084<code>Moonshine</code>\u3068\u306e\u7af6\u5408\u3001\u307e\u305f\u306f\u30d6\u30ed\u30c3\u30af\u306e\u521d\u671f\u5316\u30df\u30b9\u304c\u539f\u56e0\u3067\u3059\u3002<br><b>\u6ce8\uff1a</b>\u3053\u308c\u306fAmendments\u81ea\u4f53\u306e\u76f4\u63a5\u7684\u306a\u30a8\u30e9\u30fc\u3067\u306f\u306a\u304f\u3001\u30ec\u30b8\u30b9\u30c8\u30ea\u8aad\u307f\u8fbc\u307f\u306b\u304a\u3051\u308b\u3088\u308a\u6df1\u3044\u554f\u984c\u306e\u75c7\u72b6\u3067\u3059\u3002</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>\u95a2\u9023\u3059\u308b\u3059\u3079\u3066\u306eMOD\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\uff1a</b>Create\u3001Amendments\u3001Moonshine\u3001\u304a\u3088\u3073\u30a2\u30c9\u30aa\u30f3\uff08\u7279\u306b<code>dndecor</code>\u3068<code>createdeco</code>\uff09\u3092\u66f4\u65b0\u3057\u307e\u3059\u3002<br>\u2022 \u554f\u984c\u304c\u89e3\u6c7a\u3057\u306a\u3044\u5834\u5408\u3001<b>Create\u30a2\u30c9\u30aa\u30f3\u3092\u4e00\u6642\u7684\u306b1\u3064\u305a\u3064\u524a\u9664\u3057\u3066</b>\u539f\u56e0\u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 <b>Amendments\u3068Moonshine\u304c\u4f7f\u7528\u3057\u3066\u3044\u308bCreate\u304a\u3088\u3073Forge\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u304c\u3042\u308b\u304b</b>\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u554f\u984c\u306e\u3042\u308b\u30a2\u30c9\u30aa\u30f3\u306b\u30d9\u30fc\u30bf\u7248\u307e\u305f\u306f\u66f4\u65b0\u3055\u308c\u305f\u30d5\u30a9\u30fc\u30af\u304c\u3042\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "Create\u30a2\u30c9\u30aa\u30f3\u5185\u306enull BlockItem";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("\u30a2\u30af\u30c6\u30a3\u30d6\u306a\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\uff08Forge\u3001Fabric\u306a\u3069\uff09\u306b\u5c5e\u3055\u306a\u3044MOD\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff1a<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>\u3053\u308c\u306f\u901a\u5e38\u3001\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u304b\u306e\u72b6\u6cc1\u3067\u767a\u751f\u3057\u307e\u3059\uff1a<br>").append("\u2022 \u540c\u3058\u30d5\u30a9\u30eb\u30c0\u5185\u306b<b>Fabric\u3068Forge</b>\u306eMOD\u304c\u6df7\u5728\u3057\u3066\u3044\u308b\u3002<br>").append("\u2022 \u975e\u4e92\u63db\u306a\u30d0\u30fc\u30b8\u30e7\u30f3\u306eMinecraft\u5411\u3051MOD\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u3044\u308b\u3002<br>").append("\u2022 MOD\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u304b\u3001\u6709\u52b9\u306aJAR\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u306a\u3044\u3002</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>\u3059\u3079\u3066\u306eMOD\u304c\u540c\u3058\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\u7528\u3067\u3042\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044</b>\uff08Forge<b>\u307e\u305f\u306f</b>Fabric\u3001\u4e21\u65b9\u3067\u306f\u306a\u3044\uff09\u3002<br>\u2022 <b>MOD\u30c4\u30ea\u30fc</b>\u3092\u4f7f\u7528\u3057\u3066\u3001\u5404\u30d5\u30a1\u30a4\u30eb\u304c\u3069\u306e\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\u3068\u3057\u3066\u691c\u51fa\u3055\u308c\u3066\u3044\u308b\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u898b\u6163\u308c\u306a\u3044MOD\u3084\u7570\u306a\u308b\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0\u5411\u3051\u306eMOD\u306f\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 CurseForge\u3084Prism\u306a\u3069\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u304c\u6b63\u3057\u304f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "\u30a2\u30af\u30c6\u30a3\u30d6\u30ed\u30fc\u30c0\u30fc\u3068\u4e92\u63db\u6027\u306e\u306a\u3044MOD";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u30e2\u30c7\u30eb <code>" + modid + ":" + nombreModelo + "</code> \u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br>\u3053\u308c\u306f\u3001\u30e2\u30c9 <code>" + modid + "</code> \u306e\u30ea\u30bd\u30fc\u30b9\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u304b\u3001\u4e0d\u8db3\u3057\u3066\u3044\u308b\u304b\u3001\u307e\u305f\u306f\u4f7f\u7528\u4e2d\u306eMinecraft\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u304c\u306a\u3044\u3053\u3068\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>MOD\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3001\u3042\u306a\u305f\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3078\u3002<br>\u2022 \u958b\u767a\u7248\u3084\u30ab\u30b9\u30bf\u30e0\u30d3\u30eb\u30c9\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u516c\u5f0f\u30ea\u30ea\u30fc\u30b9\u306b\u623b\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 JAR\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\uff08\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\uff09\u3002<br>\u2022 \u554f\u984c\u304c\u89e3\u6c7a\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u3053\u306e\u30ed\u30b0\u3092\u6dfb\u3048\u3066MOD\u5236\u4f5c\u8005\u306b\u30a8\u30e9\u30fc\u3092\u5831\u544a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "\u30ea\u30bd\u30fc\u30b9\u30e2\u30c7\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'><code>Moonlight</code> \u3068 <code>Iceberg</code> \u30e2\u30c9\u306e\u9593\u3067\u91cd\u5927\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002<br>\u4e21\u65b9\u3068\u3082\u4e92\u63db\u6027\u306e\u306a\u3044\u65b9\u6cd5\u3067\u30ea\u30bd\u30fc\u30b9\u518d\u8aad\u307f\u8fbc\u307f\u30b7\u30b9\u30c6\u30e0\u3092\u767b\u9332\u3057\u3088\u3046\u3068\u3057\u3066\u304a\u308a\u3001\u6709\u52b9\u306a\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u304c\u306a\u3044\u305f\u3081\u3001OpenGL\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059\u3002<br>\u3053\u308c\u306f\u3001Fabric MOD\u7528\u30a2\u30c0\u30d7\u30bf\u30fc\u3092\u542b\u3080Forge\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306b\u4e00\u822c\u7684\u306a\u554f\u984c\u3067\u3059\u3002</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>\u4e21\u65b9\u306eMOD\u3092</b> \u3042\u306a\u305f\u306eForge\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u6700\u65b0\u7248\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u554f\u984c\u304c\u89e3\u6c7a\u3057\u306a\u3044\u5834\u5408\u306f\u3001<b>\u4e00\u6642\u7684\u306bIceberg\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044</b>\u3002Moonlight\u306f\u4ed6\u306e\u591a\u304f\u306eMOD\u306b\u3068\u3063\u3066\u91cd\u8981\u306a\u4f9d\u5b58\u95a2\u4fc2\u3067\u3042\u308b\u3053\u3068\u304c\u591a\u3044\u304b\u3089\u3067\u3059\u3002<br>\u2022 \u3053\u308c\u3089\u306eMOD\u306e\u91cd\u8907\u307e\u305f\u306f\u6df7\u5728\u3057\u305fForge/Fabric\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u3044\u306a\u3044\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>\u2022 \u5225\u306eMOD\uff08Supplementaries\u3001Citadel\u306a\u3069\uff09\u304c\u3059\u3067\u306bIceberg\u306e\u6a5f\u80fd\u3092\u5185\u90e8\u306b\u7d44\u307f\u8fbc\u3093\u3067\u3044\u308b\u304b\u3069\u3046\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "\u91cd\u5927\u306a\u885d\u7a81\uff1aMoonlight \u5bfe Iceberg (OpenGL\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u306a\u3057)";
    }

    @Override
    public String instantanea() {
        return "\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "\u524d\u56de\u306e\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u4ee5\u964d";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u304c\u6b63\u5e38\u306b\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u306e\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String consejo() {
        return "\u30d2\u30f3\u30c8";
    }

    @Override
    public String resultadoMuestra() {
        return "\u7d50\u679c\u3092\u8868\u793a";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>\u30d2\u30f3\u30c8:</b> 2\u3064\u306e\u5c65\u6b74\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u3001MOD\u30ea\u30b9\u30c8\u3092\u6bd4\u8f03\u3057\u307e\u3059\u3002   \u7d50\u679c\u306f\u6b63\u898f\u5316\u3055\u308c\u305f\u540d\u524d\u306b\u57fa\u3065\u3044\u3066\u3001<span style='color:%s;'>\u8ffd\u52a0\u3055\u308c\u305f (+)</span>\u3068   <span style='color:%s;'>\u524a\u9664\u3055\u308c\u305f (&#8722;)</span> \u3092\u8868\u793a\u3057\u307e\u3059\u3002   \u300c\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u300d\u30dc\u30bf\u30f3\u3092\u4f7f\u7528\u3057\u3066\u3001\u62e1\u5f35\u5b50\u304c .instantanea \u306e\u65e2\u5b58\u30d5\u30a1\u30a4\u30eb\u306e\u30b3\u30d4\u30fc\u3092\u4f5c\u6210\u3067\u304d\u307e\u3059\u3002</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "\u30ec\u30dd\u30fc\u30c8\u306a\u3057\u3067\u30ed\u30b0\u30ea\u30f3\u30af\u3092Markdown\u5f62\u5f0f\u3067\u53d6\u5f97";
    }

    @Override
    public String titulo_configuracion() {
        return "\u8a2d\u5b9a";
    }

    @Override
    public String columna_url() {
        return "URL";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "\u5171\u6709\u4e2d\u306b\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "\u30ea\u30f3\u30af\u751f\u6210\u4e2d\u306b\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "\u30dc\u30bf\u30f3\u51e6\u7406\u4e2d\u306b\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "\u958b\u304f\u30d5\u30a1\u30a4\u30eb\u304c\u95a2\u9023\u4ed8\u3051\u3089\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\uff1a\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "\u30a8\u30c7\u30a3\u30bf\u3067\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\u30d1\u30b9\u304c\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059\u3002";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30d1\u30b9\u306f\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f\u3002";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30d1\u30b9\u306f\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3057\u305f\u3002";
    }

    @Override
    public String limite_de_solicitudes() {
        return "\u30ea\u30af\u30a8\u30b9\u30c8\u5236\u9650\u306b\u9054\u3057\u3066\u3044\u307e\u3059\u3002\u5225\u306e\u30ed\u30b0\u30b5\u30a4\u30c8\u307e\u305f\u306f\u5225\u306e\u30ed\u30b0API\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "\u30ea\u30f3\u30af\u3092\u5171\u6709";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30ed\u30b0\u306e\u4e0a\u90e8\u3092\u4fee\u6b63\u3059\u308b\u3053\u3068\u304c\u6700\u512a\u5148\u4e8b\u9805\u3067\u3059\u3002 \u5f62\u5f0f\u306f\u300c\u30ec\u30d9\u30eb\u3001\u884c\u300d\u3067\u3059\u3002 \u3059\u3079\u3066\u306e\u30ed\u30b0\u306b\u306f\u756a\u53f7\u4f53\u7cfb\u304c\u3042\u308a\u307e\u3059\u3002 " + "<br>" + "\u4e00\u822c\u7684\u306b\u3001\u3059\u3079\u3066\u306e\u30ed\u30b0\u3067\u6700\u3082\u4f4e\u3044\u30ec\u30d9\u30eb\u3092\u63a2\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u9ad8\u3044\u30ec\u30d9\u30eb\u306e\u30c8\u30ec\u30fc\u30b9\u306f\u3001\u591a\u304f\u306e\u5834\u5408\u8aa4\u691c\u51fa\u3067\u3059\u3002 \u30c8\u30ec\u30fc\u30b9\u304c\u591a\u6570\u3042\u308b\u5834\u5408\u3001\u30c8\u30ec\u30fc\u30b9\u5206\u6790\u306f\u5b8c\u74a7\u3067\u306f\u306a\u3044\u305f\u3081\u3001\u30b3\u30f3\u30bd\u30fc\u30eb\u3092\u76f4\u63a5\u8aad\u3080\u80fd\u529b\u3092\u4f7f\u3046\u3053\u3068\u304c\u91cd\u8981\u3067\u3059\u3002</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "\u691c\u7d22\u7528\u30ef\u30e9\u30f3\u30c8\u30fb\u30ad\u30e3\u30ca\u30ea\u30fc";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "\u3053\u306e\u6a5f\u80fd\u306f\u8fd1\u65e5\u4e2d\u306b\u3054\u5229\u7528\u3044\u305f\u3060\u3051\u307e\u3059\u3002";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "\u8fd1\u65e5\u30ea\u30ea\u30fc\u30b9";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "Crash Assistant\u3068\u4e92\u63db\u6027\u306e\u306a\u3044MOD\uff08\u8aa4\u691c\u51fa\uff09";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "CrashAssistant\u3092\u4f7f\u7528\u3059\u308bMOD\u30d1\u30c3\u30af\u3068\u306e\u4e92\u63db\u6027\u30a8\u30e9\u30fc";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant\u306f\u4e92\u63db\u6027\u304c\u306a\u3044\u3068\u3057\u3066\u3044\u308bMOD\u306e\u30ea\u30b9\u30c8\u3092\u6301\u3063\u3066\u3044\u307e\u3059\u304c\u3001\u5b9f\u969b\u306b\u4e92\u63db\u6027\u304c\u306a\u3044\u3068\u3044\u3046\u8a3c\u62e0\u306f\u306a\u304f\u3001\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u3082\u82f1\u8a9e\u306e\u307f\u3067\u3059\u3002\u3053\u308c\u3089\u306eMOD\u3067\u30d7\u30ec\u30a4\u3057\u305f\u3044\u5834\u5408\u306f\u3001<code>config/crash_assistant/config.toml</code>\u30d5\u30a1\u30a4\u30eb\u3092\u7de8\u96c6\u3057\u3001[compatibility]\u30bb\u30af\u30b7\u30e7\u30f3\u306e<code>enabled = true</code>\u3092<code>enabled = false</code>\u306b\u5909\u66f4\u3067\u304d\u307e\u3059\u3002</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant\u306fMOD\u3092\u4e92\u63db\u6027\u306a\u3057\u3068\u5224\u5b9a\u3059\u308b\u6a5f\u80fd\u304c\u3042\u308a\u307e\u3059\u304c\u3001\u6642\u306b\u306f\u8aa4\u3063\u305f\u5224\u5b9a\u3067\u3042\u308a\u3001\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u306f1\u304b\u56fd\u8a9e\u3057\u304b\u3042\u308a\u307e\u305b\u3093\u3002\u3053\u308c\u3089\u306eMOD\u3092\u4f7f\u7528\u3057\u305f\u3044\u5834\u5408\u306f\u3001<code>config/crash_assistant/problematic_mods_config.json</code>\u30d5\u30a1\u30a4\u30eb\u3092\u7de8\u96c6\u3057\u3066\u3001<code>should_crash_on_startup</code>\u3092<code>true</code>\u304b\u3089<code>false</code>\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u30a8\u30e9\u30fc\uff1aMOD '" + modId + "' \u306f MOD '" + dependencia + "' \u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u3002\u73fe\u5728\u3001" + actual + "\u3002</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u30a8\u30e9\u30fc\uff1aMOD '" + modId + "' \u306f '" + dependencia + "' \u306e\u30d0\u30fc\u30b8\u30e7\u30f3 '" + requerido + "' \u4ee5\u4e0a\u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u304c\u3001\u305d\u306eMOD\u306f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u30a8\u30e9\u30fc: \u30e2\u30c9 '" + modId + "' \u306f '" + dependencia + "' \u306e\u73fe\u5728\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002 'Iris/Oculus & GeckoLib Compat' \u30e2\u30c9\u3092\u524a\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u3053\u308c\u306f Superb Warfare \u3068\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u6700\u65b0\u7248\u306e GeckoLib \u3067\u306f\u52d5\u4f5c\u3057\u307e\u305b\u3093\u3002 \u73fe\u5728\u306e\u30d0\u30fc\u30b8\u30e7\u30f3: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "\u30a8\u30e9\u30fc: \u30af\u30e9\u30b9 '" + clase + "' \u306e\u30bf\u30b9\u30af\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 \u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001\u4e92\u63db\u6027\u306e\u306a\u3044MOD\u3084\u4ed6\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u6e08\u307fMOD\u3068\u7af6\u5408\u3059\u308bMOD\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\u3002";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "\u30bf\u30b9\u30af\u5b9f\u884c\u5931\u6557";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "\u3053\u306e\u7a2e\u306e\u30a8\u30e9\u30fc\u306f\u3001MOD\u9593\u306e\u4e92\u63db\u6027\u306e\u554f\u984c\u304c\u539f\u56e0\u3067\u767a\u751f\u3059\u308b\u3053\u3068\u304c\u591a\u3044\u3067\u3059\u3002 \u7279\u306bConnectorMod\u3068\u6b63\u3057\u304f\u52d5\u4f5c\u3057\u306a\u3044MOD\u3067\u4e00\u822c\u7684\u3067\u3059\u3002";
    }

    @Override
    public String info_clase_problematica() {
        return "\u554f\u984c\u306e\u3042\u308b\u30af\u30e9\u30b9\uff1a";
    }

    public String ver_en_log() {
        return "\u30ed\u30b0\u3067\u8868\u793a";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "\u5b9f\u884c\u306b\u554f\u984c\u304c\u3042\u308b\u7279\u5b9a\u306e\u30af\u30e9\u30b9\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine\u3068Entity Model Features (EMF)\u306e\u9593\u306b\u91cd\u5927\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u3053\u308c\u3089\u306eMOD\u306f\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u308b\u30a4\u30f3\u30b8\u30a7\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "OptiFine\u3068Entity Model Features\u306e\u885d\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "OptiFine\u307e\u305f\u306fEntity Model Features\u306e\u3044\u305a\u308c\u304b\u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u308c\u3089\u306f\u4e92\u3044\u306b\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine\u3068Fusion\u306e\u9593\u306b\u91cd\u5927\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u3089\u306eMOD\u306f\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u308b\u30a4\u30f3\u30b8\u30a7\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "OptiFine\u3068Fusion\u306e\u885d\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "OptiFine\u307e\u305f\u306fFusion\u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e21\u8005\u306f\u4e92\u3044\u306b\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Flywheel\uff08Create\u304c\u5fc5\u8981\u3068\u3059\u308b\u3082\u306e\uff09\u306fSodium 0.6.0-beta.2\u4ee5\u4e0a\u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u3002Rubidium\u306f0.5.3\u3067\u3059\u3002\u4ee3\u66ff\u3068\u3057\u3066<a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a>\u306e\u4f7f\u7528\u3092\u691c\u8a0e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "Flywheel\u3068Sodium\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u885d\u7a81";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "Sodium\u30920.6.0-beta.2\u4ee5\u4e0a\u306b\u66f4\u65b0\u3059\u308b\u304b\u3001\u4e92\u63db\u6027\u306e\u3042\u308b\u4ee3\u66ff\u3068\u3057\u3066<a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a>\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine\u3068Epic Fight\u306e\u9593\u306b\u91cd\u5927\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u3089\u306eMOD\u306f\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u308b\u30a4\u30f3\u30b8\u30a7\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "OptiFine\u3068Epic Fight\u306e\u885d\u7a81";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "OptiFine\u307e\u305f\u306fEpic Fight\u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e21\u8005\u306f\u4e92\u3044\u306b\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \u3068 Rubidium \u306e\u9593\u306b\u6df1\u523b\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u3089\u306e\u30e2\u30c3\u30c9\u306f\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u30a4\u30f3\u30b8\u30a7\u30af\u30b7\u30e7\u30f3\u306e\u5931\u6557\u3092\u5f15\u304d\u8d77\u3053\u3057\u3001\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "OptiFine \u3068 Rubidium \u306e\u7af6\u5408";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "OptiFine \u307e\u305f\u306f Rubidium \u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e21\u8005\u306f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam \u304c\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u3067\u306e\u8aad\u307f\u8fbc\u307f\u3092\u8a66\u307f\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u308c\u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3067\u306e\u307f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u30b5\u30fc\u30d0\u30fc\u304b\u3089 FreeCam \u3092\u524a\u9664\u3059\u308b\u304b\u3001\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u4e0a\u306e FreeCam";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "FreeCam \u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u306e\u3067\u3001\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) \u304c\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u3067\u306e\u8aad\u307f\u8fbc\u307f\u3092\u8a66\u307f\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u308c\u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3067\u306e\u307f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u30b5\u30fc\u30d0\u30fc\u304b\u3089 ETF \u3092\u524a\u9664\u3059\u308b\u304b\u3001\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u4e0a\u306e Entity Texture Features";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features \u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u306e\u3067\u3001\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30b5\u30fc\u30d0\u30fc\u3092\u8d77\u52d5\u3059\u308b\u306b\u306f\u3001Minecraft\u306eEULA\u306b\u540c\u610f\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002 eula.txt\u30d5\u30a1\u30a4\u30eb\u3092\u7de8\u96c6\u3057\u3066\u3001'eula=false'\u3092'eula=true'\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "Minecraft EULA \u672a\u627f\u8a8d";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "\u30b5\u30fc\u30d0\u30fc\u30d5\u30a9\u30eb\u30c0\u5185\u306e eula.txt \u30d5\u30a1\u30a4\u30eb\u3092\u7de8\u96c6\u3057\u3001'eula=false'\u3092'eula=true'\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \u304c\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u3067\u306e\u8aad\u307f\u8fbc\u307f\u3092\u8a66\u307f\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u308c\u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3067\u306e\u307f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u30b5\u30fc\u30d0\u30fc\u304b\u3089 OptiFine \u3092\u524a\u9664\u3059\u308b\u304b\u3001\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u4e0a\u306e OptiFine";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "OptiFine \u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u306e\u3067\u3001\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks \u304c\u8aa4\u3063\u3066 1.20.1 \u5411\u3051\u3068\u30de\u30fc\u30af\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u30011.21.1 \u306e\u30e1\u30bd\u30c3\u30c9\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002 \u30e2\u30c3\u30c9\u306f 1.20.1 \u306b\u5b58\u5728\u3057\u306a\u3044 ResourceLocation.fromNamespaceAndPath \u3092\u4f7f\u7528\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "Iron's Spellbooks \u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u30a8\u30e9\u30fc";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "\u4f7f\u7528\u3057\u3066\u3044\u308b Minecraft \u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u6b63\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Iron's Spellbooks \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \u3068 Embeddium \u306e\u9593\u306b\u6df1\u523b\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u3089\u306e\u30e2\u30c3\u30c9\u306f\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u30a4\u30f3\u30b8\u30a7\u30af\u30b7\u30e7\u30f3\u306e\u5931\u6557\u3092\u5f15\u304d\u8d77\u3053\u3057\u3001\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "OptiFine \u3068 Embeddium \u306e\u7af6\u5408";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "OptiFine \u307e\u305f\u306f Embeddium \u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e21\u8005\u306f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u3053\u308c\u306f\u3001\u7279\u306b Terralinth\u3001AmplifiedNether\u3001Nullscape\u3001Incendium \u306a\u3069\u306e\u4e16\u754c\u751f\u6210\u7cfb mod \u540c\u58eb\u306e\u7af6\u5408\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\u3002\u4e0d\u8db3\u3057\u3066\u3044\u308b mod \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u5834\u5408\u3082\u3042\u308a\u307e\u3059\u3002</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable \u304c\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u3067\u306e\u8aad\u307f\u8fbc\u307f\u3092\u8a66\u307f\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u308c\u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3067\u306e\u307f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u30b5\u30fc\u30d0\u30fc\u304b\u3089 Controllable \u3092\u524a\u9664\u3059\u308b\u304b\u3001\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u4e0a\u306e Controllable";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "Controllable \u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u306e\u3067\u3001\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries \u304c\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u304a\u308a\u3001\u30b5\u30fc\u30d0\u30fc\u306e\u8aad\u307f\u8fbc\u307f\u3092\u59a8\u3052\u3066\u3044\u307e\u3059\u3002 \u3053\u306e mod \u306f\u706b\u306e\u6319\u52d5\u306e\u767b\u9332\u3067\u554f\u984c\u3092\u62b1\u3048\u3066\u304a\u308a\u3001datapack \u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u5931\u6557\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries \u304c\u30b5\u30fc\u30d0\u30fc\u8aad\u307f\u8fbc\u307f\u3092\u59a8\u5bb3";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "Supplementaries \u3092\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3059\u308b\u304b\u3001\u4e00\u6642\u7684\u306b\u7121\u52b9\u306b\u3057\u3066\u30b5\u30fc\u30d0\u30fc\u306e\u8aad\u307f\u8fbc\u307f\u3092\u53ef\u80fd\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader (GML) \u306f\u3001\u4e0d\u8db3\u3057\u3066\u3044\u308b Jackson \u30e2\u30b8\u30e5\u30fc\u30eb\u306b\u95a2\u3059\u308b\u554f\u984c\u3092\u691c\u51fa\u3057\u307e\u3057\u305f\u3002 Valkyrien Skies \u306e\u3088\u3046\u306a\u4e00\u90e8\u306e mod \u306f\u3001\u5fc5\u8981\u306a\u4f9d\u5b58\u95a2\u4fc2\u3092\u3059\u3079\u3066\u542b\u3093\u3067\u3044\u306a\u3044\u305f\u3081\u3001\u3053\u306e\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3059\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "Groovy Modloader \u3067 Jackson \u30e2\u30b8\u30e5\u30fc\u30eb\u304c\u4e0d\u8db3";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "\u4f9d\u5b58\u95a2\u4fc2\u306e\u7af6\u5408\u3092\u5f15\u304d\u8d77\u3053\u3059\u53ef\u80fd\u6027\u306e\u3042\u308b Groovy Modloader \u3084 Valkyrien Skies \u306a\u3069\u306e\u95a2\u9023 mod \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat \u304c\u7121\u52b9\u306a\u6728\u6750\u30d6\u30ed\u30c3\u30af\u540d\u3092\u691c\u51fa\u3057\u307e\u3057\u305f\u3002 Every Compat \u306f\u901a\u5e38\u3001\u591a\u304f\u306e\u554f\u984c\u3092\u62b1\u3048\u3066\u3044\u307e\u3059\u3002\u4f7f\u7528\u3057\u306a\u3044\u3067\u304f\u3060\u3055\u3044\uff01</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "Every Compat \u306e\u7121\u52b9\u306a\u540d\u524d";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "Every Compat \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u30ea\u30bd\u30fc\u30b9\u30d1\u30c3\u30af\u3084 mod \u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u7121\u52b9\u306a\u30d6\u30ed\u30c3\u30af\u540d\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30a8\u30e9\u30fc\u30b3\u30fc\u30c9 (-1073741819) \u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u3053\u308c\u306f Razer \u306e GameCaster\u3001Discord\u3001OBS Studio \u306a\u3069\u306e\u30aa\u30fc\u30d0\u30fc\u30ec\u30a4\u3084\u3001NVIDIA \u30c9\u30e9\u30a4\u30d0\u30fc\u306e\u554f\u984c\u306b\u3088\u3063\u3066\u5f15\u304d\u8d77\u3053\u3055\u308c\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "\u30a8\u30e9\u30fc\u30b3\u30fc\u30c9 -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "GameCaster\u3001Discord\u3001OBS Studio \u306a\u3069\u306e\u30aa\u30fc\u30d0\u30fc\u30ec\u30a4\u3092\u7121\u52b9\u5316\u3057\u3001NVIDIA \u30c9\u30e9\u30a4\u30d0\u30fc\u304c\u6700\u65b0\u3067\u3042\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips \u306f dependencia \u3068\u3057\u3066 Immersive Messages \u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u304c\u3001\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 Immersive Tooltips \u3092\u6b63\u3057\u304f\u52d5\u4f5c\u3055\u305b\u308b\u306b\u306f\u3001Immersive Messages \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "dependencia \u306e\u306a\u3044 Immersive Tooltips";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips \u306b\u5fc5\u8981\u306a dependencia \u3067\u3042\u308b Immersive Messages \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins \u306f Apoli Mod \u3068\u306e\u4e92\u63db\u6027\u306b\u554f\u984c\u304c\u3042\u308a\u3001ItemStack \u3092 EntityLinkedItemStack \u306b\u30ad\u30e3\u30b9\u30c8\u3067\u304d\u307e\u305b\u3093\u3002 \u3053\u308c\u306f\u30d0\u30fc\u30b8\u30e7\u30f3 6.6.0 \u3088\u308a\u65b0\u3057\u3044\u3082\u306e\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\u3002\u4ee5\u524d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3059\u308b\u304b\u3001Fabric \u3068 Forge \u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u5207\u308a\u66ff\u3048\u308b\u3053\u3068\u3092\u691c\u8a0e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "Medieval Origins \u306e\u30ad\u30e3\u30b9\u30c8\u30a8\u30e9\u30fc";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "Medieval Origins \u306e 6.6.0 \u4ee5\u524d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3059\u308b\u304b\u3001mod \u306e Fabric \u3068 Forge \u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u5207\u308a\u66ff\u3048\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether \u304c\u3001MusicManager \u306b\u5b58\u5728\u3057\u306a\u3044 Registry Object \u306b\u95a2\u9023\u3059\u308b\u30a8\u30e9\u30fc\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u3044\u307e\u3059\u3002 \u3053\u306e\u554f\u984c\u306f Reign of Nether \u306e MusicManager mixin \u306b\u95a2\u9023\u3057\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "Reign of Nether \u306e MusicManager \u30a8\u30e9\u30fc";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "\u3053\u306e\u30a8\u30e9\u30fc\u3092\u89e3\u6c7a\u3059\u308b\u306b\u306f\u3001Reign of Nether \u3092\u66f4\u65b0\u3059\u308b\u304b\u3001\u4e00\u6642\u7684\u306b\u524a\u9664\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel \u306f Linux \u307e\u305f\u306f Android \u4e0a\u306e YSM \u30b5\u30fc\u30d0\u30fc\u306e\u307f\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u3059\u3002 \u3053\u306e\u554f\u984c\u306f\u30012025\u5e7411\u670823\u65e5\u4ee5\u964d\u306b Modrinth \u3067\u516c\u958b\u3055\u308c\u305f\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u4fee\u6b63\u3055\u308c\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel \u304c Linux \u3068\u975e\u4e92\u63db";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "\u3053\u306e\u554f\u984c\u306f 11\u670823\u65e5\u4ee5\u964d\u306b\u4fee\u6b63\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001Modrinth \u304b\u3089 YesSteveModel \u3092\u6700\u65b0\u7248\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Moving Elevators \u3068 OptiFine \u306e\u9593\u306b\u6df1\u523b\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u3089\u306e\u30e2\u30c3\u30c9\u306f\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u30a4\u30f3\u30b8\u30a7\u30af\u30b7\u30e7\u30f3\u306e\u5931\u6557\u3092\u5f15\u304d\u8d77\u3053\u3057\u3001\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "Moving Elevators \u3068 OptiFine \u306e\u7af6\u5408";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "OptiFine \u307e\u305f\u306f Moving Elevators \u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e21\u8005\u306f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Fabric API\uff08fabric-resource-loader-v0\uff09\u3068 OptiFine \u306e\u9593\u306b\u6df1\u523b\u306a\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u3089\u306e\u30e2\u30c3\u30c9\u306f\u4e92\u63db\u6027\u304c\u306a\u304f\u3001\u30a4\u30f3\u30b8\u30a7\u30af\u30b7\u30e7\u30f3\u306e\u5931\u6557\u3092\u5f15\u304d\u8d77\u3053\u3057\u3001\u30b2\u30fc\u30e0\u306e\u8d77\u52d5\u3092\u59a8\u3052\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "Fabric API \u3068 OptiFine \u306e\u7af6\u5408";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "OptiFine \u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u304b\u3001Fabric API \u3092\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3042\u308b mod \u306b\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u3067\u304d\u306a\u3044\u6b20\u9665\u306e\u3042\u308b ITransformationService \u304c\u3042\u308a\u307e\u3059: " + claseProveedor + "\u3002\u30b2\u30fc\u30e0\u3092\u8aad\u307f\u8fbc\u3081\u308b\u3088\u3046\u306b\u3059\u308b\u306b\u306f\u3001\u3053\u306e mod \u3092\u524a\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "\u6b20\u9665\u306e\u3042\u308b ITransformationService";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "\u6b20\u9665\u306e\u3042\u308b ITransformationService \u3092\u542b\u3080 " + claseProveedor + " \u30af\u30e9\u30b9\u3092\u542b\u3080 mod \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u3042\u308b mod \u304c\u7121\u52b9\u306a\u30d0\u30fc\u30b8\u30e7\u30f3\u6307\u5b9a\u3092\u6301\u3063\u3066\u3044\u307e\u3059\u3002 \u30d0\u30fc\u30b8\u30e7\u30f3\u306f\u89d2\u62ec\u5f27\u3067\u56f2\u3080\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002 \u30b5\u30a4\u30c9\u30d1\u30cd\u30eb\u306e grep/greprf \u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3\u3092\u4f7f\u7528\u3057\u3066\u3001\u30d0\u30fc\u30b8\u30e7\u30f3 </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'> \u3092\u691c\u7d22\u3057\u3001\u554f\u984c\u306e\u3042\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "mod \u5185\u306e\u7121\u52b9\u306a\u30d0\u30fc\u30b8\u30e7\u30f3";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "\u30b5\u30a4\u30c9\u30d1\u30cd\u30eb\u306e grep/greprf \u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3\u3092\u4f7f\u7528\u3057\u3066\u554f\u984c\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u691c\u7d22\u3057\u3001\u305d\u308c\u3092\u542b\u3080 mod \u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>stack smashing \u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u3001\u30d7\u30ed\u30bb\u30b9\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002 \u3053\u308c\u306f\u3001Forge/NeoForge/PillowMC \u306e Early Window \u306e\u554f\u984c\u3001\u307e\u305f\u306f LWJGL 3.2.2 \u4ee5\u964d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u8d77\u56e0\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "Stack Smashing \u691c\u51fa";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "Early Window \u306e\u8a2d\u5b9a\u3092\u78ba\u8a8d\u3057\u3001\u5225\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306e LWJGL \u3092\u4f7f\u7528\u3059\u308b\u304b\u3001\u65e9\u671f\u30a6\u30a3\u30f3\u30c9\u30a6\u95a2\u9023\u306e mod \u3092\u898b\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore \u306f\u7279\u5b9a\u306e modpack \u5c02\u7528\u3067\u3042\u308a\u3001\u6c4e\u7528\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3067\u4f7f\u7528\u3057\u3066\u306f\u3044\u3051\u307e\u305b\u3093\u3002\u4f7f\u7528\u3059\u308b\u3068\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "Java \u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u975e\u4e92\u63db\u306e GregTechEasyCore";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u308c\u306f\u7279\u5b9a\u306e modpack \u5c02\u7528\u3067\u3042\u308a\u3001\u3042\u306a\u305f\u306e\u6c4e\u7528\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3068\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MoniLabs \u3068 Connector Extras \u306e\u9593\u3067\u3001KubeJS \u306e\u6539\u9020\u306b\u95a2\u9023\u3059\u308b\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u3089\u306e mod \u306f\u3001KubeJS \u306e\u6539\u9020\u5185\u5bb9\u304c\u4e92\u63db\u6027\u3042\u308a\u307e\u305b\u3093\u3002</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "MoniLabs \u3068 Connector Extras \u306e\u7af6\u5408";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "KubeJS \u306e\u6539\u9020\u5185\u5bb9\u304c\u7af6\u5408\u3057\u3066\u3044\u308b\u305f\u3081\u3001MoniLabs \u307e\u305f\u306f Connector Extras \u306e\u3044\u305a\u308c\u304b\u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris \u306b\u306f Distant Horizons [2.0.4] \u307e\u305f\u306f DH API \u30d0\u30fc\u30b8\u30e7\u30f3 [1.1.0] \u4ee5\u964d\u304c\u5fc5\u8981\u3067\u3059\u3002\u554f\u984c\u3092\u89e3\u6c7a\u3059\u308b\u306b\u306f\u3001\u4e92\u63db\u6027\u30ac\u30a4\u30c9\u3092\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044: https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "Iris \u3068 Distant Horizons \u306e\u4e92\u63db\u6027";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "\u4e92\u63db\u6027\u30ac\u30a4\u30c9\uff08https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e\uff09\u3092\u78ba\u8a8d\u3057\u3001Iris \u304a\u3088\u3073 Distant Horizons \u3092\u4e92\u63db\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Minecraft \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>\u30b2\u30fc\u30e0\u306e\u4ed6\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u5411\u3051\u306e mod \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002<a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a> \u3092\u4f7f\u3063\u3066\u3001\u305d\u306e\u30af\u30e9\u30b9\u304c\u3042\u306a\u305f\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5b58\u5728\u3059\u308b\u304b\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002</li><li>Minecraft \u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff08CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u306a\u3069\u306e modpack \u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\uff09\u3002CurseForge \u306e\u554f\u984c\u89e3\u6c7a\u306b\u306f<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u8996\u8074</a>\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u4e0d\u5177\u5408\u306e\u3042\u308b coremod \u304c\u3042\u308a\u307e\u3059\uff08coremod \u304c\u5931\u6557\u3059\u308b\u3068\u3001\u30af\u30e9\u30b9\u306e\u8aad\u307f\u8fbc\u307f\u3092\u30d6\u30ed\u30c3\u30af\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\uff09\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>DangerZone \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>\u30b2\u30fc\u30e0\u306e\u4ed6\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u5411\u3051\u306e mod \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002</li><li>\u4e0d\u5177\u5408\u306e\u3042\u308b coremod \u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u30e9\u30f3\u30c1\u30e3\u30fc\u3084\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FeatureCreep \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>\u4ed6\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306e FeatureCreep \u5411\u3051\u306e mod \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\uff08\u4f8b: ESR \u3068 Nightly\u3001\u307e\u305f\u306f v4 \u3068 v12\uff09\u3002</li><li>CurseForge \u307e\u305f\u306f MinecraftStorage \u304b\u3089 FeatureCreep \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3067\u304d\u307e\u3059\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModLauncher \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>mod \u304c MinecraftForge\u3001PillowMC\u3001\u307e\u305f\u306f NeoForge \u306e\u5225\u306e\u30d3\u30eb\u30c9\u5411\u3051\u306b\u306a\u3063\u3066\u3044\u307e\u3059\uff08ModLauncher \u306f\u3053\u308c\u3089\u306e\u30ed\u30fc\u30c0\u30fc\u3067\u4f7f\u7528\u3055\u308c\u307e\u3059\uff09\u3002</li><li>Minecraft \u306e1\u3064\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5bfe\u3057\u3001\u591a\u6570\u306e modloader \u66f4\u65b0\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff08CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u306a\u3069\u306e modpack \u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\uff09\u3002CurseForge \u306e\u554f\u984c\u89e3\u6c7a\u306b\u306f<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u8996\u8074</a>\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Minecraft Forge \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>mod \u304c MinecraftForge \u306e\u5225\u306e\u30d3\u30eb\u30c9\u5411\u3051\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002</li><li>Minecraft \u306e1\u3064\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5bfe\u3057\u3001\u591a\u6570\u306e modloader \u66f4\u65b0\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff08CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u306a\u3069\u306e modpack \u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\uff09\u3002CurseForge \u306e\u554f\u984c\u89e3\u6c7a\u306b\u306f<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u8996\u8074</a>\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>NeoForge \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>mod \u304c NeoForge \u306e\u5225\u306e\u30d3\u30eb\u30c9\u5411\u3051\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002</li><li>Minecraft \u306e1\u3064\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5bfe\u3057\u3001\u591a\u6570\u306e modloader \u66f4\u65b0\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff08CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u306a\u3069\u306e modpack \u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\uff09\u3002CurseForge \u306e\u554f\u984c\u89e3\u6c7a\u306b\u306f<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u8996\u8074</a>\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Fabric Loader \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>mod \u304c Fabric Loader \u306e\u5225\u306e\u30d3\u30eb\u30c9\u5411\u3051\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002</li><li>Minecraft \u306e1\u3064\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5bfe\u3057\u3001\u591a\u6570\u306e modloader \u66f4\u65b0\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff08CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u306a\u3069\u306e modpack \u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\uff09\u3002CurseForge \u306e\u554f\u984c\u89e3\u6c7a\u306b\u306f<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u8996\u8074</a>\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u591a\u304f\u306e mod \u306f Fabric API \u3092\u5fc5\u8981\u3068\u3057\u307e\u3059\u3002\u5fc5\u8981\u306b\u5fdc\u3058\u3066 Fabric API \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>PillowMC \u306e\u30af\u30e9\u30b9\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b><ul><li>mod \u304c PillowMC \u306e\u5225\u306e\u30d3\u30eb\u30c9\u5411\u3051\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002</li><li>Minecraft \u306e1\u3064\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5bfe\u3057\u3001\u591a\u6570\u306e modloader \u66f4\u65b0\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff08CurseForge App\u3001ModrinthApp/Theseus/Astralrinth \u306a\u3069\u306e modpack \u30e9\u30f3\u30c1\u30e3\u30fc\u3067\u3088\u304f\u767a\u751f\u3057\u307e\u3059\uff09\u3002CurseForge \u306e\u554f\u984c\u89e3\u6c7a\u306b\u306f<a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u8996\u8074</a>\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li></ul><p>\u6ce8: \u540d\u524d\u306b '/' \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr/fgrepr</b> \u30c4\u30fc\u30eb\u3067\u4e0d\u8db3\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b mod \u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u610f\u56f3\u7684\u306b\u30e9\u30b0\u3092\u5f15\u304d\u8d77\u3053\u3059 mod \u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u3059\u3002Uranium \u306f\u30e9\u30b0 mod \u3067\u3059\u3002\u5e38\u306b\u30af\u30e9\u30c3\u30b7\u30e5\u3059\u308b\u308f\u3051\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u304c\u3001\u6700\u7d42\u7684\u306b\u306f\u30af\u30e9\u30c3\u30b7\u30e5\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack \u306f 1.19.* \u4e92\u63db\u3068\u8868\u793a\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001\u5b9f\u969b\u306b\u306f 1.20.* \u7528\u306e\u305f\u3081\u3001\u300c\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u300d\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059\u3002\u3053\u306e mod \u306f\u3001\u73fe\u5728\u4f7f\u7528\u4e2d\u306e Minecraft \u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u5b58\u5728\u3057\u306a\u3044 DamageSources \u3092\u4f7f\u7528\u3057\u3088\u3046\u3068\u3057\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "Falling Attack \u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u30a8\u30e9\u30fc";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "\u4f7f\u7528\u4e2d\u306e Minecraft \u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u6b63\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e Falling Attack \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("\u3053\u306e\u6a5f\u80fd\u3092\u4f7f\u7528\u3059\u308b\u306b\u306f\u3001CFR (Class File Reader) \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("Linux\u3001NetBSD\u3001FreeBSD \u30b7\u30b9\u30c6\u30e0\u3067\u306f\u3001\u30d1\u30c3\u30b1\u30fc\u30b8\u30de\u30cd\u30fc\u30b8\u30e3\u30fc\u304b\u3089 CFR \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3067\u304d\u307e\u3059\u3002<br>").append("\u3053\u3061\u3089\u3067\u30d1\u30c3\u30b1\u30fc\u30b8\u3092\u691c\u7d22\u3057\u3066\u304f\u3060\u3055\u3044: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("\u307e\u305f\u306f\u3001FabricMC \u304c\u4f7f\u7528\u3057\u3066\u3044\u308b\u4fee\u6b63\u7248\u3092\u4ee5\u4e0b\u304b\u3089\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3067\u304d\u307e\u3059:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("\u4ee5\u4e0b\u306e\u30d5\u30a9\u30eb\u30c0\u306b\u4fdd\u5b58\u3057\u3066\u304f\u3060\u3055\u3044:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>\u91cd\u8981:</b> CFR \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u5f8c\u3001mod \u3092\u518d\u8d77\u52d5\u3057\u306a\u3044\u3068\u6b63\u3057\u304f\u8a8d\u8b58\u3055\u308c\u307e\u305b\u3093\u3002").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "\u5229\u7528\u53ef\u80fd\u306a\u8096\u50cf\u753b\u306a\u3057";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "CFR \u30c7\u30b3\u30f3\u30d1\u30a4\u30e9 \u2013 Sakura Riddle\uff08\u975e\u516c\u5f0f\uff09";
    }

    @Override
    public String cfrClaseActual() {
        return "\u73fe\u5728\u306e\u30af\u30e9\u30b9";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "Sakura Riddle \u306e\u8096\u50cf\u753b";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "\u8096\u50cf\u753b\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc";
    }

    @Override
    public String noticiaLegalCFR() {
        return "\u3053\u306e mod \u306e\u9006\u30b3\u30f3\u30d1\u30a4\u30eb\u7528\u30b0\u30e9\u30d5\u30a3\u30ab\u30eb\u30fb\u30e6\u30fc\u30b6\u30fc\u30fb\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\uff08GUI\uff09\u306f\u3001\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u306e\u30af\u30e9\u30c3\u30b7\u30e5\u539f\u56e0\u3092\u7279\u5b9a\u3059\u308b\u305f\u3081\u306e\u3082\u306e\u3067\u3059\u3002\u305f\u3060\u3057 mod \u306e\u9006\u30b3\u30f3\u30d1\u30a4\u30eb\u306f\u5834\u5408\u306b\u3088\u3063\u3066\u5fc5\u8981\u3068\u306a\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u304c\u3001\u751f\u6210\u3055\u308c\u305f\u30b3\u30fc\u30c9\u3092\u7528\u3044\u3066\u8457\u4f5c\u6a29\u6cd5\u306b\u9055\u53cd\u3057\u306a\u3044\u3088\u3046\u3054\u6ce8\u610f\u304f\u3060\u3055\u3044\u3002\u30b3\u30fc\u30c9\u3092\u4f7f\u7528\u3059\u308b\u524d\u306b\u3001\u8a72\u5f53 mod \u306e\u30e9\u30a4\u30bb\u30f3\u30b9\u3092\u78ba\u8a8d\u3059\u308b\u3053\u3068\u3092\u63a8\u5968\u3057\u307e\u3059\u3002\u591a\u304f\u306e mod \u306f\u516c\u5f0f\u306b\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u3092\u516c\u958b\u3057\u3066\u304a\u308a\u3001\u3053\u308c\u306f\u9006\u30b3\u30f3\u30d1\u30a4\u30eb\u7d50\u679c\u3068\u6bd4\u3079\u3066\u901a\u5e38\u3001\u3088\u308a\u660e\u78ba\u3067\u7406\u89e3\u3057\u3084\u3059\u3044\u3067\u3059\u3002\u77e5\u7684\u8ca1\u7523\u6a29\u304a\u3088\u3073\u30e9\u30a4\u30bb\u30f3\u30b9\u3078\u306e\u914d\u616e\u306f\u3001mod \u958b\u767a\u30b3\u30df\u30e5\u30cb\u30c6\u30a3\u306b\u3068\u3063\u3066\u4e0d\u53ef\u6b20\u3067\u3059\u3002\u30e1\u30ad\u30b7\u30b3\u9023\u90a6\u8457\u4f5c\u6a29\u6cd5\u306b\u3064\u3044\u3066\u306f\u4ee5\u4e0b\u3092\u3054\u53c2\u7167\u304f\u3060\u3055\u3044\uff1a<a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor\uff08\u30b9\u30da\u30a4\u30f3\u8a9e\uff09</a>\u3001\u82f1\u8a9e\u7248\u306f\u3053\u3061\u3089\uff1a<a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (English)</a>\u3002CurseForge \u4e0a\u3067\u306e\u5229\u7528\u3092\u8003\u616e\u3057\u3001\u7c73\u56fd\u8457\u4f5c\u6a29\u6cd5\u3082\u4ee5\u4e0b\u306b\u793a\u3057\u307e\u3059\uff1a<a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>\u3002\u307e\u305f\u3001\u30e6\u30fc\u30b6\u30fc\u3054\u81ea\u8eab\u306e\u5c45\u4f4f\u5730\u306b\u9069\u7528\u3055\u308c\u308b\u6cd5\u5f8b\u3092\u5fc5\u305a\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002\u672c GUI \u306f\u7c21\u6613\u8a3a\u65ad\u5c02\u7528\u3067\u3059\u3002\u8a73\u7d30\u306a\u89e3\u6790\u306b\u306f FabricMC \u7248 Enigma \u3092\u3054\u5229\u7528\u304f\u3060\u3055\u3044\uff1a<a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>\u3002\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u304c\u516c\u958b\u3055\u308c\u3066\u3044\u306a\u3044\u5834\u5408\u306b JAR \u30d5\u30a1\u30a4\u30eb\u3092\u76f4\u63a5\u7de8\u96c6\u3057\u3066\u30d1\u30c3\u30c1\u3092\u4f5c\u308b\u306b\u306f\u3001Recaf \u3092\u3054\u691c\u8a0e\u304f\u3060\u3055\u3044\uff1a<a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">\u516c\u5f0f\u30b5\u30a4\u30c8</a>\u3002";
    }

    @Override
    public String botonDescargarCfr() {
        return "CFR \u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f";
    }

    @Override
    public String colorFondoPrincipal() {
        return "\u30e1\u30a4\u30f3\u80cc\u666f\u8272";
    }

    @Override
    public String colorTextoBotonReset() {
        return "\u30ea\u30bb\u30c3\u30c8\u30dc\u30bf\u30f3\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "\u691c\u7d22\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "\u30d5\u30a3\u30eb\u30bf\u30fc\u306e\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u6587\u5b57\u8272";
    }

    @Override
    public String colorTextoRenderer() {
        return "\u30ec\u30f3\u30c0\u30e9\u30fc\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "\u30ed\u30fc\u30c9\u30aa\u30fc\u30d0\u30fc\u30ec\u30a4\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorBorde() {
        return "\u67a0\u7dda\u306e\u8272";
    }

    @Override
    public String colorFondoRetrato() {
        return "\u30dd\u30fc\u30c8\u30ec\u30fc\u30c8\u30e2\u30fc\u30c9\u306e\u80cc\u666f\u8272";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "\u5171\u6709\u30ea\u30f3\u30af\u306e\u8272";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "\u5171\u6709\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u80cc\u666f\u8272";
    }

    @Override
    public String rosaFondo() {
        return "\u80cc\u666f\u30d4\u30f3\u30af";
    }

    @Override
    public String rosaSuave() {
        return "\u30bd\u30d5\u30c8\u30d4\u30f3\u30af";
    }

    @Override
    public String moradoAcento() {
        return "\u30a2\u30af\u30bb\u30f3\u30c8\u30d1\u30fc\u30d7\u30eb";
    }

    @Override
    public String textoOscuro() {
        return "\u30c0\u30fc\u30af\u30c6\u30ad\u30b9\u30c8";
    }

    @Override
    public String bordeSuave() {
        return "\u30bd\u30d5\u30c8\u30dc\u30fc\u30c0\u30fc";
    }

    @Override
    public String fondoCampo() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9\u80cc\u666f";
    }

    @Override
    public String fondoVistaPrevia() {
        return "\u30d7\u30ec\u30d3\u30e5\u30fc\u80cc\u666f";
    }

    @Override
    public String sintaxisConstructor() {
        return "\u69cb\u6587\u8272: \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "\u69cb\u6587\u8272: \u30d8\u30eb\u30d7\u30e1\u30c3\u30bb\u30fc\u30b8";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "\u69cb\u6587\u8272: HTML\u30bf\u30b0";
    }

    @Override
    public String colorFondoVentana() {
        return "\u30a6\u30a3\u30f3\u30c9\u30a6\u80cc\u666f\u8272";
    }

    @Override
    public String colorPanel() {
        return "\u30d1\u30cd\u30eb\u8272";
    }

    @Override
    public String colorBotonTexto() {
        return "\u30dc\u30bf\u30f3\u6587\u5b57\u8272";
    }

    @Override
    public String colorCampo() {
        return "\u30d5\u30a3\u30fc\u30eb\u30c9\u8272";
    }

    @Override
    public String colorBordeDestacado() {
        return "\u5f37\u8abf\u67a0\u7dda\u8272";
    }

    @Override
    public String colorSeleccionTexto() {
        return "\u30c6\u30ad\u30b9\u30c8\u9078\u629e\u80cc\u666f\u8272";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "\u9078\u629e\u3055\u308c\u305f\u30c6\u30ad\u30b9\u30c8\u306e\u8272";
    }

    @Override
    public String colorEstadoExito() {
        return "\u30b9\u30c6\u30fc\u30bf\u30b9\u8272: \u6210\u529f";
    }

    @Override
    public String colorEstadoFallo() {
        return "\u30b9\u30c6\u30fc\u30bf\u30b9\u8272: \u5931\u6557";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "\u30b9\u30c6\u30fc\u30bf\u30b9\u8272: \u5373\u6642";
    }

    @Override
    public String colorResultadoAnadido() {
        return "\u8ffd\u52a0\u3055\u308c\u305f\u7d50\u679c\u306e\u8272";
    }

    @Override
    public String colorResultadoEliminado() {
        return "\u524a\u9664\u3055\u308c\u305f\u7d50\u679c\u306e\u8272";
    }

    @Override
    public String colorBordeScroll() {
        return "\u30b9\u30af\u30ed\u30fc\u30eb\u30d0\u30fc\u306e\u67a0\u7dda\u8272";
    }

    @Override
    public String colorFondoPanel() {
        return "\u30d1\u30cd\u30eb\u80cc\u666f\u8272";
    }

    @Override
    public String colorBeigeListas() {
        return "\u30ea\u30b9\u30c8\u30d9\u30fc\u30b8\u30e5";
    }

    @Override
    public String colorTextoListas() {
        return "\u30ea\u30b9\u30c8\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorBordeListas() {
        return "\u30ea\u30b9\u30c8\u306e\u67a0\u7dda\u8272";
    }

    @Override
    public String colorBotonFondo() {
        return "\u30dc\u30bf\u30f3\u306e\u80cc\u666f\u8272";
    }

    @Override
    public String colorBordeBoton() {
        return "\u30dc\u30bf\u30f3\u306e\u67a0\u7dda\u8272";
    }

    @Override
    public String colorDoradoTexto() {
        return "\u91d1\u8272\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorPila() {
        return "\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u306e\u8272";
    }

    @Override
    public String colorTextoPanel() {
        return "\u30d1\u30cd\u30eb\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorTextoNegro() {
        return "\u9ed2\u8272\u6587\u5b57";
    }

    @Override
    public String colorTextoPrincipal() {
        return "\u30e1\u30a4\u30f3\u6587\u5b57\u8272";
    }

    @Override
    public String colorFondoResultados() {
        return "\u7d50\u679c\u306e\u80cc\u666f\u8272";
    }

    @Override
    public String colorEstado() {
        return "\u30b9\u30c6\u30fc\u30bf\u30b9\u8272";
    }

    @Override
    public String colorTextoDescripcion() {
        return "\u8aac\u660e\u6587\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String colorTextoEstado() {
        return "\u30b9\u30c6\u30fc\u30bf\u30b9\u6587\u5b57\u8272";
    }

    @Override
    public String colorTextoExtra() {
        return "\u8ffd\u52a0\u6587\u5b57\u8272";
    }

    @Override
    public String colorSeparador() {
        return "\u533a\u5207\u308a\u7dda\u306e\u8272";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "\u30cd\u30a4\u30c6\u30a3\u30d6\u30a8\u30e9\u30fc <code>StubRoutines::SafeFetch32</code> \u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u3053\u306e\u554f\u984c\u306f macOS \u3067 JDK 17.0.9 \u3092\u4f7f\u7528\u6642\u306b\u767a\u751f\u3057\u3001JDK 17.0.10 \u4ee5\u964d\u3067\u4fee\u6b63\u3055\u308c\u3066\u3044\u307e\u3059\u3002https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "JDK 17.0.9 (macOS) \u3067\u306e SafeFetch32 \u30cd\u30a4\u30c6\u30a3\u30d6\u30a8\u30e9\u30fc";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "JDK \u3092 17.0.10 \u4ee5\u964d\uff08\u4f8b: 17.0.15\uff09\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "MultiMC\u3001Prism Launcher\u3001TLauncher \u306a\u3069\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u65b0\u3057\u3044 JDK \u3092\u4f7f\u3046\u3088\u3046\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e00\u90e8\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u306f\u3059\u3067\u306b JDK 17.0.15 \u3092\u5185\u8535\u3057\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "Spark mod \u3082\u3053\u306e\u30a8\u30e9\u30fc\u306e\u4e00\u56e0\u3068\u306a\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u4e00\u6642\u7684\u306b\u7121\u52b9\u5316\u3092\u691c\u8a0e\u3057\u3066\u304f\u3060\u3055\u3044\u3002https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MCEF \u30e2\u30c3\u30c9\uff08Chromium Embedded Framework\uff09\u304c\u7121\u97f3\u30d5\u30ea\u30fc\u30ba\u3092\u5f15\u304d\u8d77\u3053\u3057\u3066\u3044\u307e\u3059\u3002</b><ul><li>MCEF \u304c\u30ed\u30b0\u306e\u6700\u5f8c\u3067\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u3053\u308c\u306f\u901a\u5e38\u3001\u30ed\u30fc\u30c9\u4e2d\u306b\u30b2\u30fc\u30e0\u304c\u30d5\u30ea\u30fc\u30ba\u3057\u305f\u3053\u3068\u3092\u610f\u5473\u3057\u307e\u3059\u3002</li><li>\u3053\u306e mod \u306f Linux \u3084 macOS\u3001\u307e\u305f\u306f\u7279\u5b9a\u306e Java \u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u30af\u30e9\u30c3\u30b7\u30e5\u3092\u5f15\u304d\u8d77\u3053\u3059\u3053\u3068\u304c\u77e5\u3089\u308c\u3066\u3044\u307e\u3059\u3002</li><li>\u660e\u78ba\u306a\u30a8\u30e9\u30fc\u304c\u5e38\u306b\u8868\u793a\u3055\u308c\u308b\u308f\u3051\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u304c\u3001\u30b2\u30fc\u30e0\u306f\u30e1\u30a4\u30f3\u30e1\u30cb\u30e5\u30fc\u306b\u5230\u9054\u3057\u307e\u305b\u3093\u3002</li></ul><p>\u30b2\u30fc\u30e0\u5185\u30d6\u30e9\u30a6\u30b6\u6a5f\u80fd\uff08Web \u30de\u30c3\u30d7\u3084\u57cb\u3081\u8fbc\u307f\u30da\u30fc\u30b8\u306a\u3069\uff09\u304c\u4e0d\u8981\u3067\u3042\u308c\u3070\u3001\u3053\u306e mod \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "MCEF \u521d\u671f\u5316\u554f\u984c\uff08\u57cb\u3081\u8fbc\u307f\u30d6\u30e9\u30a6\u30b6 mod\uff09";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "'mods' \u30d5\u30a9\u30eb\u30c0\u304b\u3089 MCEF mod \u30d5\u30a1\u30a4\u30eb\uff08\u30d5\u30a1\u30a4\u30eb\u540d\u306b 'mcef' \u3092\u542b\u3080\uff09\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "\u3069\u3046\u3057\u3066\u3082\u5fc5\u8981\u306a\u5834\u5408\u306f\u3001\u304a\u4f7f\u3044\u306e OS \u3068 Minecraft \u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u4e92\u63db\u6027\u306e\u3042\u308b MCEF \u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>OptiFine</b> \u3068 <b>Iris/Oculus</b> \u306e\u9593\u306b\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><ul><li>OptiFine \u306f\u3001Iris \u3084 Oculus \u3068\u975e\u4e92\u63db\u306a\u65b9\u6cd5\u3067 Minecraft \u306e\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u3092\u5909\u66f4\u3057\u307e\u3059\u3002</li><li>\u30a8\u30e9\u30fc <code>MixinLevelRenderer failed injection check</code> \u306f <code>mixins.iris.json</code> \u307e\u305f\u306f <code>mixins.oculus.json</code> \u306b\u7531\u6765\u3057\u307e\u3059\u3002</li></ul><p>\u3053\u308c\u3089\u306e mod \u306f\u540c\u6642\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002Iris \u307e\u305f\u306f Oculus \u3067\u30b7\u30a7\u30fc\u30c0\u30fc\u3092\u4f7f\u7528\u3059\u308b\u306b\u306f\u3001OptiFine \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "OptiFine \u3068 Iris/Oculus \u306e\u7af6\u5408";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "'mods' \u30d5\u30a9\u30eb\u30c0\u304b\u3089 OptiFine \u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "\u6700\u65b0\u306e\u30b7\u30a7\u30fc\u30c0\u30fc\u3092\u697d\u3057\u3080\u306b\u306f\u3001OptiFine \u3092\u4f7f\u7528\u305b\u305a Iris \u307e\u305f\u306f Oculus \u3092\u5229\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>ModernFix</b> \u3068 <b>OptiFine</b> \u306e\u9593\u306b\u7af6\u5408\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><ul><li>ModernFix \u306f Forge \u306e\u6a5f\u80fd\u3092\u7834\u58ca\u3057\u8d77\u52d5\u3092\u9045\u304f\u3059\u308b\u305f\u3081\u3001OptiFine \u3068\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002</li><li>ModernFix \u81ea\u4f53\u304c\u8b66\u544a\u3057\u3066\u3044\u307e\u3059: <i>\"Use of ModernFix with OptiFine is not supported\"</i>\u3002</li></ul><p>\u30b2\u30fc\u30e0\u3092\u6b63\u5e38\u306b\u52d5\u4f5c\u3055\u305b\u308b\u306b\u306f\u3001\u3069\u3061\u3089\u304b\u4e00\u65b9\u306e mod \u3092\u524a\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "ModernFix \u3068 OptiFine \u306e\u7af6\u5408";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "'mods' \u30d5\u30a9\u30eb\u30c0\u304b\u3089 OptiFine \u307e\u305f\u306f ModernFix \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e21\u7acb\u3067\u304d\u307e\u305b\u3093\u3002";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "\u6700\u9069\u5316\u304c\u5fc5\u8981\u306a\u5834\u5408\u306f\u3001OptiFine \u306e\u307f\u3092\u4f7f\u7528\u3059\u308b\u304b\u3001ModernFix \u3092 FerriteCore \u3084 EntityCulling \u306e\u3088\u3046\u306a\u8efd\u91cf mod \u306b\u7f6e\u304d\u63db\u3048\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30a8\u30e9\u30fc: \u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u3092\u542b\u3080\u7121\u52b9\u306a\u30ec\u30b8\u30b9\u30c8\u30ea\u30ad\u30fc\u3067\u3059\u3002</b><ul><li><b>\u691c\u51fa\u3055\u308c\u305f\u30ad\u30fc:</b> <code>" + this.escapeHtml(clave) + "</code></li><li>Minecraft \u3067\u306f\u3001\u3059\u3079\u3066\u306e\u30ec\u30b8\u30b9\u30c8\u30ea\u30ad\u30fc\uff08\u30bf\u30b0\u3001\u30ec\u30b7\u30d4\u3001\u5b9f\u7e3e\u306a\u3069\uff09\u306f<b>\u5c0f\u6587\u5b57</b>\u3067\u3001\u82f1\u6570\u5b57\u3001\u30a2\u30f3\u30c0\u30fc\u30b9\u30b3\u30a2\u3001\u30cf\u30a4\u30d5\u30f3\u3001\u30b9\u30e9\u30c3\u30b7\u30e5\u306e\u307f\u3092\u4f7f\u7528\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001\u901a\u5e38\u3001\u4e0d\u9069\u5207\u306b\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u3055\u308c\u305f mod \u307e\u305f\u306f\u6b20\u9665\u306e\u3042\u308b datapack \u306b\u3088\u3063\u3066\u767a\u751f\u3057\u307e\u3059\u3002</li></ul><p><b>\u91cd\u8981\u30d2\u30f3\u30c8:</b> \u30b5\u30a4\u30c9\u30d0\u30fc\u306e <b>grepr</b> \u307e\u305f\u306f <b>fgrepr</b> \u30c4\u30fc\u30eb\u3092\u4f7f\u3044\u3001<b>\u300cJAR \u30d5\u30a1\u30a4\u30eb\u5185\u3092\u691c\u7d22\u300d</b>\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u6709\u52b9\u306b\u3057\u3066\u3001\u3053\u306e\u7121\u52b9\u306a\u30ad\u30fc\u3092\u542b\u3080 mod \u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "\u5927\u6587\u5b57\u307e\u305f\u306f\u7121\u52b9\u306a\u6587\u5b57\u3092\u542b\u3080\u30ec\u30b8\u30b9\u30c8\u30ea\u30ad\u30fc";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "\u300cJAR \u30d5\u30a1\u30a4\u30eb\u5185\u3092\u691c\u7d22\u300d\u30aa\u30d7\u30b7\u30e7\u30f3\u4ed8\u304d\u3067 'grepr' \u307e\u305f\u306f 'fgrepr' \u3092\u4f7f\u7528\u3057\u3001\u554f\u984c\u306e mod \u3092\u7279\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "mod \u3092\u7279\u5b9a\u3067\u304d\u306a\u3044\u5834\u5408\u306f\u3001\u7279\u306b\u30d6\u30ed\u30c3\u30af\u3001\u30a2\u30a4\u30c6\u30e0\u3001\u30c4\u30fc\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u6700\u8fd1\u5c0e\u5165\u3057\u305f mod \u3092\u524a\u9664\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>mod <b>" + this.escapeHtml(modNombre) + "</b> \u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002</b><ul><li>\u3053\u306e mod \u306f\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\uff08\u4f8b: \u8a2d\u5b9a\u30e1\u30cb\u30e5\u30fc\uff09\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002</li><li>\u3053\u308c\u306f\u901a\u5e38\u3001Minecraft \u3084 Fabric\u3001\u307e\u305f\u306f\u4ed6\u306e mod \u3068\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u4e0d\u6574\u5408\u306b\u3088\u3063\u3066\u767a\u751f\u3057\u307e\u3059\u3002</li></ul><p>\u30a8\u30e9\u30fc\u304c\u7d9a\u304f\u5834\u5408\u306f\u3001mod <b>" + this.escapeHtml(modNombre) + "</b> \u3092\u524a\u9664\u307e\u305f\u306f\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "mod \u521d\u671f\u5316\u30a8\u30e9\u30fc (Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "'mods' \u30d5\u30a9\u30eb\u30c0\u304b\u3089 mod '" + modNombre + "' \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "mod '" + modNombre + "' \u3092\u73fe\u5728\u306e\u74b0\u5883\u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>En Garde!</b> \u30e2\u30c3\u30c9\u306b\u95a2\u9023\u3059\u308b\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><ul><li>\u3053\u306e mod \u306f\u767d\u5175\u6226\u306e\u30e1\u30ab\u30cb\u30af\u30b9\uff08\u30d1\u30ea\u30a3\u3001\u30d6\u30ed\u30c3\u30ad\u30f3\u30b0\u306a\u3069\uff09\u3092\u8ffd\u52a0\u3057\u307e\u3059\u3002</li><li>\u3053\u306e\u30a8\u30e9\u30fc\u306f\u3001\u901a\u5e38\u3001\u4ed6\u306e\u6226\u95d8 mod\uff08Epic Fight\u3001DualRiders \u306a\u3069\uff09\u3068\u306e\u975e\u4e92\u63db\u3001\u307e\u305f\u306f Minecraft \u306b\u5408\u308f\u306a\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u4f7f\u7528\u306b\u3088\u3063\u3066\u767a\u751f\u3057\u307e\u3059\u3002</li></ul><p>\u9ad8\u5ea6\u306a\u6226\u95d8\u30b7\u30b9\u30c6\u30e0\u3092\u4f7f\u7528\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u7af6\u5408\u3092\u907f\u3051\u308b\u305f\u3081\u306b En Garde! \u3092\u524a\u9664\u3059\u308b\u3053\u3068\u3092\u691c\u8a0e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "En Garde! \u30e2\u30c3\u30c9\u30a8\u30e9\u30fc";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "\u4f7f\u7528\u4e2d\u306e Minecraft \u30d0\u30fc\u30b8\u30e7\u30f3\u304a\u3088\u3073\u30ed\u30fc\u30c0\u30fc\uff08Fabric/Forge\uff09\u3068\u4e92\u63db\u6027\u306e\u3042\u308b En Garde! \u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "\u4ed6\u306e\u6226\u95d8 mod\uff08Epic Fight\u3001Caelus \u306a\u3069\uff09\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u305d\u308c\u3089\u3092\u7121\u52b9\u5316\u3059\u308b\u304b\u3001En Garde! \u3092\u524a\u9664\u3057\u3066\u7af6\u5408\u3092\u56de\u907f\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'><b>IdleTweaks</b> \u30e2\u30c3\u30c9\u306b\u3088\u3063\u3066\u5f15\u304d\u8d77\u3053\u3055\u308c\u305f\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><ul><li>IdleTweaks \u306f\u3001\u3082\u306f\u3084\u5b58\u5728\u3057\u306a\u3044\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30c1\u30e3\u30cd\u30eb\u306e\u89e3\u653e\u3092\u8a66\u307f\u307e\u3057\u305f (<code>Tried to release unknown channel</code>)\u3002</li><li>\u3053\u306e\u30a8\u30e9\u30fc\u306f\u901a\u5e38\u3001\u30e2\u30c3\u30c9\u306e\u53e4\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u3084\u3001\u8a2d\u5b9a\u304c\u4e0d\u9069\u5207\u306a\u30b5\u30fc\u30d0\u30fc\u3067\u767a\u751f\u3057\u307e\u3059\u3002</li></ul><p>IdleTweaks \u306f\u30af\u30aa\u30ea\u30c6\u30a3\u30fb\u30aa\u30d6\u30fb\u30e9\u30a4\u30d5\u7cfb mod \u3067\u3059\u304c\u3001\u4e0d\u5b89\u5b9a\u3055\u3092\u5f15\u304d\u8d77\u3053\u3059\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002\u66f4\u65b0\u307e\u305f\u306f\u524a\u9664\u3092\u691c\u8a0e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "IdleTweaks \u30a8\u30e9\u30fc\uff08\u4e0d\u660e\u306a\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30c1\u30e3\u30cd\u30eb\uff09";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "IdleTweaks \u3092\u3001\u4f7f\u7528\u4e2d\u306e Minecraft \u3068\u4e92\u63db\u6027\u306e\u3042\u308b\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "\u4e0d\u8981\u3067\u3042\u308c\u3070\u3001'mods' \u30d5\u30a9\u30eb\u30c0\u304b\u3089 IdleTweaks \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Minecraft \u3078\u306e\u30ed\u30b0\u30a4\u30f3\u4e2d\u306b\u8a8d\u8a3c\u30a8\u30e9\u30fc (HTTP 401) \u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><p>\u3053\u306e\u30a8\u30e9\u30fc\u306f<b>\u30af\u30e9\u30c3\u30b7\u30e5\u306e\u76f4\u63a5\u7684\u539f\u56e0\u3068\u306a\u308b\u3053\u3068\u306f\u7a00</b>\u3067\u3059\u304c\u3001\u8a8d\u8a3c\u3055\u308c\u3066\u3044\u306a\u3044\u30a2\u30ab\u30a6\u30f3\u30c8\uff08\u6d77\u8cca\u7248\uff09\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u3053\u3068\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002</p><p>\u516c\u5f0f\u30b5\u30dd\u30fc\u30c8\u30c1\u30e3\u30f3\u30cd\u30eb\uff08\u4f01\u696d\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3001VTuber\u3001modpack \u4f5c\u6210\u8005\u306a\u3069\uff09\u306f\u3001\u6d77\u8cca\u7248\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001<b>\u30b5\u30dd\u30fc\u30c8\u3067\u304d\u307e\u305b\u3093</b>\u3002\u3053\u308c\u306f\u30c1\u30e3\u30c3\u30c8\u30eb\u30fc\u30eb\u3001\u5951\u7d04\u3001Mojang/Microsoft \u3068\u306e\u5354\u5b9a\u3001\u307e\u305f\u306f\u8a55\u5224\u30dd\u30ea\u30b7\u30fc\u306b\u3088\u308b\u5236\u9650\u306e\u305f\u3081\u3067\u3059\u3002</p><p>\u3053\u306e\u30c1\u30a7\u30c3\u30af\u306f\u691c\u51fa\u5668\u306e<b>\u4f01\u696d\u5411\u3051\u8a2d\u5b9a\u3067\u7121\u52b9\u5316</b>\u3067\u304d\u307e\u3059\u3002\u8b66\u544a\uff1a\u6d77\u8cca\u7248\u691c\u51fa\u6a5f\u80fd\u306f<b>\u5b8c\u74a7\u3067\u306f\u3042\u308a\u307e\u305b\u3093</b>\u3002\u958b\u767a\u74b0\u5883\u3001\u4e0d\u5b89\u5b9a\u306a\u30a4\u30f3\u30bf\u30fc\u30cd\u30c3\u30c8\u63a5\u7d9a\u3001\u6539\u9020\u30e9\u30f3\u30c1\u30e3\u30fc\u4f7f\u7528\u6642\u306b\u8aa4\u691c\u51fa\u3055\u308c\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>\u305d\u308c\u3067\u3082\u30b5\u30dd\u30fc\u30c8\u306b\u53c2\u52a0\u3057\u3088\u3046\u3068\u3059\u308b\u5834\u5408\u306e\u30df\u30e9\u30f3\u30c0\u8b66\u544a:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "\u6d77\u8cca\u7248 Minecraft";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "\u6d77\u8cca\u7248\u691c\u51fa\u3092\u7121\u52b9\u5316";
    }

    @Override
    public String comprarMC() {
        return "Minecraft \u3092\u8cfc\u5165";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u3042\u306a\u305f\u306f\u63a8\u5968\u30ea\u30b9\u30c8\u306b<b>\u542b\u307e\u308c\u3066\u3044\u306a\u3044</b>\u30e9\u30f3\u30c1\u30e3\u30fc <code>" + id + "</code> \u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>\u52d5\u4f5c\u3059\u308b\u5834\u5408\u3082\u3042\u308a\u307e\u3059\u304c\u3001\u975e\u63a8\u5968\u30e9\u30f3\u30c1\u30e3\u30fc\u306f\u6b21\u306e\u3088\u3046\u306a\u554f\u984c\u3092\u5f15\u304d\u8d77\u3053\u3059\u3053\u3068\u304c\u3042\u308a\u307e\u3059:</p><ul><li>mod \u3084\u30a2\u30d7\u30ea\u306e\u7834\u640d\u3057\u305f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3002</li><li>\u30b2\u30fc\u30e0\u304c\u8d77\u52d5\u3057\u306a\u3044\u3001\u307e\u305f\u306f\u660e\u78ba\u306a\u30a8\u30e9\u30fc\u306a\u3057\u306b\u30d5\u30ea\u30fc\u30ba\u3002</li><li>\u7570\u5e38\u306a\u30d5\u30a9\u30eb\u30c0\u69cb\u6210\uff08\u8a3a\u65ad\u304c\u56f0\u96e3\uff09\u3002</li><li>Java\u3001\u30e1\u30e2\u30ea\u3001mod \u306b\u95a2\u3059\u308b\u4e88\u6e2c\u4e0d\u80fd\u306a\u52d5\u4f5c\u3002</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "\u3088\u308a\u826f\u3044\u4f53\u9a13\u306e\u305f\u3081\u306b\u3001\u4ee5\u4e0b\u306e\u63a8\u5968\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u3044\u305a\u308c\u304b\u3092\u3054\u5229\u7528\u304f\u3060\u3055\u3044:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "\u975e\u63a8\u5968\u30e9\u30f3\u30c1\u30e3\u30fc";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "\u63a8\u5968\u30ea\u30b9\u30c8\u306b\u3042\u308b\u30e9\u30f3\u30c1\u30e3\u30fc\u306b\u5207\u308a\u66ff\u3048\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u3042\u306a\u305f\u306f<b>\u4f7f\u7528\u304c\u63a8\u5968\u3055\u308c\u306a\u3044\u30e9\u30f3\u30c1\u30e3\u30fc</b>\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>\u4f7f\u7528\u304c\u63a8\u5968\u3055\u308c\u306a\u3044\u30e9\u30f3\u30c1\u30e3\u30fc\u306f\u3001\u6b21\u306e\u3088\u3046\u306a\u554f\u984c\u3092\u5f15\u304d\u8d77\u3053\u3059\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059:</p><ul><li>\u30a2\u30d7\u30ea\u3084 mod \u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u304c\u7834\u640d\u3002</li><li>\u30b2\u30fc\u30e0\u304c\u8d77\u52d5\u3057\u306a\u3044\u3001\u307e\u305f\u306f\u30b5\u30a4\u30ec\u30f3\u30c8\u30af\u30e9\u30c3\u30b7\u30e5\u3002</li><li>\u7570\u5e38\u306a\u30d5\u30a1\u30a4\u30eb\u69cb\u6210\uff08\u30c7\u30d0\u30c3\u30b0\u304c\u56f0\u96e3\uff09\u3002</li><li>mod \u3084 Java\u3001\u30e1\u30e2\u30ea\u306e\u7ba1\u7406\u65b9\u6cd5\u304c\u4e0d\u660e\u78ba\u3002</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "\u4ee5\u4e0b\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u306e\u3044\u305a\u308c\u304b\u306e\u4f7f\u7528\u3092\u5f37\u304f\u63a8\u5968\u3057\u307e\u3059:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "\u4f7f\u7528\u304c\u63a8\u5968\u3055\u308c\u306a\u3044\u30e9\u30f3\u30c1\u30e3\u30fc";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "\u30b5\u30dd\u30fc\u30c8\u3092\u53d7\u3051\u308b\u306b\u306f\u3001\u63a8\u5968\u30e9\u30f3\u30c1\u30e3\u30fc\u306b\u5207\u308a\u66ff\u3048\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u3053\u306e\u74b0\u5883\u306b\u63a8\u5968\u3055\u308c\u308b mod \u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "\u63a8\u5968 mod \u304c\u4e0d\u8db3";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "\u6700\u9069\u306a\u4f53\u9a13\u306e\u305f\u3081\u306b\u3001\u63a8\u5968 mod \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u306b\u63a8\u5968\u3055\u308c\u306a\u3044 mod \u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "\u63a8\u5968\u3055\u308c\u306a\u3044 mod \u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "\u554f\u984c\u3092\u56de\u907f\u3059\u308b\u306b\u306f\u3001\u63a8\u5968\u3055\u308c\u306a\u3044 mod \u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u91cd\u8981\u306a\u30d5\u30a1\u30a4\u30eb\u306b\u4e0d\u6b63\u306a\u6539\u5909\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u624b\u52d5\u3067\u30d5\u30a1\u30a4\u30eb\u3092\u7de8\u96c6\u3057\u305f\u304b\u3001\u4fe1\u983c\u3067\u304d\u306a\u3044\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "\u6539\u5909\u3092\u691c\u51fa";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "\u6574\u5408\u6027\u3092\u56de\u5fa9\u3059\u308b\u306b\u306f\u3001\u5143\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u518d\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String configuracionCorporativa() {
        return "\u4f01\u696d\u5411\u3051\u8a2d\u5b9a";
    }

    @Override
    public String idiomaRespaldo() {
        return "\u30d5\u30a9\u30fc\u30eb\u30d0\u30c3\u30af\u8a00\u8a9e";
    }

    @Override
    public String buscardorHabilitado() {
        return "\u691c\u7d22\u6a5f\u80fd\u3092\u6709\u52b9\u5316";
    }

    @Override
    public String nombreHerramienta() {
        return "\u30c4\u30fc\u30eb\u540d";
    }

    @Override
    public String condenarPirateria() {
        return "\u6d77\u8cca\u7248\u3092\u975e\u96e3";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "\u63a8\u5968\u30e9\u30f3\u30c1\u30e3\u30fc";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "\u975e\u63a8\u5968\u30e9\u30f3\u30c1\u30e3\u30fc";
    }

    @Override
    public String modsRecomendados() {
        return "\u63a8\u5968 mod";
    }

    @Override
    public String modsDesaconsejados() {
        return "\u975e\u63a8\u5968 mod";
    }

    @Override
    public String antiTamper() {
        return "\u6539\u3056\u3093\u9632\u6b62";
    }

    @Override
    public String proximamente() {
        return "\u8fd1\u65e5\u516c\u958b";
    }

    @Override
    public String informacion() {
        return "\u60c5\u5831";
    }

    @Override
    public String errorCargandoImagen() {
        return "\u753b\u50cf\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc";
    }

    @Override
    public String configuracionBasica() {
        return "\u57fa\u672c\u8a2d\u5b9a";
    }

    @Override
    public String funcionalidades() {
        return "\u6a5f\u80fd";
    }

    @Override
    public String derechosMiranda() {
        return "\u30df\u30e9\u30f3\u30c0\u8b66\u544a\uff08\u5f37\u304f\u63a8\u5968\uff09";
    }

    @Override
    public String gestionVerificaciones() {
        return "\u691c\u8a3c\u7ba1\u7406";
    }

    @Override
    public String idVerificacion() {
        return "ID";
    }

    @Override
    public String nombreVerificacion() {
        return "\u540d\u524d";
    }

    @Override
    public String codigoVerificacion() {
        return "\u30b3\u30fc\u30c9";
    }

    @Override
    public String documentacionVerificacion() {
        return "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "\u6709\u52b9\u306a\u691c\u8a3c:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "\u7121\u52b9\u306a\u691c\u8a3c:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "\u975e\u4f01\u696d\u5411\u3051\u691c\u8a3c\u3092\u3059\u3079\u3066\u7121\u52b9\u5316";
    }

    @Override
    public String verCodigo() {
        return "\u30b3\u30fc\u30c9\u3092\u8868\u793a";
    }

    @Override
    public String verDocumentacion() {
        return "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u8868\u793a";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "\u7121\u52b9\u5316\u3059\u308b\u691c\u8a3c\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "\u6709\u52b9\u5316\u3059\u308b\u691c\u8a3c\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "\u4f01\u696d\u5229\u7528\u306b\u63a8\u5968\u3055\u308c\u306a\u3044\u691c\u8a3c %d \u4ef6\u304c\u7121\u52b9\u5316\u3055\u308c\u307e\u3057\u305f\u3002";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "\u7121\u52b9\u5316\u53ef\u80fd\u306a\u975e\u4f01\u696d\u5411\u3051\u691c\u8a3c\u306f\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    @Override
    public String operacionCompletada() {
        return "\u64cd\u4f5c\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "Amane Kanata\u3001\u4f1a\u3044\u305f\u3044\u3088";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "\u4f01\u696d\u691c\u8a3c\u306e\u8272";
    }

    @Override
    public String nombreLanzador() {
        return "\u30e9\u30f3\u30c1\u30e3\u30fc\u540d";
    }

    @Override
    public String motivo() {
        return "\u7406\u7531";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "\u975e\u63a8\u5968\u30e9\u30f3\u30c1\u30e3\u30fc";
    }

    @Override
    public String moverADesaconsejados() {
        return "\u975e\u63a8\u5968\u306b\u8a2d\u5b9a";
    }

    @Override
    public String moverARecomendados() {
        return "\u63a8\u5968\u306b\u8a2d\u5b9a";
    }

    @Override
    public String guardarCambios() {
        return "\u5909\u66f4\u3092\u4fdd\u5b58";
    }

    @Override
    public String cancelar() {
        return "\u30ad\u30e3\u30f3\u30bb\u30eb";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "\u79fb\u52d5\u3059\u308b\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\u5909\u66f4\u304c\u6b63\u5e38\u306b\u4fdd\u5b58\u3055\u308c\u307e\u3057\u305f\uff01";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "\u7406\u7531";
    }

    @Override
    public String agregarLanzador() {
        return "\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u8ffd\u52a0";
    }

    @Override
    public String quitarLanzador() {
        return "\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u524a\u9664";
    }

    @Override
    public String editarRazones() {
        return "\u7406\u7531\u3092\u7de8\u96c6";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "\u524a\u9664\u3059\u308b\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "\u7de8\u96c6\u3059\u308b\u30e9\u30f3\u30c1\u30e3\u30fc\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return idLanzador + " \u306e\u7406\u7531\u3092\u7de8\u96c6";
    }

    @Override
    public String agregarNuevoIdioma() {
        return "\u65b0\u3057\u3044\u8a00\u8a9e\u3092\u8ffd\u52a0";
    }

    @Override
    public String aceptar() {
        return "OK";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "\u8a00\u8a9e\u3092\u9078\u629e";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "\u3053\u308c\u3089\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u306f\u3001CrashDetector \u304c\u826f\u597d\u3068\u63a8\u5968\u3059\u308b\u3082\u306e\u3067\u3059\u3002";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "\u6b63\u5e38\u306a\u7d50\u679c";
    }

    @Override
    public String modsNoRecomendados() {
        return "\u975e\u63a8\u5968 mod";
    }

    @Override
    public String agregarMod() {
        return "mod \u3092\u8ffd\u52a0";
    }

    @Override
    public String quitarMod() {
        return "mod \u3092\u524a\u9664";
    }

    @Override
    public String modId() {
        return "Mod ID / JBoss Modules \u540d\u79f0";
    }

    @Override
    public String rutaMod() {
        return "mod \u306e\u30d1\u30b9 / \u30d5\u30a1\u30a4\u30eb";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "modid \u307e\u305f\u306f mod \u306e\u30d1\u30b9\u306e\u3044\u305a\u308c\u304b\u3092\u5c11\u306a\u304f\u3068\u3082\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "\u3053\u3053\u306b\u975e\u63a8\u5968 mod \u3092\u767b\u9332\u3059\u308b\u3053\u3068\u3067\u3001\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u306b CrashDetector \u304c\u691c\u51fa\u3057\u307e\u3059\u3002";
    }

    @Override
    public String anularNormal() {
        return "\u901a\u5e38\u30e2\u30fc\u30c9\u3092\u7121\u52b9\u5316";
    }

    @Override
    public String anularNormalDescripcion() {
        return "\u30af\u30e9\u30c3\u30b7\u30e5\u304c\u767a\u751f\u3057\u3066\u3044\u306a\u304f\u3066\u3082\u3001CrashDetector \u306f\u8b66\u544a\u3092\u51fa\u3059\u3079\u304d\u3067\u3059\u3002";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "CrashDetector \u304c\u63a8\u5968\u3059\u308b mod \u3092\u767b\u9332\u3057\u307e\u3059\u3002\u4e0d\u8db3\u3057\u3066\u3044\u308b\u5834\u5408\u3001CrashDetector \u304c\u8b66\u544a\u3092\u51fa\u3059\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "\u6d77\u8cca\u7248\u8b66\u544a\u3092\u6709\u52b9\u306b\u3059\u308b\u5834\u5408\u3001\u4e88\u9632\u63aa\u7f6e\u3068\u3057\u3066\u30b5\u30dd\u30fc\u30c8\u3092\u6c42\u3081\u308b\u4eba\u306e\u6a29\u5229\u3092\u3053\u3053\u3067\u5b9a\u7fa9\u3059\u308b\u3053\u3068\u3092\u304a\u52e7\u3081\u3057\u307e\u3059\u3002\n\n\u4e00\u822c\u7684\u306a\u8aa4\u89e3\u3068\u306f\u7570\u306a\u308a\u3001\u591a\u304f\u306e\u4eba\u6c17\u30b3\u30df\u30e5\u30cb\u30c6\u30a3\u3084\u30b5\u30dd\u30fc\u30c8\u30c1\u30e3\u30f3\u30cd\u30eb\u306f\u3001\u6d77\u8cca\u7248\u8b66\u544a\u3092\u6709\u52b9\u306b\u3057\u306a\u304f\u3066\u3082\u52a9\u3051\u3092\u63d0\u4f9b\u3057\u307e\u3059\u3002\u305f\u3060\u3057\u3001\u30e6\u30fc\u30b6\u30fc\u304c\u30b5\u30dd\u30fc\u30c8\u30c1\u30e3\u30f3\u30cd\u30eb\u306b\u30a2\u30af\u30bb\u30b9\u3057\u305f\u5834\u5408\u306b\u5099\u3048\u3066\u3001\u3053\u308c\u3089\u306e\u6a29\u5229\u3092\u6587\u66f8\u5316\u3057\u3066\u304a\u304f\u3068\u5f79\u7acb\u3061\u307e\u3059\u3002\n\n\u30e1\u30ad\u30b7\u30b3\u306e\u300e\u88ab\u62d8\u675f\u8005\u306e\u57fa\u672c\u7684\u6a29\u5229\u30cf\u30f3\u30c9\u30d6\u30c3\u30af\u300f\u306a\u3069\u306e\u516c\u5f0f\u6587\u66f8\u3092\u53c2\u8003\u306b\u3067\u304d\u307e\u3059:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\n\u307e\u305f\u3001\u30a2\u30e1\u30ea\u30ab\u5408\u8846\u56fd\u3001\u30ed\u30b7\u30a2\u9023\u90a6\u3001\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u56fd\u3001\u30a4\u30e9\u30f3\u30fb\u30a4\u30b9\u30e9\u30e0\u5171\u548c\u56fd\u3001\u671d\u9bae\u6c11\u4e3b\u4e3b\u7fa9\u4eba\u6c11\u5171\u548c\u56fd\u306a\u3069\u3067\u63a1\u7528\u3055\u308c\u3066\u3044\u308b\u985e\u4f3c\u306e\u6cd5\u7684\u539f\u5247\u3082\u53c2\u8003\u306b\u306a\u308a\u307e\u3059\u3002\n\n\u542b\u3081\u308b\u3053\u3068\u304c\u3067\u304d\u308b\u6a29\u5229\u306e\u4f8b:\n\u2022 \u30b5\u30dd\u30fc\u30c8\u306b\u4e0d\u8981\u306a\u60c5\u5831\u3092\u63d0\u4f9b\u3057\u306a\u3044\u6a29\u5229\uff08\u4f8b: \u4f7f\u7528\u4e2d\u306e\u30e9\u30f3\u30c1\u30e3\u30fc\u3001\u30e6\u30fc\u30b6\u30fc\u540d\u3001UUID\uff09\u3002\n\u2022 \u81ea\u5df1\u8ca0\u7f6a\u62d2\u5426\u6a29\u3002\n\u2022 \u554f\u984c\u89e3\u6c7a\u306b\u4e0d\u8981\u306a\u8cea\u554f\u306b\u7b54\u3048\u308b\u3053\u3068\u3092\u62d2\u5426\u3059\u308b\u6a29\u5229\u3002\n\u2022 \u30c1\u30e3\u30c3\u30c8\u5185\u3067\u30ac\u30a4\u30c0\u30f3\u30b9\u3092\u53d7\u3051\u308b\u6a29\u5229\u3002\n\u2022 CrashDetector \u306b\u5185\u8535\u3055\u308c\u305f\u30ed\u30b0\u533f\u540d\u5316\u6a5f\u80fd\u3092\u4f7f\u7528\u3059\u308b\u6a29\u5229\u3002\n\n\u3053\u306e\u30c6\u30ad\u30b9\u30c8\u306f HTML \u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u3059\u3002";
    }

    @Override
    public String editar() {
        return "\u7de8\u96c6";
    }

    @Override
    public String advertenciaHashLento() {
        return "\u8b66\u544a: \u5927\u304d\u306a\u30d5\u30a1\u30a4\u30eb\u3092\u591a\u6570\u8ffd\u52a0\u3059\u308b\u3068\u3001\u691c\u8a3c\u306b\u6570\u5206\u304b\u304b\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002CrashDetector \u306f\u7d9a\u884c\u524d\u306b\u5404\u30d5\u30a1\u30a4\u30eb\u306e\u30cf\u30c3\u30b7\u30e5\u3092\u8a08\u7b97\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u53b3\u5bc6\u306b\u5fc5\u8981\u306a\u30d5\u30a1\u30a4\u30eb\u306e\u307f\u3092\u4fdd\u8b77\u3059\u308b\u3053\u3068\u3092\u304a\u52e7\u3081\u3057\u307e\u3059\u3002";
    }

    @Override
    public String agregarArchivo() {
        return "\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0";
    }

    @Override
    public String agregarCarpeta() {
        return "\u30d5\u30a9\u30eb\u30c0\u3092\u8ffd\u52a0";
    }

    @Override
    public String quitar() {
        return "\u524a\u9664";
    }

    @Override
    public String rutaArchivo() {
        return "\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "\u9078\u629e\u3055\u308c\u305f\u30d1\u30b9\u306f\u73fe\u5728\u306e\u30b2\u30fc\u30e0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u5916\u306b\u3042\u308a\u307e\u3059\u3002\u73fe\u5728\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u307e\u305f\u306f\u305d\u306e\u30b5\u30d6\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u304a\u3088\u3073\u30d5\u30a9\u30eb\u30c0\u306e\u307f\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>Sylent Bell \u306e\u610f\u898b\u3084\u30b3\u30e1\u30f3\u30c8\u306f\u5fc5\u305a\u3057\u3082\u79c1\u305f\u3061\u306e\u898b\u89e3\u3068\u4e00\u81f4\u3059\u308b\u308f\u3051\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1b\u305f\u3060\u3001\u3053\u3053\u306b\u7f6e\u3044\u305f\u3089\u9762\u767d\u3044\u3068\u601d\u3063\u305f\u306e\u3067\u3059\u3002CrashDetector \u306f\u4e16\u4fd7\u7684\u3067\u3059\u3002</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GML\uff08Groovy ModLoader\uff09mod \u306f\u3053\u308c\u3089\u306e\u5909\u66f4\u3092\u5fc5\u8981\u3068\u3057\u3001\u3053\u306e\u554f\u984c\u306e\u6700\u3082\u4e00\u822c\u7684\u306a\u539f\u56e0\u3067\u3059\u3002</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'><i> Flywheel</i> \u306e\u4f7f\u7528\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><p><b> Flywheel \u306f\u975e\u63a8\u5968\uff08deprecated\uff09</b>\u3067\u3042\u308a\u3001\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u306f\u4f7f\u7528\u3059\u3079\u304d\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002</p><p>\u73fe\u5728\u306e <b>Create</b> \u30d0\u30fc\u30b8\u30e7\u30f3\u306f<b>Flywheel \u3092\u65e2\u306b\u5185\u8535</b>\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u5225\u9014\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u3068 \u4e92\u63db\u6027\u306e\u885d\u7a81\u3084\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059\u3002</p><p> Flywheel \u306b\u660e\u793a\u7684\u306b\u4f9d\u5b58\u3059\u308b\u4e00\u90e8\u306e mod \u306f <b>\u52d5\u4f5c\u3057\u306a\u3044</b>\u304b<b>\u4e0d\u5b89\u5b9a\u306b\u52d5\u4f5c</b>\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u7279\u5b9a\u306e\u9ad8\u5ea6\u306a\u30b1\u30fc\u30b9\u3067\u306f\u3001<b><code>mods.toml</code> \u30d5\u30a1\u30a4\u30eb\u3092\u624b\u52d5\u3067\u7de8\u96c6</b>\u3057\u3066\u30d0\u30fc\u30b8\u30e7\u30f3\u7bc4\u56f2\u3092\u8abf\u6574\u3059\u308c\u3070 \u52d5\u4f5c\u3059\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u304c\u3001\u3053\u308c\u306f<b>\u63a8\u5968\u3055\u308c\u307e\u305b\u3093</b>\u3002</p>" + (mods.isEmpty() ? "" : "<p><b>Flywheel \u3092\u53c2\u7167\u3057\u3066\u3044\u308b\u691c\u51fa\u6e08\u307f mod:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>\u63a8\u5968\u3055\u308c\u308b\u89e3\u6c7a\u7b56\u306f\u3001<b> Flywheel \u3092\u524a\u9664</b>\u3057\u3001Create \u306b\u540c\u68b1\u3055\u308c\u3066\u3044\u308b\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u307f\u3092\u4f7f\u7528\u3059\u308b\u3053\u3068\u3067\u3059\u3002</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "\u72ec\u7acb\u578b Flywheel";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'><i>Floral Enchantments</i> \u30e2\u30c3\u30c9\u306b\u95a2\u9023\u3059\u308b\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><p>\u30af\u30e9\u30c3\u30b7\u30e5\u306f\u3001\u30b2\u30fc\u30e0\u30c7\u30fc\u30bf\u3092\u51e6\u7406\u4e2d\u306b\u30e2\u30c3\u30c9\u5185\u3067\u767a\u751f\u3057\u305f\u5185\u90e8\u969c\u5bb3\u306b\u3088\u3063\u3066\u5f15\u304d\u8d77\u3053\u3055\u308c\u3001\u5b9f\u884c\u4e2d\u306b <b>NullPointerException</b> \u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002</p><p>\u3053\u306e\u554f\u984c\u306f\u901a\u5e38\u3001\u30e2\u30c3\u30c9\u3092\u66f4\u65b0\u307e\u305f\u306f\u524a\u9664\u3059\u308b\u3053\u3068\u3067\u89e3\u6c7a\u3057\u307e\u3059\u3002</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "Floral Enchantments \u30a8\u30e9\u30fc";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>MixinExtras \u306e NeoForge \u7248\u3068\u901a\u5e38\u7248\u306e\u4e21\u65b9\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u3059\u3002MinecraftForge \u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u5834\u5408\u3001<a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>\u3053\u306e\u30ea\u30f3\u30af</a>\u304b\u3089\u4fee\u6b63 mod \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3067\u304d\u307e\u3059\u3002</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Iris \u306e\u30b7\u30a7\u30fc\u30c0\u30fc\u4f7f\u7528\u6642\u306b\u5730\u5f62\u306e\u5f71\u306b\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><p>\u3053\u306e\u554f\u984c\u306f\u5730\u5f62\u306e\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u4e2d\u306b\u767a\u751f\u3057\u307e\u3059\u3002</p><p><b>\u30b7\u30a7\u30fc\u30c0\u30fc\u3092\u7121\u52b9\u306b\u3057\u3066\u30b2\u30fc\u30e0\u3092\u8a66\u3059</b>\u304b\u3001\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u54c1\u8cea\u3092\u4e0b\u3052\u308b\u3053\u3068\u3092\u63a8\u5968\u3057\u307e\u3059\u3002\u7279\u306b<b>Ultra</b>\u8a2d\u5b9a\u6642\u3067\u3059\u3002</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "\u5730\u5f62\u306e\u5f71 (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u30b5\u30fc\u30d0\u30fc\u306e\u30c6\u30a3\u30c3\u30af\u304c\u7570\u5e38\u306b\u9577\u304f\u306a\u3063\u3066\u3044\u307e\u3059\u3002</b><p>\u3053\u308c\u306f\u3001\u30b2\u30fc\u30e0\u304c1\u30c6\u30a3\u30c3\u30af\u5185\u3067\u9577\u6642\u9593\u30d5\u30ea\u30fc\u30ba\u3057\u305f\u3053\u3068\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002</p><p>\u539f\u56e0\u3092\u7279\u5b9a\u3059\u308b\u305f\u3081\u3001\u30ed\u30b0\u306b\u751f\u6210\u3055\u308c\u305f<b>\u30b9\u30ec\u30c3\u30c9\u30c0\u30f3\u30d7(thread dump)\u3092\u78ba\u8a8d</b>\u3059\u308b\u3053\u3068\u3092\u304a\u52e7\u3081\u3057\u307e\u3059\u3002</p><p><b>\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u5206\u6790(Stack Trace Analysis)</b>\u306b\u3088\u308a\u3001\u30d5\u30ea\u30fc\u30ba\u306e\u539f\u56e0\u3092\u7279\u5b9a\u3067\u304d\u307e\u3059\u3002</p><p>\u307e\u305f\u3001<b>\u30ed\u30b0\u3067\u8868\u793a</b>\u30dc\u30bf\u30f3\u306f\u3001\u554f\u984c\u306e\u539f\u56e0\u3068\u306a\u308a\u3046\u308bmod\u3092\u8d64\u8272\u3067\u5f37\u8abf\u8868\u793a\u3057\u3001<code>$modid$</code>\u3067\u56f2\u307e\u308c\u305f\u30a8\u30f3\u30c8\u30ea\u3082\u8868\u793a\u3057\u307e\u3059\uff08\u3053\u308c\u3089\u306f\u901a\u5e38\u3001\u554f\u984c\u306e\u767a\u751f\u6e90\u3092\u793a\u3057\u307e\u3059\uff09\u3002\u30ea\u30a2\u30eb\u30bf\u30a4\u30e0\u3067\u306e\u89e3\u6790\u306b\u306f\u3001VisualVM \u306e CPU \u30b5\u30f3\u30d7\u30e9\u30fc\u306e\u4f7f\u7528\u3092\u63a8\u5968\u3057\u307e\u3059\u3002\u3059\u3079\u3066\u306emod\u304c\u6b63\u5e38\u306b\u52d5\u4f5c\u3057\u3066\u3044\u3066\u3082\u3001\u6570\u304c\u591a\u3059\u304e\u308b\u3068\u3053\u306e\u554f\u984c\u304c\u767a\u751f\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308b\u305f\u3081\u3001\u30b5\u30fc\u30d0\u30fc\u3084PC\u306e\u6027\u80fd\u304c\u4f7f\u7528\u4e2d\u306emod\u3092\u5341\u5206\u306b\u51e6\u7406\u3067\u304d\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "\u30b5\u30fc\u30d0\u30fc\u30c6\u30a3\u30c3\u30af\u306e\u9577\u6642\u9593\u505c\u6b62";
    }

    @Override
    public String tituloLFPDPPP() {
        return "\u500b\u4eba\u304c\u4fdd\u6709\u3059\u308b\u500b\u4eba\u60c5\u5831\u306e\u4fdd\u8b77\u306b\u95a2\u3059\u308b\u9023\u90a6\u6cd5";
    }

    @Override
    public String aceptarPermanentemente() {
        return "\u6c38\u7d9a\u7684\u306b\u540c\u610f";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "\u97d3\u56fd\u8a9e\u7ffb\u8a33\u306b\u306f\u3001\u6cd5\u5f8b\u3092\u9075\u5b88\u3059\u308b\u305f\u3081\u306b\u907f\u3051\u308b\u3079\u304d\u5357\u90e8\u306e\u30b9\u30e9\u30f3\u30b0\u7528\u8a9e\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u5916\u56fd\u8a9e\u3001\u7279\u306b\u5357\u5074\u7531\u6765\u306e\u8a00\u8449\u306e\u4f7f\u7528\u306f\u3001\u300c\u5e73\u58cc\u6587\u5316\u8a9e\u4fdd\u8b77\u6cd5\u300d\u306b\u3088\u308a\u53b3\u3057\u304f\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "\u8a73\u7d30\u306b\u3064\u3044\u3066\u306f\u3001\u6cd5\u4ee4\u306e\u516c\u5f0f\u6587\u66f8\u3092\u3054\u53c2\u7167\u304f\u3060\u3055\u3044\uff1a<a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>\u5e73\u58cc\u6587\u5316\u8a9e\u4fdd\u8b77\u6cd5</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "\u5168\u6587\u3092\u8aad\u3080";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "\u30ea\u30f3\u30af\u3092\u958b\u304f\u969b\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "\u5e73\u58cc\u6587\u5316\u8a9e\u4fdd\u8b77\u6cd5";
    }

    @Override
    public String canarioTitulo() {
        return "\u53f8\u6cd5\u547d\u4ee4\u30ab\u30ca\u30ea\u30a2";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 \u76e3\u8996\u30e2\u30cb\u30bf\u30fc";
    }

    @Override
    public String revisar() {
        return "\u78ba\u8a8d";
    }

    @Override
    public String cerrar() {
        return "\u9589\u3058\u308b";
    }

    @Override
    public String canarioTodoSeguro() {
        return "\u3059\u3079\u3066\u306e\u30b5\u30fc\u30d3\u30b9\u304c\u5b89\u5168\u306a\u72b6\u614b\u3092\u5831\u544a\u3057\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String canarioComprometido(int c) {
        return "\u8b66\u544a: " + c + " \u500b\u306e\u30b5\u30fc\u30d3\u30b9\u304c\u5b89\u5168\u3067\u306a\u3044\u72b6\u614b\u3092\u5831\u544a\u3057\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String colorAlerta() {
        return "\u8b66\u544a\u8272";
    }

    @Override
    public String opcionesMunidiales() {
        return "\u30e0\u30cb\u30c0\u30eb\u30aa\u30d7\u30b7\u30e7\u30f3";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "LFPDPPP\u540c\u610f";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "ReLauncher\u5411\u3051\u306bHandoff\u3067\u30a2\u30af\u30bb\u30b9\u30c8\u30fc\u30af\u30f3\u306e\u30cf\u30f3\u30c9\u30aa\u30d5\u3092\u6709\u52b9\u5316\uff08\u975e\u63a8\u5968\uff09";
    }

    @Override
    public String consolaDesarrollo() {
        return "\u958b\u767a\u30b3\u30f3\u30bd\u30fc\u30eb";
    }

    @Override
    public String mundial() {
        return "\u30b0\u30ed\u30fc\u30d0\u30eb";
    }

    @Override
    public String ningun() {
        return "\u306a\u3057";
    }

    public String consolaDesarrollador() {
        return "\u958b\u767a\u8005\u30b3\u30f3\u30bd\u30fc\u30eb";
    }

    @Override
    public String bajar() {
        return "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9";
    }

    @Override
    public String logsSoporte() {
        return "\u30b5\u30dd\u30fc\u30c8\u7528\u30ed\u30b0";
    }

    @Override
    public String detenerProceso() {
        return "\u30d7\u30ed\u30bb\u30b9\u3092\u505c\u6b62";
    }

    @Override
    public String copiarSeleccion() {
        return "\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc";
    }

    @Override
    public String seleccionarTodo() {
        return "\u3059\u3079\u3066\u9078\u629e";
    }

    @Override
    public String copiarTodo() {
        return "\u3059\u3079\u3066\u30b3\u30d4\u30fc";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "\u3059\u3079\u3066\u3092\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u4fdd\u5b58";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "\u30b5\u30dd\u30fc\u30c8\u30ea\u30f3\u30af\u3092\u53d6\u5f97";
    }

    @Override
    public String borrarTodo() {
        return "\u3059\u3079\u3066\u30af\u30ea\u30a2";
    }

    public String colorFondoConsola() {
        return "\u30b3\u30f3\u30bd\u30fc\u30eb\u306e\u80cc\u666f\u8272";
    }

    public String colorTextoConsola() {
        return "\u30b3\u30f3\u30bd\u30fc\u30eb\u306e\u6587\u5b57\u8272";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "\u540c\u610f\u304c\u78ba\u8a8d\u3055\u308c\u307e\u3057\u305f\u3002\n\u30ed\u30b0\u5171\u6709\u6a5f\u80fd\u306f\u3053\u3053\u306b\u5b9f\u88c5\u3055\u308c\u307e\u3059\u3002";
    }

    @Override
    public String usarSakuraOriginal() {
        return "\u30aa\u30ea\u30b8\u30ca\u30eb\u306e Sakura Riddle \u753b\u50cf\u3092\u4f7f\u7528";
    }

    @Override
    public String canario1984Descripcion() {
        return "\u300c\u30ef\u30e9\u30f3\u30c8\u30ab\u30ca\u30ea\u30a2\uff08warrant canary\uff09\u300d\u306f\u900f\u660e\u6027\u3092\u78ba\u4fdd\u3059\u308b\u4ed5\u7d44\u307f\u3067\u3059\u3002\n\n\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u5b58\u5728\u3057\u3001\u30b5\u30fc\u30d3\u30b9\u304c\u5b89\u5168\u3068\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u9650\u308a\u3001\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306f\u79d8\u5bc6\u306e\u53f8\u6cd5\u547d\u4ee4\u3084\u691c\u95b2\u8981\u6c42\u3001\u5408\u6cd5\u7684\u306a\u76e3\u8996\u8981\u8acb\u3092\u53d7\u3051\u3066\u3044\u306a\u3044\u3053\u3068\u3092\u610f\u5473\u3057\u307e\u3059\u3002\n\n\u3044\u305a\u308c\u304b\u306e\u30ab\u30ca\u30ea\u30a2\u304c\u6d88\u3048\u305f\u308a\u3001\u975e\u5b89\u5168\u3068\u30de\u30fc\u30af\u3055\u308c\u305f\u5834\u5408\u3001\u305d\u308c\u306f\u6cd5\u7684\u72b6\u6cc1\u306b\u5909\u5316\u304c\u3042\u3063\u305f\u3053\u3068\u3092\u793a\u3057\u307e\u3059\u3002\n\n\u3053\u306e\u30d1\u30cd\u30eb\u306f\u30b7\u30b9\u30c6\u30e0\u306b\u767b\u9332\u3055\u308c\u305f\u3059\u3079\u3066\u306e\u30ab\u30ca\u30ea\u30a2\u3092\u78ba\u8a8d\u3057\u3001\u73fe\u5728\u306e\u72b6\u614b\u3092\u8868\u793a\u3057\u307e\u3059\u3002\n\n\u300c\u78ba\u8a8d\u300d\u3092\u62bc\u3057\u3066\u72b6\u614b\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\u3059\u3079\u3066\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u306b\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "\u30aa\u30d7\u30b7\u30e7\u30f3\u306a\u3057";
    }

    @Override
    public String seleccionaColor() {
        return "\u8272\u3092\u9078\u629e";
    }

    @Override
    public String botonMostrarGUI() {
        return "GUI\u3092\u8868\u793a";
    }

    @Override
    public String botonGuardarTodo() {
        return "\u3059\u3079\u3066\u4fdd\u5b58";
    }

    @Override
    public String botonRestablecerTodo() {
        return "\u3059\u3079\u3066\u30ea\u30bb\u30c3\u30c8";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms \u304c\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>LuckPerms API \u3078\u306e\u30a2\u30af\u30bb\u30b9\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><p>\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u3001\u5225\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u304c LuckPerms \u3092\u4f7f\u7528\u3057\u3088\u3046\u3068\u3057\u305f\u969b\u306b\u3001<b>LuckPerms \u304c\u307e\u3060\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u306a\u304b\u3063\u305f</b>\u3053\u3068\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002</p><p><b>\u8003\u3048\u3089\u308c\u308b\u539f\u56e0:</b></p><ul><li><b>LuckPerms \u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u306a\u3044</b>\u304b\u3001<b>\u8d77\u52d5\u306b\u5931\u6557\u3057\u305f</b>\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u5225\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u304c LuckPerms \u306b <b>\u65e9\u3059\u304e\u308b\u30bf\u30a4\u30df\u30f3\u30b0</b> \u307e\u305f\u306f <b>\u4e0d\u9069\u5207\u306a\u65b9\u6cd5</b> \u3067\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002</li></ul><p>\u30ea\u30f3\u30af\u304b\u3089<b>\u30b3\u30f3\u30bd\u30fc\u30eb\u3092\u78ba\u8a8d\u3057</b>\u3001LuckPerms \u3092\u547c\u3073\u51fa\u3057\u3066\u3044\u308b\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u7279\u5b9a\u3057\u3001\u4e92\u63db\u6027\u3092\u691c\u8a3c\u3059\u308b\u3053\u3068\u3092\u304a\u52e7\u3081\u3057\u307e\u3059\u3002</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "Iris \u30b7\u30a7\u30fc\u30c0\u30fc\u30d1\u30c3\u30af\u304c\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "\u4e0d\u660e" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Iris/Oculus \u3067\u30b7\u30a7\u30fc\u30c0\u30fc\u30d1\u30c3\u30af\u3092\u8aad\u307f\u8fbc\u3080\u969b\u306b\u30a8\u30e9\u30fc\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002</b><p><b>\u5f71\u97ff\u3092\u53d7\u3051\u305f\u30b7\u30a7\u30fc\u30c0\u30fc\u30d1\u30c3\u30af:</b> " + nombre + "</p><p>Minecraft \u306f\u30b7\u30a7\u30fc\u30c0\u30fc\u30d1\u30c3\u30af\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\uff08FileSystemNotFoundException\uff09\u3002</p><p><b>\u8003\u3048\u3089\u308c\u308b\u89e3\u6c7a\u7b56:</b></p><ul><li>\u30b7\u30a7\u30fc\u30c0\u30fc\u30d1\u30c3\u30af\u304c <b>shaderpacks</b> \u30d5\u30a9\u30eb\u30c0\u30fc\u306b\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308b\u305f\u3081\u3001\u30b7\u30a7\u30fc\u30c0\u30fc\u30d1\u30c3\u30af\u3092\u518d\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u554f\u984c\u304c\u7d9a\u304f\u5834\u5408\u306f\u3001Iris \u306e\u8a2d\u5b9a\u3092\u30ea\u30bb\u30c3\u30c8\u3059\u308b\u305f\u3081 <b>config/iris.properties</b> \u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li></ul><p>\u5909\u66f4\u3092\u9069\u7528\u3057\u305f\u5f8c\u3001\u30b2\u30fc\u30e0\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "\u4e0d\u660e" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002</b><p><b>\u5f71\u97ff\u3092\u53d7\u3051\u305f\u30d5\u30a1\u30a4\u30eb:</b> " + archivo + "</p><p>Minecraft \u306f\u30a2\u30c8\u30df\u30c3\u30af\u66f8\u304d\u8fbc\u307f\uff08REPLACE_ATOMIC\uff09\u3067\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002</p><p><b>\u3053\u308c\u306f\u901a\u5e38\u3001\u4ee5\u4e0b\u306e\u539f\u56e0\u3067\u767a\u751f\u3057\u307e\u3059:</b></p><ul><li>\u30d5\u30a9\u30eb\u30c0\u30fc\u3084\u30d5\u30a1\u30a4\u30eb\u306e\u6a29\u9650\u304c\u6b63\u3057\u304f\u306a\u3044\u3002</li><li>\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308a\u5c02\u7528\u3068\u3057\u3066\u30de\u30fc\u30af\u3055\u308c\u3066\u3044\u308b\u3002</li><li>\u4ed6\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\uff08\u30a6\u30a4\u30eb\u30b9\u5bfe\u7b56\u30bd\u30d5\u30c8\u3001\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30c4\u30fc\u30eb\u3001\u30a8\u30c7\u30a3\u30bf\u306a\u3069\uff09\u304c\u30d5\u30a1\u30a4\u30eb\u3092\u30ed\u30c3\u30af\u3057\u3066\u3044\u308b\u3002</li></ul><p><b>\u63a8\u5968\u5bfe\u5fdc:</b></p><ul><li>\u30d5\u30a9\u30eb\u30c0\u30fc\u306b\u66f8\u304d\u8fbc\u307f\u6a29\u9650\u304c\u3042\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u53d6\u308a\u5c02\u7528\u5c5e\u6027\u3092\u89e3\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u306e\u3042\u308b\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u4f5c\u6210\u6642\u306b\u30a2\u30af\u30bb\u30b9\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "\u4e0d\u660e" : origen;
        String dst = backup == null || backup.isEmpty() ? "\u4e0d\u660e" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u4f5c\u6210\u4e2d\u306b\u6a29\u9650\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002</b><p><b>\u5143\u306e\u30d5\u30a1\u30a4\u30eb:</b> " + src + "</p><p><b>\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30d5\u30a1\u30a4\u30eb:</b> " + dst + "</p><p>\u30d5\u30a1\u30a4\u30eb\u4fdd\u5b58\u4e2d\u306b\u30aa\u30da\u30ec\u30fc\u30c6\u30a3\u30f3\u30b0\u30b7\u30b9\u30c6\u30e0\u304c\u30a2\u30af\u30bb\u30b9\u3092\u30d6\u30ed\u30c3\u30af\u3057\u307e\u3057\u305f\u3002</p><p><b>\u3053\u308c\u306f\u901a\u5e38\u3001\u4ee5\u4e0b\u306e\u539f\u56e0\u3067\u767a\u751f\u3057\u307e\u3059:</b></p><ul><li>\u30d5\u30a9\u30eb\u30c0\u30fc\u306e\u6a29\u9650\u304c\u4e0d\u5341\u5206\u3067\u3059\u3002</li><li>\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308a\u5c02\u7528\u3068\u3057\u3066\u30de\u30fc\u30af\u3055\u308c\u3066\u3044\u307e\u3059\u3002</li><li>\u4ed6\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\uff08\u30a6\u30a4\u30eb\u30b9\u5bfe\u7b56\u30bd\u30d5\u30c8\u3001\u540c\u671f\u30c4\u30fc\u30eb\u3001\u30a8\u30c7\u30a3\u30bf\uff09\u304c\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u4e2d\u3067\u3059\u3002</li></ul><p><b>\u63a8\u5968\u5bfe\u5fdc:</b></p><ul><li><b>config</b> \u30d5\u30a9\u30eb\u30c0\u30fc\u306e\u6a29\u9650\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306b\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u306e\u3042\u308b\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u7d42\u4e86\u3057\u3066\u304f\u3060\u3055\u3044\u3002</li><li>\u30e9\u30f3\u30c1\u30e3\u30fc\u3084 Minecraft \u3092\u7ba1\u7406\u8005\u3068\u3057\u3066\u5b9f\u884c\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002</li></ul>";
    }
}

