/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Persa
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u067e\u0648\u0634\u0647 mods \u0646\u0627\u0645\u0639\u062a\u0628\u0631</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0627\u06cc\u0644 JAR CrashDetector \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u062f\u0631 \u062d\u0627\u0644 \u062c\u0633\u062a\u062c\u0648 \u0628\u0631\u0627\u06cc PID: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") \u0645\u062a\u0648\u0642\u0641 \u0634\u062f\u0647 \u0627\u0633\u062a!</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>JVM \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc ATI/AMD \u0634\u0645\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u06a9\u0645\u06a9 \u06a9\u0646\u062f. \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0645\u0634\u06a9\u0644 \u0627\u06cc\u0646 \u0631\u0627\u0647\u0646\u0645\u0627 \u0631\u0627 \u0628\u062e\u0648\u0627\u0646\u06cc\u062f: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0631\u0627\u0647\u0646\u0645\u0627\u06cc \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627</a> https://www.amd.com/es/support/download/drivers.html \u062f\u0627\u0646\u0644\u0648\u062f </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0628\u0631\u062e\u06cc \u0627\u0632 \u0646\u0633\u062e\u0647 \u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc \u062f\u0631 \u0631\u0627\u0628\u0637 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0627\u0648\u0644\u06cc\u0647 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 Nouveau \u06af\u0627\u0647\u06cc \u0627\u0648\u0642\u0627\u062a \u062f\u0686\u0627\u0631 \u0645\u0634\u06a9\u0644 \u0645\u06cc \u0634\u0648\u0646\u062f.</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u0645\u0634\u06a9\u0644 \u062f\u0631\u0627\u06cc\u0648\u0631 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u062f\u0627\u0631\u06cc\u062f. \u0627\u06af\u0631 \u0627\u0632 GPU \u06cc\u0627 APU AMD/ATI \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0644\u0637\u0641\u0627\u064b \u062f\u0631\u0627\u06cc\u0648\u0631 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 AMD \u062e\u0648\u062f \u0631\u0627 \u0628\u0647 \u0631\u0648\u0632 \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0627\u0632 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 NVIDIA \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u0628\u0627\u0632\u06cc \u0648 \u062a\u0645\u0627\u0645 \u0646\u0645\u0648\u0646\u0647 \u0647\u0627\u06cc javaw.exe \u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u0645\u062c\u0632\u0627 \u062a\u0646\u0638\u06cc\u0645 \u0634\u062f\u0647 \u0627\u0646\u062f. \u0627\u06cc\u0646 \u0631\u0627\u0647\u0646\u0645\u0627 \u0631\u0627 \u0628\u062e\u0648\u0627\u0646\u06cc\u062f: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0631\u0627\u0647\u0646\u0645\u0627\u06cc \u0628\u0647 \u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc \u062f\u0631\u0627\u06cc\u0648\u0631</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u067e\u0646\u062c\u0631\u0647 \u0627\u0648\u0644\u06cc\u0647 FML \u0634\u0645\u0627 \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f. \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644\u060c \u0628\u0647 (.minecraft/config/fml.toml) \u0628\u0631\u0648\u06cc\u062f \u0648 earlyWindowProvider \u0631\u0627 \u0628\u0647 \"none\" \u062a\u0646\u0638\u06cc\u0645 \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0627\u0632 Mac M1 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u0627\u0632 \u0646\u0633\u062e\u0647 ARM Java \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0646\u0647 \u0646\u0633\u062e\u0647 Intel x64. \u0627\u06cc\u0646 \u0647\u0645\u0686\u0646\u06cc\u0646 \u06cc\u06a9 \u0645\u0634\u06a9\u0644 \u0631\u0627\u06cc\u062c \u062f\u0631\u0627\u06cc\u0648\u0631 \u0642\u062f\u06cc\u0645\u06cc \u0627\u0633\u062a. \u0627\u06af\u0631 \u0627\u0632 \u0648\u06cc\u0646\u062f\u0648\u0632 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc \u06a9\u0646\u06cc\u062f \u0648 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0631\u062f\u0646 \u0627\u06cc\u0646 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0628\u06cc \u0641\u0627\u06cc\u062f\u0647 \u0628\u0648\u062f\u060c \u0627\u06cc\u0646 \u0631\u0627\u0647\u0646\u0645\u0627 \u0631\u0627 \u0645\u0637\u0627\u0644\u0639\u0647 \u06a9\u0646\u06cc\u062f: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0631\u0627\u0647\u0646\u0645\u0627\u06cc \u0628\u0647 \u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc \u062f\u0631\u0627\u06cc\u0648\u0631</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0647\u0627\u06cc \u0644\u0627\u0632\u0645 \u0631\u0627 \u0646\u062f\u0627\u0631\u06cc\u062f:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "\u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0634\u062f\u0647 \u062a\u0648\u0633\u0637").replace("Expected range", "\u0645\u062d\u062f\u0648\u062f\u0647 \u0627\u0646\u062a\u0638\u0627\u0631\u06cc") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u06af\u0632\u0627\u0631\u0634 CrashDetector \u0634\u0645\u0627 \u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u0627\u0633\u062a <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0645\u0634\u0627\u0647\u062f\u0647 \u06af\u0632\u0627\u0631\u0634</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u0627\u06cc\u0646 \u0631\u0627\u0628\u0637 \u06a9\u0627\u0631\u0628\u0631\u06cc GUI CrashDetector \u0627\u0633\u062a. \u0627\u06af\u0631 \u0628\u0627\u0632\u06cc \u0628\u0647 \u0637\u0648\u0631 \u0645\u0639\u0645\u0648\u0644 \u0628\u0633\u062a\u0647 \u0634\u062f\u060c \u0644\u0637\u0641\u0627 \u0627\u06cc\u0646 \u0631\u0627\u0628\u0637 \u0631\u0627 \u0646\u0627\u062f\u06cc\u062f\u0647 \u0628\u06af\u06cc\u0631\u06cc\u062f.</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>\u0645\u0634\u0627\u0647\u062f\u0647 \u06af\u0632\u0627\u0631\u0634</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u06af\u0632\u0627\u0631\u0634 \u0645\u062d\u0644\u06cc \u0631\u0627 \u062f\u0631 \u0645\u0631\u0648\u0631\u06af\u0631 \u0645\u0634\u0627\u0647\u062f\u0647 \u06a9\u0646\u06cc\u062f.</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "\u0628\u0647 \u0627\u0634\u062a\u0631\u0627\u06a9 \u06af\u0630\u0627\u0634\u062a\u0646 \u06af\u0632\u0627\u0631\u0634";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "\u06af\u0632\u0627\u0631\u0634 \u0631\u0627 \u0628\u0647 \u0627\u0634\u062a\u0631\u0627\u06a9 \u0628\u06af\u0630\u0627\u0631\u06cc\u062f. \u0644\u0627\u06af \u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u0647 securelogger.net \u0648 \u06af\u0632\u0627\u0631\u0634 \u0628\u0647 \u0633\u0627\u06cc\u062a \u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 \u0622\u067e\u0644\u0648\u062f \u0645\u06cc \u0634\u0648\u062f.";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0627\u06cc\u0644 JAR \u0645\u0634\u06a9\u0648\u06a9 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f (\u0627\u0648\u0644\u0648\u06cc\u062a \u0628\u0627 FATAL\u060c \u0633\u067e\u0633 \u0628\u0627 \u0627\u0648\u0644\u0648\u06cc\u062a \u0628\u0627\u0644\u0627 \u0648 \u06a9\u0645):</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> \u0633\u0637\u062d:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u062d\u062a\u0645\u0627\u0644\u0627\u064b \u06a9\u0634\u0646\u062f\u0647:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModID \u0647\u0627\u06cc \u0645\u0634\u06a9\u0648\u06a9 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0646\u062f (\u0627\u0648\u0644\u0648\u06cc\u062a \u0628\u0627 FATAL\u060c \u0633\u067e\u0633 \u0628\u0627 \u0627\u0648\u0644\u0648\u06cc\u062a \u06a9\u0645 \u0648 \u06a9\u0645):</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0628\u0633\u062a\u0647 \u0647\u0627\u06cc \u0645\u0634\u06a9\u0648\u06a9 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0646\u062f (\u0627\u0648\u0644\u0648\u06cc\u062a \u0628\u0627 FATAL\u060c \u0633\u067e\u0633 \u0628\u0627 \u0627\u0648\u0644\u0648\u06cc\u062a \u06a9\u0645 \u0648 \u06a9\u0645):</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u0645\u0631\u06af\u0628\u0627\u0631 (FATAL) \u062f\u0627\u0631\u06cc\u062f\u060c \u0627\u06cc\u0646 \u0645\u0648\u0636\u0648\u0639 \u0628\u0633\u06cc\u0627\u0631 \u062c\u062f\u06cc \u0627\u0633\u062a. \u062f\u0644\u0627\u06cc\u0644 \u0631\u0627\u06cc\u062c \u0634\u0627\u0645\u0644 \u06a9\u0648\u0631\u0645\u062f\u0647\u0627\u06cc \u0628\u062f \u06cc\u0627 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u0645\u0631\u06af\u0628\u0627\u0631 \u0627\u0633\u062a. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 QuickFix \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0645\u0648\u062f\u0647\u0627\u06cc \u062f\u0627\u0631\u0627\u06cc \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u0645\u0631\u06af\u0628\u0627\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u0645\u0631\u06af\u0628\u0627\u0631 \u06af\u0645\u0634\u062f\u0647 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647:</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u062d\u062a\u0648\u0627\u06cc {} (\u0645\u0647\u0645 \u062a\u0631\u06cc\u0646 \u062f\u0631 \u0628\u0627\u0644\u0627\u060c \u0641\u0642\u0637 20 \u0645\u0648\u0631\u062f \u0627\u0648\u0644 \u0646\u0645\u0627\u06cc\u0634 \u062f\u0627\u062f\u0647 \u0645\u06cc \u0634\u0648\u062f):</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc SpongeMixin \u0645\u0634\u06a9\u0648\u06a9 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u0645\u062f \u0647\u0627\u06cc\u06cc \u0628\u0627 \u067e\u06a9\u06cc\u062c\u200c\u0647\u0627\u06cc \u062a\u06a9\u0631\u0627\u0631\u06cc \u062f\u0627\u0631\u06cc\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0628\u0627 \u062d\u0630\u0641 \u06a9\u0631\u062f\u0646 \u067e\u0648\u0634\u0647\u200c\u06cc \u062a\u06a9\u0631\u0627\u0631\u06cc (\u067e\u06a9\u06cc\u062c) \u0627\u0632 \u0641\u0627\u06cc\u0644 \u062c\u0627\u0631 \u062d\u0644 \u06a9\u0646\u06cc\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0641\u0627\u06cc\u0644 \u062c\u0627\u0631 \u0631\u0627 \u062f\u0631 \u06cc\u06a9 \u0646\u0631\u0645\u200c\u0627\u0641\u0632\u0627\u0631 \u0641\u0634\u0631\u062f\u0647\u200c\u0633\u0627\u0632\u06cc \u0645\u062b\u0644 \u0648\u06cc\u0646\u200c\u0631\u0627\u0631 \u06cc\u0627 7\u0632 \u0628\u0627\u0632 \u06a9\u0646\u06cc\u062f\u060c \u0647\u0645\u0686\u0646\u06cc\u0646 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u067e\u0633\u0648\u0646\u062f \u0641\u0627\u06cc\u0644 \u0631\u0627 \u0627\u0632 .\u062c\u0627\u0631 \u0628\u0647 \u0632\u06cc\u067e \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f\u060c \u0633\u067e\u0633 \u067e\u0648\u0634\u0647 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u0648 \u062f\u0648\u0628\u0627\u0631\u0647 \u0622\u0646 \u0631\u0627 \u0628\u0647 \u0641\u0627\u06cc\u0644 .\u062c\u0627\u0631 \u062a\u063a\u06cc\u06cc\u0631 \u0646\u0627\u0645 \u062f\u0647\u06cc\u062f.</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mods \u062a\u06a9\u0631\u0627\u0631\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0646\u062f</b> " + linea.replace("from mod files", "\u0627\u0632 \u0641\u0627\u06cc\u0644 \u0647\u0627\u06cc mod");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge mod \u0645\u0634\u06a9\u0648\u06a9 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0631\u062f:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV \u0628\u0647 lithostitched \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f\u060c \u0634\u0645\u0627 \u0645\u06cc \u062a\u0648\u0627\u0646\u06cc\u062f \u0622\u0646 \u0631\u0627 \u0627\u0632 \u0627\u06cc\u0646\u062c\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 Iris shaders \u06cc\u0627 Oculus\u060c \u0634\u0645\u0627 \u0628\u0647 \u0646\u0633\u062e\u0647 \u0633\u0627\u0632\u06af\u0627\u0631 SODIUM \u06cc\u0627 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 (Rubidium, Embedium, Bedium) \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0634\u06a9\u0644 \u062f\u0631 \u0627\u0641\u0632\u0648\u0646\u0647 KubeJS </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0634\u06a9\u0644\u0627\u062a\u06cc \u0628\u0627 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u0628\u0644 \u0627\u0632 Windows 11 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a.</span><br/><br/>\u0628\u0631\u0627\u06cc \u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u0627\u0632 \u0627\u06cc\u0646\u06a9\u0647 Minecraft (\u0648 JVM \u0641\u0639\u0644\u06cc) \u0627\u0632 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc NVIDIA \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f\u060c \u0645\u0631\u0627\u062d\u0644 \u0632\u06cc\u0631 \u0631\u0627 \u062f\u0646\u0628\u0627\u0644 \u06a9\u0646\u06cc\u062f:<br/><br/>1. <strong>\u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc Java \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u0627\u06cc\u0646 \u0628\u0631\u0646\u0627\u0645\u0647 \u0627\u0632 \u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc \u0632\u06cc\u0631 \u0628\u0631\u0627\u06cc Java \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f: " + this.obtenerRutaJava() + "<br/>   - \u0627\u06af\u0631 \u0645\u0633\u06cc\u0631 \u062e\u0627\u0635\u06cc \u0645\u0634\u0627\u0647\u062f\u0647 \u0646\u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc Java \u0631\u0627 \u0628\u0627 \u062c\u0633\u062a\u062c\u0648\u06cc 'java.exe' \u062f\u0631 \u0633\u06cc\u0633\u062a\u0645 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f.<br/><br/>2. <strong>\u067e\u0646\u0644 \u06a9\u0646\u062a\u0631\u0644 NVIDIA \u0631\u0627 \u0628\u0627\u0632 \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u0631\u0648\u06cc \u062f\u0633\u06a9\u062a\u0627\u067e \u0631\u0627\u0633\u062a \u06a9\u0644\u06cc\u06a9 \u06a9\u0631\u062f\u0647 \u0648 \u06af\u0632\u06cc\u0646\u0647 '\u067e\u0646\u0644 \u06a9\u0646\u062a\u0631\u0644 NVIDIA' \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.<br/><br/>3. <strong>GPU \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0631\u0627 \u062a\u0646\u0638\u06cc\u0645 \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u062f\u0631 \u067e\u0646\u0644 \u06a9\u0646\u062a\u0631\u0644 NVIDIA\u060c \u0628\u0647 '\u0645\u062f\u06cc\u0631\u06cc\u062a \u062a\u0646\u0638\u06cc\u0645\u0627\u062a 3D' \u0628\u0631\u0648\u06cc\u062f.<br/>   - \u06af\u0632\u06cc\u0646\u0647 '\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0628\u0631\u0646\u0627\u0645\u0647 \u062e\u0627\u0635' \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.<br/>   - \u0631\u0648\u06cc '\u0627\u0641\u0632\u0648\u062f\u0646' \u06a9\u0644\u06cc\u06a9 \u06a9\u0646\u06cc\u062f \u0648 \u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc Java \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647 \u0642\u0628\u0644\u06cc (\u0645\u062b\u0644: 'java.exe') \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f.<br/>   - \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062a\u0646\u0638\u06cc\u0645 \u0634\u062f\u0647 \u0627\u0633\u062a \u062a\u0627 \u0627\u0632 '\u067e\u0631\u062f\u0627\u0632\u0646\u062f\u0647 \u0628\u0627 \u0639\u0645\u0644\u06a9\u0631\u062f \u0628\u0627\u0644\u0627 (NVIDIA)' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f.<br/><br/>4. <strong>\u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0631\u0627 \u0630\u062e\u06cc\u0631\u0647 \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0631\u0627 \u0627\u0639\u0645\u0627\u0644 \u06a9\u0631\u062f\u0647 \u0648 \u067e\u0646\u0644 \u06a9\u0646\u062a\u0631\u0644 NVIDIA \u0631\u0627 \u0628\u0628\u0646\u062f\u06cc\u062f.<br/><br/>5. <strong>Minecraft \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f:</strong><br/>   - Minecraft \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f \u062a\u0627 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0627\u0639\u0645\u0627\u0644 \u0634\u0648\u0646\u062f.<br/><br/>\u0627\u06af\u0631 \u0627\u0632 Windows Server 2022 \u06cc\u0627 Windows 10 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0627\u06cc\u0646 \u0645\u0631\u0627\u062d\u0644 \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u0645\u0639\u062a\u0628\u0631 \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 \u0622\u062e\u0631\u06cc\u0646 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0631\u062f\u0647 \u0628\u0627\u0634\u06cc\u062f.<br/><br/>\u062a\u0648\u062c\u0647: \u0627\u06af\u0631 \u0646\u062a\u0648\u0627\u0646\u0633\u062a\u06cc\u062f \u067e\u0646\u0644 \u06a9\u0646\u062a\u0631\u0644 NVIDIA \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0646\u0635\u0628 \u0634\u062f\u0647\u200c\u0627\u0646\u062f.";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0634\u06a9\u0644\u0627\u062a\u06cc \u0628\u0627 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u062f\u0631 Windows 11/Server 2025 \u06cc\u0627 \u062c\u062f\u06cc\u062f\u062a\u0631 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a.</span><br/><br/>\u0628\u0631\u0627\u06cc \u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u0627\u0632 \u0627\u06cc\u0646\u06a9\u0647 Minecraft (\u0648 JVM \u0641\u0639\u0644\u06cc) \u0627\u0632 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc NVIDIA \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f\u060c \u0645\u0631\u0627\u062d\u0644 \u0632\u06cc\u0631 \u0631\u0627 \u062f\u0646\u0628\u0627\u0644 \u06a9\u0646\u06cc\u062f:<br/><br/>1. <strong>\u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc Java \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u0627\u06cc\u0646 \u0628\u0631\u0646\u0627\u0645\u0647 \u0627\u0632 \u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc \u0632\u06cc\u0631 \u0628\u0631\u0627\u06cc Java \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f: " + this.obtenerRutaJava() + "<br/>   - \u0627\u06af\u0631 \u0645\u0633\u06cc\u0631 \u062e\u0627\u0635\u06cc \u0645\u0634\u0627\u0647\u062f\u0647 \u0646\u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc Java \u0631\u0627 \u0628\u0627 \u062c\u0633\u062a\u062c\u0648\u06cc 'java.exe' \u062f\u0631 \u0633\u06cc\u0633\u062a\u0645 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f.<br/><br/>2. <strong>\u0628\u0631\u0646\u0627\u0645\u0647 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0631\u0627 \u0628\u0627\u0632 \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u06a9\u0644\u06cc\u062f\u0647\u0627\u06cc <code>Win + I</code> \u0631\u0627 \u0641\u0634\u0627\u0631 \u062f\u0647\u06cc\u062f \u062a\u0627 \u0628\u0631\u0646\u0627\u0645\u0647 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0628\u0627\u0632 \u0634\u0648\u062f.<br/>   - \u0628\u0647 <strong>\u0633\u06cc\u0633\u062a\u0645 > \u0646\u0645\u0627\u06cc\u0634 > \u06af\u0631\u0627\u0641\u06cc\u06a9</strong> \u0628\u0631\u0648\u06cc\u062f.<br/><br/>3. <strong>GPU \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0631\u0627 \u062a\u0646\u0638\u06cc\u0645 \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u062f\u0631 \u0628\u062e\u0634 '\u06af\u0631\u0627\u0641\u06cc\u06a9'\u060c \u0631\u0648\u06cc '\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u067e\u06cc\u0634\u200c\u0641\u0631\u0636' \u06a9\u0644\u06cc\u06a9 \u06a9\u0646\u06cc\u062f.<br/>   - \u06af\u0632\u06cc\u0646\u0647 '\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u062f\u0633\u06a9\u062a\u0627\u067e' \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0631\u062f\u0647 \u0648 \u0633\u067e\u0633 \u0631\u0648\u06cc '\u0645\u0631\u0648\u0631' \u06a9\u0644\u06cc\u06a9 \u06a9\u0646\u06cc\u062f.<br/>   - \u0641\u0627\u06cc\u0644 \u0627\u062c\u0631\u0627\u06cc\u06cc Java \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647 \u0642\u0628\u0644\u06cc (\u0645\u062b\u0644: 'java.exe') \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0631\u062f\u0647 \u0648 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.<br/>   - \u067e\u0633 \u0627\u0632 \u0627\u0636\u0627\u0641\u0647 \u0634\u062f\u0646\u060c \u0628\u0631\u0646\u0627\u0645\u0647 Java \u0631\u0627 \u062f\u0631 \u0644\u06cc\u0633\u062a \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0631\u062f\u0647 \u0648 \u0622\u0646 \u0631\u0627 \u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 '\u0639\u0645\u0644\u06a9\u0631\u062f \u0628\u0627\u0644\u0627 (NVIDIA)' \u062a\u0646\u0638\u06cc\u0645 \u06a9\u0646\u06cc\u062f.<br/><br/>4. <strong>\u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0631\u0627 \u0630\u062e\u06cc\u0631\u0647 \u06a9\u0646\u06cc\u062f:</strong><br/>   - \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0631\u0627 \u0627\u0639\u0645\u0627\u0644 \u06a9\u0631\u062f\u0647 \u0648 \u0628\u0631\u0646\u0627\u0645\u0647 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0631\u0627 \u0628\u0628\u0646\u062f\u06cc\u062f.<br/><br/>5. <strong>Minecraft \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f:</strong><br/>   - Minecraft \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f \u062a\u0627 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0627\u0639\u0645\u0627\u0644 \u0634\u0648\u0646\u062f.<br/><br/>\u0627\u06af\u0631 \u0627\u0632 Windows 11 \u06cc\u0627 Windows Server 2025+ \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0627\u06cc\u0646 \u0645\u0631\u0627\u062d\u0644 \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u0645\u0639\u062a\u0628\u0631 \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 \u0622\u062e\u0631\u06cc\u0646 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0631\u062f\u0647 \u0628\u0627\u0634\u06cc\u062f.<br/><br/>\u062a\u0648\u062c\u0647: \u0627\u06af\u0631 \u0646\u062a\u0648\u0627\u0646\u0633\u062a\u06cc\u062f \u06af\u0632\u06cc\u0646\u0647 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0646\u0635\u0628 \u0634\u062f\u0647\u200c\u0627\u0646\u062f.";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0633\u0631\u0648\u0631 \u06cc\u0627 \u062f\u0646\u06cc\u0627\u06cc \u0634\u0645\u0627 \u062a\u06cc\u06a9\u200c\u0647\u0627\u06cc \u0628\u06cc\u0634 \u0627\u0632 60 \u062b\u0627\u0646\u06cc\u0647 \u062f\u0627\u0631\u062f. \u0627\u06cc\u0646 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0622\u0646 \u0628\u0627\u0634\u062f \u06a9\u0647 \u0645\u0648\u062f\u0647\u0627 \u0633\u0631\u0648\u0631 \u0631\u0627 \u06a9\u0646\u062f\u062a\u0631 \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f \u06cc\u0627 \u0633\u062e\u062a\u200c\u0627\u0641\u0632\u0627\u0631 \u062e\u06cc\u0644\u06cc \u0636\u0639\u06cc\u0641 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>RAM/\u062d\u0627\u0641\u0638\u0647 \u06a9\u0627\u0641\u06cc \u0646\u062f\u0627\u0631\u06cc\u062f. \u0628\u0627\u06cc\u062f \u062d\u0627\u0641\u0638\u0647 \u0628\u06cc\u0634\u062a\u0631\u06cc \u0627\u062e\u062a\u0635\u0627\u0635 \u062f\u0647\u06cc\u062f.</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Theseus \u0647\u0645\u0686\u0646\u06cc\u0646 \u0645\u0634\u06a9\u0644\u0627\u062a \u062f\u06cc\u06af\u0631\u06cc \u062f\u0627\u0631\u062f\u060c \u0627\u0632 \u062c\u0645\u0644\u0647 \u0639\u062f\u0645 \u062a\u0648\u0627\u0646\u0627\u06cc\u06cc \u062f\u0631 \u062d\u0630\u0641 \u0645\u0648\u062f\u0647\u0627 \u0648\u0642\u062a\u06cc \u06a9\u0647 \u0633\u0639\u06cc \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0646\u06cc\u0627\u0632 \u0628\u0647 \u0627\u062c\u0631\u0627\u06cc \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc mrpack \u062f\u0627\u0631\u06cc\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631\u06cc \u0645\u0627\u0646\u0646\u062f Prism Launcher (\u0641\u0642\u0637 \u0628\u0631\u0627\u06cc modrinth.com)\u060c ATLauncher (\u0641\u0642\u0637 \u0628\u0631\u0627\u06cc modrinth.com) \u06cc\u0627 Hello Minecraft Launcher (\u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0627\u0632 modrinth.com \u0648 bbsmc.net) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0634\u0645\u0627 \u0627\u0632 \u06af\u0632\u06cc\u0646\u0647\u0654 \u00ab\u0631\u062f \u06a9\u0631\u062f\u0646 \u0634\u0631\u0648\u0639 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u00bb (\u0628\u0631\u0646\u0627\u0645\u0647\u0654 CurseForge) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f. \u06af\u0627\u0647\u06cc \u0627\u06cc\u0646 \u0628\u0627\u0639\u062b \u0645\u0634\u06a9\u0644\u0627\u062a\u06cc \u0645\u06cc\u200c\u0634\u0648\u062f \u06a9\u0647 \u062a\u0634\u062e\u06cc\u0635 \u0622\u0646\u200c\u0647\u0627 \u062f\u0634\u0648\u0627\u0631 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0628\u0647 \u062f\u0644\u06cc\u0644 \u06af\u0632\u06cc\u0646\u0647\u0654 \u00ab\u0631\u062f \u06a9\u0631\u062f\u0646 \u0634\u0631\u0648\u0639 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u00bb \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc \u06cc\u0627 \u062c\u062f\u06cc\u062f \u0628\u0631\u0646\u0627\u0645\u0647\u0654 CurseForge \u0627\u0633\u062a. \u0622\u0646 \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f \u0648 \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a CurseForge \u0627\u0632 \u06af\u0632\u06cc\u0646\u0647\u0654 \u00abMojang Launcher\u00bb \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0646\u0645\u0627\u06cc\u06cc\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u06cc\u0646 \u0648\u06cc\u062f\u06cc\u0648\u06cc \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0627\u0632 Claws of Berk (\u062f\u0631 1:11) \u0631\u0627 <a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>\u0627\u06cc\u0646\u062c\u0627</a> \u0628\u0628\u06cc\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0647\u0634\u062f\u0627\u0631: \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u0634\u062f\u0647 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0646\u062f (\u0633\u0637\u062d \u0647\u0634\u062f\u0627\u0631). \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0645\u0634\u06a9\u0644\u06cc \u0646\u06cc\u0633\u062a\u060c \u0627\u0645\u0627 \u0647\u0645\u06cc\u0634\u0647 \u0627\u06cc\u0646\u0637\u0648\u0631 \u0646\u06cc\u0633\u062a \u2014 \u0628\u0627 \u062e\u0637\u0627\u0647\u0627\u06cc \u0641\u0627\u062a\u0627\u0644 \u0641\u0631\u0642 \u062f\u0627\u0631\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0631\u0627\u06cc\u062c \u0634\u0627\u0645\u0644 \u06a9\u0648\u0631\u0645\u062f\u0647\u0627\u06cc \u0628\u062f \u06cc\u0627 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u06af\u0645\u0634\u062f\u0647 \u0627\u0633\u062a. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 QuickFix \u0628\u0631\u0627\u06cc \u062c\u0633\u062a\u062c\u0648\u06cc \u0645\u0648\u062f\u0647\u0627\u06cc \u062f\u0627\u0631\u0627\u06cc \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u0634\u062f\u0647 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u0634\u062f\u0647 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647:</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0646\u062a\u06cc\u062c\u0647\u200c\u0627\u06cc \u06cc\u0627\u0641\u062a \u0646\u0634\u062f</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0645\u06a9\u0627\u0646\u200c\u0647\u0627\u06cc \u0644\u0627\u06af\u200c\u0647\u0627:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0627\u06cc\u0646\u062c\u0627 \u0646\u062a\u0627\u06cc\u062c \u0628\u0631\u0631\u0633\u06cc\u200c\u0647\u0627\u06cc \u0634\u0645\u0627 \u0622\u0645\u062f\u0647 \u0627\u0633\u062a. \u0622\u0631\u0627\u0645 \u067e\u06cc\u0634 \u0628\u0631\u0648\u06cc\u062f\u061b \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0639\u0644\u062a \u062f\u0631\u0633\u062a \u062f\u0631 \u0628\u0631\u0631\u0633\u06cc \u06f1 \u06cc\u0627 \u06f2 \u0642\u0631\u0627\u0631 \u062f\u0627\u0631\u062f. \u0628\u0642\u06cc\u0647 (\u062e\u0637\u0627\u0647\u0627\u06cc \u06f3 \u0628\u0647 \u0628\u0639\u062f) \u0631\u0627 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646 \u0628\u0631\u0627\u06cc \u062a\u0623\u06cc\u06cc\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0631\u062f\u060c \u0627\u0645\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u062e\u0637\u0627\u0647\u0627\u06cc \u0632\u0646\u062c\u06cc\u0631\u0647\u200c\u0627\u06cc \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0646\u0627\u062f\u06cc\u062f\u0647 \u0628\u06af\u06cc\u0631\u06cc\u062f. \u062e\u0637\u0627\u0647\u0627 \u0628\u0647 \u0635\u0648\u0631\u062a \u0644\u0627\u06cc\u0647\u200c\u0627\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u0646\u062f\u060c \u0628\u0646\u0627\u0628\u0631\u0627\u06cc\u0646 \u062d\u0644 \u0645\u0634\u06a9\u0644 \u0627\u0635\u0644\u06cc \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0631\u0627 \u0631\u0641\u0639 \u0645\u06cc\u200c\u06a9\u0646\u062f. \u0628\u0627 \u0627\u06cc\u0646 \u062d\u0627\u0644\u060c \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0641\u0631\u062f\u0627 \u062e\u0637\u0627\u06cc \u062c\u062f\u06cc\u062f\u06cc \u06a9\u0647 \u0628\u0627 \u062e\u0637\u0627\u06cc \u0641\u0639\u0644\u06cc \u0631\u0627\u0628\u0637\u0647\u200c\u0627\u06cc \u0646\u062f\u0627\u0631\u062f \u0638\u0627\u0647\u0631 \u0634\u0648\u062f\u060c \u0686\u0648\u0646 \u0627\u063a\u0644\u0628 \u06cc\u06a9 \u062e\u0637\u0627 \u0645\u0627\u0646\u0639 \u0646\u0645\u0627\u06cc\u0634 \u062e\u0637\u0627\u06cc \u062f\u06cc\u06af\u0631 \u062f\u0631 \u06a9\u0646\u0633\u0648\u0644 \u0645\u06cc\u200c\u0634\u0648\u062f.</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0637\u0641\u0627\u064b \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc 1.17-1.20.4 \u0627\u0632 Java 17 \u0648 \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062c\u062f\u06cc\u062f\u062a\u0631 \u0627\u0632 Java 21 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc\u200c\u062a\u0631 \u0627\u0632 Java 8 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. [\u0631\u0627\u0647\u0646\u0645\u0627](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). \u0627\u06af\u0631 \u0647\u0645\u0686\u0646\u0627\u0646 \u0645\u0634\u06a9\u0644 \u062f\u0627\u0631\u06cc\u062f\u060c \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0627\u06cc\u0646 \u0628\u0627\u0634\u062f \u06a9\u0647 \u0628\u0631\u062e\u06cc \u0627\u0632 \u0645\u0648\u062f\u0647\u0627 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u062e\u06cc\u0644\u06cc \u0642\u062f\u06cc\u0645\u06cc \u06cc\u0627 \u062e\u06cc\u0644\u06cc \u062c\u062f\u06cc\u062f \u062f\u0627\u0631\u0646\u062f.</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 22 \u0648 \u0628\u0627\u0644\u0627\u062a\u0631 \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc Minecraft \u0632\u06cc\u0631 1.20.5 \u0628\u0631\u0627\u06cc \u0628\u06cc\u0634\u062a\u0631 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u0647\u0627\u06cc \u0645\u0648\u062f \u06a9\u0627\u0631 \u0646\u0645\u06cc\u200c\u06a9\u0646\u062f \u0632\u06cc\u0631\u0627 ASM \u0645\u0646\u0633\u0648\u062e \u0634\u062f\u0647 \u0627\u0633\u062a.</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java \u0645\u0646\u0633\u0648\u062e \u0634\u062f\u0647 \u0627\u0633\u062a </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u0628\u0647 \u0645\u0627\u0698\u0648\u0644 JPMS " + mod_necesitas + " \u0627\u0632 " + submod + " \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646 " + metodo + " \u0631\u0627 \u0641\u0631\u0627\u062e\u0648\u0627\u0646\u06cc \u06a9\u0631\u062f \u0632\u06cc\u0631\u0627 " + objeto + " \u0628\u0631\u0627\u0628\u0631 \u0628\u0627 null \u0627\u0633\u062a</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "\u062a\u062d\u0644\u06cc\u0644 \u067e\u06cc\u0634\u0631\u0641\u062a\u0647";
    }

    @Override
    public String seleccionarCarpeta() {
        return "\u0627\u0646\u062a\u062e\u0627\u0628 \u067e\u0648\u0634\u0647";
    }

    @Override
    public String cadenaBusqueda() {
        return "\u0631\u0634\u062a\u0647 \u062c\u0633\u062a\u062c\u0648";
    }

    @Override
    public String usarRegex() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0639\u0628\u0627\u0631\u062a \u0645\u0646\u0638\u0645 (Regex)";
    }

    @Override
    public String ignorarMayusculas() {
        return "\u0646\u0627\u062f\u06cc\u062f\u0647 \u06af\u0631\u0641\u062a\u0646 \u062d\u0631\u0648\u0641 \u0628\u0632\u0631\u06af";
    }

    @Override
    public String buscar() {
        return "\u062c\u0633\u062a\u062c\u0648";
    }

    @Override
    public String busquedaEnProgreso() {
        return "\u062c\u0633\u062a\u062c\u0648 \u062f\u0631 \u062d\u0627\u0644 \u0627\u0646\u062c\u0627\u0645 \u0627\u0633\u062a";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "\u0646\u062a\u06cc\u062c\u0647\u200c\u0627\u06cc \u06cc\u0627\u0641\u062a \u0646\u0634\u062f";
    }

    @Override
    public String errorBusqueda() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062c\u0633\u062a\u062c\u0648";
    }

    @Override
    public String omitirYCerrar() {
        return "\u0631\u062f \u06a9\u0631\u062f\u0646 \u0648 \u0628\u0633\u062a\u0646";
    }

    @Override
    public String guardarYCerrar() {
        return "\u0630\u062e\u06cc\u0631\u0647 \u0648 \u0628\u0633\u062a\u0646";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "\u0644\u0627\u06af\u200c\u0647\u0627 \u0631\u0627 \u0627\u06cc\u0646\u062c\u0627 \u0642\u0631\u0627\u0631 \u062f\u0647\u06cc\u062f";
    }

    @Override
    public String archivo() {
        return "\u0641\u0627\u06cc\u0644";
    }

    @Override
    public String incluir() {
        return "\u0634\u0627\u0645\u0644 \u0634\u062f\u0646";
    }

    @Override
    public String abrir() {
        return "\u0628\u0627\u0632 \u06a9\u0631\u062f\u0646";
    }

    @Override
    public String endpointDeInforme() {
        return "\u0646\u0642\u0627\u0637 \u067e\u0627\u06cc\u0627\u0646\u06cc \u06af\u0632\u0627\u0631\u0634";
    }

    @Override
    public String sitoDeLogging() {
        return "\u0648\u0628\u200c\u0633\u0627\u06cc\u062a \u062b\u0628\u062a \u0644\u0627\u06af:";
    }

    @Override
    public String apiDeLogging() {
        return "API \u062b\u0628\u062a \u0644\u0627\u06af:";
    }

    @Override
    public String anonimizarRegistros() {
        return "\u0628\u06cc\u200c\u0647\u0648\u06cc\u062a \u06a9\u0631\u062f\u0646 \u0644\u0627\u06af\u200c\u0647\u0627 (\u0628\u062a\u0627)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "\u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u06af\u0632\u0627\u0631\u0634 \u0648 \u062a\u0645\u0627\u0645 \u0644\u0627\u06af\u200c\u0647\u0627\u06cc \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647";
    }

    @Override
    public String arco() {
        return "\u0627\u06cc\u0646 \u062f\u06cc\u0627\u0644\u0648\u06af \u0628\u0647 \u0634\u0645\u0627 \u0627\u0645\u06a9\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 API SecureLogger \u062f\u0631 <a href=\"https://securelogger.net\">securelogger.net</a> \u0644\u0627\u06af\u200c\u0647\u0627 \u0631\u0627 \u0628\u0647 \u0627\u0634\u062a\u0631\u0627\u06a9 \u0628\u06af\u0630\u0627\u0631\u06cc\u062f. \u0628\u0627 \u0641\u0634\u0631\u062f\u0646 \u062f\u06a9\u0645\u0647\u0654 \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u06af\u0632\u0627\u0631\u0634\u060c \u06af\u0632\u0627\u0631\u0634 \u0634\u0645\u0627 \u0628\u0647 \u0646\u0642\u0637\u0647\u0654 \u067e\u0627\u06cc\u0627\u0646\u06cc \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647 (\u067e\u06cc\u0634\u200c\u0641\u0631\u0636: asbestosstar.egoism.jp) \u0627\u0631\u0633\u0627\u0644 \u0645\u06cc\u200c\u0634\u0648\u062f (\u0642\u0627\u0628\u0644 \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0631 \u067e\u0627\u06cc\u06cc\u0646). \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u062a\u0645\u0627\u0645 \u0644\u0627\u06af\u200c\u0647\u0627\u06cc \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647 \u0631\u0627 \u0647\u0645\u0631\u0627\u0647 \u0628\u0627 \u06af\u0632\u0627\u0631\u0634 \u0628\u0647 \u0627\u0634\u062a\u0631\u0627\u06a9 \u0628\u06af\u0630\u0627\u0631\u06cc\u062f. \u0627\u06af\u0631 \u0646\u0645\u06cc\u200c\u062e\u0648\u0627\u0647\u06cc\u062f \u0622\u067e\u0644\u0648\u062f \u06a9\u0646\u06cc\u062f\u060c \u0627\u0632 \u0627\u06cc\u0646 \u062f\u06cc\u0627\u0644\u0648\u06af \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0646\u06a9\u0646\u06cc\u062f! \u0645\u0627 \u06af\u0632\u0627\u0631\u0634 \u0634\u0645\u0627 \u0631\u0627 \u062f\u0631 \u0646\u0642\u0637\u0647\u0654 \u067e\u0627\u06cc\u0627\u0646\u06cc \u0631\u0633\u0645\u06cc \u067e\u0631\u062f\u0627\u0632\u0634 \u0646\u0645\u06cc\u200c\u06a9\u0646\u06cc\u0645 (<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>)\u061b \u0641\u0642\u0637 \u0644\u06cc\u0646\u06a9\u200c\u0647\u0627\u06cc \u063a\u06cc\u0631\u0645\u062c\u0627\u0632 \u0631\u0627 \u062d\u0630\u0641 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u0645. \u06a9\u062f \u0645\u0646\u0628\u0639 \u0627\u06cc\u0646\u062c\u0627 \u0627\u0633\u062a: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">\u06a9\u062f \u0645\u0646\u0628\u0639</a>. \u0627\u06cc\u0646 \u0641\u0642\u0637 \u0628\u0631\u0627\u06cc \u0646\u0645\u0627\u06cc\u0634 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 crash \u0634\u0645\u0627 \u0648 \u0644\u06cc\u0646\u06a9 \u0644\u0627\u06af\u200c\u0647\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f. \u0628\u0627 \u0627\u06cc\u0646 \u062d\u0627\u0644\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u06cc\u06a9 \u0646\u0642\u0637\u0647\u0654 \u067e\u0627\u06cc\u0627\u0646\u06cc \u0633\u0641\u0627\u0631\u0634\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0647\u0645\u0627\u0646 \u0631\u0648\u0634\u200c\u0647\u0627 \u0631\u0627 \u0646\u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f. \u0634\u0645\u0627 \u0627\u0632 \u0633\u0627\u06cc\u062a \u06af\u0632\u0627\u0631\u0634 " + Config.obtenerInstancia().obtenerSitoDeInformes() + " \u0648 \u0633\u0627\u06cc\u062a \u0644\u0627\u06af " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + " \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f. \u0647\u0645\u0686\u0646\u06cc\u0646 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0628\u0627 \u0641\u0634\u0631\u062f\u0646 \u062f\u06a9\u0645\u0647\u200c\u0647\u0627\u06cc \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u06a9\u0646\u0627\u0631 \u0646\u0627\u0645 \u0644\u0627\u06af\u200c\u0647\u0627\u06cc \u0641\u0631\u062f\u06cc\u060c \u0644\u0627\u06af\u200c\u0647\u0627\u06cc \u062c\u062f\u0627\u06af\u0627\u0646\u0647 \u0631\u0627 \u0628\u062f\u0648\u0646 \u06af\u0632\u0627\u0631\u0634 \u0628\u0647 \u0627\u0634\u062a\u0631\u0627\u06a9 \u0628\u06af\u0630\u0627\u0631\u06cc\u062f\u061b \u0644\u0627\u06af\u200c\u0647\u0627 \u0628\u0647 \u0633\u0627\u06cc\u062a \u0644\u0627\u06af \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647 \u0627\u0631\u0633\u0627\u0644 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f. CrashDetector \u062f\u0627\u0631\u0627\u06cc \u0646\u0627\u0634\u0646\u0627\u0633\u200c\u0633\u0627\u0632\u06cc \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 \u0644\u0627\u06af \u0627\u0633\u062a \u06a9\u0647 \u0633\u0639\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f \u0646\u0627\u0645 \u06a9\u0627\u0631\u0628\u0631\u06cc\u060c UUID\u060c \u062a\u0648\u06a9\u0646\u200c\u0647\u0627\u06cc \u062f\u0633\u062a\u0631\u0633\u06cc\u060c ID\u0647\u0627\u06cc \u0646\u0634\u0633\u062a\u060c \u0622\u062f\u0631\u0633\u200c\u0647\u0627\u06cc IP \u0648 \u0633\u0627\u06cc\u0631 \u062f\u0627\u062f\u0647\u200c\u0647\u0627 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u062f. \u0628\u0627 \u0627\u06cc\u0646 \u062d\u0627\u0644\u060c \u06a9\u0627\u0645\u0644 \u0646\u06cc\u0633\u062a. \u0628\u0627 \u0627\u06cc\u0646 \u0648\u062c\u0648\u062f\u060c \u0633\u0627\u0632\u0646\u062f\u0647\u0654 modpack \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0622\u0646 \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u062f. \u0627\u06cc\u0646 \u0642\u0627\u0628\u0644\u06cc\u062a \u0631\u0627 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646 \u0628\u0627 \u06a9\u0627\u062f\u0631 \u0639\u0644\u0627\u0645\u062a\u200c\u06af\u0630\u0627\u0631\u06cc \u062f\u0631 \u067e\u0627\u06cc\u06cc\u0646 \u0627\u06cc\u0646 \u0635\u0641\u062d\u0647 \u0641\u0639\u0627\u0644 \u06cc\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0631\u062f. \u0634\u0645\u0627 \u06a9\u0646\u062a\u0631\u0644\u200c\u06a9\u0646\u0646\u062f\u0647\u0654 \u062f\u0627\u062f\u0647\u200c\u0647\u0627\u06cc \u062e\u0648\u062f \u0647\u0633\u062a\u06cc\u062f\u061b \u0634\u0645\u0627 \u062a\u0635\u0645\u06cc\u0645 \u0645\u06cc\u200c\u06af\u06cc\u0631\u06cc\u062f \u062f\u0627\u062f\u0647\u200c\u0647\u0627\u06cc\u062a\u0627\u0646 \u0631\u0627 \u06a9\u062c\u0627 \u0622\u067e\u0644\u0648\u062f \u06a9\u0646\u06cc\u062f. \u0633\u0627\u06cc\u062a\u200c\u0647\u0627\u06cc \u0644\u0627\u06af \u0645\u062a\u0639\u0644\u0642 \u0628\u0647 \u0634\u062e\u0635 \u062b\u0627\u0644\u062b \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 \u0645\u0627\u0644\u06a9\u06cc\u062a \u0622\u0646\u200c\u0647\u0627 \u0627\u063a\u0644\u0628 \u0628\u0647 \u062f\u0644\u0627\u06cc\u0644 \u062d\u0631\u06cc\u0645 \u062e\u0635\u0648\u0635\u06cc \u067e\u0646\u0647\u0627\u0646 \u0627\u0633\u062a. \u0634\u0645\u0627 \u0645\u0633\u0626\u0648\u0644\u06cc\u062a \u06a9\u0627\u0645\u0644 \u0645\u062f\u06cc\u0631\u06cc\u062a \u062f\u0627\u062f\u0647\u200c\u0647\u0627\u06cc \u062e\u0648\u062f \u0648 \u0631\u06cc\u0633\u06a9\u200c\u0647\u0627\u06cc \u0645\u0631\u062a\u0628\u0637 \u0631\u0627 \u0628\u0631 \u0639\u0647\u062f\u0647 \u062f\u0627\u0631\u06cc\u062f. \u062f\u06cc\u0627\u0644\u0648\u06af \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc CrashDetector \u062a\u0646\u0647\u0627 \u06cc\u06a9 \u0631\u0627\u0628\u0637 \u0627\u0633\u062a \u06a9\u0647 \u0628\u0647 \u0634\u0645\u0627 \u0627\u0645\u06a9\u0627\u0646 \u0645\u062f\u06cc\u0631\u06cc\u062a \u0627\u06cc\u0646 \u0645\u0648\u0627\u0631\u062f \u0631\u0627 \u0645\u06cc\u200c\u062f\u0647\u062f. \u0622\u06af\u0627\u0647\u06cc \u0627\u0632 GDPR \u0648 ARCO \u0628\u0633\u06cc\u0627\u0631 \u0645\u0647\u0645 \u0627\u0633\u062a. \u0627\u06af\u0631 \u062f\u0631 \u0627\u0631\u0648\u067e\u0627 \u0647\u0633\u062a\u06cc\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 <a href=\"https://securelogger.top\">securelogger.top</a> \u06a9\u0647 \u062a\u0648\u0633\u0637 Hetzner \u062f\u0631 \u0622\u0644\u0645\u0627\u0646 \u0645\u06cc\u0632\u0628\u0627\u0646\u06cc \u0645\u06cc\u200c\u0634\u0648\u062f\u060c \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u0628\u0631\u0627\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u062d\u0642\u0648\u0642\u06cc \u0628\u06cc\u0634\u062a\u0631\u060c \u0644\u06cc\u0646\u06a9\u200c\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0631\u0627 \u0645\u0634\u0627\u0647\u062f\u0647 \u06a9\u0646\u06cc\u062f: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>\u060c <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>\u060c <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">\u0633\u06cc\u0627\u0633\u062a \u0627\u0633\u0627\u0633\u06cc \u062d\u0641\u0627\u0638\u062a \u0627\u0632 \u062f\u0627\u062f\u0647\u200c\u0647\u0627\u06cc \u0634\u062e\u0635\u06cc \u062f\u0631 \u0698\u0627\u067e\u0646</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "\u0644\u06cc\u0646\u06a9 \u06af\u0632\u0627\u0631\u0634:";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "\u0630\u062e\u06cc\u0631\u0647 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "\u0644\u0627\u06af \u0628\u0633\u06cc\u0627\u0631 \u0628\u0632\u0631\u06af \u0627\u0633\u062a \u0628\u0631\u0627\u06cc \u0627\u06cc\u0646 \u0633\u0627\u06cc\u062a \u062b\u0628\u062a \u0644\u0627\u06af. \u0644\u0637\u0641\u0627\u064b \u0633\u0627\u06cc\u062a \u062f\u06cc\u06af\u0631\u06cc \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f \u0648 \u062f\u0648\u0628\u0627\u0631\u0647 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0627\u0646\u062a\u0634\u0627\u0631 \u0644\u0627\u06af " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "API \u062b\u0628\u062a \u0644\u0627\u06af \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f. \u0644\u0637\u0641\u0627\u064b API \u062b\u0628\u062a \u0644\u0627\u06af \u0631\u0627 \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String errorSSL() {
        return "\u062e\u0637\u0627\u06cc SSL \u062f\u0627\u0631\u06cc\u062f. \u0627\u06cc\u0646 \u0645\u0648\u0636\u0648\u0639 \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc Java \u0631\u0627\u06cc\u062c \u0627\u0633\u062a\u060c \u0627\u0632 \u062c\u0645\u0644\u0647 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc Java 8 \u062f\u0631 \u0644\u0627\u0646\u0686\u0631 \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 Minecraft \u0648 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0645\u0648\u062c\u0648\u062f \u062f\u0631 sun.com \u0648 java.com. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0628\u0631 \u0628\u0633\u06cc\u0627\u0631\u06cc \u0627\u0632 \u062c\u0646\u0628\u0647\u200c\u0647\u0627 \u062a\u0623\u062b\u06cc\u0631 \u0645\u06cc\u200c\u06af\u0630\u0627\u0631\u062f\u060c \u0627\u0632 \u062c\u0645\u0644\u0647 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc JAR \u0646\u0635\u0628\u200c\u06a9\u0646\u0646\u062f\u0647 MinecraftForge\u060c \u0639\u0645\u0644\u06a9\u0631\u062f \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u06af\u0632\u0627\u0631\u0634\u200c\u0647\u0627\u06cc CrashDetector \u0647\u0646\u06af\u0627\u0645 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0646\u0642\u0637\u0647 \u067e\u0627\u06cc\u0627\u0646\u06cc \u067e\u06cc\u0634\u200c\u0641\u0631\u0636\u060c \u0628\u0631\u062e\u06cc \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u0627\u06cc\u0646\u062a\u0631\u0646\u062a \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u0646\u062f \u0648 \u0628\u0631\u062e\u06cc \u0633\u0627\u06cc\u062a\u200c\u0647\u0627\u06cc \u062b\u0628\u062a \u0644\u0627\u06af. \u0627\u06af\u0631 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0647\u0646\u06af\u0627\u0645 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u06af\u0632\u0627\u0631\u0634 \u062f\u0627\u0634\u062a\u06cc\u062f\u060c \u06a9\u0627\u0641\u06cc \u0627\u0633\u062a \u06cc\u06a9 \u0639\u06a9\u0633 \u0627\u0632 \u0635\u0641\u062d\u0647 \u0636\u0645\u06cc\u0645\u0647 \u06a9\u0646\u06cc\u062f \u0648 \u0633\u0627\u06cc\u062a \u062b\u0628\u062a \u0644\u0627\u06af \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc Java 8 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0646\u0633\u062e\u0647 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 JavaFML: \u0646\u06cc\u0627\u0632 \u0628\u0647 \u0646\u0633\u062e\u0647 " + requerido + "\u060c \u067e\u06cc\u062f\u0627 \u0634\u062f\u0647 " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u062a\u0648\u062c\u0647! JavaFML \u0628\u0647 \u0646\u0633\u062e\u0647 \u062e\u0627\u0635\u06cc \u0627\u0632 Minecraft Forge \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0627\u06cc\u0644 JAR '" + archivoJar + "' \u0628\u0647 \u0627\u0631\u0627\u0626\u0647\u200c\u062f\u0647\u0646\u062f\u0647 \u0632\u0628\u0627\u0646 '" + proveedor + "' \u0646\u0633\u062e\u0647 '" + requerido + "' \u06cc\u0627 \u0628\u0627\u0644\u0627\u062a\u0631 \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f\u060c \u0627\u0645\u0627 \u0641\u0642\u0637 \u0646\u0633\u062e\u0647 '" + encontrado + "' \u067e\u06cc\u062f\u0627 \u0634\u062f.</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0647\u0634\u062f\u0627\u0631! Crash Assistant \u06cc\u06a9 \u062a\u0634\u062e\u06cc\u0635\u200c\u062f\u0647\u0646\u062f\u0647 \u0628\u062f\u0627\u0641\u0632\u0627\u0631 \u062c\u0639\u0644\u06cc \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0628\u0631\u0646\u0627\u0645\u0647 \u0628\u0647\u200c\u0637\u0648\u0631 \u0639\u0645\u062f\u06cc \u0628\u0627\u0632\u06cc \u0631\u0627 \u0627\u0632 \u0627\u062c\u0631\u0627\u06cc \u0634\u0631\u0648\u0639 \u0645\u0633\u062f\u0648\u062f \u0645\u06cc\u200c\u06a9\u0646\u062f \u0648 \u0622\u0632\u0627\u062f\u06cc \u0634\u0645\u0627 \u0628\u0631\u0627\u06cc \u0627\u062f\u0627\u0645\u0647 \u0628\u0627\u0632\u06cc \u0628\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0647\u062f\u0641\u200c\u06af\u06cc\u0631\u06cc\u200c\u0634\u062f\u0647 \u0631\u0627 \u0646\u0627\u062f\u06cc\u062f\u0647 \u0645\u06cc\u200c\u06af\u06cc\u0631\u062f. <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>\u0645\u0634\u0627\u0647\u062f\u0647 \u06a9\u062f MalwareMod.java</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>\u0645\u0634\u0627\u0647\u062f\u0647 \u06a9\u062f JarInJarHelper.java</a>. \u062f\u0631 \u062d\u0627\u0644 \u062d\u0627\u0636\u0631 \u0641\u0642\u0637 \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u062f\u0631 \u0644\u06cc\u0633\u062a \u0622\u0646\u0647\u0627 \u0642\u0631\u0627\u0631 \u062f\u0627\u0631\u062f \u0648 \u062f\u0631 \u0648\u0627\u0642\u0639 \u0641\u0642\u0637 \u0628\u0647 \u0633\u0627\u06cc\u062a \u062b\u0628\u062a \u0644\u0627\u06af \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 \u062d\u0645\u0644\u0647 \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f \u06a9\u0647 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u062a\u0648\u0633\u0637 \u06a9\u0627\u0631\u0628\u0631 \u062a\u063a\u06cc\u06cc\u0631 \u06a9\u0646\u062f \u0648 \u0627\u06cc\u0646 \u0641\u0642\u0637 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0628\u0647\u200c\u0635\u0648\u0631\u062a \u0635\u0631\u06cc\u062d \u0627\u0632 \u0648\u06cc\u0698\u06af\u06cc \u0645\u0634\u0627\u0631\u06a9\u062a \u0644\u0627\u06af \u062f\u0627\u062e\u0644\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. CrashAssistant \u0647\u06cc\u0686 \u0628\u0631\u0631\u0633\u06cc\u200c\u0627\u06cc \u0628\u0631\u0627\u06cc \u062d\u062a\u06cc \u062a\u0639\u06cc\u06cc\u0646 \u0627\u06cc\u0646\u06a9\u0647 \u06a9\u062f\u0627\u0645 \u0633\u0627\u06cc\u062a \u062b\u0628\u062a \u0644\u0627\u06af \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f \u0627\u0646\u062c\u0627\u0645 \u0646\u0645\u06cc\u200c\u062f\u0647\u062f \u0648 \u0646\u062d\u0648\u0647 \u062a\u063a\u06cc\u06cc\u0631 \u0622\u0646 \u0631\u0627 \u062a\u0648\u0636\u06cc\u062d \u0646\u0645\u06cc\u200c\u062f\u0647\u062f (\u06cc\u06a9 \u0645\u0646\u0648\u06cc \u06a9\u0634\u0648\u06cc\u06cc \u062f\u0631 \u067e\u0627\u06cc\u06cc\u0646 \u062c\u0639\u0628\u0647 \u0645\u062d\u0627\u0648\u0631\u0647\u200c\u0627\u06cc \u0627\u0634\u062a\u0631\u0627\u06a9 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f) \u0648 \u0635\u0631\u0641\u200c\u0646\u0638\u0631 \u0627\u0632 \u0627\u06cc\u0646\u06a9\u0647 \u0686\u0647 \u0633\u0627\u06cc\u062a\u06cc \u062a\u0646\u0638\u06cc\u0645 \u06a9\u0631\u062f\u0647\u200c\u0627\u06cc\u062f\u060c CrashAssistant \u0627\u062c\u0631\u0627\u06cc \u0628\u0627\u0632\u06cc \u0631\u0627 \u0645\u0633\u062f\u0648\u062f \u062e\u0648\u0627\u0647\u062f \u06a9\u0631\u062f. \u062f\u0631 \u067e\u06cc\u0627\u0645 \u0622\u0646\u0647\u0627 \u0627\u0634\u0627\u0631\u0647 \u0634\u062f\u0647 \u06a9\u0647 \u062a\u062d\u0642\u06cc\u0642\u0627\u062a \u062e\u0648\u062f \u0631\u0627 \u0627\u0646\u062c\u0627\u0645 \u062f\u0647\u06cc\u062f\u060c \u0627\u06cc\u0646 \u06a9\u0627\u0631 \u0631\u0627 \u0627\u0646\u062c\u0627\u0645 \u062f\u0647\u06cc\u062f\u060c \u0628\u0647 \u06a9\u062f CrashDetector \u0648 Crash Assistant \u0646\u06af\u0627\u0647 \u06a9\u0646\u06cc\u062f \u0648 \u062f\u0631\u06a9 \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0686\u0647 \u06a9\u0627\u0631\u06cc \u0627\u0646\u062c\u0627\u0645 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f\u060c \u0628\u0647 \u0627\u0633\u062a\u062f\u0644\u0627\u0644 \u0627\u0642\u062a\u0628\u0627\u0633 \u0628\u0647 \u0645\u0642\u0627\u0645 \u0627\u0639\u062a\u0645\u0627\u062f \u0646\u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + idMod + "' \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0639\u062f\u0645 \u06cc\u0627\u0641\u062a\u0646 \u06a9\u0644\u0627\u0633 \u0645\u0648\u0631\u062f \u0646\u06cc\u0627\u0632 \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f\u0647 \u0627\u0633\u062a: '" + claseNoEncontrada + "'. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062a\u0645\u0627\u0645 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0646\u0635\u0628 \u0634\u062f\u0647\u200c\u0627\u0646\u062f.</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia \u0628\u0627\u0632\u06cc \u0628\u0627 TLauncher \u0631\u0627 \u0645\u0633\u062f\u0648\u062f \u06a9\u0631\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0627\u0632 Optifine \u0628\u0631\u0627\u06cc \u06cc\u06a9 \u0646\u0633\u062e\u0647 \u0645\u0646\u0633\u0648\u062e \u0634\u062f\u0647 \u0627\u0632 Minecraft \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f. \u0628\u0627\u06cc\u062f \u0627\u0632 \u0646\u0633\u062e\u0647 Optifine \u0645\u062a\u0646\u0627\u0633\u0628 \u0628\u0627 \u0646\u0633\u062e\u0647 Minecraft \u06a9\u0647 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0633\u0631\u0648\u06cc\u0633 ModLauncher \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0634\u062f: </b>" + servicio + ".";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627 \u062f\u0631 \u062a\u062c\u0632\u06cc\u0647 \u0641\u0627\u06cc\u0644 JSON '" + recurso + "' \u0627\u0632 \u0641\u0627\u06cc\u0644 JAR '" + archivoJar + "'. \u0645\u0634\u06a9\u0644\u0627\u062a\u06cc \u0628\u0627 \u062b\u0628\u062a \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627: \u0645\u0648\u062f '" + modId + "' \u0628\u0647 \u0646\u0633\u062e\u0647 '" + requerido + "' \u06cc\u0627 \u0628\u0627\u0644\u0627\u062a\u0631 \u0627\u0632 '" + dependencia + "' \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f\u060c \u0627\u0645\u0627 '" + actual + "' \u067e\u06cc\u062f\u0627 \u0634\u062f.</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06af\u0631\u0627\u0641\u06cc\u06a9 \u0634\u0645\u0627 \u0627\u0632 \u0646\u0633\u062e\u0647 \u0645\u0648\u0631\u062f \u0646\u06cc\u0627\u0632 OpenGL \u0628\u0631\u0627\u06cc \u0627\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0628\u0627\u0632\u06cc \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0646\u0645\u06cc\u200c\u06a9\u0646\u062f. \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc \u062e\u0648\u062f \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u062e\u0648\u062f \u0631\u0627 \u0639\u0648\u0636 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u062d\u0627\u0641\u0638\u0647 \u0627\u062e\u062a\u0635\u0627\u0635 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647 \u0628\u0647 \u0628\u0627\u0632\u06cc \u0631\u0627 \u0627\u0641\u0632\u0627\u06cc\u0634 \u062f\u0647\u06cc\u062f \u06cc\u0627 \u0645\u0635\u0631\u0641 \u0645\u0648\u062f\u0647\u0627/\u067e\u0644\u0627\u06af\u06cc\u0646\u200c\u0647\u0627 \u0631\u0627 \u06a9\u0627\u0647\u0634 \u062f\u0647\u06cc\u062f</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>JVM 32 \u0628\u06cc\u062a\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f: \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0628\u06cc\u0634 \u0627\u0632 4 \u06af\u06cc\u06af\u0627\u0628\u0627\u06cc\u062a \u0631\u0645 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f. \u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u062a\u0645\u0627\u0645 \u062d\u0627\u0641\u0638\u0647 \u0645\u0648\u062c\u0648\u062f\u060c JVM 64 \u0628\u06cc\u062a\u06cc \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc \u062f\u0631 \u062d\u0627\u0641\u0638\u0647 PermGen. \u0641\u0636\u0627\u06cc \u062d\u0627\u0641\u0638\u0647 \u062f\u0627\u0626\u0645\u06cc \u0631\u0627 \u0627\u0641\u0632\u0627\u06cc\u0634 \u062f\u0647\u06cc\u062f \u06cc\u0627 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0644\u0627\u0633\u200c\u0647\u0627 \u0631\u0627 \u06a9\u0627\u0647\u0634 \u062f\u0647\u06cc\u062f</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0628\u06cc\u0646 Java 8 \u0648 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0645\u062f\u0631\u0646</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+ \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0646\u0645\u06cc\u200c\u0634\u0648\u062f - \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc Forge \u0627\u0632 Java 8 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8 \u0645\u0648\u0631\u062f \u0646\u06cc\u0627\u0632 \u0627\u0633\u062a (\u0646\u0633\u062e\u0647 52.0). \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u06a9\u0646\u06cc\u062f</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc \u0633\u0627\u0632\u06af\u0627\u0631\u06cc: \u0628\u0644\u0648\u06a9\u200c\u0647\u0627 \u062f\u0631 \u0627\u06cc\u0646 \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0646\u0645\u06cc\u200c\u0634\u0648\u0646\u062f. \u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u062d\u0627\u0635\u0644 \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0645\u0648\u062f\u0647\u0627 \u0648 \u0633\u0631\u0648\u0631 \u0633\u0627\u0632\u06af\u0627\u0631 \u0647\u0633\u062a\u0646\u062f</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627 \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0645\u0627\u0646\u06cc\u062a\u0648\u0631: \u062a\u0646\u0638\u06cc\u0645 \u062d\u0627\u0644\u062a \u0635\u0641\u062d\u0647 \u0646\u0645\u0627\u06cc\u0634 \u0627\u0645\u06a9\u0627\u0646\u200c\u067e\u0630\u06cc\u0631 \u0646\u0628\u0648\u062f. \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f:</b><br>- \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0686\u0646\u062f \u0645\u0627\u0646\u06cc\u062a\u0648\u0631\u06cc<br>- \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc \u06a9\u0627\u0631\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9 \u0628\u0647\u200c\u0631\u0648\u0632 \u0634\u062f\u0647<br>- \u0631\u0632\u0648\u0644\u0648\u0634\u0646 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc\u200c\u0634\u062f\u0647 \u062a\u0648\u0633\u0637 \u0633\u06cc\u0633\u062a\u0645";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627 \u062f\u0631 \u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627\u06cc \u062c\u0627\u0648\u0627: \u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627\u06cc \u0632\u0628\u0627\u0644\u0647\u200c\u062c\u0645\u0639\u200c\u06a9\u0646 \u062f\u0631 \u062a\u0636\u0627\u062f \u0647\u0633\u062a\u0646\u062f. \u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u062d\u0627\u0635\u0644 \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0686\u0646\u062f\u06cc\u0646 \u0627\u0644\u06af\u0648\u0631\u06cc\u062a\u0645 GC \u0631\u0627 \u062f\u0631 \u067e\u0627\u0631\u0627\u0645\u062a\u0631\u0647\u0627\u06cc JVM \u062a\u0631\u06a9\u06cc\u0628 \u0646\u06a9\u0646\u06cc\u062f</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc NightConfig/Forge: \u0641\u0627\u06cc\u0644 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u062e\u0631\u0627\u0628 \u06cc\u0627 \u0646\u0627\u0642\u0635 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u062e\u0627\u0644\u06cc (\u0627\u063a\u0644\u0628 \u06f0 \u0628\u0627\u06cc\u062a) \u062f\u0631 \u067e\u0648\u0634\u0647\u0654 'config' \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc \u06cc\u0627 \u0633\u0641\u0627\u0631\u0634\u06cc NightConfig \u0631\u062e \u062f\u0647\u062f. \u0628\u0631\u0627\u06cc \u0627\u06a9\u062b\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u060c Night Config Fixes \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u062d\u0644 \u0645\u06cc\u200c\u06a9\u0646\u062f\u060c \u0627\u0645\u0627 \u0627\u06af\u0631 \u0627\u0632 \u0646\u0633\u062e\u0647\u0654 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u06cc\u0627 \u0633\u0641\u0627\u0631\u0634\u06cc NightConfig \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0628\u0627\u06cc\u062f \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u0631\u0627 \u0628\u0647 \u0635\u0648\u0631\u062a \u062f\u0633\u062a\u06cc \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc MC Forge (\u06a9\u0647 \u0634\u0627\u0645\u0644 NightConfig \u0647\u0633\u062a\u0646\u062f) \u0648 \u062f\u0631 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc FabricMC \u06a9\u0647 NightConfig \u0631\u0627 \u0647\u0645\u0631\u0627\u0647 \u062f\u0627\u0631\u0646\u062f\u060c \u0631\u0627\u06cc\u062c\u200c\u062a\u0631 \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u062f\u0631 \u0628\u0631\u062e\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0633\u0641\u0627\u0631\u0634\u06cc NightConfig \u0646\u06cc\u0632 \u0648\u062c\u0648\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f. \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0628\u06cc\u0634\u062a\u0631 \u062f\u0631\u0628\u0627\u0631\u0647\u0654 \u0631\u0627\u0647\u200c\u062d\u0644\u200c\u0647\u0627 \u062f\u0631 <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a> \u0645\u0648\u062c\u0648\u062f \u0627\u0633\u062a.</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u062f\u0631\u0627\u06cc\u0648\u0631 Intel HD Graphics \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u0631\u0627\u0647\u200c\u062d\u0644\u200c\u0647\u0627:</b><br>1. \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc Intel \u0631\u0627 \u0627\u0632 <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a> \u0628\u0647\u200c\u0631\u0648\u0632 \u06a9\u0646\u06cc\u062f (\u062d\u062f\u0627\u0642\u0644 \u0646\u0633\u062e\u0647 15.xx.xx.xx)<br>2. \u062f\u0631 Minecraft: \u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627 \u2192 \u0648\u06cc\u062f\u0626\u0648 \u2192 'Enable VBOs' \u0648 'VSync' \u0631\u0627 \u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f<br>3. 1GB-2GB \u062d\u0627\u0641\u0638\u0647 RAM \u0631\u0627 \u0628\u0647 \u0628\u0627\u0632\u06cc \u062f\u0631 \u0644\u0627\u0646\u0686\u0631 \u0627\u062e\u062a\u0635\u0627\u0635 \u062f\u0647\u06cc\u062f<br>4. \u062f\u0631 \u0637\u0648\u0644 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u060c \u0645\u0648\u0642\u062a\u0627\u064b \u0622\u0646\u062a\u06cc\u200c\u0648\u06cc\u0631\u0648\u0633/\u062f\u06cc\u0648\u0627\u0631\u0622\u062a\u0634 \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "\u0647\u0634\u062f\u0627\u0631: \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0646\u062f";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "\u062e\u0637\u0627\u06cc \u0631\u0646\u062f\u0631 \u0628\u0644\u0648\u06a9";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "\u062a\u062d\u0644\u06cc\u0644 \u0627\u0633\u062a\u06a9\u200c\u062a\u0631\u06cc\u0633";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "\u06a9\u0646\u0633\u0648\u0644 \u0646\u0627\u0642\u0635 CurseForge";
    }

    @Override
    public String nombre_de_early_window() {
        return "\u062e\u0637\u0627\u06cc \u067e\u0646\u062c\u0631\u0647 \u0627\u0648\u0644\u06cc\u0647 (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "\u0645\u0634\u06a9\u0644\u0627\u062a \u062f\u0631\u0627\u06cc\u0648\u0631 \u0648\u06cc\u062f\u0626\u0648";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "\u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u062e\u0631\u0627\u0628 MCForge";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "\u0639\u062f\u0645 \u0645\u0648\u0641\u0642\u06cc\u062a \u062f\u0631 \u062d\u0627\u0644\u062a \u0646\u0645\u0627\u06cc\u0634 (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "\u062e\u0637\u0627\u06cc \u0627\u062c\u0631\u0627\u06cc FabricMC";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "\u0645\u0627\u0698\u0648\u0644\u200c\u0647\u0627\u06cc JPMS \u06af\u0645\u200c\u0634\u062f\u0647";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "\u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0628\u062d\u0631\u0627\u0646\u06cc";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "\u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 ModLauncher";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "\u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u062c\u0627\u0648\u0627";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "\u062e\u0637\u0627\u06cc \u0645\u0646\u0627\u0628\u0639 KubeJS";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "\u0632\u0628\u0627\u0646 \u0627\u0631\u0627\u0626\u0647\u200c\u062f\u0647\u0646\u062f\u0647 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "\u062e\u0637\u0627\u06cc Litchhost";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "\u062a\u0634\u062e\u06cc\u0635 \u0628\u062f\u0627\u0641\u0632\u0627\u0631 \u06a9\u0627\u0630\u0628";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "\u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0645\u0648\u062f \u0645\u0634\u06a9\u0648\u06a9";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "\u0645\u0648\u062f\u0647\u0627\u06cc \u062a\u06a9\u0631\u0627\u0631\u06cc \u062f\u0631 ModLauncher";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0645\u0627\u0698\u0648\u0644\u200c\u0647\u0627\u06cc JPMS";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "\u0628\u0631\u0627\u06cc Iris \u0628\u0647 Sodium \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "\u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646 JSON \u062b\u0628\u062a\u200c\u0634\u062f\u0647 \u0631\u0627 \u062a\u062d\u0644\u06cc\u0644 \u06a9\u0631\u062f";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "\u062d\u0627\u0641\u0638\u0647 \u06a9\u0627\u0641\u06cc \u0646\u06cc\u0633\u062a";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "\u062e\u0637\u0627\u06cc \u0627\u0634\u0627\u0631\u0647\u200c\u06af\u0631 \u062e\u0627\u0644\u06cc (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "\u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 GC \u062c\u0627\u0648\u0627";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "OptiFine \u0642\u062f\u06cc\u0645\u06cc/\u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "\u062a\u06cc\u06a9 \u0633\u0631\u0648\u0631 \u0628\u062d\u0631\u0627\u0646\u06cc (60 \u062b\u0627\u0646\u06cc\u0647)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "\u062e\u062f\u0645\u0627\u062a ModLauncher \u0628\u0627 \u0634\u06a9\u0633\u062a \u0645\u0648\u0627\u062c\u0647 \u0634\u062f";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 SpongeMixing";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "TLauncher \u062a\u0648\u0633\u0637 WATERMeDIA \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0646\u0645\u06cc\u200c\u0634\u0648\u062f";
    }

    @Override
    public String auditorias_transformer() {
        return "\u0628\u0627\u0632\u0631\u0633\u06cc\u200c\u0647\u0627\u06cc \u062a\u0631\u0627\u0646\u0633\u0641\u0648\u0631\u0645\u0631";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u06cc\u0646\u200c\u0647\u0627 \u0646\u062a\u0627\u06cc\u062c \u0645\u062d\u062a\u0648\u0627\u06cc \u0628\u0627\u0632\u0631\u0633\u06cc\u200c\u0647\u0627\u06cc \u062a\u0631\u0627\u0646\u0633\u0641\u0648\u0631\u0645\u0631 \u062f\u0631 \u0644\u0627\u0646\u0686\u0631 \u0648\u0627\u0646\u06cc\u0644\u0627 \u0647\u0633\u062a\u0646\u062f. \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u06a9\u0645\u062a\u0631 \u062f\u0642\u06cc\u0642\u200c\u062a\u0631 \u0627\u0632 \u062a\u062d\u0644\u06cc\u0644\u200c\u06af\u0631 StackTrace \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u0644\u0627\u0646\u0686\u0631 \u0648\u0627\u0646\u06cc\u0644\u0627 \u0647\u0645\u06cc\u0634\u0647 \u0645\u062d\u062a\u0648\u0627\u06cc {} \u0631\u0627 \u0646\u062f\u0627\u0631\u062f</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "\u0627\u06cc\u0646 \u0627\u0628\u0632\u0627\u0631 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0628\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u0647 \u062f\u0646\u0628\u0627\u0644 \u0645\u0648\u062f\u0647\u0627\u06cc \u0633\u0627\u062e\u062a\u0647\u200c\u0634\u062f\u0647 \u0628\u0627 MCreator \u0628\u06af\u0631\u062f\u062f. \u0627\u06af\u0631\u0686\u0647 \u0628\u06cc\u0634\u062a\u0631 \u0645\u0648\u062f\u0647\u0627\u06cc MCreator \u062e\u0648\u0628 \u0647\u0633\u062a\u0646\u062f \u0648 \u0645\u0648\u062f\u0647\u0627\u06cc \u0639\u0627\u0644\u06cc \u0632\u06cc\u0627\u062f\u06cc \u0628\u0627 MCreator \u0633\u0627\u062e\u062a\u0647 \u0634\u062f\u0647\u200c\u0627\u0646\u062f\u060c \u06af\u0627\u0647\u06cc \u0645\u0634\u06a9\u0644\u0627\u062a\u06cc \u062f\u0627\u0631\u0646\u062f \u0648 \u0634\u0647\u0631\u062a \u0628\u062f\u06cc \u062f\u0627\u0631\u0646\u062f. \u0627\u06cc\u0646 \u0627\u0628\u0632\u0627\u0631 \u0628\u0647 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0622\u0646\u0647\u0627 \u06a9\u0645\u06a9 \u0645\u06cc\u200c\u06a9\u0646\u062f. \u062a\u0648\u062c\u0647 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u06cc\u062f \u06a9\u0647 \u062d\u062a\u06cc \u0645\u0648\u062f\u0647\u0627\u06cc \u0628\u0627 \u0627\u0645\u062a\u06cc\u0627\u0632 \u0628\u0627\u0644\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0648\u0627\u0642\u0639\u0627\u064b \u0628\u0627 MCreator \u0633\u0627\u062e\u062a\u0647 \u0646\u0634\u062f\u0647 \u0628\u0627\u0634\u0646\u062f\u061b \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u0645\u062b\u0627\u0644\u060c \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0627\u0632 \u0627\u062f\u063a\u0627\u0645 \u0628\u0627 MCreator \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u0646\u062f.";
    }

    @Override
    public String escanear() {
        return "\u0627\u0633\u06a9\u0646";
    }

    @Override
    public String cargando() {
        return "\u062f\u0631 \u062d\u0627\u0644 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc";
    }

    @Override
    public String codigo() {
        return "fa";
    }

    @Override
    public String inicioApp() {
        return "\u0634\u0631\u0648\u0639 \u0628\u0627\u0632\u06cc/\u0628\u0631\u0646\u0627\u0645\u0647";
    }

    @Override
    public String ajustesCrashDetector() {
        return "\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u062a\u0634\u062e\u06cc\u0635 \u062e\u0631\u0627\u0628\u06cc";
    }

    @Override
    public String confidencialidad() {
        return "\u062d\u0631\u06cc\u0645 \u062e\u0635\u0648\u0635\u06cc";
    }

    @Override
    public String tooltip() {
        return "\u0631\u0627\u0647\u0646\u0645\u0627\u06cc \u0627\u0628\u0632\u0627\u0631";
    }

    @Override
    public String config() {
        return "\u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc";
    }

    @Override
    public String abrirCarpeta() {
        return "\u0628\u0627\u0632 \u06a9\u0631\u062f\u0646 \u067e\u0648\u0634\u0647";
    }

    @Override
    public String actualizar() {
        return "\u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc";
    }

    @Override
    public String anadirRegistro() {
        return "\u0627\u0641\u0632\u0648\u062f\u0646 \u062b\u0628\u062a";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0632\u0628\u0627\u0646 \u0633\u06cc\u0633\u062a\u0645";
    }

    @Override
    public String volver() {
        return "\u0628\u0627\u0632\u06af\u0634\u062a";
    }

    @Override
    public String colorFondo() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647 (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "\u0631\u0646\u06af \u062f\u06a9\u0645\u0647 (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "\u0631\u0646\u06af \u062c\u0639\u0628\u0647 \u0645\u062a\u0646 (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "\u0631\u0646\u06af \u0644\u06cc\u0646\u06a9 (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "\u0631\u0646\u06af \u0639\u0646\u0648\u0627\u0646 \u06a9\u0646\u0633\u0648\u0644 (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "\u0631\u0646\u06af \u062e\u0637\u0627 (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "\u0631\u0646\u06af \u0647\u0634\u062f\u0627\u0631 (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "\u0631\u0646\u06af \u0627\u0637\u0644\u0627\u0639\u0627\u062a (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "\u0631\u0646\u06af \u0639\u0646\u0648\u0627\u0646 (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0644\u06cc\u0646\u06a9 (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "\u0641\u0642\u0637 \u062f\u0631 \u0635\u0648\u0631\u062a \u062e\u0631\u0627\u0628\u06cc CrashDetector \u0631\u0627 \u0628\u0627\u0632 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String activar_parche() {
        return "\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u067e\u0686";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "\u0647\u06cc\u0686 \u0631\u0627\u0647\u200c\u062d\u0644\u06cc \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a";
    }

    @Override
    public String error() {
        return "\u062e\u0637\u0627";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062d\u0630\u0641 Jar";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f";
    }

    @Override
    public String exito() {
        return "\u0645\u0648\u0641\u0642\u06cc\u062a";
    }

    @Override
    public String eliminar() {
        return "\u062d\u0630\u0641";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062d\u0630\u0641 \u0628\u0633\u062a\u0647";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "\u0628\u0633\u062a\u0647 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f";
    }

    @Override
    public String eliminar_paquete() {
        return "\u062d\u0630\u0641 \u0628\u0633\u062a\u0647";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "\u0647\u06cc\u0686 \u0645\u0648\u062f\u06cc \u0628\u0627 \u0628\u0633\u062a\u0647 \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "\u0627\u0645\u06a9\u0627\u0646 \u062d\u0630\u0641 \u0628\u0633\u062a\u0647 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f";
    }

    @Override
    public String eliminar_jar() {
        return "\u062d\u0630\u0641 Jar";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "\u0647\u06cc\u0686 \u0645\u0648\u062f \u062a\u06a9\u0631\u0627\u0631\u06cc \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f";
    }

    @Override
    public String archivo_no_encontrado() {
        return "\u0641\u0627\u06cc\u0644 \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f";
    }

    @Override
    public String directorio_eliminado() {
        return "\u067e\u0648\u0634\u0647 \u062d\u0630\u0641 \u0634\u062f";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062d\u0630\u0641 \u0641\u0627\u06cc\u0644 Jar \u062a\u0648 \u062f\u0631 \u062a\u0648";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "\u0641\u0627\u06cc\u0644 \u062f\u0627\u062e\u0644\u06cc \u06cc\u0627\u0641\u062a \u0646\u0634\u062f";
    }

    @Override
    public String archivo_eliminado() {
        return "\u0641\u0627\u06cc\u0644 \u062d\u0630\u0641 \u0634\u062f";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062d\u0630\u0641 \u0641\u0627\u06cc\u0644";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "\u0641\u0627\u06cc\u0644 \u062e\u0627\u0631\u062c\u06cc \u0645\u0639\u062a\u0628\u0631 \u0646\u06cc\u0633\u062a";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "\u0639\u0646\u0635\u0631 \u0645\u0648\u062f \u062d\u0630\u0641 \u0634\u062f";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646\u06cc \u0641\u0627\u06cc\u0644 Jar \u062e\u0627\u0631\u062c\u06cc";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062d\u0630\u0641 \u0639\u0646\u0635\u0631 \u0645\u0648\u062f";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u062d\u0630\u0641 \u067e\u0648\u0634\u0647";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "\u0641\u0631\u0645\u062a \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0628\u0631\u0627\u06cc \u0641\u0627\u06cc\u0644 Jar \u062a\u0648 \u062f\u0631 \u062a\u0648";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "\u0641\u0627\u06cc\u0644 Jar \u062a\u0648 \u062f\u0631 \u062a\u0648 \u062d\u0630\u0641 \u0634\u062f";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u067e\u0627\u06a9 \u06a9\u0631\u062f\u0646 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0645\u0648\u0642\u062a";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u067e\u06cc\u0627\u0645 \u0631\u062f\u06cc\u0627\u0628\u06cc \u0641\u062a\u0627\u0644 \u0622\u062e\u0631\u06cc\u0646 (\u062a\u0631\u062c\u0645\u0647 \u0646\u0634\u062f\u0647):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u067e\u06cc\u0627\u0645 \u0631\u062f\u06cc\u0627\u0628\u06cc \u0622\u062e\u0631\u06cc\u0646 (\u062a\u0631\u062c\u0645\u0647 \u0646\u0634\u062f\u0647):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u062f\u0631 \u067e\u0627\u06cc\u06af\u0627\u0647 \u062f\u0627\u062f\u0647 WaifuNeoForge \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u0648\u062f \u0645\u0646\u0627\u0633\u0628 \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f. \u0646\u0633\u062e\u0647 \u0628\u0627\u0632\u06cc\u060c \u0628\u0627\u0631\u06af\u06cc\u0631 \u0645\u0648\u062f \u0648 \u06a9\u0644\u0627\u0633 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f. \u0627\u0632 \u062a\u0631\u06a9\u06cc\u0628\u06cc \u0634\u0628\u06cc\u0647 \u0628\u0647 \u0622\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u0641\u0642\u0637 \u06cc\u06a9 \u0628\u0627\u0631 \u062f\u0631 \u062f\u0642\u06cc\u0642\u0647 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucionFaltasClases() {
        return "\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u062f\u0631 \u067e\u0627\u06cc\u06af\u0627\u0647 \u062f\u0627\u062f\u0647 WaifuNeoForge \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u0648\u062f \u0645\u0646\u0627\u0633\u0628 \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f. \u0646\u0633\u062e\u0647 \u0628\u0627\u0632\u06cc\u060c \u0628\u0627\u0631\u06af\u06cc\u0631 \u0645\u0648\u062f \u0648 \u06a9\u0644\u0627\u0633 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f. \u0627\u0632 \u062a\u0631\u06a9\u06cc\u0628\u06cc \u0634\u0628\u06cc\u0647 \u0628\u0647 \u0622\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u0641\u0642\u0637 \u06cc\u06a9 \u0628\u0627\u0631 \u062f\u0631 \u062f\u0642\u06cc\u0642\u0647 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "\u0647\u0631 \u062f\u0648 \u0644\u0627\u0646\u0686\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062f\u0631\u0633\u062a \u062c\u0627\u0648\u0627 \u0631\u0627 \u062f\u0627\u0631\u0646\u062f \u0627\u0645\u0627 \u0646\u0647 \u0647\u0645\u0647 \u0622\u0646\u0647\u0627\u061b \u0634\u0645\u0627 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0646\u0633\u062e\u0647 \u0635\u062d\u06cc\u062d \u062c\u0627\u0648\u0627 \u0631\u0627 \u0627\u0632 \u0645\u062f\u06cc\u0631 \u0628\u0633\u062a\u0647\u200c\u0647\u0627 \u062f\u0631 \u0633\u06cc\u0633\u062a\u0645 \u062e\u0648\u062f \u06cc\u0627 \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u062f\u06a9\u0645\u0647\u200c\u0647\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u062f \u0628\u0627 \u0627\u0646\u06cc\u0645\u06cc\u0634\u0646 \u06af\u0645\u0634\u062f\u0647: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException (\u062e\u0637\u0627\u06cc \u0639\u0646\u0627\u0635\u0631 \u0646\u0627\u067e\u062f\u06cc\u062f \u0634\u062f\u0647) \u0627\u0646\u06cc\u0645\u06cc\u0634\u0646 \u06af\u0645\u0634\u062f\u0647 \u0627\u0633\u062a";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "\u0647\u06cc\u0686 \u0645\u062f\u06cc \u0628\u0631\u0627\u06cc \u062d\u0630\u0641 \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "\u062c\u0627\u06cc\u06af\u0632\u06cc\u0646\u06cc \u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627\u06cc GC \u0645\u062a\u0646\u0627\u0642\u0636 \u0628\u0627 -XX:+UseG1GC";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "\u0627\u0641\u0632\u0627\u06cc\u0634 \u0627\u0646\u062f\u0627\u0632\u0647 \u062d\u0627\u0641\u0638\u0647 Heap \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u06af\u0632\u06cc\u0646\u0647 -Xmx.";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "\u0627\u0641\u0632\u0627\u06cc\u0634 \u0627\u0646\u062f\u0627\u0632\u0647 \u062d\u0627\u0641\u0638\u0647 PermGen \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u06af\u0632\u06cc\u0646\u0647 -XX:MaxPermSize.";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 JVM 64 \u0628\u06cc\u062a\u06cc \u0628\u0631\u0627\u06cc \u0627\u0641\u0632\u0627\u06cc\u0634 \u062d\u0627\u0641\u0638\u0647 \u062f\u0631 \u062f\u0633\u062a\u0631\u0633.";
    }

    @Override
    public String optimizarCodigo() {
        return "\u0628\u0647\u06cc\u0646\u0647\u200c\u0633\u0627\u0632\u06cc \u06a9\u062f \u0628\u0631\u0627\u06cc \u06a9\u0627\u0647\u0634 \u0645\u0635\u0631\u0641 \u062d\u0627\u0641\u0638\u0647 \u0648 \u0628\u0647\u0628\u0648\u062f \u0639\u0645\u0644\u06a9\u0631\u062f.";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u06cc\u06a9 \u062c\u0645\u0639\u200c\u0622\u0648\u0631\u0646\u062f\u0647 \u0632\u0628\u0627\u0644\u0647 \u06a9\u0627\u0631\u0622\u0645\u062f \u0628\u0631\u0627\u06cc \u06a9\u0627\u0647\u0634 \u062a\u0648\u0642\u0641 \u0628\u0631\u0646\u0627\u0645\u0647.";
    }

    @Override
    public String modulos() {
        return "\u0645\u0627\u0698\u0648\u0644\u200c\u0647\u0627";
    }

    @Override
    public String paquete() {
        return "\u0628\u0633\u062a\u0647";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "\u0634\u0646\u0627\u0633\u0647\u200c\u0647\u0627\u06cc\u06cc \u06af\u0645 \u0634\u062f\u0647\u200c\u0627\u0646\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0645\u062a\u062f\u0627\u0648\u0644 \u0634\u0627\u0645\u0644 \u0645\u062f \u0647\u0627\u06cc \u06af\u0645\u0634\u062f\u0647 \u06cc\u0627 \u062f\u0627\u062f\u0647\u200c\u0647\u0627\u06cc \u0622\u06cc\u062a\u0645\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0633\u062a. \u067e\u0648\u0634\u0647\u200c\u0647\u0627\u06cc \u062f\u0627\u062f\u0647 \u0645\u062a\u062f\u0627\u0648\u0644 \u0639\u0628\u0627\u0631\u062a\u0646\u062f \u0627\u0632 datafiedcontents/ \u0648 kubejs/ \u06cc\u0627 \u0633\u0627\u06cc\u0631 \u067e\u0648\u0634\u0647\u200c\u0647\u0627\u06cc \u0645\u062f.";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "\u062b\u0628\u062a\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u067e\u0644\u0627\u06af\u06cc\u0646 'AuthMe' \u062f\u0631 \u0647\u0646\u06af\u0627\u0645 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f \u0648 \u0633\u0631\u0648\u0631 \u0631\u0627 \u0645\u062a\u0648\u0642\u0641 \u06a9\u0631\u062f.</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "\u0645\u0634\u06a9\u0644 \u062e\u0627\u0645\u0648\u0634 \u0634\u062f\u0646 \u0628\u0647 \u062f\u0644\u06cc\u0644 AuthMe";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "\u0642\u0627\u0646\u0648\u0646 'stopServer' \u0628\u0647 'true' \u062a\u063a\u06cc\u06cc\u0631 \u06a9\u0631\u062f.";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "\u062a\u0646\u0638\u06cc\u0645 \u067e\u0644\u0627\u06af\u06cc\u0646 AuthMe (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "\u0646\u0635\u0628 \u0646\u0633\u062e\u0647 \u062f\u06cc\u06af\u0631\u06cc \u0627\u0632 \u067e\u0644\u0627\u06af\u06cc\u0646 'AuthMe'";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "\u062d\u0630\u0641 \u067e\u0644\u0627\u06af\u06cc\u0646 'AuthMe'";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062c\u0647\u0627\u0646 '" + nombreMundo + "' \u0642\u0627\u0628\u0644 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u06cc\u0633\u062a \u0686\u0648\u0646 \u0634\u0627\u0645\u0644 \u062e\u0637\u0627\u0647\u0627\u06cc\u06cc \u0627\u0633\u062a \u0648 \u0627\u062d\u062a\u0645\u0627\u0644\u0627\u064b \u0622\u0633\u06cc\u0628 \u062f\u06cc\u062f\u0647 \u0627\u0633\u062a.</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "\u0645\u0634\u06a9\u0644 \u062f\u0631 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062c\u0647\u0627\u0646 Multiverse";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "\u062c\u0647\u0627\u0646 '" + nombreMundo + "' \u0631\u0627 \u062a\u0639\u0645\u06cc\u0631 \u06a9\u0646\u06cc\u062f\u060c \u0645\u062b\u0644\u0627 \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 Minecraft Region Fixer \u06cc\u0627 MCEdit.";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "\u067e\u0648\u0634\u0647 \u062c\u0647\u0627\u0646 '" + nombreMundo + "' \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u0627\u0641\u0632\u0648\u0646\u0647 'PermissionsEx' \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a.</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "\u0645\u0634\u06a9\u0644 \u062f\u0631 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc PermissionsEx";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "\u062a\u0646\u0638\u06cc\u0645 \u0627\u0641\u0632\u0648\u0646\u0647 PermissionsEx (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "\u062d\u0630\u0641 \u0627\u0641\u0632\u0648\u0646\u0647 'PermissionsEx'";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0686\u0646\u062f\u06cc\u0646 \u0641\u0627\u06cc\u0644 \u0627\u0641\u0632\u0648\u0646\u0647 \u0628\u0627 \u0646\u0627\u0645 '" + nombrePlugin + "' \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f: '" + primerPath + "' \u0648 '" + segundoPath + "'.</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "\u0646\u0627\u0645 \u0627\u0641\u0632\u0648\u0646\u0647 \u0645\u0628\u0647\u0645";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "\u062d\u0630\u0641 \u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0647\u0646\u06af\u0627\u0645 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0686\u0646\u06a9\u200c\u0647\u0627 (chunks) \u062a\u0648\u0633\u0637 \u062f\u0646\u06cc\u0627\u060c \u06cc\u06a9 \u0627\u0633\u062a\u062b\u0646\u0627 \u0631\u062e \u062f\u0627\u062f. \u0627\u06af\u0631 \u0628\u0631\u0627\u06cc \u067e\u0644\u062a\u0641\u0631\u0645 \u0634\u0645\u0627 \u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0634\u062f\u060c \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a FeatureRecycler \u0628\u062a\u0648\u0627\u0646\u062f \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u062d\u0644 \u06a9\u0646\u062f. https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0686\u0627\u0646\u06a9\u200c\u0647\u0627";
    }

    @Override
    public String solucionEliminarChunk() {
        return "\u0686\u0627\u0646\u06a9 \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0631\u0627 \u0627\u0632 \u062c\u0647\u0627\u0646 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0645\u062b\u0644\u0627\u064b \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 MCEdit \u06cc\u0627 \u062d\u0630\u0641 \u0641\u0627\u06cc\u0644 \u0645\u0646\u0637\u0642\u0647.";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u062f\u0633\u062a\u0648\u0631 '/" + comando + "' \u0631\u0627 \u0627\u062c\u0631\u0627 \u06a9\u0646\u062f.</b> ";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "\u062e\u0637\u0627\u06cc \u0627\u062c\u0631\u0627\u06cc \u062f\u0633\u062a\u0648\u0631 \u0627\u0641\u0632\u0648\u0646\u0647";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "\u0646\u0635\u0628 \u0646\u0633\u062e\u0647 \u062f\u06cc\u06af\u0631\u06cc \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u0628\u0647 \u0627\u06cc\u0646 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f: '" + dependencia + "'.</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u0641\u0627\u0642\u062f \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u0644\u0627\u0632\u0645 \u0627\u0633\u062a: " + deps.toString() + ".</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "\u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0645\u0641\u0642\u0648\u062f \u0627\u0641\u0632\u0648\u0646\u0647";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "\u0646\u0635\u0628 \u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u0628\u0647 \u0646\u0633\u062e\u0647 '" + versionAPI + "' \u0627\u0632 API \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f \u06a9\u0647 \u0628\u0627 \u0633\u0631\u0648\u0631 \u0641\u0639\u0644\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a.</b>";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "\u0646\u0633\u062e\u0647 API \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "\u0646\u0633\u062e\u0647 '" + version + "' \u0627\u0632 \u0646\u0631\u0645\u200c\u0627\u0641\u0632\u0627\u0631 \u0633\u0631\u0648\u0631\u062a\u0627\u0646 \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062c\u0647\u0627\u0646 '" + nombreMundo + "' \u06cc\u06a9 \u06a9\u067e\u06cc \u0627\u0632 \u062c\u0647\u0627\u0646 \u062f\u06cc\u06af\u0631 \u0627\u0633\u062a \u0648 \u0642\u0627\u0628\u0644 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u06cc\u0633\u062a.</b>";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "\u062c\u0647\u0627\u0646 \u062a\u06a9\u0631\u0627\u0631\u06cc";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "\u0641\u0627\u06cc\u0644 'uid.dat' \u0627\u0632 \u062c\u0647\u0627\u0646 '" + nombreMundo + "' \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "\u067e\u0648\u0634\u0647 \u062c\u0647\u0627\u0646 '" + nombreMundo + "' \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0646\u0645\u0648\u0646\u0647 \u0628\u0644\u0648\u06a9\u06cc '" + nombre + "' \u0627\u0632 \u0646\u0648\u0639 '" + tipo + "' \u062f\u0631 \u0645\u0648\u0642\u0639\u06cc\u062a " + coords + " \u0628\u0627\u0639\u062b \u0627\u06cc\u062c\u0627\u062f \u062e\u0637\u0627 \u062f\u0631 ticking \u0634\u062f\u0647 \u0627\u0633\u062a.</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "\u0646\u0645\u0648\u0646\u0647 \u0628\u0644\u0648\u06a9\u06cc \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "\u0646\u0645\u0648\u0646\u0647 '" + nombre + "' \u0631\u0627 \u062f\u0631 \u0645\u0648\u0642\u0639\u06cc\u062a " + coords + " \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0645\u062b\u0644\u0627\u064b \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 MCEdit \u06cc\u0627 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u0645\u0633\u062a\u0642\u06cc\u0645 \u062f\u0646\u06cc\u0627.";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u062f\u0627\u0631\u0627\u06cc \u0686\u0646\u062f\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0646\u0635\u0628 \u0634\u062f\u0647 \u0627\u0633\u062a.</b> ";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "\u0645\u0648\u062f \u062a\u06a9\u0631\u0627\u0631\u06cc \u062f\u0631 Fabric";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "\u0641\u0627\u06cc\u0644 \u0645\u0648\u062f \u062a\u06a9\u0631\u0627\u0631\u06cc \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f\u0647\u0627\u06cc '" + primerMod + "' \u0648 '" + segundoMod + "' \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f.</b>";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "\u0645\u0648\u062f \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u062f\u0631 Fabric";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "\u0645\u0648\u062f '" + nombreMod + "' \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u062f\u0627\u0631\u0627\u06cc \u062e\u0637\u0627 \u0627\u0633\u062a \u0648 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0627\u062c\u0631\u0627 \u0634\u0648\u062f.</b> ";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "\u0645\u0648\u062f \u0628\u0627 \u062e\u0637\u0627 \u062c\u062f\u06cc";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0636\u0631\u0648\u0631\u06cc \u0647\u0633\u062a\u0646\u062f \u0648\u0644\u06cc \u0646\u0635\u0628 \u0646\u0634\u062f\u0647\u200c\u0627\u0646\u062f: " + deps.toString() + ".</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u060c \u0645\u0648\u062f '" + dependencia + "' \u0631\u0627 \u0645\u06cc\u200c\u062e\u0648\u0627\u0647\u062f.</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u0645\u0648\u062f '" + dependencia + "' \u0628\u0627 \u0646\u0633\u062e\u0647 " + version + " \u0631\u0627 \u0645\u06cc\u200c\u062e\u0648\u0627\u0647\u062f.</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "\u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0645\u0648\u062f \u06af\u0645\u0634\u062f\u0647";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "\u0645\u0648\u062f '" + nombreMod + "' \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "\u0645\u0648\u062f '" + nombreMod + "' \u0628\u0627 \u0646\u0633\u062e\u0647 " + version + " \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u0628\u0627 \u062a\u06cc\u06a9\u06cc\u0646\u06af \u0645\u0646\u0637\u0642\u0647\u200c\u0627\u06cc Folia \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a.</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0628\u0627 \u062a\u06cc\u06a9\u06cc\u0646\u06af \u0645\u0646\u0637\u0642\u0647\u200c\u0627\u06cc Folia \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u062a\u06cc\u06a9\u06cc\u0646\u06af \u0645\u0646\u0637\u0642\u0647\u200c\u0627\u06cc";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "\u06cc\u06a9 \u0646\u0633\u062e\u0647 \u0628\u062f\u0648\u0646 \u062a\u06cc\u06a9\u06cc\u0646\u06af \u0645\u0646\u0637\u0642\u0647\u200c\u0627\u06cc \u0646\u0638\u06cc\u0631 " + software + " \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u062f\u0631 \u062f\u06cc\u062a\u067e\u06a9 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f.</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u062f\u0631 \u062f\u06cc\u062a\u067e\u06a9 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f\u0646\u062f: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "\u0645\u0648\u062f \u06cc\u0627\u0641\u062a \u0646\u0634\u062f \u062f\u0631 \u062f\u06cc\u062a\u067e\u06a9";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u0628\u0627\u0639\u062b \u06cc\u06a9 \u062e\u0637\u0627 \u0634\u062f.</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0628\u0627\u0639\u062b \u062e\u0637\u0627 \u0634\u062f\u0646\u062f: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "\u0645\u0648\u062f Forge \u062f\u0627\u0631\u0627\u06cc \u062e\u0637\u0627";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "\u06cc\u06a9 \u0646\u0633\u062e\u0647 \u062f\u06cc\u06af\u0631 \u0627\u0632 \u0645\u0648\u062f '" + nombreMod + "' \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a " + versionMC + " \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u064a\u0633\u062a.</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u064a\u0633\u062a\u0646\u062f: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (\u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a ").append(versionesMC.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "\u0645\u0648\u062f \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "\u0646\u0633\u062e\u0647 \u0633\u0627\u0632\u06af\u0627\u0631 \u0641\u0648\u0631\u062c \u0628\u0631\u0627\u06cc \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a " + versionMC + " \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0648\u062f '" + nombreMod + "' \u06af\u0645\u0634\u062f\u0647 \u0648 \u0628\u0631\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062f\u0646\u06cc\u0627 \u06cc\u0627 \u0627\u0641\u0632\u0648\u0646\u0647 \u0645\u0648\u0631\u062f \u0646\u06cc\u0627\u0632 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "\u0645\u0648\u062f \u06af\u0645\u0634\u062f\u0647";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062f\u0646\u06cc\u0627 \u0628\u0627 \u0645\u0648\u062f '" + nombreMod + "' \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f \u06a9\u0647 \u0628\u0647 \u0646\u0638\u0631 \u0645\u06cc\u200c\u0631\u0633\u062f \u06af\u0645\u0634\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u062f\u0646\u06cc\u0627 \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f \u06a9\u0647 \u0628\u0647 \u0646\u0638\u0631 \u0645\u06cc\u200c\u0631\u0633\u062f \u06af\u0645\u0634\u062f\u0647\u200c\u0627\u0646\u062f: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "\u0645\u0648\u062f \u06af\u0645\u0634\u062f\u0647 \u062f\u0631 \u062f\u0646\u06cc\u0627";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062f\u0646\u06cc\u0627 \u0628\u0627 \u0645\u0648\u062f '" + nombreMod + "' \u062f\u0631 \u0646\u0633\u062e\u0647 " + versionEsperada + " \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a \u0648 \u0627\u06a9\u0646\u0648\u0646 \u0646\u0633\u062e\u0647 " + versionActual + " \u0641\u0639\u0627\u0644 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u062f\u0631 \u062f\u0646\u06cc\u0627\u06cc \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f\u0647 \u062f\u0627\u0631\u0627\u06cc \u0627\u062e\u062a\u0644\u0627\u0641 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0647\u0633\u062a\u0646\u062f: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0648 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (\u0630\u062e\u06cc\u0631\u0647 \u0634\u062f\u0647: ").append(versionesEsperadas.get(i)).append(", \u0641\u0639\u0644\u06cc: ").append(versionesActuales.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "\u0639\u062f\u0645 \u062a\u0637\u0627\u0628\u0642 \u0646\u0633\u062e\u0647 \u0645\u0648\u062f \u062f\u0631 \u062f\u0646\u06cc\u0627\u06cc \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f\u0647";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u0633\u0639\u06cc \u06a9\u0631\u062f\u06cc\u062f \u062c\u0647\u0627\u0646\u06cc \u0631\u0627 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0628\u0627 \u0646\u0633\u062e\u0647\u200c\u06cc \u062c\u062f\u06cc\u062f\u062a\u0631\u06cc \u0627\u0632 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0627\u06cc\u062c\u0627\u062f \u0634\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "\u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062f\u0646\u06cc\u0627\u06cc\u06cc \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u06cc \u062c\u062f\u06cc\u062f\u062a\u0631";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "\u0646\u0633\u062e\u0647\u200c\u06cc \u062c\u062f\u06cc\u062f\u062a\u0631\u06cc \u0627\u0632 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "\u062f\u0646\u06cc\u0627\u06cc \u062c\u062f\u06cc\u062f\u06cc \u0627\u06cc\u062c\u0627\u062f \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u0646\u06cc\u0627\u0632\u0645\u0646\u062f \u0627\u0641\u0632\u0648\u0646\u0647 '" + dependencia + "' \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0627\u0633\u062a.</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0632\u06cc\u0631 \u062f\u0627\u0631\u0627\u06cc \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u063a\u06cc\u0631\u0646\u0635\u0628\u200c\u0634\u062f\u0647 \u0647\u0633\u062a\u0646\u062f: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("' (").append(dependencias.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647 \u0628\u0627 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u06af\u0645\u0634\u062f\u0647";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u0628\u0627 \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc \u0633\u0631\u0648\u0631 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a.</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc \u0633\u0631\u0648\u0631 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u0648 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647 \u0628\u0627 PocketMine-MP \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647 '" + nombrePlugin + "' \u062f\u0631 \u0647\u0646\u06af\u0627\u0645 \u0627\u062c\u0631\u0627 \u062e\u0637\u0627 \u062f\u0627\u062f.</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0632\u06cc\u0631 \u062f\u0631 \u0647\u0646\u06af\u0627\u0645 \u0627\u062c\u0631\u0627 \u062e\u0637\u0627 \u062f\u0627\u062f\u0646\u062f: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u0648 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647 \u0628\u0627 \u062e\u0637\u0627 \u062f\u0631 \u0627\u062c\u0631\u0627";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "\u0686\u0646\u062f\u06cc\u0646 \u0631\u0634\u062a\u0647 LegacyRandomSource";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0686\u0646\u062f\u06cc\u0646 \u0631\u0634\u062a\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633 LegacyRandomSource \u062f\u0633\u062a\u0631\u0633\u06cc \u062f\u0627\u0631\u0646\u062f. \u0628\u0631\u0627\u06cc \u06a9\u0633\u0628 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0628\u06cc\u0634\u062a\u0631 \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647 'Unsafe World Random Access Detector' \u06cc\u0627 'C2ME' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "\u0627\u0632 \u0622\u062e\u0631\u06cc\u0646 \u0645\u0648\u0641\u0642\u06cc\u062a";
    }

    @Override
    public String noHayCambios() {
        return "\u0628\u062f\u0648\u0646 \u062a\u063a\u06cc\u06cc\u0631";
    }

    @Override
    public String desdeUltimoIntento() {
        return "\u0627\u0632 \u0622\u062e\u0631\u06cc\u0646 \u062a\u0644\u0627\u0634";
    }

    @Override
    public String fallo() {
        return "\u0646\u0627\u0645\u0648\u0641\u0642";
    }

    @Override
    public String diferentesDeLasMods() {
        return "\u0645\u062a\u0641\u0627\u0648\u062a \u0628\u0627 \u0645\u0648\u062f\u0647\u0627";
    }

    @Override
    public String historialDeMods() {
        return "\u062a\u0627\u0631\u06cc\u062e\u0686\u0647 \u0645\u0648\u062f\u0647\u0627";
    }

    @Override
    public String archivo0() {
        return "\u067e\u0631\u0648\u0646\u062f\u06470";
    }

    @Override
    public String archivo1() {
        return "\u067e\u0631\u0648\u0646\u062f\u06471";
    }

    @Override
    public String comparar() {
        return "\u0645\u0642\u0627\u06cc\u0633\u0647 \u06a9\u0631\u062f\u0646";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "\u0627\u0646\u062a\u062e\u0627\u0628 \u062f\u0648 \u067e\u0631\u0648\u0646\u062f\u0647";
    }

    @Override
    public String archivoExito() {
        return "\u067e\u0631\u0648\u0646\u062f\u0647 \u0645\u0648\u0641\u0642\u06cc\u062a";
    }

    @Override
    public String archivoFalla() {
        return "\u067e\u0631\u0648\u0646\u062f\u0647 \u0634\u06a9\u0633\u062a";
    }

    @Override
    public String errorComparandoArchivos() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0645\u0642\u0627\u06cc\u0633\u0647 \u067e\u0631\u0648\u0646\u062f\u0647\u200c\u0647\u0627";
    }

    @Override
    public String comparando() {
        return "\u062f\u0631 \u062d\u0627\u0644 \u0645\u0642\u0627\u06cc\u0633\u0647";
    }

    @Override
    public String con() {
        return "\u0628\u0627";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;' dir='rtl'><p><b>\u067e\u0646\u0644 \u0645\u0642\u0627\u06cc\u0633\u0647 \u062a\u0627\u0631\u06cc\u062e\u0686\u0647 \u0645\u0648\u062f\u0647\u0627</b></p><p>\u0627\u06cc\u0646 \u067e\u0646\u0644 \u0628\u0647 \u0634\u0645\u0627 \u0627\u062c\u0627\u0632\u0647 \u0645\u06cc\u200c\u062f\u0647\u062f \u062f\u0648 \u0644\u06cc\u0633\u062a \u0645\u0648\u062f \u0631\u0627 \u0627\u0632 \u062c\u0644\u0633\u0627\u062a \u0645\u062e\u062a\u0644\u0641 \u0628\u0627 \u0647\u0645 \u0645\u0642\u0627\u06cc\u0633\u0647 \u06a9\u0646\u06cc\u062f. \u06cc\u06a9 \u0641\u0627\u06cc\u0644 \u0627\u0632 \u0633\u062a\u0648\u0646 \u0686\u067e \u0648 \u06cc\u06a9\u06cc \u0627\u0632 \u0633\u062a\u0648\u0646 \u0631\u0627\u0633\u062a \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0645\u0634\u062e\u0635 \u0634\u0648\u0646\u062f.</p><h3>\u0686\u06af\u0648\u0646\u0647 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u0645:</h3><ol><li><b>\u0627\u0646\u062a\u062e\u0627\u0628 \u0641\u0627\u06cc\u0644:</b> \u0631\u0648\u06cc \u062f\u06a9\u0645\u0647\u200c\u0647\u0627\u06cc \u0631\u0627\u062f\u06cc\u0648\u06cc\u06cc \u06a9\u0646\u0627\u0631 \u0646\u0627\u0645 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u06a9\u0644\u06cc\u06a9 \u06a9\u0646\u06cc\u062f. \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0628\u0627 \u067e\u0633\u0648\u0646\u062f <span style='color: #4CAF50; font-weight: bold;'>.suceso</span> \u062c\u0644\u0633\u0627\u062a \u0645\u0648\u0641\u0642 \u0647\u0633\u062a\u0646\u062f\u060c \u062f\u0631 \u062d\u0627\u0644\u06cc \u06a9\u0647 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc <span style='color: #F44336; font-weight: bold;'>.falla</span> \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 \u062e\u0637\u0627\u0647\u0627 \u0647\u0633\u062a\u0646\u062f.</li><li><b>\u0645\u0642\u0627\u06cc\u0633\u0647 \u062e\u0648\u062f\u06a9\u0627\u0631:</b> \u0628\u0627 \u0641\u0634\u0627\u0631 \u062f\u0627\u062f\u0646 \u062f\u06a9\u0645\u0647 'Compare' \u0633\u06cc\u0633\u062a\u0645 \u062f\u0648 \u0644\u06cc\u0633\u062a \u0627\u0646\u062a\u062e\u0627\u0628\u06cc \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0631\u062f\u0647 \u0648 \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u0636\u0627\u0641\u0647 \u0634\u062f\u0647 (+) \u06cc\u0627 \u062d\u0630\u0641 \u0634\u062f\u0647 (-) \u0631\u0627 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f.</li><li><b>\u0645\u0634\u0627\u0647\u062f\u0647 \u0646\u062a\u0627\u06cc\u062c:</b> \u0646\u062a\u0627\u06cc\u062c \u062f\u0631 \u0642\u0627\u0644\u0628 HTML \u0628\u0627 \u0631\u0646\u06af\u200c\u0647\u0627\u06cc \u0645\u0634\u062e\u0635 \u0634\u062f\u0647 \u0646\u0645\u0627\u06cc\u0634 \u062f\u0627\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f: <ul><li><span style='color: green;'>+ \u0645\u0648\u062f \u0627\u0636\u0627\u0641\u0647 \u0634\u062f\u0647</span></li><li><span style='color: red;'>- \u0645\u0648\u062f \u062d\u0630\u0641 \u0634\u062f\u0647</span></li></ul></li></ol><h3>\u0648\u06cc\u0698\u06af\u06cc\u200c\u0647\u0627\u06cc \u0645\u0647\u0645:</h3><ul><li>\u0627\u0632 \u0647\u0631 \u062a\u0631\u06a9\u06cc\u0628\u06cc \u0627\u0632 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 (\u0645\u0648\u0641\u0642/\u0646\u0627\u0645\u0648\u0641\u0642) \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f.</li><li>\u062a\u0641\u0627\u0648\u062a\u200c\u0647\u0627\u06cc \u062f\u0648 \u0637\u0631\u0641\u0647 \u0631\u0627 \u0646\u0645\u0627\u06cc\u0634 \u0645\u06cc\u200c\u062f\u0647\u062f.</li><li>\u0627\u0645\u06a9\u0627\u0646 \u0627\u0633\u06a9\u0631\u0648\u0644 \u0628\u0631\u0627\u06cc \u0644\u06cc\u0633\u062a\u200c\u0647\u0627\u06cc \u0628\u0644\u0646\u062f \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.</li><li>\u062a\u0635\u0627\u0648\u06cc\u0631 \u062a\u0648\u0636\u06cc\u062d\u06cc \u0628\u0631\u0627\u06cc \u062f\u0631\u06a9 \u0628\u0647\u062a\u0631 \u062f\u0627\u0631\u062f.</li></ul><p>\u062a\u0648\u0633\u0639\u0647 \u06cc\u0627\u0641\u062a\u0647 \u0628\u0627 3>\ufe0f \u0628\u0631\u0627\u06cc \u0631\u062f\u06cc\u0627\u0628\u06cc \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0634\u0645\u0627.</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u062d\u062a\u0645\u0627\u0644\u0627\u064b \u0634\u0645\u0627 \u0628\u0627 \u06cc\u06a9 \u0645\u0634\u06a9\u0644 \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 IPv6 \u0631\u0648\u0628\u0631\u0648 \u0647\u0633\u062a\u06cc\u062f. \u062f\u0648 \u0631\u0627\u0647\u200c\u062d\u0644 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f: 1) \u0622\u0631\u06af\u0648\u0645\u0627\u0646 JVM <code>-Djava.net.preferIPv4Stack=true</code> \u0631\u0627 \u0628\u0647 \u0644\u0627\u0646\u0686\u0631 \u062e\u0648\u062f \u0627\u0636\u0627\u0641\u0647 \u06a9\u0646\u06cc\u062f\u060c \u06cc\u0627 2) \u062f\u06a9\u0645\u0647 'QuickFix' \u062f\u0631 \u0646\u0631\u0645\u200c\u0627\u0641\u0632\u0627\u0631 CrashDetector \u0631\u0627 \u0641\u0634\u0627\u0631 \u062f\u0647\u06cc\u062f \u062a\u0627 \u067e\u0686\u06cc \u0627\u0639\u0645\u0627\u0644 \u0634\u0648\u062f \u06a9\u0647 \u0627\u06cc\u0646 \u062a\u0646\u0638\u06cc\u0645 \u0631\u0627 \u0628\u0647 \u0635\u0648\u0631\u062a \u062e\u0648\u062f\u06a9\u0627\u0631 \u0641\u0639\u0627\u0644 \u06a9\u0646\u062f.</b>";
    }

    @Override
    public String parcheIPv4() {
        return "\u067e\u0686 IPv4/6";
    }

    @Override
    public String carpetaHMCL() {
        return "\u067e\u0648\u0634\u0647 HMCL (\u0641\u0642\u0637 \u0628\u0631\u0627\u06cc HelloMineCraftLauncher)";
    }

    @Override
    public String descripcionCurseforge() {
        return "\u0646\u06a9\u062a\u0647: \u0627\u06af\u0631 \u06af\u0632\u06cc\u0646\u0647 \u00ab\u067e\u0631\u0634 \u0627\u0632 \u0644\u0627\u0646\u0686\u0631\u00bb \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a > \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0641\u0639\u0627\u0644 \u0628\u0627\u0634\u062f \u0647\u06cc\u0686 \u0633\u062c\u0644\u06cc \u0627\u06cc\u062c\u0627\u062f \u0646\u0645\u06cc\u200c\u0634\u0648\u062f.";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/\u0645\u0634\u062a\u0642\u0627\u062a: \u0631\u0648\u06cc \u0646\u0633\u062e\u0647 \u06a9\u0644\u06cc\u06a9 \u0631\u0627\u0633\u062a \u06a9\u0646\u06cc\u062f \u0648 \u00ab\u0648\u06cc\u0631\u0627\u06cc\u0634 \u0646\u0633\u062e\u0647\u00bb \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f. \u062f\u0631 \u067e\u0646\u062c\u0631\u0647\u200c\u0627\u06cc \u06a9\u0647 \u0628\u0627\u0632 \u0645\u06cc\u200c\u0634\u0648\u062f\u060c \u0628\u0647 \u062f\u0646\u0628\u0627\u0644 \u0628\u062e\u0634 \u00ab\u062b\u0628\u062a\u200c\u0647\u0627\u06cc \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a\u00bb \u06cc\u0627 \u0686\u06cc\u0632\u06cc \u0634\u0628\u06cc\u0647 \u0622\u0646 \u0628\u0627\u0634\u06cc\u062f.<br>\u0627\u06cc\u0646 \u062b\u0628\u062a\u200c\u0647\u0627 \u0634\u0627\u0645\u0644 \u062e\u0631\u0648\u062c\u06cc \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f (STDOUT) \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 \u0628\u0631\u0627\u06cc \u062a\u0634\u062e\u06cc\u0635 \u062e\u0637\u0627\u0647\u0627\u06cc \u0645\u062e\u062a\u0644\u0641 \u0636\u0631\u0648\u0631\u06cc\u200c\u0627\u0646\u062f.";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): \u0628\u0627\u06cc\u062f \u067e\u0648\u0634\u0647\u200c\u0627\u06cc \u06a9\u0647 HMCL \u062f\u0631 \u0622\u0646 \u0646\u0635\u0628 \u0634\u062f\u0647 \u0627\u0633\u062a \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f \u0648 \u067e\u0648\u0634\u0647 \u00ab.hmcl\u00bb \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f. \u0633\u062c\u0644\u200c\u0647\u0627\u06cc HMCL \u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u0630\u062e\u06cc\u0631\u0647 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f \u0648 \u062d\u0627\u0648\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0645\u0647\u0645 \u062f\u0631\u0628\u0627\u0631\u0647 \u062e\u0637\u0627\u0647\u0627\u06cc \u0647\u0633\u062a\u0646\u062f.<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix: \u0644\u0627\u0646\u0686\u0631 \u06cc\u06a9 \u0632\u0628\u0627\u0646\u0647 \u062a\u0648\u0633\u0639\u0647 \u062f\u0627\u0631\u062f \u06a9\u0647 \u0633\u062c\u0644\u200c\u0647\u0627\u06cc \u062c\u0632\u0626\u06cc \u0631\u0627 \u0646\u0645\u0627\u06cc\u0634 \u0645\u06cc\u200c\u062f\u0647\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u06cc\u0646 \u0632\u0628\u0627\u0646\u0647 \u0631\u0627 \u062f\u0631 \u0645\u0646\u0648\u06cc \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0644\u0627\u0646\u0686\u0631 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher: \u0646\u0645\u0627\u06cc\u0634 \u0633\u062c\u0644\u200c\u0647\u0627 \u062f\u0631 \u06cc\u06a9 \u067e\u0646\u062c\u0631\u0647 \u0645\u0646\u0628\u0633\u0637 \u0634\u0648\u0646\u062f\u0647 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f. \u062f\u06a9\u0645\u0647\u200c\u0647\u0627\u06cc\u06cc \u0628\u0631\u0627\u06cc \u06a9\u067e\u06cc \u0648 \u0622\u067e\u0644\u0648\u062f \u0633\u062c\u0644\u200c\u0647\u0627 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f. \u0633\u062c\u0644\u200c\u0647\u0627 \u0628\u0647 \u0635\u0648\u0631\u062a \u062e\u0648\u062f\u06a9\u0627\u0631 \u0647\u0646\u06af\u0627\u0645 \u0627\u062c\u0631\u0627\u06cc \u0628\u0627\u0632\u06cc \u0627\u06cc\u062c\u0627\u062f \u0645\u06cc\u200c\u0634\u0648\u0646\u062f \u0648 \u0634\u0627\u0645\u0644 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0636\u0631\u0648\u0631\u06cc \u0628\u0631\u0627\u06cc \u062a\u0634\u062e\u06cc\u0635 \u0645\u0634\u06a9\u0644\u0627\u062a \u0647\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher: \u0631\u0648\u06cc \u0646\u0633\u062e\u0647 \u06a9\u0644\u06cc\u06a9 \u0631\u0627\u0633\u062a \u06a9\u0631\u062f\u0647 \u0648 \u00ab\u062a\u0646\u0638\u06cc\u0645\u0627\u062a\u00bb \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f. \u0633\u067e\u0633 \u0628\u0647 \u0628\u062e\u0634 \u0633\u062c\u0644\u200c\u0647\u0627 \u0628\u0631\u0648\u06cc\u062f \u062a\u0627 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0645\u0647\u0645 \u062e\u0631\u0648\u062c\u06cc \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f (STDOUT) \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f.";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "\u0644\u06cc\u0646\u06a9\u200c\u0647\u0627\u06cc Markdown: \u0647\u0631 \u0644\u06cc\u0646\u06a9\u06cc \u06a9\u0647 \u062d\u0627\u0648\u06cc \u0633\u062c\u0644\u200c\u0647\u0627 \u062f\u0631 \u0642\u0627\u0644\u0628 Markdown \u0628\u0627\u0634\u062f \u0631\u0627 \u0627\u06cc\u0646\u062c\u0627 \u0628\u0686\u0633\u0628\u0627\u0646\u06cc\u062f. \u0633\u06cc\u0633\u062a\u0645 \u0633\u0639\u06cc \u062e\u0648\u0627\u0647\u062f \u06a9\u0631\u062f \u0644\u06cc\u0646\u06a9\u200c\u0647\u0627\u06cc \u0633\u062c\u0644 (latest.log, launcher_log.txt, debug.log \u0648 \u063a\u06cc\u0631\u0647) \u0631\u0627 \u0627\u0633\u062a\u062e\u0631\u0627\u062c \u0648 \u062a\u062d\u0644\u06cc\u0644 \u06a9\u0646\u062f.";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "\u0644\u0627\u06af \u0644\u0627\u0646\u0686\u0631 \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f";
    }

    @Override
    public String imagenNoEncontrada() {
        return "\u062a\u0635\u0648\u06cc\u0631 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "\u0639\u0645\u0648\u0645\u06cc: \u0646\u0648\u0639 \u0644\u0627\u0646\u0686\u0631\u06cc \u06a9\u0647 \u0627\u0632 \u0622\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f. \u0633\u062c\u0644\u200c\u0647\u0627\u06cc \u0644\u0627\u0646\u0686\u0631 (launcher_log.txt, stdout \u0648 \u063a\u06cc\u0631\u0647) \u0634\u0627\u0645\u0644 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0636\u0631\u0648\u0631\u06cc \u062f\u0631\u0628\u0627\u0631\u0647 \u062e\u0637\u0627\u0647\u0627\u06cc\u06cc \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 \u062f\u0631 latest.log \u062f\u06cc\u062f\u0647 \u0646\u0645\u06cc\u200c\u0634\u0648\u0646\u062f. CrashDetector \u0642\u0627\u062f\u0631 \u0628\u0647 \u062e\u0648\u0627\u0646\u062f\u0646 \u0633\u062c\u0644\u200c\u0647\u0627\u06cc \u0644\u0627\u0646\u0686\u0631 \u0634\u0645\u0627 \u0646\u06cc\u0633\u062a \u2014 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0644\u0627\u0646\u0686\u0631 \u0634\u0645\u0627 \u0641\u0627\u06cc\u0644 \u0633\u062c\u0644\u06cc \u0627\u06cc\u062c\u0627\u062f \u0646\u06a9\u0646\u062f\u060c \u0628\u0646\u0627\u0628\u0631\u0627\u06cc\u0646 \u0628\u0627\u06cc\u062f \u0633\u062c\u0644\u200c\u0647\u0627 \u0631\u0627 \u062f\u0633\u062a\u06cc \u06a9\u067e\u06cc \u06a9\u0646\u06cc\u062f.<br>\u0628\u0631\u0627\u06cc \u06a9\u0633\u0628 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0628\u06cc\u0634\u062a\u0631\u060c <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">\u0627\u06cc\u0646 \u0645\u0648\u0636\u0648\u0639 \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f</a>. \u0627\u06cc\u0646 \u0633\u062c\u0644\u200c\u0647\u0627 \u0634\u0627\u0645\u0644 \u062e\u0631\u0648\u062c\u06cc \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f (STDOUT) \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 \u0628\u0631\u0627\u06cc \u062a\u0634\u062e\u06cc\u0635 \u0628\u0633\u06cc\u0627\u0631\u06cc \u0627\u0632 \u0627\u0646\u0648\u0627\u0639 \u062e\u0637\u0627\u0647\u0627 \u0636\u0631\u0648\u0631\u06cc\u200c\u0627\u0646\u062f.";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u0634\u062f\u0647 \u0627\u0632 Create \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. Create \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0632\u06cc\u0627\u062f\u06cc \u062f\u0627\u0634\u062a\u0647 \u2014 \u0628\u0633\u06cc\u0627\u0631\u06cc \u0627\u0632 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627 \u062d\u0630\u0641 \u0634\u062f\u0647\u200c\u0627\u0646\u062f. \u0628\u0647 \u0648\u06cc\u0698\u0647 \u0627\u0632 Create 6 (\u0641\u0648\u0631\u06cc\u0647 \u06f2\u06f0\u06f2\u06f5) \u0628\u0647 \u0628\u0639\u062f\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc\u200c\u062a\u0631 Create \u062f\u06cc\u06af\u0631 \u06a9\u0627\u0631 \u0646\u0645\u06cc\u200c\u06a9\u0646\u0646\u062f. QuickFix \u0631\u0627\u0647\u200c\u062d\u0644\u06cc \u0628\u0631\u0627\u06cc \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0646\u062f\u0627\u0631\u062f. \u0628\u0627\u06cc\u062f \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc Create \u062e\u0648\u062f \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632 \u06a9\u0646\u06cc\u062f\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0646\u0633\u0648\u062e \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0627\u0632 \u0646\u0633\u062e\u0647 \u0635\u062d\u06cc\u062d Create \u0628\u0631\u0627\u06cc \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631\u062a\u0627\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u0634\u062f\u0647 \u0627\u0632 EpicFight \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. EpicFight \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0639\u0645\u062f\u0647\u200c\u0627\u06cc \u062f\u0627\u0634\u062a\u0647 \u2014 \u0628\u0633\u06cc\u0627\u0631\u06cc \u0627\u0632 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627 \u062d\u0630\u0641 \u0634\u062f\u0647\u200c\u0627\u0646\u062f. QuickFix \u0631\u0627\u0647\u200c\u062d\u0644\u06cc \u0628\u0631\u0627\u06cc \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0646\u062f\u0627\u0631\u062f. \u0628\u0627\u06cc\u062f \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc EpicFight \u062e\u0648\u062f \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632 \u06a9\u0646\u06cc\u062f\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0646\u0633\u0648\u062e \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0627\u0632 \u0646\u0633\u062e\u0647 \u0635\u062d\u06cc\u062d EpicFight \u0628\u0631\u0627\u06cc \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631\u062a\u0627\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 OpenJ9\u060c \u0648\u0647\u0648 \u063a\u064a\u0631 \u0645\u062f\u0639\u0648\u0645 \u0645\u0646 \u0642\u0628\u0644 \u0647\u0630\u0627 \u0627\u0644\u062a\u0637\u0628\u064a\u0642. \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u062a\u0637\u0628\u064a\u0642\u0627\u062a\u060c \u0628\u0645\u0627 \u0641\u064a \u0630\u0644\u0643 \u0647\u0630\u0627\u060c \u0644\u0627 \u062a\u062f\u0639\u0645 OpenJ9 \u0628\u0633\u0628\u0628 \u0627\u062e\u062a\u0644\u0627\u0641\u0627\u062a \u0641\u064a \u062a\u0646\u0641\u064a\u0630 JVM. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 QuickFix \u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627. \u064a\u062c\u0628 \u0639\u0644\u064a\u0643 \u062a\u062b\u0628\u064a\u062a JDK \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u062b\u0644 Oracle JDK \u0623\u0648 OpenJDK Hotspot \u0623\u0648 \u0628\u062f\u0627\u0626\u0644 \u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0623\u062e\u0631\u0649.</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062a\u0637\u0644\u0628 \u0647\u0630\u0647 \u0627\u0644\u0646\u0633\u062e\u0629 \u0645\u0646 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 Java 11 (JDK 11) \u0644\u0644\u0639\u0645\u0644 \u0628\u0634\u0643\u0644 \u0635\u062d\u064a\u062d. \u0623\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 \u0625\u0635\u062f\u0627\u0631\u064b\u0627 \u0642\u062f\u064a\u0645\u064b\u0627 \u0648\u063a\u064a\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0645\u0646 Java. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0644\u0640 QuickFix \u062a\u062d\u062f\u064a\u062b Java \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627. \u064a\u062c\u0628 \u062a\u0646\u0632\u064a\u0644 \u0648\u062a\u062b\u0628\u064a\u062a JDK 11 \u0623\u0648 \u0625\u0635\u062f\u0627\u0631 \u0645\u062a\u0648\u0627\u0641\u0642 \u0623\u062d\u062f\u062b \u0645\u0646 \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u0645\u0642\u062f\u0645\u0629 \u0641\u064a \u0627\u0644\u062d\u0644.</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0644\u0642\u062f \u062e\u0635\u0635\u062a \u0630\u0627\u0643\u0631\u0629 \u0632\u0627\u0626\u062f\u0629\u060c \u0645\u0645\u0627 \u064a\u0624\u062f\u064a \u0625\u0644\u0649 \u0646\u0642\u0635 \u0627\u0644\u0645\u0648\u0627\u0631\u062f \u0641\u064a \u0627\u0644\u0646\u0638\u0627\u0645. \u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u063a\u0627\u0644\u0628\u064b\u0627 \u0639\u0646\u062f \u062a\u062d\u062f\u064a\u062f \u0643\u0645\u064a\u0629 \u0630\u0627\u0643\u0631\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629\u060c \u0623\u0648 \u0639\u0646\u062f \u0627\u0633\u062a\u062e\u062f\u0627\u0645 JVM \u0645\u0646 \u0646\u0648\u0639 32 \u0628\u062a \u0644\u0627 \u064a\u0645\u0643\u0646\u0647 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0645\u0639 \u0643\u0645\u064a\u0627\u062a \u0643\u0628\u064a\u0631\u0629 \u0645\u0646 \u0627\u0644\u0630\u0627\u0643\u0631\u0629.</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0644\u062d\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629\u060c \u0642\u0645 \u0628\u062a\u0642\u0644\u064a\u0644 \u0643\u0645\u064a\u0629 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0645\u062e\u0635\u0635\u0629 \u0644\u0644\u062a\u0637\u0628\u064a\u0642. \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647 \u064a\u0639\u062a\u0645\u062f \u0639\u0644\u0649 \u0646\u0638\u0627\u0645\u0643\u060c \u0644\u0643\u0646\u0647 \u0639\u0627\u062f\u0629\u064b \u0644\u0627 \u064a\u062c\u0628 \u0623\u0646 \u064a\u062a\u062c\u0627\u0648\u0632 70-80\u066a \u0645\u0646 \u0625\u062c\u0645\u0627\u0644\u064a \u0630\u0627\u0643\u0631\u0629 RAM. \u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0633\u062a\u062e\u062f\u0645 JVM 32 \u0628\u062a\u060c \u0641\u0625\u0646 \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0647\u0648 \u062d\u0648\u0627\u0644\u064a 2-3 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a \u0628\u063a\u0636 \u0627\u0644\u0646\u0638\u0631 \u0639\u0646 \u0643\u0645\u064a\u0629 \u0627\u0644\u0630\u0627\u0643\u0631\u0629 \u0627\u0644\u0641\u0639\u0644\u064a\u0629.</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0644\u062a\u0642\u0644\u064a\u0644 \u0630\u0627\u0643\u0631\u0629 heap \u0627\u0644\u0645\u062e\u0635\u0635\u0629 \u0644\u0644\u062a\u0637\u0628\u064a\u0642\u060c \u0627\u0641\u062a\u062d \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0644\u0627\u0646\u0634\u0631 \u0648\u0627\u0628\u062d\u062b \u0639\u0646 \u062e\u064a\u0627\u0631 \u0627\u0644\u0630\u0627\u0643\u0631\u0629. \u0642\u0644\u0644 \u0627\u0644\u0642\u064a\u0645\u0629 \u0627\u0644\u0642\u0635\u0648\u0649 (Xmx) \u0625\u0644\u0649 \u0643\u0645\u064a\u0629 \u0645\u0646\u0627\u0633\u0628\u0629. \u0639\u0644\u0649 \u0633\u0628\u064a\u0644 \u0627\u0644\u0645\u062b\u0627\u0644\u060c \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0644\u062f\u064a\u0643 8 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a \u0645\u0646 RAM\u060c \u062e\u0635\u0635 3-4 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a \u0644\u0644\u062a\u0637\u0628\u064a\u0642. \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0644\u062f\u064a\u0643 16 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a\u060c \u064a\u0645\u0643\u0646\u0643 \u062a\u062e\u0635\u064a\u0635 6-8 \u062c\u064a\u062c\u0627\u0628\u0627\u064a\u062a. \u062a\u0623\u0643\u062f \u0645\u0646 \u062a\u0631\u0643 \u0630\u0627\u0643\u0631\u0629 \u0643\u0627\u0641\u064a\u0629 \u0644\u0644\u0646\u0638\u0627\u0645 \u0648\u0627\u0644\u0628\u0631\u0627\u0645\u062c \u0627\u0644\u0623\u062e\u0631\u0649.</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0636\u0631\u0648\u0631\u06cc Forge \u06af\u0645 \u0634\u062f\u0647\u200c\u0627\u0646\u062f. \u0641\u0627\u06cc\u0644 '" + archivo + "' \u062f\u0631 \u0646\u0635\u0628 \u0634\u0645\u0627 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f. \u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0648\u0642\u062a\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0646\u0635\u0628 Forge \u0642\u0637\u0639 \u0634\u062f\u0647 \u06cc\u0627 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0645\u0647\u0645\u06cc \u062d\u0630\u0641 \u0634\u062f\u0647 \u0628\u0627\u0634\u0646\u062f. QuickFix \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0627\u06cc\u0646 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0631\u0627 \u062e\u0648\u062f\u06a9\u0627\u0631 \u0628\u0627\u0632\u06cc\u0627\u0628\u06cc \u06a9\u0646\u062f. \u0628\u0627\u06cc\u062f Forge \u0631\u0627 \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0646\u0635\u0628\u200c\u06a9\u0646\u0646\u062f\u0647 \u0631\u0633\u0645\u06cc \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0646\u0633\u062e\u0647 \u0645\u0648\u0631\u062f \u0646\u06cc\u0627\u0632 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u062f. \u0646\u0633\u062e\u0647 " + version + " \u0646\u06cc\u0627\u0632 \u0627\u0633\u062a \u0627\u0645\u0627 \u062f\u0631 \u0641\u0627\u06cc\u0644 '" + archivo + "' \u06cc\u0627\u0641\u062a \u0646\u0634\u062f. \u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0628\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0648 \u0646\u0633\u062e\u0647 Forge \u062a\u0648\u0646\u0627 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0648\u062c\u0648\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0646\u0633\u062e\u0647 \u0635\u062d\u06cc\u062d Forge \u0631\u0627 \u06a9\u0647 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a \u062f\u0627\u0646\u0644\u0648\u062f \u06a9\u0631\u062f\u0647\u200c\u0627\u06cc\u062f.</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0647\u062f\u0641 'fmlclient' \u0645\u0648\u0631\u062f \u0646\u06cc\u0627\u0632 \u0628\u0631\u0627\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc Forge \u06cc\u0627\u0641\u062a \u0646\u0634\u062f. \u0627\u06cc\u0646 \u0646\u0634\u0627\u0646\u200c\u062f\u0647\u0646\u062f\u0647 \u0646\u0635\u0628 \u0646\u0627\u0642\u0635 \u06cc\u0627 \u062e\u0631\u0627\u0628 \u0634\u062f\u0647 Forge \u0627\u0633\u062a. \u0627\u062d\u062a\u0645\u0627\u0644\u0627\u064b \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0636\u0631\u0648\u0631\u06cc Forge \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0646\u0635\u0628 \u0646\u0634\u062f\u0647\u200c\u0627\u0646\u062f. \u0628\u0627\u06cc\u062f Forge \u0631\u0627 \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0646\u0635\u0628\u200c\u06a9\u0646\u0646\u062f\u0647 \u0631\u0633\u0645\u06cc \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06a9\u0644\u0627\u0633 \u0627\u0635\u0644\u06cc \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u062f\u0631 \u0628\u0627\u0631\u06af\u06cc\u0631 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f. \u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0646\u0634\u0627\u0646\u200c\u062f\u0647\u0646\u062f\u0647 \u0646\u0635\u0628 \u0646\u0627\u0642\u0635 Forge \u06cc\u0627 \u062a\u0639\u0627\u0631\u0636 \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 \u0627\u0633\u062a. \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u062f\u0631 \u062d\u06cc\u0646 \u0646\u0635\u0628 Forge \u062e\u0631\u0627\u0628 \u0634\u062f\u0647 \u0628\u0627\u0634\u0646\u062f. \u0628\u0627\u06cc\u062f Forge \u0631\u0627 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0646\u0635\u0628 Forge \u06a9\u0627\u0645\u0644 \u0646\u06cc\u0633\u062a. \u0627\u06cc\u0646 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0642\u0637\u0639 \u0634\u062f\u0646 \u0646\u0635\u0628\u060c \u062d\u0630\u0641 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u06cc\u0627 \u0639\u062f\u0645 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0634\u0645\u0627 \u0628\u0627\u0634\u062f. Forge \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u0628\u0647 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u062e\u0627\u0635\u06cc \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f \u0648 \u0628\u0631\u062e\u06cc \u0627\u0632 \u0622\u0646\u200c\u0647\u0627 \u062f\u0631 \u0646\u0635\u0628 \u0641\u0639\u0644\u06cc \u0634\u0645\u0627 \u06af\u0645 \u0634\u062f\u0647\u200c\u0627\u0646\u062f.</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "\u0646\u0635\u0628 \u0646\u0627\u0642\u0635 Forge";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0628\u0631\u0627\u06cc \u062d\u0644 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644\u060c Forge \u0631\u0627 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0646\u0633\u062e\u0647 \u0645\u0646\u0627\u0633\u0628 \u0631\u0627 \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u062e\u0648\u062f \u062f\u0627\u0646\u0644\u0648\u062f \u06a9\u0631\u062f\u0647 \u0648 \u0641\u0631\u0622\u06cc\u0646\u062f \u0646\u0635\u0628 \u0631\u0627 \u0628\u062f\u0648\u0646 \u0642\u0637\u0639 \u06a9\u0631\u062f\u0646 \u0627\u0646\u062c\u0627\u0645 \u062f\u0647\u06cc\u062f.</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "\u062f\u0627\u0646\u0644\u0648\u062f \u0631\u0633\u0645\u06cc Forge";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "\u0686\u06af\u0648\u0646\u0647 Forge \u0631\u0627 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u0645";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>\u062f\u0633\u062a\u0648\u0631\u0627\u0644\u0639\u0645\u0644 \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 Forge:</h3><ol><li>\u0646\u0635\u0628\u200c\u06a9\u0646\u0646\u062f\u0647 \u0635\u062d\u06cc\u062d Forge \u0631\u0627 \u0627\u0632 \u0633\u0627\u06cc\u062a \u0631\u0633\u0645\u06cc \u062f\u0627\u0646\u0644\u0648\u062f \u06a9\u0646\u06cc\u062f (\u0646\u0633\u062e\u0647 \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0634\u0645\u0627)</li><li>\u06a9\u0627\u0645\u0644\u0627\u064b \u0628\u0631\u0646\u0627\u0645\u0647 \u0627\u062c\u0631\u0627\u06cc\u06cc \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u062e\u0648\u062f \u0631\u0627 \u0628\u0628\u0646\u062f\u06cc\u062f</li><li>\u0646\u0635\u0628\u200c\u06a9\u0646\u0646\u062f\u0647 Forge \u0631\u0627 \u0628\u0627 \u062f\u0633\u062a\u0631\u0633\u06cc \u0645\u062f\u06cc\u0631 \u0627\u062c\u0631\u0627 \u06a9\u0646\u06cc\u062f</li><li>\u06af\u0632\u06cc\u0646\u0647 'Installer' \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f (\u0646\u0647 'Installer (run client)')</li><li>\u067e\u0648\u0634\u0647 \u067e\u0631\u0648\u0641\u0627\u06cc\u0644 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u062e\u0648\u062f \u0631\u0627 \u062f\u0631 \u0644\u0627\u0646\u0686\u0631 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f</li><li>\u062f\u06a9\u0645\u0647 'OK' \u0631\u0627 \u0628\u0632\u0646\u06cc\u062f \u0648 \u0635\u0628\u0631 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0646\u0635\u0628 \u06a9\u0627\u0645\u0644 \u0634\u0648\u062f</li><li>\u0644\u0627\u0646\u0686\u0631 \u0631\u0627 \u062f\u0648\u0628\u0627\u0631\u0647 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f \u0648 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f Forge \u062f\u0631 \u0644\u06cc\u0633\u062a \u067e\u0631\u0648\u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0638\u0627\u0647\u0631 \u0634\u062f\u0647 \u0627\u0633\u062a</li></ol><p><b>\u0646\u06a9\u062a\u0647 \u0645\u0647\u0645:</b> \u0627\u06af\u0631 \u0627\u0632 \u0644\u0627\u0646\u0686\u0631 \u0633\u0641\u0627\u0631\u0634\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u067e\u0648\u0634\u0647 \u0635\u062d\u06cc\u062d \u067e\u0631\u0648\u0641\u0627\u06cc\u0644 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0631\u062f\u0647\u200c\u0627\u06cc\u062f.</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "\u062f\u0633\u062a\u0648\u0631\u0627\u0644\u0639\u0645\u0644 \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 Forge";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0631\u0628\u0637: \u0641\u0634\u0644 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 " + nombreBiblioteca + ". \u0627\u0644\u062d\u0644\u0648\u0644 \u0627\u0644\u0645\u0645\u0643\u0646\u0629:<br/><br/>\u0623) \u0623\u0636\u0641 \u0627\u0644\u062f\u0644\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 -Djava.library.path \u0623\u0648 -Dorg.lwjgl.librarypath.<br/>\u0628) \u0623\u0636\u0641 \u0645\u0644\u0641 JAR \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 classpath.<br/><br/>\u064a\u062d\u062f\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623 \u0639\u0646\u062f\u0645\u0627 \u0644\u0627 \u064a\u0633\u062a\u0637\u064a\u0639 \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629 \u0644\u0644\u062a\u0634\u063a\u064a\u0644. \u0648\u0647\u0648 \u0646\u0627\u062a\u062c \u0639\u0627\u062f\u0629\u064b \u0639\u0646 \u062a\u062b\u0628\u064a\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644 \u0623\u0648 \u0645\u0634\u0627\u0643\u0644 \u0641\u064a \u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u0646\u0638\u0627\u0645.</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0631\u0628\u0637";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0641\u0634\u0644 \u0641\u064a \u062a\u062d\u0645\u064a\u0644 \u0645\u0643\u062a\u0628\u0629. \u0627\u0644\u062d\u0644\u0648\u0644 \u0627\u0644\u0645\u0645\u0643\u0646\u0629:<br/><br/>\u0623) \u0623\u0636\u0641 \u0627\u0644\u062f\u0644\u064a\u0644 \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 -Djava.library.path \u0623\u0648 -Dorg.lwjgl.librarypath.<br/>\u0628) \u0623\u0636\u0641 \u0645\u0644\u0641 JAR \u0627\u0644\u0630\u064a \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629 \u0625\u0644\u0649 classpath.<br/><br/>\u0647\u0630\u0647 \u0627\u0644\u062d\u0644\u0648\u0644 \u0627\u0644\u062a\u0642\u0646\u064a\u0629 \u0645\u062e\u0635\u0635\u0629 \u0644\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0627\u0644\u0645\u062a\u0642\u062f\u0645\u064a\u0646. \u0645\u0639\u0638\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u0627\u0648\u0644\u0648\u0627 \u0625\u0639\u0627\u062f\u0629 \u062a\u062b\u0628\u064a\u062a \u0645\u0627\u064a\u0646\u0643\u0631\u0627\u0641\u062a \u0642\u0628\u0644 \u062a\u0639\u062f\u064a\u0644 \u0647\u0630\u0647 \u0627\u0644\u0645\u0639\u0644\u0645\u0627\u062a.</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u062f\u0627\u062e\u0644 \u0634\u0646\u0627\u0633\u0647\u200c\u0647\u0627 (ID): \u0634\u0646\u0627\u0633\u0647 <strong>" + id + "</strong> \u0642\u0628\u0644\u0627\u064b \u062a\u0648\u0633\u0637 <strong>" + modOrigen + "</strong> \u0627\u0634\u063a\u0627\u0644 \u0634\u062f\u0647 \u0648 \u0647\u0646\u06af\u0627\u0645 \u0627\u0636\u0627\u0641\u0647 \u06a9\u0631\u062f\u0646 <strong>" + modDestino + "</strong> \u0628\u0627 \u0645\u0634\u06a9\u0644 \u0645\u0648\u0627\u062c\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f. \u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u062f\u0648 \u0645\u0648\u062f \u0633\u0639\u06cc \u06a9\u0646\u0646\u062f \u0627\u0632 \u06cc\u06a9 \u0634\u0646\u0627\u0633\u0647 \u0628\u0631\u0627\u06cc \u0639\u0646\u0627\u0635\u0631 \u0645\u062e\u062a\u0644\u0641 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u0646\u062f.</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0628\u06cc\u0634 \u0627\u0632 \u062d\u062f \u0645\u062c\u0627\u0632 \u0634\u0646\u0627\u0633\u0647\u200c\u0647\u0627 \u0641\u0631\u0627\u062a\u0631 \u0631\u0641\u062a\u0647 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0645\u0648\u062f\u0647\u0627 \u0633\u0639\u06cc \u06a9\u0646\u0646\u062f \u0628\u0644\u0648\u06a9\u200c\u0647\u0627 \u06cc\u0627 \u0622\u06cc\u062a\u0645\u200c\u0647\u0627 \u0631\u0627 \u0628\u0627 \u0634\u0646\u0627\u0633\u0647\u200c\u0647\u0627\u06cc\u06cc \u062b\u0628\u062a \u06a9\u0646\u0646\u062f \u06a9\u0647 \u062e\u0627\u0631\u062c \u0627\u0632 \u0645\u062d\u062f\u0648\u062f\u0647 \u0645\u062c\u0627\u0632 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0634\u0645\u0627 \u0628\u0627\u0634\u0646\u062f.</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "\u062a\u062f\u0627\u062e\u0644 \u0634\u0646\u0627\u0633\u0647\u200c\u0647\u0627";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0628\u0631\u0627\u06cc \u062d\u0644 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u062f\u0631 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a 1.12.2\u060c <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a> \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f. \u0628\u0631\u0627\u06cc 1.7.10\u060c \u0627\u0632 <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0627\u0632 \u0627\u0628\u0632\u0627\u0631\u0647\u0627\u06cc\u06cc \u0645\u0627\u0646\u0646\u062f <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> \u06cc\u0627 <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a> \u0628\u0631\u0627\u06cc \u062d\u0644 \u062a\u062f\u0627\u062e\u0644 \u0634\u0646\u0627\u0633\u0647\u200c\u0647\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "\u0646\u0635\u0628 JustEnoughIDs";
    }

    @Override
    public String instalar_endlessids() {
        return "\u0646\u0635\u0628 EndlessIDs";
    }

    @Override
    public String usar_idfix_minus() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 IdFix Minus \u06cc\u0627 IdFix";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 Minecraft-ID-Resolver";
    }

    @Override
    public String ver_documentacion_jp() {
        return "\u0645\u0634\u0627\u0647\u062f\u0647 \u0645\u0633\u062a\u0646\u062f\u0627\u062a \u0698\u0627\u067e\u0646\u06cc";
    }

    @Override
    public String escanearDeMCreator() {
        return "\u0627\u0633\u06a9\u0646 \u0628\u0627 MCreator";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\u062f\u0631\u062e\u062a \u0645\u0627\u0698\u0648\u0644\u200c\u0647\u0627 \u0648 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627";
    }

    @Override
    public String tipoBusqueda() {
        return "\u0646\u0648\u0639";
    }

    @Override
    public String filtroTodos() {
        return "\u0647\u0645\u0647";
    }

    @Override
    public String filtroPaquetes() {
        return "\u0628\u0633\u062a\u0647\u200c\u0647\u0627";
    }

    @Override
    public String filtroClases() {
        return "\u06a9\u0644\u0627\u0633\u200c\u0647\u0627";
    }

    @Override
    public String filtroMetodos() {
        return "\u0631\u0648\u0634\u200c\u0647\u0627";
    }

    @Override
    public String filtroCampos() {
        return "\u0641\u06cc\u0644\u062f\u0647\u0627";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u0641\u06cc\u0644\u062f";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u0631\u0648\u0634";
    }

    @Override
    public String filtroReferenciasClase() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u06a9\u0644\u0627\u0633";
    }

    @Override
    public String tipBuscar() {
        return "\u0627\u06cc\u0646\u062c\u0627 \u0628\u0646\u0648\u06cc\u0633\u06cc\u062f \u062a\u0627 \u062f\u0631 \u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627 \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String botonBuscar() {
        return "\u062c\u0633\u062a\u062c\u0648";
    }

    @Override
    public String botonResetearArbol() {
        return "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u062f\u0631\u062e\u062a";
    }

    @Override
    public String modsCargados() {
        return "\u0645\u0648\u062f\u0647\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc\u200c\u0634\u062f\u0647";
    }

    @Override
    public String clases() {
        return "\u06a9\u0644\u0627\u0633\u200c\u0647\u0627";
    }

    @Override
    public String metodos() {
        return "\u0631\u0648\u0634\u200c\u0647\u0627";
    }

    @Override
    public String campos() {
        return "\u0641\u06cc\u0644\u062f\u0647\u0627";
    }

    @Override
    public String referencias() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a";
    }

    @Override
    public String resultadosBusqueda() {
        return "\u0646\u062a\u0627\u06cc\u062c \u062c\u0633\u062a\u062c\u0648";
    }

    @Override
    public String buscarReferencias() {
        return "\u06cc\u0627\u0641\u062a\u0646 \u0627\u0631\u062c\u0627\u0639\u0627\u062a";
    }

    @Override
    public String referenciasMod() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u0645\u0648\u062f";
    }

    @Override
    public String referenciasClase() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u06a9\u0644\u0627\u0633";
    }

    @Override
    public String referenciasMetodo() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u0631\u0648\u0634";
    }

    @Override
    public String referenciasCampo() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u0641\u06cc\u0644\u062f";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "\u0627\u0631\u062c\u0627\u0639\u06cc \u06cc\u0627\u0641\u062a \u0646\u0634\u062f";
    }

    @Override
    public String detalleMod() {
        return "\u062c\u0632\u0626\u06cc\u0627\u062a \u0645\u0648\u062f:";
    }

    @Override
    public String ubicacion() {
        return "\u0645\u06a9\u0627\u0646";
    }

    @Override
    public String nombres() {
        return "\u0646\u0627\u0645\u200c\u0647\u0627";
    }

    @Override
    public String modulo() {
        return "\u0645\u0627\u0698\u0648\u0644";
    }

    @Override
    public String detalleClase() {
        return "\u062c\u0632\u0626\u06cc\u0627\u062a \u06a9\u0644\u0627\u0633:";
    }

    @Override
    public String detalleMetodo() {
        return "\u062c\u0632\u0626\u06cc\u0627\u062a \u0631\u0648\u0634:";
    }

    @Override
    public String detalleCampo() {
        return "\u062c\u0632\u0626\u06cc\u0627\u062a \u0641\u06cc\u0644\u062f:";
    }

    @Override
    public String clase() {
        return "\u06a9\u0644\u0627\u0633";
    }

    @Override
    public String tipo() {
        return "\u0646\u0648\u0639";
    }

    @Override
    public String referenciasAMetodos() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u0628\u0647 \u0631\u0648\u0634\u200c\u0647\u0627:";
    }

    @Override
    public String referenciasACampos() {
        return "\u0627\u0631\u062c\u0627\u0639\u0627\u062a \u0628\u0647 \u0641\u06cc\u0644\u062f\u0647\u0627:";
    }

    @Override
    public String arbolDeMods() {
        return "\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627";
    }

    @Override
    public String metodo() {
        return "\u0631\u0648\u0634";
    }

    @Override
    public String campo() {
        return "\u0641\u06cc\u0644\u062f";
    }

    @Override
    public String descompilar() {
        return "\u062f\u06cc\u200c\u06a9\u0627\u0645\u067e\u0627\u06cc\u0644";
    }

    @Override
    public String exportar() {
        return "\u0635\u062f\u0648\u0631";
    }

    @Override
    public String importar() {
        return "\u0648\u0627\u0631\u062f\u0627\u062a";
    }

    @Override
    public String errorImportar() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0627\u0633\u062a\u064a\u0631\u0627\u062f";
    }

    @Override
    public String estructuraImportada() {
        return "\u0627\u0644\u0647\u064a\u0643\u0644\u0629 \u0627\u0644\u0645\u0633\u062a\u0648\u0631\u062f\u0629";
    }

    @Override
    public String estructuraExportada() {
        return "\u0627\u0644\u0647\u064a\u0643\u0644\u0629 \u0627\u0644\u0645\u0635\u062f\u0631\u0629";
    }

    @Override
    public String errorExportar() {
        return "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u062a\u0635\u062f\u064a\u0631";
    }

    @Override
    public String exportando() {
        return "\u062f\u0631 \u062d\u0627\u0644 \u062e\u0631\u0648\u062c\u06cc\u200c\u06af\u06cc\u0631\u06cc";
    }

    @Override
    public String exportacionTardara() {
        return "\u062e\u0631\u0648\u062c\u06cc\u200c\u06af\u06cc\u0631\u06cc \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0637\u0648\u0644 \u0628\u06a9\u0634\u062f";
    }

    @Override
    public String porFavorEspere() {
        return "\u0644\u0637\u0641\u0627\u064b \u0635\u0628\u0631 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0627\u062c\u0631\u0627\u06cc\u06cc VLC \u0631\u0627 \u0646\u062f\u0627\u0631\u06cc\u062f. WaterMedia \u0628\u0647 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0627\u062c\u0631\u0627\u06cc\u06cc VLC \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f. \u0628\u0627\u06cc\u062f \u0622\u0646\u200c\u0647\u0627 \u0631\u0627 \u0628\u0647 \u0635\u0648\u0631\u062a \u062f\u0633\u062a\u06cc \u0627\u0632 https://www.videolan.org/vlc/ \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "\u062f\u0631\u06cc\u0627\u0641\u062a VLC";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0646\u0627\u0645 \u0645\u0627\u0698\u0648\u0644 '" + nombreModulo + "' \u0634\u0627\u0645\u0644 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a. \u0628\u062e\u0634 '" + parteInvalida + "' \u06cc\u06a9 \u0634\u0646\u0627\u0633\u0647\u0654 \u0645\u0639\u062a\u0628\u0631 \u062c\u0627\u0648\u0627 \u0646\u06cc\u0633\u062a. \u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u06cc\u06a9 \u0645\u0648\u062f \u0627\u0632 \u06a9\u0644\u0645\u0627\u062a \u0631\u0632\u0631\u0648 \u0634\u062f\u0647 \u062c\u0627\u0648\u0627 (\u0645\u062b\u0644 'true', 'class') \u06cc\u0627 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u063a\u06cc\u0631\u0645\u062c\u0627\u0632 \u062f\u0631 \u0646\u0627\u0645 \u062e\u0648\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f.</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "\u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u062f\u0631 \u0646\u0627\u0645 \u0645\u0648\u062f";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "\u0646\u0627\u0645 \u0645\u0648\u062f '" + nombreModulo + "' \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a \u0632\u06cc\u0631\u0627 \u0634\u0627\u0645\u0644 '" + parteInvalida + "' \u0627\u0633\u062a \u06a9\u0647 \u06cc\u06a9 \u06a9\u0644\u0645\u0647\u0654 \u0631\u0632\u0631\u0648 \u0634\u062f\u0647 \u062c\u0627\u0648\u0627 \u06cc\u0627 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631 \u063a\u06cc\u0631\u0645\u062c\u0627\u0632 \u0627\u0633\u062a. \u062f\u0631 \u0644\u0627\u06af\u200c\u0647\u0627 \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f \u06a9\u062f\u0627\u0645 \u0645\u0648\u062f \u0628\u0627 \u0627\u06cc\u0646 \u0646\u0627\u0645 \u0645\u0637\u0627\u0628\u0642\u062a \u062f\u0627\u0631\u062f (\u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0646\u0627\u0645 \u0641\u0627\u06cc\u0644 JAR)";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "\u0628\u0647 \u067e\u0648\u0634\u0647 \u0645\u0648\u062f \u0628\u0631\u0648\u06cc\u062f \u0648 \u0641\u0627\u06cc\u0644 <b>mods.toml</b> \u0631\u0627 \u062f\u0631 \u067e\u0648\u0634\u0647 <b>/META-INF/</b> \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0646\u06cc\u062f. \u0645\u0642\u062f\u0627\u0631 <b>modId</b> \u0631\u0627 \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f \u062a\u0627 \u0641\u0642\u0637 \u0627\u0632 \u062d\u0631\u0648\u0641\u060c \u0627\u0639\u062f\u0627\u062f \u0648 \u0632\u06cc\u0631\u062e\u0637 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f \u0648 \u0627\u0632 \u06a9\u0644\u0645\u0627\u062a \u0631\u0632\u0631\u0648 \u0634\u062f\u0647 \u062c\u0627\u0648\u0627 \u062f\u0648\u0631\u06cc \u06a9\u0646\u062f";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "\u0645\u062b\u0627\u0644\u06cc \u0627\u0632 \u0646\u0627\u0645 \u0645\u0639\u062a\u0628\u0631: 'truemod_shot_enchantment' \u0628\u0647 \u062c\u0627\u06cc 'true.shot.enchantment'. \u0628\u0647 \u06cc\u0627\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u06cc\u062f \u06a9\u0647 \u0646\u0627\u0645\u200c\u0647\u0627\u06cc \u0645\u0648\u062f \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u0646\u062f \u0634\u0627\u0645\u0644 \u0646\u0642\u0637\u0647\u060c \u062e\u0637 \u062a\u06cc\u0631\u0647 \u06cc\u0627 \u06a9\u0644\u0645\u0627\u062a \u0631\u0632\u0631\u0648 \u0634\u062f\u0647 \u062c\u0627\u0648\u0627 \u0645\u062b\u0644 'true', 'false' \u06cc\u0627 'class' \u0628\u0627\u0634\u0646\u062f";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc \u062f\u0631 \u0645\u0648\u062f: '" + nombreJar + "'. \u0641\u06cc\u0644\u062f \u0627\u062c\u0628\u0627\u0631\u06cc 'mandatory' \u062f\u0631 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u0622\u0646 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f. \u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0641\u0627\u06cc\u0644 mods.toml \u062a\u0639\u06cc\u06cc\u0646 \u0646\u06a9\u0646\u062f \u06a9\u0647 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0627\u062c\u0628\u0627\u0631\u06cc \u0627\u0633\u062a \u06cc\u0627 \u0646\u0647.</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "\u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0645\u0648\u062f \u0628\u0627 \u0641\u06cc\u0644\u062f \u0627\u062c\u0628\u0627\u0631\u06cc \u06af\u0645\u0634\u062f\u0647";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "\u0645\u0648\u062f \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0627\u06cc\u0646 \u0627\u0633\u062a: <b>" + nombreJar + "</b>. \u0627\u06cc\u0646 \u0641\u0627\u06cc\u0644 \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627 \u0645\u0634\u06a9\u0644 \u062f\u0627\u0631\u062f";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "\u0641\u0627\u06cc\u0644 <b>mods.toml</b> \u0631\u0627 \u062f\u0631 \u067e\u0648\u0634\u0647 <b>/META-INF/</b> \u0645\u0648\u062f <b>" + nombreJar + "</b> \u0628\u0627\u0632 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "\u062f\u0631 \u0628\u062e\u0634 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0647\u0631 \u0648\u0631\u0648\u062f\u06cc \u0634\u0627\u0645\u0644 <b>mandatory=true</b> \u06cc\u0627 <b>mandatory=false</b> \u0628\u0627\u0634\u062f (\u0645\u062b\u0627\u0644: modId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" )";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc \u062f\u0631 \u0645\u0648\u062f: '" + nombreJar + "'. \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 access transformer. \u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0641\u0627\u06cc\u0644 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u062f\u0627\u0631\u0627\u06cc \u0646\u062d\u0648 \u0646\u0627\u062f\u0631\u0633\u062a \u06cc\u0627 \u0627\u0631\u062c\u0627\u0639 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627/\u0631\u0648\u0634\u200c\u0647\u0627\u06cc \u063a\u06cc\u0631\u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0634\u062f.</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "access transformer \u0646\u0627\u0645\u0639\u062a\u0628\u0631";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "\u0645\u0648\u062f \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631: <b>" + nombreJar + "</b>. \u0627\u06cc\u0646 \u0645\u0648\u062f \u062d\u0627\u0648\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 access transformer \u0627\u0633\u062a";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "\u0641\u0627\u06cc\u0644 <b>accessTransformer.cfg</b> \u0631\u0627 \u062f\u0631\u0648\u0646 \u0645\u0648\u062f <b>" + nombreJar + "</b> \u0628\u0627\u0632 \u06a9\u0646\u06cc\u062f (\u0645\u0639\u0645\u0648\u0644\u0627\u064b \u062f\u0631 \u067e\u0648\u0634\u0647 \u0627\u0635\u0644\u06cc \u0641\u0627\u06cc\u0644 JAR)";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "\u0646\u062d\u0648 access transformer \u0631\u0627 \u0627\u0635\u0644\u0627\u062d \u06a9\u0646\u06cc\u062f. \u062e\u0637\u0648\u0637 \u0628\u0627\u06cc\u062f \u0627\u0632 \u0641\u0631\u0645\u062a \u0632\u06cc\u0631 \u067e\u06cc\u0631\u0648\u06cc \u06a9\u0646\u0646\u062f: <b>access class.method</b> (\u0645\u062b\u0627\u0644: public net.minecraft.world.entity.Entity.func_200560_a). \u062e\u0637\u0648\u0637\u06cc \u0631\u0627 \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627 \u06cc\u0627 \u0631\u0648\u0634\u200c\u0647\u0627\u06cc\u06cc \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u06a9\u0647 \u062f\u0631 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0634\u0645\u0627 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u0646\u062f\u060c \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0639\u062f\u0645 \u062a\u0637\u0627\u0628\u0642 \u0628\u06cc\u0646 \u0634\u0646\u0627\u0633\u0647 \u0645\u0648\u062f \u062f\u0631 \u062a\u0648\u0636\u06cc\u062d @Mod \u0648 \u0641\u0627\u06cc\u0644 mods.toml. \u0645\u0648\u062f '" + nombreMod + "' \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0634\u0648\u062f \u0632\u06cc\u0631\u0627 \u0634\u0646\u0627\u0633\u0647\u200c\u0647\u0627 \u0645\u0637\u0627\u0628\u0642\u062a \u0646\u062f\u0627\u0631\u0646\u062f.</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "\u0639\u062f\u0645 \u062a\u0637\u0627\u0628\u0642 \u0628\u06cc\u0646 @Mod \u0648 mods.toml";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "\u0645\u0648\u062f \u062f\u0631 \u062d\u0627\u0644 \u062a\u0648\u0633\u0639\u0647 '" + nombreMod + "' \u062f\u0627\u0631\u0627\u06cc \u0639\u062f\u0645 \u062a\u0637\u0627\u0628\u0642 \u0628\u06cc\u0646 \u0634\u0646\u0627\u0633\u0647 \u062f\u0631 \u062a\u0648\u0636\u06cc\u062d <b>@Mod</b> \u0648 \u0645\u0642\u062f\u0627\u0631 \u062f\u0631 <b>mods.toml</b> \u0627\u0633\u062a";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "\u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0634\u0646\u0627\u0633\u0647 \u062f\u0631 \u06a9\u0644\u0627\u0633 \u0627\u0635\u0644\u06cc \u0634\u0645\u0627 \u0628\u0627 \u0645\u0642\u062f\u0627\u0631 <b>modId</b> \u062f\u0631 \u0641\u0627\u06cc\u0644 <b>/META-INF/mods.toml</b> \u0645\u0637\u0627\u0628\u0642\u062a \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f. \u0645\u062b\u0627\u0644: <b>@Mod(\"mymod\")</b> \u0628\u0627\u06cc\u062f \u0628\u0627 <b>modId=\"mymod\"</b> \u0645\u0637\u0627\u0628\u0642\u062a \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "\u0627\u06af\u0631 \u0627\u0632 Gradle \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u067e\u0633 \u0627\u0632 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u062f\u0633\u062a\u0648\u0631 <b>clean</b> \u0631\u0627 \u0627\u062c\u0631\u0627 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u062d\u0627\u0635\u0644 \u06a9\u0646\u06cc\u062f \u0645\u0646\u0627\u0628\u0639 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0628\u0647\u200c\u0631\u0648\u0632 \u0634\u062f\u0647\u200c\u0627\u0646\u062f. \u06af\u0627\u0647\u06cc \u0627\u0648\u0642\u0627\u062a \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc \u062f\u0631 \u067e\u0648\u0634\u0647 build \u0628\u0627\u0642\u06cc \u0645\u06cc\u200c\u0645\u0627\u0646\u0646\u062f";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u06a9\u0644\u0627\u06cc\u0646\u062a" : "\u0633\u0631\u0648\u0631";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u0633\u0631\u0648\u0631" : "\u06a9\u0644\u0627\u06cc\u0646\u062a";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u062f\u0631 \u062d\u0627\u0644 \u062d\u0627\u0636\u0631 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u06a9\u0644\u0627\u0633 '" + nombreClase + "' \u062f\u0631 \u0645\u062d\u06cc\u0637 " + plataforma + " \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u0628\u0631\u0627\u06cc " + plataformaOpuesta + " \u0637\u0631\u0627\u062d\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a. <b>\u0627\u0632 \u0648\u06cc\u0698\u06af\u06cc '\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627' \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0645\u0648\u062f\u06cc \u06a9\u0647 \u0633\u0639\u06cc \u062f\u0631 \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u062f\u0627\u0631\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f</b>. \u0645\u0648\u062f\u0647\u0627 \u0628\u0647 \u0637\u0648\u0631 \u062e\u0627\u0635 \u0628\u0631\u0627\u06cc \u06cc\u06a9 \u067e\u0644\u062a\u0641\u0631\u0645 \u0633\u0627\u062e\u062a\u0647 \u0634\u062f\u0647\u200c\u0627\u0646\u062f \u0648 \u062f\u0631 \u062f\u06cc\u06af\u0631\u06cc \u06a9\u0627\u0631 \u0646\u0645\u06cc\u200c\u06a9\u0646\u0646\u062f.</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "\u0645\u0648\u062f \u062f\u0631 \u067e\u0644\u062a\u0641\u0631\u0645 \u0646\u0627\u062f\u0631\u0633\u062a";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "\u062f\u0631 \u062a\u0628 <b>\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627</b> (\u0633\u0645\u062a \u0631\u0627\u0633\u062a)\u060c \u0628\u0647 \u062f\u0646\u0628\u0627\u0644 \u0645\u0631\u0627\u062c\u0639 \u0628\u0647 \u06a9\u0644\u0627\u0633 <b>" + nombreClase + "</b> \u0628\u06af\u0631\u062f\u06cc\u062f \u062a\u0627 \u0645\u0648\u062f \u0645\u0633\u0628\u0628 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u06a9\u0644\u0627\u06cc\u0646\u062a" : "\u0633\u0631\u0648\u0631";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u0633\u0631\u0648\u0631" : "\u06a9\u0644\u0627\u06cc\u0646\u062a";
        return "\u0645\u0648\u062f \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc\u200c\u0634\u062f\u0647 \u06cc\u06a9 \u0645\u0648\u062f <b>" + plataformaOpuesta + "</b> \u0627\u0633\u062a \u0648 \u0646\u0628\u0627\u06cc\u062f \u062f\u0631 \u0645\u062d\u06cc\u0637 " + plataforma + " \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u0648\u062f.";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "\u0645\u0648\u062f \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647 <b>\u0645\u0648\u062f\u0647\u0627</b> \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0628\u0647 \u0639\u0645\u0644\u06a9\u0631\u062f \u0645\u0634\u0627\u0628\u0647\u06cc \u062f\u0631 \u0627\u06cc\u0646 \u067e\u0644\u062a\u0641\u0631\u0645 \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f\u060c \u0645\u0648\u062f \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646\u06cc \u0631\u0627 \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0628\u0647 \u0637\u0648\u0631 \u062e\u0627\u0635 \u0628\u0631\u0627\u06cc <b>\u06a9\u0644\u0627\u06cc\u0646\u062a</b> \u06cc\u0627 <b>\u0633\u0631\u0648\u0631</b> \u0637\u0631\u0627\u062d\u06cc \u0634\u062f\u0647 \u0628\u0627\u0634\u062f";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0645\u062a\u0627\u062f\u06cc\u062a\u0627 \u0628\u0631\u0627\u06cc modid '").append(modIdFaltante).append("' \u06cc\u0627\u0641\u062a \u0646\u0634\u062f. ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("\u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0627\u06cc\u062c\u0627\u062f \u06a9\u0646\u0646\u062f: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0645\u0648\u062f\u06cc \u0628\u0647 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631\u06cc \u06a9\u0647 \u0646\u0635\u0628 \u0646\u0634\u062f\u0647 \u06cc\u0627 \u0641\u0627\u06cc\u0644 mods.toml \u0622\u0646 \u0627\u0634\u062a\u0628\u0627\u0647 \u0627\u0633\u062a\u060c \u0648\u0627\u0628\u0633\u062a\u0647 \u0628\u0627\u0634\u062f.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "\u0645\u062a\u0627\u062f\u06cc\u062a\u0627\u06cc mods.toml \u06af\u0645\u0634\u062f\u0647";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0628\u0647 '").append(modIdFaltante).append("' \u0648\u0627\u0628\u0633\u062a\u0647\u200c\u0627\u0646\u062f: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            paso.append("</b>. \u0627\u0632 \u0648\u06cc\u0698\u06af\u06cc <b>\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627</b> \u0628\u0631\u0627\u06cc \u062a\u0623\u06cc\u06cc\u062f \u0645\u0648\u062f \u0645\u0633\u0628\u0628 \u0645\u0634\u06a9\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f");
            return paso.toString();
        }
        return "\u0645\u0648\u062f\u06cc \u062f\u0631 \u062d\u0627\u0644 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0628\u0647 '" + modIdFaltante + "' \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u0627\u06cc\u0646 \u0645\u0648\u062f \u0646\u0635\u0628 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u0632 \u0648\u06cc\u0698\u06af\u06cc <b>\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627</b> \u0628\u0631\u0627\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0645\u0648\u062f \u0645\u0633\u0628\u0628 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u062f\u0648 \u06af\u0632\u06cc\u0646\u0647 \u062f\u0627\u0631\u06cc\u062f:<br/>1. <b>\u0646\u0635\u0628 \u0645\u0648\u062f \u06af\u0645\u0634\u062f\u0647</b>: \u0645\u0648\u062f \u0628\u0627 \u0634\u0646\u0627\u0633\u0647 '" + modIdFaltante + "' \u0631\u0627 \u067e\u06cc\u062f\u0627 \u0648 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f<br/>2. <b>\u062d\u0630\u0641 \u0645\u0648\u062f \u0648\u0627\u0628\u0633\u062a\u0647</b>: \u0627\u06af\u0631 \u0628\u0647 \u0627\u06cc\u0646 \u0648\u06cc\u0698\u06af\u06cc \u0646\u06cc\u0627\u0632 \u0646\u062f\u0627\u0631\u06cc\u062f\u060c \u0645\u0648\u062f \u0648\u0627\u0628\u0633\u062a\u0647 \u0628\u0647 '" + modIdFaltante + "' \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u0627\u06af\u0631 \u0645\u0648\u062f '" + modIdFaltante + "' \u06cc\u06a9 \u06a9\u062a\u0627\u0628\u062e\u0627\u0646\u0647 \u0628\u0627\u0634\u062f (\u0645\u062b\u0644 'forge', 'minecraft', 'curios')\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0635\u062d\u06cc\u062d \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0648 Forge \u0631\u0627 \u062f\u0627\u0631\u06cc\u062f. \u0627\u06af\u0631 \u0645\u0648\u062f \u0645\u0639\u0645\u0648\u0644\u06cc \u0627\u0633\u062a\u060c \u062f\u0631 \u0635\u0641\u062d\u0647 \u062f\u0627\u0646\u0644\u0648\u062f \u0622\u0646\u060c \u067e\u06cc\u0634\u200c\u0646\u06cc\u0627\u0632\u0647\u0627\u06cc \u0644\u0627\u0632\u0645 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0647\u0634\u062f\u0627\u0631: \u062e\u0637\u0627\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0633\u06cc\u0633\u062a\u0645 \u0635\u062f\u0627. \u0635\u062f\u0627\u0647\u0627 \u0648 \u0645\u0648\u0633\u06cc\u0642\u06cc \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u0634\u062f\u0647\u200c\u0627\u0646\u062f. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0627 \u0645\u0648\u062f SoundPhysicsMod \u0645\u0631\u062a\u0628\u0637 \u0627\u0633\u062a \u0648 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u062f\u0644\u06cc\u0644 \u062a\u062f\u0627\u062e\u0644 \u0628\u0627 \u06a9\u062a\u0627\u0628\u062e\u0627\u0646\u0647\u200c\u0647\u0627\u06cc \u0635\u0648\u062a\u06cc \u062f\u06cc\u06af\u0631 \u0631\u062e \u062f\u0627\u062f\u0647 \u0628\u0627\u0634\u062f.</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "\u062e\u0637\u0627\u06cc \u0633\u06cc\u0633\u062a\u0645 \u0635\u062f\u0627";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0647 <b>SoundPhysicsMod</b> \u0645\u0631\u0628\u0648\u0637 \u0645\u06cc\u200c\u0634\u0648\u062f. \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u062e\u0648\u062f \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0631\u062f\u0647 \u0628\u0627\u0634\u06cc\u062f";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "\u0627\u06af\u0631 \u0627\u0632 \u0645\u0648\u062f\u0647\u0627\u06cc \u0635\u0648\u062a\u06cc \u062f\u06cc\u06af\u0631\u06cc (\u0645\u062b\u0644 Sound Filters\u060c Dynamic Surroundings \u0648 \u063a\u06cc\u0631\u0647) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u0648\u0642\u062a\u0627\u064b SoundPhysicsMod \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f \u0622\u06cc\u0627 \u062a\u0639\u0627\u0631\u0636 \u0631\u0641\u0639 \u0645\u06cc\u200c\u0634\u0648\u062f \u06cc\u0627 \u0646\u0647";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "\u067e\u0648\u0634\u0647 <b>logs</b> \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u062a\u0627 \u067e\u06cc\u0627\u0645\u200c\u0647\u0627\u06cc \u0628\u06cc\u0634\u062a\u0631\u06cc \u062f\u0631\u0628\u0627\u0631\u0647 LWJGL \u06cc\u0627 OpenAL \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0646\u0634\u0627\u0646\u200c\u062f\u0647\u0646\u062f\u0647 \u0645\u0634\u06a9\u0644 \u062f\u0631 \u06a9\u062a\u0627\u0628\u062e\u0627\u0646\u0647\u200c\u0647\u0627\u06cc \u0635\u0648\u062a\u06cc \u067e\u0627\u06cc\u0647 \u0628\u0627\u0634\u0646\u062f";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u06a9\u0644\u0627\u0633 '").append(nombreClase).append("' \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u06af\u06cc\u0631\u0646\u062f\u0647 \u0631\u0648\u06cc\u062f\u0627\u062f \u062b\u0628\u062a \u0634\u062f\u0647 \u0627\u0645\u0627 \u0634\u0627\u0645\u0644 \u0631\u0648\u0634 \u0645\u0639\u062a\u0628\u0631\u06cc \u0646\u06cc\u0633\u062a. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u062f\u0631 \u0645\u0648\u062f\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u0627\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u06cc\u06a9 \u06a9\u0644\u0627\u0633 \u0628\u0631\u0627\u06cc \u062f\u0631\u06cc\u0627\u0641\u062a \u0631\u0648\u06cc\u062f\u0627\u062f\u0647\u0627 \u062b\u0628\u062a \u0634\u0648\u062f \u0627\u0645\u0627 \u0631\u0648\u0634\u06cc \u0628\u0627 \u0628\u0631\u0686\u0633\u0628 @SubscribeEvent \u0646\u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "\u06a9\u0644\u0627\u0633 \u062b\u0628\u062a\u200c\u0634\u062f\u0647 \u0628\u062f\u0648\u0646 \u06af\u06cc\u0631\u0646\u062f\u0647 \u0631\u0648\u06cc\u062f\u0627\u062f";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u06a9\u0644\u0627\u0633 \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u062f\u0631 \u0627\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            paso.append("</b>. \u0627\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627 \u062f\u0631 \u062d\u0627\u0644 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u062b\u0628\u062a \u0631\u0648\u06cc\u062f\u0627\u062f \u0628\u062f\u0648\u0646 \u0631\u0648\u0634 \u0645\u0639\u062a\u0628\u0631 \u0647\u0633\u062a\u0646\u062f");
            return paso.toString();
        }
        return "\u06a9\u0644\u0627\u0633 <b>" + nombreClase + "</b> \u0628\u0631\u0627\u06cc \u062f\u0631\u06cc\u0627\u0641\u062a \u0631\u0648\u06cc\u062f\u0627\u062f \u062b\u0628\u062a \u0634\u062f\u0647 \u0627\u0645\u0627 \u0634\u0627\u0645\u0644 \u0631\u0648\u0634\u06cc \u0628\u0627 \u0628\u0631\u0686\u0633\u0628 <b>@SubscribeEvent</b> \u0646\u06cc\u0633\u062a. \u0627\u0632 \u0648\u06cc\u0698\u06af\u06cc <b>\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627</b> \u0628\u0631\u0627\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0645\u0648\u062f \u062d\u0627\u0648\u06cc \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "\u062f\u0631 \u06a9\u062f \u0645\u0646\u0628\u0639\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0644\u0627\u0633 <b>" + nombreClase + "</b> \u062d\u062f\u0627\u0642\u0644 \u06cc\u06a9 \u0631\u0648\u0634 \u0628\u0627 \u0641\u0631\u0645\u062a \u0632\u06cc\u0631 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f: <b>@SubscribeEvent public void \u0646\u0627\u0645_\u0631\u0648\u0634(\u0631\u0648\u06cc\u062f\u0627\u062f_\u062e\u0627\u0635 \u0631\u0648\u06cc\u062f\u0627\u062f) { ... }</b>. \u0627\u06af\u0631 \u06a9\u0644\u0627\u0633 \u062f\u0627\u062e\u0644\u06cc \u0627\u0633\u062a\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0627\u0633\u062a\u0627\u062a\u06cc\u06a9 \u0646\u0628\u0627\u0634\u062f";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("\u0628\u0631\u0627\u06cc \u0645\u0648\u062f\u0647\u0627\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc\u200c\u0634\u062f\u0647 (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", \u0648 \u063a\u06cc\u0631\u0647.");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("\u0628\u0627 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u0647 \u0627\u06cc\u0646 \u0645\u0648\u062f \u062a\u0645\u0627\u0633 \u0628\u06af\u06cc\u0631\u06cc\u062f \u062a\u0627 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0631\u0641\u0639 \u06a9\u0646\u062f. ");
            } else {
                paso.append("\u0628\u0627 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u06af\u0627\u0646 \u0627\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627 \u062a\u0645\u0627\u0633 \u0628\u06af\u06cc\u0631\u06cc\u062f \u062a\u0627 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0631\u0641\u0639 \u06a9\u0646\u0646\u062f. ");
            }
        }
        paso.append("\u0627\u06af\u0631 \u062e\u0648\u062f \u0634\u0645\u0627 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u0647 \u0647\u0633\u062a\u06cc\u062f\u060c \u062b\u0628\u062a \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u062f\u0631 EventBus \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0631\u0648\u0634\u200c\u0647\u0627\u06cc \u0645\u0639\u062a\u0628\u0631 @SubscribeEvent \u0627\u0636\u0627\u0641\u0647 \u06a9\u0646\u06cc\u062f");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u062e\u0637\u0627\u06cc\u06cc \u0627\u0632 \u0646\u0648\u0639 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' \u0647\u0646\u06af\u0627\u0645 \u067e\u0631\u062f\u0627\u0632\u0634 \u0641\u0627\u06cc\u0644 '" + nombreArchivo + "' \u0631\u062e \u062f\u0627\u062f\u0647 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0628\u0647 \u0627\u06cc\u0646 \u0645\u0639\u0646\u06cc \u0627\u0633\u062a \u06a9\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u0654 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0645\u0648\u062f\u067e\u06a9 \u0631\u0627 \u062f\u0627\u0646\u0644\u0648\u062f \u06cc\u0627 \u0627\u0633\u062a\u062e\u0631\u0627\u062c \u0646\u06a9\u0631\u062f\u0647 \u0627\u0633\u062a. \u067e\u06cc\u0627\u0645 'zip END header not found' \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f \u0641\u0627\u06cc\u0644 JAR \u0646\u0627\u0642\u0635 \u06cc\u0627 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a \u06a9\u0647 \u062f\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u062f\u0627\u0646\u0644\u0648\u062f \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0628\u0632\u0631\u06af \u0631\u0627 \u0628\u0647 \u062e\u0648\u0628\u06cc \u0645\u062f\u06cc\u0631\u06cc\u062a \u0646\u0645\u06cc\u200c\u06a9\u0646\u0646\u062f \u0628\u0633\u06cc\u0627\u0631 \u0631\u0627\u06cc\u062c \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0639\u0645\u062f\u062a\u0627\u064b \u06a9\u0627\u0631\u0628\u0631\u0627\u0646 Twitch/CurseForge\u060c Technic Launcher \u0648 \u0628\u0647 \u0648\u06cc\u0698\u0647 \u06a9\u0627\u0631\u0628\u0631\u0627\u0646 Luna Pixel \u0631\u0627 \u062a\u062d\u062a \u062a\u0623\u062b\u06cc\u0631 \u0642\u0631\u0627\u0631 \u0645\u06cc\u200c\u062f\u0647\u062f\u060c \u0632\u06cc\u0631\u0627 \u0627\u06cc\u0646 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627 \u0627\u063a\u0644\u0628 \u062f\u0631 \u062a\u0623\u06cc\u06cc\u062f \u06a9\u0627\u0645\u0644 \u0635\u062d\u062a \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u062f\u0627\u0646\u0644\u0648\u062f \u0634\u062f\u0647 \u0634\u06a9\u0633\u062a \u0645\u06cc\u200c\u062e\u0648\u0631\u0646\u062f. \u06a9\u0627\u0631\u0628\u0631\u0627\u0646 Luna Pixel \u0628\u0627\u06cc\u062f ATLauncher \u0631\u0627 \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u06af\u0632\u06cc\u0646\u0647\u200c\u0627\u06cc \u067e\u0627\u06cc\u062f\u0627\u0631\u062a\u0631 \u062f\u0631 \u0646\u0638\u0631 \u0628\u06af\u06cc\u0631\u0646\u062f\u060c \u0632\u06cc\u0631\u0627 \u0627\u06cc\u0646 \u0628\u0631\u0646\u0627\u0645\u0647 \u0628\u0647\u062a\u0631 \u0628\u0627 \u0635\u062d\u062a \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u06a9\u0627\u0631 \u0645\u06cc\u200c\u06a9\u0646\u062f \u0648 \u0627\u0632 \u0627\u06cc\u0646 \u062e\u0637\u0627 \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f. \u0633\u06cc\u0633\u062a\u0645 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0645\u0648\u062f\u0647\u0627 \u0631\u0627 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0646\u062f \u0632\u06cc\u0631\u0627 \u0641\u0631\u0645\u062a ZIP \u0622\u0633\u06cc\u0628 \u062f\u06cc\u062f\u0647 \u0627\u0633\u062a \u0648 \u0627\u0632 \u062e\u0648\u0627\u0646\u062f\u0646 \u0645\u0646\u0627\u0628\u0639 \u0644\u0627\u0632\u0645 \u062a\u0648\u0633\u0637 Forge \u0628\u0631\u0627\u06cc \u0634\u0631\u0648\u0639 \u0628\u0627\u0632\u06cc \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f.</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "\u062e\u0637\u0627\u06cc UnionFileSystem - \u0641\u0627\u06cc\u0644 \u062e\u0631\u0627\u0628";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "\u06a9\u0627\u0645\u0644\u0627\u064b \u0645\u0648\u062f\u067e\u06a9 \u0631\u0627 \u0627\u0632 \u0627\u0628\u062a\u062f\u0627 \u0646\u0635\u0628 \u0645\u062c\u062f\u062f \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "\u0627\u06af\u0631 \u0627\u0632 Luna Pixel \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 ATLauncher \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "\u0642\u0628\u0644 \u0627\u0632 \u0646\u0635\u0628 \u0645\u062c\u062f\u062f\u060c \u0627\u062a\u0635\u0627\u0644 \u0627\u06cc\u0646\u062a\u0631\u0646\u062a \u0648 \u0641\u0636\u0627\u06cc \u062f\u06cc\u0633\u06a9 \u062e\u0648\u062f \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "\u0622\u06cc\u0627 ProxySysOutSysErr \u0641\u0639\u0627\u0644 \u0634\u0648\u062f\u061f\n\n\u0627\u06cc\u0646 \u06af\u0632\u06cc\u0646\u0647 \u0628\u0647 CrashDetector \u0627\u062c\u0627\u0632\u0647 \u062f\u0633\u062a\u0631\u0633\u06cc \u0628\u0647 System.out \u0648 System.err \u0631\u0627 \u0645\u06cc\u200c\u062f\u0647\u062f \u0632\u0645\u0627\u0646\u06cc \u06a9\u0647 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0644\u0627\u06af\u06cc \u0627\u0631\u0627\u0626\u0647 \u0646\u0645\u06cc\u200c\u062f\u0647\u062f.\n\n\u0641\u0642\u0637 \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u0628\u0627\u06cc\u062f \u0641\u0639\u0627\u0644 \u0634\u0648\u062f \u06a9\u0647 \u0646\u062a\u0648\u0627\u0646\u06cc\u062f \u0628\u0647\u200c\u0635\u0648\u0631\u062a \u062f\u0633\u062a\u06cc \u06cc\u06a9 \u0644\u0627\u06af \u0631\u0627 \u062c\u0627\u06cc\u06af\u0630\u0627\u0631\u06cc \u06a9\u0646\u06cc\u062f.\n\n\u0647\u0634\u062f\u0627\u0631: \u0627\u06cc\u0646 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627 \u0628\u0631\u062e\u06cc \u0645\u0648\u062f\u0647\u0627 \u06cc\u0627 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627 \u062a\u062f\u0627\u062e\u0644 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f.\n\n\u0628\u0631\u0627\u06cc \u0627\u0639\u0645\u0627\u0644 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a\u060c \u0628\u0627\u0632\u0622\u063a\u0627\u0632 \u0645\u062c\u062f\u062f \u0628\u0627\u0632\u06cc/\u0628\u0631\u0646\u0627\u0645\u0647 \u0636\u0631\u0648\u0631\u06cc \u0627\u0633\u062a.";
    }

    @Override
    public String confirmacionTitulo() {
        return "\u062a\u0627\u06cc\u06cc\u062f";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0641\u0639\u0627\u0644 \u0634\u062f.\n\n\u0628\u0631\u0627\u06cc \u0627\u0639\u0645\u0627\u0644 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a\u060c CrashDetector \u0628\u0627\u06cc\u062f \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u0648\u062f.";
    }

    @Override
    public String informacionTitulo() {
        return "\u0627\u0637\u0644\u0627\u0639\u0627\u062a";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: AzureLib \u0648 GeckoLib \u062e\u06cc\u0644\u06cc \u0632\u0648\u062f \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u062f\u0646\u062f! ");
        } else if (azureLibError) {
            mensaje.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: AzureLib \u062e\u06cc\u0644\u06cc \u0632\u0648\u062f \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u062f! ");
        } else if (geckoLibError) {
            mensaje.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: GeckoLib \u062e\u06cc\u0644\u06cc \u0632\u0648\u062f \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u062f! ");
        }
        mensaje.append("\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0633\u0639\u06cc \u06a9\u0646\u06cc\u062f \u0627\u0632 \u0645\u0648\u062f\u0647\u0627\u06cc Fabric \u0628\u0627 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u063a\u06cc\u0631-Fabric \u0627\u06cc\u0646 \u06a9\u062a\u0627\u0628\u062e\u0627\u0646\u0647\u200c\u0647\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. ");
        if (connectorPresente) {
            mensaje.append("\u06cc\u06a9 \u0645\u0648\u062f \u0633\u0627\u0632\u06af\u0627\u0631\u06cc (Sinytra Connector \u06cc\u0627 specialcompatibilityoperation) \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f \u06a9\u0647 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f \u062f\u0631 \u062d\u0627\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0645\u0648\u062f\u0647\u0627\u06cc Fabric \u062f\u0631 \u0645\u062d\u06cc\u0637 Forge \u06cc\u0627 FeatureCreep \u0647\u0633\u062a\u06cc\u062f. ");
            mensaje.append("\u062e\u0637\u0627\u06cc '\u062e\u0637\u0627\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc FabricMC' \u0631\u0627 \u062f\u0631 \u0644\u0627\u06af\u200c\u0647\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u0648\u062f \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f. ");
        }
        mensaje.append("AzureLib \u0648 GeckoLib \u06a9\u062a\u0627\u0628\u062e\u0627\u0646\u0647\u200c\u0647\u0627\u06cc \u0636\u0631\u0648\u0631\u06cc \u0628\u0631\u0627\u06cc \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u0646\u06cc\u0645\u06cc\u0634\u0646 \u0647\u0633\u062a\u0646\u062f\u060c \u0627\u0645\u0627 \u0628\u0627\u06cc\u062f \u0628\u0627 \u067e\u0644\u062a\u0641\u0631\u0645 \u0635\u062d\u06cc\u062d (Fabric \u06cc\u0627 Forge) \u0645\u0637\u0627\u0628\u0642\u062a \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u0646\u062f. ");
        mensaje.append("\u0628\u0627\u0632\u06cc \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u0646\u06cc\u0645\u06cc\u0634\u0646 \u0631\u0627 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0646\u062f \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0627\u06cc\u0646 \u062a\u0639\u0627\u0631\u0636 \u062f\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "\u06a9\u062a\u0627\u0628\u062e\u0627\u0646\u0647 \u062e\u06cc\u0644\u06cc \u0632\u0648\u062f \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u062f";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "\u062e\u0637\u0627\u06cc '\u062e\u0637\u0627\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc FabricMC' \u0631\u0627 \u062f\u0631 \u0644\u0627\u06af\u200c\u0647\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u0648\u062f \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "\u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0627\u0632 \u0646\u0633\u062e\u0647 \u0635\u062d\u06cc\u062d AzureLib/GeckoLib \u0628\u0631\u0627\u06cc \u067e\u0644\u062a\u0641\u0631\u0645 \u062e\u0648\u062f (Forge \u06cc\u0627 Fabric) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0639\u062f\u0645 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0628\u06cc\u0646 C2ME \u0648 \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u062a\u0635\u0627\u0644. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 C2ME \u0633\u0639\u06cc \u06a9\u0646\u062f \u0628\u0647 \u0645\u0624\u0644\u0641\u0647\u200c\u0647\u0627\u06cc \u062f\u0627\u062e\u0644\u06cc \u062c\u0627\u0648\u0627 \u062f\u0633\u062a\u0631\u0633\u06cc \u067e\u06cc\u062f\u0627 \u06a9\u0646\u062f \u06a9\u0647 \u062f\u0631 \u0645\u062d\u06cc\u0637\u200c\u0647\u0627\u06cc \u062f\u0627\u0631\u0627\u06cc Sinytra Connector \u06cc\u0627 specialcompatibilityoperation \u06cc\u0627 \u0633\u0627\u06cc\u0631 \u0645\u0648\u062f\u0647\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631\u06cc Fabric/Forge \u0645\u062d\u062f\u0648\u062f \u0634\u062f\u0647\u200c\u0627\u0646\u062f. <b>C2ME \u0628\u0627 \u0627\u06cc\u0646 \u0645\u062d\u06cc\u0637\u200c\u0647\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u060c \u0627\u0645\u0627 <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u067e\u06cc\u0634\u0646\u0647\u0627\u062f\u06cc \u0627\u0633\u062a</b> \u06a9\u0647 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u062a\u0635\u0627\u0644 \u06a9\u0627\u0631 \u0645\u06cc\u200c\u06a9\u0646\u062f. \u0628\u0627\u0632\u06cc \u0628\u0647 \u062f\u0644\u06cc\u0644 \u062a\u0639\u0627\u0631\u0636 \u0645\u062c\u0648\u0632\u0647\u0627\u06cc \u0627\u0645\u0646\u06cc\u062a\u06cc \u062c\u0627\u0648\u0627 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0634\u0631\u0648\u0639 \u0634\u0648\u062f.</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "\u0639\u062f\u0645 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc C2ME \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u062a\u0635\u0627\u0644";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "C2ME \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647 \u0645\u0648\u062f\u0647\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "\u0628\u0647 \u062c\u0627\u06cc \u0622\u0646\u060c <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> \u0631\u0627 \u062f\u0627\u0646\u0644\u0648\u062f \u0648 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f (\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 Sinytra Connector)";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "\u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u062a\u0645\u0627\u0645 \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u062a\u0635\u0627\u0644 (\u0645\u062b\u0644 Sinytra Connector) \u0628\u0647 \u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u0634\u062f\u0647\u200c\u0627\u0646\u062f";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0627\u0641\u0632\u0648\u0646\u0647 JEI \u0628\u0631\u0627\u06cc \u0645\u0648\u062f '" + modId + "' \u0646\u0627\u0645\u0648\u0641\u0642 \u0628\u0648\u062f. \u06a9\u0644\u0627\u0633 '" + nombreClase + "' (\u0634\u0646\u0627\u0633\u0647 \u0627\u0641\u0632\u0648\u0646\u0647: '" + pluginId + "') \u0628\u0627\u0639\u062b \u062e\u0637\u0627\u06cc\u06cc \u0634\u062f \u06a9\u0647 \u0645\u0646\u062c\u0631 \u0628\u0647 \u06a9\u0631\u0634 \u0634\u062f\u0646 \u0628\u0627\u0632\u06cc \u062f\u0631 \u0647\u0646\u06af\u0627\u0645 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0645\u06cc\u200c\u0634\u0648\u062f. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u06cc\u06a9 \u0645\u0648\u062f \u0627\u062f\u063a\u0627\u0645 JEI \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u06cc\u0627 \u062e\u0631\u0627\u0628 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f \u06a9\u0647 \u0645\u0627\u0646\u0639 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u0634\u0648\u062f.</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647 JEI \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f - \u0628\u0627\u0639\u062b \u06a9\u0631\u0634 \u0645\u06cc\u200c\u0634\u0648\u062f";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "\u0645\u0648\u062f <b>" + modId + "</b> \u062d\u0627\u0648\u06cc \u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647 JEI \u0645\u0639\u06cc\u0648\u0628 \u0627\u0633\u062a \u06a9\u0647 \u0628\u0627\u0639\u062b \u06a9\u0631\u0634 \u0634\u062f\u0646 \u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u0632 \u0642\u0627\u0628\u0644\u06cc\u062a <b>\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627</b> \u0628\u0631\u0627\u06cc \u062a\u0634\u062e\u06cc\u0635 \u0645\u0648\u062f \u0639\u0627\u0645\u0644 \u0645\u0634\u06a9\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "\u0645\u0648\u062f <b>" + modId + "</b> \u0631\u0627 \u0628\u0647\u200c\u0637\u0648\u0631 \u0645\u0648\u0642\u062a \u0627\u0632 \u067e\u0648\u0634\u0647 \u0645\u0648\u062f\u0647\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u0622\u06cc\u0627 \u0645\u0634\u06a9\u0644 \u06a9\u0631\u0634 \u062d\u0644 \u0645\u06cc\u200c\u0634\u0648\u062f";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "\u0628\u0631\u0627\u06cc \u0645\u0648\u062f <b>" + modId + "</b> \u0628\u0647 \u062f\u0646\u0628\u0627\u0644 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u0628\u0627\u0634\u06cc\u062f \u06cc\u0627 \u0645\u0634\u06a9\u0644 \u0627\u0641\u0632\u0648\u0646\u0647 JEI \u0631\u0627 \u0628\u0647 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u0647 \u06af\u0632\u0627\u0631\u0634 \u062f\u0647\u06cc\u062f. \u062f\u0631 \u0647\u0645\u06cc\u0646 \u062d\u0627\u0644\u060c \u0628\u0631\u0627\u06cc \u0627\u062c\u0631\u0627\u06cc \u0628\u0627\u0632\u06cc \u0628\u0627\u06cc\u062f \u0627\u06cc\u0646 \u0645\u0648\u062f \u062d\u0630\u0641 \u0634\u0648\u062f";
    }

    @Override
    public String tituloLectador() {
        return "\u062e\u0648\u0627\u0646\u0646\u062f\u0647 \u0644\u0627\u06af\u200c\u0647\u0627 - \u062a\u0634\u062e\u06cc\u0635\u200c\u062f\u0647\u0646\u062f\u0647 \u06a9\u0631\u0634";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "\u0631\u0627\u0647\u0646\u0645\u0627\u06cc \u0631\u0646\u06af\u200c\u0647\u0627";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "\u062e\u0637\u0627\u0647\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "\u0631\u062f\u067e\u0627\u06cc \u067e\u0634\u062a\u0647";
    }

    @Override
    public String obtenerTituloError() {
        return "\u062e\u0637\u0627";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "\u0647\u0646\u06af\u0627\u0645 \u067e\u0631\u062f\u0627\u0632\u0634 \u062e\u0637 \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647 \u062e\u0637\u0627\u06cc\u06cc \u0631\u062e \u062f\u0627\u062f";
    }

    @Override
    public String obtenerNombreError() {
        return "\u0646\u0627\u0645 \u062e\u0637\u0627";
    }

    @Override
    public String obtenerDescripcionError() {
        return "\u0634\u0631\u062d \u062f\u0642\u06cc\u0642";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "\u0627\u0646\u062a\u062e\u0627\u0628 \u0644\u0627\u06af";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "\u062e\u0637\u0627\u06cc \u0646\u0627\u0634\u0646\u0627\u0633";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc \u062f\u0631 \u0644\u0627\u06af\u200c\u0647\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0639\u0644\u062a \u0627\u0635\u0644\u06cc\u060c \u0631\u062f\u067e\u0627\u06cc \u067e\u0634\u062a\u0647 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "\u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646 \u0641\u0627\u06cc\u0644 \u0644\u0627\u06af \u0631\u0627 \u062e\u0648\u0627\u0646\u062f. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0641\u0627\u06cc\u0644 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f \u0648 \u062f\u0633\u062a\u0631\u0633\u06cc \u062e\u0648\u0627\u0646\u062f\u0646 \u062f\u0627\u0631\u062f.";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "\u062a\u062d\u0644\u06cc\u0644\u200c\u06af\u0631 \u0644\u0627\u06af";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u062b\u0628\u062a \u0645\u0634\u062a\u0631\u06a9\u0627\u0646 \u062e\u0648\u062f\u06a9\u0627\u0631 \u0628\u0631\u0627\u06cc \u0645\u0648\u062f '").append(modId).append("' \u0646\u0627\u0645\u0648\u0641\u0642 \u0628\u0648\u062f. ");
        mensaje.append("\u06a9\u0644\u0627\u0633 \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631: <b>").append(nombreClase).append("</b>. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u062f\u0631 \u0627\u06cc\u0646 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0642\u0631\u0627\u0631 \u062f\u0627\u0631\u062f: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0645\u0648\u062f\u06cc \u0633\u0639\u06cc \u06a9\u0646\u062f \u06a9\u0644\u0627\u0633\u06cc \u0631\u0627 \u0628\u0647\u200c\u0639\u0646\u0648\u0627\u0646 \u06af\u06cc\u0631\u0646\u062f\u0647 \u0631\u0648\u06cc\u062f\u0627\u062f \u0628\u0647\u200c\u0635\u0648\u0631\u062a \u062e\u0648\u062f\u06a9\u0627\u0631 \u062b\u0628\u062a \u06a9\u0646\u062f\u060c \u0627\u0645\u0627 \u06a9\u0644\u0627\u0633 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0634\u0648\u062f. ");
        mensaje.append("<b>\u062e\u0637\u0627\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 \u062f\u0631 \u0644\u0627\u06af \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0639\u0644\u062a \u0627\u0635\u0644\u06cc \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u0646\u0627\u0645\u0648\u0641\u0642 \u0642\u0628\u0644\u06cc \u0628\u0627\u0634\u062f</b>.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "\u062b\u0628\u062a \u0645\u0634\u062a\u0631\u06a9\u0627\u0646 \u062e\u0648\u062f\u06a9\u0627\u0631 \u0646\u0627\u0645\u0648\u0641\u0642";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "\u0645\u0648\u062f <b>" + modId + "</b> \u062f\u0631 \u062d\u0627\u0644 \u062b\u0628\u062a \u06a9\u0644\u0627\u0633 <b>" + nombreClase + "</b> \u0628\u0647\u200c\u0639\u0646\u0648\u0627\u0646 \u06af\u06cc\u0631\u0646\u062f\u0647 \u062e\u0648\u062f\u06a9\u0627\u0631 \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f\u0647 \u0627\u0633\u062a. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f \u0648 \u0642\u0627\u0628\u0644 \u062f\u0633\u062a\u0631\u0633\u06cc \u0627\u0633\u062a";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u06a9\u0644\u0627\u0633 \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 <b>" + nombreClase + "</b> \u062f\u0631 \u0627\u06cc\u0646 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0627\u0633\u062a: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            paso.append("</b>. ");
            paso.append("\u0627\u0632 \u0648\u06cc\u0698\u06af\u06cc <b>\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627</b> \u0628\u0631\u0627\u06cc \u062a\u0634\u062e\u06cc\u0635 \u0641\u0627\u06cc\u0644 \u062f\u0642\u06cc\u0642 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f");
            return paso.toString();
        }
        return "\u06a9\u0644\u0627\u0633 <b>" + nombreClase + "</b> \u062f\u0631 \u0647\u06cc\u0686 \u0641\u0627\u06cc\u0644 \u0645\u0648\u062f\u06cc \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0645\u0648\u062f <b>" + modId + "</b> \u0628\u0647\u200c\u062f\u0631\u0633\u062a\u06cc \u0646\u0635\u0628 \u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u0632 \u0648\u06cc\u0698\u06af\u06cc <b>\u062f\u0631\u062e\u062a \u0645\u0648\u062f\u0647\u0627</b> \u0628\u0631\u0627\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0645\u0634\u06a9\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "\u0645\u0648\u062f <b>" + modId + "</b> \u0631\u0627 \u0628\u0647 \u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0627\u064a\u0646 \u0643\u0631\u0627\u0641\u062a \u0648 Forge \u062e\u0648\u062f \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0642\u06cc \u0645\u0627\u0646\u062f\u060c \u0628\u0627 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u0647 \u0645\u0648\u062f \u062a\u0645\u0627\u0633 \u0628\u06af\u06cc\u0631\u06cc\u062f \u0648 \u062e\u0637\u0627 \u0631\u0627 \u0647\u0645\u0631\u0627\u0647 \u0628\u0627 \u06a9\u0644\u0627\u0633 \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u06af\u0632\u0627\u0631\u0634 \u062f\u0647\u06cc\u062f";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "\u062e\u0637\u0627\u0647\u0627\u06cc <b>\u062f\u06cc\u06af\u0631 \u062f\u0631 \u0644\u0627\u06af</b> \u0642\u0628\u0644 \u0627\u0632 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0645\u0634\u06a9\u0644 \u0648\u0627\u0642\u0639\u06cc \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u062f\u0631 \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u0642\u0628\u0644\u06cc \u0628\u0627\u0634\u062f. \u06af\u0627\u0647\u06cc \u0627\u0648\u0642\u0627\u062a \u06cc\u06a9 \u062e\u0637\u0627 \u0642\u0628\u0644\u06cc \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u0644\u0627\u0632\u0645 \u0628\u0631\u0627\u06cc \u062b\u0628\u062a \u0631\u0648\u06cc\u062f\u0627\u062f \u0631\u0627 \u0645\u0633\u062f\u0648\u062f \u0645\u06cc\u200c\u06a9\u0646\u062f";
    }

    @Override
    public String limpiado() {
        return "\u067e\u0627\u06a9\u200c\u0634\u062f\u0647";
    }

    @Override
    public String original() {
        return "\u0627\u0635\u0644\u06cc";
    }

    @Override
    public String verEnConsola() {
        return "\u0645\u0634\u0627\u0647\u062f\u0647 \u062f\u0631 \u0644\u0627\u06af";
    }

    @Override
    public String advertencia() {
        return "\u0647\u0634\u062f\u0627\u0631";
    }

    @Override
    public String fatal() {
        return "\u06a9\u0634\u0646\u062f\u0647";
    }

    @Override
    public String noRegistroDeBattly() {
        return "BattlyLauncher \u0644\u0627\u06af \u06cc\u0627 \u06a9\u0646\u0633\u0648\u0644\u06cc \u0628\u0631\u0627\u06cc \u06a9\u067e\u06cc \u06a9\u0631\u062f\u0646 \u0646\u062f\u0627\u0631\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 ProxySysOutSysErr \u0628\u0631\u0627\u06cc \u062f\u0631\u0646\u06af \u06a9\u0631\u062f\u0646 STDOUT \u0648 STDERR \u0648 \u0631\u06cc\u200c\u0627\u0633\u062a\u0627\u0631\u062a \u0628\u0627\u0632\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0627\u0645\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a ProxySysOutSysErr \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc\u06cc \u06a9\u0647 STDOUT \u06cc\u0627 STDERR \u0631\u0627 \u062a\u063a\u06cc\u06cc\u0631 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u062a\u062f\u0627\u062e\u0644 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "\u0628\u0631\u0627\u06cc \u062f\u0631\u06cc\u0627\u0641\u062a \u0644\u0627\u06af \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u060c \u0628\u0627\u06cc\u062f \u062d\u0627\u0644\u062a \u062f\u06cc\u0628\u0627\u06af \u0631\u0627 \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a NightWorld \u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f. \u0627\u06cc\u0646 \u0645\u0648\u0636\u0648\u0639 \u0628\u0633\u06cc\u0627\u0631 \u0645\u0647\u0645 \u0627\u0633\u062a\u060c \u0628\u0647\u200c\u0648\u06cc\u0698\u0647 \u0686\u0648\u0646 \u0634\u0627\u0645\u0644 STDOUT \u0648 STDERR \u0645\u06cc\u200c\u0634\u0648\u062f";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "\u0628\u0627\u06cc\u062f \u0645\u062d\u062a\u0648\u0627\u06cc \u062a\u0631\u0645\u06cc\u0646\u0627\u0644 \u0633\u0631\u0648\u0631 \u062e\u0648\u062f \u0631\u0627 \u0630\u062e\u06cc\u0631\u0647 \u06cc\u0627 \u062c\u0627\u06cc\u06af\u0630\u0627\u0631\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u062d\u0627\u0648\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a\u06cc \u0627\u0633\u062a \u06a9\u0647 \u062f\u0631 \u0633\u0627\u06cc\u0631 \u0644\u0627\u06af\u200c\u0647\u0627 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f\u060c \u0627\u0632 \u062c\u0645\u0644\u0647 STDOUT\u060c STDERR \u0648 \u0633\u0627\u06cc\u0631 \u062e\u0637\u0627\u0647\u0627. \u0644\u0637\u0641\u0627\u064b \u0645\u062d\u062a\u0648\u0627\u06cc \u0622\u062e\u0631\u06cc\u0646 \u062c\u0644\u0633\u0647 \u0631\u0627 \u062c\u0627\u06cc\u06af\u0630\u0627\u0631\u06cc \u06a9\u0646\u06cc\u062f. \u0628\u0631\u0627\u06cc \u0622\u06cc\u0646\u062f\u0647\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u062e\u0631\u0648\u062c\u06cc \u062a\u0631\u0645\u06cc\u0646\u0627\u0644 \u0631\u0627 \u0628\u0647 \u0641\u0627\u06cc\u0644\u06cc \u0628\u0647 \u0646\u0627\u0645 cd_launcherlog \u0630\u062e\u06cc\u0631\u0647 \u06a9\u0646\u06cc\u062f. \u0628\u0631\u0627\u06cc \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0627\u0632 \u0646\u06cc\u0627\u0632 \u0628\u0647 \u062c\u0627\u06cc\u06af\u0630\u0627\u0631\u06cc\u060c \u067e\u0633 \u0627\u0632 \u062f\u0633\u062a\u0648\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0639\u0628\u0627\u0631\u062a >> cd_launcherlog \u0631\u0627 \u0627\u0636\u0627\u0641\u0647 \u06a9\u0646\u06cc\u062f (\u0647\u0645\u0627\u0646\u0637\u0648\u0631 \u06a9\u0647 \u062f\u0631 \u062a\u0635\u0648\u06cc\u0631 \u0646\u0634\u0627\u0646 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647). \u062a\u0648\u062c\u0647 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u06cc\u062f \u06a9\u0647 \u0627\u06cc\u0646 \u06a9\u0627\u0631 \u0628\u0627\u0639\u062b \u0645\u06cc\u200c\u0634\u0648\u062f \u062e\u0631\u0648\u062c\u06cc \u062f\u0631 \u062a\u0631\u0645\u06cc\u0646\u0627\u0644 \u0646\u0645\u0627\u06cc\u0634 \u062f\u0627\u062f\u0647 \u0646\u0634\u0648\u062f \u0648 \u0641\u0642\u0637 \u062f\u0631 \u0622\u0646 \u0641\u0627\u06cc\u0644 \u062b\u0628\u062a \u0634\u0648\u062f.";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u062a\u0631\u0627\u0646\u0633\u0641\u0648\u0631\u0645\u0631 LexForge \u062f\u0631 \u0645\u062d\u06cc\u0637 NeoForge \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. ");
        sb.append("</b>");
        sb.append("\u06a9\u0644\u0627\u0633 \u062f\u0631\u06af\u06cc\u0631: <b>").append(claseReceptora).append("</b>. ");
        sb.append("\u0631\u0627\u0628\u0637 \u0645\u062a\u0627\u062b\u0631 <b>").append(interfazObjetivo).append("</b> \u0627\u0633\u062a \u0648 ");
        sb.append("\u0645\u062a\u062f \u06af\u0645\u0634\u062f\u0647 <b>").append(firmaMetodoFaltante).append("</b> \u0645\u06cc\u200c\u0628\u0627\u0634\u062f. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u062f\u0631 \u0627\u06cc\u0646 \u0645\u06a9\u0627\u0646\u200c\u0647\u0627 \u06cc\u0627\u0641\u062a \u0634\u062f: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("\u0647\u06cc\u0686 JAR\u06cc \u062d\u0627\u0648\u06cc \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f\u061b \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0633\u0627\u06cc\u0647\u200c\u0632\u0646\u06cc \u0634\u062f\u0647 \u0628\u0627\u0634\u062f \u06cc\u0627 \u0628\u0647 \u0635\u0648\u0631\u062a jar-in-jar \u062a\u0639\u0628\u06cc\u0647 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f. ");
        }
        sb.append("\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u06cc\u06a9 \u062a\u0631\u0627\u0646\u0633\u0641\u0648\u0631\u0645\u0631/\u0633\u0631\u0648\u06cc\u0633 ModLauncher \u06a9\u0647 \u0628\u0631\u0627\u06cc MinecraftForge/LexForge \u06a9\u0627\u0645\u067e\u0627\u06cc\u0644 \u0634\u062f\u0647\u060c ");
        sb.append("\u062f\u0631 NeoForge \u0628\u0627 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0632 API ModLauncher \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0634\u0648\u062f. ");
        sb.append("\u0628\u0631\u0627\u06cc NeoForge\u060c \u0627\u06cc\u0646 \u062c\u0632\u0621 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06cc\u0627 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u06a9\u0646\u06cc\u062f.");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "\u062a\u0631\u0627\u0646\u0633\u0641\u0648\u0631\u0645\u0631 LexForge \u062f\u0631 NeoForge \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u062f\u0647";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "\u062a\u0631\u0627\u0646\u0633\u0641\u0648\u0631\u0645\u0631 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u06cc\u062f: <b>" + claseReceptora + "</b>. API \u0645\u0648\u0631\u062f \u0627\u0646\u062a\u0638\u0627\u0631 <b>" + interfazObjetivo + "</b> \u0627\u0633\u062a \u0648 \u0645\u062a\u062f \u06af\u0645\u0634\u062f\u0647 <b>" + firmaMetodoFaltante + "</b> \u0645\u06cc\u200c\u0628\u0627\u0634\u062f. \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u0622\u06cc\u0627 \u0645\u0648\u062f \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u0631\u0627 \u062f\u0631 <b>META-INF/services</b> \u062b\u0628\u062a \u06a9\u0631\u062f\u0647 \u0627\u0633\u062a \u0648 \u0622\u0646 \u0631\u0627 \u062f\u0631 NeoForge \u062d\u0630\u0641 \u06cc\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u0645\u06a9\u0627\u0646 \u0645\u0648\u062f(\u0647\u0627\u06cc) \u062f\u0631\u06af\u06cc\u0631: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("\u0647\u06cc\u0686 JAR\u06cc \u062d\u0627\u0648\u06cc \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f. jar-in-jar \u0648 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u0633\u0627\u06cc\u0647\u200c\u0632\u0646\u06cc \u0634\u062f\u0647 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f. ");
        }
        sb.append("\u0645\u0648\u0642\u062a\u0627\u064b \u0627\u06cc\u0646 JAR\u0647\u0627 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 NeoForge \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u0646\u0634\u0623 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u062a\u0623\u06cc\u06cc\u062f \u06a9\u0646\u06cc\u062f.");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "\u0627\u06cc\u0646 \u062c\u0632\u0621 \u0631\u0627 \u0628\u0627 \u0646\u0633\u062e\u0647 \u062e\u0627\u0635 NeoForge \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0622\u0646 \u0631\u0627 \u0646\u0633\u0628\u062a \u0628\u0647 \u0646\u0633\u062e\u0647 ModLauncher \u0645\u0648\u0631\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u062a\u0648\u0633\u0637 NeoForge \u062f\u0648\u0628\u0627\u0631\u0647 \u06a9\u0627\u0645\u067e\u0627\u06cc\u0644 \u06a9\u0646\u06cc\u062f. \u0627\u0632 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0628\u0627\u06cc\u0646\u0631\u06cc \u0642\u062f\u06cc\u0645\u06cc LexForge/MinecraftForge \u062e\u0648\u062f\u062f\u0627\u0631\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "\u067e\u0648\u0634\u0647 mods \u0631\u0627 \u067e\u0627\u06a9\u0633\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f \u0648 \u0645\u0648\u0627\u0631\u062f \u062a\u06a9\u0631\u0627\u0631\u06cc jar-in-jar \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u062f\u0631 \u0635\u0648\u0631\u062a \u0646\u06cc\u0627\u0632 \u06a9\u0634 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0631\u0627 \u067e\u0627\u06a9 \u06a9\u0646\u06cc\u062f \u0648 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0647\u06cc\u0686 \u062a\u0631\u0627\u0646\u0633\u0641\u0648\u0631\u0645\u0631 LexForge\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0645\u06cc\u200c\u0634\u0648\u062f.";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u0648\u062f: Xenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("\u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a.</b> ");
        sb.append("Xenon \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u0648 \u0628\u0647 \u062c\u0627\u06cc \u0622\u0646 \u0627\u0632 Embeddium \u06cc\u0627 Sodium \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u062f\u0631 \u0627\u06cc\u0646 \u0645\u0633\u06cc\u0631\u0647\u0627 \u067e\u06cc\u062f\u0627 \u0634\u062f: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "\u0646\u0627 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc WaterMedia \u0628\u0627 Xenon";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return label + " \u0628\u0627 WaterMedia \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a. \u0622\u0646 \u0631\u0627 \u0627\u0632 \u067e\u0631\u0648\u0641\u0627\u06cc\u0644 \u062e\u0648\u062f \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("\u0645\u0633\u06cc\u0631\u0647\u0627: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646...");
            }
            sb.append("</b>. \u0627\u06cc\u0646 \u0641\u0627\u06cc\u0644 JAR \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.");
            return sb.toString();
        }
        return "\u0647\u06cc\u0686 \u0641\u0627\u06cc\u0644 JAR\u06cc \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f. \u067e\u0648\u0634\u0647 mods \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0631\u062f\u0647 \u0648 Xenon \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "\u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646\u060c Embeddium \u06cc\u0627 Sodium \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0631\u062f\u0647 \u0648 \u0628\u0627\u0632\u06cc \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "\u062e\u0637\u0627\u06cc \u0641\u0634\u0631\u062f\u0647\u200c\u0633\u0627\u0632\u06cc (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>Deflater \u062f\u0631 \u062d\u06cc\u0646 \u06a9\u067e\u06cc \u0645\u0646\u0627\u0628\u0639 TACZ \u0628\u0633\u062a\u0647 \u0634\u062f.</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u0645\u0631\u062a\u0628\u0637 \u0628\u0627: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0648 \u062f\u06cc\u06af\u0631\u0627\u0646");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>\u0631\u0627\u0647\u200c\u062d\u0644:</b> \u062f\u0631 <code>tacz/tacz-pre.toml</code> \u0645\u0642\u062f\u0627\u0631 <code>DefaultPackDebug=true</code> \u0631\u0627 \u062a\u0646\u0638\u06cc\u0645 \u06a9\u0646\u06cc\u062f. ").append("\u062f\u0631 \u0635\u0648\u0631\u062a \u0646\u06cc\u0627\u0632\u060c \u0627\u0628\u062a\u062f\u0627 \u06cc\u06a9 \u0646\u0642\u0634\u0647 \u0627\u06cc\u062c\u0627\u062f \u06a9\u0631\u062f\u0647 \u0648 \u0633\u067e\u0633 \u0622\u0646 \u0631\u0627 \u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f.");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "\u062f\u0631 \u0641\u0627\u06cc\u0644 tacz/tacz-pre.toml \u0645\u0642\u062f\u0627\u0631 DefaultPackDebug=true \u0631\u0627 \u062a\u0646\u0638\u06cc\u0645 \u06a9\u0646\u06cc\u062f. \u062f\u0631 \u0635\u0648\u0631\u062a \u0646\u06cc\u0627\u0632\u060c \u0627\u0628\u062a\u062f\u0627 \u0646\u0642\u0634\u0647\u200c\u0627\u06cc \u0627\u06cc\u062c\u0627\u062f \u06a9\u0631\u062f\u0647 \u0648 \u0633\u067e\u0633 \u0622\u0646 \u0631\u0627 \u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "\u062a\u0648\u0627\u0628\u0639 \u0686\u06af\u0627\u0644\u06cc \u0645\u062a\u0635\u0644\u200c\u0646\u0634\u062f\u0647";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>\u062a\u0648\u0627\u0628\u0639 \u0686\u06af\u0627\u0644\u06cc \u062f\u0631 \u0631\u062c\u06cc\u0633\u062a\u0631\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u0646\u062f.</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("\u0645\u0641\u0642\u0648\u062f \u0634\u062f\u0647\u200c\u0647\u0627: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append(". ");
        }
        sb.append("<br/><b>\u0631\u0627\u0647\u200c\u062d\u0644:</b> mod/datapack\u06cc \u0631\u0627 \u06a9\u0647 \u0627\u06cc\u0646 \u062a\u0648\u0627\u0628\u0639 \u0631\u0627 \u062a\u0639\u0631\u06cc\u0641 \u0645\u06cc\u200c\u06a9\u0646\u062f\u060c \u0646\u0635\u0628 \u06cc\u0627 \u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f \u0648 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0646\u0645\u0627\u06cc\u06cc\u062f. \u062f\u0644\u06cc\u0644 \u062f\u06cc\u06af\u0631 \u0631\u0627\u06cc\u062c \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0627\u06cc\u0646 \u0627\u0633\u062a \u06a9\u0647 \u0634\u0645\u0627 mod \u0644\u0627\u0632\u0645 \u0631\u0627 \u062f\u0627\u0631\u06cc\u062f \u0627\u0645\u0627 \u0622\u0646 mod \u062f\u0686\u0627\u0631 \u0645\u0634\u06a9\u0644 \u0627\u0633\u062a \u06cc\u0627 \u0628\u0627 mod \u062f\u06cc\u06af\u0631\u06cc \u062f\u0631 \u062a\u062f\u0627\u062e\u0644 \u0627\u0633\u062a\u061b \u0628\u0647\u200c\u0639\u0646\u0648\u0627\u0646 \u0645\u062b\u0627\u0644\u060c Terralith \u0645\u0634\u06a9\u0644\u0627\u062a \u0632\u06cc\u0627\u062f\u06cc \u062f\u0627\u0631\u062f \u0648 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0648 \u0633\u0627\u06cc\u0631 \u062e\u0637\u0627\u0647\u0627 \u0627\u0632 \u062c\u0645\u0644\u0647 \u062e\u0637\u0627\u0647\u0627\u06cc JSON \u0631\u0627 \u0627\u06cc\u062c\u0627\u062f \u06a9\u0646\u062f.");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "\u0645\u0648\u062f \u06cc\u0627 \u062f\u06cc\u062a\u0627\u067e\u06a9\u06cc \u06a9\u0647 \u0627\u06cc\u0646 \u062a\u0648\u0627\u0628\u0639 \u0631\u0627 \u0641\u0631\u0627\u0647\u0645 \u0645\u06cc\u200c\u06a9\u0646\u062f \u0631\u0627 \u0646\u0635\u0628 \u06cc\u0627 \u0641\u0639\u0627\u0644 \u06a9\u0631\u062f\u0647 \u0648 \u0628\u0627\u0632\u06cc \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0648\u0631\u0648\u062f\u06cc \u0631\u062c\u06cc\u0633\u062a\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f: ").append(claveFaltante).append(". ");
        sb.append("\u0645\u0639\u0645\u0648\u0644\u0627\u064b \u062f\u0631 \u0646\u0633\u062e\u0647 \u0622\u0644\u0641\u0627\u06cc Steam & Railways \u0628\u0631\u0627\u06cc Create 6 \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (\u0622\u0644\u0641\u0627)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "\u0646\u0633\u062e\u0647 \u0622\u0644\u0641\u0627\u06cc Steam & Railways \u0628\u0631\u0627\u06cc Create 6 \u0631\u0627 \u062d\u0630\u0641 \u06cc\u0627 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0633\u0627\u0632\u06af\u0627\u0631 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u062a\u0636\u0627\u062f \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc: \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0647\u0645\u0632\u0645\u0627\u0646 Multiworld \u0628\u0627 Sodium/Embeddium/Rubidium \u0628\u0627\u0639\u062b ").append("IncompatibleClassChangeError (FabricLoader.getInstance) \u0645\u06cc\u200c\u0634\u0648\u062f. ").append("\u067e\u06cc\u0634\u0646\u0647\u0627\u062f: Multiworld \u06cc\u0627 \u0645\u0648\u062f \u0628\u0647\u06cc\u0646\u0647\u200c\u0633\u0627\u0632\u06cc \u0639\u0645\u0644\u06a9\u0631\u062f \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u06cc\u0627 \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "\u062a\u0636\u0627\u062f: Multiworld \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc \u0639\u0645\u0644\u06a9\u0631\u062f\u06cc";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "Multiworld \u06cc\u0627 Sodium/Embeddium/Rubidium \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u06cc\u0627 \u0628\u0647 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium \u062f\u0631\u0627\u06cc\u0648\u0631 \u06af\u0631\u0627\u0641\u06cc\u06a9\u06cc \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0631\u0627 \u062a\u0634\u062e\u06cc\u0635 \u062f\u0627\u062f\u0647 \u0627\u0633\u062a. \u062f\u0631\u0627\u06cc\u0648\u0631 GPU \u062e\u0648\u062f \u0631\u0627 \u0628\u0647 \u062d\u062f\u0627\u0642\u0644 \u0646\u0633\u062e\u0647 \u0645\u0648\u0631\u062f \u0646\u06cc\u0627\u0632 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0631\u0627\u0647\u0646\u0645\u0627\u06cc Sodium \u0631\u0627 \u062f\u0646\u0628\u0627\u0644 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "\u062e\u0637\u0627\u06cc \u0645\u062a\u0646 OpenGL";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OpenGL \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f: \u0647\u06cc\u0686 \u0645\u062a\u0646 \u0641\u0639\u0644\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f \u06cc\u0627 \u062a\u0627\u0628\u0639 \u062f\u0631 \u0627\u06cc\u0646 \u0645\u062a\u0646 \u062f\u0631 \u062f\u0633\u062a\u0631\u0633 \u0646\u06cc\u0633\u062a. \u0647\u0645\u0686\u0646\u06cc\u0646 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0645\u0634\u06a9\u0644\u06cc \u062f\u0631 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc \u0648\u06cc\u062f\u0626\u0648\u06cc\u06cc \u0628\u0627\u0634\u062f.</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "\u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc GPU \u062e\u0648\u062f \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06cc\u0627 \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f \u0648 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f\u061b \u0631\u0648\u06cc\u0647\u0645\u200c\u06af\u0630\u0627\u0631\u06cc\u200c\u0647\u0627 \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0631\u062f\u0647 \u0648 \u0628\u062f\u0648\u0646 \u0645\u0648\u062f\u0647\u0627\u06cc \u0639\u0645\u0644\u06a9\u0631\u062f\u06cc \u0627\u0645\u062a\u062d\u0627\u0646 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "\u0644\u06cc\u0646\u06a9 \u062f\u0631 \u062d\u0627\u0641\u0638\u0647 \u0645\u0648\u0642\u062a \u06a9\u067e\u06cc \u0634\u062f.";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "\u062c\u0633\u062a\u062c\u0648 \u062f\u0627\u062e\u0644 \u0628\u0627\u06cc\u06af\u0627\u0646\u06cc\u200c\u0647\u0627 (.zip/.jar/.war/.ear/.fpm/.rar \u0628\u0631\u0627\u06cc Java*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0648\u0636\u0648\u062d \u0628\u0627\u0641\u062a: \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646 " + recurso + " \u0631\u0627 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0631\u062f - \u0627\u0646\u062f\u0627\u0632\u0647: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "\u062e\u0637\u0627\u06cc \u0648\u0636\u0648\u062d \u0628\u0627\u0641\u062a";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0628\u0627\u0641\u062a\u200c\u0647\u0627 \u062e\u06cc\u0644\u06cc \u0628\u0632\u0631\u06af \u0628\u0627\u0634\u0646\u062f \u06cc\u0627 \u062a\u0639\u062f\u0627\u062f \u0632\u06cc\u0627\u062f\u06cc \u067e\u06a9 \u0645\u0646\u0627\u0628\u0639 \u0648\u062c\u0648\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f. \u0633\u0639\u06cc \u06a9\u0646\u06cc\u062f \u0627\u0632 \u067e\u06a9\u200c\u0647\u0627\u06cc \u0645\u0646\u0627\u0628\u0639 \u0628\u0627 \u0648\u0636\u0648\u062d \u067e\u0627\u06cc\u06cc\u0646\u200c\u062a\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0628\u0631\u062e\u06cc \u0627\u0632 \u067e\u06a9\u200c\u0647\u0627 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0622\u06cc\u0627 \u0628\u0627\u0641\u062a \u0633\u0641\u0627\u0631\u0634\u06cc \u0628\u0627 \u0648\u0636\u0648\u062d \u0628\u0627\u0644\u0627\u062a\u0631 \u0627\u0632 \u062d\u062f \u0645\u062c\u0627\u0632 \u0627\u0636\u0627\u0641\u0647 \u0646\u06a9\u0631\u062f\u0647\u200c\u0627\u06cc\u062f.";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0633\u0631\u0648\u06cc\u0633\u200c\u0647\u0627\u06cc ModLauncher: \u0645\u0633\u06cc\u0631 \u0634\u0627\u0645\u0644 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a. \u0633\u0631\u0648\u06cc\u0633\u200c\u0647\u0627\u06cc ModLauncher \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u0646\u062f \u0645\u0633\u06cc\u0631\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0634\u0627\u0645\u0644 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u063a\u06cc\u0631 ASCII \u06cc\u0627 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u062e\u0627\u0635 \u0628\u0627\u0634\u0646\u062f \u0631\u0627 \u067e\u0631\u062f\u0627\u0632\u0634 \u06a9\u0646\u0646\u062f. \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u0645\u0634\u06a9\u0644\u200c\u0633\u0627\u0632 \u0634\u0627\u0645\u0644: \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694 \u0648 \u0628\u0647\u200c\u0648\u06cc\u0698\u0647 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631 '\"' \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u06a9\u0647 \u062f\u0631 \u0627\u0646\u062a\u0647\u0627\u06cc \u0646\u0627\u0645 \u0628\u0627\u0634\u062f\u060c \u0645\u06cc\u200c\u0634\u0648\u062f. \u0645\u0648\u0644\u0641\u0647\u200c\u0647\u0627\u06cc \u0631\u0627\u06cc\u062c \u0633\u0631\u0648\u06cc\u0633 \u062f\u0631 ModLauncher \u0634\u0627\u0645\u0644 CrashDetector\u060c " + Config.obtenerInstancia().obtenerNombreCD() + "\u060c FeatureCreep\u060c Vivicraft\u060c Optifine\u060c Sodium\u060c clonos\u060c Iris Shaders/Oculus\u060c MixerLogger\u060c CrashAssistant \u0648 Sintrya Connector \u0647\u0633\u062a\u0646\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u062a\u0645\u0627\u0645 \u0633\u0631\u0648\u06cc\u0633\u200c\u0647\u0627 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0627\u0645\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0646\u0627\u0645 \u0645\u0633\u06cc\u0631\u060c \u0645\u0634\u06a9\u0644\u0627\u062a \u062f\u06cc\u06af\u0631\u06cc \u067e\u06cc\u0634 \u0628\u06cc\u0627\u06cc\u062f. \u0631\u0627\u0647\u200c\u062d\u0644: \u0646\u0627\u0645 \u0645\u062c\u0645\u0648\u0639\u0647 \u0631\u0627 \u0641\u0642\u0637 \u0628\u0627 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc ASCII (a-z, A-Z, 0-9) \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f \u0648 \u0627\u0632 \u0641\u0627\u0635\u0644\u0647 \u0648 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u062e\u0627\u0635 \u067e\u0631\u0647\u06cc\u0632 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "\u062e\u0637\u0627\u06cc \u0645\u0633\u06cc\u0631 ModLauncher";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0645\u0633\u06cc\u0631 \u0645\u062c\u0645\u0648\u0639\u0647 \u0634\u0627\u0645\u0644 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u063a\u06cc\u0631 ASCII \u06cc\u0627 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u062e\u0627\u0635 \u0628\u0627\u0634\u062f. \u0633\u0631\u0648\u06cc\u0633\u200c\u0647\u0627\u06cc ModLauncher \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u0646\u062f \u0627\u06cc\u0646 \u0645\u0633\u06cc\u0631\u0647\u0627 \u0631\u0627 \u0645\u062f\u06cc\u0631\u06cc\u062a \u06a9\u0646\u0646\u062f. \u0631\u0627\u0647\u200c\u062d\u0644: \u0646\u0627\u0645 \u0645\u062c\u0645\u0648\u0639\u0647 \u0631\u0627 \u0628\u0647 \u06af\u0648\u0646\u0647\u200c\u0627\u06cc \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f \u06a9\u0647 \u0641\u0642\u0637 \u0627\u0632 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc ASCII (a-z, A-Z, 0-9) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u0648\u062f \u0648 \u0627\u0632 \u0641\u0627\u0635\u0644\u0647 \u0648 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u062e\u0627\u0635 \u0627\u062c\u062a\u0646\u0627\u0628 \u06a9\u0646\u06cc\u062f. \u0628\u0647 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631 '\"' \u062a\u0648\u062c\u0647 \u0648\u06cc\u0698\u0647\u200c\u0627\u06cc \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u06cc\u062f \u06a9\u0647 \u0628\u0633\u06cc\u0627\u0631 \u0645\u0634\u06a9\u0644\u200c\u0633\u0627\u0632 \u0627\u0633\u062a\u060c \u0628\u0647\u200c\u0648\u06cc\u0698\u0647 \u0648\u0642\u062a\u06cc \u062f\u0631 \u0627\u0646\u062a\u0647\u0627\u06cc \u0646\u0627\u0645 \u0642\u0631\u0627\u0631 \u062f\u0627\u0631\u062f.";
    }

    @Override
    public String tituloEditorCodice() {
        return "\u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631 \u06a9\u062f\u06cc\u0633";
    }

    @Override
    public String nuevo() {
        return "\u062c\u062f\u06cc\u062f";
    }

    @Override
    public String actualizarSeleccionado() {
        return "\u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u0645\u0648\u0631\u062f \u0627\u0646\u062a\u062e\u0627\u0628 \u0634\u062f\u0647";
    }

    @Override
    public String eliminarSeleccionado() {
        return "\u062d\u0630\u0641 \u0645\u0648\u0631\u062f \u0627\u0646\u062a\u062e\u0627\u0628 \u0634\u062f\u0647";
    }

    @Override
    public String exportarJSON() {
        return "\u0635\u062f\u0648\u0631 JSON...";
    }

    @Override
    public String guardarTodo() {
        return "\u0630\u062e\u06cc\u0631\u0647 \u0647\u0645\u0647";
    }

    @Override
    public String general() {
        return "\u0639\u0645\u0648\u0645\u06cc";
    }

    @Override
    public String id() {
        return "\u0634\u0646\u0627\u0633\u0647";
    }

    @Override
    public String paraBuscar() {
        return "\u0645\u062a\u0646 \u062c\u0633\u062a\u062c\u0648";
    }

    @Override
    public String filtro() {
        return "\u0641\u06cc\u0644\u062a\u0631 (\u0634\u0646\u0627\u0633\u0647)";
    }

    @Override
    public String criticalidad() {
        return "\u0633\u0637\u062d \u0627\u0647\u0645\u06cc\u062a (\u0647\u0634\u062f\u0627\u0631/\u062e\u0637\u0627/\u06a9\u0634\u0646\u062f\u0647)";
    }

    @Override
    public String prioridad() {
        return "\u0627\u0648\u0644\u0648\u06cc\u062a";
    }

    @Override
    public String lista() {
        return "\u0628\u0631\u0631\u0633\u06cc\u200c\u0647\u0627";
    }

    @Override
    public String colIdioma() {
        return "\u0632\u0628\u0627\u0646";
    }

    @Override
    public String colNombre() {
        return "\u0646\u0627\u0645";
    }

    @Override
    public String colResultado() {
        return "\u0646\u062a\u06cc\u062c\u0647";
    }

    @Override
    public String vistaJson() {
        return "\u067e\u06cc\u0634\u200c\u0646\u0645\u0627\u06cc\u0634 JSON";
    }

    @Override
    public String idiomas() {
        return "\u0632\u0628\u0627\u0646\u200c\u0647\u0627 (\u0647\u0645\u0647 \u0627\u0644\u0632\u0627\u0645\u06cc)";
    }

    @Override
    public String elegirFiltro() {
        return "\u0627\u0646\u062a\u062e\u0627\u0628...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "\u06cc\u06a9 \u0641\u06cc\u0644\u062a\u0631 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "\u0641\u06cc\u0644\u062a\u0631\u0647\u0627\u06cc \u0645\u0648\u062c\u0648\u062f";
    }

    @Override
    public String faltanCampos() {
        return "\u062a\u0645\u0627\u0645 \u0641\u06cc\u0644\u062f\u0647\u0627\u06cc \u0639\u0645\u0648\u0645\u06cc \u0636\u0631\u0648\u0631\u06cc \u0631\u0627 \u067e\u0631 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String critInvalida() {
        return "\u0633\u0637\u062d \u0627\u0647\u0645\u06cc\u062a \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a. \u0627\u0632 \u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627\u06cc \u0647\u0634\u062f\u0627\u0631\u060c \u062e\u0637\u0627 \u06cc\u0627 \u06a9\u0634\u0646\u062f\u0647 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String filtroNoExiste() {
        return "\u0641\u06cc\u0644\u062a\u0631 \u0645\u0634\u062e\u0635 \u0634\u062f\u0647 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.";
    }

    @Override
    public String faltanIdiomas() {
        return "\u0646\u0627\u0645 \u0648 \u0646\u062a\u06cc\u062c\u0647 \u0631\u0627 \u0628\u0631\u0627\u06cc \u062a\u0645\u0627\u0645 \u0632\u0628\u0627\u0646\u200c\u0647\u0627 \u062a\u06a9\u0645\u06cc\u0644 \u06a9\u0646\u06cc\u062f:";
    }

    @Override
    public String verificacionInvalida() {
        return "\u06cc\u06a9 \u0628\u0631\u0631\u0633\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a. \u0644\u0637\u0641\u0627\u064b \u0641\u06cc\u0644\u062f\u0647\u0627 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String guardadoOk() {
        return "\u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f.";
    }

    @Override
    public String editorCodiceBoton() {
        return "\u0627\u0641\u0632\u0648\u062f\u0646 \u062f\u0644\u0627\u06cc\u0644";
    }

    @Override
    public String descripcionEditorCodice() {
        return "\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u06cc\u0646\u062c\u0627 \u062f\u0644\u0627\u06cc\u0644 \u0631\u0627 \u062b\u0628\u062a \u06a9\u0646\u06cc\u062f. \u0628\u0647 \u06cc\u06a9 \u0634\u0646\u0627\u0633\u0647 (ID) \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f \u06a9\u0647 \u0631\u0634\u062a\u0647\u200c\u0627\u06cc \u0628\u062f\u0648\u0646 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u062e\u0627\u0635\u060c \u0639\u0644\u0627\u0645\u062a \u0644\u0647\u062c\u0647 \u06cc\u0627 \u0641\u0627\u0635\u0644\u0647 \u0628\u0627\u0634\u062f. \u0628\u0631\u0627\u06cc \u0641\u06cc\u0644\u062a\u0631\u0647\u0627 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u00ab\u062e\u0637 \u0634\u0627\u0645\u0644\u00bb \u0628\u0631\u0627\u06cc \u062c\u0633\u062a\u062c\u0648\u06cc \u06cc\u06a9 \u0631\u0634\u062a\u0647 \u062f\u0631 \u06cc\u06a9 \u062e\u0637\u060c \u00ab\u0647\u0645\u0647 \u0634\u0627\u0645\u0644\u00bb \u0627\u06af\u0631 \u0633\u06cc\u0627\u0647\u0647 \u0634\u0627\u0645\u0644 \u06cc\u06a9 \u0631\u0634\u062a\u0647 \u0628\u0627\u0634\u062f\u060c \u00ab\u0639\u0628\u0627\u0631\u062a \u0645\u0646\u0638\u0645 \u062e\u0637\u00bb \u0627\u06af\u0631 \u06cc\u06a9 \u062e\u0637 \u0628\u0627 \u0639\u0628\u0627\u0631\u062a \u0645\u0646\u0638\u0645 \u062a\u0637\u0628\u06cc\u0642 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f\u060c \u0648 \u00ab\u0639\u0628\u0627\u0631\u062a \u0645\u0646\u0638\u0645 \u0647\u0645\u0647\u00bb \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f (\u067e\u06cc\u0634\u0646\u0647\u0627\u062f \u0645\u06cc\u200c\u0634\u0648\u062f \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062e\u0637 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f). \u0628\u0627\u06cc\u062f \u0633\u0637\u062d \u0627\u0647\u0645\u06cc\u062a \u0631\u0627 \u062a\u0639\u06cc\u06cc\u0646 \u06a9\u0646\u06cc\u062f: FATAL\u060c ERROR \u06cc\u0627 ADVERTENCIA \u062a\u0627 \u0631\u0646\u06af\u200c\u0628\u0646\u062f\u06cc \u0627\u0646\u062c\u0627\u0645 \u0634\u0648\u062f. \u0628\u0631\u0627\u06cc \u062a\u0645\u0627\u0645 \u0632\u0628\u0627\u0646\u200c\u0647\u0627 \u0628\u0627\u06cc\u062f \u06cc\u06a9 \u0646\u0627\u0645 \u0648 \u067e\u0627\u0633\u062e \u0628\u0646\u0648\u06cc\u0633\u06cc\u062f \u06a9\u0647 \u0631\u0648\u06cc \u0635\u0641\u062d\u0647 \u0646\u0645\u0627\u06cc\u0634 \u062f\u0627\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0628\u0631\u0631\u0633\u06cc\u200c\u0647\u0627\u06cc \u0628\u06cc\u0634\u062a\u0631\u06cc \u0627\u0636\u0627\u0641\u0647 \u06cc\u0627 \u0628\u0631\u062e\u06cc \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u067e\u0633 \u0627\u0632 \u062a\u06a9\u0645\u06cc\u0644 \u0630\u062e\u06cc\u0631\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f.";
    }

    @Override
    public String descartarCambios() {
        return "\u0622\u06cc\u0627 \u0645\u06cc\u200c\u062e\u0648\u0627\u0647\u06cc\u062f \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0630\u062e\u06cc\u0631\u0647\u200c\u0646\u0634\u062f\u0647 \u062f\u0631 \u0628\u0631\u0631\u0633\u06cc \u062c\u0627\u0631\u06cc \u0631\u0627 \u062f\u0648\u0631 \u0628\u06cc\u0646\u062f\u0627\u0632\u06cc\u062f\u061f";
    }

    @Override
    public String confirmacion() {
        return "\u062a\u0627\u06cc\u06cc\u062f";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\u0622\u06cc\u0627 \u0642\u0628\u0644 \u0627\u0632 \u062e\u0631\u0648\u062c\u060c \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0631\u0627 \u0630\u062e\u06cc\u0631\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u061f";
    }

    @Override
    public String salirSinGuardar() {
        return "\u062e\u0631\u0648\u062c \u0628\u062f\u0648\u0646 \u0630\u062e\u06cc\u0631\u0647";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0633\u0631\u0648\u06cc\u0633 modlauncher (IDependencyLocator) \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f.<br>");
        sb.append("\ud83d\udd39 <b>\u06a9\u0644\u0627\u0633 \u0645\u0634\u06a9\u0644\u200c\u0633\u0627\u0632:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>\u0645\u0648\u062f \u062a\u062d\u062a \u062a\u0623\u062b\u06cc\u0631:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>\u0645\u0648\u062f \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0646\u0634\u062f.</b> \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u062e\u06cc\u0631\u0627\u064b \u0646\u0635\u0628 \u0634\u062f\u0647\u060c \u062a\u0648\u0633\u0639\u0647\u200c\u0627\u06cc \u06cc\u0627 \u0628\u062f \u0628\u0633\u062a\u0647\u200c\u0628\u0646\u062f\u06cc \u0634\u062f\u0647 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.<br>");
        }
        sb.append("\ud83d\udd38 <b>\u0639\u0644\u062a:</b> \u0641\u0627\u06cc\u0644 <code>META-INF/services/...</code> \u0645\u0648\u062f \u062e\u0631\u0627\u0628 \u0627\u0633\u062a\u060c ");
        sb.append("\u0628\u0627 \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc Forge/NeoForge \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u060c \u06cc\u0627 \u0645\u0648\u062f \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647 \u0627\u0634\u062a\u0628\u0627\u0647\u06cc \u0627\u0633\u062a.<br>");
        sb.append("\ud83d\udd38 <b>\u067e\u06cc\u0627\u0645\u062f:</b> Forge/NeoForge \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u0645\u0648\u062f \u0631\u0627 \u062b\u0628\u062a \u06a9\u0646\u062f\u060c ");
        sb.append("\u06a9\u0647 \u0628\u0627\u0639\u062b \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u0645\u06cc\u200c\u0634\u0648\u062f.<br>");
        sb.append("\ud83d\udd38 <b>\u0631\u0627\u0647\u200c\u062d\u0644:</b> \u0645\u0648\u062f \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u060c \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06cc\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. ");
        sb.append("\u0627\u06af\u0631 \u0627\u0632 \u0645\u0648\u062f\u0647\u0627\u06cc \u062a\u0648\u0633\u0639\u0647\u200c\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647 \u062f\u0642\u06cc\u0642 Forge/NeoForge \u0634\u0645\u0627 \u06a9\u0627\u0645\u067e\u0627\u06cc\u0644 \u0634\u062f\u0647\u200c\u0627\u0646\u062f.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "\u062e\u0637\u0627\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u0633\u0631\u0648\u06cc\u0633 (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. \u0645\u0648\u062f \u0639\u0627\u0645\u0644 \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u06cc\u062f: \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u062e\u06cc\u0631\u0627\u064b \u0646\u0635\u0628 \u0634\u062f\u0647 \u06cc\u0627 \u062f\u0631 \u062d\u0627\u0644 \u062a\u0648\u0633\u0639\u0647 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.";
        }
        return "1. \u0645\u0648\u062f \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0627\u06cc\u0646 \u0627\u0633\u062a: " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. \u0645\u0648\u062f \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u060c \u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06cc\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 Forge/NeoForge \u062e\u0648\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0645\u062a\u0648\u062f \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.</b><br>\u0645\u0648\u062f \u0633\u0639\u06cc \u06a9\u0631\u062f \u0628\u0647 \u0645\u062a\u0648\u062f <b style='color:#" + colorCodigo + "'>" + metodo + "</b> \u0641\u0631\u0627\u062e\u0648\u0627\u0646\u06cc \u06a9\u0646\u062f\u060c \u06a9\u0647 \u062f\u0631 \u0627\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0627\u0632 \u0628\u0627\u0632\u06cc \u06cc\u0627 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "\u0645\u062a\u0648\u062f \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u06cc\u06a9 \u0645\u0648\u062f \u0628\u0627 \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc \u0628\u0627\u0632\u06cc \u06cc\u0627 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631\u06cc \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627\u0634\u062f.";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. \u062a\u0645\u0627\u0645 \u0645\u0648\u062f\u0647\u0627\u06cc \u062f\u0631\u06af\u06cc\u0631 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0642\u06cc \u0645\u0627\u0646\u062f\u060c \u062e\u0637\u0627\u06cc \u0631\u0627 \u0628\u0647 \u0646\u0648\u06cc\u0633\u0646\u062f\u0647 \u0645\u0648\u062f \u062a\u062d\u062a \u062a\u0623\u062b\u06cc\u0631 \u06af\u0632\u0627\u0631\u0634 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: \u0641\u06cc\u0644\u062f \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.</b><br>\u0645\u0648\u062f \u0633\u0639\u06cc \u06a9\u0631\u062f \u0628\u0647 \u0641\u06cc\u0644\u062f <b style='color:#" + colorCodigo + "'>" + campo + "</b> \u062f\u0633\u062a\u0631\u0633\u06cc \u067e\u06cc\u062f\u0627 \u06a9\u0646\u062f\u060c \u06a9\u0647 \u062f\u0631 \u0627\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0627\u0632 \u0628\u0627\u0632\u06cc \u06cc\u0627 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "\u0641\u06cc\u0644\u062f \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u06cc\u06a9 \u0645\u0648\u062f \u0628\u0627 \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc \u0628\u0627\u0632\u06cc \u06cc\u0627 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631\u06cc \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627\u0634\u062f.";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. \u062a\u0645\u0627\u0645 \u0645\u0648\u062f\u0647\u0627\u06cc \u062a\u062d\u062a \u062a\u0623\u062b\u06cc\u0631 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0627\u062f\u0627\u0645\u0647 \u062f\u0627\u0634\u062a\u060c \u0628\u0627 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u0647 \u0645\u0648\u062f\u06cc \u06a9\u0647 \u062e\u0637\u0627 \u0631\u0627 \u0627\u06cc\u062c\u0627\u062f \u06a9\u0631\u062f\u0647 \u062a\u0645\u0627\u0633 \u0628\u06af\u06cc\u0631\u06cc\u062f.";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\u0628\u0647 \u06a9\u0645\u06a9 \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f\u061f</strong><br>  \u0627\u06af\u0631 \u0646\u0645\u06cc\u200c\u062f\u0627\u0646\u06cc\u062f \u0686\u06af\u0648\u0646\u0647 \u0622\u0646 \u0631\u0627 \u0631\u0641\u0639 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0639\u0644\u062a \u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0637\u0631\u06cc\u0642 \u0634\u0628\u06a9\u0647\u200c\u0647\u0627\u06cc \u0627\u062c\u062a\u0645\u0627\u0639\u06cc \u0645\u0627 \u06a9\u0645\u06a9 \u0628\u06af\u06cc\u0631\u06cc\u062f.   \u0627\u0632 \u062f\u06a9\u0645\u0647 <img src='" + iconoCompartir + "' alt='\u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc' style='height:12px;vertical-align:middle;'/>   <strong>\u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc</strong> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u067e\u06cc\u0648\u0646\u062f\u0647\u0627\u06cc\u06cc \u0628\u0647 \u0633\u06cc\u0627\u0647\u0647\u200c\u0647\u0627 \u0648 \u0646\u062a\u0627\u06cc\u062c \u0628\u0631\u0627\u06cc \u062a\u06cc\u0645 \u0645\u0627 \u062f\u0631\u06cc\u0627\u0641\u062a \u06a9\u0646\u06cc\u062f.   \u0627\u06af\u0631 \u0633\u0627\u0632\u0646\u062f\u0647\u0654 \u0645\u0648\u062f\u067e\u06a9 \u06cc\u0627 \u06cc\u06a9 \u0634\u0631\u06a9\u062a \u0647\u0633\u062a\u06cc\u062f\u060c \u0641\u0627\u06cc\u0644 <code>crash_detector/plantilla.htm</code> \u0631\u0627 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0646\u06cc\u062f   \u062a\u0627 \u067e\u06cc\u0648\u0646\u062f\u0647\u0627\u06cc \u062a\u06cc\u0645 \u062e\u0648\u062f \u0631\u0627 \u0634\u062e\u0635\u06cc\u200c\u0633\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f.</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0627\u0644\u06af\u0648";
    }

    @Override
    public String restablecer() {
        return "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return "\u0622\u06cc\u0627 " + nombreImagen + " \u0631\u0627 \u0628\u0647 \u0645\u0642\u0627\u062f\u06cc\u0631 \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 \u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u06a9\u0646\u06cc\u0645\u061f";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\u0622\u06cc\u0627 \u0627\u0644\u06af\u0648 \u0631\u0627 \u0628\u0647 \u0645\u0642\u0627\u062f\u06cc\u0631 \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 \u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u06a9\u0646\u06cc\u0645\u061f";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc AzureLib \u06cc\u0627\u0641\u062a \u0646\u0634\u062f. \u0627\u06af\u0631 \u0642\u0628\u0644\u0627\u064b AzureLib \u062f\u0627\u0631\u06cc\u062f\u060c \u0644\u0637\u0641\u0627\u064b \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0642\u0628\u0644 \u0627\u0632 \u06f8 \u0627\u06a9\u062a\u0628\u0631 \u06f2\u06f0\u06f2\u06f5 \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0631\u0627\u06cc\u062c \u0628\u0648\u062f. \u0627\u06af\u0631 AzureLib \u0646\u062f\u0627\u0631\u06cc\u062f\u060c \u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0645\u0648\u062f <code>healight</code> \u0628\u0627\u0639\u062b \u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc \u0645\u06cc\u200c\u0634\u0648\u062f: <code>java.lang.NoSuchFieldError: INT</code>. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0645\u0648\u062f \u0633\u0639\u06cc \u06a9\u0646\u062f \u0628\u0647 \u0641\u06cc\u0644\u062f\u06cc \u062f\u0633\u062a\u0631\u0633\u06cc \u067e\u06cc\u062f\u0627 \u06a9\u0646\u062f \u06a9\u0647 \u062f\u0631 \u0646\u0633\u062e\u0647 MCForge 47.10 \u0628\u0631\u0627\u06cc \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a 1.20+ \u062f\u06cc\u06af\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f. \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644\u060c \u0628\u0627\u0632\u06cc \u0642\u0627\u0628\u0644 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0646\u06cc\u0633\u062a.</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 \u0645\u0648\u062f <code>healight</code> \u0631\u0627 \u062d\u0630\u0641 \u06cc\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f. \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc \u0628\u0627 MinecraftForge 47.10 \u0628\u0631\u0627\u06cc 1.20.1 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a. \u0646\u0633\u062e\u0647 \u062c\u062f\u06cc\u062f\u062a\u0631\u06cc \u0627\u0632 \u0645\u0648\u062f \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0627\u0632 \u06cc\u06a9 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "\u062e\u0637\u0627\u06cc \u0628\u062d\u0631\u0627\u0646\u06cc: healight - \u0641\u06cc\u0644\u062f 'INT' \u06cc\u0627\u0641\u062a \u0646\u0634\u062f";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("\u06a9\u0644\u0627\u0633 <code>").append(clase).append("</code> \u0645\u062a\u062f \u0627\u0644\u0632\u0627\u0645\u06cc \u0632\u06cc\u0631 \u0631\u0627 \u067e\u06cc\u0627\u062f\u0647\u200c\u0633\u0627\u0632\u06cc \u0646\u06a9\u0631\u062f\u0647 \u0627\u0633\u062a:<br>").append("<code>").append(metodo).append("</code><br>").append("\u0627\u0632 \u0631\u0627\u0628\u0637 <code>").append(interfaz).append("</code>.");
        if (!origen.isEmpty()) {
            sb.append("<br><br>\u0645\u0648\u062f \u06cc\u0627 \u0641\u0627\u06cc\u0644 \u0645\u0634\u06a9\u0648\u06a9: <code>").append(origen).append("</code>.");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u06cc\u06a9 \u0645\u0648\u062f \u06cc\u06a9 \u0631\u0627\u0628\u0637 \u0631\u0627 \u067e\u06cc\u0627\u062f\u0647\u200c\u0633\u0627\u0632\u06cc \u06a9\u0646\u062f \u0627\u0645\u0627 \u06cc\u06a9 \u0645\u062a\u062f \u0636\u0631\u0648\u0631\u06cc \u0631\u0627 \u0641\u0631\u0627\u0645\u0648\u0634 \u06a9\u0646\u062f. <b>\u0647\u0631 \u062f\u0648 \u0645\u0648\u062f</b> \u062f\u0631\u06af\u06cc\u0631 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f (\u0645\u0648\u062f\u06cc \u06a9\u0647 \u0631\u0627\u0628\u0637 \u0631\u0627 \u062a\u0639\u0631\u06cc\u0641 \u0645\u06cc\u200c\u06a9\u0646\u062f \u0648 \u0645\u0648\u062f\u06cc \u06a9\u0647 \u0622\u0646 \u0631\u0627 \u067e\u06cc\u0627\u062f\u0647\u200c\u0633\u0627\u0632\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f). \u0627\u06af\u0631 \u0646\u0645\u06cc\u200c\u062f\u0627\u0646\u06cc\u062f \u06a9\u062f\u0627\u0645 \u0647\u0633\u062a\u0646\u062f\u060c \u0628\u0647 \u0646\u0627\u0645\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u062f\u0631 \u067e\u06cc\u0627\u0645 \u062e\u0637\u0627 \u0646\u0634\u0627\u0646 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647 \u0646\u06af\u0627\u0647 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "\u0645\u062a\u062f \u0631\u0627\u0628\u0637 \u067e\u06cc\u0627\u062f\u0647\u200c\u0633\u0627\u0632\u06cc \u0646\u0634\u062f\u0647 (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u06cc\u06a9 \u0645\u0648\u062f \u062f\u0631 \u062d\u0627\u0644 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u06cc\u06a9 \u06a9\u0644\u0627\u0633 <b>\u0637\u0631\u0641 \u06a9\u0644\u0627\u06cc\u0646\u062a</b> (<code>AnimationMetadataSection</code>) \u0631\u0648\u06cc \u06cc\u06a9 <b>\u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc</b> \u0627\u0633\u062a\u060c \u06a9\u0647 \u063a\u06cc\u0631\u0645\u0645\u06a9\u0646 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u06cc\u06a9 \u0645\u0648\u062f \u06a9\u062f \u062e\u0648\u062f \u0631\u0627 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0628\u06cc\u0646 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0648 \u0633\u0631\u0648\u0631 \u062c\u062f\u0627 \u0646\u06a9\u0646\u062f. \u0648\u062c\u0648\u062f <code>ModernFix</code> \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0622\u0634\u06a9\u0627\u0631 \u06a9\u0646\u062f\u060c \u0647\u0631\u0686\u0646\u062f \u0639\u0644\u062a \u0645\u0633\u062a\u0642\u06cc\u0645 \u0646\u06cc\u0633\u062a.</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>\u0631\u0627\u0647\u200c\u062d\u0644 \u0633\u0631\u06cc\u0639:</b> \u0628\u0631\u0627\u06cc \u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0633\u0631\u0648\u0631\u060c \u0645\u0648\u0642\u062a\u0627\u064b <code>ModernFix</code> \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0633\u0631\u0648\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u062f\u060c \u0645\u0634\u06a9\u0644 \u0627\u0632 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631\u06cc \u0627\u0633\u062a \u06a9\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06a9\u0644\u0627\u06cc\u0646\u062a \u0631\u0627 \u0631\u0648\u06cc \u0633\u0631\u0648\u0631 \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f.<br>\u2022 <b>\u0631\u0627\u0647\u200c\u062d\u0644 \u062f\u0627\u0626\u0645\u06cc:</b> \u0645\u0648\u062f \u0645\u0642\u0635\u0631 \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u06cc\u062f (\u0628\u0647 \u062f\u0646\u0628\u0627\u0644 \u0645\u0648\u062f\u0647\u0627\u06cc\u06cc \u0628\u0627 \u0645\u0646\u0627\u0628\u0639 \u0627\u0646\u06cc\u0645\u06cc\u0634\u0646\u06cc\u060c \u0628\u0627\u0641\u062a\u200c\u0647\u0627\u06cc \u0633\u0641\u0627\u0631\u0634\u06cc \u06cc\u0627 \u06a9\u062a\u0627\u0628\u062e\u0627\u0646\u0647\u200c\u0647\u0627\u06cc \u06af\u0631\u0627\u0641\u06cc\u06a9\u06cc \u0628\u0627\u0634\u06cc\u062f) \u0648 \u0622\u0646 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06cc\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "\u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u06a9\u0644\u0627\u0633 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0631\u0648\u06cc \u0633\u0631\u0648\u0631 (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0641\u0627\u06cc\u0644 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u06cc\u06a9 \u0645\u0648\u062f <code>Sinytra Connector</code> \u062e\u0631\u0627\u0628 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u0641\u0627\u06cc\u0644 \u0628\u0627 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631\u0647\u0627\u06cc \u062e\u0627\u0644\u06cc (<code>\\u0000</code>) \u067e\u0631 \u0634\u0648\u062f \u0628\u0647 \u062f\u0644\u06cc\u0644 \u062e\u0627\u0645\u0648\u0634\u06cc \u063a\u06cc\u0631\u0645\u0646\u062a\u0638\u0631\u0647 \u0628\u0627\u0632\u06cc\u060c \u062e\u0637\u0627 \u062f\u0631 \u0646\u0648\u0634\u062a\u0646 \u06cc\u0627 \u062a\u062f\u0627\u062e\u0644 \u0645\u0648\u062f\u0647\u0627.</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 \u0628\u0647 \u067e\u0648\u0634\u0647 <code>config/</code> \u0646\u0645\u0648\u0646\u0647 \u0628\u0627\u0632\u06cc \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u062e\u0648\u062f \u0628\u0631\u0648\u06cc\u062f.<br>\u2022 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0645\u0648\u062f\u0647\u0627\u06cc connector \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0631\u062f\u0647 \u0648 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.<br>\u2022 \u0628\u0627\u0632\u06cc \u0631\u0627 \u062f\u0648\u0628\u0627\u0631\u0647 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f: Sinytra Connector \u06cc\u06a9 \u0641\u0627\u06cc\u0644 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u062c\u062f\u06cc\u062f \u0648 \u062a\u0645\u06cc\u0632 \u0627\u06cc\u062c\u0627\u062f \u062e\u0648\u0627\u0647\u062f \u06a9\u0631\u062f.";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "\u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u062e\u0631\u0627\u0628 Sinytra Connector";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0641\u0627\u06cc\u0644 <code>" + nombreJar + "</code> \u062e\u0631\u0627\u0628 \u06cc\u0627 \u0646\u0627\u0642\u0635 \u0627\u0633\u062a.<br>\u0633\u06cc\u0633\u062a\u0645 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0645\u062d\u062a\u0648\u0627\u06cc \u0622\u0646 \u0631\u0627 \u0628\u062e\u0648\u0627\u0646\u062f \u0632\u06cc\u0631\u0627 \u0647\u062f\u0631 \u067e\u0627\u06cc\u0627\u0646\u06cc \u0641\u0627\u06cc\u0644 ZIP \u06af\u0645 \u0634\u062f\u0647 \u0627\u0633\u062a.<br>\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u067e\u0633 \u0627\u0632 \u062f\u0627\u0646\u0644\u0648\u062f \u0642\u0637\u0639 \u0634\u062f\u0647 \u06cc\u0627 \u062e\u0631\u0627\u0628\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f.</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "\u0641\u0627\u06cc\u0644 JAR \u062e\u0631\u0627\u0628 (\u0628\u0627 \u0646\u0627\u0645 \u0645\u0634\u062e\u0635)";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>\u0641\u0627\u06cc\u0644 \u062e\u0631\u0627\u0628 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f</b> \u0648 \u062f\u0648\u0628\u0627\u0631\u0647 \u0627\u0632 \u0645\u0646\u0628\u0639 \u0631\u0633\u0645\u06cc (CurseForge\u060c MinecraftStorage \u0648 \u063a\u06cc\u0631\u0647) \u062f\u0627\u0646\u0644\u0648\u062f \u06a9\u0646\u06cc\u062f.<br>\u2022 \u0627\u06af\u0631 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc\u06cc \u0645\u0627\u0646\u0646\u062f CurseForge\u060c Technic \u06cc\u0627 Luna Pixel \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0628\u0647\u062a\u0631 \u0627\u0633\u062a \u0628\u0647 <b>ATLauncher</b> \u06cc\u0627 <b>Prism Launcher</b> \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f\u060c \u06a9\u0647 \u0635\u062d\u062a \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0631\u0627 \u0628\u0647\u062a\u0631 \u0628\u0631\u0631\u0633\u06cc \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f.<br>\u2022 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u062f\u0631 \u0637\u0648\u0644 \u062f\u0627\u0646\u0644\u0648\u062f\u060c \u0627\u062a\u0635\u0627\u0644 \u0627\u06cc\u0646\u062a\u0631\u0646\u062a \u0634\u0645\u0627 \u067e\u0627\u06cc\u062f\u0627\u0631 \u0628\u0627\u0634\u062f.";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0646\u0627\u062a\u0648\u0627\u0646\u06cc \u062f\u0631 \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u062f\u0646\u06cc\u0627 \u0628\u0647 \u062f\u0644\u06cc\u0644 \u062e\u0631\u0627\u0628\u06cc \u06cc\u06a9\u06cc \u0627\u0632 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc NBT \u0622\u0646 (\u0645\u062b\u0644\u0627\u064b: <code>level.dat</code>, <code>playerdata/*.dat</code>\u060c \u06cc\u0627 \u0686\u0646\u06a9\u200c\u0647\u0627).<br>\u062e\u0637\u0627\u06cc \u062e\u0627\u0635: <code>UTFDataFormatException: \u0648\u0631\u0648\u062f\u06cc \u0645\u0639\u06cc\u0648\u0628 \u062f\u0631 \u0627\u0637\u0631\u0627\u0641 \u0628\u0627\u06cc\u062a " + byteCorrupto + "</code>.<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f \u0642\u0628\u0644 \u0627\u0632 \u0647\u0631 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u062a\u0639\u0645\u06cc\u0631\u060c \u06cc\u06a9 \u06a9\u067e\u06cc \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u06a9\u0627\u0645\u0644 \u0627\u0632 \u067e\u0648\u0634\u0647 \u062f\u0646\u06cc\u0627 \u0628\u06af\u06cc\u0631\u06cc\u062f.</b><br><br>\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0633\u0639\u06cc \u06a9\u0646\u06cc\u062f \u0641\u0627\u06cc\u0644 \u062e\u0631\u0627\u0628 \u0631\u0627 \u0628\u0627 \u06cc\u06a9 <b>\u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631 NBT</b> \u0645\u0627\u0646\u0646\u062f <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a> \u062a\u0639\u0645\u06cc\u0631 \u06a9\u0646\u06cc\u062f.<br>\u0627\u06af\u0631 \u0622\u0633\u06cc\u0628 \u062c\u062f\u06cc \u0628\u0627\u0634\u062f\u060c \u0627\u0632 \u06cc\u06a9 <b>\u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631 \u0647\u06af\u0632\u0627\u062f\u0633\u06cc\u0645\u0627\u0644</b> (\u0645\u0627\u0646\u0646\u062f HxD) \u0628\u0631\u0627\u06cc \u0628\u0631\u0631\u0633\u06cc \u0648 \u0627\u0635\u0644\u0627\u062d \u0628\u0627\u06cc\u062a\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f (\u0641\u0642\u0637 \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u06a9\u0647 \u0628\u0627 \u0641\u0631\u0645\u062a NBT \u062a\u062c\u0631\u0628\u0647 \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u06cc\u062f).<br>\u062f\u0631 \u0622\u062e\u0631\u06cc\u0646 \u062d\u0627\u0644\u062a\u060c \u0627\u0632 \u06cc\u06a9 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u0628\u0627\u0632\u06cc\u0627\u0628\u06cc \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0627\u0632 \u0642\u0627\u0628\u0644\u06cc\u062a <i>\u062a\u0639\u0645\u06cc\u0631 \u062f\u0646\u06cc\u0627</i> \u062f\u0631 \u0645\u0648\u062f\u0647\u0627\u06cc\u06cc \u0645\u0627\u0646\u0646\u062f <code>FTB Backup</code> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>\u0642\u0628\u0644 \u0627\u0632 \u0647\u0631 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u062a\u0639\u0645\u06cc\u0631\u060c \u06cc\u06a9 \u06a9\u067e\u06cc \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u06a9\u0627\u0645\u0644 \u0627\u0632 \u067e\u0648\u0634\u0647 \u062f\u0646\u06cc\u0627 \u0628\u06af\u06cc\u0631\u06cc\u062f</b>.<br>\u2022 \u0627\u0632 \u06cc\u06a9 \u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631 NBT (\u0645\u0627\u0646\u0646\u062f NBT Studio) \u0628\u0631\u0627\u06cc \u0628\u0627\u0632 \u06a9\u0631\u062f\u0646 \u0648 \u062a\u0639\u0645\u06cc\u0631 \u0641\u0627\u06cc\u0644 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.<br>\u2022 \u0627\u06af\u0631 \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f\u060c \u0641\u0627\u06cc\u0644 \u0631\u0627 \u0628\u0627 \u06cc\u06a9 \u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631 \u0647\u06af\u0632 \u062f\u0631 \u0645\u0648\u0642\u0639\u06cc\u062a \u0628\u0627\u06cc\u062a \u062e\u0631\u0627\u0628 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.<br>\u2022 \u0627\u06af\u0631 \u062a\u062c\u0631\u0628\u0647 \u0646\u062f\u0627\u0631\u06cc\u062f\u060c \u0627\u0632 \u06cc\u06a9 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u0627\u062e\u06cc\u0631 \u0628\u0627\u0632\u06cc\u0627\u0628\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "\u062f\u0646\u06cc\u0627\u06cc \u062e\u0631\u0627\u0628: \u062e\u0637\u0627\u06cc \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u062f\u0627\u062f\u0647\u200c\u0647\u0627\u06cc NBT";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0645\u0634\u06a9\u0644\u06cc \u0628\u0627 OpenAL \u062f\u0627\u0631\u06cc\u062f. \u06af\u0627\u0647\u06cc \u0627\u0648\u0642\u0627\u062a \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc Nouveau \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0627\u06cc\u062c\u0627\u062f \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f\u060c \u0627\u0645\u0627 \u06af\u0627\u0647\u06cc \u0647\u0645 \u0646\u0633\u062e\u0647\u0654 OpenAL \u06a9\u0647 \u0628\u0627 \u0628\u0631\u0646\u0627\u0645\u0647 \u0628\u0633\u062a\u0647\u200c\u0628\u0646\u062f\u06cc \u0634\u062f\u0647 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0648\u062c\u0648\u062f \u062f\u0631 \u062a\u0648\u0632\u06cc\u0639 \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a \u0648 \u0628\u0627\u06cc\u062f \u0627\u0632 \u0646\u0633\u062e\u0647 \u062a\u0648\u0632\u06cc\u0639 \u062e\u0648\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u0627\u06cc\u0646 \u0645\u0648\u0636\u0648\u0639 \u0628\u0647 \u0648\u06cc\u0698\u0647 \u062f\u0631 \u062a\u0648\u0632\u06cc\u0639\u200c\u0647\u0627\u06cc \u0645\u0628\u062a\u0646\u06cc \u0628\u0631 Red Hat \u0648 \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc \u0635\u062f\u0627 \u0645\u0627\u0646\u0646\u062f Sound Physics Remastered \u0631\u0627\u06cc\u062c \u0627\u0633\u062a. \u0628\u0631\u0627\u06cc \u0631\u0627\u0647\u0646\u0645\u0627\u06cc\u06cc \u0628\u06cc\u0634\u062a\u0631 \u0628\u0647 \u0627\u06cc\u0646 \u0631\u0627\u0647\u0646\u0645\u0627 \u0645\u0631\u0627\u062c\u0639\u0647 \u06a9\u0646\u06cc\u062f: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>\u0686\u06af\u0648\u0646\u0647 \u0645\u0634\u06a9\u0644\u0627\u062a \u0635\u062f\u0627 \u062f\u0631 \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u0631\u0648\u06cc \u0644\u06cc\u0646\u0648\u06a9\u0633 \u0631\u0627 \u0631\u0641\u0639 \u06a9\u0646\u06cc\u0645</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0633\u0631\u0648\u0631 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0634\u0648\u062f \u0632\u06cc\u0631\u0627 \u06cc\u06a9 \u0641\u0627\u06cc\u0644 \u062f\u0646\u06cc\u0627 \u062a\u0648\u0633\u0637 \u0641\u0631\u0622\u06cc\u0646\u062f \u062f\u06cc\u06af\u0631\u06cc \u0642\u0641\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a.<br>\u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647:<br>\u2022 \u0642\u0628\u0644\u0627\u064b \u06cc\u06a9 \u0646\u0645\u0648\u0646\u0647 \u0633\u0631\u0648\u0631 \u062f\u0631 \u062d\u0627\u0644 \u0627\u062c\u0631\u0627 \u0628\u0627\u0634\u062f.<br>\u2022 \u0622\u0646\u062a\u06cc\u200c\u0648\u06cc\u0631\u0648\u0633 \u06cc\u0627 \u0645\u0631\u0648\u0631\u06af\u0631 \u0641\u0627\u06cc\u0644\u060c \u067e\u0648\u0634\u0647 \u062f\u0646\u06cc\u0627 \u0631\u0627 \u0628\u0627\u0632 \u06a9\u0631\u062f\u0647 \u0628\u0627\u0634\u062f.<br>\u2022 \u0641\u0631\u0622\u06cc\u0646\u062f \u0642\u0628\u0644\u06cc \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0628\u0633\u062a\u0647 \u0646\u0634\u062f\u0647 \u0648 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0642\u0641\u0644 \u0645\u0627\u0646\u062f\u0647\u200c\u0627\u0646\u062f.</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>\u062a\u0645\u0627\u0645 \u0646\u0645\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0633\u0631\u0648\u0631 \u0631\u0627 \u0628\u0628\u0646\u062f\u06cc\u062f</b> (\u0634\u0627\u0645\u0644 \u0641\u0631\u0622\u06cc\u0646\u062f\u0647\u0627\u06cc \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647 \u0645\u062b\u0644 javaw.exe).<br>\u2022 \u0627\u06af\u0631 \u0627\u0632 \u067e\u0646\u0644 \u0647\u0627\u0633\u062a\u06cc\u0646\u06af (\u0645\u062b\u0644 Multicraft) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0627\u0632 \u0637\u0631\u06cc\u0642 \u067e\u0646\u0644 \u0633\u0631\u0648\u0631 \u0631\u0627 \u06a9\u0627\u0645\u0644\u0627\u064b \u0631\u06cc\u0633\u062a\u0627\u0631\u062a \u06a9\u0646\u06cc\u062f.<br>\u2022 <b>\u0645\u0648\u0642\u062a\u0627\u064b \u0622\u0646\u062a\u06cc\u200c\u0648\u06cc\u0631\u0648\u0633 \u062e\u0648\u062f \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f</b> \u0627\u06af\u0631 \u0641\u06a9\u0631 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0631\u0627 \u0645\u0633\u062f\u0648\u062f \u06a9\u0631\u062f\u0647 \u0627\u0633\u062a.<br>\u2022 \u062f\u0631 \u0633\u06cc\u0633\u062a\u0645\u200c\u0647\u0627\u06cc \u0645\u062d\u0644\u06cc\u060c \u062a\u0645\u0627\u0645 \u067e\u0646\u062c\u0631\u0647\u200c\u0647\u0627\u06cc \u0627\u06a9\u0633\u067e\u0644\u0648\u0631\u0631 \u0648\u06cc\u0646\u062f\u0648\u0632 \u06a9\u0647 \u067e\u0648\u0634\u0647 \u062f\u0646\u06cc\u0627 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0631\u0627 \u0628\u0628\u0646\u062f\u06cc\u062f.<br>\u2022 \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0642\u06cc \u0645\u0627\u0646\u062f\u060c \u0641\u0627\u06cc\u0644 <code>session.lock</code> \u0631\u0627 \u062f\u0631\u0648\u0646 \u067e\u0648\u0634\u0647 \u062f\u0646\u06cc\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f (\u0641\u0642\u0637 \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u06a9\u0647 \u0645\u0637\u0645\u0626\u0646 \u0628\u0627\u0634\u06cc\u062f \u0633\u0631\u0648\u0631 \u062f\u06cc\u06af\u0631\u06cc \u0641\u0639\u0627\u0644 \u0646\u06cc\u0633\u062a).";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "\u0641\u0627\u06cc\u0644 \u062f\u0646\u06cc\u0627 \u062a\u0648\u0633\u0637 \u0641\u0631\u0622\u06cc\u0646\u062f \u062f\u06cc\u06af\u0631\u06cc \u0642\u0641\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0645\u0648\u062f \u0633\u0639\u06cc \u06a9\u0631\u062f \u06a9\u0644\u0627\u0633 <code>" + clasePadreFinal + "</code> \u0631\u0627 \u06af\u0633\u062a\u0631\u0634 \u062f\u0647\u062f\u060c \u0627\u0645\u0627 \u0627\u06cc\u0646 \u06a9\u0644\u0627\u0633 \u0627\u06a9\u0646\u0648\u0646 <b>\u0646\u0647\u0627\u06cc\u06cc</b> \u0627\u0633\u062a \u0648 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0628\u0647 \u0627\u0631\u062b \u0628\u0631\u062f\u0647 \u0634\u0648\u062f.<br>\u06a9\u0644\u0627\u0633 \u0645\u0634\u06a9\u0644\u200c\u0633\u0627\u0632: <code>" + claseHija + "</code>.<br><br>\u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647 \u06cc\u06a9 \u0645\u0648\u062f \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647 \u0642\u0628\u0644\u06cc \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u06cc\u0627 \u06cc\u06a9 \u0645\u0648\u062f \u067e\u0627\u06cc\u0647 \u062f\u06cc\u06af\u0631 \u06a9\u0627\u0645\u067e\u0627\u06cc\u0644 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f\u060c \u06a9\u0647 \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0627\u062e\u06cc\u0631 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627 \u0631\u0627 \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 <code>final</code> \u0639\u0644\u0627\u0645\u062a\u200c\u06af\u0630\u0627\u0631\u06cc \u06a9\u0631\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>\u062a\u0645\u0627\u0645 \u0645\u0648\u062f\u0647\u0627\u06cc \u062f\u0631\u06af\u06cc\u0631 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f</b>\u060c \u0628\u0647 \u062e\u0635\u0648\u0635 \u0622\u0646\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u0645\u0648\u062f \u067e\u0627\u06cc\u0647 \u0630\u06a9\u0631 \u0634\u062f\u0647 \u0645\u0631\u0628\u0648\u0637 \u0628\u0627\u0634\u0646\u062f.<br>\u2022 \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0642\u06cc \u0645\u0627\u0646\u062f\u060c \u0628\u0647 \u062f\u0646\u0628\u0627\u0644 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0627\u0632 \u0645\u0648\u062f \u0628\u06af\u0631\u062f\u06cc\u062f \u06a9\u0647 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u0648 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc\u0634 \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627\u0634\u062f.<br>\u2022 \u062f\u0631 \u0628\u0631\u062e\u06cc \u0645\u0648\u0627\u0631\u062f\u060c \u062d\u0630\u0641 \u0645\u0648\u0642\u062a \u0645\u0648\u062f\u06cc \u06a9\u0647 \u0634\u0627\u0645\u0644 \u06a9\u0644\u0627\u0633 \u0641\u0631\u0632\u0646\u062f \u0627\u0633\u062a \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0639\u0644\u062a \u0631\u0627 \u062a\u0623\u06cc\u06cc\u062f \u06a9\u0646\u062f.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "\u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0627\u0631\u062b\u200c\u0628\u0631\u06cc \u0627\u0632 \u06cc\u06a9 \u06a9\u0644\u0627\u0633 \u0646\u0647\u0627\u06cc\u06cc";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0634\u0645\u0627 \u0627\u0632 <b>Rubidium</b> (\u06cc\u06a9 \u0646\u0633\u062e\u0647 \u0642\u062f\u06cc\u0645\u06cc \u0634\u062f\u0647 \u0627\u0632 Sodium \u0628\u0631\u0627\u06cc Forge) \u0647\u0645\u0631\u0627\u0647 \u0628\u0627 <b>Iris \u06cc\u0627 Oculus</b> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.<br>\u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0627\u062e\u06cc\u0631 \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a (1.19.2 \u0628\u0647 \u0628\u0639\u062f)\u060c Rubidium \u062f\u06cc\u06af\u0631 \u0628\u0627 Sodium \u0647\u0645\u0627\u0647\u0646\u06af \u0646\u06cc\u0633\u062a \u0648 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u0622\u0646 \u0645\u0634\u06a9\u0644\u0627\u062a\u06cc \u062f\u0627\u0634\u062a\u0647\u200c\u0627\u0646\u062f.<br><br>\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0647\u0645\u0686\u0646\u06cc\u0646 \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u062a\u062f\u0627\u062e\u0644\u06cc \u0628\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627\u06cc \u0639\u0645\u0644\u06a9\u0631\u062f\u06cc (Sodium\u060c Rubidium\u060c Embeddium\u060c Bedium\u060c Xeonium \u0648 \u063a\u06cc\u0631\u0647) \u06cc\u0627 Iris Shaders \u0648 \u06cc\u06a9 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631 \u0648\u062c\u0648\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f.</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <b>Rubidium \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647 <code>mods</code> \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f</b>.<br>\u2022 <b><a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f</b>\u060c \u0627\u06cc\u0646 \u0646\u0633\u062e\u0647 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u0641\u0639\u0627\u0644 \u0648 \u0633\u0627\u0632\u06af\u0627\u0631 Sodium \u0628\u0631\u0627\u06cc Forge \u0627\u0633\u062a \u06a9\u0647 \u062f\u0631 1.20+ \u0627\u0632 Iris/Oculus \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f.<br>\u2022 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0628\u06cc\u0634 \u0627\u0632 \u06cc\u06a9 \u0646\u0633\u062e\u0647 \u0627\u0632 Sodium \u0631\u0627 \u0647\u0645\u0632\u0645\u0627\u0646 \u0646\u0635\u0628 \u0646\u06a9\u0631\u062f\u0647 \u0628\u0627\u0634\u06cc\u062f (\u0645\u062b\u0644\u0627\u064b Rubidium + Embeddium).<br>\u2022 \u0627\u06af\u0631 \u0628\u0647 \u062c\u0627\u06cc Iris \u0627\u0632 Oculus \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u0628\u0627 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc Forge \u0648 Embeddium \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a.";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "Rubidium \u0645\u0646\u0633\u0648\u062e \u0628\u0627 Iris/Oculus (OptionInstance \u0646\u0647\u0627\u06cc\u06cc \u0627\u0633\u062a)";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0645\u0648\u062f <code>Simple Voice Chat</code> \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0633\u0631\u0648\u0631 \u0635\u062f\u0627 \u062e\u0648\u062f \u0631\u0627 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u062f \u0632\u06cc\u0631\u0627 \u067e\u0648\u0631\u062a UDP \u0642\u0628\u0644\u0627\u064b \u062f\u0631 \u062d\u0627\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0633\u062a \u06cc\u0627 \u0622\u062f\u0631\u0633 IP \u062a\u0646\u0638\u06cc\u0645 \u0634\u062f\u0647 \u0645\u0639\u062a\u0628\u0631 \u0646\u06cc\u0633\u062a.<br>\u0627\u06cc\u0646 \u0645\u0648\u0636\u0648\u0639 \u0628\u0627\u0639\u062b \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u0646\u0645\u06cc\u200c\u0634\u0648\u062f\u060c \u0627\u0645\u0627 \u0639\u0645\u0644\u06a9\u0631\u062f \u0686\u062a \u0635\u0648\u062a\u06cc \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u0645\u06cc\u200c\u06a9\u0646\u062f.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>\u0647\u0631 \u0646\u0645\u0648\u0646\u0647 \u062f\u06cc\u06af\u0631\u06cc \u0627\u0632 \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u06cc\u0627 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0627\u06cc \u06a9\u0647 \u0627\u0632 \u067e\u0648\u0631\u062a UDP 24454 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f \u0631\u0627 \u0628\u0628\u0646\u062f\u06cc\u062f</b>.<br>\u2022 \u0627\u06af\u0631 \u0631\u0648\u06cc \u06cc\u06a9 \u0633\u0631\u0648\u0631 \u0647\u0633\u062a\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f <b>\u0647\u06cc\u0686 \u0633\u0631\u0648\u06cc\u0633 \u062f\u06cc\u06af\u0631\u06cc</b> \u0627\u0632 \u0622\u0646 \u067e\u0648\u0631\u062a \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0646\u0645\u06cc\u200c\u06a9\u0646\u062f.<br>\u2022 \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0645\u0648\u062f (<code>config/voicechat/</code>)\u060c \u067e\u0648\u0631\u062a UDP \u0631\u0627 \u0628\u0647 \u06cc\u06a9 \u067e\u0648\u0631\u062a \u0622\u0632\u0627\u062f \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f (\u0645\u062b\u0644\u0627\u064b 24455).<br>\u2022 \u0627\u06af\u0631 \u0627\u0632 \u06cc\u06a9 \u0622\u062f\u0631\u0633 IP \u0634\u062e\u0635\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0635\u062d\u062a \u0622\u0646 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0645\u0642\u062f\u0627\u0631 \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 \u0622\u0646 \u0631\u0627 \u062e\u0627\u0644\u06cc \u0628\u06af\u0630\u0627\u0631\u06cc\u062f.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "\u0686\u062a \u0635\u0648\u062a\u06cc: \u067e\u0648\u0631\u062a UDP \u0627\u0634\u063a\u0627\u0644 \u0634\u062f\u0647 \u06cc\u0627 IP \u0646\u0627\u0645\u0639\u062a\u0628\u0631";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>BlockItem <code>" + nombreBlockItem + "</code> \u062f\u0627\u0631\u0627\u06cc \u0628\u0644\u0648\u06a9 \u062a\u0647\u06cc \u0627\u0633\u062a.<br>\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u062f\u0631 <b>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc Create</b> (\u0645\u0627\u0646\u0646\u062f <code>dndecor</code>, <code>createdeco</code>) \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u0648\u0642\u062a\u06cc \u062a\u062f\u0627\u062e\u0644\u06cc \u0628\u0627 <code>Amendments</code>, <code>Moonshine</code> \u0648\u062c\u0648\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f \u06cc\u0627 \u0645\u0642\u062f\u0627\u0631\u062f\u0647\u06cc \u0627\u0648\u0644\u06cc\u0647 \u0628\u0644\u0648\u06a9\u200c\u0647\u0627 \u0627\u0634\u062a\u0628\u0627\u0647 \u0628\u0627\u0634\u062f.<br><b>\u062a\u0648\u062c\u0647:</b> \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0633\u062a\u0642\u06cc\u0645\u0627\u064b \u0627\u0632 Amendments \u0646\u06cc\u0633\u062a\u060c \u0628\u0644\u06a9\u0647 \u0645\u0634\u06a9\u0644 \u0639\u0645\u06cc\u0642\u200c\u062a\u0631\u06cc \u062f\u0631 \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u062b\u0628\u062a\u200c\u0647\u0627\u0633\u062a.</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>\u062a\u0645\u0627\u0645 \u0645\u0648\u062f\u0647\u0627\u06cc \u0645\u0631\u062a\u0628\u0637 \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f:</b> Create\u060c Amendments\u060c Moonshine \u0648 \u0647\u0631 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0627\u06cc (\u0628\u0647 \u062e\u0635\u0648\u0635 <code>dndecor</code> \u0648 <code>createdeco</code>).<br>\u2022 \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0642\u06cc \u0645\u0627\u0646\u062f\u060c <b>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc Create \u0631\u0627 \u0645\u0648\u0642\u062a\u0627\u064b \u06cc\u06a9\u06cc \u06cc\u06a9\u06cc \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f</b> \u062a\u0627 \u0639\u0627\u0645\u0644 \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f.<br>\u2022 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f <b>Amendments \u0648 Moonshine \u0628\u0627 \u0646\u0633\u062e\u0647 Create \u0648 Forge \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627\u0634\u0646\u062f</b>.<br>\u2022 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u0622\u06cc\u0627 \u0646\u0633\u062e\u0647 \u0628\u062a\u0627 \u06cc\u0627 \u0641\u0648\u0631\u06a9\u200c\u0647\u0627\u06cc \u0628\u0647\u200c\u0631\u0648\u0632 \u0634\u062f\u0647\u200c\u0627\u06cc \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "BlockItem \u062a\u0647\u06cc \u062f\u0631 \u0627\u0641\u0632\u0648\u0646\u0647 Create";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("\u0645\u062f/\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u0647\u06cc\u0686 \u067e\u0644\u062a\u0641\u0631\u0645 \u0641\u0639\u0627\u0644\u06cc (\u0645\u062b\u0644 Forge\u060c Fabric \u0648 \u063a\u06cc\u0631\u0647) \u062a\u0639\u0644\u0642 \u0646\u062f\u0627\u0631\u0646\u062f \u067e\u06cc\u062f\u0627 \u0634\u062f\u0646\u062f:<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>\u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0632\u0645\u0627\u0646\u06cc \u0627\u062a\u0641\u0627\u0642 \u0645\u06cc\u200c\u0627\u0641\u062a\u062f \u06a9\u0647:<br>").append("\u2022 \u0645\u062f/\u0647\u0627\u06cc <b>Fabric \u0648 Forge</b> \u062f\u0631 \u06cc\u06a9 \u067e\u0648\u0634\u0647 \u0628\u0627 \u0647\u0645 \u0645\u062e\u0644\u0648\u0637 \u0634\u062f\u0647 \u0628\u0627\u0634\u0646\u062f.<br>").append("\u2022 \u0645\u062f \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0632 \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u0646\u0635\u0628 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f.<br>").append("\u2022 \u0645\u062f \u062e\u0631\u0627\u0628 \u0628\u0627\u0634\u062f \u06cc\u0627 \u06cc\u06a9 \u0641\u0627\u06cc\u0644 JAR \u0645\u0639\u062a\u0628\u0631 \u0646\u0628\u0627\u0634\u062f.</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>\u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u062d\u0627\u0635\u0644 \u06a9\u0646\u06cc\u062f \u0647\u0645\u0647 \u0645\u062f/\u0647\u0627 \u0628\u0631\u0627\u06cc \u06cc\u06a9 \u067e\u0644\u062a\u0641\u0631\u0645 \u0647\u0633\u062a\u0646\u062f</b> (Forge <b>\u06cc\u0627</b> Fabric\u060c \u0646\u0647 \u0647\u0631 \u062f\u0648).<br>\u2022 \u0627\u0632 <b>\u062f\u0631\u062e\u062a \u0645\u062f/\u0647\u0627</b> \u0628\u0631\u0627\u06cc \u062a\u0634\u062e\u06cc\u0635 \u067e\u0644\u062a\u0641\u0631\u0645 \u0647\u0631 \u0641\u0627\u06cc\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.<br>\u2022 \u0647\u0631 \u0645\u062f\u06cc \u06a9\u0647 \u0646\u0645\u06cc\u200c\u0634\u0646\u0627\u0633\u06cc\u062f \u06cc\u0627 \u0628\u0631\u0627\u06cc \u067e\u0644\u062a\u0641\u0631\u0645 \u062f\u06cc\u06af\u0631\u06cc \u0627\u0633\u062a \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.<br>\u2022 \u0627\u06af\u0631 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0645\u062b\u0644 CurseForge \u06cc\u0627 Prism \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u067e\u0631\u0648\u0641\u0627\u06cc\u0644 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u062a\u0646\u0638\u06cc\u0645 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f.";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "\u0645\u062f \u0628\u0627 \u0628\u0627\u0631\u06af\u06cc\u0631\u0646\u062f\u0647 \u0641\u0639\u0627\u0644 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0627\u06cc\u062c\u0627\u062f \u0645\u062f\u0644 <code>" + modid + ":" + nombreModelo + "</code> \u0646\u0627\u0645\u0648\u0641\u0642 \u0628\u0648\u062f.<br>\u0627\u06cc\u0646 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0645\u0648\u062f <code>" + modid + "</code> \u062f\u0627\u0631\u0627\u06cc \u0645\u0646\u0627\u0628\u0639 \u062e\u0631\u0627\u0628\u060c \u06af\u0645 \u0634\u062f\u0647\u060c \u06cc\u0627 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u0634\u0645\u0627\u0633\u062a.</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>\u0645\u0648\u062f \u0631\u0627 \u0628\u0647 \u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0645\u0648\u0646\u0647 \u062e\u0648\u062f \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f</b>.<br>\u2022 \u0627\u06af\u0631 \u0627\u0632 \u0646\u0633\u062e\u0647 \u062a\u0648\u0633\u0639\u0647 \u06cc\u0627 \u0633\u0641\u0627\u0631\u0634\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0646\u0633\u062e\u0647 \u0631\u0633\u0645\u06cc \u0628\u0631\u06af\u0631\u062f\u06cc\u062f.<br>\u2022 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0641\u0627\u06cc\u0644 JAR \u062e\u0631\u0627\u0628 \u0646\u06cc\u0633\u062a (\u062f\u0648\u0628\u0627\u0631\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f).<br>\u2022 \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0642\u06cc \u0645\u0627\u0646\u062f\u060c \u062e\u0637\u0627\u06cc \u0631\u0627 \u0647\u0645\u0631\u0627\u0647 \u0628\u0627 \u0627\u06cc\u0646 \u0644\u0627\u06af \u0628\u0647 \u0646\u0648\u06cc\u0633\u0646\u062f\u0647 \u0645\u0648\u062f \u06af\u0632\u0627\u0631\u0634 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0627\u06cc\u062c\u0627\u062f \u0645\u062f\u0644 \u0645\u0646\u0628\u0639";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627\u06cc <code>Moonlight</code> \u0648 <code>Iceberg</code> \u062a\u0634\u062e\u06cc\u0635 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a.<br>\u0647\u0631 \u062f\u0648 \u0633\u0639\u06cc \u062f\u0631 \u062b\u0628\u062a \u0633\u06cc\u0633\u062a\u0645\u200c\u0647\u0627\u06cc \u0628\u0627\u0632\u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u0645\u0646\u0627\u0628\u0639 \u0628\u0647 \u0634\u06a9\u0644 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u062f\u0627\u0631\u0646\u062f\u060c \u06a9\u0647 \u0628\u0627\u0639\u062b \u062e\u0631\u0627\u0628\u06cc OpenGL \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u06cc\u06a9 \u06a9\u0627\u0646\u062a\u06a9\u0633\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9\u06cc \u0645\u0639\u062a\u0628\u0631 \u0645\u06cc\u200c\u0634\u0648\u062f.<br>\u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0632\u0645\u0627\u0646\u06cc \u0631\u0627\u06cc\u062c \u0627\u0633\u062a \u06a9\u0647 \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc Forge \u06a9\u0647 \u0634\u0627\u0645\u0644 \u0622\u062f\u0627\u067e\u062a\u0648\u0631\u0647\u0627\u06cc \u0645\u0648\u062f Fabric \u0647\u0633\u062a\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>\u0647\u0631 \u062f\u0648 \u0645\u0648\u062f \u0631\u0627 \u0628\u0647 \u062c\u062f\u06cc\u062f\u062a\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647 Forge \u062e\u0648\u062f \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f</b>.<br>\u2022 \u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0642\u06cc \u0645\u0627\u0646\u062f\u060c <b>\u0628\u0647 \u0637\u0648\u0631 \u0645\u0648\u0642\u062a Iceberg \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f</b>\u060c \u0632\u06cc\u0631\u0627 Moonlight \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u06cc\u06a9 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc \u0645\u0647\u0645\u200c\u062a\u0631 \u0628\u0631\u0627\u06cc \u0645\u0648\u062f\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 \u0627\u0633\u062a.<br>\u2022 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062a\u06a9\u0631\u0627\u0631\u06cc \u06cc\u0627 \u062a\u0631\u06a9\u06cc\u0628\u06cc Forge/Fabric \u0627\u0632 \u0627\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627 \u0646\u062f\u0627\u0631\u06cc\u062f.<br>\u2022 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u0622\u06cc\u0627 \u0645\u0648\u062f \u062f\u06cc\u06af\u0631\u06cc (\u0645\u062b\u0644 Supplementaries\u060c Citadel \u0648 \u063a\u06cc\u0631\u0647) \u0642\u0628\u0644\u0627\u064b \u0639\u0645\u0644\u06a9\u0631\u062f Iceberg \u0631\u0627 \u062f\u0627\u062e\u0644\u06cc \u062f\u0627\u0631\u062f.";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc: Moonlight \u062f\u0631 \u0645\u0642\u0627\u0628\u0644 Iceberg (OpenGL \u0628\u062f\u0648\u0646 \u06a9\u0627\u0646\u062a\u06a9\u0633\u062a)";
    }

    @Override
    public String instantanea() {
        return "\u062a\u0635\u0648\u06cc\u0631 \u0644\u062d\u0638\u0647\u200c\u0627\u06cc";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "\u0627\u0632 \u0622\u062e\u0631\u06cc\u0646 \u062a\u0635\u0648\u06cc\u0631 \u0644\u062d\u0638\u0647\u200c\u0627\u06cc";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "\u06cc\u06a9 \u0641\u0627\u06cc\u0644 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "\u062a\u0635\u0648\u06cc\u0631 \u0644\u062d\u0638\u0647\u200c\u0627\u06cc \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0627\u06cc\u062c\u0627\u062f \u0634\u062f";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0627\u06cc\u062c\u0627\u062f \u062a\u0635\u0648\u06cc\u0631 \u0644\u062d\u0638\u0647\u200c\u0627\u06cc";
    }

    @Override
    public String consejo() {
        return "\u0646\u06a9\u062a\u0647";
    }

    @Override
    public String resultadoMuestra() {
        return "\u0646\u0645\u0627\u06cc\u0634 \u0646\u062a\u06cc\u062c\u0647";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>\u0646\u06a9\u062a\u0647:</b> \u062f\u0648 \u0641\u0627\u06cc\u0644 \u062a\u0627\u0631\u06cc\u062e\u0686\u0647 \u0631\u0627 \u0628\u0631\u0627\u06cc \u0645\u0642\u0627\u06cc\u0633\u0647 \u0644\u06cc\u0633\u062a \u0645\u0648\u062f\u0647\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.   \u0646\u062a\u06cc\u062c\u0647 <span style='color:%s;'>\u0627\u0641\u0632\u0648\u062f\u0647 \u0634\u062f\u0647\u200c\u0647\u0627 (+)</span> \u0648   <span style='color:%s;'>\u062d\u0630\u0641 \u0634\u062f\u0647\u200c\u0647\u0627 (&#8722;)</span> \u0631\u0627 \u0628\u0631 \u0627\u0633\u0627\u0633 \u0646\u0627\u0645\u200c\u0647\u0627\u06cc \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0634\u062f\u0647 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f.   \u0627\u0632 \u062f\u06a9\u0645\u0647 \u00ab\u062a\u0635\u0648\u06cc\u0631 \u0644\u062d\u0638\u0647\u200c\u0627\u06cc\u00bb \u0628\u0631\u0627\u06cc \u0627\u06cc\u062c\u0627\u062f \u06a9\u067e\u06cc \u0627\u0632 \u06cc\u06a9 \u0641\u0627\u06cc\u0644 \u0645\u0648\u062c\u0648\u062f \u0628\u0627 \u067e\u0633\u0648\u0646\u062f .instantanea \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "\u062f\u0631\u06cc\u0627\u0641\u062a \u067e\u06cc\u0648\u0646\u062f\u0647\u0627\u06cc \u0633\u06cc\u0627\u0647\u0647 \u0628\u0647 \u0635\u0648\u0631\u062a \u0645\u0627\u0631\u06a9\u200c\u062f\u0627\u0648\u0646 \u0628\u062f\u0648\u0646 \u06af\u0632\u0627\u0631\u0634";
    }

    @Override
    public String titulo_configuracion() {
        return "\u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc";
    }

    @Override
    public String columna_url() {
        return "\u0622\u062f\u0631\u0633 URL";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "\u062e\u0637\u0627\u06cc \u063a\u06cc\u0631\u0645\u0646\u062a\u0638\u0631\u0647\u200c\u0627\u06cc \u0647\u0646\u06af\u0627\u0645 \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u0631\u062e \u062f\u0627\u062f.";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "\u062e\u0637\u0627\u06cc \u063a\u06cc\u0631\u0645\u0646\u062a\u0638\u0631\u0647\u200c\u0627\u06cc \u0647\u0646\u06af\u0627\u0645 \u062a\u0648\u0644\u06cc\u062f \u067e\u06cc\u0648\u0646\u062f\u0647\u0627 \u0631\u062e \u062f\u0627\u062f.";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "\u062e\u0637\u0627\u06cc \u063a\u06cc\u0631\u0645\u0646\u062a\u0638\u0631\u0647\u200c\u0627\u06cc \u0647\u0646\u06af\u0627\u0645 \u067e\u0631\u062f\u0627\u0632\u0634 \u062f\u06a9\u0645\u0647 \u0631\u062e \u062f\u0627\u062f.";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "\u0641\u0627\u06cc\u0644\u06cc \u0628\u0631\u0627\u06cc \u0628\u0627\u0632 \u06a9\u0631\u062f\u0646 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "\u0641\u0627\u06cc\u0644 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f:\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "\u062f\u0631 \u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631 \u0628\u0627\u0632 \u0646\u0634\u062f.\n\u0645\u0633\u06cc\u0631 \u0628\u0647 \u062d\u0627\u0641\u0638\u0647 \u0645\u0648\u0642\u062a \u06a9\u067e\u06cc \u062e\u0648\u0627\u0647\u062f \u0634\u062f.";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "\u0639\u062f\u0645 \u062a\u0648\u0627\u0646\u0627\u06cc\u06cc \u062f\u0631 \u0628\u0627\u0632 \u06a9\u0631\u062f\u0646 \u0641\u0627\u06cc\u0644\u061b \u0645\u0633\u06cc\u0631 \u0628\u0647 \u062d\u0627\u0641\u0638\u0647 \u0645\u0648\u0642\u062a \u06a9\u067e\u06cc \u0634\u062f.";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "\u062f\u0633\u06a9\u062a\u0627\u067e \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0646\u0645\u06cc\u200c\u0634\u0648\u062f\u061b \u0645\u0633\u06cc\u0631 \u0628\u0647 \u062d\u0627\u0641\u0638\u0647 \u0645\u0648\u0642\u062a \u06a9\u067e\u06cc \u0634\u062f.";
    }

    @Override
    public String limite_de_solicitudes() {
        return "\u0628\u0647 \u0645\u062d\u062f\u0648\u062f\u06cc\u062a \u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0631\u0633\u06cc\u062f\u0647\u200c\u0627\u06cc\u062f. \u0633\u0639\u06cc \u06a9\u0646\u06cc\u062f \u0627\u0632 \u06cc\u06a9 \u0633\u0627\u06cc\u062a \u062b\u0628\u062a \u0644\u0627\u06af \u062f\u06cc\u06af\u0631 \u06cc\u0627 \u06cc\u06a9 API \u062b\u0628\u062a \u0644\u0627\u06af \u062f\u06cc\u06af\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "\u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u067e\u06cc\u0648\u0646\u062f";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0631\u0641\u0639 \u0645\u0634\u06a9\u0644 \u0628\u0627\u0644\u0627\u06cc \u062a\u0646\u0647\u200c\u0647\u0627 \u0627\u0648\u0644\u0648\u06cc\u062a \u0627\u0648\u0644 \u0627\u0633\u062a. \u0641\u0631\u0645\u062a \u0628\u0647 \u0635\u0648\u0631\u062a \u0633\u0637\u062d\u060c \u062e\u0637 \u0627\u0633\u062a. \u0647\u0645\u0647 \u0633\u06cc\u0627\u0647\u0647\u200c\u0647\u0627 \u06cc\u06a9 \u0633\u06cc\u0633\u062a\u0645 \u0634\u0645\u0627\u0631\u0647\u200c\u06af\u0630\u0627\u0631\u06cc \u062f\u0627\u0631\u0646\u062f. " + "<br>" + "\u0628\u0647 \u0637\u0648\u0631 \u06a9\u0644\u06cc \u0628\u0627\u06cc\u062f \u062f\u0631 \u0647\u0645\u0647 \u0633\u06cc\u0627\u0647\u0647\u200c\u0647\u0627 \u0628\u0647 \u062f\u0646\u0628\u0627\u0644 \u067e\u0627\u06cc\u06cc\u0646\u200c\u062a\u0631\u06cc\u0646 \u0633\u0637\u0648\u062d \u0628\u0627\u0634\u06cc\u062f\u061b \u0631\u062f\u067e\u0627\u0647\u0627 \u0628\u0627 \u0633\u0637\u0648\u062d \u0628\u0627\u0644\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0645\u062b\u0628\u062a \u06a9\u0627\u0630\u0628 \u0647\u0633\u062a\u0646\u062f. \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u062a\u0648\u0627\u0646\u0627\u06cc\u06cc \u062e\u0648\u062f \u0628\u0631\u0627\u06cc \u0645\u0634\u0627\u0647\u062f\u0647 \u06a9\u0646\u0633\u0648\u0644 \u0645\u0647\u0645 \u0627\u0633\u062a\u060c \u0632\u06cc\u0631\u0627 \u062a\u062d\u0644\u06cc\u0644 \u0631\u062f\u067e\u0627\u0647\u0627 \u0648\u0642\u062a\u06cc \u062a\u0639\u062f\u0627\u062f \u0632\u06cc\u0627\u062f\u06cc \u0631\u062f\u067e\u0627 \u0648\u062c\u0648\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f \u06a9\u0627\u0645\u0644 \u0646\u06cc\u0633\u062a.</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "\u062c\u0633\u062a\u062c\u0648\u06af\u0631 \u06a9\u0627\u0646\u0627\u0631\u06cc \u062f\u0633\u062a\u0648\u0631";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "\u0627\u06cc\u0646 \u0642\u0627\u0628\u0644\u06cc\u062a \u0628\u0647 \u0632\u0648\u062f\u06cc \u062f\u0631 \u062f\u0633\u062a\u0631\u0633 \u062e\u0648\u0627\u0647\u062f \u0628\u0648\u062f.";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "\u0628\u0647 \u0632\u0648\u062f\u06cc";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "\u0645\u0648\u062f\u0647\u0627\u06cc \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 Crash Assistant (\u063a\u0644\u0637)";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "\u0645\u0648\u062f \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0645\u0648\u062f\u067e\u06a9 \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 CrashAssistant";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant \u0644\u06cc\u0633\u062a\u06cc \u0627\u0632 \u0645\u0648\u062f\u0647\u0627\u06cc\u06cc \u062f\u0627\u0631\u062f \u06a9\u0647 \u0645\u06cc\u200c\u06af\u0648\u06cc\u062f \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0647\u0633\u062a\u0646\u062f\u060c \u0627\u0645\u0627 \u0645\u0627 \u0634\u0648\u0627\u0647\u062f\u06cc \u0646\u062f\u0627\u0631\u06cc\u0645 \u0648 \u062e\u0637\u0627\u06cc \u0622\u0646 \u0641\u0642\u0637 \u0628\u0647 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0627\u0633\u062a. \u0627\u06af\u0631 \u0645\u06cc\u200c\u062e\u0648\u0627\u0647\u06cc\u062f \u0628\u0627 \u0627\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627 \u0628\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0641\u0627\u06cc\u0644 <code>config/crash_assistant/config.toml</code> \u0631\u0627 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0631\u062f\u0647 \u0648 <code>enabled = true</code> \u062f\u0631 \u0628\u062e\u0634 [compatibility] \u0631\u0627 \u0628\u0647 <code>enabled = false</code> \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant \u062a\u0648\u0627\u0646\u0627\u06cc\u06cc \u06af\u0641\u062a\u0646 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0645\u0648\u062f\u0647\u0627 \u0631\u0627 \u062f\u0627\u0631\u062f\u060c \u0627\u0645\u0627 \u06af\u0627\u0647\u06cc \u0627\u06cc\u0646 \u0645\u0648\u0636\u0648\u0639 \u0627\u0634\u062a\u0628\u0627\u0647 \u0627\u0633\u062a \u0648 \u062e\u0637\u0627\u06cc \u0622\u0646 \u0641\u0642\u0637 \u0628\u0647 \u06cc\u06a9 \u0632\u0628\u0627\u0646 \u0627\u0633\u062a. \u0627\u06af\u0631 \u0645\u06cc\u200c\u062e\u0648\u0627\u0647\u06cc\u062f \u0628\u0627 \u0627\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627 \u0628\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0641\u0627\u06cc\u0644 <code>config/crash_assistant/problematic_mods_config.json</code> \u0631\u0627 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0631\u062f\u0647 \u0648 <code>should_crash_on_startup</code> \u0631\u0627 \u0627\u0632 <code>true</code> \u0628\u0647 <code>false</code> \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627: \u0645\u0648\u062f '" + modId + "' \u0628\u0647 \u0645\u0648\u062f '" + dependencia + "' \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f. \u062f\u0631 \u062d\u0627\u0644 \u062d\u0627\u0636\u0631\u060c " + actual + " \u0627\u0633\u062a.</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627: \u0645\u0648\u062f '" + modId + "' \u0628\u0647 \u0646\u0633\u062e\u0647\u0654 '" + requerido + "' \u06cc\u0627 \u0628\u0627\u0644\u0627\u062a\u0631 \u0627\u0632 '" + dependencia + "' \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f\u060c \u0627\u0645\u0627 \u0627\u06cc\u0646 \u0645\u0648\u062f \u0646\u0635\u0628 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a.</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627: \u0645\u0648\u062f '" + modId + "' \u0628\u0627 \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc '" + dependencia + "' \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a. \u0628\u0627\u06cc\u062f \u0645\u0648\u062f 'Iris/Oculus & GeckoLib Compat' \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u0632\u06cc\u0631\u0627 \u0628\u0627 Superb Warfare \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a \u0648 \u0628\u0627 \u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 GeckoLib \u06a9\u0627\u0631 \u0646\u0645\u06cc\u200c\u06a9\u0646\u062f. \u0646\u0633\u062e\u0647 \u0641\u0639\u0644\u06cc: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "\u062e\u0637\u0627: \u0627\u062c\u0631\u0627\u06cc \u0648\u0638\u06cc\u0641\u0647 \u0628\u0631\u0627\u06cc \u06a9\u0644\u0627\u0633 '" + clase + "' \u0646\u0627\u0645\u0648\u0641\u0642 \u0628\u0648\u062f. \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0627 \u0645\u0648\u062f\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f \u06cc\u0627 \u0628\u0627 \u0633\u0627\u06cc\u0631 \u0645\u0648\u062f\u0647\u0627\u06cc \u0646\u0635\u0628 \u0634\u062f\u0647 \u062a\u062f\u0627\u062e\u0644 \u062f\u0627\u0631\u0646\u062f \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f.";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "\u0634\u06a9\u0633\u062a \u062f\u0631 \u0627\u062c\u0631\u0627\u06cc \u0648\u0638\u0627\u06cc\u0641";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "\u0627\u06cc\u0646 \u0646\u0648\u0639 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0632\u0645\u0627\u0646\u06cc \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0628\u06cc\u0646 \u0645\u0648\u062f\u0647\u0627 \u0639\u062f\u0645 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0648\u062c\u0648\u062f \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u062f. \u0628\u0647 \u062e\u0635\u0648\u0635 \u0628\u0631\u0627\u06cc \u0645\u0648\u062f\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0628\u0627 ConnectorMod \u06a9\u0627\u0631 \u0646\u0645\u06cc\u200c\u06a9\u0646\u0646\u062f\u060c \u0631\u0627\u06cc\u062c \u0627\u0633\u062a.";
    }

    @Override
    public String info_clase_problematica() {
        return "\u06a9\u0644\u0627\u0633 \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631:";
    }

    public String ver_en_log() {
        return "\u0645\u0634\u0627\u0647\u062f\u0647 \u062f\u0631 \u0633\u06cc\u0627\u0647\u0647";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "\u0647\u06cc\u0686 \u06a9\u0644\u0627\u0633 \u062e\u0627\u0635\u06cc \u0628\u0627 \u0645\u0634\u06a9\u0644\u0627\u062a \u0627\u062c\u0631\u0627\u06cc\u06cc \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f.";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 OptiFine \u0648 Entity Model Features (EMF) \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u0627\u06cc\u0646 \u062f\u0648 \u0645\u0648\u062f \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f \u0648 \u0628\u0627\u0639\u062b \u062e\u0631\u0627\u0628\u06cc \u062f\u0631\u062c (injection failure) \u0634\u062f\u0647 \u0648 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "\u062a\u0636\u0627\u062f OptiFine \u0648 Entity Model Features";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "\u06cc\u06a9\u06cc \u0627\u0632 OptiFine \u06cc\u0627 Entity Model Features \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0622\u0646\u0647\u0627 \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 OptiFine \u0648 Fusion \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u0627\u06cc\u0646 \u062f\u0648 \u0645\u0648\u062f \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f \u0648 \u0628\u0627\u0639\u062b \u062e\u0631\u0627\u0628\u06cc \u062f\u0631\u062c (injection failure) \u0634\u062f\u0647 \u0648 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "\u062a\u0636\u0627\u062f OptiFine \u0648 Fusion";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "OptiFine \u06cc\u0627 Fusion \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0622\u0646\u0647\u0627 \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Flywheel (\u06a9\u0647 \u062a\u0648\u0633\u0637 Create \u0646\u06cc\u0627\u0632 \u0627\u0633\u062a) \u0628\u0647 Sodium 0.6.0-beta.2 \u06cc\u0627 \u0628\u0627\u0644\u0627\u062a\u0631 \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f. Rubidium \u0646\u0633\u062e\u0647 0.5.3 \u0627\u0633\u062a. \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u0631\u0627 \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u062f\u0631 \u0646\u0638\u0631 \u0628\u06af\u06cc\u0631\u06cc\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "\u062a\u0636\u0627\u062f Flywheel \u0648 \u0646\u0633\u062e\u0647 Sodium";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "Sodium \u0631\u0627 \u0628\u0647 \u0646\u0633\u062e\u0647 0.6.0-beta.2 \u06cc\u0627 \u0628\u0627\u0644\u0627\u062a\u0631 \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f\u060c \u06cc\u0627 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u0631\u0627 \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 OptiFine \u0648 Epic Fight \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u0627\u06cc\u0646 \u062f\u0648 \u0645\u0648\u062f \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f \u0648 \u0628\u0627\u0639\u062b \u062e\u0631\u0627\u0628\u06cc \u062f\u0631\u062c (injection failure) \u0634\u062f\u0647 \u0648 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "\u062a\u0636\u0627\u062f OptiFine \u0648 Epic Fight";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "OptiFine \u06cc\u0627 Epic Fight \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0622\u0646\u0647\u0627 \u0628\u0627 \u0647\u0645 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 OptiFine \u0648 Rubidium \u062a\u0634\u062e\u06cc\u0635 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0647\u0633\u062a\u0646\u062f \u0648 \u0628\u0627\u0639\u062b \u0634\u06a9\u0633\u062a \u062a\u0632\u0631\u06cc\u0642 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f \u06a9\u0647 \u062c\u0644\u0648\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u0631\u0627 \u0645\u06cc\u200c\u06af\u06cc\u0631\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "\u062a\u0636\u0627\u062f OptiFine \u0648 Rubidium";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "OptiFine \u06cc\u0627 Rubidium \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0628\u0627 \u06cc\u06a9\u062f\u06cc\u06af\u0631 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam \u062f\u0631 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062f\u0631 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u062a\u0646\u0647\u0627 \u0628\u0627 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a. FreeCam \u0631\u0627 \u0627\u0632 \u0633\u0631\u0648\u0631 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062a\u0646\u0647\u0627 \u062f\u0631 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0646\u0635\u0628 \u0634\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "FreeCam \u062f\u0631 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "FreeCam \u0631\u0627 \u0627\u0632 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0628\u0627\u06cc\u062f \u0641\u0642\u0637 \u062f\u0631 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0646\u0635\u0628 \u0634\u0648\u062f.";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) \u062f\u0631 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062f\u0631 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u062a\u0646\u0647\u0627 \u0628\u0627 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a. ETF \u0631\u0627 \u0627\u0632 \u0633\u0631\u0648\u0631 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062a\u0646\u0647\u0627 \u062f\u0631 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0646\u0635\u0628 \u0634\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features \u062f\u0631 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features \u0631\u0627 \u0627\u0632 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0628\u0627\u06cc\u062f \u0641\u0642\u0637 \u062f\u0631 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0646\u0635\u0628 \u0634\u0648\u062f.";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0628\u0631\u0627\u06cc \u0627\u062c\u0631\u0627\u06cc \u0633\u0631\u0648\u0631\u060c \u0628\u0627\u06cc\u062f EULA \u0645\u0627\u06cc\u0646\u06a9\u0631\u0627\u0641\u062a \u0631\u0627 \u0628\u067e\u0630\u06cc\u0631\u06cc\u062f. \u0641\u0627\u06cc\u0644 eula.txt \u0631\u0627 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0631\u062f\u0647 \u0648 'eula=false' \u0631\u0627 \u0628\u0647 'eula=true' \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "EULA \u0645\u0627\u06cc\u0646\u06a9\u0631\u0627\u0641\u062a \u067e\u0630\u06cc\u0631\u0641\u062a\u0647 \u0646\u0634\u062f\u0647";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "\u0641\u0627\u06cc\u0644 eula.txt \u0631\u0627 \u062f\u0631 \u067e\u0648\u0634\u0647 \u0633\u0631\u0648\u0631 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0631\u062f\u0647 \u0648 'eula=false' \u0631\u0627 \u0628\u0647 'eula=true' \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \u062f\u0631 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062f\u0631 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u062a\u0646\u0647\u0627 \u0628\u0627 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a. OptiFine \u0631\u0627 \u0627\u0632 \u0633\u0631\u0648\u0631 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062a\u0646\u0647\u0627 \u062f\u0631 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0646\u0635\u0628 \u0634\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "OptiFine \u062f\u0631 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "OptiFine \u0631\u0627 \u0627\u0632 \u0633\u0631\u0648\u0631 \u0627\u062e\u062a\u0635\u0627\u0635\u06cc \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0628\u0627\u06cc\u062f \u0641\u0642\u0637 \u062f\u0631 \u06a9\u0644\u0627\u06cc\u0646\u062a \u0646\u0635\u0628 \u0634\u0648\u062f.";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks \u0628\u0647 \u0627\u0634\u062a\u0628\u0627\u0647 \u0628\u0631\u0627\u06cc 1.20.1 \u0639\u0644\u0627\u0645\u062a\u200c\u06af\u0630\u0627\u0631\u06cc \u0634\u062f\u0647 \u0627\u0645\u0627 \u0627\u0632 \u0645\u062a\u062f\u0647\u0627\u06cc 1.21.1 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u062f\u0631 \u062d\u0627\u0644 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 ResourceLocation.fromNamespaceAndPath \u0627\u0633\u062a \u06a9\u0647 \u062f\u0631 1.20.1 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "\u062e\u0637\u0627\u06cc \u0646\u0633\u062e\u0647 Iron's Spellbooks";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "\u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u0646\u0633\u062e\u0647 \u0635\u062d\u06cc\u062d Iron's Spellbooks \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647 \u0645\u0627\u06cc\u0646\u06a9\u0631\u0627\u0641\u062a \u062e\u0648\u062f \u0631\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 OptiFine \u0648 Embeddium \u062a\u0634\u062e\u06cc\u0635 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0647\u0633\u062a\u0646\u062f \u0648 \u0628\u0627\u0639\u062b \u0634\u06a9\u0633\u062a \u062a\u0632\u0631\u06cc\u0642 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f \u06a9\u0647 \u062c\u0644\u0648\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u0631\u0627 \u0645\u06cc\u200c\u06af\u06cc\u0631\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "\u062a\u0636\u0627\u062f OptiFine \u0648 Embeddium";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "OptiFine \u06cc\u0627 Embeddium \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0628\u0627 \u06cc\u06a9\u062f\u06cc\u06af\u0631 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0627\u06cc\u0646 \u0645\u0633\u0626\u0644\u0647 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u062a\u0648\u0644\u06cc\u062f \u062f\u0646\u06cc\u0627\u06cc \u0645\u062a\u0646\u0627\u0642\u0636 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f\u060c \u0628\u0647\u200c\u0648\u06cc\u0698\u0647 Terralinth\u060c AmplifiedNether\u060c Nullscape \u0648 Incendium \u0648 \u0633\u0627\u06cc\u0631 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u062a\u0648\u0644\u06cc\u062f \u062f\u0646\u06cc\u0627. \u0647\u0645\u0686\u0646\u06cc\u0646 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0646\u06cc\u0627\u0632 \u0628\u0627\u0634\u062f \u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u06af\u0645\u200c\u0634\u062f\u0647 \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable \u304c\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u3067\u306e\u8aad\u307f\u8fbc\u307f\u3092\u8a66\u307f\u3066\u3044\u307e\u3059\u304c\u3001\u3053\u308c\u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3067\u306e\u307f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u30b5\u30fc\u30d0\u30fc\u304b\u3089 Controllable \u3092\u524a\u9664\u3059\u308b\u304b\u3001\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u4e0a\u306e Controllable";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "Controllable \u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u306e\u307f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u306e\u3067\u3001\u5c02\u7528\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries \u0628\u0627\u0639\u062b \u062e\u0637\u0627\u06cc\u06cc \u0634\u062f\u0647 \u06a9\u0647 \u0627\u0632 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0633\u0631\u0648\u0631 \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u062f\u0631 \u062b\u0628\u062a \u0631\u0641\u062a\u0627\u0631\u0647\u0627\u06cc \u0622\u062a\u0634 \u0645\u0634\u06a9\u0644 \u062f\u0627\u0631\u062f \u06a9\u0647 \u0637\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc datapack\u0647\u0627 \u0628\u0627\u0639\u062b \u0634\u06a9\u0633\u062a \u0645\u06cc\u200c\u0634\u0648\u062f.</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries \u0645\u0627\u0646\u0639 \u0627\u0632 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0633\u0631\u0648\u0631 \u0634\u062f\u0647 \u0627\u0633\u062a";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "\u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f Supplementaries \u0631\u0627 \u0628\u0647 \u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0628\u0647 \u0637\u0648\u0631 \u0645\u0648\u0642\u062a \u0622\u0646 \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0633\u0631\u0648\u0631 \u0628\u062a\u0648\u0627\u0646\u062f \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0634\u0648\u062f.";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader (GML) \u0628\u0627 \u0645\u0634\u06a9\u0644\u06cc \u062f\u0631 \u0645\u0648\u0631\u062f \u0645\u0627\u0698\u0648\u0644\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 Jackson \u0645\u0648\u0627\u062c\u0647 \u0634\u062f. \u0628\u0631\u062e\u06cc \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0645\u0627\u0646\u0646\u062f Valkyrien Skies \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0639\u062f\u0645 \u0627\u0631\u0627\u0626\u0647\u0654 \u062a\u0645\u0627\u0645 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627\u06cc \u0644\u0627\u0632\u0645\u060c \u0627\u06cc\u0646 \u062e\u0637\u0627 \u0631\u0627 \u0627\u06cc\u062c\u0627\u062f \u06a9\u0646\u0646\u062f.</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "\u0645\u0627\u0698\u0648\u0644 Jackson \u062f\u0631 Groovy Modloader \u06af\u0645 \u0634\u062f\u0647 \u0627\u0633\u062a";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "Groovy Modloader \u0648 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0631\u062a\u0628\u0637 \u0645\u0627\u0646\u0646\u062f Valkyrien Skies \u06a9\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627\u0639\u062b \u062a\u062f\u0627\u062e\u0644 \u0648\u0627\u0628\u0633\u062a\u06af\u06cc\u200c\u0647\u0627 \u0634\u0648\u0646\u062f \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat \u0646\u0627\u0645 \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0628\u0644\u0648\u06a9 \u0686\u0648\u0628\u06cc \u0631\u0627 \u067e\u06cc\u062f\u0627 \u06a9\u0631\u062f. Every Compat \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0645\u0634\u06a9\u0644\u0627\u062a \u0632\u06cc\u0627\u062f\u06cc \u062f\u0627\u0631\u062f. \u0627\u0632 \u0622\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0646\u06a9\u0646\u06cc\u062f!</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "\u0646\u0627\u0645 \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u062f\u0631 Every Compat";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "\u067e\u06a9\u200c\u0647\u0627\u06cc \u0645\u0646\u0627\u0628\u0639 \u06cc\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u0631\u0627 \u06a9\u0647 \u0627\u0632 Every Compat \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u062d\u0627\u0648\u06cc \u0646\u0627\u0645\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0628\u0644\u0648\u06a9 \u0628\u0627\u0634\u0646\u062f.";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06a9\u062f \u062e\u0637\u0627\u06cc (-1073741819) \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f \u06a9\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0646\u0627\u0634\u06cc \u0627\u0632 overlay\u0647\u0627\u06cc\u06cc \u0645\u0627\u0646\u0646\u062f GameCaster\u0650 Razer\u060c Discord\u060c OBS Studio \u06cc\u0627 \u0645\u0634\u06a9\u0644\u0627\u062a \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u0628\u0627\u0634\u062f.</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "\u06a9\u062f \u062e\u0637\u0627 -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "\u0633\u0639\u06cc \u06a9\u0646\u06cc\u062f overlay\u0647\u0627\u06cc\u06cc \u0645\u0627\u0646\u0646\u062f GameCaster\u060c Discord \u06cc\u0627 OBS Studio \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f \u0648 \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u062f\u0631\u0627\u06cc\u0648\u0631\u0647\u0627\u06cc NVIDIA \u0634\u0645\u0627 \u0628\u0647\u200c\u0631\u0648\u0632 \u0647\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips \u0628\u0647 Immersive Messages \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u06cc\u06a9 dependencia \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f \u0627\u0645\u0627 \u0646\u0635\u0628 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a. \u0628\u0631\u0627\u06cc \u0627\u06cc\u0646\u06a9\u0647 Immersive Tooltips \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u06a9\u0627\u0631 \u06a9\u0646\u062f\u060c Immersive Messages \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips \u0628\u062f\u0648\u0646 dependencia";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Messages \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0627\u06cc\u0646 \u06cc\u06a9 dependencia \u0636\u0631\u0648\u0631\u06cc \u0628\u0631\u0627\u06cc Immersive Tooltips \u0627\u0633\u062a.";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins \u0628\u0627 Apoli Mod \u0645\u0634\u06a9\u0644 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u062f\u0627\u0631\u062f \u06a9\u0647 \u062f\u0631 \u0622\u0646 ItemStack \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0628\u0647 EntityLinkedItemStack cast \u0634\u0648\u062f. \u0627\u06cc\u0646 \u0645\u0633\u0626\u0644\u0647 \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0628\u0627\u0644\u0627\u062a\u0631 \u0627\u0632 6.6.0 \u0631\u0627\u06cc\u062c \u0627\u0633\u062a. \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u06cc \u0642\u062f\u06cc\u0645\u06cc\u200c\u062a\u0631 \u06cc\u0627 \u062a\u0639\u0648\u06cc\u0636 \u0628\u06cc\u0646 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc Fabric \u0648 Forge \u0631\u0627 \u062f\u0631 \u0646\u0638\u0631 \u0628\u06af\u06cc\u0631\u06cc\u062f.</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "\u062e\u0637\u0627\u06cc cast \u062f\u0631 Medieval Origins";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "\u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u06cc 6.6.0 \u06cc\u0627 \u0642\u062f\u06cc\u0645\u06cc\u200c\u062a\u0631 Medieval Origins \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u06cc\u0627 \u0628\u06cc\u0646 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc Fabric \u0648 Forge \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether \u0628\u0627\u0639\u062b \u062e\u0637\u0627\u06cc\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a \u06a9\u0647 \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 \u06cc\u06a9 Registry Object \u063a\u0627\u06cc\u0628 \u062f\u0631 MusicManager \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0645\u0631\u062a\u0628\u0637 \u0628\u0627 mixin\u0650 MusicManager \u0627\u0632 Reign of Nether \u0645\u06cc\u200c\u0628\u0627\u0634\u062f.</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "\u062e\u0637\u0627\u06cc MusicManager \u062f\u0631 Reign of Nether";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "\u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0627\u06cc\u0646 \u062e\u0637\u0627\u060c Reign of Nether \u0631\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0628\u0647 \u0637\u0648\u0631 \u0645\u0648\u0642\u062a \u0622\u0646 \u0631\u0627 \u062d\u0630\u0641 \u0646\u0645\u0627\u06cc\u06cc\u062f.";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel \u0641\u0642\u0637 \u0627\u0632 \u0633\u0631\u0648\u0631 YSM \u062f\u0631 Linux \u06cc\u0627 Android \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062c\u062f\u06cc\u062f\u062a\u0631 \u0627\u0632 \u06f2\u06f3 \u0646\u0648\u0627\u0645\u0628\u0631 \u06f2\u06f0\u06f2\u06f5 \u062f\u0631 Modrinth \u0631\u0641\u0639 \u0634\u062f\u0647 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel \u0628\u0627 Linux \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "YesSteveModel \u0631\u0627 \u0627\u0632 Modrinth \u0628\u0647 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u062c\u062f\u06cc\u062f\u062a\u0631 \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u067e\u0633 \u0627\u0632 \u06f2\u06f3 \u0646\u0648\u0627\u0645\u0628\u0631 \u0631\u0641\u0639 \u0634\u062f\u0647 \u0627\u0633\u062a.";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 Moving Elevators \u0648 OptiFine \u062a\u0634\u062e\u06cc\u0635 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0647\u0633\u062a\u0646\u062f \u0648 \u0628\u0627\u0639\u062b \u0634\u06a9\u0633\u062a \u062a\u0632\u0631\u06cc\u0642 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f \u06a9\u0647 \u062c\u0644\u0648\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u0631\u0627 \u0645\u06cc\u200c\u06af\u06cc\u0631\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "\u062a\u0636\u0627\u062f Moving Elevators \u0648 OptiFine";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "Moving Elevators \u06cc\u0627 OptiFine \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0628\u0627 \u06cc\u06a9\u062f\u06cc\u06af\u0631 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0636\u0627\u062f \u0628\u062d\u0631\u0627\u0646\u06cc \u0628\u06cc\u0646 Fabric API (fabric-resource-loader-v0) \u0648 OptiFine \u062a\u0634\u062e\u06cc\u0635 \u062f\u0627\u062f\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0647\u0633\u062a\u0646\u062f \u0648 \u0628\u0627\u0639\u062b \u0634\u06a9\u0633\u062a \u062a\u0632\u0631\u06cc\u0642 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f \u06a9\u0647 \u062c\u0644\u0648\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627\u0632\u06cc \u0631\u0627 \u0645\u06cc\u200c\u06af\u06cc\u0631\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "\u062a\u0636\u0627\u062f Fabric API \u0648 OptiFine";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "OptiFine \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f \u06cc\u0627 Fabric API \u0631\u0627 \u0628\u0647 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u0646\u0645\u0627\u06cc\u06cc\u062f.";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647 \u062f\u0627\u0631\u0627\u06cc ITransformationService \u0645\u0639\u06cc\u0648\u0628\u06cc \u0627\u0633\u062a \u06a9\u0647 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0646\u0645\u0648\u0646\u0647\u200c\u0633\u0627\u0632\u06cc \u0634\u0648\u062f: " + claseProveedor + ". \u0628\u0631\u0627\u06cc \u0627\u0645\u06a9\u0627\u0646 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0628\u0627\u0632\u06cc\u060c \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u0628\u0627\u06cc\u062f \u062d\u0630\u0641 \u0634\u0648\u062f.</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "ITransformationService \u0645\u0639\u06cc\u0648\u0628";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0627\u06cc \u06a9\u0647 \u06a9\u0644\u0627\u0633 " + claseProveedor + " \u0631\u0627 \u062f\u0627\u0631\u062f \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u062f\u0627\u0631\u0627\u06cc ITransformationService \u0645\u0639\u06cc\u0648\u0628\u06cc \u0627\u0633\u062a.";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647 \u062f\u0627\u0631\u0627\u06cc \u0645\u0634\u062e\u0635\u0627\u062a \u0646\u0633\u062e\u0647\u0654 \u0646\u0627\u0645\u0639\u062a\u0628\u0631\u06cc \u0627\u0633\u062a. \u0646\u0633\u062e\u0647 \u0628\u0627\u06cc\u062f \u0628\u0627 \u0628\u0631\u0627\u06a9\u062a \u0645\u0631\u0628\u0639\u06cc \u0627\u062d\u0627\u0637\u0647 \u0634\u0648\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 grep/greprf \u062f\u0631 \u067e\u0646\u0644 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u062c\u0633\u062a\u062c\u0648\u06cc \u0646\u0633\u062e\u0647\u0654 </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u0634\u062e\u0635 \u06a9\u0646\u06cc\u062f \u06a9\u062f\u0627\u0645 \u0627\u0641\u0632\u0648\u0646\u0647 \u0645\u0634\u06a9\u0644 \u062f\u0627\u0631\u062f.</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "\u0646\u0633\u062e\u0647\u0654 \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u062f\u0631 \u0627\u0641\u0632\u0648\u0646\u0647";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "\u0627\u0632 \u0627\u0628\u0632\u0627\u0631 grep/greprf \u062f\u0631 \u067e\u0646\u0644 \u06a9\u0646\u0627\u0631\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0646\u0633\u062e\u0647\u0654 \u0645\u0634\u06a9\u0644\u200c\u062f\u0627\u0631 \u0631\u0627 \u062c\u0633\u062a\u062c\u0648 \u06a9\u0631\u062f\u0647 \u0648 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0627\u06cc \u06a9\u0647 \u0622\u0646 \u0631\u0627 \u062f\u0627\u0631\u062f \u067e\u06cc\u062f\u0627 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc stack smashing \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f \u06a9\u0647 \u0628\u0627\u0639\u062b \u067e\u0627\u06cc\u0627\u0646 \u0641\u0631\u0622\u06cc\u0646\u062f \u0634\u062f. \u0627\u06cc\u0646 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0646\u0627\u0634\u06cc \u0627\u0632 \u0645\u0634\u06a9\u0644\u0627\u062a Early Window \u062f\u0631 Forge/NeoForge/PillowMC \u06cc\u0627 LWJGL \u0646\u0633\u062e\u0647 3.2.2 \u0648 \u062c\u062f\u06cc\u062f\u062a\u0631 \u0628\u0627\u0634\u062f.</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "Stack Smashing \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "\u062a\u0646\u0638\u06cc\u0645\u0627\u062a Early Window \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u0648 \u0646\u0633\u062e\u0647\u0654 \u062f\u06cc\u06af\u0631\u06cc \u0627\u0632 LWJGL \u0631\u0627 \u0627\u0645\u062a\u062d\u0627\u0646 \u06a9\u0646\u06cc\u062f \u06cc\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0631\u062a\u0628\u0637 \u0628\u0627 \u067e\u0646\u062c\u0631\u0647\u0654 \u0627\u0648\u0644\u06cc\u0647 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u0646\u0645\u0627\u06cc\u06cc\u062f.";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore \u0641\u0642\u0637 \u0628\u0631\u0627\u06cc \u06cc\u06a9 modpack \u062e\u0627\u0635 \u0627\u0633\u062a \u0648 \u0646\u0628\u0627\u06cc\u062f \u062f\u0631 \u0646\u0635\u0628\u200c\u0647\u0627\u06cc \u0639\u0645\u0648\u0645\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u0648\u062f\u060c \u0632\u06cc\u0631\u0627 \u0628\u0627\u0639\u062b \u0627\u06cc\u062c\u0627\u062f \u0645\u0634\u06a9\u0644 \u0645\u06cc\u200c\u0634\u0648\u062f.</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore \u0628\u0627 \u0646\u0633\u062e\u0647\u0654 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 Java";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0641\u0642\u0637 \u0628\u0631\u0627\u06cc \u06cc\u06a9 modpack \u062e\u0627\u0635 \u0627\u0633\u062a \u0648 \u0628\u0627 \u0646\u0635\u0628 \u0639\u0645\u0648\u0645\u06cc \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a.";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0639\u0627\u0631\u0636\u06cc \u0628\u06cc\u0646 MoniLabs \u0648 Connector Extras \u062f\u0631 \u0627\u0631\u062a\u0628\u0627\u0637 \u0628\u0627 \u0627\u0635\u0644\u0627\u062d\u0627\u062a KubeJS \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u062f\u0631 \u0627\u0635\u0644\u0627\u062d\u0627\u062a KubeJS \u062e\u0648\u062f \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0647\u0633\u062a\u0646\u062f.</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "\u062a\u0639\u0627\u0631\u0636 MoniLabs \u0648 Connector Extras";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "\u06cc\u06a9\u06cc \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 (MoniLabs \u06cc\u0627 Connector Extras) \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0627\u0635\u0644\u0627\u062d\u0627\u062a KubeJS \u0622\u0646\u200c\u0647\u0627 \u0628\u0627 \u0647\u0645 \u062a\u062f\u0627\u062e\u0644 \u062f\u0627\u0631\u062f.";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris \u0646\u06cc\u0627\u0632\u0645\u0646\u062f Distant Horizons [2.0.4] \u06cc\u0627 DH API \u0646\u0633\u062e\u0647\u0654 [1.1.0] \u06cc\u0627 \u062c\u062f\u06cc\u062f\u062a\u0631 \u0627\u0633\u062a. \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644\u060c \u0631\u0627\u0647\u0646\u0645\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0631\u0627 \u062f\u0631 https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e \u0645\u0634\u0627\u0647\u062f\u0647 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "\u0633\u0627\u0632\u06af\u0627\u0631\u06cc Iris \u0648 Distant Horizons";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "\u0631\u0627\u0647\u0646\u0645\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0631\u0627 \u062f\u0631 https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e \u0628\u0631\u0631\u0633\u06cc \u06a9\u0631\u062f\u0647 \u0648 Iris \u0648 Distant Horizons \u0631\u0627 \u0628\u0647 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 Minecraft \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 \u0628\u0627\u0632\u06cc \u062f\u0627\u0631\u06cc\u062f. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a> \u0628\u0631\u0627\u06cc \u0628\u0631\u0631\u0633\u06cc \u0648\u062c\u0648\u062f \u06a9\u0644\u0627\u0633 \u062f\u0631 \u0646\u0633\u062e\u0647\u0654 \u062e\u0648\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</li><li>\u0646\u0635\u0628\u200c \u0634\u0645\u0627 \u0627\u0632 Minecraft \u062e\u0631\u0627\u0628 \u0627\u0633\u062a (\u0631\u0627\u06cc\u062c \u062f\u0631 CurseForge App\u060c ModrinthApp/Theseus/Astralrinth \u0648 \u0633\u0627\u06cc\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc modpack). \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0645\u0634\u06a9\u0644\u0627\u062a CurseForge\u060c <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0622\u0645\u0648\u0632\u0634 \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f</a>.</li><li>coremod \u0645\u0639\u06cc\u0648\u0628\u06cc \u062f\u0627\u0631\u06cc\u062f (\u062f\u0631 \u0635\u0648\u0631\u062a \u0634\u06a9\u0633\u062a coremod\u060c \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0644\u0627\u0633 \u0645\u0633\u062f\u0648\u062f \u0634\u0648\u062f).</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 DangerZone \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 \u0628\u0627\u0632\u06cc \u062f\u0627\u0631\u06cc\u062f.</li><li>coremod\u0647\u0627\u06cc \u0645\u0639\u06cc\u0648\u0628\u06cc \u062f\u0627\u0631\u06cc\u062f.</li><li>\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u06cc\u0627 \u0646\u0635\u0628\u200c \u0634\u0645\u0627 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a.</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 FeatureCreep \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u0628\u0631\u0627\u06cc \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 FeatureCreep \u062f\u0627\u0631\u06cc\u062f (\u0645\u062b\u0644\u0627\u064b: ESR \u062f\u0631 \u0645\u0642\u0627\u0628\u0644 Nightly \u06cc\u0627 v4 \u062f\u0631 \u0645\u0642\u0627\u0628\u0644 v12).</li><li>\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f FeatureCreep \u0631\u0627 \u0627\u0632 CurseForge \u06cc\u0627 MinecraftStorage \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 ModLauncher \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u0631\u0627\u06cc build \u0645\u062a\u0641\u0627\u0648\u062a\u06cc \u0627\u0632 MinecraftForge\u060c PillowMC \u06cc\u0627 NeoForge \u0647\u0633\u062a\u0646\u062f (ModLauncher \u0628\u0627 \u0627\u06cc\u0646 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u0647\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f).</li><li>\u0628\u0631\u0627\u06cc \u0647\u0631 \u0646\u0633\u062e\u0647\u0654 Minecraft\u060c \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u200c\u0647\u0627\u06cc \u0632\u06cc\u0627\u062f\u06cc \u0627\u0632 modloader \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.</li><li>\u0646\u0635\u0628\u200c \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0634\u0645\u0627 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a (\u0631\u0627\u06cc\u062c \u062f\u0631 CurseForge App\u060c ModrinthApp/Theseus/Astralrinth \u0648 \u0633\u0627\u06cc\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc modpack). \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0645\u0634\u06a9\u0644\u0627\u062a CurseForge\u060c <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0622\u0645\u0648\u0632\u0634 \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f</a>.</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 Minecraft Forge \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u0631\u0627\u06cc build \u0645\u062a\u0641\u0627\u0648\u062a\u06cc \u0627\u0632 MinecraftForge \u0647\u0633\u062a\u0646\u062f.</li><li>\u0628\u0631\u0627\u06cc \u0647\u0631 \u0646\u0633\u062e\u0647\u0654 Minecraft\u060c \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u200c\u0647\u0627\u06cc \u0632\u06cc\u0627\u062f\u06cc \u0627\u0632 modloader \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.</li><li>\u0646\u0635\u0628\u200c \u0634\u0645\u0627 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a (\u0631\u0627\u06cc\u062c \u062f\u0631 CurseForge App\u060c ModrinthApp/Theseus/Astralrinth \u0648 \u0633\u0627\u06cc\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc modpack). \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0645\u0634\u06a9\u0644\u0627\u062a CurseForge\u060c <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0622\u0645\u0648\u0632\u0634 \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f</a>.</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 NeoForge \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u0631\u0627\u06cc build \u0645\u062a\u0641\u0627\u0648\u062a\u06cc \u0627\u0632 NeoForge \u0647\u0633\u062a\u0646\u062f.</li><li>\u0628\u0631\u0627\u06cc \u0647\u0631 \u0646\u0633\u062e\u0647\u0654 Minecraft\u060c \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u200c\u0647\u0627\u06cc \u0632\u06cc\u0627\u062f\u06cc \u0627\u0632 modloader \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.</li><li>\u0646\u0635\u0628\u200c \u0634\u0645\u0627 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a (\u0631\u0627\u06cc\u062c \u062f\u0631 CurseForge App\u060c ModrinthApp/Theseus/Astralrinth \u0648 \u0633\u0627\u06cc\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc modpack). \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0645\u0634\u06a9\u0644\u0627\u062a CurseForge\u060c <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0622\u0645\u0648\u0632\u0634 \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f</a>.</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 Fabric Loader \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u0631\u0627\u06cc build \u0645\u062a\u0641\u0627\u0648\u062a\u06cc \u0627\u0632 Fabric Loader \u0647\u0633\u062a\u0646\u062f.</li><li>\u0628\u0631\u0627\u06cc \u0647\u0631 \u0646\u0633\u062e\u0647\u0654 Minecraft\u060c \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u200c\u0647\u0627\u06cc \u0632\u06cc\u0627\u062f\u06cc \u0627\u0632 modloader \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.</li><li>\u0646\u0635\u0628\u200c \u0634\u0645\u0627 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a (\u0631\u0627\u06cc\u062c \u062f\u0631 CurseForge App\u060c ModrinthApp/Theseus/Astralrinth \u0648 \u0633\u0627\u06cc\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc modpack). \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0645\u0634\u06a9\u0644\u0627\u062a CurseForge\u060c <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0622\u0645\u0648\u0632\u0634 \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f</a>.</li><li>\u0628\u0633\u06cc\u0627\u0631\u06cc \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0628\u0647 Fabric API \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u0646\u062f. \u062f\u0631 \u0635\u0648\u0631\u062a \u0646\u06cc\u0627\u0632\u060c Fabric API \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0634\u0645\u0627 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 PillowMC \u0631\u0627 \u0627\u0632 \u062f\u0633\u062a \u062f\u0627\u062f\u0647\u200c\u0627\u06cc\u062f. \u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u0631\u0627\u06cc build \u0645\u062a\u0641\u0627\u0648\u062a\u06cc \u0627\u0632 PillowMC \u0647\u0633\u062a\u0646\u062f.</li><li>\u0628\u0631\u0627\u06cc \u0647\u0631 \u0646\u0633\u062e\u0647\u0654 Minecraft\u060c \u0628\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc\u200c\u0647\u0627\u06cc \u0632\u06cc\u0627\u062f\u06cc \u0627\u0632 modloader \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.</li><li>\u0646\u0635\u0628\u200c \u0634\u0645\u0627 \u062e\u0631\u0627\u0628 \u0627\u0633\u062a (\u0631\u0627\u06cc\u062c \u062f\u0631 CurseForge App\u060c ModrinthApp/Theseus/Astralrinth \u0648 \u0633\u0627\u06cc\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc modpack). \u0628\u0631\u0627\u06cc \u0631\u0641\u0639 \u0645\u0634\u06a9\u0644\u0627\u062a CurseForge\u060c <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0622\u0645\u0648\u0632\u0634 \u0631\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f</a>.</li></ul><p>\u0646\u06a9\u062a\u0647: \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr/fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647 \u06a9\u0644\u0627\u0633\u200c\u0647\u0627\u06cc \u06af\u0645\u200c\u0634\u062f\u0647 \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0634\u0631\u0637\u06cc \u06a9\u0647 \u062f\u0631 \u0646\u0627\u0645\u200c\u0647\u0627 \u0627\u0632 '/' \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0634\u0645\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0627\u06cc \u062f\u0627\u0631\u06cc\u062f \u06a9\u0647 \u0639\u0645\u062f\u0627\u064b \u0628\u0627\u0639\u062b \u062a\u0623\u062e\u06cc\u0631 (\u0644\u0627\u06af) \u0645\u06cc\u200c\u0634\u0648\u062f. Uranium \u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u0644\u0627\u06af \u0627\u0633\u062a. \u0647\u0645\u06cc\u0634\u0647 \u0628\u0627\u0639\u062b crash \u0646\u0645\u06cc\u200c\u0634\u0648\u062f\u060c \u0627\u0645\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u062f\u0631 \u0646\u0647\u0627\u06cc\u062a \u0627\u06cc\u0646 \u0627\u062a\u0641\u0627\u0642 \u0628\u06cc\u0641\u062a\u062f.</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 1.19.* \u0639\u0644\u0627\u0645\u062a\u200c\u06af\u0630\u0627\u0631\u06cc \u0634\u062f\u0647 \u0627\u0645\u0627 \u062f\u0631 \u0648\u0627\u0642\u0639 \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 1.20.* \u0627\u0633\u062a \u06a9\u0647 \u0628\u0627\u0639\u062b \u062e\u0637\u0627\u06cc \u00ab\u06a9\u0644\u0627\u0633 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f\u00bb \u0645\u06cc\u200c\u0634\u0648\u062f. \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u0633\u0639\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f \u0627\u0632 DamageSources\u200c\u0647\u0627\u06cc\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f \u06a9\u0647 \u062f\u0631 \u0646\u0633\u062e\u0647\u0654 \u0641\u0639\u0644\u06cc Minecraft \u0634\u0645\u0627 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u0646\u062f.</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "\u062e\u0637\u0627\u06cc \u0646\u0633\u062e\u0647 Falling Attack";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "\u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u0627\u0632 \u0646\u0633\u062e\u0647\u0654 \u062f\u0631\u0633\u062a Falling Attack \u06a9\u0647 \u0628\u0627 \u0646\u0633\u062e\u0647\u0654 Minecraft \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a\u060c \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("\u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0627\u06cc\u0646 \u0642\u0627\u0628\u0644\u06cc\u062a\u060c \u0628\u0627\u06cc\u062f CFR (Class File Reader) \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("\u062f\u0631 \u0633\u06cc\u0633\u062a\u0645\u200c\u0647\u0627\u06cc Linux\u060c NetBSD \u06cc\u0627 FreeBSD\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f CFR \u0631\u0627 \u0627\u0632 \u0637\u0631\u06cc\u0642 \u0645\u062f\u06cc\u0631 \u0628\u0633\u062a\u0647 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.<br>").append("\u0628\u0633\u062a\u0647 \u0631\u0627 \u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u062c\u0633\u062a\u062c\u0648 \u06a9\u0646\u06cc\u062f: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("\u062f\u0631 \u063a\u06cc\u0631 \u0627\u06cc\u0646 \u0635\u0648\u0631\u062a\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0646\u0633\u062e\u0647\u0654 \u0627\u0635\u0644\u0627\u062d\u200c\u0634\u062f\u0647\u200c\u0627\u06cc \u06a9\u0647 FabricMC \u0627\u0632 \u0622\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f \u0631\u0627 \u0627\u0632 \u0627\u06cc\u0646\u062c\u0627 \u062f\u0627\u0646\u0644\u0648\u062f \u06a9\u0646\u06cc\u062f:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("\u0622\u0646 \u0631\u0627 \u062f\u0631 \u067e\u0648\u0634\u0647\u0654 \u0632\u06cc\u0631 \u0630\u062e\u06cc\u0631\u0647 \u06a9\u0646\u06cc\u062f:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>\u0645\u0647\u0645:</b> \u067e\u0633 \u0627\u0632 \u0646\u0635\u0628 CFR\u060c \u0628\u0627\u06cc\u062f mod \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u0648\u062f.").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "\u067e\u0631\u062a\u0631\u0647\u200c\u0627\u06cc \u062f\u0631 \u062f\u0633\u062a\u0631\u0633 \u0646\u06cc\u0633\u062a";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "\u06a9\u0644\u0627\u0633 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "\u062f\u06cc\u06a9\u0627\u0645\u067e\u0627\u06cc\u0644\u0631 CFR \u2013 Sakura Riddle (\u063a\u06cc\u0631\u0631\u0633\u0645\u06cc)";
    }

    @Override
    public String cfrClaseActual() {
        return "\u06a9\u0644\u0627\u0633 \u0641\u0639\u0644\u06cc";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "\u067e\u0631\u062a\u0631\u0647\u0654 Sakura Riddle";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u067e\u0631\u062a\u0631\u0647";
    }

    @Override
    public String noticiaLegalCFR() {
        return "\u0627\u06cc\u0646 \u0631\u0627\u0628\u0637 \u06a9\u0627\u0631\u0628\u0631\u06cc \u06af\u0631\u0627\u0641\u06cc\u06a9\u06cc (GUI) \u0628\u0631\u0627\u06cc \u062f\u06cc\u06a9\u0627\u0645\u067e\u0627\u06cc\u0644 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0628\u0647 \u0645\u0646\u0638\u0648\u0631 \u06a9\u0645\u06a9 \u0628\u0647 \u06a9\u0627\u0631\u0628\u0631\u0627\u0646 \u062f\u0631 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0639\u0644\u062a \u062e\u0631\u0627\u0628\u06cc\u200c\u0647\u0627\u06cc \u0646\u0631\u0645\u200c\u0627\u0641\u0632\u0627\u0631\u06cc \u0637\u0631\u0627\u062d\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a. \u0628\u0627 \u0627\u06cc\u0646 \u062d\u0627\u0644\u060c \u06af\u0627\u0647\u06cc \u062f\u06cc\u06a9\u0627\u0645\u067e\u0627\u06cc\u0644 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0636\u0631\u0648\u0631\u06cc \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u06a9\u0627\u0631\u0628\u0631\u0627\u0646 \u0628\u0627\u06cc\u062f \u0645\u0631\u0627\u0642\u0628 \u0628\u0627\u0634\u0646\u062f \u06a9\u0647 \u0627\u0632 \u06a9\u062f \u062a\u0648\u0644\u06cc\u062f\u0634\u062f\u0647 \u0628\u0631\u0627\u06cc \u0646\u0642\u0636 \u0642\u0627\u0646\u0648\u0646 \u062d\u0642 \u062a\u06a9\u062b\u06cc\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0646\u06a9\u0646\u0646\u062f. \u0642\u0628\u0644 \u0627\u0632 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0647\u0631 \u06a9\u062f\u06cc\u060c \u0628\u0631\u0631\u0633\u06cc \u0645\u062c\u0648\u0632 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u0645\u0631\u0628\u0648\u0637\u0647 \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f. \u0639\u0644\u0627\u0648\u0647 \u0628\u0631 \u0627\u06cc\u0646\u060c \u0628\u0633\u06cc\u0627\u0631\u06cc \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u06a9\u062f \u0645\u0646\u0628\u0639 \u062e\u0648\u062f \u0631\u0627 \u0628\u0647 \u0635\u0648\u0631\u062a \u0631\u0633\u0645\u06cc \u0627\u0631\u0627\u0626\u0647 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f\u060c \u06a9\u0647 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u062a\u0645\u06cc\u0632\u062a\u0631 \u0648 \u0642\u0627\u0628\u0644\u200c\u062f\u0631\u06a9\u200c\u062a\u0631 \u0627\u0632 \u06a9\u062f \u062f\u06cc\u06a9\u0627\u0645\u067e\u0627\u06cc\u0644\u200c\u0634\u062f\u0647 \u0627\u0633\u062a. \u0631\u0639\u0627\u06cc\u062a \u0645\u0627\u0644\u06a9\u06cc\u062a \u0641\u06a9\u0631\u06cc \u0648 \u0645\u062c\u0648\u0632\u0647\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647\u060c \u0627\u0635\u0644\u06cc\u200c\u062a\u0631\u06cc\u0646 \u0627\u0631\u0632\u0634 \u062f\u0631 \u062c\u0627\u0645\u0639\u0647\u0654 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u06af\u0627\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u0627\u0633\u062a. \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0642\u0627\u0646\u0648\u0646 \u0641\u062f\u0631\u0627\u0644 \u062d\u0642 \u062a\u06a9\u062b\u06cc\u0631 \u0645\u06a9\u0632\u06cc\u06a9 \u0631\u0627 \u062f\u0631 \u0627\u06cc\u0646 \u0644\u06cc\u0646\u06a9 \u0645\u0634\u0627\u0647\u062f\u0647 \u06a9\u0646\u06cc\u062f: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor (\u0627\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc)</a> \u0648 \u0646\u0633\u062e\u0647\u0654 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0622\u0646 \u0631\u0627 \u0627\u06cc\u0646\u062c\u0627 \u0628\u0628\u06cc\u0646\u06cc\u062f: <a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (English)</a>. \u0628\u0627 \u062a\u0648\u062c\u0647 \u0628\u0647 \u0627\u06cc\u0646\u06a9\u0647 \u0634\u0645\u0627 \u062f\u0631 CurseForge \u0647\u0633\u062a\u06cc\u062f\u060c \u0644\u06cc\u0646\u06a9 \u0642\u0627\u0646\u0648\u0646 \u062d\u0642 \u062a\u06a9\u062b\u06cc\u0631 \u0627\u06cc\u0627\u0644\u0627\u062a \u0645\u062a\u062d\u062f\u0647 \u0631\u0627 \u0646\u06cc\u0632 \u0641\u0631\u0627\u0647\u0645 \u06a9\u0631\u062f\u0647\u200c\u0627\u06cc\u0645: <a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>. \u0647\u0645\u0686\u0646\u06cc\u0646 \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f \u06a9\u0627\u0631\u0628\u0631\u0627\u0646 \u0642\u0648\u0627\u0646\u06cc\u0646 \u062c\u0627\u0631\u06cc \u062f\u0631 \u06a9\u0634\u0648\u0631 \u062e\u0648\u062f \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u0646\u062f. \u0627\u06cc\u0646 GUI \u0641\u0642\u0637 \u0628\u0631\u0627\u06cc \u0628\u0631\u0631\u0633\u06cc\u200c\u0647\u0627\u06cc \u0633\u0627\u062f\u0647 \u0627\u0633\u062a\u061b \u0628\u0631\u0627\u06cc \u062a\u062d\u0644\u06cc\u0644 \u067e\u06cc\u0634\u0631\u0641\u062a\u0647\u060c \u0627\u0632 \u0627\u0646\u0634\u0639\u0627\u0628 Enigma \u062a\u0648\u0633\u0637 FabricMC \u062f\u0631 <a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0646\u06cc\u0627\u0632 \u0628\u0647 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u0645\u0633\u062a\u0642\u06cc\u0645 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc JAR \u0628\u0631\u0627\u06cc \u0627\u06cc\u062c\u0627\u062f \u067e\u0686 \u062f\u0627\u0631\u06cc\u062f (\u062f\u0631 \u0635\u0648\u0631\u062a \u0639\u062f\u0645 \u062f\u0633\u062a\u0631\u0633\u06cc \u0628\u0647 \u06a9\u062f \u0645\u0646\u0628\u0639)\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 Recaf \u062f\u0631 <a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">\u0648\u0628\u200c\u0633\u0627\u06cc\u062a\u0634</a> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String botonDescargarCfr() {
        return "\u062f\u0627\u0646\u0644\u0648\u062f CFR";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "\u0628\u0627\u0632 \u06a9\u0631\u062f\u0646 \u067e\u0648\u0634\u0647\u0654 \u0646\u0635\u0628";
    }

    @Override
    public String colorFondoPrincipal() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u0627\u0635\u0644\u06cc";
    }

    @Override
    public String colorTextoBotonReset() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u062f\u06a9\u0645\u0647\u0654 \u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0641\u06cc\u0644\u062f \u062c\u0633\u062a\u062c\u0648";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0645\u0646\u0648\u06cc \u06a9\u0634\u0648\u06cc\u06cc \u0641\u06cc\u0644\u062a\u0631";
    }

    @Override
    public String colorTextoRenderer() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0631\u0646\u062f\u0631\u06a9\u0646\u0646\u062f\u0647";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u067e\u0648\u0634\u0634 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc";
    }

    @Override
    public String colorBorde() {
        return "\u0631\u0646\u06af \u062d\u0627\u0634\u06cc\u0647";
    }

    @Override
    public String colorFondoRetrato() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647 \u062f\u0631 \u062d\u0627\u0644\u062a \u067e\u0631\u062a\u0631\u0647";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "\u0631\u0646\u06af \u067e\u06cc\u0648\u0646\u062f \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u0641\u06cc\u0644\u062f \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc";
    }

    @Override
    public String rosaFondo() {
        return "\u0635\u0648\u0631\u062a\u06cc \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647";
    }

    @Override
    public String rosaSuave() {
        return "\u0635\u0648\u0631\u062a\u06cc \u0645\u0644\u0627\u06cc\u0645";
    }

    @Override
    public String moradoAcento() {
        return "\u0628\u0646\u0641\u0634 \u0628\u0631\u062c\u0633\u062a\u0647";
    }

    @Override
    public String textoOscuro() {
        return "\u0645\u062a\u0646 \u062a\u06cc\u0631\u0647";
    }

    @Override
    public String bordeSuave() {
        return "\u062d\u0627\u0634\u06cc\u0647\u0654 \u0645\u0644\u0627\u06cc\u0645";
    }

    @Override
    public String fondoCampo() {
        return "\u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u0641\u06cc\u0644\u062f";
    }

    @Override
    public String fondoVistaPrevia() {
        return "\u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u067e\u06cc\u0634\u200c\u0646\u0645\u0627\u06cc\u0634";
    }

    @Override
    public String sintaxisConstructor() {
        return "\u0631\u0646\u06af \u0646\u062d\u0648: \u0633\u0627\u0632\u0646\u062f\u0647";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "\u0631\u0646\u06af \u0646\u062d\u0648: \u067e\u06cc\u0627\u0645 \u0631\u0627\u0647\u0646\u0645\u0627";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "\u0631\u0646\u06af \u0646\u062d\u0648: \u0628\u0631\u0686\u0633\u0628\u200c\u0647\u0627\u06cc HTML";
    }

    @Override
    public String colorFondoVentana() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u067e\u0646\u062c\u0631\u0647";
    }

    @Override
    public String colorPanel() {
        return "\u0631\u0646\u06af \u067e\u0627\u0646\u0644";
    }

    @Override
    public String colorBotonTexto() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u062f\u06a9\u0645\u0647";
    }

    @Override
    public String colorCampo() {
        return "\u0631\u0646\u06af \u0641\u06cc\u0644\u062f";
    }

    @Override
    public String colorBordeDestacado() {
        return "\u0631\u0646\u06af \u062d\u0627\u0634\u06cc\u0647\u0654 \u0628\u0631\u062c\u0633\u062a\u0647";
    }

    @Override
    public String colorSeleccionTexto() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u0627\u0646\u062a\u062e\u0627\u0628 \u0645\u062a\u0646";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647";
    }

    @Override
    public String colorEstadoExito() {
        return "\u0631\u0646\u06af \u0648\u0636\u0639\u06cc\u062a: \u0645\u0648\u0641\u0642\u06cc\u062a";
    }

    @Override
    public String colorEstadoFallo() {
        return "\u0631\u0646\u06af \u0648\u0636\u0639\u06cc\u062a: \u0634\u06a9\u0633\u062a";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "\u0631\u0646\u06af \u0648\u0636\u0639\u06cc\u062a: \u0644\u062d\u0638\u0647\u200c\u0627\u06cc";
    }

    @Override
    public String colorResultadoAnadido() {
        return "\u0631\u0646\u06af \u0646\u062a\u06cc\u062c\u0647\u0654 \u0627\u0636\u0627\u0641\u0647\u200c\u0634\u062f\u0647";
    }

    @Override
    public String colorResultadoEliminado() {
        return "\u0631\u0646\u06af \u0646\u062a\u06cc\u062c\u0647\u0654 \u062d\u0630\u0641\u200c\u0634\u062f\u0647";
    }

    @Override
    public String colorBordeScroll() {
        return "\u0631\u0646\u06af \u062d\u0627\u0634\u06cc\u0647\u0654 \u0646\u0648\u0627\u0631 \u067e\u06cc\u0645\u0627\u06cc\u0634";
    }

    @Override
    public String colorFondoPanel() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u067e\u0627\u0646\u0644";
    }

    @Override
    public String colorBeigeListas() {
        return "\u0628\u06cc\u0698 \u0641\u0647\u0631\u0633\u062a\u200c\u0647\u0627";
    }

    @Override
    public String colorTextoListas() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0641\u0647\u0631\u0633\u062a\u200c\u0647\u0627";
    }

    @Override
    public String colorBordeListas() {
        return "\u0631\u0646\u06af \u062d\u0627\u0634\u06cc\u0647\u0654 \u0641\u0647\u0631\u0633\u062a\u200c\u0647\u0627";
    }

    @Override
    public String colorBotonFondo() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u062f\u06a9\u0645\u0647";
    }

    @Override
    public String colorBordeBoton() {
        return "\u0631\u0646\u06af \u062d\u0627\u0634\u06cc\u0647\u0654 \u062f\u06a9\u0645\u0647";
    }

    @Override
    public String colorDoradoTexto() {
        return "\u0631\u0646\u06af \u0637\u0644\u0627\u06cc\u06cc \u0645\u062a\u0646";
    }

    @Override
    public String colorPila() {
        return "\u0631\u0646\u06af \u0631\u062f\u06cc\u0627\u0628\u06cc \u067e\u0634\u062a\u0647 (stack trace)";
    }

    @Override
    public String colorTextoPanel() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u067e\u0627\u0646\u0644";
    }

    @Override
    public String colorTextoNegro() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0633\u06cc\u0627\u0647";
    }

    @Override
    public String colorTextoPrincipal() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0627\u0635\u0644\u06cc";
    }

    @Override
    public String colorFondoResultados() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u0646\u062a\u0627\u06cc\u062c";
    }

    @Override
    public String colorEstado() {
        return "\u0631\u0646\u06af \u0648\u0636\u0639\u06cc\u062a";
    }

    @Override
    public String colorTextoDescripcion() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u062a\u0648\u0636\u06cc\u062d\u0627\u062a";
    }

    @Override
    public String colorTextoEstado() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0648\u0636\u0639\u06cc\u062a";
    }

    @Override
    public String colorTextoExtra() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u0627\u0636\u0627\u0641\u06cc";
    }

    @Override
    public String colorSeparador() {
        return "\u0631\u0646\u06af \u062c\u062f\u0627\u06a9\u0646\u0646\u062f\u0647";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "\u062e\u0637\u0627\u06cc \u0628\u0648\u0645\u06cc <code>StubRoutines::SafeFetch32</code> \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u062f\u0631 macOS \u0628\u0627 JDK 17.0.9 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f \u0648 \u062f\u0631 JDK 17.0.10 \u06cc\u0627 \u062c\u062f\u06cc\u062f\u062a\u0631 \u0631\u0641\u0639 \u0634\u062f\u0647 \u0627\u0633\u062a. https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "\u062e\u0637\u0627\u06cc \u0628\u0648\u0645\u06cc SafeFetch32 \u062f\u0631 JDK 17.0.9 (macOS)";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "JDK \u062e\u0648\u062f \u0631\u0627 \u0628\u0647 \u0646\u0633\u062e\u0647\u0654 17.0.10 \u06cc\u0627 \u0628\u0627\u0644\u0627\u062a\u0631 (\u0645\u062b\u0644\u0627\u064b 17.0.15) \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "\u0627\u06af\u0631 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0645\u0627\u0646\u0646\u062f MultiMC\u060c Prism Launcher \u06cc\u0627 TLauncher \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0622\u0646 \u0631\u0627 \u0637\u0648\u0631\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0627\u0632 JDK \u062c\u062f\u06cc\u062f\u062a\u0631\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u062f. \u0628\u0631\u062e\u06cc \u0627\u0632 \u0622\u0646\u200c\u0647\u0627 \u0627\u0632 \u067e\u06cc\u0634 JDK 17.0.15 \u0631\u0627 \u062f\u0627\u0631\u0646\u062f.";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u0654 Spark \u0646\u06cc\u0632 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u0627\u06cc\u0646 \u062e\u0637\u0627 \u06a9\u0645\u06a9 \u06a9\u0646\u062f. \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0631\u062f\u0646 \u0645\u0648\u0642\u062a \u0622\u0646 \u0631\u0627 \u062f\u0631 \u0646\u0638\u0631 \u0628\u06af\u06cc\u0631\u06cc\u062f. https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647\u0654 MCEF (Chromium Embedded Framework) \u0628\u0627\u0639\u062b \u0642\u0641\u0644 \u062e\u0627\u0645\u0648\u0634 \u0645\u06cc\u200c\u0634\u0648\u062f.</b><ul><li>MCEF \u062f\u0631 \u0627\u0646\u062a\u0647\u0627\u06cc \u0644\u0627\u06af\u200c\u0647\u0627 \u062f\u0631 \u062d\u0627\u0644 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0627\u0633\u062a \u06a9\u0647 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0646\u0634\u0627\u0646\u200c\u062f\u0647\u0646\u062f\u0647\u0654 \u0647\u064e\u0646\u06af \u0634\u062f\u0646 \u0628\u0627\u0632\u06cc \u062f\u0631 \u062d\u06cc\u0646 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0627\u0633\u062a.</li><li>\u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0627\u06cc\u062c\u0627\u062f crash \u062f\u0631 \u0633\u06cc\u0633\u062a\u0645\u200c\u0647\u0627\u06cc Linux\u060c macOS \u06cc\u0627 \u0628\u0627 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u062e\u0627\u0635\u06cc \u0627\u0632 Java \u0634\u0646\u0627\u062e\u062a\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a.</li><li>\u0647\u0645\u06cc\u0634\u0647 \u062e\u0637\u0627\u06cc \u0635\u0631\u06cc\u062d\u06cc \u0638\u0627\u0647\u0631 \u0646\u0645\u06cc\u200c\u0634\u0648\u062f\u060c \u0627\u0645\u0627 \u0628\u0627\u0632\u06cc \u0647\u0631\u06af\u0632 \u0628\u0647 \u0645\u0646\u0648\u06cc \u0627\u0635\u0644\u06cc \u0646\u0645\u06cc\u200c\u0631\u0633\u062f.</li></ul><p>\u0627\u06af\u0631 \u0628\u0647 \u0642\u0627\u0628\u0644\u06cc\u062a \u0645\u0631\u0648\u0631\u06af\u0631 \u062f\u0631\u0648\u0646\u200c\u0628\u0627\u0632\u06cc (\u0645\u062b\u0644 \u0646\u0642\u0634\u0647\u200c\u0647\u0627\u06cc \u0648\u0628 \u06cc\u0627 \u0635\u0641\u062d\u0627\u062a \u062c\u0627\u0633\u0627\u0632\u06cc\u200c\u0634\u062f\u0647) \u0646\u06cc\u0627\u0632 \u0646\u062f\u0627\u0631\u06cc\u062f\u060c \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "\u0645\u0634\u06a9\u0644 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc MCEF (\u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u0645\u0631\u0648\u0631\u06af\u0631 \u062c\u0627\u0633\u0627\u0632\u06cc\u200c\u0634\u062f\u0647)";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "\u0641\u0627\u06cc\u0644 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 MCEF (\u0641\u0627\u06cc\u0644\u06cc \u06a9\u0647 \u0646\u0627\u0645\u0634 \u0634\u0627\u0645\u0644 'mcef' \u0627\u0633\u062a) \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647\u0654 'mods' \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "\u0627\u06af\u0631 \u0648\u0627\u0642\u0639\u0627\u064b \u0628\u0647 \u0622\u0646 \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f\u060c \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u0627\u0632 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0628\u0627 \u0633\u06cc\u0633\u062a\u0645\u200c\u0639\u0627\u0645\u0644 \u0648 \u0646\u0633\u062e\u0647\u0654 Minecraft \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a.";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0639\u0627\u0631\u0636\u06cc \u0628\u06cc\u0646 <b>OptiFine</b> \u0648 <b>Iris/Oculus</b> \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a.</b><ul><li>OptiFine \u0631\u0646\u062f\u0631\u06cc\u0646\u06af Minecraft \u0631\u0627 \u0628\u0647 \u0634\u06cc\u0648\u0647\u200c\u0627\u06cc \u062a\u063a\u06cc\u06cc\u0631 \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0628\u0627 Iris \u06cc\u0627 Oculus \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a.</li><li>\u062e\u0637\u0627\u06cc <code>MixinLevelRenderer failed injection check</code> \u0627\u0632 <code>mixins.iris.json</code> \u06cc\u0627 <code>mixins.oculus.json</code> \u0646\u0634\u0623\u062a \u0645\u06cc\u200c\u06af\u06cc\u0631\u062f.</li></ul><p>\u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u0646\u062f \u0647\u0645\u0632\u0645\u0627\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u0648\u0646\u062f. \u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 shaders \u0628\u0627 Iris \u06cc\u0627 Oculus\u060c OptiFine \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u06cc\u0646 OptiFine \u0648 Iris/Oculus";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "\u0641\u0627\u06cc\u0644 OptiFine \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647\u0654 'mods' \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "\u0628\u0631\u0627\u06cc shaders \u0645\u062f\u0631\u0646\u060c Iris \u06cc\u0627 Oculus \u0631\u0627 \u0628\u062f\u0648\u0646 OptiFine \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062a\u0639\u0627\u0631\u0636\u06cc \u0628\u06cc\u0646 <b>ModernFix</b> \u0648 <b>OptiFine</b> \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a.</b><ul><li>ModernFix \u0628\u0627 OptiFine \u0633\u0627\u0632\u06af\u0627\u0631 \u0646\u06cc\u0633\u062a\u060c \u0632\u06cc\u0631\u0627 \u0639\u0645\u0644\u06a9\u0631\u062f\u0647\u0627\u06cc Forge \u0631\u0627 \u062e\u0631\u0627\u0628 \u06a9\u0631\u062f\u0647 \u0648 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0631\u0627 \u06a9\u0646\u062f \u0645\u06cc\u200c\u06a9\u0646\u062f.</li><li>\u062e\u0648\u062f ModernFix \u0647\u0634\u062f\u0627\u0631 \u0645\u06cc\u200c\u062f\u0647\u062f: <i>\"Use of ModernFix with OptiFine is not supported\"</i>.</li></ul><p>\u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u0635\u062d\u06cc\u062d \u0628\u0627\u0632\u06cc\u060c \u0628\u0627\u06cc\u062f \u06cc\u06a9\u06cc \u0627\u0632 \u0627\u06cc\u0646 \u062f\u0648 \u0627\u0641\u0632\u0648\u0646\u0647 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "\u062a\u0639\u0627\u0631\u0636 \u0628\u06cc\u0646 ModernFix \u0648 OptiFine";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "OptiFine \u06cc\u0627 ModernFix \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647\u0654 'mods' \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f. \u0627\u06cc\u0646 \u062f\u0648 \u0631\u0627 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646 \u0647\u0645\u0632\u0645\u0627\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0631\u062f.";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "\u0627\u06af\u0631 \u0628\u0647 \u0628\u0647\u06cc\u0646\u0647\u200c\u0633\u0627\u0632\u06cc \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u06cc\u062f\u060c \u0641\u0642\u0637 \u0627\u0632 OptiFine \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u06cc\u0627 ModernFix \u0631\u0627 \u0628\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0633\u0628\u06a9\u200c\u062a\u0631\u06cc \u0645\u0627\u0646\u0646\u062f FerriteCore \u06cc\u0627 EntityCulling \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627: \u06a9\u0644\u06cc\u062f \u062b\u0628\u062a \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0628\u0627 \u0646\u0648\u06cc\u0633\u0647\u200c\u0647\u0627\u06cc \u063a\u06cc\u0631\u0645\u062c\u0627\u0632.</b><ul><li><b>\u06a9\u0644\u06cc\u062f \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc\u200c\u0634\u062f\u0647:</b> <code>" + this.escapeHtml(clave) + "</code></li><li>\u062f\u0631 Minecraft\u060c \u062a\u0645\u0627\u0645 \u06a9\u0644\u06cc\u062f\u0647\u0627\u06cc \u062b\u0628\u062a (\u0628\u0631\u0686\u0633\u0628\u200c\u0647\u0627\u060c \u062f\u0633\u062a\u0648\u0631\u0647\u0627\u060c \u067e\u06cc\u0634\u0631\u0641\u062a\u200c\u0647\u0627 \u0648 \u063a\u06cc\u0631\u0647) \u0628\u0627\u06cc\u062f <b>\u06a9\u0648\u0686\u06a9\u200c\u0634\u062f\u0647</b> \u0628\u0627\u0634\u0646\u062f \u0648 \u062a\u0646\u0647\u0627 \u0627\u0632 \u062d\u0631\u0648\u0641\u060c \u0627\u0639\u062f\u0627\u062f\u060c \u0632\u06cc\u0631\u062e\u0637\u060c \u062e\u0637\u200c\u062a\u06cc\u0631\u0647 \u0648 \u0627\u0633\u0644\u0634 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u0646\u062f.</li><li>\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0647 \u062f\u0644\u06cc\u0644 \u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u0628\u062f\u06a9\u062f\u0646\u0648\u06cc\u0633\u06cc\u200c\u0634\u062f\u0647 \u06cc\u0627 \u06cc\u06a9 datapack \u0645\u0639\u06cc\u0648\u0628 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f.</li></ul><p><b>\u0646\u06a9\u062a\u0647\u0654 \u0645\u0647\u0645:</b> \u0627\u0632 \u0627\u0628\u0632\u0627\u0631 <b>grepr</b> \u06cc\u0627 <b>fgrepr</b> \u062f\u0631 \u0646\u0648\u0627\u0631 \u06a9\u0646\u0627\u0631\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f \u0648 \u06af\u0632\u06cc\u0646\u0647\u0654 <b>\u00ab\u062c\u0633\u062a\u062c\u0648 \u062f\u0631 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc JAR\u00bb</b> \u0631\u0627 \u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f \u062a\u0627 \u0645\u062a\u0648\u062c\u0647 \u0634\u0648\u06cc\u062f \u06a9\u062f\u0627\u0645 \u0627\u0641\u0632\u0648\u0646\u0647 \u0627\u06cc\u0646 \u06a9\u0644\u06cc\u062f \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0631\u0627 \u062f\u0627\u0631\u062f.</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "\u06a9\u0644\u06cc\u062f \u062b\u0628\u062a \u0628\u0627 \u062d\u0631\u0648\u0641 \u0628\u0632\u0631\u06af \u06cc\u0627 \u0646\u0648\u06cc\u0633\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "\u0627\u0632 'grepr' \u06cc\u0627 'fgrepr' \u0647\u0645\u0631\u0627\u0647 \u0628\u0627 \u00ab\u062c\u0633\u062a\u062c\u0648 \u062f\u0631 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc JAR\u00bb \u0628\u0631\u0627\u06cc \u06cc\u0627\u0641\u062a\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u0645\u0642\u0635\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "\u0627\u06af\u0631 \u0646\u062a\u0648\u0627\u0646\u0633\u062a\u06cc\u062f \u0627\u0641\u0632\u0648\u0646\u0647 \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0627\u062e\u06cc\u0631 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647\u200c\u0648\u06cc\u0698\u0647 \u0622\u0646\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0644\u0648\u06a9\u060c \u0622\u06cc\u062a\u0645 \u06cc\u0627 \u0627\u0628\u0632\u0627\u0631 \u0627\u0636\u0627\u0641\u0647 \u0645\u06cc\u200c\u06a9\u0646\u0646\u062f.";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627 \u062f\u0631 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0627\u0641\u0632\u0648\u0646\u0647\u0654 <b>" + this.escapeHtml(modNombre) + "</b>.</b><ul><li>\u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u062f\u0631 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06cc\u06a9\u06cc \u0627\u0632 \u0645\u0624\u0644\u0641\u0647\u200c\u0647\u0627\u06cc\u0634 (\u0645\u062b\u0644 \u0645\u0646\u0648\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc) \u0634\u06a9\u0633\u062a \u062e\u0648\u0631\u062f.</li><li>\u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0628\u0627 \u0646\u0633\u062e\u0647\u0654 Minecraft\u060c Fabric \u06cc\u0627 \u0633\u0627\u06cc\u0631 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f.</li></ul><p>\u0627\u06af\u0631 \u062e\u0637\u0627 \u0627\u062f\u0627\u0645\u0647 \u06cc\u0627\u0641\u062a\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u0654 <b>" + this.escapeHtml(modNombre) + "</b> \u0631\u0627 \u062d\u0630\u0641 \u06cc\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "\u062e\u0637\u0627\u06cc \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0627\u0641\u0632\u0648\u0646\u0647 (Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u0654 '" + modNombre + "' \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647\u0654 'mods' \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u0654 '" + modNombre + "' \u0631\u0627 \u0628\u0647 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0635\u0628 \u0634\u0645\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc\u06cc \u0645\u0631\u062a\u0628\u0637 \u0628\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 <b>En Garde!</b> \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><ul><li>\u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647 \u0645\u06a9\u0627\u0646\u06cc\u06a9\u200c\u0647\u0627\u06cc \u0631\u0632\u0645 \u0646\u0632\u062f\u06cc\u06a9 (\u0645\u062b\u0644 \u067e\u0631\u06cc\u060c \u0628\u0644\u0627\u06a9 \u0648 \u063a\u06cc\u0631\u0647) \u0631\u0627 \u0627\u0636\u0627\u0641\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f.</li><li>\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0628\u0627 \u0633\u0627\u06cc\u0631 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0631\u0632\u0645 (\u0645\u062b\u0644 Epic Fight\u060c DualRiders \u0648 \u063a\u06cc\u0631\u0647) \u06cc\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0646\u0633\u062e\u0647\u0654 \u0646\u0627\u0645\u0646\u0627\u0633\u0628 \u0628\u0631\u0627\u06cc Minecraft \u0634\u0645\u0627 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f.</li></ul><p>\u0627\u06af\u0631 \u0627\u0632 \u0633\u06cc\u0633\u062a\u0645 \u0631\u0632\u0645 \u067e\u06cc\u0634\u0631\u0641\u062a\u0647 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0646\u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0628\u0631\u0627\u06cc \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0627\u0632 \u062a\u062f\u0627\u062e\u0644\u060c En Garde! \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 En Garde!";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "\u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u06a9\u0647 \u0627\u0632 \u0646\u0633\u062e\u0647\u0654 En Garde! \u0633\u0627\u0632\u06af\u0627\u0631 \u0628\u0627 \u0646\u0633\u062e\u0647\u0654 Minecraft \u0648 \u0628\u0627\u0631\u06af\u0630\u0627\u0631 \u0634\u0645\u0627 (Fabric/Forge) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "\u0627\u06af\u0631 \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0631\u0632\u0645 \u062f\u06cc\u06af\u0631\u06cc (\u0645\u062b\u0644 Epic Fight\u060c Caelus \u0648 \u063a\u06cc\u0631\u0647) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0622\u0646\u200c\u0647\u0627 \u0631\u0627 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f \u06cc\u0627 En Garde! \u0631\u0627 \u062d\u0630\u0641 \u0646\u0645\u0627\u06cc\u06cc\u062f \u062a\u0627 \u0627\u0632 \u062a\u062f\u0627\u062e\u0644 \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0634\u0648\u062f.";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc\u06cc \u0646\u0627\u0634\u06cc \u0627\u0632 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 <b>IdleTweaks</b> \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><ul><li>IdleTweaks \u0633\u0639\u06cc \u06a9\u0631\u062f \u06a9\u0627\u0646\u0627\u0644 \u0634\u0628\u06a9\u0647\u200c\u0627\u06cc \u0631\u0627 \u0622\u0632\u0627\u062f \u06a9\u0646\u062f \u06a9\u0647 \u062f\u06cc\u06af\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f (<code>Tried to release unknown channel</code>).</li><li>\u0627\u06cc\u0646 \u062e\u0637\u0627 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0642\u062f\u06cc\u0645\u06cc \u0627\u0641\u0632\u0648\u0646\u0647 \u06cc\u0627 \u0647\u0646\u06af\u0627\u0645 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u062f\u0631 \u0633\u0631\u0648\u0631\u0647\u0627\u06cc \u0628\u062f\u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc\u200c\u0634\u062f\u0647 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f.</li></ul><p>IdleTweaks \u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u0631\u0641\u0627\u0647\u06cc \u0627\u0633\u062a\u060c \u0627\u0645\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627\u0639\u062b \u0646\u0627\u067e\u0627\u06cc\u062f\u0627\u0631\u06cc \u0634\u0648\u062f. \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06cc\u0627 \u062d\u0630\u0641 \u0622\u0646 \u0631\u0627 \u062f\u0631 \u0646\u0638\u0631 \u0628\u06af\u06cc\u0631\u06cc\u062f.</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "\u062e\u0637\u0627\u06cc IdleTweaks (\u06a9\u0627\u0646\u0627\u0644 \u0634\u0628\u06a9\u0647\u0654 \u0646\u0627\u0634\u0646\u0627\u062e\u062a\u0647)";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "IdleTweaks \u0631\u0627 \u0628\u0647 \u062c\u062f\u06cc\u062f\u062a\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647\u200c\u0627\u06cc \u06a9\u0647 \u0628\u0627 Minecraft \u0634\u0645\u0627 \u0633\u0627\u0632\u06af\u0627\u0631 \u0627\u0633\u062a\u060c \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "\u0627\u06af\u0631 \u0628\u0647 \u0622\u0646 \u0646\u06cc\u0627\u0632\u06cc \u0646\u062f\u0627\u0631\u06cc\u062f\u060c IdleTweaks \u0631\u0627 \u0627\u0632 \u067e\u0648\u0634\u0647\u0654 'mods' \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0627\u062d\u0631\u0627\u0632 \u0647\u0648\u06cc\u062a (HTTP 401) \u0647\u0646\u06af\u0627\u0645 \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u0648\u0631\u0648\u062f \u0628\u0647 Minecraft \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><p>\u0627\u06cc\u0646 \u062e\u0637\u0627 <b>\u0628\u0647 \u0646\u062f\u0631\u062a \u0639\u0644\u062a \u0645\u0633\u062a\u0642\u06cc\u0645 crash \u0627\u0633\u062a</b>\u060c \u0627\u0645\u0627 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0627\u0632 \u06cc\u06a9 \u062d\u0633\u0627\u0628 \u063a\u06cc\u0631\u0645\u062c\u0627\u0632 (\u0646\u0633\u062e\u0647\u0654 \u063a\u06cc\u0631\u0642\u0627\u0646\u0648\u0646\u06cc) \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.</p><p>\u06a9\u0627\u0646\u0627\u0644\u200c\u0647\u0627\u06cc \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0631\u0633\u0645\u06cc (\u067e\u0631\u0648\u0698\u0647\u200c\u0647\u0627\u06cc \u0634\u0631\u06a9\u062a\u06cc\u060c VTuber\u0647\u0627\u060c \u0633\u0627\u0632\u0646\u062f\u06af\u0627\u0646 modpack \u0648 \u063a\u06cc\u0631\u0647) <b>\u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u0646\u062f \u0628\u0647 \u0634\u0645\u0627 \u06a9\u0645\u06a9 \u06a9\u0646\u0646\u062f</b> \u0627\u06af\u0631 \u0627\u0632 \u0646\u0633\u062e\u0647\u0654 \u063a\u06cc\u0631\u0642\u0627\u0646\u0648\u0646\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u062f\u0644\u06cc\u0644 \u0645\u062d\u062f\u0648\u062f\u06cc\u062a\u200c\u0647\u0627\u06cc \u0642\u0648\u0627\u0646\u06cc\u0646 \u0686\u062a\u060c \u0642\u0631\u0627\u0631\u062f\u0627\u062f\u0647\u0627\u060c \u062a\u0648\u0627\u0641\u0642\u0627\u062a \u0628\u0627 Mojang/Microsoft \u06cc\u0627 \u0633\u06cc\u0627\u0633\u062a\u200c\u0647\u0627\u06cc \u0627\u0639\u062a\u0628\u0627\u0631.</p><p>\u0627\u06cc\u0646 \u0628\u0631\u0631\u0633\u06cc \u0631\u0627 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646 \u062f\u0631 <b>\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0634\u0631\u06a9\u062a\u06cc</b> \u062a\u0634\u062e\u06cc\u0635\u200c\u062f\u0647\u0646\u062f\u0647 \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u06a9\u0631\u062f. \u0627\u062e\u0637\u0627\u0631: \u0633\u06cc\u0633\u062a\u0645 \u062a\u0634\u062e\u06cc\u0635 \u063a\u06cc\u0631\u0642\u0627\u0646\u0648\u0646\u06cc \u0628\u0648\u062f\u0646 <b>\u06a9\u0627\u0645\u0644 \u0646\u06cc\u0633\u062a</b> \u0648 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u062f\u0631 \u0645\u062d\u06cc\u0637\u200c\u0647\u0627\u06cc \u062a\u0648\u0633\u0639\u0647\u060c \u0628\u0627 \u0627\u06cc\u0646\u062a\u0631\u0646\u062a \u0646\u0627\u067e\u0627\u06cc\u062f\u0627\u0631 \u06cc\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u0627\u0635\u0644\u0627\u062d\u200c\u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>\u062d\u0642\u0648\u0642 \u0645\u06cc\u0631\u0627\u0646\u062f\u0627 \u062f\u0631 \u0635\u0648\u0631\u062a \u062a\u0644\u0627\u0634 \u0628\u0631\u0627\u06cc \u067e\u06cc\u0648\u0633\u062a\u0646 \u0628\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0628\u0627 \u0648\u062c\u0648\u062f \u0627\u06cc\u0646 \u0647\u0634\u062f\u0627\u0631:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "Minecraft \u063a\u06cc\u0631\u0642\u0627\u0646\u0648\u0646\u06cc";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "\u063a\u06cc\u0631\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u0628\u0631\u0631\u0633\u06cc \u063a\u06cc\u0631\u0642\u0627\u0646\u0648\u0646\u06cc \u0628\u0648\u062f\u0646";
    }

    @Override
    public String comprarMC() {
        return "\u062e\u0631\u06cc\u062f Minecraft";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0634\u0645\u0627 \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 <code>" + id + "</code> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f \u06a9\u0647 <b>\u062f\u0631 \u0644\u06cc\u0633\u062a \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u0646\u06cc\u0633\u062a</b>.</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>\u0627\u06af\u0631\u0686\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u06a9\u0627\u0631 \u06a9\u0646\u062f\u060c \u0627\u0645\u0627 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u063a\u06cc\u0631\u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0627\u0639\u062b \u0645\u06cc\u200c\u0634\u0648\u0646\u062f:</p><ul><li>\u0646\u0635\u0628\u200c\u0647\u0627\u06cc \u062e\u0631\u0627\u0628\u200c\u0634\u062f\u0647\u0654 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u06cc\u0627 \u0627\u067e\u0644\u06cc\u06a9\u06cc\u0634\u0646.</li><li>\u0628\u0627\u0632\u06cc \u0634\u0631\u0648\u0639 \u0646\u0634\u0648\u062f \u06cc\u0627 \u0628\u062f\u0648\u0646 \u062e\u0637\u0627\u06cc \u0645\u0634\u062e\u0635 \u0647\u064e\u0646\u06af \u06a9\u0646\u062f.</li><li>\u0633\u0627\u062e\u062a\u0627\u0631 \u063a\u06cc\u0631\u0645\u0639\u0645\u0648\u0644 \u067e\u0648\u0634\u0647\u200c\u0647\u0627 (\u062a\u0634\u062e\u06cc\u0635 \u0631\u0627 \u062f\u0634\u0648\u0627\u0631 \u0645\u06cc\u200c\u06a9\u0646\u062f).</li><li>\u0631\u0641\u062a\u0627\u0631 \u063a\u06cc\u0631\u0642\u0627\u0628\u0644\u200c\u067e\u06cc\u0634\u200c\u0628\u06cc\u0646\u06cc \u0628\u0627 \u062c\u0627\u0648\u0627\u060c \u062d\u0627\u0641\u0638\u0647 \u06cc\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627.</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "\u0628\u0631\u0627\u06cc \u062a\u062c\u0631\u0628\u0647\u0654 \u0628\u0647\u062a\u0631\u060c \u06cc\u06a9\u06cc \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647\u0654 \u0632\u06cc\u0631 \u0631\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u06cc\u062f:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u063a\u06cc\u0631\u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "\u0628\u0647 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0627\u0632 \u0644\u06cc\u0633\u062a \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0634\u0645\u0627 \u0627\u0632 \u06cc\u06a9 <b>\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0646\u0627\u0645\u0646\u0627\u0633\u0628</b> \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627\u0639\u062b \u0634\u0648\u0646\u062f:</p><ul><li>\u0646\u0635\u0628\u200c\u0647\u0627\u06cc \u062e\u0631\u0627\u0628\u200c\u0634\u062f\u0647\u0654 \u0627\u067e\u0644\u06cc\u06a9\u06cc\u0634\u0646 \u06cc\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627.</li><li>\u0628\u0627\u0632\u06cc \u0634\u0631\u0648\u0639 \u0646\u0634\u0648\u062f \u06cc\u0627 \u0628\u0647\u200c\u0635\u0648\u0631\u062a \u0633\u0627\u06a9\u062a \u0634\u06a9\u0633\u062a \u0628\u062e\u0648\u0631\u062f.</li><li>\u0633\u0627\u0632\u0645\u0627\u0646\u200c\u062f\u0647\u06cc \u063a\u06cc\u0631\u0645\u0639\u0645\u0648\u0644 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 (\u0627\u0634\u06a9\u0627\u0644\u200c\u0632\u062f\u0627\u06cc\u06cc \u0631\u0627 \u062f\u0634\u0648\u0627\u0631 \u0645\u06cc\u200c\u06a9\u0646\u062f).</li><li>\u0639\u062f\u0645 \u0627\u0637\u0645\u06cc\u0646\u0627\u0646 \u0627\u0632 \u0646\u062d\u0648\u0647\u0654 \u0645\u062f\u06cc\u0631\u06cc\u062a \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u060c \u062c\u0627\u0648\u0627 \u06cc\u0627 \u062d\u0627\u0641\u0638\u0647 \u062a\u0648\u0633\u0637 \u0622\u0646.</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u06cc\u06a9\u06cc \u0627\u0632 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u0632\u06cc\u0631 \u0628\u0647\u200c\u0634\u062f\u062a \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "\u0628\u0631\u0627\u06cc \u062f\u0631\u06cc\u0627\u0641\u062a \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc\u060c \u0628\u0647 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u062a\u063a\u06cc\u06cc\u0631 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0628\u0631\u0627\u06cc \u0627\u06cc\u0646 \u0645\u062d\u06cc\u0637\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u0646\u062f.</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u06af\u0645 \u0634\u062f\u0647\u200c\u0627\u0646\u062f";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "\u0628\u0631\u0627\u06cc \u062a\u062c\u0631\u0628\u0647\u0654 \u0628\u0647\u06cc\u0646\u0647\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u0631\u0627 \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628 \u062f\u0631 \u0646\u0635\u0628 \u0634\u0645\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0646\u062f.</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f\u0646\u062f";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "\u0628\u0631\u0627\u06cc \u062c\u0644\u0648\u06af\u06cc\u0631\u06cc \u0627\u0632 \u0645\u0634\u06a9\u0644\u0627\u062a\u060c \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u062f\u0633\u062a\u06a9\u0627\u0631\u06cc \u063a\u06cc\u0631\u0645\u062c\u0627\u0632 \u062f\u0631 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u062d\u06cc\u0627\u062a\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f. \u06cc\u0627 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0631\u0627 \u062f\u0633\u062a\u06cc \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0631\u062f\u0647\u200c\u0627\u06cc\u062f \u06cc\u0627 \u0627\u0632 \u06cc\u06a9 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "\u062f\u0633\u062a\u06a9\u0627\u0631\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "\u0628\u0631\u0627\u06cc \u0628\u0627\u0632\u06af\u0631\u062f\u0627\u0646\u062f\u0646 \u06cc\u06a9\u067e\u0627\u0631\u0686\u06af\u06cc\u060c \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0627\u0635\u0644\u06cc \u0631\u0627 \u0645\u062c\u062f\u062f\u0627\u064b \u0646\u0635\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String configuracionCorporativa() {
        return "\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0634\u0631\u06a9\u062a\u06cc";
    }

    @Override
    public String idiomaRespaldo() {
        return "\u0632\u0628\u0627\u0646 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646";
    }

    @Override
    public String buscardorHabilitado() {
        return "\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u062c\u0633\u062a\u062c\u0648\u06af\u0631";
    }

    @Override
    public String nombreHerramienta() {
        return "\u0646\u0627\u0645 \u0627\u0628\u0632\u0627\u0631";
    }

    @Override
    public String condenarPirateria() {
        return "\u0645\u062d\u06a9\u0648\u0645\u06cc\u062a \u062f\u0632\u062f\u06cc \u0646\u0631\u0645\u200c\u0627\u0641\u0632\u0627\u0631\u06cc";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String modsRecomendados() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647";
    }

    @Override
    public String modsDesaconsejados() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String antiTamper() {
        return "\u0636\u062f \u062f\u0633\u062a\u06a9\u0627\u0631\u06cc";
    }

    @Override
    public String proximamente() {
        return "\u0628\u0647 \u0632\u0648\u062f\u06cc";
    }

    @Override
    public String informacion() {
        return "\u0627\u0637\u0644\u0627\u0639\u0627\u062a";
    }

    @Override
    public String errorCargandoImagen() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062a\u0635\u0648\u06cc\u0631";
    }

    @Override
    public String configuracionBasica() {
        return "\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u067e\u0627\u06cc\u0647";
    }

    @Override
    public String funcionalidades() {
        return "\u0627\u0645\u06a9\u0627\u0646\u0627\u062a";
    }

    @Override
    public String derechosMiranda() {
        return "\u062d\u0642\u0648\u0642 \u0645\u06cc\u0631\u0627\u0646\u062f\u0627 (\u0628\u0647\u200c\u0634\u062f\u062a \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f)";
    }

    @Override
    public String gestionVerificaciones() {
        return "\u0645\u062f\u06cc\u0631\u06cc\u062a \u062a\u0623\u06cc\u06cc\u062f\u0647\u0627";
    }

    @Override
    public String idVerificacion() {
        return "\u0634\u0646\u0627\u0633\u0647";
    }

    @Override
    public String nombreVerificacion() {
        return "\u0646\u0627\u0645";
    }

    @Override
    public String codigoVerificacion() {
        return "\u06a9\u062f";
    }

    @Override
    public String documentacionVerificacion() {
        return "\u0645\u0633\u062a\u0646\u062f\u0627\u062a";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "\u062a\u0623\u06cc\u06cc\u062f\u0647\u0627\u06cc \u0641\u0639\u0627\u0644\u200c\u0634\u062f\u0647:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "\u062a\u0623\u06cc\u06cc\u062f\u0647\u0627\u06cc \u063a\u06cc\u0631\u0641\u0639\u0627\u0644\u200c\u0634\u062f\u0647:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "\u063a\u06cc\u0631\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u0647\u0645\u0647\u0654 \u0645\u0648\u0627\u0631\u062f \u063a\u06cc\u0631\u0634\u0631\u06a9\u062a\u06cc";
    }

    @Override
    public String verCodigo() {
        return "\u0645\u0634\u0627\u0647\u062f\u0647\u0654 \u06a9\u062f";
    }

    @Override
    public String verDocumentacion() {
        return "\u0645\u0634\u0627\u0647\u062f\u0647\u0654 \u0645\u0633\u062a\u0646\u062f\u0627\u062a";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "\u062a\u0623\u06cc\u06cc\u062f\u06cc \u0631\u0627 \u0628\u0631\u0627\u06cc \u063a\u06cc\u0631\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "\u062a\u0623\u06cc\u06cc\u062f\u06cc \u0631\u0627 \u0628\u0631\u0627\u06cc \u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "%d \u062a\u0623\u06cc\u06cc\u062f \u06a9\u0647 \u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647\u0654 \u0634\u0631\u06a9\u062a\u06cc \u062a\u0648\u0635\u06cc\u0647 \u0646\u0645\u06cc\u200c\u0634\u0648\u0646\u062f\u060c \u063a\u06cc\u0631\u0641\u0639\u0627\u0644 \u0634\u062f\u0646\u062f.";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "\u062a\u0623\u06cc\u06cc\u062f \u063a\u06cc\u0631\u0634\u0631\u06a9\u062a\u06cc \u0628\u0631\u0627\u06cc \u063a\u06cc\u0631\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.";
    }

    @Override
    public String operacionCompletada() {
        return "\u0639\u0645\u0644\u06cc\u0627\u062a \u06a9\u0627\u0645\u0644 \u0634\u062f";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "\u0645\u0627 \u062a\u0648 \u0631\u0627 \u062f\u0648\u0633\u062a \u062f\u0627\u0631\u06cc\u0645\u060c Amane Kanata";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "\u0631\u0646\u06af \u062a\u0623\u06cc\u06cc\u062f \u0634\u0631\u06a9\u062a\u06cc";
    }

    @Override
    public String nombreLanzador() {
        return "\u0646\u0627\u0645 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632";
    }

    @Override
    public String motivo() {
        return "\u062f\u0644\u06cc\u0644";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String moverADesaconsejados() {
        return "\u063a\u06cc\u0631\u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u06a9\u0631\u062f\u0646";
    }

    @Override
    public String moverARecomendados() {
        return "\u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647 \u06a9\u0631\u062f\u0646";
    }

    @Override
    public String guardarCambios() {
        return "\u0630\u062e\u06cc\u0631\u0647\u0654 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a";
    }

    @Override
    public String cancelar() {
        return "\u0644\u063a\u0648";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "\u0644\u0637\u0641\u0627\u064b \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0631\u0627 \u0628\u0631\u0627\u06cc \u062c\u0627\u0628\u0647\u200c\u062c\u0627\u06cc\u06cc \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f!";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "\u062f\u0644\u0627\u06cc\u0644";
    }

    @Override
    public String agregarLanzador() {
        return "\u0627\u0641\u0632\u0648\u062f\u0646 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632";
    }

    @Override
    public String quitarLanzador() {
        return "\u062d\u0630\u0641 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632";
    }

    @Override
    public String editarRazones() {
        return "\u0648\u06cc\u0631\u0627\u06cc\u0634 \u062f\u0644\u0627\u06cc\u0644";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0631\u0627 \u0628\u0631\u0627\u06cc \u062d\u0630\u0641 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0631\u0627 \u0628\u0631\u0627\u06cc \u0648\u06cc\u0631\u0627\u06cc\u0634 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return "\u0648\u06cc\u0631\u0627\u06cc\u0634 \u062f\u0644\u0627\u06cc\u0644 \u0628\u0631\u0627\u06cc " + idLanzador;
    }

    @Override
    public String agregarNuevoIdioma() {
        return "\u0627\u0641\u0632\u0648\u062f\u0646 \u0632\u0628\u0627\u0646 \u062c\u062f\u06cc\u062f";
    }

    @Override
    public String aceptar() {
        return "\u062a\u0623\u06cc\u06cc\u062f";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "\u0632\u0628\u0627\u0646 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u06a9\u0646\u06cc\u062f";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "\u0627\u06cc\u0646 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627 \u0647\u0645\u0627\u0646\u200c\u0647\u0627\u06cc\u06cc \u0647\u0633\u062a\u0646\u062f \u06a9\u0647 CrashDetector \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627\u06cc \u062e\u0648\u0628 \u067e\u06cc\u0634\u0646\u0647\u0627\u062f \u0645\u06cc\u200c\u06a9\u0646\u062f.";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "\u0646\u062a\u06cc\u062c\u0647\u0654 \u0635\u062d\u06cc\u062d";
    }

    @Override
    public String modsNoRecomendados() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String agregarMod() {
        return "\u0627\u0641\u0632\u0648\u062f\u0646 \u0627\u0641\u0632\u0648\u0646\u0647";
    }

    @Override
    public String quitarMod() {
        return "\u062d\u0630\u0641 \u0627\u0641\u0632\u0648\u0646\u0647";
    }

    @Override
    public String modId() {
        return "\u0634\u0646\u0627\u0633\u0647\u0654 \u0627\u0641\u0632\u0648\u0646\u0647 / \u0646\u0627\u0645 JBoss Modules";
    }

    @Override
    public String rutaMod() {
        return "\u0645\u0633\u06cc\u0631 / \u0641\u0627\u06cc\u0644 \u0627\u0641\u0632\u0648\u0646\u0647";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "\u0628\u0627\u06cc\u062f \u062d\u062f\u0627\u0642\u0644 \u0634\u0646\u0627\u0633\u0647\u0654 \u0627\u0641\u0632\u0648\u0646\u0647 \u06cc\u0627 \u0645\u0633\u06cc\u0631 \u0622\u0646 \u0631\u0627 \u0645\u0634\u062e\u0635 \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "\u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628 \u0631\u0627 \u062b\u0628\u062a \u06a9\u0646\u06cc\u062f \u062a\u0627 CrashDetector \u062f\u0631 \u0635\u0648\u0631\u062a \u0646\u0635\u0628 \u0628\u0648\u062f\u0646 \u0622\u0646\u200c\u0647\u0627\u060c \u0622\u0646\u200c\u0647\u0627 \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0646\u062f.";
    }

    @Override
    public String anularNormal() {
        return "\u0644\u063a\u0648 \u062d\u0627\u0644\u062a \u0639\u0627\u062f\u06cc";
    }

    @Override
    public String anularNormalDescripcion() {
        return "CrashDetector \u0628\u0627\u06cc\u062f \u062d\u062a\u06cc \u0627\u06af\u0631 crash \u0648\u0627\u0642\u0639\u06cc \u0631\u062e \u0646\u062f\u0647\u062f\u060c \u0647\u0634\u062f\u0627\u0631 \u062f\u0647\u062f.";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u0631\u0627 \u06a9\u0647 CrashDetector \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f \u062b\u0628\u062a \u06a9\u0646\u06cc\u062f. \u0627\u06af\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u0646\u062f\u060c CrashDetector \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0647\u0634\u062f\u0627\u0631 \u062f\u0647\u062f.";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "\u0627\u06af\u0631 \u062a\u0635\u0645\u06cc\u0645 \u06af\u0631\u0641\u062a\u06cc\u062f \u0647\u0634\u062f\u0627\u0631 \u0636\u062f \u062f\u0632\u062f\u06cc \u0646\u0631\u0645\u200c\u0627\u0641\u0632\u0627\u0631\u06cc \u0631\u0627 \u0641\u0639\u0627\u0644 \u06a9\u0646\u06cc\u062f\u060c \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u06cc\u06a9 \u0627\u0642\u062f\u0627\u0645 \u067e\u06cc\u0634\u06af\u06cc\u0631\u0627\u0646\u0647 \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f \u062d\u0642\u0648\u0642 \u0641\u0631\u062f \u062f\u0631\u062e\u0648\u0627\u0633\u062a\u200c\u06a9\u0646\u0646\u062f\u0647\u0654 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0631\u0627 \u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u062a\u0639\u0631\u06cc\u0641 \u06a9\u0646\u06cc\u062f.\n\n\u0628\u0631\u062e\u0644\u0627\u0641 \u0628\u0627\u0648\u0631 \u0631\u0627\u06cc\u062c\u060c \u0628\u0633\u06cc\u0627\u0631\u06cc \u0627\u0632 \u062c\u0648\u0627\u0645\u0639 \u0648 \u06a9\u0627\u0646\u0627\u0644\u200c\u0647\u0627\u06cc \u0645\u062d\u0628\u0648\u0628 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0628\u0631\u0627\u06cc \u0627\u0631\u0627\u0626\u0647\u0654 \u06a9\u0645\u06a9\u060c \u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u0647\u0634\u062f\u0627\u0631\u0647\u0627\u06cc \u0636\u062f \u062f\u0632\u062f\u06cc \u0631\u0627 \u0627\u0644\u0632\u0627\u0645\u06cc \u0646\u0645\u06cc\u200c\u062f\u0627\u0646\u0646\u062f. \u0628\u0627 \u0627\u06cc\u0646 \u062d\u0627\u0644\u060c \u0645\u0633\u062a\u0646\u062f\u0633\u0627\u0632\u06cc \u0627\u06cc\u0646 \u062d\u0642\u0648\u0642 \u062f\u0631 \u0635\u0648\u0631\u062a\u06cc \u06a9\u0647 \u0641\u0631\u062f\u06cc \u0628\u0647 \u0647\u0631 \u062d\u0627\u0644 \u0628\u0647 \u06a9\u0627\u0646\u0627\u0644 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u062f\u0633\u062a\u0631\u0633\u06cc \u067e\u06cc\u062f\u0627 \u06a9\u0646\u062f\u060c \u0645\u0641\u06cc\u062f \u062e\u0648\u0627\u0647\u062f \u0628\u0648\u062f.\n\n\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0627\u0632 \u0633\u0646\u062f \u0631\u0633\u0645\u06cc \u0645\u0627\u0646\u0646\u062f \u00ab\u06a9\u062a\u0627\u0628\u0686\u0647\u0654 \u062d\u0642\u0648\u0642 \u067e\u0627\u06cc\u0647\u0654 \u0628\u0627\u0632\u062f\u0627\u0634\u062a\u200c\u0634\u062f\u0647\u00bb \u062f\u0631 \u0645\u06a9\u0632\u06cc\u06a9 \u0627\u0644\u0647\u0627\u0645 \u0628\u06af\u06cc\u0631\u06cc\u062f:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\n\u0647\u0645\u0686\u0646\u06cc\u0646 \u0627\u0632 \u0627\u0635\u0648\u0644 \u062d\u0642\u0648\u0642\u06cc \u0645\u0634\u0627\u0628\u0647\u06cc \u06a9\u0647 \u062f\u0631 \u06a9\u0634\u0648\u0631\u0647\u0627\u06cc \u062f\u06cc\u06af\u0631 \u0627\u0632 \u062c\u0645\u0644\u0647 \u0627\u06cc\u0627\u0644\u0627\u062a \u0645\u062a\u062d\u062f\u0647\u060c \u0641\u062f\u0631\u0627\u0633\u06cc\u0648\u0646 \u0631\u0648\u0633\u06cc\u0647\u060c \u062c\u0645\u0647\u0648\u0631\u06cc \u062e\u0644\u0642 \u0686\u06cc\u0646\u060c \u062c\u0645\u0647\u0648\u0631\u06cc \u0627\u0633\u0644\u0627\u0645\u06cc \u0627\u06cc\u0631\u0627\u0646 \u0648 \u062c\u0645\u0647\u0648\u0631\u06cc \u062f\u0645\u0648\u06a9\u0631\u0627\u062a\u06cc\u06a9 \u062e\u0644\u0642 \u06a9\u0631\u0647 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f.\n\n\u0646\u0645\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u0627\u0632 \u062d\u0642\u0648\u0642\u06cc \u06a9\u0647 \u0645\u06cc\u200c\u062a\u0648\u0627\u0646 \u062f\u0631 \u0646\u0638\u0631 \u06af\u0631\u0641\u062a \u0639\u0628\u0627\u0631\u062a\u0646\u062f \u0627\u0632:\n\u2022 \u062d\u0642 \u0639\u062f\u0645 \u0627\u0631\u0627\u0626\u0647\u0654 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u063a\u06cc\u0631\u0636\u0631\u0648\u0631\u06cc \u0628\u0631\u0627\u06cc \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc\u060c \u0645\u0627\u0646\u0646\u062f \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632 \u0627\u0633\u062a\u0641\u0627\u062f\u0647\u200c\u0634\u062f\u0647\u060c \u0646\u0627\u0645 \u06a9\u0627\u0631\u0628\u0631\u06cc \u06cc\u0627 UUID.\n\u2022 \u062d\u0642 \u0639\u062f\u0645 \u062e\u0648\u062f\u0627\u062a\u0647\u0627\u0645.\n\u2022 \u062d\u0642 \u0631\u062f \u067e\u0627\u0633\u062e \u0628\u0647 \u0633\u0624\u0627\u0644\u0627\u062a\u06cc \u06a9\u0647 \u0628\u0631\u0627\u06cc \u062d\u0644 \u0645\u0634\u06a9\u0644 \u0636\u0631\u0648\u0631\u06cc \u0646\u06cc\u0633\u062a\u0646\u062f.\n\u2022 \u062d\u0642 \u062f\u0631\u06cc\u0627\u0641\u062a \u0631\u0627\u0647\u0646\u0645\u0627\u06cc\u06cc \u062f\u0631\u0648\u0646 \u0686\u062a.\n\u2022 \u062d\u0642 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0642\u0627\u0628\u0644\u06cc\u062a \u0646\u0627\u0634\u0646\u0627\u0633\u200c\u0633\u0627\u0632\u06cc \u0644\u0627\u06af\u200c\u0647\u0627\u06cc \u062f\u0627\u062e\u0644\u06cc CrashDetector.\n\n\u0627\u06cc\u0646 \u0645\u062a\u0646 \u0627\u0632 \u0645\u062d\u062a\u0648\u0627\u06cc HTML \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f.";
    }

    @Override
    public String editar() {
        return "\u0648\u06cc\u0631\u0627\u06cc\u0634";
    }

    @Override
    public String advertenciaHashLento() {
        return "\u0647\u0634\u062f\u0627\u0631: \u0627\u0641\u0632\u0648\u062f\u0646 \u062a\u0639\u062f\u0627\u062f \u0632\u06cc\u0627\u062f\u06cc \u0641\u0627\u06cc\u0644 \u0628\u0632\u0631\u06af \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627\u0639\u062b \u0634\u0648\u062f \u0628\u0631\u0631\u0633\u06cc \u0686\u0646\u062f \u062f\u0642\u06cc\u0642\u0647 \u0637\u0648\u0644 \u0628\u06a9\u0634\u062f. CrashDetector \u0628\u0627\u06cc\u062f \u0642\u0628\u0644 \u0627\u0632 \u0627\u062f\u0627\u0645\u0647\u060c \u0647\u0634 \u0647\u0631 \u0641\u0627\u06cc\u0644 \u0631\u0627 \u0645\u062d\u0627\u0633\u0628\u0647 \u06a9\u0646\u062f. \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f \u062a\u0646\u0647\u0627 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627\u06cc \u0636\u0631\u0648\u0631\u06cc \u0631\u0627 \u0645\u062d\u0627\u0641\u0638\u062a \u06a9\u0646\u06cc\u062f.";
    }

    @Override
    public String agregarArchivo() {
        return "\u0627\u0641\u0632\u0648\u062f\u0646 \u0641\u0627\u06cc\u0644";
    }

    @Override
    public String agregarCarpeta() {
        return "\u0627\u0641\u0632\u0648\u062f\u0646 \u067e\u0648\u0634\u0647";
    }

    @Override
    public String quitar() {
        return "\u062d\u0630\u0641";
    }

    @Override
    public String rutaArchivo() {
        return "\u0645\u0633\u06cc\u0631 \u0641\u0627\u06cc\u0644";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "\u0645\u0633\u06cc\u0631 \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647 \u062e\u0627\u0631\u062c \u0627\u0632 \u062f\u0627\u06cc\u0631\u06a9\u062a\u0648\u0631\u06cc \u0641\u0639\u0644\u06cc \u0628\u0627\u0632\u06cc \u0627\u0633\u062a. \u062a\u0646\u0647\u0627 \u0641\u0627\u06cc\u0644\u200c\u0647\u0627 \u0648 \u067e\u0648\u0634\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u062f\u0631 \u062f\u0627\u06cc\u0631\u06a9\u062a\u0648\u0631\u06cc \u0641\u0639\u0644\u06cc \u06cc\u0627 \u0632\u06cc\u0631\u067e\u0648\u0634\u0647\u200c\u0647\u0627\u06cc \u0622\u0646 \u0642\u0631\u0627\u0631 \u062f\u0627\u0631\u0646\u062f\u060c \u0645\u062c\u0627\u0632 \u0647\u0633\u062a\u0646\u062f.";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>\u0646\u0638\u0631\u0627\u062a \u0648 \u062a\u0648\u0636\u06cc\u062d\u0627\u062a Sylent Bell \u0644\u0632\u0648\u0645\u0627\u064b \u0628\u0627 \u0645\u0627 \u0647\u0645\u200c\u062e\u0648\u0627\u0646\u06cc \u0646\u062f\u0627\u0631\u062f\u061b \u0641\u0642\u0637 \u0641\u06a9\u0631 \u06a9\u0631\u062f\u06cc\u0645 \u062c\u0627\u0644\u0628 \u0628\u0627\u0634\u062f \u06a9\u0647 \u0627\u0648 \u0631\u0627 \u0627\u06cc\u0646\u062c\u0627 \u0628\u06af\u0630\u0627\u0631\u06cc\u0645. CrashDetector \u0633\u06a9\u0648\u0644\u0627\u0631 \u0627\u0633\u062a.</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0627\u0641\u0632\u0648\u0646\u0647\u0654 GML (Groovy ModLoader) \u0628\u0647 \u0627\u06cc\u0646 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0646\u06cc\u0627\u0632 \u062f\u0627\u0631\u062f \u0648 \u0631\u0627\u06cc\u062c\u200c\u062a\u0631\u06cc\u0646 \u0645\u0646\u0634\u0623 \u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0627\u0633\u062a.</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 <i>Flywheel</i> \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><p><b>Flywheel \u0645\u0646\u0633\u0648\u062e\u200c\u0634\u062f\u0647 (deprecated) \u0627\u0633\u062a</b> \u0648 \u0646\u0628\u0627\u06cc\u062f \u062f\u0631 \u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0645\u062f\u0631\u0646 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u0648\u062f.</p><p>\u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u0641\u0639\u0644\u06cc <b>Create</b> <b>\u0627\u0632 \u067e\u06cc\u0634 Flywheel \u0631\u0627 \u0634\u0627\u0645\u0644 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f</b>\u060c \u0628\u0646\u0627\u0628\u0631\u0627\u06cc\u0646 \u0646\u0635\u0628 \u062c\u062f\u0627\u06af\u0627\u0646\u0647\u0654 \u0622\u0646 \u0628\u0627\u0639\u062b \u062a\u062f\u0627\u062e\u0644 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0648 \u062e\u0637\u0627\u0647\u0627\u06cc \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0645\u06cc\u200c\u0634\u0648\u062f.</p><p>\u0628\u0631\u062e\u06cc \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0647\u200c\u0635\u0648\u0631\u062a \u0635\u0631\u06cc\u062d \u0628\u0647 Flywheel \u0648\u0627\u0628\u0633\u062a\u0647\u200c\u0627\u0646\u062f \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a <b>\u06a9\u0627\u0631 \u0646\u06a9\u0646\u0646\u062f</b> \u06cc\u0627 <b>\u0646\u0627\u067e\u0627\u06cc\u062f\u0627\u0631 \u0639\u0645\u0644 \u06a9\u0646\u0646\u062f</b>. \u062f\u0631 \u0628\u0631\u062e\u06cc \u0645\u0648\u0627\u0631\u062f \u067e\u06cc\u0634\u0631\u0641\u062a\u0647\u060c \u0627\u06cc\u0646 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0627 <b>\u0648\u06cc\u0631\u0627\u06cc\u0634 \u062f\u0633\u062a\u06cc \u0641\u0627\u06cc\u0644 <code>mods.toml</code></b> \u0628\u0631\u0627\u06cc \u062a\u0646\u0638\u06cc\u0645 \u0645\u062d\u062f\u0648\u062f\u0647\u0654 \u0646\u0633\u062e\u0647\u200c\u0647\u0627 \u06a9\u0627\u0631 \u06a9\u0646\u0646\u062f\u060c \u0647\u0631\u0686\u0646\u062f \u0627\u06cc\u0646 \u06a9\u0627\u0631 <b>\u062a\u0648\u0635\u06cc\u0647 \u0646\u0645\u06cc\u200c\u0634\u0648\u062f</b>.</p>" + (mods.isEmpty() ? "" : "<p><b>\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc\u200c\u0634\u062f\u0647 \u06a9\u0647 \u0628\u0647 Flywheel \u0627\u0631\u062c\u0627\u0639 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>\u0631\u0627\u0647\u200c\u062d\u0644 \u067e\u06cc\u0634\u0646\u0647\u0627\u062f\u06cc\u060c <b>\u062d\u0630\u0641 Flywheel</b> \u0648 \u0627\u0633\u062a\u0641\u0627\u062f\u0647\u0654 \u0627\u0646\u062d\u0635\u0627\u0631\u06cc \u0627\u0632 \u0646\u0633\u062e\u0647\u0654 \u062f\u0627\u062e\u0644\u06cc Create \u0627\u0633\u062a.</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "Flywheel \u0645\u0633\u062a\u0642\u0644";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062e\u0637\u0627\u06cc\u06cc \u0645\u0631\u062a\u0628\u0637 \u0628\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 <i>Floral Enchantments</i> \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><p>\u0627\u06cc\u0646 crash \u0628\u0647 \u062f\u0644\u06cc\u0644 \u062e\u0637\u0627 \u062f\u0631 \u062f\u0627\u062e\u0644 \u0627\u0641\u0632\u0648\u0646\u0647 \u0647\u0646\u06af\u0627\u0645 \u067e\u0631\u062f\u0627\u0632\u0634 \u062f\u0627\u062f\u0647\u200c\u0647\u0627\u06cc \u0628\u0627\u0632\u06cc \u0631\u062e \u062f\u0627\u062f\u0647 \u0648 \u062f\u0631 \u062d\u06cc\u0646 \u0627\u062c\u0631\u0627 \u0628\u0627\u0639\u062b <b>NullPointerException</b> \u0645\u06cc\u200c\u0634\u0648\u062f.</p><p>\u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0627 \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u06cc\u0627 \u062d\u0630\u0641 \u0627\u0641\u0632\u0648\u0646\u0647 \u0628\u0631\u0637\u0631\u0641 \u0645\u06cc\u200c\u0634\u0648\u062f.</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "\u062e\u0637\u0627\u06cc Floral Enchantments";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>\u0634\u0645\u0627 \u0647\u0645 \u0646\u0633\u062e\u0647\u0654 NeoForge \u0648 \u0647\u0645 \u0646\u0633\u062e\u0647\u0654 \u0645\u0639\u0645\u0648\u0644\u06cc MixinExtras \u0631\u0627 \u062f\u0627\u0631\u06cc\u062f. \u0627\u06af\u0631 \u0627\u0632 MinecraftForge \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f\u060c \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u06cc\u062f \u0628\u0627 \u0646\u0635\u0628 <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>\u0627\u06cc\u0646 \u0644\u06cc\u0646\u06a9</a> \u0645\u0634\u06a9\u0644 \u0631\u0627 \u062d\u0644 \u06a9\u0646\u06cc\u062f.</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062e\u0637\u0627\u06cc\u06cc \u062f\u0631 \u0633\u0627\u06cc\u0647\u200c\u0647\u0627\u06cc \u0632\u0645\u06cc\u0646 \u0647\u0646\u06af\u0627\u0645 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0634\u06cc\u062f\u0631\u0647\u0627 (shaders) \u0628\u0627 Iris \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><p>\u0627\u06cc\u0646 \u0645\u0634\u06a9\u0644 \u062f\u0631 \u062d\u06cc\u0646 \u0631\u0646\u062f\u0631 \u0632\u0645\u06cc\u0646 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f.</p><p>\u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f <b>\u0628\u0627\u0632\u06cc \u0631\u0627 \u0628\u062f\u0648\u0646 \u0634\u06cc\u062f\u0631 \u0627\u0645\u062a\u062d\u0627\u0646 \u06a9\u0646\u06cc\u062f</b> \u06cc\u0627 \u06a9\u06cc\u0641\u06cc\u062a \u06af\u0631\u0627\u0641\u06cc\u06a9\u06cc \u0631\u0627 \u06a9\u0627\u0647\u0634 \u062f\u0647\u06cc\u062f\u060c \u0628\u0647\u200c\u0648\u06cc\u0698\u0647 \u062f\u0631 \u062a\u0646\u0638\u06cc\u0645\u0627\u062a <b>Ultra</b>.</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "\u0633\u0627\u06cc\u0647\u200c\u0647\u0627\u06cc \u0632\u0645\u06cc\u0646 (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u06cc\u06a9 \u062a\u06cc\u06a9 \u0633\u0631\u0648\u0631 \u0628\u0633\u06cc\u0627\u0631 \u0637\u0648\u0644\u0627\u0646\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><p>\u0627\u06cc\u0646 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 \u0628\u0627\u0632\u06cc \u0628\u0631\u0627\u06cc \u0645\u062f\u062a \u0637\u0648\u0644\u0627\u0646\u06cc \u062f\u0631 \u06cc\u06a9 \u062a\u06cc\u06a9 \u06af\u06cc\u0631 \u06a9\u0631\u062f\u0647 \u0627\u0633\u062a.</p><p>\u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f <b>thread dump</b> \u0627\u06cc\u062c\u0627\u062f\u0634\u062f\u0647 \u062f\u0631 \u0644\u0627\u06af \u0631\u0627 \u0628\u0631\u0627\u06cc \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0639\u0644\u062a \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.</p><p><b>\u062a\u062d\u0644\u06cc\u0644 Stack Trace</b> \u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u0628\u0647 \u0634\u0645\u0627 \u062f\u0631 \u06cc\u0627\u0641\u062a\u0646 \u0645\u0646\u0634\u0623 \u06af\u06cc\u0631 \u06a9\u0645\u06a9 \u06a9\u0646\u062f.</p><p>\u0647\u0645\u0686\u0646\u06cc\u0646\u060c \u062f\u06a9\u0645\u0647\u0654 <b>\u0645\u0634\u0627\u0647\u062f\u0647 \u062f\u0631 \u0644\u0627\u06af</b> \u0645\u0648\u062f\u0647\u0627\u06cc \u0627\u062d\u062a\u0645\u0627\u0644\u06cc \u0645\u0633\u0626\u0648\u0644 \u0631\u0627 \u0628\u0647 \u0631\u0646\u06af \u0642\u0631\u0645\u0632 \u0628\u0631\u062c\u0633\u062a\u0647 \u0645\u06cc\u200c\u06a9\u0646\u062f\u060c \u0648 \u0647\u0645\u0686\u0646\u06cc\u0646 \u0648\u0631\u0648\u062f\u06cc\u200c\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0628\u0627 <code>$modid$</code> \u0627\u062d\u0627\u0637\u0647 \u0634\u062f\u0647\u200c\u0627\u0646\u062f (\u06a9\u0647 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0645\u0646\u0634\u0623 \u0645\u0634\u06a9\u0644 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u0646\u062f). \u0628\u0631\u0627\u06cc \u0627\u0633\u06a9\u0646 \u0628\u0644\u0627\u062f\u0631\u0646\u06af\u060c \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0646\u0645\u0648\u0646\u0647\u200c\u0628\u0631\u062f\u0627\u0631 CPU \u062f\u0631 VisualVM \u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f. \u0645\u0637\u0645\u0626\u0646 \u0634\u0648\u06cc\u062f \u0633\u0631\u0648\u0631 \u06cc\u0627 \u0631\u0627\u06cc\u0627\u0646\u0647\u0654 \u0634\u0645\u0627 \u0642\u062f\u0631\u062a \u06a9\u0627\u0641\u06cc \u0628\u0631\u0627\u06cc \u0645\u062f\u06cc\u0631\u06cc\u062a \u0645\u0648\u062f\u0647\u0627\u06cc\u06cc \u06a9\u0647 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0645\u06cc\u200c\u06a9\u0646\u06cc\u062f \u062f\u0627\u0631\u062f \u2014 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0647\u0645\u0647\u0654 \u0645\u0648\u062f\u0647\u0627 \u0628\u0647\u200c\u062f\u0631\u0633\u062a\u06cc \u06a9\u0627\u0631 \u06a9\u0646\u0646\u062f\u060c \u0627\u0645\u0627 \u062a\u0639\u062f\u0627\u062f\u0634\u0627\u0646 \u0628\u06cc\u0634 \u0627\u0632 \u062d\u062f \u0628\u0627\u0634\u062f.</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "\u062a\u06cc\u06a9 \u0637\u0648\u0644\u0627\u0646\u06cc \u0633\u0631\u0648\u0631";
    }

    @Override
    public String tituloLFPDPPP() {
        return "\u500b\u4eba\u304c\u4fdd\u6709\u3059\u308b\u500b\u4eba\u60c5\u5831\u306e\u4fdd\u8b77\u306b\u95a2\u3059\u308b\u9023\u90a6\u6cd5";
    }

    @Override
    public String aceptarPermanentemente() {
        return "\u6c38\u7d9a\u7684\u306b\u540c\u610f";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "\u97d3\u56fd\u8a9e\u7ffb\u8a33\u306b\u306f\u3001\u6cd5\u5f8b\u3092\u9075\u5b88\u3059\u308b\u305f\u3081\u306b\u907f\u3051\u308b\u3079\u304d\u5357\u90e8\u306e\u30b9\u30e9\u30f3\u30b0\u7528\u8a9e\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u5916\u56fd\u8a9e\u3001\u7279\u306b\u5357\u5074\u7531\u6765\u306e\u8a00\u8449\u306e\u4f7f\u7528\u306f\u3001\u300c\u5e73\u58cc\u6587\u5316\u8a9e\u4fdd\u8b77\u6cd5\u300d\u306b\u3088\u308a\u53b3\u3057\u304f\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "\u8a73\u7d30\u306b\u3064\u3044\u3066\u306f\u3001\u6cd5\u4ee4\u306e\u516c\u5f0f\u6587\u66f8\u3092\u3054\u53c2\u7167\u304f\u3060\u3055\u3044\uff1a<a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>\u5e73\u58cc\u6587\u5316\u8a9e\u4fdd\u8b77\u6cd5</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "\u5168\u6587\u3092\u8aad\u3080";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "\u30ea\u30f3\u30af\u3092\u958b\u304f\u969b\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "\u0642\u0627\u0646\u0648\u0646 \u062d\u0645\u0627\u06cc\u062a \u0627\u0632 \u0632\u0628\u0627\u0646 \u0641\u0631\u0647\u0646\u06af\u06cc \u067e\u06cc\u0648\u0646\u06af\u200c\u06cc\u0627\u0646\u06af";
    }

    @Override
    public String canarioTitulo() {
        return "\u0642\u0646\u0627\u0631\u06cc \u062f\u0633\u062a\u0648\u0631 \u0642\u0636\u0627\u06cc\u06cc";
    }

    @Override
    public String canario1984Titulo() {
        return "\u06f1\u06f9\u06f8\u06f4 \u2014 \u0646\u0638\u0627\u0631\u062a\u200c\u06af\u0631 \u0646\u0638\u0627\u0631\u062a\u06cc";
    }

    @Override
    public String revisar() {
        return "\u0628\u0631\u0631\u0633\u06cc";
    }

    @Override
    public String cerrar() {
        return "\u0628\u0633\u062a\u0646";
    }

    @Override
    public String canarioTodoSeguro() {
        return "\u0647\u0645\u0647\u0654 \u0633\u0631\u0648\u06cc\u0633\u200c\u0647\u0627 \u0648\u0636\u0639\u06cc\u062a \u0627\u0645\u0646 \u0631\u0627 \u06af\u0632\u0627\u0631\u0634 \u06a9\u0631\u062f\u0647\u200c\u0627\u0646\u062f.";
    }

    @Override
    public String canarioComprometido(int c) {
        return "\u0647\u0634\u062f\u0627\u0631: " + c + " \u0633\u0631\u0648\u06cc\u0633\u060c \u0648\u0636\u0639\u06cc\u062a \u0646\u0627\u0627\u0645\u0646 \u0631\u0627 \u06af\u0632\u0627\u0631\u0634 \u06a9\u0631\u062f\u0647\u200c\u0627\u0646\u062f.";
    }

    @Override
    public String colorAlerta() {
        return "\u0631\u0646\u06af \u0647\u0634\u062f\u0627\u0631";
    }

    @Override
    public String opcionesMunidiales() {
        return "\u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627\u06cc \u0645\u0648\u0646\u06cc\u062f\u06cc\u0627\u0644";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "\u0631\u0636\u0627\u06cc\u062a\u200c\u0646\u0627\u0645\u0647\u0654 LFPDPPP";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u0627\u0646\u062a\u0642\u0627\u0644 \u062a\u0648\u06a9\u0646 \u062f\u0633\u062a\u0631\u0633\u06cc \u062f\u0631 Handoff \u0628\u0631\u0627\u06cc ReLauncher (\u062a\u0648\u0635\u06cc\u0647 \u0646\u0645\u06cc\u200c\u0634\u0648\u062f).";
    }

    @Override
    public String consolaDesarrollo() {
        return "\u06a9\u0646\u0633\u0648\u0644 \u062a\u0648\u0633\u0639\u0647";
    }

    @Override
    public String mundial() {
        return "\u062c\u0647\u0627\u0646\u06cc";
    }

    @Override
    public String ningun() {
        return "\u0647\u06cc\u0686\u200c\u06a9\u062f\u0627\u0645";
    }

    public String consolaDesarrollador() {
        return "\u06a9\u0646\u0633\u0648\u0644 \u062a\u0648\u0633\u0639\u0647\u200c\u062f\u0647\u0646\u062f\u0647";
    }

    @Override
    public String bajar() {
        return "\u062f\u0627\u0646\u0644\u0648\u062f";
    }

    @Override
    public String logsSoporte() {
        return "\u0644\u0627\u06af\u200c\u0647\u0627\u06cc \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc";
    }

    @Override
    public String detenerProceso() {
        return "\u062a\u0648\u0642\u0641 \u0641\u0631\u0622\u06cc\u0646\u062f";
    }

    @Override
    public String copiarSeleccion() {
        return "\u06a9\u067e\u06cc \u0627\u0646\u062a\u062e\u0627\u0628\u200c\u0634\u062f\u0647";
    }

    @Override
    public String seleccionarTodo() {
        return "\u0627\u0646\u062a\u062e\u0627\u0628 \u0647\u0645\u0647";
    }

    @Override
    public String copiarTodo() {
        return "\u06a9\u067e\u06cc \u0647\u0645\u0647";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "\u0630\u062e\u06cc\u0631\u0647\u0654 \u0647\u0645\u0647 \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u0641\u0627\u06cc\u0644";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "\u062f\u0631\u06cc\u0627\u0641\u062a \u0644\u06cc\u0646\u06a9 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc";
    }

    @Override
    public String borrarTodo() {
        return "\u067e\u0627\u06a9\u200c\u0633\u0627\u0632\u06cc \u0647\u0645\u0647";
    }

    public String colorFondoConsola() {
        return "\u0631\u0646\u06af \u067e\u0633\u200c\u0632\u0645\u06cc\u0646\u0647\u0654 \u06a9\u0646\u0633\u0648\u0644";
    }

    public String colorTextoConsola() {
        return "\u0631\u0646\u06af \u0645\u062a\u0646 \u06a9\u0646\u0633\u0648\u0644";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "\u0631\u0636\u0627\u06cc\u062a \u062a\u0623\u06cc\u06cc\u062f \u0634\u062f.\n\u0627\u0645\u06a9\u0627\u0646 \u0627\u0634\u062a\u0631\u0627\u06a9\u200c\u06af\u0630\u0627\u0631\u06cc \u0644\u0627\u06af\u200c\u0647\u0627 \u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u067e\u06cc\u0627\u062f\u0647\u200c\u0633\u0627\u0632\u06cc \u062e\u0648\u0627\u0647\u062f \u0634\u062f.";
    }

    @Override
    public String usarSakuraOriginal() {
        return "\u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u062a\u0635\u0648\u06cc\u0631 \u0627\u0635\u0644\u06cc Sakura Riddle";
    }

    @Override
    public String canario1984Descripcion() {
        return "\u00ab\u0642\u0646\u0627\u0631\u06cc \u062f\u0633\u062a\u0648\u0631 \u0642\u0636\u0627\u06cc\u06cc\u00bb (warrant canary) \u06cc\u06a9 \u0645\u06a9\u0627\u0646\u06cc\u0632\u0645 \u0634\u0641\u0627\u0641\u06cc\u062a \u0627\u0633\u062a.\n\n\u062a\u0627 \u0632\u0645\u0627\u0646\u06cc \u06a9\u0647 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f \u0648 \u0633\u0631\u0648\u06cc\u0633\u200c\u0647\u0627 \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u0627\u0645\u0646 \u0646\u0645\u0627\u06cc\u0634 \u062f\u0627\u062f\u0647 \u0645\u06cc\u200c\u0634\u0648\u0646\u062f\u060c \u0628\u0647 \u0627\u06cc\u0646 \u0645\u0639\u0646\u0627\u0633\u062a \u06a9\u0647 \u067e\u0631\u0648\u0698\u0647 \u062f\u0633\u062a\u0648\u0631 \u0642\u0636\u0627\u06cc\u06cc \u0645\u062d\u0631\u0645\u0627\u0646\u0647\u060c \u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0633\u0627\u0646\u0633\u0648\u0631 \u06cc\u0627 \u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0642\u0627\u0646\u0648\u0646\u06cc \u0646\u0638\u0627\u0631\u062a\u06cc \u062f\u0631\u06cc\u0627\u0641\u062a \u0646\u06a9\u0631\u062f\u0647 \u0627\u0633\u062a.\n\n\u0627\u06af\u0631 \u0647\u0631 \u06cc\u06a9 \u0627\u0632 \u0642\u0646\u0627\u0631\u06cc\u200c\u0647\u0627 \u0646\u0627\u067e\u062f\u06cc\u062f \u0634\u0648\u062f \u06cc\u0627 \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u0646\u0627\u0627\u0645\u0646 \u0639\u0644\u0627\u0645\u062a\u200c\u06af\u0630\u0627\u0631\u06cc \u0634\u0648\u062f\u060c \u0627\u06cc\u0646 \u0646\u0634\u0627\u0646\u200c\u062f\u0647\u0646\u062f\u0647\u0654 \u062a\u063a\u06cc\u06cc\u0631\u06cc \u0642\u0627\u0646\u0648\u0646\u06cc \u0627\u0633\u062a.\n\n\u0627\u06cc\u0646 \u067e\u0646\u0644 \u062a\u0645\u0627\u0645 \u0642\u0646\u0627\u0631\u06cc\u200c\u0647\u0627\u06cc \u062b\u0628\u062a\u200c\u0634\u062f\u0647 \u062f\u0631 \u0633\u06cc\u0633\u062a\u0645 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0631\u062f\u0647 \u0648 \u0648\u0636\u0639\u06cc\u062a \u0641\u0639\u0644\u06cc \u0622\u0646\u200c\u0647\u0627 \u0631\u0627 \u0646\u0645\u0627\u06cc\u0634 \u0645\u06cc\u200c\u062f\u0647\u062f.\n\n\u0628\u0631\u0627\u06cc \u0628\u0647\u200c\u0631\u0648\u0632\u0631\u0633\u0627\u0646\u06cc \u0648\u0636\u0639\u06cc\u062a\u200c\u0647\u0627\u060c \u00ab\u0628\u0631\u0631\u0633\u06cc\u00bb \u0631\u0627 \u0641\u0634\u0627\u0631 \u062f\u0647\u06cc\u062f.";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\u0647\u0645\u0647\u0654 \u06af\u0632\u06cc\u0646\u0647\u200c\u0647\u0627 \u0628\u0647 \u0645\u0642\u0627\u062f\u06cc\u0631 \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 \u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0634\u0648\u0646\u062f\u061f";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "\u0628\u062f\u0648\u0646 \u06af\u0632\u06cc\u0646\u0647";
    }

    @Override
    public String seleccionaColor() {
        return "\u0627\u0646\u062a\u062e\u0627\u0628 \u0631\u0646\u06af";
    }

    @Override
    public String botonMostrarGUI() {
        return "\u0646\u0645\u0627\u06cc\u0634 GUI";
    }

    @Override
    public String botonGuardarTodo() {
        return "\u0630\u062e\u06cc\u0631\u0647\u0654 \u0647\u0645\u0647";
    }

    @Override
    public String botonRestablecerTodo() {
        return "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0647\u0645\u0647";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0634\u062f\u0647 \u0627\u0633\u062a";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062e\u0637\u0627\u06cc\u06cc \u0647\u0646\u06af\u0627\u0645 \u062f\u0633\u062a\u0631\u0633\u06cc \u0628\u0647 \u0631\u0627\u0628\u0637 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0646\u0648\u06cc\u0633\u06cc LuckPerms \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><p>\u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0646\u0634\u0627\u0646 \u0645\u06cc\u200c\u062f\u0647\u062f \u06a9\u0647 <b>LuckPerms \u062f\u0631 \u0632\u0645\u0627\u0646\u06cc \u06a9\u0647 \u06cc\u06a9 \u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u062f\u06cc\u06af\u0631 \u0633\u0639\u06cc \u062f\u0631 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0622\u0646 \u06a9\u0631\u062f\u060c \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0634\u062f\u0647 \u0628\u0648\u062f</b>.</p><p><b>\u062f\u0644\u0627\u06cc\u0644 \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b></p><ul><li>\u0627\u0641\u0632\u0648\u0646\u0647\u0654 <b>LuckPerms \u0646\u0635\u0628 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a</b> \u06cc\u0627 <b>\u062f\u0631 \u0647\u0646\u06af\u0627\u0645 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u0628\u0627 \u0634\u06a9\u0633\u062a \u0645\u0648\u0627\u062c\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a</b>.</li><li>\u0627\u0641\u0632\u0648\u0646\u0647\u0654 \u062f\u06cc\u06af\u0631\u06cc \u062f\u0631 \u062d\u0627\u0644 \u062f\u0633\u062a\u0631\u0633\u06cc \u0628\u0647 LuckPerms <b>\u062e\u06cc\u0644\u06cc \u0632\u0648\u062f</b> \u06cc\u0627 <b>\u0628\u0647\u200c\u0635\u0648\u0631\u062a \u0646\u0627\u062f\u0631\u0633\u062a</b> \u0627\u0633\u062a.</li></ul><p>\u062a\u0648\u0635\u06cc\u0647 \u0645\u06cc\u200c\u0634\u0648\u062f \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u067e\u06cc\u0648\u0646\u062f\u060c <b>\u06a9\u0646\u0633\u0648\u0644 \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f</b> \u062a\u0627 \u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0627\u06cc \u06a9\u0647 LuckPerms \u0631\u0627 \u0641\u0631\u0627\u062e\u0648\u0627\u0646\u06cc \u0645\u06cc\u200c\u06a9\u0646\u062f \u0631\u0627 \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u06a9\u0631\u062f\u0647 \u0648 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0622\u0646 \u0631\u0627 \u062a\u0623\u06cc\u06cc\u062f \u0646\u0645\u0627\u06cc\u06cc\u062f.</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "\u0628\u0633\u062a\u0647\u0654 \u0633\u0627\u06cc\u0647\u200c\u067e\u0631\u062f\u0627\u0632 Iris \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0634\u062f\u0647 \u0627\u0633\u062a";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "\u0646\u0627\u0634\u0646\u0627\u062e\u062a\u0647" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062e\u0637\u0627\u06cc\u06cc \u0647\u0646\u06af\u0627\u0645 \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u0628\u0633\u062a\u0647\u0654 \u0633\u0627\u06cc\u0647\u200c\u067e\u0631\u062f\u0627\u0632 \u0628\u0627 Iris/Oculus \u0634\u0646\u0627\u0633\u0627\u06cc\u06cc \u0634\u062f.</b><p><b>\u0628\u0633\u062a\u0647\u0654 \u0633\u0627\u06cc\u0647\u200c\u067e\u0631\u062f\u0627\u0632 \u062a\u062d\u062a \u062a\u0623\u062b\u06cc\u0631:</b> " + nombre + "</p><p>\u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u0646\u062a\u0648\u0627\u0646\u0633\u062a \u0641\u0627\u06cc\u0644 \u0628\u0633\u062a\u0647\u0654 \u0633\u0627\u06cc\u0647\u200c\u067e\u0631\u062f\u0627\u0632 \u0631\u0627 \u0628\u0627\u0632 \u06a9\u0646\u062f (FileSystemNotFoundException).</p><p><b>\u0631\u0627\u0647\u200c\u062d\u0644\u200c\u0647\u0627\u06cc \u0627\u062d\u062a\u0645\u0627\u0644\u06cc:</b></p><ul><li>\u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0628\u0633\u062a\u0647\u0654 \u0633\u0627\u06cc\u0647\u200c\u067e\u0631\u062f\u0627\u0632 \u0628\u0647\u200c\u062f\u0631\u0633\u062a\u06cc \u062f\u0631 \u067e\u0648\u0634\u0647\u0654 <b>shaderpacks</b> \u0646\u0635\u0628 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f.</li><li>\u0628\u0633\u062a\u0647\u0654 \u0633\u0627\u06cc\u0647\u200c\u067e\u0631\u062f\u0627\u0632 \u0631\u0627 \u062f\u0648\u0628\u0627\u0631\u0647 \u0628\u0627\u0631\u06af\u06cc\u0631\u06cc \u06a9\u0646\u06cc\u062f\u060c \u0632\u06cc\u0631\u0627 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0641\u0627\u06cc\u0644 \u062e\u0631\u0627\u0628 \u0634\u062f\u0647 \u0628\u0627\u0634\u062f.</li><li>\u0627\u06af\u0631 \u0645\u0634\u06a9\u0644 \u0627\u062f\u0627\u0645\u0647 \u06cc\u0627\u0641\u062a\u060c \u0628\u0631\u0627\u06cc \u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc Iris\u060c \u0641\u0627\u06cc\u0644 <b>config/iris.properties</b> \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f.</li></ul><p>\u067e\u0633 \u0627\u0632 \u0627\u0639\u0645\u0627\u0644 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a\u060c \u0628\u0627\u0632\u06cc \u0631\u0627 \u062f\u0648\u0628\u0627\u0631\u0647 \u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u06cc \u06a9\u0646\u06cc\u062f.</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "\u0627\u0645\u06a9\u0627\u0646 \u0646\u0648\u0634\u062a\u0646 \u0641\u0627\u06cc\u0644 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "\u0646\u0627\u0634\u0646\u0627\u062e\u062a\u0647" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u0647\u0646\u06af\u0627\u0645 \u0630\u062e\u06cc\u0631\u0647\u0654 \u0641\u0627\u06cc\u0644 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u062e\u0637\u0627\u06cc\u06cc \u0631\u062e \u062f\u0627\u062f.</b><p><b>\u0641\u0627\u06cc\u0644 \u062a\u062d\u062a \u062a\u0623\u062b\u06cc\u0631:</b> " + archivo + "</p><p>\u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u0646\u062a\u0648\u0627\u0646\u0633\u062a \u0641\u0627\u06cc\u0644 \u0631\u0627 \u0628\u0627 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0646\u0648\u0634\u062a\u0646 \u0627\u062a\u0645\u06cc (REPLACE_ATOMIC) \u0628\u0646\u0648\u06cc\u0633\u062f.</p><p><b>\u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0647 \u062f\u0644\u0627\u06cc\u0644 \u0632\u06cc\u0631 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f:</b></p><ul><li>\u0645\u062c\u0648\u0632\u0647\u0627\u06cc \u0646\u0627\u062f\u0631\u0633\u062a \u0631\u0648\u06cc \u067e\u0648\u0634\u0647 \u06cc\u0627 \u0641\u0627\u06cc\u0644.</li><li>\u0641\u0627\u06cc\u0644 \u0628\u0647\u200c\u0635\u0648\u0631\u062a \u0641\u0642\u0637\u200c\u062e\u0648\u0627\u0646\u062f\u0646\u06cc \u0639\u0644\u0627\u0645\u062a\u200c\u06af\u0630\u0627\u0631\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a.</li><li>\u0628\u0631\u0646\u0627\u0645\u0647\u0654 \u062f\u06cc\u06af\u0631\u06cc (\u0622\u0646\u062a\u06cc\u200c\u0648\u06cc\u0631\u0648\u0633\u060c \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u200c\u06af\u06cc\u0631\u06cc\u060c \u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631) \u062f\u0631 \u062d\u0627\u0644 \u0642\u0641\u0644 \u06a9\u0631\u062f\u0646 \u0641\u0627\u06cc\u0644 \u0627\u0633\u062a.</li></ul><p><b>\u062a\u0648\u0635\u06cc\u0647\u200c\u0647\u0627:</b></p><ul><li>\u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f \u06a9\u0647 \u0645\u062c\u0648\u0632 \u0646\u0648\u0634\u062a\u0646 \u062f\u0631 \u067e\u0648\u0634\u0647 \u0631\u0627 \u062f\u0627\u0631\u06cc\u062f.</li><li>\u0648\u06cc\u0698\u06af\u06cc \u0641\u0642\u0637\u200c\u062e\u0648\u0627\u0646\u062f\u0646\u06cc \u0631\u0627 \u0627\u0632 \u0641\u0627\u06cc\u0644 \u0628\u0631\u062f\u0627\u0631\u06cc\u062f.</li><li>\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc\u06cc \u0631\u0627 \u06a9\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0627\u0632 \u0627\u06cc\u0646 \u0641\u0627\u06cc\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u06a9\u0646\u0646\u062f\u060c \u0628\u0628\u0646\u062f\u06cc\u062f.</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "\u062f\u0633\u062a\u0631\u0633\u06cc \u0647\u0646\u06af\u0627\u0645 \u0627\u06cc\u062c\u0627\u062f \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u0631\u062f \u0634\u062f";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "\u0646\u0627\u0634\u0646\u0627\u062e\u062a\u0647" : origen;
        String dst = backup == null || backup.isEmpty() ? "\u0646\u0627\u0634\u0646\u0627\u062e\u062a\u0647" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u062e\u0637\u0627\u06cc \u0645\u062c\u0648\u0632 \u0647\u0646\u06af\u0627\u0645 \u0627\u06cc\u062c\u0627\u062f \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u0627\u0632 \u0641\u0627\u06cc\u0644 \u067e\u06cc\u06a9\u0631\u0628\u0646\u062f\u06cc \u0631\u062e \u062f\u0627\u062f.</b><p><b>\u0641\u0627\u06cc\u0644 \u0627\u0635\u0644\u06cc:</b> " + src + "</p><p><b>\u0641\u0627\u06cc\u0644 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646:</b> " + dst + "</p><p>\u0633\u06cc\u0633\u062a\u0645\u200c\u0639\u0627\u0645\u0644 \u062f\u0631 \u062d\u06cc\u0646 \u0630\u062e\u06cc\u0631\u0647\u0654 \u0641\u0627\u06cc\u0644\u060c \u062f\u0633\u062a\u0631\u0633\u06cc \u0631\u0627 \u0645\u0633\u062f\u0648\u062f \u06a9\u0631\u062f.</p><p><b>\u0627\u06cc\u0646 \u0645\u0639\u0645\u0648\u0644\u0627\u064b \u0628\u0647 \u062f\u0644\u0627\u06cc\u0644 \u0632\u06cc\u0631 \u0631\u062e \u0645\u06cc\u200c\u062f\u0647\u062f:</b></p><ul><li>\u0645\u062c\u0648\u0632\u0647\u0627\u06cc \u0646\u0627\u06a9\u0627\u0641\u06cc \u0631\u0648\u06cc \u067e\u0648\u0634\u0647.</li><li>\u0641\u0627\u06cc\u0644 \u0628\u0647\u200c\u0635\u0648\u0631\u062a \u0641\u0642\u0637\u200c\u062e\u0648\u0627\u0646\u062f\u0646\u06cc \u0639\u0644\u0627\u0645\u062a\u200c\u06af\u0630\u0627\u0631\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a.</li><li>\u0628\u0631\u0646\u0627\u0645\u0647\u0654 \u062f\u06cc\u06af\u0631\u06cc (\u0622\u0646\u062a\u06cc\u200c\u0648\u06cc\u0631\u0648\u0633\u060c \u0627\u0628\u0632\u0627\u0631 \u0647\u0645\u06af\u0627\u0645\u200c\u0633\u0627\u0632\u06cc\u060c \u0648\u06cc\u0631\u0627\u06cc\u0634\u06af\u0631) \u062f\u0631 \u062d\u0627\u0644 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0641\u0627\u06cc\u0644 \u0627\u0633\u062a.</li></ul><p><b>\u062a\u0648\u0635\u06cc\u0647\u200c\u0647\u0627:</b></p><ul><li>\u0645\u062c\u0648\u0632\u0647\u0627\u06cc \u067e\u0648\u0634\u0647\u0654 <b>config</b> \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.</li><li>\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc\u06cc \u0631\u0627 \u06a9\u0647 \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0628\u0647 \u0641\u0627\u06cc\u0644 \u062f\u0633\u062a\u0631\u0633\u06cc \u062f\u0627\u0634\u062a\u0647 \u0628\u0627\u0634\u0646\u062f\u060c \u0628\u0628\u0646\u062f\u06cc\u062f.</li><li>\u0633\u0639\u06cc \u06a9\u0646\u06cc\u062f \u0644\u0627\u0646\u0686\u0631 \u06cc\u0627 \u0645\u0627\u06cc\u0646\u06a9\u0631\u0641\u062a \u0631\u0627 \u0628\u0647\u200c\u0639\u0646\u0648\u0627\u0646 \u0645\u062f\u06cc\u0631 \u0627\u062c\u0631\u0627 \u06a9\u0646\u06cc\u062f.</li></ul>";
    }
}

