/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Portuges
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Pasta de mods inv\u00e1lida</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>N\u00e3o foi poss\u00edvel encontrar o JAR do CrashDetector</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Procurando pelo PID: " + pid + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + pid + ") foi finalizado!</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Sem JVM dispon\u00edvel</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Atualizar seus drivers ATI/AMD pode ajudar. Leia este guia para corrigir: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Guia de atualiza\u00e7\u00e3o de drivers</a> https://www.amd.com/pt/support/download/drivers.html Baixar </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>Algumas vers\u00f5es antigas apresentam problemas com a interface de inicializa\u00e7\u00e3o do Nouveau.</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Problema detectado com seus drivers de v\u00eddeo. Usu\u00e1rios de AMD/ATI devem atualizar os drivers. Usu\u00e1rios de NVIDIA devem garantir que todos os processos javaw.exe estejam usando a GPU dedicada. Leia este guia: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Guia de Atualiza\u00e7\u00e3o de Drivers</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Falha ao carregar janela inicial do FML. Para corrigi-lo, v\u00e1 para (.minecraft/config/fml.toml) e defina earlyWindowProvider para \"none\". Usu\u00e1rios de Mac M1 devem usar Java ARM. Este problema tamb\u00e9m pode ocorrer com drivers desatualizados. Se usar Windows e a configura\u00e7\u00e3o n\u00e3o funcionar, consulte: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>Guia de Atualiza\u00e7\u00e3o de Drivers</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Depend\u00eancias faltando:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "Solicitado por").replace("Expected range", "Intervalo esperado") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Seu relat\u00f3rio do CrashDetector est\u00e1 aqui: <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>Visualizar Relat\u00f3rio</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Esta \u00e9 a interface gr\u00e1fica do CrashDetector. Ignore-a se o jogo fechar normalmente.</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>Visualizar Relat\u00f3rio</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>Visualizar relat\u00f3rio local no navegador.</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "Compartilhar Relat\u00f3rio";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "Compartilhar relat\u00f3rio. Seus logs ser\u00e3o enviados para securelogger.net e o relat\u00f3rio para outros sites.";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JAR problem\u00e1tico detectado (prioridade: FATAL > Alta > Baixa):</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> N\u00edvel:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Potencialmente fatal:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ModIDs problem\u00e1ticos detectados (prioridade: FATAL > Alta > Baixa):</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Pacotes problem\u00e1ticos detectados (prioridade: FATAL > Alta > Baixa):</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea tem classes fatais (FATAL), isso \u00e9 muito grave. Causas comuns s\u00e3o CoreMods defeituosos ou depend\u00eancias fatais. Use o QuickFix para procurar mods com classes fatais. Classes fatais ausentes detectadas:</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Conte\u00fado entre chaves (mais importantes no topo, mostrando primeiros 20):</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Configura\u00e7\u00e3o problem\u00e1tica do SpongeMixin detectada: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea tem mods com pacotes duplicados. Voc\u00ea pode resolver isso removendo o pacote (pasta) duplicado do arquivo JAR. Voc\u00ea pode abrir o JAR em um programa de arquivamento como WinRAR ou 7z, ou tamb\u00e9m pode alterar a extens\u00e3o do arquivo de .jar para .zip, excluir a pasta e depois renome\u00e1-lo novamente para um arquivo .jar.</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mods duplicados detectados</b> " + linea.replace("from mod files", "de arquivos de mod");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge detectou mod suspeito:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV requer lithostitched. Instale aqui: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Para usar shaders Iris/Oculus, voc\u00ea precisa do SODIUM ou outro loader compat\u00edvel (Rubidium, Embedium, Bedium)</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Problema com expans\u00e3o KubeJS </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Problemas detectados com drivers NVIDIA em vers\u00f5es anteriores ao Windows 11.</span><br/><br/>Para garantir que o Minecraft (e a JVM atual) use a GPU dedicada NVIDIA, siga estes passos:<br/><br/>1. <strong>Identifique o execut\u00e1vel do Java:</strong><br/>   - Este programa est\u00e1 usando o seguinte execut\u00e1vel do Java: " + this.obtenerRutaJava() + "<br/>   - Se voc\u00ea n\u00e3o vir um caminho espec\u00edfico, pode encontrar o execut\u00e1vel do Java pesquisando por 'java.exe' no sistema.<br/><br/>2. <strong>Abra o Painel de Controle da NVIDIA:</strong><br/>   - Clique com o bot\u00e3o direito na \u00e1rea de trabalho e selecione 'Painel de Controle da NVIDIA'.<br/><br/>3. <strong>Configure a GPU preferida:</strong><br/>   - No Painel de Controle da NVIDIA, v\u00e1 para 'Gerenciar configura\u00e7\u00f5es 3D'.<br/>   - Selecione a op\u00e7\u00e3o 'Programa espec\u00edfico'.<br/>   - Clique em 'Adicionar' e localize o execut\u00e1vel do Java identificado anteriormente (ex.: 'java.exe').<br/>   - Certifique-se de que esteja configurado para usar o 'Processador de alto desempenho (NVIDIA)'.<br/><br/>4. <strong>Salve as altera\u00e7\u00f5es:</strong><br/>   - Aplique as altera\u00e7\u00f5es e feche o Painel de Controle da NVIDIA.<br/><br/>5. <strong>Reinicie o Minecraft:</strong><br/>   - Reinicie o Minecraft para que as altera\u00e7\u00f5es tenham efeito.<br/><br/>Se voc\u00ea usa Windows Server 2022 ou Windows 10, esses passos s\u00e3o v\u00e1lidos desde que tenha os drivers NVIDIA mais recentes instalados.<br/><br/>Nota: Se voc\u00ea n\u00e3o encontrar o Painel de Controle da NVIDIA, certifique-se de que os drivers NVIDIA est\u00e3o corretamente instalados.";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Problemas detectados com drivers NVIDIA no Windows 11/Server 2025 ou posterior.</span><br/><br/>Para garantir que o Minecraft (e a JVM atual) use a GPU dedicada NVIDIA, siga estes passos:<br/><br/>1. <strong>Identifique o execut\u00e1vel do Java:</strong><br/>   - Este programa est\u00e1 usando o seguinte execut\u00e1vel do Java: " + this.obtenerRutaJava() + "<br/>   - Se voc\u00ea n\u00e3o vir um caminho espec\u00edfico, pode encontrar o execut\u00e1vel do Java pesquisando por 'java.exe' no sistema.<br/><br/>2. <strong>Abra o aplicativo Configura\u00e7\u00f5es:</strong><br/>   - Pressione as teclas <code>Win + I</code> para abrir o aplicativo Configura\u00e7\u00f5es.<br/>   - Navegue at\u00e9 <strong>Sistema > Tela > Gr\u00e1ficos</strong>.<br/><br/>3. <strong>Configure a GPU preferida:</strong><br/>   - Na se\u00e7\u00e3o 'Gr\u00e1ficos', clique em 'Configura\u00e7\u00f5es de gr\u00e1ficos padr\u00e3o'.<br/>   - Selecione 'Aplicativos de desktop' e depois clique em 'Procurar'.<br/>   - Localize e selecione o execut\u00e1vel do Java identificado anteriormente (ex.: 'java.exe').<br/>   - Uma vez adicionado, selecione o aplicativo Java na lista e configure-o para usar 'Alto desempenho (NVIDIA)'.<br/><br/>4. <strong>Salve as altera\u00e7\u00f5es:</strong><br/>   - Aplique as altera\u00e7\u00f5es e feche o aplicativo Configura\u00e7\u00f5es.<br/><br/>5. <strong>Reinicie o Minecraft:</strong><br/>   - Reinicie o Minecraft para que as altera\u00e7\u00f5es tenham efeito.<br/><br/>Se voc\u00ea usa Windows 11 ou Windows Server 2025+, esses passos s\u00e3o v\u00e1lidos desde que tenha os drivers NVIDIA mais recentes instalados.<br/><br/>Nota: Se voc\u00ea n\u00e3o encontrar a op\u00e7\u00e3o de configura\u00e7\u00e3o de gr\u00e1ficos, certifique-se de que os drivers NVIDIA est\u00e3o corretamente instalados.";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Seu Servidor ou Mundo tem ticks de mais de 60 segundos. Isso pode ser devido a mods tornando o servidor mais lento ou ao hardware ser muito fraco.</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea n\u00e3o tem RAM/Mem\u00f3ria suficiente. Voc\u00ea precisa alocar mais.</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>O Theseus tamb\u00e9m tem mais problemas, incluindo falhas ao remover mods quando voc\u00ea tenta. Se voc\u00ea precisa jogar com arquivos mrpack, pode usar outros lan\u00e7adores, como Prism Launcher (apenas para modrinth.com), ATLauncher (apenas para modrinth.com) ou Hello Minecraft Launcher (compat\u00edvel com modrinth.com e bbsmc.net).</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Voc\u00ea est\u00e1 usando \"Ignorar In\u00edcio do Launcher\" (App CurseForge). \u00c0s vezes isso causa problemas dif\u00edceis de detectar. Isso ocorre devido \u00e0 op\u00e7\u00e3o \"Ignorar In\u00edcio do Launcher\" em vers\u00f5es antigas do App CurseForge ou na vers\u00e3o nova. Desative-a e use a op\u00e7\u00e3o \"Mojang Launcher\" nas configura\u00e7\u00f5es do CurseForge. Voc\u00ea pode assistir a este v\u00eddeo em ingl\u00eas de Claws of Berk (v\u00e1 para 1:11) <a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>aqui</a>.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Aviso: Classes ausentes detectadas (n\u00edvel de aviso). Geralmente n\u00e3o \u00e9 grave, mas pode causar problemas \u2014 diferente de erros fatais. Causas comuns incluem CoreMods defeituosos ou depend\u00eancias ausentes. Use o QuickFix para verificar mods com classes faltantes. Classes ausentes detectadas:</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sem Resultados</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Loca\u00e7\u00f5es dos Logs:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Aqui est\u00e3o os resultados das suas verifica\u00e7\u00f5es. Fa\u00e7a com calma; geralmente, a causa correta est\u00e1 na verifica\u00e7\u00e3o 1 ou 2. O resto (erros 3 e acima) pode ser usado para confirma\u00e7\u00e3o, mas geralmente s\u00e3o erros em cascata que voc\u00ea pode ignorar. As falhas ocorrem em camadas, ent\u00e3o corrigir o problema principal resolver\u00e1 esse erro espec\u00edfico. No entanto, amanh\u00e3 pode aparecer um novo erro n\u00e3o relacionado ao atual, pois muitas vezes um erro impede que outro apare\u00e7a no console.</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Por favor, use o Java 17 para as vers\u00f5es 1.17-1.20.4 e o Java 21 para qualquer vers\u00e3o mais recente. Use o Java 8 para vers\u00f5es mais antigas. [Guia](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). Se voc\u00ea ainda tiver problemas, pode ser porque algum mod tem arquivos muito novos ou antigos.</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O Java 22 e superior n\u00e3o funciona em vers\u00f5es do Minecraft abaixo de 1.20.5 para a maioria dos modloaders devido ao ASM estar desatualizado.</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O Java est\u00e1 obsoleto </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea precisa do m\u00f3dulo JPMS " + mod_necesitas + " de " + submod + "</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>N\u00e3o \u00e9 poss\u00edvel invocar " + metodo + " porque " + objeto + " \u00e9 nulo</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "An\u00e1lise Avan\u00e7ada";
    }

    @Override
    public String seleccionarCarpeta() {
        return "Selecionar Pasta";
    }

    @Override
    public String cadenaBusqueda() {
        return "String de Busca";
    }

    @Override
    public String usarRegex() {
        return "Usar Regex";
    }

    @Override
    public String ignorarMayusculas() {
        return "Ignorar Mai\u00fasculas";
    }

    @Override
    public String buscar() {
        return "Buscar";
    }

    @Override
    public String busquedaEnProgreso() {
        return "Busca em Andamento";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "Nenhum Resultado Encontrado";
    }

    @Override
    public String errorBusqueda() {
        return "Erro na Busca";
    }

    @Override
    public String omitirYCerrar() {
        return "Ignorar e Fechar";
    }

    @Override
    public String guardarYCerrar() {
        return "Salvar e Fechar";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "Cole os registros aqui";
    }

    @Override
    public String archivo() {
        return "Arquivo";
    }

    @Override
    public String incluir() {
        return "Incluir";
    }

    @Override
    public String abrir() {
        return "Abrir";
    }

    @Override
    public String endpointDeInforme() {
        return "Ponto Final do Relat\u00f3rio";
    }

    @Override
    public String sitoDeLogging() {
        return "Site de Registro:";
    }

    @Override
    public String apiDeLogging() {
        return "API de Registro:";
    }

    @Override
    public String anonimizarRegistros() {
        return "Anonimizar registros (Beta)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "Compartilhar Relat\u00f3rio e todos os registros selecionados";
    }

    @Override
    public String arco() {
        return "Esta caixa de di\u00e1logo permite que voc\u00ea compartilhe logs usando a API do SecureLogger em <a href=\"https://securelogger.net\">securelogger.net</a>. Ao clicar no bot\u00e3o para compartilhar o relat\u00f3rio, seu relat\u00f3rio \u00e9 enviado ao endpoint selecionado (padr\u00e3o: asbestosstar.egoism.jp) (pode ser alterado na parte inferior). Voc\u00ea pode compartilhar todos os logs selecionados junto com o relat\u00f3rio. Se n\u00e3o quiser fazer upload, n\u00e3o use esta caixa de di\u00e1logo! N\u00e3o processamos seu relat\u00f3rio no endpoint oficial (<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>); apenas removemos links n\u00e3o permitidos. O c\u00f3digo est\u00e1 aqui: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">c\u00f3digo-fonte</a>. Isso \u00e9 usado apenas para exibir informa\u00e7\u00f5es sobre sua falha e o link para os logs. No entanto, \u00e9 poss\u00edvel usar um endpoint personalizado que pode n\u00e3o usar os mesmos m\u00e9todos. Voc\u00ea est\u00e1 usando o site de relat\u00f3rios " + Config.obtenerInstancia().obtenerSitoDeInformes() + " e o site de logs " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + ". Voc\u00ea tamb\u00e9m pode compartilhar logs individuais sem um relat\u00f3rio clicando nos bot\u00f5es de compartilhamento ao lado dos nomes dos logs individuais; os logs ser\u00e3o enviados ao site de logs selecionado. O CrashDetector possui anonimiza\u00e7\u00e3o padr\u00e3o de logs, que tenta remover nomes de usu\u00e1rio, UUIDs, tokens de acesso, IDs de sess\u00e3o, endere\u00e7os IP e outros dados. No entanto, n\u00e3o \u00e9 perfeita. Ainda assim, o autor do modpack pode desativ\u00e1-la. Ela pode ser ativada ou desativada pela caixa de sele\u00e7\u00e3o na parte inferior desta tela. Voc\u00ea \u00e9 o controlador dos seus pr\u00f3prios dados; cabe a voc\u00ea decidir onde enviar seus dados. Os sites de logs s\u00e3o de propriedade de terceiros cuja titularidade muitas vezes \u00e9 ocultada por motivos de privacidade. Voc\u00ea assume total responsabilidade pela gest\u00e3o dos seus dados e pelos riscos envolvidos. A Caixa de Di\u00e1logo de Compartilhamento do CrashDetector \u00e9 apenas uma interface que permite gerenciar isso. \u00c9 importante que voc\u00ea esteja ciente do GDPR e ARCO. Se voc\u00ea estiver na Europa, pode usar o <a href=\"https://securelogger.top\">securelogger.top</a> hospedado na Alemanha pela Hetzner. Para mais informa\u00e7\u00f5es legais, consulte os seguintes links: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>, <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>, <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">Pol\u00edtica B\u00e1sica de Prote\u00e7\u00e3o de Dados Pessoais no Jap\u00e3o</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "Link do Relat\u00f3rio:";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "Salvar Configura\u00e7\u00e3o de Compartilhamento";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "O registro \u00e9 muito grande para este site de registro. Escolha outro e tente novamente.";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "Erro ao publicar registro " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "A API de Registro n\u00e3o existe. Por favor, altere a API de registro nas configura\u00e7\u00f5es.";
    }

    @Override
    public String errorSSL() {
        return "Voc\u00ea est\u00e1 com um Erro SSL. Isso \u00e9 comum em vers\u00f5es antigas do Java, incluindo as vers\u00f5es do Java 8 no Launcher Minecraft padr\u00e3o e as vers\u00f5es em sun.com e java.com. Isso afeta v\u00e1rios aspectos, como os arquivos JAR do instalador do MinecraftForge, a fun\u00e7\u00e3o de compartilhar relat\u00f3rios do CrashDetector ao usar o endpoint padr\u00e3o, alguns mods que exigem internet e alguns sites de registro. Se isso acontecer enquanto voc\u00ea tenta compartilhar um relat\u00f3rio, basta anexar uma captura de tela e selecionar um site de registro compat\u00edvel com vers\u00f5es mais antigas do Java 8.";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>JavaFML Incompat\u00edvel: Requer vers\u00e3o " + requerido + ", detectado " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Aten\u00e7\u00e3o! JavaFML requer uma vers\u00e3o espec\u00edfica do Minecraft Forge</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O arquivo JAR '" + archivoJar + "' requer o provedor de linguagem '" + proveedor + "' vers\u00e3o '" + requerido + "' ou superior, mas apenas a vers\u00e3o '" + encontrado + "' foi encontrada.</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>ALERTA! O Crash Assistant \u00e9 um detector de malware falso. Ele bloqueia intencionalmente o lan\u00e7amento do jogo, ignorando sua liberdade de continuar jogando com os mods que ele visa. <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>Ver c\u00f3digo MalwareMod.java</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>Ver c\u00f3digo JarInJarHelper.java</a>. Apenas este mod est\u00e1 na lista deles no momento, e eles est\u00e3o realmente indo atr\u00e1s apenas do site de registro padr\u00e3o, que pode ser alterado pelo usu\u00e1rio, e isso s\u00f3 ocorre se voc\u00ea escolher explicitamente usar o recurso integrado de compartilhamento de logs. O CrashAssistant N\u00c3O faz nenhuma verifica\u00e7\u00e3o para determinar qual site de registro est\u00e1 sendo usado e n\u00e3o explica como alter\u00e1-lo (h\u00e1 um menu suspenso na parte inferior da caixa de di\u00e1logo de compartilhamento), e independentemente do site configurado, o CrashAssistant bloquear\u00e1 o lan\u00e7amento do jogo. Em sua mensagem, eles dizem para fazer sua pr\u00f3pria pesquisa, FA\u00c7A ISSO, examine o c\u00f3digo do CrashDetector e do Crash Assistant e entenda o que eles fazem, N\u00c3O confie em uma apela\u00e7\u00e3o \u00e0 autoridade.</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String classeNaoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + idMod + "' falhou porque a classe necess\u00e1ria n\u00e3o foi encontrada: '" + classeNaoEncontrada + "'. Certifique-se de que todas as depend\u00eancias est\u00e3o instaladas corretamente.</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O Watermedia bloqueou o uso do TLauncher.</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea est\u00e1 usando uma vers\u00e3o do Optifine para uma vers\u00e3o obsoleta do Minecraft. Voc\u00ea precisa usar a vers\u00e3o do Optifine correspondente \u00e0 vers\u00e3o do Minecraft que voc\u00ea est\u00e1 usando.</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>N\u00e3o foi poss\u00edvel carregar o Servi\u00e7o do ModLauncher: </b>" + servicio + ".";
    }

    @Override
    public String errorConJSONDeRegistro(String arquivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro ao analisar o arquivo JSON '" + recurso + "' do arquivo JAR '" + arquivoJar + "'. H\u00e1 problemas com o registro.</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String atual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Erro: O mod '" + modId + "' requer a vers\u00e3o '" + requerido + "' ou superior de '" + dependencia + "', mas foi encontrada '" + atual + "'.</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sua GPU n\u00e3o suporta a vers\u00e3o do OpenGL necess\u00e1ria para esta vers\u00e3o do jogo. Atualize seus drivers ou troque sua placa gr\u00e1fica.</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Aumente a mem\u00f3ria alocada para o jogo ou reduza o uso de mods/plugins</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>JVM de 32 bits detectada: N\u00e3o pode usar mais de 4GB de RAM. Instale uma JVM de 64 bits para aproveitar toda a sua mem\u00f3ria dispon\u00edvel</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico de mem\u00f3ria PermGen. Aumente o espa\u00e7o de mem\u00f3ria permanente ou reduza a carga de classes</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro de compatibilidade entre Java 8 e vers\u00f5es modernas</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+ n\u00e3o suportado - Use Java 8 para vers\u00f5es antigas do Forge</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 8 necess\u00e1rio (vers\u00e3o 52.0). Atualize ou configure corretamente</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico de compatibilidade: Blocos n\u00e3o suportados nesta vers\u00e3o. Verifique se as vers\u00f5es dos mods e do servidor s\u00e3o compat\u00edveis</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro de configura\u00e7\u00e3o de monitores: N\u00e3o foi poss\u00edvel definir o modo de tela. Verifique:</b><br>- Configura\u00e7\u00e3o de m\u00faltiplos monitores<br>- Drivers de placa gr\u00e1fica atualizados<br>- Resolu\u00e7\u00e3o suportada pelo sistema";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro nas op\u00e7\u00f5es do Java: Op\u00e7\u00f5es conflitantes do coletor de lixo. Verifique se voc\u00ea n\u00e3o combina v\u00e1rios algoritmos GC nos par\u00e2metros da JVM</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico de configura\u00e7\u00e3o do NightConfig/Forge: Arquivo de configura\u00e7\u00e3o corrompido ou incompleto. Isso pode ser causado por arquivos de configura\u00e7\u00e3o vazios (muitas vezes de 0 bytes) na pasta 'config' em vers\u00f5es antigas ou personalizadas do NightConfig. Na maioria das vers\u00f5es, o Night Config Fixes resolver\u00e1 o problema, mas se voc\u00ea estiver usando uma vers\u00e3o incompat\u00edvel ou personalizada do NightConfig, precisar\u00e1 excluir os arquivos de configura\u00e7\u00e3o manualmente. Esse problema \u00e9 mais comum em vers\u00f5es antigas do MC Forge (que incluem o NightConfig) e em mods antigos do FabricMC que empacotam o NightConfig, mas tamb\u00e9m pode ocorrer em algumas vers\u00f5es personalizadas do NightConfig. Mais informa\u00e7\u00f5es sobre as solu\u00e7\u00f5es est\u00e3o dispon\u00edveis em <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a>.</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro de driver Intel HD Graphics detectado. Solu\u00e7\u00f5es:</b><br>1. Atualize os drivers Intel em <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a> (vers\u00e3o m\u00ednima 15.xx.xx.xx)<br>2. No Minecraft: Op\u00e7\u00f5es \u2192 V\u00eddeo \u2192 Ative 'Enable VBOs' e 'VSync'<br>3. Atribua 1GB-2GB de RAM ao jogo no launcher<br>4. Desative temporariamente o antiv\u00edrus/firewall durante a atualiza\u00e7\u00e3o";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "Aviso: Classes ausentes detectadas";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "Erro de renderiza\u00e7\u00e3o de blocos";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "An\u00e1lise de stack trace";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "Console CurseForge incompleta";
    }

    @Override
    public String nombre_de_early_window() {
        return "Erro de janela inicial (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "Problemas com drivers de v\u00eddeo";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "Configura\u00e7\u00e3o corrompida do MCForge";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "Falha no modo de exibi\u00e7\u00e3o (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "Erro de inicializa\u00e7\u00e3o do FabricMC";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "M\u00f3dulos JPMS ausentes";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "Classes cr\u00edticas ausentes";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "Depend\u00eancias ausentes do ModLauncher";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "Vers\u00f5es incompat\u00edveis do Java";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "Erro de recursos do KubeJS";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "Provedor de linguagem incompat\u00edvel";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "Erro Litchhost";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "Falso positivo de malware detectado";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "Mod suspeito detectado";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "Mods duplicados no ModLauncher";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "Conflitos de m\u00f3dulos JPMS";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "Sodium necess\u00e1rio para Iris";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "Erro ao analisar JSON de registro";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "Mem\u00f3ria insuficiente";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "Erro de ponteiro nulo (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "Op\u00e7\u00f5es inv\u00e1lidas de GC do Java";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "OptiFine obsoleta/incompat\u00edvel";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "Tick cr\u00edtico do servidor (60s)";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "Servi\u00e7os do ModLauncher falharam";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "Configura\u00e7\u00f5es problem\u00e1ticas do SpongeMixing";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus incompat\u00edvel";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "Launcher TLauncher n\u00e3o suportado pelo WATERMeDIA";
    }

    @Override
    public String auditorias_transformer() {
        return "Auditorias Transformer";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Estes s\u00e3o os resultados dos conte\u00fados das Auditorias Transformer no Launcher Vanilla. Geralmente, \u00e9 menos preciso que o analisador de StackTrace, mas o Launcher Vanilla nem sempre tem conte\u00fado para {}</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "Isso verifica seus mods em busca de mods criados com o MCreator. Embora a maioria dos mods do MCreator seja boa e existam muitos mods incr\u00edveis feitos com o MCreator, \u00e0s vezes eles t\u00eam problemas e uma m\u00e1 reputa\u00e7\u00e3o. Isso ajuda a identific\u00e1-los. Observe que at\u00e9 os mais bem avaliados podem n\u00e3o ser realmente do MCreator; por exemplo, podem ter integra\u00e7\u00e3o com o MCreator.";
    }

    @Override
    public String escanear() {
        return "Escanear";
    }

    @Override
    public String cargando() {
        return "Carregando";
    }

    @Override
    public String codigo() {
        return "pt";
    }

    @Override
    public String inicioApp() {
        return "In\u00edcio do Jogo/App";
    }

    @Override
    public String ajustesCrashDetector() {
        return "Configura\u00e7\u00f5es do CrashDetector";
    }

    @Override
    public String confidencialidad() {
        return "Privacidade";
    }

    @Override
    public String tooltip() {
        return "Dica de ferramenta";
    }

    @Override
    public String config() {
        return "Configura\u00e7\u00e3o";
    }

    @Override
    public String abrirCarpeta() {
        return "Abrir Pasta";
    }

    @Override
    public String actualizar() {
        return "Atualizar";
    }

    @Override
    public String anadirRegistro() {
        return "Adicionar Registro";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "Usar idioma do sistema";
    }

    @Override
    public String volver() {
        return "Voltar";
    }

    @Override
    public String colorFondo() {
        return "Cor de fundo (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "Cor do texto (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "Cor do bot\u00e3o (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "Cor da caixa de texto (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "Cor do link (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "Cor dos t\u00edtulos das consoles (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "Cor de erro (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "Cor de aviso (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "Cor de informa\u00e7\u00e3o (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "Cor do t\u00edtulo (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "Cor do texto do link (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "Abrir CrashDetector apenas em caso de falha";
    }

    @Override
    public String activar_parche() {
        return "Ativar Patch";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "Nenhuma solu\u00e7\u00e3o dispon\u00edvel";
    }

    @Override
    public String error() {
        return "erro";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "Erro ao excluir Jar";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar exclu\u00eddo com sucesso";
    }

    @Override
    public String exito() {
        return "sucesso";
    }

    @Override
    public String eliminar() {
        return "excluir";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "Erro ao excluir pacote";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "Pacote exclu\u00eddo com sucesso";
    }

    @Override
    public String eliminar_paquete() {
        return "Excluir pacote";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "Nenhum mod com pacote encontrado";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "N\u00e3o \u00e9 poss\u00edvel excluir o pacote";
    }

    @Override
    public String eliminar_jar() {
        return "Excluir jar";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "Nenhum mod duplicado encontrado";
    }

    @Override
    public String archivo_no_encontrado() {
        return "Arquivo N\u00e3o Encontrado";
    }

    @Override
    public String directorio_eliminado() {
        return "Diret\u00f3rio Exclu\u00eddo";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "Erro ao excluir Jar aninhado";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "Arquivo interno n\u00e3o encontrado";
    }

    @Override
    public String archivo_eliminado() {
        return "arquivo exclu\u00eddo";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "erro ao excluir arquivo";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "arquivo externo inv\u00e1lido";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "Elemento mod exclu\u00eddo";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "Erro ao substituir Jar externo";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "erro ao excluir elemento mod";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "erro ao excluir diret\u00f3rio";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "formato inv\u00e1lido para Jar aninhado";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "Jar aninhado exclu\u00eddo";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "erro ao limpar arquivos tempor\u00e1rios";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mensagem de Trace Fatal \u00daltima (N\u00e3o traduzida):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mensagem de Trace \u00daltima (N\u00e3o traduzida):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "Voc\u00ea pode pesquisar no banco de dados WaifuNeoForge para encontrar mods. Selecione a vers\u00e3o do jogo, o carregador de mods e a classe. Use a combina\u00e7\u00e3o mais pr\u00f3xima. Voc\u00ea pode pesquisar uma vez por minuto.";
    }

    @Override
    public String solucionFaltasClases() {
        return "Voc\u00ea pode pesquisar no banco de dados WaifuNeoForge para encontrar mods. Selecione a vers\u00e3o do jogo, o carregador de mods e a classe. Use a combina\u00e7\u00e3o mais pr\u00f3xima. Voc\u00ea pode pesquisar uma vez por minuto.";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "Ambos os lan\u00e7adores t\u00eam as vers\u00f5es corretas do Java, mas nem todas; voc\u00ea pode instalar a vers\u00e3o correta do Java a partir do gerenciador de pacotes no seu sistema ou usando os bot\u00f5es.";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Mod com Anima\u00e7\u00e3o Ausente: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException (Exce\u00e7\u00e3o Sem Elemento) Anima\u00e7\u00e3o Ausente";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "Nenhum mod foi encontrado para excluir";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "Substituir op\u00e7\u00f5es de GC conflitantes por -XX:+UseG1GC";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "Aumentar o tamanho da mem\u00f3ria heap usando a op\u00e7\u00e3o -Xmx.";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "Aumentar o tamanho da mem\u00f3ria permgen usando a op\u00e7\u00e3o -XX:MaxPermSize.";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "Usar uma JVM de 64 bits para aumentar a mem\u00f3ria dispon\u00edvel.";
    }

    @Override
    public String optimizarCodigo() {
        return "Otimizar o c\u00f3digo para reduzir o uso de mem\u00f3ria e melhorar o desempenho.";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "Usar um coletor de lixo eficiente para reduzir as pausas na aplica\u00e7\u00e3o.";
    }

    @Override
    public String modulos() {
        return "M\u00f3dulos";
    }

    @Override
    public String paquete() {
        return "Pacote";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "H\u00e1 IDs faltando. Causas comuns s\u00e3o mods faltando ou dados de itens faltando. Pastas de dados comuns s\u00e3o datafiedcontents/ e kubejs/ ou outras pastas de mods.";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "registros incorretamente mapeados";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin 'AuthMe' falhou ao carregar e desligou o servidor.</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "Problema de desligamento causado pelo AuthMe";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "A regra 'stopServer' mudou para 'true'.";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "Configure o plugin AuthMe (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "Instale uma vers\u00e3o diferente do plugin 'AuthMe'";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "Remover o plugin 'AuthMe'";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mundo '" + nombreMundo + "' n\u00e3o p\u00f4de ser carregado pois cont\u00e9m erros e provavelmente est\u00e1 corrompido.</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "Problema ao carregar mundo do Multiverse";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "Repare o mundo '" + nombreMundo + "', por exemplo usando Minecraft Region Fixer ou MCEdit.";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "Exclua a pasta do mundo '" + nombreMundo + "'.";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>A configura\u00e7\u00e3o da extens\u00e3o 'PermissionsEx' \u00e9 inv\u00e1lida.</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "Problema na configura\u00e7\u00e3o do PermissionsEx";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "Configure o plugin PermissionsEx (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "Remover o plugin 'PermissionsEx'";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>H\u00e1 m\u00faltiplos arquivos de plugins com o nome '" + nombrePlugin + "': '" + primerPath + "' e '" + segundoPath + "'.</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "Problema com nome amb\u00edguo de plugin";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "Remover o plugin '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Ocorreu uma exce\u00e7\u00e3o enquanto o mundo carregava os chunks. Se existir para sua plataforma, o FeatureRecycler poder\u00e1 resolver o problema. https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "Exce\u00e7\u00e3o ao carregar chunks";
    }

    @Override
    public String solucionEliminarChunk() {
        return "Remova o chunk problem\u00e1tico do mundo, por exemplo usando MCEdit ou excluindo o arquivo de regi\u00e3o.";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' n\u00e3o pode executar o comando '/" + comando + "'.</b> ";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "Exce\u00e7\u00e3o ao executar comando do plugin";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "Instale uma vers\u00e3o diferente do plugin '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' requer a seguinte depend\u00eancia: '" + dependencia + "'.</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' est\u00e1 faltando as seguintes depend\u00eancias: " + deps.toString() + ".</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "Depend\u00eancia de plugin ausente";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "Instale o plugin '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' requer a vers\u00e3o da API '" + versionAPI + "' que n\u00e3o \u00e9 compat\u00edvel com o servidor atual.</b> ";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "Vers\u00e3o de API incompat\u00edvel";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "Instale a vers\u00e3o '" + version + "' do software do seu servidor.";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mundo '" + nombreMundo + "' \u00e9 uma duplicata de outro mundo e n\u00e3o pode ser carregado.</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "Mundo Duplicado";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "Exclua o arquivo 'uid.dat' do mundo '" + nombreMundo + "'";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "Exclua a pasta do mundo '" + nombreMundo + "'";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>A entidade de bloco '" + nombre + "' do tipo '" + tipo + "' na localiza\u00e7\u00e3o " + coords + " est\u00e1 causando erros no ticking.</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "Entidade de Bloco Problem\u00e1tica";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "Remova a entidade '" + nombre + "' na localiza\u00e7\u00e3o " + coords + " usando MCEdit ou editando o mundo diretamente.";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' tem m\u00faltiplas vers\u00f5es instaladas.</b> ";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "Mod Duplicado no Fabric";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "Exclua o arquivo duplicado do mod: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Os mods '" + primerMod + "' e '" + segundoMod + "' s\u00e3o incompat\u00edveis entre si.</b> ";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "Mod Incompat\u00edvel no Fabric";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "Remova o mod '" + nombreMod + "'";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' tem um erro cr\u00edtico e n\u00e3o pode ser executado.</b> ";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "Mod com Erro Cr\u00edtico";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Os seguintes mods s\u00e3o necess\u00e1rios mas n\u00e3o est\u00e3o instalados: " + deps.toString() + ".</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' requer o mod '" + dependencia + "' como depend\u00eancia.</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' requer o mod '" + dependencia + "' na vers\u00e3o " + version + ".</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "Depend\u00eancia de mod ausente";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "Instale o mod '" + nombreMod + "'";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "Instale o mod '" + nombreMod + "' com a vers\u00e3o " + version;
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' n\u00e3o \u00e9 compat\u00edvel com o ticking regional do Folia.</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes plugins n\u00e3o s\u00e3o compat\u00edveis com o ticking regional do Folia: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "Plugin incompat\u00edvel com Ticking Regional";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "Instale uma vers\u00e3o sem ticking regional, como " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' est\u00e1 faltando no datapack.</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes mods est\u00e3o faltando no datapack: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" e ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "Mod ausente no datapack";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' causou um erro.</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes mods causaram erros: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" e ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "Mod do Forge com Exce\u00e7\u00e3o";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "Instale uma vers\u00e3o diferente do mod '" + nombreMod + "'";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' n\u00e3o \u00e9 compat\u00edvel com a vers\u00e3o do Minecraft " + versionMC + ".</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes mods n\u00e3o s\u00e3o compat\u00edveis com as respectivas vers\u00f5es do Minecraft: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (Minecraft ").append(versionesMC.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "Mod incompat\u00edvel com o Minecraft";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "Instale uma vers\u00e3o do Forge compat\u00edvel com o Minecraft " + versionMC;
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod '" + nombreMod + "' est\u00e1 faltando e \u00e9 necess\u00e1rio para carregar o mundo ou plugin.</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "Mod ausente";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mundo foi salvo com o mod '" + nombreMod + "' que parece estar ausente.</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("O mundo foi salvo com os seguintes mods que parecem estar ausentes: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" e ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "Mod ausente no mundo";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mundo foi salvo com o mod '" + nombreMod + "' na vers\u00e3o " + versionEsperada + ", e agora est\u00e1 na vers\u00e3o " + versionActual + ".</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes mods t\u00eam vers\u00f5es diferentes no mundo salvo: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" e ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (Salvo: ").append(versionesEsperadas.get(i)).append(", Atual: ").append(versionesActuales.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "Incompatibilidade de vers\u00e3o do mod no mundo salvo";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea tentou carregar um mundo criado com uma vers\u00e3o mais nova do Minecraft.</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "Tentativa de carregar mundo de vers\u00e3o superior";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "Instale uma vers\u00e3o mais recente do Minecraft.";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "Gere um novo mundo.";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' precisa do seguinte plugin como depend\u00eancia: '" + dependencia + "'.</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes plugins precisam de depend\u00eancias que n\u00e3o est\u00e3o instaladas: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("' (").append(dependencias.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "Plugin com depend\u00eancia ausente";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' \u00e9 incompat\u00edvel com a vers\u00e3o atual do servidor.</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes plugins s\u00e3o incompat\u00edveis com a vers\u00e3o atual do servidor: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" e ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "Plugin incompat\u00edvel com PocketMine-MP";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O plugin '" + nombrePlugin + "' causou um erro durante a execu\u00e7\u00e3o.</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Os seguintes plugins causaram erros durante a execu\u00e7\u00e3o: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" e ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "Plugin com erro de execu\u00e7\u00e3o";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "LegacyRandomSource Multi Threads";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea tem problemas com m\u00faltiplas threads acessando a classe LegacyRandomSource. Obtenha mais informa\u00e7\u00f5es usando o mod 'Unsafe World Random Access Detector' ou 'C2ME'.</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "Desde o \u00daltimo Sucesso";
    }

    @Override
    public String noHayCambios() {
        return "Sem Altera\u00e7\u00f5es";
    }

    @Override
    public String desdeUltimoIntento() {
        return "Desde a \u00daltima Tentativa";
    }

    @Override
    public String fallo() {
        return "Falhou";
    }

    @Override
    public String diferentesDeLasMods() {
        return "Diferente das Mods";
    }

    @Override
    public String historialDeMods() {
        return "Hist\u00f3rico de Mods";
    }

    @Override
    public String archivo0() {
        return "Arquivo0";
    }

    @Override
    public String archivo1() {
        return "Arquivo1";
    }

    @Override
    public String comparar() {
        return "Comparar";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "Selecionar Dois Arquivos";
    }

    @Override
    public String archivoExito() {
        return "Arquivo de Sucesso";
    }

    @Override
    public String archivoFalla() {
        return "Arquivo com Falha";
    }

    @Override
    public String errorComparandoArchivos() {
        return "Erro ao Comparar Arquivos";
    }

    @Override
    public String comparando() {
        return "Comparando";
    }

    @Override
    public String con() {
        return "Com";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'><p><b>Painel de Compara\u00e7\u00e3o do Hist\u00f3rico de Mods</b></p><p>Este painel permite comparar duas listas de mods de sess\u00f5es distintas. Selecione um arquivo na coluna esquerda e outro na direita para visualizar as altera\u00e7\u00f5es entre as vers\u00f5es.</p><h3>Como us\u00e1-lo:</h3><ol><li><b>Sele\u00e7\u00e3o de arquivos:</b> Clique nos bot\u00f5es de r\u00e1dio ao lado dos nomes dos arquivos. Arquivos terminados em <span style='color: #4CAF50; font-weight: bold;'>.sucesso</span> indicam sess\u00f5es bem-sucedidas, enquanto os com <span style='color: #F44336; font-weight: bold;'>.falha</span> representam erros ou falhas.</li><li><b>Compara\u00e7\u00e3o autom\u00e1tica:</b> Ao pressionar o bot\u00e3o 'Comparar', o sistema analisar\u00e1 as duas listas selecionadas e exibir\u00e1 quais mods foram adicionados (+) ou removidos (-).</li><li><b>Visualiza\u00e7\u00e3o dos resultados:</b> Os resultados s\u00e3o mostrados em formato HTML com cores codificadas: <ul><li><span style='color: green;'>+ Mod adicionado</span></li><li><span style='color: red;'>- Mod removido</span></li></ul></li></ol><h3>Principais caracter\u00edsticas:</h3><ul><li>Suporta qualquer combina\u00e7\u00e3o de arquivos (sucesso/falha).</li><li>Mostra diferen\u00e7as bidirecionais para identificar mudan\u00e7as exatas.</li><li>Inclui rolagem para listas longas de mods.</li><li>Cont\u00e9m imagens explicativas para melhor compreens\u00e3o visual.</li></ul><p>Desenvolvido com <3\ufe0f para ajudar no rastreamento de altera\u00e7\u00f5es nas suas configura\u00e7\u00f5es.</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea pode estar enfrentando um problema relacionado ao IPv6. H\u00e1 duas solu\u00e7\u00f5es: 1) Adicionar o argumento JVM <code>-Djava.net.preferIPv4Stack=true</code> no seu lan\u00e7ador, ou 2) Usar o bot\u00e3o 'QuickFix' no CrashDetector para aplicar um patch que ative automaticamente essa configura\u00e7\u00e3o.</b>";
    }

    @Override
    public String parcheIPv4() {
        return "Corre\u00e7\u00e3o IPv4/6";
    }

    @Override
    public String carpetaHMCL() {
        return "Pasta HMCL (Somente para HelloMineCraftLauncher)";
    }

    @Override
    public String descripcionCurseforge() {
        return "Nota: Nenhum registro \u00e9 gerado se a op\u00e7\u00e3o \"Pular Launcher\" estiver ativada em Configura\u00e7\u00f5es > Minecraft";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/Derivados: Clique com o bot\u00e3o direito na inst\u00e2ncia e selecione \"Editar Inst\u00e2ncia\". Na janela que abrir, procure pela se\u00e7\u00e3o \"Registros do Minecraft\" ou algo semelhante.<br>Esses registros cont\u00eam a sa\u00edda padr\u00e3o (STDOUT), essencial para diagnosticar erros.";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): Voc\u00ea deve selecionar a pasta onde o HMCL est\u00e1 instalado e escolher a pasta \".hmcl\". Os registros do HMCL s\u00e3o salvos nesse local e cont\u00eam informa\u00e7\u00f5es importantes sobre erros.<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix: O lan\u00e7ador tem uma aba de desenvolvedor com registros detalhados. Voc\u00ea pode encontrar essa aba no menu de configura\u00e7\u00f5es do lan\u00e7ador.";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher: Existe uma janela pop-up com os registros. Possui bot\u00f5es para copiar e enviar os registros. Os registros s\u00e3o gerados automaticamente ao iniciar o jogo e cont\u00eam informa\u00e7\u00f5es cr\u00edticas para diagn\u00f3stico.";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher: Clique com o bot\u00e3o direito na inst\u00e2ncia e selecione \"Configura\u00e7\u00f5es\". Em seguida, v\u00e1 \u00e0 se\u00e7\u00e3o de Registros para visualizar a informa\u00e7\u00e3o importante da sa\u00edda padr\u00e3o (STDOUT).";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "Links em Markdown: Cole aqui qualquer link que contenha registros em formato Markdown. O sistema tentar\u00e1 extrair automaticamente os links dos registros (latest.log, launcher_log.txt, debug.log, etc.) e analis\u00e1-los.";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "Registro do Launcher N\u00e3o Encontrado";
    }

    @Override
    public String imagenNoEncontrada() {
        return "Imagem n\u00e3o encontrada";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "GEN\u00c9RICO: Selecione o tipo de launcher que voc\u00ea est\u00e1 usando. Os registros do launcher (launcher_log.txt, stdout, etc.) cont\u00eam informa\u00e7\u00f5es vitais sobre erros que n\u00e3o aparecem no latest.log. O CrashDetector n\u00e3o consegue ler os registros do seu launcher \u2014 talvez ele n\u00e3o gere um arquivo, ent\u00e3o voc\u00ea precisa colar os registros manualmente.<br>Para mais informa\u00e7\u00f5es, veja <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">esta quest\u00e3o</a>. Esses registros cont\u00eam a sa\u00edda padr\u00e3o (STDOUT), essencial para diagnosticar muitos tipos de erro.";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Classes ausentes do Create detectadas. O Create mudou muito \u2014 muitas classes foram removidas. Especialmente desde o Create 6 (fevereiro de 2025), addons para vers\u00f5es antigas do Create n\u00e3o funcionam mais. O QuickFix n\u00e3o tem solu\u00e7\u00e3o para isso. Atualize seus addons do Create, remova os obsoletos ou use a vers\u00e3o correta do Create para os addons desejados.</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Classes ausentes do EpicFight detectadas. O EpicFight mudou muito \u2014 muitas classes foram removidas. O QuickFix n\u00e3o tem solu\u00e7\u00e3o para isso. Atualize seus addons do EpicFight, remova os obsoletos ou use a vers\u00e3o correta do EpicFight para os addons desejados.</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea est\u00e1 usando o OpenJ9, que n\u00e3o \u00e9 suportado por este aplicativo. Muitos programas, incluindo este, n\u00e3o suportam o OpenJ9 devido a diferen\u00e7as na implementa\u00e7\u00e3o da JVM. O QuickFix n\u00e3o pode resolver esse problema automaticamente. Voc\u00ea precisa instalar um JDK compat\u00edvel, como Oracle JDK, OpenJDK Hotspot ou outras alternativas recomendadas.</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Esta vers\u00e3o do aplicativo requer Java 11 (JDK 11) para funcionar corretamente. Voc\u00ea est\u00e1 usando uma vers\u00e3o antiga do Java que n\u00e3o \u00e9 compat\u00edvel. O QuickFix n\u00e3o pode atualizar seu Java automaticamente. Voc\u00ea precisa baixar e instalar o JDK 11 ou uma vers\u00e3o superior compat\u00edvel pelos links fornecidos na solu\u00e7\u00e3o.</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea alocou mem\u00f3ria em excesso, fazendo com que o sistema n\u00e3o tenha recursos suficientes. Isso ocorre quando a quantidade de RAM definida \u00e9 maior que a dispon\u00edvel ou ao usar uma JVM de 32 bits, que n\u00e3o lida bem com grandes aloca\u00e7\u00f5es.</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Para resolver, reduza a mem\u00f3ria alocada ao app. O m\u00e1ximo recomendado depende do seu sistema, mas geralmente n\u00e3o deve ultrapassar 70-80% da RAM total. Em JVMs de 32 bits, o limite \u00e9 de cerca de 2-3 GB, independentemente da RAM f\u00edsica.</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Para reduzir a mem\u00f3ria heap, abra as configura\u00e7\u00f5es do seu launcher e encontre a op\u00e7\u00e3o de mem\u00f3ria RAM. Reduza o valor m\u00e1ximo (Xmx) para um valor adequado. Exemplo: com 8 GB de RAM, use 3-4 GB; com 16 GB, use 6-8 GB. Deixe mem\u00f3ria suficiente para o sistema operacional e outros programas.</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Faltan archivos esenciales de Forge. El archivo '" + archivo + "' no se encuentra en tu instalaci\u00f3n. Esto suele ocurrir cuando la instalaci\u00f3n de Forge se interrumpi\u00f3 o se eliminaron archivos importantes. QuickFix no puede recuperar estos archivos autom\u00e1ticamente. Necesitas reinstalar Forge correctamente desde el instalador oficial.</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge no puede encontrar la versi\u00f3n de Minecraft requerida. Se necesita la versi\u00f3n " + version + " pero no se encuentra en el archivo '" + archivo + "'. Esto ocurre cuando hay una incompatibilidad entre la versi\u00f3n de Minecraft y la versi\u00f3n de Forge que est\u00e1s utilizando. Aseg\u00farate de descargar la versi\u00f3n correcta de Forge que coincida con tu versi\u00f3n de Minecraft.</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No se puede encontrar el target 'fmlclient' necesario para iniciar Forge. Esto indica que la instalaci\u00f3n de Forge est\u00e1 incompleta o da\u00f1ada. Es probable que los archivos esenciales de Forge no se hayan instalado correctamente. Necesitas reinstalar Forge usando el instalador oficial.</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>No se puede encontrar la clase principal de Minecraft en el cargador de clases. Esto suele indicar que la instalaci\u00f3n de Forge est\u00e1 incompleta o que hay un conflicto con otros mods. Es posible que los archivos de Minecraft se hayan da\u00f1ado durante la instalaci\u00f3n de Forge. Necesitas reinstalar Forge correctamente.</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>La instalaci\u00f3n de Forge no est\u00e1 completa. Esto puede deberse a una instalaci\u00f3n interrumpida, archivos eliminados o una incompatibilidad con tu versi\u00f3n de Minecraft. Forge necesita archivos espec\u00edficos para funcionar correctamente, y algunos de ellos est\u00e1n faltando en tu instalaci\u00f3n actual.</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "Instalaci\u00f3n incompleta de Forge";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Para resolver este problema, necesitas reinstalar Forge correctamente. Aseg\u00farate de descargar la versi\u00f3n adecuada para tu versi\u00f3n de Minecraft y seguir el proceso de instalaci\u00f3n completo sin interrumpirlo.</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "Descargar Forge oficialmente";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "C\u00f3mo reinstalar Forge correctamente";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>Instrucciones para reinstalar Forge:</h3><ol><li>Descarga el instalador correcto de Forge desde el sitio oficial (versi\u00f3n recomendada para tu versi\u00f3n de Minecraft)</li><li>Cierra completamente tu launcher de Minecraft</li><li>Ejecuta el instalador de Forge como administrador</li><li>Selecciona la opci\u00f3n 'Installer' (no 'Installer (run client)')</li><li>Elige la carpeta de tu perfil de Minecraft en el launcher</li><li>Presiona 'OK' y espera a que termine la instalaci\u00f3n</li><li>Reinicia tu launcher y verifica que Forge aparezca en la lista de perfiles</li></ol><p><b>Nota importante:</b> Si usas un launcher personalizado, aseg\u00farate de seleccionar la carpeta correcta del perfil.</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "Instrucciones para reinstalar Forge";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Unsatisfied Link Error: Failed to load library " + nombreBiblioteca + ". Possible solutions:<br/><br/>a) Add the directory containing the shared library to -Djava.library.path or -Dorg.lwjgl.librarypath.<br/>b) Add the JAR file containing the shared library to the classpath.<br/><br/>This error occurs when Minecraft cannot locate essential files for execution. It is usually caused by an incomplete Minecraft installation or system permission issues.</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "Unsatisfied Link Error";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Failed to load a library. Possible solutions:<br/><br/>a) Add the directory containing the shared library to -Djava.library.path or -Dorg.lwjgl.librarypath.<br/>b) Add the JAR file containing the shared library to the classpath.<br/><br/>These technical solutions are intended for advanced users. Most users should try reinstalling Minecraft before modifying these parameters.</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Conflito de ID: O ID <strong>" + id + "</strong> j\u00e1 est\u00e1 em uso pelo <strong>" + modOrigen + "</strong> ao tentar adicionar <strong>" + modDestino + "</strong>. Isso ocorre quando dois mods tentam usar o mesmo ID para elementos diferentes.</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O limite m\u00e1ximo de IDs permitidos foi excedido. Isso acontece quando mods tentam registrar blocos ou itens com IDs fora do intervalo suportado pela sua vers\u00e3o do Minecraft.</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "Conflito de ID";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Para resolver isso no Minecraft 1.12.2, instale <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a>. Para 1.7.10, use <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a>.</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>Use ferramentas como <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> ou <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a> para resolver conflitos de ID.</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "Instalar JustEnoughIDs";
    }

    @Override
    public String instalar_endlessids() {
        return "Instalar EndlessIDs";
    }

    @Override
    public String usar_idfix_minus() {
        return "Usar IdFix Minus ou IdFix";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "Usar Minecraft-ID-Resolver";
    }

    @Override
    public String ver_documentacion_jp() {
        return "Ver documenta\u00e7\u00e3o em japon\u00eas";
    }

    @Override
    public String escanearDeMCreator() {
        return "Escanear MCreator";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\u00c1rvore de M\u00f3dulos e Classes";
    }

    @Override
    public String tipoBusqueda() {
        return "Tipo";
    }

    @Override
    public String filtroTodos() {
        return "Todos";
    }

    @Override
    public String filtroPaquetes() {
        return "Pacotes";
    }

    @Override
    public String filtroClases() {
        return "Classes";
    }

    @Override
    public String filtroMetodos() {
        return "M\u00e9todos";
    }

    @Override
    public String filtroCampos() {
        return "Campos";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "Refer\u00eancias de Campo";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "Refer\u00eancias de M\u00e9todo";
    }

    @Override
    public String filtroReferenciasClase() {
        return "Refer\u00eancias de Classe";
    }

    @Override
    public String tipBuscar() {
        return "Digite aqui para pesquisar na \u00e1rvore de mods";
    }

    @Override
    public String botonBuscar() {
        return "Pesquisar";
    }

    @Override
    public String botonResetearArbol() {
        return "Redefinir \u00c1rvore";
    }

    @Override
    public String modsCargados() {
        return "Mods Carregados";
    }

    @Override
    public String clases() {
        return "Classes";
    }

    @Override
    public String metodos() {
        return "M\u00e9todos";
    }

    @Override
    public String campos() {
        return "Campos";
    }

    @Override
    public String referencias() {
        return "Refer\u00eancias";
    }

    @Override
    public String resultadosBusqueda() {
        return "Resultados da Pesquisa";
    }

    @Override
    public String buscarReferencias() {
        return "Buscar Refer\u00eancias";
    }

    @Override
    public String referenciasMod() {
        return "Refer\u00eancias do Mod";
    }

    @Override
    public String referenciasClase() {
        return "Refer\u00eancias da Classe";
    }

    @Override
    public String referenciasMetodo() {
        return "Refer\u00eancias do M\u00e9todo";
    }

    @Override
    public String referenciasCampo() {
        return "Refer\u00eancias do Campo";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "Nenhuma refer\u00eancia encontrada";
    }

    @Override
    public String detalleMod() {
        return "Detalhes do Mod:";
    }

    @Override
    public String ubicacion() {
        return "Localiza\u00e7\u00e3o";
    }

    @Override
    public String nombres() {
        return "Nomes";
    }

    @Override
    public String modulo() {
        return "M\u00f3dulo";
    }

    @Override
    public String detalleClase() {
        return "Detalhes da Classe:";
    }

    @Override
    public String detalleMetodo() {
        return "Detalhes do M\u00e9todo:";
    }

    @Override
    public String detalleCampo() {
        return "Detalhes do Campo:";
    }

    @Override
    public String clase() {
        return "Classe";
    }

    @Override
    public String tipo() {
        return "Tipo";
    }

    @Override
    public String referenciasAMetodos() {
        return "Refer\u00eancias para M\u00e9todos:";
    }

    @Override
    public String referenciasACampos() {
        return "Refer\u00eancias para Campos:";
    }

    @Override
    public String arbolDeMods() {
        return "\u00c1rvore de Mods";
    }

    @Override
    public String metodo() {
        return "M\u00e9todo";
    }

    @Override
    public String campo() {
        return "Campo";
    }

    @Override
    public String descompilar() {
        return "Descompilar";
    }

    @Override
    public String exportar() {
        return "Exportar";
    }

    @Override
    public String importar() {
        return "Importar";
    }

    @Override
    public String errorImportar() {
        return "Erro ao Importar";
    }

    @Override
    public String estructuraImportada() {
        return "Estrutura Importada";
    }

    @Override
    public String estructuraExportada() {
        return "Estrutura Exportada";
    }

    @Override
    public String errorExportar() {
        return "Erro ao Exportar";
    }

    @Override
    public String exportando() {
        return "Exportando";
    }

    @Override
    public String exportacionTardara() {
        return "A exporta\u00e7\u00e3o pode demorar";
    }

    @Override
    public String porFavorEspere() {
        return "Aguarde";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Voc\u00ea n\u00e3o possui os bin\u00e1rios do VLC. O WaterMedia requer os bin\u00e1rios do VLC. Instale manualmente em https://www.videolan.org/vlc/.  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "Baixar VLC";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico: O nome do m\u00f3dulo '" + nombreModulo + "' cont\u00e9m caracteres inv\u00e1lidos. A parte '" + parteInvalida + "' n\u00e3o \u00e9 um identificador Java v\u00e1lido. Isso ocorre quando um mod usa palavras reservadas do Java (como 'true', 'class') ou caracteres n\u00e3o permitidos em seu nome.</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "Caracteres Inv\u00e1lidos no Nome do Mod";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "O nome do mod '" + nombreModulo + "' \u00e9 inv\u00e1lido porque cont\u00e9m '" + parteInvalida + "', que \u00e9 uma palavra reservada do Java ou um caractere inv\u00e1lido. Procure nos logs qual mod corresponde a esse nome (geralmente o nome do arquivo JAR)";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "Acesse a pasta do mod e edite o arquivo <b>mods.toml</b> dentro da pasta <b>/META-INF/</b>. Altere o valor de <b>modId</b> para usar apenas letras, n\u00fameros e sublinhados, sem palavras reservadas do Java";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "Exemplo de nome v\u00e1lido: 'truemod_shot_enchantment' em vez de 'true.shot.enchantment'. Lembre-se que nomes de mods n\u00e3o podem conter pontos, h\u00edfens ou palavras reservadas do Java como 'true', 'false' ou 'class'";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico com o mod: '" + nombreJar + "'. Falta o campo obrigat\u00f3rio 'mandatory' em suas depend\u00eancias. Isso ocorre quando o arquivo mods.toml n\u00e3o especifica se a depend\u00eancia \u00e9 obrigat\u00f3ria.</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "Depend\u00eancia de Mod com Campo 'mandatory' Ausente";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "O mod problem\u00e1tico \u00e9: <b>" + nombreJar + "</b>. Este arquivo tem um erro na configura\u00e7\u00e3o de depend\u00eancias";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "Abra o arquivo <b>mods.toml</b> dentro da pasta <b>/META-INF/</b> do mod <b>" + nombreJar + "</b>";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "Na se\u00e7\u00e3o de depend\u00eancias, certifique-se de que cada entrada inclua <b>mandatory=true</b> ou <b>mandatory=false</b> (ex: modId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" )";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico com o mod: '" + nombreJar + "'. Configura\u00e7\u00e3o inv\u00e1lida de access transformer. Isso ocorre quando o arquivo de configura\u00e7\u00e3o tem sintaxe incorreta ou refer\u00eancias a classes/m\u00e9todos inexistentes.</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "Access Transformer Inv\u00e1lido";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "O mod problem\u00e1tico \u00e9: <b>" + nombreJar + "</b>. Este mod cont\u00e9m uma configura\u00e7\u00e3o inv\u00e1lida de access transformer";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "Abra o arquivo <b>accessTransformer.cfg</b> dentro do mod <b>" + nombreJar + "</b> (normalmente na pasta raiz do arquivo JAR)";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "Corrija a sintaxe do access transformer. As linhas devem seguir o formato: <b>access class.method</b> (ex: public net.minecraft.world.entity.Entity.func_200560_a). Remova linhas com refer\u00eancias a classes ou m\u00e9todos que n\u00e3o existam na sua vers\u00e3o do Minecraft";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico: Discrep\u00e2ncia entre o ID do mod na anota\u00e7\u00e3o @Mod e o arquivo mods.toml. O mod '" + nombreMod + "' n\u00e3o pode ser carregado porque os IDs n\u00e3o coincidem.</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "Discrep\u00e2ncia entre @Mod e mods.toml";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "O mod em desenvolvimento '" + nombreMod + "' tem uma discrep\u00e2ncia entre o ID na anota\u00e7\u00e3o <b>@Mod</b> e o valor em <b>mods.toml</b>";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "Verifique se o ID na sua classe principal coincide com o valor <b>modId</b> no arquivo <b>/META-INF/mods.toml</b>. Exemplo: <b>@Mod(\"meumod\")</b> deve coincidir com <b>modId=\"meumod\"</b>";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "Se estiver usando Gradle, execute <b>clean</b> ap\u00f3s altera\u00e7\u00f5es para garantir que os recursos sejam atualizados corretamente. \u00c0s vezes, arquivos antigos permanecem na pasta build";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "cliente" : "servidor";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "servidor" : "cliente";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico: Tentando carregar a classe '" + nombreClase + "' no ambiente de " + plataforma + ", mas ela foi feita para " + plataformaOpuesta + ". <b>Use a fun\u00e7\u00e3o '\u00c1rvore de Mods' na barra lateral para descobrir qual mod est\u00e1 tentando carregar esta classe</b>. Mods s\u00e3o feitos especificamente para uma plataforma e n\u00e3o funcionam na outra.</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "Mod em Plataforma Incorreta";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "Na aba <b>\u00c1rvore de Mods</b> (\u00e0 direita), busque refer\u00eancias \u00e0 classe <b>" + nombreClase + "</b> para identificar qual mod est\u00e1 causando o problema";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "cliente" : "servidor";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "servidor" : "cliente";
        return "O mod identificado \u00e9 um mod de <b>" + plataformaOpuesta + "</b> e n\u00e3o deve ser usado em seu ambiente de " + plataforma + ".";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "Remova o mod problem\u00e1tico da pasta <b>mods</b>. Se precisar de funcionalidade semelhante nesta plataforma, procure um mod alternativo feito especificamente para <b>cliente</b> ou <b>servidor</b>, conforme necess\u00e1rio";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Erro cr\u00edtico: Falta metadados para o modid '").append(modIdFaltante).append("'. ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("Os seguintes mods podem estar causando o problema: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", e outros...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Isso ocorre quando um mod depende de outro que n\u00e3o est\u00e1 instalado ou tem um arquivo mods.toml incorreto.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "Metadados mods.toml Ausentes";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("Os seguintes mods dependem de '").append(modIdFaltante).append("': <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", e outros...");
            }
            paso.append("</b>. Use a fun\u00e7\u00e3o <b>\u00c1rvore de Mods</b> para confirmar qual mod est\u00e1 causando o problema");
            return paso.toString();
        }
        return "Um mod est\u00e1 tentando depender de '" + modIdFaltante + "', mas este mod n\u00e3o est\u00e1 instalado. Use a fun\u00e7\u00e3o <b>\u00c1rvore de Mods</b> para identificar qual mod est\u00e1 causando o problema";
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "Voc\u00ea tem duas op\u00e7\u00f5es:<br/>1. <b>Instale o mod ausente</b>: Encontre e instale o mod com ID '" + modIdFaltante + "'<br/>2. <b>Remova o mod dependente</b>: Se n\u00e3o precisar da funcionalidade, remova o mod que depende de '" + modIdFaltante + "'";
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "Se o mod '" + modIdFaltante + "' for uma biblioteca (como 'forge', 'minecraft', 'curios'), certifique-se de ter as vers\u00f5es corretas do Minecraft e do Forge instaladas. Se for um mod comum, verifique na p\u00e1gina de download os pr\u00e9-requisitos necess\u00e1rios";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Aviso: Falha ao iniciar o sistema de som. Sons e m\u00fasica foram desativados. Esse erro est\u00e1 comumente associado ao mod SoundPhysicsMod e pode ser causado por conflitos com outras bibliotecas de \u00e1udio.</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "Erro no Sistema de Som";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "O erro est\u00e1 comumente relacionado ao <b>SoundPhysicsMod</b>. Verifique se voc\u00ea tem a vers\u00e3o mais recente compat\u00edvel com sua vers\u00e3o do Minecraft";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "Se voc\u00ea usa outros mods de som (como Sound Filters, Dynamic Surroundings, etc.), tente remover temporariamente o SoundPhysicsMod para ver se resolve o conflito";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "Verifique a pasta <b>logs</b> para mensagens adicionais relacionadas a LWJGL ou OpenAL, que podem indicar problemas com as bibliotecas de som subjacentes";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Erro cr\u00edtico: A classe '").append(nombreClase).append("' est\u00e1 registrada como ouvinte de eventos, mas n\u00e3o possui m\u00e9todos v\u00e1lidos. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("Esta classe est\u00e1 presente nos seguintes mods: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", e outros...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Isso ocorre quando uma classe \u00e9 registrada para escutar eventos sem ter m\u00e9todos anotados com @SubscribeEvent.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "Classe Registrada sem Ouvintes de Eventos";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("A classe problem\u00e1tica est\u00e1 nestes mods: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", e outros...");
            }
            paso.append("</b>. Esses mods est\u00e3o tentando registrar eventos sem m\u00e9todos v\u00e1lidos");
            return paso.toString();
        }
        return "A classe <b>" + nombreClase + "</b> foi registrada para escutar eventos, mas n\u00e3o possui m\u00e9todos com a anota\u00e7\u00e3o <b>@SubscribeEvent</b>. Use a fun\u00e7\u00e3o <b>\u00c1rvore de Mods</b> para identificar qual mod cont\u00e9m esta classe";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "No c\u00f3digo-fonte, verifique que a classe <b>" + nombreClase + "</b> contenha pelo menos um m\u00e9todo com: <b>@SubscribeEvent public void nomeMetodo(EventoEspecifico evento) { ... }</b>. Se for uma classe interna, certifique-se de que n\u00e3o esteja marcada como est\u00e1tica";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("Para os mods identificados (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", etc.");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("contate o desenvolvedor desse mod para corrigir o problema. ");
            } else {
                paso.append("contate os desenvolvedores desses mods para corrigir o problema. ");
            }
        }
        paso.append("Se voc\u00ea for o desenvolvedor, remova o registro dessa classe no EventBus ou adicione m\u00e9todos @SubscribeEvent v\u00e1lidos");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico: Ocorreu uma exce\u00e7\u00e3o 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' ao processar o arquivo '" + nombreArchivo + "'. Este erro espec\u00edfico indica que o launcher n\u00e3o baixou ou extraiu corretamente os arquivos do modpack. A mensagem 'zip END header not found' revela que o arquivo JAR est\u00e1 incompleto ou corrompido, o que \u00e9 extremamente comum em launchers que gerenciam mal o download de arquivos grandes. Este problema afeta principalmente usu\u00e1rios do Twitch/CurseForge, Technic Launcher e especialmente usu\u00e1rios do Luna Pixel, pois esses launchers muitas vezes falham em verificar a integridade completa dos arquivos baixados. Usu\u00e1rios do Luna Pixel deveriam considerar o ATLauncher como uma alternativa mais est\u00e1vel, pois ele lida melhor com a integridade dos arquivos e evita esse erro espec\u00edfico. O sistema n\u00e3o pode carregar os mods porque o formato ZIP est\u00e1 danificado, impedindo que o Forge leia os recursos necess\u00e1rios para iniciar o jogo.</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "Erro UnionFileSystem - Arquivo Corrompido";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "Reinstale completamente o modpack do zero";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "Se voc\u00ea usa Luna Pixel, mude para o ATLauncher";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "Verifique sua conex\u00e3o com a internet e espa\u00e7o em disco antes de reinstalar";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "Habilitar ProxySysOutSysErr?\n\nEsta op\u00e7\u00e3o d\u00e1 ao CrashDetector acesso ao System.out e System.err quando o launcher n\u00e3o fornece registros.\n\nDeve ser habilitada apenas quando voc\u00ea n\u00e3o conseguir colar um log manualmente.\n\nAviso: Isso pode interferir com alguns mods ou launchers.\n\n\u00c9 necess\u00e1rio reiniciar o jogo/aplicativo para que as altera\u00e7\u00f5es tenham efeito.";
    }

    @Override
    public String confirmacionTitulo() {
        return "Confirma\u00e7\u00e3o";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr habilitado com sucesso.\n\n\u00c9 necess\u00e1rio reiniciar o CrashDetector para que as altera\u00e7\u00f5es tenham efeito.";
    }

    @Override
    public String informacionTitulo() {
        return "Informa\u00e7\u00e3o";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("Erro cr\u00edtico: AzureLib e GeckoLib foram inicializados muito cedo! ");
        } else if (azureLibError) {
            mensaje.append("Erro cr\u00edtico: AzureLib foi inicializado muito cedo! ");
        } else if (geckoLibError) {
            mensaje.append("Erro cr\u00edtico: GeckoLib foi inicializado muito cedo! ");
        }
        mensaje.append("Esse erro ocorre ao tentar usar mods Fabric com vers\u00f5es n\u00e3o-Fabric dessas bibliotecas. ");
        if (connectorPresente) {
            mensaje.append("Um mod de compatibilidade (Sinytra Connector ou specialcompatibilityoperation) foi detectado, indicando que voc\u00ea est\u00e1 tentando usar mods Fabric em um ambiente Forge ou FeatureCreep. ");
            mensaje.append("Verifique o erro 'Erro de inicializa\u00e7\u00e3o do FabricMC' nos logs para identificar qual mod espec\u00edfico est\u00e1 causando o problema. ");
        }
        mensaje.append("AzureLib e GeckoLib s\u00e3o bibliotecas essenciais para mods de anima\u00e7\u00e3o, mas devem corresponder \u00e0 plataforma correta (Fabric ou Forge). ");
        mensaje.append("O jogo n\u00e3o pode carregar corretamente os mods de anima\u00e7\u00e3o devido a esse conflito de inicializa\u00e7\u00e3o.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "Biblioteca Inicializada Muito Cedo";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "Verifique o erro 'Erro de inicializa\u00e7\u00e3o do FabricMC' nos logs para identificar o mod problem\u00e1tico";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "Verifique se est\u00e1 usando a vers\u00e3o correta do AzureLib/GeckoLib para sua plataforma (Forge ou Fabric)";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico: Incompatibilidade entre C2ME e mods de conex\u00e3o. Este erro ocorre porque o C2ME tenta acessar componentes internos do Java que s\u00e3o restritos em ambientes com Sinytra Connector ou specialcompatibilityoperation ou outros mods de compatibilidade Fabric/Forge. <b>O C2ME n\u00e3o \u00e9 compat\u00edvel com esses ambientes, mas <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> \u00e9 a alternativa recomendada</b> que funciona corretamente com mods de conex\u00e3o. O jogo n\u00e3o pode iniciar devido a conflitos de permiss\u00e3o de seguran\u00e7a do Java.</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "Incompatibilidade do C2ME com Mods de Conex\u00e3o";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "Remova o C2ME da pasta de mods";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "Baixe e instale <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> no lugar (compat\u00edvel com Sinytra Connector)";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "Verifique se todos os mods de conex\u00e3o (como Sinytra Connector) est\u00e3o atualizados para a vers\u00e3o mais recente";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro cr\u00edtico: Falha ao carregar o plugin JEI para o mod '" + modId + "'. A classe '" + nombreClase + "' (ID do plugin: '" + pluginId + "') gerou um erro que est\u00e1 fazendo o jogo crashar durante a inicializa\u00e7\u00e3o. Esse problema ocorre quando um mod possui uma integra\u00e7\u00e3o JEI incompat\u00edvel ou corrompida que interrompe a inicializa\u00e7\u00e3o do jogo.</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "Plugin JEI Falhou - Causa Crash";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "O mod <b>" + modId + "</b> cont\u00e9m um plugin JEI corrompido que est\u00e1 causando o crash. Use a fun\u00e7\u00e3o <b>\u00c1rvore de Mods</b> para confirmar qual mod est\u00e1 gerando o problema";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "Remova temporariamente o mod <b>" + modId + "</b> da pasta de mods para verificar se isso resolve o crash";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "Procure por atualiza\u00e7\u00f5es do mod <b>" + modId + "</b> ou entre em contato com seu desenvolvedor relatando o problema com o plugin JEI. Enquanto isso, o mod deve ser removido para conseguir iniciar o jogo";
    }

    @Override
    public String tituloLectador() {
        return "Leitor de Logs - Crash Detector";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "LEGENDA DE CORES";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "Erros cr\u00edticos";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "Rastros de pilha";
    }

    @Override
    public String obtenerTituloError() {
        return "Erro";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "Ocorreu um erro ao processar a linha selecionada";
    }

    @Override
    public String obtenerNombreError() {
        return "NOME DO ERRO";
    }

    @Override
    public String obtenerDescripcionError() {
        return "DESCRI\u00c7\u00c3O DETALHADA";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "SELECIONAR LOG";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "Erro n\u00e3o identificado";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "Um erro cr\u00edtico foi detectado nos logs. Verifique o rastro de pilha para identificar a causa raiz.";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "N\u00e3o foi poss\u00edvel ler o arquivo de log. Verifique se o arquivo existe e tem permiss\u00f5es de leitura.";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "Analisador de Logs";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("Erro cr\u00edtico: Falha ao registrar assinantes autom\u00e1ticos para o mod '").append(modId).append("'. ");
        mensaje.append("Classe problem\u00e1tica: <b>").append(nombreClase).append("</b>. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("Esta classe est\u00e1 localizada em: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", e outros...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("Este erro ocorre quando um mod tenta registrar uma classe como assinante de eventos automaticamente, mas a classe n\u00e3o pode ser carregada. ");
        mensaje.append("<b>Verifique outros erros no log, pois a causa real pode estar em um carregamento anterior falho</b>.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "Falha no Registro de Assinantes Autom\u00e1ticos";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "O mod <b>" + modId + "</b> est\u00e1 tentando registrar a classe <b>" + nombreClase + "</b> como assinante autom\u00e1tico, mas falhou. Verifique se esta classe existe e \u00e9 acess\u00edvel";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("A classe problem\u00e1tica <b>" + nombreClase + "</b> est\u00e1 nestes arquivos: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", e outros...");
            }
            paso.append("</b>. ");
            paso.append("Use a fun\u00e7\u00e3o <b>\u00c1rvore de Mods</b> para confirmar qual arquivo cont\u00e9m a classe problem\u00e1tica");
            return paso.toString();
        }
        return "A classe <b>" + nombreClase + "</b> n\u00e3o foi encontrada em nenhum arquivo de mod. Verifique se o mod <b>" + modId + "</b> est\u00e1 instalado corretamente. Use a fun\u00e7\u00e3o <b>\u00c1rvore de Mods</b> para ajudar a identificar o problema";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "Atualize o mod <b>" + modId + "</b> para a \u00faltima vers\u00e3o compat\u00edvel com sua vers\u00e3o do Minecraft e Forge. Se o problema persistir, contate o desenvolvedor do mod relatando o erro com a classe problem\u00e1tica";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "Verifique <b>outros erros no log</b> antes desta mensagem, pois o problema real pode estar em um carregamento anterior falhado. \u00c0s vezes um erro anterior impede o carregamento das classes necess\u00e1rias para o registro de eventos";
    }

    @Override
    public String limpiado() {
        return "Limpo";
    }

    @Override
    public String original() {
        return "Original";
    }

    @Override
    public String verEnConsola() {
        return "Ver no Log";
    }

    @Override
    public String advertencia() {
        return "Aviso";
    }

    @Override
    public String fatal() {
        return "Fatal";
    }

    @Override
    public String noRegistroDeBattly() {
        return "O BattlyLauncher n\u00e3o possui um log ou console dispon\u00edvel para copiar. Voc\u00ea pode usar o ProxySysOutSysErr para interceptar STDOUT e STDERR reiniciando o jogo, mas o ProxySysOutSysErr pode entrar em conflito com mods que modificam STDOUT ou STDERR";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "Voc\u00ea precisa habilitar o modo de depura\u00e7\u00e3o nas configura\u00e7\u00f5es do NightWorld para obter um log do launcher. Isso \u00e9 muito importante, especialmente porque inclui STDOUT e STDERR";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "Voc\u00ea precisa salvar ou colar o conte\u00fado do Terminal do seu servidor, pois ele cont\u00e9m informa\u00e7\u00f5es n\u00e3o presentes em outros logs, incluindo STDOUT, STDERR e outros erros. Por favor, cole o conte\u00fado da sua \u00faltima sess\u00e3o. Para o futuro, voc\u00ea pode salvar a sa\u00edda do terminal em um arquivo chamado cd_launcherlog. Para evitar ter que colar, adicione >> cd_launcherlog ap\u00f3s o comando de inicializa\u00e7\u00e3o, conforme mostrado na imagem. Observe que isso impedir\u00e1 a exibi\u00e7\u00e3o no terminal; a sa\u00edda s\u00f3 aparecer\u00e1 nesse arquivo a partir de ent\u00e3o.";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("Erro cr\u00edtico: transformador do LexForge detectado em um ambiente NeoForge. ");
        sb.append("</b>");
        sb.append("Classe envolvida: <b>").append(claseReceptora).append("</b>. ");
        sb.append("A interface afetada \u00e9 <b>").append(interfazObjetivo).append("</b> ");
        sb.append("e o m\u00e9todo ausente \u00e9 <b>").append(firmaMetodoFaltante).append("</b>. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("A classe foi encontrada em: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", e outros...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("Nenhum JAR contendo essa classe foi localizado; pode estar ofuscado ou embutido como jar-em-jar. ");
        }
        sb.append("Essa falha ocorre quando um transformador/servi\u00e7o do ModLauncher compilado para MinecraftForge/LexForge ");
        sb.append("\u00e9 carregado no NeoForge com uma vers\u00e3o incompat\u00edvel da API do ModLauncher. ");
        sb.append("Atualize ou substitua o componente para NeoForge.");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "Transformador do LexForge usado no NeoForge";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "Identifique o transformador incompat\u00edvel: <b>" + claseReceptora + "</b>. A API esperada \u00e9 <b>" + interfazObjetivo + "</b> e o m\u00e9todo ausente \u00e9 <b>" + firmaMetodoFaltante + "</b>. Verifique se o mod registra essa classe em <b>META-INF/services</b> e remova ou desative-a no NeoForge.";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Localiza\u00e7\u00e3o do(s) mod(s) envolvido(s): <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", e outros...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("Nenhum JAR contendo a classe foi encontrado. Verifique depend\u00eancias embutidas (jar-em-jar) e ofuscadas. ");
        }
        sb.append("Remova temporariamente esses JARs ou use vers\u00f5es compat\u00edveis com NeoForge para confirmar a origem.");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "Substitua o componente por uma vers\u00e3o espec\u00edfica para NeoForge ou recompile-o contra a vers\u00e3o do ModLauncher usada pelo NeoForge. Evite bin\u00e1rios antigos do LexForge/MinecraftForge.";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "Limpe sua pasta de mods e remova duplicatas jar-em-jar. Limpe o cache do launcher se necess\u00e1rio e reinicie para garantir que nenhum transformador do LexForge esteja sendo carregado.";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia n\u00e3o pode iniciar: Xenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("\u00e9 incompat\u00edvel.</b> ");
        sb.append("Remova o Xenon e use Embeddium ou Sodium. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Detectado em: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", e outros...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia incompat\u00edvel com Xenon";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return "Detectado " + label + " incompat\u00edvel com WaterMedia. Remova-o do seu perfil.";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("Localiza\u00e7\u00f5es: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", e outros...");
            }
            sb.append("</b>. Exclua esse JAR.");
            return sb.toString();
        }
        return "Nenhum JAR encontrado. Verifique a pasta de mods e remova o Xenon.";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "Instale Embeddium ou Sodium como substituto e reinicie o jogo.";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "Erro ao comprimir (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>Deflater fechado durante c\u00f3pia de recursos do TACZ.</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("Relacionado a: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", e outros");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>Solu\u00e7\u00e3o:</b> em <code>tacz/tacz-pre.toml</code>, defina <code>DefaultPackDebug=true</code>. ").append("Se necess\u00e1rio, gere um mapa primeiro e depois ative-o.");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "Em tacz/tacz-pre.toml, defina DefaultPackDebug=true. Se necess\u00e1rio, gere um mapa primeiro e depois ative-o.";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "Fun\u00e7\u00f5es de densidade n\u00e3o vinculadas";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>Faltam fun\u00e7\u00f5es de densidade no registro.</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("Faltando: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append(". ");
        }
        sb.append("<br/><b>Solu\u00e7\u00e3o:</b> instale ou ative o mod/datapack que define essas fun\u00e7\u00f5es e reinicie. Outra causa comum desse problema \u00e9 quando voc\u00ea tem o mod necess\u00e1rio, mas ele apresenta um problema ou conflito com outro mod; por exemplo, o Terralith tem muitos problemas e pode causar este erro e outros, incluindo erros com JSON.");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "Instale ou ative o mod/pacote de dados que fornece essas fun\u00e7\u00f5es e reinicie o jogo.";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Entrada de registro n\u00e3o encontrada: ").append(claveFaltante).append(". ");
        sb.append("Comum com a vers\u00e3o alfa do Steam & Railways para Create 6.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (alfa)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "Remova ou substitua a vers\u00e3o alfa do Steam & Railways para Create 6 por uma vers\u00e3o compat\u00edvel.";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Conflito de carregamento: Multiworld junto com Sodium/Embeddium/Rubidium causa ").append("IncompatibleClassChangeError (FabricLoader.getInstance). ").append("Sugest\u00e3o: remova o Multiworld ou o mod de desempenho, ou use vers\u00f5es compat\u00edveis.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "Conflito: Multiworld com mods de desempenho";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "Desinstale o Multiworld ou o Sodium/Embeddium/Rubidium, ou atualize para vers\u00f5es mutuamente compat\u00edveis.";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium detectou um driver gr\u00e1fico incompat\u00edvel. Atualize o driver da sua GPU para o m\u00ednimo exigido ou siga o guia do Sodium.</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "Erro de Contexto OpenGL";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falha no OpenGL: sem contexto atual ou fun\u00e7\u00e3o n\u00e3o dispon\u00edvel neste contexto. Pode tamb\u00e9m ser um problema com os drivers de v\u00eddeo.</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "Atualize/reinstale os drivers da GPU e reinicie; desative sobreposi\u00e7\u00f5es e teste sem mods de desempenho.";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "Link copiado para a \u00e1rea de transfer\u00eancia.";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "Pesquisar dentro de arquivos compactados (.zip/.jar/.war/.ear/.fpm/.rar para Java*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro de resolu\u00e7\u00e3o de textura: N\u00e3o foi poss\u00edvel carregar " + recurso + " - tamanho: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "Erro de Resolu\u00e7\u00e3o de Textura";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "Esse erro ocorre quando as texturas s\u00e3o muito grandes ou h\u00e1 muitos pacotes de recursos. Tente usar pacotes de recursos de resolu\u00e7\u00e3o mais baixa ou remova alguns pacotes. Verifique se voc\u00ea n\u00e3o adicionou texturas personalizadas com resolu\u00e7\u00e3o acima do limite permitido.";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro nos servi\u00e7os do ModLauncher: caminho com caracteres inv\u00e1lidos. Os servi\u00e7os do ModLauncher n\u00e3o conseguem processar caminhos que contenham caracteres n\u00e3o ASCII ou caracteres especiais. Caracteres problem\u00e1ticos incluem: \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694, e especialmente o caractere '\"' quando no final do nome. Componentes comuns de servi\u00e7o no ModLauncher incluem CrashDetector, " + Config.obtenerInstancia().obtenerNombreCD() + ", FeatureCreep, Vivicraft, Optifine, Sodium, clonos, Iris Shaders/Oculus, MixerLogger, CrashAssistant e Sintrya Connector. Voc\u00ea pode remover todos os servi\u00e7os, mas outros problemas podem surgir devido ao nome do caminho. Solu\u00e7\u00e3o: renomeie a inst\u00e2ncia para usar apenas caracteres ASCII (a-z, A-Z, 0-9), sem espa\u00e7os ou caracteres especiais.</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "Erro de Caminho no ModLauncher";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "Este erro ocorre quando o caminho da inst\u00e2ncia cont\u00e9m caracteres n\u00e3o ASCII ou caracteres especiais. Os servi\u00e7os do ModLauncher n\u00e3o conseguem lidar com esses caminhos. Solu\u00e7\u00e3o: renomeie a inst\u00e2ncia para usar apenas caracteres ASCII (a-z, A-Z, 0-9) e evite espa\u00e7os e caracteres especiais. Preste aten\u00e7\u00e3o especial ao caractere '\"', que \u00e9 altamente problem\u00e1tico, especialmente quando no final do nome.";
    }

    @Override
    public String tituloEditorCodice() {
        return "Editor de Codice";
    }

    @Override
    public String nuevo() {
        return "Novo";
    }

    @Override
    public String actualizarSeleccionado() {
        return "Atualizar selecionado";
    }

    @Override
    public String eliminarSeleccionado() {
        return "Excluir selecionado";
    }

    @Override
    public String exportarJSON() {
        return "Exportar JSON...";
    }

    @Override
    public String guardarTodo() {
        return "Salvar tudo";
    }

    @Override
    public String general() {
        return "Geral";
    }

    @Override
    public String id() {
        return "ID";
    }

    @Override
    public String paraBuscar() {
        return "Texto a pesquisar";
    }

    @Override
    public String filtro() {
        return "Filtro (id)";
    }

    @Override
    public String criticalidad() {
        return "Crit\u00e9rios (AVISO/ERRO/FATAL)";
    }

    @Override
    public String prioridad() {
        return "Prioridade";
    }

    @Override
    public String lista() {
        return "Verifica\u00e7\u00f5es";
    }

    @Override
    public String colIdioma() {
        return "Idioma";
    }

    @Override
    public String colNombre() {
        return "Nome";
    }

    @Override
    public String colResultado() {
        return "Resultado";
    }

    @Override
    public String vistaJson() {
        return "Visualiza\u00e7\u00e3o JSON";
    }

    @Override
    public String idiomas() {
        return "Idiomas (todos obrigat\u00f3rios)";
    }

    @Override
    public String elegirFiltro() {
        return "Escolher...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "Selecione um filtro";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "Filtros dispon\u00edveis";
    }

    @Override
    public String faltanCampos() {
        return "Preencha todos os campos gerais obrigat\u00f3rios.";
    }

    @Override
    public String critInvalida() {
        return "Crit\u00e9rio inv\u00e1lido. Use AVISO, ERRO ou FATAL.";
    }

    @Override
    public String filtroNoExiste() {
        return "O filtro especificado n\u00e3o existe.";
    }

    @Override
    public String faltanIdiomas() {
        return "Preencha nome e resultado para todos os idiomas:";
    }

    @Override
    public String verificacionInvalida() {
        return "Uma verifica\u00e7\u00e3o \u00e9 inv\u00e1lida. Verifique os campos.";
    }

    @Override
    public String guardadoOk() {
        return "Salvo com sucesso.";
    }

    @Override
    public String editorCodiceBoton() {
        return "Adicionar raz\u00f5es";
    }

    @Override
    public String descripcionEditorCodice() {
        return "Voc\u00ea pode registrar raz\u00f5es aqui. Voc\u00ea precisa de um ID, uma string sem caracteres especiais, acentos ou espa\u00e7os. Para filtros, voc\u00ea pode usar \"linha cont\u00e9m\" para procurar uma string em uma linha, \"tudo cont\u00e9m\" se o log tem uma string, \"regex linha\" se uma linha corresponde a uma express\u00e3o regular, e \"regex tudo\" (sugerimos usar as vers\u00f5es de linha). Voc\u00ea precisa definir a criticidade: FATAL, ERRO ou ADVERT\u00caNCIA para as cores. Para todos os idiomas, \u00e9 necess\u00e1rio escrever um nome e um resultado que aparecer\u00e1 na tela. Voc\u00ea pode adicionar mais verifica\u00e7\u00f5es ou remover outras. Salvo ao concluir.";
    }

    @Override
    public String descartarCambios() {
        return "Descartar as altera\u00e7\u00f5es n\u00e3o salvas na verifica\u00e7\u00e3o atual?";
    }

    @Override
    public String confirmacion() {
        return "Confirma\u00e7\u00e3o";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "Deseja salvar as altera\u00e7\u00f5es antes de sair?";
    }

    @Override
    public String salirSinGuardar() {
        return "Sair sem salvar";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("Erro cr\u00edtico: Falha ao carregar um servi\u00e7o do modlauncher (IDependencyLocator).<br>");
        sb.append("\ud83d\udd39 <b>Classe problem\u00e1tica:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>Mod afetado:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>Mod n\u00e3o identificado.</b> Verifique mods recentemente instalados, de desenvolvimento ou mal empacotados.<br>");
        }
        sb.append("\ud83d\udd38 <b>Causa:</b> O arquivo <code>META-INF/services/...</code> do mod est\u00e1 corrompido, ");
        sb.append("\u00e9 incompat\u00edvel com esta vers\u00e3o do Forge/NeoForge, ou o mod \u00e9 para uma vers\u00e3o incorreta.<br>");
        sb.append("\ud83d\udd38 <b>Consequ\u00eancia:</b> O Forge/NeoForge n\u00e3o pode registrar as depend\u00eancias do mod, ");
        sb.append("impedindo o in\u00edcio do jogo.<br>");
        sb.append("\ud83d\udd38 <b>Solu\u00e7\u00e3o:</b> Atualize, reinstale ou remova o mod problem\u00e1tico. ");
        sb.append("Se estiver usando mods de desenvolvimento, certifique-se de que foram compilados para a sua vers\u00e3o exata do Forge/NeoForge.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "Erro de Configura\u00e7\u00e3o de Servi\u00e7o (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. Identifique o mod causador: verifique mods instalados recentemente ou em desenvolvimento.";
        }
        return "1. O mod problem\u00e1tico \u00e9: " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. Atualize, reinstale ou remova o mod. Certifique-se de usar uma vers\u00e3o compat\u00edvel com seu Forge/NeoForge.";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>Erro cr\u00edtico: M\u00e9todo inexistente.</b><br>O mod tentou chamar o m\u00e9todo <b style='color:#" + colorCodigo + "'>" + metodo + "</b>, que n\u00e3o existe nesta vers\u00e3o do jogo ou de outro mod.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "M\u00e9todo Inexistente (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. Este erro ocorre quando um mod \u00e9 incompat\u00edvel com a vers\u00e3o atual do jogo ou de outro mod.";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. Atualize todos os mods envolvidos. Se persistir, reporte o erro ao autor do mod afetado.";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>Erro cr\u00edtico: Campo inexistente.</b><br>O mod tentou acessar o campo <b style='color:#" + colorCodigo + "'>" + campo + "</b>, que n\u00e3o existe nesta vers\u00e3o do jogo ou de outro mod.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "Campo Inexistente (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. Este erro geralmente ocorre quando um mod \u00e9 incompat\u00edvel com a vers\u00e3o atual do jogo ou de outro mod.";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. Atualize todos os mods afetados. Se o problema persistir, entre em contato com o autor do mod que gerou o erro.";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>Precisa de ajuda?</strong><br>  Se voc\u00ea n\u00e3o sabe como corrigir ou a raz\u00e3o n\u00e3o est\u00e1 aqui, pode obter ajuda em nossas redes sociais.   Use o bot\u00e3o <img src='" + iconoCompartir + "' alt='Compartilhar' style='height:12px;vertical-align:middle;'/>   <strong>Compartilhar</strong> para obter links dos registros e resultados para nossa equipe.   Se voc\u00ea \u00e9 criador de modpack ou uma corpora\u00e7\u00e3o, edite <code>crash_detector/plantilla.htm</code>   para personalizar os links da sua equipe.</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "Redefinir Modelo";
    }

    @Override
    public String restablecer() {
        return "Redefinir";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return "Redefinir " + nombreImagen + " para os valores padr\u00e3o?";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "Redefinir modelo para os valores padr\u00e3o?";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Faltando classes do AzureLib. Se voc\u00ea j\u00e1 tem o AzureLib, por favor instale uma vers\u00e3o anterior a 8 de outubro de 2025. Era comum. Se voc\u00ea n\u00e3o tem o AzureLib, instale a vers\u00e3o atual.</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>O mod <code>healight</code> est\u00e1 causando um erro cr\u00edtico: <code>java.lang.NoSuchFieldError: INT</code>. Esse erro ocorre porque o mod tenta acessar um campo que j\u00e1 n\u00e3o existe na vers\u00e3o MCForge 47.10 do Minecraft 1.20+. O jogo n\u00e3o pode iniciar devido a esse problema.</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 Remova ou atualize o mod <code>healight</code>. A vers\u00e3o atual n\u00e3o \u00e9 compat\u00edvel com o MinecraftForge 47.10 para 1.20.1. Procure uma vers\u00e3o mais recente do mod ou considere usar uma alternativa.";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "Erro cr\u00edtico: healight - Campo 'INT' n\u00e3o encontrado";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("A classe <code>").append(clase).append("</code> n\u00e3o implementa o m\u00e9todo necess\u00e1rio:<br>").append("<code>").append(metodo).append("</code><br>").append("da interface <code>").append(interfaz).append("</code>.");
        if (!origen.isEmpty()) {
            sb.append("<br><br>Mod ou arquivo suspeito: <code>").append(origen).append("</code>.");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 Esse erro ocorre quando um mod implementa uma interface mas omite um m\u00e9todo obrigat\u00f3rio. Atualize <b>ambos os mods</b> envolvidos (o que define a interface e o que a implementa). Se voc\u00ea n\u00e3o sabe quais s\u00e3o, procure pelos nomes mostrados na mensagem de erro.";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "M\u00e9todo de Interface N\u00e3o Implementado (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Um mod est\u00e1 tentando carregar uma classe do <b>lado do cliente</b> (<code>AnimationMetadataSection</code>) em um <b>servidor dedicado</b>, o que \u00e9 imposs\u00edvel. Esse erro geralmente ocorre quando um mod n\u00e3o separa corretamente seu c\u00f3digo entre cliente e servidor. A presen\u00e7a do <code>ModernFix</code> pode expor esse problema, embora n\u00e3o seja a causa direta.</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>Solu\u00e7\u00e3o r\u00e1pida:</b> Remova temporariamente o <code>ModernFix</code> para confirmar se o servidor inicia. Se funcionar, o problema est\u00e1 em outro mod que carrega classes do cliente no servidor.<br>\u2022 <b>Solu\u00e7\u00e3o permanente:</b> Identifique o mod culpado (procure mods com recursos animados, texturas personalizadas ou bibliotecas gr\u00e1ficas) e atualize-o ou remova-o.<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "Classe do cliente carregada no servidor (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>O arquivo de configura\u00e7\u00e3o de um mod do <code>Sinytra Connector</code> est\u00e1 corrompido. Isso geralmente ocorre quando o arquivo \u00e9 preenchido com caracteres nulos (<code>\\u0000</code>) devido a um encerramento inesperado do jogo, falhas na grava\u00e7\u00e3o ou conflitos de mods.</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 Navegue at\u00e9 a pasta <code>config/</code> da sua inst\u00e2ncia do Minecraft.<br>\u2022 Localize e exclua os arquivos de configura\u00e7\u00e3o dos mods do connector.<br>\u2022 Reinicie o jogo: o Sinytra Connector gerar\u00e1 um novo arquivo de configura\u00e7\u00e3o limpo.";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "Configura\u00e7\u00e3o do Sinytra Connector Corrompida";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>O arquivo <code>" + nombreJar + "</code> est\u00e1 corrompido ou incompleto.<br>O sistema n\u00e3o pode ler seu conte\u00fado porque o cabe\u00e7alho final do arquivo ZIP est\u00e1 faltando.<br>Esse erro geralmente ocorre ap\u00f3s um download interrompido ou falha do launcher.</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "Arquivo JAR corrompido (com nome espec\u00edfico)";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>Exclua o arquivo corrompido</b> e baixe-o novamente da fonte oficial (CurseForge, MinecraftStorage, etc.).<br>\u2022 Se voc\u00ea usa um launcher como CurseForge, Technic ou Luna Pixel, considere mudar para <b>ATLauncher</b> ou <b>Prism Launcher</b>, que verificam melhor a integridade dos arquivos.<br>\u2022 Certifique-se de que sua conex\u00e3o com a internet esteja est\u00e1vel durante o download.";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>N\u00e3o foi poss\u00edvel carregar o mundo porque um de seus arquivos NBT est\u00e1 corrompido (por exemplo: <code>level.dat</code>, <code>playerdata/*.dat</code> ou chunks).<br>O erro espec\u00edfico \u00e9: <code>UTFDataFormatException: entrada malformada em torno do byte " + byteCorrupto + "</code>.<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f Antes de tentar qualquer reparo, fa\u00e7a um backup completo da pasta do mundo.</b><br><br>Voc\u00ea pode tentar reparar o arquivo corrompido usando um <b>editor NBT</b> como <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>.<br>Se o dano for grave, use um <b>editor hexadecimal</b> (como HxD) para inspecionar e corrigir bytes inv\u00e1lidos (somente se voc\u00ea tiver experi\u00eancia com o formato NBT).<br>Como \u00faltimo recurso, restaure a partir de um backup ou use a fun\u00e7\u00e3o <i>reparar mundo</i> de mods como <code>FTB Backup</code>.</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>Fa\u00e7a um backup completo da pasta do mundo</b> antes de tentar qualquer reparo.<br>\u2022 Use um editor NBT (como o NBT Studio) para abrir e corrigir o arquivo corrompido.<br>\u2022 Se falhar, inspecione o arquivo com um editor hexadecimal na posi\u00e7\u00e3o do byte corrompido.<br>\u2022 Se n\u00e3o tiver experi\u00eancia, restaure a partir de um backup recente.";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "Mundo corrompido: erro ao carregar dados NBT";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea tem um problema com o OpenAL. \u00c0s vezes os drivers Nouveau podem causar isso, mas \u00e0s vezes a vers\u00e3o do OpenAL inclu\u00edda na aplica\u00e7\u00e3o n\u00e3o \u00e9 compat\u00edvel com a vers\u00e3o da sua distribui\u00e7\u00e3o e voc\u00ea precisa usar a vers\u00e3o da sua distro. Isso \u00e9 especialmente comum em distribui\u00e7\u00f5es baseadas em Red Hat e com mods de som como o Sound Physics Remastered. Veja este guia para mais ajuda: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>Como corrigir problemas de som no Minecraft usando Linux</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>O servidor n\u00e3o pode iniciar porque um arquivo do mundo est\u00e1 bloqueado por outro processo.<br>Isso geralmente acontece se:<br>\u2022 J\u00e1 existe uma inst\u00e2ncia do servidor em execu\u00e7\u00e3o.<br>\u2022 Um antiv\u00edrus ou explorador de arquivos tem a pasta do mundo aberta.<br>\u2022 O processo anterior n\u00e3o foi fechado corretamente e deixou arquivos bloqueados.</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>Feche todas as inst\u00e2ncias do servidor</b> (incluindo processos em segundo plano como javaw.exe).<br>\u2022 Se voc\u00ea usa um painel de hospedagem (como Multicraft), reinicie completamente o servidor pelo painel.<br>\u2022 <b>Desative temporariamente seu antiv\u00edrus</b> se suspeitar que ele esteja bloqueando os arquivos.<br>\u2022 Em sistemas locais, feche qualquer janela do Explorador de Arquivos que mostre a pasta do mundo.<br>\u2022 Se o problema persistir, exclua manualmente o arquivo <code>session.lock</code> dentro da pasta do mundo (somente se tiver certeza de que n\u00e3o h\u00e1 outro servidor ativo).";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "Arquivo do mundo bloqueado por outro processo";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>O mod tentou estender a classe <code>" + clasePadreFinal + "</code>, mas essa classe agora \u00e9 <b>final</b> e n\u00e3o pode ser herdada.<br>A classe problem\u00e1tica \u00e9: <code>" + claseHija + "</code>.<br><br>Isso geralmente ocorre quando um mod foi compilado para uma vers\u00e3o anterior do Minecraft ou de outro mod base, que marcou classes como <code>final</code> em vers\u00f5es recentes.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>Atualize todos os mods envolvidos</b>, especialmente aqueles que possam estar relacionados ao mod base mencionado.<br>\u2022 Se o problema persistir, procure uma vers\u00e3o do mod compat\u00edvel com sua vers\u00e3o atual do Minecraft e suas depend\u00eancias.<br>\u2022 Em alguns casos, remover temporariamente o mod que cont\u00e9m a classe filha pode ajudar a confirmar a causa.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "Tentativa de herdar de uma classe final";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Voc\u00ea est\u00e1 usando <b>Rubidium</b> (um fork obsoleto do Sodium para Forge) junto com <b>Iris ou Oculus</b>.<br>Em vers\u00f5es recentes do Minecraft (1.19.2+), o Rubidium n\u00e3o acompanhou as atualiza\u00e7\u00f5es do Sodium e suas depend\u00eancias apresentaram problemas.<br><br>Este erro tamb\u00e9m pode ocorrer se houver um conflito entre mods de desempenho (Sodium, Rubidium, Embeddium, Bedium, Xeonium, etc.) ou Iris Shaders com outro mod.</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <b>Remova o Rubidium</b> da sua pasta <code>mods</code>.<br>\u2022 <b>Instale o <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a></b>, o fork ativo e compat\u00edvel do Sodium para Forge que suporta Iris/Oculus em 1.20+.<br>\u2022 Certifique-se de n\u00e3o ter mais de um fork do Sodium instalado ao mesmo tempo (ex: Rubidium + Embeddium).<br>\u2022 Se voc\u00ea estiver usando Oculus em vez de Iris, verifique se ele tamb\u00e9m \u00e9 compat\u00edvel com sua vers\u00e3o de Forge e Embeddium.";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "Rubidium obsoleto com Iris/Oculus (OptionInstance \u00e9 final)";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>O mod <code>Simple Voice Chat</code> n\u00e3o consegue iniciar seu servidor de voz porque a porta UDP j\u00e1 est\u00e1 em uso ou o endere\u00e7o IP configurado \u00e9 inv\u00e1lido.<br>Isso n\u00e3o impede o jogo de iniciar, mas desativa a funcionalidade de chat de voz.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>Feche qualquer outra inst\u00e2ncia do Minecraft</b> ou aplicativo que esteja usando a porta UDP 24454.<br>\u2022 Se voc\u00ea estiver em um servidor, certifique-se de que <b>nenhum outro servi\u00e7o</b> esteja usando essa porta.<br>\u2022 Nas configura\u00e7\u00f5es do mod (<code>config/voicechat/</code>), mude a porta UDP para uma livre (por exemplo, 24455).<br>\u2022 Se estiver usando um endere\u00e7o IP personalizado, verifique se est\u00e1 correto ou deixe em branco para usar o padr\u00e3o.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "Chat de Voz: porta UDP ocupada ou IP inv\u00e1lido";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>O BlockItem <code>" + nombreBlockItem + "</code> tem um bloco nulo.<br>Esse erro geralmente ocorre em <b>addons do Create</b> (como <code>dndecor</code>, <code>createdeco</code>) quando h\u00e1 conflitos com <code>Amendments</code>, <code>Moonshine</code> ou inicializa\u00e7\u00e3o incorreta de blocos.<br><b>Nota:</b> Esse n\u00e3o \u00e9 um erro direto do Amendments, mas um sintoma de um problema mais profundo no carregamento do registro.</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>Atualize todos os mods relacionados:</b> Create, Amendments, Moonshine e qualquer addon (especialmente <code>dndecor</code> e <code>createdeco</code>).<br>\u2022 Se o problema persistir, <b>remova temporariamente os addons do Create</b> um por um para identificar o culpado.<br>\u2022 Certifique-se de que <b>Amendments e Moonshine sejam compat\u00edveis</b> com sua vers\u00e3o do Create e do Forge.<br>\u2022 Verifique se h\u00e1 vers\u00f5es beta ou forks atualizados dos addons problem\u00e1ticos.";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "BlockItem nulo em addon do Create";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("Foram encontrados mods que n\u00e3o pertencem a nenhuma plataforma ativa (Forge, Fabric, etc.):<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>Isto geralmente ocorre quando:<br>").append("\u2022 Mods de <b>Fabric e Forge</b> s\u00e3o misturados na mesma pasta.<br>").append("\u2022 Um mod \u00e9 instalado para uma vers\u00e3o incompat\u00edvel do Minecraft.<br>").append("\u2022 O mod est\u00e1 corrompido ou n\u00e3o \u00e9 um arquivo JAR v\u00e1lido.</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>Verifique se todos os mods s\u00e3o para a mesma plataforma</b> (Forge <b>ou</b> Fabric, n\u00e3o ambos).<br>\u2022 Use a <b>\u00e1rvore de mods</b> para identificar qual plataforma cada arquivo \u00e9 detectado.<br>\u2022 Remova qualquer mod que voc\u00ea n\u00e3o reconhe\u00e7a ou que seja de uma plataforma diferente.<br>\u2022 Se voc\u00ea usa um launcher como CurseForge ou Prism, certifique-se de que o perfil esteja configurado corretamente.";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "Mod incompat\u00edvel com carregador ativo";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Falha ao criar o modelo <code>" + modid + ":" + nombreModelo + "</code>.<br>Isso indica que o mod <code>" + modid + "</code> possui recursos corrompidos, ausentes ou incompat\u00edveis com sua vers\u00e3o do Minecraft.</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>Atualize o mod</b> para a vers\u00e3o mais recente compat\u00edvel com sua inst\u00e2ncia.<br>\u2022 Se estiver usando uma vers\u00e3o de desenvolvimento ou personalizada, volte para a vers\u00e3o oficial.<br>\u2022 Verifique se o arquivo JAR n\u00e3o est\u00e1 corrompido (reinstale-o).<br>\u2022 Se o problema persistir, relate o erro ao autor do mod incluindo este log.";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "Falha ao criar modelo de recurso";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>Foi detectado um conflito cr\u00edtico entre os mods <code>Moonlight</code> e <code>Iceberg</code>.<br>Ambos tentam registrar sistemas de recarga de recursos de forma incompat\u00edvel, o que causa uma falha do OpenGL por falta de um contexto gr\u00e1fico v\u00e1lido.<br>Esse problema \u00e9 comum ao usar vers\u00f5es do Forge que incluem adaptadores para mods do Fabric.</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>Atualize ambos os mods</b> para as \u00faltimas vers\u00f5es compat\u00edveis com sua vers\u00e3o do Forge.<br>\u2022 Se o problema persistir, <b>remova temporariamente o Iceberg</b>, pois o Moonlight geralmente \u00e9 uma depend\u00eancia mais cr\u00edtica para outros mods.<br>\u2022 Certifique-se de n\u00e3o ter vers\u00f5es duplicadas ou misturadas do Forge/Fabric desses mods.<br>\u2022 Verifique se algum outro mod (como Supplementaries, Citadel, etc.) j\u00e1 inclui funcionalidade do Iceberg internamente.";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "Conflito cr\u00edtico: Moonlight vs Iceberg (OpenGL sem contexto)";
    }

    @Override
    public String instantanea() {
        return "Instant\u00e2neo";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "Desde o \u00faltimo instant\u00e2neo";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "Selecionar um arquivo";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "Instant\u00e2neo criado com sucesso";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "Erro ao criar o instant\u00e2neo";
    }

    @Override
    public String consejo() {
        return "Dica";
    }

    @Override
    public String resultadoMuestra() {
        return "Mostrar Resultado";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>Dica:</b> Selecione dois arquivos de hist\u00f3rico para comparar a lista de mods.   O resultado mostra <span style='color:%s;'>adicionados (+)</span> e   <span style='color:%s;'>removidos (&#8722;)</span> com base em nomes normalizados.   Use o bot\u00e3o 'Instant\u00e2neo' para criar uma c\u00f3pia de um arquivo existente com a extens\u00e3o .instantanea.</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "Obter Links de Logs como Markdown sem Relat\u00f3rio";
    }

    @Override
    public String titulo_configuracion() {
        return "Configura\u00e7\u00e3o";
    }

    @Override
    public String columna_url() {
        return "URL";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "Erro inesperado ao compartilhar.";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "Erro inesperado ao gerar links.";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "Erro inesperado ao processar bot\u00e3o.";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "Nenhum arquivo associado para abrir.";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "O arquivo n\u00e3o existe:\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "N\u00e3o foi poss\u00edvel abrir no editor.\nO caminho ser\u00e1 copiado para a \u00e1rea de transfer\u00eancia.";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "N\u00e3o foi poss\u00edvel abrir o arquivo; o caminho foi copiado para a \u00e1rea de transfer\u00eancia.";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "\u00c1rea de trabalho n\u00e3o suportada; o caminho foi copiado para a \u00e1rea de transfer\u00eancia.";
    }

    @Override
    public String limite_de_solicitudes() {
        return "Voc\u00ea est\u00e1 enfrentando um limite de solicita\u00e7\u00f5es. Tente usar outro site de registro ou outra API de registro.";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "Compartilhar Link";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Corrigir as partes superiores dos troncos \u00e9 a principal prioridade. O formato \u00e9 N\u00edvel, Linha. Todos os registros t\u00eam um sistema de numera\u00e7\u00e3o. " + "<br>" + "Geralmente, voc\u00ea precisa procurar nos n\u00edveis mais baixos em todos os registros; rastros com n\u00edveis altos geralmente s\u00e3o falsos positivos. \u00c9 importante usar sua habilidade de ler na console, pois a an\u00e1lise de rastros n\u00e3o \u00e9 perfeita quando h\u00e1 muitos rastros.</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "Localizador de Canary de Mandado";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "Este recurso estar\u00e1 dispon\u00edvel em breve.";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "Em Breve";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "Mods Incompat\u00edveis com o Crash Assistant (Falso)";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "Mod Incompat\u00edvel com Modpack usando CrashAssistant";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O Crash Assistant possui uma lista de mods que ele diz serem incompat\u00edveis, mas n\u00e3o temos evid\u00eancias disso e o erro est\u00e1 apenas em ingl\u00eas. Se voc\u00ea quiser jogar com esses mods, pode editar o arquivo <code>config/crash_assistant/config.toml</code> e alterar <code>enabled = true</code> na se\u00e7\u00e3o [compatibility] para <code>enabled = false</code>.</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O Crash Assistant tem a capacidade de dizer que mods s\u00e3o incompat\u00edveis, mas \u00e0s vezes isso \u00e9 incorreto e a mensagem de erro est\u00e1 apenas em um idioma. Se voc\u00ea quiser usar esses mods, pode editar o arquivo <code>config/crash_assistant/problematic_mods_config.json</code> e mudar <code>should_crash_on_startup</code> de <code>true</code> para <code>false</code>.</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Erro: O mod '" + modId + "' requer o mod '" + dependencia + "'. Atualmente, " + actual + ".</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Erro: O mod '" + modId + "' requer a vers\u00e3o '" + requerido + "' ou superior do '" + dependencia + "', mas o mod n\u00e3o est\u00e1 instalado.</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Erro: O mod '" + modId + "' \u00e9 incompat\u00edvel com a vers\u00e3o atual de '" + dependencia + "'. Voc\u00ea deve remover o mod 'Iris/Oculus & GeckoLib Compat', pois ele \u00e9 incompat\u00edvel com o Superb Warfare e n\u00e3o funciona com a vers\u00e3o mais recente do GeckoLib. Vers\u00e3o atual: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "Erro: Falha ao executar a tarefa para a classe '" + clase + "'. Esse erro \u00e9 comum com mods que n\u00e3o s\u00e3o compat\u00edveis entre si ou que t\u00eam conflitos com outros mods instalados.";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "Falhas na execu\u00e7\u00e3o de tarefas";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "Esse tipo de erro geralmente ocorre quando h\u00e1 incompatibilidades entre mods. Especialmente comum com mods que n\u00e3o funcionam corretamente com o ConnectorMod.";
    }

    @Override
    public String info_clase_problematica() {
        return "Classe problem\u00e1tica:";
    }

    public String ver_en_log() {
        return "Ver no Log";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "Nenhuma classe espec\u00edfica com problemas de execu\u00e7\u00e3o foi encontrada.";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito cr\u00edtico entre OptiFine e Entity Model Features (EMF). Esses mods n\u00e3o s\u00e3o compat\u00edveis e causam uma falha de inje\u00e7\u00e3o que impede o in\u00edcio do jogo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "Conflito entre OptiFine e Entity Model Features";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "Desinstale o OptiFine ou o Entity Model Features, pois eles n\u00e3o s\u00e3o compat\u00edveis entre si.";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito cr\u00edtico entre OptiFine e Fusion. Esses mods n\u00e3o s\u00e3o compat\u00edveis e causam uma falha de inje\u00e7\u00e3o que impede o in\u00edcio do jogo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "Conflito entre OptiFine e Fusion";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "Desinstale o OptiFine ou o Fusion, pois eles n\u00e3o s\u00e3o compat\u00edveis entre si.";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O Flywheel (necess\u00e1rio pelo Create) precisa do Sodium 0.6.0-beta.2 ou superior. O Rubidium \u00e9 0.5.3. Considere usar o <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> como alternativa.</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "Conflito entre Flywheel e vers\u00e3o do Sodium";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "Atualize o Sodium para 0.6.0-beta.2 ou superior, ou instale o <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> como uma alternativa compat\u00edvel.";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito cr\u00edtico entre OptiFine e Epic Fight. Esses mods n\u00e3o s\u00e3o compat\u00edveis e causam uma falha de inje\u00e7\u00e3o que impede o in\u00edcio do jogo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "Conflito entre OptiFine e Epic Fight";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "Desinstale o OptiFine ou o Epic Fight, pois eles n\u00e3o s\u00e3o compat\u00edveis entre si.";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito cr\u00edtico entre OptiFine e Rubidium. Esses mods s\u00e3o incompat\u00edveis e causam uma falha de inje\u00e7\u00e3o que impede o in\u00edcio do jogo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "Conflito entre OptiFine e Rubidium";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "Desinstale OptiFine ou Rubidium, pois eles s\u00e3o incompat\u00edveis entre si.";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam est\u00e1 tentando carregar em um servidor dedicado, mas \u00e9 compat\u00edvel apenas com o cliente. Remova FreeCam do servidor ou certifique-se de que ele est\u00e1 instalado apenas no cliente.</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "FreeCam em servidor dedicado";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "Remova FreeCam do servidor dedicado, pois ele deve ser instalado apenas no cliente.";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) est\u00e1 tentando carregar em um servidor dedicado, mas \u00e9 compat\u00edvel apenas com o cliente. Remova ETF do servidor ou certifique-se de que ele est\u00e1 instalado apenas no cliente.</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features em servidor dedicado";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "Remova Entity Texture Features do servidor dedicado, pois ele deve ser instalado apenas no cliente.";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Voc\u00ea deve aceitar o EULA do Minecraft para executar o servidor. Edite o arquivo eula.txt e mude 'eula=false' para 'eula=true'.</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "EULA do Minecraft n\u00e3o aceito";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "Edite o arquivo eula.txt na pasta do servidor e mude 'eula=false' para 'eula=true'.";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine est\u00e1 tentando carregar em um servidor dedicado, mas \u00e9 compat\u00edvel apenas com o cliente. Remova OptiFine do servidor ou certifique-se de que ele est\u00e1 instalado apenas no cliente.</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "OptiFine em servidor dedicado";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "Remova OptiFine do servidor dedicado, pois ele deve ser instalado apenas no cliente.";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks est\u00e1 marcado incorretamente para 1.20.1, mas usa m\u00e9todos do 1.21.1. O mod est\u00e1 tentando usar ResourceLocation.fromNamespaceAndPath, que n\u00e3o existe no 1.20.1.</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "Erro de vers\u00e3o no Iron's Spellbooks";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "Certifique-se de estar usando a vers\u00e3o correta do Iron's Spellbooks compat\u00edvel com sua vers\u00e3o do Minecraft.";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito cr\u00edtico entre OptiFine e Embeddium. Esses mods s\u00e3o incompat\u00edveis e causam uma falha de inje\u00e7\u00e3o que impede o in\u00edcio do jogo.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "Conflito entre OptiFine e Embeddium";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "Desinstale OptiFine ou Embeddium, pois eles s\u00e3o incompat\u00edveis entre si.";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u00c9 comum com mods conflitantes de gera\u00e7\u00e3o de mundo, especialmente Terralinth, AmplifiedNether, Nullscape e Incendium, e outros mods de gera\u00e7\u00e3o de mundo. Tamb\u00e9m pode ser necess\u00e1rio instalar um mod ausente.</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable est\u00e1 tentando carregar em um servidor dedicado, mas \u00e9 compat\u00edvel apenas com o cliente. Remova Controllable do servidor ou certifique-se de que ele est\u00e1 instalado apenas no cliente.</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "Controllable em servidor dedicado";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "Remova Controllable do servidor dedicado, pois ele deve ser instalado apenas no cliente.";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries est\u00e1 causando um erro que impede a inicializa\u00e7\u00e3o do servidor. O mod tem problemas com o registro de comportamentos de fogo que causam uma falha durante o carregamento dos datapacks.</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries impede a inicializa\u00e7\u00e3o do servidor";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "Tente atualizar o Supplementaries para a vers\u00e3o mais recente ou desative-o temporariamente para permitir a inicializa\u00e7\u00e3o do servidor.";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader (GML) encontrou um problema com m\u00f3dulos Jackson ausentes. Alguns mods, como Valkyrien Skies, podem causar este erro por n\u00e3o inclu\u00edrem todas as depend\u00eancias necess\u00e1rias.</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "M\u00f3dulo Jackson ausente no Groovy Modloader";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "Remova o Groovy Modloader e mods relacionados, como Valkyrien Skies, que possam causar conflitos de depend\u00eancias.";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat encontrou um nome inv\u00e1lido de bloco de madeira. Every Compat geralmente tem muitos problemas. N\u00e3o o use!</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "Nome inv\u00e1lido no Every Compat";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "Verifique os pacotes de recursos ou mods que usam Every Compat, pois podem conter nomes de blocos inv\u00e1lidos.";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um c\u00f3digo de erro (-1073741819) que pode ser causado por overlays como GameCaster da Razer, Discord, OBS Studio ou problemas com drivers da NVIDIA.</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "C\u00f3digo de erro -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "Tente desativar overlays como GameCaster, Discord ou OBS Studio e verifique se seus drivers da NVIDIA est\u00e3o atualizados.";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips requer Immersive Messages como depend\u00eancia, mas n\u00e3o est\u00e1 instalado. Instale Immersive Messages para que Immersive Tooltips funcione corretamente.</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips sem depend\u00eancia";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "Instale Immersive Messages, pois \u00e9 uma depend\u00eancia necess\u00e1ria para o Immersive Tooltips.";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins tem um problema de compatibilidade com Apoli Mod onde ItemStack n\u00e3o pode ser convertido (cast) para EntityLinkedItemStack. Isso \u00e9 comum em vers\u00f5es posteriores \u00e0 6.6.0. Considere usar uma vers\u00e3o anterior ou alternar entre vers\u00f5es do Fabric e Forge.</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "Erro de convers\u00e3o (cast) no Medieval Origins";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "Use uma vers\u00e3o do Medieval Origins 6.6.0 ou anterior, ou tente alternar entre as vers\u00f5es Fabric e Forge do mod.";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether est\u00e1 causando um erro com um Registry Object ausente no MusicManager. Esse problema est\u00e1 relacionado ao mixin do MusicManager do Reign of Nether.</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "Erro do MusicManager no Reign of Nether";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "Tente atualizar o Reign of Nether ou remov\u00ea-lo temporariamente para resolver o erro.";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel suporta o servidor YSM apenas no Linux ou Android. Esse problema foi corrigido em vers\u00f5es mais recentes a partir de 23 de novembro de 2025 no Modrinth.</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel incompat\u00edvel com Linux";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "Atualize o YesSteveModel para uma vers\u00e3o mais recente no Modrinth, pois o problema foi corrigido ap\u00f3s 23 de novembro.";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito cr\u00edtico entre Moving Elevators e OptiFine. Esses mods s\u00e3o incompat\u00edveis e causam uma falha de inje\u00e7\u00e3o que impede o in\u00edcio do jogo.</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "Conflito entre Moving Elevators e OptiFine";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "Desinstale OptiFine ou Moving Elevators, pois eles s\u00e3o incompat\u00edveis entre si.";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito cr\u00edtico entre Fabric API (fabric-resource-loader-v0) e OptiFine. Esses mods s\u00e3o incompat\u00edveis e causam uma falha de inje\u00e7\u00e3o que impede o in\u00edcio do jogo.</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "Conflito entre Fabric API e OptiFine";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "Desinstale o OptiFine ou atualize o Fabric API para uma vers\u00e3o compat\u00edvel.";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Um mod possui um ITransformationService defeituoso que n\u00e3o pode ser instanciado: " + claseProveedor + ". Esse mod deve ser removido para permitir a inicializa\u00e7\u00e3o do jogo.</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "ITransformationService defeituoso";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "Remova o mod que cont\u00e9m a classe " + claseProveedor + ", pois ele possui um ITransformationService defeituoso.";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>Um mod possui uma especifica\u00e7\u00e3o de vers\u00e3o inv\u00e1lida. A vers\u00e3o deve estar envolvida por colchetes. Voc\u00ea pode usar o utilit\u00e1rio grep/greprf do painel lateral buscando a vers\u00e3o </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'> para identificar qual mod tem o problema.</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "Vers\u00e3o inv\u00e1lida no mod";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "Use o utilit\u00e1rio grep/greprf do painel lateral para buscar a vers\u00e3o problem\u00e1tica e encontrar o mod que a cont\u00e9m.";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um erro de stack smashing que encerrou o processo. Isso pode ser causado por problemas com Early Window no Forge/NeoForge/PillowMC ou com LWJGL 3.2.2 e vers\u00f5es mais recentes.</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "Stack Smashing Detectado";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "Verifique as configura\u00e7\u00f5es do Early Window e considere usar uma vers\u00e3o diferente do LWJGL ou revisar os mods relacionados \u00e0 janela inicial.";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore \u00e9 apenas para um modpack espec\u00edfico e n\u00e3o deve ser usado em instala\u00e7\u00f5es gerais, pois causa um problema.</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore com vers\u00e3o incompat\u00edvel do Java";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "Remova o GregTechEasyCore, pois ele \u00e9 apenas para um modpack espec\u00edfico e n\u00e3o \u00e9 compat\u00edvel com sua instala\u00e7\u00e3o geral.";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito entre MoniLabs e Connector Extras relacionado \u00e0s modifica\u00e7\u00f5es do KubeJS. Esses mods s\u00e3o incompat\u00edveis em suas modifica\u00e7\u00f5es do KubeJS.</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "Conflito entre MoniLabs e Connector Extras";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "Tente desinstalar um dos mods (MoniLabs ou Connector Extras), pois h\u00e1 conflito em suas modifica\u00e7\u00f5es do KubeJS.";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O Iris requer o Distant Horizons [2.0.4] ou a DH API vers\u00e3o [1.1.0] ou superior. Consulte o guia de compatibilidade em https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e para resolver o problema.</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "Compatibilidade entre Iris e Distant Horizons";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "Consulte o guia de compatibilidade em https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e e atualize o Iris e o Distant Horizons para vers\u00f5es compat\u00edveis.";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do Minecraft. Poss\u00edveis raz\u00f5es:</b><ul><li>Voc\u00ea tem mods para outras vers\u00f5es do jogo. Voc\u00ea pode usar o <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a> para verificar se a classe existe na sua vers\u00e3o.</li><li>Voc\u00ea tem uma instala\u00e7\u00e3o corrompida do Minecraft (comum com CurseForge App, ModrinthApp/Theseus/Astralrinth e outros launchers de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Veja o tutorial</a> para resolver problemas com o CurseForge.</li><li>Voc\u00ea tem um coremod defeituoso (se um coremod falhar, pode bloquear o carregamento da classe).</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do DangerZone. Poss\u00edveis raz\u00f5es:</b><ul><li>Voc\u00ea tem mods para outras vers\u00f5es do jogo.</li><li>Voc\u00ea tem coremods defeituosos.</li><li>Voc\u00ea tem um launcher ou instala\u00e7\u00e3o corrompida.</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do FeatureCreep. Poss\u00edveis raz\u00f5es:</b><ul><li>Voc\u00ea tem mods para outras vers\u00f5es do FeatureCreep (ex.: ESR vs Nightly ou v4 vs v12).</li><li>Voc\u00ea pode instalar o FeatureCreep pelo CurseForge ou MinecraftStorage.</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do ModLauncher. Poss\u00edveis raz\u00f5es:</b><ul><li>Seus mods s\u00e3o para uma build diferente do MinecraftForge, PillowMC ou NeoForge (o ModLauncher \u00e9 usado com esses carregadores).</li><li>Existem muitas atualiza\u00e7\u00f5es de modloaders para uma \u00fanica vers\u00e3o do Minecraft.</li><li>Voc\u00ea tem uma instala\u00e7\u00e3o corrompida do seu launcher (comum com CurseForge App, ModrinthApp/Theseus/Astralrinth e outros launchers de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Veja o tutorial</a> para resolver problemas com o CurseForge.</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do Minecraft Forge. Poss\u00edveis raz\u00f5es:</b><ul><li>Seus mods s\u00e3o para uma build diferente do MinecraftForge.</li><li>Existem muitas atualiza\u00e7\u00f5es de modloaders para uma \u00fanica vers\u00e3o do Minecraft.</li><li>Voc\u00ea tem uma instala\u00e7\u00e3o corrompida (comum com CurseForge App, ModrinthApp/Theseus/Astralrinth e outros launchers de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Veja o tutorial</a> para resolver problemas com o CurseForge.</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do NeoForge. Poss\u00edveis raz\u00f5es:</b><ul><li>Seus mods s\u00e3o para uma build diferente do NeoForge.</li><li>Existem muitas atualiza\u00e7\u00f5es de modloaders para uma \u00fanica vers\u00e3o do Minecraft.</li><li>Voc\u00ea tem uma instala\u00e7\u00e3o corrompida (comum com CurseForge App, ModrinthApp/Theseus/Astralrinth e outros launchers de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Veja o tutorial</a> para resolver problemas com o CurseForge.</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do Fabric Loader. Poss\u00edveis raz\u00f5es:</b><ul><li>Seus mods s\u00e3o para uma build diferente do Fabric Loader.</li><li>Existem muitas atualiza\u00e7\u00f5es de modloaders para uma \u00fanica vers\u00e3o do Minecraft.</li><li>Voc\u00ea tem uma instala\u00e7\u00e3o corrompida (comum com CurseForge App, ModrinthApp/Theseus/Astralrinth e outros launchers de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Veja o tutorial</a> para resolver problemas com o CurseForge.</li><li>Muitos mods exigem o Fabric API. Por favor, instale o Fabric API se necess\u00e1rio.</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Est\u00e3o faltando classes do PillowMC. Poss\u00edveis raz\u00f5es:</b><ul><li>Seus mods s\u00e3o para uma build diferente do PillowMC.</li><li>Existem muitas atualiza\u00e7\u00f5es de modloaders para uma \u00fanica vers\u00e3o do Minecraft.</li><li>Voc\u00ea tem uma instala\u00e7\u00e3o corrompida (comum com CurseForge App, ModrinthApp/Theseus/Astralrinth e outros launchers de modpacks). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>Veja o tutorial</a> para resolver problemas com o CurseForge.</li></ul><p>Observa\u00e7\u00e3o: voc\u00ea pode usar a ferramenta <b>grepr/fgrepr</b> na barra lateral para encontrar os mods que fazem refer\u00eancia \u00e0s classes ausentes, desde que use '/' nos nomes.</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Voc\u00ea tem um mod que est\u00e1 intencionalmente causando lag. Uranium \u00e9 um mod de lag. Ele nem sempre causa falhas, mas eventualmente pode causar.</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack est\u00e1 marcado como compat\u00edvel com 1.19.*, mas \u00e9 para 1.20.*, o que causa um erro de 'classe n\u00e3o encontrada'. O mod tenta usar DamageSources que n\u00e3o existem na vers\u00e3o atual do Minecraft.</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "Erro de vers\u00e3o do Falling Attack";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "Certifique-se de estar usando a vers\u00e3o correta do Falling Attack compat\u00edvel com sua vers\u00e3o do Minecraft.";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("Voc\u00ea precisa instalar o CFR (Class File Reader) para usar este recurso.<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("Em sistemas Linux, NetBSD ou FreeBSD, voc\u00ea pode instalar o CFR pelo gerenciador de pacotes.<br>").append("Procure o pacote em: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("Alternativamente, voc\u00ea pode baixar a vers\u00e3o modificada usada pelo FabricMC em:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("Salve-o na seguinte pasta:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>Importante:</b> ap\u00f3s instalar o CFR, reinicie o mod para que ele seja reconhecido corretamente.").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "Sem retrato dispon\u00edvel";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "N\u00e3o foi poss\u00edvel encontrar a classe: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "Descompilador CFR \u2013 Sakura Riddle (N\u00e3o Oficial)";
    }

    @Override
    public String cfrClaseActual() {
        return "Classe atual";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "Retrato de Sakura Riddle";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "Erro ao carregar o retrato";
    }

    @Override
    public String noticiaLegalCFR() {
        return "Este programa com interface gr\u00e1fica (GUI) para descompilar mods foi projetado para ajudar os usu\u00e1rios a identificar as causas de falhas no software. No entanto, a descompila\u00e7\u00e3o de mods pode ser necess\u00e1ria, e os usu\u00e1rios devem ter cuidado para n\u00e3o usar o c\u00f3digo gerado para infringir a Lei Federal de Direitos Autorais. Recomenda-se verificar a licen\u00e7a do mod correspondente antes de usar qualquer c\u00f3digo obtido. Al\u00e9m disso, muitos mods disponibilizam oficialmente seu c\u00f3digo-fonte, que geralmente \u00e9 mais limpo e f\u00e1cil de entender do que o c\u00f3digo descompilado. Lembre-se de que o respeito \u00e0 propriedade intelectual e \u00e0s licen\u00e7as de uso \u00e9 fundamental para a comunidade de desenvolvedores de mods. Voc\u00ea pode consultar a Lei Federal de Direitos Autorais do M\u00e9xico no seguinte link: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor (Espanhol)</a> e a vers\u00e3o em ingl\u00eas aqui: <a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (English)</a>. Como voc\u00ea est\u00e1 no CurseForge, tamb\u00e9m fornecemos o link para a Lei de Direitos Autorais dos EUA em ingl\u00eas: <a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>. Al\u00e9m disso, recomenda-se que os usu\u00e1rios pesquisem as leis aplic\u00e1veis em sua localiza\u00e7\u00e3o. Nossa GUI \u00e9 apenas para verifica\u00e7\u00f5es simples; para an\u00e1lise avan\u00e7ada, use o fork Enigma da FabricMC dispon\u00edvel em <a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>. Se desejar editar arquivos JAR para criar patches quando o c\u00f3digo-fonte n\u00e3o estiver dispon\u00edvel, use o Recaf em <a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">seu site</a>.";
    }

    @Override
    public String botonDescargarCfr() {
        return "Baixar CFR";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "Abrir pasta de instala\u00e7\u00e3o";
    }

    @Override
    public String colorFondoPrincipal() {
        return "Cor de fundo principal";
    }

    @Override
    public String colorTextoBotonReset() {
        return "Cor do texto do bot\u00e3o de reiniciar";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "Cor do texto do campo de busca";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "Cor do texto do menu suspenso de filtro";
    }

    @Override
    public String colorTextoRenderer() {
        return "Cor do texto do renderizador";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "Cor do texto da sobreposi\u00e7\u00e3o de carregamento";
    }

    @Override
    public String colorBorde() {
        return "Cor da borda";
    }

    @Override
    public String colorFondoRetrato() {
        return "Cor de fundo no modo retrato";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "Cor do link de compartilhamento";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "Cor de fundo do campo de compartilhamento";
    }

    @Override
    public String rosaFondo() {
        return "Rosa de fundo";
    }

    @Override
    public String rosaSuave() {
        return "Rosa suave";
    }

    @Override
    public String moradoAcento() {
        return "Roxo de destaque";
    }

    @Override
    public String textoOscuro() {
        return "Texto escuro";
    }

    @Override
    public String bordeSuave() {
        return "Borda suave";
    }

    @Override
    public String fondoCampo() {
        return "Fundo do campo";
    }

    @Override
    public String fondoVistaPrevia() {
        return "Fundo da visualiza\u00e7\u00e3o pr\u00e9via";
    }

    @Override
    public String sintaxisConstructor() {
        return "Cor de sintaxe: construtor";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "Cor de sintaxe: mensagem de ajuda";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "Cor de sintaxe: tags HTML";
    }

    @Override
    public String colorFondoVentana() {
        return "Cor de fundo da janela";
    }

    @Override
    public String colorPanel() {
        return "Cor do painel";
    }

    @Override
    public String colorBotonTexto() {
        return "Cor do texto do bot\u00e3o";
    }

    @Override
    public String colorCampo() {
        return "Cor do campo";
    }

    @Override
    public String colorBordeDestacado() {
        return "Cor da borda destacada";
    }

    @Override
    public String colorSeleccionTexto() {
        return "Cor de fundo da sele\u00e7\u00e3o de texto";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "Cor do texto selecionado";
    }

    @Override
    public String colorEstadoExito() {
        return "Cor de estado: sucesso";
    }

    @Override
    public String colorEstadoFallo() {
        return "Cor de estado: falha";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "Cor de estado: instant\u00e2nea";
    }

    @Override
    public String colorResultadoAnadido() {
        return "Cor de resultado adicionado";
    }

    @Override
    public String colorResultadoEliminado() {
        return "Cor de resultado removido";
    }

    @Override
    public String colorBordeScroll() {
        return "Cor da borda da barra de rolagem";
    }

    @Override
    public String colorFondoPanel() {
        return "Cor de fundo do painel";
    }

    @Override
    public String colorBeigeListas() {
        return "Bege das listas";
    }

    @Override
    public String colorTextoListas() {
        return "Cor do texto nas listas";
    }

    @Override
    public String colorBordeListas() {
        return "Cor da borda das listas";
    }

    @Override
    public String colorBotonFondo() {
        return "Cor de fundo do bot\u00e3o";
    }

    @Override
    public String colorBordeBoton() {
        return "Cor da borda do bot\u00e3o";
    }

    @Override
    public String colorDoradoTexto() {
        return "Cor dourada do texto";
    }

    @Override
    public String colorPila() {
        return "Cor do rastro de pilha (stack trace)";
    }

    @Override
    public String colorTextoPanel() {
        return "Cor do texto do painel";
    }

    @Override
    public String colorTextoNegro() {
        return "Cor de texto preto";
    }

    @Override
    public String colorTextoPrincipal() {
        return "Cor do texto principal";
    }

    @Override
    public String colorFondoResultados() {
        return "Cor de fundo dos resultados";
    }

    @Override
    public String colorEstado() {
        return "Cor de estado";
    }

    @Override
    public String colorTextoDescripcion() {
        return "Cor do texto de descri\u00e7\u00e3o";
    }

    @Override
    public String colorTextoEstado() {
        return "Cor do texto de estado";
    }

    @Override
    public String colorTextoExtra() {
        return "Cor do texto extra";
    }

    @Override
    public String colorSeparador() {
        return "Cor do separador";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "Foi detectado um erro nativo <code>StubRoutines::SafeFetch32</code>. Esse problema ocorre no macOS com o JDK 17.0.9 e foi corrigido no JDK 17.0.10 ou posterior. https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "Erro nativo SafeFetch32 no JDK 17.0.9 (macOS)";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "Atualize seu JDK para a vers\u00e3o 17.0.10 ou superior (por exemplo, 17.0.15).";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "Se voc\u00ea usa um launcher como MultiMC, Prism Launcher ou TLauncher, configure-o para usar um JDK mais recente. Alguns j\u00e1 incluem o JDK 17.0.15 integrado.";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "O mod Spark tamb\u00e9m pode contribuir para esse erro. Considere desativ\u00e1-lo temporariamente. https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod MCEF (Chromium Embedded Framework) est\u00e1 causando um travamento silencioso.</b><ul><li>O MCEF est\u00e1 sendo inicializado no final do log, o que normalmente indica que o jogo travou durante o carregamento.</li><li>Este mod \u00e9 conhecido por causar falhas em sistemas Linux, macOS ou com certas vers\u00f5es do Java.</li><li>Nem sempre aparece um erro expl\u00edcito, mas o jogo nunca chega ao menu principal.</li></ul><p>Se voc\u00ea n\u00e3o precisa da funcionalidade de navegador no jogo (como mapas web ou p\u00e1ginas embutidas), remova o mod.</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "Problema de inicializa\u00e7\u00e3o do MCEF (mod de navegador embutido)";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "Remova o arquivo do mod MCEF (procure por 'mcef' no nome do arquivo) da pasta 'mods'.";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "Se realmente precisar dele, certifique-se de usar uma vers\u00e3o compat\u00edvel com seu sistema operacional e vers\u00e3o do Minecraft.";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito entre <b>OptiFine</b> e <b>Iris/Oculus</b>.</b><ul><li>O OptiFine modifica a renderiza\u00e7\u00e3o do Minecraft de forma incompat\u00edvel com o Iris ou Oculus.</li><li>O erro <code>MixinLevelRenderer failed injection check</code> vem de <code>mixins.iris.json</code> ou <code>mixins.oculus.json</code>.</li></ul><p>Esses mods n\u00e3o podem ser usados juntos. Remova o OptiFine para usar shaders com Iris ou Oculus.</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "Conflito entre OptiFine e Iris/Oculus";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "Remova o arquivo do OptiFine da pasta 'mods'.";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "Use o Iris ou Oculus sem o OptiFine para shaders modernos.";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um conflito entre <b>ModernFix</b> e <b>OptiFine</b>.</b><ul><li>ModernFix n\u00e3o \u00e9 compat\u00edvel com OptiFine porque quebra funcionalidades do Forge e deixa a inicializa\u00e7\u00e3o mais lenta.</li><li>O pr\u00f3prio ModernFix avisa: <i>\"Use of ModernFix with OptiFine is not supported\"</i>.</li></ul><p>Voc\u00ea deve remover um dos dois mods para que o jogo funcione corretamente.</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "Conflito entre ModernFix e OptiFine";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "Remova o OptiFinite ou o ModernFix da pasta 'mods'. Eles n\u00e3o podem ser usados juntos.";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "Se precisar de otimiza\u00e7\u00f5es, considere usar apenas o OptiFine ou substituir o ModernFix por mods mais leves, como FerriteCore ou EntityCulling.";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro: chave de registro inv\u00e1lida com caracteres n\u00e3o permitidos.</b><ul><li><b>Chave detectada:</b> <code>" + this.escapeHtml(clave) + "</code></li><li>No Minecraft, todas as chaves de registro (tags, receitas, conquistas, etc.) devem estar em <b>letras min\u00fasculas</b> e usar apenas letras, n\u00fameros, sublinhados, hifens e barras.</li><li>Esse erro geralmente \u00e9 causado por um mod mal programado ou um datapack defeituoso.</li></ul><p><b>Dica importante:</b> Use a ferramenta <b>grepr</b> ou <b>fgrepr</b> na barra lateral e ative a op\u00e7\u00e3o <b>\"Buscar em arquivos JAR\"</b> para identificar qual mod cont\u00e9m essa chave inv\u00e1lida.</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "Chave de registro com mai\u00fasculas ou caracteres inv\u00e1lidos";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "Use 'grepr' ou 'fgrepr' com \"Buscar em arquivos JAR\" para localizar o mod causador.";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "Se n\u00e3o conseguir identificar o mod, remova mods recentes, especialmente os que adicionam blocos, itens ou ferramentas.";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Erro ao carregar o mod <b>" + this.escapeHtml(modNombre) + "</b>.</b><ul><li>O mod falhou ao inicializar um de seus componentes (por exemplo, o menu de configura\u00e7\u00f5es).</li><li>Isso geralmente ocorre por incompatibilidade com a vers\u00e3o do Minecraft, Fabric ou com outros mods.</li></ul><p>Se o erro persistir, remova ou atualize o mod <b>" + this.escapeHtml(modNombre) + "</b>.</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "Erro de inicializa\u00e7\u00e3o de mod (Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "Remova o mod '" + modNombre + "' da pasta 'mods'.";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "Atualize o mod '" + modNombre + "' para uma vers\u00e3o compat\u00edvel com sua instala\u00e7\u00e3o.";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um erro relacionado ao mod <b>En Garde!</b>.</b><ul><li>Este mod adiciona mec\u00e2nicas de combate corpo a corpo (parry, bloqueio, etc.).</li><li>O erro geralmente ocorre por incompatibilidade com outros mods de combate (como Epic Fight, DualRiders, etc.) ou por usar uma vers\u00e3o incorreta para o seu Minecraft.</li></ul><p>Se voc\u00ea n\u00e3o usa combate avan\u00e7ado, considere remover o En Garde! para evitar conflitos.</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "Erro no mod En Garde!";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "Certifique-se de usar a vers\u00e3o do En Garde! compat\u00edvel com sua vers\u00e3o do Minecraft e seu carregador (Fabric/Forge).";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "Se voc\u00ea usa outros mods de combate (Epic Fight, Caelus, etc.), desative-os ou remova o En Garde! para evitar conflitos.";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um erro causado pelo mod <b>IdleTweaks</b>.</b><ul><li>O IdleTweaks tentou liberar um canal de rede que j\u00e1 n\u00e3o existe (<code>Tried to release unknown channel</code>).</li><li>Esse erro geralmente ocorre em vers\u00f5es antigas do mod ou ao us\u00e1-lo em servidores mal configurados.</li></ul><p>IdleTweaks \u00e9 um mod de qualidade de vida, mas pode causar instabilidade. Considere atualiz\u00e1-lo ou remov\u00ea-lo.</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "Erro no IdleTweaks (canal de rede desconhecido)";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "Atualize o IdleTweaks para a vers\u00e3o mais recente compat\u00edvel com seu Minecraft.";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "Remova o IdleTweaks da pasta 'mods' se n\u00e3o for necess\u00e1rio.";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um erro de autentica\u00e7\u00e3o (HTTP 401) ao tentar fazer login no Minecraft.</b><p>Esse erro <b>raramente \u00e9 a causa direta da falha</b>, mas indica que voc\u00ea est\u00e1 usando uma conta n\u00e3o autenticada (pirata).</p><p>Canais oficiais de suporte (projetos corporativos, VTubers, criadores de modpacks, etc.) <b>n\u00e3o podem ajud\u00e1-lo</b> se voc\u00ea usar uma c\u00f3pia pirata, devido a restri\u00e7\u00f5es em suas regras de chat, contratos, acordos com Mojang/Microsoft ou pol\u00edticas de reputa\u00e7\u00e3o.</p><p>Essa verifica\u00e7\u00e3o pode ser <b>desativada nas configura\u00e7\u00f5es corporativas</b> do detector. Aviso: a detec\u00e7\u00e3o antipirataria <b>n\u00e3o \u00e9 perfeita</b> e pode ser acionada em ambientes de desenvolvimento, com internet inst\u00e1vel ou ao usar launchers modificados.</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>Direitos Miranda se voc\u00ea tentar entrar no suporte mesmo assim:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "Minecraft pirata";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "Desativar verifica\u00e7\u00e3o antipirataria";
    }

    @Override
    public String comprarMC() {
        return "Comprar Minecraft";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Voc\u00ea est\u00e1 usando o launcher <code>" + id + "</code>, que <b>n\u00e3o est\u00e1 na lista de launchers recomendados</b>.</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>Embora possa funcionar, launchers n\u00e3o recomendados costumam causar:</p><ul><li>Instala\u00e7\u00f5es corrompidas de mods ou do aplicativo.</li><li>O jogo n\u00e3o inicia ou trava sem erro claro.</li><li>Estrutura de pastas incomum (dificulta o diagn\u00f3stico).</li><li>Comportamento imprevis\u00edvel com Java, mem\u00f3ria ou mods.</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "Para uma melhor experi\u00eancia, use um dos seguintes launchers recomendados:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "Launcher n\u00e3o recomendado";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "Mude para um launcher da lista recomendada.";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>Voc\u00ea est\u00e1 usando um <b>launcher desaconselhado</b>: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>Launchers desaconselhados podem causar:</p><ul><li>Instala\u00e7\u00f5es corrompidas do aplicativo ou mods.</li><li>O jogo n\u00e3o inicia ou falha silenciosamente.</li><li>Organiza\u00e7\u00e3o incomum de arquivos (dif\u00edcil depurar).</li><li>Incerteza sobre como ele gerencia mods, Java ou mem\u00f3ria.</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "Recomenda-se vivamente usar um dos seguintes launchers:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "Launcher desaconselhado";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "Mude para um launcher recomendado para receber suporte.";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Faltam mods recomendados para este ambiente.</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "Mods recomendados ausentes";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "Instale os mods recomendados para uma experi\u00eancia ideal.";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foram detectados mods desaconselhados na sua instala\u00e7\u00e3o.</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "Mods desaconselhados detectados";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "Remova os mods desaconselhados para evitar problemas.";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Modifica\u00e7\u00e3o n\u00e3o autorizada detectada em arquivos cr\u00edticos. Voc\u00ea editou arquivos manualmente ou est\u00e1 usando um launcher n\u00e3o confi\u00e1vel.</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "Manipula\u00e7\u00e3o detectada";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "Reinstale os arquivos originais para restaurar a integridade.";
    }

    @Override
    public String configuracionCorporativa() {
        return "\u062a\u0646\u0638\u06cc\u0645\u0627\u062a \u0634\u0631\u06a9\u062a\u06cc";
    }

    @Override
    public String idiomaRespaldo() {
        return "\u0632\u0628\u0627\u0646 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646";
    }

    @Override
    public String buscardorHabilitado() {
        return "\u0641\u0639\u0627\u0644\u200c\u0633\u0627\u0632\u06cc \u062c\u0633\u062a\u062c\u0648\u06af\u0631";
    }

    @Override
    public String nombreHerramienta() {
        return "\u0646\u0627\u0645 \u0627\u0628\u0632\u0627\u0631";
    }

    @Override
    public String condenarPirateria() {
        return "\u0645\u062d\u06a9\u0648\u0645\u06cc\u062a \u062f\u0632\u062f\u06cc \u0646\u0631\u0645\u200c\u0627\u0641\u0632\u0627\u0631\u06cc";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "\u0631\u0627\u0647\u200c\u0627\u0646\u062f\u0627\u0632\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String modsRecomendados() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u062a\u0648\u0635\u06cc\u0647\u200c\u0634\u062f\u0647";
    }

    @Override
    public String modsDesaconsejados() {
        return "\u0627\u0641\u0632\u0648\u0646\u0647\u200c\u0647\u0627\u06cc \u0646\u0627\u0645\u0646\u0627\u0633\u0628";
    }

    @Override
    public String antiTamper() {
        return "\u0636\u062f \u062f\u0633\u062a\u06a9\u0627\u0631\u06cc";
    }

    @Override
    public String proximamente() {
        return "\u0628\u0647 \u0632\u0648\u062f\u06cc";
    }

    @Override
    public String informacion() {
        return "\u0627\u0637\u0644\u0627\u0639\u0627\u062a";
    }

    @Override
    public String errorCargandoImagen() {
        return "\u062e\u0637\u0627 \u062f\u0631 \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u062a\u0635\u0648\u06cc\u0631";
    }

    @Override
    public String configuracionBasica() {
        return "Configura\u00e7\u00f5es B\u00e1sicas";
    }

    @Override
    public String funcionalidades() {
        return "Funcionalidades";
    }

    @Override
    public String derechosMiranda() {
        return "Direitos Miranda (ALTAMENTE recomendados)";
    }

    @Override
    public String gestionVerificaciones() {
        return "Gest\u00e3o de Verifica\u00e7\u00f5es";
    }

    @Override
    public String idVerificacion() {
        return "ID";
    }

    @Override
    public String nombreVerificacion() {
        return "Nome";
    }

    @Override
    public String codigoVerificacion() {
        return "C\u00f3digo";
    }

    @Override
    public String documentacionVerificacion() {
        return "Documenta\u00e7\u00e3o";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "Verifica\u00e7\u00f5es Habilitadas:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "Verifica\u00e7\u00f5es Desabilitadas:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "Desabilitar todas as n\u00e3o corporativas";
    }

    @Override
    public String verCodigo() {
        return "Ver C\u00f3digo";
    }

    @Override
    public String verDocumentacion() {
        return "Ver Documenta\u00e7\u00e3o";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "Selecione uma verifica\u00e7\u00e3o para desabilitar.";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "Selecione uma verifica\u00e7\u00e3o para habilitar.";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "%d verifica\u00e7\u00f5es n\u00e3o recomendadas para uso corporativo foram desabilitadas.";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "N\u00e3o h\u00e1 verifica\u00e7\u00f5es n\u00e3o corporativas para desabilitar.";
    }

    @Override
    public String operacionCompletada() {
        return "Opera\u00e7\u00e3o conclu\u00edda";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "Sentimos sua falta, Amane Kanata";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "Cor de Verifica\u00e7\u00e3o Corporativa";
    }

    @Override
    public String nombreLanzador() {
        return "Nome do Launcher";
    }

    @Override
    public String motivo() {
        return "Motivo";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "Launchers Desaconselhados";
    }

    @Override
    public String moverADesaconsejados() {
        return "Desaconselhar";
    }

    @Override
    public String moverARecomendados() {
        return "Recomendar";
    }

    @Override
    public String guardarCambios() {
        return "Salvar Altera\u00e7\u00f5es";
    }

    @Override
    public String cancelar() {
        return "Cancelar";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "Por favor, selecione um launcher para mover.";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "As altera\u00e7\u00f5es foram salvas com sucesso!";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "Motivos";
    }

    @Override
    public String agregarLanzador() {
        return "Adicionar launcher";
    }

    @Override
    public String quitarLanzador() {
        return "Remover launcher";
    }

    @Override
    public String editarRazones() {
        return "Editar motivos";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "Selecione um launcher para remover.";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "Selecione um launcher para editar.";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return "Editar motivos para " + idLanzador;
    }

    @Override
    public String agregarNuevoIdioma() {
        return "Adicionar novo idioma";
    }

    @Override
    public String aceptar() {
        return "Aceitar";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "Selecione o idioma";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "Esses s\u00e3o os launchers que o CrashDetector recomenda como bons.";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "Resultado correto";
    }

    @Override
    public String modsNoRecomendados() {
        return "Mods Desaconselhados";
    }

    @Override
    public String agregarMod() {
        return "Adicionar mod";
    }

    @Override
    public String quitarMod() {
        return "Remover mod";
    }

    @Override
    public String modId() {
        return "ID do mod / Nome do JBoss Modules";
    }

    @Override
    public String rutaMod() {
        return "Caminho / arquivo do mod";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "Voc\u00ea deve informar pelo menos o modid ou o caminho do mod.";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "Aqui voc\u00ea pode registrar mods desaconselhados para que o CrashDetector os detecte caso estejam instalados.";
    }

    @Override
    public String anularNormal() {
        return "Desativar Normal";
    }

    @Override
    public String anularNormalDescripcion() {
        return "O CrashDetector deve avisar mesmo que n\u00e3o ocorra um crash real.";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "Registre os mods que o CrashDetector recomenda. Se estiverem ausentes, o CrashDetector poder\u00e1 avisar.";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "Se voc\u00ea decidir ativar o aviso antipirataria, recomenda-se definir aqui os direitos da pessoa que solicita suporte, como medida preventiva.\n\nAo contr\u00e1rio do que se acredita comumente, muitas comunidades e canais de suporte populares N\u00c3O exigem que avisos antipirataria estejam ativados para fornecer ajuda. No entanto, documentar esses direitos pode ser \u00fatil caso algu\u00e9m acesse o canal de suporte mesmo assim.\n\nVoc\u00ea pode se basear em documentos oficiais, como o Manual de Direitos B\u00e1sicos do Preso no M\u00e9xico:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\nAssim como em princ\u00edpios legais compar\u00e1veis usados em outros pa\u00edses, incluindo Estados Unidos, Federa\u00e7\u00e3o Russa, Rep\u00fablica Popular da China, Rep\u00fablica Isl\u00e2mica do Ir\u00e3 e Rep\u00fablica Popular Democr\u00e1tica da Coreia.\n\nAlguns exemplos de direitos que podem ser inclu\u00eddos s\u00e3o:\n\u2022 O direito de n\u00e3o fornecer informa\u00e7\u00f5es desnecess\u00e1rias para o suporte, como o launcher usado, nome de usu\u00e1rio ou UUID.\n\u2022 O direito de n\u00e3o se autoincriminar.\n\u2022 O direito de recusar responder perguntas que n\u00e3o sejam necess\u00e1rias para resolver o problema.\n\u2022 O direito de receber orienta\u00e7\u00e3o dentro do chat.\n\u2022 O direito de usar o recurso integrado de anonimiza\u00e7\u00e3o de logs do CrashDetector.\n\nEste texto aceita conte\u00fado HTML.";
    }

    @Override
    public String editar() {
        return "Editar";
    }

    @Override
    public String advertenciaHashLento() {
        return "Aviso: adicionar muitos arquivos grandes pode fazer com que a verifica\u00e7\u00e3o leve v\u00e1rios minutos. O CrashDetector precisar\u00e1 calcular o hash de cada arquivo antes de continuar. Recomenda-se proteger apenas os arquivos estritamente necess\u00e1rios.";
    }

    @Override
    public String agregarArchivo() {
        return "Adicionar arquivo";
    }

    @Override
    public String agregarCarpeta() {
        return "Adicionar pasta";
    }

    @Override
    public String quitar() {
        return "Remover";
    }

    @Override
    public String rutaArchivo() {
        return "Caminho do arquivo";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "O caminho selecionado est\u00e1 fora do diret\u00f3rio atual do jogo. Apenas arquivos e pastas dentro do diret\u00f3rio atual ou seus subdiret\u00f3rios s\u00e3o permitidos.";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>As opini\u00f5es e coment\u00e1rios de Sylent Bell n\u00e3o refletem necessariamente as nossas; achamos apenas que seria engra\u00e7ado coloc\u00e1-la aqui. CrashDetector \u00e9 secular.</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>O mod GML (Groovy ModLoader) requer essas altera\u00e7\u00f5es e \u00e9 a causa mais comum deste problema.</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Foi detectado o uso do <i>Independente Flywheel</i>.</b><p><b>O Independente Flywheel est\u00e1 obsoleto (descontinuado)</b> e n\u00e3o deve ser usado em vers\u00f5es modernas.</p><p>As vers\u00f5es atuais do <b>Create</b> <b>j\u00e1 incluem o Flywheel</b>, ent\u00e3o instal\u00e1-lo separadamente causa conflitos de compatibilidade e erros de carregamento.</p><p>Alguns mods que dependem explicitamente do Independent Flywheel podem <b>n\u00e3o funcionar</b> ou <b>funcionar de forma inst\u00e1vel</b>. Em certos casos avan\u00e7ados, esses mods podem funcionar se voc\u00ea <b>editar manualmente o arquivo <code>mods.toml</code></b> para ajustar os intervalos de vers\u00e3o, embora isso <b>n\u00e3o seja recomendado</b>.</p>" + (mods.isEmpty() ? "" : "<p><b>Mods detectados que fazem refer\u00eancia ao Flywheel:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>A solu\u00e7\u00e3o recomendada \u00e9 <b>remover o Independente Flywheel</b> e usar apenas a vers\u00e3o inclu\u00edda no Create.</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "Flywheel Independente";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Foi detectado um erro relacionado ao mod <i>Floral Enchantments</i>.</b><p>O crash \u00e9 causado por uma falha interna do mod ao manipular dados do jogo, o que gera uma <b>NullPointerException</b> durante a execu\u00e7\u00e3o.</p><p>Esse problema geralmente \u00e9 resolvido atualizando ou removendo o mod.</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "Erro do Floral Enchantments";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>Voc\u00ea tem a vers\u00e3o NeoForge e a vers\u00e3o normal do MixinExtras instaladas. Se estiver usando MinecraftForge, pode instalar a corre\u00e7\u00e3o em <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>este link</a>.</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Foi detectado um erro nas sombras do terreno com shaders (Iris).</b><p>O problema ocorre durante a renderiza\u00e7\u00e3o do terreno.</p><p>Recomenda-se <b>tentar jogar sem shaders</b> ou reduzir a qualidade gr\u00e1fica, especialmente em configura\u00e7\u00f5es <b>Ultra</b>.</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "Sombras do terreno (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Um tick do servidor excessivamente longo foi detectado.</b><p>Isso indica que o jogo ficou travado por muito tempo em um \u00fanico tick.</p><p>Recomenda-se <b>verificar o thread dump</b> gerado no log para identificar a causa.</p><p>A <b>An\u00e1lise de Stack Trace</b> pode ajud\u00e1-lo a localizar a origem do travamento.</p><p>Al\u00e9m disso, o bot\u00e3o <b>Ver no log</b> destacar\u00e1 em vermelho os mods possivelmente respons\u00e1veis, bem como entradas cercadas por <code>$modid$</code>, que geralmente indicam a origem do problema. Para an\u00e1lise em tempo real, recomendamos usar o amostrador de CPU no VisualVM. Certifique-se de que seu servidor ou computador seja potente o suficiente para lidar com os mods que voc\u00ea est\u00e1 usando \u2014 \u00e9 poss\u00edvel que todos os seus mods funcionem corretamente, mas voc\u00ea tenha muitos deles.</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "Tick longo do servidor";
    }

    @Override
    public String tituloLFPDPPP() {
        return "Lei Federal de Prote\u00e7\u00e3o de Dados Pessoais em Posse de Particulares";
    }

    @Override
    public String aceptarPermanentemente() {
        return "Aceitar permanentemente";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "A tradu\u00e7\u00e3o coreana cont\u00e9m g\u00edrias do sul que devem ser evitadas para cumprir a lei. O uso de linguagem estrangeira, especialmente proveniente do Sul, \u00e9 estritamente proibido pela Lei de Prote\u00e7\u00e3o da L\u00edngua Cultural de Pyongyang.";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "Para mais informa\u00e7\u00f5es, consulte o documento oficial da lei: <a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>Lei de Prote\u00e7\u00e3o da L\u00edngua Cultural de Pyongyang</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "Ler Lei Completa";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "Erro ao abrir o link";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "Lei de Prote\u00e7\u00e3o da L\u00edngua Cultural de Pyongyang";
    }

    @Override
    public String canarioTitulo() {
        return "Can\u00e1rio de Ordem Judicial";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 Monitor de Vigil\u00e2ncia";
    }

    @Override
    public String revisar() {
        return "Verificar";
    }

    @Override
    public String cerrar() {
        return "Fechar";
    }

    @Override
    public String canarioTodoSeguro() {
        return "Todos os servi\u00e7os relatam status seguro.";
    }

    @Override
    public String canarioComprometido(int c) {
        return "ALERTA: " + c + " servi\u00e7o(s) relatam status inseguro.";
    }

    @Override
    public String colorAlerta() {
        return "Cor de alerta";
    }

    @Override
    public String opcionesMunidiales() {
        return "Op\u00e7\u00f5es Munidial";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "Consentimento LFPDPPP";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "Habilitar handoff do token de acesso em Handoff para ReLauncher (desaconselhado).";
    }

    @Override
    public String consolaDesarrollo() {
        return "Console de desenvolvimento";
    }

    @Override
    public String mundial() {
        return "Global";
    }

    @Override
    public String ningun() {
        return "Nenhum";
    }

    public String consolaDesarrollador() {
        return "Console do desenvolvedor";
    }

    @Override
    public String bajar() {
        return "Baixar";
    }

    @Override
    public String logsSoporte() {
        return "Logs de suporte";
    }

    @Override
    public String detenerProceso() {
        return "Parar processo";
    }

    @Override
    public String copiarSeleccion() {
        return "Copiar sele\u00e7\u00e3o";
    }

    @Override
    public String seleccionarTodo() {
        return "Selecionar tudo";
    }

    @Override
    public String copiarTodo() {
        return "Copiar tudo";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "Salvar tudo como arquivo";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "Obter link de suporte";
    }

    @Override
    public String borrarTodo() {
        return "Limpar tudo";
    }

    public String colorFondoConsola() {
        return "Cor de fundo do console";
    }

    public String colorTextoConsola() {
        return "Cor do texto do console";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "Consentimento confirmado.\nA integra\u00e7\u00e3o para compartilhar logs ser\u00e1 implementada aqui.";
    }

    @Override
    public String usarSakuraOriginal() {
        return "Usar a imagem original do Sakura Riddle";
    }

    @Override
    public String canario1984Descripcion() {
        return "Um \"warrant canary\" \u00e9 um mecanismo de transpar\u00eancia.\n\nEnquanto esta mensagem existir e os servi\u00e7os aparecerem como seguros, significa que o projeto N\u00c3O recebeu ordens judiciais secretas, solicita\u00e7\u00f5es de censura nem pedidos legais de vigil\u00e2ncia.\n\nSe algum can\u00e1rio desaparecer ou for marcado como inseguro, isso indica que houve uma mudan\u00e7a legal.\n\nEste painel verifica todos os can\u00e1rios registrados no sistema e exibe seu estado atual.\n\nClique em \"Verificar\" para atualizar os estados.";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "Redefinir todas as op\u00e7\u00f5es para os valores padr\u00e3o?";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "Sem op\u00e7\u00f5es";
    }

    @Override
    public String seleccionaColor() {
        return "Selecionar cor";
    }

    @Override
    public String botonMostrarGUI() {
        return "Mostrar GUI";
    }

    @Override
    public String botonGuardarTodo() {
        return "Salvar tudo";
    }

    @Override
    public String botonRestablecerTodo() {
        return "Redefinir tudo";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms n\u00e3o carregado";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Foi detectado um erro ao acessar a API do LuckPerms.</b><p>A mensagem indica que o <b>LuckPerms n\u00e3o estava carregado</b> no momento em que outro plugin tentou us\u00e1-lo.</p><p><b>Causas poss\u00edveis:</b></p><ul><li>O plugin <b>LuckPerms n\u00e3o est\u00e1 instalado</b> ou <b>falhou ao iniciar</b>.</li><li>Outro plugin est\u00e1 tentando acessar o LuckPerms <b>muito cedo</b> ou de <b>forma incorreta</b>.</li></ul><p>Recomenda-se <b>verificar o console</b> usando o link para identificar o plugin que est\u00e1 chamando o LuckPerms e verificar sua compatibilidade.</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "Shaderpack do Iris n\u00e3o carregado";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "desconhecido" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Foi detectado um erro ao carregar um shaderpack com Iris/Oculus.</b><p><b>Shaderpack afetado:</b> " + nombre + "</p><p>O Minecraft n\u00e3o conseguiu abrir o arquivo do shaderpack (FileSystemNotFoundException).</p><p><b>Solu\u00e7\u00f5es poss\u00edveis:</b></p><ul><li>Verifique se o shaderpack est\u00e1 corretamente instalado na pasta <b>shaderpacks</b>.</li><li>Baixe novamente o shaderpack, pois o arquivo pode estar corrompido.</li><li>Se o problema persistir, exclua o arquivo <b>config/iris.properties</b> para redefinir a configura\u00e7\u00e3o do Iris.</li></ul><p>Ap\u00f3s aplicar as altera\u00e7\u00f5es, reinicie o jogo.</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "N\u00e3o foi poss\u00edvel escrever o arquivo de configura\u00e7\u00e3o";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "desconhecido" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Ocorreu um erro ao salvar um arquivo de configura\u00e7\u00e3o.</b><p><b>Arquivo afetado:</b> " + archivo + "</p><p>O Minecraft n\u00e3o p\u00f4de escrever o arquivo usando grava\u00e7\u00e3o at\u00f4mica (REPLACE_ATOMIC).</p><p><b>Isso geralmente ocorre por:</b></p><ul><li>Permiss\u00f5es incorretas na pasta ou no arquivo.</li><li>O arquivo est\u00e1 marcado como somente leitura.</li><li>Outro programa (antiv\u00edrus, backup, editor) est\u00e1 bloqueando o arquivo.</li></ul><p><b>Recomenda\u00e7\u00f5es:</b></p><ul><li>Verifique se voc\u00ea tem permiss\u00f5es de escrita na pasta.</li><li>Remova o atributo de somente leitura do arquivo.</li><li>Feche programas que possam estar usando esse arquivo.</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "Acesso negado ao criar backup";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "desconhecido" : origen;
        String dst = backup == null || backup.isEmpty() ? "desconhecido" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Ocorreu um erro de permiss\u00f5es ao criar um backup do arquivo de configura\u00e7\u00e3o.</b><p><b>Arquivo original:</b> " + src + "</p><p><b>Arquivo de backup:</b> " + dst + "</p><p>O sistema operacional bloqueou o acesso durante o salvamento do arquivo.</p><p><b>Isso geralmente ocorre por:</b></p><ul><li>Permiss\u00f5es insuficientes na pasta.</li><li>O arquivo est\u00e1 marcado como somente leitura.</li><li>Outro programa (antiv\u00edrus, ferramenta de sincroniza\u00e7\u00e3o, editor) est\u00e1 usando o arquivo.</li></ul><p><b>Recomenda\u00e7\u00f5es:</b></p><ul><li>Verifique as permiss\u00f5es da pasta <b>config</b>.</li><li>Feche programas que possam estar acessando o arquivo.</li><li>Tente iniciar o launcher ou o Minecraft como administrador.</li></ul>";
    }
}

