/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.idioma;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.Statics;
import java.io.File;
import java.util.List;
import java.util.Set;

public class Ruso
implements Idioma {
    private final Config config = Config.obtenerInstancia();

    @Override
    public String carpeta_de_mods_no_valido() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043f\u0430\u043f\u043a\u0430 mods</span>";
    }

    @Override
    public String no_se_donde_esta_jar() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>JAR-\u0444\u0430\u0439\u043b CrashDetector \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d</span>";
    }

    @Override
    public String buscando_para_pid(long pid) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u041f\u043e\u0438\u0441\u043a PID: " + String.valueOf(pid) + "</span>";
    }

    @Override
    public String pid_esta_muerto(long pid) {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>(PID: " + String.valueOf(pid) + ") \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d!</span>";
    }

    @Override
    public String no_tenemos_jvm() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>JVM \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430</span>";
    }

    @Override
    public String problema_con_graficas_ati() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u043e\u0432 ATI/AMD \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u043c\u043e\u0447\u044c. \u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0439\u0442\u0435 \u044d\u0442\u043e \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u0434\u043b\u044f \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044e \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u043e\u0432</a> https://www.amd.com/es/support/download/drivers.html \u0421\u043a\u0430\u0447\u0430\u0442\u044c </span>";
    }

    @Override
    public String problema_con_graficas_nouveau() {
        return "<span style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0441\u0442\u0430\u0440\u044b\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 \u043c\u043e\u0433\u0443\u0442 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043e\u0432\u0430\u0442\u044c \u0441 Nouveau-\u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430\u043c\u0438 \u043d\u0430 \u0440\u0430\u043d\u043d\u0438\u0445 \u044d\u0442\u0430\u043f\u0430\u0445 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438.</span>";
    }

    @Override
    public String problema_con_graficas_general() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0432\u0438\u0434\u0435\u043e\u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430\u043c\u0438. \u0414\u043b\u044f AMD/ATI \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b, \u0434\u043b\u044f NVIDIA \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0438\u0441\u043a\u0440\u0435\u0442\u043d\u0443\u044e \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u0443 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 javaw.exe. \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044e \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u043e\u0432</a></span>";
    }

    @Override
    public String fmlEarlyWindow() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 FML early window. \u0418\u0441\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u0432 (.minecraft/config/fml.toml) earlyWindowProvider \u043d\u0430 \"none\". \u0414\u043b\u044f Mac M1 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 ARM-\u0432\u0435\u0440\u0441\u0438\u044e Java. \u0422\u0430\u043a\u0436\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b. \u0414\u043b\u044f Windows, \u0435\u0441\u043b\u0438 \u043d\u0435 \u043f\u043e\u043c\u043e\u0433\u0430\u0435\u0442, \u0447\u0438\u0442\u0430\u0439\u0442\u0435: <a href='https://forums.minecraftforge.net/topic/125488-rules-and-frequently-asked-questions-faq/#:~:text=How%20do%20I%20update%20my%20drivers%3F' style='color:#" + this.config.obtenerColorEnlace() + "'>\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044e \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u043e\u0432</a></span>";
    }

    @Override
    public String no_tienes_las_dependencias_necesarias() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438:</span>";
    }

    @Override
    public String linea_de_dependencia(String linea) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>" + linea.replace("Requested by", "\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043e").replace("Expected range", "\u041e\u0436\u0438\u0434\u0430\u0435\u043c\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d") + "</span>";
    }

    @Override
    public String local_headless(String archivo) {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u041e\u0442\u0447\u0435\u0442 CrashDetector \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0437\u0434\u0435\u0441\u044c: <a href='" + archivo + "' style='color:#" + this.config.obtenerColorEnlace() + "'>\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043e\u0442\u0447\u0435\u0442</a></span>";
    }

    @Override
    public String texto_de_gui() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u042d\u0442\u043e GUI CrashDetector. \u0415\u0441\u043b\u0438 \u0438\u0433\u0440\u0430 \u0437\u0430\u043a\u0440\u044b\u043b\u0430\u0441\u044c \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e, \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0439\u0442\u0435 \u044d\u0442\u043e \u043e\u043a\u043d\u043e.</span>";
    }

    @Override
    public String texto_de_boton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorBoton() + "'>\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043e\u0442\u0447\u0435\u0442</span>";
    }

    @Override
    public String texto_debajo_de_buton_local_enlace() {
        return "<span style='color:#" + this.config.obtenerColorInfo() + "'>\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442 \u0432 \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0435.</span>";
    }

    @Override
    public String texto_de_buton_compartir_enlace() {
        return "\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043e\u0442\u0447\u0435\u0442\u043e\u043c";
    }

    @Override
    public String texto_debajo_de_buton_compartir_enlace() {
        return "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0442\u0447\u0435\u0442. \u041b\u043e\u0433\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u044f\u0442\u0441\u044f \u043d\u0430 securelogger.net, \u043e\u0442\u0447\u0435\u0442 \u043d\u0430 \u0434\u0440\u0443\u0433\u0438\u0435 \u0441\u0430\u0439\u0442\u044b.";
    }

    @Override
    public String problematico_jar() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0435 JAR-\u0444\u0430\u0439\u043b\u044b (\u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: FATAL > HIGH > LOW):</b>";
    }

    @Override
    public String nivel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'> \u0423\u0440\u043e\u0432\u0435\u043d\u044c:</b> ";
    }

    @Override
    public String posibilidad_fatal() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043e\u0442\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e \u0444\u0430\u0442\u0430\u043b\u044c\u043d\u043e:</b> ";
    }

    @Override
    public String modids_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0435 ModID (\u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: FATAL > LOW > LOW):</b>";
    }

    @Override
    public String packages_problematicos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b (\u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: FATAL > LOW > LOW):</b>";
    }

    @Override
    public String falta_de_clases_fatales() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0444\u0430\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u043a\u043b\u0430\u0441\u0441\u044b (FATAL), \u044d\u0442\u043e \u043e\u0447\u0435\u043d\u044c \u0441\u0435\u0440\u044c\u0451\u0437\u043d\u043e. \u0427\u0430\u0441\u0442\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b \u2014 \u043f\u043b\u043e\u0445\u0438\u0435 CoreMods \u0438\u043b\u0438 \u0444\u0430\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 QuickFix \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u043c\u043e\u0434\u043e\u0432 \u0441 \u0444\u0430\u0442\u0430\u043b\u044c\u043d\u044b\u043c\u0438 \u043a\u043b\u0430\u0441\u0441\u0430\u043c\u0438. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0444\u0430\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u043a\u043b\u0430\u0441\u0441\u044b:</b>";
    }

    @Override
    public String corchetes_ondulados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 {} (\u0432\u0430\u0436\u043d\u0435\u0439\u0448\u0438\u0435 \u0432\u0432\u0435\u0440\u0445\u0443, \u043f\u043e\u043a\u0430\u0437\u0430\u043d\u043e \u043f\u0435\u0440\u0432\u044b\u0435 20):</b>";
    }

    @Override
    public String config_spongemixin_problematico() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f SpongeMixin: </b>";
    }

    @Override
    public String module_resolution_exception() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0423 \u0432\u0430\u0441 \u0435\u0441\u0442\u044c \u043c\u043e\u0434\u044b \u0441 \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u044e\u0449\u0438\u043c\u0438\u0441\u044f \u043f\u0430\u043a\u0435\u0442\u0430\u043c\u0438. \u042d\u0442\u043e \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c, \u0443\u0434\u0430\u043b\u0438\u0432 \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u044e\u0449\u0438\u0439\u0441\u044f \u043f\u0430\u043a\u0435\u0442 (\u043f\u0430\u043f\u043a\u0443) \u0438\u0437 JAR-\u0444\u0430\u0439\u043b\u0430. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u044c JAR \u0432 \u0430\u0440\u0445\u0438\u0432\u0430\u0442\u043e\u0440\u0435, \u0442\u0430\u043a\u043e\u043c \u043a\u0430\u043a WinRAR \u0438\u043b\u0438 7z, \u0442\u0430\u043a\u0436\u0435 \u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 .jar \u043d\u0430 .zip, \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443, \u0430 \u0437\u0430\u0442\u0435\u043c \u0441\u043d\u043e\u0432\u0430 \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u0435\u0433\u043e \u043e\u0431\u0440\u0430\u0442\u043d\u043e \u0432 .jar \u0444\u0430\u0439\u043b.</span>";
    }

    @Override
    public String modlauncher_mods_duplicado(String linea) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u044e\u0449\u0438\u0435\u0441\u044f \u043c\u043e\u0434\u044b</b> " + linea.replace("from mod files", "\u0438\u0437 \u0444\u0430\u0439\u043b\u043e\u0432 \u043c\u043e\u0434\u0430");
    }

    @Override
    public String mcforge_mod_sospechoso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>MinecraftForge \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b \u043f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043c\u043e\u0434:</b> ";
    }

    @Override
    public String lithostichctov() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>CTOV \u0442\u0440\u0435\u0431\u0443\u0435\u0442 Lithostitched, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435: <a href='https://www.curseforge.com/minecraft/mc-mods/lithostitched' style='color:#" + this.config.obtenerColorEnlace() + "'>Lithostitched</a></b>";
    }

    @Override
    public String necesitasSodiumParaIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0414\u043b\u044f Iris/Oculus \u043d\u0443\u0436\u0435\u043d SODIUM \u0438\u043b\u0438 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a (Rubidium, Embedium, Bedium)</b>";
    }

    @Override
    public String kubeJSResourcePack(String mod_nombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435\u043c KubeJS </b>" + mod_nombre;
    }

    @Override
    public String problema_con_graficas_nvidia_windows_viejo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430\u043c\u0438 NVIDIA \u0432 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 \u0434\u043e Windows 11.</span><br/><br/>\u0427\u0442\u043e\u0431\u044b \u0443\u0431\u0435\u0434\u0438\u0442\u044c\u0441\u044f, \u0447\u0442\u043e Minecraft (\u0438 \u0442\u0435\u043a\u0443\u0449\u0430\u044f JVM) \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u0443 NVIDIA, \u0441\u043b\u0435\u0434\u0443\u0439\u0442\u0435 \u044d\u0442\u0438\u043c \u0448\u0430\u0433\u0430\u043c:<br/><br/>1. <strong>\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java:</strong><br/>   - \u042d\u0442\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java: " + this.obtenerRutaJava() + "<br/>   - \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0432\u0438\u0434\u0438\u0442\u0435 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0443\u0442\u0438, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u0439\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java, \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0432 \u043f\u043e\u0438\u0441\u043a \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443 'java.exe' \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435.<br/><br/>2. <strong>\u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u043f\u0430\u043d\u0435\u043b\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f NVIDIA:</strong><br/>   - \u0429\u0435\u043b\u043a\u043d\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u043e\u0439 \u043a\u043d\u043e\u043f\u043a\u043e\u0439 \u043c\u044b\u0448\u0438 \u043d\u0430 \u0440\u0430\u0431\u043e\u0447\u0435\u043c \u0441\u0442\u043e\u043b\u0435 \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 '\u041f\u0430\u043d\u0435\u043b\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f NVIDIA'.<br/><br/>3. <strong>\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e GPU:</strong><br/>   - \u0412 \u043f\u0430\u043d\u0435\u043b\u0438 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f NVIDIA \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043a '\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 3D'.<br/>   - \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e '\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b'.<br/>   - \u041d\u0430\u0436\u043c\u0438\u0442\u0435 '\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c' \u0438 \u043d\u0430\u0439\u0434\u0438\u0442\u0435 \u0440\u0430\u043d\u0435\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 'java.exe').<br/>   - \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043e\u043d \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 '\u041f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440\u0430 \u0432\u044b\u0441\u043e\u043a\u043e\u0439 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 (NVIDIA)'.<br/><br/>4. <strong>\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f:</strong><br/>   - \u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0438 \u0437\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u043f\u0430\u043d\u0435\u043b\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f NVIDIA.<br/><br/>5. <strong>\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 Minecraft:</strong><br/>   - \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 Minecraft, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432\u0441\u0442\u0443\u043f\u0438\u043b\u0438 \u0432 \u0441\u0438\u043b\u0443.<br/><br/>\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 Windows Server 2022 \u0438\u043b\u0438 Windows 10, \u044d\u0442\u0438 \u0448\u0430\u0433\u0438 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b NVIDIA.<br/><br/>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u0439\u0442\u0438 \u043f\u0430\u043d\u0435\u043b\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f NVIDIA, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b NVIDIA \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b.";
    }

    @Override
    public String problema_con_graficas_nvidia_windows_nuevo() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430\u043c\u0438 NVIDIA \u0432 Windows 11/Server 2025 \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u043f\u043e\u0437\u0434\u043d\u0438\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445.</span><br/><br/>\u0427\u0442\u043e\u0431\u044b \u0443\u0431\u0435\u0434\u0438\u0442\u044c\u0441\u044f, \u0447\u0442\u043e Minecraft (\u0438 \u0442\u0435\u043a\u0443\u0449\u0430\u044f JVM) \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u0443 NVIDIA, \u0441\u043b\u0435\u0434\u0443\u0439\u0442\u0435 \u044d\u0442\u0438\u043c \u0448\u0430\u0433\u0430\u043c:<br/><br/>1. <strong>\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java:</strong><br/>   - \u042d\u0442\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java: " + this.obtenerRutaJava() + "<br/>   - \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0432\u0438\u0434\u0438\u0442\u0435 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0443\u0442\u0438, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u0439\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java, \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0432 \u043f\u043e\u0438\u0441\u043a \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443 'java.exe' \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435.<br/><br/>2. <strong>\u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:</strong><br/>   - \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 <code>Win + I</code>, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b.<br/>   - \u041f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043a <strong>\u0421\u0438\u0441\u0442\u0435\u043c\u0430 > \u0414\u0438\u0441\u043f\u043b\u0435\u0439 > \u0413\u0440\u0430\u0444\u0438\u043a\u0430</strong>.<br/><br/>3. <strong>\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e GPU:</strong><br/>   - \u0412 \u0440\u0430\u0437\u0434\u0435\u043b\u0435 '\u0413\u0440\u0430\u0444\u0438\u043a\u0430' \u043d\u0430\u0436\u043c\u0438\u0442\u0435 '\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0433\u0440\u0430\u0444\u0438\u043a\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e'.<br/>   - \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 '\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0447\u0435\u0433\u043e \u0441\u0442\u043e\u043b\u0430', \u0437\u0430\u0442\u0435\u043c \u043d\u0430\u0436\u043c\u0438\u0442\u0435 '\u041e\u0431\u0437\u043e\u0440'.<br/>   - \u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0430\u043d\u0435\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b Java (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 'java.exe').<br/>   - \u041f\u043e\u0441\u043b\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 Java \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u0435\u0433\u043e \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f '\u0412\u044b\u0441\u043e\u043a\u043e\u0439 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 (NVIDIA)'.<br/><br/>4. <strong>\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f:</strong><br/>   - \u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0438 \u0437\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b.<br/><br/>5. <strong>\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 Minecraft:</strong><br/>   - \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 Minecraft, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432\u0441\u0442\u0443\u043f\u0438\u043b\u0438 \u0432 \u0441\u0438\u043b\u0443.<br/><br/>\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 Windows 11 \u0438\u043b\u0438 Windows Server 2025+, \u044d\u0442\u0438 \u0448\u0430\u0433\u0438 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b NVIDIA.<br/><br/>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u0439\u0442\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0433\u0440\u0430\u0444\u0438\u043a\u0438, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b NVIDIA \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b.";
    }

    @Override
    public String segundo60Tick() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u0430\u0448 \u0441\u0435\u0440\u0432\u0435\u0440 \u0438\u043b\u0438 \u043c\u0438\u0440 \u0438\u043c\u0435\u0435\u0442 \u0442\u0438\u043a\u0438 \u0434\u043e\u043b\u044c\u0448\u0435 60 \u0441\u0435\u043a\u0443\u043d\u0434. \u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043c\u043e\u0434\u0430\u043c\u0438, \u0437\u0430\u043c\u0435\u0434\u043b\u044f\u044e\u0449\u0438\u043c\u0438 \u0441\u0435\u0440\u0432\u0435\u0440, \u0438\u043b\u0438 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0441\u043b\u0430\u0431\u044b\u043c \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u0435\u043c.</b>";
    }

    @Override
    public String noTieneMemoria() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e RAM/\u043f\u0430\u043c\u044f\u0442\u0438. \u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435.</b>";
    }

    @Override
    public String theseus() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0423 Theseus \u0435\u0441\u0442\u044c \u0438 \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b, \u0432\u043a\u043b\u044e\u0447\u0430\u044f \u0441\u0431\u043e\u0438 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043c\u043e\u0434\u043e\u0432. \u0415\u0441\u043b\u0438 \u0432\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0442\u044c \u0444\u0430\u0439\u043b\u044b mrpack, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u044b\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u044b, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a Prism Launcher (\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f modrinth.com), ATLauncher (\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f modrinth.com) \u0438\u043b\u0438 Hello Minecraft Launcher (\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 modrinth.com \u0438 bbsmc.net).</b>";
    }

    @Override
    public String noTieneConsolaDeLauncherCursedForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043e\u043f\u0446\u0438\u044e \u00ab\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0437\u0430\u043f\u0443\u0441\u043a \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430\u00bb (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 CurseForge). \u0418\u043d\u043e\u0433\u0434\u0430 \u044d\u0442\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u0442\u0440\u0443\u0434\u043d\u043e\u0443\u043b\u043e\u0432\u0438\u043c\u044b\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b. \u042d\u0442\u043e \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043e\u043f\u0446\u0438\u0435\u0439 \u00ab\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0437\u0430\u043f\u0443\u0441\u043a \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430\u00bb \u0432 \u0441\u0442\u0430\u0440\u044b\u0445 \u0438\u043b\u0438 \u043d\u043e\u0432\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f CurseForge. \u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0435\u0451 \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u00abMojang Launcher\u00bb \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 CurseForge. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u044d\u0442\u043e \u0432\u0438\u0434\u0435\u043e \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c \u043e\u0442 Claws of Berk (\u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043a 1:11) <a href='https://youtu.be/g847O_2LjoE?si=8Y_oj3zyyhYTrSkv&t=71' style='color: inherit;'>\u0437\u0434\u0435\u0441\u044c</a>.</b>";
    }

    @Override
    public String faltar_de_clases_advertencia() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b (\u0443\u0440\u043e\u0432\u0435\u043d\u044c \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f). \u041e\u0431\u044b\u0447\u043d\u043e \u043d\u0435 \u043a\u0440\u0438\u0442\u0438\u0447\u043d\u043e, \u043d\u043e \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u2014 \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0444\u0430\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u043e\u0448\u0438\u0431\u043e\u043a. \u0427\u0430\u0441\u0442\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b: \u043f\u043b\u043e\u0445\u0438\u0435 CoreMods \u0438\u043b\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 QuickFix \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u043c\u043e\u0434\u043e\u0432 \u0441 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u043c\u0438 \u043a\u043b\u0430\u0441\u0441\u0430\u043c\u0438. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b:</b>";
    }

    @Override
    public String noResultados() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041d\u0435\u0442 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432</b>";
    }

    @Override
    public String ubicacionesDeLogs() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0420\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043b\u043e\u0433\u043e\u0432:</b>";
    }

    @Override
    public String infoDeVerificaciones() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0412\u043e\u0442 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0432\u0430\u0448\u0438\u0445 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a. \u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0439\u0442\u0435 \u043c\u0435\u0434\u043b\u0435\u043d\u043d\u043e: \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 1 \u0438\u043b\u0438 2. \u041e\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u0435 (\u043e\u0448\u0438\u0431\u043a\u0438 3 \u0438 \u0432\u044b\u0448\u0435) \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f, \u043d\u043e \u044d\u0442\u043e, \u043a\u0430\u043a \u043f\u0440\u0430\u0432\u0438\u043b\u043e, \u043a\u0430\u0441\u043a\u0430\u0434\u043d\u044b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0436\u043d\u043e \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c. \u0421\u0431\u043e\u0438 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u044f\u0442 \u0441\u043b\u043e\u044f\u043c\u0438, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0440\u0435\u0448\u0438\u0442 \u0438\u043c\u0435\u043d\u043d\u043e \u044d\u0442\u0443 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u0443\u044e \u043e\u0448\u0438\u0431\u043a\u0443. \u041e\u0434\u043d\u0430\u043a\u043e \u0437\u0430\u0432\u0442\u0440\u0430 \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u044f\u0432\u0438\u0442\u044c\u0441\u044f \u043d\u043e\u0432\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430, \u043d\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u0430\u044f \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u0434\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0447\u0430\u0441\u0442\u043e \u043c\u0435\u0448\u0430\u0435\u0442 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044e \u0434\u0440\u0443\u0433\u043e\u0439 \u0432 \u043a\u043e\u043d\u0441\u043e\u043b\u0438.</b>";
    }

    @Override
    public String versionDeJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 Java 17 \u0434\u043b\u044f \u0432\u0435\u0440\u0441\u0438\u0439 1.17-1.20.4 \u0438 Java 21 \u0434\u043b\u044f \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439. \u0414\u043b\u044f \u0441\u0442\u0430\u0440\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 Java 8. [\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). \u0415\u0441\u043b\u0438 \u0443 \u0432\u0430\u0441 \u0432\u0441\u0435 \u0435\u0449\u0435 \u0435\u0441\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b, \u044d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u0442\u0435\u043c, \u0447\u0442\u043e \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0434\u044b \u0438\u043c\u0435\u044e\u0442 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043d\u043e\u0432\u044b\u0435 \u0438\u043b\u0438 \u0441\u0442\u0430\u0440\u044b\u0435 \u0444\u0430\u0439\u043b\u044b.</b>";
    }

    @Override
    public String java22() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 22 \u0438 \u0432\u044b\u0448\u0435 \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0432 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 Minecraft \u043d\u0438\u0436\u0435 1.20.5 \u0434\u043b\u044f \u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u043e\u0432 \u043c\u043e\u0434\u043e\u0432 \u0438\u0437-\u0437\u0430 \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0435\u0433\u043e ASM.</b>" + this.versionDeJava();
    }

    @Override
    public String javaObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java \u0443\u0441\u0442\u0430\u0440\u0435\u043b\u0430 </b>" + this.versionDeJava();
    }

    @Override
    public String jpms_modules_faltas(String mod_necesitas, String submod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u0430\u043c \u043d\u0443\u0436\u0435\u043d JPMS \u043c\u043e\u0434\u0443\u043b\u044c " + mod_necesitas + " \u0438\u0437 " + submod + "</b>";
    }

    @Override
    public String null_pointer_error(String metodo, String objeto) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0437\u0432\u0430\u0442\u044c " + metodo + ", \u0442\u0430\u043a \u043a\u0430\u043a " + objeto + " \u0440\u0430\u0432\u0435\u043d null</b>";
    }

    @Override
    public String analisisAvanzado() {
        return "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u0430\u043d\u0430\u043b\u0438\u0437";
    }

    @Override
    public String seleccionarCarpeta() {
        return "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443";
    }

    @Override
    public String cadenaBusqueda() {
        return "\u0421\u0442\u0440\u043e\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430";
    }

    @Override
    public String usarRegex() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f";
    }

    @Override
    public String ignorarMayusculas() {
        return "\u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440";
    }

    @Override
    public String buscar() {
        return "\u041f\u043e\u0438\u0441\u043a";
    }

    @Override
    public String busquedaEnProgreso() {
        return "\u041f\u043e\u0438\u0441\u043a \u0432 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435";
    }

    @Override
    public String noSeEncontraronResultados() {
        return "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
    }

    @Override
    public String errorBusqueda() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430";
    }

    @Override
    public String omitirYCerrar() {
        return "\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0438 \u0417\u0430\u043a\u0440\u044b\u0442\u044c";
    }

    @Override
    public String guardarYCerrar() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438 \u0417\u0430\u043a\u0440\u044b\u0442\u044c";
    }

    @Override
    public String pegaLosRegistrosAqui() {
        return "\u0412\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u043b\u043e\u0433\u0438 \u0441\u044e\u0434\u0430";
    }

    @Override
    public String archivo() {
        return "\u0424\u0430\u0439\u043b";
    }

    @Override
    public String incluir() {
        return "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c";
    }

    @Override
    public String abrir() {
        return "\u041e\u0442\u043a\u0440\u044b\u0442\u044c";
    }

    @Override
    public String endpointDeInforme() {
        return "\u041a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0442\u043e\u0447\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430";
    }

    @Override
    public String sitoDeLogging() {
        return "\u0421\u0430\u0439\u0442 \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f:";
    }

    @Override
    public String apiDeLogging() {
        return "API \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f:";
    }

    @Override
    public String anonimizarRegistros() {
        return "\u0410\u043d\u043e\u043d\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u043b\u043e\u0433\u043e\u0432 (\u0411\u0435\u0442\u0430)";
    }

    @Override
    public String botonDeCompartirInforme() {
        return "\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043e\u0442\u0447\u0435\u0442\u043e\u043c \u0438 \u0432\u0441\u0435\u043c\u0438 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c\u0438 \u043b\u043e\u0433\u0430\u043c\u0438";
    }

    @Override
    public String arco() {
        return "\u042d\u0442\u043e\u0442 \u0434\u0438\u0430\u043b\u043e\u0433 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0432\u0430\u043c \u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043b\u043e\u0433\u0430\u043c\u0438 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e API SecureLogger \u043d\u0430 <a href=\"https://securelogger.net\">securelogger.net</a>. \u041f\u0440\u0438 \u043d\u0430\u0436\u0430\u0442\u0438\u0438 \u043a\u043d\u043e\u043f\u043a\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043e\u0442\u0447\u0451\u0442\u0430 \u0432\u0430\u0448 \u043e\u0442\u0447\u0451\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043d\u0434\u043f\u043e\u0438\u043d\u0442 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: asbestosstar.egoism.jp) (\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u043d\u0438\u0437\u0443). \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043b\u043e\u0433\u0438 \u0432\u043c\u0435\u0441\u0442\u0435 \u0441 \u043e\u0442\u0447\u0451\u0442\u043e\u043c. \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435, \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u044d\u0442\u043e\u0442 \u0434\u0438\u0430\u043b\u043e\u0433! \u041c\u044b \u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u043c \u0432\u0430\u0448 \u043e\u0442\u0447\u0451\u0442 \u043d\u0430 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u043c \u044d\u043d\u0434\u043f\u043e\u0438\u043d\u0442\u0435 (<a href=\"https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb\">https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb</a>); \u043c\u044b \u043b\u0438\u0448\u044c \u0443\u0434\u0430\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438. \u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u043a\u043e\u0434 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0437\u0434\u0435\u0441\u044c: <a href=\"https://pagure.io/CrashDetectorMC/blob/main/f/src/main/resources/crash_detector_servidor.rb\">\u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u043a\u043e\u0434</a>. \u042d\u0442\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0432\u0430\u0448\u0435\u043c \u0441\u0431\u043e\u0435 \u0438 \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043b\u043e\u0433\u0438. \u041e\u0434\u043d\u0430\u043a\u043e \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439 \u044d\u043d\u0434\u043f\u043e\u0438\u043d\u0442, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u043e\u0436\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0438\u043d\u0430\u0447\u0435. \u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0441\u0430\u0439\u0442 \u043e\u0442\u0447\u0451\u0442\u043e\u0432 " + Config.obtenerInstancia().obtenerSitoDeInformes() + " \u0438 \u0441\u0430\u0439\u0442 \u043b\u043e\u0433\u043e\u0432 " + Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado() + ". \u0412\u044b \u0442\u0430\u043a\u0436\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u043b\u043e\u0433\u0430\u043c\u0438 \u0431\u0435\u0437 \u043e\u0442\u0447\u0451\u0442\u0430, \u043d\u0430\u0436\u0430\u0432 \u043a\u043d\u043e\u043f\u043a\u0438 \u00ab\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f\u00bb \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u043c\u0435\u043d\u0430\u043c\u0438 \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0445 \u043b\u043e\u0433\u043e\u0432; \u043b\u043e\u0433\u0438 \u0431\u0443\u0434\u0443\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0441\u0430\u0439\u0442 \u043b\u043e\u0433\u043e\u0432. CrashDetector \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0430\u043d\u043e\u043d\u0438\u043c\u0438\u0437\u0438\u0440\u0443\u0435\u0442 \u043b\u043e\u0433\u0438, \u043f\u044b\u0442\u0430\u044f\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u043c\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439, UUID, \u0442\u043e\u043a\u0435\u043d\u044b \u0434\u043e\u0441\u0442\u0443\u043f\u0430, ID \u0441\u0435\u0441\u0441\u0438\u0439, IP-\u0430\u0434\u0440\u0435\u0441\u0430 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435. \u041e\u0434\u043d\u0430\u043a\u043e \u044d\u0442\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u0438\u0434\u0435\u0430\u043b\u044c\u043d\u0430. \u041a\u0440\u043e\u043c\u0435 \u0442\u043e\u0433\u043e, \u0430\u0432\u0442\u043e\u0440 \u043c\u043e\u0434\u043f\u0430\u043a\u0430 \u043c\u043e\u0436\u0435\u0442 \u0435\u0451 \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c. \u0415\u0451 \u043c\u043e\u0436\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u043b\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0444\u043b\u0430\u0436\u043a\u0430 \u0432\u043d\u0438\u0437\u0443 \u044d\u0442\u043e\u0433\u043e \u043e\u043a\u043d\u0430. \u0412\u044b \u2014 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u0451\u0440 \u0441\u0432\u043e\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445; \u0438\u043c\u0435\u043d\u043d\u043e \u0432\u044b \u0440\u0435\u0448\u0430\u0435\u0442\u0435, \u043a\u0443\u0434\u0430 \u0438\u0445 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044c. \u0421\u0430\u0439\u0442\u044b \u043b\u043e\u0433\u043e\u0432 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0430\u0442 \u0442\u0440\u0435\u0442\u044c\u0438\u043c \u043b\u0438\u0446\u0430\u043c, \u0447\u044c\u044f \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0447\u0430\u0441\u0442\u043e \u0441\u043a\u0440\u044b\u0442\u0430 \u0438\u0437 \u0441\u043e\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439 \u043f\u0440\u0438\u0432\u0430\u0442\u043d\u043e\u0441\u0442\u0438. \u0412\u044b \u043d\u0435\u0441\u0451\u0442\u0435 \u043f\u043e\u043b\u043d\u0443\u044e \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0438\u043c\u0438 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0438 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u044d\u0442\u0438\u043c \u0440\u0438\u0441\u043a\u0438. \u0414\u0438\u0430\u043b\u043e\u0433 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 CrashDetector \u2014 \u044d\u0442\u043e \u043f\u0440\u043e\u0441\u0442\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441, \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0449\u0438\u0439 \u0432\u0430\u043c \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u044d\u0442\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u043c. \u0412\u0430\u0436\u043d\u043e, \u0447\u0442\u043e\u0431\u044b \u0432\u044b \u0437\u043d\u0430\u043b\u0438 \u043e GDPR \u0438 ARCO. \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0435\u0441\u044c \u0432 \u0415\u0432\u0440\u043e\u043f\u0435, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c <a href=\"https://securelogger.top\">securelogger.top</a>, \u0440\u0430\u0437\u043c\u0435\u0449\u0451\u043d\u043d\u044b\u0439 \u0432 \u0413\u0435\u0440\u043c\u0430\u043d\u0438\u0438 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0435\u0439 Hetzner. \u0414\u043b\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u044e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0441\u043c. \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0441\u0441\u044b\u043b\u043a\u0438: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFPDPPP.pdf\">LFPDPPP</a>, <a href=\"https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679\">GDPR</a>, <a href=\"https://www.ppc.go.jp/files/pdf/20220401_personal_basicpolicy.pdf\">\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u0437\u0430\u0449\u0438\u0442\u044b \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u042f\u043f\u043e\u043d\u0438\u0438</a>.";
    }

    @Override
    public String enlaceDelReporte() {
        return "\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043e\u0442\u0447\u0435\u0442:";
    }

    @Override
    public String guardarConfigDeCompartir() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0431\u043c\u0435\u043d\u0430";
    }

    @Override
    public String registroDemasiadoGrande() {
        return "\u041b\u043e\u0433 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430 \u043b\u043e\u0433\u043e\u0432. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443.";
    }

    @Override
    public String errorConPublicarRegistro(String error) {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u043b\u043e\u0433\u0430 " + error;
    }

    @Override
    public String apiDeRegistroNoExiste() {
        return "API \u043b\u043e\u0433\u043e\u0432 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u0435 API \u043b\u043e\u0433\u043e\u0432 \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445.";
    }

    @Override
    public String errorSSL() {
        return "\u0423 \u0432\u0430\u0441 \u043e\u0448\u0438\u0431\u043a\u0430 SSL. \u042d\u0442\u043e \u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0432 \u0441\u0442\u0430\u0440\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 Java, \u0432\u043a\u043b\u044e\u0447\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u0438 Java 8 \u0432 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u043c \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0435 Minecraft \u0438 \u0432\u0435\u0440\u0441\u0438\u0438 \u0441 sun.com \u0438 java.com. \u042d\u0442\u043e \u0432\u043b\u0438\u044f\u0435\u0442 \u043d\u0430 \u043c\u043d\u043e\u0433\u0438\u0435 \u0430\u0441\u043f\u0435\u043a\u0442\u044b, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a JAR-\u0444\u0430\u0439\u043b\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0449\u0438\u043a\u0430 MinecraftForge, \u0444\u0443\u043d\u043a\u0446\u0438\u044f \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 CrashDetector \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430, \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0434\u044b, \u0442\u0440\u0435\u0431\u0443\u044e\u0449\u0438\u0435 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430, \u0438 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0441\u0430\u0439\u0442\u044b \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438 \u043b\u043e\u0433\u043e\u0432. \u0415\u0441\u043b\u0438 \u044d\u0442\u043e \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043e\u0442\u0447\u0435\u0442\u043e\u043c, \u043f\u0440\u043e\u0441\u0442\u043e \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442 \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0430\u0439\u0442 \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438 \u043b\u043e\u0433\u043e\u0432, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u0441\u043e \u0441\u0442\u0430\u0440\u044b\u043c\u0438 \u0432\u0435\u0440\u0441\u0438\u044f\u043c\u0438 Java 8.";
    }

    @Override
    public String errorJavaFMLVersion(String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f JavaFML: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f " + requerido + ", \u043d\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u0430 " + encontrado + "</b>";
    }

    @Override
    public String errorJavaFML_MCForge() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! JavaFML \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft Forge</b>";
    }

    @Override
    public String errorProveedorVersion(String archivoJar, String proveedor, String requerido, String encontrado) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0424\u0430\u0439\u043b JAR '" + archivoJar + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 '" + proveedor + "' \u0432\u0435\u0440\u0441\u0438\u0438 '" + requerido + "' \u0438\u043b\u0438 \u0432\u044b\u0448\u0435, \u043d\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0435\u0440\u0441\u0438\u044f '" + encontrado + "'.</b>";
    }

    @Override
    public String advertenciaMalwareFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415! Crash Assistant \u2014 \u044d\u0442\u043e \u043f\u043e\u0434\u0434\u0435\u043b\u044c\u043d\u044b\u0439 \u0434\u0435\u0442\u0435\u043a\u0442\u043e\u0440 \u0432\u0440\u0435\u0434\u043e\u043d\u043e\u0441\u043d\u043e\u0433\u043e \u041f\u041e. \u041e\u043d \u043d\u0430\u043c\u0435\u0440\u0435\u043d\u043d\u043e \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b, \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u044f \u0432\u0430\u0448\u0443 \u0441\u0432\u043e\u0431\u043e\u0434\u0443 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0442\u044c \u0438\u0433\u0440\u0430\u0442\u044c \u0441 \u0446\u0435\u043b\u0435\u0432\u044b\u043c\u0438 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f\u043c\u0438. <a href='https://github.com/KostromDan/Crash-Assistant/blob/8decd964e629100f36fc72ca2eb3c1226652f223/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/mod_list/MalwareMod.java#L7'>\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043a\u043e\u0434 MalwareMod.java</a>   <a href='https://github.com/KostromDan/Crash-Assistant/blob/0787924a97a29fec8a83969fae3e87e30d816f22/common_config/src/main/java/dev/kostromdan/mods/crash_assistant/common_config/loading_utils/JarInJarHelper.java#L185'>\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043a\u043e\u0434 JarInJarHelper.java</a>. \u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u0432 \u0438\u0445 \u0441\u043f\u0438\u0441\u043a\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u044d\u0442\u043e\u0442 \u043c\u043e\u0434, \u0438 \u043e\u043d\u0438 \u0444\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043d\u0430\u0446\u0435\u043b\u0435\u043d\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0441\u0430\u0439\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0451\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c, \u0438 \u044d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0432\u044b \u044f\u0432\u043d\u043e \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u0443\u044e \u0444\u0443\u043d\u043a\u0446\u0438\u044e \u043e\u0431\u043c\u0435\u043d\u0430 \u043b\u043e\u0433\u0430\u043c\u0438. CrashAssistant \u041d\u0415 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442 \u043d\u0438\u043a\u0430\u043a\u0438\u0445 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u043a\u0430\u043a\u043e\u0439 \u0441\u0430\u0439\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f, \u0438 \u043d\u0435 \u043e\u0431\u044a\u044f\u0441\u043d\u044f\u0435\u0442, \u043a\u0430\u043a \u0435\u0433\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c (\u0435\u0441\u0442\u044c \u0432\u044b\u043f\u0430\u0434\u0430\u044e\u0449\u0435\u0435 \u043c\u0435\u043d\u044e \u0432\u043d\u0438\u0437\u0443 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u0433\u043e \u043e\u043a\u043d\u0430 \u043e\u0431\u043c\u0435\u043d\u0430), \u0438 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e \u043e\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430, CrashAssistant \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b. \u0412 \u0438\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0438 \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f, \u0447\u0442\u043e\u0431\u044b \u0432\u044b \u043f\u0440\u043e\u0432\u0435\u043b\u0438 \u0441\u0432\u043e\u0451 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 \u0438\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435, \u0421\u0414\u0415\u041b\u0410\u0419\u0422\u0415 \u042d\u0422\u041e, \u0438\u0437\u0443\u0447\u0438\u0442\u0435 \u043a\u043e\u0434 CrashDetector \u0438 Crash Assistant \u0438 \u043f\u043e\u0439\u043c\u0438\u0442\u0435, \u0447\u0442\u043e \u043e\u043d\u0438 \u0434\u0435\u043b\u0430\u044e\u0442, \u041d\u0415 \u043f\u043e\u043b\u0430\u0433\u0430\u0439\u0442\u0435\u0441\u044c \u043d\u0430 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u0430\u0432\u0442\u043e\u0440\u0438\u0442\u0435\u0442\u0443.</b>";
    }

    @Override
    public String error_clase_no_encontrada_mcforge_mod_suspechoso(String idMod, String claseNoEncontrada) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + idMod + "' \u043d\u0435 \u0441\u043c\u043e\u0433 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c\u0441\u044f, \u0442\u0430\u043a \u043a\u0430\u043a \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 \u043d\u0435 \u0431\u044b\u043b \u043d\u0430\u0439\u0434\u0435\u043d: '" + claseNoEncontrada + "'. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u0441\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e.</b>";
    }

    @Override
    public String waterMediaTL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Watermedia \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043b \u0438\u0433\u0440\u0443 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e TLauncher.</b>";
    }

    @Override
    public String optifineObsoleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e Optifine \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e Optifine, \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft, \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435.</b>";
    }

    @Override
    public String servicioMLNoPudoCargar(String servicio) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043b\u0443\u0436\u0431\u0443 ModLauncher: </b>" + servicio + ".";
    }

    @Override
    public String errorConJSONDeRegistro(String archivoJar, String recurso) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 JSON-\u0444\u0430\u0439\u043b\u0430 '" + recurso + "' \u0438\u0437 JAR-\u0444\u0430\u0439\u043b\u0430 '" + archivoJar + "'. \u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0435\u0439.</b>";
    }

    @Override
    public String errorVersionDependencia(String modId, String dependencia, String requerido, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430: \u041c\u043e\u0434 '" + modId + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0432\u0435\u0440\u0441\u0438\u044e '" + requerido + "' \u0438\u043b\u0438 \u0432\u044b\u0448\u0435 \u0434\u043b\u044f '" + dependencia + "', \u043d\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432\u0435\u0440\u0441\u0438\u044f '" + actual + "'.</span>";
    }

    @Override
    public String gpu_no_compatible() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u0430\u0448\u0430 \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e OpenGL \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u0433\u0440\u044b. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b \u0438\u043b\u0438 \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u0435 \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u0443.</b>";
    }

    @Override
    public String recomendacionMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0423\u0432\u0435\u043b\u0438\u0447\u044c\u0442\u0435 \u043e\u0431\u044a\u0435\u043c \u043f\u0430\u043c\u044f\u0442\u0438, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0434\u043b\u044f \u0438\u0433\u0440\u044b, \u0438\u043b\u0438 \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u043e\u0432/\u043f\u043b\u0430\u0433\u0438\u043d\u043e\u0432.</b>";
    }

    @Override
    public String error32BitMemoria() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 32-\u0431\u0438\u0442\u043d\u0430\u044f JVM: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435 4 \u0413\u0411 \u043e\u043f\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 64-\u0431\u0438\u0442\u043d\u0443\u044e JVM, \u0447\u0442\u043e\u0431\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u044e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0443\u044e \u043f\u0430\u043c\u044f\u0442\u044c.</b>";
    }

    @Override
    public String permGenError() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 PermGen \u043f\u0430\u043c\u044f\u0442\u0438. \u0423\u0432\u0435\u043b\u0438\u0447\u044c\u0442\u0435 \u043e\u0431\u044a\u0435\u043c \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438 \u0438\u043b\u0438 \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u043a\u043b\u0430\u0441\u0441\u043e\u0432.</b>";
    }

    @Override
    public String errorCompatibilidadJava8() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u043c\u0435\u0436\u0434\u0443 Java 8 \u0438 \u0441\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c\u0438 \u0432\u0435\u0440\u0441\u0438\u044f\u043c\u0438</b>";
    }

    @Override
    public String errorJava9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Java 9+ \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f - \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 Java 8 \u0434\u043b\u044f \u0441\u0442\u0430\u0440\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 Forge</b>";
    }

    @Override
    public String errorJava8Requerido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f Java 8 (\u0432\u0435\u0440\u0441\u0438\u044f 52.0). \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e</b>";
    }

    @Override
    public String errorDeBloqueTeselado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438: \u0411\u043b\u043e\u043a\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u0432 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u0435\u0440\u0441\u0438\u0438 \u043c\u043e\u0434\u043e\u0432 \u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b</b>";
    }

    @Override
    public String errorMonitorLWJGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u0432: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u044d\u043a\u0440\u0430\u043d\u0430. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435:</b><br>- \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u0432<br>- \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u044b<br>- \u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435, \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439";
    }

    @Override
    public String errorOpcionesGCJava() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 Java: \u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u044e\u0449\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441\u0431\u043e\u0440\u0449\u0438\u043a\u0430 \u043c\u0443\u0441\u043e\u0440\u0430. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u0443\u0435\u0442\u0435 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c\u043e\u0432 GC \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 JVM</b>";
    }

    @Override
    public String errorConfigMCForge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 NightConfig/Forge: \u0424\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d \u0438\u043b\u0438 \u043d\u0435\u043f\u043e\u043b\u043e\u043d. \u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u0437\u0432\u0430\u043d\u043e \u043f\u0443\u0441\u0442\u044b\u043c\u0438 \u0444\u0430\u0439\u043b\u0430\u043c\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 (\u0447\u0430\u0441\u0442\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c 0 \u0431\u0430\u0439\u0442) \u0432 \u043f\u0430\u043f\u043a\u0435 'config' \u0432 \u0441\u0442\u0430\u0440\u044b\u0445 \u0438\u043b\u0438 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 NightConfig. \u0412 \u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u0435 \u0441\u043b\u0443\u0447\u0430\u0435\u0432 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u043c\u043e\u0434\u043e\u043c Night Config Fixes, \u043d\u043e \u0435\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0438\u043b\u0438 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e NightConfig, \u0432\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b\u044b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0432\u0440\u0443\u0447\u043d\u0443\u044e. \u042d\u0442\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0447\u0430\u0449\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0432 \u0441\u0442\u0430\u0440\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 MC Forge (\u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c NightConfig) \u0438 \u0432 \u0441\u0442\u0430\u0440\u044b\u0445 \u043c\u043e\u0434\u0430\u0445 FabricMC, \u0432\u043a\u043b\u044e\u0447\u0430\u044e\u0449\u0438\u0445 NightConfig, \u043d\u043e \u0442\u0430\u043a\u0436\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0442\u044c \u0432 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u043e\u0440\u043a\u0430\u0445 NightConfig. \u0411\u043e\u043b\u044c\u0448\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0440\u0435\u0448\u0435\u043d\u0438\u044f\u0445 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 <a href='https://www.curseforge.com/minecraft/mc-mods/night-config-fixes'>Night Config Fixes</a>.</b>";
    }

    @Override
    public String problema_con_graficas_intel() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430 Intel HD Graphics. \u0420\u0435\u0448\u0435\u043d\u0438\u044f:</b><br>1. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b Intel \u0441 <a href='https://www.intel.com/content/www/us/en/download-center/home.html'>intel.com</a> (\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f 15.xx.xx.xx)<br>2. \u0412 Minecraft: \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u2192 \u0412\u0438\u0434\u0435\u043e \u2192 \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u0435 'Enable VBOs' \u0438 'VSync'<br>3. \u0412\u044b\u0434\u0435\u043b\u0438\u0442\u0435 1GB-2GB RAM \u0434\u043b\u044f \u0438\u0433\u0440\u044b \u0432 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0435<br>4. \u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0430\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441/\u0431\u0440\u0430\u043d\u0434\u043c\u0430\u0443\u044d\u0440 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f";
    }

    @Override
    public String nombre_de_faltar_de_clases_advertencia() {
        return "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b";
    }

    @Override
    public String nombre_de_bloque_teselado() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 \u0431\u043b\u043e\u043a\u043e\u0432";
    }

    @Override
    public String nombre_de_contenido_de_stacktrace() {
        return "\u0410\u043d\u0430\u043b\u0438\u0437 \u0441\u0442\u0435\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u043e\u0432 (stack trace)";
    }

    @Override
    public String nombre_de_cursed_consola() {
        return "\u041d\u0435\u043f\u043e\u043b\u043d\u0430\u044f \u043a\u043e\u043d\u0441\u043e\u043b\u044c CurseForge";
    }

    @Override
    public String nombre_de_early_window() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u043d\u043d\u0435\u0433\u043e \u043e\u043a\u043d\u0430 (FMLEarlyWindow)";
    }

    @Override
    public String nombre_de_drivers() {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0432\u0438\u0434\u0435\u043e\u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430\u043c\u0438";
    }

    @Override
    public String nombre_de_error_de_config_mcforge() {
        return "\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f MCForge";
    }

    @Override
    public String nombre_de_error_de_monitor_lwjgl() {
        return "\u0421\u0431\u043e\u0439 \u0440\u0435\u0436\u0438\u043c\u0430 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f (LWJGL)";
    }

    @Override
    public String nombre_de_fabricmc_runtime_error_provided_by() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 FabricMC";
    }

    @Override
    public String nombre_de_falta_module_jmps() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u0438 JPMS";
    }

    @Override
    public String nombre_de_faltar_de_clases() {
        return "\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b";
    }

    @Override
    public String nombre_de_faltas_dependencias_de_modlauncher() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 ModLauncher";
    }

    @Override
    public String nombre_de_java_versiones() {
        return "\u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 Java";
    }

    @Override
    public String nombre_de_faltar_de_kubejs_resourcepack() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 KubeJS";
    }

    @Override
    public String nombre_de_lenguaje_proveedor_check() {
        return "\u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440";
    }

    @Override
    public String nombre_de_faltar_de_liyhostictchctov() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 Litchhost";
    }

    @Override
    public String nombre_de_malware_falso_crash_assistant() {
        return "\u041b\u043e\u0436\u043d\u043e\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u0434\u043e\u043d\u043e\u0441\u043d\u043e\u0433\u043e \u041f\u041e";
    }

    @Override
    public String nombre_de_mcforge_mod_sespechoso() {
        return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043c\u043e\u0434";
    }

    @Override
    public String nombre_de_mods_duplicados_modlauncher() {
        return "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b \u0432 ModLauncher";
    }

    @Override
    public String nombre_de_modules_duplicados_jmps() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b \u043c\u043e\u0434\u0443\u043b\u0435\u0439 JPMS";
    }

    @Override
    public String nombre_de_necesitas_sodium() {
        return "\u0414\u043b\u044f Iris \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f Sodium";
    }

    @Override
    public String nombre_de_no_puede_analizar_json_de_registro() {
        return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c JSON \u0440\u0435\u0435\u0441\u0442\u0440\u0430";
    }

    @Override
    public String nombre_de_no_tiene_memoria() {
        return "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0430\u043c\u044f\u0442\u0438";
    }

    @Override
    public String nombre_de_null_pointer() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f (NullPointerException)";
    }

    @Override
    public String nombre_de_opciones_java_gc_invalidas() {
        return "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441\u0431\u043e\u0440\u043a\u0438 \u043c\u0443\u0441\u043e\u0440\u0430 Java (GC)";
    }

    @Override
    public String nombre_de_optifine_obsoleta() {
        return "\u0423\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0430\u044f/\u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430\u044f OptiFine";
    }

    @Override
    public String nombre_de_60_segundo_trick() {
        return "\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0442\u0438\u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (60 \u0441\u0435\u043a\u0443\u043d\u0434)";
    }

    public String nombre_de_servicio_de_modlauncher_nao_funciona() {
        return "\u0421\u0431\u043e\u0439 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 ModLauncher";
    }

    @Override
    public String nombre_de_spongemixin_configs_problematicos() {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 SpongeMixing";
    }

    @Override
    public String nombre_de_theseus() {
        return "Theseus \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c";
    }

    @Override
    public String nombre_de_watermedia_tl() {
        return "TLauncher \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f WATERMeDIA";
    }

    @Override
    public String nombre_de_servicio_de_modlauncher_no_funciona() {
        return "\u0421\u0435\u0440\u0432\u0438\u0441 ModLauncher \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442";
    }

    @Override
    public String auditorias_transformer() {
        return "\u0410\u0443\u0434\u0438\u0442\u044b Transformer";
    }

    @Override
    public String auditorias_transformer_detectadas() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u042d\u0442\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u043e\u0432 Transformer \u0432 Vanilla-\u0437\u0430\u043f\u0443\u0441\u043a\u0430\u043b\u043a\u0435. \u041e\u0431\u044b\u0447\u043d\u043e \u044d\u0442\u043e \u043c\u0435\u043d\u0435\u0435 \u0442\u043e\u0447\u043d\u043e, \u0447\u0435\u043c \u0430\u043d\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 StackTrace, \u043d\u043e \u0432 Vanilla-\u0437\u0430\u043f\u0443\u0441\u043a\u0430\u043b\u043a\u0435 \u043d\u0435 \u0432\u0441\u0435\u0433\u0434\u0430 \u0435\u0441\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0434\u043b\u044f {}</b>";
    }

    @Override
    public String descripcionEscanerMCreator() {
        return "\u042d\u0442\u043e \u043f\u0440\u043e\u0441\u043c\u0430\u0442\u0440\u0438\u0432\u0430\u0435\u0442 \u0432\u0430\u0448\u0438 \u043c\u043e\u0434\u044b \u0432 \u043f\u043e\u0438\u0441\u043a\u0430\u0445 \u043c\u043e\u0434\u043e\u0432, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0445 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e MCreator. \u0425\u043e\u0442\u044f \u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u043e \u043c\u043e\u0434\u043e\u0432 MCreator \u0432\u043f\u043e\u043b\u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u043e\u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b \u0438 \u0435\u0441\u0442\u044c \u043c\u043d\u043e\u0433\u043e \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0445 \u043c\u043e\u0434\u043e\u0432, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0445 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e MCreator, \u0438\u043d\u043e\u0433\u0434\u0430 \u0443 \u043d\u0438\u0445 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u044e\u0442 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b, \u0438 \u043e\u043d\u0438 \u0438\u043c\u0435\u044e\u0442 \u043f\u043b\u043e\u0445\u0443\u044e \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044e. \u042d\u0442\u043e \u043f\u043e\u043c\u043e\u0433\u0430\u0435\u0442 \u0438\u0445 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435 \u0432\u043d\u0438\u043c\u0430\u043d\u0438\u0435, \u0447\u0442\u043e \u0434\u0430\u0436\u0435 \u0432\u044b\u0441\u043e\u043a\u043e \u043e\u0446\u0435\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b \u043c\u043e\u0433\u0443\u0442 \u043d\u0430 \u0441\u0430\u043c\u043e\u043c \u0434\u0435\u043b\u0435 \u043d\u0435 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d\u044b MCreator; \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0443 \u043d\u0438\u0445 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044f \u0441 MCreator.";
    }

    @Override
    public String escanear() {
        return "\u0421\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c";
    }

    @Override
    public String cargando() {
        return "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430";
    }

    @Override
    public String codigo() {
        return "ru";
    }

    @Override
    public String inicioApp() {
        return "\u0417\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b/\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    }

    @Override
    public String ajustesCrashDetector() {
        return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0434\u0435\u0442\u0435\u043a\u0442\u043e\u0440\u0430 \u0441\u0431\u043e\u0435\u0432";
    }

    @Override
    public String confidencialidad() {
        return "\u041a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c";
    }

    @Override
    public String tooltip() {
        return "\u041f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430";
    }

    @Override
    public String config() {
        return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430";
    }

    @Override
    public String abrirCarpeta() {
        return "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043f\u043a\u0443";
    }

    @Override
    public String actualizar() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c";
    }

    @Override
    public String anadirRegistro() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043b\u043e\u0433";
    }

    @Override
    public String usarIdiomaDelSistema() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u044f\u0437\u044b\u043a";
    }

    @Override
    public String volver() {
        return "\u041d\u0430\u0437\u0430\u0434";
    }

    @Override
    public String colorFondo() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 (#RRGGBB):";
    }

    @Override
    public String colorTexto() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 (#RRGGBB):";
    }

    @Override
    public String colorBoton() {
        return "\u0426\u0432\u0435\u0442 \u043a\u043d\u043e\u043f\u043a\u0438 (#RRGGBB):";
    }

    @Override
    public String colorCajaTexto() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u043b\u044f (#RRGGBB):";
    }

    @Override
    public String colorEnlace() {
        return "\u0426\u0432\u0435\u0442 \u0441\u0441\u044b\u043b\u043a\u0438 (#RRGGBB):";
    }

    @Override
    public String colorTitulosConsolas() {
        return "\u0426\u0432\u0435\u0442 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u043e\u0432 \u043a\u043e\u043d\u0441\u043e\u043b\u0435\u0439 (#RRGGBB):";
    }

    @Override
    public String colorError() {
        return "\u0426\u0432\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0438 (#RRGGBB):";
    }

    @Override
    public String colorAdvertencia() {
        return "\u0426\u0432\u0435\u0442 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f (#RRGGBB):";
    }

    @Override
    public String colorInfo() {
        return "\u0426\u0432\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 (#RRGGBB):";
    }

    @Override
    public String colorTitulo() {
        return "\u0426\u0432\u0435\u0442 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 (#RRGGBB):";
    }

    @Override
    public String colorEnlaceTexto() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u0441\u0441\u044b\u043b\u043a\u0438 (#RRGGBB):";
    }

    @Override
    public String transformacionDeMinecraftCodigo0() {
        return "\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u0442\u044c CrashDetector \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438 \u0441\u0431\u043e\u0435";
    }

    @Override
    public String activar_parche() {
        return "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0442\u0447";
    }

    @Override
    public String noHaySolucionDisponible() {
        return "\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0440\u0435\u0448\u0435\u043d\u0438\u0439";
    }

    @Override
    public String error() {
        return "\u043e\u0448\u0438\u0431\u043a\u0430";
    }

    @Override
    public String error_al_eliminar_jar() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 Jar";
    }

    @Override
    public String jar_eliminado_exitosamente() {
        return "Jar \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d";
    }

    @Override
    public String exito() {
        return "\u0443\u0441\u043f\u0435\u0445";
    }

    @Override
    public String eliminar() {
        return "\u0443\u0434\u0430\u043b\u0438\u0442\u044c";
    }

    @Override
    public String error_al_eliminar_paquete() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u043a\u0435\u0442\u0430";
    }

    @Override
    public String paquete_eliminado_exitosamente() {
        return "\u041f\u0430\u043a\u0435\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d";
    }

    @Override
    public String eliminar_paquete() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043a\u0435\u0442";
    }

    @Override
    public String no_se_encontraron_mods_con_paquete() {
        return "\u041c\u043e\u0434\u044b \u0441 \u043f\u0430\u043a\u0435\u0442\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
    }

    @Override
    public String no_se_puede_eliminar_paquete() {
        return "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043a\u0435\u0442";
    }

    @Override
    public String eliminar_jar() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c Jar";
    }

    @Override
    public String no_se_encontraron_mods_duplicados() {
        return "\u0414\u0443\u0431\u043b\u0438\u0440\u0443\u044e\u0449\u0438\u0435\u0441\u044f \u043c\u043e\u0434\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
    }

    @Override
    public String archivo_no_encontrado() {
        return "\u0424\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
    }

    @Override
    public String directorio_eliminado() {
        return "\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u0443\u0434\u0430\u043b\u0435\u043d";
    }

    @Override
    public String error_al_eliminar_jar_anidado() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0433\u043e Jar";
    }

    @Override
    public String archivo_interno_no_encontrado() {
        return "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0444\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
    }

    @Override
    public String archivo_eliminado() {
        return "\u0444\u0430\u0439\u043b \u0443\u0434\u0430\u043b\u0435\u043d";
    }

    @Override
    public String error_al_eliminar_archivo() {
        return "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430";
    }

    @Override
    public String archivo_externo_no_valido() {
        return "\u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0432\u043d\u0435\u0448\u043d\u0438\u0439 \u0444\u0430\u0439\u043b";
    }

    @Override
    public String elemento_mod_eliminado() {
        return "\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u043e\u0434\u0430 \u0443\u0434\u0430\u043b\u0435\u043d";
    }

    @Override
    public String error_al_reemplazar_jar_externo() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043c\u0435\u043d\u0435 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e Jar";
    }

    @Override
    public String error_al_eliminar_elemento_mod() {
        return "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u043c\u043e\u0434\u0430";
    }

    @Override
    public String error_al_eliminar_directorio() {
        return "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430";
    }

    @Override
    public String formato_invalido_para_jar_anidado() {
        return "\u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u043b\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0433\u043e Jar";
    }

    @Override
    public String jar_anidado_eliminado() {
        return "\u0432\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0439 Jar \u0443\u0434\u0430\u043b\u0435\u043d";
    }

    @Override
    public String error_al_limpiar_temporales() {
        return "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0447\u0438\u0441\u0442\u043a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432";
    }

    @Override
    public String mensaje_de_trace_fatal_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0424\u0430\u0442\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 (\u041d\u0435 \u043f\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043d\u043e):</b> ";
    }

    @Override
    public String mensaje_de_trace_ultima_no_traductado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 (\u041d\u0435 \u043f\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043d\u043e):</b> ";
    }

    @Override
    public String solucionParaAdvertenciaFaltasClases() {
        return "\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 WaifuNeoForge, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e \u0438\u0433\u0440\u044b, \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a \u043c\u043e\u0434\u043e\u0432 \u0438 \u043a\u043b\u0430\u0441\u0441. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0443\u044e \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044e. \u041f\u043e\u0438\u0441\u043a \u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043c\u0438\u043d\u0443\u0442\u0443.";
    }

    @Override
    public String solucionFaltasClases() {
        return "\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 WaifuNeoForge, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e \u0438\u0433\u0440\u044b, \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a \u043c\u043e\u0434\u043e\u0432 \u0438 \u043a\u043b\u0430\u0441\u0441. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0443\u044e \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044e. \u041f\u043e\u0438\u0441\u043a \u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043c\u0438\u043d\u0443\u0442\u0443.";
    }

    @Override
    public String solucionParaJavaInstallar() {
        return "\u041e\u0431\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u0438\u043c\u0435\u044e\u0442 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 Java, \u043d\u043e \u043d\u0435 \u0432\u0441\u0435 \u0438\u0437 \u043d\u0438\u0445; \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Java \u0447\u0435\u0440\u0435\u0437 \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u0432 \u0432\u0430\u0448\u0435\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0438\u043b\u0438 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043d\u043e\u043f\u043e\u043a.";
    }

    @Override
    public String error_animacion_no_encontrada() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 \u0431\u0435\u0437 \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0438: </b>";
    }

    @Override
    public String nombre_de_error_animacion_minecraft() {
        return "NoSuchElementException (\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430) \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u044f";
    }

    @Override
    public String no_se_encontraron_mods_para_eliminar() {
        return "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043c\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f";
    }

    @Override
    public String opcionesGCInvalidas() {
        return "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u044e\u0449\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b GC \u043d\u0430 -XX:+UseG1GC";
    }

    @Override
    public String aumentarMemoriaHeap() {
        return "\u0423\u0432\u0435\u043b\u0438\u0447\u044c\u0442\u0435 \u0440\u0430\u0437\u043c\u0435\u0440 \u043a\u0443\u0447\u0438 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043e\u043f\u0446\u0438\u0438 -Xmx.";
    }

    @Override
    public String aumentarMemoriaPermgen() {
        return "\u0423\u0432\u0435\u043b\u0438\u0447\u044c\u0442\u0435 \u0440\u0430\u0437\u043c\u0435\u0440 permgen \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043e\u043f\u0446\u0438\u0438 -XX:MaxPermSize.";
    }

    @Override
    public String utilizarJVM64Bits() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 64-\u0431\u0438\u0442\u043d\u0443\u044e JVM \u0434\u043b\u044f \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438.";
    }

    @Override
    public String optimizarCodigo() {
        return "\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0438\u0440\u0443\u0439\u0442\u0435 \u043a\u043e\u0434, \u0447\u0442\u043e\u0431\u044b \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043c\u044f\u0442\u0438 \u0438 \u043f\u043e\u0432\u044b\u0441\u0438\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c.";
    }

    @Override
    public String utilizarRecolectorBasuraEficiente() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u0441\u0431\u043e\u0440\u0449\u0438\u043a \u043c\u0443\u0441\u043e\u0440\u0430, \u0447\u0442\u043e\u0431\u044b \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c \u043f\u0430\u0443\u0437\u044b \u0432 \u0440\u0430\u0431\u043e\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String modulos() {
        return "\u041c\u043e\u0434\u0443\u043b\u0438";
    }

    @Override
    public String paquete() {
        return "\u041f\u0430\u043a\u0435\u0442";
    }

    @Override
    public String solucionRegistrosMalMapeados() {
        return "\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 ID \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442. \u041e\u0431\u044b\u0447\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b \u2014 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0435 \u043c\u043e\u0434\u043e\u0432 \u0438\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u0445. \u0420\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u043f\u0430\u043f\u043a\u0438 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438: datafiedcontents/ \u0438 kubejs/, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0430\u043f\u043a\u0438 \u043c\u043e\u0434\u043e\u0432.";
    }

    @Override
    public String nombre_de_registros_mal_mapeados() {
        return "\u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0451\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438";
    }

    @Override
    public String mensajeCierreAuthMe() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d 'AuthMe' \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u043b\u0441\u044f \u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b \u0441\u0435\u0440\u0432\u0435\u0440.</b> ";
    }

    @Override
    public String nombreProblemaCierreAuthMe() {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0438\u0437-\u0437\u0430 AuthMe";
    }

    @Override
    public String solucionCierreAuthMe() {
        return "\u041f\u0440\u0430\u0432\u0438\u043b\u043e 'stopServer' \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430 'true'.";
    }

    @Override
    public String solucionConfigurarPluginAuthMe() {
        return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043f\u043b\u0430\u0433\u0438\u043d AuthMe (plugins/AuthMe/config.yml)";
    }

    @Override
    public String solucionInstalarVersionDiferenteAuthMe() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u043f\u043b\u0430\u0433\u0438\u043d\u0430 'AuthMe'";
    }

    @Override
    public String solucionEliminarPluginAuthMe() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u043b\u0430\u0433\u0438\u043d 'AuthMe'";
    }

    @Override
    public String mensajeProblemaCargaMultiverso(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u0438\u0440 '" + nombreMundo + "' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0448\u0438\u0431\u043a\u0438 \u0438, \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e, \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d.</b> ";
    }

    @Override
    public String nombreProblemaCargaMultiverso() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043c\u0438\u0440\u0430 Multiverse";
    }

    @Override
    public String solucionRepararMundo(String nombreMundo) {
        return "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u0438\u0440 '" + nombreMundo + "', \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e Minecraft Region Fixer \u0438\u043b\u0438 MCEdit.";
    }

    @Override
    public String solucionEliminarCarpetaMundo(String nombreMundo) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 \u043c\u0438\u0440\u0430 '" + nombreMundo + "'.";
    }

    @Override
    public String mensajeConfiguracionPermissionsEx() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f 'PermissionsEx' \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0430.</b> ";
    }

    @Override
    public String nombreProblemaConfiguracionPermissionsEx() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 PermissionsEx";
    }

    @Override
    public String solucionConfigurarPermissionsEx() {
        return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043f\u043b\u0430\u0433\u0438\u043d PermissionsEx (plugins/PermissionsEx/permissions.yml)";
    }

    @Override
    public String solucionEliminarPluginPermissionsEx() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u043b\u0430\u0433\u0438\u043d 'PermissionsEx'";
    }

    @Override
    public String mensajeNombrePluginAmbiguo(String nombrePlugin, String primerPath, String segundoPath) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0430\u0439\u043b\u043e\u0432 \u043f\u043b\u0430\u0433\u0438\u043d\u043e\u0432 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + nombrePlugin + "': '" + primerPath + "' \u0438 '" + segundoPath + "'.</b> ";
    }

    @Override
    public String nombreProblemaNombrePluginAmbiguo() {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u043d\u0435\u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u044b\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u043f\u043b\u0430\u0433\u0438\u043d\u0430";
    }

    @Override
    public String solucionEliminarPlugin(String nombrePlugin) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeCargaChunk() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Ocorreu uma exce\u00e7\u00e3o enquanto o mundo carregava os chunks. Se existir para sua plataforma, o FeatureRecycler poder\u00e1 resolver o problema. https://www.curseforge.com/minecraft/mc-mods/feature-recycler</b>";
    }

    @Override
    public String nombreProblemaCargaChunk() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0447\u0430\u043d\u043a\u0430";
    }

    @Override
    public String solucionEliminarChunk() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u0447\u0430\u043d\u043a \u0438\u0437 \u043c\u0438\u0440\u0430, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e MCEdit \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0438\u0432 \u0444\u0430\u0439\u043b \u0440\u0435\u0433\u0438\u043e\u043d\u0430.";
    }

    @Override
    public String mensajeExcepcionComandoPlugin(String nombrePlugin, String comando) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 '/" + comando + "'.</b> ";
    }

    @Override
    public String nombreProblemaExcepcionComandoPlugin() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u043f\u043b\u0430\u0433\u0438\u043d\u0430";
    }

    @Override
    public String solucionInstalarVersionDiferentePlugin(String nombrePlugin) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u043f\u043b\u0430\u0433\u0438\u043d\u0430 '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeDependenciaPluginUnica(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c '" + dependencia + "'.</b> ";
    }

    @Override
    public String mensajeDependenciaPluginMultiples(String nombrePlugin, List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d\u0443 '" + nombrePlugin + "' \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439: " + deps.toString() + ".</b> ";
    }

    @Override
    public String nombreProblemaDependenciaPlugin() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0430\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043b\u0430\u0433\u0438\u043d\u0430";
    }

    @Override
    public String solucionInstalarPlugin(String nombrePlugin) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "'";
    }

    @Override
    public String mensajeVersionAPIIncompatible(String nombrePlugin, String versionAPI) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0432\u0435\u0440\u0441\u0438\u044e API '" + versionAPI + "', \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0441 \u0442\u0435\u043a\u0443\u0449\u0438\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c.</b> ";
    }

    @Override
    public String nombreProblemaVersionAPIIncompatible() {
        return "\u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f API";
    }

    @Override
    public String solucionInstalarVersionServidor(String version) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e '" + version + "' \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u043e\u0433\u043e \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430.";
    }

    @Override
    public String mensajeMundoDuplicado(String nombreMundo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u0438\u0440 '" + nombreMundo + "' \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442\u043e\u043c \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u043c\u0438\u0440\u0430 \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.</b> ";
    }

    @Override
    public String nombreProblemaMundoDuplicado() {
        return "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043c\u0438\u0440";
    }

    @Override
    public String solucionEliminarUID(String nombreMundo) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0444\u0430\u0439\u043b 'uid.dat' \u0438\u0437 \u043c\u0438\u0440\u0430 '" + nombreMundo + "'";
    }

    @Override
    public String solucionEliminarMundo(String nombreMundo) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 \u043c\u0438\u0440\u0430 '" + nombreMundo + "'";
    }

    @Override
    public String mensajeTickingEntidadBloque(String nombre, String tipo, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0411\u043b\u043e\u0447\u043d\u0430\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c '" + nombre + "' \u0442\u0438\u043f\u0430 '" + tipo + "' \u043f\u043e \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430\u043c " + coords + " \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438 \u0442\u0438\u043a\u0430\u0445.</b> ";
    }

    @Override
    public String nombreProblemaTickingEntidadBloque() {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u0430\u044f \u0431\u043b\u043e\u0447\u043d\u0430\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c";
    }

    @Override
    public String solucionEliminarEntidadBloque(String nombre, int[] coordenadas) {
        String coords = "(" + coordenadas[0] + ", " + coordenadas[1] + ", " + coordenadas[2] + ")";
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c '" + nombre + "' \u043f\u043e \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430\u043c " + coords + " \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e MCEdit \u0438\u043b\u0438 \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e \u0432 \u043c\u0438\u0440\u0435.";
    }

    @Override
    public String mensajeModDuplicadoFabric(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439.</b> ";
    }

    @Override
    public String nombreProblemaModDuplicadoFabric() {
        return "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u0434 \u0432 Fabric";
    }

    @Override
    public String solucionEliminarModDuplicado(String rutaMod) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0444\u0430\u0439\u043b\u0430 \u043c\u043e\u0434\u0430: " + rutaMod;
    }

    @Override
    public String mensajeModIncompatible(String primerMod, String segundoMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434\u044b '" + primerMod + "' \u0438 '" + segundoMod + "' \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c.</b> ";
    }

    @Override
    public String nombreProblemaModIncompatibleFabric() {
        return "\u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u043c\u043e\u0434 \u0432 Fabric";
    }

    @Override
    public String solucionEliminarMod(String nombreMod) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043c\u043e\u0434 '" + nombreMod + "'";
    }

    @Override
    public String mensajeModFatal(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u043e\u0448\u0438\u0431\u043a\u0443 \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d.</b> ";
    }

    @Override
    public String nombreProblemaModFatal() {
        return "\u041c\u043e\u0434 \u0441 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u043e\u0439";
    }

    @Override
    public String mensajeModDependenciaPlural(List<String> dependencias) {
        StringBuilder deps = new StringBuilder();
        for (int i = 0; i < dependencias.size(); ++i) {
            if (i > 0) {
                deps.append(", ");
            }
            deps.append("'").append(dependencias.get(i)).append("'");
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b, \u043d\u043e \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b: " + deps.toString() + ".</b>";
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod, String dependencia, String version) {
        if (version == null || version.isEmpty()) {
            return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c '" + dependencia + "'.</b>";
        }
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0432\u0435\u0440\u0441\u0438\u044e '" + dependencia + "' \u0432\u0435\u0440\u0441\u0438\u0438 " + version + ".</b>";
    }

    @Override
    public String nombreProblemaDependenciaMod() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0430\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u043c\u043e\u0434\u0430";
    }

    @Override
    public String solucionInstalarMod(String nombreMod) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434 '" + nombreMod + "'";
    }

    @Override
    public String solucionInstalarModConVersion(String nombreMod, String version) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434 '" + nombreMod + "' \u0432\u0435\u0440\u0441\u0438\u0438 " + version;
    }

    @Override
    public String mensajePluginTickingRegionalSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "' \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0440\u0435\u0433\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u043c \u0442\u0438\u043a\u0438\u043d\u0433\u043e\u043c Folia.</b> ";
    }

    @Override
    public String mensajePluginTickingRegionalPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0441 \u0440\u0435\u0433\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u043c \u0442\u0438\u043a\u0438\u043d\u0433\u043e\u043c Folia: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginTickingRegional() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0440\u0435\u0433\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u043c \u0442\u0438\u043a\u0438\u043d\u0433\u043e\u043c";
    }

    @Override
    public String solucionInstalarSoftwareSinTickingRegional(String software) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e \u0431\u0435\u0437 \u0440\u0435\u0433\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0442\u0438\u043a\u0438\u043d\u0433\u0430, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, " + software;
    }

    @Override
    public String mensajeModFaltanteEnDatapackSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0434\u0430\u0442\u0430\u043f\u0430\u043a\u0435.</b>";
    }

    @Override
    public String mensajeModFaltanteEnDatapackPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0432 \u0434\u0430\u0442\u0430\u043f\u0430\u043a\u0435: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0438 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModFaltanteEnDatapack() {
        return "\u041c\u043e\u0434 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0434\u0430\u0442\u0430\u043f\u0430\u043a\u0435";
    }

    @Override
    public String mensajeModExcepcionSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u0432\u044b\u0437\u0432\u0430\u043b \u043e\u0448\u0438\u0431\u043a\u0443.</b>";
    }

    @Override
    public String mensajeModExcepcionPlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u044b \u0432\u044b\u0437\u0432\u0430\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0438: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0438 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModExcepcion() {
        return "\u041c\u043e\u0434 Forge \u0441 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u043c";
    }

    @Override
    public String solucionInstalarVersionDiferenteMod(String nombreMod) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u043c\u043e\u0434\u0430 '" + nombreMod + "'";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftSingular(String nombreMod, String versionMC) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft " + versionMC + ".</b>";
    }

    @Override
    public String mensajeModIncompatibleConMinecraftPlural(List<String> mods, List<String> versionesMC) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0441 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u043c\u0438 \u0432\u0435\u0440\u0441\u0438\u044f\u043c\u0438 Minecraft: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (Minecraft ").append(versionesMC.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaModIncompatibleConMinecraft() {
        return "\u041c\u043e\u0434 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 Minecraft";
    }

    @Override
    public String solucionInstalarVersionForge(String versionMC) {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e Forge, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 Minecraft " + versionMC;
    }

    @Override
    public String mensajeDependenciaModFaltante(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 '" + nombreMod + "' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442, \u043d\u043e \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043c\u0438\u0440\u0430 \u0438\u043b\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430.</b>";
    }

    @Override
    public String nombreProblemaDependenciaModFaltante() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043c\u043e\u0434";
    }

    @Override
    public String mensajeWorldModFaltanteSingular(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u0438\u0440 \u0431\u044b\u043b \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u043c\u043e\u0434\u0430 '" + nombreMod + "', \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u0435\u0439\u0447\u0430\u0441 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.</b>";
    }

    @Override
    public String mensajeWorldModFaltantePlural(List<String> mods) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u041c\u0438\u0440 \u0431\u044b\u043b \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u043c\u043e\u0434\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0441\u0435\u0439\u0447\u0430\u0441 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0438 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaWorldModFaltante() {
        return "\u041c\u043e\u0434 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043c\u0438\u0440\u0435";
    }

    @Override
    public String mensajeVersionModMundoSingular(String nombreMod, String versionEsperada, String versionActual) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u0438\u0440 \u0431\u044b\u043b \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d \u0441 \u043c\u043e\u0434\u043e\u043c '" + nombreMod + "' \u0432\u0435\u0440\u0441\u0438\u0438 " + versionEsperada + ", \u0430 \u0441\u0435\u0439\u0447\u0430\u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432\u0435\u0440\u0441\u0438\u044f " + versionActual + ".</b>";
    }

    @Override
    public String mensajeVersionModMundoPlural(List<String> mods, List<String> versionesEsperadas, List<String> versionesActuales) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u044b \u0438\u043c\u0435\u044e\u0442 \u043d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439 \u0432 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u043e\u043c \u043c\u0438\u0440\u0435: ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                if (i == mods.size() - 1) {
                    sb.append(" \u0438 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(mods.get(i)).append("'");
            sb.append(" (\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e: ").append(versionesEsperadas.get(i)).append(", \u0422\u0435\u043a\u0443\u0449\u0430\u044f: ").append(versionesActuales.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaVersionModMundo() {
        return "\u041d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439 \u043c\u043e\u0434\u043e\u0432 \u0432 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u043e\u043c \u043c\u0438\u0440\u0435";
    }

    @Override
    public String mensajeVersionDowngrade() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u044b \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u0438\u0440, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u0432 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft.</b>";
    }

    @Override
    public String nombreProblemaVersionDowngrade() {
        return "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043c\u0438\u0440\u0430 \u0438\u0437 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438";
    }

    @Override
    public String solucionVersionDowngrade() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Minecraft.";
    }

    @Override
    public String solucionGenerarNuevoMundo() {
        return "\u0421\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u043d\u043e\u0432\u044b\u0439 \u043c\u0438\u0440.";
    }

    @Override
    public String mensajeDependenciaPluginFaltanteSingular(String nombrePlugin, String dependencia) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0443\u044e \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c: '" + dependencia + "'.</b>";
    }

    @Override
    public String mensajeDependenciaPluginFaltantePlural(List<String> plugins, List<String> dependencias) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u0442\u0440\u0435\u0431\u0443\u044e\u0442 \u043d\u0435\u0437\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'").append(plugins.get(i)).append("' (").append(dependencias.get(i)).append(")");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaDependenciaPluginFaltante() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d \u0441 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c\u044e";
    }

    @Override
    public String mensajePluginIncompatibleSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "' \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.</b>";
    }

    @Override
    public String mensajePluginIncompatiblePlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u0438 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginIncompatible() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 PocketMine-MP";
    }

    @Override
    public String mensajePluginEjecucionSingular(String nombrePlugin) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u043b\u0430\u0433\u0438\u043d '" + nombrePlugin + "' \u0432\u044b\u0437\u0432\u0430\u043b \u043e\u0448\u0438\u0431\u043a\u0443 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.</b>";
    }

    @Override
    public String mensajePluginEjecucionPlural(List<String> plugins) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u0432\u044b\u0437\u0432\u0430\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438: ");
        for (int i = 0; i < plugins.size(); ++i) {
            if (i > 0) {
                if (i == plugins.size() - 1) {
                    sb.append(" \u0438 ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append("'").append(plugins.get(i)).append("'");
        }
        sb.append(".</b>");
        return sb.toString();
    }

    @Override
    public String nombreProblemaPluginEjecucion() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f";
    }

    @Override
    public String nombreLegacyRandomSourceMultiHilos() {
        return "LegacyRandomSource \u041c\u043d\u043e\u0433\u043e\u043f\u043e\u0442\u043e\u0447\u043d\u043e\u0441\u0442\u044c";
    }

    @Override
    public String mensajeLegacyRandomSourceMultiHilos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043c\u043d\u043e\u0433\u043e\u043f\u043e\u0442\u043e\u0447\u043d\u043e\u0435 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u043a\u043b\u0430\u0441\u0441\u0443 LegacyRandomSource. \u0414\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043c\u043e\u0434\u044b 'Unsafe World Random Access Detector' \u0438\u043b\u0438 'C2ME'.</b>";
    }

    @Override
    public String desdeUltimoExito() {
        return "\u0421 \u043c\u043e\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0443\u0441\u043f\u0435\u0445\u0430";
    }

    @Override
    public String noHayCambios() {
        return "\u041d\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439";
    }

    @Override
    public String desdeUltimoIntento() {
        return "\u0421 \u043c\u043e\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043f\u043e\u043f\u044b\u0442\u043a\u0438";
    }

    @Override
    public String fallo() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430";
    }

    @Override
    public String diferentesDeLasMods() {
        return "\u041e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u043c\u043e\u0434\u043e\u0432";
    }

    @Override
    public String historialDeMods() {
        return "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043c\u043e\u0434\u043e\u0432";
    }

    @Override
    public String archivo0() {
        return "\u0424\u0430\u0439\u043b0";
    }

    @Override
    public String archivo1() {
        return "\u0424\u0430\u0439\u043b1";
    }

    @Override
    public String comparar() {
        return "\u0421\u0440\u0430\u0432\u043d\u0438\u0442\u044c";
    }

    @Override
    public String seleccionarDosArchivos() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0432\u0430 \u0444\u0430\u0439\u043b\u0430";
    }

    @Override
    public String archivoExito() {
        return "\u0424\u0430\u0439\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0437\u0430\u043f\u0443\u0441\u043a\u0430";
    }

    @Override
    public String archivoFalla() {
        return "\u0424\u0430\u0439\u043b \u0441\u0431\u043e\u044f";
    }

    @Override
    public String errorComparandoArchivos() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u043e\u0432";
    }

    @Override
    public String comparando() {
        return "\u0421\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u0435\u0442\u0441\u044f";
    }

    @Override
    public String con() {
        return "\u0441";
    }

    @Override
    public String descripcionPanelHistoriaMods() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'><p><b>\u041f\u0430\u043d\u0435\u043b\u044c \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u043c\u043e\u0434\u043e\u0432</b></p><p>\u042d\u0442\u0430 \u043f\u0430\u043d\u0435\u043b\u044c \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0441\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043a\u0438 \u043c\u043e\u0434\u043e\u0432 \u0438\u0437 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0435\u0430\u043d\u0441\u043e\u0432 \u0437\u0430\u043f\u0443\u0441\u043a\u0430. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0444\u0430\u0439\u043b \u0441\u043b\u0435\u0432\u0430 \u0438 \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u043f\u0440\u0430\u0432\u0430, \u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043c\u0435\u0436\u0434\u0443 \u043d\u0438\u043c\u0438.</p><h3>\u041a\u0430\u043a \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c:</h3><ol><li><b>\u0412\u044b\u0431\u043e\u0440 \u0444\u0430\u0439\u043b\u043e\u0432:</b> \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043d\u0430 \u0440\u0430\u0434\u0438\u043e\u043a\u043d\u043e\u043f\u043a\u0438 \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u043c\u0435\u043d\u0430\u043c\u0438 \u0444\u0430\u0439\u043b\u043e\u0432. \u0424\u0430\u0439\u043b\u044b \u0441 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u043c <span style='color: #4CAF50; font-weight: bold;'>.\u0443\u0441\u043f\u0435\u0445</span> \u2014 \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0435 \u0441\u0435\u0430\u043d\u0441\u044b, \u0444\u0430\u0439\u043b\u044b <span style='color: #F44336; font-weight: bold;'>.\u043f\u0440\u043e\u0432\u0430\u043b</span> \u2014 \u0441\u0435\u0430\u043d\u0441\u044b \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438.</li><li><b>\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0435:</b> \u041f\u043e\u0441\u043b\u0435 \u043d\u0430\u0436\u0430\u0442\u0438\u044f '\u0421\u0440\u0430\u0432\u043d\u0438\u0442\u044c' \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043f\u0440\u043e\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0435\u0442 \u043e\u0431\u0430 \u0441\u043f\u0438\u0441\u043a\u0430 \u0438 \u043f\u043e\u043a\u0430\u0436\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 (+) \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0435 (-) \u043c\u043e\u0434\u044b.</li><li><b>\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432:</b> \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 HTML \u0441 \u0446\u0432\u0435\u0442\u043e\u0432\u044b\u043c \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u043c: <ul><li><span style='color: green;'>+ \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u043c\u043e\u0434</span></li><li><span style='color: red;'>- \u0423\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0439 \u043c\u043e\u0434</span></li></ul></li></ol><h3>\u041e\u0441\u043d\u043e\u0432\u043d\u044b\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438:</h3><ul><li>\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043b\u044e\u0431\u0443\u044e \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044e \u0444\u0430\u0439\u043b\u043e\u0432 (\u0443\u0441\u043f\u0435\u0445/\u043f\u0440\u043e\u0432\u0430\u043b).</li><li>\u0414\u0432\u0443\u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0435\u0435 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0442\u043e\u0447\u043d\u043e\u0433\u043e \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439.</li><li>\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0434\u043b\u044f \u0434\u043b\u0438\u043d\u043d\u044b\u0445 \u0441\u043f\u0438\u0441\u043a\u043e\u0432 \u043c\u043e\u0434\u043e\u0432.</li><li>\u0418\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044f \u0441 \u043f\u043e\u044f\u0441\u043d\u044f\u044e\u0449\u0438\u043c\u0438 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u0434\u043b\u044f \u043b\u0443\u0447\u0448\u0435\u0433\u043e \u043f\u043e\u043d\u0438\u043c\u0430\u043d\u0438\u044f.</li></ul><p>\u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0441 <3\ufe0f \u0434\u043b\u044f \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0432 \u0432\u0430\u0448\u0438\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445.</p></body></html>";
    }

    @Override
    public String tieneErrorIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0443 \u0432\u0430\u0441 \u0435\u0441\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 IPv6. \u0415\u0441\u0442\u044c \u0434\u0432\u0430 \u0440\u0435\u0448\u0435\u043d\u0438\u044f: 1) \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 JVM <code>-Djava.net.preferIPv4Stack=true</code> \u0432 \u0441\u0432\u043e\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440, \u0438\u043b\u0438 2) \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 'QuickFix' \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 CrashDetector \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u0430\u0442\u0447\u0430 \u0441 \u044d\u0442\u043e\u0439 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439.</b>";
    }

    @Override
    public String parcheIPv4() {
        return "\u041f\u0430\u0442\u0447 IPv4/6";
    }

    @Override
    public String carpetaHMCL() {
        return "\u041f\u0430\u043f\u043a\u0430 HMCL (\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f HelloMineCraftLauncher)";
    }

    @Override
    public String descripcionCurseforge() {
        return "\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u041b\u043e\u0433 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u0451\u0442\u0441\u044f, \u0435\u0441\u043b\u0438 \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 > Minecraft \u0432\u043a\u043b\u044e\u0447\u0451\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440\"";
    }

    @Override
    public String descripcionPrism() {
        return "Prism/MultiMC/PolyMC/PollyMC/UltimMC/\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u043d\u044b\u0435: \u0429\u0435\u043b\u043a\u043d\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u043e\u0439 \u043a\u043d\u043e\u043f\u043a\u043e\u0439 \u043c\u044b\u0448\u0438 \u043f\u043e \u0438\u043d\u0441\u0442\u0430\u043d\u0441\u0443 \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u043d\u0441\u0442\u0430\u043d\u0441\". \u0412 \u043e\u0442\u043a\u0440\u044b\u0432\u0448\u0435\u043c\u0441\u044f \u043e\u043a\u043d\u0435 \u043d\u0430\u0439\u0434\u0438\u0442\u0435 \u0440\u0430\u0437\u0434\u0435\u043b \"\u041b\u043e\u0433\u0438 Minecraft\" \u0438\u043b\u0438 \u043f\u043e\u0434\u043e\u0431\u043d\u044b\u0439 \u0435\u043c\u0443.<br>\u042d\u0442\u0438 \u043b\u043e\u0433\u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0432\u044b\u0432\u043e\u0434 (STDOUT), \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u0430\u0436\u043d\u044b\u0439 \u0434\u043b\u044f \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438 \u043e\u0448\u0438\u0431\u043e\u043a.";
    }

    @Override
    public String descripcionHMCL() {
        return "HMCL (HelloMinecraftLauncher): \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443, \u0433\u0434\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d HMCL, \u0438 \u0443\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 \".hmcl\". \u041b\u043e\u0433\u0438 HMCL \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u044e\u0442\u0441\u044f \u0437\u0434\u0435\u0441\u044c \u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u0432\u0430\u0436\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0430\u0445.<br>";
    }

    @Override
    public String descripcionFenix() {
        return "LauncherFenix: \u041b\u0430\u0443\u043d\u0447\u0435\u0440 \u0438\u043c\u0435\u0435\u0442 \u0432\u043a\u043b\u0430\u0434\u043a\u0443 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0441 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c\u0438 \u043b\u043e\u0433\u0430\u043c\u0438. \u042d\u0442\u0430 \u0432\u043a\u043b\u0430\u0434\u043a\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043c\u0435\u043d\u044e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430.";
    }

    @Override
    public String descripcionATLauncher() {
        return "ATLauncher: \u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u0441\u043f\u043b\u044b\u0432\u0430\u044e\u0449\u0435\u0435 \u043e\u043a\u043d\u043e \u0441 \u043b\u043e\u0433\u0430\u043c\u0438. \u041e\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043d\u043e\u043f\u043a\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438. \u041b\u043e\u0433\u0438 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u0438\u0433\u0440\u044b \u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043a\u0440\u0438\u0442\u0438\u0447\u043d\u0443\u044e \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e.";
    }

    @Override
    public String descripcionGDLauncher() {
        return "GDLauncher: \u0429\u0435\u043b\u043a\u043d\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u043e\u0439 \u043a\u043d\u043e\u043f\u043a\u043e\u0439 \u043c\u044b\u0448\u0438 \u043f\u043e \u0438\u043d\u0441\u0442\u0430\u043d\u0441\u0443 \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438\". \u0417\u0430\u0442\u0435\u043c \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u0432 \u0440\u0430\u0437\u0434\u0435\u043b \u043b\u043e\u0433\u043e\u0432, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432\u0430\u0436\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u0438\u0437 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0433\u043e \u0432\u044b\u0432\u043e\u0434\u0430 (STDOUT).";
    }

    @Override
    public String descripcionLinksMarkdown() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 Markdown: \u0412\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u043b\u044e\u0431\u0443\u044e \u0441\u0441\u044b\u043b\u043a\u0443, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0443\u044e \u043b\u043e\u0433\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 Markdown. \u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u043f\u043e\u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0438\u0437\u0432\u043b\u0435\u0447\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043b\u043e\u0433\u0438 (latest.log, launcher_log.txt, debug.log \u0438 \u0442. \u0434.) \u0438 \u043f\u0440\u043e\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0445.";
    }

    @Override
    public String noRegistroLauncherTitulo() {
        return "\u0416\u0443\u0440\u043d\u0430\u043b \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
    }

    @Override
    public String imagenNoEncontrada() {
        return "\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e";
    }

    @Override
    public String noRegistroDeLauncher() {
        return "\u041e\u0411\u0429\u0418\u0419: \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u043e\u0433\u043e \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430. \u0416\u0443\u0440\u043d\u0430\u043b\u044b \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 (launcher_log.txt, stdout \u0438 \u0442. \u0434.) \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0430\u0445, \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043d\u0435\u0442 \u0432 latest.log. CrashDetector \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0436\u0443\u0440\u043d\u0430\u043b\u044b \u0432\u0430\u0448\u0435\u0433\u043e \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u2014 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u043d \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u0451\u0442 \u0444\u0430\u0439\u043b \u0436\u0443\u0440\u043d\u0430\u043b\u0430, \u0438 \u0432\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0436\u0443\u0440\u043d\u0430\u043b\u044b \u0432\u0440\u0443\u0447\u043d\u0443\u044e.<br>\u0414\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0441\u043c. <a href=\"https://github.com/HMCL-dev/HMCL/issues/2663 \">\u044d\u0442\u043e\u0442 \u0432\u043e\u043f\u0440\u043e\u0441</a>. \u042d\u0442\u0438 \u0436\u0443\u0440\u043d\u0430\u043b\u044b \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0432\u044b\u0432\u043e\u0434 (STDOUT), \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0439 \u0434\u043b\u044f \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438 \u043c\u043d\u043e\u0433\u0438\u0445 \u0442\u0438\u043f\u043e\u0432 \u043e\u0448\u0438\u0431\u043e\u043a.";
    }

    @Override
    public String faltar_de_clases_create() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438\u0437 Create. Create \u0441\u0438\u043b\u044c\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u2014 \u043c\u043d\u043e\u0433\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0431\u044b\u043b\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u044b. \u041d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 Create 6 (\u0444\u0435\u0432\u0440\u0430\u043b\u044c 2025), \u0430\u0434\u0434\u043e\u043d\u044b \u0434\u043b\u044f \u0441\u0442\u0430\u0440\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 Create \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442. QuickFix \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0440\u0435\u0448\u0438\u0442\u044c \u044d\u0442\u0443 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0430\u0434\u0434\u043e\u043d\u044b Create, \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0435 \u0438\u043b\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Create \u0434\u043b\u044f \u043d\u0443\u0436\u043d\u044b\u0445 \u0430\u0434\u0434\u043e\u043d\u043e\u0432.</b>";
    }

    @Override
    public String faltar_de_clases_epicfight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438\u0437 EpicFight. EpicFight \u0441\u0438\u043b\u044c\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u2014 \u043c\u043d\u043e\u0433\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0431\u044b\u043b\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u044b. QuickFix \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0440\u0435\u0448\u0438\u0442\u044c \u044d\u0442\u0443 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0430\u0434\u0434\u043e\u043d\u044b EpicFight, \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0435 \u0438\u043b\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e EpicFight \u0434\u043b\u044f \u043d\u0443\u0436\u043d\u044b\u0445 \u0430\u0434\u0434\u043e\u043d\u043e\u0432.</b>";
    }

    @Override
    public String openJ9NoSoportado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 OpenJ9, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u044d\u0442\u0438\u043c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c. \u041c\u043d\u043e\u0433\u0438\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f, \u0432\u043a\u043b\u044e\u0447\u0430\u044f \u044d\u0442\u043e, \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442 OpenJ9 \u0438\u0437-\u0437\u0430 \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0439 \u0432 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 JVM. QuickFix \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0440\u0435\u0448\u0438\u0442\u044c \u044d\u0442\u0443 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 JDK, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 Oracle JDK, OpenJDK Hotspot \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u0438\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u044b.</b>";
    }

    @Override
    public String necesitasJDK11() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0414\u043b\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0439 \u0440\u0430\u0431\u043e\u0442\u044b \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f Java 11 (JDK 11). \u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0443\u044e, \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Java. QuickFix \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c Java \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c JDK 11 \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u0443\u044e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0430\u043c, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0432 \u0440\u0435\u0448\u0435\u043d\u0438\u0438.</b>";
    }

    @Override
    public String memoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u044b \u0432\u044b\u0434\u0435\u043b\u0438\u043b\u0438 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043f\u0430\u043c\u044f\u0442\u0438, \u0438\u0437-\u0437\u0430 \u0447\u0435\u0433\u043e \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432. \u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u0435 RAM, \u0447\u0435\u043c \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e, \u0438\u043b\u0438 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 32-\u0431\u0438\u0442\u043d\u043e\u0439 JVM, \u043d\u0435 \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0439 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0438\u0435 \u043e\u0431\u044a\u0451\u043c\u044b \u043f\u0430\u043c\u044f\u0442\u0438.</b>";
    }

    @Override
    public String recomendacionMemoriaExcesiva() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0427\u0442\u043e\u0431\u044b \u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443, \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u0435 \u043e\u0431\u044a\u0451\u043c \u043f\u0430\u043c\u044f\u0442\u0438, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044e. \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u0437\u0430\u0432\u0438\u0441\u0438\u0442 \u043e\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u043d\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 70\u201380% \u043e\u0442 \u043e\u0431\u0449\u0435\u0433\u043e \u043e\u0431\u044a\u0451\u043c\u0430 RAM. \u041f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 32-\u0431\u0438\u0442\u043d\u043e\u0439 JVM \u043b\u0438\u043c\u0438\u0442 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043e\u043a\u043e\u043b\u043e 2\u20133 \u0413\u0411, \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e \u043e\u0442 \u043e\u0431\u044a\u0451\u043c\u0430 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438.</b>";
    }

    @Override
    public String disminuirMemoriaHeap() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0427\u0442\u043e\u0431\u044b \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u043a\u0443\u0447\u0443 (heap), \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u0438 \u043d\u0430\u0439\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0430\u043c\u044f\u0442\u0438. \u0423\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u0435 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (Xmx) \u0434\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e. \u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u043f\u0440\u0438 8 \u0413\u0411 \u041e\u0417\u0423 \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u0435 3\u20134 \u0413\u0411; \u043f\u0440\u0438 16 \u0413\u0411 \u2014 6\u20138 \u0413\u0411. \u041e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0430\u043c\u044f\u0442\u0438 \u0434\u043b\u044f \u041e\u0421 \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c.</b>";
    }

    @Override
    public String forgeArchivosFaltantes(String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0432\u0430\u0436\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b Forge. \u0424\u0430\u0439\u043b '" + archivo + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0432\u0430\u0448\u0435\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435. \u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u0435\u0441\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 Forge \u0431\u044b\u043b\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430 \u0438\u043b\u0438 \u0432\u0430\u0436\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0431\u044b\u043b\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u044b. QuickFix \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u044d\u0442\u0438 \u0444\u0430\u0439\u043b\u044b \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Forge \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0449\u0438\u043a\u0430.</b>";
    }

    @Override
    public String forgeVersionNoEncontrada(String version, String archivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Forge \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043d\u0430\u0439\u0442\u0438 \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Minecraft. \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u0435\u0440\u0441\u0438\u044f " + version + ", \u043d\u043e \u043e\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 '" + archivo + "'. \u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u043f\u0440\u0438 \u043d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft \u0438 \u0432\u0435\u0440\u0441\u0438\u0438 Forge. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u0441\u043a\u0430\u0447\u0430\u043b\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Forge, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft.</b>";
    }

    @Override
    public String forgeTargetFmlclientNoEncontrado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0446\u0435\u043b\u0435\u0432\u043e\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 'fmlclient', \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0439 \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 Forge. \u042d\u0442\u043e \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043d\u0430 \u043d\u0435\u043f\u043e\u043b\u043d\u0443\u044e \u0438\u043b\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0443\u044e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 Forge. \u041a\u043b\u044e\u0447\u0435\u0432\u044b\u0435 \u0444\u0430\u0439\u043b\u044b Forge, \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043d\u0435 \u0431\u044b\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Forge \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0449\u0438\u043a\u0430.</b>";
    }

    @Override
    public String forgeClaseMinecraftFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043a\u043b\u0430\u0441\u0441 Minecraft \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u0435 \u043a\u043b\u0430\u0441\u0441\u043e\u0432. \u042d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442 \u043d\u0435\u043f\u043e\u043b\u043d\u0443\u044e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 Forge \u0438\u043b\u0438 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438. \u0424\u0430\u0439\u043b\u044b Minecraft \u043c\u043e\u0433\u043b\u0438 \u043f\u043e\u0432\u0440\u0435\u0434\u0438\u0442\u044c\u0441\u044f \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 Forge. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Forge.</b>";
    }

    @Override
    public String forgeInstallacionNoCompleta() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 Forge \u043d\u0435\u043f\u043e\u043b\u043d\u0430\u044f. \u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u0437\u0432\u0430\u043d\u043e \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u043d\u043e\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439, \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u043c\u0438 \u0444\u0430\u0439\u043b\u0430\u043c\u0438 \u0438\u043b\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft. Forge \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b, \u0438 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u0437 \u043d\u0438\u0445 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0432 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435.</b>";
    }

    @Override
    public String nombre_de_forge_instalacion_no_completa() {
        return "\u041d\u0435\u043f\u043e\u043b\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 Forge";
    }

    @Override
    public String solucion_para_forge_instalacion_no_completa() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0427\u0442\u043e\u0431\u044b \u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443, \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Forge. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u0441\u043a\u0430\u0447\u0430\u043b\u0438 \u0432\u0435\u0440\u0441\u0438\u044e, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft, \u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0431\u0435\u0437 \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u043e\u0432.</b>";
    }

    @Override
    public String descargar_forge_oficial() {
        return "\u0421\u043a\u0430\u0447\u0430\u0442\u044c Forge \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e";
    }

    @Override
    public String reinstalar_forge_correctamente() {
        return "\u041a\u0430\u043a \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Forge";
    }

    @Override
    public String instrucciones_reinstalar_forge() {
        return "<html><body style='width: 500px;'><h3 style='color:#" + this.config.obtenerColorTitulo() + "'>\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 Forge:</h3><ol><li>\u0421\u043a\u0430\u0447\u0430\u0439\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0449\u0438\u043a Forge \u0441 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430 (\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e Minecraft)</li><li>\u041f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0437\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 Minecraft</li><li>\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0449\u0438\u043a Forge \u043e\u0442 \u0438\u043c\u0435\u043d\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430</li><li>\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e 'Installer' (\u043d\u0435 'Installer (run client)')</li><li>\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 \u043f\u0440\u043e\u0444\u0438\u043b\u044f Minecraft \u0432 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0435</li><li>\u041d\u0430\u0436\u043c\u0438\u0442\u0435 'OK' \u0438 \u0434\u043e\u0436\u0434\u0438\u0442\u0435\u0441\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438</li><li>\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u043f\u043e\u044f\u0432\u0438\u043b\u0441\u044f \u043b\u0438 Forge \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u043f\u0440\u043e\u0444\u0438\u043b\u0435\u0439</li></ol><p><b>\u0412\u0430\u0436\u043d\u043e:</b> \u041f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0433\u043e \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u043f\u0430\u043f\u043a\u0430 \u043f\u0440\u043e\u0444\u0438\u043b\u044f.</p></body></html>";
    }

    @Override
    public String titulo_instrucciones_reinstaler_mcforge() {
        return "\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 Forge";
    }

    @Override
    public String error_enlace_insatisfecho(String nombreBiblioteca) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0435\u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u0451\u043d\u043d\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0438: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0443 " + nombreBiblioteca + ". \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f:<br/><br/>a) \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u0441 \u043e\u0431\u0449\u0435\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u043e\u0439 \u0432 -Djava.library.path \u0438\u043b\u0438 -Dorg.lwjgl.librarypath.<br/>b) \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 JAR-\u0444\u0430\u0439\u043b \u0441 \u043e\u0431\u0449\u0435\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u043e\u0439 \u0432 classpath.<br/><br/>\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 Minecraft \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043d\u0430\u0439\u0442\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b. \u041e\u0431\u044b\u0447\u043d\u043e \u0432\u044b\u0437\u0432\u0430\u043d\u0430 \u043d\u0435\u043f\u043e\u043b\u043d\u043e\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439 Minecraft \u0438\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u043c\u0438 \u0441 \u043f\u0440\u0430\u0432\u0430\u043c\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435.</b>";
    }

    @Override
    public String nombre_de_error_enlace_insatisfecho() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0435\u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u0451\u043d\u043d\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0438";
    }

    @Override
    public String solucion_para_error_enlace_insatisfecho() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0443. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f:<br/><br/>a) \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u0441 \u043e\u0431\u0449\u0435\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u043e\u0439 \u0432 -Djava.library.path \u0438\u043b\u0438 -Dorg.lwjgl.librarypath.<br/>b) \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 JAR-\u0444\u0430\u0439\u043b \u0441 \u043e\u0431\u0449\u0435\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u043e\u0439 \u0432 classpath.<br/><br/>\u042d\u0442\u0438 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0434\u043b\u044f \u043e\u043f\u044b\u0442\u043d\u044b\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439. \u0411\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u043f\u043e\u043f\u0440\u043e\u0431\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Minecraft \u043f\u0435\u0440\u0435\u0434 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435\u043c \u044d\u0442\u0438\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432.</b>";
    }

    @Override
    public String conflicto_id_colision_especifico(String id, String modOrigen, String modDestino) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 ID: ID <strong>" + id + "</strong> \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442 \u043c\u043e\u0434\u043e\u043c <strong>" + modOrigen + "</strong>, \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c <strong>" + modDestino + "</strong>. \u041f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u0434\u0432\u0430 \u043c\u043e\u0434\u0430 \u043f\u044b\u0442\u0430\u044e\u0442\u0441\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438 \u0442\u043e\u0442 \u0436\u0435 ID \u0434\u043b\u044f \u0440\u0430\u0437\u043d\u044b\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.</b>";
    }

    @Override
    public String conflicto_id_maximo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d ID. \u041f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434\u044b \u043f\u044b\u0442\u0430\u044e\u0442\u0441\u044f \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0431\u043b\u043e\u043a\u0438 \u0438\u043b\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0441 ID \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430, \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft.</b>";
    }

    @Override
    public String nombre_de_conflicto_ids() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 ID";
    }

    @Override
    public String solucion_maximo_rango() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0427\u0442\u043e\u0431\u044b \u0440\u0435\u0448\u0438\u0442\u044c \u044d\u0442\u043e \u0432 Minecraft 1.12.2, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 <a href='https://www.curseforge.com/minecraft/mc-mods/justenoughids'>JustEnoughIDs</a>. \u0414\u043b\u044f 1.7.10 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 <a href='https://www.curseforge.com/minecraft/mc-mods/endless-ids'>EndlessIDs</a>.</b>";
    }

    @Override
    public String solucion_colision_id() {
        return "<b style='color:#" + this.config.obtenerColorInfo() + "'>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0442\u0430\u043a\u0438\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u044b, \u043a\u0430\u043a <a href='https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/1291014-idfix-and-idfix-minus-mods-for-resolving-id'>IdFix Minus</a> \u0438\u043b\u0438 <a href='https://github.com/SS111/Minecraft-ID-Resolver'>Minecraft-ID-Resolver</a>, \u0447\u0442\u043e\u0431\u044b \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b ID.</b>";
    }

    @Override
    public String instalar_justenoughids() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c JustEnoughIDs";
    }

    @Override
    public String instalar_endlessids() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c EndlessIDs";
    }

    @Override
    public String usar_idfix_minus() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c IdFix Minus \u0438\u043b\u0438 IdFix";
    }

    @Override
    public String usar_minecraft_id_resolver() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c Minecraft-ID-Resolver";
    }

    @Override
    public String ver_documentacion_jp() {
        return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u044f\u043f\u043e\u043d\u0441\u043a\u0443\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u044e";
    }

    @Override
    public String escanearDeMCreator() {
        return "\u0421\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c MCreator";
    }

    @Override
    public String tituloArbolDeMods() {
        return "\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u0443\u043b\u0435\u0439 \u0438 \u043a\u043b\u0430\u0441\u0441\u043e\u0432";
    }

    @Override
    public String tipoBusqueda() {
        return "\u0422\u0438\u043f";
    }

    @Override
    public String filtroTodos() {
        return "\u0412\u0441\u0435";
    }

    @Override
    public String filtroPaquetes() {
        return "\u041f\u0430\u043a\u0435\u0442\u044b";
    }

    @Override
    public String filtroClases() {
        return "\u041a\u043b\u0430\u0441\u0441\u044b";
    }

    @Override
    public String filtroMetodos() {
        return "\u041c\u0435\u0442\u043e\u0434\u044b";
    }

    @Override
    public String filtroCampos() {
        return "\u041f\u043e\u043b\u044f";
    }

    @Override
    public String filtroReferenciasCampo() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043f\u043e\u043b\u044f";
    }

    @Override
    public String filtroReferenciasMetodo() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043c\u0435\u0442\u043e\u0434\u044b";
    }

    @Override
    public String filtroReferenciasClase() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043a\u043b\u0430\u0441\u0441\u044b";
    }

    @Override
    public String tipBuscar() {
        return "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435 \u043c\u043e\u0434\u043e\u0432";
    }

    @Override
    public String botonBuscar() {
        return "\u041f\u043e\u0438\u0441\u043a";
    }

    @Override
    public String botonResetearArbol() {
        return "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e";
    }

    @Override
    public String modsCargados() {
        return "\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b";
    }

    @Override
    public String clases() {
        return "\u041a\u043b\u0430\u0441\u0441\u044b";
    }

    @Override
    public String metodos() {
        return "\u041c\u0435\u0442\u043e\u0434\u044b";
    }

    @Override
    public String campos() {
        return "\u041f\u043e\u043b\u044f";
    }

    @Override
    public String referencias() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438";
    }

    @Override
    public String resultadosBusqueda() {
        return "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u043e\u0438\u0441\u043a\u0430";
    }

    @Override
    public String buscarReferencias() {
        return "\u041d\u0430\u0439\u0442\u0438 \u0441\u0441\u044b\u043b\u043a\u0438";
    }

    @Override
    public String referenciasMod() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043c\u043e\u0434\u0430";
    }

    @Override
    public String referenciasClase() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043a\u043b\u0430\u0441\u0441\u0430";
    }

    @Override
    public String referenciasMetodo() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043c\u0435\u0442\u043e\u0434\u0430";
    }

    @Override
    public String referenciasCampo() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u043b\u044f";
    }

    @Override
    public String noSeEncontraronReferencias() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
    }

    @Override
    public String detalleMod() {
        return "\u0414\u0435\u0442\u0430\u043b\u0438 \u043c\u043e\u0434\u0430:";
    }

    @Override
    public String ubicacion() {
        return "\u0420\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
    }

    @Override
    public String nombres() {
        return "\u0418\u043c\u0435\u043d\u0430";
    }

    @Override
    public String modulo() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c";
    }

    @Override
    public String detalleClase() {
        return "\u0414\u0435\u0442\u0430\u043b\u0438 \u043a\u043b\u0430\u0441\u0441\u0430:";
    }

    @Override
    public String detalleMetodo() {
        return "\u0414\u0435\u0442\u0430\u043b\u0438 \u043c\u0435\u0442\u043e\u0434\u0430:";
    }

    @Override
    public String detalleCampo() {
        return "\u0414\u0435\u0442\u0430\u043b\u0438 \u043f\u043e\u043b\u044f:";
    }

    @Override
    public String clase() {
        return "\u041a\u043b\u0430\u0441\u0441";
    }

    @Override
    public String tipo() {
        return "\u0422\u0438\u043f";
    }

    @Override
    public String referenciasAMetodos() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043c\u0435\u0442\u043e\u0434\u044b:";
    }

    @Override
    public String referenciasACampos() {
        return "\u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043f\u043e\u043b\u044f:";
    }

    @Override
    public String arbolDeMods() {
        return "\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432";
    }

    @Override
    public String metodo() {
        return "\u041c\u0435\u0442\u043e\u0434";
    }

    @Override
    public String campo() {
        return "\u041f\u043e\u043b\u0435";
    }

    @Override
    public String descompilar() {
        return "\u0414\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c";
    }

    @Override
    public String exportar() {
        return "\u042d\u043a\u0441\u043f\u043e\u0440\u0442";
    }

    @Override
    public String importar() {
        return "\u0418\u043c\u043f\u043e\u0440\u0442";
    }

    @Override
    public String errorImportar() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430";
    }

    @Override
    public String estructuraImportada() {
        return "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0430";
    }

    @Override
    public String estructuraExportada() {
        return "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0430";
    }

    @Override
    public String errorExportar() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430";
    }

    @Override
    public String exportando() {
        return "\u042d\u043a\u0441\u043f\u043e\u0440\u0442";
    }

    @Override
    public String exportacionTardara() {
        return "\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043d\u044f\u0442\u044c \u0432\u0440\u0435\u043c\u044f";
    }

    @Override
    public String porFavorEspere() {
        return "\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435";
    }

    @Override
    public String noTienesVLCBin() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0423 \u0432\u0430\u0441 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b VLC. WaterMedia \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b VLC. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u0445 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0441 \u0441\u0430\u0439\u0442\u0430 https://www.videolan.org/vlc/.  </b>";
    }

    @Override
    public String descargar_vlc() {
        return "\u0421\u043a\u0430\u0447\u0430\u0442\u044c VLC";
    }

    @Override
    public String errorCaracteresInvalidosEnNombre(String nombreModulo, String parteInvalida) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0418\u043c\u044f \u043c\u043e\u0434\u0443\u043b\u044f '" + nombreModulo + "' \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b. \u0427\u0430\u0441\u0442\u044c '" + parteInvalida + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c Java. \u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0441\u043b\u043e\u0432\u0430 Java (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 'true', 'class') \u0438\u043b\u0438 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0432 \u0441\u0432\u043e\u0451\u043c \u0438\u043c\u0435\u043d\u0438.</b>";
    }

    @Override
    public String nombre_de_error_caracteres_invalidos() {
        return "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0432 \u0438\u043c\u0435\u043d\u0438 \u043c\u043e\u0434\u0430";
    }

    @Override
    public String paso1_caracteres_invalidos(String nombreModulo, String parteInvalida) {
        return "\u0418\u043c\u044f \u043c\u043e\u0434\u0430 '" + nombreModulo + "' \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e, \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 '" + parteInvalida + "', \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c \u0441\u043b\u043e\u0432\u043e\u043c Java \u0438\u043b\u0438 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u043c \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u043c. \u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u0432 \u043b\u043e\u0433\u0430\u0445, \u043a\u0430\u043a\u043e\u043c\u0443 \u043c\u043e\u0434\u0443 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u044d\u0442\u043e \u0438\u043c\u044f (\u043e\u0431\u044b\u0447\u043d\u043e \u0438\u043c\u044f JAR-\u0444\u0430\u0439\u043b\u0430)";
    }

    @Override
    public String paso2_caracteres_invalidos(String nombreModulo) {
        return "\u041f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u0432 \u043f\u0430\u043f\u043a\u0443 \u043c\u043e\u0434\u0430 \u0438 \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0444\u0430\u0439\u043b <b>mods.toml</b> \u0432 \u043f\u0430\u043f\u043a\u0435 <b>/META-INF/</b>. \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 <b>modId</b>, \u0447\u0442\u043e\u0431\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b \u0438 \u043f\u043e\u0434\u0447\u0451\u0440\u043a\u0438\u0432\u0430\u043d\u0438\u044f, \u0431\u0435\u0437 \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0441\u043b\u043e\u0432 Java";
    }

    @Override
    public String paso3_caracteres_invalidos() {
        return "\u041f\u0440\u0438\u043c\u0435\u0440 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438: 'truemod_shot_enchantment' \u0432\u043c\u0435\u0441\u0442\u043e 'true.shot.enchantment'. \u041f\u043e\u043c\u043d\u0438\u0442\u0435, \u0447\u0442\u043e \u0438\u043c\u0435\u043d\u0430 \u043c\u043e\u0434\u043e\u0432 \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u0447\u043a\u0438, \u0434\u0435\u0444\u0438\u0441\u044b \u0438\u043b\u0438 \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0441\u043b\u043e\u0432\u0430 Java, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a 'true', 'false' \u0438\u043b\u0438 'class'";
    }

    @Override
    public String errorDependenciaModFaltante(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u043c\u043e\u0434\u043e\u043c: '" + nombreJar + "'. \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 'mandatory' \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044f\u0445. \u041f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u0444\u0430\u0439\u043b mods.toml \u043d\u0435 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442, \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043b\u0438 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.</b>";
    }

    @Override
    public String nombre_de_error_dependencia_mod_faltante() {
        return "\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u043c\u043e\u0434\u0430 \u0431\u0435\u0437 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f";
    }

    @Override
    public String paso1_dependencia_mod_faltante(String nombreJar) {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434: <b>" + nombreJar + "</b>. \u0423 \u044d\u0442\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439";
    }

    @Override
    public String paso2_dependencia_mod_faltante(String nombreJar) {
        return "\u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0444\u0430\u0439\u043b <b>mods.toml</b> \u0432 \u043f\u0430\u043f\u043a\u0435 <b>/META-INF/</b> \u043c\u043e\u0434\u0430 <b>" + nombreJar + "</b>";
    }

    @Override
    public String paso3_dependencia_mod_faltante() {
        return "\u0412 \u0440\u0430\u0437\u0434\u0435\u043b\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043a\u0430\u0436\u0434\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 <b>mandatory=true</b> \u0438\u043b\u0438 <b>mandatory=false</b> (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: modId=\"forge\", mandatory=true, versionRange=\"[1.21.8,)\" )";
    }

    @Override
    public String errorAccessTransformerInvalido(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u043c\u043e\u0434\u043e\u043c: '" + nombreJar + "'. \u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f access transformer. \u041f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441 \u0438\u043b\u0438 \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b/\u043c\u0435\u0442\u043e\u0434\u044b.</b>";
    }

    @Override
    public String nombre_de_error_access_transformer_invalido() {
        return "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 Access Transformer";
    }

    @Override
    public String paso1_access_transformer_invalido(String nombreJar) {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434: <b>" + nombreJar + "</b>. \u042d\u0442\u043e\u0442 \u043c\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0443\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e access transformer";
    }

    @Override
    public String paso2_access_transformer_invalido(String nombreJar) {
        return "\u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0444\u0430\u0439\u043b <b>accessTransformer.cfg</b> \u0432\u043d\u0443\u0442\u0440\u0438 \u043c\u043e\u0434\u0430 <b>" + nombreJar + "</b> (\u043e\u0431\u044b\u0447\u043d\u043e \u0432 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043f\u0430\u043f\u043a\u0435 JAR-\u0444\u0430\u0439\u043b\u0430)";
    }

    @Override
    public String paso3_access_transformer_invalido() {
        return "\u0418\u0441\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441 access transformer. \u0421\u0442\u0440\u043e\u043a\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c \u0444\u043e\u0440\u043c\u0430\u0442\u0443: <b>access class.method</b> (\u043d\u0430\u043f\u0440.: public net.minecraft.world.entity.Entity.func_200560_a). \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0438, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043a\u043b\u0430\u0441\u0441\u044b \u0438\u043b\u0438 \u043c\u0435\u0442\u043e\u0434\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043d\u0435\u0442 \u0432 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft";
    }

    @Override
    public String errorDiscrepanciaModID(String nombreMod) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0420\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 ID \u043c\u043e\u0434\u0430 \u0432 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 @Mod \u0438 \u0444\u0430\u0439\u043b\u043e\u043c mods.toml. \u041c\u043e\u0434 '" + nombreMod + "' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a ID \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442.</b>";
    }

    @Override
    public String nombre_de_error_discrepancia_mod_id() {
        return "\u0420\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 @Mod \u0438 mods.toml";
    }

    @Override
    public String paso1_discrepancia_mod_id(String nombreMod) {
        return "\u041c\u043e\u0434 \u0432 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0435 '" + nombreMod + "' \u0438\u043c\u0435\u0435\u0442 \u0440\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 ID \u0432 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 <b>@Mod</b> \u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u0432 <b>mods.toml</b>";
    }

    @Override
    public String paso2_discrepancia_mod_id() {
        return "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e ID \u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u043c \u043a\u043b\u0430\u0441\u0441\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c <b>modId</b> \u0432 \u0444\u0430\u0439\u043b\u0435 <b>/META-INF/mods.toml</b>. \u041f\u0440\u0438\u043c\u0435\u0440: <b>@Mod(\"mymod\")</b> \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c \u0441 <b>modId=\"mymod\"</b>";
    }

    @Override
    public String paso3_discrepancia_mod_id() {
        return "\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 Gradle, \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u0435 <b>clean</b> \u043f\u043e\u0441\u043b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439, \u0447\u0442\u043e\u0431\u044b \u0433\u0430\u0440\u0430\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432. \u0418\u043d\u043e\u0433\u0434\u0430 \u0441\u0442\u0430\u0440\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u043e\u0441\u0442\u0430\u044e\u0442\u0441\u044f \u0432 \u043f\u0430\u043f\u043a\u0435 build";
    }

    @Override
    public String errorModEnPlataformaIncorrecta(String nombreClase, String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u043a\u043b\u0438\u0435\u043d\u0442" : "\u0441\u0435\u0440\u0432\u0435\u0440";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u0441\u0435\u0440\u0432\u0435\u0440" : "\u043a\u043b\u0438\u0435\u043d\u0442";
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043b\u0430\u0441\u0441 '" + nombreClase + "' \u0432 \u0441\u0440\u0435\u0434\u0435 " + plataforma + ", \u043d\u043e \u043e\u043d \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f " + plataformaOpuesta + ". <b>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e \u00ab\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432\u00bb \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438, \u043a\u0430\u043a\u043e\u0439 \u043c\u043e\u0434 \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043a\u043b\u0430\u0441\u0441</b>. \u041c\u043e\u0434\u044b \u0441\u043e\u0437\u0434\u0430\u044e\u0442\u0441\u044f \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b \u0438 \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439.</b>";
    }

    @Override
    public String nombre_de_error_mod_plataforma_incorrecta() {
        return "\u041c\u043e\u0434 \u043d\u0430 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0435";
    }

    @Override
    public String paso1_mod_plataforma_incorrecta(String nombreClase, String entornoInvalido) {
        return "\u041d\u0430 \u0432\u043a\u043b\u0430\u0434\u043a\u0435 <b>\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b> (\u0441\u043f\u0440\u0430\u0432\u0430) \u043d\u0430\u0439\u0434\u0438\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043a\u043b\u0430\u0441\u0441 <b>" + nombreClase + "</b>, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u043a\u0430\u043a\u043e\u0439 \u043c\u043e\u0434 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443";
    }

    @Override
    public String paso2_mod_plataforma_incorrecta(String entornoInvalido) {
        String plataforma = entornoInvalido.equals("CLIENT") ? "\u043a\u043b\u0438\u0435\u043d\u0442" : "\u0441\u0435\u0440\u0432\u0435\u0440";
        String plataformaOpuesta = entornoInvalido.equals("CLIENT") ? "\u0441\u0435\u0440\u0432\u0435\u0440" : "\u043a\u043b\u0438\u0435\u043d\u0442";
        return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0439 \u043c\u043e\u0434 \u2014 \u044d\u0442\u043e \u043c\u043e\u0434 \u0434\u043b\u044f <b>" + plataformaOpuesta + "</b>, \u0438 \u0435\u0433\u043e \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0432\u0430\u0448\u0435\u0439 \u0441\u0440\u0435\u0434\u0435 " + plataforma + ".";
    }

    @Override
    public String paso3_mod_plataforma_incorrecta() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434 \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 <b>mods</b>. \u0415\u0441\u043b\u0438 \u0432\u0430\u043c \u043d\u0443\u0436\u043d\u0430 \u0430\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u0430\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b, \u043d\u0430\u0439\u0434\u0438\u0442\u0435 \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u044b\u0439 \u043c\u043e\u0434, \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u044b\u0439 \u0434\u043b\u044f <b>\u043a\u043b\u0438\u0435\u043d\u0442\u0430</b> \u0438\u043b\u0438 <b>\u0441\u0435\u0440\u0432\u0435\u0440\u0430</b> \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e";
    }

    @Override
    public String errorMetadataModsTomlFaltante(String modIdFaltante, List<String> modsPotenciales) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f modid '").append(modIdFaltante).append("'. ");
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            mensaje.append("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b: <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                mensaje.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                mensaje.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u0437\u0430\u0432\u0438\u0441\u0438\u0442 \u043e\u0442 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u043c\u043e\u0434\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0438\u043b\u0438 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u0430\u0439\u043b mods.toml.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_metadata_mods_toml_faltante() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 mods.toml";
    }

    @Override
    public String paso1_metadata_mods_toml_faltante(String modIdFaltante, List<String> modsPotenciales) {
        if (modsPotenciales != null && !modsPotenciales.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u043e\u0434\u044b \u0437\u0430\u0432\u0438\u0441\u044f\u0442 \u043e\u0442 '").append(modIdFaltante).append("': <b>");
            for (int i = 0; i < Math.min(modsPotenciales.size(), 3); ++i) {
                paso.append(modsPotenciales.get(i));
                if (i >= modsPotenciales.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsPotenciales.size() > 3) {
                paso.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            paso.append("</b>. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e <b>\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b>, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c, \u043a\u0430\u043a\u043e\u0439 \u043c\u043e\u0434 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443");
            return paso.toString();
        }
        return "\u041e\u0434\u0438\u043d \u0438\u0437 \u043c\u043e\u0434\u043e\u0432 \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0432\u0438\u0441\u0435\u0442\u044c \u043e\u0442 '" + modIdFaltante + "', \u043d\u043e \u044d\u0442\u043e\u0442 \u043c\u043e\u0434 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e <b>\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b>, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434";
    }

    @Override
    public String paso2_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u0423 \u0432\u0430\u0441 \u0434\u0432\u0430 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u0430:<br/>1. <b>\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u044e\u0449\u0438\u0439 \u043c\u043e\u0434</b>: \u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434 \u0441 ID '" + modIdFaltante + "'<br/>2. <b>\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u043c\u043e\u0434</b>: \u0415\u0441\u043b\u0438 \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043c\u043e\u0434, \u0437\u0430\u0432\u0438\u0441\u044f\u0449\u0438\u0439 \u043e\u0442 '" + modIdFaltante + "'";
    }

    @Override
    public String paso3_metadata_mods_toml_faltante(String modIdFaltante) {
        return "\u0415\u0441\u043b\u0438 \u043c\u043e\u0434 '" + modIdFaltante + "' \u2014 \u044d\u0442\u043e \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 'forge', 'minecraft', 'curios'), \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0443 \u0432\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f Minecraft \u0438 Forge. \u0415\u0441\u043b\u0438 \u044d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u043c\u043e\u0434, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0435\u0433\u043e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0445 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439";
    }

    @Override
    public String errorSistemaSonido() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b. \u0417\u0432\u0443\u043a\u0438 \u0438 \u043c\u0443\u0437\u044b\u043a\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u044b. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0441\u0432\u044f\u0437\u0430\u043d\u0430 \u0441 \u043c\u043e\u0434\u043e\u043c SoundPhysicsMod \u0438 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u0437\u0432\u0430\u043d\u0430 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0430\u043c\u0438 \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u0437\u0432\u0443\u043a\u043e\u0432\u044b\u043c\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430\u043c\u0438.</b>";
    }

    @Override
    public String nombre_de_error_sistema_sonido() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0432\u0443\u043a\u043e\u0432\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b";
    }

    @Override
    public String paso1_sistema_sonido() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0441\u0432\u044f\u0437\u0430\u043d\u0430 \u0441 <b>SoundPhysicsMod</b>. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043b\u0438 \u0443 \u0432\u0430\u0441 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0432\u0435\u0440\u0441\u0438\u044f, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430\u044f \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft";
    }

    @Override
    public String paso2_sistema_sonido() {
        return "\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u0437\u0432\u0443\u043a\u043e\u0432\u044b\u0435 \u043c\u043e\u0434\u044b (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Sound Filters, Dynamic Surroundings \u0438 \u0442. \u0434.), \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c SoundPhysicsMod, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c, \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442 \u043b\u0438 \u044d\u0442\u043e \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442";
    }

    @Override
    public String paso3_sistema_sonido() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 <b>logs</b> \u043d\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0441 LWJGL \u0438\u043b\u0438 OpenAL, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0433\u0443\u0442 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0431\u0430\u0437\u043e\u0432\u044b\u043c\u0438 \u0437\u0432\u0443\u043a\u043e\u0432\u044b\u043c\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430\u043c\u0438";
    }

    @Override
    public String errorSinListenersEnClase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041a\u043b\u0430\u0441\u0441 '").append(nombreClase).append("' \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0439, \u043d\u043e \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u043c\u0435\u0442\u043e\u0434\u043e\u0432. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u042d\u0442\u043e\u0442 \u043a\u043b\u0430\u0441\u0441 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u043c\u043e\u0434\u0430\u0445: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u042d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u043a\u043b\u0430\u0441\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043b\u0443\u0448\u0438\u0432\u0430\u043d\u0438\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u0439, \u043d\u043e \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043c\u0435\u0442\u043e\u0434\u043e\u0432 \u0441 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0435\u0439 @SubscribeEvent.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_sin_listeners_en_clase() {
        return "\u041a\u043b\u0430\u0441\u0441 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0431\u0435\u0437 \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0435\u0439 \u0441\u043e\u0431\u044b\u0442\u0438\u0439";
    }

    @Override
    public String paso1_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u044d\u0442\u0438\u0445 \u043c\u043e\u0434\u0430\u0445: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            paso.append("</b>. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043f\u044b\u0442\u0430\u044e\u0442\u0441\u044f \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0431\u0435\u0437 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u043c\u0435\u0442\u043e\u0434\u043e\u0432");
            return paso.toString();
        }
        return "\u041a\u043b\u0430\u0441\u0441 <b>" + nombreClase + "</b> \u0431\u044b\u043b \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043b\u0443\u0448\u0438\u0432\u0430\u043d\u0438\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u0439, \u043d\u043e \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043c\u0435\u0442\u043e\u0434\u043e\u0432 \u0441 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0435\u0439 <b>@SubscribeEvent</b>. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e <b>\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b>, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u043a\u0430\u043a\u043e\u0439 \u043c\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u0442\u043e\u0442 \u043a\u043b\u0430\u0441\u0441";
    }

    @Override
    public String paso2_sin_listeners_en_clase(String nombreClase) {
        return "\u0412 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c \u043a\u043e\u0434\u0435 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043a\u043b\u0430\u0441\u0441 <b>" + nombreClase + "</b> \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u0438\u043d \u043c\u0435\u0442\u043e\u0434 \u0441: <b>@SubscribeEvent public void \u0438\u043c\u044f\u041c\u0435\u0442\u043e\u0434\u0430(\u0421\u043e\u0431\u044b\u0442\u0438\u0435\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e\u0422\u0438\u043f\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u0435) { ... }</b>. \u0415\u0441\u043b\u0438 \u044d\u0442\u043e \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u043a\u043b\u0430\u0441\u0441, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043e\u043d \u043d\u0435 \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u043a\u0430\u043a static";
    }

    @Override
    public String paso3_sin_listeners_en_clase(String nombreClase, List<String> modsUbicacion) {
        StringBuilder paso = new StringBuilder();
        if (!modsUbicacion.isEmpty()) {
            paso.append("\u0414\u043b\u044f \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043c\u043e\u0434\u043e\u0432 (<b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 2); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 1) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 2) {
                paso.append(", \u0438 \u0442. \u0434.");
            }
            paso.append("</b>): ");
            if (modsUbicacion.size() == 1) {
                paso.append("\u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u043c \u044d\u0442\u043e\u0433\u043e \u043c\u043e\u0434\u0430, \u0447\u0442\u043e\u0431\u044b \u043e\u043d \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u043b \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443. ");
            } else {
                paso.append("\u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c\u0438 \u044d\u0442\u0438\u0445 \u043c\u043e\u0434\u043e\u0432, \u0447\u0442\u043e\u0431\u044b \u043e\u043d\u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443. ");
            }
        }
        paso.append("\u0415\u0441\u043b\u0438 \u0432\u044b \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e \u044d\u0442\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0430 \u0432 EventBus \u0438\u043b\u0438 \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u043c\u0435\u0442\u043e\u0434\u044b @SubscribeEvent");
        return paso.toString();
    }

    @Override
    public String errorUnionFileSystemCorrupto(String nombreArchivo) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 'cpw.mods.niofs.union.UnionFileSystem$UncheckedIOException' \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 '" + nombreArchivo + "'. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043d\u0430 \u0442\u043e, \u0447\u0442\u043e \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u043d\u0435 \u0441\u043c\u043e\u0433 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0438\u043b\u0438 \u0440\u0430\u0441\u043f\u0430\u043a\u043e\u0432\u0430\u0442\u044c \u0444\u0430\u0439\u043b\u044b \u043c\u043e\u0434\u043f\u0430\u043a\u0430. \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 'zip END header not found' \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442, \u0447\u0442\u043e JAR-\u0444\u0430\u0439\u043b \u043d\u0435\u043f\u043e\u043b\u043d\u044b\u0439 \u0438\u043b\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d, \u0447\u0442\u043e \u043a\u0440\u0430\u0439\u043d\u0435 \u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0443 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432, \u043f\u043b\u043e\u0445\u043e \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u0445 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u043e\u0439 \u0431\u043e\u043b\u044c\u0448\u0438\u0445 \u0444\u0430\u0439\u043b\u043e\u0432. \u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u043c \u0437\u0430\u0442\u0440\u0430\u0433\u0438\u0432\u0430\u0435\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 Twitch/CurseForge, Technic Launcher \u0438 \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e Luna Pixel, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u044d\u0442\u0438 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u044b \u0447\u0430\u0441\u0442\u043e \u043d\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u044e\u0442 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432. \u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c Luna Pixel \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u043d\u0430 ATLauncher \u2014 \u0431\u043e\u043b\u0435\u0435 \u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u0443\u044e \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u0443, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043b\u0443\u0447\u0448\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u0432 \u0438 \u0438\u0437\u0431\u0435\u0433\u0430\u0435\u0442 \u044d\u0442\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u0438. \u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u043e\u0434\u044b, \u0442\u0430\u043a \u043a\u0430\u043a \u0444\u043e\u0440\u043c\u0430\u0442 ZIP \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d, \u0447\u0442\u043e \u043c\u0435\u0448\u0430\u0435\u0442 Forge \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombre_de_error_union_filesystem_corrupto() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 UnionFileSystem \u2014 \u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b";
    }

    @Override
    public String paso1_union_filesystem_corrupto(String nombreArchivo) {
        return "\u041f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434\u043f\u0430\u043a \u0441 \u043d\u0443\u043b\u044f";
    }

    @Override
    public String paso2_union_filesystem_corrupto() {
        return "\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 Luna Pixel, \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043d\u0430 ATLauncher";
    }

    @Override
    public String paso3_union_filesystem_corrupto() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443 \u0438 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u043d\u0430 \u0434\u0438\u0441\u043a\u0435 \u043f\u0435\u0440\u0435\u0434 \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439";
    }

    @Override
    public String habilitarProxySysOutSysErrMensaje() {
        return "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c ProxySysOutSysErr?\n\n\u042d\u0442\u0430 \u043e\u043f\u0446\u0438\u044f \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 CrashDetector \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a System.out \u0438 System.err, \u043a\u043e\u0433\u0434\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u043d\u0435 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043b\u043e\u0433\u0438.\n\n\u0421\u043b\u0435\u0434\u0443\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043b\u043e\u0433.\n\n\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u044d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043e\u0432\u0430\u0442\u044c \u0441 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438 \u0438\u043b\u0438 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430\u043c\u0438.\n\n\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b/\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439.";
    }

    @Override
    public String confirmacionTitulo() {
        return "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435";
    }

    @Override
    public String proxyHabilitadoMensaje() {
        return "ProxySysOutSysErr \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0451\u043d.\n\n\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a CrashDetector \u0434\u043b\u044f \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439.";
    }

    @Override
    public String informacionTitulo() {
        return "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f";
    }

    @Override
    public String errorAzureGeckoLibInicializoPronto(boolean azureLibError, boolean geckoLibError, boolean connectorPresente) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        if (azureLibError && geckoLibError) {
            mensaje.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: AzureLib \u0438 GeckoLib \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0440\u0430\u043d\u043e! ");
        } else if (azureLibError) {
            mensaje.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: AzureLib \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0440\u0430\u043d\u043e! ");
        } else if (geckoLibError) {
            mensaje.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: GeckoLib \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0440\u0430\u043d\u043e! ");
        }
        mensaje.append("\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0434\u044b Fabric \u0441 \u043d\u0435-Fabric-\u0432\u0435\u0440\u0441\u0438\u044f\u043c\u0438 \u044d\u0442\u0438\u0445 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a. ");
        if (connectorPresente) {
            mensaje.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043c\u043e\u0434 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 (Sinytra Connector \u0438\u043b\u0438 specialcompatibilityoperation), \u0447\u0442\u043e \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043d\u0430 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043c\u043e\u0434\u043e\u0432 Fabric \u0432 \u0441\u0440\u0435\u0434\u0435 Forge \u0438\u043b\u0438 FeatureCreep. ");
            mensaje.append("\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043e\u0448\u0438\u0431\u043a\u0443 '\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 FabricMC' \u0432 \u043b\u043e\u0433\u0430\u0445, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434. ");
        }
        mensaje.append("AzureLib \u0438 GeckoLib \u2014 \u043a\u043b\u044e\u0447\u0435\u0432\u044b\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u0434\u043b\u044f \u043c\u043e\u0434\u043e\u0432 \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0438, \u043d\u043e \u043e\u043d\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0435 (Fabric \u0438\u043b\u0438 Forge). ");
        mensaje.append("\u0418\u0433\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u043e\u0434\u044b \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0438 \u0438\u0437-\u0437\u0430 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_azure_geckolib_inicializo_pronto() {
        return "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0440\u0430\u043d\u043e";
    }

    @Override
    public String paso1_azure_geckolib_inicializo_pronto() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043e\u0448\u0438\u0431\u043a\u0443 '\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 FabricMC' \u0432 \u043b\u043e\u0433\u0430\u0445, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434";
    }

    @Override
    public String paso2_azure_geckolib_inicializo_pronto() {
        return "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e AzureLib/GeckoLib \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b (Forge \u0438\u043b\u0438 Fabric)";
    }

    @Override
    public String errorCompatibilidadC2ME() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c \u043c\u0435\u0436\u0434\u0443 C2ME \u0438 \u043c\u043e\u0434\u0430\u043c\u0438 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e C2ME \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u043c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c Java, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u044b \u0432 \u0441\u0440\u0435\u0434\u0430\u0445 \u0441 Sinytra Connector \u0438\u043b\u0438 specialcompatibilityoperation, \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 Fabric/Forge. <b>C2ME \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0442\u0430\u043a\u0438\u043c\u0438 \u0441\u0440\u0435\u0434\u0430\u043c\u0438, \u043d\u043e <a href='https://www.curseforge.com/minecraft/mc-mods/c3me'>C3ME</a> \u2014 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u0430\u044f \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u0430</b>, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0441 \u043c\u043e\u0434\u0430\u043c\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f. \u0418\u0433\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u0441\u044f \u0438\u0437-\u0437\u0430 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0430 \u043f\u0440\u0430\u0432 \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 Java.</b>";
    }

    @Override
    public String nombre_de_error_compatibilidad_c2me() {
        return "\u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c C2ME \u0441 \u043c\u043e\u0434\u0430\u043c\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f";
    }

    @Override
    public String paso1_compatibilidad_c2me() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 C2ME \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 mods";
    }

    @Override
    public String paso2_compatibilidad_c2me() {
        return "\u0421\u043a\u0430\u0447\u0430\u0439\u0442\u0435 \u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 <a href='https://www.mcmod.cn/class/15818.html'>C3ME</a> \u0432\u043c\u0435\u0441\u0442\u043e \u043d\u0435\u0433\u043e (\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e \u0441 Sinytra Connector)";
    }

    @Override
    public String paso3_compatibilidad_c2me() {
        return "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u0441\u0435 \u043c\u043e\u0434\u044b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Sinytra Connector) \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438";
    }

    @Override
    public String errorJEIPluginFallido(String nombreClase, String modId, String pluginId) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u043b\u0430\u0433\u0438\u043d JEI \u0434\u043b\u044f \u043c\u043e\u0434\u0430 '" + modId + "'. \u041a\u043b\u0430\u0441\u0441 '" + nombreClase + "' (ID \u043f\u043b\u0430\u0433\u0438\u043d\u0430: '" + pluginId + "') \u0432\u044b\u0437\u0432\u0430\u043b \u043e\u0448\u0438\u0431\u043a\u0443, \u0438\u0437-\u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0438\u0433\u0440\u0430 \u0430\u0432\u0430\u0440\u0438\u0439\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435. \u042d\u0442\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0438\u043b\u0438 \u0441\u043b\u043e\u043c\u0430\u043d\u043d\u0443\u044e \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044e \u0441 JEI, \u043c\u0435\u0448\u0430\u044e\u0449\u0443\u044e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombre_de_error_jei_plugin_fallido() {
        return "\u0421\u0431\u043e\u0439 \u043f\u043b\u0430\u0433\u0438\u043d\u0430 JEI \u2014 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043a\u0440\u0430\u0445";
    }

    @Override
    public String paso1_jei_plugin_fallido(String modId) {
        return "\u041c\u043e\u0434 <b>" + modId + "</b> \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0433\u0438\u043d JEI, \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0449\u0438\u0439 \u043a\u0440\u0430\u0445. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e <b>\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b>, \u0447\u0442\u043e\u0431\u044b \u0442\u043e\u0447\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u043a\u0430\u043a\u043e\u0439 \u043c\u043e\u0434 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443";
    }

    @Override
    public String paso2_jei_plugin_fallido(String modId) {
        return "\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043c\u043e\u0434 <b>" + modId + "</b> \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 mods, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c, \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442 \u043b\u0438 \u044d\u0442\u043e \u043a\u0440\u0430\u0445";
    }

    @Override
    public String paso3_jei_plugin_fallido(String modId) {
        return "\u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043c\u043e\u0434\u0430 <b>" + modId + "</b> \u0438\u043b\u0438 \u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u0435\u0433\u043e \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u043c, \u0441\u043e\u043e\u0431\u0449\u0438\u0432 \u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0435 \u0441 \u043f\u043b\u0430\u0433\u0438\u043d\u043e\u043c JEI. \u041f\u043e\u043a\u0430 \u0447\u0442\u043e \u043c\u043e\u0434 \u043d\u0443\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0447\u0442\u043e\u0431\u044b \u0438\u0433\u0440\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u043b\u0430\u0441\u044c";
    }

    @Override
    public String tituloLectador() {
        return "\u0427\u0438\u0442\u0430\u0442\u0435\u043b\u044c \u043b\u043e\u0433\u043e\u0432 - \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0438\u0435 \u0441\u0431\u043e\u0435\u0432";
    }

    @Override
    public String obtenerTituloLeyenda() {
        return "\u0426\u0412\u0415\u0422\u041e\u0412\u0410\u042f \u041b\u0415\u0413\u0415\u041d\u0414\u0410";
    }

    @Override
    public String obtenerErrorEnLeyenda() {
        return "\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438";
    }

    @Override
    public String obtenerStacktraceEnLeyenda() {
        return "\u0421\u0442\u0435\u043a\u0442\u0440\u0435\u0439\u0441\u044b";
    }

    @Override
    public String obtenerTituloError() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430";
    }

    @Override
    public String obtenerErrorAlProcesarLinea() {
        return "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438";
    }

    @Override
    public String obtenerNombreError() {
        return "\u041d\u0410\u0417\u0412\u0410\u041d\u0418\u0415 \u041e\u0428\u0418\u0411\u041a\u0418";
    }

    @Override
    public String obtenerDescripcionError() {
        return "\u041f\u041e\u0414\u0420\u041e\u0411\u041d\u041e\u0415 \u041e\u041f\u0418\u0421\u0410\u041d\u0418\u0415";
    }

    @Override
    public String obtenerSeleccionarConsola() {
        return "\u0412\u042b\u0411\u0415\u0420\u0418\u0422\u0415 \u041b\u041e\u0413";
    }

    @Override
    public String obtenerNombreErrorPorDefecto() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430";
    }

    @Override
    public String obtenerDescripcionErrorPorDefecto() {
        return "\u0412 \u043b\u043e\u0433\u0430\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u0442\u0435\u043a\u0442\u0440\u0435\u0439\u0441, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0432\u043e\u043f\u0440\u0438\u0447\u0438\u043d\u0443.";
    }

    @Override
    public String obtenerErrorLecturaArchivo() {
        return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043b\u043e\u0433\u0430. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0444\u0430\u0439\u043b \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String obtenerEtiquetaBotonLectador() {
        return "\u0410\u043d\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u043b\u043e\u0433\u043e\u0432";
    }

    @Override
    public String errorRegistroSuscriptoresAutomaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        StringBuilder mensaje = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        mensaje.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0430 '").append(modId).append("'. ");
        mensaje.append("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441: <b>").append(nombreClase).append("</b>. ");
        if (!modsUbicacion.isEmpty()) {
            mensaje.append("\u042d\u0442\u043e\u0442 \u043a\u043b\u0430\u0441\u0441 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                mensaje.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                mensaje.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                mensaje.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0445...");
            }
            mensaje.append("</b>. ");
        }
        mensaje.append("\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441 \u043a\u0430\u043a \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u0439, \u043d\u043e \u043a\u043b\u0430\u0441\u0441 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d. ");
        mensaje.append("<b>\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043b\u043e\u0433\u0435 \u2014 \u0440\u0435\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439 \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e\u0439 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435</b>.");
        mensaje.append("</b>");
        return mensaje.toString();
    }

    @Override
    public String nombre_de_error_registro_suscriptores_automaticos() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u043e\u0432";
    }

    @Override
    public String paso1_registro_suscriptores_automaticos(String modId, String nombreClase) {
        return "\u041c\u043e\u0434 <b>" + modId + "</b> \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441 <b>" + nombreClase + "</b> \u043a\u0430\u043a \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430, \u043d\u043e \u044d\u0442\u043e \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043a\u043b\u0430\u0441\u0441 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
    }

    @Override
    public String paso2_registro_suscriptores_automaticos(String modId, String nombreClase, List<String> modsUbicacion) {
        if (!modsUbicacion.isEmpty()) {
            StringBuilder paso = new StringBuilder("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 <b>" + nombreClase + "</b> \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u044d\u0442\u0438\u0445 \u0444\u0430\u0439\u043b\u0430\u0445: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                paso.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                paso.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                paso.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0445...");
            }
            paso.append("</b>. ");
            paso.append("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e <b>\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b>, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u0432 \u043a\u0430\u043a\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441");
            return paso.toString();
        }
        return "\u041a\u043b\u0430\u0441\u0441 <b>" + nombreClase + "</b> \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u0438 \u0432 \u043e\u0434\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043c\u043e\u0434\u0430. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043c\u043e\u0434 <b>" + modId + "</b> \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e <b>\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b> \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b";
    }

    @Override
    public String paso3_registro_suscriptores_automaticos(String modId) {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434 <b>" + modId + "</b> \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft \u0438 Forge. \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u043e\u0441\u0442\u0430\u043d\u0435\u0442\u0441\u044f, \u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u043c \u043c\u043e\u0434\u0430 \u0438 \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435\u043c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0430";
    }

    @Override
    public String paso4_registro_suscriptores_automaticos() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 <b>\u0434\u0440\u0443\u0433\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043b\u043e\u0433\u0435</b> \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435\u043c \u2014 \u0440\u0435\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0441\u0431\u043e\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438. \u0418\u043d\u043e\u0433\u0434\u0430 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043c\u0435\u0448\u0430\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u0434\u043b\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439";
    }

    @Override
    public String limpiado() {
        return "\u041e\u0447\u0438\u0449\u0435\u043d\u043e";
    }

    @Override
    public String original() {
        return "\u041e\u0440\u0438\u0433\u0438\u043d\u0430\u043b";
    }

    @Override
    public String verEnConsola() {
        return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432 \u043b\u043e\u0433\u0435";
    }

    @Override
    public String advertencia() {
        return "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435";
    }

    @Override
    public String fatal() {
        return "\u0424\u0430\u0442\u0430\u043b\u044c\u043d\u043e";
    }

    @Override
    public String noRegistroDeBattly() {
        return "\u0423 BattlyLauncher \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e \u043b\u043e\u0433\u0430 \u0438\u043b\u0438 \u043a\u043e\u043d\u0441\u043e\u043b\u0438 \u0434\u043b\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c ProxySysOutSysErr, \u0447\u0442\u043e\u0431\u044b \u043f\u0435\u0440\u0435\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0442\u044c STDOUT \u0438 STDERR, \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0432 \u0438\u0433\u0440\u0443, \u043d\u043e ProxySysOutSysErr \u043c\u043e\u0436\u0435\u0442 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043e\u0432\u0430\u0442\u044c \u0441 \u043c\u043e\u0434\u0430\u043c\u0438, \u0438\u0437\u043c\u0435\u043d\u044f\u044e\u0449\u0438\u043c\u0438 STDOUT \u0438\u043b\u0438 STDERR";
    }

    @Override
    public String noRegistroDeNightWorld() {
        return "\u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043b\u0430\u0434\u043a\u0438 \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 NightWorld, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043b\u043e\u0433 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430. \u042d\u0442\u043e \u043e\u0447\u0435\u043d\u044c \u0432\u0430\u0436\u043d\u043e, \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u043e\u043d \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u0442 STDOUT \u0438 STDERR";
    }

    @Override
    public String noRegistroDeMCServidor() {
        return "\u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u043b\u0438 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430 \u0432\u0430\u0448\u0435\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e, \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432 \u0434\u0440\u0443\u0433\u0438\u0445 \u043b\u043e\u0433\u0430\u0445, \u0432\u043a\u043b\u044e\u0447\u0430\u044f STDOUT, STDERR \u0438 \u0434\u0440\u0443\u0433\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0441\u0435\u0441\u0441\u0438\u0438. \u0412 \u0431\u0443\u0434\u0443\u0449\u0435\u043c \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0432\u044b\u0432\u043e\u0434 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430 \u0432 \u0444\u0430\u0439\u043b \u043f\u043e\u0434 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c cd_launcherlog. \u0427\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0435\u0436\u0430\u0442\u044c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0438, \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 >> cd_launcherlog \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430, \u043a\u0430\u043a \u043f\u043e\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435 \u0432\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u044d\u0442\u043e \u043f\u0440\u0435\u0434\u043e\u0442\u0432\u0440\u0430\u0442\u0438\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0435; \u0432\u0441\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0442\u044c\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u044d\u0442\u043e\u0442 \u0444\u0430\u0439\u043b.";
    }

    @Override
    public String errorLexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#" + this.config.obtenerColorError() + "'>");
        sb.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0435\u0440 LexForge \u0432 \u0441\u0440\u0435\u0434\u0435 NeoForge. ");
        sb.append("</b>");
        sb.append("\u0417\u0430\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441: <b>").append(claseReceptora).append("</b>. ");
        sb.append("\u0417\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u044b\u0439 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u2014 <b>").append(interfazObjetivo).append("</b>, ");
        sb.append("\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043c\u0435\u0442\u043e\u0434 \u2014 <b>").append(firmaMetodoFaltante).append("</b>. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u041a\u043b\u0430\u0441\u0441 \u043d\u0430\u0439\u0434\u0435\u043d \u0432: <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("JAR-\u0444\u0430\u0439\u043b\u044b \u0441 \u044d\u0442\u0438\u043c \u043a\u043b\u0430\u0441\u0441\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b; \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u043d \u0437\u0430\u0442\u0435\u043d\u0451\u043d \u0438\u043b\u0438 \u0432\u0441\u0442\u0440\u043e\u0435\u043d \u043a\u0430\u043a jar-in-jar. ");
        }
        sb.append("\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0435\u0440/\u0441\u0435\u0440\u0432\u0438\u0441 ModLauncher, \u0441\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043b\u044f MinecraftForge/LexForge, ");
        sb.append("\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442\u0441\u044f \u0432 NeoForge \u0441 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 API ModLauncher. ");
        sb.append("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u043d\u0430 \u0432\u0435\u0440\u0441\u0438\u044e \u0434\u043b\u044f NeoForge.");
        return sb.toString();
    }

    @Override
    public String nombre_de_LexForgeMLTransformerEnNeoForge() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0435\u0440\u0430 LexForge \u0432 NeoForge";
    }

    @Override
    public String paso1_LexForgeMLTransformerEnNeoForge(String claseReceptora, String interfazObjetivo, String firmaMetodoFaltante) {
        return "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u0435 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0435\u0440: <b>" + claseReceptora + "</b>. \u041e\u0436\u0438\u0434\u0430\u0435\u043c\u043e\u0435 API \u2014 <b>" + interfazObjetivo + "</b>, \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 <b>" + firmaMetodoFaltante + "</b>. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0435\u0442 \u043b\u0438 \u043c\u043e\u0434 \u044d\u0442\u043e\u0442 \u043a\u043b\u0430\u0441\u0441 \u0432 <b>META-INF/services</b>, \u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0438\u043b\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0435\u0433\u043e \u0432 NeoForge.";
    }

    @Override
    public String paso2_LexForgeMLTransformerEnNeoForge(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder();
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u0420\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0430(\u043e\u0432): <b>");
            for (int i = 0; i < Math.min(modsUbicacion.size(), 3); ++i) {
                sb.append(modsUbicacion.get(i));
                if (i >= modsUbicacion.size() - 1 || i >= 2) continue;
                sb.append(", ");
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            sb.append("</b>. ");
        } else {
            sb.append("JAR-\u0444\u0430\u0439\u043b\u044b \u0441 \u044d\u0442\u0438\u043c \u043a\u043b\u0430\u0441\u0441\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 jar-in-jar \u0438 \u0437\u0430\u0442\u0435\u043d\u0451\u043d\u043d\u044b\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438. ");
        }
        sb.append("\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u044d\u0442\u0438 JAR-\u0444\u0430\u0439\u043b\u044b \u0438\u043b\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u0438, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0435 \u0441 NeoForge, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a.");
        return sb.toString();
    }

    @Override
    public String paso3_LexForgeMLTransformerEnNeoForge() {
        return "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u043d\u0430 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0434\u043b\u044f NeoForge \u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0439\u0442\u0435 \u0435\u0433\u043e \u043f\u043e\u0434 \u0432\u0435\u0440\u0441\u0438\u044e ModLauncher, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u0443\u044e NeoForge. \u0418\u0437\u0431\u0435\u0433\u0430\u0439\u0442\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0431\u0438\u043d\u0430\u0440\u043d\u0438\u043a\u043e\u0432 \u043e\u0442 LexForge/MinecraftForge.";
    }

    @Override
    public String paso4_LexForgeMLTransformerEnNeoForge() {
        return "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 mods \u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 jar-in-jar-\u0444\u0430\u0439\u043b\u044b. \u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u0435 \u043a\u044d\u0448 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0443\u0431\u0435\u0434\u0438\u0442\u044c\u0441\u044f, \u0447\u0442\u043e \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0435\u0440\u044b LexForge \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u044e\u0442\u0441\u044f.";
    }

    @Override
    public String errorWaterMediaXenonIncompatible(String modNombre, String modId, List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("WaterMedia \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u0441\u044f: Xenon ");
        sb.append("(").append(modId).append(") ");
        if (modNombre != null && !modNombre.isEmpty()) {
            sb.append("[").append(modNombre).append("] ");
        }
        sb.append("\u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c.</b> ");
        sb.append("\u0423\u0434\u0430\u043b\u0438\u0442\u0435 Xenon \u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0432\u043c\u0435\u0441\u0442\u043e \u043d\u0435\u0433\u043e Embeddium \u0438\u043b\u0438 Sodium. ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0432: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            sb.append("</b>.");
        }
        return sb.toString();
    }

    @Override
    public String nombreDeWaterMediaXenonIncompatible() {
        return "WaterMedia \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 Xenon";
    }

    @Override
    public String paso1WaterMediaXenonIncompatible(String modNombre, String modId) {
        String label = "Xenon (" + modId + ")";
        if (modNombre != null && !modNombre.isEmpty()) {
            label = label + " [" + modNombre + "]";
        }
        return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d " + label + ", \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u0441 WaterMedia. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0435\u0433\u043e \u0438\u0437 \u043f\u0440\u043e\u0444\u0438\u043b\u044f.";
    }

    @Override
    public String paso2WaterMediaXenonIncompatible(List<String> modsUbicacion) {
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder("\u041c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435...");
            }
            sb.append("</b>. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u044d\u0442\u043e\u0442 JAR-\u0444\u0430\u0439\u043b.");
            return sb.toString();
        }
        return "JAR-\u0444\u0430\u0439\u043b\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 mods \u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 Xenon.";
    }

    @Override
    public String paso3WaterMediaXenonIncompatible() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Embeddium \u0438\u043b\u0438 Sodium \u043a\u0430\u043a \u0437\u0430\u043c\u0435\u043d\u0443 \u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0438\u0433\u0440\u0443.";
    }

    @Override
    public String nombreDeTaczDeflaterCerrado() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0436\u0430\u0442\u0438\u044f (TACZ)";
    }

    @Override
    public String errorTaczDeflaterCerrado(List<String> modsUbicacion) {
        StringBuilder sb = new StringBuilder("<b>Deflater \u0437\u0430\u043a\u0440\u044b\u0442 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 TACZ.</b> ");
        if (modsUbicacion != null && !modsUbicacion.isEmpty()) {
            sb.append("\u0421\u0432\u044f\u0437\u0430\u043d\u043e \u0441: <b>");
            for (int i = 0; i < Math.min(3, modsUbicacion.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(modsUbicacion.get(i));
            }
            if (modsUbicacion.size() > 3) {
                sb.append(", \u0438 \u0434\u0440\u0443\u0433\u0438\u0435");
            }
            sb.append("</b>. ");
        }
        sb.append("<br/><b>\u0420\u0435\u0448\u0435\u043d\u0438\u0435:</b> \u0432 \u0444\u0430\u0439\u043b\u0435 <code>tacz/tacz-pre.toml</code> \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 <code>DefaultPackDebug=true</code>. ").append("\u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u043a\u0430\u0440\u0442\u0443, \u0437\u0430\u0442\u0435\u043c \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0439\u0442\u0435 \u0435\u0451.");
        return sb.toString();
    }

    @Override
    public String pasoTaczDeflaterCerrado() {
        return "\u0412 \u0444\u0430\u0439\u043b\u0435 tacz/tacz-pre.toml \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 DefaultPackDebug=true. \u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u043a\u0430\u0440\u0442\u0443, \u0437\u0430\u0442\u0435\u043c \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0439\u0442\u0435 \u0435\u0451.";
    }

    @Override
    public String nombreDeFuncionesDeDensidadNoVinculadas() {
        return "\u041d\u0435\u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043f\u043b\u043e\u0442\u043d\u043e\u0441\u0442\u0438";
    }

    @Override
    public String errorFuncionesDeDensidadNoVinculadas(List<String> claves) {
        StringBuilder sb = new StringBuilder("<b>\u0412 \u0440\u0435\u0435\u0441\u0442\u0440\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043f\u043b\u043e\u0442\u043d\u043e\u0441\u0442\u0438.</b> ");
        if (claves != null && !claves.isEmpty()) {
            sb.append("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442: ");
            for (int i = 0; i < Math.min(4, claves.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<code>").append(claves.get(i)).append("</code>");
            }
            if (claves.size() > 4) {
                sb.append(", \u2026");
            }
            sb.append(". ");
        }
        sb.append("<br/><b>\u0420\u0435\u0448\u0435\u043d\u0438\u0435:</b> \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0439\u0442\u0435 \u043c\u043e\u0434/datapack, \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u044e\u0449\u0438\u0439 \u044d\u0442\u0438 \u0444\u0443\u043d\u043a\u0446\u0438\u0438, \u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435. \u0414\u0440\u0443\u0433\u0430\u044f \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0451\u043d\u043d\u0430\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u044d\u0442\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u2014 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0433\u043e \u043c\u043e\u0434\u0430, \u043d\u043e \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439 \u0438\u043b\u0438 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043e\u043c \u0441 \u0434\u0440\u0443\u0433\u0438\u043c \u043c\u043e\u0434\u043e\u043c; \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Terralith \u0447\u0430\u0441\u0442\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0438 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u044d\u0442\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u0435 \u0438 \u0434\u0440\u0443\u0433\u0438\u043c, \u0432\u043a\u043b\u044e\u0447\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0438 JSON.");
        return sb.toString();
    }

    @Override
    public String pasoFuncionesDeDensidadNoVinculadas() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043c\u043e\u0434/\u0434\u0430\u0442\u0430\u043f\u0430\u043a, \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u0439 \u044d\u0442\u0438 \u0444\u0443\u043d\u043a\u0446\u0438\u0438, \u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0438\u0433\u0440\u0443.";
    }

    @Override
    public String errorRailwaysCreate6Alfa(String claveFaltante) {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u0417\u0430\u043f\u0438\u0441\u044c \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442: ").append(claveFaltante).append(". ");
        sb.append("\u0427\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0432 \u0430\u043b\u044c\u0444\u0430-\u0432\u0435\u0440\u0441\u0438\u0438 Steam & Railways \u0434\u043b\u044f Create 6.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeRailwaysCreate6Alfa() {
        return "Create 6: Steam & Railways (\u0430\u043b\u044c\u0444\u0430)";
    }

    @Override
    public String pasoRailwaysCreate6Alfa() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0438\u043b\u0438 \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u0435 \u0430\u043b\u044c\u0444\u0430-\u0432\u0435\u0440\u0441\u0438\u044e Steam & Railways \u0434\u043b\u044f Create 6 \u043d\u0430 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e.";
    }

    @Override
    public String errorConflictoMultiworldRendimiento() {
        StringBuilder sb = new StringBuilder("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: Multiworld \u0432\u043c\u0435\u0441\u0442\u0435 \u0441 Sodium/Embeddium/Rubidium \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 ").append("IncompatibleClassChangeError (FabricLoader.getInstance). ").append("\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u044f: \u0443\u0434\u0430\u043b\u0438\u0442\u0435 Multiworld \u0438\u043b\u0438 \u043c\u043e\u0434 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043b\u0438\u0431\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0435 \u0432\u0435\u0440\u0441\u0438\u0438.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombreDeConflictoMultiworldRendimiento() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442: Multiworld \u0441 \u043c\u043e\u0434\u0430\u043c\u0438 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438";
    }

    @Override
    public String pasoConflictoMultiworldRendimiento() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 Multiworld \u0438\u043b\u0438 Sodium/Embeddium/Rubidium, \u043b\u0438\u0431\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435\u0441\u044c \u0434\u043e \u0432\u0437\u0430\u0438\u043c\u043d\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439.";
    }

    @Override
    public String problema_con_graficas_sodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Sodium \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0440\u0430\u0439\u0432\u0435\u0440. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440 \u0432\u0430\u0448\u0435\u0439 \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u044b \u0434\u043e \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u043b\u0438 \u0441\u043b\u0435\u0434\u0443\u0439\u0442\u0435 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u0443 \u043f\u043e Sodium.</b>";
    }

    @Override
    public String nombreErrorContextoOpenGL() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 OpenGL";
    }

    @Override
    public String errorContextoOpenGL() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0421\u0431\u043e\u0439 OpenGL: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0438\u043b\u0438 \u0444\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0432 \u044d\u0442\u043e\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435. \u0422\u0430\u043a\u0436\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430\u043c\u0438 \u0432\u0438\u0434\u0435\u043e\u043a\u0430\u0440\u0442\u044b.</b>";
    }

    @Override
    public String paso1ErrorContextoOpenGL() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435/\u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b GPU \u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435\u0441\u044c; \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043e\u0432\u0435\u0440\u043b\u0435\u0438 \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0431\u0435\u0437 \u043c\u043e\u0434\u043e\u0432 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.";
    }

    @Override
    public String copiadoAlPortapapeles() {
        return "\u0421\u0441\u044b\u043b\u043a\u0430 \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430.";
    }

    @Override
    public String buscarDentroDeComprimidos() {
        return "\u0418\u0441\u043a\u0430\u0442\u044c \u0432\u043d\u0443\u0442\u0440\u0438 \u0430\u0440\u0445\u0438\u0432\u043e\u0432 (.zip/.jar/.war/.ear/.fpm/.rar \u0434\u043b\u044f Java*)";
    }

    @Override
    public String error_resolucion_textura(String recurso, String tama\u00f1o) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c " + recurso + " \u2014 \u0440\u0430\u0437\u043c\u0435\u0440: " + tama\u00f1o + "</b>";
    }

    @Override
    public String nombre_de_error_resolucion_textura() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b";
    }

    @Override
    public String solucion_resolucion_textura() {
        return "\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u0438\u0435 \u0438\u043b\u0438 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0440\u0435\u0441\u0443\u0440\u0441-\u043f\u0430\u043a\u043e\u0432. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441-\u043f\u0430\u043a\u0438 \u0441 \u0431\u043e\u043b\u0435\u0435 \u043d\u0438\u0437\u043a\u0438\u043c \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435\u043c \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u0437 \u043d\u0438\u0445. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u0438\u043b\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b \u0441 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435\u043c \u0432\u044b\u0448\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0433\u043e.";
    }

    @Override
    public String error_modlauncher_path() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043b\u0443\u0436\u0431\u044b ModLauncher: \u043f\u0443\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b. \u0421\u043b\u0443\u0436\u0431\u044b ModLauncher \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u043f\u0443\u0442\u0438, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0435 \u043d\u0435-ASCII \u0438\u043b\u0438 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b. \u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0432\u043a\u043b\u044e\u0447\u0430\u044e\u0442: \u00a1, !, \u0645\u0631\u062d\u0628\u0627, Ol\u00e1, \u0633\u0644\u0627\u0645, \u041f\u0440\u0438\u0432\u0435\u0442, \u4f60\u597d, Saluton, \u3053\u3093\u306b\u3061\u306f, \uc548\ub155\ud558\uc138\uc694, \u0438 \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0441\u0438\u043c\u0432\u043e\u043b '\"', \u0435\u0441\u043b\u0438 \u043e\u043d \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043a\u043e\u043d\u0446\u0435 \u0438\u043c\u0435\u043d\u0438. \u0420\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u0441\u043b\u0443\u0436\u0431 \u0432 ModLauncher \u0432\u043a\u043b\u044e\u0447\u0430\u044e\u0442 CrashDetector, " + Config.obtenerInstancia().obtenerNombreCD() + ", FeatureCreep, Vivicraft, Optifine, Sodium, clonos, Iris Shaders/Oculus, MixerLogger, CrashAssistant \u0438 Sintrya Connector. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0441\u043b\u0443\u0436\u0431\u044b, \u043d\u043e \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u043c\u043e\u0433\u0443\u0442 \u0432\u043e\u0437\u043d\u0438\u043a\u043d\u0443\u0442\u044c \u0438\u0437-\u0437\u0430 \u0438\u043c\u0435\u043d\u0438 \u043f\u0443\u0442\u0438. \u0420\u0435\u0448\u0435\u043d\u0438\u0435: \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u0443\u0439\u0442\u0435 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u0442\u043e\u043b\u044c\u043a\u043e ASCII-\u0441\u0438\u043c\u0432\u043e\u043b\u044b (a-z, A-Z, 0-9), \u0431\u0435\u0437 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432 \u0438 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.</b>";
    }

    @Override
    public String nombre_error_modlauncher_path() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0443\u0442\u0438 \u0432 ModLauncher";
    }

    @Override
    public String solucion_modlauncher_path() {
        return "\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u043f\u0443\u0442\u044c \u043a \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u0443 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435-ASCII \u0438\u043b\u0438 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b. \u0421\u043b\u0443\u0436\u0431\u044b ModLauncher \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0442\u0430\u043a\u0438\u0435 \u043f\u0443\u0442\u0438. \u0420\u0435\u0448\u0435\u043d\u0438\u0435: \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u0443\u0439\u0442\u0435 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u0442\u043e\u043b\u044c\u043a\u043e ASCII-\u0441\u0438\u043c\u0432\u043e\u043b\u044b (a-z, A-Z, 0-9), \u0438\u0437\u0431\u0435\u0433\u0430\u0439\u0442\u0435 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432 \u0438 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432. \u041e\u0441\u043e\u0431\u043e\u0435 \u0432\u043d\u0438\u043c\u0430\u043d\u0438\u0435 \u0443\u0434\u0435\u043b\u0438\u0442\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u0443 '\"', \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u0435\u0440\u044c\u0451\u0437\u043d\u044b\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b, \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0432 \u043a\u043e\u043d\u0446\u0435 \u0438\u043c\u0435\u043d\u0438.";
    }

    @Override
    public String tituloEditorCodice() {
        return "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 Codice";
    }

    @Override
    public String nuevo() {
        return "\u041d\u043e\u0432\u044b\u0439";
    }

    @Override
    public String actualizarSeleccionado() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0435";
    }

    @Override
    public String eliminarSeleccionado() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0435";
    }

    @Override
    public String exportarJSON() {
        return "\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c JSON...";
    }

    @Override
    public String guardarTodo() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u0441\u0451";
    }

    @Override
    public String general() {
        return "\u041e\u0431\u0449\u0435\u0435";
    }

    @Override
    public String id() {
        return "ID";
    }

    @Override
    public String paraBuscar() {
        return "\u0422\u0435\u043a\u0441\u0442 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430";
    }

    @Override
    public String filtro() {
        return "\u0424\u0438\u043b\u044c\u0442\u0440 (id)";
    }

    @Override
    public String criticalidad() {
        return "\u041a\u0440\u0438\u0442\u0438\u0447\u043d\u043e\u0441\u0442\u044c (\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415/\u041e\u0428\u0418\u0411\u041a\u0410/\u0424\u0410\u0422\u0410\u041b\u042c\u041d\u041e)";
    }

    @Override
    public String prioridad() {
        return "\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442";
    }

    @Override
    public String lista() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438";
    }

    @Override
    public String colIdioma() {
        return "\u042f\u0437\u044b\u043a";
    }

    @Override
    public String colNombre() {
        return "\u0418\u043c\u044f";
    }

    @Override
    public String colResultado() {
        return "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442";
    }

    @Override
    public String vistaJson() {
        return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 JSON";
    }

    @Override
    public String idiomas() {
        return "\u042f\u0437\u044b\u043a\u0438 (\u0432\u0441\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b)";
    }

    @Override
    public String elegirFiltro() {
        return "\u0412\u044b\u0431\u0440\u0430\u0442\u044c...";
    }

    @Override
    public String eligeFiltroMsg() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0438\u043b\u044c\u0442\u0440";
    }

    @Override
    public String eligeFiltroTitulo() {
        return "\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0444\u0438\u043b\u044c\u0442\u0440\u044b";
    }

    @Override
    public String faltanCampos() {
        return "\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0432\u0441\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043e\u0431\u0449\u0438\u0435 \u043f\u043e\u043b\u044f.";
    }

    @Override
    public String critInvalida() {
        return "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u043a\u0440\u0438\u0442\u0438\u0447\u043d\u043e\u0441\u0442\u044c. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415, \u041e\u0428\u0418\u0411\u041a\u0410 \u0438\u043b\u0438 \u0424\u0410\u0422\u0410\u041b\u042c\u041d\u041e.";
    }

    @Override
    public String filtroNoExiste() {
        return "\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0444\u0438\u043b\u044c\u0442\u0440 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.";
    }

    @Override
    public String faltanIdiomas() {
        return "\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0438\u043c\u044f \u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u044f\u0437\u044b\u043a\u043e\u0432:";
    }

    @Override
    public String verificacionInvalida() {
        return "\u041e\u0434\u043d\u0430 \u0438\u0437 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0430. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u043e\u043b\u044f.";
    }

    @Override
    public String guardadoOk() {
        return "\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e.";
    }

    @Override
    public String editorCodiceBoton() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u044b";
    }

    @Override
    public String descripcionEditorCodice() {
        return "\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u044b. \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f ID \u2014 \u0441\u0442\u0440\u043e\u043a\u0430 \u0431\u0435\u0437 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432, \u0430\u043a\u0446\u0435\u043d\u0442\u043e\u0432 \u0438 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432. \u0414\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b: \"\u0441\u0442\u0440\u043e\u043a\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\" \u2014 \u043f\u043e\u0438\u0441\u043a \u0441\u0442\u0440\u043e\u043a\u0438 \u0432 \u043e\u0434\u043d\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0435 \u043b\u043e\u0433\u0430, \"\u0432\u0441\u0451 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\" \u2014 \u0435\u0441\u043b\u0438 \u043b\u043e\u0433 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u0442\u0440\u043e\u043a\u0443, \"\u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435\" \u2014 \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 \u0441 \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c, \"\u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u043e \u0432\u0441\u0451\u043c\" (\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0441\u0442\u0440\u043e\u0447\u043d\u044b\u0435 \u0432\u0435\u0440\u0441\u0438\u0438). \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u043a\u0440\u0438\u0442\u0438\u0447\u043d\u043e\u0441\u0442\u0438: FATAL, ERROR \u0438\u043b\u0438 ADVERTENCIA \u2014 \u0434\u043b\u044f \u0440\u0430\u0441\u043a\u0440\u0430\u0441\u043a\u0438. \u0414\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u044f\u0437\u044b\u043a\u0430 \u043d\u0443\u0436\u043d\u043e \u0432\u0432\u0435\u0441\u0442\u0438 \u0438\u043c\u044f \u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435. \u041c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u044f\u0442\u044c \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435. \u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String descartarCambios() {
        return "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435?";
    }

    @Override
    public String confirmacion() {
        return "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435";
    }

    @Override
    public String guardarAntesDeSalir() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0434 \u0432\u044b\u0445\u043e\u0434\u043e\u043c?";
    }

    @Override
    public String salirSinGuardar() {
        return "\u0412\u044b\u0439\u0442\u0438 \u0431\u0435\u0437 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f";
    }

    @Override
    public String errorConfiguracionServicio(String clase, List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorError()).append("'>");
        sb.append("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 modlauncher (IDependencyLocator).<br>");
        sb.append("\ud83d\udd39 <b>\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441:</b> <code>").append(clase).append("</code><br>");
        if (mods != null && !mods.isEmpty()) {
            sb.append("\ud83d\udd38 <b>\u0417\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u044b\u0439 \u043c\u043e\u0434:</b> ").append(String.join((CharSequence)", ", mods)).append("<br>");
        } else {
            sb.append("\ud83d\udd38 <b>\u041c\u043e\u0434 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d.</b> \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0435\u0434\u0430\u0432\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435, \u0440\u0430\u0437\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u043c\u044b\u0435 \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043f\u0430\u043a\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b.<br>");
        }
        sb.append("\ud83d\udd38 <b>\u041f\u0440\u0438\u0447\u0438\u043d\u0430:</b> \u0424\u0430\u0439\u043b <code>META-INF/services/...</code> \u043c\u043e\u0434\u0430 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d, ");
        sb.append("\u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Forge/NeoForge \u0438\u043b\u0438 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438.<br>");
        sb.append("\ud83d\udd38 <b>\u041f\u043e\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0435:</b> Forge/NeoForge \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043c\u043e\u0434\u0430, ");
        sb.append("\u0447\u0442\u043e \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b.<br>");
        sb.append("\ud83d\udd38 <b>\u0420\u0435\u0448\u0435\u043d\u0438\u0435:</b> \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435, \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434. ");
        sb.append("\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043c\u043e\u0434\u044b \u0432 \u0441\u0442\u0430\u0434\u0438\u0438 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0438, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043e\u043d\u0438 \u0441\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u043f\u043e\u0434 \u0442\u043e\u0447\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0432\u0430\u0448\u0435\u0433\u043e Forge/NeoForge.");
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String nombre_error_configuracion_servicio() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u043b\u0443\u0436\u0431\u044b (IDependencyLocator)";
    }

    @Override
    public String paso1_configuracion_servicio(List<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return "1. \u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u0435 \u0432\u0438\u043d\u043e\u0432\u043d\u044b\u0439 \u043c\u043e\u0434: \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0435\u0434\u0430\u0432\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0438\u043b\u0438 \u0440\u0430\u0437\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b.";
        }
        return "1. \u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434: " + String.join((CharSequence)", ", mods);
    }

    @Override
    public String paso2_configuracion_servicio() {
        return "2. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435, \u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043c\u043e\u0434. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432\u0435\u0440\u0441\u0438\u044f, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430\u044f \u0441 \u0432\u0430\u0448\u0438\u043c Forge/NeoForge.";
    }

    @Override
    public String errorMetodoInexistente(String metodo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041c\u0435\u0442\u043e\u0434 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.</b><br>\u041c\u043e\u0434 \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u043c\u0435\u0442\u043e\u0434 <b style='color:#" + colorCodigo + "'>" + metodo + "</b>, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u0433\u0440\u044b \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u043c\u043e\u0434\u0430.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_metodo_inexistente() {
        return "\u041c\u0435\u0442\u043e\u0434 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 (NoSuchMethodError)";
    }

    @Override
    public String paso1_metodo_inexistente() {
        return "1. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u0438\u0433\u0440\u044b \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u0438\u043c \u043c\u043e\u0434\u043e\u043c.";
    }

    @Override
    public String paso2_metodo_inexistente() {
        return "2. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0441\u0435 \u0437\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u044b\u0435 \u043c\u043e\u0434\u044b. \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 \u0430\u0432\u0442\u043e\u0440\u0443 \u0437\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u043e\u0433\u043e \u043c\u043e\u0434\u0430.";
    }

    @Override
    public String errorCampoInexistente(String campo, String lineaCompleta) {
        String colorError = this.config.obtenerColorError();
        String colorCodigo = "888888";
        return "<b style='color:#" + colorError + "'>\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u041f\u043e\u043b\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.</b><br>\u041c\u043e\u0434 \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u043e\u043b\u044e <b style='color:#" + colorCodigo + "'>" + campo + "</b>, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u0433\u0440\u044b \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u043c\u043e\u0434\u0430.<br><span style='color:#" + colorCodigo + "; font-family:monospace;'>" + this.escapeHtml(lineaCompleta) + "</span>";
    }

    @Override
    public String nombre_error_campo_inexistente() {
        return "\u041f\u043e\u043b\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 (NoSuchFieldError)";
    }

    @Override
    public String paso1_campo_inexistente() {
        return "1. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u0438\u0433\u0440\u044b \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u0438\u043c \u043c\u043e\u0434\u043e\u043c.";
    }

    @Override
    public String paso2_campo_inexistente() {
        return "2. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0441\u0435 \u0437\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u044b\u0435 \u043c\u043e\u0434\u044b. \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, \u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u0430\u0432\u0442\u043e\u0440\u043e\u043c \u043c\u043e\u0434\u0430, \u0432\u044b\u0437\u0432\u0430\u0432\u0448\u0435\u0433\u043e \u043e\u0448\u0438\u0431\u043a\u0443.";
    }

    @Override
    public String mensajeAyudar() {
        String iconoCompartir = Statics.carpeta.resolve("imagenes").resolve("boton_compartir_icon.png").toAbsolutePath().toUri().toString();
        String colorTexto = Config.obtenerInstancia().obtenerColorInfo();
        return "<div style='color:" + colorTexto + ";'>  <strong>\u041d\u0443\u0436\u043d\u0430 \u043f\u043e\u043c\u043e\u0449\u044c?</strong><br>  \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0437\u043d\u0430\u0435\u0442\u0435, \u043a\u0430\u043a \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443, \u0438\u043b\u0438 \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0434\u0435\u0441\u044c, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u043c\u043e\u0449\u044c \u0447\u0435\u0440\u0435\u0437 \u043d\u0430\u0448\u0438 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0435\u0442\u0438.   \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 <img src='" + iconoCompartir + "' alt='\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f' style='height:12px;vertical-align:middle;'/>   <strong>\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f</strong>, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043b\u043e\u0433\u0438 \u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0434\u043b\u044f \u043d\u0430\u0448\u0435\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.   \u0415\u0441\u043b\u0438 \u0432\u044b \u0441\u043e\u0437\u0434\u0430\u0442\u0435\u043b\u044c \u043c\u043e\u0434\u043f\u0430\u043a\u0430 \u0438\u043b\u0438 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f, \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0444\u0430\u0439\u043b <code>crash_detector/plantilla.htm</code>,   \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u0432\u0430\u0448\u0435\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.</div>";
    }

    @Override
    public String restablecerPlantilla() {
        return "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d";
    }

    @Override
    public String restablecer() {
        return "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c";
    }

    @Override
    public String restablecerImagenMensjae(String nombreImagen) {
        return "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c " + nombreImagen + " \u0434\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e?";
    }

    @Override
    public String restablecerPlantillaMensaje() {
        return "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e?";
    }

    @Override
    public String faltar_de_clases_azurelib() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b AzureLib. \u0415\u0441\u043b\u0438 \u0443 \u0432\u0430\u0441 \u0443\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d AzureLib, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e \u0434\u043e 8 \u043e\u043a\u0442\u044f\u0431\u0440\u044f 2025 \u0433\u043e\u0434\u0430. \u042d\u0442\u043e \u0431\u044b\u043b\u0430 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0451\u043d\u043d\u0430\u044f \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430. \u0415\u0441\u043b\u0438 \u0443 \u0432\u0430\u0441 \u043d\u0435\u0442 AzureLib, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e.</b>";
    }

    @Override
    public String errorHealightINT() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u041c\u043e\u0434 <code>healight</code> \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u043e\u0448\u0438\u0431\u043a\u0443: <code>java.lang.NoSuchFieldError: INT</code>. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u043c\u043e\u0434 \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u043e\u043b\u044e, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 MCForge 47.10 \u0434\u043b\u044f Minecraft 1.20+. \u0418\u0437-\u0437\u0430 \u044d\u0442\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0438\u0433\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u0441\u044f.</b>";
    }

    @Override
    public String solucionHealightINT() {
        return "\u2022 \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0438\u043b\u0438 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434 <code>healight</code>. \u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0441 MinecraftForge 47.10 \u0434\u043b\u044f 1.20.1. \u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u043c\u043e\u0434\u0430 \u0438\u043b\u0438 \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u044b.";
    }

    @Override
    public String nombreErrorHealightINT() {
        return "\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: healight \u2014 \u041f\u043e\u043b\u0435 'INT' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e";
    }

    @Override
    public String errorMetodoAbstractoNoImplementadoDetallado(String clase, String metodo, String interfaz, String origen) {
        String colorError = this.config.obtenerColorError();
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(colorError).append(";'>").append("\u041a\u043b\u0430\u0441\u0441 <code>").append(clase).append("</code> \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0443\u0435\u0442 \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u044b\u0439 \u043c\u0435\u0442\u043e\u0434:<br>").append("<code>").append(metodo).append("</code><br>").append("\u0438\u0437 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 <code>").append(interfaz).append("</code>.");
        if (!origen.isEmpty()) {
            sb.append("<br><br>\u041f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043c\u043e\u0434 \u0438\u043b\u0438 \u0444\u0430\u0439\u043b: <code>").append(origen).append("</code>.");
        }
        sb.append("</b>");
        return sb.toString();
    }

    @Override
    public String solucionMetodoAbstractoNoImplementado() {
        return "\u2022 \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u0440\u0435\u0430\u043b\u0438\u0437\u0443\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441, \u043d\u043e \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043c\u0435\u0442\u043e\u0434. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 <b>\u043e\u0431\u0430 \u043c\u043e\u0434\u0430</b>, \u0443\u0447\u0430\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0432 \u044d\u0442\u043e\u043c (\u0442\u043e\u0442, \u0447\u0442\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441, \u0438 \u0442\u043e\u0442, \u0447\u0442\u043e \u0435\u0433\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0443\u0435\u0442). \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0437\u043d\u0430\u0435\u0442\u0435, \u043a\u0430\u043a\u0438\u0435 \u0438\u043c\u0435\u043d\u043d\u043e, \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0438\u043c\u0435\u043d\u0430 \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0438 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435.";
    }

    @Override
    public String nombreErrorMetodoAbstractoNoImplementado() {
        return "\u041c\u0435\u0442\u043e\u0434 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d (AbstractMethodError)";
    }

    @Override
    public String errorMetadataAnimacionEnServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u041c\u043e\u0434 \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c <b>\u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439</b> \u043a\u043b\u0430\u0441\u0441 (<code>AnimationMetadataSection</code>) \u043d\u0430 <b>\u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435</b>, \u0447\u0442\u043e \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u0435\u0442 \u043a\u043e\u0434 \u0434\u043b\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u041d\u0430\u043b\u0438\u0447\u0438\u0435 <code>ModernFix</code> \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u044f\u0432\u0438\u0442\u044c \u044d\u0442\u0443 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443, \u0445\u043e\u0442\u044f \u0438 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0435\u0451 \u043f\u0440\u044f\u043c\u043e\u0439 \u043f\u0440\u0438\u0447\u0438\u043d\u043e\u0439.</b>";
    }

    @Override
    public String solucionErrorMetadataAnimacionEnServidor() {
        return "\u2022 <b>\u0411\u044b\u0441\u0442\u0440\u043e\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u0435:</b> \u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u0435 <code>ModernFix</code>, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c, \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u043b\u0438 \u0441\u0435\u0440\u0432\u0435\u0440. \u0415\u0441\u043b\u0438 \u0434\u0430, \u0437\u043d\u0430\u0447\u0438\u0442, \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0432 \u0434\u0440\u0443\u0433\u043e\u043c \u043c\u043e\u0434\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440.<br>\u2022 <b>\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u0435:</b> \u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u0432\u0438\u043d\u043e\u0432\u043d\u044b\u0439 \u043c\u043e\u0434 (\u0438\u0449\u0438\u0442\u0435 \u043c\u043e\u0434\u044b \u0441 \u0430\u043d\u0438\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438, \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u043c\u0438 \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u0430\u043c\u0438 \u0438\u043b\u0438 \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u043c\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430\u043c\u0438) \u0438 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0435\u0433\u043e.<br>";
    }

    @Override
    public String nombreErrorMetadataAnimacionEnServidor() {
        return "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u043a\u043b\u0430\u0441\u0441 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 (AnimationMetadataSection)";
    }

    @Override
    public String errorConfiguracionConnectorCorrupta() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0424\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0430 <code>Sinytra Connector</code> \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d. \u041e\u0431\u044b\u0447\u043d\u043e \u044d\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u0444\u0430\u0439\u043b \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043d\u0443\u043b\u0435\u0432\u044b\u043c\u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u0430\u043c\u0438 (<code>\\u0000</code>) \u0438\u0437-\u0437\u0430 \u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0438\u0433\u0440\u044b, \u0441\u0431\u043e\u0435\u0432 \u0437\u0430\u043f\u0438\u0441\u0438 \u0438\u043b\u0438 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043e\u0432 \u043c\u043e\u0434\u043e\u0432.</b>";
    }

    @Override
    public String solucionConfiguracionConnectorCorrupta() {
        return "\u2022 \u041f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u0432 \u043f\u0430\u043f\u043a\u0443 <code>config/</code> \u0432\u0430\u0448\u0435\u0433\u043e \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u0430 Minecraft.<br>\u2022 \u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u043c\u043e\u0434\u043e\u0432 connector.<br>\u2022 \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0438\u0433\u0440\u0443: Sinytra Connector \u0441\u043e\u0437\u0434\u0430\u0441\u0442 \u043d\u043e\u0432\u044b\u0439 \u0447\u0438\u0441\u0442\u044b\u0439 \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.";
    }

    @Override
    public String nombreErrorConfiguracionConnectorCorrupta() {
        return "\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f Sinytra Connector";
    }

    @Override
    public String errorJarCorruptoConNombre(String nombreJar) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0424\u0430\u0439\u043b <code>" + nombreJar + "</code> \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d \u0438\u043b\u0438 \u043d\u0435\u043f\u043e\u043b\u043d\u044b\u0439.<br>\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0435\u0433\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0435\u0447\u043d\u044b\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a ZIP-\u0444\u0430\u0439\u043b\u0430.<br>\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u043d\u043e\u0439 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438\u043b\u0438 \u0441\u0431\u043e\u044f \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430.</b>";
    }

    @Override
    public String nombreErrorJarCorruptoConNombre() {
        return "\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0439 JAR-\u0444\u0430\u0439\u043b (\u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435\u043c \u0438\u043c\u0435\u043d\u0438)";
    }

    @Override
    public String solucionJarCorrupto() {
        return "\u2022 <b>\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b</b> \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0435\u0433\u043e \u0441 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 (CurseForge, MinecraftStorage \u0438 \u0442.\u0434.).<br>\u2022 \u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0432\u0440\u043e\u0434\u0435 CurseForge, Technic \u0438\u043b\u0438 Luna Pixel, \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0430 <b>ATLauncher</b> \u0438\u043b\u0438 <b>Prism Launcher</b>, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043b\u0443\u0447\u0448\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u044e\u0442 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u0432.<br>\u2022 \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u0430\u0448\u0435 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438.";
    }

    @Override
    public String errorCargaNBTMundoCorruptoConByte(String byteCorrupto) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u041d\u0435 \u0443\u0434\u0430\u0451\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u0438\u0440, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u0434\u0438\u043d \u0438\u0437 \u0435\u0433\u043e NBT-\u0444\u0430\u0439\u043b\u043e\u0432 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: <code>level.dat</code>, <code>playerdata/*.dat</code> \u0438\u043b\u0438 \u0447\u0430\u043d\u043a\u0438).<br>\u041a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: <code>UTFDataFormatException: \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0432\u0432\u043e\u0434 \u043e\u043a\u043e\u043b\u043e \u0431\u0430\u0439\u0442\u0430 " + byteCorrupto + "</code>.<br><br><b style='color:#" + this.config.obtenerColorAdvertencia() + ";'>\u26a0\ufe0f \u041f\u0435\u0440\u0435\u0434 \u043b\u044e\u0431\u043e\u0439 \u043f\u043e\u043f\u044b\u0442\u043a\u043e\u0439 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u043f\u043e\u043b\u043d\u0443\u044e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u043f\u0430\u043f\u043a\u0438 \u043c\u0438\u0440\u0430.</b><br><br>\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u043e\u043f\u0440\u043e\u0431\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0447\u0438\u043d\u0438\u0442\u044c \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e <b>\u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 NBT</b>, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 <a href='https://github.com/tryashtar/nbt-studio'>NBT Studio</a>.<br>\u0415\u0441\u043b\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u044c\u0451\u0437\u043d\u043e\u0435, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 <b>\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u0435\u0440\u0438\u0447\u043d\u044b\u0439 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440</b> (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, HxD), \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0431\u0430\u0439\u0442\u044b (\u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0432\u044b \u0440\u0430\u0437\u0431\u0438\u0440\u0430\u0435\u0442\u0435\u0441\u044c \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 NBT).<br>\u0412 \u043a\u0440\u0430\u0439\u043d\u0435\u043c \u0441\u043b\u0443\u0447\u0430\u0435 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u0438\u0440 \u0438\u0437 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438 \u0438\u043b\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u044e <i>\u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043c\u0438\u0440\u0430</i> \u043c\u043e\u0434\u043e\u0432, \u0442\u0430\u043a\u0438\u0445 \u043a\u0430\u043a <code>FTB Backup</code>.</b>";
    }

    @Override
    public String solucionErrorCargaNBTMundoCorrupto() {
        return "\u2022 <b>\u0421\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u043f\u043e\u043b\u043d\u0443\u044e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u043f\u0430\u043f\u043a\u0438 \u043c\u0438\u0440\u0430</b> \u043f\u0435\u0440\u0435\u0434 \u043f\u043e\u043f\u044b\u0442\u043a\u043e\u0439 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f.<br>\u2022 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 NBT (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, NBT Studio), \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b.<br>\u2022 \u0415\u0441\u043b\u0438 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u0441\u044f, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0444\u0430\u0439\u043b \u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u0435\u0440\u0438\u0447\u043d\u044b\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u043e\u043c \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u043e\u0433\u043e \u0431\u0430\u0439\u0442\u0430.<br>\u2022 \u041f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u043f\u044b\u0442\u0430 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u0438\u0440 \u0438\u0437 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438.";
    }

    @Override
    public String nombreErrorCargaNBTMundoCorrupto() {
        return "\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0439 \u043c\u0438\u0440: \u043e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 NBT";
    }

    @Override
    public String problema_con_openAL() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u0423 \u0432\u0430\u0441 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 OpenAL. \u0418\u043d\u043e\u0433\u0434\u0430 \u0435\u0451 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b Nouveau, \u043d\u043e \u0438\u043d\u043e\u0433\u0434\u0430 \u0432\u0438\u043d\u043e\u0439 \u0442\u043e\u043c\u0443 \u0432\u0435\u0440\u0441\u0438\u044f OpenAL, \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c\u0430\u044f \u0441 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0441 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u0432 \u0432\u0430\u0448\u0435\u043c \u0434\u0438\u0441\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u0432\u0435, \u0438 \u0432\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e \u0438\u0437 \u0432\u0430\u0448\u0435\u0433\u043e \u0434\u0438\u0441\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u0432\u0430. \u042d\u0442\u043e \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0432 \u0434\u0438\u0441\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u0432\u0430\u0445 \u043d\u0430 \u0431\u0430\u0437\u0435 Red Hat \u0438 \u0441 \u043c\u043e\u0434\u0430\u043c\u0438 \u043d\u0430 \u0437\u0432\u0443\u043a, \u0442\u0430\u043a\u0438\u043c\u0438 \u043a\u0430\u043a Sound Physics Remastered. \u0421\u043c. \u044d\u0442\u043e \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043c\u043e\u0449\u0438: <a href='https://www.reddit.com/r/linux_gaming/comments/15zrzcw/how_to_fix_minecraft_sound_problems_using/' target='_blank'>\u041a\u0430\u043a \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441\u043e \u0437\u0432\u0443\u043a\u043e\u043c \u0432 Minecraft \u043d\u0430 Linux</a>.</span>";
    }

    @Override
    public String errorArchivoBloqueadoPorOtroProceso() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u0441\u044f, \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u0444\u0430\u0439\u043b \u043c\u0438\u0440\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u043c.<br>\u042d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u0435\u0441\u043b\u0438:<br>\u2022 \u0423\u0436\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0434\u0440\u0443\u0433\u043e\u0439 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.<br>\u2022 \u0410\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441 \u0438\u043b\u0438 \u043f\u0440\u043e\u0432\u043e\u0434\u043d\u0438\u043a \u0438\u043c\u0435\u0435\u0442 \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0439 \u043f\u0430\u043f\u043a\u0443 \u043c\u0438\u0440\u0430.<br>\u2022 \u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0441\u044f \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0438 \u043e\u0441\u0442\u0430\u0432\u0438\u043b \u0444\u0430\u0439\u043b\u044b \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c\u0438.</b>";
    }

    @Override
    public String solucionErrorArchivoBloqueadoPorOtroProceso() {
        return "\u2022 <b>\u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0432\u0441\u0435 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u0430</b> (\u0432\u043a\u043b\u044e\u0447\u0430\u044f \u0444\u043e\u043d\u043e\u0432\u044b\u0435 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u044b \u0432\u0440\u043e\u0434\u0435 javaw.exe).<br>\u2022 \u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0445\u043e\u0441\u0442\u0438\u043d\u0433-\u043f\u0430\u043d\u0435\u043b\u044c (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Multicraft), \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440 \u0447\u0435\u0440\u0435\u0437 \u043f\u0430\u043d\u0435\u043b\u044c.<br>\u2022 <b>\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0430\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441</b>, \u0435\u0441\u043b\u0438 \u043f\u043e\u0434\u043e\u0437\u0440\u0435\u0432\u0430\u0435\u0442\u0435, \u0447\u0442\u043e \u043e\u043d \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u0442 \u0444\u0430\u0439\u043b\u044b.<br>\u2022 \u041d\u0430 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0438\u0441\u0442\u0435\u043c\u0430\u0445 \u0437\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0432\u0441\u0435 \u043e\u043a\u043d\u0430 \u041f\u0440\u043e\u0432\u043e\u0434\u043d\u0438\u043a\u0430, \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u044e\u0449\u0438\u0435 \u043f\u0430\u043f\u043a\u0443 \u043c\u0438\u0440\u0430.<br>\u2022 \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0444\u0430\u0439\u043b <code>session.lock</code> \u0432\u043d\u0443\u0442\u0440\u0438 \u043f\u0430\u043f\u043a\u0438 \u043c\u0438\u0440\u0430 (\u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0432\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u043d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430).";
    }

    @Override
    public String nombreErrorArchivoBloqueadoPorOtroProceso() {
        return "\u0424\u0430\u0439\u043b \u043c\u0438\u0440\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u043c";
    }

    @Override
    public String errorClaseFinalExtendida(String claseHija, String clasePadreFinal) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u041c\u043e\u0434 \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043a\u043b\u0430\u0441\u0441 <code>" + clasePadreFinal + "</code>, \u043d\u043e \u044d\u0442\u043e\u0442 \u043a\u043b\u0430\u0441\u0441 \u0442\u0435\u043f\u0435\u0440\u044c \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u043a\u0430\u043a <b>final</b> \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d.<br>\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441: <code>" + claseHija + "</code>.<br><br>\u042d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430 \u043c\u043e\u0434 \u0441\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u043b\u044f \u0431\u043e\u043b\u0435\u0435 \u0441\u0442\u0430\u0440\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u0431\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u043c\u043e\u0434\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432 \u043d\u0435\u0434\u0430\u0432\u043d\u0438\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 \u043f\u043e\u043c\u0435\u0442\u0438\u043b \u043a\u043b\u0430\u0441\u0441\u044b \u043a\u0430\u043a <code>final</code>.</b>";
    }

    @Override
    public String solucionErrorClaseFinalExtendida() {
        return "\u2022 <b>\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0441\u0435 \u0437\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u044b\u0435 \u043c\u043e\u0434\u044b</b>, \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0442\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0441\u0432\u044f\u0437\u0430\u043d\u044b \u0441 \u0443\u043f\u043e\u043c\u044f\u043d\u0443\u0442\u044b\u043c \u0431\u0430\u0437\u043e\u0432\u044b\u043c \u043c\u043e\u0434\u043e\u043c.<br>\u2022 \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, \u043d\u0430\u0439\u0434\u0438\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e \u043c\u043e\u0434\u0430, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft \u0438 \u0435\u0451 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044f\u043c\u0438.<br>\u2022 \u0412 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0441\u043b\u0443\u0447\u0430\u044f\u0445 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0430, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0435\u0433\u043e \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439 \u043a\u043b\u0430\u0441\u0441, \u043f\u043e\u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u0443.";
    }

    @Override
    public String nombreErrorClaseFinalExtendida() {
        return "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442 final-\u043a\u043b\u0430\u0441\u0441\u0430";
    }

    @Override
    public String errorRubidiumObsoletoConIris() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 <b>Rubidium</b> (\u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0443\u044e \u0432\u0435\u0442\u043a\u0443 Sodium \u0434\u043b\u044f Forge) \u0432\u043c\u0435\u0441\u0442\u0435 \u0441 <b>Iris \u0438\u043b\u0438 Oculus</b>.<br>\u0412 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 Minecraft (1.19.2 \u0438 \u0432\u044b\u0448\u0435) Rubidium \u043d\u0435 \u0443\u0441\u043f\u0435\u043b \u0437\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438 Sodium, \u0438 \u0443 \u0435\u0433\u043e \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b.<br><br>\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u043a\u0436\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u043e\u0437\u043d\u0438\u043a\u043d\u0443\u0442\u044c \u0438\u0437-\u0437\u0430 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0430 \u043c\u0435\u0436\u0434\u0443 \u043c\u043e\u0434\u0430\u043c\u0438 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 (Sodium, Rubidium, Embeddium, Bedium, Xeonium \u0438 \u0442.\u0434.) \u0438\u043b\u0438 Iris Shaders \u0438 \u0434\u0440\u0443\u0433\u0438\u043c \u043c\u043e\u0434\u043e\u043c.</b>";
    }

    @Override
    public String solucionRubidiumObsoletoConIris() {
        return "\u2022 <b>\u0423\u0434\u0430\u043b\u0438\u0442\u0435 Rubidium</b> \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 <code>mods</code>.<br>\u2022 <b>\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a></b>, \u0430\u043a\u0442\u0438\u0432\u043d\u0443\u044e \u0438 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0432\u0435\u0442\u043a\u0443 Sodium \u0434\u043b\u044f Forge, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 Iris/Oculus \u043d\u0430 1.20+.<br>\u2022 \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0443 \u0432\u0430\u0441 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u0432\u0435\u0442\u043a\u0438 Sodium \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: Rubidium + Embeddium).<br>\u2022 \u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 Oculus \u0432\u043c\u0435\u0441\u0442\u043e Iris, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0435\u0433\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Forge \u0438 Embeddium.";
    }

    @Override
    public String nombreErrorRubidiumObsoletoConIris() {
        return "\u0423\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0439 Rubidium \u0441 Iris/Oculus (OptionInstance \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f final)";
    }

    @Override
    public String errorVoiceChatPuertoOcupado() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u041c\u043e\u0434 <code>Simple Voice Chat</code> \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0441\u0432\u043e\u0439 \u0433\u043e\u043b\u043e\u0441\u043e\u0432\u043e\u0439 \u0441\u0435\u0440\u0432\u0435\u0440, \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e UDP-\u043f\u043e\u0440\u0442 \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0438\u043b\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 IP-\u0430\u0434\u0440\u0435\u0441 \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.<br>\u042d\u0442\u043e \u043d\u0435 \u043c\u0435\u0448\u0430\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b, \u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u044e \u0433\u043e\u043b\u043e\u0441\u043e\u0432\u043e\u0433\u043e \u0447\u0430\u0442\u0430.</b>";
    }

    @Override
    public String solucionErrorVoiceChatPuertoOcupado() {
        return "\u2022 <b>\u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u043b\u044e\u0431\u044b\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u044b Minecraft</b> \u0438\u043b\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u0435 UDP-\u043f\u043e\u0440\u0442 24454.<br>\u2022 \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0435\u0441\u044c \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e <b>\u043d\u0438 \u043e\u0434\u043d\u0430 \u0434\u0440\u0443\u0433\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430</b> \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u044d\u0442\u043e\u0442 \u043f\u043e\u0440\u0442.<br>\u2022 \u0412 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u043c\u043e\u0434\u0430 (<code>config/voicechat/</code>) \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u0435 UDP-\u043f\u043e\u0440\u0442 \u043d\u0430 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0439 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 24455).<br>\u2022 \u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 IP-\u0430\u0434\u0440\u0435\u0441, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0435\u0433\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0438\u043b\u0438 \u043e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u043f\u0443\u0441\u0442\u044b\u043c \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.";
    }

    @Override
    public String nombreErrorVoiceChatPuertoOcupado() {
        return "\u0413\u043e\u043b\u043e\u0441\u043e\u0432\u043e\u0439 \u0447\u0430\u0442: UDP-\u043f\u043e\u0440\u0442 \u0437\u0430\u043d\u044f\u0442 \u0438\u043b\u0438 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 IP";
    }

    @Override
    public String errorBlockItemNuloCreate(String nombreBlockItem) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u0423 BlockItem <code>" + nombreBlockItem + "</code> \u0431\u043b\u043e\u043a \u0440\u0430\u0432\u0435\u043d null.<br>\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u0432 <b>\u0430\u0434\u0434\u043e\u043d\u0430\u0445 \u0434\u043b\u044f Create</b> (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, <code>dndecor</code>, <code>createdeco</code>) \u043f\u0440\u0438 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0430\u0445 \u0441 <code>Amendments</code>, <code>Moonshine</code> \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0431\u043b\u043e\u043a\u043e\u0432.<br><b>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435:</b> \u042d\u0442\u043e \u043d\u0435 \u043f\u0440\u044f\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 Amendments, \u0430 \u0441\u0438\u043c\u043f\u0442\u043e\u043c \u0431\u043e\u043b\u0435\u0435 \u0433\u043b\u0443\u0431\u043e\u043a\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0440\u0435\u0435\u0441\u0442\u0440\u0430.</b>";
    }

    @Override
    public String solucionErrorBlockItemNuloCreate() {
        return "\u2022 <b>\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0432\u0441\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b:</b> Create, Amendments, Moonshine \u0438 \u043b\u044e\u0431\u044b\u0435 \u0430\u0434\u0434\u043e\u043d\u044b (\u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e <code>dndecor</code> \u0438 <code>createdeco</code>).<br>\u2022 \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, <b>\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0430\u0434\u0434\u043e\u043d\u044b \u0434\u043b\u044f Create</b> \u043f\u043e \u043e\u0434\u043d\u043e\u043c\u0443, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u0432\u0438\u043d\u043e\u0432\u043d\u0438\u043a\u0430.<br>\u2022 \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e <b>Amendments \u0438 Moonshine \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b</b> \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Create \u0438 Forge.<br>\u2022 \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0435\u0441\u0442\u044c \u043b\u0438 \u0431\u0435\u0442\u0430-\u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u043b\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d\u043d\u044b\u0435 \u0444\u043e\u0440\u043a\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0445 \u0430\u0434\u0434\u043e\u043d\u043e\u0432.";
    }

    @Override
    public String nombreErrorBlockItemNuloCreate() {
        return "Null BlockItem \u0432 \u0430\u0434\u0434\u043e\u043d\u0435 Create";
    }

    @Override
    public String modIncompatibleConCargadorActivo(List<String> mods) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b style='color:#").append(this.config.obtenerColorAdvertencia()).append(";'>").append("\u041d\u0430\u0439\u0434\u0435\u043d\u044b \u043c\u043e\u0434\u044b, \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0430\u0449\u0438\u0435 \u043d\u0438 \u043e\u0434\u043d\u043e\u0439 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0435 (Forge, Fabric \u0438 \u0442.\u0434.):<ul>");
        for (String mod : mods) {
            sb.append("<li><code>").append(mod).append("</code></li>");
        }
        sb.append("</ul>\u042d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442, \u043a\u043e\u0433\u0434\u0430:<br>").append("\u2022 \u041c\u043e\u0434\u044b \u043e\u0442 <b>Fabric \u0438 Forge</b> \u0441\u043c\u0435\u0448\u0430\u043d\u044b \u0432 \u043e\u0434\u043d\u043e\u0439 \u043f\u0430\u043f\u043a\u0435.<br>").append("\u2022 \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043c\u043e\u0434 \u0434\u043b\u044f \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft.<br>").append("\u2022 \u041c\u043e\u0434 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d \u0438\u043b\u0438 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u043c JAR-\u0444\u0430\u0439\u043b\u043e\u043c.</b>");
        return sb.toString();
    }

    @Override
    public String solucionModIncompatibleConCargadorActivo() {
        return "\u2022 <b>\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u0441\u0435 \u043c\u043e\u0434\u044b \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b</b> (\u0442\u043e\u043b\u044c\u043a\u043e Forge <b>\u0438\u043b\u0438</b> \u0442\u043e\u043b\u044c\u043a\u043e Fabric, \u0430 \u043d\u0435 \u043e\u0431\u0435 \u0441\u0440\u0430\u0437\u0443).<br>\u2022 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 <b>\u0434\u0435\u0440\u0435\u0432\u043e \u043c\u043e\u0434\u043e\u0432</b>, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u043a\u0430\u043a\u0443\u044e \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0443 \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0451\u0442 \u043a\u0430\u0436\u0434\u044b\u0439 \u0444\u0430\u0439\u043b.<br>\u2022 \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043b\u044e\u0431\u043e\u0439 \u043c\u043e\u0434, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u044b \u043d\u0435 \u0443\u0437\u043d\u0430\u0451\u0442\u0435 \u0438\u043b\u0438 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b.<br>\u2022 \u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 CurseForge \u0438\u043b\u0438 Prism, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e.";
    }

    @Override
    public String nombreModIncompatibleConCargadorActivo() {
        return "\u041c\u043e\u0434 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u043e\u043c";
    }

    @Override
    public String errorCreacionModeloFallida(String modid, String nombreModelo) {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043c\u043e\u0434\u0435\u043b\u044c <code>" + modid + ":" + nombreModelo + "</code>.<br>\u042d\u0442\u043e \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442, \u0447\u0442\u043e \u043c\u043e\u0434 <code>" + modid + "</code> \u0438\u043c\u0435\u0435\u0442 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0435, \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0438\u043b\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft.</b>";
    }

    @Override
    public String solucionErrorCreacionModeloFallida() {
        return "\u2022 <b>\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434</b> \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0441 \u0432\u0430\u0448\u0438\u043c \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u043e\u043c.<br>\u2022 \u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0441\u0431\u043e\u0440\u043a\u0443 \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0438\u043b\u0438 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u0443\u044e, \u0432\u0435\u0440\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438.<br>\u2022 \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0444\u0430\u0439\u043b JAR \u043d\u0435 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d (\u043f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0435\u0433\u043e).<br>\u2022 \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 \u0430\u0432\u0442\u043e\u0440\u0443 \u043c\u043e\u0434\u0430, \u043f\u0440\u0438\u043b\u043e\u0436\u0438\u0432 \u044d\u0442\u043e\u0442 \u043b\u043e\u0433.";
    }

    @Override
    public String nombreErrorCreacionModeloFallida() {
        return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043c\u043e\u0434\u0435\u043b\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u0430";
    }

    @Override
    public String conflictoMoonlightIceberg() {
        return "<b style='color:#" + this.config.obtenerColorError() + ";'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 \u043c\u043e\u0434\u0430\u043c\u0438 <code>Moonlight</code> \u0438 <code>Iceberg</code>.<br>\u041e\u0431\u0430 \u043f\u044b\u0442\u0430\u044e\u0442\u0441\u044f \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u043c \u0441\u043f\u043e\u0441\u043e\u0431\u043e\u043c, \u0447\u0442\u043e \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442 \u043a \u0441\u0431\u043e\u044e OpenGL \u0438\u0437-\u0437\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u044f \u0432\u0430\u043b\u0438\u0434\u043d\u043e\u0433\u043e \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430.<br>\u042d\u0442\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0447\u0430\u0441\u0442\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0432\u0435\u0440\u0441\u0438\u0439 Forge, \u0432\u043a\u043b\u044e\u0447\u0430\u044e\u0449\u0438\u0445 \u0430\u0434\u0430\u043f\u0442\u0435\u0440\u044b \u0434\u043b\u044f \u043c\u043e\u0434\u043e\u0432 Fabric.</b>";
    }

    @Override
    public String solucionConflictoMoonlightIceberg() {
        return "\u2022 <b>\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043e\u0431\u0430 \u043c\u043e\u0434\u0430</b> \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u0432\u0435\u0440\u0441\u0438\u0439, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0445 \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Forge.<br>\u2022 \u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, <b>\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u0435 Iceberg</b>, \u0442\u0430\u043a \u043a\u0430\u043a Moonlight \u043e\u0431\u044b\u0447\u043d\u043e \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0432\u0430\u0436\u043d\u043e\u0439 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c\u044e \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u0438\u0445 \u043c\u043e\u0434\u043e\u0432.<br>\u2022 \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0443 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u044e\u0449\u0438\u0445\u0441\u044f \u0438\u043b\u0438 \u0441\u043c\u0435\u0448\u0430\u043d\u043d\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 Forge/Fabric \u044d\u0442\u0438\u0445 \u043c\u043e\u0434\u043e\u0432.<br>\u2022 \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u043b\u0438 \u0434\u0440\u0443\u0433\u043e\u0439 \u043c\u043e\u0434 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Supplementaries, Citadel \u0438 \u0442.\u0434.) \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c Iceberg \u0432\u043d\u0443\u0442\u0440\u0438 \u0441\u0435\u0431\u044f.";
    }

    @Override
    public String nombreConflictoMoonlightIceberg() {
        return "\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442: Moonlight \u043f\u0440\u043e\u0442\u0438\u0432 Iceberg (OpenGL \u0431\u0435\u0437 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430)";
    }

    @Override
    public String instantanea() {
        return "\u0421\u043d\u0438\u043c\u043e\u043a";
    }

    @Override
    public Object desdeUltimaInstantanea() {
        return "\u0421 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0441\u043d\u0438\u043c\u043a\u0430";
    }

    @Override
    public String seleccionarUnArchivo() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b";
    }

    @Override
    public String instantaneaCreadaCorrectamente() {
        return "\u0421\u043d\u0438\u043c\u043e\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d";
    }

    @Override
    public String errorCreandoInstantanea() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u043d\u0438\u043c\u043a\u0430";
    }

    @Override
    public String consejo() {
        return "\u0421\u043e\u0432\u0435\u0442";
    }

    @Override
    public String resultadoMuestra() {
        return "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442";
    }

    @Override
    public String historaDeModsDesc() {
        return "<html><body style='font-family: sans-serif; font-size: 12px;'>  <b>\u0421\u043e\u0432\u0435\u0442:</b> \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0432\u0430 \u0444\u0430\u0439\u043b\u0430 \u0436\u0443\u0440\u043d\u0430\u043b\u0430, \u0447\u0442\u043e\u0431\u044b \u0441\u0440\u0430\u0432\u043d\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043c\u043e\u0434\u043e\u0432.   \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 <span style='color:%s;'>\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 (+)</span> \u0438   <span style='color:%s;'>\u0443\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0435 (&#8722;)</span> \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0435 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0438\u043c\u0451\u043d.   \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 \u00ab\u0421\u043d\u0438\u043c\u043e\u043a\u00bb, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043f\u0438\u044e \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0441 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435\u043c .instantanea.</body></html>";
    }

    @Override
    public String texto_de_boton_compartir_markdown() {
        return "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043b\u043e\u0433\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 Markdown \u0431\u0435\u0437 \u043e\u0442\u0447\u0451\u0442\u0430";
    }

    @Override
    public String titulo_configuracion() {
        return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438";
    }

    @Override
    public String columna_url() {
        return "URL";
    }

    @Override
    public String error_inesperado_al_compartir() {
        return "\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435.";
    }

    @Override
    public String error_inesperado_al_generar_enlaces() {
        return "\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0441\u044b\u043b\u043e\u043a.";
    }

    @Override
    public String error_inesperado_al_procesar_boton() {
        return "\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043a\u043d\u043e\u043f\u043a\u0438.";
    }

    @Override
    public String sin_archivo_para_abrir() {
        return "\u041d\u0435\u0442 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0434\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.";
    }

    @Override
    public String archivo_no_existe_prefijo() {
        return "\u0424\u0430\u0439\u043b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442:\n";
    }

    @Override
    public String no_se_pudo_editar_se_copia_ruta() {
        return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435.\n\u041f\u0443\u0442\u044c \u0431\u0443\u0434\u0435\u0442 \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430.";
    }

    @Override
    public String no_se_pudo_abrir_se_copia_ruta() {
        return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b; \u043f\u0443\u0442\u044c \u0431\u044b\u043b \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430.";
    }

    @Override
    public String escritorio_no_soportado_se_copia_ruta() {
        return "\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f; \u043f\u0443\u0442\u044c \u0431\u044b\u043b \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430.";
    }

    @Override
    public String limite_de_solicitudes() {
        return "\u0412\u044b \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u0438 \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0430\u0439\u0442 \u043b\u043e\u0433\u043e\u0432 \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u043e\u0435 API \u0434\u043b\u044f \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.";
    }

    @Override
    public String texto_de_boton_compartir_enlace() {
        return "\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439";
    }

    @Override
    public String infoDeTrazos() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0418\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0445\u043d\u0438\u0445 \u0447\u0430\u0441\u0442\u0435\u0439 \u0431\u0440\u0451\u0432\u0435\u043d \u2014 \u0433\u043b\u0430\u0432\u043d\u044b\u0439 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442. \u0424\u043e\u0440\u043c\u0430\u0442: \u0423\u0440\u043e\u0432\u0435\u043d\u044c, \u0421\u0442\u0440\u043e\u043a\u0430. \u0412\u0441\u0435 \u043b\u043e\u0433\u0438 \u0438\u043c\u0435\u044e\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438. " + "<br>" + "\u041a\u0430\u043a \u043f\u0440\u0430\u0432\u0438\u043b\u043e, \u043d\u0443\u0436\u043d\u043e \u0438\u0441\u043a\u0430\u0442\u044c \u043d\u0430 \u0441\u0430\u043c\u044b\u0445 \u043d\u0438\u0436\u043d\u0438\u0445 \u0443\u0440\u043e\u0432\u043d\u044f\u0445 \u0432\u043e \u0432\u0441\u0435\u0445 \u043b\u043e\u0433\u0430\u0445; \u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0438 \u0441 \u0432\u044b\u0441\u043e\u043a\u0438\u043c \u0443\u0440\u043e\u0432\u043d\u0435\u043c \u043e\u0431\u044b\u0447\u043d\u043e \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043b\u043e\u0436\u043d\u043e\u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438. \u0412\u0430\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432\u0430\u0448\u0443 \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u044c \u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043e\u043d\u0441\u043e\u043b\u044c, \u0442\u0430\u043a \u043a\u0430\u043a \u0430\u043d\u0430\u043b\u0438\u0437 \u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043e\u043a \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0434\u0435\u0430\u043b\u044c\u043d\u044b\u043c \u043f\u0440\u0438 \u0431\u043e\u043b\u044c\u0448\u043e\u043c \u0438\u0445 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435.</b>";
    }

    @Override
    public String buscador_canario_de_orden_label() {
        return "\u041f\u043e\u0438\u0441\u043a\u043e\u0432\u0438\u043a \u043a\u0430\u043d\u0430\u0440\u0435\u0439\u043a\u0438 \u043e\u0440\u0434\u0435\u0440\u0430";
    }

    @Override
    public String buscador_canario_de_orden_mensaje_proximamente() {
        return "\u042d\u0442\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u044f \u0441\u0442\u0430\u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0439 \u0432 \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0435\u0435 \u0432\u0440\u0435\u043c\u044f.";
    }

    @Override
    public String buscador_canario_de_orden_titulo_proximamente() {
        return "\u0421\u043a\u043e\u0440\u043e \u0431\u0443\u0434\u0435\u0442";
    }

    @Override
    public String nombre_de_mods_incompatibles_crash_assistant() {
        return "\u041c\u043e\u0434\u044b, \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0435 \u0441 Crash Assistant (\u041b\u043e\u0436\u043d\u044b\u0435)";
    }

    @Override
    public String nombre_de_modpack_incompatible_crash_assistant() {
        return "\u041c\u043e\u0434 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u043c\u043e\u0434\u043f\u0430\u043a\u043e\u043c, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u043c CrashAssistant";
    }

    @Override
    public String advertenciaCrashAssistantModpackIncompatibleFalso() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant \u0438\u043c\u0435\u0435\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u043c\u043e\u0434\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043e\u043d \u0441\u0447\u0438\u0442\u0430\u0435\u0442 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u043c\u0438, \u043d\u043e \u0443 \u043d\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432 \u044d\u0442\u043e\u043c\u0443, \u0438 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435. \u0415\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0433\u0440\u0430\u0442\u044c \u0441 \u044d\u0442\u0438\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0444\u0430\u0439\u043b <code>config/crash_assistant/config.toml</code> \u0438 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c <code>enabled = true</code> \u0432 \u0440\u0430\u0437\u0434\u0435\u043b\u0435 [compatibility] \u043d\u0430 <code>enabled = false</code>.</b>";
    }

    @Override
    public String advertenciaCrashAssistantModsIncompatibles() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Crash Assistant \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u043c\u0435\u0447\u0430\u0442\u044c \u043c\u043e\u0434\u044b \u043a\u0430\u043a \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0435, \u043d\u043e \u0438\u043d\u043e\u0433\u0434\u0430 \u044d\u0442\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e, \u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043e\u0434\u043d\u043e\u043c \u044f\u0437\u044b\u043a\u0435. \u0415\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0438 \u043c\u043e\u0434\u044b, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0444\u0430\u0439\u043b <code>config/crash_assistant/problematic_mods_config.json</code> \u0438 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 <code>should_crash_on_startup</code> \u0441 <code>true</code> \u043d\u0430 <code>false</code>.</b>";
    }

    @Override
    public String errorDependenciaSimple(String modId, String dependencia, String actual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430: \u041c\u043e\u0434 '" + modId + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043c\u043e\u0434 '" + dependencia + "'. \u0412 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f, " + actual + ".</span>";
    }

    @Override
    public String errorDependenciaNoInstalada(String modId, String dependencia, String requerido) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430: \u041c\u043e\u0434\u0443 '" + modId + "' \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u0435\u0440\u0441\u0438\u044f '" + requerido + "' \u0438\u043b\u0438 \u0432\u044b\u0448\u0435 \u043c\u043e\u0434\u0430 '" + dependencia + "', \u043d\u043e \u044d\u0442\u043e\u0442 \u043c\u043e\u0434 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d.</span>";
    }

    @Override
    public String errorSuperbWarfareIncompatible(String modId, String dependencia, String versionActual) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430: \u041c\u043e\u0434 '" + modId + "' \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 '" + dependencia + "'. \u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434 'Iris/Oculus & GeckoLib Compat', \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 Superb Warfare \u0438 \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0441 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 GeckoLib. \u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + versionActual + "</span>";
    }

    @Override
    public String fallo_ejecucion_tarea_descripcion(String clase) {
        return "\u041e\u0448\u0438\u0431\u043a\u0430: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 '" + clase + "'. \u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0447\u0430\u0441\u0442\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u0441 \u043c\u043e\u0434\u0430\u043c\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c \u0438\u043b\u0438 \u0438\u043c\u0435\u044e\u0442 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438.";
    }

    @Override
    public String nombre_fallos_ejecucion_tareas() {
        return "\u0421\u0431\u043e\u0438 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u0434\u0430\u0447";
    }

    @Override
    public String recomendacion_fallos_ejecucion() {
        return "\u0422\u0430\u043a\u043e\u0439 \u0442\u0438\u043f \u043e\u0448\u0438\u0431\u043a\u0438 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u0438\u0437-\u0437\u0430 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u043c\u0435\u0436\u0434\u0443 \u043c\u043e\u0434\u0430\u043c\u0438. \u041e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u043e \u0441 \u043c\u043e\u0434\u0430\u043c\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0441 ConnectorMod.";
    }

    @Override
    public String info_clase_problematica() {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441:";
    }

    public String ver_en_log() {
        return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432 \u043b\u043e\u0433\u0435";
    }

    @Override
    public String no_se_encontraron_clases_problema() {
        return "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u044b\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u0441 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u043c\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String errorConflictoOptiFineEMF() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Entity Model Features (EMF). \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0441\u0431\u043e\u0439 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044f, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u0435\u0448\u0430\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEMF() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Entity Model Features";
    }

    @Override
    public String pasoConflictoOptiFineEMF() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043b\u0438\u0431\u043e OptiFine, \u043b\u0438\u0431\u043e Entity Model Features, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c.";
    }

    @Override
    public String errorConflictoOptiFineFusion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Fusion. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0441\u0431\u043e\u0439 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044f, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u0435\u0448\u0430\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineFusion() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Fusion";
    }

    @Override
    public String pasoConflictoOptiFineFusion() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043b\u0438\u0431\u043e OptiFine, \u043b\u0438\u0431\u043e Fusion, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c.";
    }

    @Override
    public String errorConflictoFlywheelSodium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Flywheel (\u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f Create) \u043d\u0443\u0436\u0434\u0430\u0435\u0442\u0441\u044f \u0432 Sodium \u0432\u0435\u0440\u0441\u0438\u0438 0.6.0-beta.2 \u0438\u043b\u0438 \u0432\u044b\u0448\u0435. Rubidium \u2014 \u044d\u0442\u043e 0.5.3. \u0420\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoFlywheelSodium() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 Flywheel \u0438 \u0432\u0435\u0440\u0441\u0438\u0438 Sodium";
    }

    @Override
    public String pasoConflictoFlywheelSodium() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 Sodium \u0434\u043e \u0432\u0435\u0440\u0441\u0438\u0438 0.6.0-beta.2 \u0438\u043b\u0438 \u0432\u044b\u0448\u0435, \u043b\u0438\u0431\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 <a href='https://www.curseforge.com/minecraft/mc-mods/embeddium'>Embeddium</a> \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u044b.";
    }

    @Override
    public String errorConflictoOptiFineEpicFight() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Epic Fight. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0441\u0431\u043e\u0439 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044f, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u0435\u0448\u0430\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEpicFight() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Epic Fight";
    }

    @Override
    public String pasoConflictoOptiFineEpicFight() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043b\u0438\u0431\u043e OptiFine, \u043b\u0438\u0431\u043e Epic Fight, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c.";
    }

    @Override
    public String errorConflictoOptiFineRubidium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Rubidium. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0441\u0431\u043e\u0439 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044f, \u043f\u0440\u0435\u043f\u044f\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineRubidium() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 OptiFine \u0438 Rubidium";
    }

    @Override
    public String pasoConflictoOptiFineRubidium() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine \u0438\u043b\u0438 Rubidium, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c.";
    }

    @Override
    public String errorFreeCamServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>FreeCam \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u043d\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 FreeCam \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0438\u043b\u0438 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043e\u043d \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.</b>";
    }

    @Override
    public String nombreDeErrorFreeCamServidor() {
        return "FreeCam \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435";
    }

    @Override
    public String pasoErrorFreeCamServidor() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 FreeCam \u0441 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.";
    }

    @Override
    public String errorEntityTextureFeaturesServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Entity Texture Features (ETF) \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u043d\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 ETF \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0438\u043b\u0438 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043e\u043d \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.</b>";
    }

    @Override
    public String nombreDeErrorEntityTextureFeaturesServidor() {
        return "Entity Texture Features \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435";
    }

    @Override
    public String pasoErrorEntityTextureFeaturesServidor() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 Entity Texture Features \u0441 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.";
    }

    @Override
    public String errorEULANoAceptado() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u0440\u0438\u043d\u044f\u0442\u044c EULA Minecraft, \u0447\u0442\u043e\u0431\u044b \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440. \u041e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0444\u0430\u0439\u043b eula.txt \u0438 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u0435 'eula=false' \u043d\u0430 'eula=true'.</b>";
    }

    @Override
    public String nombreDeErrorEULANoAceptado() {
        return "EULA Minecraft \u043d\u0435 \u043f\u0440\u0438\u043d\u044f\u0442\u0430";
    }

    @Override
    public String pasoErrorEULANoAceptado() {
        return "\u041e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0444\u0430\u0439\u043b eula.txt \u0432 \u043f\u0430\u043f\u043a\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0438 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u0435 'eula=false' \u043d\u0430 'eula=true'.";
    }

    @Override
    public String errorOptiFineServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>OptiFine \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u043d\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0438\u043b\u0438 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043e\u043d \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.</b>";
    }

    @Override
    public String nombreDeErrorOptiFineServidor() {
        return "OptiFine \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435";
    }

    @Override
    public String pasoErrorOptiFineServidor() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine \u0441 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.";
    }

    @Override
    public String errorIronSpellbooksVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iron's Spellbooks \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u0434\u043b\u044f 1.20.1, \u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043c\u0435\u0442\u043e\u0434\u044b \u0438\u0437 1.21.1. \u041c\u043e\u0434 \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c ResourceLocation.fromNamespaceAndPath, \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 1.20.1.</b>";
    }

    @Override
    public String nombreDeErrorIronSpellbooksVersion() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0435\u0440\u0441\u0438\u0438 Iron's Spellbooks";
    }

    @Override
    public String pasoErrorIronSpellbooksVersion() {
        return "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Iron's Spellbooks, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft.";
    }

    @Override
    public String errorConflictoOptiFineEmbeddium() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Embeddium. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0441\u0431\u043e\u0439 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044f, \u043f\u0440\u0435\u043f\u044f\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoOptiFineEmbeddium() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 OptiFine \u0438 Embeddium";
    }

    @Override
    public String pasoConflictoOptiFineEmbeddium() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine \u0438\u043b\u0438 Embeddium, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c.";
    }

    @Override
    public String noPuedeAnalizarJSON() {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u042d\u0442\u043e \u0447\u0430\u0441\u0442\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0438\u0437-\u0437\u0430 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u044e\u0449\u0438\u0445 \u043c\u043e\u0434\u043e\u0432 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043c\u0438\u0440\u0430, \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e Terralinth, AmplifiedNether, Nullscape \u0438 Incendium, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0445 \u043c\u043e\u0434\u043e\u0432 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043c\u0438\u0440\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0432\u0430\u043c \u0442\u0430\u043a\u0436\u0435 \u043d\u0443\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043c\u043e\u0434.</span>";
    }

    @Override
    public String errorControllableServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Controllable \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u043d\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 Controllable \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0438\u043b\u0438 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043e\u043d \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.</b>";
    }

    @Override
    public String nombreDeErrorControllableServidor() {
        return "Controllable \u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435";
    }

    @Override
    public String pasoErrorControllableServidor() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 Controllable \u0441 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435.";
    }

    @Override
    public String errorSupplementariesCargaServidor() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Supplementaries \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0443, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043c\u0435\u0448\u0430\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u041c\u043e\u0434 \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u043c \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0433\u043d\u044f, \u0447\u0442\u043e \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442 \u043a \u0441\u0431\u043e\u044e \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 datapack'\u043e\u0432.</b>";
    }

    @Override
    public String nombreDeErrorSupplementariesCargaServidor() {
        return "Supplementaries \u043c\u0435\u0448\u0430\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u0430";
    }

    @Override
    public String pasoErrorSupplementariesCargaServidor() {
        return "\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c Supplementaries \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u043b\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0435\u0433\u043e, \u0447\u0442\u043e\u0431\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.";
    }

    @Override
    public String errorGroovyModloaderModuloFaltante() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Groovy Modloader (GML) \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443 \u0441 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u043c\u0438 \u043c\u043e\u0434\u0443\u043b\u044f\u043c\u0438 Jackson. \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0434\u044b, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a Valkyrien Skies, \u043c\u043e\u0433\u0443\u0442 \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043e\u0448\u0438\u0431\u043a\u0443, \u0435\u0441\u043b\u0438 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u044e\u0442 \u0432\u0441\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438.</b>";
    }

    @Override
    public String nombreDeErrorGroovyModloaderModuloFaltante() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043e\u0434\u0443\u043b\u044c Jackson \u0432 Groovy Modloader";
    }

    @Override
    public String pasoErrorGroovyModloaderModuloFaltante() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 Groovy Modloader \u0438 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a Valkyrien Skies, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0433\u0443\u0442 \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439.";
    }

    @Override
    public String errorEveryCompatNombreInvalido() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Every Compat \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u0434\u0435\u0440\u0435\u0432\u044f\u043d\u043d\u043e\u0433\u043e \u0431\u043b\u043e\u043a\u0430. Every Compat \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c. \u041d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0435\u0433\u043e!</b>";
    }

    @Override
    public String nombreDeErrorEveryCompatNombreInvalido() {
        return "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u0432 Every Compat";
    }

    @Override
    public String pasoErrorEveryCompatNombreInvalido() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043f\u0430\u043a\u0438 \u0438\u043b\u0438 \u043c\u043e\u0434\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 Every Compat, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0438 \u043c\u043e\u0433\u0443\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0438\u043c\u0435\u043d\u0430 \u0431\u043b\u043e\u043a\u043e\u0432.";
    }

    @Override
    public String errorCodigo1073741819() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 (-1073741819), \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u0437\u0432\u0430\u043d \u043e\u0432\u0435\u0440\u043b\u0435\u044f\u043c\u0438, \u0442\u0430\u043a\u0438\u043c\u0438 \u043a\u0430\u043a GameCaster \u043e\u0442 Razer, Discord, OBS Studio, \u0438\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u043c\u0438 \u0441 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430\u043c\u0438 NVIDIA.</b>";
    }

    @Override
    public String nombreDeErrorCodigo1073741819() {
        return "\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 -1073741819";
    }

    @Override
    public String pasoErrorCodigo1073741819() {
        return "\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043e\u0432\u0435\u0440\u043b\u0435\u0438, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a GameCaster, Discord \u0438\u043b\u0438 OBS Studio, \u0438 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u044b NVIDIA \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b.";
    }

    @Override
    public String errorImmersiveTooltipsSinDependencia() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Immersive Tooltips \u0442\u0440\u0435\u0431\u0443\u0435\u0442 Immersive Messages \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438, \u043d\u043e \u043e\u043d\u0430 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Immersive Messages, \u0447\u0442\u043e\u0431\u044b Immersive Tooltips \u0440\u0430\u0431\u043e\u0442\u0430\u043b \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e.</b>";
    }

    @Override
    public String nombreDeErrorImmersiveTooltipsSinDependencia() {
        return "Immersive Tooltips \u0431\u0435\u0437 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438";
    }

    @Override
    public String pasoErrorImmersiveTooltipsSinDependencia() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Immersive Messages, \u0442\u0430\u043a \u043a\u0430\u043a \u044d\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u0434\u043b\u044f Immersive Tooltips.";
    }

    @Override
    public String errorMedievalOriginsCast() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Medieval Origins \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u0441 Apoli Mod: ItemStack \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u0432\u0435\u0434\u0451\u043d (cast) \u043a EntityLinkedItemStack. \u042d\u0442\u043e \u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0432 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 \u043d\u043e\u0432\u0435\u0435 6.6.0. \u0420\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0431\u043e\u043b\u0435\u0435 \u0440\u0430\u043d\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043c\u0435\u0436\u0434\u0443 \u0432\u0435\u0440\u0441\u0438\u044f\u043c\u0438 \u0434\u043b\u044f Fabric \u0438 Forge.</b>";
    }

    @Override
    public String nombreDeErrorMedievalOriginsCast() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u043e\u0432 (cast) \u0432 Medieval Origins";
    }

    @Override
    public String pasoErrorMedievalOriginsCast() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 Medieval Origins \u0432\u0435\u0440\u0441\u0438\u0438 6.6.0 \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u0440\u0430\u043d\u043d\u044e\u044e, \u043b\u0438\u0431\u043e \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043c\u0435\u0436\u0434\u0443 \u0432\u0435\u0440\u0441\u0438\u044f\u043c\u0438 \u043c\u043e\u0434\u0430 \u0434\u043b\u044f Fabric \u0438 Forge.";
    }

    @Override
    public String errorReignOfNetherMusicManager() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Reign of Nether \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0443 \u0438\u0437-\u0437\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e Registry Object \u0432 MusicManager. \u042d\u0442\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u0432\u044f\u0437\u0430\u043d\u0430 \u0441 mixin MusicManager \u0438\u0437 Reign of Nether.</b>";
    }

    @Override
    public String nombreDeErrorReignOfNetherMusicManager() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 MusicManager \u0432 Reign of Nether";
    }

    @Override
    public String pasoErrorReignOfNetherMusicManager() {
        return "\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c Reign of Nether \u0438\u043b\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0435\u0433\u043e, \u0447\u0442\u043e\u0431\u044b \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0443.";
    }

    @Override
    public String errorYesSteveModelLinux() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>YesSteveModel \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440 YSM \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 Linux \u0438\u043b\u0438 Android. \u042d\u0442\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0431\u044b\u043b\u0430 \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 \u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 23 \u043d\u043e\u044f\u0431\u0440\u044f 2025 \u0433\u043e\u0434\u0430 \u043d\u0430 Modrinth.</b>";
    }

    @Override
    public String nombreDeErrorYesSteveModelLinux() {
        return "YesSteveModel \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 Linux";
    }

    @Override
    public String pasoErrorYesSteveModelLinux() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 YesSteveModel \u0434\u043e \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0441 Modrinth, \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0431\u044b\u043b\u0430 \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430 \u043f\u043e\u0441\u043b\u0435 23 \u043d\u043e\u044f\u0431\u0440\u044f.";
    }

    @Override
    public String errorConflictoMovingElevatorsOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 Moving Elevators \u0438 OptiFine. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0441\u0431\u043e\u0439 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044f, \u043f\u0440\u0435\u043f\u044f\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoMovingElevatorsOptiFine() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 Moving Elevators \u0438 OptiFine";
    }

    @Override
    public String pasoConflictoMovingElevatorsOptiFine() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine \u0438\u043b\u0438 Moving Elevators, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c.";
    }

    @Override
    public String errorConflictoFabricAPIOptiFine() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 Fabric API (fabric-resource-loader-v0) \u0438 OptiFine. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442 \u0441\u0431\u043e\u0439 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044f, \u043f\u0440\u0435\u043f\u044f\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a\u0443 \u0438\u0433\u0440\u044b.</b>";
    }

    @Override
    public String nombreDeConflictoFabricAPIOptiFine() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 Fabric API \u0438 OptiFine";
    }

    @Override
    public String pasoConflictoFabricAPIOptiFine() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine \u0438\u043b\u0438 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 Fabric API \u0434\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438.";
    }

    @Override
    public String errorModLauncherTransformationService(String claseProveedor) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u043c\u043e\u0434\u043e\u0432 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b\u0439 ITransformationService, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c: " + claseProveedor + ". \u042d\u0442\u043e\u0442 \u043c\u043e\u0434 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0447\u0442\u043e\u0431\u044b \u0438\u0433\u0440\u0430 \u0441\u043c\u043e\u0433\u043b\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c\u0441\u044f.</b>";
    }

    @Override
    public String nombreDeErrorModLauncherTransformationService() {
        return "\u041d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b\u0439 ITransformationService";
    }

    @Override
    public String pasoErrorModLauncherTransformationService(String claseProveedor) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043c\u043e\u0434, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u043a\u043b\u0430\u0441\u0441 " + claseProveedor + ", \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b\u0439 ITransformationService.";
    }

    @Override
    public String errorVersionInvalidaMod(String version) {
        return "<span style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0434\u0438\u043d \u0438\u0437 \u043c\u043e\u0434\u043e\u0432 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0443\u044e \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044e \u0432\u0435\u0440\u0441\u0438\u0438. \u0412\u0435\u0440\u0441\u0438\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0432 \u043a\u0432\u0430\u0434\u0440\u0430\u0442\u043d\u044b\u0435 \u0441\u043a\u043e\u0431\u043a\u0438. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0443\u0442\u0438\u043b\u0438\u0442\u0443 grep/greprf \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0432\u0435\u0440\u0441\u0438\u0438 </span>" + version + "<span style='color:#" + this.config.obtenerColorError() + "'>, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u0432 \u043a\u0430\u043a\u043e\u043c \u043c\u043e\u0434\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430.</span>";
    }

    @Override
    public String nombreDeErrorVersionInvalidaMod() {
        return "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0432 \u043c\u043e\u0434\u0435";
    }

    @Override
    public String pasoErrorVersionInvalidaMod() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0443\u0442\u0438\u043b\u0438\u0442\u0443 grep/greprf \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c, \u0432 \u043a\u0430\u043a\u043e\u043c \u043c\u043e\u0434\u0435 \u043e\u043d\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f.";
    }

    @Override
    public String errorStackSmashingDetected() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 stack smashing, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430 \u043f\u0440\u043e\u0446\u0435\u0441\u0441. \u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u0437\u0432\u0430\u043d\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u043c\u0438 \u0441 Early Window \u0432 Forge/NeoForge/PillowMC \u0438\u043b\u0438 \u0441 LWJGL 3.2.2 \u0438 \u043d\u043e\u0432\u0435\u0435.</b>";
    }

    @Override
    public String nombreDeErrorStackSmashingDetected() {
        return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d Stack Smashing";
    }

    @Override
    public String pasoErrorStackSmashingDetected() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 Early Window \u0438 \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 LWJGL \u0438\u043b\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043c\u043e\u0434\u043e\u0432, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0441 \u0440\u0430\u043d\u043d\u0438\u043c \u043e\u043a\u043d\u043e\u043c.";
    }

    @Override
    public String errorVersionClaseGregTechEasyCore() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>GregTechEasyCore \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u043c\u043e\u0434\u043f\u0430\u043a\u0430 \u0438 \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0432 \u043e\u0431\u044b\u0447\u043d\u044b\u0445 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430\u0445, \u0442\u0430\u043a \u043a\u0430\u043a \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443.</b>";
    }

    @Override
    public String nombreDeErrorVersionClaseGregTechEasyCore() {
        return "GregTechEasyCore \u0441 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Java";
    }

    @Override
    public String pasoErrorVersionClaseGregTechEasyCore() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 GregTechEasyCore, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u043c\u043e\u0434\u043f\u0430\u043a\u0430 \u0438 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0432\u0430\u0448\u0435\u0439 \u043e\u0431\u044b\u0447\u043d\u043e\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439.";
    }

    @Override
    public String errorConflictoMoniLabsConnectorExtras() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 MoniLabs \u0438 Connector Extras, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u0441 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u043c\u0438 \u0432 KubeJS. \u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b \u0432 \u0441\u0432\u043e\u0438\u0445 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f\u0445 KubeJS.</b>";
    }

    @Override
    public String nombreDeConflictoMoniLabsConnectorExtras() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 MoniLabs \u0438 Connector Extras";
    }

    @Override
    public String pasoConflictoMoniLabsConnectorExtras() {
        return "\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u043c\u043e\u0434\u043e\u0432 (MoniLabs \u0438\u043b\u0438 Connector Extras), \u0442\u0430\u043a \u043a\u0430\u043a \u0438\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 KubeJS \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u044e\u0442.";
    }

    @Override
    public String errorCompatibilidadIrisDH() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Iris \u0442\u0440\u0435\u0431\u0443\u0435\u0442 Distant Horizons [2.0.4] \u0438\u043b\u0438 DH API \u0432\u0435\u0440\u0441\u0438\u0438 [1.1.0] \u0438\u043b\u0438 \u043d\u043e\u0432\u0435\u0435. \u041e\u0437\u043d\u0430\u043a\u043e\u043c\u044c\u0442\u0435\u0441\u044c \u0441 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e\u043c \u043f\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443 https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e, \u0447\u0442\u043e\u0431\u044b \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443.</b>";
    }

    @Override
    public String nombreDeErrorCompatibilidadIrisDH() {
        return "\u0421\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c Iris \u0438 Distant Horizons";
    }

    @Override
    public String pasoErrorCompatibilidadIrisDH() {
        return "\u041e\u0437\u043d\u0430\u043a\u043e\u043c\u044c\u0442\u0435\u0441\u044c \u0441 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e\u043c \u043f\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443 https://gist.github.com/Steveplays28/52db568f297ded527da56dbe6deeec0e \u0438 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 Iris \u0438 Distant Horizons \u0434\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u0439.";
    }

    @Override
    public String faltar_de_clases_minecraft() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b Minecraft. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0423 \u0432\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043c\u043e\u0434\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u0438\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 \u0438\u0433\u0440\u044b. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u043e\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f <a href='https://wagyourtail.xyz/Projects/MinecraftMappingViewer' target='_blank'>MinecraftMappingViewer</a>, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043b\u0438 \u043a\u043b\u0430\u0441\u0441 \u0432 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438.</li><li>\u0423 \u0432\u0430\u0441 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 Minecraft (\u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 CurseForge App, ModrinthApp/Theseus/Astralrinth \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432 \u043c\u043e\u0434\u043f\u0430\u043a\u043e\u0432). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e</a> \u043f\u043e \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0441 CurseForge.</li><li>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b\u0439 coremod (\u043f\u0440\u0438 \u0441\u0431\u043e\u0435 coremod \u043c\u043e\u0436\u0435\u0442 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u043a\u043b\u0430\u0441\u0441\u0430).</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String faltar_de_clases_dangerzone() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b DangerZone. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0423 \u0432\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043c\u043e\u0434\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u0438\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 \u0438\u0433\u0440\u044b.</li><li>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b\u0435 coremod'\u044b.</li><li>\u0423 \u0432\u0430\u0441 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0438\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430.</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String faltar_de_clases_featurecreep() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b FeatureCreep. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0423 \u0432\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043c\u043e\u0434\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u0438\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 FeatureCreep (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: ESR \u043f\u0440\u043e\u0442\u0438\u0432 Nightly \u0438\u043b\u0438 v4 \u043f\u0440\u043e\u0442\u0438\u0432 v12).</li><li>\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c FeatureCreep \u0441 CurseForge \u0438\u043b\u0438 MinecraftStorage.</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String faltar_de_clases_modlauncher() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b ModLauncher. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0412\u0430\u0448\u0438 \u043c\u043e\u0434\u044b \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 MinecraftForge, PillowMC \u0438\u043b\u0438 NeoForge (ModLauncher \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0441 \u044d\u0442\u0438\u043c\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u0430\u043c\u0438).</li><li>\u0414\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 modloader'\u043e\u0432.</li><li>\u0423 \u0432\u0430\u0441 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 (\u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 CurseForge App, ModrinthApp/Theseus/Astralrinth \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432 \u043c\u043e\u0434\u043f\u0430\u043a\u043e\u0432). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e</a> \u043f\u043e \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0441 CurseForge.</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String faltar_de_clases_minecraftforge() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b Minecraft Forge. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0412\u0430\u0448\u0438 \u043c\u043e\u0434\u044b \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 MinecraftForge.</li><li>\u0414\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 modloader'\u043e\u0432.</li><li>\u0423 \u0432\u0430\u0441 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 (\u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 CurseForge App, ModrinthApp/Theseus/Astralrinth \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432 \u043c\u043e\u0434\u043f\u0430\u043a\u043e\u0432). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e</a> \u043f\u043e \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0441 CurseForge.</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String faltar_de_clases_neoforged() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b NeoForge. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0412\u0430\u0448\u0438 \u043c\u043e\u0434\u044b \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 NeoForge.</li><li>\u0414\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 modloader'\u043e\u0432.</li><li>\u0423 \u0432\u0430\u0441 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 (\u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 CurseForge App, ModrinthApp/Theseus/Astralrinth \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432 \u043c\u043e\u0434\u043f\u0430\u043a\u043e\u0432). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e</a> \u043f\u043e \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0441 CurseForge.</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String faltar_de_clases_fabricloader() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b Fabric Loader. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0412\u0430\u0448\u0438 \u043c\u043e\u0434\u044b \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 Fabric Loader.</li><li>\u0414\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 modloader'\u043e\u0432.</li><li>\u0423 \u0432\u0430\u0441 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 (\u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 CurseForge App, ModrinthApp/Theseus/Astralrinth \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432 \u043c\u043e\u0434\u043f\u0430\u043a\u043e\u0432). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e</a> \u043f\u043e \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0441 CurseForge.</li><li>\u041c\u043d\u043e\u0433\u0438\u043c \u043c\u043e\u0434\u0430\u043c \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f Fabric API. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Fabric API, \u0435\u0441\u043b\u0438 \u044d\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e.</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String faltar_de_clases_pillowmc() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043b\u0430\u0441\u0441\u044b PillowMC. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b><ul><li>\u0412\u0430\u0448\u0438 \u043c\u043e\u0434\u044b \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 PillowMC.</li><li>\u0414\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 modloader'\u043e\u0432.</li><li>\u0423 \u0432\u0430\u0441 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 (\u0447\u0430\u0441\u0442\u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 CurseForge App, ModrinthApp/Theseus/Astralrinth \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432 \u043c\u043e\u0434\u043f\u0430\u043a\u043e\u0432). <a href='https://www.youtube.com/watch?v=EeAf_PKXl8c' target='_blank'>\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e</a> \u043f\u043e \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0441 CurseForge.</li></ul><p>\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr/fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b, \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438, \u0447\u0442\u043e \u0432 \u0438\u043c\u0435\u043d\u0430\u0445 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f '/'.</p>";
    }

    @Override
    public String uraniumLag() {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0423 \u0432\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043c\u043e\u0434, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0430\u043c\u0435\u0440\u0435\u043d\u043d\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043b\u0430\u0433\u0438. Uranium \u2014 \u044d\u0442\u043e \u043c\u043e\u0434 \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043b\u0430\u0433\u043e\u0432. \u041e\u043d \u043d\u0435 \u0432\u0441\u0435\u0433\u0434\u0430 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442 \u043a \u0441\u0431\u043e\u044f\u043c, \u043d\u043e \u0441\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0438\u0445.</b>";
    }

    @Override
    public String errorFallingAttackVersion() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Falling Attack \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u043a\u0430\u043a \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u0439 \u0441 1.19.*, \u043d\u043e \u043d\u0430 \u0441\u0430\u043c\u043e\u043c \u0434\u0435\u043b\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f 1.20.*, \u0447\u0442\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0443 \u00ab\u043a\u043b\u0430\u0441\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u00bb. \u041c\u043e\u0434 \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c DamageSources, \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043d\u0435\u0442 \u0432 \u0432\u0430\u0448\u0435\u0439 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft.</b>";
    }

    @Override
    public String nombreDeErrorFallingAttackVersion() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0435\u0440\u0441\u0438\u0438 Falling Attack";
    }

    @Override
    public String pasoErrorFallingAttackVersion() {
        return "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e Falling Attack, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft.";
    }

    @Override
    public String necesitasInstalarCfr() {
        String sistema = System.getProperty("os.name").toLowerCase();
        StringBuilder mensaje = new StringBuilder();
        mensaje.append("<html>").append("\u0414\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c CFR (Class File Reader).<br><br>");
        if (sistema.contains("linux") || sistema.contains("netbsd") || sistema.contains("freebsd")) {
            mensaje.append("\u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u0430\u0445 Linux, NetBSD \u0438\u043b\u0438 FreeBSD \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c CFR \u0447\u0435\u0440\u0435\u0437 \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u043f\u0430\u043a\u0435\u0442\u043e\u0432.<br>").append("\u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0437\u0434\u0435\u0441\u044c: <a href=\"https://pkgs.org/search/?q=cfr\">https://pkgs.org/search/?q=cfr</a><br><br>");
        }
        mensaje.append("\u041b\u0438\u0431\u043e \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0451\u043d\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u0443\u044e FabricMC, \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435:<br>").append("<a href=\"https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar\">").append("https://maven.fabricmc.net/net/fabricmc/cfr/0.2.2/cfr-0.2.2.jar</a><br><br>").append("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0435\u0451 \u0432 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0443\u044e \u043f\u0430\u043f\u043a\u0443:<br>").append("<b>").append(new File(System.getProperty("user.home"), "crash_detector/cfr/").getAbsolutePath()).append("</b><br><br>").append("\u26a0\ufe0f <b>\u0412\u0430\u0436\u043d\u043e:</b> \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 CFR \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043c\u043e\u0434, \u0447\u0442\u043e\u0431\u044b \u043e\u043d \u0431\u044b\u043b \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u043d.").append("</html>");
        return mensaje.toString();
    }

    @Override
    public String cfrNoHayRetrato() {
        return "\u041f\u043e\u0440\u0442\u0440\u0435\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
    }

    @Override
    public String cfrClaseNoEncontrada(String nombreClase) {
        return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043b\u0430\u0441\u0441: " + nombreClase;
    }

    @Override
    public String tituloCfrSakura() {
        return "\u0414\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0442\u043e\u0440 CFR \u2013 Sakura Riddle (\u041d\u0435\u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0439)";
    }

    @Override
    public String cfrClaseActual() {
        return "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u043b\u0430\u0441\u0441";
    }

    @Override
    public String cfrRetratoDeSakura() {
        return "\u041f\u043e\u0440\u0442\u0440\u0435\u0442 Sakura Riddle";
    }

    @Override
    public String cfrErrorCargarRetrato() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u043e\u0440\u0442\u0440\u0435\u0442\u0430";
    }

    @Override
    public String noticiaLegalCFR() {
        return "\u042d\u0442\u043e\u0442 \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 (GUI) \u0434\u043b\u044f \u0434\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043c\u043e\u0434\u043e\u0432 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u043f\u043e\u043c\u043e\u0449\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c \u0432 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u0440\u0438\u0447\u0438\u043d \u0441\u0431\u043e\u0435\u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u043e\u0433\u043e \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f. \u041e\u0434\u043d\u0430\u043a\u043e \u0434\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u043c\u043e\u0434\u043e\u0432 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430, \u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0438\u0437\u0431\u0435\u0433\u0430\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0430 \u0434\u043b\u044f \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0431 \u0430\u0432\u0442\u043e\u0440\u0441\u043a\u043e\u043c \u043f\u0440\u0430\u0432\u0435. \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043e\u0437\u043d\u0430\u043a\u043e\u043c\u0438\u0442\u044c\u0441\u044f \u0441 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0435\u0439 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u043c\u043e\u0434\u0430 \u043f\u0435\u0440\u0435\u0434 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u043b\u044e\u0431\u043e\u0433\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0430. \u041a\u0440\u043e\u043c\u0435 \u0442\u043e\u0433\u043e, \u043c\u043d\u043e\u0433\u0438\u0435 \u043c\u043e\u0434\u044b \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0442 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u043a\u043e\u0434, \u043a\u043e\u0442\u043e\u0440\u044b\u0439, \u043a\u0430\u043a \u043f\u0440\u0430\u0432\u0438\u043b\u043e, \u0447\u0438\u0449\u0435 \u0438 \u043f\u0440\u043e\u0449\u0435 \u0434\u043b\u044f \u043f\u043e\u043d\u0438\u043c\u0430\u043d\u0438\u044f, \u0447\u0435\u043c \u0434\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439. \u041f\u043e\u043c\u043d\u0438\u0442\u0435: \u0443\u0432\u0430\u0436\u0435\u043d\u0438\u0435 \u0438\u043d\u0442\u0435\u043b\u043b\u0435\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0438 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u043e\u043d\u043d\u044b\u0445 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u2014 \u043e\u0441\u043d\u043e\u0432\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u0441\u0442\u0432\u0430 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u0432 \u043c\u043e\u0434\u043e\u0432. \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043a\u043e\u043d \u043e\u0431 \u0430\u0432\u0442\u043e\u0440\u0441\u043a\u043e\u043c \u043f\u0440\u0430\u0432\u0435 \u041c\u0435\u043a\u0441\u0438\u043a\u0438 \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435: <a href=\"https://www.diputados.gob.mx/LeyesBiblio/pdf/LFDA.pdf\" target=\"_blank\">Ley Federal de Derechos de Autor (\u043d\u0430 \u0438\u0441\u043f\u0430\u043d\u0441\u043a\u043e\u043c)</a> \u0438 \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435 \u0437\u0434\u0435\u0441\u044c: <a href=\"https://www.indautor.gob.mx/documentos/marco-juridico/L_Fed_Derecho_de_Autor_(English).pdf\" target=\"_blank\">Copyright Law (English)</a>. \u041f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u0432\u044b \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0435\u0441\u044c \u043d\u0430 CurseForge, \u043c\u044b \u0442\u0430\u043a\u0436\u0435 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0437\u0430\u043a\u043e\u043d \u0421\u0428\u0410 \u043e\u0431 \u0430\u0432\u0442\u043e\u0440\u0441\u043a\u043e\u043c \u043f\u0440\u0430\u0432\u0435: <a href=\"https://www.copyright.gov/title17/title17.pdf\" target=\"_blank\">U.S. Copyright Law</a>. \u041a\u0440\u043e\u043c\u0435 \u0442\u043e\u0433\u043e, \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0438\u0437\u0443\u0447\u0438\u0442\u044c \u0437\u0430\u043a\u043e\u043d\u044b, \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0432 \u0438\u0445 \u0441\u0442\u0440\u0430\u043d\u0435. \u041d\u0430\u0448 GUI \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u0442\u043e\u0439 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438; \u0434\u043b\u044f \u0443\u0433\u043b\u0443\u0431\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0444\u043e\u0440\u043a Enigma \u043e\u0442 FabricMC, \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0439 \u043d\u0430 <a href=\"https://github.com/FabricMC/Enigma\" target=\"_blank\">GitHub</a>. \u0415\u0441\u043b\u0438 \u0432\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c JAR-\u0444\u0430\u0439\u043b\u044b \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u0430\u0442\u0447\u0435\u0439 \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 Recaf \u043d\u0430 <a href=\"https://recaf.coley.software/home.html\" target=\"_blank\">\u0435\u0433\u043e \u0441\u0430\u0439\u0442\u0435</a>.";
    }

    @Override
    public String botonDescargarCfr() {
        return "\u0421\u043a\u0430\u0447\u0430\u0442\u044c CFR";
    }

    @Override
    public String botonAbrirCarpetaCfr() {
        return "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438";
    }

    @Override
    public String colorFondoPrincipal() {
        return "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0446\u0432\u0435\u0442 \u0444\u043e\u043d\u0430";
    }

    @Override
    public String colorTextoBotonReset() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043a\u043d\u043e\u043f\u043a\u0438 \u0441\u0431\u0440\u043e\u0441\u0430";
    }

    @Override
    public String colorTextoCampoBuscar() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043f\u043e\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430";
    }

    @Override
    public String colorTextoComboFiltro() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432\u044b\u043f\u0430\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043c\u0435\u043d\u044e \u0444\u0438\u043b\u044c\u0442\u0440\u0430";
    }

    @Override
    public String colorTextoRenderer() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u0440\u0435\u043d\u0434\u0435\u0440\u0435\u0440\u0430";
    }

    @Override
    public String colorTextoOverlayCarga() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043e\u0432\u0435\u0440\u043b\u0435\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438";
    }

    @Override
    public String colorBorde() {
        return "\u0426\u0432\u0435\u0442 \u0433\u0440\u0430\u043d\u0438\u0446\u044b";
    }

    @Override
    public String colorFondoRetrato() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u0432 \u043f\u043e\u0440\u0442\u0440\u0435\u0442\u043d\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435";
    }

    @Override
    public String colorEnlaceCompartir() {
        return "\u0426\u0432\u0435\u0442 \u0441\u0441\u044b\u043b\u043a\u0438 \u0434\u043b\u044f \u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0446\u0438\u0438";
    }

    @Override
    public String colorFondoCampoCompartir() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043f\u043e\u043b\u044f \u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0446\u0438\u0438";
    }

    @Override
    public String rosaFondo() {
        return "\u0420\u043e\u0437\u043e\u0432\u044b\u0439 \u0444\u043e\u043d";
    }

    @Override
    public String rosaSuave() {
        return "\u041d\u0435\u0436\u043d\u043e-\u0440\u043e\u0437\u043e\u0432\u044b\u0439";
    }

    @Override
    public String moradoAcento() {
        return "\u0410\u043a\u0446\u0435\u043d\u0442\u043d\u044b\u0439 \u0444\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u044b\u0439";
    }

    @Override
    public String textoOscuro() {
        return "\u0422\u0451\u043c\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442";
    }

    @Override
    public String bordeSuave() {
        return "\u041c\u044f\u0433\u043a\u0430\u044f \u0433\u0440\u0430\u043d\u0438\u0446\u0430";
    }

    @Override
    public String fondoCampo() {
        return "\u0424\u043e\u043d \u043f\u043e\u043b\u044f";
    }

    @Override
    public String fondoVistaPrevia() {
        return "\u0424\u043e\u043d \u043f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430";
    }

    @Override
    public String sintaxisConstructor() {
        return "\u0426\u0432\u0435\u0442 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441\u0430: \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440";
    }

    @Override
    public String sintaxisMensajeAyudar() {
        return "\u0426\u0432\u0435\u0442 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441\u0430: \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435";
    }

    @Override
    public String sintaxisEtiquetasHtml() {
        return "\u0426\u0432\u0435\u0442 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441\u0430: HTML-\u0442\u0435\u0433\u0438";
    }

    @Override
    public String colorFondoVentana() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043e\u043a\u043d\u0430";
    }

    @Override
    public String colorPanel() {
        return "\u0426\u0432\u0435\u0442 \u043f\u0430\u043d\u0435\u043b\u0438";
    }

    @Override
    public String colorBotonTexto() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043a\u043d\u043e\u043f\u043a\u0438";
    }

    @Override
    public String colorCampo() {
        return "\u0426\u0432\u0435\u0442 \u043f\u043e\u043b\u044f";
    }

    @Override
    public String colorBordeDestacado() {
        return "\u0426\u0432\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0433\u0440\u0430\u043d\u0438\u0446\u044b";
    }

    @Override
    public String colorSeleccionTexto() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430";
    }

    @Override
    public String colorTextoSeleccionado() {
        return "\u0426\u0432\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430";
    }

    @Override
    public String colorEstadoExito() {
        return "\u0426\u0432\u0435\u0442 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f: \u0443\u0441\u043f\u0435\u0445";
    }

    @Override
    public String colorEstadoFallo() {
        return "\u0426\u0432\u0435\u0442 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f: \u043e\u0448\u0438\u0431\u043a\u0430";
    }

    @Override
    public String colorEstadoInstantanea() {
        return "\u0426\u0432\u0435\u0442 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f: \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0435";
    }

    @Override
    public String colorResultadoAnadido() {
        return "\u0426\u0432\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430";
    }

    @Override
    public String colorResultadoEliminado() {
        return "\u0426\u0432\u0435\u0442 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430";
    }

    @Override
    public String colorBordeScroll() {
        return "\u0426\u0432\u0435\u0442 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u043e\u043b\u043e\u0441\u044b \u043f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0438";
    }

    @Override
    public String colorFondoPanel() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043f\u0430\u043d\u0435\u043b\u0438";
    }

    @Override
    public String colorBeigeListas() {
        return "\u0411\u0435\u0436\u0435\u0432\u044b\u0439 \u0441\u043f\u0438\u0441\u043a\u043e\u0432";
    }

    @Override
    public String colorTextoListas() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432 \u0441\u043f\u0438\u0441\u043a\u0430\u0445";
    }

    @Override
    public String colorBordeListas() {
        return "\u0426\u0432\u0435\u0442 \u0433\u0440\u0430\u043d\u0438\u0446 \u0441\u043f\u0438\u0441\u043a\u043e\u0432";
    }

    @Override
    public String colorBotonFondo() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0438";
    }

    @Override
    public String colorBordeBoton() {
        return "\u0426\u0432\u0435\u0442 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u043a\u043d\u043e\u043f\u043a\u0438";
    }

    @Override
    public String colorDoradoTexto() {
        return "\u0417\u043e\u043b\u043e\u0442\u043e\u0439 \u0446\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430";
    }

    @Override
    public String colorPila() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0438 \u0441\u0442\u0435\u043a\u0430 (stack trace)";
    }

    @Override
    public String colorTextoPanel() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043f\u0430\u043d\u0435\u043b\u0438";
    }

    @Override
    public String colorTextoNegro() {
        return "\u0426\u0432\u0435\u0442 \u0447\u0451\u0440\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430";
    }

    @Override
    public String colorTextoPrincipal() {
        return "\u0426\u0432\u0435\u0442 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430";
    }

    @Override
    public String colorFondoResultados() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432";
    }

    @Override
    public String colorEstado() {
        return "\u0426\u0432\u0435\u0442 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f";
    }

    @Override
    public String colorTextoDescripcion() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f";
    }

    @Override
    public String colorTextoEstado() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f";
    }

    @Override
    public String colorTextoExtra() {
        return "\u0426\u0432\u0435\u0442 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430";
    }

    @Override
    public String colorSeparador() {
        return "\u0426\u0432\u0435\u0442 \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044f";
    }

    @Override
    public String problema_safe_fetch32_jdk17() {
        return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 <code>StubRoutines::SafeFetch32</code>. \u042d\u0442\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u0432 macOS \u0441 JDK 17.0.9 \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 JDK 17.0.10 \u0438 \u043d\u043e\u0432\u0435\u0435. https://github.com/async-profiler/async-profiler/issues/747 https://www.minecraftforum.net/forums/support/java-edition-support/3192465-issues-with-jre-17-0-9-in-macos-sonoma-14-2-1";
    }

    @Override
    public String nombre_problema_safe_fetch32_jdk17() {
        return "\u041d\u0430\u0442\u0438\u0432\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 SafeFetch32 \u0432 JDK 17.0.9 (macOS)";
    }

    @Override
    public String solucion_actualizar_jdk_macos() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 JDK \u0434\u043e \u0432\u0435\u0440\u0441\u0438\u0438 17.0.10 \u0438\u043b\u0438 \u0432\u044b\u0448\u0435 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 17.0.15).";
    }

    @Override
    public String solucion_usar_lanzador_con_jdk_actualizado() {
        return "\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 (MultiMC, Prism Launcher \u0438\u043b\u0438 TLauncher), \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u0435\u0433\u043e \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 JDK. \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u0437 \u043d\u0438\u0445 \u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u044e\u0442 JDK 17.0.15.";
    }

    @Override
    public String solucion_desactivar_spark_mod() {
        return "\u041c\u043e\u0434 Spark \u0442\u0430\u043a\u0436\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043e\u0448\u0438\u0431\u043a\u0443. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0435\u0433\u043e. https://www.reddit.com/r/fabricmc/comments/17snlol/game_crashing_when_creating_world/";
    }

    @Override
    public String problema_mcef_inicializacion_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 MCEF (Chromium Embedded Framework) \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u00ab\u0442\u0438\u0445\u043e\u0435\u00bb \u0437\u0430\u0432\u0438\u0441\u0430\u043d\u0438\u0435.</b><ul><li>MCEF \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0432 \u043a\u043e\u043d\u0446\u0435 \u043b\u043e\u0433\u0430, \u0447\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442, \u0447\u0442\u043e \u0438\u0433\u0440\u0430 \u0437\u0430\u0432\u0438\u0441\u043b\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438.</li><li>\u0418\u0437\u0432\u0435\u0441\u0442\u043d\u043e, \u0447\u0442\u043e \u044d\u0442\u043e\u0442 \u043c\u043e\u0434 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u0431\u043e\u0438 \u0432 Linux, macOS \u0438\u043b\u0438 \u0441 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u043c\u0438 \u0432\u0435\u0440\u0441\u0438\u044f\u043c\u0438 Java.</li><li>\u042f\u0432\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0435 \u0432\u0441\u0435\u0433\u0434\u0430, \u043d\u043e \u0438\u0433\u0440\u0430 \u0442\u0430\u043a \u0438 \u043d\u0435 \u0434\u043e\u0445\u043e\u0434\u0438\u0442 \u0434\u043e \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e.</li></ul><p>\u0415\u0441\u043b\u0438 \u0432\u0430\u043c \u043d\u0435 \u043d\u0443\u0436\u043d\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u043e\u0433\u043e \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0430 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0432\u0435\u0431-\u043a\u0430\u0440\u0442\u044b \u0438\u043b\u0438 \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b), \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043c\u043e\u0434.</p>";
    }

    @Override
    public String nombre_problema_mcef_inicializacion() {
        return "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 MCEF (\u043c\u043e\u0434 \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u043e\u0433\u043e \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0430)";
    }

    @Override
    public String solucion_eliminar_mod_mcef() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u043c\u043e\u0434\u0430 MCEF (\u0438\u0449\u0438\u0442\u0435 'mcef' \u0432 \u0438\u043c\u0435\u043d\u0438 \u0444\u0430\u0439\u043b\u0430) \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 'mods'.";
    }

    @Override
    public String solucion_verificar_compatibilidad_mcef() {
        return "\u0415\u0441\u043b\u0438 \u043e\u043d \u0432\u0430\u043c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u043d\u0443\u0436\u0435\u043d, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0438 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft.";
    }

    @Override
    public String conflicto_iris_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 <b>OptiFine</b> \u0438 <b>Iris/Oculus</b>.</b><ul><li>OptiFine \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433 Minecraft \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b\u043c \u043e\u0431\u0440\u0430\u0437\u043e\u043c \u0441 Iris \u0438\u043b\u0438 Oculus.</li><li>\u041e\u0448\u0438\u0431\u043a\u0430 <code>MixinLevelRenderer failed injection check</code> \u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 <code>mixins.iris.json</code> \u0438\u043b\u0438 <code>mixins.oculus.json</code>.</li></ul><p>\u042d\u0442\u0438 \u043c\u043e\u0434\u044b \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine, \u0447\u0442\u043e\u0431\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0448\u0435\u0439\u0434\u0435\u0440\u044b \u0441 Iris \u0438\u043b\u0438 Oculus.</p>";
    }

    @Override
    public String nombre_conflicto_iris_optifine() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 OptiFine \u0438 Iris/Oculus";
    }

    @Override
    public String solucion_eliminar_optifine() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0444\u0430\u0439\u043b OptiFine \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 'mods'.";
    }

    @Override
    public String solucion_usar_iris_sin_optifine() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 Iris \u0438\u043b\u0438 Oculus \u0431\u0435\u0437 OptiFine \u0434\u043b\u044f \u0441\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0448\u0435\u0439\u0434\u0435\u0440\u043e\u0432.";
    }

    @Override
    public String conflicto_modernfix_optifine_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 <b>ModernFix</b> \u0438 <b>OptiFine</b>.</b><ul><li>ModernFix \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 OptiFine, \u0442\u0430\u043a \u043a\u0430\u043a \u043b\u043e\u043c\u0430\u0435\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c Forge \u0438 \u0437\u0430\u043c\u0435\u0434\u043b\u044f\u0435\u0442 \u0437\u0430\u043f\u0443\u0441\u043a.</li><li>\u0421\u0430\u043c ModernFix \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0430\u0435\u0442: <i>\"Use of ModernFix with OptiFine is not supported\"</i>.</li></ul><p>\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0434\u0432\u0443\u0445 \u043c\u043e\u0434\u043e\u0432, \u0447\u0442\u043e\u0431\u044b \u0438\u0433\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u0430\u043b\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e.</p>";
    }

    @Override
    public String nombre_conflicto_modernfix_optifine() {
        return "\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043c\u0435\u0436\u0434\u0443 ModernFix \u0438 OptiFine";
    }

    @Override
    public String solucion_eliminar_optifine_o_modernfix() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 OptiFine \u0438\u043b\u0438 ModernFix \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 'mods'. \u0418\u0445 \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e.";
    }

    @Override
    public String solucion_usar_alternativa_modernfix() {
        return "\u0415\u0441\u043b\u0438 \u0432\u0430\u043c \u043d\u0443\u0436\u043d\u044b \u043e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u0438, \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e OptiFine \u0438\u043b\u0438 \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u0435 ModernFix \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u043b\u0451\u0433\u043a\u0438\u0435 \u043c\u043e\u0434\u044b, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a FerriteCore \u0438\u043b\u0438 EntityCulling.";
    }

    @Override
    public String error_clave_registro_mayusculas_html(String clave) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043a\u043b\u044e\u0447 \u0440\u0435\u0435\u0441\u0442\u0440\u0430 \u0441 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d\u043d\u044b\u043c\u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u0430\u043c\u0438.</b><ul><li><b>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0439 \u043a\u043b\u044e\u0447:</b> <code>" + this.escapeHtml(clave) + "</code></li><li>\u0412 Minecraft \u0432\u0441\u0435 \u043a\u043b\u044e\u0447\u0438 \u0440\u0435\u0435\u0441\u0442\u0440\u0430 (\u0442\u0435\u0433\u0438, \u0440\u0435\u0446\u0435\u043f\u0442\u044b, \u0434\u043e\u0441\u0442\u0438\u0436\u0435\u043d\u0438\u044f \u0438 \u0442. \u0434.) \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c <b>\u0441\u0442\u0440\u043e\u0447\u043d\u044b\u043c\u0438</b> \u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b, \u043f\u043e\u0434\u0447\u0451\u0440\u043a\u0438\u0432\u0430\u043d\u0438\u044f, \u0434\u0435\u0444\u0438\u0441\u044b \u0438 \u0441\u043b\u044d\u0448\u0438.</li><li>\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u044b\u0437\u0432\u0430\u043d\u0430 \u043d\u0435\u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u043c \u043c\u043e\u0434\u043e\u043c \u0438\u043b\u0438 \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b\u043c datapack'\u043e\u043c.</li></ul><p><b>\u0412\u0430\u0436\u043d\u044b\u0439 \u0441\u043e\u0432\u0435\u0442:</b> \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 <b>grepr</b> \u0438\u043b\u0438 <b>fgrepr</b> \u043d\u0430 \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438 \u0438 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e <b>\u00ab\u0418\u0441\u043a\u0430\u0442\u044c \u0432 JAR-\u0444\u0430\u0439\u043b\u0430\u0445\u00bb</b>, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u043c\u043e\u0434, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u044d\u0442\u043e\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043a\u043b\u044e\u0447.</p>";
    }

    @Override
    public String nombre_error_clave_registro_mayusculas() {
        return "\u041a\u043b\u044e\u0447 \u0440\u0435\u0435\u0441\u0442\u0440\u0430 \u0441 \u0437\u0430\u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0438\u043b\u0438 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u043c\u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u0430\u043c\u0438";
    }

    @Override
    public String solucion_buscar_clave_en_archivos() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 'grepr' \u0438\u043b\u0438 'fgrepr' \u0441 \u043e\u043f\u0446\u0438\u0435\u0439 \u00ab\u0418\u0441\u043a\u0430\u0442\u044c \u0432 JAR-\u0444\u0430\u0439\u043b\u0430\u0445\u00bb, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438 \u0432\u0438\u043d\u043e\u0432\u043d\u044b\u0439 \u043c\u043e\u0434.";
    }

    @Override
    public String solucion_eliminar_mod_reciente() {
        return "\u0415\u0441\u043b\u0438 \u043d\u0435 \u0443\u0434\u0430\u0451\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043c\u043e\u0434, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043d\u0435\u0434\u0430\u0432\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b, \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0442\u0435, \u0447\u0442\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u044e\u0442 \u0431\u043b\u043e\u043a\u0438, \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0438\u043b\u0438 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u044b.";
    }

    @Override
    public String error_entrypoint_fabric_html(String modNombre) {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u043e\u0434\u0430 <b>" + this.escapeHtml(modNombre) + "</b>.</b><ul><li>\u041c\u043e\u0434 \u043d\u0435 \u0441\u043c\u043e\u0433 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0441\u0432\u043e\u0438\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u043c\u0435\u043d\u044e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a).</li><li>\u042d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0438\u0437-\u0437\u0430 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u0441 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft, Fabric \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438.</li></ul><p>\u0415\u0441\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0438\u043b\u0438 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434 <b>" + this.escapeHtml(modNombre) + "</b>.</p>";
    }

    @Override
    public String nombre_error_entrypoint_fabric() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0430 (Fabric Entrypoint)";
    }

    @Override
    public String solucion_eliminar_mod(String modNombre) {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043c\u043e\u0434 '" + modNombre + "' \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 'mods'.";
    }

    @Override
    public String solucion_actualizar_mod(String modNombre) {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043c\u043e\u0434 '" + modNombre + "' \u0434\u043e \u0432\u0435\u0440\u0441\u0438\u0438, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0441 \u0432\u0430\u0448\u0435\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439.";
    }

    @Override
    public String error_en_garde_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u0430\u044f \u0441 \u043c\u043e\u0434\u043e\u043c <b>En Garde!</b>.</b><ul><li>\u042d\u0442\u043e\u0442 \u043c\u043e\u0434 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u0442 \u043c\u0435\u0445\u0430\u043d\u0438\u043a\u0438 \u0431\u043b\u0438\u0436\u043d\u0435\u0433\u043e \u0431\u043e\u044f (\u043f\u0430\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435, \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u0438 \u0442. \u0434.).</li><li>\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u0438\u0437-\u0437\u0430 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u0431\u043e\u0435\u0432\u044b\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Epic Fight, DualRiders \u0438 \u0434\u0440.) \u0438\u043b\u0438 \u0438\u0437-\u0437\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435\u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e Minecraft.</li></ul><p>\u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u044b\u0439 \u0431\u043e\u0439, \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c \u0443\u0434\u0430\u043b\u0438\u0442\u044c En Garde!, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0435\u0436\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043e\u0432.</p>";
    }

    @Override
    public String nombre_error_en_garde() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043c\u043e\u0434\u0435 En Garde!";
    }

    @Override
    public String solucion_actualizar_en_garde() {
        return "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0432\u0435\u0440\u0441\u0438\u044e En Garde!, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u0441 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 Minecraft \u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u043e\u043c (Fabric/Forge).";
    }

    @Override
    public String solucion_eliminar_conflicto_mod_combate() {
        return "\u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u0431\u043e\u0435\u0432\u044b\u0435 \u043c\u043e\u0434\u044b (Epic Fight, Caelus \u0438 \u0434\u0440.), \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0438\u0445 \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 En Garde!, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0435\u0436\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043e\u0432.";
    }

    @Override
    public String error_idletweaks_html() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430, \u0432\u044b\u0437\u0432\u0430\u043d\u043d\u0430\u044f \u043c\u043e\u0434\u043e\u043c <b>IdleTweaks</b>.</b><ul><li>IdleTweaks \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u043e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0441\u0435\u0442\u0435\u0432\u043e\u0439 \u043a\u0430\u043d\u0430\u043b, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 (<code>Tried to release unknown channel</code>).</li><li>\u042d\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u0432 \u0441\u0442\u0430\u0440\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445 \u043c\u043e\u0434\u0430 \u0438\u043b\u0438 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u043d\u0430 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445.</li></ul><p>IdleTweaks \u2014 \u044d\u0442\u043e \u043c\u043e\u0434 \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0430 \u0436\u0438\u0437\u043d\u0438, \u043d\u043e \u043e\u043d \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c. \u0420\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0435\u0433\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f.</p>";
    }

    @Override
    public String nombre_error_idletweaks() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 IdleTweaks (\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0435\u0442\u0435\u0432\u043e\u0439 \u043a\u0430\u043d\u0430\u043b)";
    }

    @Override
    public String solucion_actualizar_idletweaks() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 IdleTweaks \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438, \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0441 \u0432\u0430\u0448\u0438\u043c Minecraft.";
    }

    @Override
    public String solucion_eliminar_idletweaks() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 IdleTweaks \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 'mods', \u0435\u0441\u043b\u0438 \u043e\u043d \u0432\u0430\u043c \u043d\u0435 \u043d\u0443\u0436\u0435\u043d.";
    }

    @Override
    public String mensagjePirataMC() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>Foi detectado um erro de autentica\u00e7\u00e3o (HTTP 401) ao tentar fazer login no Minecraft.</b><p>Esse erro <b>raramente \u00e9 a causa direta da falha</b>, mas indica que voc\u00ea est\u00e1 usando uma conta n\u00e3o autenticada (pirata).</p><p>Canais oficiais de suporte (projetos corporativos, VTubers, criadores de modpacks, etc.) <b>n\u00e3o podem ajud\u00e1-lo</b> se voc\u00ea usar uma c\u00f3pia pirata, devido a restri\u00e7\u00f5es em suas regras de chat, contratos, acordos com Mojang/Microsoft ou pol\u00edticas de reputa\u00e7\u00e3o.</p><p>Essa verifica\u00e7\u00e3o pode ser <b>desativada nas configura\u00e7\u00f5es corporativas</b> do detector. Aviso: a detec\u00e7\u00e3o antipirataria <b>n\u00e3o \u00e9 perfeita</b> e pode ser acionada em ambientes de desenvolvimento, com internet inst\u00e1vel ou ao usar launchers modificados.</p>";
    }

    @Override
    public String infoDeDerechosMiranda() {
        return "<b>Direitos Miranda se voc\u00ea tentar entrar no suporte mesmo assim:</b>";
    }

    @Override
    public String nombrePirataMC() {
        return "Minecraft pirata";
    }

    @Override
    public String desactivarVerificacionPirata() {
        return "Desativar verifica\u00e7\u00e3o antipirataria";
    }

    @Override
    public String comprarMC() {
        return "Comprar Minecraft";
    }

    @Override
    public String lanzer_no_animado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 <code>" + id + "</code>, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 <b>\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u043d\u044b\u0445</b>.</b>";
    }

    @Override
    public String lanzer_no_animado_problemas_comunes() {
        return "<p>\u0425\u043e\u0442\u044f \u043e\u043d \u043c\u043e\u0436\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c, \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u044b \u0447\u0430\u0441\u0442\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0442:</p><ul><li>\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043c\u043e\u0434\u043e\u0432 \u0438\u043b\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f.</li><li>\u0418\u0433\u0440\u0430 \u043d\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u0438\u043b\u0438 \u0437\u0430\u0432\u0438\u0441\u0430\u0435\u0442 \u0431\u0435\u0437 \u043f\u043e\u043d\u044f\u0442\u043d\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u0438.</li><li>\u041d\u0435\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0443\u044e \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443 \u043f\u0430\u043f\u043e\u043a (\u0437\u0430\u0442\u0440\u0443\u0434\u043d\u044f\u0435\u0442 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0443).</li><li>\u041d\u0435\u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0443\u0435\u043c\u043e\u0435 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0441 Java, \u043f\u0430\u043c\u044f\u0442\u044c\u044e \u0438\u043b\u0438 \u043c\u043e\u0434\u0430\u043c\u0438.</li></ul>";
    }

    @Override
    public String lanzer_no_animado_usar_animados() {
        return "\u0414\u043b\u044f \u043b\u0443\u0447\u0448\u0435\u0433\u043e \u043e\u043f\u044b\u0442\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432:";
    }

    @Override
    public String nombre_lanzer_no_animado() {
        return "\u041d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440";
    }

    @Override
    public String lanzer_no_animado_cambiar_a_animado() {
        return "\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u0441\u044c \u043d\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0438\u0437 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430.";
    }

    @Override
    public String lanzer_desanimado_titulo(String id) {
        return "<b style='color:#" + this.config.obtenerColorAdvertencia() + "'>\u0412\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 <b>\u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440</b>: <code>" + id + "</code>.</b>";
    }

    @Override
    public String lanzer_desanimado_problemas_comunes() {
        return "<p>\u041d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c:</p><ul><li>\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438\u043b\u0438 \u043c\u043e\u0434\u043e\u0432.</li><li>\u0418\u0433\u0440\u0430 \u043d\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u0438\u043b\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u0442\u0441\u044f \u0431\u0435\u0437 \u043e\u0448\u0438\u0431\u043a\u0438.</li><li>\u041d\u0435\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0443\u044e \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044e \u0444\u0430\u0439\u043b\u043e\u0432 (\u0441\u043b\u043e\u0436\u043d\u043e \u043e\u0442\u043b\u0430\u0436\u0438\u0432\u0430\u0442\u044c).</li><li>\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0441\u0442\u044c \u0432 \u0442\u043e\u043c, \u043a\u0430\u043a \u043e\u043d \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u0442 \u043c\u043e\u0434\u0430\u043c\u0438, Java \u0438\u043b\u0438 \u043f\u0430\u043c\u044f\u0442\u044c\u044e.</li></ul>";
    }

    @Override
    public String lanzer_desanimado_usar_animados() {
        return "\u041d\u0430\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u043d\u043e \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u043e\u0432:";
    }

    @Override
    public String nombre_lanzer_desanimado() {
        return "\u041d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440";
    }

    @Override
    public String lanzer_desanimado_cambiar_lanzer() {
        return "\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u0441\u044c \u043d\u0430 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0443.";
    }

    @Override
    public String falta_mod_animado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0414\u043b\u044f \u044d\u0442\u043e\u0439 \u0441\u0440\u0435\u0434\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b.</b>";
    }

    @Override
    public String nombre_falta_mod_animado() {
        return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b";
    }

    @Override
    public String falta_mod_animado_instalar() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b \u0434\u043b\u044f \u043e\u043f\u0442\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u043f\u044b\u0442\u0430.";
    }

    @Override
    public String tienes_mod_desanimado_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u0412 \u0432\u0430\u0448\u0435\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b.</b>";
    }

    @Override
    public String nombre_tienes_mod_desanimado() {
        return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b";
    }

    @Override
    public String tienes_mod_desanimado_eliminar() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0435\u0436\u0430\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c.";
    }

    @Override
    public String antimanipulacion_titulo() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0432\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u043e \u0432 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0444\u0430\u0439\u043b\u044b. \u0412\u044b \u043b\u0438\u0431\u043e \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0438 \u0444\u0430\u0439\u043b\u044b, \u043b\u0438\u0431\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 \u043d\u0435\u043d\u0430\u0434\u0451\u0436\u043d\u044b\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440.</b>";
    }

    @Override
    public String nombre_antimanipulacion() {
        return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0432\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u043e";
    }

    @Override
    public String antimanipulacion_reinstalar() {
        return "\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b, \u0447\u0442\u043e\u0431\u044b \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c.";
    }

    @Override
    public String configuracionCorporativa() {
        return "Configura\u00e7\u00f5es Corporativas";
    }

    @Override
    public String idiomaRespaldo() {
        return "Idioma de Fallback";
    }

    @Override
    public String buscardorHabilitado() {
        return "Habilitar Buscador";
    }

    @Override
    public String nombreHerramienta() {
        return "Nome da Ferramenta";
    }

    @Override
    public String condenarPirateria() {
        return "Condenar Pirataria";
    }

    @Override
    public String lanzadoresRecomendados() {
        return "Launchers Recomendados";
    }

    @Override
    public String lanzadoresDesaconsejados() {
        return "Launchers Desaconselhados";
    }

    @Override
    public String modsRecomendados() {
        return "Mods Recomendados";
    }

    @Override
    public String modsDesaconsejados() {
        return "Mods Desaconselhados";
    }

    @Override
    public String antiTamper() {
        return "AntiManipula\u00e7\u00e3o";
    }

    @Override
    public String proximamente() {
        return "Em breve";
    }

    @Override
    public String informacion() {
        return "Informa\u00e7\u00e3o";
    }

    @Override
    public String errorCargandoImagen() {
        return "Erro ao carregar imagem";
    }

    @Override
    public String configuracionBasica() {
        return "\u0411\u0430\u0437\u043e\u0432\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438";
    }

    @Override
    public String funcionalidades() {
        return "\u0424\u0443\u043d\u043a\u0446\u0438\u0438";
    }

    @Override
    public String derechosMiranda() {
        return "\u041f\u0440\u0430\u0432\u0430 \u041c\u0438\u0440\u0430\u043d\u0434\u044b (\u041d\u0410\u0421\u0422\u041e\u042f\u0422\u0415\u041b\u042c\u041d\u041e \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f)";
    }

    @Override
    public String gestionVerificaciones() {
        return "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\u043c\u0438";
    }

    @Override
    public String idVerificacion() {
        return "ID";
    }

    @Override
    public String nombreVerificacion() {
        return "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435";
    }

    @Override
    public String codigoVerificacion() {
        return "\u041a\u043e\u0434";
    }

    @Override
    public String documentacionVerificacion() {
        return "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u044f";
    }

    @Override
    public String verificacionesHabilitadas() {
        return "\u0412\u043a\u043b\u044e\u0447\u0451\u043d\u043d\u044b\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438:";
    }

    @Override
    public String verificacionesDeshabilitadas() {
        return "\u041e\u0442\u043a\u043b\u044e\u0447\u0451\u043d\u043d\u044b\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438:";
    }

    @Override
    public String deshabilitarNoCorporativas() {
        return "\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u0441\u0435 \u043d\u0435\u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0435";
    }

    @Override
    public String verCodigo() {
        return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043a\u043e\u0434";
    }

    @Override
    public String verDocumentacion() {
        return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u044e";
    }

    @Override
    public String seleccionaVerificacionDeshabilitar() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String seleccionaVerificacionHabilitar() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0434\u043b\u044f \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String verificacionesNoCorporativasDeshabilitadas() {
        return "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e %d \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a, \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0445 \u0434\u043b\u044f \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f.";
    }

    @Override
    public String noVerificacionesNoCorporativas() {
        return "\u041d\u0435\u0442 \u043d\u0435\u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String operacionCompletada() {
        return "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430";
    }

    @Override
    public String mensajeAmaneKanata() {
        return "\u041c\u044b \u0441\u043a\u0443\u0447\u0430\u0435\u043c \u043f\u043e \u0442\u0435\u0431\u0435, Amane Kanata";
    }

    @Override
    public String colorVerificacionCorporativa() {
        return "\u0426\u0432\u0435\u0442 \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u0439 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438";
    }

    @Override
    public String nombreLanzador() {
        return "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430";
    }

    @Override
    public String motivo() {
        return "\u041f\u0440\u0438\u0447\u0438\u043d\u0430";
    }

    @Override
    public String lanzadoresNoRecomendados() {
        return "\u041d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u044b";
    }

    @Override
    public String moverADesaconsejados() {
        return "\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u043a\u0430\u043a \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439";
    }

    @Override
    public String moverARecomendados() {
        return "\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u043a\u0430\u043a \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439";
    }

    @Override
    public String guardarCambios() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f";
    }

    @Override
    public String cancelar() {
        return "\u041e\u0442\u043c\u0435\u043d\u0430";
    }

    @Override
    public String seleccionaLanzadorMover() {
        return "\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String cambiosGuardadosExitosamente() {
        return "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b!";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEs(String nombreLanzador) {
        return "Este lanzador no es recomendado debido a problemas de seguridad y estabilidad conocidos.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoEn(String nombreLanzador) {
        return "This launcher is not recommended due to known security and stability issues.";
    }

    @Override
    public String motivoDesaconsejoPredeterminadoPt(String nombreLanzador) {
        return "Este lan\u00e7ador n\u00e3o \u00e9 recomendado devido a problemas conhecidos de seguran\u00e7a e estabilidade.";
    }

    @Override
    public String razones() {
        return "\u041f\u0440\u0438\u0447\u0438\u043d\u044b";
    }

    @Override
    public String agregarLanzador() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440";
    }

    @Override
    public String quitarLanzador() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440";
    }

    @Override
    public String editarRazones() {
        return "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u044b";
    }

    @Override
    public String seleccionaLanzadorQuitar() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f.";
    }

    @Override
    public String seleccionaLanzadorEditar() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.";
    }

    @Override
    public String editarRazonesPara(String idLanzador) {
        return "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u044b \u0434\u043b\u044f " + idLanzador;
    }

    @Override
    public String agregarNuevoIdioma() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044f\u0437\u044b\u043a";
    }

    @Override
    public String aceptar() {
        return "\u041f\u0440\u0438\u043d\u044f\u0442\u044c";
    }

    @Override
    public String seleccionaCodigoIdioma() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u044f\u0437\u044b\u043a";
    }

    @Override
    public String lanzadoresRecomendadosAviso() {
        return "\u042d\u0442\u0438 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u044b \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u044b CrashDetector \u043a\u0430\u043a \u043d\u0430\u0434\u0451\u0436\u043d\u044b\u0435.";
    }

    @Override
    public String colorResultadoCorrecto() {
        return "\u041f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442";
    }

    @Override
    public String modsNoRecomendados() {
        return "\u041d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b";
    }

    @Override
    public String agregarMod() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043c\u043e\u0434";
    }

    @Override
    public String quitarMod() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434";
    }

    @Override
    public String modId() {
        return "ID \u043c\u043e\u0434\u0430 / \u0418\u043c\u044f JBoss Modules";
    }

    @Override
    public String rutaMod() {
        return "\u041f\u0443\u0442\u044c / \u0444\u0430\u0439\u043b \u043c\u043e\u0434\u0430";
    }

    @Override
    public String errorDebeIndicarMod() {
        return "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b modid \u0438\u043b\u0438 \u043f\u0443\u0442\u044c \u043a \u043c\u043e\u0434\u0443.";
    }

    @Override
    public String modsNoRecomendadosAviso() {
        return "\u0417\u0434\u0435\u0441\u044c \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0435 \u043c\u043e\u0434\u044b, \u0447\u0442\u043e\u0431\u044b CrashDetector \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u0432\u0430\u043b \u0438\u0445 \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435.";
    }

    @Override
    public String anularNormal() {
        return "\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c";
    }

    @Override
    public String anularNormalDescripcion() {
        return "CrashDetector \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0430\u0442\u044c, \u0434\u0430\u0436\u0435 \u0435\u0441\u043b\u0438 \u0441\u0431\u043e\u0439 \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u0451\u043b.";
    }

    @Override
    public String modsRecomendadosAviso() {
        return "\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0439\u0442\u0435 \u043c\u043e\u0434\u044b, \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u043d\u044b\u0435 CrashDetector. \u0415\u0441\u043b\u0438 \u043e\u043d\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442, CrashDetector \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0434\u0438\u0442\u044c \u0432\u0430\u0441.";
    }

    @Override
    public String descripcionDerechosPirateria() {
        return "\u0415\u0441\u043b\u0438 \u0432\u044b \u0440\u0435\u0448\u0438\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043e \u043f\u0438\u0440\u0430\u0442\u0441\u0442\u0432\u0435, \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u0434\u0435\u0441\u044c \u043f\u0440\u0430\u0432\u0430 \u043b\u0438\u0446\u0430, \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0443, \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043f\u0440\u0435\u0432\u0435\u043d\u0442\u0438\u0432\u043d\u043e\u0439 \u043c\u0435\u0440\u044b.\n\n\u0412\u043e\u043f\u0440\u0435\u043a\u0438 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0451\u043d\u043d\u043e\u043c\u0443 \u043c\u043d\u0435\u043d\u0438\u044e, \u043c\u043d\u043e\u0433\u0438\u0435 \u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u043a\u0430\u043d\u0430\u043b\u044b \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438 \u041d\u0415 \u0442\u0440\u0435\u0431\u0443\u044e\u0442 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0430\u043d\u0442\u0438\u043f\u0438\u0440\u0430\u0442\u0441\u043a\u0438\u0445 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u043f\u043e\u043c\u043e\u0449\u0438. \u041e\u0434\u043d\u0430\u043a\u043e \u0444\u0438\u043a\u0441\u0430\u0446\u0438\u044f \u044d\u0442\u0438\u0445 \u043f\u0440\u0430\u0432 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u043b\u0435\u0437\u043d\u0430, \u0435\u0441\u043b\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u0441\u0451 \u0436\u0435 \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0441\u044f \u0432 \u043a\u0430\u043d\u0430\u043b \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438.\n\n\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0440\u0438\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b, \u0442\u0430\u043a\u0438\u0435 \u043a\u0430\u043a \u00ab\u041f\u0430\u043c\u044f\u0442\u043a\u0430 \u043e\u0441\u043d\u043e\u0432\u043d\u044b\u0445 \u043f\u0440\u0430\u0432 \u0437\u0430\u0434\u0435\u0440\u0436\u0430\u043d\u043d\u043e\u0433\u043e\u00bb \u0432 \u041c\u0435\u043a\u0441\u0438\u043a\u0435:\nhttps://www.gob.mx/cms/uploads/attachment/file/342687/Cartilla_Derechos_b_sicos_del_detenido.pdf\n\n\u0410 \u0442\u0430\u043a\u0436\u0435 \u043d\u0430 \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u0438\u043c\u044b\u0435 \u043f\u0440\u0430\u0432\u043e\u0432\u044b\u0435 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u044b, \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u043c\u044b\u0435 \u0432 \u0434\u0440\u0443\u0433\u0438\u0445 \u0441\u0442\u0440\u0430\u043d\u0430\u0445, \u0432\u043a\u043b\u044e\u0447\u0430\u044f \u0421\u0428\u0410, \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0443\u044e \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u044e, \u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0443\u044e \u041d\u0430\u0440\u043e\u0434\u043d\u0443\u044e \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0443, \u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0443\u044e \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0443 \u0418\u0440\u0430\u043d \u0438 \u041a\u043e\u0440\u0435\u0439\u0441\u043a\u0443\u044e \u041d\u0430\u0440\u043e\u0434\u043d\u043e-\u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0443.\n\n\u041f\u0440\u0438\u043c\u0435\u0440\u044b \u043f\u0440\u0430\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0436\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c:\n\u2022 \u041f\u0440\u0430\u0432\u043e \u043d\u0435 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0435\u043d\u0443\u0436\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u0434\u043b\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438, \u0442\u0430\u043a\u0443\u044e \u043a\u0430\u043a \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440, \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 UUID.\n\u2022 \u041f\u0440\u0430\u0432\u043e \u043d\u0435 \u0441\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u0438\u0432 \u0441\u0435\u0431\u044f.\n\u2022 \u041f\u0440\u0430\u0432\u043e \u043e\u0442\u043a\u0430\u0437\u0430\u0442\u044c\u0441\u044f \u043e\u0442\u0432\u0435\u0447\u0430\u0442\u044c \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u044b, \u043d\u0435 \u043e\u0442\u043d\u043e\u0441\u044f\u0449\u0438\u0435\u0441\u044f \u043a \u0440\u0435\u0448\u0435\u043d\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b.\n\u2022 \u041f\u0440\u0430\u0432\u043e \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u0432\u043d\u0443\u0442\u0440\u0438 \u0447\u0430\u0442\u0430.\n\u2022 \u041f\u0440\u0430\u0432\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u0443\u044e \u0432 CrashDetector \u0444\u0443\u043d\u043a\u0446\u0438\u044e \u0430\u043d\u043e\u043d\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u0438 \u043b\u043e\u0433\u043e\u0432.\n\n\u042d\u0442\u043e\u0442 \u0442\u0435\u043a\u0441\u0442 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 HTML-\u043a\u043e\u043d\u0442\u0435\u043d\u0442.";
    }

    @Override
    public String editar() {
        return "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c";
    }

    @Override
    public String advertenciaHashLento() {
        return "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0430 \u0431\u043e\u043b\u044c\u0448\u0438\u0445 \u0444\u0430\u0439\u043b\u043e\u0432 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u0442\u043e\u043c\u0443, \u0447\u0442\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u0439\u043c\u0451\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043c\u0438\u043d\u0443\u0442. CrashDetector \u0434\u043e\u043b\u0436\u0435\u043d \u0432\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u0445\u0435\u0448 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u043f\u0435\u0440\u0435\u0434 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435\u043c. \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0437\u0430\u0449\u0438\u0449\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0440\u043e\u0433\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0444\u0430\u0439\u043b\u044b.";
    }

    @Override
    public String agregarArchivo() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0444\u0430\u0439\u043b";
    }

    @Override
    public String agregarCarpeta() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443";
    }

    @Override
    public String quitar() {
        return "\u0423\u0434\u0430\u043b\u0438\u0442\u044c";
    }

    @Override
    public String rutaArchivo() {
        return "\u041f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443";
    }

    @Override
    public String errorRutaFueraDirectorio() {
        return "\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043d\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u0438\u0433\u0440\u044b. \u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u0444\u0430\u0439\u043b\u044b \u0438 \u043f\u0430\u043f\u043a\u0438 \u0432\u043d\u0443\u0442\u0440\u0438 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u0438\u043b\u0438 \u0435\u0451 \u043f\u043e\u0434\u043a\u0430\u0442\u0430\u043b\u043e\u0433\u043e\u0432.";
    }

    @Override
    public String mensajeDeSylentBell() {
        return "<html><div style='width:150px; text-align:center;'>\u041c\u043d\u0435\u043d\u0438\u044f \u0438 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 Sylent Bell \u043d\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u0441 \u043d\u0430\u0448\u0438\u043c\u0438; \u043c\u044b \u043f\u0440\u043e\u0441\u0442\u043e \u043f\u043e\u0434\u0443\u043c\u0430\u043b\u0438, \u0447\u0442\u043e \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u0431\u0430\u0432\u043d\u043e \u0440\u0430\u0437\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0435\u0451 \u0437\u0434\u0435\u0441\u044c. CrashDetector \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0432\u0435\u0442\u0441\u043a\u0438\u043c.</div></html>";
    }

    @Override
    public String gmlIPV6() {
        return "<b style='color:#" + this.config.obtenerColorError() + "'>\u041c\u043e\u0434 GML (Groovy ModLoader) \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u044d\u0442\u0438\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0438 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u0447\u0430\u0441\u0442\u043e\u0439 \u043f\u0440\u0438\u0447\u0438\u043d\u043e\u0439 \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b.</b>";
    }

    @Override
    public String mensajeIndependenteFlywheel(Set<String> mods) {
        StringBuilder listaMods = new StringBuilder();
        if (!mods.isEmpty()) {
            for (String mod : mods) {
                listaMods.append("<li>").append(mod).append("</li>");
            }
        }
        String mensaje = "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 <i> Flywheel</i>.</b><p><b>Independent Flywheel \u0443\u0441\u0442\u0430\u0440\u0435\u043b (deprecated)</b> \u0438 \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0432 \u0441\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0432\u0435\u0440\u0441\u0438\u044f\u0445.</p><p>\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 <b>Create</b> <b>\u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u044e\u0442 Flywheel</b>, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0435\u0433\u043e \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438 \u0438 \u043e\u0448\u0438\u0431\u043a\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438.</p><p>\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0434\u044b, \u044f\u0432\u043d\u043e \u0437\u0430\u0432\u0438\u0441\u044f\u0449\u0438\u0435 \u043e\u0442  Flywheel, \u043c\u043e\u0433\u0443\u0442 <b>\u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c</b> \u0438\u043b\u0438 <b>\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e</b>. \u0412 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u044b\u0445 \u0441\u043b\u0443\u0447\u0430\u044f\u0445 \u043e\u043d\u0438 \u043c\u043e\u0433\u0443\u0442 \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c, \u0435\u0441\u043b\u0438 \u0432\u044b <b>\u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u0442\u0435 \u0444\u0430\u0439\u043b <code>mods.toml</code></b>, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b \u0432\u0435\u0440\u0441\u0438\u0439, \u0445\u043e\u0442\u044f \u044d\u0442\u043e <b>\u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f</b>.</p>" + (mods.isEmpty() ? "" : "<p><b>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 Flywheel:</b></p><ul>" + listaMods.toString() + "</ul>") + "<p>\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u043e\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u2014 <b>\u0443\u0434\u0430\u043b\u0438\u0442\u044c  Flywheel</b> \u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0435\u0440\u0441\u0438\u044e, \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u0443\u044e \u0432 Create.</p>";
        return mensaje;
    }

    @Override
    public String nombreIndependenteFlywheel() {
        return "\u041d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 Flywheel";
    }

    @Override
    public String mensajeFloralEnchantments() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>Foi detectado um erro relacionado ao mod <i>Floral Enchantments</i>.</b><p>O crash \u00e9 causado por uma falha interna do mod ao manipular dados do jogo, o que gera uma <b>NullPointerException</b> durante a execu\u00e7\u00e3o.</p><p>Esse problema geralmente \u00e9 resolvido atualizando ou removendo o mod.</p>";
    }

    @Override
    public String nombreFloralEnchantments() {
        return "Erro do Floral Enchantments";
    }

    @Override
    public String mixinExtrasDuplicados() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorAdvertencia() + "'>\u0423 \u0432\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0431\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 MixinExtras: NeoForge \u0438 \u043e\u0431\u044b\u0447\u043d\u0430\u044f. \u0415\u0441\u043b\u0438 \u0432\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 MinecraftForge, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e <a href='https://www.curseforge.com/minecraft/mc-mods/mixin-extras-neoforge-on-forge-fix' style='color: inherit;'>\u044d\u0442\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435</a>.</b>";
    }

    @Override
    public String mensajeIrisSombrasTerreno() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0442\u0435\u043d\u044f\u0445 \u043b\u0430\u043d\u0434\u0448\u0430\u0444\u0442\u0430 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0448\u0435\u0439\u0434\u0435\u0440\u043e\u0432 (Iris).</b><p>\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u0430\u0435\u0442 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u043d\u0433\u0430 \u043b\u0430\u043d\u0434\u0448\u0430\u0444\u0442\u0430.</p><p>\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f <b>\u043f\u043e\u043f\u0440\u043e\u0431\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0438\u0433\u0440\u0443 \u0431\u0435\u0437 \u0448\u0435\u0439\u0434\u0435\u0440\u043e\u0432</b> \u0438\u043b\u0438 \u0441\u043d\u0438\u0437\u0438\u0442\u044c \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u043e, \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 <b>Ultra</b>.</p>";
    }

    @Override
    public String nombreIrisSombrasTerreno() {
        return "\u0422\u0435\u043d\u0438 \u043b\u0430\u043d\u0434\u0448\u0430\u0444\u0442\u0430 (Iris)";
    }

    @Override
    public String mensajeTickLargoServidor() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0447\u0440\u0435\u0437\u043c\u0435\u0440\u043d\u043e \u0434\u043e\u043b\u0433\u0438\u0439 \u0442\u0438\u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0430.</b><p>\u042d\u0442\u043e \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442, \u0447\u0442\u043e \u0438\u0433\u0440\u0430 \u0437\u0430\u0432\u0438\u0441\u043b\u0430 \u043d\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u0432 \u043e\u0434\u043d\u043e\u043c \u0442\u0438\u043a\u0435.</p><p>\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f <b>\u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c thread dump</b>, \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0432 \u043b\u043e\u0433\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u0443.</p><p><b>\u0410\u043d\u0430\u043b\u0438\u0437 \u0441\u0442\u0435\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u043e\u0432 (Stack Trace)</b> \u043f\u043e\u043c\u043e\u0436\u0435\u0442 \u0432\u0430\u043c \u043d\u0430\u0439\u0442\u0438 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0437\u0430\u0432\u0438\u0441\u0430\u043d\u0438\u044f.</p><p>\u041a\u0440\u043e\u043c\u0435 \u0442\u043e\u0433\u043e, \u043a\u043d\u043e\u043f\u043a\u0430 <b>\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0432 \u043b\u043e\u0433\u0435</b> \u0432\u044b\u0434\u0435\u043b\u0438\u0442 \u043a\u0440\u0430\u0441\u043d\u044b\u043c \u0446\u0432\u0435\u0442\u043e\u043c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u044b\u0435 \u043c\u043e\u0434\u044b, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0437\u0430\u043f\u0438\u0441\u0438, \u043e\u043a\u0440\u0443\u0436\u0451\u043d\u043d\u044b\u0435 <code>$modid$</code>, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043e\u0431\u044b\u0447\u043d\u043e \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u044e\u0442 \u043d\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b. \u0414\u043b\u044f \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u0432 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c CPU-\u0441\u044d\u043c\u043f\u043b\u0435\u0440 \u0432 VisualVM. \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u0430\u0448 \u0441\u0435\u0440\u0432\u0435\u0440 \u0438\u043b\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043c\u043e\u0449\u043d\u044b\u0439 \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0445 \u043c\u043e\u0434\u043e\u0432 \u2014 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0432\u0441\u0435 \u043e\u043d\u0438 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e, \u043d\u043e \u0438\u0445 \u043f\u0440\u043e\u0441\u0442\u043e \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e.</p>";
    }

    @Override
    public String nombreTickLargoServidor() {
        return "\u0414\u043e\u043b\u0433\u0438\u0439 \u0442\u0438\u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0430";
    }

    @Override
    public String tituloLFPDPPP() {
        return "\u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043a\u043e\u043d \u043e \u0437\u0430\u0449\u0438\u0442\u0435 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0438\u0445\u0441\u044f \u0432 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0436\u0435\u043d\u0438\u0438 \u0447\u0430\u0441\u0442\u043d\u044b\u0445 \u043b\u0438\u0446";
    }

    @Override
    public String aceptarPermanentemente() {
        return "\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430";
    }

    @Override
    public String mensajeAdvertenciaIdiomaCoreano() {
        return "\u041a\u043e\u0440\u0435\u0439\u0441\u043a\u0438\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044e\u0436\u043d\u043e\u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0438\u0439 \u0441\u043b\u0435\u043d\u0433, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u0437\u0431\u0435\u0433\u0430\u0442\u044c \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0437\u0430\u043a\u043e\u043d\u043e\u043c. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043d\u043e\u0441\u0442\u0440\u0430\u043d\u043d\u043e\u0439 \u043b\u0435\u043a\u0441\u0438\u043a\u0438, \u043e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u0438\u0437 \u042e\u0433\u0430, \u0441\u0442\u0440\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0417\u0430\u043a\u043e\u043d\u043e\u043c \u043e \u0437\u0430\u0449\u0438\u0442\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u043d\u043e\u0433\u043e \u044f\u0437\u044b\u043a\u0430 \u041f\u0445\u0435\u043d\u044c\u044f\u043d\u0430.";
    }

    @Override
    public String enlaceDocumentacionIdiomaCoreano() {
        return "\u0414\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0437\u043d\u0430\u043a\u043e\u043c\u044c\u0442\u0435\u0441\u044c \u0441 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u043c \u0442\u0435\u043a\u0441\u0442\u043e\u043c \u0437\u0430\u043a\u043e\u043d\u0430: <a href='https://www.dailynk.com/english/wp-content/uploads/sites/2/2023/03/Pyongyang-Cultural-Language-Protection-Act_English-and-Korean-Versions_Daily-NK.pdf'>\u0417\u0430\u043a\u043e\u043d \u043e \u0437\u0430\u0449\u0438\u0442\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u043d\u043e\u0433\u043e \u044f\u0437\u044b\u043a\u0430 \u041f\u0445\u0435\u043d\u044c\u044f\u043d\u0430</a>";
    }

    @Override
    public String leerLeyCompleta() {
        return "\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043f\u043e\u043b\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u0437\u0430\u043a\u043e\u043d\u0430";
    }

    @Override
    public String errorAbriendoEnlace() {
        return "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u0441\u044b\u043b\u043a\u0438";
    }

    @Override
    public String actaProteccionIdiomaCultural() {
        return "\u0417\u0430\u043a\u043e\u043d \u043e \u0437\u0430\u0449\u0438\u0442\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u043d\u043e\u0433\u043e \u044f\u0437\u044b\u043a\u0430 \u041f\u0445\u0435\u043d\u044c\u044f\u043d\u0430";
    }

    @Override
    public String canarioTitulo() {
        return "\u041a\u0430\u043d\u0430\u0440\u0435\u0439\u043a\u0430 \u0441\u0443\u0434\u0435\u0431\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043a\u0430\u0437\u0430";
    }

    @Override
    public String canario1984Titulo() {
        return "1984 \u2014 \u041c\u043e\u043d\u0438\u0442\u043e\u0440 \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f";
    }

    @Override
    public String revisar() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c";
    }

    @Override
    public String cerrar() {
        return "\u0417\u0430\u043a\u0440\u044b\u0442\u044c";
    }

    @Override
    public String canarioTodoSeguro() {
        return "\u0412\u0441\u0435 \u0441\u043b\u0443\u0436\u0431\u044b \u0441\u043e\u043e\u0431\u0449\u0430\u044e\u0442 \u043e \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438.";
    }

    @Override
    public String canarioComprometido(int c) {
        return "\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: " + c + " \u0441\u043b\u0443\u0436\u0431(\u0430/\u044b) \u0441\u043e\u043e\u0431\u0449\u0430\u044e\u0442 \u043e \u043d\u0435\u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438.";
    }

    @Override
    public String colorAlerta() {
        return "\u0426\u0432\u0435\u0442 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u044f";
    }

    @Override
    public String opcionesMunidiales() {
        return "Op\u00e7\u00f5es Munidial";
    }

    @Override
    public String consentimientoLFPDPPP() {
        return "Consentimento LFPDPPP";
    }

    @Override
    public String habilitarTokenAccesoEnEntregar() {
        return "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0443 \u0442\u043e\u043a\u0435\u043d\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 Handoff \u0434\u043b\u044f ReLauncher (\u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f).";
    }

    @Override
    public String consolaDesarrollo() {
        return "Console de desenvolvimento";
    }

    @Override
    public String mundial() {
        return "\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439";
    }

    @Override
    public String ningun() {
        return "Nenhum";
    }

    public String consolaDesarrollador() {
        return "\u041a\u043e\u043d\u0441\u043e\u043b\u044c \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430";
    }

    @Override
    public String bajar() {
        return "\u0421\u043a\u0430\u0447\u0430\u0442\u044c";
    }

    @Override
    public String logsSoporte() {
        return "\u041b\u043e\u0433\u0438 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438";
    }

    @Override
    public String detenerProceso() {
        return "\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0446\u0435\u0441\u0441";
    }

    @Override
    public String copiarSeleccion() {
        return "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435";
    }

    @Override
    public String seleccionarTodo() {
        return "\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0441\u0451";
    }

    @Override
    public String copiarTodo() {
        return "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0451";
    }

    @Override
    public String guardarTodoComoArchivo() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u0441\u0451 \u043a\u0430\u043a \u0444\u0430\u0439\u043b";
    }

    @Override
    public String obtenerEnlaceSoporte() {
        return "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438";
    }

    @Override
    public String borrarTodo() {
        return "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0451";
    }

    public String colorFondoConsola() {
        return "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u0438";
    }

    public String colorTextoConsola() {
        return "\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u0438";
    }

    @Override
    public String consentimientoConfirmadoPendienteImplementacion() {
        return "\u0421\u043e\u0433\u043b\u0430\u0441\u0438\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043e.\n\u0418\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044f \u0434\u043b\u044f \u043e\u0431\u043c\u0435\u043d\u0430 \u043b\u043e\u0433\u0430\u043c\u0438 \u0431\u0443\u0434\u0435\u0442 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u0430 \u0437\u0434\u0435\u0441\u044c.";
    }

    @Override
    public String usarSakuraOriginal() {
        return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 Sakura Riddle";
    }

    @Override
    public String canario1984Descripcion() {
        return "\u00ab\u041a\u0430\u043d\u0430\u0440\u0435\u0439\u043a\u0430 \u0441\u0443\u0434\u0435\u0431\u043d\u043e\u0433\u043e \u043e\u0440\u0434\u0435\u0440\u0430\u00bb (warrant canary) \u2014 \u044d\u0442\u043e \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c \u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u043e\u0441\u0442\u0438.\n\n\u041f\u043e\u043a\u0430 \u044d\u0442\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438 \u0441\u043b\u0443\u0436\u0431\u044b \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u044e\u0442\u0441\u044f \u043a\u0430\u043a \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u044b\u0435, \u044d\u0442\u043e \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442, \u0447\u0442\u043e \u043f\u0440\u043e\u0435\u043a\u0442 \u041d\u0415 \u043f\u043e\u043b\u0443\u0447\u0430\u043b \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0445 \u0441\u0443\u0434\u0435\u0431\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439, \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043e \u0446\u0435\u043d\u0437\u0443\u0440\u0435 \u0438\u043b\u0438 \u0437\u0430\u043a\u043e\u043d\u043d\u044b\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u043d\u0430 \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435.\n\n\u0415\u0441\u043b\u0438 \u043a\u0430\u043a\u0430\u044f-\u043b\u0438\u0431\u043e \u043a\u0430\u043d\u0430\u0440\u0435\u0439\u043a\u0430 \u0438\u0441\u0447\u0435\u0437\u043d\u0435\u0442 \u0438\u043b\u0438 \u0431\u0443\u0434\u0435\u0442 \u043f\u043e\u043c\u0435\u0447\u0435\u043d\u0430 \u043a\u0430\u043a \u043d\u0435\u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u0430\u044f, \u044d\u0442\u043e \u0443\u043a\u0430\u0436\u0435\u0442 \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u043e\u0432\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.\n\n\u042d\u0442\u0430 \u043f\u0430\u043d\u0435\u043b\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0432\u0441\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043a\u0430\u043d\u0430\u0440\u0435\u0439\u043a\u0438 \u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442 \u0438\u0445 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441.\n\n\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u00ab\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c\u00bb, \u0447\u0442\u043e\u0431\u044b \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441\u044b.";
    }

    @Override
    public String confirmacionReEstablarTodos() {
        return "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0432\u0441\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043a \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u043c \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e?";
    }

    @Override
    public String gui() {
        return "GUI";
    }

    @Override
    public String sinOpciones() {
        return "\u041d\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a";
    }

    @Override
    public String seleccionaColor() {
        return "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0446\u0432\u0435\u0442";
    }

    @Override
    public String botonMostrarGUI() {
        return "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c GUI";
    }

    @Override
    public String botonGuardarTodo() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u0441\u0451";
    }

    @Override
    public String botonRestablecerTodo() {
        return "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0432\u0441\u0451";
    }

    @Override
    public String nombreLuckPermsNoCargado() {
        return "LuckPerms \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d";
    }

    @Override
    public String mensajeLuckPermsNoCargado() {
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0438 \u043a API LuckPerms.</b><p>\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442, \u0447\u0442\u043e <b>LuckPerms \u043d\u0435 \u0431\u044b\u043b \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d</b> \u0432 \u043c\u043e\u043c\u0435\u043d\u0442, \u043a\u043e\u0433\u0434\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u043f\u043b\u0430\u0433\u0438\u043d \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c.</p><p><b>\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b:</b></p><ul><li>\u041f\u043b\u0430\u0433\u0438\u043d <b>LuckPerms \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d</b> \u0438\u043b\u0438 <b>\u043d\u0435 \u0441\u043c\u043e\u0433 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u0441\u044f</b>.</li><li>\u0414\u0440\u0443\u0433\u043e\u0439 \u043f\u043b\u0430\u0433\u0438\u043d \u043f\u044b\u0442\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a LuckPerms <b>\u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0440\u0430\u043d\u043e</b> \u0438\u043b\u0438 <b>\u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e</b>.</li></ul><p>\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f <b>\u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043a\u043e\u043d\u0441\u043e\u043b\u044c</b> \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u043b\u0430\u0433\u0438\u043d, \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0449\u0438\u0439 LuckPerms, \u0438 \u0443\u0431\u0435\u0434\u0438\u0442\u044c\u0441\u044f \u0432 \u0435\u0433\u043e \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438.</p>";
    }

    @Override
    public String nombreIrisShaderpackNoEncontrado() {
        return "\u0428\u0435\u0439\u0434\u0435\u0440\u043f\u0430\u043a Iris \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d";
    }

    @Override
    public String mensajeIrisShaderpackNoEncontrado(String shaderpack) {
        String nombre = shaderpack == null || shaderpack.isEmpty() ? "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d" : shaderpack;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u0435\u0439\u0434\u0435\u0440\u043f\u0430\u043a\u0430 \u0447\u0435\u0440\u0435\u0437 Iris/Oculus.</b><p><b>\u0417\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u044b\u0439 \u0448\u0435\u0439\u0434\u0435\u0440\u043f\u0430\u043a:</b> " + nombre + "</p><p>Minecraft \u043d\u0435 \u0441\u043c\u043e\u0433 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b \u0448\u0435\u0439\u0434\u0435\u0440\u043f\u0430\u043a\u0430 (FileSystemNotFoundException).</p><p><b>\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f:</b></p><ul><li>\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0448\u0435\u0439\u0434\u0435\u0440\u043f\u0430\u043a \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 \u043f\u0430\u043f\u043a\u0443 <b>shaderpacks</b>.</li><li>\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u0441\u043a\u0430\u0447\u0430\u0439\u0442\u0435 \u0448\u0435\u0439\u0434\u0435\u0440\u043f\u0430\u043a \u2014 \u0444\u0430\u0439\u043b \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d.</li><li>\u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0444\u0430\u0439\u043b <b>config/iris.properties</b>, \u0447\u0442\u043e\u0431\u044b \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 Iris.</li></ul><p>\u041f\u043e\u0441\u043b\u0435 \u0432\u043d\u0435\u0441\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0438\u0433\u0440\u0443.</p>";
    }

    @Override
    public String nombreNightConfigNoSePuedeEscribir() {
        return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438";
    }

    @Override
    public String mensajeNightConfigNoSePuedeEscribir(String ruta) {
        String archivo = ruta == null || ruta.isEmpty() ? "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d" : ruta;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.</b><p><b>\u0417\u0430\u0442\u0440\u043e\u043d\u0443\u0442\u044b\u0439 \u0444\u0430\u0439\u043b:</b> " + archivo + "</p><p>Minecraft \u043d\u0435 \u0441\u043c\u043e\u0433 \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0430\u0442\u043e\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 (REPLACE_ATOMIC).</p><p><b>\u042d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0438\u0437-\u0437\u0430:</b></p><ul><li>\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0445 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043f\u0430\u043f\u043a\u0435 \u0438\u043b\u0438 \u0444\u0430\u0439\u043b\u0443.</li><li>\u0424\u0430\u0439\u043b \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u043a\u0430\u043a \u00ab\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f\u00bb.</li><li>\u0414\u0440\u0443\u0433\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 (\u0430\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441, \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0435 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435, \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440) \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u0442 \u0444\u0430\u0439\u043b.</li></ul><p><b>\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u0438:</b></p><ul><li>\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0443 \u0432\u0430\u0441 \u0435\u0441\u0442\u044c \u043f\u0440\u0430\u0432\u0430 \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u043f\u0430\u043f\u043a\u0443.</li><li>\u0421\u043d\u0438\u043c\u0438\u0442\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u00ab\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f\u00bb \u0441 \u0444\u0430\u0439\u043b\u0430.</li><li>\u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u0444\u0430\u0439\u043b.</li></ul>";
    }

    @Override
    public String nombreAccesoDenegadoBackupConfig() {
        return "\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438";
    }

    @Override
    public String mensajeAccesoDenegadoBackupConfig(String origen, String backup) {
        String src = origen == null || origen.isEmpty() ? "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d" : origen;
        String dst = backup == null || backup.isEmpty() ? "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d" : backup;
        return "<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.</b><p><b>\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0444\u0430\u0439\u043b:</b> " + src + "</p><p><b>\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0439 \u0444\u0430\u0439\u043b:</b> " + dst + "</p><p>\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043b\u0430 \u0434\u043e\u0441\u0442\u0443\u043f \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.</p><p><b>\u042d\u0442\u043e \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0438\u0437-\u0437\u0430:</b></p><ul><li>\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u044b\u0445 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043f\u0430\u043f\u043a\u0435.</li><li>\u0424\u0430\u0439\u043b \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u043a\u0430\u043a \u00ab\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f\u00bb.</li><li>\u0414\u0440\u0443\u0433\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 (\u0430\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441, \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438, \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440) \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0444\u0430\u0439\u043b.</li></ul><p><b>\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u0438:</b></p><ul><li>\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043f\u0430\u043f\u043a\u0435 <b>config</b>.</li><li>\u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u0444\u0430\u0439\u043b.</li><li>\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0438\u043b\u0438 Minecraft \u043e\u0442 \u0438\u043c\u0435\u043d\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430.</li></ul>";
    }
}

