/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.json;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.json.JsonDMR;
import com.asbestosstar.crashdetector.json.JsonGson;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class Json {
    private static final Motor motor = Json.seleccionarMotor();

    public static Nodo leer(String json) {
        if (motor == null) {
            throw new IllegalStateException("No se encontro Gson ni JBoss DMR");
        }
        return motor.leer(json);
    }

    public static Nodo crearObjeto() {
        if (motor == null) {
            throw new IllegalStateException("No se encontro Gson ni JBoss DMR");
        }
        return motor.crearObjeto();
    }

    public static String escribir(Nodo nodo) {
        if (motor == null) {
            throw new IllegalStateException("No se encontro Gson ni JBoss DMR");
        }
        return motor.escribir(nodo);
    }

    public static String nombreMotor() {
        if (motor == null) {
            return "ninguno";
        }
        return motor.nombre();
    }

    private static Motor seleccionarMotor() {
        if (Json.claseExiste("com.google.gson.JsonElement")) {
            return new JsonGson();
        }
        if (Json.claseExiste("org.jboss.dmr.ModelNode")) {
            return new JsonDMR();
        }
        return null;
    }

    private static boolean claseExiste(String cn) {
        try {
            Class.forName(cn, false, Json.class.getClassLoader());
            CrashDetectorLogger.log("JSON clase " + cn);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static interface Motor {
        public String nombre();

        public Nodo leer(String var1);

        public Nodo crearObjeto();

        public String escribir(Nodo var1);

        public boolean esObjeto(Nodo var1);

        public boolean esArreglo(Nodo var1);

        public List<String> claves(Nodo var1);

        public Nodo obtener(Nodo var1, String var2);

        public boolean eliminar(Nodo var1, String var2);

        public Nodo poner(Nodo var1, Object var2);

        public Nodo agregar(Nodo var1, Object var2);

        public Nodo agregarNodo(Nodo var1, Nodo var2);

        public int tamano(Nodo var1);

        public Nodo en(Nodo var1, int var2);

        public String comoCadena(Nodo var1);

        public int comoEntero(Nodo var1);

        public long comoLargo(Nodo var1);

        public boolean comoBooleano(Nodo var1);

        public double comoDouble(Nodo var1);
    }

    public static class Nodo {
        public Object interno;
        final Motor motorRef;
        Object padre;
        String claveEnPadre;
        Integer indiceEnPadre;

        public Nodo(Object interno, Motor motorRef) {
            this.interno = interno;
            this.motorRef = motorRef;
        }

        public Nodo(Object interno, Motor motorRef, Object padre, String clave, Integer indice) {
            this.interno = interno;
            this.motorRef = motorRef;
            this.padre = padre;
            this.claveEnPadre = clave;
            this.indiceEnPadre = indice;
        }

        public boolean esObjeto() {
            return this.motorRef.esObjeto(this);
        }

        public boolean esArreglo() {
            return this.motorRef.esArreglo(this);
        }

        public List<String> claves() {
            return this.motorRef.claves(this);
        }

        public Nodo obtener(String nombre) {
            return this.motorRef.obtener(this, nombre);
        }

        public boolean eliminar(String nombre) {
            return this.motorRef.eliminar(this, nombre);
        }

        public Nodo poner(String valor) {
            return this.motorRef.poner(this, valor);
        }

        public Nodo poner(int valor) {
            return this.motorRef.poner(this, valor);
        }

        public Nodo poner(long valor) {
            return this.motorRef.poner(this, valor);
        }

        public Nodo poner(boolean valor) {
            return this.motorRef.poner(this, valor);
        }

        public Nodo poner(double valor) {
            return this.motorRef.poner(this, valor);
        }

        public Nodo poner(Nodo valorNodo) {
            return this.motorRef.poner(this, valorNodo);
        }

        public Nodo agregar(String valor) {
            return this.motorRef.agregar(this, valor);
        }

        public Nodo agregar(int valor) {
            return this.motorRef.agregar(this, valor);
        }

        public Nodo agregar(long valor) {
            return this.motorRef.agregar(this, valor);
        }

        public Nodo agregar(boolean valor) {
            return this.motorRef.agregar(this, valor);
        }

        public Nodo agregar(double valor) {
            return this.motorRef.agregar(this, valor);
        }

        public Nodo agregar(Nodo nodo) {
            return this.motorRef.agregarNodo(this, nodo);
        }

        public int tamano() {
            return this.motorRef.tamano(this);
        }

        public Nodo en(int indice) {
            return this.motorRef.en(this, indice);
        }

        public String comoCadena() {
            return this.motorRef.comoCadena(this);
        }

        public int comoEntero() {
            return this.motorRef.comoEntero(this);
        }

        public long comoLargo() {
            return this.motorRef.comoLargo(this);
        }

        public boolean comoBooleano() {
            return this.motorRef.comoBooleano(this);
        }

        public double comoDouble() {
            return this.motorRef.comoDouble(this);
        }

        public String escribir() {
            return this.motorRef.escribir(this);
        }

        public byte[] aBytesUtf8() {
            return this.escribir().getBytes(StandardCharsets.UTF_8);
        }
    }
}

