/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.limpiador;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.limpiador.LimpiadorDeRegistro;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class LimpiadorRegistroDeLauncherVainilla
implements LimpiadorDeRegistro {
    private List<Integer> mapeoLineasOriginales;
    private boolean mapeoValido;

    @Override
    public String limpiarConsola(String contento_de_consola) {
        CrashDetectorLogger.log("limpiar vainilla");
        String[] lineas_viejas = contento_de_consola.split(System.lineSeparator());
        ArrayList<String> lineas_limpias = new ArrayList<String>();
        this.mapeoLineasOriginales = new ArrayList<Integer>();
        for (int indice_original = 0; indice_original < lineas_viejas.length; ++indice_original) {
            String linea = lineas_viejas[indice_original];
            String lineaProcesada = LimpiadorRegistroDeLauncherVainilla.limpiarLinea(linea);
            String trim = lineaProcesada.trim();
            if (trim.isEmpty()) continue;
            lineas_limpias.add(lineaProcesada);
            this.mapeoLineasOriginales.add(indice_original);
        }
        this.mapeoValido = true;
        return String.join((CharSequence)System.lineSeparator(), lineas_limpias);
    }

    public static String limpiarLinea(String linea) {
        int finCorchete;
        if (linea.contains("LauncherAppRenderer.cpp")) {
            linea = "";
        }
        if (linea.contains("ControllerInterface.cpp")) {
            linea = "";
        }
        if (linea.contains("LauncherController.cpp")) {
            linea = "";
        }
        if (linea.contains("NetQueue.cpp")) {
            linea = "";
        }
        if (linea.contains("KeyMaker.cpp")) {
            linea = "";
        }
        if (linea.contains("GamecoreClientApi_win32.cpp")) {
            linea = "";
        }
        if (linea.contains("Sha1Cacher.cpp")) {
            linea = "";
        }
        if (linea.contains("Updating.cpp")) {
            linea = "";
        }
        if (linea.contains("Common.cpp")) {
            linea = "";
        }
        if (linea.contains("mainWindows.cpp")) {
            linea = "";
        }
        if (linea.contains("AzureUpdateTools.cpp")) {
            linea = "";
        }
        if (linea.contains("CoreUpdateSystemCheck.cpp")) {
            linea = "";
        }
        if (linea.contains("CurlNetQueue.cpp")) {
            linea = "";
        }
        if (linea.contains("TreatmentTagFetcher.cpp")) {
            linea = "";
        }
        if (linea.contains("main.cpp")) {
            linea = "";
        }
        if (linea.contains("StartLibrary.cpp")) {
            linea = "";
        }
        if (linea.contains("PreferencesManager.cpp")) {
            linea = "";
        }
        if (linea.contains("SkinManager.cpp")) {
            linea = "";
        }
        if (linea.contains("CefUI.cpp")) {
            linea = "";
        }
        if (linea.contains("main_context.cpp")) {
            linea = "";
        }
        if (linea.contains("root_window_manager.cpp")) {
            linea = "";
        }
        if (linea.contains("client_handler.cpp")) {
            linea = "";
        }
        if (linea.contains("JreManifestManager.cpp")) {
            linea = "";
        }
        if (linea.contains("PersistentReflectedStruct.h")) {
            linea = "";
        }
        if (linea.contains("GameVersionManager.cpp")) {
            linea = "";
        }
        if (linea.contains("Xal.lib")) {
            linea = "";
        }
        if (linea.contains("UserIdentity.cpp")) {
            linea = "";
        }
        if (linea.contains("MSIPatchInstaller.cpp")) {
            linea = "";
        }
        if (linea.contains("KeyMakerCache.cpp")) {
            linea = "";
        }
        if (linea.contains("UpdateChecking.cpp")) {
            linea = "";
        }
        if (linea.contains("LauncherMain.cpp")) {
            linea = "";
        }
        if (linea.contains("SettingsManager.cpp")) {
            linea = "";
        }
        if (linea.contains("Common_p.h")) {
            linea = "";
        }
        if (linea.contains("XalStorage.cpp")) {
            linea = "";
        }
        if (linea.contains("XalApi.cpp")) {
            linea = "";
        }
        if (linea.contains("XalContext.cpp")) {
            linea = "";
        }
        if (linea.contains("SentryAPI.cpp")) {
            linea = "";
        }
        if (linea.contains("CoreFileUtils.cpp")) {
            linea = "";
        }
        if (linea.contains("ProductInstance.cpp")) {
            linea = "";
        }
        if (linea.contains("UnifiedMSAAccounts.cpp")) {
            linea = "";
        }
        if (linea.contains("TelemetryEventSink_1DS.cpp")) {
            linea = "";
        }
        if (linea.contains("EntitlementsManager.cpp")) {
            linea = "";
        }
        if (linea.contains("TelemetryEventSink.cpp")) {
            linea = "";
        }
        if (linea.contains("PistonInstaller.cpp")) {
            linea = "";
        }
        if (linea.contains("CefUI.cpp")) {
            linea = "";
        }
        if (linea.contains("LauncherAppBrowser.cpp")) {
            linea = "";
        }
        if (linea.contains("MinecraftServicesApi.cpp")) {
            linea = "";
        }
        if (linea.contains("Auth.cpp")) {
            linea = "";
        }
        if (linea.startsWith("[") && (finCorchete = linea.indexOf(93)) != -1) {
            linea = linea.substring(finCorchete + 1);
        }
        linea = linea.replaceFirst("^\\s*Game/game \\(\\) Info", "");
        if ((linea = linea.trim()).startsWith("at ")) {
            linea = " " + linea;
        }
        if (linea.startsWith("Authorization:Bearer")) {
            linea = "";
        }
        if (linea.startsWith("Method:")) {
            linea = "";
        }
        if (linea.startsWith("Headers:")) {
            linea = "";
        }
        if (linea.startsWith("Content-Type:")) {
            linea = "";
        }
        if (linea.startsWith("Body:")) {
            linea = "";
        }
        if (linea.startsWith("Response")) {
            linea = "";
        }
        return linea;
    }

    public static List<String> limpiarLineas(Iterable<String> lineas) {
        ArrayList<String> resultado = new ArrayList<String>();
        for (String linea : lineas) {
            String lineaProcesada = LimpiadorRegistroDeLauncherVainilla.limpiarLinea(linea);
            String trim = lineaProcesada.trim();
            if (trim.isEmpty()) continue;
            resultado.add(lineaProcesada);
        }
        return resultado;
    }

    @Override
    public boolean predicado(Path archivo) {
        return archivo.toString().endsWith("launcher_log.txt");
    }

    @Override
    public int obtenerLineaOriginalDesdeLineaLimpiada(int linea_de_comenzar, int linea_nueva) {
        if (!this.mapeoValido || linea_nueva < 1 || linea_nueva > this.mapeoLineasOriginales.size()) {
            return -1;
        }
        int indice_nuevo = linea_nueva - 1;
        int indice_original = this.mapeoLineasOriginales.get(indice_nuevo);
        return indice_original + 1 + linea_de_comenzar;
    }
}

