/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.limpiador;

import com.asbestosstar.crashdetector.limpiador.LimpiadorDeRegistro;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LimpiadorRegistroLatestLog
implements LimpiadorDeRegistro {
    private static final String SEPARADOR_PREFIJO = "]: ";
    private static final Pattern AT_CON_TABS = Pattern.compile("^[\\t ]*at\\s+");
    private static final Pattern AT_CON_TRANSFORMADOR = Pattern.compile("^(\\s*)at\\s+(?:[A-Z_]+/)?(?:[^/]+/)+([\\w.$]+\\.[\\w$<>]+\\([^)]*\\))(.*)$");
    private static final Pattern BLOQUE_CLASE_METODO_LINEA = Pattern.compile("\\[[\\w.$]+:[\\w$<>]+:\\d+\\]:\\s*");
    private static final Pattern DOS_PUNTOS_INICIALES = Pattern.compile("^:\\s+");

    @Override
    public String limpiarConsola(String contenido) {
        if (contenido == null || contenido.isEmpty()) {
            return contenido;
        }
        String[] lineas = contenido.split("\n", -1);
        StringBuilder out = new StringBuilder(contenido.length());
        for (String linea : lineas) {
            int iSep = linea.indexOf(SEPARADOR_PREFIJO);
            String prefijo = null;
            String cuerpo = linea;
            if (iSep != -1) {
                prefijo = linea.substring(0, iSep + SEPARADOR_PREFIJO.length());
                cuerpo = linea.substring(iSep + SEPARADOR_PREFIJO.length());
            }
            if (this.esLineaTraza(cuerpo)) {
                String limpio = this.limpiarCuerpoTraza(cuerpo);
                out.append(limpio).append("\n");
                continue;
            }
            out.append(linea).append("\n");
        }
        return out.toString();
    }

    private boolean esLineaTraza(String cuerpo) {
        if (cuerpo == null || cuerpo.isEmpty()) {
            return false;
        }
        if (AT_CON_TABS.matcher(cuerpo).find()) {
            return true;
        }
        String sinBloques = BLOQUE_CLASE_METODO_LINEA.matcher(cuerpo).replaceAll("");
        if (AT_CON_TABS.matcher(sinBloques).find()) {
            return true;
        }
        if (cuerpo.contains(" at TRANSFORMER/") || cuerpo.contains(" at mixin/") || cuerpo.contains(" at MODULE/")) {
            return true;
        }
        return (cuerpo.startsWith("TRANSFORMER/") || cuerpo.startsWith("mixin/") || cuerpo.startsWith("MODULE/")) && cuerpo.contains(".java:") && cuerpo.contains("(") && cuerpo.contains(")");
    }

    private String limpiarCuerpoTraza(String cuerpo) {
        String trabajado = cuerpo;
        Matcher mTrans = AT_CON_TRANSFORMADOR.matcher(trabajado = BLOQUE_CLASE_METODO_LINEA.matcher(trabajado).replaceAll(""));
        if (mTrans.matches()) {
            trabajado = mTrans.group(1) + "at " + mTrans.group(2) + mTrans.group(3);
        }
        if (AT_CON_TABS.matcher(trabajado).find()) {
            trabajado = "  at " + trabajado.replaceFirst("^[\\t ]*at\\s+", "");
        } else if (trabajado.startsWith("at ")) {
            trabajado = "  " + trabajado;
        }
        trabajado = DOS_PUNTOS_INICIALES.matcher(trabajado).replaceFirst("");
        return trabajado;
    }

    @Override
    public boolean predicado(Path archivo) {
        return archivo != null && archivo.toString().endsWith("latest.log");
    }
}

