/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.mapas;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class QuadMap<K1, K2, K3, K4, V> {
    private final Map<QuadrupleKey<K1, K2, K3, K4>, V> map = new HashMap<QuadrupleKey<K1, K2, K3, K4>, V>();

    public void put(K1 key1, K2 key2, K3 key3, K4 key4, V value) {
        QuadrupleKey<K1, K2, K3, K4> quadKey = new QuadrupleKey<K1, K2, K3, K4>(key1, key2, key3, key4);
        this.map.put(quadKey, value);
    }

    public V get(K1 key1, K2 key2, K3 key3, K4 key4) {
        QuadrupleKey<K1, K2, K3, K4> quadKey = new QuadrupleKey<K1, K2, K3, K4>(key1, key2, key3, key4);
        return this.map.get(quadKey);
    }

    public boolean remove(K1 key1, K2 key2, K3 key3, K4 key4) {
        QuadrupleKey<K1, K2, K3, K4> quadKey = new QuadrupleKey<K1, K2, K3, K4>(key1, key2, key3, key4);
        return this.map.remove(quadKey) != null;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<QuadrupleKey<K1, K2, K3, K4>> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public Set<Map.Entry<QuadrupleKey<K1, K2, K3, K4>, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return "QuadMap{entries=" + this.map + '}';
    }

    public static class QuadrupleKey<K1, K2, K3, K4> {
        public final K1 key1;
        public final K2 key2;
        public final K3 key3;
        public final K4 key4;

        public QuadrupleKey(K1 key1, K2 key2, K3 key3, K4 key4) {
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
            this.key4 = key4;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QuadrupleKey)) {
                return false;
            }
            QuadrupleKey other = (QuadrupleKey)o;
            return Objects.equals(this.key1, other.key1) && Objects.equals(this.key2, other.key2) && Objects.equals(this.key3, other.key3) && Objects.equals(this.key4, other.key4);
        }

        public int hashCode() {
            return Objects.hash(this.key1, this.key2, this.key3, this.key4);
        }

        public String toString() {
            return "QuadrupleKey{k1=" + this.key1 + ", k2=" + this.key2 + ", k3=" + this.key3 + ", k4=" + this.key4 + '}';
        }
    }
}

