/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.mapas;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TriMap<K1, K2, K3, V> {
    private final Map<TripleKey<K1, K2, K3>, V> map = new HashMap<TripleKey<K1, K2, K3>, V>();

    public void put(K1 key1, K2 key2, K3 key3, V value) {
        TripleKey<K1, K2, K3> tripleKey = new TripleKey<K1, K2, K3>(key1, key2, key3);
        this.map.put(tripleKey, value);
    }

    public V get(K1 key1, K2 key2, K3 key3) {
        TripleKey<K1, K2, K3> tripleKey = new TripleKey<K1, K2, K3>(key1, key2, key3);
        return this.map.get(tripleKey);
    }

    public boolean remove(K1 key1, K2 key2, K3 key3) {
        TripleKey<K1, K2, K3> tripleKey = new TripleKey<K1, K2, K3>(key1, key2, key3);
        return this.map.remove(tripleKey) != null;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<TripleKey<K1, K2, K3>> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public Set<Map.Entry<TripleKey<K1, K2, K3>, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return "Trimap{entries=" + this.map + '}';
    }

    public static class TripleKey<K1, K2, K3> {
        public final K1 key1;
        public final K2 key2;
        public final K3 key3;

        public TripleKey(K1 key1, K2 key2, K3 key3) {
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TripleKey)) {
                return false;
            }
            TripleKey other = (TripleKey)o;
            return Objects.equals(this.key1, other.key1) && Objects.equals(this.key2, other.key2) && Objects.equals(this.key3, other.key3);
        }

        public int hashCode() {
            return Objects.hash(this.key1, this.key2, this.key3);
        }

        public String toString() {
            return "TripleKey{k1=" + this.key1 + ", k2=" + this.key2 + ", k3=" + this.key3 + '}';
        }
    }
}

