/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.parches;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.parches.Parche;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Set;

public class ConfigDeParches {
    private static final Path RUTA_ARCHIVO_CONFIG_PARCHES = Statics.carpeta.resolve("parches.properties");
    public static File archivoConfigParches = RUTA_ARCHIVO_CONFIG_PARCHES.toFile();
    private Properties propiedadesConfig = new Properties();
    private static ConfigDeParches instancia;

    private ConfigDeParches() {
        if (archivoConfigParches.exists()) {
            try (FileReader lector = new FileReader(archivoConfigParches);){
                this.propiedadesConfig.load(lector);
            }
            catch (IOException e) {
                System.err.println("Error al leer el archivo de configuraci\u00f3n de parches: " + e.getMessage());
            }
        }
        this.inicializarParchesFaltantes();
        this.guardar();
    }

    public static synchronized ConfigDeParches obtenerInstancia() {
        if (instancia == null) {
            instancia = new ConfigDeParches();
        }
        return instancia;
    }

    private void inicializarParchesFaltantes() {
        for (Parche<?> parche : Parche.parches) {
            String id = parche.id();
            if (this.propiedadesConfig.containsKey(id)) continue;
            this.propiedadesConfig.setProperty(id, String.valueOf(parche.predeterminado()));
        }
    }

    public void guardar() {
        archivoConfigParches.getParentFile().mkdirs();
        try (FileWriter escritor = new FileWriter(archivoConfigParches);){
            this.propiedadesConfig.store(escritor, "Configuraci\u00f3n de parches - Activaci\u00f3n por ID");
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error al guardar el archivo de configuraci\u00f3n de parches: " + e.getMessage());
        }
    }

    public boolean obtenerActivacion(String id) {
        String valor = this.propiedadesConfig.getProperty(id);
        return valor != null ? Boolean.parseBoolean(valor) : false;
    }

    public void guardarActivacion(String id, boolean activo) {
        this.propiedadesConfig.setProperty(id, String.valueOf(activo));
        this.guardar();
    }

    public Set<String> obtenerIDsParches() {
        return this.propiedadesConfig.stringPropertyNames();
    }

    public boolean estaActivo(String id) {
        return Boolean.parseBoolean(this.propiedadesConfig.getProperty(id, "false"));
    }

    public void establecerActivo(String id, boolean activo) {
        this.propiedadesConfig.setProperty(id, String.valueOf(activo));
        this.guardar();
    }

    public void asegurarParches() {
        boolean cambios = false;
        for (Parche<?> parche : Parche.parches) {
            String id = parche.id();
            if (this.propiedadesConfig.containsKey(id)) continue;
            this.propiedadesConfig.setProperty(id, String.valueOf(parche.predeterminado()));
            cambios = true;
        }
        if (cambios) {
            this.guardar();
        }
    }

    public Properties obtenerPropiedades() {
        return this.propiedadesConfig;
    }
}

