/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.parches;

import com.asbestosstar.crashdetector.parches.ConfigDeParches;
import com.asbestosstar.crashdetector.parches.ParcheClassNode;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;

public interface Parche<T> {
    public static final Set<Parche<?>> parches = new HashSet();

    public Set<String> clases();

    default public boolean activar() {
        return ConfigDeParches.obtenerInstancia().estaActivo(this.id());
    }

    default public boolean predeterminado() {
        return false;
    }

    public T parche(T var1, String var2);

    public Class<T> tipo();

    public Parche<T> nuevo();

    public String id();

    public String nombre_de_gui();

    public static <T> T aplicarParches(T contenido, String nombre) {
        if (contenido == null || nombre == null) {
            return contenido;
        }
        String nombre_codigo = nombre.replace("/", ".");
        Object resultado = contenido;
        for (Parche<?> parche : parches) {
            Parche<?> tipo;
            if (!parche.tipo().isAssignableFrom(resultado.getClass()) || !(tipo = parche).activar() || !tipo.clases().contains(nombre_codigo)) continue;
            resultado = tipo.nuevo().parche(resultado, nombre_codigo);
        }
        return resultado;
    }

    public static void applicarParches(ClassNode contento, String nombre) {
        if (contento == null || nombre == null) {
            return;
        }
        String nombre_codigo = nombre.replace("/", ".");
        for (Parche<?> parche : parches) {
            if (!(parche instanceof ParcheClassNode) || !parche.activar() || !parche.clases().contains(nombre_codigo)) continue;
            ParcheClassNode node = (ParcheClassNode)parche;
            node.nuevo().parche(contento, nombre_codigo);
        }
    }
}

