/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.parches.minecraft;

import com.asbestosstar.crashdetector.parches.Parche;
import com.asbestosstar.crashdetector.parches.ParcheClassNode;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ParcheSoyPirata
implements ParcheClassNode {
    public static final String id = "soy_pirata";
    public static File SOY_PIRATA = new File("soy_pirata");

    @Override
    public Set<String> clases() {
        HashSet<String> clases = new HashSet<String>();
        clases.add("com/mojang/authlib/yggdrasil/YggdrasilUserApiService");
        return clases;
    }

    @Override
    public Parche<ClassNode> nuevo() {
        return new ParcheSoyPirata();
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public String nombre_de_gui() {
        return "AntiPirata";
    }

    @Override
    public void parchClassNode(ClassNode node, String nombre) {
        for (MethodNode method : node.methods) {
            if (!"fetchProperties".equals(method.name) || !"()Lcom/mojang/authlib/minecraft/UserProperties;".equals(method.desc)) continue;
            this.inyectarLlamadaAntesDeThrow(method);
            return;
        }
    }

    private void inyectarLlamadaAntesDeThrow(MethodNode method) {
        for (AbstractInsnNode actual = method.instructions.getFirst(); actual != null; actual = actual.getNext()) {
            if (actual.getOpcode() != 182) continue;
            MethodInsnNode min = (MethodInsnNode)actual;
            if (!"toAuthenticationException".equals(min.name) || !"com/mojang/authlib/exceptions/MinecraftClientHttpException".equals(min.owner) || !"()Lcom/mojang/authlib/exceptions/AuthenticationException;".equals(min.desc)) continue;
            InsnList inyeccion = new InsnList();
            inyeccion.add((AbstractInsnNode)new MethodInsnNode(184, "com/asbestosstar/crashdetector/parches/minecraft/ParcheSoyPirate", "escribirArchivoSoyPirata", "()V", false));
            method.instructions.insertBefore(actual, inyeccion);
            return;
        }
    }

    public static void escribirArchivoSoyPirata() {
        try {
            SOY_PIRATA.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

