/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.parches.minecraft;

import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.parches.Parche;
import com.asbestosstar.crashdetector.parches.ParcheClassNode;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class TransformacionDeMinecraftCodigo0
implements ParcheClassNode {
    public boolean completa_servidor = false;
    public boolean completa_cliente = false;
    public static boolean tiene_clase_cliente = false;

    @Override
    public Set<String> clases() {
        HashSet<String> clases = new HashSet<String>();
        clases.add("net.minecraft.server.MinecraftServer");
        clases.add("game.Server");
        clases.add("game.Client");
        clases.add("net.minecraft.class_310");
        clases.add("net.minecraft.client.Minecraft");
        return clases;
    }

    @Override
    public void parchClassNode(ClassNode node, String nombre_de_clase) {
        if (nombre_de_clase.equals("net.minecraft.server.MinecraftServer") || nombre_de_clase.equals("game.Server")) {
            if (!this.completa_servidor && !this.completa_cliente) {
                node.methods.forEach(method -> {
                    String methodName = method.name;
                    String methodDesc = method.desc;
                    if ((methodName.equals("shutdown") || methodName.equals("stopServer") || methodName.equals("m_7041_") || methodName.equals("method_3782")) && methodDesc.equals("()V")) {
                        InsnList insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new InsnNode(4));
                        insnList.add((AbstractInsnNode)new MethodInsnNode(184, TransformacionDeMinecraftCodigo0.class.getCanonicalName().replace('.', '/'), "hechoArchivoDeCodigoError0", "(Z)V", false));
                        method.instructions.insert(insnList);
                    }
                });
                this.completa_servidor = true;
            }
        } else if (nombre_de_clase.equals("net.minecraft.client.Minecraft") || nombre_de_clase.equals("net.minecraft.class_310") || nombre_de_clase.equals("game.Client")) {
            tiene_clase_cliente = true;
            if (!this.completa_cliente) {
                node.methods.forEach(method -> {
                    String methodName = method.name;
                    String methodDesc = method.desc;
                    if ((methodName.equals("shutdown") || methodName.equals("stop") || methodName.equals("m_91395_") || methodName.equals("method_1592")) && methodDesc.equals("()V")) {
                        System.out.println("CD Transformando CLIENT");
                        InsnList insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new InsnNode(3));
                        insnList.add((AbstractInsnNode)new MethodInsnNode(184, TransformacionDeMinecraftCodigo0.class.getCanonicalName().replace('.', '/'), "hechoArchivoDeCodigoError0", "(Z)V", false));
                        method.instructions.insert(insnList);
                    }
                });
                this.completa_cliente = true;
            }
        }
    }

    public static void hechoArchivoDeCodigoError0(boolean es_servidor) {
        System.out.println("hechoArchivoDeCodigoError0 " + String.valueOf(es_servidor));
        if (!tiene_clase_cliente || !es_servidor) {
            try {
                MonitorDePID.ArchivoDeCodigoError0.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Parche<ClassNode> nuevo() {
        return new TransformacionDeMinecraftCodigo0();
    }

    @Override
    public String id() {
        return "transformacion_de_minecraft_codigo0";
    }

    @Override
    public String nombre_de_gui() {
        return MonitorDePID.idioma.transformacionDeMinecraftCodigo0();
    }

    @Override
    public boolean predeterminado() {
        return true;
    }
}

