/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.waifu;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.json.Json;
import com.asbestosstar.crashdetector.waifu.RespuestaWaifu;
import com.asbestosstar.crashdetector.waifu.VersionWaifu;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class WaifuAPI {
    private static final String GRAPHQL_URL = "https://api.waifu.neoforged.net/graphql  ";
    public static List<VersionWaifu> versiones = new ArrayList<VersionWaifu>();

    public static VersionWaifu obtainerVersion(String cargador, String version_del_juego) {
        for (VersionWaifu vers : versiones) {
            if (!vers.cargador.equals(cargador) || !vers.version_del_juego.equals(version_del_juego)) continue;
            return vers;
        }
        VersionWaifu ret = new VersionWaifu(cargador, version_del_juego);
        versiones.add(ret);
        return ret;
    }

    public static List<RespuestaWaifu.Mod> obtanerModDesdeClase(String clase, VersionWaifu version) {
        ArrayList<RespuestaWaifu.Mod> modsEncontrados = new ArrayList<RespuestaWaifu.Mod>();
        try {
            Json.Nodo edgesNodo;
            Json.Nodo classesNodo;
            Json.Nodo gameVersionNodo;
            String graphqlQuery = WaifuAPI.generarConsultaGraphQL(clase, version);
            String jsonResponse = WaifuAPI.enviarSolicitudGraphQL(graphqlQuery);
            Json.Nodo respuestaNodo = Json.leer(jsonResponse);
            Json.Nodo dataNodo = respuestaNodo.obtener("data");
            if (dataNodo != null && !dataNodo.comoCadena().equals("null") && (gameVersionNodo = dataNodo.obtener("gameVersion")) != null && !gameVersionNodo.comoCadena().equals("null") && (classesNodo = gameVersionNodo.obtener("classes")) != null && !classesNodo.comoCadena().equals("null") && (edgesNodo = classesNodo.obtener("edges")) != null && edgesNodo.esArreglo()) {
                for (int i = 0; i < edgesNodo.tamano(); ++i) {
                    Json.Nodo definitionsNodo;
                    Json.Nodo aristaNodo = edgesNodo.en(i);
                    Json.Nodo nodeNodo = aristaNodo.obtener("node");
                    if (nodeNodo == null || nodeNodo.comoCadena().equals("null") || (definitionsNodo = nodeNodo.obtener("definitions")) == null || !definitionsNodo.esArreglo()) continue;
                    for (int j = 0; j < definitionsNodo.tamano(); ++j) {
                        Json.Nodo modrinthIdNodo;
                        Json.Nodo defNodo = definitionsNodo.en(j);
                        Json.Nodo modNodo = defNodo.obtener("mod");
                        if (modNodo == null || modNodo.comoCadena().equals("null")) continue;
                        RespuestaWaifu.Mod mod = new RespuestaWaifu.Mod();
                        mod.name = modNodo.obtener("name").comoCadena();
                        Json.Nodo curseforgeIdNodo = modNodo.obtener("curseforgeProjectId");
                        if (curseforgeIdNodo.comoCadena() != null && !curseforgeIdNodo.comoCadena().equals("null")) {
                            mod.curseforgeProjectId = curseforgeIdNodo.comoEntero();
                        }
                        if ((modrinthIdNodo = modNodo.obtener("modrinthProjectId")).comoCadena() != null && !modrinthIdNodo.comoCadena().equals("null")) {
                            mod.modrinthProjectId = modrinthIdNodo.comoCadena();
                        }
                        modsEncontrados.add(mod);
                    }
                }
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
        }
        return modsEncontrados;
    }

    public static String generarConsultaGraphQL(String nombreClase, VersionWaifu version) {
        String cargador = version.cargador;
        String version_del_juego = version.version_del_juego;
        return String.format("query ModsWithClass {\n  gameVersion(loader: %s, version: \"%s\") {\n    classes(where: {name: {equals: \"%s\"}}, first: 1) {\n      edges {\n        node {\n          definitions {\n            mod {\n              name\n              curseforgeProjectId\n              modrinthProjectId\n            }\n          }\n        }\n      }\n    }\n  }\n}", cargador, version_del_juego, nombreClase);
    }

    public static String enviarSolicitudGraphQL(String query) throws IOException {
        URL url = new URL(GRAPHQL_URL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0");
        conn.setRequestProperty("Accept", "application/json, multipart/mixed");
        conn.setRequestProperty("Accept-Language", "es-MX,es;q=0.8,en-US;q=0.5,en;q=0.3");
        conn.setRequestProperty("Accept-Encoding", "gzip, deflate, br");
        conn.setRequestProperty("Referer", "https://api.waifu.neoforged.net/graphql.html  ");
        conn.setRequestProperty("Origin", "https://api.waifu.neoforged.net  ");
        conn.setRequestProperty("Connection", "keep-alive");
        conn.setDoOutput(true);
        Json.Nodo payload = Json.crearObjeto();
        payload.obtener("query").poner(query);
        payload.obtener("operationName").poner("ModsWithClass");
        String cuerpoJSON = payload.escribir();
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = cuerpoJSON.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int codigoRespuesta = conn.getResponseCode();
        if (codigoRespuesta != 200) {
            throw new IOException("Error HTTP: " + codigoRespuesta);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String linea;
            StringBuilder respuesta = new StringBuilder();
            while ((linea = br.readLine()) != null) {
                respuesta.append(linea);
            }
            String string = respuesta.toString();
            return string;
        }
    }

    static {
        versiones.add(new VersionWaifu("NeoForge", "1.21.1"));
        versiones.add(new VersionWaifu("NeoForge", "1.21.7"));
        versiones.add(new VersionWaifu("NeoForge", "1.21.5"));
        versiones.add(new VersionWaifu("NeoForge", "1.21.4"));
        versiones.add(new VersionWaifu("Fabric", "1.21.1"));
        versiones.add(new VersionWaifu("Forge", "1.20.1"));
    }
}

