/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.DungeonsMod;
import com.dainxt.dungeonsmod.init.EntityInit;
import com.dainxt.dungeonsmod.util.handlers.ConfigHandler;
import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import com.dainxt.dungeonsmod.world.gen.WorldGenCustomStructures;
import com.dainxt.dungeonsmod.world.storage.WorldCustomData;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;

public class EntityCrawler
extends EntityMob {
    int MAX_DISTANCE = 10;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final DataParameter<Boolean> HEAVY_ATTACK = EntityDataManager.func_187226_a(EntityCrawler.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FINISHER_ATTACK = EntityDataManager.func_187226_a(EntityCrawler.class, (DataSerializer)DataSerializers.field_187198_h);
    public ArrayList<BlockPos> HEART_PLACES;

    public EntityCrawler(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_70105_a(5.0f, 5.0f);
        this.field_70728_aV = 7000;
        this.func_110163_bv();
        if (!worldIn.field_72995_K) {
            this.HEART_PLACES = new ArrayList();
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.CRAWLER;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAVY_ATTACK, (Object)false);
        this.field_70180_af.func_187214_a(FINISHER_ATTACK, (Object)false);
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof ItemArmor) {
            if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
                stack.func_77966_a(Enchantments.field_180310_c, 8);
            }
            if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
                stack.func_77966_a(Enchantments.field_185300_i, 2);
                stack.func_77966_a(Enchantments.field_180309_e, 2);
            }
            if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD) {
                stack.func_77966_a(Enchantments.field_185298_f, 2);
            }
            if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
                stack.func_77966_a(Enchantments.field_92091_k, 3);
            }
        }
        return super.func_70099_a(stack, offsetY);
    }

    public boolean isHeavyAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(HEAVY_ATTACK);
    }

    public void setHeavyAttack(boolean attack) {
        this.func_184212_Q().func_187227_b(HEAVY_ATTACK, (Object)attack);
    }

    public boolean isFinisherAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(FINISHER_ATTACK);
    }

    public void setFinisherAttack(boolean attack) {
        this.func_184212_Q().func_187227_b(FINISHER_ATTACK, (Object)attack);
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        boolean flag = false;
        if (this.isHeavyAttacking()) {
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), (float)((double)((EntityLivingBase)entityIn).func_110143_aJ() * 0.75));
        } else if (this.isFinisherAttacking()) {
            float modAmount = 0.0f;
            if (entityIn instanceof EntityPlayer) {
                for (ItemStack stack : ((EntityPlayer)entityIn).field_71071_by.field_70462_a) {
                    if (stack.func_190926_b()) continue;
                    modAmount = (float)((double)modAmount + 0.1);
                }
            }
            modAmount = (float)((double)modAmount + (double)this.func_70032_d(entityIn) * 0.005);
            DungeonsMod.logger.info("A{}", (Object)Float.valueOf(modAmount));
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), modAmount);
        } else {
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        }
        if (flag) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70601_bi() {
        boolean flag = EntityInit.rareSpawn(this.func_70681_au(), ConfigHandler.spawnRates.Crawler, super.func_70601_bi());
        return flag;
    }

    public void func_70020_e(NBTTagCompound compound) {
        this.setHeavyAttack(compound.func_74767_n("HeavyAttack"));
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound nbt = compound.func_74775_l("heartPos");
            for (int i = 0; i < nbt.func_74762_e("index"); ++i) {
                this.HEART_PLACES.add(BlockPos.func_177969_a((long)nbt.func_74763_f("heart_" + i)));
            }
        }
        super.func_70020_e(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74757_a("HeavyAttack", this.isHeavyAttacking());
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound nbt = compound.func_74775_l("heartPos");
            nbt.func_74768_a("index", this.HEART_PLACES.size());
            for (int i = 0; i < this.HEART_PLACES.size(); ++i) {
                nbt.func_74772_a("heart_" + i, this.HEART_PLACES.get(i).func_177986_g());
            }
            compound.func_74782_a("heartPos", (NBTBase)nbt);
        }
        return super.func_189511_e(compound);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoFinisherAttack(this, 200, 30));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIDoHeavyAttack(this, 40, 50, 81));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, (Predicate)null));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityArrow) {
            ((EntityArrow)source.func_76364_f()).func_70240_a(0);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected float func_175134_bD() {
        return 0.8f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187745_eA;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187539_bB;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        for (BlockPos pos : this.HEART_PLACES) {
            if (pos.equals((Object)BlockPos.field_177992_a) || this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150451_bX) continue;
            this.func_70691_i(2.0f);
        }
        float distance = Float.MAX_VALUE;
        for (EntityPlayer player : this.bossInfo.func_186757_c()) {
            distance = Math.min(player.func_70032_d((Entity)this), distance);
        }
        if (distance > (float)this.MAX_DISTANCE) {
            this.func_70691_i(1.0f);
        }
        this.func_70691_i(0.4f);
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        WorldCustomData data = WorldCustomData.get(this.field_70170_p);
        data.dungeonData.resetData(WorldGenCustomStructures.THE_LAB);
    }

    class AIDoHeavyAttack
    extends EntityAIBase {
        int interval;
        int duration;
        int waitHome;
        int distance;
        int cooldown;
        int ticksSinceLastAttack;
        EntityCrawler attacker;

        public AIDoHeavyAttack(EntityCrawler entity, int interval, int cooldown, int duration) {
            this.interval = interval;
            this.duration = duration;
            this.cooldown = cooldown;
            this.attacker = entity;
            this.func_75248_a(3);
        }

        public void func_75251_c() {
            this.attacker.func_70095_a(false);
            this.ticksSinceLastAttack = 0;
            this.attacker.setHeavyAttack(false);
        }

        public void func_75246_d() {
            if (!this.attacker.func_70093_af()) {
                this.attacker.func_70095_a(true);
            }
            if (this.waitHome % this.interval == 0 && this.waitHome != 0) {
                this.attacker.func_70683_ar().func_75660_a();
            }
            if (this.attacker.field_70122_E) {
                List entities;
                if (this.waitHome % this.interval == 1 && this.waitHome != 1 && !(entities = this.attacker.field_70170_p.func_72872_a(EntityLivingBase.class, this.attacker.func_174813_aQ().func_186662_g(25.0))).isEmpty()) {
                    for (EntityLivingBase entity : entities) {
                        if (entity instanceof EntityCrawler) continue;
                        if (entity instanceof EntityPlayer) {
                            this.attacker.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
                        }
                        this.attacker.setHeavyAttack(true);
                        this.attacker.func_70652_k((Entity)entity);
                    }
                }
                ++this.waitHome;
            }
        }

        public boolean func_75250_a() {
            return ++this.ticksSinceLastAttack > this.cooldown && this.attacker.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            boolean flag = this.waitHome > this.duration;
            return !flag;
        }

        public void func_75249_e() {
            this.waitHome = 0;
        }
    }

    class AIDoFinisherAttack
    extends EntityAIBase {
        int duration;
        int waitHome;
        int distance;
        int cooldown;
        int ticksSinceLastAttack;
        EntityCrawler attacker;

        public AIDoFinisherAttack(EntityCrawler entity, int cooldown, int duration) {
            this.duration = duration;
            this.cooldown = cooldown;
            this.attacker = entity;
            this.func_75248_a(3);
        }

        public void func_75251_c() {
            this.ticksSinceLastAttack = 0;
            this.attacker.setFinisherAttack(false);
        }

        public void func_75246_d() {
            this.attacker.setFinisherAttack(true);
            if (this.attacker.field_70122_E) {
                List entities;
                if (this.waitHome >= this.duration && !(entities = this.attacker.field_70170_p.func_72872_a(EntityLivingBase.class, this.attacker.func_174813_aQ().func_186662_g(50.0))).isEmpty()) {
                    for (EntityLivingBase entity : entities) {
                        if (entity instanceof EntityCrawler) continue;
                        this.attacker.func_70652_k((Entity)entity);
                    }
                }
                ++this.waitHome;
            }
        }

        public boolean func_75250_a() {
            return ++this.ticksSinceLastAttack > this.cooldown && this.attacker.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            boolean flag = this.waitHome > this.duration;
            return !flag;
        }

        public void func_75249_e() {
            this.waitHome = 0;
        }
    }
}

