/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import com.dainxt.dungeonsmod.world.gen.WorldGenCustomStructures;
import com.dainxt.dungeonsmod.world.storage.WorldCustomData;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityDeserted
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Integer> FIRE_ARMOR_TIME = EntityDataManager.func_187226_a(EntityDeserted.class, (DataSerializer)DataSerializers.field_187192_b);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityDeserted(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 1000;
        this.func_110163_bv();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRE_ARMOR_TIME, (Object)0);
    }

    public int getFireArmor() {
        return (Integer)this.func_184212_Q().func_187225_a(FIRE_ARMOR_TIME);
    }

    public void setHaveFireArmor(int time) {
        this.func_184212_Q().func_187227_b(FIRE_ARMOR_TIME, (Object)time);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.DESERTED;
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof ItemSword) {
            stack.func_77966_a(Enchantments.field_185302_k, 32);
        }
        return super.func_70099_a(stack, offsetY);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        AxisAlignedBB boundingBox;
        if (this.getFireArmor() > 0) {
            amount *= 0.25f;
        }
        if (source.equals(DamageSource.field_76368_d)) {
            boundingBox = this.func_174813_aQ().func_186662_g(1.5);
            double d0 = boundingBox.field_72340_a + (boundingBox.field_72336_d - boundingBox.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d1 = boundingBox.field_72338_b + (boundingBox.field_72337_e - boundingBox.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d2 = boundingBox.field_72339_c + (boundingBox.field_72334_f - boundingBox.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            this.destroyBlocksInAABB(boundingBox, new Block[]{Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150467_bQ, Blocks.field_150347_e, Blocks.field_150348_b});
        }
        if (source.func_76364_f() instanceof EntityArrow) {
            ((EntityArrow)source.func_76364_f()).func_70240_a(0);
        }
        if (source.func_76347_k()) {
            this.setHaveFireArmor(100);
            if (this.func_70681_au().nextInt(3) == 0) {
                this.func_70691_i(amount * 2.0f);
            }
            boundingBox = this.func_174813_aQ().func_186662_g(2.0);
            this.destroyBlocksInAABB(boundingBox, new Block[]{Blocks.field_150480_ab, Blocks.field_150353_l, Blocks.field_150356_k});
        }
        if (source.equals(DamageSource.field_82728_o)) {
            BlockPos pos = this.func_180425_c();
            this.field_70170_p.func_175655_b(pos, false);
            super.func_70097_a(source, amount);
            this.healPerSecond(amount, 10);
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70072_I() {
        this.field_70171_ac = this.field_70170_p.func_72875_a(this.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151586_h);
        return this.field_70171_ac;
    }

    private void healPerSecond(float amount, int ticks) {
        int maxTicks = ticks;
        while (--ticks >= 0) {
            this.func_70691_i(amount / (float)maxTicks);
        }
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            float f = (this.field_70761_aq + 90.0f) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_76134_b((float)f);
            return this.field_70165_t + (double)f1 * 1.0;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double getHeadY(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 1.9 : this.field_70163_u + 2.2;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            float f = (this.field_70761_aq + 90.0f) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_76126_a((float)f);
            return this.field_70161_v + (double)f1 * 1.0;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    private void launchProjectiletoEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchProjectiletoCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchProjectiletoCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1024, new BlockPos((Entity)this), 0);
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        EntityLargeFireball entityfireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d3, d4, d5);
        entityfireball.field_92057_e = 0;
        entityfireball.field_70163_u = d1;
        entityfireball.field_70165_t = d0;
        entityfireball.field_70161_v = d2;
        this.field_70170_p.func_72838_d((Entity)entityfireball);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 7, 20.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, (Predicate)null));
    }

    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(140.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_70107_b((int)this.field_70165_t, this.field_70163_u, (int)this.field_70161_v);
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70636_d() {
        super.func_70636_d();
        BlockPos pos = this.func_180425_c();
        if (this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() == 0.0) {
            this.func_70105_a(1.0f, 1.0f);
        } else {
            this.func_70105_a(1.5f, 2.5f);
        }
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (!this.field_70170_p.field_72995_K && this.getFireArmor() > 0) {
            int time = this.getFireArmor();
            this.setHaveFireArmor(--time);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (distanceFactor <= 0.35f) {
            this.func_70652_k((Entity)target);
        }
        this.func_184609_a(EnumHand.OFF_HAND);
        this.launchProjectiletoEntity(0, target);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected void func_191955_a(IBlockState block) {
        if (block.func_177230_c() != Blocks.field_150350_a) {
            // empty if block
        }
        if (block.func_177230_c() == Blocks.field_150354_m) {
            AxisAlignedBB boundingBox = this.func_174813_aQ();
            this.destroyBlocksInAABB(boundingBox, new Block[]{Blocks.field_150354_m});
            this.func_70691_i(10.0f);
        }
        super.func_191955_a(block);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_, Block ... blockList) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos)) continue;
                    if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        flag = true;
                        continue;
                    }
                    if (block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) {
                        for (Block blockInList : blockList) {
                            if (block == blockInList) {
                                flag1 = this.field_70170_p.func_175698_g(blockpos) || flag1;
                                continue;
                            }
                            flag = true;
                        }
                        continue;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        WorldCustomData data = WorldCustomData.get(this.field_70170_p);
        data.dungeonData.resetData(WorldGenCustomStructures.THE_HOUSE);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187749_eC;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187751_eD;
    }

    class AIDoNothing
    extends EntityAIBase {
        EntityDeserted deserted;
        int weaken;

        public AIDoNothing(EntityDeserted entity) {
            this.deserted = entity;
            this.func_75248_a(7);
        }

        public void func_75251_c() {
            super.func_75251_c();
            AxisAlignedBB boundingBox = this.deserted.func_174813_aQ().func_186662_g(3.0);
            EntityDeserted.this.destroyBlocksInAABB(boundingBox, new Block[]{Blocks.field_150355_j, Blocks.field_150358_i});
            this.deserted.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        }

        public boolean func_75250_a() {
            return this.deserted.func_70090_H();
        }

        public boolean func_75253_b() {
            return this.weaken > 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            --this.weaken;
        }

        public void func_75249_e() {
            this.weaken = 500;
            this.deserted.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        }
    }
}

