/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass;

import dlovin.advancedcompass.config.CompassConfig;
import dlovin.advancedcompass.events.EntityEvents;
import dlovin.advancedcompass.events.ResourcePackEvents;
import dlovin.advancedcompass.events.UpdateNotificationEvent;
import dlovin.advancedcompass.gui.CompassGui;
import dlovin.advancedcompass.gui.config.AdvCompassConfigScreen;
import dlovin.advancedcompass.keybinds.KeyBinds;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.JsonUtils;
import java.io.IOException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="advancedcompass")
public class AdvancedCompass {
    public static final String MODID = "advancedcompass";
    private static AdvancedCompass instance;
    public static final Logger logger;
    private static CompassConfig CONFIG;
    private CompassGui cGui;

    public AdvancedCompass() throws IOException {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        instance = this;
        CONFIG = new CompassConfig();
        CONFIG.register(ModLoadingContext.get());
        JsonUtils.initVanilla();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonRegistries);
        bus.addListener(this::clientRegistries);
        bus.addListener(this::loadCompleteRegistries);
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> new AdvCompassConfigScreen(false)));
    }

    public static CompassConfig.Client getClient() {
        return CONFIG.getClient();
    }

    public static CompassConfig getConfig() {
        return CONFIG;
    }

    private void commonRegistries(FMLCommonSetupEvent event) {
        HeadUtils.loadModHeads();
        logger.info("commonRegistries method registred");
    }

    private void loadCompleteRegistries(FMLLoadCompleteEvent event) {
        logger.info("loadComplete method registred");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        this.cGui = new CompassGui();
        MinecraftForge.EVENT_BUS.register((Object)this.cGui);
        MinecraftForge.EVENT_BUS.register((Object)new EntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new KeyBinds());
        MinecraftForge.EVENT_BUS.register((Object)new ResourcePackEvents());
        MinecraftForge.EVENT_BUS.register((Object)new UpdateNotificationEvent());
        logger.info("clientRegistries method registred");
    }

    public static void LogSomething(String st) {
        logger.info("[AdvancedCompass] " + st);
    }

    public static AdvancedCompass getInstance() {
        return instance;
    }

    public CompassGui getCompassGui() {
        return this.cGui;
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }
}

