/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.gui.renderers.CompassRenderer;
import dlovin.advancedcompass.gui.renderers.EntitiesRenderer;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.gui.renderers.WaypointRenderer;
import dlovin.advancedcompass.utils.InventoryUtils;
import dlovin.advancedcompass.utils.SettingsValues;
import dlovin.advancedcompass.utils.enums.CoordinatesMode;
import dlovin.advancedcompass.utils.enums.GenerationType;
import dlovin.advancedcompass.utils.enums.ShowMode;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CompassGui
extends Gui {
    private final ResourceLocation COMPASS_TOP = new ResourceLocation("advancedcompass", "textures/gui/compass_top.png");
    private final ResourceLocation COMPASS_MID = new ResourceLocation("advancedcompass", "textures/gui/compass_mid.png");
    private final ResourceLocation COMPASS_BOT = new ResourceLocation("advancedcompass", "textures/gui/compass_bot.png");
    public SettingsValues settings;
    private CompassRenderer compassRenderer;
    private EntitiesRenderer entitiesRenderer;
    private WaypointRenderer waypointRenderer;
    private Collection<IRenderer> renderers = new ArrayList<IRenderer>();
    private float coordinatesScale;
    private int coordinatesOffset;
    private int compassOffset;
    private int coordinatesHeight;
    private int bossOffset;

    public CompassGui() {
        super(Minecraft.m_91087_());
        this.settings = new SettingsValues();
        this.settings.yOffset = (Integer)AdvancedCompass.getClient().yOffset.get();
        this.settings.maxDistance = (Integer)AdvancedCompass.getClient().maxDistance.get();
        this.settings.groupRadius = (Integer)AdvancedCompass.getClient().groupRadius.get();
        this.settings.moveBossbar = (Boolean)AdvancedCompass.getClient().moveBossbar.get();
        this.settings.groupEntities = (Boolean)AdvancedCompass.getClient().groupEntities.get();
        this.settings.showDistance = (Boolean)AdvancedCompass.getClient().showDistance.get();
        this.settings.showPlayers = (Boolean)AdvancedCompass.getClient().showDistance.get();
        this.settings.setViewAngle((Integer)AdvancedCompass.getClient().viewAngle.get());
        this.settings.angleThreshold = (Integer)AdvancedCompass.getClient().angleThreshold.get();
        this.settings.hideOverlapped = (Boolean)AdvancedCompass.getClient().hideOverlapped.get();
        this.settings.overlapThreshold = (Integer)AdvancedCompass.getClient().overlapThreshold.get();
        this.settings.autoDeathWaypoint = (Boolean)AdvancedCompass.getClient().autoDeathWaypoint.get();
        this.settings.showMode = (ShowMode)((Object)AdvancedCompass.getClient().showMode.get());
        this.settings.compassWidth = (Integer)AdvancedCompass.getClient().compassWidth.get();
        this.settings.compassHeight = (Integer)AdvancedCompass.getClient().compassHeight.get();
        this.settings.iconScale = (Integer)AdvancedCompass.getClient().iconScale.get();
        this.settings.coordinatesScale = (Integer)AdvancedCompass.getClient().coordinatesScale.get();
        this.coordinatesScale = (float)this.settings.coordinatesScale / 100.0f;
        this.setCoordinatesMode((CoordinatesMode)((Object)AdvancedCompass.getClient().coordinatesMode.get()));
        this.settings.generationType = (GenerationType)((Object)AdvancedCompass.getClient().generationType.get());
        this.compassRenderer = new CompassRenderer(Minecraft.m_91087_(), this.m_93082_(), this.settings);
        this.renderers.add(this.compassRenderer);
        this.entitiesRenderer = new EntitiesRenderer(Minecraft.m_91087_(), this.m_93082_(), this.settings);
        this.renderers.add(this.entitiesRenderer);
        this.waypointRenderer = new WaypointRenderer(Minecraft.m_91087_(), this.m_93082_(), this.settings);
        this.renderers.add(this.waypointRenderer);
    }

    public void setIconScale(int scale) {
        this.settings.iconScale = scale;
        this.recalculateCoords();
        this.renderers.forEach(r -> r.setIconScale(scale));
    }

    public void setCoordinatesMode(CoordinatesMode mode) {
        this.settings.coordinatesMode = mode;
        this.recalculateCoords();
    }

    public void setCoordinatesScale(int scale) {
        this.settings.coordinatesScale = scale;
        this.coordinatesScale = (float)this.settings.coordinatesScale / 100.0f;
        this.recalculateCoords();
    }

    public void setCompassHeight(int height) {
        this.settings.compassHeight = height;
        this.recalculateCoords();
    }

    private void recalculateCoords() {
        if (this.settings.coordinatesMode.equals((Object)CoordinatesMode.ABOVE)) {
            this.coordinatesOffset = 0;
            this.compassOffset = (int)(10.0f * this.coordinatesScale);
            int iconheight = (int)((float)(9 * this.settings.iconScale) / 100.0f);
            if (this.settings.compassHeight / 2 < iconheight) {
                this.compassOffset += iconheight - this.settings.compassHeight / 2;
            }
            iconheight = (int)((float)(22 * this.settings.iconScale) / 100.0f);
            this.bossOffset = this.compassOffset + this.settings.compassHeight;
            if (this.bossOffset < this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2) {
                this.bossOffset = this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2;
            }
            this.coordinatesHeight = 0;
        } else if (this.settings.coordinatesMode.equals((Object)CoordinatesMode.BELOW)) {
            int iconheight = (int)((float)(10 * this.settings.iconScale) / 100.0f);
            this.compassOffset = this.settings.compassHeight / 2 < iconheight ? iconheight - this.settings.compassHeight / 2 : 0;
            iconheight = (int)(22.0f * ((float)this.settings.iconScale / 100.0f));
            this.coordinatesOffset = this.settings.compassHeight + 2;
            if (this.coordinatesOffset < this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2) {
                this.coordinatesOffset = this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2 + 2;
            }
            this.coordinatesHeight = (int)(8.0f * this.coordinatesScale);
            this.bossOffset = this.coordinatesOffset + this.coordinatesHeight;
        } else {
            this.coordinatesOffset = 0;
            int iconheight = (int)((float)(10 * this.settings.iconScale) / 100.0f);
            this.compassOffset = this.settings.compassHeight / 2 < iconheight ? iconheight - this.settings.compassHeight / 2 : 0;
            this.coordinatesHeight = 0;
            iconheight = (int)((float)(22 * this.settings.iconScale) / 100.0f);
            this.bossOffset = this.settings.compassHeight;
            if (this.settings.compassHeight < this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2) {
                this.bossOffset = this.compassOffset + this.settings.compassHeight / 2 + iconheight / 2;
            }
        }
    }

    @SubscribeEvent
    public void onRenderPost(RenderGameOverlayEvent.Post event) {
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.BOSSINFO)) {
            return;
        }
        if (this.settings.showMode.equals((Object)ShowMode.OFF)) {
            return;
        }
        if (!this.settings.showMode.equals((Object)ShowMode.ALWAYS_ON)) {
            if (this.settings.showMode.equals((Object)ShowMode.MAIN_HAND) && !InventoryUtils.isCompass(this.f_92986_.f_91074_.m_21205_())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.BOTH_HANDS) && !InventoryUtils.hasCompass(this.f_92986_.f_91074_.m_6167_())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.ANY_SLOT) && !InventoryUtils.hasCompass(new Iterable[]{this.f_92986_.f_91074_.m_150109_().f_35974_, this.f_92986_.f_91074_.m_150109_().f_35975_, this.f_92986_.f_91074_.m_150109_().f_35976_})) {
                return;
            }
        }
        if (this.settings.moveBossbar) {
            PoseStack mat = event.getMatrixStack();
            mat.m_85837_(0.0, (double)(-this.bossOffset - this.settings.yOffset), 0.0);
            mat.m_85849_();
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Pre event) {
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL) && !event.getType().equals((Object)RenderGameOverlayEvent.ElementType.BOSSINFO)) {
            return;
        }
        if (this.settings.showMode.equals((Object)ShowMode.OFF)) {
            return;
        }
        if (!this.settings.showMode.equals((Object)ShowMode.ALWAYS_ON)) {
            if (this.settings.showMode.equals((Object)ShowMode.MAIN_HAND) && !InventoryUtils.isCompass(this.f_92986_.f_91074_.m_21205_())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.BOTH_HANDS) && !InventoryUtils.hasCompass(this.f_92986_.f_91074_.m_6167_())) {
                return;
            }
            if (this.settings.showMode.equals((Object)ShowMode.ANY_SLOT) && !InventoryUtils.hasCompass(new Iterable[]{this.f_92986_.f_91074_.m_150109_().f_35974_, this.f_92986_.f_91074_.m_150109_().f_35975_, this.f_92986_.f_91074_.m_150109_().f_35976_})) {
                return;
            }
        }
        PoseStack mat = event.getMatrixStack();
        if (this.settings.moveBossbar && event.getType().equals((Object)RenderGameOverlayEvent.ElementType.BOSSINFO)) {
            mat.m_85836_();
            mat.m_85837_(0.0, (double)(this.bossOffset + this.settings.yOffset), 0.0);
            return;
        }
        int width = this.f_92986_.m_91268_().m_85445_();
        float scale = this.getScale(width, this.settings.compassWidth);
        float angle = -Mth.m_14177_((float)this.f_92986_.f_91074_.m_5675_(event.getPartialTicks()));
        mat.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mat.m_85836_();
        mat.m_85837_(0.0, (double)(this.compassOffset + this.settings.yOffset), -1.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.COMPASS_TOP);
        CompassGui.m_93133_((PoseStack)mat, (int)((int)((float)(width / 2) - (float)(this.settings.compassWidth / 2) * scale)), (int)0, (float)0.0f, (float)0.0f, (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)), (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)));
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.COMPASS_MID);
        CompassGui.m_93133_((PoseStack)mat, (int)((int)((float)(width / 2) - (float)(this.settings.compassWidth / 2) * scale)), (int)((int)(scale * 3.0f)), (float)0.0f, (float)0.0f, (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)((float)(this.settings.compassHeight - 6) * scale)), (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)((float)(this.settings.compassHeight - 6) * scale)));
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.COMPASS_BOT);
        CompassGui.m_93133_((PoseStack)mat, (int)((int)((float)(width / 2) - (float)(this.settings.compassWidth / 2) * scale)), (int)((int)((float)(this.settings.compassHeight - 3) * scale)), (float)0.0f, (float)0.0f, (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)), (int)((int)((float)this.settings.compassWidth * scale)), (int)((int)(3.0f * scale)));
        mat.m_85836_();
        RenderSystem.m_69478_();
        mat.m_85837_((double)(width / 2), 0.0, 1.0);
        this.compassRenderer.render(mat, angle, scale);
        this.entitiesRenderer.render(mat, angle, scale);
        this.waypointRenderer.render(mat, angle, scale);
        RenderSystem.m_69461_();
        mat.m_85849_();
        mat.m_85849_();
        if (!this.settings.coordinatesMode.equals((Object)CoordinatesMode.OFF)) {
            mat.m_85836_();
            Vec3 pos = this.f_92986_.f_91074_.m_20182_();
            String coords = String.format("%.1f  %.0f  %.1f", pos.f_82479_, pos.f_82480_, pos.f_82481_);
            mat.m_85837_((double)(width / 2), (double)(this.coordinatesOffset + this.settings.yOffset), 0.0);
            mat.m_85841_(this.coordinatesScale, this.coordinatesScale, this.coordinatesScale);
            this.m_93082_().m_92750_(mat, coords, (float)(-this.m_93082_().m_92895_(coords) / 2), 0.0f, -1);
            mat.m_85849_();
        }
        RenderSystem.m_69461_();
        mat.m_85849_();
    }

    private float getScale(int width, int w) {
        if (width < w) {
            return (float)width / (float)w;
        }
        return 1.0f;
    }

    public void removeWaypointByName(String name) {
        this.waypointRenderer.removeWaypointByName(name);
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypointRenderer.addWaypoint(waypoint);
    }

    public void setWaypoints(Collection waypoints) {
        this.waypointRenderer.setWaypoints(waypoints);
    }

    public void removeWaypoint(Waypoint w) {
        this.waypointRenderer.removeWaypoint(w);
    }

    public void changeWaypoint(Waypoint w) {
        this.waypointRenderer.changeWaypoint(w);
    }
}

