/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.gui.config.WaypointAddGui;
import dlovin.advancedcompass.gui.config.WaypointEditGui;
import dlovin.advancedcompass.gui.config.widgets.CheckBox;
import dlovin.advancedcompass.gui.config.widgets.ConfirmButton;
import dlovin.advancedcompass.gui.config.widgets.CustomButton;
import dlovin.advancedcompass.gui.config.widgets.CustomOptionList;
import dlovin.advancedcompass.gui.config.widgets.TextWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.StringUtils;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointJsonUtils;
import dlovin.advancedcompass.utils.waypoints.WaypointUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ServerLevelData;

public class WaypointListGui
extends Screen {
    CustomOptionList optionList;
    List<Widget> widgetList;
    String dir;

    public WaypointListGui() {
        super((Component)new TextComponent("Waypoint list"));
    }

    public void m_7856_() {
        this.optionList = new CustomOptionList(this.f_96541_, 30, 40, 24, this);
        this.dir = this.f_96541_.m_91089_() != null ? StringUtils.trimPort(this.f_96541_.m_91089_().f_105363_) : StringUtils.removeIllegal(((ServerLevelData)this.f_96541_.m_91092_().m_129783_().m_6106_()).m_5462_());
        Collection<Waypoint> waypoints = WaypointJsonUtils.getWaypoints(this.dir);
        String[] dimensions = WaypointUtils.getAllDimensions(waypoints);
        int index = 0;
        for (int i = 0; i < dimensions.length; ++i) {
            Collection<Waypoint> tmpList = WaypointUtils.getWaypointsInDimension(dimensions[i], waypoints);
            String[] dim = dimensions[i].split(":");
            String dimension = String.format("(%s) %s:", StringUtils.capitalize(dim[0]), StringUtils.capitalize(dim[dim.length - 1]));
            this.optionList.addWidget(new TextWidget(this.f_96543_ / 2, 10, 0xFFFFFF, TextWidget.TextAlign.CENTER, dimension, this.f_96547_), index++);
            for (Waypoint w : tmpList) {
                CustomButton tmp = new CustomButton(this.f_96543_ / 2 + 10, 2, 16, 16, 16, "", new ResourceLocation("advancedcompass", "textures/gui/widgets/settings_btn.png"), false);
                this.optionList.addWidget(tmp, index);
                tmp.addListener(() -> this.changeWaypoint(w));
                tmp = new ConfirmButton(this.f_96543_ / 2 + 36, 2, 16, 16, 16, "", new ResourceLocation("advancedcompass", "textures/gui/widgets/delete_btn.png"), new Widget.ITooltip[]{(wi, m, x, y) -> this.m_96602_(m, Translation.DELETE_BTN, x, y), (wi, m, x, y) -> this.m_96602_(m, Translation.CONFIRM_BTN, x, y)});
                this.optionList.addWidget(tmp, index);
                int finalIndex = index;
                tmp.addListener(() -> this.deleteWaypoint(finalIndex, w, this.dir));
                this.optionList.addWidget(new CheckBox(this.f_96543_ / 2 + 62, 0, 20, 20, t -> this.changeEnabled(t, w), w.isEnabled()), index);
                this.optionList.addWidget(new TextWidget(this.f_96543_ / 2 - 10, 10, 0xFFFFFF, TextWidget.TextAlign.RIGHT, w.getName(), this.f_96547_), index++);
            }
        }
        this.widgetList = new ArrayList<Widget>();
        CustomButton tmp = new CustomButton(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 60, 20, Translation.HIDEALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.HideAll());
        this.m_6702_().add(tmp);
        tmp = new CustomButton(this.f_96543_ / 2 - 30, this.f_96544_ - 30, 60, 20, Translation.ADDNEW.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.addNew());
        this.m_6702_().add(tmp);
        tmp = new CustomButton(this.f_96543_ / 2 + 40, this.f_96544_ - 30, 60, 20, Translation.SHOWALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.ShowAll());
        this.m_6702_().add(tmp);
        this.m_6702_().add(this.optionList);
    }

    private void ShowAll() {
        for (Widget w : this.optionList.getWidgets()) {
            if (!(w instanceof CheckBox) || ((CheckBox)w).checked) continue;
            ((CheckBox)w).checked = true;
            ((CheckBox)w).onChanged();
        }
    }

    private void addNew() {
        this.f_96541_.m_91152_((Screen)new WaypointAddGui(true));
    }

    private void HideAll() {
        for (Widget w : this.optionList.getWidgets()) {
            if (!(w instanceof CheckBox) || !((CheckBox)w).checked) continue;
            ((CheckBox)w).checked = false;
            ((CheckBox)w).onChanged();
        }
    }

    private void deleteWaypoint(int r, Waypoint w, String dir) {
        this.optionList.removeRow(r);
        WaypointJsonUtils.deleteWaypoint(dir, w);
        AdvancedCompass.getInstance().getCompassGui().removeWaypoint(w);
    }

    private void changeWaypoint(Waypoint w) {
        this.f_96541_.m_91152_((Screen)new WaypointEditGui(w));
    }

    private void changeEnabled(CheckBox t, Waypoint w) {
        w.setEnabled(t.checked);
        WaypointJsonUtils.changeWaypoint(this.dir, w.getName(), w, true);
        AdvancedCompass.getInstance().getCompassGui().changeWaypoint(w);
    }

    public void m_6305_(PoseStack mat, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(mat);
        this.optionList.m_6305_(mat, mouseX, mouseY, partialTick);
        this.widgetList.forEach(w -> w.m_6305_(mat, mouseX, mouseY, partialTick));
        this.optionList.renderTooltips(mat, mouseX, mouseY);
        this.widgetList.forEach(w -> w.renderTooltip(mat, mouseX, mouseY));
    }

    public boolean m_7979_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        this.optionList.m_7979_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
        return false;
    }
}

