/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.gui.config.widgets.ButtonWidget;
import dlovin.advancedcompass.utils.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class ColorPicker
extends ButtonWidget {
    private final ResourceLocation PALETTE = new ResourceLocation("advancedcompass", "textures/gui/widgets/palette.png");
    private BufferedImage paletteImage;
    private Color color;
    private boolean isPicking;
    private int pickerX;
    private int pickerY;

    public ColorPicker(int x, int y, int width, int height, Color color) {
        super(x, y, width, height, "");
        this.color = color;
        this.pickerX = x + width;
        this.pickerY = y;
        int windowWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int windowHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        if (this.pickerX + 128 > windowWidth) {
            this.pickerX = windowWidth - 128;
        }
        if (this.pickerY + 128 > windowHeight) {
            this.pickerY = windowHeight - 128;
        }
        try {
            this.paletteImage = ImageIO.read(Minecraft.m_91087_().m_91098_().m_142591_(this.PALETTE).m_6679_());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.hovered) {
            this.playDownSound(Minecraft.m_91087_().m_91106_());
            if (this.isPicking) {
                int x = (int)mouseX - this.pickerX;
                int y = (int)mouseY - this.pickerY;
                this.color = this.pickColor(x, y, this.color);
                this.isPicking = !this.isPicking;
                for (ButtonWidget.ButtonClickListener hl : this.listeners) {
                    hl.onClick();
                }
                return true;
            }
            this.isPicking = !this.isPicking;
        } else if (this.isPicking) {
            this.isPicking = !this.isPicking;
        }
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void m_6305_(PoseStack mat, int mouseX, int mouseY, float p_230430_4_) {
        this.hovered = !this.isPicking ? mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height : mouseX >= this.pickerX && mouseY >= this.pickerY && mouseX < this.pickerX + 128 && mouseY < this.pickerY + 128;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BG);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        if (this.hovered && !this.isPicking) {
            this.renderBtnBg(mat, 16);
        } else {
            this.renderBtnBg(mat, 0);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.PALETTE);
        if (this.isPicking) {
            int x = mouseX - this.pickerX;
            int y = mouseY - this.pickerY;
            Color pickingColor = new Color();
            pickingColor = this.pickColor(x, y, pickingColor);
            RenderSystem.m_157429_((float)pickingColor.r, (float)pickingColor.g, (float)pickingColor.b, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)1.0f);
        }
        ColorPicker.m_93160_((PoseStack)mat, (int)(this.x + 4), (int)(this.y + 4), (int)(this.width - 8), (int)(this.height - 8), (float)0.0f, (float)0.0f, (int)1, (int)1, (int)128, (int)128);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isPicking) {
            ColorPicker.m_93160_((PoseStack)mat, (int)this.pickerX, (int)this.pickerY, (int)128, (int)128, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
        }
        RenderSystem.m_69461_();
    }

    @Override
    protected void renderBtnBg(PoseStack mat, int offsetX) {
        ColorPicker.m_93160_((PoseStack)mat, (int)this.x, (int)this.y, (int)2, (int)2, (float)offsetX, (float)0.0f, (int)2, (int)2, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)(this.x + this.width - 2), (int)this.y, (int)2, (int)2, (float)(14 + offsetX), (float)0.0f, (int)2, (int)2, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)this.x, (int)(this.y + this.height - 2), (int)2, (int)2, (float)offsetX, (float)14.0f, (int)2, (int)2, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)(this.x + this.width - 2), (int)(this.y + this.height - 2), (int)2, (int)2, (float)(14 + offsetX), (float)14.0f, (int)2, (int)2, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)(this.x + 2), (int)this.y, (int)(this.width - 4), (int)2, (float)(2 + offsetX), (float)0.0f, (int)12, (int)2, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)(this.x + this.width - 2), (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)(14 + offsetX), (float)2.0f, (int)2, (int)12, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)(this.x + 2), (int)(this.y + this.height - 2), (int)(this.width - 4), (int)2, (float)(2 + offsetX), (float)14.0f, (int)12, (int)2, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)this.x, (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)offsetX, (float)2.0f, (int)2, (int)12, (int)32, (int)32);
        ColorPicker.m_93160_((PoseStack)mat, (int)(this.x + 2), (int)(this.y + 2), (int)(this.width - 4), (int)(this.height - 4), (float)(2 + offsetX), (float)2.0f, (int)12, (int)12, (int)32, (int)32);
    }

    private Color pickColor(int x, int y, Color color) {
        if (x < 0 || x > 127 || y < 0 || y > 127) {
            return this.color;
        }
        return color.setFromRGB(this.paletteImage.getRGB(x, y));
    }
}

