/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.config;

import dlovin.advancedcompass.utils.enums.CoordinatesMode;
import dlovin.advancedcompass.utils.enums.GenerationType;
import dlovin.advancedcompass.utils.enums.ModWPType;
import dlovin.advancedcompass.utils.enums.ShowMode;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class CompassConfig {
    public ForgeConfigSpec clientSpec;
    private final Client client;

    public CompassConfig() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        this.clientSpec = (ForgeConfigSpec)specPair.getRight();
        this.client = (Client)specPair.getLeft();
    }

    public Client getClient() {
        return this.client;
    }

    public void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientSpec);
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue yOffset;
        public final ForgeConfigSpec.IntValue maxDistance;
        public final ForgeConfigSpec.IntValue groupRadius;
        public final ForgeConfigSpec.BooleanValue moveBossbar;
        public final ForgeConfigSpec.BooleanValue groupEntities;
        public final ForgeConfigSpec.BooleanValue showDistance;
        public final ForgeConfigSpec.BooleanValue showPlayers;
        public final ForgeConfigSpec.IntValue viewAngle;
        public final ForgeConfigSpec.IntValue angleThreshold;
        public final ForgeConfigSpec.IntValue angleThresholdWaypoints;
        public final ForgeConfigSpec.IntValue overlapThreshold;
        public final ForgeConfigSpec.BooleanValue hideBehindBlocks;
        public final ForgeConfigSpec.BooleanValue hideOverlapped;
        public final ForgeConfigSpec.BooleanValue autoDeathWaypoint;
        public final ForgeConfigSpec.EnumValue<ShowMode> showMode;
        public final ForgeConfigSpec.EnumValue<CoordinatesMode> coordinatesMode;
        public final ForgeConfigSpec.EnumValue<GenerationType> generationType;
        public final ForgeConfigSpec.EnumValue<ModWPType> modWaypoints;
        public final ForgeConfigSpec.IntValue coordinatesScale;
        public final ForgeConfigSpec.IntValue compassWidth;
        public final ForgeConfigSpec.IntValue compassHeight;
        public final ForgeConfigSpec.IntValue iconScale;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("advancedcompass");
            this.yOffset = builder.comment("Vertical offset from top edge of the screen (from 0 to 50)").defineInRange("yOffset", 4, 0, 50);
            this.maxDistance = builder.comment("Maximum distance to entity for rendering (from 0 to 999)").defineInRange("maxDistance", 50, 0, 999);
            this.groupRadius = builder.comment("Maximum radius to merge entity into groups (from 5 to 15)").defineInRange("groupRadius", 10, 5, 15);
            this.viewAngle = builder.comment("Angle of view that fits into the compass (from 30 to 360)").defineInRange("viewAngle", 70, 30, 360);
            this.angleThreshold = builder.comment("Angle threshold for rendering entity icons (from 15 to 180)").defineInRange("angleThreshold", 90, 15, 180);
            this.angleThresholdWaypoints = builder.comment("Angle threshold for rendering waypoint icons (from 15 to 180)").defineInRange("angleThresholdWaypoints", 90, 15, 180);
            this.moveBossbar = builder.comment("Move vanilla bossbar below the compass").define("moveBossbar", true);
            this.groupEntities = builder.comment("Merge entities into groups").define("groupEntities", true);
            this.showDistance = builder.comment("Show distance").define("showDistance", true);
            this.showPlayers = builder.comment("Show players").define("showPlayers", true);
            this.hideOverlapped = builder.comment("Hide overlapped icons").define("hideOverlapped", true);
            this.overlapThreshold = builder.comment("Overlap threshold").defineInRange("overlapThreshold", 4, 0, 10);
            this.autoDeathWaypoint = builder.comment("Create waypoint on death").define("autoDeathWaypoint", true);
            this.showMode = builder.comment("Compass show mode").defineEnum("showMode", (Enum)ShowMode.ALWAYS_ON);
            this.hideBehindBlocks = builder.comment("Hide mob icons if they are behind blocks").define("hideBehindBlocks", false);
            this.coordinatesMode = builder.comment("Show coordinates").defineEnum("coordinatesMode", (Enum)CoordinatesMode.OFF);
            this.coordinatesScale = builder.comment("Coordinates font scale").defineInRange("coordinatesScale", 100, 50, 200);
            this.compassWidth = builder.comment("Compass width").defineInRange("compassWidth", 412, 100, 9999);
            this.compassHeight = builder.comment("Compass height").defineInRange("compassHeight", 22, 8, 50);
            this.iconScale = builder.comment("Icon scale").defineInRange("iconScale", 100, 50, 200);
            this.generationType = builder.comment("Auto icon generation type").defineEnum("generationType", (Enum)GenerationType.HEAD_FIRST);
            this.modWaypoints = builder.comment("Way to show waypoints from other mods").defineEnum("modWaypoints", (Enum)ModWPType.SHOW_ENABLED);
            builder.pop();
        }
    }
}

