/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.events;

import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.IconCreator;
import dlovin.advancedcompass.utils.StringUtils;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointIcon;
import dlovin.advancedcompass.utils.waypoints.WaypointJsonUtils;
import dlovin.advancedcompass.utils.waypoints.WaypointUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityEvents {
    private static EntityEvents instance;
    private Minecraft mc = Minecraft.m_91087_();
    private List<EntityType> types = new ArrayList<EntityType>();
    private ArrayDeque<QueuedEntity> queue = new ArrayDeque();

    public static EntityEvents getInstance() {
        return instance;
    }

    public void addEntity(Entity en) {
        ResourceLocation resourceLocation = this.mc.m_91290_().m_114382_(en).m_5478_(en);
        this.queue.add(new QueuedEntity(en, resourceLocation));
    }

    public EntityEvents() {
        for (Map.Entry<EntityType, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            this.types.add(entry.getKey());
        }
        instance = this;
    }

    @SubscribeEvent
    public void onPlayerDeath(ScreenOpenEvent event) {
        if (event.getScreen() instanceof DeathScreen && AdvancedCompass.getInstance().getCompassGui().settings.autoDeathWaypoint) {
            this.createDeathWaypoint(this.mc.f_91074_.m_20182_());
        }
    }

    private void createDeathWaypoint(Vec3 position) {
        String dir = "";
        dir = this.mc.m_91089_() != null ? StringUtils.trimPort(this.mc.m_91089_().f_105363_) : StringUtils.removeIllegal(((ServerLevelData)this.mc.m_91092_().m_129783_().m_6106_()).m_5462_());
        String name = "DP(" + (int)position.f_82479_ + "_" + (int)position.f_82480_ + "_" + (int)position.f_82481_ + ")";
        Waypoint wp = new Waypoint(name, position, this.mc.f_91073_.m_46472_().m_135782_().toString(), WaypointIcon.SKULL, new Color(1.0f, 1.0f, 1.0f), 0, 0, true);
        WaypointJsonUtils.addWaypoint(dir, wp, true);
        AdvancedCompass.getInstance().getCompassGui().addWaypoint(wp);
    }

    @SubscribeEvent
    public void onEntityEnter(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob MobEntity = (Mob)entity;
            if (!this.types.contains(event.getEntity().m_6095_())) {
                this.types.add(event.getEntity().m_6095_());
                Entity en = event.getEntity();
                try {
                    ResourceLocation resourceLocation = this.mc.m_91290_().m_114382_(en).m_5478_(en);
                    this.queue.add(new QueuedEntity(en, resourceLocation));
                }
                catch (Exception ex) {
                    AdvancedCompass.logger.info("Can't add icon for " + event.getEntity().m_6095_());
                }
            }
        } else if (event.getEntity().equals((Object)this.mc.f_91074_)) {
            String dir = this.mc.m_91089_() != null ? StringUtils.trimPort(this.mc.m_91089_().f_105363_) : StringUtils.removeIllegal(((ServerLevelData)this.mc.m_91092_().m_129783_().m_6106_()).m_5462_());
            List<Waypoint> waypoints = WaypointJsonUtils.getWaypoints(dir);
            waypoints = WaypointUtils.getWaypointsInDimension(event.getWorld().m_46472_().m_135782_().toString(), waypoints);
            AdvancedCompass.getInstance().getCompassGui().setWaypoints(waypoints);
        }
    }

    @SubscribeEvent
    public void onEnter(RenderGameOverlayEvent.Post event) {
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        while (this.queue.peek() != null) {
            QueuedEntity queuedEntity = this.queue.pop();
            Entity en = queuedEntity.entity;
            ResourceLocation resourceLocation = queuedEntity.resourceLocation;
            String namespace = en.m_6095_().getRegistryName().m_135827_();
            AdvancedCompass.logger.info("Trying to create icon for: " + en.m_6095_().getRegistryName().m_135827_() + ":" + en.m_6095_().getRegistryName().m_135815_());
            switch (AdvancedCompass.getInstance().getCompassGui().settings.generationType) {
                case HEAD_FIRST: {
                    IconCreator.fullCycle(en, namespace, resourceLocation, event.getPartialTicks());
                    break;
                }
                case FULL_BODY: {
                    IconCreator.bodyCycle(en, namespace);
                    break;
                }
                case OFF: {
                    IconCreator.saveDefault(en, namespace);
                }
            }
            AdvancedCompass.logger.info("Creating process done with some state, no jre or opengl errors!");
        }
    }

    private class QueuedEntity {
        Entity entity;
        ResourceLocation resourceLocation;

        QueuedEntity(Entity en, ResourceLocation loc) {
            this.entity = en;
            this.resourceLocation = loc;
        }
    }
}

