/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import dlovin.advancedcompass.gui.config.ConfigScreen;
import dlovin.advancedcompass.gui.config.IconConfigGui;
import dlovin.advancedcompass.gui.config.widgets.CustomButton;
import dlovin.advancedcompass.gui.config.widgets.EntityCheckBox;
import dlovin.advancedcompass.gui.config.widgets.TextWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.gui.ModListScreen;

public class EntityListConfigScreen
extends ConfigScreen {
    public EntityListConfigScreen(boolean inGame) {
        super(1, inGame);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int i = 0;
        HashMap mobs = new HashMap();
        for (Map.Entry entry : HeadUtils.heads.entrySet().stream().sorted(Comparator.comparing(w -> ((EntityType)w.getKey()).m_20676_().getString())).collect(Collectors.toList())) {
            if (mobs.get(((EntityType)entry.getKey()).getRegistryName().m_135827_()) == null) {
                ArrayList<EntityType> newList = new ArrayList<EntityType>();
                newList.add((EntityType)entry.getKey());
                mobs.put(((EntityType)entry.getKey()).getRegistryName().m_135827_(), newList);
                continue;
            }
            ((List)mobs.get(((EntityType)entry.getKey()).getRegistryName().m_135827_())).add((EntityType)entry.getKey());
        }
        for (Map.Entry entry : mobs.entrySet()) {
            this.OptionList.addWidget(new TextWidget(this.f_96543_ / 2 - 10, 10, 0xFFFFFF, TextWidget.TextAlign.CENTER, new TranslatableComponent((String)entry.getKey()).getString(), this.f_96547_), i++);
            for (EntityType type : (List)entry.getValue()) {
                this.OptionList.addWidget(new TextWidget(this.f_96543_ / 2 - 10, 10, 0xFFFFFF, TextWidget.TextAlign.RIGHT, type.m_20676_().getString() + ":", this.f_96547_), i);
                this.OptionList.addWidget(new EntityCheckBox(this.f_96543_ / 2 + 10, 0, 20, 20, w -> this.changeType(w), GroupUtils.types.contains(type), type), i++);
                if (type.getRegistryName().m_135827_().equalsIgnoreCase("minecraft") || this.f_96541_.f_91073_ == null) continue;
                CustomButton tmp = new CustomButton(this.f_96543_ / 2 + 40, 2, 16, 16, 16, "", new ResourceLocation("advancedcompass", "textures/gui/widgets/settings_btn.png"), false);
                this.OptionList.addWidget(tmp, i - 1);
                tmp.addListener(() -> Minecraft.m_91087_().m_91152_((Screen)new IconConfigGui(type, this.inGame, this.OptionList.getScroll())));
            }
        }
        int n = this.f_96547_.m_92895_(Translation.HIDEALL.getString());
        CustomButton tmp = new CustomButton(this.f_96543_ / 2 - 15 - n, this.f_96544_ - 25, n + 10, 20, Translation.HIDEALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.HideAll());
        this.m_6702_().add(tmp);
        int n2 = this.f_96547_.m_92895_(Translation.SHOWALL.getString());
        tmp = new CustomButton(this.f_96543_ / 2 + 5, this.f_96544_ - 25, n2 + 10, 20, Translation.SHOWALL.getString(), null, false);
        this.widgetList.add(tmp);
        tmp.addListener(() -> this.ShowAll());
        this.m_6702_().add(tmp);
    }

    private void HideAll() {
        for (Widget w : this.OptionList.getWidgets()) {
            if (!(w instanceof EntityCheckBox)) continue;
            ((EntityCheckBox)w).checked = false;
            this.changeType((EntityCheckBox)w);
        }
    }

    private void ShowAll() {
        for (Widget w : this.OptionList.getWidgets()) {
            if (!(w instanceof EntityCheckBox)) continue;
            ((EntityCheckBox)w).checked = true;
            this.changeType((EntityCheckBox)w);
        }
    }

    private void changeType(EntityCheckBox w) {
        if (w.checked) {
            if (!GroupUtils.types.contains(w.getType())) {
                GroupUtils.types.add(w.getType());
            }
        } else {
            GroupUtils.types.remove(w.getType());
        }
    }

    @Override
    public void changeScreen(Screen screen) {
        JsonUtils.saveMobs();
        this.f_96541_.m_91152_(screen);
    }

    @Override
    public void m_7379_() {
        JsonUtils.saveMobs();
        if (!this.inGame) {
            this.f_96541_.m_91152_((Screen)new ModListScreen(null));
        } else {
            this.f_96541_.m_91152_(null);
        }
    }
}

