/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.utils.DrawRanges;
import dlovin.advancedcompass.utils.Group;
import dlovin.advancedcompass.utils.GroupEntity;
import dlovin.advancedcompass.utils.GroupPlayers;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.NumsUtils;
import dlovin.advancedcompass.utils.SettingsValues;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.TextureRes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitiesRenderer
extends IRenderer {
    public EntitiesRenderer(Minecraft mc, Font fontRenderer, SettingsValues settingsValues) {
        super(mc, fontRenderer, settingsValues);
    }

    public void render(PoseStack mat, float angle, float scale) {
        mat.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.settings.groupEntities) {
            if (this.settings.hideOverlapped) {
                this.renderGroups(mat, angle, scale);
            } else {
                this.renderOverlappedGroups(mat, angle, scale);
            }
        } else if (this.settings.hideOverlapped) {
            this.renderAllEntities(mat, angle, scale);
        } else {
            this.renderOverlappedAllEntities(mat, angle, scale);
        }
        mat.m_85849_();
    }

    private void renderGroups(PoseStack mat, float angle, float scale) {
        ArrayList<DrawRanges> listOfAddedHeads = new ArrayList<DrawRanges>();
        ArrayList<Runnable> toRender = new ArrayList<Runnable>();
        for (Group gEn : GroupUtils.getSortedGroups(this.settings.maxDistance, this.settings.groupRadius, this.settings.showPlayers, this.settings.hideBehind)) {
            Vec3 genPoint = gEn.getPoint();
            TextureCoords coords = HeadUtils.heads.get(gEn instanceof GroupEntity ? gEn.getType() : EntityType.f_20532_);
            if (coords == null) continue;
            float mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
            double x = this.getX(mobAngle, scale);
            double min = x - (double)((float)coords.width / 2.0f);
            double max = x + (double)((float)coords.width / 2.0f);
            if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.overlapThreshold))) continue;
            if (gEn instanceof GroupEntity) {
                toRender.add(() -> this.drawMobHead(mat, mobAngle, scale, coords, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - genPoint.f_82480_));
            } else {
                toRender.add(() -> this.drawPlayerHead(mat, mobAngle, scale, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - genPoint.f_82480_, this.mc.m_91290_().m_114382_(((GroupPlayers)gEn).getSample()).m_5478_(((GroupPlayers)gEn).getSample()), coords));
            }
            listOfAddedHeads.add(new DrawRanges(min, max));
        }
        Collections.reverse(toRender);
        for (Runnable r : toRender) {
            r.run();
        }
    }

    private void renderOverlappedGroups(PoseStack mat, float angle, float scale) {
        for (Group gEn : GroupUtils.getSortedReversedGroups(this.settings.maxDistance, this.settings.groupRadius, this.settings.showPlayers, this.settings.hideBehind)) {
            Vec3 genPoint = gEn.getPoint();
            if (gEn instanceof GroupEntity) {
                this.drawMobHead(mat, this.ToFormat(90.0f + angle + this.getAngle(genPoint)), scale, HeadUtils.heads.get(gEn.getType()), this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - genPoint.f_82480_);
                continue;
            }
            this.drawPlayerHead(mat, this.ToFormat(90.0f + angle + this.getAngle(genPoint)), scale, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - genPoint.f_82480_, this.mc.m_91290_().m_114382_(((GroupPlayers)gEn).getSample()).m_5478_(((GroupPlayers)gEn).getSample()), HeadUtils.heads.get(EntityType.f_20532_));
        }
    }

    private void renderAllEntities(PoseStack mat, float angle, float scale) {
        double max;
        double min;
        double x;
        double mobAngle;
        TextureCoords coords;
        Vec3 genPoint;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ArrayList<Entity> players = new ArrayList<Entity>();
        this.addEntities(entities, players);
        ArrayList<DrawRanges> listOfAddedHeads = new ArrayList<DrawRanges>();
        ArrayList<Runnable> toRender = new ArrayList<Runnable>();
        if (this.settings.showPlayers) {
            for (Entity en : players.stream().sorted(Comparator.comparing(e -> Float.valueOf(e.m_20270_((Entity)this.mc.f_91074_)))).collect(Collectors.toList())) {
                genPoint = en.m_20182_();
                coords = HeadUtils.heads.get(en.m_6095_());
                if (coords == null) continue;
                mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
                x = this.getX(mobAngle, scale);
                min = x - (double)((float)coords.width / 2.0f);
                max = x + (double)((float)coords.width / 2.0f);
                if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.overlapThreshold))) continue;
                toRender.add(() -> this.drawPlayerHead(mat, mobAngle, scale, this.settings.showDistance ? (int)this.getFlatDistance(en.m_20182_(), this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - en.m_20186_(), this.mc.m_91290_().m_114382_(en).m_5478_(en), coords));
                listOfAddedHeads.add(new DrawRanges(min, max));
            }
        }
        for (Entity en : entities.stream().sorted(Comparator.comparing(e -> Float.valueOf(e.m_20270_((Entity)this.mc.f_91074_)))).collect(Collectors.toList())) {
            genPoint = en.m_20182_();
            coords = HeadUtils.heads.get(en.m_6095_());
            if (coords == null) continue;
            mobAngle = this.ToFormat(90.0f + angle + this.getAngle(genPoint));
            x = this.getX(mobAngle, scale);
            min = x - (double)((float)coords.width / 2.0f);
            max = x + (double)((float)coords.width / 2.0f);
            if (!listOfAddedHeads.stream().noneMatch(w -> w.inRange(min, max, this.settings.overlapThreshold))) continue;
            if (en instanceof Mob) {
                toRender.add(() -> this.drawMobHead(mat, mobAngle, scale, coords, this.settings.showDistance ? (int)this.getFlatDistance(genPoint, this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - genPoint.f_82480_));
            } else {
                toRender.add(() -> this.drawPlayerHead(mat, mobAngle, scale, this.settings.showDistance ? (int)this.getFlatDistance(en.m_20182_(), this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - en.m_20186_(), this.mc.m_91290_().m_114382_(en).m_5478_(en), coords));
            }
            listOfAddedHeads.add(new DrawRanges(min, max));
        }
        Collections.reverse(toRender);
        for (Runnable r : toRender) {
            r.run();
        }
    }

    private boolean hasLineOfSight(Entity en, Vec3 vec3) {
        Vec3 vec31 = new Vec3(en.m_20185_(), en.m_20188_(), en.m_20189_());
        if (vec31.m_82554_(vec3) > (double)this.settings.maxDistance) {
            return false;
        }
        if (this.settings.hideBehind) {
            return this.mc.f_91073_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_)).m_6662_() == HitResult.Type.MISS;
        }
        return true;
    }

    private void addEntities(Collection<Entity> entities, Collection<Entity> players) {
        Vec3 vec3 = new Vec3(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20188_(), this.mc.f_91074_.m_20189_());
        this.mc.f_91073_.m_104735_().forEach(e -> {
            if (!e.m_20177_((Player)this.mc.f_91074_)) {
                if (e instanceof Mob) {
                    if (GroupUtils.types.contains(e.m_6095_()) && this.hasLineOfSight((Entity)e, vec3)) {
                        entities.add((Entity)e);
                    }
                } else if (e instanceof Player && !e.equals((Object)this.mc.f_91074_)) {
                    if (this.mc.f_91074_.f_108617_.m_104949_(e.m_142081_()) == null) {
                        if (GroupUtils.types.contains(e.m_6095_()) && this.hasLineOfSight((Entity)e, vec3)) {
                            entities.add((Entity)e);
                        }
                    } else if (this.settings.showPlayers && !e.m_6047_() && this.hasLineOfSight((Entity)e, vec3)) {
                        players.add((Entity)e);
                    }
                }
            }
        });
    }

    private void renderOverlappedAllEntities(PoseStack mat, float angle, float scale) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ArrayList<Entity> players = new ArrayList<Entity>();
        this.addEntities(entities, players);
        for (Entity en : entities.stream().sorted(Comparator.comparing(e -> Float.valueOf(((Entity)e).m_20270_((Entity)this.mc.f_91074_))).reversed()).collect(Collectors.toList())) {
            if (en instanceof Mob) {
                this.drawMobHead(mat, this.ToFormat(90.0f + angle + this.getAngle(en.m_20182_())), scale, HeadUtils.heads.get(en.m_6095_()), this.settings.showDistance ? (int)this.getFlatDistance(en.m_20182_(), this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - en.m_20186_());
                continue;
            }
            this.drawPlayerHead(mat, this.ToFormat(90.0f + angle + this.getAngle(en.m_20182_())), scale, this.settings.showDistance ? (int)this.getFlatDistance(en.m_20182_(), this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - en.m_20186_(), this.mc.m_91290_().m_114382_(en).m_5478_(en), HeadUtils.heads.get(en.m_6095_()));
        }
        if (this.settings.showPlayers) {
            this.drawPlayers(mat, angle, scale, players.stream().sorted(Comparator.comparing(e -> Float.valueOf(((Entity)e).m_20270_((Entity)this.mc.f_91074_))).reversed()).collect(Collectors.toList()));
        }
    }

    private void drawPlayers(PoseStack mat, float angle, float scale, Collection<Entity> players) {
        for (Entity en : players.stream().sorted(Comparator.comparing(e -> Float.valueOf(((Entity)e).m_20270_((Entity)this.mc.f_91074_))).reversed()).collect(Collectors.toList())) {
            this.drawPlayerHead(mat, this.ToFormat(90.0f + angle + this.getAngle(en.m_20182_())), scale, this.settings.showDistance ? (int)this.getFlatDistance(en.m_20182_(), this.mc.f_91074_.m_20182_()) : 0, this.mc.f_91074_.m_20186_() - en.m_20186_(), this.mc.m_91290_().m_114382_(en).m_5478_(en), HeadUtils.heads.get(en.m_6095_()));
        }
    }

    private void drawMobHead(PoseStack mat, double angle, float scale, TextureCoords tex, int distance, double hDif) {
        if (tex == null || Math.abs(angle) > (double)this.settings.angleThreshold) {
            return;
        }
        if (tex instanceof TextureRes) {
            this.drawMod(mat, (TextureRes)tex, angle, scale);
        } else {
            this.drawVanilla(mat, tex, angle, scale);
        }
        if (hDif < -3.0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ARROWS);
            GuiComponent.m_93133_((PoseStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)0.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        } else if (hDif > 3.0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ARROWS);
            GuiComponent.m_93133_((PoseStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)7.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (distance > 0) {
            mat.m_85836_();
            mat.m_85837_((double)NumsUtils.getWidth(distance + "m") / 2.0, 5.0, 0.0);
            int width = 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.NUMS);
            TextureCoords c = NumsUtils.nums[10];
            GuiComponent.m_93133_((PoseStack)mat, (int)(-c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
            width += c.width - 1;
            while (distance > 0) {
                c = NumsUtils.nums[distance % 10];
                GuiComponent.m_93133_((PoseStack)mat, (int)(-width - c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
                distance /= 10;
                width += c.width - 1;
            }
            mat.m_85849_();
        }
        mat.m_85849_();
    }

    private void drawVanilla(PoseStack mat, TextureCoords tex, double angle, float scale) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.MOBHEADS);
        mat.m_85836_();
        mat.m_85837_(this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), 0.0);
        mat.m_85841_(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - Mth.m_14036_((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69478_();
        GuiComponent.m_93133_((PoseStack)mat, (int)(-tex.width / 2), (int)(-tex.height / 2), (float)tex.xOffset, (float)tex.yOffset, (int)tex.width, (int)tex.height, (int)256, (int)256);
    }

    private void drawMod(PoseStack mat, TextureRes tex, double angle, float scale) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)tex.res);
        mat.m_85836_();
        mat.m_85837_(this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), 0.0);
        mat.m_85841_(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - Mth.m_14036_((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69478_();
        GuiComponent.m_93133_((PoseStack)mat, (int)(-tex.width / 2), (int)(-tex.height / 2), (float)tex.xOffset, (float)tex.yOffset, (int)tex.width, (int)tex.height, (int)tex.width, (int)tex.height);
    }

    private void drawPlayerHead(PoseStack mat, double angle, float scale, int distance, double hDif, ResourceLocation icon, TextureCoords tex) {
        if (Math.abs(angle) > (double)this.settings.angleThreshold) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        mat.m_85836_();
        mat.m_85837_(this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), 0.0);
        mat.m_85841_(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - Mth.m_14036_((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.MOBHEADS);
        GuiComponent.m_93133_((PoseStack)mat, (int)(-tex.width / 2), (int)(-tex.height / 2), (float)tex.xOffset, (float)tex.yOffset, (int)tex.width, (int)tex.height, (int)256, (int)256);
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        GuiComponent.m_93160_((PoseStack)mat, (int)-6, (int)-6, (int)12, (int)12, (float)12.0f, (float)12.0f, (int)12, (int)12, (int)96, (int)96);
        GuiComponent.m_93160_((PoseStack)mat, (int)-6, (int)-6, (int)12, (int)12, (float)60.0f, (float)12.0f, (int)12, (int)12, (int)96, (int)96);
        if (hDif < -3.0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ARROWS);
            GuiComponent.m_93133_((PoseStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)0.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        } else if (hDif > 3.0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ARROWS);
            GuiComponent.m_93133_((PoseStack)mat, (int)(tex.width / 2 - 5), (int)0, (float)7.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (distance > 0) {
            mat.m_85836_();
            mat.m_85837_((double)NumsUtils.getWidth(distance + "m") / 2.0, 5.0, 0.0);
            int width = 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.NUMS);
            TextureCoords c = NumsUtils.nums[10];
            GuiComponent.m_93133_((PoseStack)mat, (int)(-c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
            width += c.width - 1;
            while (distance > 0) {
                c = NumsUtils.nums[distance % 10];
                GuiComponent.m_93133_((PoseStack)mat, (int)(-width - c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
                distance /= 10;
                width += c.width - 1;
            }
            mat.m_85849_();
        }
        mat.m_85849_();
    }
}

