/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import dlovin.advancedcompass.utils.SettingsValues;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class IRenderer {
    protected Minecraft mc;
    protected Font fontRenderer;
    protected SettingsValues settings;
    protected float iconScale;
    protected final ResourceLocation CARDINAL_P = new ResourceLocation("advancedcompass", "textures/gui/cardinal_point.png");
    protected final ResourceLocation MOBHEADS = new ResourceLocation("advancedcompass", "textures/mobs.png");
    protected final ResourceLocation NUMS = new ResourceLocation("advancedcompass", "textures/gui/nums.png");
    protected final ResourceLocation ARROWS = new ResourceLocation("advancedcompass", "textures/gui/arrows.png");
    protected final ResourceLocation WAYPOINTS = new ResourceLocation("advancedcompass", "textures/waypoints.png");

    public IRenderer(Minecraft mc, Font fontRenderer, SettingsValues settings) {
        this.mc = mc;
        this.fontRenderer = fontRenderer;
        this.settings = settings;
        this.iconScale = (float)settings.iconScale / 100.0f;
    }

    public void setIconScale(int scale) {
        this.iconScale = (float)this.settings.iconScale / 100.0f;
    }

    protected double getFlatDistance(Vec3 pos1, Vec3 pos2) {
        float f = (float)(pos1.f_82479_ - pos2.f_82479_);
        float f2 = (float)(pos1.f_82481_ - pos2.f_82481_);
        return Math.sqrt(f * f + f2 * f2);
    }

    protected float getAngle(Vec3 en) {
        return (float)Math.toDegrees(Math.atan2(en.f_82481_ - this.mc.f_91074_.m_20189_(), en.f_82479_ - this.mc.f_91074_.m_20185_()));
    }

    protected float ToFormat(float angle) {
        float f = (angle + 180.0f) % 360.0f;
        if (f < -180.0f) {
            f = (float)((double)f + 360.0);
        } else if (f >= 180.0f) {
            f = (float)((double)f - 360.0);
        }
        return f;
    }

    protected double getX(double angle, float scale) {
        int halfWidth = this.settings.compassWidth / 2;
        return Mth.m_14008_((double)(angle / (double)this.settings.getViewAngle() * (double)halfWidth * (double)scale), (double)((float)(-halfWidth) * scale), (double)((float)halfWidth * scale));
    }
}

