/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class GLTools {
    private static final Tesselator tessellator = Tesselator.m_85913_();
    private static final BufferBuilder bufferBuilder = tessellator.m_85915_();
    public static int frameBufferID = 0;
    public static int renderBufferID = 0;
    public static int textureID = 0;
    private static int prevFrameBufferID = 0;
    private static int prevFrameBufferIDr = 0;
    private static int prevFrameBufferIDd = 0;

    public static void setupFrameBuffer() {
        prevFrameBufferID = GL11.glGetInteger((int)36006);
        frameBufferID = GL30.glGenFramebuffers();
        textureID = GL11.glGenTextures();
        int width = 512;
        int height = 512;
        GL30.glBindFramebuffer((int)36160, (int)frameBufferID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(6 * width * height));
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureID, (int)0);
        renderBufferID = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)renderBufferID);
        GL30.glRenderbufferStorage((int)36161, (int)33190, (int)width, (int)height);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)renderBufferID);
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GLTools.checkFramebufferStatus();
        GL30.glBindFramebuffer((int)36160, (int)prevFrameBufferID);
        GlStateManager.m_84544_((int)0);
    }

    public static void checkFramebufferStatus() {
        int i = GL30.glCheckFramebufferStatus((int)36160);
        if (i != 36053) {
            if (i == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    public static void bindFrameBuffer() {
        prevFrameBufferID = GL11.glGetInteger((int)36006);
        prevFrameBufferIDr = GL11.glGetInteger((int)36010);
        prevFrameBufferIDd = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)frameBufferID);
        GL30.glBindFramebuffer((int)36008, (int)frameBufferID);
        GL30.glBindFramebuffer((int)36009, (int)frameBufferID);
    }

    public static void unbindFrameBuffer() {
        GL30.glBindFramebuffer((int)36160, (int)prevFrameBufferID);
        GL30.glBindFramebuffer((int)36008, (int)prevFrameBufferIDr);
        GL30.glBindFramebuffer((int)36009, (int)prevFrameBufferIDd);
    }

    public static void drawPre() {
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
    }

    public static void drawPost() {
        tessellator.m_85914_();
    }

    public static void verTex(double x, double y, double z, float u, float v) {
        bufferBuilder.m_5483_(x, y, z).m_7421_(u, v).m_5752_();
    }
}

