/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import dlovin.advancedcompass.utils.Group;
import dlovin.advancedcompass.utils.GroupEntity;
import dlovin.advancedcompass.utils.GroupPlayers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GroupUtils {
    private static Minecraft mc = Minecraft.m_91087_();
    public static List<EntityType> types;

    private static boolean hasLineOfSight(Entity en, Vec3 vec3, boolean hideBehind, int maxDistance) {
        Vec3 vec31 = new Vec3(en.m_20185_(), en.m_20188_(), en.m_20189_());
        if (vec31.m_82554_(vec3) > (double)maxDistance) {
            return false;
        }
        if (hideBehind) {
            return GroupUtils.mc.f_91073_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)GroupUtils.mc.f_91074_)).m_6662_() == HitResult.Type.MISS;
        }
        return true;
    }

    public static Collection<Group> getGroups(int maxDistance, int inGroupDistance, boolean showPlayers, boolean hideBehind) {
        ArrayList<Group> groups = new ArrayList<Group>();
        Vec3 vec3 = new Vec3(GroupUtils.mc.f_91074_.m_20185_(), GroupUtils.mc.f_91074_.m_20188_(), GroupUtils.mc.f_91074_.m_20189_());
        for (Entity en : GroupUtils.mc.f_91073_.m_104735_()) {
            boolean added;
            if (en.m_20177_((Player)GroupUtils.mc.f_91074_)) continue;
            if (en instanceof Mob) {
                if (!types.contains(en.m_6095_()) || !GroupUtils.hasLineOfSight(en, vec3, hideBehind, maxDistance)) continue;
                added = false;
                for (Group gEn : groups) {
                    if (!gEn.getType().equals(en.m_6095_()) || !(gEn.distanceTo(en) <= (float)inGroupDistance)) continue;
                    gEn.addEntity(en);
                    added = true;
                    break;
                }
                if (added) continue;
                groups.add(new GroupEntity(en));
                continue;
            }
            if (!(en instanceof Player) || en.equals((Object)GroupUtils.mc.f_91074_)) continue;
            if (GroupUtils.mc.f_91074_.f_108617_.m_104949_(en.m_142081_()) == null) {
                if (!types.contains(en.m_6095_()) || !GroupUtils.hasLineOfSight(en, vec3, hideBehind, maxDistance)) continue;
                added = false;
                for (Group gEn : groups) {
                    if (!gEn.getType().equals(en.m_142081_()) || !(gEn.distanceTo(en) <= (float)inGroupDistance)) continue;
                    gEn.addEntity(en);
                    added = true;
                    break;
                }
                if (added) continue;
                groups.add(new GroupPlayers(en));
                continue;
            }
            if (!showPlayers || !GroupUtils.hasLineOfSight(en, vec3, hideBehind, maxDistance)) continue;
            added = false;
            for (Group gEn : groups) {
                if (!gEn.getType().equals(en.m_142081_()) || !(gEn.distanceTo(en) <= (float)inGroupDistance)) continue;
                gEn.addEntity(en);
                added = true;
                break;
            }
            if (added) continue;
            groups.add(new GroupPlayers(en));
        }
        return groups;
    }

    public static Collection<Group> getSortedGroups(int maxDistance, int inGroupDistance, boolean showPlayers, boolean hideBehind) {
        return GroupUtils.getGroups(maxDistance, inGroupDistance, showPlayers, hideBehind).stream().sorted(Comparator.comparing(w -> Float.valueOf(w.distanceTo((Entity)GroupUtils.mc.f_91074_)))).collect(Collectors.toList());
    }

    public static Collection<Group> getSortedReversedGroups(int maxDistance, int inGroupDistance, boolean showPlayers, boolean hideBehind) {
        return GroupUtils.getGroups(maxDistance, inGroupDistance, showPlayers, hideBehind).stream().sorted(Comparator.comparing(w -> Float.valueOf(((Group)w).distanceTo((Entity)GroupUtils.mc.f_91074_))).reversed()).collect(Collectors.toList());
    }
}

