/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadPack;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.TextureRes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class HeadUtils {
    public static HashMap<EntityType, TextureCoords> heads;
    private static List<HeadPack> ipack;

    public static void addHead(EntityType type, int width, int height, ResourceLocation resourceLocation) {
        if (ipack.stream().noneMatch(w -> w.m_8017_().equals(resourceLocation.m_135827_()))) {
            HeadPack pack = new HeadPack(type.getRegistryName().m_135827_());
            ipack.add(pack);
            Minecraft.m_91087_().m_91099_().addPackFinder((c, f) -> {
                Pack packInfo = new Pack(pack.m_8017_(), true, () -> pack, (Component)new TextComponent("AC"), (Component)new TextComponent("AC"), PackCompatibility.COMPATIBLE, Pack.Position.BOTTOM, true, PackSource.f_10528_, true);
                c.accept(packInfo);
            });
        }
        for (HeadPack pack : ipack) {
            if (!Minecraft.m_91087_().m_91098_().m_7536_().noneMatch(w -> w.m_8017_().equals(pack.m_8017_()))) continue;
            AdvancedCompass.logger.info("IResourcePack " + pack.m_8017_() + " has been added");
            ((SimpleReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_10880_((PackResources)pack);
        }
        heads.put(type, new TextureRes(0, 0, width, height, resourceLocation));
    }

    public static void loadModHeads() {
        File file = new File(FMLPaths.CONFIGDIR.get() + "/AdvancedCompass/mobs/");
        String[] directories = file.list((current, name) -> new File(current, name).isDirectory());
        for (String directory : directories) {
            AdvancedCompass.logger.info("scanning directory: " + directory);
            if (!ModList.get().isLoaded(directory)) {
                AdvancedCompass.logger.info(directory + " mod doesn't exists");
                continue;
            }
            File tmp = new File(file.getAbsolutePath() + "/" + directory + "/mobs.json");
            if (!tmp.exists()) continue;
            HeadPack tmpPack = new HeadPack(directory);
            try {
                FileReader reader = new FileReader(tmp);
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse((Reader)reader);
                for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                    File iconFile = new File(file.getAbsolutePath() + "/" + directory + "/" + (String)entry.getKey() + ".png");
                    if (!iconFile.exists()) {
                        AdvancedCompass.logger.info("Missed icon for mob: " + (String)entry.getKey());
                        continue;
                    }
                    ResourceLocation loc = new ResourceLocation("advancedcompass." + directory, (String)entry.getKey());
                    heads.put((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(directory, (String)entry.getKey())), new TextureRes(0, 0, ((JsonElement)entry.getValue()).getAsJsonObject().get("width").getAsInt(), ((JsonElement)entry.getValue()).getAsJsonObject().get("height").getAsInt(), loc));
                    AdvancedCompass.logger.info("Mob: " + loc + " added");
                    if (!((JsonElement)entry.getValue()).getAsJsonObject().get("show").getAsBoolean()) continue;
                    GroupUtils.types.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(directory, (String)entry.getKey())));
                }
                ipack.add(tmpPack);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (HeadPack pack : ipack) {
            Minecraft.m_91087_().m_91099_().addPackFinder((infoConsumer, infoFactory) -> {
                Pack packInfo = new Pack(pack.m_8017_(), true, () -> pack, (Component)new TextComponent("AC"), (Component)new TextComponent("AC"), PackCompatibility.COMPATIBLE, Pack.Position.BOTTOM, true, PackSource.f_10528_, true);
                infoConsumer.accept(packInfo);
            });
        }
    }

    public static void AddResourcePacks() {
        for (HeadPack pack : ipack) {
            if (!Minecraft.m_91087_().m_91098_().m_7536_().noneMatch(p -> p.m_8017_().equals(pack.m_8017_()))) continue;
            ((SimpleReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_10880_((PackResources)pack);
            AdvancedCompass.logger.info("IResourcePack " + pack.m_8017_() + " has been added");
        }
    }

    public static EntityType getType(String name) {
        for (Map.Entry<EntityType, TextureCoords> en : heads.entrySet()) {
            if (!en.getKey().m_20675_().equals(name)) continue;
            return en.getKey();
        }
        return null;
    }

    static {
        ipack = new ArrayList<HeadPack>();
        heads = new HashMap();
        heads.put(EntityType.f_20501_, new TextureCoords(0, 0, 16, 16));
        heads.put(EntityType.f_20530_, new TextureCoords(16, 0, 16, 19));
        heads.put(EntityType.f_20524_, new TextureCoords(32, 0, 16, 16));
        heads.put(EntityType.f_20531_, new TextureCoords(48, 0, 20, 16));
        heads.put(EntityType.f_20500_, new TextureCoords(68, 0, 18, 20));
        heads.put(EntityType.f_20499_, new TextureCoords(86, 0, 14, 17));
        heads.put(EntityType.f_20497_, new TextureCoords(100, 0, 16, 16));
        heads.put(EntityType.f_20496_, new TextureCoords(116, 0, 32, 17));
        heads.put(EntityType.f_20495_, new TextureCoords(148, 0, 20, 25));
        heads.put(EntityType.f_20517_, new TextureCoords(168, 0, 14, 19));
        heads.put(EntityType.f_20494_, new TextureCoords(182, 0, 16, 17));
        heads.put(EntityType.f_20493_, new TextureCoords(198, 0, 16, 19));
        heads.put(EntityType.f_20492_, new TextureCoords(214, 0, 16, 19));
        heads.put(EntityType.f_20491_, new TextureCoords(230, 0, 16, 16));
        heads.put(EntityType.f_20489_, new TextureCoords(0, 25, 13, 8));
        heads.put(EntityType.f_20482_, new TextureCoords(13, 25, 18, 16));
        heads.put(EntityType.f_20481_, new TextureCoords(31, 25, 18, 17));
        heads.put(EntityType.f_20480_, new TextureCoords(49, 25, 16, 18));
        heads.put(EntityType.f_20479_, new TextureCoords(65, 25, 18, 16));
        heads.put(EntityType.f_20528_, new TextureCoords(83, 25, 16, 16));
        heads.put(EntityType.f_20452_, new TextureCoords(99, 25, 16, 16));
        heads.put(EntityType.f_20526_, new TextureCoords(115, 25, 16, 16));
        heads.put(EntityType.f_20523_, new TextureCoords(131, 25, 20, 16));
        heads.put(EntityType.f_20521_, new TextureCoords(151, 25, 18, 16));
        heads.put(EntityType.f_20520_, new TextureCoords(169, 25, 16, 16));
        heads.put(EntityType.f_20519_, new TextureCoords(185, 25, 20, 13));
        heads.put(EntityType.f_20504_, new TextureCoords(205, 25, 16, 16));
        heads.put(EntityType.f_20518_, new TextureCoords(221, 25, 18, 20));
        heads.put(EntityType.f_20516_, new TextureCoords(0, 45, 16, 16));
        heads.put(EntityType.f_20514_, new TextureCoords(16, 45, 18, 17));
        heads.put(EntityType.f_20513_, new TextureCoords(34, 45, 16, 19));
        heads.put(EntityType.f_20568_, new TextureCoords(34, 45, 16, 19));
        heads.put(EntityType.f_20511_, new TextureCoords(50, 45, 20, 16));
        heads.put(EntityType.f_20512_, new TextureCoords(50, 45, 20, 16));
        heads.put(EntityType.f_20510_, new TextureCoords(70, 45, 16, 16));
        heads.put(EntityType.f_20509_, new TextureCoords(86, 45, 18, 10));
        heads.put(EntityType.f_20508_, new TextureCoords(104, 45, 9, 16));
        heads.put(EntityType.f_20507_, new TextureCoords(113, 45, 22, 17));
        heads.put(EntityType.f_20505_, new TextureCoords(135, 45, 14, 14));
        heads.put(EntityType.f_20503_, new TextureCoords(149, 45, 18, 18));
        heads.put(EntityType.f_20468_, new TextureCoords(167, 45, 16, 16));
        heads.put(EntityType.f_20460_, new TextureCoords(183, 45, 16, 19));
        heads.put(EntityType.f_20459_, new TextureCoords(199, 45, 16, 19));
        heads.put(EntityType.f_20458_, new TextureCoords(215, 45, 16, 16));
        heads.put(EntityType.f_20502_, new TextureCoords(231, 45, 18, 18));
        heads.put(EntityType.f_20525_, new TextureCoords(0, 64, 18, 18));
        heads.put(EntityType.f_20457_, new TextureCoords(18, 64, 18, 18));
        heads.put(EntityType.f_20456_, new TextureCoords(36, 64, 18, 20));
        heads.put(EntityType.f_20563_, new TextureCoords(54, 64, 20, 20));
        heads.put(EntityType.f_20455_, new TextureCoords(74, 64, 20, 20));
        heads.put(EntityType.f_20453_, new TextureCoords(94, 64, 16, 16));
        heads.put(EntityType.f_20567_, new TextureCoords(110, 64, 14, 10));
        heads.put(EntityType.f_20566_, new TextureCoords(124, 64, 18, 16));
        heads.put(EntityType.f_20562_, new TextureCoords(142, 64, 16, 16));
        heads.put(EntityType.f_20560_, new TextureCoords(158, 64, 18, 18));
        heads.put(EntityType.f_20565_, new TextureCoords(176, 64, 36, 18));
        heads.put(EntityType.f_20559_, new TextureCoords(212, 64, 18, 16));
        heads.put(EntityType.f_20558_, new TextureCoords(230, 64, 16, 16));
        heads.put(EntityType.f_20466_, new TextureCoords(0, 84, 16, 19));
        heads.put(EntityType.f_20488_, new TextureCoords(0, 84, 16, 19));
        heads.put(EntityType.f_20557_, new TextureCoords(16, 84, 16, 16));
        heads.put(EntityType.f_20556_, new TextureCoords(32, 84, 19, 11));
        heads.put(EntityType.f_20555_, new TextureCoords(51, 84, 12, 16));
        heads.put(EntityType.f_20554_, new TextureCoords(63, 84, 18, 16));
        heads.put(EntityType.f_20551_, new TextureCoords(81, 84, 16, 16));
        heads.put(EntityType.f_20490_, new TextureCoords(97, 84, 19, 11));
        heads.put(EntityType.f_20550_, new TextureCoords(116, 84, 16, 16));
        heads.put(EntityType.f_20549_, new TextureCoords(132, 84, 12, 12));
        heads.put(EntityType.f_20553_, new TextureCoords(144, 84, 14, 14));
        heads.put(EntityType.f_20532_, new TextureCoords(158, 84, 16, 16));
        heads.put(EntityType.f_147039_, new TextureCoords(190, 84, 18, 14));
        heads.put(EntityType.f_147035_, new TextureCoords(208, 84, 17, 19));
        heads.put(EntityType.f_147034_, new TextureCoords(225, 84, 16, 18));
    }
}

