/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.api.temperature;

import com.google.common.base.Preconditions;
import toughasnails.api.temperature.ITemperatureModifier;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureHelper;

public interface IModifierMonitor {
    public void addEntry(Context var1);

    public void setTargetTemperature(Temperature var1);

    public static class Context {
        public final String modifierId;
        public final String description;
        public final Temperature startTemperature;
        public final Temperature endTemperature;

        public Context(String modifierId, String description, Temperature startTemperature, Temperature endTemperature) {
            Preconditions.checkArgument((TemperatureHelper.getTemperatureModifiers().containsKey((Object)modifierId) || modifierId.equals("equilibrium") || modifierId.equals("climatisation") ? 1 : 0) != 0, (Object)("Modifier id " + modifierId + " does not exist!"));
            this.modifierId = modifierId;
            this.description = description;
            this.startTemperature = startTemperature;
            this.endTemperature = endTemperature;
        }

        public ITemperatureModifier getModifier() {
            return (ITemperatureModifier)TemperatureHelper.getTemperatureModifiers().get((Object)this.modifierId);
        }
    }
}

