/*
 * Decompiled with CFR 0.152.
 */
package ml.northwestwind.moreboots.events;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import ml.northwestwind.moreboots.events.annotations.Cancellable;

public class Event {
    private boolean cancelled;
    private Result result = Result.DEFAULT;

    public void setCancelled(boolean cancelled) {
        if (!this.getClass().isAnnotationPresent(Cancellable.class)) {
            throw new UnsupportedOperationException("Attempting to call Event#setCancelled in non-cancellable events");
        }
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setResult(Result result) {
        if (!this.getClass().isAnnotationPresent(HasResult.class)) {
            throw new UnsupportedOperationException("Attempting to call Event#setResult in events without result");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

