/*
 * Decompiled with CFR 0.152.
 */
package ml.northwestwind.moreboots.mixins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import ml.northwestwind.moreboots.events.LivingDropsEvent;
import ml.northwestwind.moreboots.events.LivingEquipmentChangeEvent;
import ml.northwestwind.moreboots.events.LivingEvent;
import ml.northwestwind.moreboots.events.LivingFallEvent;
import ml.northwestwind.moreboots.events.LivingHurtEvent;
import ml.northwestwind.moreboots.handler.MoreBootsHandler;
import ml.northwestwind.moreboots.init.ItemInit;
import ml.northwestwind.moreboots.mixins.MixinEntity;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1309.class})
public abstract class MixinLivingEntity
extends MixinEntity {
    @Shadow
    protected int field_6238;

    @Shadow
    protected abstract int method_23329(float var1, float var2);

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;computeFallDamage(FF)I"), method={"handleFallDamage"})
    public int computeFallDamage(class_1309 entity, float fallDistance, float damageMultiplier) {
        LivingFallEvent event = new LivingFallEvent((class_1309)this, fallDistance, damageMultiplier);
        MoreBootsHandler.onLivingFall(event);
        if (event.isCancelled()) {
            return 0;
        }
        return this.method_23329(event.getDistance(), event.getMultiplier());
    }

    @Inject(at={@At(value="RETURN")}, method={"jump"})
    public void jump(CallbackInfo ci) {
        MoreBootsHandler.onLivingJump(new LivingEvent.LivingJumpEvent((class_1309)this));
    }

    @ModifyArgs(at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"), method={"damage"})
    public void applyDamage(Args args) {
        class_1282 source = (class_1282)args.get(0);
        float amount = ((Float)args.get(1)).floatValue();
        LivingHurtEvent event = new LivingHurtEvent((class_1309)this, source, amount);
        MoreBootsHandler.onLivingHurt(event);
        args.set(1, (Object)Float.valueOf(event.isCancelled() ? 0.0f : event.getAmount()));
    }

    @Inject(method={"getEquipment"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;areEqual(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void getEquipment(CallbackInfoReturnable<Map<class_1304, class_1799>> cir, Map<class_1304, class_1799> map, class_1304[] var2, int var3, int var4, class_1304 equipmentSlot, class_1799 itemStack3, class_1799 itemStack4) {
        MoreBootsHandler.onLivingEquipmentChange(new LivingEquipmentChangeEvent((class_1309)this, equipmentSlot, itemStack3, itemStack4));
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    public void tick(CallbackInfo ci) {
        LivingEvent.LivingUpdateEvent event = new LivingEvent.LivingUpdateEvent((class_1309)this);
        MoreBootsHandler.onLivingUpdate(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"drop"})
    public void drop(class_1282 source, CallbackInfo ci) {
        class_1297 killer = source.method_5529();
        int looting = 0;
        if (killer instanceof class_1309) {
            looting = class_1890.method_8226((class_1309)((class_1309)killer));
        }
        ArrayList items = Lists.newArrayList();
        LivingDropsEvent event = new LivingDropsEvent((class_1309)this, source, items, looting, this.field_6238 > 0);
        MoreBootsHandler.onLivingDrop(event);
        items.forEach(item -> this.field_6002.method_8649((class_1297)item));
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;getSlipperiness()F"))
    public float getSlipperiness(class_2248 block) {
        class_1309 entity = (class_1309)this;
        return entity.method_6118(class_1304.field_6166).method_7909().equals(ItemInit.SLIPPERY_BOOTS) ? 1.1f : block.method_9499();
    }
}

