/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block.tileentity;

import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.container.MailboxContainer;
import io.github.wouink.furnish.item.Letter;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MailboxTileEntity
extends RandomizableContainerBlockEntity {
    public static final int SIZE = 18;
    private static final TagKey MAIL_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("furnish", "mail"));
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private String owner;
    private String ownerDisplayName;

    public MailboxTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FurnishData.TileEntities.TE_Mailbox.get(), pos, state);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> newInventory) {
        this.inventory = newInventory;
    }

    protected Component m_6820_() {
        return new TranslatableComponent(String.format("block.%s.%s", "furnish", this.m_58900_().m_60734_().getRegistryName().m_135815_()));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128359_("Owner", this.owner == null ? "" : this.owner);
        nbt.m_128359_("OwnerDisplayName", this.ownerDisplayName == null ? "" : this.ownerDisplayName);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.owner = nbt.m_128461_("Owner");
        this.ownerDisplayName = nbt.m_128461_("OwnerDisplayName");
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new MailboxContainer(syncId, playerInventory, (Container)this);
    }

    public int m_6643_() {
        return 18;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return false;
    }

    public void updateDisplayName(Player playerEntity) {
        if (this.isOwner(playerEntity)) {
            String playerName = playerEntity.m_36316_().getName();
            if (this.ownerDisplayName == null || !this.ownerDisplayName.equals(playerName)) {
                this.ownerDisplayName = playerName;
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void setOwner(Player playerEntity) {
        this.owner = playerEntity.m_20149_();
        this.updateDisplayName(playerEntity);
    }

    public UUID getOwner() {
        return UUID.fromString(this.owner);
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public boolean isOwner(Player playerEntity) {
        return this.hasOwner() && playerEntity.m_20149_().equals(this.owner);
    }

    public boolean hasMail() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return !this.inventory.contains((Object)ItemStack.f_41583_);
    }

    public ItemStack addMail(ItemStack stack) {
        int slot;
        if (((Boolean)Furnish.CONFIG.restrictMailboxItems.get()).booleanValue() && !stack.m_204117_(MAIL_TAG)) {
            return stack;
        }
        if (stack.m_41720_() instanceof Letter) {
            Letter.signLetter(stack, "Anonymous Player");
        }
        if ((slot = this.getFreeSlot()) < this.m_6643_()) {
            Player mailboxOwner;
            ItemStack result = (ItemStack)this.inventory.set(slot, (Object)stack);
            if (result.m_41619_() && (mailboxOwner = this.f_58857_.m_46003_(this.getOwner())) != null) {
                if (this.m_8077_()) {
                    mailboxOwner.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.new_mail_loc", new Object[]{this.m_7770_()}), true);
                } else {
                    mailboxOwner.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.new_mail"), true);
                }
            }
            return result;
        }
        return stack;
    }

    public Component getOwnerDisplayName() {
        return !this.hasOwner() || this.ownerDisplayName.isEmpty() ? null : new TextComponent(this.ownerDisplayName);
    }

    private int getFreeSlot() {
        int slot;
        for (slot = 0; slot < this.inventory.size() && !((ItemStack)this.inventory.get(slot)).m_41619_(); ++slot) {
        }
        return slot;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

